/*
 * Decompiled with CFR 0.152.
 */
package rivoreo.minecraft.aggressivechickens;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierManager;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import rivoreo.minecraft.aggressivechickens.AngryWhenBeingStaredByPlayerGoal;

@Mod(value="aggressive-chickens")
public class ForgeMod {
    public static final String MODID = "aggressive-chickens";
    public static final String VERSION = "1.7";
    private ForgeConfigSpec.BooleanValue hurted_chicken_call_for_help;
    private ForgeConfigSpec.DoubleValue call_help_max_distance;
    private ForgeConfigSpec.IntValue attack_damage;
    private ForgeConfigSpec.BooleanValue revenge_for_killed_chicken;
    private ForgeConfigSpec.DoubleValue revenge_for_killed_chicken_horizontal_distance;
    private ForgeConfigSpec.DoubleValue revenge_for_killed_chicken_vertical_distance;
    private ForgeConfigSpec.BooleanValue angry_when_being_stared_by_player;
    private ForgeConfigSpec.DoubleValue angry_when_being_stared_by_player_max_distance;
    private ForgeConfigSpec.DoubleValue attack_moving_speed;
    private Field goal_selector_goals_field;

    public ForgeMod() {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        this.init_config();
    }

    private void init_config() {
        ForgeConfigSpec.Builder config_builder = new ForgeConfigSpec.Builder();
        config_builder.comment("Being attacked chicken call nearby chickens for help");
        this.hurted_chicken_call_for_help = config_builder.define("HurtedChickenCallForHelp", true);
        config_builder.comment("Maximum horizontal distance for a chicken to help a being attacked chicken [Set to NaN to keep Minecraft default FOLLOW_RANGE attribute, this is default]");
        this.call_help_max_distance = config_builder.defineInRange("CallHelpMaxDistance", Double.NaN, 1.0, 2048.0);
        config_builder.comment("Chicken's attack damage");
        this.attack_damage = config_builder.defineInRange("AttackDamage", 2, 1, 20);
        config_builder.comment("Chicken's moving speed towards to target when attacking");
        this.attack_moving_speed = config_builder.defineInRange("AttackMovingSpeed", 0.9, 0.25, 2.0);
        config_builder.comment("Nearby chickens will start retaliation if they witnessed another chicken being killed by someone");
        this.revenge_for_killed_chicken = config_builder.define("RevengeForKilledChicken", true);
        config_builder.comment("Provoke chickens in this horizontal radius range to revenge for killed chicken, if RevengeForKilledChicken is enabled");
        this.revenge_for_killed_chicken_horizontal_distance = config_builder.defineInRange("RevengeForKilledChickenHorizontalDistance", 16.0, 1.0, 128.0);
        config_builder.comment("Provoke chickens in this vertical radius range to revenge for killed chicken, if RevengeForKilledChicken is enabled");
        this.revenge_for_killed_chicken_vertical_distance = config_builder.defineInRange("RevengeForKilledChickenVerticalDistance", 12.0, 1.0, 128.0);
        config_builder.comment("Chicken will get angry when being stared by nearest player");
        this.angry_when_being_stared_by_player = config_builder.define("AngryWhenBeingStaredByPlayer", false);
        config_builder.comment("Maximum distance for provoking the chicken when a player staring on it");
        this.angry_when_being_stared_by_player_max_distance = config_builder.defineInRange("AngryWhenBeingStaredByPlayerMaxDistance", 16.0, 1.0, 64.0);
        ModLoadingContext ml_context = ModLoadingContext.get();
        ml_context.registerConfig(ModConfig.Type.COMMON, config_builder.build());
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent event) throws NoSuchFieldException {
        this.goal_selector_goals_field = GoalSelector.class.getDeclaredField("field_220892_d");
        this.goal_selector_goals_field.setAccessible(true);
        MinecraftForge.EVENT_BUS.register((Object)new ForgeEventsListener());
    }

    @SubscribeEvent
    public void on_entity_attributes_modification(EntityAttributeModificationEvent event) {
        event.add(EntityType.field_200795_i, Attributes.field_233823_f_, ((Integer)this.attack_damage.get()).doubleValue());
    }

    class ForgeEventsListener {
        ForgeEventsListener() {
        }

        @SubscribeEvent
        public void on_entity_join_world(EntityJoinWorldEvent event) throws IllegalAccessException {
            double call_help_max_distance_value;
            if (!(event.getEntity() instanceof ChickenEntity)) {
                return;
            }
            ChickenEntity chicken = (ChickenEntity)event.getEntity();
            if (chicken.field_70170_p.field_72995_K) {
                return;
            }
            AttributeModifierManager attrib_mod_mgr = chicken.func_233645_dx_();
            if (((Boolean)ForgeMod.this.hurted_chicken_call_for_help.get()).booleanValue() && !Double.isNaN(call_help_max_distance_value = ((Double)ForgeMod.this.call_help_max_distance.get()).doubleValue())) {
                attrib_mod_mgr.func_233779_a_(Attributes.field_233819_b_).func_111128_a(call_help_max_distance_value);
            }
            boolean angry_when_being_stared_by_player_value = (Boolean)ForgeMod.this.angry_when_being_stared_by_player.get();
            ArrayList<Goal> goals_to_remove = new ArrayList<Goal>();
            for (PrioritizedGoal e : (Set)ForgeMod.this.goal_selector_goals_field.get(chicken.field_70714_bg)) {
                Goal goal = e.func_220772_j();
                if (angry_when_being_stared_by_player_value && goal instanceof TemptGoal) {
                    goals_to_remove.add(goal);
                    continue;
                }
                if (!(goal instanceof PanicGoal)) continue;
                goals_to_remove.add(goal);
            }
            for (Goal goal : goals_to_remove) {
                chicken.field_70714_bg.func_85156_a(goal);
            }
            chicken.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)chicken, ((Double)ForgeMod.this.attack_moving_speed.get()).doubleValue(), true));
            HurtByTargetGoal hurt_by_target_goal = new HurtByTargetGoal((CreatureEntity)chicken, new Class[0]);
            if (((Boolean)ForgeMod.this.hurted_chicken_call_for_help.get()).booleanValue()) {
                hurt_by_target_goal.func_220794_a(new Class[0]);
            }
            chicken.field_70715_bh.func_75776_a(1, (Goal)hurt_by_target_goal);
            if (angry_when_being_stared_by_player_value) {
                chicken.field_70714_bg.func_75776_a(3, (Goal)new AngryWhenBeingStaredByPlayerGoal((CreatureEntity)chicken, (Double)ForgeMod.this.angry_when_being_stared_by_player_max_distance.get()));
            }
        }

        @SubscribeEvent
        public void on_living_entity_death(LivingDeathEvent event) {
            Entity killer = event.getSource().func_76346_g();
            if (killer == null) {
                return;
            }
            if (killer.field_70170_p.field_72995_K) {
                return;
            }
            if (killer instanceof ChickenEntity) {
                ((ChickenEntity)killer).func_70624_b(null);
                return;
            }
            if (!((Boolean)ForgeMod.this.revenge_for_killed_chicken.get()).booleanValue()) {
                return;
            }
            if (!(event.getEntity() instanceof ChickenEntity)) {
                return;
            }
            if (!(killer instanceof LivingEntity)) {
                return;
            }
            ChickenEntity died_chicken = (ChickenEntity)event.getEntity();
            double x = died_chicken.func_226277_ct_();
            double y = died_chicken.func_226278_cu_();
            double z = died_chicken.func_226281_cx_();
            double horizontal_distance_value = (Double)ForgeMod.this.revenge_for_killed_chicken_horizontal_distance.get();
            double vertical_distance_value = (Double)ForgeMod.this.revenge_for_killed_chicken_vertical_distance.get();
            List nearby_chickens = died_chicken.field_70170_p.func_217357_a(ChickenEntity.class, new AxisAlignedBB(x, y, z, x + 1.0, y + 1.0, z + 1.0).func_72314_b(horizontal_distance_value, vertical_distance_value, horizontal_distance_value));
            for (ChickenEntity chicken : nearby_chickens) {
                LivingEntity current_attack_target;
                if (chicken == died_chicken || (current_attack_target = chicken.func_70638_az()) != null && current_attack_target.func_70089_S()) continue;
                chicken.func_70624_b((LivingEntity)killer);
            }
        }
    }
}

