local preset_datas, data2profile

U1RegisterAddon("ShadowedUnitFrames", {
    title = "SUF头像增强",
    defaultEnable = 0,
    load = "NORMAL",
    optionsAfterLogin = 1,

    tags = { TAG_INTERFACE, TAG_GOOD, },
    icon = [[Interface\Icons\Spell_Shadow_Rune]],
    desc = "定制型很强的著名头像插件`配置命令 /suf`解锁命令 /suf lock",

    runBeforeLoad = function(info, name)
        info.neverUsedSUF = ShadowedUFDB == nil
    end,

    toggle = function(name, info, enable, justload)
        if justload and enable and info.neverUsedSUF then
            data2profile(preset_datas.SIDE)
        end
    end,

    {
        type = 'button',
        text = '锁定解锁框架',
        callback = function()
            SlashCmdList["SHADOWEDUF"]("lock")
        end,
    },

    {
        type = 'radio',
        var = 'abbr',
        default = 1,
        options = {'万进位', 1, '千进位', 2},
        text = '数值缩写方式',
        callback = function(_, v)
            ShadowUF.originFormatLargeNumber = ShadowUF.originFormatLargeNumber or ShadowUF.FormatLargeNumber
            ShadowUF.chineseFormatLargeNumber = ShadowUF.chineseFormatLargeNumber or function(self, number)
                if number <= 9999 then
                    return n2s(number, nil, true);
                elseif number <= 999999 then
                    return f2s(number/1e4, 1).."万"
                elseif number <= 99999999 then
                    return n2s(number/1e4, nil, true).."万"
                else
                    return f2s(number/1e8, 2).."亿"
                end
            end
            ShadowUF.FormatLargeNumber = v == 2 and ShadowUF.originFormatLargeNumber or ShadowUF.chineseFormatLargeNumber
        end,
    },

    {
        type = 'button',
        text = '配置选项',
        callback = function()
            SlashCmdList["SHADOWEDUF"]("")
        end
    },
    {
        text = '选择预设方案',
        type = 'radio',
        var = 'prestyle',
        default = (GetScreenWidth() <= 1280) and "COMPACT" or "MINI",
        options = {'简洁文字型', 'TEXT', '头像贯通型', 'CENTER', "左右头像型", "SIDE"},
        secure = 1,
        confirm = "注意：当前SUF设置将重置，您是否确定？",
        tip = "说明`有爱预设了几套方案，感谢群友叶心安提供的配置。注意，每次切换方案会把当前方案保存在'有爱备份'方案中，可以恢复，但连续切换就无法恢复了。",
        callback = function(cfg, v, loading)
            if(loading) then return end
            if ShadowUF.db:GetCurrentProfile() == "有爱备份" then
                return U1Message("请不要在SUF界面里选择'有爱备份'方案")
            end
            data2profile(preset_datas[v])
        end
    },
    {
        type = 'button',
        text = '恢复备份方案',
        callback = function()
            if ShadowUF.db:GetCurrentProfile() == "有爱备份" then
                return U1Message("请不要在SUF界面里选择'有爱备份'方案")
            end
            ShadowUF.db:CopyProfile("有爱备份", true)
            ShadowUF:ProfilesChanged()
        end
    },

});

U1RegisterAddon("ShadowedUF_Options", { hide = 1, protected = 1, })

--[[
local suf = ShadowUF; suf.tmp = suf.db; suf.db = { profile = CopyTable(suf.defaults.profile) }
suf:LoadDefaultLayout()
suf.defaults2 = suf.db; suf.db = suf.tmp; suf.tmp = nil
AceRemoveDefaults(suf.db.profile, suf.defaults2.profile)
wowluacopy(suf.db.profile)
AceCopyDefaults(suf.db.profile, suf.defaults2.profile)
--]]

--[[-------------------------------------------------------------------------
	AceDB Utility Functions
---------------------------------------------------------------------------]]
local function copyDefaults(dest, src)
	-- this happens if some value in the SV overwrites our default value with a non-table
	--if type(dest) ~= "table" then return end
	for k, v in pairs(src) do
		if k == "*" or k == "**" then
			if type(v) == "table" then
				-- This is a metatable used for table defaults
				local mt = {
					-- This handles the lookup and creation of new subtables
					__index = function(t,k)
							if k == nil then return nil end
							local tbl = {}
							copyDefaults(tbl, v)
							rawset(t, k, tbl)
							return tbl
						end,
				}
				setmetatable(dest, mt)
				-- handle already existing tables in the SV
				for dk, dv in pairs(dest) do
					if not rawget(src, dk) and type(dv) == "table" then
						copyDefaults(dv, v)
					end
				end
			else
				-- Values are not tables, so this is just a simple return
				local mt = {__index = function(t,k) return k~=nil and v or nil end}
				setmetatable(dest, mt)
			end
		elseif type(v) == "table" then
			if not rawget(dest, k) then rawset(dest, k, {}) end
			if type(dest[k]) == "table" then
				copyDefaults(dest[k], v)
				if src['**'] then
					copyDefaults(dest[k], src['**'])
				end
			end
		else
			if rawget(dest, k) == nil then
				rawset(dest, k, v)
			end
		end
	end
end

local function removeDefaults(db, defaults, blocker)
	-- remove all metatables from the db, so we don't accidentally create new sub-tables through them
	setmetatable(db, nil)
	-- loop through the defaults and remove their content
	for k,v in pairs(defaults) do
		if k == "*" or k == "**" then
			if type(v) == "table" then
				-- Loop through all the actual k,v pairs and remove
				for key, value in pairs(db) do
					if type(value) == "table" then
						-- if the key was not explicitly specified in the defaults table, just strip everything from * and ** tables
						if defaults[key] == nil and (not blocker or blocker[key] == nil) then
							removeDefaults(value, v)
							-- if the table is empty afterwards, remove it
							if next(value) == nil then
								db[key] = nil
							end
						-- if it was specified, only strip ** content, but block values which were set in the key table
						elseif k == "**" then
							removeDefaults(value, v, defaults[key])
						end
					end
				end
			elseif k == "*" then
				-- check for non-table default
				for key, value in pairs(db) do
					if defaults[key] == nil and v == value then
						db[key] = nil
					end
				end
			end
		elseif type(v) == "table" and type(db[k]) == "table" then
			-- if a blocker was set, dive into it, to allow multi-level defaults
			removeDefaults(db[k], v, blocker and blocker[k])
			if next(db[k]) == nil then
				db[k] = nil
			end
		else
			-- check if the current value matches the default, and that its not blocked by another defaults table
			if db[k] == defaults[k] and (not blocker or blocker[k] == nil) then
				db[k] = nil
			end
		end
	end
end
_G.AceRemoveDefaults = removeDefaults
_G.AceCopyDefaults = copyDefaults

function data2profile(data)
    local before = ShadowUF.db:GetCurrentProfile()
    -- 设置或新建方案
    ShadowUF.db:SetProfile("有爱备份")
    -- 将之前的方案复制到此方案中（内部会先reset此方案）
    ShadowUF.db:CopyProfile(before, true)
    -- 设置回之前的方案
    ShadowUF.db:SetProfile(before)
    ShadowUF.db:ResetProfile(false, true)
    local old = ShadowUF.db
    ShadowUF.db = { profile = CopyTable(ShadowUF.defaults.profile) }
    ShadowUF:LoadDefaultLayout()
    local defaults = ShadowUF.db
    ShadowUF.db = old
    data = CopyTable(data)
    AceCopyDefaults(data, defaults.profile)
    -- AceCopyDefaults(data, ShadowUF.db.profile) --此时profile相当于defaults
    for k, v in pairs(data) do
        ShadowUF.db.profile[k] = v
    end
    ShadowUF:ProfilesChanged()
end

preset_datas = {
    TEXT = {
      advanced = true,
      auras = { borderType = "dark", },
      backdrop = {
        backgroundColor = { a = 1, },
        backgroundTexture = "None",
        borderColor = { b = 1, g = 1, r = 1, },
        clip = 2,
        edgeSize = 10,
        inset = 0,
        tileSize = 0,
      },
      bars = {
        backgroundAlpha = 1,
        backgroundColor = { a = 1, b = 0, g = 0, r = 0, },
        spacing = -1.1,
        texture = "Flat",
      },
      font = { extra = "OUTLINE", size = 12, },
      hidden = { arena = false, raid = false, },
      locked = true,
      positions = {
        arenapet = { point = "", relativePoint = "", },
        arenatarget = { point = "", relativePoint = "", },
        arenatargettarget = { point = "", relativePoint = "", },
        battlegroundpet = { point = "", relativePoint = "", },
        battlegroundtarget = { point = "", relativePoint = "", },
        battlegroundtargettarget = { point = "", relativePoint = "", },
        boss = {
          anchorPoint = "",
          bottom = 287.71571877242,
          point = "BOTTOMRIGHT",
          relativePoint = "BOTTOMLEFT",
          top = 435.6268334651,
          x = 1167.3602713225,
          y = 287.71571877242,
        },
        bosstarget = { point = "", relativePoint = "", },
        bosstargettarget = { point = "", relativePoint = "", },
        focus = { anchorPoint = "", anchorTo = "UIParent", point = "CENTER", relativePoint = "CENTER", x = -311.46667420864, y = -170.668013978, },
        focustarget = { anchorPoint = "", anchorTo = "UIParent", point = "CENTER", relativePoint = "CENTER", x = -227.70210564112, y = -56.429903423786, },
        mainassist = { point = "", relativePoint = "", },
        mainassisttarget = { point = "", relativePoint = "", },
        mainassisttargettarget = { point = "", relativePoint = "", x = 0, },
        maintank = { point = "", relativePoint = "", },
        maintanktarget = { point = "", relativePoint = "", },
        maintanktargettarget = { point = "", relativePoint = "", x = 0, },
        party = {
          anchorPoint = "",
          anchorTo = "UIParent",
          bottom = 462.22297126189,
          point = "TOPRIGHT",
          relativePoint = "BOTTOMLEFT",
          top = 614.40079612734,
          x = 283.02283671434,
          y = 614.40079612734,
        },
        partypet = { point = "", relativePoint = "", },
        partytarget = { point = "", relativePoint = "", },
        partytargettarget = { point = "", relativePoint = "", },
        pet = { anchorPoint = "", anchorTo = "UIParent", point = "CENTER", relativePoint = "CENTER", x = -170.66667079926, y = -145.06667017937, },
        pettarget = { point = "", relativePoint = "", },
        player = { anchorPoint = "", point = "CENTER", relativePoint = "CENTER", x = -170.66667079926, y = -170.66667079926, },
        raid = {
          anchorPoint = "",
          bottom = 618.5244073383,
          point = "TOPLEFT",
          relativePoint = "BOTTOMLEFT",
          top = 745.81329930941,
          x = 15.787014813696,
          y = 745.81329930941,
        },
        raidpet = { point = "", relativePoint = "", },
        target = { anchorPoint = "", anchorTo = "UIParent", point = "CENTER", relativePoint = "CENTER", x = 170.66667079926, y = -170.66667079926, },
        targettarget = { anchorPoint = "", anchorTo = "UIParent", point = "CENTER", relativePoint = "CENTER", x = 311.46667420864, y = -170.66667079926, },
        targettargettarget = { anchorPoint = "", anchorTo = "UIParent", point = "CENTER", relativePoint = "CENTER", x = 311.46667420864, y = -196.26667141914, },
      },
      powerColors = {
        ALTERNATE = { g = 0, r = 0.71, },
        BANKEDHOLYPOWER = { b = 0.84, g = 0.61, r = 0.96, },
        BURNINGEMBERS = { b = 0.79, g = 0.51, r = 0.58, },
        DEMONICFURY = { b = 0.79, g = 0.51, r = 0.58, },
        ECLIPSE_MOON = { b = 0.9, g = 0.52, r = 0.3, },
        ECLIPSE_SUN = { b = 0, g = 1, r = 1, },
        FULLBURNINGEMBER = { b = 0.062, g = 0.09, r = 0.88, },
        LIGHTWELL = { b = 0.8, g = 0.8, r = 0.8, },
        POWER_TYPE_FEL_ENERGY = { b = 0, g = 0.98, r = 0.878, },
        SHADOWORBS = { b = 0.79, g = 0.51, r = 0.58, },
      },
      revision = 59,
      tags = {
        ["法力值"] = {
          category = "misc",
          func = "function(unit, unitOwner)\nlocal maxPower = UnitPowerMax(unit)\nlocal power = UnitPower(unit)\nif( UnitIsDeadOrGhost(unit) ) then\nreturn string.format(\"0/%s\", ShadowUF:FormatLargeNumber(maxPower))\nelseif( maxPower <= 0 ) then\nreturn nil\nend\n\nreturn string.format(\"%s/%s\", ShadowUF:FormatLargeNumber(power), ShadowUF:FormatLargeNumber(maxPower))\nend",
        },
      },
      units = {
        arena = {
          auraIndicators = { height = 0.5, },
          auras = { height = 0.5, },
          combatText = { height = 0.5, },
          enabled = false,
          highlight = { height = 0.5, },
          indicators = { height = 0.5, },
          range = { height = 0.5, },
        },
        arenatarget = {
          altPowerBar = { enabled = true, },
        },
        battleground = {
          auraIndicators = { height = 0.5, },
          auras = { height = 0.5, },
          combatText = { height = 0.5, },
          enabled = false,
          highlight = { height = 0.5, },
          indicators = { height = 0.5, },
          range = { height = 0.5, },
        },
        battlegroundtarget = {
          altPowerBar = { enabled = true, },
        },
        boss = {
          altPowerBar = { background = false, height = 0.8, },
          attribAnchorPoint = "RIGHT",
          attribPoint = "BOTTOM",
          auraIndicators = { height = 0.5, },
          auras = {
            buffs = {
              anchorOn = false,
              anchorPoint = "LT",
              enlarge = { REMOVABLE = false, SELF = false, },
              maxRows = 3,
              perRow = 1,
              selfScale = 1,
              show = { consolidated = false, raid = false, },
              size = 25,
              timers = { SELF = true, },
              x = -3,
              y = -6,
            },
            debuffs = {
              anchorOn = false,
              anchorPoint = "RT",
              enlarge = { BOSS = false, REMOVABLE = false, SELF = false, },
              maxRows = 3,
              perRow = 1,
              selfScale = 1,
              show = { misc = false, },
              size = 25,
              x = 3,
              y = -6,
            },
            height = 0.5,
          },
          combatText = { enabled = false, height = 0.5, },
          healthBar = { background = false, height = 10, },
          highlight = { height = 0.5, },
          indicators = {
            class = { size = 20, },
            height = 0.5,
            raidTarget = { anchorPoint = "BC", size = 13, y = 10, },
          },
          offset = 2,
          portrait = { isBar = false, width = 0.3, },
          powerBar = { background = false, height = 0.8, },
          range = { height = 0.5, },
          scale = 1.1,
          text = {
            { width = 10, },
            { anchorPoint = "RC", text = "[dechp]", width = 10, x = -43, },
            { size = -1, text = "", width = 5, y = 1, },
            { anchorPoint = "RC", size = -1, text = "[perpp]", width = 10, x = -23, },
          },
          width = 170,
        },
        bosstarget = {
          altPowerBar = { enabled = true, },
        },
        focus = {
          auraIndicators = { height = 0.5, },
          auras = {
            buffs = {
              anchorOn = false,
              enabled = true,
              enlarge = { REMOVABLE = true, SELF = false, },
              maxRows = 1,
              perRow = 4,
              show = { consolidated = false, misc = false, player = false, raid = false, },
              size = 15,
              x = 1,
              y = -8,
            },
            debuffs = {
              anchorOn = true,
              enabled = true,
              enlarge = { BOSS = true, REMOVABLE = true, SELF = false, },
              maxRows = 1,
              perRow = 4,
              show = { misc = false, },
              size = 22,
            },
            height = 0.5,
          },
          castBar = { autoHide = true, enabled = true, height = 3.5, icon = "LEFT", order = 100, },
          combatText = { enabled = false, height = 0.5, },
          fader = { height = 0.5, inactiveAlpha = 1, },
          healAbsorb = { cap = 1.3, enabled = false, height = 0.5, },
          healthBar = { background = false, height = 10, },
          height = 35,
          highlight = { aggro = false, height = 0.5, mouseover = false, },
          incAbsorb = { enabled = false, height = 0.5, },
          incHeal = { enabled = false, height = 0.5, },
          indicators = {
            height = 0.5,
            leader = { x = 5, y = -10, },
            masterLoot = { enabled = false, },
            petBattle = { anchorPoint = "BL", anchorTo = "$parent", enabled = false, size = 18, x = -6, y = 12, },
            pvp = { enabled = false, },
            questBoss = { size = 18, y = 19, },
            raidTarget = { anchorPoint = "BC", size = 12, y = 8, },
            resurrect = { size = 23, x = 31, y = -2, },
            role = { enabled = false, size = 13, x = 19, y = -9, },
          },
          powerBar = { background = false, height = 0.8, order = 90, },
          range = { height = 0.5, },
          scale = 1.2,
          text = {
            { anchorPoint = "C", text = "[name]", width = 10, x = 0, y = -3, },
            { anchorPoint = "C", size = -1, text = "[perhp]", width = 10, x = 0, y = 14, },
            { size = -1, text = "", y = 1, },
            { size = -1, text = "", y = 1, },
          },
          width = 100,
        },
        focustarget = {
          altPowerBar = { enabled = true, },
          auraIndicators = { height = 0.5, },
          auras = { height = 0.5, },
          enabled = false,
          fader = { height = 0.5, },
          height = 50,
          highlight = { height = 0.5, },
          indicators = { height = 0.5, },
          range = { height = 0.5, },
          scale = 1.25,
          width = 190,
        },
        mainassist = {
          healAbsorb = { cap = 1.3, },
          incAbsorb = { cap = 1.3, },
          indicators = {
            leader = { size = 0, },
            masterLoot = { size = 0, },
            pvp = { size = 0, },
            ready = { size = 0, },
            role = { size = 0, },
            status = { size = 19, },
          },
        },
        mainassisttarget = {
          altPowerBar = { enabled = true, },
        },
        maintank = {
          auraIndicators = { height = 0.5, },
          auras = { height = 0.5, },
          combatText = { height = 0.5, },
          fader = { height = 0.5, },
          healAbsorb = { cap = 1.3, height = 0.5, },
          highlight = { height = 0.5, },
          incAbsorb = { cap = 1.3, height = 0.5, },
          incHeal = { height = 0.5, },
          indicators = {
            height = 0.5,
            leader = { size = 0, },
            masterLoot = { size = 0, },
            pvp = { size = 0, },
            ready = { size = 0, },
            role = { size = 0, },
            status = { size = 19, },
          },
          range = { height = 0.5, },
        },
        maintanktarget = {
          altPowerBar = { enabled = true, },
        },
        party = {
          altPowerBar = { background = false, height = 0.7, },
          attribAnchorPoint = "RIGHT",
          auraIndicators = { height = 0.5, },
          auras = {
            buffs = {
              anchorOn = false,
              anchorPoint = "LT",
              enabled = false,
              maxRows = 3,
              perRow = 1,
              show = { misc = false, raid = false, },
              size = 30,
              y = -10,
            },
            debuffs = {
              anchorOn = false,
              anchorPoint = "LT",
              enlarge = { BOSS = false, REMOVABLE = false, SELF = false, },
              maxRows = 5,
              perRow = 1,
              show = { player = false, relevant = false, },
              size = 25,
              x = -8,
              y = -8,
            },
            height = 0.5,
          },
          columnSpacing = 5,
          combatText = { height = 0.5, },
          fader = { height = 0.5, },
          healAbsorb = { cap = 1.3, enabled = false, height = 0.5, },
          healthBar = { background = false, height = 8.8, order = 0, },
          height = 40,
          hideAnyRaid = true,
          hideSemiRaid = false,
          highlight = { height = 0.5, },
          incAbsorb = { cap = 1.3, enabled = false, height = 0.5, },
          incHeal = { cap = 1.2, enabled = false, height = 0.5, },
          indicators = {
            height = 0.5,
            leader = { size = 13, x = 10, y = -9, },
            lfdRole = { anchorPoint = "LC", x = 8, y = 0, },
            masterLoot = { size = 10, x = 23, y = -7, },
            phase = { size = 20, x = 2, },
            pvp = { enabled = false, },
            raidTarget = { anchorPoint = "BC", size = 15, y = 10, },
            ready = { anchorPoint = "RC", size = 25, x = -10, },
            resurrect = { anchorPoint = "C", size = 25, x = 15, y = 1, },
            role = { enabled = false, y = -7, },
          },
          offset = 18,
          portrait = { enabled = false, fullAfter = 100, fullBefore = 100, height = 6, isBar = false, width = 1, },
          powerBar = { background = false, height = 0.7, invert = false, order = 100, },
          range = { enabled = true, height = 0.5, oorAlpha = 0.6, },
          scale = 1.2,
          showPlayer = false,
          text = {
            { text = "[name][( )afk]", width = 10, x = 8, },
            { anchorPoint = "RC", text = "[perhp]", width = 10, x = -40, },
            { size = -2, text = "[level]", width = 10, x = 5, },
            { size = -2, text = "[perpp]", width = 10, x = -5, },
          },
          width = 155,
        },
        partypet = {
          healAbsorb = { cap = 1.3, },
        },
        partytarget = {
          altPowerBar = { enabled = true, },
          fader = { height = 0.5, },
          highlight = { height = 0.5, },
          indicators = { height = 0.5, },
          range = { height = 0.5, },
        },
        partytargettarget = {
          highlight = { height = 0.5, },
          indicators = { height = 0.5, },
          range = { height = 0.5, },
        },
        pet = {
          altPowerBar = { background = false, enabled = false, },
          auraIndicators = { height = 0.5, },
          auras = { height = 0.5, },
          castBar = { autoHide = true, background = false, enabled = true, height = 0.5, order = 50, },
          combatText = { enabled = false, height = 0.5, },
          fader = { height = 0.5, },
          healAbsorb = { cap = 1.3, enabled = false, height = 0.5, },
          healthBar = { background = false, height = 1, order = 0, },
          height = 12,
          highlight = { height = 0.5, },
          incAbsorb = { enabled = false, height = 0.5, },
          incHeal = { enabled = false, height = 0.5, },
          indicators = {
            height = 0.5,
            raidTarget = { size = 15, },
          },
          portrait = { width = 1, },
          powerBar = { background = false, height = 1, order = 100, },
          range = { height = 0.5, },
          scale = 1.2,
          text = {
            { anchorPoint = "C", size = -1, width = 10, x = 0, y = -2, },
            { anchorPoint = "C", text = "", width = 10, x = 0, },
            { text = "", width = 10, },
            { text = "", width = 10, },
          },
          width = 200,
        },
        pettarget = {
          altPowerBar = { enabled = true, },
          highlight = { height = 0.5, },
          indicators = { height = 0.5, },
          range = { height = 0.5, },
        },
        player = {
          altPowerBar = { enabled = false, invert = false, },
          arcaneCharges = { anchorPoint = "RC", background = false, growth = "RIGHT", height = 1, isBar = false, order = 85, showAlways = false, size = 13, spacing = -5, x = -30, y = 20, },
          auraIndicators = { height = 0.5, },
          auras = {
            buffs = {
              anchorOn = true,
              maxRows = 3,
              perRow = 50,
              show = { misc = false, },
              size = 30,
              temporary = true,
              x = 3,
              y = 80,
            },
            debuffs = {
              anchorOn = false,
              enabled = true,
              enlarge = { BOSS = true, REMOVABLE = true, },
              perRow = 7,
              size = 20,
              y = -9,
            },
            height = 0.5,
          },
          chi = { height = 0.8, },
          combatText = { enabled = false, height = 0.5, },
          comboPoints = { anchorPoint = "TR", growth = "DOWN", height = 1, isBar = false, size = 15, spacing = 5, x = 6, y = 1, },
          druidBar = { background = false, height = 0, order = 0, reverse = false, vertical = false, },
          emptyBar = {
            backgroundColor = { b = 0, g = 0, r = 0, },
            class = false,
          },
          fader = { height = 0.5, inactiveAlpha = 1, },
          healAbsorb = { cap = 1.3, enabled = false, height = 0.5, },
          healthBar = { background = false, colorAggro = true, height = 10, invert = false, order = 0, },
          height = 40,
          highlight = { aggro = false, height = 0.5, mouseover = false, },
          holyPower = { height = 0.8, },
          incAbsorb = { cap = 1.3, enabled = false, height = 0.5, },
          incHeal = { cap = 1.2, enabled = false, height = 0.5, },
          indicators = {
            height = 0.5,
            leader = { x = 3, y = -10, },
            lfdRole = { anchorPoint = "LC", enabled = false, size = 15, x = 10, y = 0, },
            masterLoot = { size = 11, x = 17, y = -8, },
            pvp = { anchorPoint = "RB", enabled = false, size = 40, x = -12, y = -18, },
            raidTarget = { anchorPoint = "BC", size = 15, y = 10, },
            ready = { anchorPoint = "RC", size = 25, x = 0, },
            resurrect = { anchorPoint = "C", size = 25, x = 0, y = 0, },
            role = { size = 12, y = -9, },
            status = { anchorPoint = "BL", size = 23, x = 25, y = 15, },
          },
          portrait = { enabled = false, fullAfter = 100, height = 10, isBar = false, order = 0, width = 0.2, },
          powerBar = { background = false, invert = false, order = 100, reverse = false, },
          runeBar = { height = 0.8, },
          scale = 1.2,
          shamanBar = { enabled = false, },
          soulShards = { height = 0.8, },
          text = {
            { anchorPoint = "C", size = 2, text = "[name]", width = 10, x = 0, y = -3, },
            { anchorPoint = "C", text = "[curmaxhp] [( )perhp]", width = 10, x = 0, y = 15, },
            { anchorPoint = "LC", size = -2, text = "[level]", width = 10, x = 25, },
            { anchorPoint = "RC", size = -2, text = "[perpp]", width = 10, x = -35, },
            nil,
            nil,
            { anchorTo = "", text = "", },
            { anchorTo = "", text = "", },
            { anchorTo = "", text = "", },
            { anchorTo = "$staggerBar", name = "文字", text = "[monk:abs:stagger]", width = 1, },
            { anchorTo = "$runeBar", block = true, name = "计时器文字", width = 1, },
            { anchorTo = "$totemBar", block = true, default = true, name = "计时器文字", text = "[totem:timer]", width = 1, },
          },
          totemBar = { enabled = false, height = 1, icon = false, invert = false, order = 0, reverse = false, secure = false, showAlways = true, vertical = false, },
          width = 200,
        },
        raid = {
          altPowerBar = { background = false, height = 0.8, },
          auraIndicators = { height = 0.5, },
          auras = {
            buffs = {
              anchorOn = false,
              show = { boss = false, consolidated = false, misc = false, player = false, raid = false, },
              timers = { ALL = false, },
            },
            debuffs = {
              anchorOn = false,
              anchorPoint = "RT",
              enabled = true,
              enlarge = { BOSS = false, REMOVABLE = false, SELF = false, },
              maxRows = 3,
              perRow = 1,
              selfScale = 1,
              size = 23,
              timers = { BOSS = true, },
              x = 3,
              y = -4,
            },
            height = 0.5,
          },
          columnSpacing = 95,
          combatText = { height = 0.5, },
          fader = { height = 0.5, inactiveAlpha = 0.2, },
          frameSplit = true,
          groupSpacing = 10,
          groupsPerRow = 2,
          healAbsorb = { cap = 1.3, enabled = false, height = 0.5, },
          healthBar = { background = false, colorAggro = false, height = 10, },
          height = 35,
          hideSemiRaid = false,
          highlight = { aggro = false, attention = false, height = 0.5, mouseover = false, },
          incAbsorb = { cap = 1.3, enabled = false, height = 0.5, },
          incHeal = { enabled = false, height = 0.5, },
          indicators = {
            height = 0.5,
            leader = { size = 15, x = 4, y = -10, },
            lfdRole = { anchorPoint = "LC", size = 13, x = -2, y = 0, },
            masterLoot = { anchorPoint = "TL", x = 22, y = -12, },
            pvp = { enabled = false, x = -3, y = 14, },
            raidTarget = { anchorPoint = "RC", size = 15, x = -8, },
            ready = { anchorPoint = "C", size = 30, x = 30, y = 2, },
            resurrect = { anchorPoint = "C", size = 30, x = 0, y = 0, },
          },
          maxColumns = 5,
          offset = 1,
          powerBar = { background = false, height = 0.8, },
          range = { enabled = true, height = 0.5, oorAlpha = 0.5, },
          scale = 1,
          showParty = false,
          text = {
            { anchorPoint = "C", text = "[name][( )afk]", width = 10, x = 0, },
            { anchorPoint = "RC", text = "", width = 10, x = 0, },
          },
          unitsPerColumn = 10,
        },
        raidpet = {
          auraIndicators = { height = 0.5, },
          auras = { height = 0.5, },
          combatText = { height = 0.5, },
          fader = { height = 0.5, },
          healAbsorb = { cap = 1.3, height = 0.5, },
          highlight = { height = 0.5, },
          incAbsorb = { cap = 1.3, height = 0.5, },
          incHeal = { height = 0.5, },
          indicators = { height = 0.5, },
          range = { height = 0.5, },
        },
        target = {
          altPowerBar = { background = false, height = 1, order = 95, },
          auraIndicators = { height = 0.5, },
          auras = {
            buffs = {
              anchorOn = false,
              enlarge = { REMOVABLE = true, SELF = false, },
              maxRows = 2,
              perRow = 9,
              size = 19,
              x = 7,
              y = -5,
            },
            debuffs = {
              anchorOn = true,
              enlarge = { BOSS = true, REMOVABLE = true, },
              maxRows = 1,
              perRow = 7,
              size = 20,
            },
            height = 0.5,
          },
          castBar = { autoHide = true, enabled = true, height = 3.5, icon = "LEFT", order = 100, },
          combatText = { enabled = false, height = 0.5, },
          comboPoints = { height = 0.5, order = 99, },
          emptyBar = {
            background = false,
            backgroundColor = { b = 0, g = 0, r = 0, },
            class = false,
            enabled = true,
            height = 0,
            order = 100,
          },
          healAbsorb = { cap = 1.3, enabled = false, height = 0.5, },
          healthBar = { background = false, colorAggro = false, height = 10, invert = false, reverse = false, vertical = false, },
          height = 40,
          highlight = { debuff = true, height = 0.5, mouseover = false, rareMob = true, },
          incAbsorb = { cap = 1.3, enabled = false, height = 0.5, },
          incHeal = { cap = 1.2, enabled = false, height = 0.5, },
          indicators = {
            class = { anchorPoint = "LC", size = 15, },
            height = 0.5,
            leader = { x = 3, y = -10, },
            lfdRole = { size = 15, x = 5, y = 13, },
            masterLoot = { x = 4, y = -30, },
            petBattle = { anchorPoint = "BL", anchorTo = "$parent", enabled = false, size = 18, x = -6, y = 14, },
            pvp = { enabled = false, },
            questBoss = { anchorPoint = "TR", size = 20, x = 10, y = -18, },
            raidTarget = { anchorPoint = "BC", size = 15, y = 10, },
            resurrect = { anchorPoint = "C", size = 25, x = 0, y = 0, },
            role = { size = 12, x = 4, y = -19, },
          },
          portrait = { enabled = false, isBar = false, },
          powerBar = { background = false, invert = false, order = 90, vertical = false, },
          range = { height = 0.5, },
          scale = 1.2,
          text = {
            { anchorPoint = "C", size = 1, text = "[name][( )dechp]", width = 10, x = 0, y = 15, },
            { anchorPoint = "C", size = 1, text = "[( )smart:curmaxhp]", width = 10, x = 0, y = -3, },
            { anchorPoint = "LC", size = -2, text = "[( )level]", width = 10, x = 30, },
            { anchorPoint = "RC", size = -2, text = "[perpp]", width = 10, x = -35, },
            { size = -2, text = "[classification][( )incabsorb]", width = 10, x = 35, y = 2, },
          },
          width = 200,
        },
        targettarget = {
          altPowerBar = { background = false, enabled = true, height = 1, },
          auraIndicators = { height = 0.5, },
          auras = {
            buffs = { anchorOn = false, anchorPoint = "TL", maxRows = 3, perRow = 6, size = 17, },
            debuffs = {
              anchorOn = false,
              anchorPoint = "RT",
              enlarge = { SELF = false, },
              maxRows = 1,
              perRow = 2,
              show = { player = false, raid = false, },
              size = 20,
            },
            height = 0.5,
          },
          healthBar = { background = false, height = 3, order = 0, reverse = false, },
          height = 35,
          highlight = { height = 0.5, },
          indicators = {
            class = { anchorPoint = "C", size = 18, },
            height = 0.5,
            raidTarget = { anchorPoint = "BC", size = 12, y = 8, },
          },
          portrait = { fullBefore = 100, height = 10, isBar = true, order = 60, width = 1, },
          powerBar = { background = false, height = 0.2, order = 100, },
          range = { height = 0.5, },
          scale = 1.2,
          text = {
            { anchorPoint = "C", width = 10, x = 0, y = -3, },
            { anchorPoint = "C", size = -1, text = "[perhp]", width = 10, x = 0, y = 14, },
            { text = "", width = 10, x = 0, },
            { anchorPoint = "RC", text = "", width = 10, x = 0, },
          },
          width = 100,
        },
        targettargettarget = {
          altPowerBar = { enabled = true, },
          auraIndicators = { height = 0.5, },
          auras = { height = 0.5, },
          enabled = false,
          height = 5,
          highlight = { height = 0.5, },
          indicators = {
            class = { anchorPoint = "C", size = 20, },
            height = 0.5,
            raidTarget = { size = 12, },
          },
          portrait = { isBar = false, },
          powerBar = { enabled = false, },
          range = { height = 0.5, },
          scale = 1.2,
          text = { { anchorPoint = "C", text = "", width = 10, }, { width = 10, }, },
          width = 20,
        },
      },
      wowBuild = 80000,
    },
    CENTER = {
      advanced = true,
      auras = { borderType = "dark", },
      backdrop = {
        backgroundColor = { a = 1, },
        backgroundTexture = "None",
        borderColor = { b = 1, g = 1, r = 1, },
        clip = 2,
        edgeSize = 10,
        inset = 0,
        tileSize = 0,
      },
      bars = {
        backgroundAlpha = 1,
        backgroundColor = { a = 1, b = 0, g = 0, r = 0, },
        spacing = -1.1,
        texture = "Smooth v2",
      },
      font = { extra = "OUTLINE", size = 12, },
      hidden = { arena = false, raid = false, },
      locked = true,
      positions = {
        arenapet = { point = "", relativePoint = "", },
        arenatarget = { point = "", relativePoint = "", },
        arenatargettarget = { point = "", relativePoint = "", },
        battlegroundpet = { point = "", relativePoint = "", },
        battlegroundtarget = { point = "", relativePoint = "", },
        battlegroundtargettarget = { point = "", relativePoint = "", },
        boss = {
          anchorPoint = "",
          bottom = 287.71571877242,
          point = "BOTTOMRIGHT",
          relativePoint = "BOTTOMLEFT",
          top = 435.6268334651,
          x = 1167.3602713225,
          y = 287.71571877242,
        },
        bosstarget = { point = "", relativePoint = "", },
        bosstargettarget = { point = "", relativePoint = "", },
        focus = { anchorPoint = "", anchorTo = "UIParent", point = "CENTER", relativePoint = "CENTER", x = -311.46667420864, y = -170.668013978, },
        focustarget = { anchorPoint = "", anchorTo = "UIParent", point = "CENTER", relativePoint = "CENTER", x = -227.70210564112, y = -56.429903423786, },
        mainassist = { point = "", relativePoint = "", },
        mainassisttarget = { point = "", relativePoint = "", },
        mainassisttargettarget = { point = "", relativePoint = "", x = 0, },
        maintank = { point = "", relativePoint = "", },
        maintanktarget = { point = "", relativePoint = "", },
        maintanktargettarget = { point = "", relativePoint = "", x = 0, },
        party = {
          anchorPoint = "",
          anchorTo = "UIParent",
          bottom = 466.4893776152,
          point = "TOPRIGHT",
          relativePoint = "BOTTOMLEFT",
          top = 618.66724588343,
          x = 318.57841483224,
          y = 618.66724588343,
        },
        partypet = { point = "", relativePoint = "", },
        partytarget = { point = "", relativePoint = "", },
        partytargettarget = { point = "", relativePoint = "", },
        pet = { anchorPoint = "", anchorTo = "UIParent", point = "CENTER", relativePoint = "CENTER", x = -170.66667079926, y = -134.82666993141, },
        pettarget = { point = "", relativePoint = "", },
        player = { anchorPoint = "", point = "CENTER", relativePoint = "CENTER", x = -170.66667079926, y = -170.66667079926, },
        raid = {
          anchorPoint = "",
          bottom = 615.67996282498,
          point = "TOPLEFT",
          relativePoint = "BOTTOMLEFT",
          top = 742.96885479609,
          x = 14.364791200699,
          y = 742.96885479609,
        },
        raidpet = { point = "", relativePoint = "", },
        target = { anchorPoint = "", anchorTo = "UIParent", point = "CENTER", relativePoint = "CENTER", x = 170.66667079926, y = -170.66667079926, },
        targettarget = { anchorPoint = "", anchorTo = "UIParent", point = "CENTER", relativePoint = "CENTER", x = 311.46667420864, y = -170.66667079926, },
        targettargettarget = { anchorPoint = "", anchorTo = "UIParent", point = "CENTER", relativePoint = "CENTER", x = 311.46667420864, y = -196.26667141914, },
      },
      powerColors = {
        ALTERNATE = { g = 0, r = 0.71, },
        BANKEDHOLYPOWER = { b = 0.84, g = 0.61, r = 0.96, },
        BURNINGEMBERS = { b = 0.79, g = 0.51, r = 0.58, },
        DEMONICFURY = { b = 0.79, g = 0.51, r = 0.58, },
        ECLIPSE_MOON = { b = 0.9, g = 0.52, r = 0.3, },
        ECLIPSE_SUN = { b = 0, g = 1, r = 1, },
        FULLBURNINGEMBER = { b = 0.062, g = 0.09, r = 0.88, },
        LIGHTWELL = { b = 0.8, g = 0.8, r = 0.8, },
        POWER_TYPE_FEL_ENERGY = { b = 0, g = 0.98, r = 0.878, },
        SHADOWORBS = { b = 0.79, g = 0.51, r = 0.58, },
      },
      revision = 59,
      tags = {
        ["法力值"] = {
          category = "misc",
          func = "function(unit, unitOwner)\nlocal maxPower = UnitPowerMax(unit)\nlocal power = UnitPower(unit)\nif( UnitIsDeadOrGhost(unit) ) then\nreturn string.format(\"0/%s\", ShadowUF:FormatLargeNumber(maxPower))\nelseif( maxPower <= 0 ) then\nreturn nil\nend\n\nreturn string.format(\"%s/%s\", ShadowUF:FormatLargeNumber(power), ShadowUF:FormatLargeNumber(maxPower))\nend",
        },
      },
      units = {
        arena = {
          auraIndicators = { height = 0.5, },
          auras = { height = 0.5, },
          combatText = { height = 0.5, },
          enabled = false,
          highlight = { height = 0.5, },
          indicators = { height = 0.5, },
          range = { height = 0.5, },
        },
        arenatarget = {
          altPowerBar = { enabled = true, },
        },
        battleground = {
          auraIndicators = { height = 0.5, },
          auras = { height = 0.5, },
          combatText = { height = 0.5, },
          enabled = false,
          highlight = { height = 0.5, },
          indicators = { height = 0.5, },
          range = { height = 0.5, },
        },
        battlegroundtarget = {
          altPowerBar = { enabled = true, },
        },
        boss = {
          altPowerBar = { background = false, height = 0.8, },
          attribAnchorPoint = "RIGHT",
          attribPoint = "BOTTOM",
          auraIndicators = { height = 0.5, },
          auras = {
            buffs = {
              anchorOn = false,
              anchorPoint = "LT",
              enlarge = { REMOVABLE = false, SELF = false, },
              maxRows = 3,
              perRow = 1,
              selfScale = 1,
              show = { consolidated = false, raid = false, },
              size = 25,
              timers = { SELF = true, },
              x = -3,
              y = -6,
            },
            debuffs = {
              anchorOn = false,
              anchorPoint = "RT",
              enlarge = { BOSS = false, REMOVABLE = false, SELF = false, },
              maxRows = 3,
              perRow = 1,
              selfScale = 1,
              show = { misc = false, },
              size = 25,
              x = 3,
              y = -6,
            },
            height = 0.5,
          },
          combatText = { enabled = false, height = 0.5, },
          healthBar = { background = false, height = 10, },
          highlight = { height = 0.5, },
          indicators = {
            class = { size = 20, },
            height = 0.5,
            raidTarget = { anchorPoint = "BC", size = 13, y = 10, },
          },
          offset = 2,
          portrait = { isBar = false, width = 0.3, },
          powerBar = { background = false, height = 0.8, },
          range = { height = 0.5, },
          scale = 1.1,
          text = {
            { width = 10, },
            { anchorPoint = "RC", text = "[dechp]", width = 10, x = -43, },
            { size = -1, text = "", width = 5, y = 1, },
            { anchorPoint = "RC", size = -1, text = "[perpp]", width = 10, x = -23, },
          },
          width = 170,
        },
        bosstarget = {
          altPowerBar = { enabled = true, },
        },
        focus = {
          auraIndicators = { height = 0.5, },
          auras = {
            buffs = {
              anchorOn = false,
              enabled = true,
              enlarge = { REMOVABLE = true, SELF = false, },
              maxRows = 1,
              perRow = 4,
              show = { consolidated = false, misc = false, player = false, raid = false, },
              size = 15,
              x = 1,
              y = -8,
            },
            debuffs = {
              anchorOn = true,
              enabled = true,
              enlarge = { BOSS = true, REMOVABLE = true, SELF = false, },
              maxRows = 1,
              perRow = 4,
              show = { misc = false, },
              size = 22,
            },
            height = 0.5,
          },
          castBar = { autoHide = true, enabled = true, height = 3.5, icon = "LEFT", order = 100, },
          combatText = { enabled = false, height = 0.5, },
          fader = { height = 0.5, inactiveAlpha = 1, },
          healAbsorb = { cap = 1.3, enabled = false, height = 0.5, },
          healthBar = { background = false, height = 10, },
          height = 30,
          highlight = { aggro = false, height = 0.5, mouseover = false, },
          incAbsorb = { enabled = false, height = 0.5, },
          incHeal = { enabled = false, height = 0.5, },
          indicators = {
            height = 0.5,
            leader = { x = 5, y = -10, },
            masterLoot = { enabled = false, },
            petBattle = { anchorPoint = "BL", anchorTo = "$parent", enabled = false, size = 18, x = -6, y = 12, },
            pvp = { enabled = false, },
            questBoss = { size = 18, y = 19, },
            raidTarget = { anchorPoint = "BC", size = 12, y = 8, },
            resurrect = { size = 23, x = 31, y = -2, },
            role = { enabled = false, size = 13, x = 19, y = -9, },
          },
          powerBar = { background = false, height = 0.8, },
          range = { height = 0.5, },
          scale = 1.2,
          text = {
            { anchorPoint = "C", text = "[name]", width = 10, x = 0, y = -2, },
            { anchorPoint = "C", size = -1, text = "[perhp]", width = 10, x = 0, y = 12, },
            { size = -1, text = "", y = 1, },
            { size = -1, text = "", y = 1, },
          },
          width = 90,
        },
        focustarget = {
          altPowerBar = { enabled = true, },
          auraIndicators = { height = 0.5, },
          auras = { height = 0.5, },
          enabled = false,
          fader = { height = 0.5, },
          height = 50,
          highlight = { height = 0.5, },
          indicators = { height = 0.5, },
          range = { height = 0.5, },
          scale = 1.25,
          width = 190,
        },
        mainassist = {
          healAbsorb = { cap = 1.3, },
          incAbsorb = { cap = 1.3, },
          indicators = {
            leader = { size = 0, },
            masterLoot = { size = 0, },
            pvp = { size = 0, },
            ready = { size = 0, },
            role = { size = 0, },
            status = { size = 19, },
          },
        },
        mainassisttarget = {
          altPowerBar = { enabled = true, },
        },
        maintank = {
          auraIndicators = { height = 0.5, },
          auras = { height = 0.5, },
          combatText = { height = 0.5, },
          fader = { height = 0.5, },
          healAbsorb = { cap = 1.3, height = 0.5, },
          highlight = { height = 0.5, },
          incAbsorb = { cap = 1.3, height = 0.5, },
          incHeal = { height = 0.5, },
          indicators = {
            height = 0.5,
            leader = { size = 0, },
            masterLoot = { size = 0, },
            pvp = { size = 0, },
            ready = { size = 0, },
            role = { size = 0, },
            status = { size = 19, },
          },
          range = { height = 0.5, },
        },
        maintanktarget = {
          altPowerBar = { enabled = true, },
        },
        party = {
          altPowerBar = { background = false, height = 0.7, },
          attribAnchorPoint = "RIGHT",
          auraIndicators = { height = 0.5, },
          auras = {
            buffs = {
              anchorOn = false,
              anchorPoint = "LT",
              enabled = false,
              maxRows = 3,
              perRow = 1,
              show = { misc = false, raid = false, },
              size = 30,
              y = -10,
            },
            debuffs = {
              anchorOn = false,
              anchorPoint = "LT",
              enlarge = { BOSS = false, REMOVABLE = false, SELF = false, },
              maxRows = 5,
              perRow = 1,
              show = { player = false, relevant = false, },
              size = 25,
              x = -8,
              y = -8,
            },
            height = 0.5,
          },
          columnSpacing = 5,
          combatText = { height = 0.5, },
          fader = { height = 0.5, },
          healAbsorb = { cap = 1.3, enabled = false, height = 0.5, },
          healthBar = { background = false, height = 8.8, order = 0, },
          height = 40,
          hideAnyRaid = true,
          hideSemiRaid = false,
          highlight = { height = 0.5, },
          incAbsorb = { cap = 1.3, enabled = false, height = 0.5, },
          incHeal = { cap = 1.2, enabled = false, height = 0.5, },
          indicators = {
            height = 0.5,
            leader = { size = 13, x = 10, y = -9, },
            lfdRole = { anchorPoint = "LC", x = 8, y = 0, },
            masterLoot = { size = 10, x = 23, y = -7, },
            phase = { size = 20, x = 2, },
            pvp = { enabled = false, },
            raidTarget = { anchorPoint = "BC", size = 15, y = 10, },
            ready = { anchorPoint = "RC", size = 25, x = -10, },
            resurrect = { anchorPoint = "C", size = 25, x = 15, y = 1, },
            role = { enabled = false, y = -7, },
          },
          offset = 18,
          portrait = { enabled = false, fullAfter = 100, fullBefore = 100, height = 6, isBar = false, width = 1, },
          powerBar = { background = false, height = 0.7, invert = false, order = 100, },
          range = { enabled = true, height = 0.5, oorAlpha = 0.6, },
          scale = 1.2,
          showPlayer = false,
          text = {
            { text = "[name][( )afk]", width = 10, x = 8, },
            { anchorPoint = "RC", text = "[perhp]", width = 10, x = -40, },
            { size = -2, text = "[level]", width = 10, x = 5, },
            { size = -2, text = "[perpp]", width = 10, x = -5, },
          },
          width = 155,
        },
        partypet = {
          healAbsorb = { cap = 1.3, },
        },
        partytarget = {
          altPowerBar = { enabled = true, },
          fader = { height = 0.5, },
          highlight = { height = 0.5, },
          indicators = { height = 0.5, },
          range = { height = 0.5, },
        },
        partytargettarget = {
          highlight = { height = 0.5, },
          indicators = { height = 0.5, },
          range = { height = 0.5, },
        },
        pet = {
          altPowerBar = { background = false, enabled = false, },
          auraIndicators = { height = 0.5, },
          auras = { height = 0.5, },
          castBar = { autoHide = true, background = false, enabled = true, height = 0.5, order = 50, },
          combatText = { enabled = false, height = 0.5, },
          fader = { height = 0.5, },
          healAbsorb = { cap = 1.3, enabled = false, height = 0.5, },
          healthBar = { background = false, height = 1, order = 0, },
          height = 12,
          highlight = { height = 0.5, },
          incAbsorb = { enabled = false, height = 0.5, },
          incHeal = { enabled = false, height = 0.5, },
          indicators = {
            height = 0.5,
            raidTarget = { anchorPoint = "RC", size = 15, x = -50, },
          },
          portrait = { width = 1, },
          powerBar = { background = false, height = 1, order = 100, },
          range = { height = 0.5, },
          scale = 1.2,
          text = {
            { anchorPoint = "C", size = -1, width = 10, x = 0, y = -2, },
            { anchorPoint = "C", text = "", width = 10, x = 0, },
            { text = "", width = 10, },
            { text = "", width = 10, },
          },
          width = 200,
        },
        pettarget = {
          altPowerBar = { enabled = true, },
          highlight = { height = 0.5, },
          indicators = { height = 0.5, },
          range = { height = 0.5, },
        },
        player = {
          altPowerBar = { enabled = false, invert = false, },
          arcaneCharges = { anchorPoint = "TC", background = false, growth = "RIGHT", height = 1, isBar = false, order = 85, showAlways = false, size = 15, spacing = -1, x = 30, y = -5, },
          auraIndicators = { height = 0.5, },
          auras = {
            buffs = {
              anchorOn = true,
              maxRows = 3,
              perRow = 50,
              show = { misc = false, },
              size = 30,
              temporary = true,
              x = 3,
              y = 80,
            },
            debuffs = {
              anchorOn = false,
              enabled = true,
              enlarge = { BOSS = true, REMOVABLE = true, },
              perRow = 7,
              size = 20,
              y = -9,
            },
            height = 0.5,
          },
          chi = { height = 1.2, },
          combatText = { enabled = false, height = 0.5, },
          comboPoints = { anchorPoint = "TC", growth = "RIGHT", height = 1, isBar = false, size = 15, spacing = -3, x = 25, y = -5, },
          druidBar = { background = false, height = 0, order = 0, reverse = false, vertical = false, },
          emptyBar = {
            backgroundColor = { b = 0, g = 0, r = 0, },
            class = false,
          },
          fader = { height = 0.5, inactiveAlpha = 1, },
          healAbsorb = { cap = 1.3, enabled = false, height = 0.5, },
          healthBar = { background = false, colorAggro = true, height = 2, invert = false, order = 0, },
          height = 40,
          highlight = { aggro = false, height = 0.5, mouseover = false, },
          holyPower = { height = 1.2, },
          incAbsorb = { cap = 1.3, enabled = false, height = 0.5, },
          incHeal = { cap = 1.2, enabled = false, height = 0.5, },
          indicators = {
            height = 0.5,
            leader = { x = 3, y = -10, },
            lfdRole = { anchorPoint = "LC", enabled = false, size = 15, x = 10, y = 0, },
            masterLoot = { size = 11, x = 17, y = -8, },
            pvp = { anchorPoint = "RB", enabled = false, size = 40, x = -12, y = -18, },
            raidTarget = { anchorPoint = "BC", size = 15, y = 10, },
            ready = { anchorPoint = "RC", size = 25, x = 0, },
            resurrect = { anchorPoint = "C", size = 25, x = 0, y = 0, },
            role = { size = 12, y = -9, },
            status = { anchorPoint = "BL", size = 23, x = 25, y = 15, },
          },
          portrait = { fullAfter = 100, height = 10, isBar = true, order = 50, width = 0.2, },
          powerBar = { background = false, height = 2, invert = false, order = 100, reverse = false, },
          runeBar = { height = 0.8, order = 30, },
          scale = 1.2,
          shamanBar = { enabled = false, },
          soulShards = { height = 1.2, },
          text = {
            { anchorPoint = "LC", size = 1, text = "[name]", width = 10, x = 55, y = 13, },
            { anchorPoint = "RC", size = 2, width = 5, x = -100, y = 13, },
            { anchorPoint = "LC", size = -2, text = "[level]", width = 10, x = 25, },
            { anchorPoint = "RC", size = -2, text = "[perpp]", width = 10, x = -35, },
            nil,
            nil,
            { anchorTo = "", text = "", },
            { anchorTo = "", text = "", },
            { anchorTo = "", text = "", },
            { anchorTo = "$staggerBar", name = "文字", text = "[monk:abs:stagger]", width = 1, },
            { anchorTo = "$runeBar", block = true, name = "计时器文字", width = 1, },
            { anchorTo = "$totemBar", block = true, default = true, name = "计时器文字", text = "[totem:timer]", width = 1, },
          },
          totemBar = { enabled = false, height = 1, icon = false, invert = false, order = 0, reverse = false, secure = false, showAlways = true, vertical = false, },
          width = 200,
        },
        raid = {
          altPowerBar = { background = false, height = 0.5, },
          auraIndicators = { height = 0.5, },
          auras = {
            buffs = {
              anchorOn = false,
              show = { boss = false, consolidated = false, misc = false, player = false, raid = false, },
              timers = { ALL = false, },
            },
            debuffs = {
              anchorOn = false,
              anchorPoint = "RT",
              enabled = true,
              enlarge = { BOSS = false, REMOVABLE = false, SELF = false, },
              maxRows = 3,
              perRow = 1,
              selfScale = 1,
              size = 23,
              timers = { BOSS = true, },
              x = 3,
              y = -4,
            },
            height = 0.5,
          },
          columnSpacing = 95,
          combatText = { height = 0.5, },
          fader = { height = 0.5, inactiveAlpha = 0.2, },
          frameSplit = true,
          groupSpacing = 10,
          groupsPerRow = 2,
          healAbsorb = { cap = 1.3, enabled = false, height = 0.5, },
          healthBar = { background = false, colorAggro = false, height = 10, },
          height = 35,
          hideSemiRaid = false,
          highlight = { aggro = false, attention = false, height = 0.5, mouseover = false, },
          incAbsorb = { cap = 1.3, enabled = false, height = 0.5, },
          incHeal = { enabled = false, height = 0.5, },
          indicators = {
            height = 0.5,
            leader = { size = 15, x = 4, y = -10, },
            lfdRole = { anchorPoint = "LC", size = 13, x = -2, y = 0, },
            masterLoot = { anchorPoint = "TL", x = 22, y = -12, },
            pvp = { enabled = false, x = -3, y = 14, },
            raidTarget = { anchorPoint = "RC", size = 15, x = -8, },
            ready = { anchorPoint = "C", size = 30, x = 30, y = 2, },
            resurrect = { anchorPoint = "C", size = 30, x = 0, y = 0, },
          },
          maxColumns = 5,
          offset = 1,
          powerBar = { background = false, height = 0.5, },
          range = { enabled = true, height = 0.5, oorAlpha = 0.5, },
          scale = 1,
          showParty = false,
          text = {
            { anchorPoint = "C", text = "[name][( )afk]", width = 10, x = 0, },
            { anchorPoint = "RC", text = "", width = 10, x = 0, },
          },
          unitsPerColumn = 10,
        },
        raidpet = {
          auraIndicators = { height = 0.5, },
          auras = { height = 0.5, },
          combatText = { height = 0.5, },
          fader = { height = 0.5, },
          healAbsorb = { cap = 1.3, height = 0.5, },
          highlight = { height = 0.5, },
          incAbsorb = { cap = 1.3, height = 0.5, },
          incHeal = { height = 0.5, },
          indicators = { height = 0.5, },
          range = { height = 0.5, },
        },
        target = {
          altPowerBar = { background = false, height = 1, order = 95, },
          auraIndicators = { height = 0.5, },
          auras = {
            buffs = {
              anchorOn = false,
              enlarge = { REMOVABLE = true, SELF = false, },
              maxRows = 2,
              perRow = 9,
              size = 19,
              x = 7,
              y = -5,
            },
            debuffs = {
              anchorOn = true,
              enlarge = { BOSS = true, REMOVABLE = true, },
              maxRows = 1,
              perRow = 7,
              size = 20,
            },
            height = 0.5,
          },
          castBar = { autoHide = true, enabled = true, height = 3.5, icon = "LEFT", order = 100, },
          combatText = { enabled = false, height = 0.5, },
          comboPoints = { height = 0.5, order = 99, },
          emptyBar = {
            background = false,
            backgroundColor = { b = 0, g = 0, r = 0, },
            class = false,
            height = 0,
            order = 100,
          },
          healAbsorb = { cap = 1.3, enabled = false, height = 0.5, },
          healthBar = { background = false, colorAggro = false, height = 2, invert = false, order = 0, reverse = false, vertical = false, },
          height = 40,
          highlight = { debuff = true, height = 0.5, mouseover = false, rareMob = true, },
          incAbsorb = { cap = 1.3, enabled = false, height = 0.5, },
          incHeal = { cap = 1.2, enabled = false, height = 0.5, },
          indicators = {
            class = { anchorPoint = "LC", size = 15, },
            height = 0.5,
            leader = { x = 3, y = -10, },
            lfdRole = { size = 15, x = 5, y = 13, },
            masterLoot = { x = 4, y = -30, },
            petBattle = { anchorPoint = "BL", anchorTo = "$parent", enabled = false, size = 18, x = -6, y = 14, },
            pvp = { enabled = false, },
            questBoss = { anchorPoint = "TR", size = 20, x = 10, y = -18, },
            raidTarget = { anchorPoint = "BC", size = 15, y = 10, },
            resurrect = { anchorPoint = "C", size = 25, x = 0, y = 0, },
            role = { size = 12, x = 4, y = -19, },
          },
          portrait = { height = 10, isBar = true, order = 50, },
          powerBar = { background = false, height = 2, invert = false, order = 100, vertical = false, },
          range = { height = 0.5, },
          scale = 1.2,
          text = {
            { anchorPoint = "C", size = 1, text = "[name]", width = 10, x = 0, y = -17, },
            { anchorPoint = "C", text = "[( )smart:curmaxhp]  [( )perhp]", width = 10, x = 0, },
            { anchorPoint = "LC", size = -2, text = "[( )level]", width = 10, x = 25, },
            { anchorPoint = "RC", size = -2, text = "[perpp]", width = 10, x = -35, },
            { size = -2, text = "[classification][( )incabsorb]", width = 10, x = 35, y = 2, },
          },
          width = 200,
        },
        targettarget = {
          altPowerBar = { background = false, enabled = true, height = 1, },
          auraIndicators = { height = 0.5, },
          auras = {
            buffs = { anchorOn = false, anchorPoint = "TL", maxRows = 3, perRow = 6, size = 17, },
            debuffs = {
              anchorOn = false,
              anchorPoint = "RT",
              enlarge = { SELF = false, },
              maxRows = 1,
              perRow = 2,
              show = { player = false, raid = false, },
              size = 20,
            },
            height = 0.5,
          },
          healthBar = { background = false, height = 3, order = 0, reverse = false, },
          highlight = { height = 0.5, },
          indicators = {
            class = { anchorPoint = "C", size = 18, },
            height = 0.5,
            raidTarget = { anchorPoint = "BC", size = 12, y = 8, },
          },
          portrait = { fullBefore = 100, height = 10, isBar = true, order = 60, width = 1, },
          powerBar = { background = false, height = 0.2, order = 100, },
          range = { height = 0.5, },
          scale = 1.2,
          text = {
            { anchorPoint = "C", width = 10, x = 0, y = -2, },
            { anchorPoint = "C", size = -1, text = "[perhp]", width = 10, x = 0, y = 12, },
            { text = "", width = 10, x = 0, },
            { anchorPoint = "RC", text = "", width = 10, x = 0, },
          },
          width = 90,
        },
        targettargettarget = {
          altPowerBar = { enabled = true, },
          auraIndicators = { height = 0.5, },
          auras = { height = 0.5, },
          enabled = false,
          height = 5,
          highlight = { height = 0.5, },
          indicators = {
            class = { anchorPoint = "C", size = 20, },
            height = 0.5,
            raidTarget = { size = 12, },
          },
          portrait = { isBar = false, },
          powerBar = { enabled = false, },
          range = { height = 0.5, },
          scale = 1.2,
          text = { { anchorPoint = "C", text = "", width = 10, }, { width = 10, }, },
          width = 20,
        },
      },
      wowBuild = 80000,
    },
    SIDE = {
      advanced = true,
      auras = { borderType = "dark", },
      backdrop = {
        backgroundColor = { a = 1, b = 0.070588235294118, g = 0.054901960784314, r = 0.11764705882353, },
        backgroundTexture = "Solid",
        borderColor = { b = 0.92549019607843, g = 0.99607843137255, r = 1, },
        borderTexture = "Square Clean",
        clip = 2,
        edgeSize = 8,
        inset = 2,
        tileSize = 0,
      },
      bars = {
        backgroundAlpha = 1,
        backgroundColor = { a = 1, b = 0, g = 0, r = 0, },
        spacing = -2,
        texture = "Armory",
      },
      font = { extra = "OUTLINE", size = 12, },
      hidden = { arena = false, raid = false, },
      locked = true,
      positions = {
        arenapet = { point = "", relativePoint = "", },
        arenatarget = { point = "", relativePoint = "", },
        arenatargettarget = { point = "", relativePoint = "", },
        battlegroundpet = { point = "", relativePoint = "", },
        battlegroundtarget = { point = "", relativePoint = "", },
        battlegroundtargettarget = { point = "", relativePoint = "", },
        boss = {
          anchorPoint = "",
          bottom = 290.55994627184,
          point = "BOTTOMRIGHT",
          relativePoint = "BOTTOMLEFT",
          top = 474.0267041866,
          x = 1054.2928206679,
          y = 290.55994627184,
        },
        bosstarget = { point = "", relativePoint = "", },
        bosstargettarget = { point = "", relativePoint = "", },
        focus = { anchorPoint = "", anchorTo = "UIParent", point = "CENTER", relativePoint = "CENTER", x = -315.73334097862, y = -170.668013978, },
        focustarget = { anchorPoint = "", anchorTo = "UIParent", point = "CENTER", relativePoint = "CENTER", x = -227.70210564112, y = -56.429903423786, },
        mainassist = { point = "", relativePoint = "", },
        mainassisttarget = { point = "", relativePoint = "", },
        mainassisttargettarget = { point = "", relativePoint = "", x = 0, },
        maintank = { point = "", relativePoint = "", },
        maintanktarget = { point = "", relativePoint = "", },
        maintanktargettarget = { point = "", relativePoint = "", x = 0, },
        party = {
          anchorPoint = "",
          anchorTo = "UIParent",
          bottom = 423.11146857872,
          point = "TOPRIGHT",
          relativePoint = "BOTTOMLEFT",
          top = 614.40031869677,
          x = 334.93364526299,
          y = 614.40031869677,
        },
        partypet = { point = "", relativePoint = "", },
        partytarget = { point = "", relativePoint = "", },
        partytargettarget = { point = "", relativePoint = "", },
        pet = { anchorPoint = "", anchorTo = "UIParent", point = "CENTER", relativePoint = "CENTER", x = -170.66667079926, y = -143.36000347137, },
        pettarget = { point = "", relativePoint = "", },
        player = { anchorPoint = "", point = "CENTER", relativePoint = "CENTER", x = -170.66667079926, y = -170.66667079926, },
        raid = {
          anchorPoint = "",
          bottom = 622.79107410828,
          point = "TOPLEFT",
          relativePoint = "BOTTOMLEFT",
          top = 742.2576568622,
          x = 11.520341262031,
          y = 742.2576568622,
        },
        raidpet = { point = "", relativePoint = "", },
        target = { anchorPoint = "", anchorTo = "UIParent", point = "CENTER", relativePoint = "CENTER", x = 170.66667079926, y = -170.66667079926, },
        targettarget = { anchorPoint = "", anchorTo = "UIParent", point = "CENTER", relativePoint = "CENTER", x = 315.73334097862, y = -170.66667079926, },
        targettargettarget = { anchorPoint = "", anchorTo = "UIParent", point = "CENTER", relativePoint = "CENTER", x = 315.73334097862, y = -196.26667141914, },
      },
      powerColors = {
        ALTERNATE = { g = 0, r = 0.71, },
        BANKEDHOLYPOWER = { b = 0.84, g = 0.61, r = 0.96, },
        BURNINGEMBERS = { b = 0.79, g = 0.51, r = 0.58, },
        DEMONICFURY = { b = 0.79, g = 0.51, r = 0.58, },
        ECLIPSE_MOON = { b = 0.9, g = 0.52, r = 0.3, },
        ECLIPSE_SUN = { b = 0, g = 1, r = 1, },
        FULLBURNINGEMBER = { b = 0.062, g = 0.09, r = 0.88, },
        LIGHTWELL = { b = 0.8, g = 0.8, r = 0.8, },
        POWER_TYPE_FEL_ENERGY = { b = 0, g = 0.98, r = 0.878, },
        SHADOWORBS = { b = 0.79, g = 0.51, r = 0.58, },
      },
      revision = 59,
      tags = {
        ["法力值"] = {
          category = "misc",
          func = "function(unit, unitOwner)\nlocal maxPower = UnitPowerMax(unit)\nlocal power = UnitPower(unit)\nif( UnitIsDeadOrGhost(unit) ) then\nreturn string.format(\"0/%s\", ShadowUF:FormatLargeNumber(maxPower))\nelseif( maxPower <= 0 ) then\nreturn nil\nend\n\nreturn string.format(\"%s/%s\", ShadowUF:FormatLargeNumber(power), ShadowUF:FormatLargeNumber(maxPower))\nend",
        },
      },
      units = {
        arena = {
          auraIndicators = { height = 0.5, },
          auras = { height = 0.5, },
          combatText = { height = 0.5, },
          enabled = false,
          highlight = { height = 0.5, },
          indicators = { height = 0.5, },
          range = { height = 0.5, },
        },
        arenatarget = {
          altPowerBar = { enabled = true, },
        },
        battleground = {
          auraIndicators = { height = 0.5, },
          auras = { height = 0.5, },
          combatText = { height = 0.5, },
          enabled = false,
          highlight = { height = 0.5, },
          indicators = { height = 0.5, },
          range = { height = 0.5, },
        },
        battlegroundtarget = {
          altPowerBar = { enabled = true, },
        },
        boss = {
          altPowerBar = { background = false, height = 0.8, },
          attribAnchorPoint = "RIGHT",
          attribPoint = "BOTTOM",
          auraIndicators = { height = 0.5, },
          auras = {
            buffs = {
              anchorOn = false,
              anchorPoint = "LT",
              enlarge = { REMOVABLE = false, SELF = false, },
              maxRows = 3,
              perRow = 1,
              selfScale = 1,
              show = { consolidated = false, raid = false, },
              size = 28,
              timers = { SELF = true, },
              y = -8,
            },
            debuffs = {
              anchorOn = false,
              anchorPoint = "RT",
              enlarge = { BOSS = false, REMOVABLE = false, SELF = false, },
              maxRows = 3,
              perRow = 1,
              selfScale = 1,
              show = { misc = false, },
              size = 28,
              x = 1,
              y = -8,
            },
            height = 0.5,
          },
          combatText = { enabled = false, height = 0.5, },
          healthBar = { background = false, height = 10, },
          height = 50,
          highlight = { height = 0.5, },
          indicators = {
            class = { size = 20, },
            height = 0.5,
            raidTarget = { anchorPoint = "BC", size = 15, y = 15, },
          },
          offset = 2,
          portrait = { isBar = false, width = 0.3, },
          powerBar = { background = false, height = 0.8, },
          range = { height = 0.5, },
          scale = 1.1,
          text = {
            { width = 5, },
            { text = "[dechp]", width = 5, },
            { size = -1, text = "", width = 5, y = 1, },
            { size = -1, text = "[perpp]", width = 5, },
          },
          width = 150,
        },
        bosstarget = {
          altPowerBar = { enabled = true, },
        },
        focus = {
          auraIndicators = { height = 0.5, },
          auras = {
            buffs = {
              anchorOn = false,
              enabled = true,
              enlarge = { REMOVABLE = true, SELF = false, },
              maxRows = 1,
              perRow = 4,
              show = { consolidated = false, misc = false, player = false, raid = false, },
              size = 20,
            },
            debuffs = {
              anchorOn = true,
              enabled = true,
              enlarge = { BOSS = true, REMOVABLE = true, SELF = false, },
              maxRows = 1,
              perRow = 4,
              show = { misc = false, },
              size = 20,
            },
            height = 0.5,
          },
          castBar = { autoHide = true, enabled = true, height = 3.5, icon = "LEFT", order = 100, },
          combatText = { enabled = false, height = 0.5, },
          fader = { height = 0.5, inactiveAlpha = 1, },
          healAbsorb = { cap = 1.3, enabled = false, height = 0.5, },
          healthBar = { background = false, height = 10, },
          height = 40,
          highlight = { aggro = false, height = 0.5, mouseover = false, },
          incAbsorb = { enabled = false, height = 0.5, },
          incHeal = { enabled = false, height = 0.5, },
          indicators = {
            height = 0.5,
            petBattle = { anchorPoint = "BL", anchorTo = "$parent", enabled = false, size = 18, x = -6, y = 12, },
            pvp = { enabled = false, },
            questBoss = { size = 18, y = 19, },
            raidTarget = { anchorPoint = "BC", size = 15, y = 13, },
            resurrect = { size = 23, x = 31, y = -2, },
          },
          powerBar = { background = false, height = 0.8, },
          range = { height = 0.5, },
          scale = 1.2,
          text = {
            { anchorPoint = "C", text = "", width = 5, x = 0, },
            { anchorPoint = "C", size = 1, text = "[perhp]", width = 10, x = 4, y = -1, },
            { size = -1, text = "", y = 1, },
            { size = -1, text = "", y = 1, },
          },
          width = 90,
        },
        focustarget = {
          altPowerBar = { enabled = true, },
          auraIndicators = { height = 0.5, },
          auras = { height = 0.5, },
          enabled = false,
          fader = { height = 0.5, },
          height = 50,
          highlight = { height = 0.5, },
          indicators = { height = 0.5, },
          range = { height = 0.5, },
          scale = 1.25,
          width = 190,
        },
        mainassist = {
          healAbsorb = { cap = 1.3, },
          incAbsorb = { cap = 1.3, },
          indicators = {
            leader = { size = 0, },
            masterLoot = { size = 0, },
            pvp = { size = 0, },
            ready = { size = 0, },
            role = { size = 0, },
            status = { size = 19, },
          },
        },
        mainassisttarget = {
          altPowerBar = { enabled = true, },
        },
        maintank = {
          auraIndicators = { height = 0.5, },
          auras = { height = 0.5, },
          combatText = { height = 0.5, },
          fader = { height = 0.5, },
          healAbsorb = { cap = 1.3, height = 0.5, },
          highlight = { height = 0.5, },
          incAbsorb = { cap = 1.3, height = 0.5, },
          incHeal = { height = 0.5, },
          indicators = {
            height = 0.5,
            leader = { size = 0, },
            masterLoot = { size = 0, },
            pvp = { size = 0, },
            ready = { size = 0, },
            role = { size = 0, },
            status = { size = 19, },
          },
          range = { height = 0.5, },
        },
        maintanktarget = {
          altPowerBar = { enabled = true, },
        },
        party = {
          altPowerBar = { background = false, height = 0.5, },
          attribAnchorPoint = "RIGHT",
          auraIndicators = { height = 0.5, },
          auras = {
            buffs = {
              anchorOn = false,
              anchorPoint = "LT",
              enabled = false,
              maxRows = 3,
              perRow = 1,
              show = { misc = false, raid = false, },
              size = 30,
              y = -10,
            },
            debuffs = {
              anchorOn = false,
              anchorPoint = "LT",
              enlarge = { BOSS = false, REMOVABLE = false, SELF = false, },
              maxRows = 5,
              perRow = 1,
              show = { player = false, relevant = false, },
              size = 25,
              x = -5,
              y = -10,
            },
            height = 0.5,
          },
          columnSpacing = 5,
          combatText = { height = 0.5, },
          fader = { height = 0.5, },
          healAbsorb = { cap = 1.3, enabled = false, height = 0.5, },
          healthBar = { background = false, height = 8.8, order = 0, },
          height = 50,
          hideAnyRaid = true,
          hideSemiRaid = false,
          highlight = { height = 0.5, },
          incAbsorb = { cap = 1.3, enabled = false, height = 0.5, },
          incHeal = { cap = 1.2, enabled = false, height = 0.5, },
          indicators = {
            height = 0.5,
            leader = { size = 13, x = 10, y = -10, },
            lfdRole = { anchorPoint = "LC", size = 13, x = 10, y = 1, },
            masterLoot = { size = 11, x = 25, y = -9, },
            phase = { size = 25, x = 0, },
            pvp = { enabled = false, },
            raidTarget = { anchorPoint = "BC", y = 15, },
            ready = { anchorPoint = "C", size = 25, x = 0, },
            resurrect = { anchorPoint = "TC", size = 25, x = 0, y = -15, },
            role = { enabled = false, y = -7, },
          },
          portrait = { enabled = false, fullAfter = 100, fullBefore = 100, height = 6, isBar = false, width = 1, },
          powerBar = { background = false, height = 0.5, invert = false, order = 100, },
          range = { enabled = true, height = 0.5, oorAlpha = 0.6, },
          scale = 1.2,
          showPlayer = false,
          text = {
            { text = "[name][( )afk]", width = 10, x = 5, },
            { text = "[perhp]", width = 0, x = -5, },
            { size = -2, text = "[level]", width = 0, x = 5, },
            { size = -2, text = "[perpp]", width = 0, x = -5, },
          },
          width = 155,
        },
        partypet = {
          healAbsorb = { cap = 1.3, },
        },
        partytarget = {
          altPowerBar = { enabled = true, },
          fader = { height = 0.5, },
          highlight = { height = 0.5, },
          indicators = { height = 0.5, },
          range = { height = 0.5, },
        },
        partytargettarget = {
          highlight = { height = 0.5, },
          indicators = { height = 0.5, },
          range = { height = 0.5, },
        },
        pet = {
          altPowerBar = { background = false, enabled = false, },
          auraIndicators = { height = 0.5, },
          auras = { height = 0.5, },
          castBar = {
            autoHide = true,
            enabled = true,
            name = { x = 2, },
          },
          combatText = { enabled = false, height = 0.5, },
          fader = { height = 0.5, },
          healAbsorb = { cap = 1.3, enabled = false, height = 0.5, },
          healthBar = { background = false, height = 1, order = 0, },
          height = 15,
          highlight = { height = 0.5, },
          incAbsorb = { enabled = false, height = 0.5, },
          incHeal = { enabled = false, height = 0.5, },
          indicators = {
            height = 0.5,
            raidTarget = { anchorPoint = "RC", size = 15, x = -50, },
          },
          portrait = { width = 1, },
          powerBar = { background = false, height = 1, order = 100, },
          range = { height = 0.5, },
          scale = 1.2,
          text = {
            { anchorPoint = "C", size = -1, width = 0, x = 0, },
            { anchorPoint = "C", text = "", width = 0, x = 0, },
            { text = "", },
            { text = "", },
          },
          width = 240,
        },
        pettarget = {
          altPowerBar = { enabled = true, },
          highlight = { height = 0.5, },
          indicators = { height = 0.5, },
          range = { height = 0.5, },
        },
        player = {
          altPowerBar = { enabled = false, invert = false, },
          arcaneCharges = { anchorPoint = "TC", growth = "RIGHT", height = 3, isBar = false, order = 85, showAlways = false, size = 15, x = 30, y = -2, },
          auraIndicators = { height = 0.5, },
          auras = {
            buffs = {
              anchorOn = true,
              maxRows = 3,
              perRow = 50,
              show = { misc = false, },
              size = 20,
              temporary = true,
              x = 3,
              y = 80,
            },
            debuffs = {
              anchorOn = false,
              enabled = true,
              enlarge = { BOSS = true, REMOVABLE = true, },
              perRow = 7,
              size = 20,
              y = -2,
            },
            height = 0.5,
          },
          chi = { height = 0.7, },
          combatText = { enabled = false, height = 0.5, },
          comboPoints = { anchorPoint = "TC", growth = "RIGHT", isBar = false, size = 15, spacing = -3, x = 30, y = -3, },
          druidBar = { background = false, height = 0, order = 0, reverse = false, vertical = false, },
          emptyBar = {
            backgroundColor = { b = 0, g = 0, r = 0, },
            class = false,
          },
          fader = { height = 0.5, },
          healAbsorb = { cap = 1.3, enabled = false, height = 0.5, },
          healthBar = { background = false, colorAggro = true, height = 10, order = 0, },
          height = 50,
          highlight = { aggro = false, height = 0.5, mouseover = false, },
          holyPower = { height = 0.7, },
          incAbsorb = { cap = 1.3, enabled = false, height = 0.5, },
          incHeal = { cap = 1.2, enabled = false, height = 0.5, },
          indicators = {
            height = 0.5,
            leader = { x = 11, y = -11, },
            lfdRole = { enabled = false, x = 5, y = 13, },
            masterLoot = { size = 11, x = 26, y = -9, },
            pvp = { anchorPoint = "RT", enabled = false, size = 40, x = -12, y = -10, },
            raidTarget = { anchorPoint = "BC", size = 17, x = 25, y = 15, },
            ready = { anchorPoint = "RC", size = 25, x = 0, },
            resurrect = { anchorPoint = "TC", size = 30, x = 25, y = -20, },
            role = { size = 12, x = 39, y = -10, },
            status = { anchorPoint = "RT", size = 23, x = -15, y = 7, },
          },
          portrait = { fullAfter = 100, height = 10, isBar = false, order = 50, width = 0.25, },
          powerBar = { background = false, invert = false, order = 100, reverse = false, },
          runeBar = { height = 0.7, },
          scale = 1.2,
          shamanBar = { enabled = false, },
          soulShards = { height = 1, },
          text = {
            { anchorPoint = "C", text = "[( )absolutehp]", width = 10, x = -33, },
            { anchorPoint = "RC", text = "[perhp]", width = 5, x = -40, },
            { anchorPoint = "LC", size = -2, text = "[level]", width = 5, x = 23, },
            { anchorPoint = "RC", size = -2, text = "[perpp]", width = 0, x = -33, },
            nil,
            nil,
            { anchorTo = "", text = "", },
            { anchorTo = "", text = "", },
            { anchorTo = "", text = "", },
            { anchorTo = "$staggerBar", name = "文字", text = "[monk:abs:stagger]", width = 1, },
            { anchorTo = "$runeBar", block = true, name = "计时器文字", width = 1, },
            { anchorTo = "$totemBar", block = true, default = true, name = "计时器文字", width = 1, },
          },
          totemBar = { enabled = false, height = 0.5, icon = false, invert = false, order = 0, reverse = false, secure = false, showAlways = true, vertical = false, },
          width = 240,
        },
        raid = {
          altPowerBar = { background = false, height = 0.8, },
          auraIndicators = { height = 0.5, },
          auras = {
            buffs = {
              anchorOn = false,
              show = { boss = false, consolidated = false, misc = false, player = false, raid = false, },
              timers = { ALL = false, },
            },
            debuffs = {
              anchorOn = false,
              anchorPoint = "RT",
              enabled = true,
              enlarge = { BOSS = false, REMOVABLE = false, SELF = false, },
              maxRows = 3,
              perRow = 1,
              selfScale = 1,
              size = 25,
              timers = { BOSS = true, },
              x = -3,
              y = -4,
            },
            height = 0.5,
          },
          columnSpacing = 90,
          combatText = { height = 0.5, },
          fader = { height = 0.5, inactiveAlpha = 0.2, },
          frameSplit = true,
          groupSpacing = -20,
          groupsPerRow = 2,
          healAbsorb = { cap = 1.3, enabled = false, height = 0.5, },
          healthBar = { background = false, colorAggro = false, height = 10, },
          height = 40,
          hideSemiRaid = false,
          highlight = { aggro = false, attention = false, height = 0.5, mouseover = false, },
          incAbsorb = { cap = 1.3, enabled = false, height = 0.5, },
          incHeal = { enabled = false, height = 0.5, },
          indicators = {
            height = 0.5,
            leader = { size = 13, x = 10, y = -13, },
            lfdRole = { anchorPoint = "LC", size = 13, y = 0, },
            masterLoot = { anchorPoint = "TL", x = 22, y = -12, },
            pvp = { enabled = false, x = -3, y = 14, },
            raidTarget = { size = 18, y = -15, },
            ready = { anchorPoint = "C", size = 30, x = 30, y = 2, },
            resurrect = { anchorPoint = "C", size = 30, x = 0, y = 0, },
          },
          maxColumns = 5,
          offset = -5,
          powerBar = { background = false, height = 0.5, },
          range = { enabled = true, height = 0.5, oorAlpha = 0.5, },
          scale = 1,
          showParty = false,
          text = { { anchorPoint = "C", text = "[name][( )afk]", width = 10, }, { text = "", }, },
          unitsPerColumn = 10,
        },
        raidpet = {
          auraIndicators = { height = 0.5, },
          auras = { height = 0.5, },
          combatText = { height = 0.5, },
          fader = { height = 0.5, },
          healAbsorb = { cap = 1.3, height = 0.5, },
          highlight = { height = 0.5, },
          incAbsorb = { cap = 1.3, height = 0.5, },
          incHeal = { height = 0.5, },
          indicators = { height = 0.5, },
          range = { height = 0.5, },
        },
        target = {
          altPowerBar = { background = false, height = 1, },
          auraIndicators = { height = 0.5, },
          auras = {
            buffs = {
              anchorOn = false,
              enlarge = { REMOVABLE = true, SELF = false, },
              maxRows = 2,
              perRow = 9,
              size = 18,
              x = 3,
              y = -3,
            },
            debuffs = {
              anchorOn = true,
              enlarge = { BOSS = true, REMOVABLE = true, },
              maxRows = 1,
              perRow = 7,
              size = 18,
            },
            height = 0.5,
          },
          castBar = { autoHide = true, enabled = true, height = 3.5, icon = "LEFT", order = 100, },
          combatText = { enabled = false, height = 0.5, },
          comboPoints = { height = 0.5, order = 99, },
          emptyBar = {
            background = false,
            backgroundColor = { b = 0, g = 0, r = 0, },
            height = 0,
            order = 100,
          },
          healAbsorb = { cap = 1.3, enabled = false, height = 0.5, },
          healthBar = { background = false, colorAggro = false, height = 10, invert = false, reverse = false, vertical = false, },
          height = 50,
          highlight = { debuff = true, height = 0.5, mouseover = false, rareMob = true, },
          incAbsorb = { cap = 1.3, enabled = false, height = 0.5, },
          incHeal = { cap = 1.2, enabled = false, height = 0.5, },
          indicators = {
            class = { anchorPoint = "LC", size = 15, },
            height = 0.5,
            leader = { x = 11, y = -11, },
            lfdRole = { size = 15, x = 5, y = 13, },
            masterLoot = { size = 11, x = 26, y = -9, },
            petBattle = { anchorPoint = "BL", anchorTo = "$parent", enabled = false, size = 18, x = -6, y = 14, },
            pvp = { enabled = false, },
            questBoss = { anchorPoint = "TR", size = 20, y = -18, },
            raidTarget = { anchorPoint = "BC", size = 17, x = -25, y = 15, },
            resurrect = { anchorPoint = "TC", size = 30, x = -25, y = -20, },
            role = { size = 12, x = 39, y = -10, },
          },
          portrait = { fullAfter = 100, height = 10, isBar = false, order = 50, width = 0.25, },
          powerBar = { background = false, invert = false, order = 90, vertical = false, },
          range = { height = 0.5, },
          scale = 1.2,
          text = {
            { anchorPoint = "C", text = "[curmaxhp]", width = 10, x = -35, },
            { anchorPoint = "RC", text = "[dechp][( )rare]", width = 10, x = -50, },
            { anchorPoint = "C", text = "[( )level] [( )name]", width = 10, x = -18, },
            { anchorPoint = "RC", size = -2, text = "[( )perpp]", width = 3, x = -40, },
            { anchorPoint = "LC", size = -2, text = "[level]", width = 10, x = 25, },
            { anchorPoint = "C", x = 0, },
          },
          width = 240,
        },
        targettarget = {
          altPowerBar = { background = false, enabled = true, height = 0.5, },
          auraIndicators = { height = 0.5, },
          auras = {
            buffs = { anchorOn = false, anchorPoint = "TL", maxRows = 3, perRow = 6, size = 17, },
            debuffs = {
              anchorOn = false,
              anchorPoint = "RT",
              enlarge = { SELF = false, },
              maxRows = 1,
              perRow = 2,
              show = { player = false, raid = false, },
              size = 20,
            },
            height = 0.5,
          },
          healthBar = { background = false, height = 3, order = 0, reverse = false, },
          height = 40,
          highlight = { height = 0.5, },
          indicators = {
            class = { anchorPoint = "C", size = 18, },
            height = 0.5,
            raidTarget = { anchorPoint = "RC", size = 15, x = -11, },
          },
          portrait = { fullBefore = 100, height = 10, isBar = true, order = 60, width = 1, },
          powerBar = { background = false, height = 0.2, order = 100, },
          range = { height = 0.5, },
          scale = 1.2,
          text = {
            { anchorPoint = "C", size = -2, text = "[perhp]", width = 5, x = 2, y = -12, },
            { anchorPoint = "C", size = 1, text = "[name]", width = 0, x = 0, y = 2, },
            { text = "", width = 0, x = 0, },
            { anchorPoint = "RC", text = "", width = 0, x = 0, },
          },
          width = 90,
        },
        targettargettarget = {
          altPowerBar = { enabled = true, },
          auraIndicators = { height = 0.5, },
          auras = { height = 0.5, },
          enabled = false,
          height = 10,
          highlight = { height = 0.5, },
          indicators = {
            height = 0.5,
            raidTarget = { size = 15, },
          },
          powerBar = { enabled = false, },
          range = { height = 0.5, },
          scale = 1.2,
          text = { { anchorPoint = "C", text = "", }, },
          width = 40,
        },
      },
      wowBuild = 80000,
    },
}

_G.data2profile = data2profile
_G.preset_datas = preset_datas
