--[[--
	复用代码请在显著位置标注来源【ALA@网易有爱】
--]]--
if select(4, GetBuildInfo()) < 90000 then
	return;
end

local max = max;
local IsInInstance, GetInstanceInfo = IsInInstance, GetInstanceInfo;
local LE_PARTY_CATEGORY_HOME = LE_PARTY_CATEGORY_HOME;
local GameTooltip = GameTooltip;

local BUTTON_HEIGHT = 16;
local BUTTON_INTERVAL = 1;

local data = {
	-- [34] = {		--	test purpose
	-- 	{
	-- 		-1,
	-- 		"BOSS_TEST1",
	-- 		"STRATEGY_TEST1",
	-- 	},
	-- 	{
	-- 		-1,
	-- 		"BOSS_TEST2",
	-- 		"STRATEGY_TEST2",
	-- 	},
	-- 	{
	-- 		-1,
	-- 		"BOSS_TEST3",
	-- 		"STRATEGY_TEST3",
	-- 	},
	-- },
	[2284] = {	--	"赤红深渊"
		{
			-1,
			"贪食的克里克西斯",
			"",
		},
		{
			-1,
			"执行者塔沃德",
			"",
		},
		{
			-1,
			"大学监贝律莉娅",
			"",
		},
		{
			-1,
			"卡尔将军",
			"",
		},
	},
	[2285] = {	--	"晋升高塔"
		{
			-1,
			"金·塔拉",
			"",
		},
		{
			-1,
			"雯图纳柯丝",
			"",
		},
		{
			-1,
			"奥莱芙莉安",
			"",
		},
		{
			-1,
			"疑虑圣杰德沃斯",
			"",
		},
	},
	[2286] = {	--	"通灵战潮"
		{
			-1,
			"凋骨",
			"",
		},
		{
			-1,
			"收割者阿玛厄斯",
			"",
		},
		{
			-1,
			"外科医生缝肉",
			"",
		},
		{
			-1,
			"缚霜者纳尔佐",
			"",
		},
	},
	[2287] = {	--	"赎罪大厅"
		{
			-1,
			"罪污巨像",
			"",
		},
		{
			-1,
			"艾谢朗",
			"",
		},
		{
			-1,
			"高阶裁决官阿丽兹",
			"",
		},
		{
			-1,
			"宫务大臣",
			"",
		},
	},
	[2289] = {	--	"凋魂之殇"
		{
			-1,
			"酤团",
			"【网·易·有·爱】躲BOSS正面喷吐；小软吃控制、出来速度打掉。",
		},
		{
			-1,
			"依库斯博士",
			"【网·易·有·爱】躲BOSS跳跃，注意驱散疾病，先打绿软炸弹、断红软疾病，红软死后血水有急速加成、但会持续掉血。",
		},
		{
			-1,
			"多米娜·毒刃",
			"【网·易·有·爱】点名出人群、AOE技能找BOSS蜘蛛网小怪。",
		},
		{
			-1,
			"斯特拉达玛侯爵",
			"【网·易·有·爱】小怪出来T拉住，T站小怪附近绿圈打。BOSS两次消失转阶段，触须扇形拍地板，停手、跑到无触须的一侧场地，否则拍中秒杀。毒雨debuff交群疗。",
		},
	},
	[2290] = {	--	"塞兹仙林的迷雾"
		{
			-1,
			"英格拉·马洛克",
			"",
		},
		{
			-1,
			"唤雾者",
			"",
		},
		{
			-1,
			"特雷德奥瓦",
			"",
		},
	},
	[2291] = {	--	"彼界"	--	[2439] = "彼界",
		{
			-1,
			"夺灵者哈卡",
			"",
		},
		{
			-1,
			"法力风暴夫妇",
			"",
		},
		{
			-1,
			"商人赛·艾柯莎",
			"",
		},
		{
			-1,
			"穆厄扎拉",
			"",
		},
	},
	[2293] = {	--	"伤逝剧场"
		{
			-1,
			"狭路相逢",
			"",
		},
		{
			-1,
			"斩血",
			"",
		},
		{
			-1,
			"无堕者哈夫",
			"",
		},
		{
			-1,
			"库尔萨洛克",
			"",
		},
		{
			-1,
			"无尽女皇莫得蕾莎",
			"",
		},
	},
};

local main = CreateFrame("BUTTON", nil, UIParent);
main:SetSize(24, 24);
main:SetNormalTexture("Interface\\Buttons\\UI-MicroButton-Abilities-Up");
main:SetPushedTexture("Interface\\Buttons\\UI-MicroButton-Abilities-Up");
main:GetNormalTexture():SetTexCoord(4 / 32, 28 / 32, 31 / 64, 55 / 64);
main:GetPushedTexture():SetTexCoord(4 / 32, 28 / 32, 31 / 64, 55 / 64);
main:GetPushedTexture():SetVertexColor(0.25, 0.25, 0.25, 1.0);
main:SetPoint("RIGHT", ChatFrame1EditBox, "LEFT", -1, 0);
main:SetScript("OnEnter", function(self)
	GameTooltip:SetOwner(self, "ANCHOR_RIGHT");
	GameTooltip:AddLine("副本一句话攻略");
	GameTooltip:Show();
end);
main:SetScript("OnLeave", function(self)
	if GameTooltip:IsOwned(self) then
		GameTooltip:Hide();
	end
end);

local current = nil;
local menu = CreateFrame("FRAME", nil, main);
menu:SetBackdrop({
	bgFile = "Interface\\Buttons\\WHITE8X8";
	edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border",
	tile = true,
	tileSize = 2,
	edgeSize = 2,
	insets = { left = 2, right = 2, top = 2, bottom = 2 }
});
menu:SetBackdropColor(0.05, 0.05, 0.05, 1.0);
menu:Hide();
local pool = {  };
local eles = {  };
local function OnClick(self)
	if current ~= nil then
		local index = self.id;
		local val = current[index];
		if IsInGroup(LE_PARTY_CATEGORY_HOME) then
			SendChatMessage(val[3], "PARTY");
		else
			ChatFrame1:AddMessage(val[3]);
		end
	end
	menu:Hide();
end
local function update()
	if current ~= nil then
		local num = #current;
		local w = -1;
		for index = 1, num do
			local ele = pool[index];
			if ele == nil then
				ele = CreateFrame("BUTTON", nil, menu);
				ele:SetHeight(BUTTON_HEIGHT);
				ele:SetPoint("TOPLEFT", 0, -(BUTTON_HEIGHT + BUTTON_INTERVAL) * (index - 1));
				ele:SetHighlightTexture("Interface\\TargetingFrame\\UI-StatusBar");
				ele:GetHighlightTexture():SetVertexColor(0.5, 0.5, 0.0, 0.75);
				local text = ele:CreateFontString(nil, "ARTWORK", "GameFontNormalSmall");
				text:SetPoint("LEFT", 2, 0);
				text:SetTextColor(0.9, 0.9, 0.9, 0.9);
				ele.text = text;
				ele.id = index;
				ele:SetScript("OnClick", OnClick);
				pool[index] = ele;
			else
				ele:Show();
			end
			local val = current[index];
			ele.text:SetText(val[2]);
			w = max(ele.text:GetWidth() + 4, w);
		end
		for index = 1, num do
			pool[index]:SetWidth(w);
		end
		menu:SetSize(w, num * (BUTTON_HEIGHT + BUTTON_INTERVAL));
		if num < #pool then
			for index = num + 1, #pool do
				pool[index]:Hide();
			end
		end
	end
end

main:SetScript("OnClick", function(self, button)
	if menu:IsShown() then
		menu:Hide();
	else
		menu:Show();
		menu:ClearAllPoints();
		local l, r, t, b = main:GetLeft(), main:GetRight(), main:GetTop(), main:GetBottom();
		local w, h = UIParent:GetSize();
		if l + r > w then
			if t + b > h then
				menu:SetPoint("TOPRIGHT", main, "BOTTOMLEFT", -2, -2);
			else
				menu:SetPoint("BOTTOMRIGHT", main, "TOPLEFT", -2, 2);
			end
		else
			if t + b > h then
				menu:SetPoint("TOPLEFT", main, "BOTTOMRIGHT", 2, -2)
			else
				menu:SetPoint("BOTTOMLEFT", main, "TOPRIGHT", 2, 2);
			end
		end
	end
end);

local function hook_dwchat()
	-- local dw = LibStub('AceAddon-3.0'):GetAddon('DuowanChat'):GetModule("CHATFRAME");
	if DWCPullButton then
		main:ClearAllPoints();
		main:SetPoint("LEFT", DWCPullButton, "RIGHT", 1, 0);
	end
end

local _EventHandler = CreateFrame("FRAME");
local function OnEvent(self, event, arg1)
	if event == "LOADING_SCREEN_DISABLED" then
		local inInstance, instanceType
				= IsInInstance();
		if inInstance and instanceType == 'party' then
			local name, instanceType, difficultyID, difficultyName, maxPlayers, dynamicDifficulty, isDynamic, instanceID, instanceGroupSize, LfgDungeonID
					= GetInstanceInfo();
			current = data[instanceID];
			if current ~= nil then
				main:Show();
				update();
			else
				main:Hide();
			end
		else
			main:Hide();
		end
	elseif event == "ADDON_LOADED" and arg1 == "DuowanChat" then
		hook_dwchat();
		_EventHandler:UnregisterEvent("ADDON_LOADED");
	end
end
_EventHandler:SetScript("OnEvent", OnEvent);

_EventHandler:RegisterEvent("LOADING_SCREEN_DISABLED");
if IsAddOnLoaded("DuowanChat") then
	hook_dwchat();
else
	_EventHandler:RegisterEvent("ADDON_LOADED");
end

