
--> add to lib stub
local major, minor = "Lib3DModelList", 1
local Lib3DModelList, oldminor = LibStub:NewLibrary (major, minor)

if (not Lib3DModelList) then 
	return 
end

--> put the object on the global scope
_G.Lib3DModelList = Lib3DModelList
local Lib3DModelList = Lib3DModelList

Lib3DModelList.embeds = Lib3DModelList.embeds or {}
local embed_functions = {
	"SelectModel"
}
function Lib3DModelList:Embed (target)
	for k, v in pairs (embed_functions) do
		target[v] = self[v]
	end
	self.embeds [target] = true
	return target
end

--> select model function
function Lib3DModelList:SelectModel (callback, current, use_on_click)

	local opened = {}
	Lib3DModelList.callback = callback

	if (not Lib3DModelList.SelectWindow) then
	
		--> create the main frame
		Lib3DModelList.SelectWindow = CreateFrame ("frame", "Lib3DModelListSelectWindow", UIParent, "ButtonFrameTemplate")
		local f = Lib3DModelList.SelectWindow
		
		--> set size, title and portrait
		f.portrait:SetTexture ([[Interface\CHARACTERFRAME\TEMPORARYPORTRAIT-FEMALE-BLOODELF]])
		f.TitleText:SetText ("Model Viewer")
		f:SetSize (800, 350)
		
		--> drag scripts
		f:SetMovable (true)
		f:EnableMouse (true)
		tinsert (UISpecialFrames, "Lib3DModelListSelectWindow")
		Lib3DModelList.SelectWindow:SetFrameStrata ("FULLSCREEN")
		f:SetPoint ("center", UIParent, "center")
		
		f:SetScript ("OnMouseDown", function (self, button)
			if (button == "LeftButton" and not self.isMoving) then
				self:StartMoving()
				self.isMoving = true
			elseif (button == "RightButton") then
				if (not self.isMoving) then
					self:Hide()
				end
			end
		end)
		
		f:SetScript ("OnMouseUp", function (self, button)
			if (button == "LeftButton" and self.isMoving) then
				self:StopMovingOrSizing()
				self.isMoving = false
			end
		end)

		--> model path label
		local model_path_label = f:CreateFontString (nil, "overlay", "GameFontHighlight")
		model_path_label:SetPoint ("bottomleft", f, "bottomleft", 10, 9)
		model_path_label:SetTextColor (1, .8, 0)
		
		--> model viewer frame
		local m = CreateFrame ("playermodel", "Lib3DModelListSelectWindowModelViewer", f, "ModelWithControlsTemplate")
		m:SetSize (500, 250)
		m:SetPoint ("bottomleft", f, "bottomleft", 10, 32)
		m:SetModel ([[World/EXPANSION02/DOODADS/Coldarra/COLDARRALOCUS.m2]])
		m:EnableMouse (true)
		m:EnableMouseWheel (true)
		m.cur_model = "COLDARRALOCUS.m2"
		f.ModelBox = m
	
		--> use button
		local use_button = CreateFrame ("button", "Lib3DModelListUse", f, "OptionsButtonTemplate")
		use_button:SetPoint ("bottomright", f, "bottomright", -10, 4)
		use_button:SetText ("Use")
		use_button:SetScript ("OnClick", function (self)
			local success, _error = pcall (Lib3DModelList.callback, Lib3DModelList.current_model)
			if (not success) then
				print ("error:", _error)
			end
		end)
	
		--> build folder list
		local folder_scroll = CreateFrame ("scrollframe", "Lib3DModelListFolderBox", f, "FauxScrollFrameTemplate")
		folder_scroll:SetPoint ("bottomright", f, "bottomright", -36, 32)
		folder_scroll:SetSize (256, 250)
		folder_scroll:SetBackdrop ({bgFile = "Interface\\AddOns\\Details\\images\\background", tile = true, tileSize = 16,
		insets = {left = 0, right = 0, top = 0, bottom = 0}})
		folder_scroll:SetBackdropColor (.1, .1, .1, .2)
		Lib3DModelList.folder_scroll = folder_scroll
		
		local folder_buttons = {}
		local cur_deep = 0
		
		local button_click = function (self)

			local deep = self.deep
			local index = self.index
			local folder = self.isFolder
			local already_expanded = self.isExpanded
			
			if (not folder and deep < cur_deep) then
				for i = #opened, deep, -1 do
					opened [i] = nil
				end
				Lib3DModelList.LastListBuilt = nil
				Lib3DModelList:RefreshFolders()
			end
			
			if (folder) then
				if (already_expanded) then
					for i = #opened, deep, -1 do
						opened [i] = nil
					end
				else
					if (deep > 1) then
						for i = #opened, deep+1, -1 do
							opened [i] = nil
						end
						opened [deep] = index
					else
						table.wipe (opened)
						opened [1] = index
					end
				end
				Lib3DModelList.LastListBuilt = nil
				Lib3DModelList:RefreshFolders()
			else
				--> is a model
				local path = ""
				local t
				
				for i = 1, #opened do
				
					local index = opened[i]
					
					if (not t) then
						local object = Lib3DModelList.ModelList [index]
						path = path .. object.N .. "\\"
						t = object.T
					else
						t = t [index]
						path = path .. t.N .. "\\"
						t = t.T
					end
				end
				
				path = path .. self.isModel
				model_path_label:SetText ("Path: " .. path)
				
				Lib3DModelList.current_model = path
				
				if (use_on_click) then
					local success, _error = pcall (Lib3DModelList.callback, path)
					if (not success) then
						print ("error:", _error)
					end
				end
				
				m:SetModel (path)
				m.cur_model = self.isModel
				
				if (Lib3DModelList.last_button_clicked) then
					Lib3DModelList.last_button_clicked.text:SetTextColor (1, 1, 1)
					Lib3DModelList.last_button_clicked.selected = nil
				end
				self.text:SetTextColor (.2, 1, .2)
				self.selected = true
				Lib3DModelList.last_button_clicked = self
			end
			
			cur_deep = deep
		end
		
		local on_enter = function (self)
			self.text:SetTextColor (1, 0.8, 0)
		end
		local on_leave = function (self)
			if (self.selected) then
				self.text:SetTextColor (.2, 1, .2)
			else
				self.text:SetTextColor (1, 1, 1)
			end
		end
		
		for index = 1, 19 do
			local b = CreateFrame ("button", "Lib3DModelListFolderBoxButton" .. index, f)
			b:SetSize (200, 13)
			b:SetScript ("OnClick", button_click)
			b:SetScript ("OnEnter", on_enter)
			b:SetScript ("OnLeave", on_leave)
			tinsert (folder_buttons, b)
			
			local text = b:CreateFontString (nil, "overlay", "GameFontHighlightSmall")
			text:SetPoint ("left", b, "left", 20, 0)
			text:SetText ("button " .. index)
			b.text = text
			
			local texture = b:CreateTexture (nil, "overlay")
			texture:SetPoint ("left", b, "left", 2, 0)
			texture:SetSize (13, 13)
			texture:SetTexture ([[Interface\Buttons\UI-AttributeButton-Encourage-Up]])

			b.texture = texture
		
			local h = (index-1)*13*-1
			b:SetPoint ("topleft", folder_scroll, "topleft", 10, h)
			b.point = h
			--b:SetBackdrop ({bgFile = "Interface\\AddOns\\Details\\images\\background", tile = true, tileSize = 16,
			--insets = {left = 0, right = 0, top = 0, bottom = 0}})
			--b:SetBackdropColor (1, 1, 1, 1)
		end
		
		local dig = function (list_built, folder, deep, dig)
			for index, object in ipairs (folder.T) do
				if (type (object) == "table") then --is a folder
					if (opened [deep] == index) then
						tinsert (list_built, {object, deep, false, true, index})
						dig (list_built, object, deep+1, dig)
					else
						tinsert (list_built, {object, deep, false, false, index})
					end
					
				elseif (type (object) == "string") then --is a model
					tinsert (list_built, {object, deep, true, false, index})
				end
			end
		end
		
		function Lib3DModelList:RefreshFolders()

			--> create the list
			local list_built
			if (Lib3DModelList.LastListBuilt) then
				list_built = Lib3DModelList.LastListBuilt
			else
				list_built = {}
				for index, folder in ipairs (Lib3DModelList.ModelList) do
					if (opened [1] == index) then
						tinsert (list_built, {folder, 1, false, true, index})
						dig (list_built, folder, 2, dig)
					else
						tinsert (list_built, {folder, 1, false, false, index}) --is not a model and not opened
					end
				end
				
				Lib3DModelList.LastListBuilt = list_built
				Lib3DModelList.last_button_clicked = nil
			end
			
			FauxScrollFrame_Update (folder_scroll, #list_built, 19, 13)
			
			local offset = FauxScrollFrame_GetOffset (folder_scroll)
			
			for i = 1, 19 do 
				local data = list_built [i + offset]
				local button = folder_buttons [i]
				if (data) then
					local name = data [1]
					local deep = data [2]
					local isModel = data [3]
					local isExpanded = data [4]
					local index = data [5]
					
					button:Show()
					button.deep = deep
					button.index = index
					
					local n
					if (type (data [1]) == "table") then
						n = data [1].N
					else
						n = name
					end
					
					button.text:SetText (n)
					button:SetPoint ("topleft", folder_scroll, "topleft", 10*deep, button.point)
					
					if (not isModel) then
						if (isExpanded) then
							button.texture:SetTexture ([[Interface\Buttons\UI-MinusButton-Up]])
							button.isExpanded = true
						else
							button.texture:SetTexture ([[Interface\Buttons\UI-AttributeButton-Encourage-Up]])
							button.isExpanded = nil
						end
						button.isFolder = true
						button.isModel = nil
						button.text:SetTextColor (1, 1, 1)
					else
						button.texture:SetTexture ([[Interface\Buttons\UI-SquareButton-Disabled]])
						button.isExpanded = nil
						button.isFolder = nil
						button.isModel = n
						
						if (m.cur_model == n) then
							button.text:SetTextColor (.2, 1, .2)
							Lib3DModelList.last_button_clicked = button
							button.selected = true
						else
							button.text:SetTextColor (1, 1, 1)
							button.selected = false
						end
					end
				else
					button:Hide()
				end
			end
			
		end
		
		folder_scroll:SetScript ("OnVerticalScroll", function (self, offset) FauxScrollFrame_OnVerticalScroll (self, offset, 13, Lib3DModelList.RefreshFolders) end)
		
	end

	if (current) then
		table.wipe (opened)
		
		local path_parts = {strsplit ("\\", current)}
		local object = Lib3DModelList.ModelList
		
		for pnumber, part in ipairs (path_parts) do
			for i = 1, #object do
				local cobject = object [i]
				
				if (type (cobject) == "string") then
					break
				end
				
				if (cobject.N == part) then
					tinsert (opened, i)
					object = cobject.T
					break
				end
			end
		end
		
		Lib3DModelList.SelectWindow.ModelBox:SetModel (current)
		Lib3DModelList.SelectWindow.ModelBox.cur_model = path_parts [#path_parts]
	end
	
	Lib3DModelList:RefreshFolders()
	
	Lib3DModelList.SelectWindow:Show()
	
end

--> list of all models
Lib3DModelList.ModelList = {
	{
		["T"] = {
			"Abyssal_Maw_CameraFly_01.M2", -- [1]
			"Firelands_Bridge_Camera_01.M2", -- [2]
			"FlyByBloodElf.M2", -- [3]
			"FlyByDeathKnight.M2", -- [4]
			"FlyByDwarf.M2", -- [5]
			"FlyByGateoftheSettingSun.M2", -- [6]
			"FlyByGilneas_Telescope.M2", -- [7]
			"FlyByGnome.M2", -- [8]
			"FlyByGoblin.M2", -- [9]
			"FlyByHuman.M2", -- [10]
			"FlyByPandaren.M2", -- [11]
			"FlyBySunwell5Man.m2", -- [12]
			"FlyByTauren.M2", -- [13]
			"FlyByTroll.M2", -- [14]
			"FlyByWorgen.M2", -- [15]
			"FlyBy_Maelstrom.M2", -- [16]
			"FlyBy_MoguBridge_Collapse.M2", -- [17]
			"FlyBy_MoguBridge_Collapse02.M2", -- [18]
			"FlyBy_MoguSecret_Door.M2", -- [19]
			"FlyBy_MoguSecret_Door02.M2", -- [20]
			"FlybyDraenei.M2", -- [21]
			"FlybyGilneasShort.M2", -- [22]
			"FlybyNightElf.M2", -- [23]
			"FlybyOrc.M2", -- [24]
			"FlybyUndead.M2", -- [25]
			"OrcIntro01.m2", -- [26]
			"OrcIntro02.m2", -- [27]
			"OrcIntro03.m2", -- [28]
			"OrcIntro04.m2", -- [29]
			"OrcIntro05.m2", -- [30]
			"OrcIntro06.m2", -- [31]
			"PalantirOfAzora.m2", -- [32]
			"Scry_cam.m2", -- [33]
		},
		["N"] = "Cameras",
	}, -- [1]
	{
		["T"] = {
			{
				["T"] = {
					{
						["T"] = {
							"BloodElfFemale.M2", -- [1]
						},
						["N"] = "Female",
					}, -- [1]
					{
						["T"] = {
							"BloodElfMale.M2", -- [1]
						},
						["N"] = "Male",
					}, -- [2]
				},
				["N"] = "Bloodelf",
			}, -- [1]
			{
				["T"] = {
					{
						["T"] = {
							"BrokenFemale.m2", -- [1]
						},
						["N"] = "Female",
					}, -- [1]
					{
						["T"] = {
							"BrokenMale.M2", -- [1]
						},
						["N"] = "Male",
					}, -- [2]
				},
				["N"] = "Broken",
			}, -- [2]
			{
				["T"] = {
					{
						["T"] = {
							"DraeneiFemale.M2", -- [1]
							"DraeneiFemale_HD.m2", -- [2]
						},
						["N"] = "Female",
					}, -- [1]
					{
						["T"] = {
							"DraeneiMale.M2", -- [1]
							"DraeneiMale_HD.m2", -- [2]
						},
						["N"] = "Male",
					}, -- [2]
				},
				["N"] = "Draenei",
			}, -- [3]
			{
				["T"] = {
					{
						["T"] = {
							"DwarfFemale.M2", -- [1]
							"DwarfFemale_HD.M2", -- [2]
						},
						["N"] = "Female",
					}, -- [1]
					{
						["T"] = {
							"DwarfMale.M2", -- [1]
							"DwarfMale_HD.M2", -- [2]
						},
						["N"] = "Male",
					}, -- [2]
				},
				["N"] = "Dwarf",
			}, -- [4]
			{
				["T"] = {
					{
						["T"] = {
							"FelOrcFemale.m2", -- [1]
						},
						["N"] = "Female",
					}, -- [1]
					{
						["T"] = {
							"FelOrcMale.M2", -- [1]
							"FelOrcMaleAxe.m2", -- [2]
							"FelOrcMaleSword.m2", -- [3]
						},
						["N"] = "Male",
					}, -- [2]
				},
				["N"] = "Felorc",
			}, -- [5]
			{
				["T"] = {
					{
						["T"] = {
							"ForestTrollMale.M2", -- [1]
						},
						["N"] = "Male",
					}, -- [1]
				},
				["N"] = "Foresttroll",
			}, -- [6]
			{
				["T"] = {
					{
						["T"] = {
							"GnomeFemale.M2", -- [1]
							"GnomeFemale_HD.M2", -- [2]
						},
						["N"] = "Female",
					}, -- [1]
					{
						["T"] = {
							"GnomeMale.M2", -- [1]
							"GnomeMale_HD.M2", -- [2]
						},
						["N"] = "Male",
					}, -- [2]
				},
				["N"] = "Gnome",
			}, -- [7]
			{
				["T"] = {
					{
						["T"] = {
							"GoblinFemale.M2", -- [1]
						},
						["N"] = "Female",
					}, -- [1]
					{
						["T"] = {
							"GoblinMale.M2", -- [1]
						},
						["N"] = "Male",
					}, -- [2]
				},
				["N"] = "Goblin",
			}, -- [8]
			{
				["T"] = {
					{
						["T"] = {
							"HumanFemale.M2", -- [1]
							"HumanFemale_HD.m2", -- [2]
						},
						["N"] = "Female",
					}, -- [1]
					{
						["T"] = {
							"HumanMale.M2", -- [1]
							"HumanMaleTransform_HD.m2", -- [2]
							"HumanMale_HD.m2", -- [3]
						},
						["N"] = "Male",
					}, -- [2]
				},
				["N"] = "Human",
			}, -- [9]
			{
				["T"] = {
					{
						["T"] = {
							"IceTrollMale.M2", -- [1]
						},
						["N"] = "Male",
					}, -- [1]
				},
				["N"] = "Icetroll",
			}, -- [10]
			{
				["T"] = {
					{
						["T"] = {
							"Naga_Female.M2", -- [1]
						},
						["N"] = "Female",
					}, -- [1]
					{
						["T"] = {
							"Naga_Male.M2", -- [1]
						},
						["N"] = "Male",
					}, -- [2]
				},
				["N"] = "Naga_",
			}, -- [11]
			{
				["T"] = {
					{
						["T"] = {
							"NightElfFemale.M2", -- [1]
							"NightElfFemale_HD.M2", -- [2]
						},
						["N"] = "Female",
					}, -- [1]
					{
						["T"] = {
							"NightElfMale.M2", -- [1]
							"NightElfMale_HD.m2", -- [2]
						},
						["N"] = "Male",
					}, -- [2]
				},
				["N"] = "Nightelf",
			}, -- [12]
			{
				["T"] = {
					{
						["T"] = {
							"NorthrendSkeletonMale.M2", -- [1]
						},
						["N"] = "Male",
					}, -- [1]
				},
				["N"] = "Northrendskeleton",
			}, -- [13]
			{
				["T"] = {
					{
						["T"] = {
							"OrcFemale.M2", -- [1]
							"OrcFemale_HD.M2", -- [2]
						},
						["N"] = "Female",
					}, -- [1]
					{
						["T"] = {
							"OrcMale.M2", -- [1]
							"OrcMale_HD.M2", -- [2]
						},
						["N"] = "Male",
					}, -- [2]
				},
				["N"] = "Orc",
			}, -- [14]
			{
				["T"] = {
					"OrcFemale_HD_Shadowmoon.m2", -- [1]
				},
				["N"] = "Orcfemaleshadowmoon",
			}, -- [15]
			{
				["T"] = {
					"OrcMale_HD_Shadowmoon.m2", -- [1]
				},
				["N"] = "Orcmaleshadowmoon",
			}, -- [16]
			{
				["T"] = {
					{
						["T"] = {
							"PandarenFemale.M2", -- [1]
						},
						["N"] = "Female",
					}, -- [1]
					{
						["T"] = {
							"PandarenMale.M2", -- [1]
						},
						["N"] = "Male",
					}, -- [2]
				},
				["N"] = "Pandaren",
			}, -- [17]
			{
				["T"] = {
					{
						["T"] = {
							"ScourgeFemale.M2", -- [1]
							"ScourgeFemale_HD.m2", -- [2]
						},
						["N"] = "Female",
					}, -- [1]
					{
						["T"] = {
							"ScourgeMale.M2", -- [1]
							"ScourgeMale_HD.m2", -- [2]
						},
						["N"] = "Male",
					}, -- [2]
				},
				["N"] = "Scourge",
			}, -- [18]
			{
				["T"] = {
					{
						["T"] = {
							"SkeletonFemale.m2", -- [1]
						},
						["N"] = "Female",
					}, -- [1]
					{
						["T"] = {
							"SkeletonMale.m2", -- [1]
						},
						["N"] = "Male",
					}, -- [2]
				},
				["N"] = "Skeleton",
			}, -- [19]
			{
				["T"] = {
					{
						["T"] = {
							"TaunkaMale.M2", -- [1]
						},
						["N"] = "Male",
					}, -- [1]
				},
				["N"] = "Taunka",
			}, -- [20]
			{
				["T"] = {
					{
						["T"] = {
							"TaurenFemale.M2", -- [1]
							"TaurenFemale_HD.m2", -- [2]
						},
						["N"] = "Female",
					}, -- [1]
					{
						["T"] = {
							"TaurenMale.M2", -- [1]
							"TaurenMale_HD.M2", -- [2]
						},
						["N"] = "Male",
					}, -- [2]
				},
				["N"] = "Tauren",
			}, -- [21]
			{
				["T"] = {
					{
						["T"] = {
							"TrollFemale.M2", -- [1]
							"TrollFemale_HD.m2", -- [2]
						},
						["N"] = "Female",
					}, -- [1]
					{
						["T"] = {
							"TrollMale.M2", -- [1]
							"TrollMale_HD.m2", -- [2]
						},
						["N"] = "Male",
					}, -- [2]
				},
				["N"] = "Troll",
			}, -- [22]
			{
				["T"] = {
					{
						["T"] = {
							"TuskarrMale.m2", -- [1]
						},
						["N"] = "Male",
					}, -- [1]
				},
				["N"] = "Tuskarr",
			}, -- [23]
			{
				["T"] = {
					{
						["T"] = {
							"VrykulMale.M2", -- [1]
						},
						["N"] = "Male",
					}, -- [1]
				},
				["N"] = "Vrykul",
			}, -- [24]
			{
				["T"] = {
					{
						["T"] = {
							"WorgenFemale.M2", -- [1]
						},
						["N"] = "Female",
					}, -- [1]
					{
						["T"] = {
							"WorgenMale.M2", -- [1]
						},
						["N"] = "Male",
					}, -- [2]
				},
				["N"] = "Worgen",
			}, -- [25]
		},
		["N"] = "Character",
	}, -- [2]
	{
		["T"] = {
			{
				["T"] = {
					"Abyssal_Illidan.m2", -- [1]
				},
				["N"] = "Abyssalillidan",
			}, -- [1]
			{
				["T"] = {
					"Abyssal_Outland.M2", -- [1]
					"Abyssal_Outland_Green.M2", -- [2]
				},
				["N"] = "Abyssaloutland",
			}, -- [2]
			{
				["T"] = {
					"Agronn.m2", -- [1]
				},
				["N"] = "Agronn",
			}, -- [3]
			{
				["T"] = {
					"AirElemental.M2", -- [1]
				},
				["N"] = "Airelemental",
			}, -- [4]
			{
				["T"] = {
					"AirSpiritSmall.M2", -- [1]
					"AirSpiritSmallLesser.M2", -- [2]
				},
				["N"] = "Airspiritsmall",
			}, -- [5]
			{
				["T"] = {
					"Akama.m2", -- [1]
				},
				["N"] = "Akama",
			}, -- [6]
			{
				["T"] = {
					"AlAkir.M2", -- [1]
				},
				["N"] = "Alakir",
			}, -- [7]
			{
				["T"] = {
					"Alexstrasza.M2", -- [1]
					"LadyAlexstrasa.m2", -- [2]
					"LadyAlexstrasa2.M2", -- [3]
				},
				["N"] = "Alexstrasza",
			}, -- [8]
			{
				["T"] = {
					"AlgalontheObserver.M2", -- [1]
				},
				["N"] = "Alglontheobserver",
			}, -- [9]
			{
				["T"] = {
					"AllianceBomb.m2", -- [1]
				},
				["N"] = "Alliancebomb",
			}, -- [10]
			{
				["T"] = {
					"AllianceBrassCannon.M2", -- [1]
					"AllianceBrassCannon_Flat.M2", -- [2]
				},
				["N"] = "Alliancebrasscannon",
			}, -- [11]
			{
				["T"] = {
					"AllianceChopper.m2", -- [1]
				},
				["N"] = "Alliancechopper",
			}, -- [12]
			{
				["T"] = {
					"AllianceGarrisonTank.m2", -- [1]
					"AllianceGarrisonTank_Small.m2", -- [2]
				},
				["N"] = "Alliancegarrisontank",
			}, -- [13]
			{
				["T"] = {
					"AllianceLion.M2", -- [1]
				},
				["N"] = "Alliancelionmount",
			}, -- [14]
			{
				["T"] = {
					"AlliancePVPMount.M2", -- [1]
				},
				["N"] = "Alliancepvpmount",
			}, -- [15]
			{
				["T"] = {
					"AllianceRider.m2", -- [1]
				},
				["N"] = "Alliancerider",
			}, -- [16]
			{
				["T"] = {
					"Ammunae.M2", -- [1]
				},
				["N"] = "Ammunae",
			}, -- [17]
			{
				["T"] = {
					"AncientofArcane.M2", -- [1]
				},
				["N"] = "Ancientofarcane",
			}, -- [18]
			{
				["T"] = {
					"AncientofLore.M2", -- [1]
				},
				["N"] = "Ancientoflore",
			}, -- [19]
			{
				["T"] = {
					"AncientofWar.M2", -- [1]
				},
				["N"] = "Ancientofwar",
			}, -- [20]
			{
				["T"] = {
					"AncientProtector.M2", -- [1]
				},
				["N"] = "Ancientprotector",
			}, -- [21]
			{
				["T"] = {
					"AncientProtectorPetFall.M2", -- [1]
					"AncientProtectorPetSpring.M2", -- [2]
					"AncientProtectorPetSummer.M2", -- [3]
					"AncientProtectorPetWinter.M2", -- [4]
				},
				["N"] = "Ancientprotector_pet",
			}, -- [22]
			{
				["T"] = {
					"AncientProtectorCrystalSong.M2", -- [1]
				},
				["N"] = "Ancientprotectorcrystalsong",
			}, -- [23]
			{
				["T"] = {
					"AncientSeaTurtle.M2", -- [1]
				},
				["N"] = "Ancientseaturtle",
			}, -- [24]
			{
				["T"] = {
					"AncientSeaTurtleFire.M2", -- [1]
				},
				["N"] = "Ancientseaturtlefire",
			}, -- [25]
			{
				["T"] = {
					"Anduin.M2", -- [1]
				},
				["N"] = "Anduin",
			}, -- [26]
			{
				["T"] = {
					"AnjiAutumnlight_bake_01.M2", -- [1]
				},
				["N"] = "Anjiautumnlight_bake_01",
			}, -- [27]
			{
				["T"] = {
					"Anubisath.M2", -- [1]
				},
				["N"] = "Anubisath",
			}, -- [28]
			{
				["T"] = {
					"PA_Apprentice_SousChef.M2", -- [1]
				},
				["N"] = "Apprentice_souschef",
			}, -- [29]
			{
				["T"] = {
					"Arakkoa.m2", -- [1]
					"Arakkoa_Sage.M2", -- [2]
					"Arakkoa_Warrior.m2", -- [3]
				},
				["N"] = "Arakkoa",
			}, -- [30]
			{
				["T"] = {
					"Arakkoa2.m2", -- [1]
				},
				["N"] = "Arakkoa2",
			}, -- [31]
			{
				["T"] = {
					"ArakkoaGolem.m2", -- [1]
				},
				["N"] = "Arakkoagolem",
			}, -- [32]
			{
				["T"] = {
					"ArakkoaOutland.m2", -- [1]
				},
				["N"] = "Arakkoaoutland",
			}, -- [33]
			{
				["T"] = {
					"ArcaneGolem.M2", -- [1]
					"ArcaneGolemBroken.M2", -- [2]
				},
				["N"] = "Arcanegolem",
			}, -- [34]
			{
				["T"] = {
					"ArcaneTitan.M2", -- [1]
				},
				["N"] = "Arcanetitan",
			}, -- [35]
			{
				["T"] = {
					"ArcaneVoidWraith.M2", -- [1]
					"arcanevoidwraith_low.m2", -- [2]
				},
				["N"] = "Arcanevoidwraith",
			}, -- [36]
			{
				["T"] = {
					"ArcticCondor.M2", -- [1]
				},
				["N"] = "Arcticcondor",
			}, -- [37]
			{
				["T"] = {
					"Armadillo.M2", -- [1]
				},
				["N"] = "Armadillo",
			}, -- [38]
			{
				["T"] = {
					"Arthas.M2", -- [1]
				},
				["N"] = "Arthas",
			}, -- [39]
			{
				["T"] = {
					"ArthasLichKing.M2", -- [1]
					"ArthasLichKing_Unarmed.M2", -- [2]
				},
				["N"] = "Arthaslichking",
			}, -- [40]
			{
				["T"] = {
					"ArthasUndead.m2", -- [1]
				},
				["N"] = "Arthasundead",
			}, -- [41]
			{
				["T"] = {
					"AvengingAngel.M2", -- [1]
				},
				["N"] = "Avengingangel",
			}, -- [42]
			{
				["T"] = {
					"Azshara.M2", -- [1]
				},
				["N"] = "Azshara",
			}, -- [43]
			{
				["T"] = {
					"BabyBeholder.M2", -- [1]
				},
				["N"] = "Babybeholder",
			}, -- [44]
			{
				["T"] = {
					"BabyCrocodile.M2", -- [1]
				},
				["N"] = "Babycrocodile",
			}, -- [45]
			{
				["T"] = {
					"BabyElekk.m2", -- [1]
				},
				["N"] = "Babyelekk",
			}, -- [46]
			{
				["T"] = {
					"babyhawkstrider.m2", -- [1]
				},
				["N"] = "Babyhawkstrider",
			}, -- [47]
			{
				["T"] = {
					"BabyHippo.M2", -- [1]
				},
				["N"] = "Babyhippo",
			}, -- [48]
			{
				["T"] = {
					"BabyLich.M2", -- [1]
				},
				["N"] = "Babylich",
			}, -- [49]
			{
				["T"] = {
					"BabyMoonkin_NE.M2", -- [1]
					"BabyMoonkin_TA.M2", -- [2]
				},
				["N"] = "Babymoonkin",
			}, -- [50]
			{
				["T"] = {
					"BabyRagnoros.M2", -- [1]
				},
				["N"] = "Babyragnoros",
			}, -- [51]
			{
				["T"] = {
					"BabyThunderCrocodile.M2", -- [1]
				},
				["N"] = "Babythundercrocodile",
			}, -- [52]
			{
				["T"] = {
					"BabyTriceratops.M2", -- [1]
				},
				["N"] = "Babytriceratops",
			}, -- [53]
			{
				["T"] = {
					"Creature_Balloon_01.M2", -- [1]
				},
				["N"] = "Balloon",
			}, -- [54]
			{
				["T"] = {
					"BandTaurenMale.M2", -- [1]
					"BandTrollMale.M2", -- [2]
					"Band_DrumSet.M2", -- [3]
					"bandBloodElfMale.m2", -- [4]
					"bandOrcMale.m2", -- [5]
					"bandUndeadMale.m2", -- [6]
				},
				["N"] = "Band",
			}, -- [55]
			{
				["T"] = {
					"Baneling.M2", -- [1]
				},
				["N"] = "Banelingpet",
			}, -- [56]
			{
				["T"] = {
					"Banshee.M2", -- [1]
				},
				["N"] = "Banshee",
			}, -- [57]
			{
				["T"] = {
					"Basilisk.M2", -- [1]
				},
				["N"] = "Basilisk",
			}, -- [58]
			{
				["T"] = {
					"Basilisk_Outland.M2", -- [1]
				},
				["N"] = "Basiliskoutland",
			}, -- [59]
			{
				["T"] = {
					"Bat.M2", -- [1]
					"BatMount.M2", -- [2]
					"EpicBatMount.M2", -- [3]
				},
				["N"] = "Bat",
			}, -- [60]
			{
				["T"] = {
					"Bear.M2", -- [1]
					"PolarBearCub.M2", -- [2]
					"SpectralBear.m2", -- [3]
				},
				["N"] = "Bear",
			}, -- [61]
			{
				["T"] = {
					"BearCub.M2", -- [1]
					"MechanicalBearCub.M2", -- [2]
				},
				["N"] = "Bearcub",
			}, -- [62]
			{
				["T"] = {
					"beargod.M2", -- [1]
				},
				["N"] = "Beargod",
			}, -- [63]
			{
				["T"] = {
					"BearMount.M2", -- [1]
				},
				["N"] = "Bearmount",
			}, -- [64]
			{
				["T"] = {
					"BearMountALT.M2", -- [1]
					"BearMountALT_DarkmoonFaire.M2", -- [2]
				},
				["N"] = "Bearmountalt",
			}, -- [65]
			{
				["T"] = {
					"Beaver.M2", -- [1]
				},
				["N"] = "Beaver",
			}, -- [66]
			{
				["T"] = {
					"Beholder.M2", -- [1]
				},
				["N"] = "Beholder",
			}, -- [67]
			{
				["T"] = {
					"BeholderEye.M2", -- [1]
				},
				["N"] = "Beholdereye",
			}, -- [68]
			{
				["T"] = {
					"Blackhand.M2", -- [1]
				},
				["N"] = "Blackhand",
			}, -- [69]
			{
				["T"] = {
					"BlackHole.M2", -- [1]
				},
				["N"] = "Blackhole",
			}, -- [70]
			{
				["T"] = {
					"BlackrockBrute_Dark.m2", -- [1]
					"BlackrockBrute_Pale.m2", -- [2]
				},
				["N"] = "Blackrockbrute",
			}, -- [71]
			{
				["T"] = {
					"Blingtron.m2", -- [1]
				},
				["N"] = "Blingtron",
			}, -- [72]
			{
				["T"] = {
					"BloodelfFemaleKid.m2", -- [1]
				},
				["N"] = "Bloodelffemalekid",
			}, -- [73]
			{
				["T"] = {
					"BloodElfMale_Guard.m2", -- [1]
				},
				["N"] = "Bloodelfguard",
			}, -- [74]
			{
				["T"] = {
					"BloodelfMaleKid.m2", -- [1]
				},
				["N"] = "Bloodelfmalekid",
			}, -- [75]
			{
				["T"] = {
					"BloodGolem.M2", -- [1]
					"BloodGolem_LOW.M2", -- [2]
				},
				["N"] = "Bloodgolem",
			}, -- [76]
			{
				["T"] = {
					"BloodQueen.M2", -- [1]
				},
				["N"] = "Bloodqueen",
			}, -- [77]
			{
				["T"] = {
					"Boar.M2", -- [1]
					"BoarTruesilver.m2", -- [2]
				},
				["N"] = "Boar",
			}, -- [78]
			{
				["T"] = {
					"BodyofKathune.M2", -- [1]
				},
				["N"] = "Bodyofkathune",
			}, -- [79]
			{
				["T"] = {
					"BogBeast.M2", -- [1]
				},
				["N"] = "Bogbeast",
			}, -- [80]
			{
				["T"] = {
					"BoneGolem.M2", -- [1]
				},
				["N"] = "Bonegolem",
			}, -- [81]
			{
				["T"] = {
					"BoneGuard.M2", -- [1]
					"BoneGuardRock.M2", -- [2]
				},
				["N"] = "Boneguard",
			}, -- [82]
			{
				["T"] = {
					"BoneSpider.m2", -- [1]
				},
				["N"] = "Bonespider",
			}, -- [83]
			{
				["T"] = {
					"Boneworm.M2", -- [1]
				},
				["N"] = "Boneworm",
			}, -- [84]
			{
				["T"] = {
					"Botani.m2", -- [1]
				},
				["N"] = "Botani",
			}, -- [85]
			{
				["T"] = {
					"BoulderGiant.M2", -- [1]
				},
				["N"] = "Bouldergiant",
			}, -- [86]
			{
				["T"] = {
					"BoundAirElemental.M2", -- [1]
					"UnboundAirElemental.M2", -- [2]
					"UnboundAirElementalLord.M2", -- [3]
				},
				["N"] = "Boundairelemental",
			}, -- [87]
			{
				["T"] = {
					"BoundEarthElemental.M2", -- [1]
					"UnboundEarthElemental.M2", -- [2]
					"UnboundEarthElementalLord.M2", -- [3]
					"UnboundEarthElementalLord_NoParticles.M2", -- [4]
				},
				["N"] = "Boundearthelemental",
			}, -- [88]
			{
				["T"] = {
					"BoundFireElemental.M2", -- [1]
					"UnboundFireElemental.M2", -- [2]
					"UnboundFireElementalLord.M2", -- [3]
				},
				["N"] = "Boundfireelemental",
			}, -- [89]
			{
				["T"] = {
					"BoundWaterElemental.M2", -- [1]
					"UnboundWaterElemental.M2", -- [2]
				},
				["N"] = "Boundwaterelemental",
			}, -- [90]
			{
				["T"] = {
					"BE_Broom01.M2", -- [1]
				},
				["N"] = "Broom",
			}, -- [91]
			{
				["T"] = {
					"BroomMount.M2", -- [1]
				},
				["N"] = "Broommount",
			}, -- [92]
			{
				["T"] = {
					"Brutallus.M2", -- [1]
				},
				["N"] = "Brutallus",
			}, -- [93]
			{
				["T"] = {
					"Bubble_Creature.M2", -- [1]
				},
				["N"] = "Bubble_creature",
			}, -- [94]
			{
				["T"] = {
					"BushChicken.M2", -- [1]
				},
				["N"] = "Bushchicken",
			}, -- [95]
			{
				["T"] = {
					"Camel.M2", -- [1]
					"CamelMount.M2", -- [2]
				},
				["N"] = "Camel",
			}, -- [96]
			{
				["T"] = {
					"CarrionBird.M2", -- [1]
				},
				["N"] = "Carrionbird",
			}, -- [97]
			{
				["T"] = {
					"CarrionBirdOutland.M2", -- [1]
				},
				["N"] = "Carrionbirdoutland",
			}, -- [98]
			{
				["T"] = {
					"CarrionWorm.m2", -- [1]
				},
				["N"] = "Carrionworm",
			}, -- [99]
			{
				["T"] = {
					"Cat.M2", -- [1]
					"Cat_HallowsEnd.M2", -- [2]
					"SpectralCat.m2", -- [3]
				},
				["N"] = "Cat",
			}, -- [100]
			{
				["T"] = {
					"CataclysmCrocodile.M2", -- [1]
				},
				["N"] = "Cataclysmcrocodile",
			}, -- [101]
			{
				["T"] = {
					"CatapultBall01_Creature.M2", -- [1]
				},
				["N"] = "Catapultball",
			}, -- [102]
			{
				["T"] = {
					"CelestialDragonWyrm.M2", -- [1]
				},
				["N"] = "Celestialdragonwyrm",
			}, -- [103]
			{
				["T"] = {
					"CelestialHorse.M2", -- [1]
					"CelestialHorse_NonFlying.M2", -- [2]
				},
				["N"] = "Celestialhorse",
			}, -- [104]
			{
				["T"] = {
					"CelestialHuman.M2", -- [1]
				},
				["N"] = "Celestialhuman",
			}, -- [105]
			{
				["T"] = {
					"CelestialSerpent.M2", -- [1]
					"CelestialSerpentMount.M2", -- [2]
				},
				["N"] = "Celestialserpent",
			}, -- [106]
			{
				["T"] = {
					"Cenarius.M2", -- [1]
				},
				["N"] = "Cenarius",
			}, -- [107]
			{
				["T"] = {
					"Centaur.M2", -- [1]
					"CentaurCaster.M2", -- [2]
					"CentaurKhan.m2", -- [3]
					"CentaurWarrior.M2", -- [4]
				},
				["N"] = "Centaur",
			}, -- [108]
			{
				["T"] = {
					"ChenStormstout.M2", -- [1]
				},
				["N"] = "Chenstormstout",
			}, -- [109]
			{
				["T"] = {
					"Chicken.M2", -- [1]
				},
				["N"] = "Chicken",
			}, -- [110]
			{
				["T"] = {
					"ChickenMount.M2", -- [1]
					"ChickenMount15.m2", -- [2]
					"ChickenMount35.m2", -- [3]
				},
				["N"] = "Chickenmount",
			}, -- [111]
			{
				["T"] = {
					"Chimera.M2", -- [1]
				},
				["N"] = "Chimera",
			}, -- [112]
			{
				["T"] = {
					"Chimera2.M2", -- [1]
					"Chimera2Taxi.m2", -- [2]
					"Chimera2_low.m2", -- [3]
					"ChromaticChimera.m2", -- [4]
					"IronChimera.M2", -- [5]
					"IronChimeraBall.M2", -- [6]
					"IronChimera_Var.m2", -- [7]
				},
				["N"] = "Chimera2",
			}, -- [113]
			{
				["T"] = {
					"Chimerabeast.M2", -- [1]
					"ChimerabeastBattlePet.m2", -- [2]
				},
				["N"] = "Chimerabeast",
			}, -- [114]
			{
				["T"] = {
					"ChimeraOutland.m2", -- [1]
				},
				["N"] = "Chimeraoutland",
			}, -- [115]
			{
				["T"] = {
					"ChineseDragon.M2", -- [1]
					"JadeChineseDragon.M2", -- [2]
				},
				["N"] = "Chinesedragon",
			}, -- [116]
			{
				["T"] = {
					"ChoGall.M2", -- [1]
					"ChoGall2.m2", -- [2]
					"ChoGallDisciple.M2", -- [3]
				},
				["N"] = "Chogall",
			}, -- [117]
			{
				["T"] = {
					"Chogall_Corrupt.M2", -- [1]
				},
				["N"] = "Chogall_corrupt",
			}, -- [118]
			{
				["T"] = {
					"ChromaticDragonPet.M2", -- [1]
				},
				["N"] = "Chromaticdragonpet",
			}, -- [119]
			{
				["T"] = {
					"ClawofKathune.M2", -- [1]
				},
				["N"] = "Clawofkathune",
			}, -- [120]
			{
				["T"] = {
					"ClefthoofDraenor.M2", -- [1]
					"ClefthoofDraenorMount.M2", -- [2]
					"ClefthoofDraenorPackAnimal.M2", -- [3]
				},
				["N"] = "Clefthoofdraenor",
			}, -- [121]
			{
				["T"] = {
					"CleftHoove.m2", -- [1]
				},
				["N"] = "Clefthoove",
			}, -- [122]
			{
				["T"] = {
					"ClockworkGiant.M2", -- [1]
					"ClockworkGiantHeart.m2", -- [2]
					"ClockworkGiantPet.M2", -- [3]
				},
				["N"] = "Clockworkgiant",
			}, -- [123]
			{
				["T"] = {
					"ClockworkGnome.M2", -- [1]
					"ClockworkGnome_A.M2", -- [2]
					"ClockworkGnome_B.M2", -- [3]
					"ClockworkGnome_C.M2", -- [4]
					"ClockworkGnome_D.M2", -- [5]
				},
				["N"] = "Clockworkgnome",
			}, -- [124]
			{
				["T"] = {
					"ClockworkHorse.M2", -- [1]
				},
				["N"] = "Clockworkhorse",
			}, -- [125]
			{
				["T"] = {
					"CloudSwampGas.M2", -- [1]
					"CloudSwampGas_Shadowmoon_White.M2", -- [2]
					"CloudSwampGas_White_Clickable.M2", -- [3]
				},
				["N"] = "Cloud",
			}, -- [126]
			{
				["T"] = {
					"cloudMount.M2", -- [1]
				},
				["N"] = "Cloudmount",
			}, -- [127]
			{
				["T"] = {
					"CockatriceElite.M2", -- [1]
					"CockatriceMount.M2", -- [2]
				},
				["N"] = "Cockatrice",
			}, -- [128]
			{
				["T"] = {
					"Cockroach.M2", -- [1]
				},
				["N"] = "Cockroach",
			}, -- [129]
			{
				["T"] = {
					"Cocoon.m2", -- [1]
				},
				["N"] = "Cocoon",
			}, -- [130]
			{
				["T"] = {
					"ColdWraith.M2", -- [1]
				},
				["N"] = "Coldwraith",
			}, -- [131]
			{
				["T"] = {
					"cookbotPet.M2", -- [1]
				},
				["N"] = "Cookbotpet",
			}, -- [132]
			{
				["T"] = {
					"CoreHoundMount.m2", -- [1]
					"Corehound2.m2", -- [2]
				},
				["N"] = "Corehound2",
			}, -- [133]
			{
				["T"] = {
					"Corrupted_Deathwing_Missile_Creature.M2", -- [1]
				},
				["N"] = "Corrupted_deathwing_missile",
			}, -- [134]
			{
				["T"] = {
					"CorruptedTentacle.M2", -- [1]
				},
				["N"] = "Corruptedtentacle",
			}, -- [135]
			{
				["T"] = {
					"Cow.M2", -- [1]
				},
				["N"] = "Cow",
			}, -- [136]
			{
				["T"] = {
					"Crab.m2", -- [1]
					"CrabSmall.m2", -- [2]
				},
				["N"] = "Crab",
			}, -- [137]
			{
				["T"] = {
					"CrackElfMale.m2", -- [1]
				},
				["N"] = "Crackelf",
			}, -- [138]
			{
				["T"] = {
					"Crane.M2", -- [1]
					"CraneGod.M2", -- [2]
					"CraneMount.M2", -- [3]
				},
				["N"] = "Crane",
			}, -- [139]
			{
				["T"] = {
					"CraneGodPet.M2", -- [1]
				},
				["N"] = "Cranegodpet",
			}, -- [140]
			{
				["T"] = {
					"CrateCreature.M2", -- [1]
					"CrateCreatureBasic.m2", -- [2]
				},
				["N"] = "Cratecreature",
			}, -- [141]
			{
				["T"] = {
					"Crawler.M2", -- [1]
				},
				["N"] = "Crawler",
			}, -- [142]
			{
				["T"] = {
					"CrawlerElite.M2", -- [1]
				},
				["N"] = "Crawlerelite",
			}, -- [143]
			{
				["T"] = {
					"CrawlingHandPet.M2", -- [1]
				},
				["N"] = "Crawlinghandpet",
			}, -- [144]
			{
				["T"] = {
					"Creature_GrippingHatred.M2", -- [1]
				},
				["N"] = "Creature_grippinghatred",
			}, -- [145]
			{
				["T"] = {
					"Creature_IceCrown_Bonepile_01.M2", -- [1]
				},
				["N"] = "Creature_icecrown_bonepile",
			}, -- [146]
			{
				["T"] = {
					"creature_seesaw.M2", -- [1]
				},
				["N"] = "Creature_seesaw",
			}, -- [147]
			{
				["T"] = {
					"cricket.M2", -- [1]
				},
				["N"] = "Cricket",
			}, -- [148]
			{
				["T"] = {
					"Crocodile.M2", -- [1]
				},
				["N"] = "Crocodile",
			}, -- [149]
			{
				["T"] = {
					"CryptFiend.M2", -- [1]
				},
				["N"] = "Cryptfiend",
			}, -- [150]
			{
				["T"] = {
					"CryptLord.M2", -- [1]
					"CryptLord_Frost.M2", -- [2]
					"CryptLord_Underground.m2", -- [3]
				},
				["N"] = "Cryptlord",
			}, -- [151]
			{
				["T"] = {
					"Crypt_Scarab.M2", -- [1]
				},
				["N"] = "Cryptscarab",
			}, -- [152]
			{
				["T"] = {
					"CrystalDryad.M2", -- [1]
				},
				["N"] = "Crystaldryad",
			}, -- [153]
			{
				["T"] = {
					"CrystalPortal.M2", -- [1]
				},
				["N"] = "Crystalportal",
			}, -- [154]
			{
				["T"] = {
					"CrystalSatyr.M2", -- [1]
				},
				["N"] = "Crystalsatyr",
			}, -- [155]
			{
				["T"] = {
					"Cupid.M2", -- [1]
				},
				["N"] = "Cupid",
			}, -- [156]
			{
				["T"] = {
					"DarkHound.m2", -- [1]
				},
				["N"] = "Darkhound",
			}, -- [157]
			{
				["T"] = {
					"Darkmoon_Eye_Pet.M2", -- [1]
				},
				["N"] = "Darkmoon_eye_pet",
			}, -- [158]
			{
				["T"] = {
					"DarkmoonDireWolfBoss.M2", -- [1]
				},
				["N"] = "Darkmoondirewolfboss",
			}, -- [159]
			{
				["T"] = {
					"DarkOfKnight.M2", -- [1]
				},
				["N"] = "Darkofknight",
			}, -- [160]
			{
				["T"] = {
					"DarkPhoenix.M2", -- [1]
					"DarkPhoenixMount.M2", -- [2]
					"DarkPhoenixMount_Spectral.M2", -- [3]
				},
				["N"] = "Darkphoenix",
			}, -- [161]
			{
				["T"] = {
					"DarkPhoenixPet.M2", -- [1]
					"DarkPhoenixPet_Spectral.M2", -- [2]
				},
				["N"] = "Darkphoenixpet",
			}, -- [162]
			{
				["T"] = {
					"DeathKnightMount.M2", -- [1]
				},
				["N"] = "Deathknightmount",
			}, -- [163]
			{
				["T"] = {
					"Deathwing.M2", -- [1]
					"Deathwing_Backplate_Test01_Creature.M2", -- [2]
					"Deathwing_Backplate_Test02_Creature.M2", -- [3]
					"Deathwing_Backplate_Test03_Creature.M2", -- [4]
				},
				["N"] = "Deathwing",
			}, -- [164]
			{
				["T"] = {
					"DeathwingCorrupted.M2", -- [1]
					"DeathwingCorruptedArmL.M2", -- [2]
					"DeathwingCorruptedArmR.M2", -- [3]
					"DeathwingCorruptedWingArmL.M2", -- [4]
					"DeathwingCorruptedWingArmR.M2", -- [5]
					"SmallDeathwingCorrupted.M2", -- [6]
				},
				["N"] = "Deathwingcorrupted",
			}, -- [165]
			{
				["T"] = {
					"DeathwingCorruptedClaw.M2", -- [1]
					"DeathwingCorruptedClawR.M2", -- [2]
				},
				["N"] = "Deathwingcorruptedclaw",
			}, -- [166]
			{
				["T"] = {
					"DeathwingCorruptedJaw.M2", -- [1]
				},
				["N"] = "Deathwingcorruptedjaw",
			}, -- [167]
			{
				["T"] = {
					"DeathwingCorruptedTail.M2", -- [1]
				},
				["N"] = "Deathwingcorruptedtail",
			}, -- [168]
			{
				["T"] = {
					"DeathwingCorruptedWing.M2", -- [1]
				},
				["N"] = "Deathwingcorruptedwing",
			}, -- [169]
			{
				["T"] = {
					"DeathwingDungeon.M2", -- [1]
				},
				["N"] = "Deathwingdungeon",
			}, -- [170]
			{
				["T"] = {
					"DeathwingElemental.M2", -- [1]
				},
				["N"] = "Deathwingelemental",
			}, -- [171]
			{
				["T"] = {
					"DeathwingHuman.M2", -- [1]
				},
				["N"] = "Deathwinghuman",
			}, -- [172]
			{
				["T"] = {
					"DeepholmGolem.M2", -- [1]
				},
				["N"] = "Deepholmgolem",
			}, -- [173]
			{
				["T"] = {
					"DeepSeaCrab.M2", -- [1]
					"DeepSeaCrab_Ghost.M2", -- [2]
				},
				["N"] = "Deepseacrab",
			}, -- [174]
			{
				["T"] = {
					"DeepSeaTurtle.M2", -- [1]
				},
				["N"] = "Deepseaturtle",
			}, -- [175]
			{
				["T"] = {
					"Deer.M2", -- [1]
				},
				["N"] = "Deer",
			}, -- [176]
			{
				["T"] = {
					"DemolisherCannonball.m2", -- [1]
				},
				["N"] = "Demolishercannonball",
			}, -- [177]
			{
				["T"] = {
					"DemolisherVehicle.M2", -- [1]
				},
				["N"] = "Demolishervehicle",
			}, -- [178]
			{
				["T"] = {
					"Creature_Demoncrystal_03_blue.m2", -- [1]
					"Creature_Demoncrystal_03_fel.m2", -- [2]
					"Creature_Demoncrystal_03_fire.m2", -- [3]
					"Creature_Demoncrystal_03_purple.m2", -- [4]
				},
				["N"] = "Demoncrystal",
			}, -- [179]
			{
				["T"] = {
					"DemonForm.M2", -- [1]
				},
				["N"] = "Demonform",
			}, -- [180]
			{
				["T"] = {
					"DemonHunter.M2", -- [1]
				},
				["N"] = "Demonhunter",
			}, -- [181]
			{
				["T"] = {
					"DiabloFunSized.M2", -- [1]
				},
				["N"] = "Diablo",
			}, -- [182]
			{
				["T"] = {
					"DiabloFetish.M2", -- [1]
				},
				["N"] = "Diablofetish",
			}, -- [183]
			{
				["T"] = {
					"Diemetradon.M2", -- [1]
				},
				["N"] = "Diemetradon",
			}, -- [184]
			{
				["T"] = {
					"DireFurbolg.M2", -- [1]
				},
				["N"] = "Direfurbolg",
			}, -- [185]
			{
				["T"] = {
					"DireWolf.M2", -- [1]
					"PvPRidingDireWolf.M2", -- [2]
					"RidingDireWolf.M2", -- [3]
				},
				["N"] = "Direwolf",
			}, -- [186]
			{
				["T"] = {
					"djinn.M2", -- [1]
				},
				["N"] = "Djinn",
			}, -- [187]
			{
				["T"] = {
					"DoomGuard.M2", -- [1]
					"DoomGuard_Pet.M2", -- [2]
				},
				["N"] = "Doomguard",
			}, -- [188]
			{
				["T"] = {
					"DoomGuardOutland.M2", -- [1]
					"DoomGuardOutland_low.M2", -- [2]
				},
				["N"] = "Doomguardoutland",
			}, -- [189]
			{
				["T"] = {
					"creature_6IH_IronHorde_doubleturret.m2", -- [1]
				},
				["N"] = "Doubleturret",
			}, -- [190]
			{
				["T"] = {
					"DraeneiConstruct.m2", -- [1]
				},
				["N"] = "Draeneiconstruct",
			}, -- [191]
			{
				["T"] = {
					"DraeneiFemaleKid.m2", -- [1]
				},
				["N"] = "Draeneifemalekid",
			}, -- [192]
			{
				["T"] = {
					"DraeneiFemaleLow.m2", -- [1]
				},
				["N"] = "Draeneifemalelow",
			}, -- [193]
			{
				["T"] = {
					"DraeneiMaleKid.m2", -- [1]
				},
				["N"] = "Draeneimalekid",
			}, -- [194]
			{
				["T"] = {
					"DraeneiMaleLow.m2", -- [1]
				},
				["N"] = "Draeneimalelow",
			}, -- [195]
			{
				["T"] = {
					"DraenorAncient.m2", -- [1]
					"DraenorAncientArrak.M2", -- [2]
					"DraenorAncientBasic.M2", -- [3]
					"DraenorAncientGorgrond.M2", -- [4]
					"DraenorAncientShadowmoon.M2", -- [5]
					"DraenorAncientShadowmoonWillow.M2", -- [6]
				},
				["N"] = "Draenorancient",
			}, -- [196]
			{
				["T"] = {
					"DraenorFungalGiant.m2", -- [1]
					"DraenorFungalGiantBoss.m2", -- [2]
				},
				["N"] = "Draenorfungalgiant",
			}, -- [197]
			{
				["T"] = {
					"DraenorKaliri.m2", -- [1]
					"DraenorKaliriSunGod.m2", -- [2]
				},
				["N"] = "Draenorkaliri",
			}, -- [198]
			{
				["T"] = {
					"Dragon.M2", -- [1]
					"DragonAzurgoz.M2", -- [2]
					"DragonNefarian.M2", -- [3]
					"DragonOnyxia.M2", -- [4]
					"Lethon.M2", -- [5]
					"NorthrendDragon.M2", -- [6]
					"OnyxiaMount.M2", -- [7]
					"Taerar.M2", -- [8]
					"Taerar_q.m2", -- [9]
				},
				["N"] = "Dragon",
			}, -- [199]
			{
				["T"] = {
					"DragonAtramedes.M2", -- [1]
				},
				["N"] = "Dragonatramedes",
			}, -- [200]
			{
				["T"] = {
					"DragonChromatic.M2", -- [1]
				},
				["N"] = "Dragonchromatic",
			}, -- [201]
			{
				["T"] = {
					"DragonChromaticMount.M2", -- [1]
				},
				["N"] = "Dragonchromaticmount",
			}, -- [202]
			{
				["T"] = {
					"DragonDarkShade.M2", -- [1]
				},
				["N"] = "Dragondarkshade",
			}, -- [203]
			{
				["T"] = {
					"DragonDeepholm.M2", -- [1]
					"DragonDeepholmMount.M2", -- [2]
				},
				["N"] = "Dragondeepholm",
			}, -- [204]
			{
				["T"] = {
					"Dragonfly.m2", -- [1]
					"DragonflyPet.m2", -- [2]
				},
				["N"] = "Dragonfly",
			}, -- [205]
			{
				["T"] = {
					"DragonFootSoldier.M2", -- [1]
				},
				["N"] = "Dragonfootsoldier",
			}, -- [206]
			{
				["T"] = {
					"DragonFootSoldierDarkshade.M2", -- [1]
				},
				["N"] = "Dragonfootsoldierdarkshade",
			}, -- [207]
			{
				["T"] = {
					"DragonHawk.M2", -- [1]
					"DragonHawkArmorMountAlliance.M2", -- [2]
					"DragonHawkArmorMountHorde.M2", -- [3]
					"DragonHawkMount.M2", -- [4]
				},
				["N"] = "Dragonhawk",
			}, -- [208]
			{
				["T"] = {
					"DragonHawkGod.M2", -- [1]
				},
				["N"] = "Dragonhawkgod",
			}, -- [209]
			{
				["T"] = {
					"DragonKalecgos.M2", -- [1]
					"DragonKalecgos_flightTier.M2", -- [2]
				},
				["N"] = "Dragonkalecgos",
			}, -- [210]
			{
				["T"] = {
					"DragonKite.m2", -- [1]
				},
				["N"] = "Dragonkite",
			}, -- [211]
			{
				["T"] = {
					"DragonMan.M2", -- [1]
					"DragonMan_Var1.M2", -- [2]
				},
				["N"] = "Dragonman",
			}, -- [212]
			{
				["T"] = {
					"DragonManHulk.M2", -- [1]
				},
				["N"] = "Dragonmanhulk",
			}, -- [213]
			{
				["T"] = {
					"DragonNefarianZombified.M2", -- [1]
				},
				["N"] = "Dragonnefarianzombified",
			}, -- [214]
			{
				["T"] = {
					"DragonPrince.M2", -- [1]
					"DragonPrince_BlindFolded.M2", -- [2]
				},
				["N"] = "Dragonprince",
			}, -- [215]
			{
				["T"] = {
					"RedCrystalDragon.M2", -- [1]
					"RedCrystalDragonHologram.M2", -- [2]
				},
				["N"] = "Dragonredcrystal",
			}, -- [216]
			{
				["T"] = {
					"DragonSinestra.M2", -- [1]
					"DragonTarecgosa.M2", -- [2]
				},
				["N"] = "Dragonsinestra",
			}, -- [217]
			{
				["T"] = {
					"DragonSkywall.M2", -- [1]
					"DragonSkywallMount.M2", -- [2]
				},
				["N"] = "Dragonskywall",
			}, -- [218]
			{
				["T"] = {
					"DragonSpawn.M2", -- [1]
					"DragonSpawnArmored.M2", -- [2]
					"DragonSpawnGreater.M2", -- [3]
					"DragonSpawnOverlord.M2", -- [4]
					"DragonSpawnOverlordNexus.M2", -- [5]
					"DragonSpawnTwilight.M2", -- [6]
					"DragonSpawnTwilightArmored.M2", -- [7]
					"DragonSpawnTwilightCaster.M2", -- [8]
					"DragonSpawnTwilightOverlord.M2", -- [9]
				},
				["N"] = "Dragonspawn",
			}, -- [219]
			{
				["T"] = {
					"DragonSpawnArmoredDarkshade.M2", -- [1]
				},
				["N"] = "Dragonspawnarmoreddarkshade",
			}, -- [220]
			{
				["T"] = {
					"DragonSpawnCaster.m2", -- [1]
				},
				["N"] = "Dragonspawncaster",
			}, -- [221]
			{
				["T"] = {
					"DragonSpawnCasterDarkshade.m2", -- [1]
				},
				["N"] = "Dragonspawncasterdarkshade",
			}, -- [222]
			{
				["T"] = {
					"DragonSpawnDarkshade.M2", -- [1]
				},
				["N"] = "Dragonspawndarkshade",
			}, -- [223]
			{
				["T"] = {
					"DragonSpawnArmoredNexus.m2", -- [1]
				},
				["N"] = "Dragonspawnnexus",
			}, -- [224]
			{
				["T"] = {
					"DragonSpawnOverlordDarkshade.M2", -- [1]
				},
				["N"] = "Dragonspawnoverlorddarkshade",
			}, -- [225]
			{
				["T"] = {
					"DragonTurtle.M2", -- [1]
					"DragonTurtleEpic.M2", -- [2]
					"RidingDragonTurtle.M2", -- [3]
					"RidingDragonTurtleEpic.M2", -- [4]
				},
				["N"] = "Dragonturtle",
			}, -- [226]
			{
				["T"] = {
					"DragonWhelp.M2", -- [1]
					"DragonWhelpOnyxia.M2", -- [2]
					"DragonWhelpTarecgosa.M2", -- [3]
				},
				["N"] = "Dragonwhelp",
			}, -- [227]
			{
				["T"] = {
					"DragonWhelpCataclysm.M2", -- [1]
				},
				["N"] = "Dragonwhelpcataclysm",
			}, -- [228]
			{
				["T"] = {
					"DragonWhelpdarkshade.M2", -- [1]
				},
				["N"] = "Dragonwhelpdarkshade",
			}, -- [229]
			{
				["T"] = {
					"DragonWhelpElementium.M2", -- [1]
				},
				["N"] = "Dragonwhelpelementium",
			}, -- [230]
			{
				["T"] = {
					"DragonWhelpOutland.M2", -- [1]
				},
				["N"] = "Dragonwhelpoutland",
			}, -- [231]
			{
				["T"] = {
					"DragonWhelpOutlandCute.M2", -- [1]
				},
				["N"] = "Dragonwhelpoutlandcute",
			}, -- [232]
			{
				["T"] = {
					"Drake.M2", -- [1]
					"NorthrendDrake.M2", -- [2]
					"OrcDrakeRider.M2", -- [3]
				},
				["N"] = "Drake",
			}, -- [233]
			{
				["T"] = {
					"Drakeadon.M2", -- [1]
				},
				["N"] = "Drakeadon",
			}, -- [234]
			{
				["T"] = {
					"DrakeDarkshade.M2", -- [1]
				},
				["N"] = "Drakedarkshade",
			}, -- [235]
			{
				["T"] = {
					"ArmoredTwilightDrake.M2", -- [1]
					"DrakeMount.M2", -- [2]
					"FelDrakeMount.M2", -- [3]
				},
				["N"] = "Drakemount",
			}, -- [236]
			{
				["T"] = {
					"DreadLord.M2", -- [1]
				},
				["N"] = "Dreadlord",
			}, -- [237]
			{
				["T"] = {
					"DreadRavenWarbirdSun.m2", -- [1]
					"DreadRavenWarbirdWind.m2", -- [2]
				},
				["N"] = "Dreadravenwarbird",
			}, -- [238]
			{
				["T"] = {
					"DruidBear.M2", -- [1]
					"DruidBearEpic.M2", -- [2]
					"DruidBearTauren.M2", -- [3]
					"DruidBearTaurenEpic.M2", -- [4]
					"DruidBearTauren_Legacy.m2", -- [5]
					"DruidBear_Legacy.m2", -- [6]
				},
				["N"] = "Druidbear",
			}, -- [239]
			{
				["T"] = {
					"DruidBearTroll.M2", -- [1]
					"DruidBearTrollEpic.M2", -- [2]
				},
				["N"] = "Druidbeartroll",
			}, -- [240]
			{
				["T"] = {
					"DruidBearWorgen.M2", -- [1]
					"DruidBearWorgenEpic.M2", -- [2]
				},
				["N"] = "Druidbearworgen",
			}, -- [241]
			{
				["T"] = {
					"DruidCat.M2", -- [1]
					"DruidCatEpic.M2", -- [2]
					"DruidCat_Legacy.M2", -- [3]
				},
				["N"] = "Druidcat",
			}, -- [242]
			{
				["T"] = {
					"DruidCatTauren.M2", -- [1]
					"DruidCatTaurenEpic.M2", -- [2]
					"DruidCatTauren_Legacy.M2", -- [3]
				},
				["N"] = "Druidcattauren",
			}, -- [243]
			{
				["T"] = {
					"DruidCatTroll.M2", -- [1]
					"DruidCatTrollEpic.M2", -- [2]
				},
				["N"] = "Druidcattroll",
			}, -- [244]
			{
				["T"] = {
					"DruidCatWorgen.M2", -- [1]
					"DruidCatWorgenEpic.M2", -- [2]
				},
				["N"] = "Druidcatworgen",
			}, -- [245]
			{
				["T"] = {
					"DruidOwlBear.M2", -- [1]
					"DruidOwlBearEpic.M2", -- [2]
					"DruidOwlBearTauren.M2", -- [3]
					"DruidOwlBearTaurenEpic.M2", -- [4]
				},
				["N"] = "Druidowlbear",
			}, -- [246]
			{
				["T"] = {
					"DruidTravelAlliance.M2", -- [1]
					"DruidTravelAlliance_low01.M2", -- [2]
				},
				["N"] = "Druidtravelalliance",
			}, -- [247]
			{
				["T"] = {
					"DruidTravelHorde.M2", -- [1]
				},
				["N"] = "Druidtravelhorde",
			}, -- [248]
			{
				["T"] = {
					"DruidTreeForm.M2", -- [1]
				},
				["N"] = "Druidtreeform",
			}, -- [249]
			{
				["T"] = {
					"Dryad.M2", -- [1]
				},
				["N"] = "Dryad",
			}, -- [250]
			{
				["T"] = {
					"Dryder.M2", -- [1]
				},
				["N"] = "Dryder",
			}, -- [251]
			{
				["T"] = {
					"Durotan.M2", -- [1]
				},
				["N"] = "Durotan",
			}, -- [252]
			{
				["T"] = {
					"DwarfMaleWarriorLight.M2", -- [1]
					"DwarfMaleWarriorLight_Ghost.M2", -- [2]
				},
				["N"] = "Dwarfmalewarriorlight",
			}, -- [253]
			{
				["T"] = {
					"eagle.M2", -- [1]
				},
				["N"] = "Eagle",
			}, -- [254]
			{
				["T"] = {
					"EagleGod.M2", -- [1]
				},
				["N"] = "Eaglegod",
			}, -- [255]
			{
				["T"] = {
					"Earthen_Onager_Vehicle.M2", -- [1]
				},
				["N"] = "Earthen_onager_vehicle",
			}, -- [256]
			{
				["T"] = {
					"EarthenDwarf.M2", -- [1]
					"EarthenDwarf_low.M2", -- [2]
				},
				["N"] = "Earthendwarf",
			}, -- [257]
			{
				["T"] = {
					"EarthenFury.m2", -- [1]
					"EarthenFury_Tectus.m2", -- [2]
				},
				["N"] = "Earthenfury",
			}, -- [258]
			{
				["T"] = {
					"EarthSpiritSmall.M2", -- [1]
					"EarthSpiritSmallLesser.M2", -- [2]
				},
				["N"] = "Earthspiritsmall",
			}, -- [259]
			{
				["T"] = {
					"EggCreature.M2", -- [1]
					"EggCreature_white.M2", -- [2]
				},
				["N"] = "Egg",
			}, -- [260]
			{
				["T"] = {
					"Elekk.m2", -- [1]
					"ElekkDraenor.M2", -- [2]
					"ElekkDraenorMount.m2", -- [3]
					"ElekkWild.M2", -- [4]
				},
				["N"] = "Elekk",
			}, -- [261]
			{
				["T"] = {
					"Elekkplushie.m2", -- [1]
				},
				["N"] = "Elekkplushie",
			}, -- [262]
			{
				["T"] = {
					"ElementalEarth.M2", -- [1]
				},
				["N"] = "Elementalearth",
			}, -- [263]
			{
				["T"] = {
					"EliteGryphon.M2", -- [1]
					"EliteGryphonArmored.M2", -- [2]
				},
				["N"] = "Elitegryphon",
			}, -- [264]
			{
				["T"] = {
					"EliteHippogryph.M2", -- [1]
				},
				["N"] = "Elitehippogryph",
			}, -- [265]
			{
				["T"] = {
					"EliteWyvern.M2", -- [1]
					"EliteWyvernArmored.M2", -- [2]
				},
				["N"] = "Elitewyvern",
			}, -- [266]
			{
				["T"] = {
					"Ent.M2", -- [1]
				},
				["N"] = "Ent",
			}, -- [267]
			{
				["T"] = {
					"EpicDruidFlightAlliance.M2", -- [1]
				},
				["N"] = "Epicdruidflightalliance",
			}, -- [268]
			{
				["T"] = {
					"EpicDruidFlightHorde.M2", -- [1]
				},
				["N"] = "Epicdruidflighthorde",
			}, -- [269]
			{
				["T"] = {
					"EpicDruidFlightTroll.M2", -- [1]
				},
				["N"] = "Epicdruidflighttroll",
			}, -- [270]
			{
				["T"] = {
					"EpicDruidFlightWorgen.M2", -- [1]
				},
				["N"] = "Epicdruidflightworgen",
			}, -- [271]
			{
				["T"] = {
					"Archimonde.M2", -- [1]
					"Eredar.m2", -- [2]
				},
				["N"] = "Eredar",
			}, -- [272]
			{
				["T"] = {
					"EredarFemale.M2", -- [1]
				},
				["N"] = "Eredarfemale",
			}, -- [273]
			{
				["T"] = {
					"Etherial.M2", -- [1]
				},
				["N"] = "Etherial",
			}, -- [274]
			{
				["T"] = {
					"EtherialRobe.M2", -- [1]
				},
				["N"] = "Etherialrobe",
			}, -- [275]
			{
				["T"] = {
					"Ettin.M2", -- [1]
					"Throngus.M2", -- [2]
				},
				["N"] = "Ettin",
			}, -- [276]
			{
				["T"] = {
					"EyeofKathune.M2", -- [1]
				},
				["N"] = "Eyeofkathune",
			}, -- [277]
			{
				["T"] = {
					"EyeOfKilrog_Blue_Pet.M2", -- [1]
					"EyeOfKilrog_Pet.M2", -- [2]
				},
				["N"] = "Eyeofkilrog_pet",
			}, -- [278]
			{
				["T"] = {
					"EyeStalkofKathune.M2", -- [1]
				},
				["N"] = "Eyestalkofkathune",
			}, -- [279]
			{
				["T"] = {
					"FacelessGeneral.M2", -- [1]
				},
				["N"] = "Facelessgeneral",
			}, -- [280]
			{
				["T"] = {
					"FacelessMount.M2", -- [1]
				},
				["N"] = "Facelessmount",
			}, -- [281]
			{
				["T"] = {
					"FacelessOne.M2", -- [1]
				},
				["N"] = "Facelessone",
			}, -- [282]
			{
				["T"] = {
					"FacelessOneAquatic.M2", -- [1]
				},
				["N"] = "Facelessoneaquatic",
			}, -- [283]
			{
				["T"] = {
					"FacelessOneCaster.M2", -- [1]
				},
				["N"] = "Facelessonecaster",
			}, -- [284]
			{
				["T"] = {
					"FaerieDragon.M2", -- [1]
					"FaerieDragon_Ghost.M2", -- [2]
				},
				["N"] = "Faeriedragon",
			}, -- [285]
			{
				["T"] = {
					"FaerieDragonCreature.m2", -- [1]
					"FaerieDragonMount.M2", -- [2]
				},
				["N"] = "Faeriedragonmount",
			}, -- [286]
			{
				["T"] = {
					"FandralFireCat.M2", -- [1]
					"FandralFireCatNoArmor.M2", -- [2]
				},
				["N"] = "Fandralfirecat",
			}, -- [287]
			{
				["T"] = {
					"FandralFireScorpion.M2", -- [1]
				},
				["N"] = "Fandralfirescorpion",
			}, -- [288]
			{
				["T"] = {
					"FandralStaghelm.M2", -- [1]
				},
				["N"] = "Fandralstaghelm",
			}, -- [289]
			{
				["T"] = {
					"Fel_abyssal_outland.M2", -- [1]
				},
				["N"] = "Fel_abyssal_outland",
			}, -- [290]
			{
				["T"] = {
					"BatRider.m2", -- [1]
					"BatTaxi.M2", -- [2]
					"FelBat.M2", -- [3]
				},
				["N"] = "Felbat",
			}, -- [291]
			{
				["T"] = {
					"Corehoundpet.M2", -- [1]
					"FelBeast.M2", -- [2]
				},
				["N"] = "Felbeast",
			}, -- [292]
			{
				["T"] = {
					"felbeastshadowmoon.M2", -- [1]
				},
				["N"] = "Felbeastshadowmoon",
			}, -- [293]
			{
				["T"] = {
					"FelBoar.M2", -- [1]
				},
				["N"] = "Felboar",
			}, -- [294]
			{
				["T"] = {
					"FelCannon.M2", -- [1]
					"FelCannon_02.M2", -- [2]
				},
				["N"] = "Felcannon",
			}, -- [295]
			{
				["T"] = {
					"FelElfCasterFemale.M2", -- [1]
				},
				["N"] = "Felelfcasterfemale",
			}, -- [296]
			{
				["T"] = {
					"FelElfCasterMale.M2", -- [1]
				},
				["N"] = "Felelfcastermale",
			}, -- [297]
			{
				["T"] = {
					"FelElfHunterFemale.M2", -- [1]
				},
				["N"] = "Felelfhunterfemale",
			}, -- [298]
			{
				["T"] = {
					"FelElfWarriorMale.M2", -- [1]
				},
				["N"] = "Felelfwarriormale",
			}, -- [299]
			{
				["T"] = {
					"FelGolem.M2", -- [1]
				},
				["N"] = "Felgolem",
			}, -- [300]
			{
				["T"] = {
					"FelGuard.M2", -- [1]
					"FelGuard_low.M2", -- [2]
				},
				["N"] = "Felguard",
			}, -- [301]
			{
				["T"] = {
					"FelHippogryph.M2", -- [1]
					"FelHippogryphMount.M2", -- [2]
				},
				["N"] = "Felhippogryph",
			}, -- [302]
			{
				["T"] = {
					"FelHorseEpic.M2", -- [1]
				},
				["N"] = "Felhorse",
			}, -- [303]
			{
				["T"] = {
					"FelHound.m2", -- [1]
				},
				["N"] = "Felhound",
			}, -- [304]
			{
				["T"] = {
					"FelOrc.m2", -- [1]
					"FelOrc_Axe.m2", -- [2]
					"FelOrc_Sword.m2", -- [3]
				},
				["N"] = "Felorc",
			}, -- [305]
			{
				["T"] = {
					"FelOrcWarriorAxe.m2", -- [1]
				},
				["N"] = "Felorcaxe",
			}, -- [306]
			{
				["T"] = {
					"FelOrcWarriorBoss.M2", -- [1]
				},
				["N"] = "Felorcboss",
			}, -- [307]
			{
				["T"] = {
					"FelOrcDire.M2", -- [1]
				},
				["N"] = "Felorcdire",
			}, -- [308]
			{
				["T"] = {
					"FelOrcNetherDrake.M2", -- [1]
					"FelOrcNetherDrakeMounted.M2", -- [2]
				},
				["N"] = "Felorcnetherdrake",
			}, -- [309]
			{
				["T"] = {
					"FelOrcWarriorSword.m2", -- [1]
				},
				["N"] = "Felorcsword",
			}, -- [310]
			{
				["T"] = {
					"FelOrcWarlord.M2", -- [1]
				},
				["N"] = "Felorcwarlord",
			}, -- [311]
			{
				["T"] = {
					"FelReaver.M2", -- [1]
					"MiniFelReaver.M2", -- [2]
				},
				["N"] = "Felreaver",
			}, -- [312]
			{
				["T"] = {
					"Creature_Fireblock_Shannox.M2", -- [1]
				},
				["N"] = "Fireblock_shannox",
			}, -- [313]
			{
				["T"] = {
					"Creature_Fireblock_Solid.M2", -- [1]
				},
				["N"] = "Fireblock_solid",
			}, -- [314]
			{
				["T"] = {
					"FireDancer.m2", -- [1]
				},
				["N"] = "Firedancer",
			}, -- [315]
			{
				["T"] = {
					"FireElemental.M2", -- [1]
					"FireElemental_fel.m2", -- [2]
				},
				["N"] = "Fireelemental",
			}, -- [316]
			{
				["T"] = {
					"FireElemental_kar.M2", -- [1]
				},
				["N"] = "Fireelemental_kar",
			}, -- [317]
			{
				["T"] = {
					"FireElementalDraenor.m2", -- [1]
				},
				["N"] = "Fireelementaldraenor",
			}, -- [318]
			{
				["T"] = {
					"FireFlyGreen.M2", -- [1]
				},
				["N"] = "Firefly",
			}, -- [319]
			{
				["T"] = {
					"FireHawk_NoArmor.M2", -- [1]
					"Firehawk.M2", -- [2]
					"Firehawk_Mount.M2", -- [3]
				},
				["N"] = "Firehawk",
			}, -- [320]
			{
				["T"] = {
					"FireKitty.M2", -- [1]
				},
				["N"] = "Firekitty",
			}, -- [321]
			{
				["T"] = {
					"FireRavenGodMount.M2", -- [1]
				},
				["N"] = "Fireravengodmount",
			}, -- [322]
			{
				["T"] = {
					"FireSpider.M2", -- [1]
				},
				["N"] = "Firespider",
			}, -- [323]
			{
				["T"] = {
					"FireSpiderBoss.M2", -- [1]
					"FireSpiderBoss_nofx.M2", -- [2]
				},
				["N"] = "Firespiderboss",
			}, -- [324]
			{
				["T"] = {
					"FireSpiritSmall.M2", -- [1]
					"FireSpiritSmallLesser.M2", -- [2]
				},
				["N"] = "Firespiritsmall",
			}, -- [325]
			{
				["T"] = {
					"FireSprite.M2", -- [1]
				},
				["N"] = "Firesprite",
			}, -- [326]
			{
				["T"] = {
					"Fish.m2", -- [1]
					"fish2.m2", -- [2]
					"fish3.m2", -- [3]
					"fish4.m2", -- [4]
				},
				["N"] = "Fish",
			}, -- [327]
			{
				["T"] = {
					"DefenseTurret.M2", -- [1]
					"FlameLeviathan.M2", -- [2]
					"FlameLeviathan_Weapon_Cannon.m2", -- [3]
				},
				["N"] = "Flameleviathan",
			}, -- [328]
			{
				["T"] = {
					"FleshBeast.M2", -- [1]
				},
				["N"] = "Fleshbeast",
			}, -- [329]
			{
				["T"] = {
					"FleshGiant.M2", -- [1]
				},
				["N"] = "Fleshgiant",
			}, -- [330]
			{
				["T"] = {
					"FleshGolem.M2", -- [1]
				},
				["N"] = "Fleshgolem",
			}, -- [331]
			{
				["T"] = {
					"FleshTitan.M2", -- [1]
				},
				["N"] = "Fleshtitan",
			}, -- [332]
			{
				["T"] = {
					"FloatingScroll.M2", -- [1]
				},
				["N"] = "Floatingscroll",
			}, -- [333]
			{
				["T"] = {
					"FlyingBomber_noSmoke.m2", -- [1]
					"Flyingbomber_02noSmoke.m2", -- [2]
					"flyingBomber.m2", -- [3]
					"flyingBomber_02.M2", -- [4]
					"flyingBomber_02closedCanopy.M2", -- [5]
				},
				["N"] = "Flyingbomber",
			}, -- [334]
			{
				["T"] = {
					"FlyingBook_01.M2", -- [1]
					"FlyingBook_01_Pet.M2", -- [2]
					"FlyingBook_02.M2", -- [3]
					"FlyingBook_03.M2", -- [4]
					"FlyingBook_03_Pet.M2", -- [5]
				},
				["N"] = "Flyingbook",
			}, -- [335]
			{
				["T"] = {
					"FlyingCarpetMount.M2", -- [1]
				},
				["N"] = "Flyingcarpetmount",
			}, -- [336]
			{
				["T"] = {
					"FlyingMachineCreature.M2", -- [1]
				},
				["N"] = "Flyingmachinecreature",
			}, -- [337]
			{
				["T"] = {
					"FlyingMachineCreature_Vehicle.M2", -- [1]
				},
				["N"] = "Flyingmachinecreature_vehicle",
			}, -- [338]
			{
				["T"] = {
					"FlyingNerubian.m2", -- [1]
				},
				["N"] = "Flyingnerubian",
			}, -- [339]
			{
				["T"] = {
					"FlyingPanther.M2", -- [1]
				},
				["N"] = "Flyingpanther",
			}, -- [340]
			{
				["T"] = {
					"FlyingReindeer.M2", -- [1]
				},
				["N"] = "Flyingreindeer",
			}, -- [341]
			{
				["T"] = {
					"fogcreature.M2", -- [1]
				},
				["N"] = "Fogcreature",
			}, -- [342]
			{
				["T"] = {
					"Fomor.m2", -- [1]
				},
				["N"] = "Fomor",
			}, -- [343]
			{
				["T"] = {
					"FomorHandLeft.m2", -- [1]
					"FomorHandRight.m2", -- [2]
					"FomorHandRight01.m2", -- [3]
					"FomorHandRight01_plain.m2", -- [4]
					"fomorhandleft01.m2", -- [5]
				},
				["N"] = "Fomorhand",
			}, -- [344]
			{
				["T"] = {
					"FomorSmith.m2", -- [1]
				},
				["N"] = "Fomorsmith",
			}, -- [345]
			{
				["T"] = {
					"ForceofNature.m2", -- [1]
				},
				["N"] = "Forceofnature",
			}, -- [346]
			{
				["T"] = {
					"ForestSprite.M2", -- [1]
					"ForestSprite_low01.M2", -- [2]
					"SpikySprite.M2", -- [3]
				},
				["N"] = "Forestsprite",
			}, -- [347]
			{
				["T"] = {
					"ForestTroll.M2", -- [1]
				},
				["N"] = "Foresttroll",
			}, -- [348]
			{
				["T"] = {
					"ForestTrollCouncilor.M2", -- [1]
				},
				["N"] = "Foresttrollcouncilor",
			}, -- [349]
			{
				["T"] = {
					"ForsakenCatapult.M2", -- [1]
				},
				["N"] = "Forsakencatapult",
			}, -- [350]
			{
				["T"] = {
					"Freia.M2", -- [1]
				},
				["N"] = "Freia",
			}, -- [351]
			{
				["T"] = {
					"Frenzy.m2", -- [1]
				},
				["N"] = "Frenzy",
			}, -- [352]
			{
				["T"] = {
					"ArrowFrog.M2", -- [1]
					"Frog.M2", -- [2]
				},
				["N"] = "Frog",
			}, -- [353]
			{
				["T"] = {
					"FrostLord.M2", -- [1]
					"FrostLordCore.M2", -- [2]
				},
				["N"] = "Frostlord",
			}, -- [354]
			{
				["T"] = {
					"FrostNymph.M2", -- [1]
				},
				["N"] = "Frostnymph",
			}, -- [355]
			{
				["T"] = {
					"FrostSabre.M2", -- [1]
					"PVPRidingFrostSabre.M2", -- [2]
					"RidingFrostSabre.M2", -- [3]
					"SabreCub.M2", -- [4]
				},
				["N"] = "Frostsabre",
			}, -- [356]
			{
				["T"] = {
					"FrostVrykulMale.M2", -- [1]
				},
				["N"] = "Frostvrykulmale",
			}, -- [357]
			{
				["T"] = {
					"FrostWolfPup.M2", -- [1]
					"FrostWolfPup_Fel.m2", -- [2]
					"FrostWolfPup_Fire.m2", -- [3]
					"FrostWolfPup_NoCollar.m2", -- [4]
					"FrostWolfPup_Shadow.m2", -- [5]
				},
				["N"] = "Frostwolfpup",
			}, -- [358]
			{
				["T"] = {
					"FrostWurm.M2", -- [1]
					"FrostWurm_NoFrost.m2", -- [2]
				},
				["N"] = "Frostwurm",
			}, -- [359]
			{
				["T"] = {
					"FrostWurmFellfire.M2", -- [1]
				},
				["N"] = "Frostwurmfellfire",
			}, -- [360]
			{
				["T"] = {
					"FrostWurmNorthrend.M2", -- [1]
				},
				["N"] = "Frostwurmnorthrend",
			}, -- [361]
			{
				["T"] = {
					"FrostWyrmPet.M2", -- [1]
				},
				["N"] = "Frostwyrmpet",
			}, -- [362]
			{
				["T"] = {
					"Fuelrobot.m2", -- [1]
				},
				["N"] = "Fuelrobot",
			}, -- [363]
			{
				["T"] = {
					"FungalGiant.M2", -- [1]
				},
				["N"] = "Fungalgiant",
			}, -- [364]
			{
				["T"] = {
					"FungalMonster.M2", -- [1]
				},
				["N"] = "Fungalmonster",
			}, -- [365]
			{
				["T"] = {
					"Furbolg.M2", -- [1]
				},
				["N"] = "Furbolg",
			}, -- [366]
			{
				["T"] = {
					"Gargoyle.M2", -- [1]
				},
				["N"] = "Gargoyle",
			}, -- [367]
			{
				["T"] = {
					"Garrosh.M2", -- [1]
				},
				["N"] = "Garrosh",
			}, -- [368]
			{
				["T"] = {
					"Garrosh2.M2", -- [1]
					"Garrosh2Lootable.M2", -- [2]
					"Garrosh2_Corrupted.M2", -- [3]
				},
				["N"] = "Garrosh2",
			}, -- [369]
			{
				["T"] = {
					"garrosh3.m2", -- [1]
				},
				["N"] = "Garrosh3",
			}, -- [370]
			{
				["T"] = {
					"GarroshHulked.M2", -- [1]
				},
				["N"] = "Garroshhulked",
			}, -- [371]
			{
				["T"] = {
					"Gazelle.M2", -- [1]
				},
				["N"] = "Gazelle",
			}, -- [372]
			{
				["T"] = {
					"Genesaur.m2", -- [1]
				},
				["N"] = "Genesaur",
			}, -- [373]
			{
				["T"] = {
					"Geode.M2", -- [1]
				},
				["N"] = "Geode",
			}, -- [374]
			{
				["T"] = {
					"Ghost.M2", -- [1]
				},
				["N"] = "Ghost",
			}, -- [375]
			{
				["T"] = {
					"GhostlyCharger.M2", -- [1]
				},
				["N"] = "Ghostlycharger",
			}, -- [376]
			{
				["T"] = {
					"GhostlySkullPet.M2", -- [1]
				},
				["N"] = "Ghostlyskullpet",
			}, -- [377]
			{
				["T"] = {
					"Ghoul.M2", -- [1]
					"GhoulNoBirth.m2", -- [2]
				},
				["N"] = "Ghoul",
			}, -- [378]
			{
				["T"] = {
					"GiantBoar.M2", -- [1]
					"GiantBoarArmoredMount.M2", -- [2]
					"giantboarmount.m2", -- [3]
				},
				["N"] = "Giantboar",
			}, -- [379]
			{
				["T"] = {
					"GiantDragonTurtle.M2", -- [1]
				},
				["N"] = "Giantdragonturtle",
			}, -- [380]
			{
				["T"] = {
					"GiantRemora.M2", -- [1]
				},
				["N"] = "Giantremora",
			}, -- [381]
			{
				["T"] = {
					"GiantSpider.M2", -- [1]
				},
				["N"] = "Giantspider",
			}, -- [382]
			{
				["T"] = {
					"Gilgoblin.M2", -- [1]
				},
				["N"] = "Gilgoblin",
			}, -- [383]
			{
				["T"] = {
					"GilneasStagecoach.M2", -- [1]
					"GilneasStagecoach_Carriage.M2", -- [2]
					"GilneasStagecoach_Harness.M2", -- [3]
				},
				["N"] = "Gilneasstagecoach",
			}, -- [384]
			{
				["T"] = {
					"Giraffe.M2", -- [1]
				},
				["N"] = "Giraffe",
			}, -- [385]
			{
				["T"] = {
					"GlaiveThrowerVehicle.M2", -- [1]
				},
				["N"] = "Glaivethrowervehicle",
			}, -- [386]
			{
				["T"] = {
					"gnoll.M2", -- [1]
				},
				["N"] = "Gnoll",
			}, -- [387]
			{
				["T"] = {
					"GnollCaster.M2", -- [1]
				},
				["N"] = "Gnollcaster",
			}, -- [388]
			{
				["T"] = {
					"GnollMelee.M2", -- [1]
				},
				["N"] = "Gnollmelee",
			}, -- [389]
			{
				["T"] = {
					"Gnome.m2", -- [1]
				},
				["N"] = "Gnome",
			}, -- [390]
			{
				["T"] = {
					"GnomeCopter.M2", -- [1]
				},
				["N"] = "Gnomecopter",
			}, -- [391]
			{
				["T"] = {
					"GnomeRockCutterCreature.M2", -- [1]
					"gnomerockcutterpet.m2", -- [2]
				},
				["N"] = "Gnomerockcuttercreature",
			}, -- [392]
			{
				["T"] = {
					"GnomeRocketCar.M2", -- [1]
				},
				["N"] = "Gnomerocketcar",
			}, -- [393]
			{
				["T"] = {
					"GnomeAlertBot.M2", -- [1]
					"GnomeBomBot.M2", -- [2]
					"GnomeBot.m2", -- [3]
					"GnomePounder.M2", -- [4]
					"GnomePounderVehicle.M2", -- [5]
					"GnomeSpiderTank.M2", -- [6]
					"GnomeSpiderTank02.M2", -- [7]
				},
				["N"] = "Gnomespidertank",
			}, -- [394]
			{
				["T"] = {
					"Goat.M2", -- [1]
					"GoatMount.M2", -- [2]
				},
				["N"] = "Goat",
			}, -- [395]
			{
				["T"] = {
					"Goblin.m2", -- [1]
					"GoblinShredder.M2", -- [2]
					"GoblinShredder_Low.M2", -- [3]
				},
				["N"] = "Goblin",
			}, -- [396]
			{
				["T"] = {
					"Goblin_Cannon.M2", -- [1]
				},
				["N"] = "Goblin_cannon",
			}, -- [397]
			{
				["T"] = {
					"Goblin_MineCart_01_Creature.M2", -- [1]
					"Goblin_MineCart_02_Creature.M2", -- [2]
				},
				["N"] = "Goblin_minecart",
			}, -- [398]
			{
				["T"] = {
					"goblin_riverboat_creature.M2", -- [1]
					"goblin_riverboat_creature_cannon_front.M2", -- [2]
					"goblin_riverboat_creature_cannon_side.M2", -- [3]
				},
				["N"] = "Goblin_riverboat_creature",
			}, -- [399]
			{
				["T"] = {
					"GoblinBombBot.M2", -- [1]
				},
				["N"] = "Goblinbombbot",
			}, -- [400]
			{
				["T"] = {
					"GoblinFemaleKid.M2", -- [1]
				},
				["N"] = "Goblinfemalekid",
			}, -- [401]
			{
				["T"] = {
					"GoblinGlider.M2", -- [1]
				},
				["N"] = "Goblinglider",
			}, -- [402]
			{
				["T"] = {
					"GoblinHotAirBalloonVehicle.M2", -- [1]
				},
				["N"] = "Goblinhotairballoonvehicle",
			}, -- [403]
			{
				["T"] = {
					"GoblinHotrod.M2", -- [1]
				},
				["N"] = "Goblinhotrod",
			}, -- [404]
			{
				["T"] = {
					"GoblinMale_Corrupted.M2", -- [1]
				},
				["N"] = "Goblinmale_corrupted",
			}, -- [405]
			{
				["T"] = {
					"GoblinMaleKid.M2", -- [1]
				},
				["N"] = "Goblinmalekid",
			}, -- [406]
			{
				["T"] = {
					"Goblin_Rocket.M2", -- [1]
				},
				["N"] = "Goblinrocket",
			}, -- [407]
			{
				["T"] = {
					"GoblinRocketCar.M2", -- [1]
				},
				["N"] = "Goblinrocketcar",
			}, -- [408]
			{
				["T"] = {
					"GoblinShredderMount.M2", -- [1]
					"GoblinShredderMount_Low.M2", -- [2]
				},
				["N"] = "Goblinshreddermount",
			}, -- [409]
			{
				["T"] = {
					"GoblinTrike01.M2", -- [1]
					"GoblinTrike02.M2", -- [2]
				},
				["N"] = "Goblintrike",
			}, -- [410]
			{
				["T"] = {
					"Goldfish.M2", -- [1]
				},
				["N"] = "Goldfish",
			}, -- [411]
			{
				["T"] = {
					"GolemDwarven.M2", -- [1]
				},
				["N"] = "Golemdwarven",
			}, -- [412]
			{
				["T"] = {
					"GolemHarvest.M2", -- [1]
				},
				["N"] = "Golemharvest",
			}, -- [413]
			{
				["T"] = {
					"GolemHarvestStage2.M2", -- [1]
				},
				["N"] = "Golemharveststage2",
			}, -- [414]
			{
				["T"] = {
					"GolemCannonIron.m2", -- [1]
					"GolemIron.m2", -- [2]
				},
				["N"] = "Golemiron",
			}, -- [415]
			{
				["T"] = {
					"GolemCannonStone.M2", -- [1]
					"GolemStone.M2", -- [2]
				},
				["N"] = "Golemstone",
			}, -- [416]
			{
				["T"] = {
					"Goren.M2", -- [1]
				},
				["N"] = "Goren",
			}, -- [417]
			{
				["T"] = {
					"Gorilla.M2", -- [1]
					"gorillapet.m2", -- [2]
				},
				["N"] = "Gorilla",
			}, -- [418]
			{
				["T"] = {
					"GreaterBeholder.M2", -- [1]
				},
				["N"] = "Greaterbeholder",
			}, -- [419]
			{
				["T"] = {
					"GreaterSlime.M2", -- [1]
					"GreaterSlimeDeathWing.M2", -- [2]
					"GreaterSlimeDeathWing_Sorted.M2", -- [3]
					"GreaterSlimeMercury.M2", -- [4]
					"GreaterSlime_Blood.M2", -- [5]
					"GreaterSlime_BloodFace.M2", -- [6]
					"GreaterSlime_Brown.M2", -- [7]
					"GreaterSlime_Corrupted.M2", -- [8]
					"GreaterSlime_CorruptedFace.M2", -- [9]
					"GreaterSlime_Sorted.M2", -- [10]
					"GreaterSlime_Unsorted.M2", -- [11]
					"GreaterSlime_Water.M2", -- [12]
					"GreaterSlime_WaterSha.M2", -- [13]
				},
				["N"] = "Greaterslime",
			}, -- [420]
			{
				["T"] = {
					"Grell.M2", -- [1]
				},
				["N"] = "Grell",
			}, -- [421]
			{
				["T"] = {
					"Grommash.M2", -- [1]
				},
				["N"] = "Grommash",
			}, -- [422]
			{
				["T"] = {
					"Grommloc.m2", -- [1]
				},
				["N"] = "Grommloc",
			}, -- [423]
			{
				["T"] = {
					"Gronn.M2", -- [1]
					"GronnDraenor.M2", -- [2]
					"GronnDraenorHarness.m2", -- [3]
					"GronnDraenorWarForged.m2", -- [4]
				},
				["N"] = "Gronn",
			}, -- [424]
			{
				["T"] = {
					"GroundFlower.M2", -- [1]
				},
				["N"] = "Groundflower",
			}, -- [425]
			{
				["T"] = {
					"Grouper.M2", -- [1]
				},
				["N"] = "Grouper",
			}, -- [426]
			{
				["T"] = {
					"Gryphon.m2", -- [1]
					"Gryphon_Armored.M2", -- [2]
					"Gryphon_ArmoredMount.M2", -- [3]
					"Gryphon_Armored_Vehicle.M2", -- [4]
					"Gryphon_Ghost.M2", -- [5]
					"Gryphon_Ghost_Mount.M2", -- [6]
					"Gryphon_Mount.M2", -- [7]
					"Gryphon_Skeletal.m2", -- [8]
					"Gryphon_Skeletal_Mount.M2", -- [9]
					"Gryphon_Skeletal_Mount_DeathKnight.M2", -- [10]
				},
				["N"] = "Gryphon",
			}, -- [427]
			{
				["T"] = {
					"GryphonPet.M2", -- [1]
					"GryphonPetGeneric.M2", -- [2]
				},
				["N"] = "Gryphonpet",
			}, -- [428]
			{
				["T"] = {
					{
						["T"] = {
							"AllianceLionMount.M2", -- [1]
						},
						["N"] = "Alliancelionmount",
					}, -- [1]
				},
				["N"] = "Guildcreatures",
			}, -- [429]
			{
				["T"] = {
					"Guldan.m2", -- [1]
				},
				["N"] = "Guldan",
			}, -- [430]
			{
				["T"] = {
					"Gyrocopter_01.M2", -- [1]
					"Gyrocopter_02.M2", -- [2]
				},
				["N"] = "Gyrocopter",
			}, -- [431]
			{
				["T"] = {
					"Hakkar.M2", -- [1]
				},
				["N"] = "Hakkar",
			}, -- [432]
			{
				["T"] = {
					"HalfBodyofKathune.M2", -- [1]
				},
				["N"] = "Halfbodyofkathune",
			}, -- [433]
			{
				["T"] = {
					"HaremMatron.M2", -- [1]
				},
				["N"] = "Haremmatron",
			}, -- [434]
			{
				["T"] = {
					"Harkoa.M2", -- [1]
				},
				["N"] = "Harkoa",
			}, -- [435]
			{
				["T"] = {
					"VR_Harpoon_01.M2", -- [1]
				},
				["N"] = "Harpoon",
			}, -- [436]
			{
				["T"] = {
					"Harpy.M2", -- [1]
				},
				["N"] = "Harpy",
			}, -- [437]
			{
				["T"] = {
					"Headlesshorseman.m2", -- [1]
				},
				["N"] = "Headlesshorseman",
			}, -- [438]
			{
				["T"] = {
					"HeadlessHorsemanHorse.M2", -- [1]
				},
				["N"] = "Headlesshorsemanhorse",
			}, -- [439]
			{
				["T"] = {
					"HeadlessHorsemanMount.m2", -- [1]
				},
				["N"] = "Headlesshorsemanmount",
			}, -- [440]
			{
				["T"] = {
					"HeartoftheMountain.m2", -- [1]
					"HeartoftheMountain_nobase.m2", -- [2]
				},
				["N"] = "Heartofthemountain",
			}, -- [441]
			{
				["T"] = {
					"HeavyWoodenCombatDummy.M2", -- [1]
				},
				["N"] = "Heavywoodencombatdummy",
			}, -- [442]
			{
				["T"] = {
					"HellHound.M2", -- [1]
				},
				["N"] = "Hellhound",
			}, -- [443]
			{
				["T"] = {
					"HHGroundMount.M2", -- [1]
				},
				["N"] = "Hhgroundmount",
			}, -- [444]
			{
				["T"] = {
					"HHMount.M2", -- [1]
				},
				["N"] = "Hhmount",
			}, -- [445]
			{
				["T"] = {
					"HighElfFemale_Hunter.m2", -- [1]
					"HighElfFemale_Mage.m2", -- [2]
					"HighElfFemale_Priest.m2", -- [3]
					"HighElfFemale_Warrior.m2", -- [4]
					"HighElfMale_Hunter.m2", -- [5]
					"HighElfMale_Mage.m2", -- [6]
					"HighElfMale_Priest.m2", -- [7]
					"HighElfMale_Warrior.m2", -- [8]
				},
				["N"] = "Highelf",
			}, -- [446]
			{
				["T"] = {
					"Hippo.M2", -- [1]
				},
				["N"] = "Hippo",
			}, -- [447]
			{
				["T"] = {
					"BurntHippoGryph.M2", -- [1]
					"Hippogryph.M2", -- [2]
					"HippogryphPet.M2", -- [3]
				},
				["N"] = "Hippogryph",
			}, -- [448]
			{
				["T"] = {
					"HippogryphMount.M2", -- [1]
				},
				["N"] = "Hippogryphmount",
			}, -- [449]
			{
				["T"] = {
					"hippomount.m2", -- [1]
				},
				["N"] = "Hippomount",
			}, -- [450]
			{
				["T"] = {
					"Hobgoblin.M2", -- [1]
				},
				["N"] = "Hobgoblin",
			}, -- [451]
			{
				["T"] = {
					"Hodir.M2", -- [1]
				},
				["N"] = "Hodir",
			}, -- [452]
			{
				["T"] = {
					"HolidayRobot.m2", -- [1]
				},
				["N"] = "Holidayrobot",
			}, -- [453]
			{
				["T"] = {
					"HoppingGhost.M2", -- [1]
				},
				["N"] = "Hoppingghost",
			}, -- [454]
			{
				["T"] = {
					"Hoptallus.M2", -- [1]
				},
				["N"] = "Hoptallus",
			}, -- [455]
			{
				["T"] = {
					"HordeCaravanVehicle.M2", -- [1]
					"HordeCaravanVehicle_carriage.M2", -- [2]
					"HordeCaravanVehicle_harness.M2", -- [3]
				},
				["N"] = "Hordecaravan",
			}, -- [456]
			{
				["T"] = {
					"HordeChopper.m2", -- [1]
				},
				["N"] = "Hordechopper",
			}, -- [457]
			{
				["T"] = {
					"HordeDeckGun.M2", -- [1]
				},
				["N"] = "Hordedeckgun",
			}, -- [458]
			{
				["T"] = {
					"HordeGarrisonTank.m2", -- [1]
					"HordeGarrisonTank_Small.m2", -- [2]
				},
				["N"] = "Hordegarrisontank",
			}, -- [459]
			{
				["T"] = {
					"HordePVPMount.M2", -- [1]
				},
				["N"] = "Hordepvpmount",
			}, -- [460]
			{
				["T"] = {
					"HordeRider.m2", -- [1]
				},
				["N"] = "Horderider",
			}, -- [461]
			{
				["T"] = {
					"HordeScorpion.M2", -- [1]
					"HordeScorpionMount.M2", -- [2]
				},
				["N"] = "Hordescorpionmount",
			}, -- [462]
			{
				["T"] = {
					"Horisath.m2", -- [1]
				},
				["N"] = "Horisath",
			}, -- [463]
			{
				["T"] = {
					"Horse.M2", -- [1]
				},
				["N"] = "Horse",
			}, -- [464]
			{
				["T"] = {
					"PA_HotAirBalloon_Vehicle.M2", -- [1]
				},
				["N"] = "Hotairballoon_vehicle",
			}, -- [465]
			{
				["T"] = {
					"HozuMonkey.M2", -- [1]
					"HozuMonkey_Low01.M2", -- [2]
				},
				["N"] = "Hozu",
			}, -- [466]
			{
				["T"] = {
					"HuF_Garrison_A_Archer.m2", -- [1]
				},
				["N"] = "Huf_garrison_a_archer",
			}, -- [467]
			{
				["T"] = {
					"HUFMCitizenLow.m2", -- [1]
				},
				["N"] = "Hufmcitizenlow",
			}, -- [468]
			{
				["T"] = {
					"HUFMCitizenMid.m2", -- [1]
				},
				["N"] = "Hufmcitizenmid",
			}, -- [469]
			{
				["T"] = {
					"HUFMMerchant.m2", -- [1]
				},
				["N"] = "Hufmmerchant",
			}, -- [470]
			{
				["T"] = {
					"HulkedOrc.m2", -- [1]
				},
				["N"] = "Hulkedorc",
			}, -- [471]
			{
				["T"] = {
					"HuM_Garrison_A_Guard.m2", -- [1]
				},
				["N"] = "Hum_garrison_a_guard",
			}, -- [472]
			{
				["T"] = {
					"HumanFemaleBlacksmith.m2", -- [1]
				},
				["N"] = "Humanfemaleblacksmith",
			}, -- [473]
			{
				["T"] = {
					"HumanFemaleCaster.m2", -- [1]
				},
				["N"] = "Humanfemalecaster",
			}, -- [474]
			{
				["T"] = {
					"HumanFemaleFarmer.M2", -- [1]
				},
				["N"] = "Humanfemalefarmer",
			}, -- [475]
			{
				["T"] = {
					"HumanFemaleKid.M2", -- [1]
				},
				["N"] = "Humanfemalekid",
			}, -- [476]
			{
				["T"] = {
					"HumanFemaleMerchantFat.m2", -- [1]
				},
				["N"] = "Humanfemalemerchantfat",
			}, -- [477]
			{
				["T"] = {
					"HumanFemaleMerchantThin.m2", -- [1]
				},
				["N"] = "Humanfemalemerchantthin",
			}, -- [478]
			{
				["T"] = {
					"HumanFemalePeasant.m2", -- [1]
				},
				["N"] = "Humanfemalepeasant",
			}, -- [479]
			{
				["T"] = {
					"HumanFemaleWarriorHeavy.m2", -- [1]
				},
				["N"] = "Humanfemalewarriorheavy",
			}, -- [480]
			{
				["T"] = {
					"HumanFemaleWarriorLight.m2", -- [1]
				},
				["N"] = "Humanfemalewarriorlight",
			}, -- [481]
			{
				["T"] = {
					"HumanFemaleWarriorMedium.m2", -- [1]
				},
				["N"] = "Humanfemalewarriormedium",
			}, -- [482]
			{
				["T"] = {
					"HumanMaleBlacksmith.m2", -- [1]
				},
				["N"] = "Humanmaleblacksmith",
			}, -- [483]
			{
				["T"] = {
					"HumanMaleBuried.M2", -- [1]
				},
				["N"] = "Humanmaleburied",
			}, -- [484]
			{
				["T"] = {
					"HumanMaleCaster.m2", -- [1]
				},
				["N"] = "Humanmalecaster",
			}, -- [485]
			{
				["T"] = {
					"HumanMaleFarmer.m2", -- [1]
				},
				["N"] = "Humanmalefarmer",
			}, -- [486]
			{
				["T"] = {
					"HumanMaleGuard.m2", -- [1]
				},
				["N"] = "Humanmaleguard",
			}, -- [487]
			{
				["T"] = {
					"ArgentSquireHumanMaleKid.m2", -- [1]
					"ArgentSquireHumanMaleKid_BP.M2", -- [2]
					"HumanMaleKid.M2", -- [3]
					"HumanMaleKid_Ghost.m2", -- [4]
				},
				["N"] = "Humanmalekid",
			}, -- [488]
			{
				["T"] = {
					"HumanMaleMarshal.m2", -- [1]
				},
				["N"] = "Humanmalemarshal",
			}, -- [489]
			{
				["T"] = {
					"HumanMaleNoble.M2", -- [1]
				},
				["N"] = "Humanmalenoble",
			}, -- [490]
			{
				["T"] = {
					"HumanMalePeasant.M2", -- [1]
					"HumanMalePeasantAxe.m2", -- [2]
					"HumanMalePeasantGold.m2", -- [3]
					"HumanMalePeasantPick.m2", -- [4]
					"HumanMalePeasantWood.M2", -- [5]
				},
				["N"] = "Humanmalepeasant",
			}, -- [491]
			{
				["T"] = {
					"HumanMalePirateCaptain.M2", -- [1]
					"HumanMalePirateCaptain_Ghost.m2", -- [2]
				},
				["N"] = "Humanmalepiratecaptain",
			}, -- [492]
			{
				["T"] = {
					"HumanMalePirateCrewman.M2", -- [1]
					"HumanMalePirateCrewman_Ghost.m2", -- [2]
				},
				["N"] = "Humanmalepiratecrewman",
			}, -- [493]
			{
				["T"] = {
					"HumanMalePirateSwashbuckler.M2", -- [1]
					"HumanMalePirateSwashbuckler_Ghost.m2", -- [2]
				},
				["N"] = "Humanmalepirateswashbuckler",
			}, -- [494]
			{
				["T"] = {
					"HumanMaleWarriorHeavy.m2", -- [1]
					"HumanMaleWarriorHeavy_Ghost.m2", -- [2]
				},
				["N"] = "Humanmalewarriorheavy",
			}, -- [495]
			{
				["T"] = {
					"HumanMaleWarriorLight.m2", -- [1]
				},
				["N"] = "Humanmalewarriorlight",
			}, -- [496]
			{
				["T"] = {
					"HumanMaleWarriorMedium.m2", -- [1]
				},
				["N"] = "Humanmalewarriormedium",
			}, -- [497]
			{
				["T"] = {
					"HumanMaleWizard.m2", -- [1]
				},
				["N"] = "Humanmalewizard",
			}, -- [498]
			{
				["T"] = {
					"HumanThief.M2", -- [1]
				},
				["N"] = "Humanthief",
			}, -- [499]
			{
				["T"] = {
					"HUMLBlackSmith.m2", -- [1]
				},
				["N"] = "Humlblacksmith",
			}, -- [500]
			{
				["T"] = {
					"HUMLCitizenMid.m2", -- [1]
				},
				["N"] = "Humlcitizenmid",
			}, -- [501]
			{
				["T"] = {
					"HUMLMagicSmith.m2", -- [1]
				},
				["N"] = "Humlmagicsmith",
			}, -- [502]
			{
				["T"] = {
					"HUMLMerchant.m2", -- [1]
				},
				["N"] = "Humlmerchant",
			}, -- [503]
			{
				["T"] = {
					"HUMLUpperCitizen.m2", -- [1]
				},
				["N"] = "Humluppercitizen",
			}, -- [504]
			{
				["T"] = {
					"HUMNGuardBig.m2", -- [1]
				},
				["N"] = "Humnguardbig",
			}, -- [505]
			{
				["T"] = {
					"HUMSCitizenMid.m2", -- [1]
				},
				["N"] = "Humscitizenmid",
			}, -- [506]
			{
				["T"] = {
					"HUMSGuardBig.m2", -- [1]
				},
				["N"] = "Humsguardbig",
			}, -- [507]
			{
				["T"] = {
					"HUMSMerchant.m2", -- [1]
				},
				["N"] = "Humsmerchant",
			}, -- [508]
			{
				["T"] = {
					"Hydra.M2", -- [1]
				},
				["N"] = "Hydra",
			}, -- [509]
			{
				["T"] = {
					"HydraOutland.M2", -- [1]
				},
				["N"] = "Hydraoutland",
			}, -- [510]
			{
				["T"] = {
					"Hyena.M2", -- [1]
				},
				["N"] = "Hyena",
			}, -- [511]
			{
				["T"] = {
					"Iceberg.m2", -- [1]
				},
				["N"] = "Iceberg",
			}, -- [512]
			{
				["T"] = {
					"IcecrownFleshBeast.M2", -- [1]
				},
				["N"] = "Icecrownfleshbeast",
			}, -- [513]
			{
				["T"] = {
					"IceTrollCouncilor.M2", -- [1]
				},
				["N"] = "Icetrollcouncilor",
			}, -- [514]
			{
				["T"] = {
					"Illidan.m2", -- [1]
					"IllidanDark.m2", -- [2]
				},
				["N"] = "Illidan",
			}, -- [515]
			{
				["T"] = {
					"Illidan_Past.M2", -- [1]
				},
				["N"] = "Illidan_past",
			}, -- [516]
			{
				["T"] = {
					"Creature_IllidansGlaive.M2", -- [1]
				},
				["N"] = "Illidanglaive",
			}, -- [517]
			{
				["T"] = {
					"Imp.M2", -- [1]
				},
				["N"] = "Imp",
			}, -- [518]
			{
				["T"] = {
					"ImpOutland.M2", -- [1]
				},
				["N"] = "Impoutland",
			}, -- [519]
			{
				["T"] = {
					"Infernal.M2", -- [1]
				},
				["N"] = "Infernal",
			}, -- [520]
			{
				["T"] = {
					"InfestedOrc.m2", -- [1]
				},
				["N"] = "Infestedorc",
			}, -- [521]
			{
				["T"] = {
					"InvisibleMan.m2", -- [1]
				},
				["N"] = "Invisibleman",
			}, -- [522]
			{
				["T"] = {
					"InvisibleStalker.M2", -- [1]
					"InvisibleStalkerGround.m2", -- [2]
					"InvisibleStalkerNoName.m2", -- [3]
					"InvisibleStalker_followTerrain.M2", -- [4]
					"InvisibleStalker_noAnims.m2", -- [5]
				},
				["N"] = "Invisiblestalker",
			}, -- [523]
			{
				["T"] = {
					"IronDwarf.M2", -- [1]
					"IronDwarf_low01.m2", -- [2]
					"IronDwarf_low02.m2", -- [3]
				},
				["N"] = "Irondwarf",
			}, -- [524]
			{
				["T"] = {
					"IronHordeClefthoof.m2", -- [1]
				},
				["N"] = "Ironhordeclefthoof",
			}, -- [525]
			{
				["T"] = {
					"IronHordeElekk.m2", -- [1]
				},
				["N"] = "Ironhordeelekk",
			}, -- [526]
			{
				["T"] = {
					"IronHordeWolf.m2", -- [1]
				},
				["N"] = "Ironhordewolf",
			}, -- [527]
			{
				["T"] = {
					"IronJuggernaut.M2", -- [1]
					"IronJuggernautLeftArmSaw.M2", -- [2]
					"IronJuggernautLeftCannon.M2", -- [3]
					"IronJuggernautMount.M2", -- [4]
					"IronJuggernautRightArmDrill.M2", -- [5]
					"IronJuggernautRightCannon.M2", -- [6]
					"IronJuggernautSawBlade.M2", -- [7]
					"IronJuggernautTailGun.M2", -- [8]
					"IronJuggernautTailGunSolo.M2", -- [9]
					"IronJuggernautTopCannon.M2", -- [10]
					"IronJuggernaut_DungeonDoll.M2", -- [11]
				},
				["N"] = "Ironjuggernaut",
			}, -- [528]
			{
				["T"] = {
					"IronVrykulMale.m2", -- [1]
				},
				["N"] = "Ironvrykulmale",
			}, -- [529]
			{
				["T"] = {
					"Isiset.M2", -- [1]
				},
				["N"] = "Isiset",
			}, -- [530]
			{
				["T"] = {
					"JadeSerpentGodPet.M2", -- [1]
				},
				["N"] = "Jadeserpentgodpet",
			}, -- [531]
			{
				["T"] = {
					"Jaina.m2", -- [1]
					"Jaina2.M2", -- [2]
				},
				["N"] = "Jaina",
			}, -- [532]
			{
				["T"] = {
					"JeweledGnome.M2", -- [1]
				},
				["N"] = "Jeweledgnome",
			}, -- [533]
			{
				["T"] = {
					"Jinyu.M2", -- [1]
				},
				["N"] = "Jinyu",
			}, -- [534]
			{
				["T"] = {
					"Jormungar.m2", -- [1]
				},
				["N"] = "Jormungar",
			}, -- [535]
			{
				["T"] = {
					"JormungarLarva.m2", -- [1]
				},
				["N"] = "Jormungarlarva",
			}, -- [536]
			{
				["T"] = {
					"JungleTrollCouncilor.M2", -- [1]
				},
				["N"] = "Jungletrollcouncilor",
			}, -- [537]
			{
				["T"] = {
					"KaelThas.M2", -- [1]
				},
				["N"] = "Kaelthas",
			}, -- [538]
			{
				["T"] = {
					"KaelThasBroken.m2", -- [1]
				},
				["N"] = "Kaelthas_broken",
			}, -- [539]
			{
				["T"] = {
					"Kalecgos.M2", -- [1]
				},
				["N"] = "Kalecgos",
			}, -- [540]
			{
				["T"] = {
					"Kargath.m2", -- [1]
				},
				["N"] = "Kargath",
			}, -- [541]
			{
				["T"] = {
					"kargathbladefist.m2", -- [1]
				},
				["N"] = "Kargathbladefist",
			}, -- [542]
			{
				["T"] = {
					"KarshSteelbenderMolten.M2", -- [1]
				},
				["N"] = "Karshsteelbendermolten",
			}, -- [543]
			{
				["T"] = {
					"KeeperOfTheGrove.M2", -- [1]
				},
				["N"] = "Keeperofthegrove",
			}, -- [544]
			{
				["T"] = {
					"KelThuzad.M2", -- [1]
					"kelthuzad_window_portal_Creature.m2", -- [2]
				},
				["N"] = "Kelthuzad",
			}, -- [545]
			{
				["T"] = {
					"Khadgar2.m2", -- [1]
				},
				["N"] = "Khadgar2",
			}, -- [546]
			{
				["T"] = {
					"Kiljaeden.M2", -- [1]
				},
				["N"] = "Kiljaeden",
			}, -- [547]
			{
				["T"] = {
					"killroggdeadeye.m2", -- [1]
				},
				["N"] = "Killroggdeadeye",
			}, -- [548]
			{
				["T"] = {
					"KingVarianWrynn.m2", -- [1]
				},
				["N"] = "Kingvarianwrynn",
			}, -- [549]
			{
				["T"] = {
					"KingYmiron.m2", -- [1]
				},
				["N"] = "Kingymiron",
			}, -- [550]
			{
				["T"] = {
					"kobold.M2", -- [1]
				},
				["N"] = "Kobold",
			}, -- [551]
			{
				["T"] = {
					"KodoBeast.M2", -- [1]
					"KodoBeastPack.m2", -- [2]
					"KodoBeastPvPT2.M2", -- [3]
					"KodoBeastTame.m2", -- [4]
					"RidingKodo.M2", -- [5]
					"RidingKotoBeastSunwalker.M2", -- [6]
					"RidingKotoBeastSunwalkerElite.M2", -- [7]
				},
				["N"] = "Kodobeast",
			}, -- [552]
			{
				["T"] = {
					"KoloArmL.m2", -- [1]
					"KoloArmR.m2", -- [2]
					"Kologarn.M2", -- [3]
				},
				["N"] = "Kologarn",
			}, -- [553]
			{
				["T"] = {
					"KorKronEliteWolf.M2", -- [1]
				},
				["N"] = "Korkronelitewolf",
			}, -- [554]
			{
				["T"] = {
					"Krakken.M2", -- [1]
					"KrakkenNOFX.M2", -- [2]
				},
				["N"] = "Krakken",
			}, -- [555]
			{
				["T"] = {
					"KunAutumnlight_Bake_01.M2", -- [1]
				},
				["N"] = "Kunautumnlight",
			}, -- [556]
			{
				["T"] = {
					"LadyNazjar.M2", -- [1]
				},
				["N"] = "Ladynazjar",
			}, -- [557]
			{
				["T"] = {
					"LadySylvanasWindrunner.m2", -- [1]
				},
				["N"] = "Ladysylvanaswindrunner",
			}, -- [558]
			{
				["T"] = {
					"LadyVashj.M2", -- [1]
				},
				["N"] = "Ladyvashj",
			}, -- [559]
			{
				["T"] = {
					"Landro.m2", -- [1]
				},
				["N"] = "Landro",
			}, -- [560]
			{
				["T"] = {
					"BE_Lantern_01_Pet.M2", -- [1]
					"DR_Lantern_01_Pet.M2", -- [2]
					"LunarNewYearLantern_Alliance_Hanging_Pet.M2", -- [3]
					"LunarNewYearLantern_Horde_Hanging_Pet.M2", -- [4]
				},
				["N"] = "Lanternpet",
			}, -- [561]
			{
				["T"] = {
					"Larva.M2", -- [1]
				},
				["N"] = "Larva",
			}, -- [562]
			{
				["T"] = {
					"LarvaOutland.m2", -- [1]
				},
				["N"] = "Larvaoutland",
			}, -- [563]
			{
				["T"] = {
					"Lasher.M2", -- [1]
				},
				["N"] = "Lasher",
			}, -- [564]
			{
				["T"] = {
					"LasherOrchid.m2", -- [1]
					"LasherOrchid_Scroll.m2", -- [2]
				},
				["N"] = "Lasherorchid",
			}, -- [565]
			{
				["T"] = {
					"Lasher_Sunflower.M2", -- [1]
				},
				["N"] = "Lashersunflower",
			}, -- [566]
			{
				["T"] = {
					"LavaHorse.m2", -- [1]
				},
				["N"] = "Lavahorse",
			}, -- [567]
			{
				["T"] = {
					"Lavaman.m2", -- [1]
				},
				["N"] = "Lavaman",
			}, -- [568]
			{
				["T"] = {
					"Lavaworm.M2", -- [1]
					"Lavaworm_02.M2", -- [2]
					"Lavaworm_03.M2", -- [3]
				},
				["N"] = "Lavaworm",
			}, -- [569]
			{
				["T"] = {
					"LesserGronn.m2", -- [1]
					"LesserGronnMount.m2", -- [2]
				},
				["N"] = "Lessergronn",
			}, -- [570]
			{
				["T"] = {
					"LesserManaFiend.M2", -- [1]
				},
				["N"] = "Lessermanafiend",
			}, -- [571]
			{
				["T"] = {
					"Leviathan.M2", -- [1]
					"Leviathan_Tentacle.M2", -- [2]
					"Leviathan_Tentacle_Tail.M2", -- [3]
				},
				["N"] = "Leviathan",
			}, -- [572]
			{
				["T"] = {
					"Lich.M2", -- [1]
				},
				["N"] = "Lich",
			}, -- [573]
			{
				["T"] = {
					"LifebinderGift.M2", -- [1]
				},
				["N"] = "Lifebindergift",
			}, -- [574]
			{
				["T"] = {
					"LilliansSoul.M2", -- [1]
				},
				["N"] = "Lillianssoul",
			}, -- [575]
			{
				["T"] = {
					"Lion.M2", -- [1]
				},
				["N"] = "Lion",
			}, -- [576]
			{
				["T"] = {
					"LionSeal.M2", -- [1]
				},
				["N"] = "Lionseal",
			}, -- [577]
			{
				["T"] = {
					"LiquidMagmaGiant.M2", -- [1]
				},
				["N"] = "Liquidmagmagiant",
			}, -- [578]
			{
				["T"] = {
					"Lobstrok.M2", -- [1]
				},
				["N"] = "Lobstrok",
			}, -- [579]
			{
				["T"] = {
					"LobstrokOutland.M2", -- [1]
				},
				["N"] = "Lobstrokoutland",
			}, -- [580]
			{
				["T"] = {
					"LordKezzak.M2", -- [1]
					"LordKezzak_Armored.M2", -- [2]
				},
				["N"] = "Lord Kezzak",
			}, -- [581]
			{
				["T"] = {
					"LostIsles_CarnivorousPlant01_Creature.M2", -- [1]
					"LostIsles_CarnivorousPlant01_Creature_RedSpitter.M2", -- [2]
					"LostIsles_CarnivorousPlant02_Creature.M2", -- [3]
					"LostIsles_CarnivorousPlant02_Creature_Freezer.M2", -- [4]
				},
				["N"] = "Lostisles_carnivorousplant",
			}, -- [582]
			{
				["T"] = {
					"LostOne.M2", -- [1]
				},
				["N"] = "Lostone",
			}, -- [583]
			{
				["T"] = {
					"Lynxgod.M2", -- [1]
				},
				["N"] = "Lynxgod",
			}, -- [584]
			{
				["T"] = {
					"MadScientist.M2", -- [1]
					"MadScientistNoBackpack.m2", -- [2]
				},
				["N"] = "Madscientist",
			}, -- [585]
			{
				["T"] = {
					"Mage_Flameorb_01.M2", -- [1]
					"Mage_Flameorb_02.M2", -- [2]
				},
				["N"] = "Mage_flameorb",
			}, -- [586]
			{
				["T"] = {
					"Mage_FocusingCrystal_Creature.M2", -- [1]
				},
				["N"] = "Magefocusingcrystal",
			}, -- [587]
			{
				["T"] = {
					"MageHunter.M2", -- [1]
				},
				["N"] = "Magehunter",
			}, -- [588]
			{
				["T"] = {
					"MagmaGiant.M2", -- [1]
					"MagmaGiant_LegLeft.M2", -- [2]
					"MagmaGiant_LegRight.M2", -- [3]
				},
				["N"] = "Magmagiant",
			}, -- [589]
			{
				["T"] = {
					"magnataur.M2", -- [1]
				},
				["N"] = "Magnataur",
			}, -- [590]
			{
				["T"] = {
					"MalfurionStormrage.M2", -- [1]
				},
				["N"] = "Malfurionstormrage",
			}, -- [591]
			{
				["T"] = {
					"Malganis.M2", -- [1]
				},
				["N"] = "Malganis",
			}, -- [592]
			{
				["T"] = {
					"Malorne.M2", -- [1]
				},
				["N"] = "Malorne",
			}, -- [593]
			{
				["T"] = {
					"Malygos.M2", -- [1]
				},
				["N"] = "Malygos",
			}, -- [594]
			{
				["T"] = {
					"MammothMount_1seat.M2", -- [1]
					"MammothMount_3seat.M2", -- [2]
					"mammoth.M2", -- [3]
					"mammothMount2.m2", -- [4]
					"mammothMount5.m2", -- [5]
				},
				["N"] = "Mammoth",
			}, -- [595]
			{
				["T"] = {
					"ManaFiend.M2", -- [1]
				},
				["N"] = "Manafiend",
			}, -- [596]
			{
				["T"] = {
					"ManaFiend_Arcane_Blue.M2", -- [1]
					"ManaFiend_Arcane_Pink.M2", -- [2]
					"ManaFiend_Arcane_White.M2", -- [3]
					"ManaFiend_Arcane_Yellow.M2", -- [4]
					"ManaFiend_Void.m2", -- [5]
				},
				["N"] = "Manafiend2",
			}, -- [597]
			{
				["T"] = {
					"ManaFiendGreen.M2", -- [1]
				},
				["N"] = "Manafiendgreen",
			}, -- [598]
			{
				["T"] = {
					"ManaWurm.M2", -- [1]
				},
				["N"] = "Manawurm",
			}, -- [599]
			{
				["T"] = {
					"mantid.M2", -- [1]
					"mantid_low01.M2", -- [2]
					"mantid_low02.M2", -- [3]
					"mantid_low03.M2", -- [4]
					"mantid_low03_wingedNoShadow.M2", -- [5]
				},
				["N"] = "Mantid",
			}, -- [600]
			{
				["T"] = {
					"mantid_1Batch.M2", -- [1]
				},
				["N"] = "Mantid_1batch",
			}, -- [601]
			{
				["T"] = {
					"Mantid_Bomb_Amber_Journal.M2", -- [1]
				},
				["N"] = "Mantid_bomb_amber",
			}, -- [602]
			{
				["T"] = {
					"MantidCommander.M2", -- [1]
				},
				["N"] = "Mantidcommander",
			}, -- [603]
			{
				["T"] = {
					"MantidGrandVizier.M2", -- [1]
				},
				["N"] = "Mantidgrandvizier",
			}, -- [604]
			{
				["T"] = {
					"MantidLord.M2", -- [1]
				},
				["N"] = "Mantidlord",
			}, -- [605]
			{
				["T"] = {
					"MantidQueen.M2", -- [1]
				},
				["N"] = "Mantidqueen",
			}, -- [606]
			{
				["T"] = {
					"MantidTank_low01.M2", -- [1]
					"Mantidtank.M2", -- [2]
					"Mantidtank_Damaged.M2", -- [3]
				},
				["N"] = "Mantidtank",
			}, -- [607]
			{
				["T"] = {
					"Mastiff.M2", -- [1]
				},
				["N"] = "Mastiff",
			}, -- [608]
			{
				["T"] = {
					"MechanicalRabbit.M2", -- [1]
				},
				["N"] = "Mechanicalrabbit",
			}, -- [609]
			{
				["T"] = {
					"GnomeMechaStrider.M2", -- [1]
					"MechaStrider.M2", -- [2]
					"PvPMechaStrider.M2", -- [3]
				},
				["N"] = "Mechastrider",
			}, -- [610]
			{
				["T"] = {
					"Medivh.m2", -- [1]
				},
				["N"] = "Medivh",
			}, -- [611]
			{
				["T"] = {
					"MercilessOne.M2", -- [1]
				},
				["N"] = "Mercilessone",
			}, -- [612]
			{
				["T"] = {
					"Miev.M2", -- [1]
				},
				["N"] = "Miev",
			}, -- [613]
			{
				["T"] = {
					"Mimiron_Head.m2", -- [1]
					"Mimiron_Head_Mount.M2", -- [2]
					"Mimiron_Legs.m2", -- [3]
					"Mimiron_Legs_Weapon_Cannon.m2", -- [4]
					"Mimiron_Torso.M2", -- [5]
				},
				["N"] = "Mimiron",
			}, -- [614]
			{
				["T"] = {
					"MineSpider.M2", -- [1]
					"MineSpiderBoss.M2", -- [2]
				},
				["N"] = "Minespider",
			}, -- [615]
			{
				["T"] = {
					"MinisterofDeath.M2", -- [1]
				},
				["N"] = "Ministerofdeath",
			}, -- [616]
			{
				["T"] = {
					"MissileRocketMount.M2", -- [1]
				},
				["N"] = "Missilerocketmount",
			}, -- [617]
			{
				["T"] = {
					"MistFox.M2", -- [1]
				},
				["N"] = "Mistfox",
			}, -- [618]
			{
				["T"] = {
					"Moarg1.M2", -- [1]
					"Moarg2.m2", -- [2]
					"Moarg3.m2", -- [3]
					"Moarg4.m2", -- [4]
					"Moarg5.m2", -- [5]
					"Moarg6.m2", -- [6]
				},
				["N"] = "Moarg",
			}, -- [619]
			{
				["T"] = {
					"MoargMinion.m2", -- [1]
				},
				["N"] = "Moargminion",
			}, -- [620]
			{
				["T"] = {
					"Mobat.m2", -- [1]
				},
				["N"] = "Mobat",
			}, -- [621]
			{
				["T"] = {
					"Mogu.M2", -- [1]
					"MoguLieutenant.M2", -- [2]
					"Mogu_1Batch_01.M2", -- [3]
					"Mogu_1Batch_02.M2", -- [4]
					"Mogu_1Batch_02_LOW.M2", -- [5]
					"Mogu_1Batch_03.M2", -- [6]
				},
				["N"] = "Mogu",
			}, -- [622]
			{
				["T"] = {
					"Mogu1B_LOW_Statue.M2", -- [1]
				},
				["N"] = "Mogu1b_low_statue",
			}, -- [623]
			{
				["T"] = {
					"Mogu_LightningDrill_Creature.M2", -- [1]
				},
				["N"] = "Mogu_lightningdrill_creature",
			}, -- [624]
			{
				["T"] = {
					"MoguFemale_Moon.M2", -- [1]
					"MoguFemale_Sun.M2", -- [2]
				},
				["N"] = "Mogufemale",
			}, -- [625]
			{
				["T"] = {
					"MoguKing.M2", -- [1]
				},
				["N"] = "Moguking",
			}, -- [626]
			{
				["T"] = {
					"MoguTitan.M2", -- [1]
				},
				["N"] = "Mogutitan",
			}, -- [627]
			{
				["T"] = {
					"Molten_Meteor.M2", -- [1]
				},
				["N"] = "Molten_meteor",
			}, -- [628]
			{
				["T"] = {
					"MoltenCorgi.m2", -- [1]
				},
				["N"] = "Moltencorgi",
			}, -- [629]
			{
				["T"] = {
					"MoltenGiant.M2", -- [1]
				},
				["N"] = "Moltengiant",
			}, -- [630]
			{
				["T"] = {
					"Monk_Xuen_Low.M2", -- [1]
				},
				["N"] = "Monk_xuen_low",
			}, -- [631]
			{
				["T"] = {
					"Monkey.M2", -- [1]
					"Monkey_Fez.M2", -- [2]
				},
				["N"] = "Monkey",
			}, -- [632]
			{
				["T"] = {
					"HozuMonkeyKing.M2", -- [1]
				},
				["N"] = "Monkeyking",
			}, -- [633]
			{
				["T"] = {
					"monstrouseel.M2", -- [1]
				},
				["N"] = "Monstrouseel",
			}, -- [634]
			{
				["T"] = {
					"Moth.M2", -- [1]
					"Moth_Low.M2", -- [2]
				},
				["N"] = "Moth",
			}, -- [635]
			{
				["T"] = {
					"MothPet.m2", -- [1]
				},
				["N"] = "Mothpet",
			}, -- [636]
			{
				["T"] = {
					"MotorcycleVehicle.M2", -- [1]
				},
				["N"] = "Motorcyclevehicle",
			}, -- [637]
			{
				["T"] = {
					"MountainGiant.M2", -- [1]
				},
				["N"] = "Mountaingiant",
			}, -- [638]
			{
				["T"] = {
					"MountainGiantCrystal.M2", -- [1]
					"MountainGiantCrystal_Boss.M2", -- [2]
				},
				["N"] = "Mountaingiantcrystal",
			}, -- [639]
			{
				["T"] = {
					"MountainGiantCrystalOgrila.m2", -- [1]
				},
				["N"] = "Mountaingiantcrystalogrila",
			}, -- [640]
			{
				["T"] = {
					"MountainGiant_Howling.m2", -- [1]
				},
				["N"] = "Mountaingiantnorthrend",
			}, -- [641]
			{
				["T"] = {
					"MountainGiant_Bladesedge.M2", -- [1]
					"MountainGiant_Netherstorm.M2", -- [2]
					"MountainGiant_Zangarmarsh.M2", -- [3]
				},
				["N"] = "Mountaingiantoutland",
			}, -- [642]
			{
				["T"] = {
					"MountedDeathKnight.M2", -- [1]
					"MountedDeathKnight_Blaumeux.m2", -- [2]
					"MountedDeathKnight_Korthazz.m2", -- [3]
					"MountedDeathKnight_Mograine.m2", -- [4]
					"MountedDeathKnight_Zeliek.m2", -- [5]
					"RidingUndeadWarHorse.M2", -- [6]
					"UnMountedDeathKnight.m2", -- [7]
				},
				["N"] = "Mounteddeathknight",
			}, -- [643]
			{
				["T"] = {
					"MountedDemonKnight.m2", -- [1]
				},
				["N"] = "Mounteddemonknight",
			}, -- [644]
			{
				["T"] = {
					"MountedKnight.m2", -- [1]
				},
				["N"] = "Mountedknight",
			}, -- [645]
			{
				["T"] = {
					"MouthofKathune01.M2", -- [1]
				},
				["N"] = "Mouthofkathune01",
			}, -- [646]
			{
				["T"] = {
					"BabyMurloc.M2", -- [1]
					"BabyMurlocPlated.m2", -- [2]
					"DeathWingBabyMurloc.M2", -- [3]
					"DiabloBabyMurloc.M2", -- [4]
					"MarineBabyMurloc.M2", -- [5]
					"Murloc.M2", -- [6]
					"MurlocCrusader.M2", -- [7]
					"MurlocDeepSea.M2", -- [8]
				},
				["N"] = "Murloc",
			}, -- [647]
			{
				["T"] = {
					"murloccostume.m2", -- [1]
					"murloccostume_noflag.m2", -- [2]
					"murloccostume_whiteflag.m2", -- [3]
				},
				["N"] = "Murloccostume",
			}, -- [648]
			{
				["T"] = {
					"Murmur.M2", -- [1]
				},
				["N"] = "Murmur",
			}, -- [649]
			{
				["T"] = {
					"Murozond.M2", -- [1]
				},
				["N"] = "Murozond",
			}, -- [650]
			{
				["T"] = {
					"Muru.M2", -- [1]
				},
				["N"] = "Muru",
			}, -- [651]
			{
				["T"] = {
					"MushanBeast.M2", -- [1]
					"MushanBeastMount.M2", -- [2]
				},
				["N"] = "Mushanbeast",
			}, -- [652]
			{
				["T"] = {
					"Naaru.m2", -- [1]
				},
				["N"] = "Naaru",
			}, -- [653]
			{
				["T"] = {
					"NagaFemale_Low01.M2", -- [1]
					"NagaMale_Low01.M2", -- [2]
				},
				["N"] = "Naga",
			}, -- [654]
			{
				["T"] = {
					"Siren.M2", -- [1]
				},
				["N"] = "Nagafemale",
			}, -- [655]
			{
				["T"] = {
					"NagaLordMale.M2", -- [1]
				},
				["N"] = "Nagalordmale",
			}, -- [656]
			{
				["T"] = {
					"NagaMale.M2", -- [1]
				},
				["N"] = "Nagamale",
			}, -- [657]
			{
				["T"] = {
					"Necromancer.m2", -- [1]
				},
				["N"] = "Necromancer",
			}, -- [658]
			{
				["T"] = {
					"Neptulon.M2", -- [1]
				},
				["N"] = "Neptulon",
			}, -- [659]
			{
				["T"] = {
					"Nerubian.m2", -- [1]
				},
				["N"] = "Nerubian",
			}, -- [660]
			{
				["T"] = {
					"NerubianCaster.m2", -- [1]
				},
				["N"] = "Nerubiancaster",
			}, -- [661]
			{
				["T"] = {
					"NerubianPriest.M2", -- [1]
				},
				["N"] = "Nerubianpriest",
			}, -- [662]
			{
				["T"] = {
					"NerubianSpiderling.m2", -- [1]
				},
				["N"] = "Nerubianspiderling",
			}, -- [663]
			{
				["T"] = {
					"NerubianWarrior.m2", -- [1]
				},
				["N"] = "Nerubianwarrior",
			}, -- [664]
			{
				["T"] = {
					"nerzhul.m2", -- [1]
				},
				["N"] = "Nerzhul",
			}, -- [665]
			{
				["T"] = {
					"NetherDragon.M2", -- [1]
				},
				["N"] = "Netherdragon",
			}, -- [666]
			{
				["T"] = {
					"NetherDrake.M2", -- [1]
					"NetherDrakeElite.M2", -- [2]
					"NetherDrakeOutland.m2", -- [3]
					"NorthrendNetherDrake.M2", -- [4]
				},
				["N"] = "Netherdrake",
			}, -- [667]
			{
				["T"] = {
					"NetherDrakonid.M2", -- [1]
				},
				["N"] = "Netherdrakonid",
			}, -- [668]
			{
				["T"] = {
					"NetherDrakonidBoss.M2", -- [1]
				},
				["N"] = "Netherdrakonidboss",
			}, -- [669]
			{
				["T"] = {
					"NetherRay.M2", -- [1]
				},
				["N"] = "Netherray",
			}, -- [670]
			{
				["T"] = {
					"Nexus_Floating_Disc.m2", -- [1]
				},
				["N"] = "Nexus",
			}, -- [671]
			{
				["T"] = {
					"Nhallish.m2", -- [1]
				},
				["N"] = "Nhallish",
			}, -- [672]
			{
				["T"] = {
					"Nian.M2", -- [1]
				},
				["N"] = "Nian",
			}, -- [673]
			{
				["T"] = {
					"NightBane.M2", -- [1]
				},
				["N"] = "Nightbane",
			}, -- [674]
			{
				["T"] = {
					"Gorgon101.M2", -- [1]
					"Nightmare.M2", -- [2]
				},
				["N"] = "Nightmare",
			}, -- [675]
			{
				["T"] = {
					"NorthrendBearMount.M2", -- [1]
					"NorthrendBearMountArmored.M2", -- [2]
					"NorthrendBearMountArmored2Seat.m2", -- [3]
					"NorthrendBearMountArmored_large.m2", -- [4]
					"NorthrendBearMountBlizzcon.M2", -- [5]
				},
				["N"] = "Northrendbearmount",
			}, -- [676]
			{
				["T"] = {
					"NorthrendFireGiant.m2", -- [1]
				},
				["N"] = "Northrendfiregiant",
			}, -- [677]
			{
				["T"] = {
					"NorthrendFleshGiant.M2", -- [1]
				},
				["N"] = "Northrendfleshgiant",
			}, -- [678]
			{
				["T"] = {
					"NorthrendFrostWurm.M2", -- [1]
				},
				["N"] = "Northrendfrostwurm",
			}, -- [679]
			{
				["T"] = {
					"NorthrendFrostWurm_NoFrost.M2", -- [1]
				},
				["N"] = "Northrendfrostwurm_nofrost",
			}, -- [680]
			{
				["T"] = {
					"NorthrendGeist.m2", -- [1]
				},
				["N"] = "Northrendgeist",
			}, -- [681]
			{
				["T"] = {
					"NorthrendGhoul.m2", -- [1]
					"NorthrendGhoulSpiked.M2", -- [2]
				},
				["N"] = "Northrendghoul",
			}, -- [682]
			{
				["T"] = {
					"Gymer.m2", -- [1]
					"NorthrendGiant.M2", -- [2]
				},
				["N"] = "Northrendgiant",
			}, -- [683]
			{
				["T"] = {
					"NorthrendIceGiant.M2", -- [1]
				},
				["N"] = "Northrendicegiant",
			}, -- [684]
			{
				["T"] = {
					"NorthrendIronGiant.M2", -- [1]
				},
				["N"] = "Northrendirongiant",
			}, -- [685]
			{
				["T"] = {
					"NorthrendNightBane.M2", -- [1]
				},
				["N"] = "Northrendnightbane",
			}, -- [686]
			{
				["T"] = {
					"NorthrendPenguin.m2", -- [1]
				},
				["N"] = "Northrendpenguin",
			}, -- [687]
			{
				["T"] = {
					"NorthrendStoneGiant.m2", -- [1]
				},
				["N"] = "Northrendstonegiant",
			}, -- [688]
			{
				["T"] = {
					"NorthrendWorgen.m2", -- [1]
				},
				["N"] = "Northrendworgen",
			}, -- [689]
			{
				["T"] = {
					"Nozdormu.M2", -- [1]
					"Nozdormu2.M2", -- [2]
				},
				["N"] = "Nozdormu",
			}, -- [690]
			{
				["T"] = {
					"NozdormuDragon.M2", -- [1]
				},
				["N"] = "Nozdormudragon",
			}, -- [691]
			{
				["T"] = {
					"ArcheryTarget.m2", -- [1]
					"ArcheryTarget_Shield.M2", -- [2]
					"ArcheryTarget_Stand.M2", -- [3]
					"Cannon.M2", -- [4]
					"WoodenDummy.m2", -- [5]
				},
				["N"] = "Object",
			}, -- [692]
			{
				["T"] = {
					"ObsidianDestroyer.M2", -- [1]
				},
				["N"] = "Obsidiandestroyer",
			}, -- [693]
			{
				["T"] = {
					"OGRaid_Engine_02.M2", -- [1]
					"OGRaid_Engine_02_nosound.m2", -- [2]
				},
				["N"] = "Ograid_engine_02",
			}, -- [694]
			{
				["T"] = {
					"Ogre.M2", -- [1]
					"OgreMage.M2", -- [2]
					"OgreWarlord.M2", -- [3]
				},
				["N"] = "Ogre",
			}, -- [695]
			{
				["T"] = {
					"Ogre02.M2", -- [1]
				},
				["N"] = "Ogre02",
			}, -- [696]
			{
				["T"] = {
					"OgreDraenor.M2", -- [1]
					"OgreDraenorButcher.m2", -- [2]
				},
				["N"] = "Ogredraenor",
			}, -- [697]
			{
				["T"] = {
					"ogrefelbreaker.m2", -- [1]
				},
				["N"] = "Ogrefelbreaker",
			}, -- [698]
			{
				["T"] = {
					"OgreHighmaulKing.m2", -- [1]
				},
				["N"] = "Ogrehighmaulking",
			}, -- [699]
			{
				["T"] = {
					"OgreKing.m2", -- [1]
				},
				["N"] = "Ogreking",
			}, -- [700]
			{
				["T"] = {
					"OgreMage02.M2", -- [1]
				},
				["N"] = "Ogremage02",
			}, -- [701]
			{
				["T"] = {
					"OgreMageLord.M2", -- [1]
				},
				["N"] = "Ogremagelord",
			}, -- [702]
			{
				["T"] = {
					"OnyxiaUndead.M2", -- [1]
				},
				["N"] = "Onyxiaundead",
			}, -- [703]
			{
				["T"] = {
					"OnyxPanther.M2", -- [1]
				},
				["N"] = "Onyxpanther",
			}, -- [704]
			{
				["T"] = {
					"Oracle.m2", -- [1]
					"Oracle_Quest.m2", -- [2]
				},
				["N"] = "Oracle",
			}, -- [705]
			{
				["T"] = {
					"OrcFemale_1Batch_1.M2", -- [1]
					"OrcFemale_1Batch_2.M2", -- [2]
					"OrcMale_1Batch_1.M2", -- [3]
					"OrcMale_1Batch_2.M2", -- [4]
				},
				["N"] = "Orc1batch",
			}, -- [706]
			{
				["T"] = {
					"Orca.m2", -- [1]
				},
				["N"] = "Orca",
			}, -- [707]
			{
				["T"] = {
					"Orca_Druid.M2", -- [1]
				},
				["N"] = "Orca_druid",
			}, -- [708]
			{
				["T"] = {
					"OrcFemaleKid.m2", -- [1]
				},
				["N"] = "Orcfemalekid",
			}, -- [709]
			{
				["T"] = {
					"OrcFemaleKidBrown.m2", -- [1]
				},
				["N"] = "Orcfemalekidbrown",
			}, -- [710]
			{
				["T"] = {
					"OrcMaleImpaled.m2", -- [1]
				},
				["N"] = "Orcmaleimpaled",
			}, -- [711]
			{
				["T"] = {
					"OrcMaleKid.M2", -- [1]
					"OrcMaleKidGruntling.m2", -- [2]
					"OrcMaleKidGruntling_BP.m2", -- [3]
				},
				["N"] = "Orcmalekid",
			}, -- [712]
			{
				["T"] = {
					"OrcMaleKidBrown.m2", -- [1]
				},
				["N"] = "Orcmalekidbrown",
			}, -- [713]
			{
				["T"] = {
					"OrcMaleMerchantLight.m2", -- [1]
				},
				["N"] = "Orcmalemerchantlight",
			}, -- [714]
			{
				["T"] = {
					"OrcMalePeasantGold.M2", -- [1]
				},
				["N"] = "Orcmalepeasant",
			}, -- [715]
			{
				["T"] = {
					"OrcMaleWarriorHeavy.m2", -- [1]
				},
				["N"] = "Orcmalewarriorheavy",
			}, -- [716]
			{
				["T"] = {
					"OrcMaleWarriorLight.m2", -- [1]
				},
				["N"] = "Orcmalewarriorlight",
			}, -- [717]
			{
				["T"] = {
					"OrcSkeleton.m2", -- [1]
				},
				["N"] = "Orcskeleton",
			}, -- [718]
			{
				["T"] = {
					"OrcSuperSoldier.M2", -- [1]
				},
				["N"] = "Orcsupersoldier",
			}, -- [719]
			{
				["T"] = {
					"Orf_Garrison_H_Grunt.m2", -- [1]
				},
				["N"] = "Orf_garrison_h_grunt",
			}, -- [720]
			{
				["T"] = {
					"OrnateBloodGolem.M2", -- [1]
				},
				["N"] = "Ornatebloodgolem",
			}, -- [721]
			{
				["T"] = {
					"Otter.M2", -- [1]
				},
				["N"] = "Otter",
			}, -- [722]
			{
				["T"] = {
					"Fel_Overfiend.M2", -- [1]
					"Overfiend.M2", -- [2]
				},
				["N"] = "Overfiend",
			}, -- [723]
			{
				["T"] = {
					"Owl.M2", -- [1]
				},
				["N"] = "Owl",
			}, -- [724]
			{
				["T"] = {
					"OwlGhost_Green.M2", -- [1]
				},
				["N"] = "Owlghost_green",
			}, -- [725]
			{
				["T"] = {
					"PA_BrewRickshaw_Vehicle.M2", -- [1]
				},
				["N"] = "Pa_brewrickshaw_vehicle",
			}, -- [726]
			{
				["T"] = {
					"PA_Keg_Creature.M2", -- [1]
				},
				["N"] = "Pa_keg_creature",
			}, -- [727]
			{
				["T"] = {
					"PA_Kite_Lamp_Creature.M2", -- [1]
				},
				["N"] = "Pa_kite_lamp",
			}, -- [728]
			{
				["T"] = {
					"PA_Kite_02_Creature.M2", -- [1]
					"PA_Kite_03_Creature.M2", -- [2]
				},
				["N"] = "Pa_kites",
			}, -- [729]
			{
				["T"] = {
					"PA_Rickshaw_01Vehicle.M2", -- [1]
				},
				["N"] = "Pa_rickshaw_01vehicle",
			}, -- [730]
			{
				["T"] = {
					"PaleOrc.M2", -- [1]
					"Pale_Orc_Low.m2", -- [2]
				},
				["N"] = "Paleorc",
			}, -- [731]
			{
				["T"] = {
					"Jadepandacub.M2", -- [1]
					"PandaCub.m2", -- [2]
				},
				["N"] = "Panda",
			}, -- [732]
			{
				["T"] = {
					"Lili.M2", -- [1]
					"PandarenFemaleKid.M2", -- [2]
				},
				["N"] = "Pandarenfemalekid",
			}, -- [733]
			{
				["T"] = {
					"PandarenKiteMount.M2", -- [1]
				},
				["N"] = "Pandarenkitemount",
			}, -- [734]
			{
				["T"] = {
					"PandarenKiteTaxi.M2", -- [1]
				},
				["N"] = "Pandarenkitetaxi",
			}, -- [735]
			{
				["T"] = {
					"PandarenMaleKid.M2", -- [1]
				},
				["N"] = "Pandarenmalekid",
			}, -- [736]
			{
				["T"] = {
					"PandarenMaleKid_basic.M2", -- [1]
				},
				["N"] = "Pandarenmalekid_basic",
			}, -- [737]
			{
				["T"] = {
					"PandarenMonk.M2", -- [1]
				},
				["N"] = "Pandarenmonk",
			}, -- [738]
			{
				["T"] = {
					"PandarenPhoenixMount.M2", -- [1]
				},
				["N"] = "Pandarenphoenixmount",
			}, -- [739]
			{
				["T"] = {
					"PVPPandarenSerpentMount.M2", -- [1]
					"PandarenSerpent.M2", -- [2]
					"PandarenSerpentMount.M2", -- [3]
					"PandarenSerpentMount_Lightning.M2", -- [4]
					"PandarenSerpent_Lightning.M2", -- [5]
					"PandarenSerpent_low.M2", -- [6]
				},
				["N"] = "Pandarenserpent",
			}, -- [740]
			{
				["T"] = {
					"PandarenSerpentGod.M2", -- [1]
					"PandarenSerpentGodMount.M2", -- [2]
				},
				["N"] = "Pandarenserpentgod",
			}, -- [741]
			{
				["T"] = {
					"PandarenSerpentLowRes.M2", -- [1]
				},
				["N"] = "Pandarenserpentlowres",
			}, -- [742]
			{
				["T"] = {
					"PandarenSerpentPet.M2", -- [1]
					"PandarenSerpentPet_lightning.M2", -- [2]
				},
				["N"] = "Pandarenserpentpet",
			}, -- [743]
			{
				["T"] = {
					"PandarenStag.M2", -- [1]
				},
				["N"] = "Pandarenstag",
			}, -- [744]
			{
				["T"] = {
					"PandarenYeti.M2", -- [1]
					"PandarenYeti_low01.M2", -- [2]
				},
				["N"] = "Pandarenyeti",
			}, -- [745]
			{
				["T"] = {
					"PandarenYetiMount.m2", -- [1]
				},
				["N"] = "Pandarenyetimount",
			}, -- [746]
			{
				["T"] = {
					"Paperairplane_Gyro.m2", -- [1]
				},
				["N"] = "Paperairplane_gyro",
			}, -- [747]
			{
				["T"] = {
					"Paperairplane_Zeppelin.m2", -- [1]
				},
				["N"] = "Paperairplane_zeppelin",
			}, -- [748]
			{
				["T"] = {
					"Parrot.M2", -- [1]
				},
				["N"] = "Parrot",
			}, -- [749]
			{
				["T"] = {
					"peacock.M2", -- [1]
				},
				["N"] = "Peacock",
			}, -- [750]
			{
				["T"] = {
					"PegasusMount.M2", -- [1]
				},
				["N"] = "Pegasusmount",
			}, -- [751]
			{
				["T"] = {
					"PenguinPet.M2", -- [1]
				},
				["N"] = "Penguinpet",
			}, -- [752]
			{
				["T"] = {
					"Perotharn.M2", -- [1]
				},
				["N"] = "Perotharn",
			}, -- [753]
			{
				["T"] = {
					"Phoenix.M2", -- [1]
				},
				["N"] = "Phoenix",
			}, -- [754]
			{
				["T"] = {
					"PhoenixPet.M2", -- [1]
				},
				["N"] = "Phoenixpet",
			}, -- [755]
			{
				["T"] = {
					"Pig.M2", -- [1]
				},
				["N"] = "Pig",
			}, -- [756]
			{
				["T"] = {
					"Magtheridon.M2", -- [1]
					"Pitlord.M2", -- [2]
				},
				["N"] = "Pitlord",
			}, -- [757]
			{
				["T"] = {
					"PlantCorruptedOrc.m2", -- [1]
				},
				["N"] = "Plantcorruptedorc",
			}, -- [758]
			{
				["T"] = {
					"PlantHydra.M2", -- [1]
				},
				["N"] = "Planthydra",
			}, -- [759]
			{
				["T"] = {
					"platoonOrcs_glump.m2", -- [1]
				},
				["N"] = "Platoonorcs_glump",
			}, -- [760]
			{
				["T"] = {
					"Podling.m2", -- [1]
				},
				["N"] = "Podling",
			}, -- [761]
			{
				["T"] = {
					"Porcupine.M2", -- [1]
				},
				["N"] = "Porcupine",
			}, -- [762]
			{
				["T"] = {
					"PortalBlueArcane.m2", -- [1]
				},
				["N"] = "Portal",
			}, -- [763]
			{
				["T"] = {
					"PortalofKathune.m2", -- [1]
					"PortalofKathuneThick.m2", -- [2]
				},
				["N"] = "Portalofkathune",
			}, -- [764]
			{
				["T"] = {
					"PowerSparkCreature.M2", -- [1]
				},
				["N"] = "Powersparkcreature",
			}, -- [765]
			{
				["T"] = {
					"PrarieDog.M2", -- [1]
				},
				["N"] = "Prariedog",
			}, -- [766]
			{
				["T"] = {
					"PrimordialSaurok.M2", -- [1]
				},
				["N"] = "Primordialsaurok",
			}, -- [767]
			{
				["T"] = {
					"KorKronProtodrake.M2", -- [1]
					"KorKronProtodrakeMount.M2", -- [2]
					"MDProtoDrakeMount.M2", -- [3]
					"ProtoDragon.M2", -- [4]
					"ProtoDragonMount.M2", -- [5]
					"ProtoDragon_Razorscale.M2", -- [6]
					"ProtoDragon_Razorscale_Mount.M2", -- [7]
					"ProtoDragon_low01.M2", -- [8]
				},
				["N"] = "Protodragon",
			}, -- [768]
			{
				["T"] = {
					"Pterrordax.M2", -- [1]
				},
				["N"] = "Pterrordax",
			}, -- [769]
			{
				["T"] = {
					"PufferFish.M2", -- [1]
				},
				["N"] = "Pufferfish",
			}, -- [770]
			{
				["T"] = {
					"pug.M2", -- [1]
				},
				["N"] = "Pug",
			}, -- [771]
			{
				["T"] = {
					"PumpkinSoldier.M2", -- [1]
				},
				["N"] = "Pumpkinsoldier",
			}, -- [772]
			{
				["T"] = {
					"PygmyBase.M2", -- [1]
					"PygmyHunter.M2", -- [2]
					"PygmyRoadie.M2", -- [3]
					"PygmyShaman.M2", -- [4]
					"PygmyWarrior.M2", -- [5]
					"SandPygmy.M2", -- [6]
				},
				["N"] = "Pygmy",
			}, -- [773]
			{
				["T"] = {
					"PyroGryph.M2", -- [1]
				},
				["N"] = "Pyrogryph",
			}, -- [774]
			{
				["T"] = {
					"PythonPet.M2", -- [1]
				},
				["N"] = "Pythonpet",
			}, -- [775]
			{
				["T"] = {
					"BlackrockV2_ShieldGong_01.M2", -- [1]
					"BlackrockV2_ShieldGong_02.M2", -- [2]
					"BlackrockV2_ShieldGong_03.M2", -- [3]
					"BlackrockV2_ShieldGong_04.M2", -- [4]
					"BlackrockV2_ShieldGong_05.M2", -- [5]
					"BlackrockV2_ShieldGong_06.M2", -- [6]
					"BlackrockV2_ShieldGong_07.M2", -- [7]
					"BlackrockV2_ShieldGong_08.M2", -- [8]
					"Creature_BurningAsh.M2", -- [9]
					"Creature_BurningLegionCannon.M2", -- [10]
					"Creature_DemonCrystal_02.M2", -- [11]
					"Creature_EtherealStorm.M2", -- [12]
					"Creature_IceBlock.M2", -- [13]
					"Creature_IceBlock_Sindragosa.M2", -- [14]
					"Creature_NagaDistiller.M2", -- [15]
					"Creature_PowerCrystal.M2", -- [16]
					"Creature_Sc_Crystal.M2", -- [17]
					"Creature_ScourgeCrystal.M2", -- [18]
					"Creature_ScourgeCrystal02.M2", -- [19]
					"Creature_ScourgeCrystalDamaged.M2", -- [20]
					"Plate_Creature.m2", -- [21]
				},
				["N"] = "Questobjects",
			}, -- [776]
			{
				["T"] = {
					"Quilin.M2", -- [1]
					"QuilinFlyingMount.M2", -- [2]
					"QuilinFlyingMount_NoRibbon.M2", -- [3]
					"QuilinMount.M2", -- [4]
				},
				["N"] = "Quilin",
			}, -- [777]
			{
				["T"] = {
					"quilinpet.M2", -- [1]
				},
				["N"] = "Quilinpet",
			}, -- [778]
			{
				["T"] = {
					"QuillBoar.M2", -- [1]
					"QuillBoarCaster.M2", -- [2]
					"QuillBoarWarrior.M2", -- [3]
				},
				["N"] = "Quillboar",
			}, -- [779]
			{
				["T"] = {
					"BattleGuard.M2", -- [1]
				},
				["N"] = "Quirajbattleguard",
			}, -- [780]
			{
				["T"] = {
					"QuirajGladiator.M2", -- [1]
				},
				["N"] = "Quirajgladiator",
			}, -- [781]
			{
				["T"] = {
					"QuirajProphet.M2", -- [1]
				},
				["N"] = "Quirajprophet",
			}, -- [782]
			{
				["T"] = {
					"Rabbit.M2", -- [1]
					"RabbitGold.M2", -- [2]
				},
				["N"] = "Rabbit",
			}, -- [783]
			{
				["T"] = {
					"Raccoon.m2", -- [1]
				},
				["N"] = "Raccoon",
			}, -- [784]
			{
				["T"] = {
					"Raccoon2.M2", -- [1]
				},
				["N"] = "Raccoon2",
			}, -- [785]
			{
				["T"] = {
					"Ragnaros.M2", -- [1]
				},
				["N"] = "Ragnaros",
			}, -- [786]
			{
				["T"] = {
					"Ragnaros2.M2", -- [1]
				},
				["N"] = "Ragnaros2",
			}, -- [787]
			{
				["T"] = {
					"Rajah.M2", -- [1]
				},
				["N"] = "Rajah",
			}, -- [788]
			{
				["T"] = {
					"PVPRidingRam.M2", -- [1]
					"Ram.M2", -- [2]
					"RidingRam.M2", -- [3]
				},
				["N"] = "Ram",
			}, -- [789]
			{
				["T"] = {
					"MechanicalRaptorPet.M2", -- [1]
					"Raptor.M2", -- [2]
					"RaptorPet.M2", -- [3]
				},
				["N"] = "Raptor",
			}, -- [790]
			{
				["T"] = {
					"Raptor2.m2", -- [1]
					"ViciousWarRaptor.m2", -- [2]
				},
				["N"] = "Raptor2",
			}, -- [791]
			{
				["T"] = {
					"Raptor_Outland.M2", -- [1]
				},
				["N"] = "Raptoroutland",
			}, -- [792]
			{
				["T"] = {
					"Rat.M2", -- [1]
				},
				["N"] = "Rat",
			}, -- [793]
			{
				["T"] = {
					"Ravager2.m2", -- [1]
					"Ravager2Mount.M2", -- [2]
					"Ravager2Pet.m2", -- [3]
				},
				["N"] = "Ravager2",
			}, -- [794]
			{
				["T"] = {
					"raven.M2", -- [1]
					"raven_low01.M2", -- [2]
				},
				["N"] = "Raven",
			}, -- [795]
			{
				["T"] = {
					"RavenGod.M2", -- [1]
				},
				["N"] = "Ravengod",
			}, -- [796]
			{
				["T"] = {
					"RavenLord.M2", -- [1]
					"RavenLordMount.M2", -- [2]
					"RavenLord_Purple.m2", -- [3]
				},
				["N"] = "Ravenlord",
			}, -- [797]
			{
				["T"] = {
					"RavenLordPet.M2", -- [1]
				},
				["N"] = "Ravenlordpet",
			}, -- [798]
			{
				["T"] = {
					"RedDrakeMount.M2", -- [1]
				},
				["N"] = "Reddrakemount",
			}, -- [799]
			{
				["T"] = {
					"RedPanda.M2", -- [1]
				},
				["N"] = "Redpanda",
			}, -- [800]
			{
				["T"] = {
					"ReinDeer.m2", -- [1]
					"ReinDeerMount.m2", -- [2]
				},
				["N"] = "Reindeer",
			}, -- [801]
			{
				["T"] = {
					"RenFireTongue_Bake_01.M2", -- [1]
				},
				["N"] = "Renfiretongue_bake_01",
			}, -- [802]
			{
				["T"] = {
					"RevenantAir.M2", -- [1]
				},
				["N"] = "Revenantair",
			}, -- [803]
			{
				["T"] = {
					"RevenantEarth.M2", -- [1]
				},
				["N"] = "Revenantearth",
			}, -- [804]
			{
				["T"] = {
					"RevenantFire.M2", -- [1]
				},
				["N"] = "Revenantfire",
			}, -- [805]
			{
				["T"] = {
					"RevenantWater.M2", -- [1]
				},
				["N"] = "Revenantwater",
			}, -- [806]
			{
				["T"] = {
					"Rexxar.M2", -- [1]
				},
				["N"] = "Rexxar",
			}, -- [807]
			{
				["T"] = {
					"Vehicle_OpenRickshaw_01.M2", -- [1]
				},
				["N"] = "Rickshaw",
			}, -- [808]
			{
				["T"] = {
					"RidingDireWolfSpectral.M2", -- [1]
				},
				["N"] = "Ridingdirewolfspectral",
			}, -- [809]
			{
				["T"] = {
					"DraeneiPaladinElekk.M2", -- [1]
					"PaladinElekkElite.M2", -- [2]
					"RidingElekk.M2", -- [3]
					"RidingElekkElite.M2", -- [4]
				},
				["N"] = "Ridingelekk",
			}, -- [810]
			{
				["T"] = {
					"PackMule.M2", -- [1]
					"RidingHorse.M2", -- [2]
					"RidingHorsePvPT2.M2", -- [3]
					"RidingHorseSpectral.M2", -- [4]
				},
				["N"] = "Ridinghorse",
			}, -- [811]
			{
				["T"] = {
					"RidingNetherRay.M2", -- [1]
				},
				["N"] = "Ridingnetherray",
			}, -- [812]
			{
				["T"] = {
					"RidingPhoenix.M2", -- [1]
				},
				["N"] = "Ridingphoenix",
			}, -- [813]
			{
				["T"] = {
					"PvPRidingRaptor.M2", -- [1]
					"RidingRaptor.M2", -- [2]
				},
				["N"] = "Ridingraptor",
			}, -- [814]
			{
				["T"] = {
					"RidingSilithid.M2", -- [1]
				},
				["N"] = "Ridingsilithid",
			}, -- [815]
			{
				["T"] = {
					"RidingTalbuk.M2", -- [1]
					"RidingTalbukEpic.M2", -- [2]
				},
				["N"] = "Ridingtalbuk",
			}, -- [816]
			{
				["T"] = {
					"RidingTurtle.M2", -- [1]
				},
				["N"] = "Ridingturtle",
			}, -- [817]
			{
				["T"] = {
					"ArmoredRidingUndeadDrake.M2", -- [1]
					"RidingUndeadDrake.M2", -- [2]
				},
				["N"] = "Ridingundeaddrake",
			}, -- [818]
			{
				["T"] = {
					"RidingWyvern.M2", -- [1]
				},
				["N"] = "Ridingwyvern",
			}, -- [819]
			{
				["T"] = {
					"RidingWyvernArmored.M2", -- [1]
					"Wyvern_Armored_Vehicle.M2", -- [2]
				},
				["N"] = "Ridingwyvernarmored",
			}, -- [820]
			{
				["T"] = {
					"RidingYak.M2", -- [1]
				},
				["N"] = "Ridingyak",
			}, -- [821]
			{
				["T"] = {
					"RingWorm.M2", -- [1]
				},
				["N"] = "Ringworm",
			}, -- [822]
			{
				["T"] = {
					"RocketChicken.M2", -- [1]
				},
				["N"] = "Rocketchicken",
			}, -- [823]
			{
				["T"] = {
					"RocketMount.M2", -- [1]
				},
				["N"] = "Rocketmount",
			}, -- [824]
			{
				["T"] = {
					"RocketMount2.M2", -- [1]
				},
				["N"] = "Rocketmount2",
			}, -- [825]
			{
				["T"] = {
					"RocketMount3.M2", -- [1]
				},
				["N"] = "Rocketmount3",
			}, -- [826]
			{
				["T"] = {
					"RocketMount4.M2", -- [1]
				},
				["N"] = "Rocketmount4",
			}, -- [827]
			{
				["T"] = {
					"RockFlayer.m2", -- [1]
					"RockFlayerCrystal.m2", -- [2]
					"RockFlayerElite.M2", -- [3]
				},
				["N"] = "Rockflayer",
			}, -- [828]
			{
				["T"] = {
					"RomOgg.M2", -- [1]
				},
				["N"] = "Romogg",
			}, -- [829]
			{
				["T"] = {
					"EntanglingRoots_Brown_01.M2", -- [1]
				},
				["N"] = "Roots",
			}, -- [830]
			{
				["T"] = {
					"BE_Rowboat_vehicle.m2", -- [1]
					"DarkshoreBoat_vehicle.M2", -- [2]
					"RowBoat01_vehicle.M2", -- [3]
					"Troll_Rowboat_vehicle.M2", -- [4]
				},
				["N"] = "Rowboat_vehicle",
			}, -- [831]
			{
				["T"] = {
					"Saberon.m2", -- [1]
				},
				["N"] = "Saberon",
			}, -- [832]
			{
				["T"] = {
					"Saberworg.M2", -- [1]
					"SpectralSaberWorg.m2", -- [2]
				},
				["N"] = "Saberworg",
			}, -- [833]
			{
				["T"] = {
					"SalamanderMale.M2", -- [1]
				},
				["N"] = "Salamander",
			}, -- [834]
			{
				["T"] = {
					"SalamanderHunter.M2", -- [1]
				},
				["N"] = "Salamanderhunter",
			}, -- [835]
			{
				["T"] = {
					"Sandbox_Tiger_01.M2", -- [1]
				},
				["N"] = "Sandboxtiger",
			}, -- [836]
			{
				["T"] = {
					"SandElemental.M2", -- [1]
				},
				["N"] = "Sandelemental",
			}, -- [837]
			{
				["T"] = {
					"SandReaver.M2", -- [1]
				},
				["N"] = "Sandreaver",
			}, -- [838]
			{
				["T"] = {
					"SandTrollCouncilor.M2", -- [1]
				},
				["N"] = "Sandtrollcouncilor",
			}, -- [839]
			{
				["T"] = {
					"SandVortex.m2", -- [1]
				},
				["N"] = "Sandvortex",
			}, -- [840]
			{
				["T"] = {
					"SandWorm.M2", -- [1]
				},
				["N"] = "Sandworm",
			}, -- [841]
			{
				["T"] = {
					"Satyr.M2", -- [1]
				},
				["N"] = "Satyr",
			}, -- [842]
			{
				["T"] = {
					"ScaledDrakeMount.M2", -- [1]
				},
				["N"] = "Scaleddrakemount",
			}, -- [843]
			{
				["T"] = {
					"Scorpion.M2", -- [1]
				},
				["N"] = "Scorpion",
			}, -- [844]
			{
				["T"] = {
					"ScryingOrb.M2", -- [1]
				},
				["N"] = "Scryingorb",
			}, -- [845]
			{
				["T"] = {
					"SeaGiant.M2", -- [1]
				},
				["N"] = "Seagiant",
			}, -- [846]
			{
				["T"] = {
					"seagull.M2", -- [1]
				},
				["N"] = "Seagull",
			}, -- [847]
			{
				["T"] = {
					"Seahorse.M2", -- [1]
					"SeahorseMount.M2", -- [2]
					"Seahorse_Baby.M2", -- [3]
				},
				["N"] = "Seahorse",
			}, -- [848]
			{
				["T"] = {
					"SeaLion.M2", -- [1]
				},
				["N"] = "Sealion",
			}, -- [849]
			{
				["T"] = {
					"SeaSnake.M2", -- [1]
				},
				["N"] = "Seasnake",
			}, -- [850]
			{
				["T"] = {
					"SeaTurtle.M2", -- [1]
				},
				["N"] = "Seaturtle",
			}, -- [851]
			{
				["T"] = {
					"SeaVrykul.m2", -- [1]
				},
				["N"] = "Seavrykul",
			}, -- [852]
			{
				["T"] = {
					"SeaVrykulMale.M2", -- [1]
					"SeaVrykulMaleOarsman.M2", -- [2]
					"SeaVrykulMale_A.M2", -- [3]
				},
				["N"] = "Seavrykulmale",
			}, -- [853]
			{
				["T"] = {
					"Serpent.M2", -- [1]
					"SerpentRuby.m2", -- [2]
				},
				["N"] = "Serpent",
			}, -- [854]
			{
				["T"] = {
					"Setesh.M2", -- [1]
				},
				["N"] = "Setesh",
			}, -- [855]
			{
				["T"] = {
					"ShaBoss.M2", -- [1]
					"ShaBoss_unshaded.M2", -- [2]
				},
				["N"] = "Shaboss",
			}, -- [856]
			{
				["T"] = {
					"ShaBoss_Anger.M2", -- [1]
				},
				["N"] = "Shaboss_anger",
			}, -- [857]
			{
				["T"] = {
					"ShaBoss_Doubt.M2", -- [1]
				},
				["N"] = "Shaboss_doubt",
			}, -- [858]
			{
				["T"] = {
					"ShaBoss_Fear.M2", -- [1]
				},
				["N"] = "Shaboss_fear",
			}, -- [859]
			{
				["T"] = {
					"ShaBoss_Pride.M2", -- [1]
				},
				["N"] = "Shaboss_pride",
			}, -- [860]
			{
				["T"] = {
					"Shade.M2", -- [1]
				},
				["N"] = "Shade",
			}, -- [861]
			{
				["T"] = {
					"ShaHaunt.M2", -- [1]
					"ShaHaunt02.M2", -- [2]
					"ShaHaunt03.M2", -- [3]
					"ShaHauntPride.M2", -- [4]
					"ShaHaunt_Corrupted.M2", -- [5]
				},
				["N"] = "Shahaunt",
			}, -- [862]
			{
				["T"] = {
					"ShaleSpider.M2", -- [1]
				},
				["N"] = "Shalespider",
			}, -- [863]
			{
				["T"] = {
					"Shaman_Thrall.M2", -- [1]
				},
				["N"] = "Shaman_thrall",
			}, -- [864]
			{
				["T"] = {
					"ShaMedium.M2", -- [1]
					"ShaMedium02.M2", -- [2]
					"ShaMedium03.M2", -- [3]
					"ShaMediumPride.M2", -- [4]
					"ShaMedium_Corrupted.M2", -- [5]
				},
				["N"] = "Shamedium",
			}, -- [865]
			{
				["T"] = {
					"Shaohao.M2", -- [1]
				},
				["N"] = "Shaohao",
			}, -- [866]
			{
				["T"] = {
					"HammerHead.M2", -- [1]
					"Shark.M2", -- [2]
				},
				["N"] = "Shark",
			}, -- [867]
			{
				["T"] = {
					"ShatteredHandCaster.m2", -- [1]
					"ShatteredHandMelee.m2", -- [2]
				},
				["N"] = "Shatteredhandorcs",
			}, -- [868]
			{
				["T"] = {
					"Sheep.M2", -- [1]
				},
				["N"] = "Sheep",
			}, -- [869]
			{
				["T"] = {
					"Sherpa.M2", -- [1]
				},
				["N"] = "Sherpa",
			}, -- [870]
			{
				["T"] = {
					"Shivan.M2", -- [1]
					"Shivan_Pet.M2", -- [2]
				},
				["N"] = "Shivan",
			}, -- [871]
			{
				["T"] = {
					"ShovelTusk.m2", -- [1]
				},
				["N"] = "Shoveltusk",
			}, -- [872]
			{
				["T"] = {
					"ShredderMount.M2", -- [1]
					"shredderpet.m2", -- [2]
				},
				["N"] = "Shredder",
			}, -- [873]
			{
				["T"] = {
					"SiberianTiger.M2", -- [1]
					"SiberianTigerMount.M2", -- [2]
				},
				["N"] = "Siberiantiger",
			}, -- [874]
			{
				["T"] = {
					"SiberianTigerGod.M2", -- [1]
				},
				["N"] = "Siberiantigergod",
			}, -- [875]
			{
				["T"] = {
					"SiegeEngineer.M2", -- [1]
					"SiegeEngineerSaw.M2", -- [2]
					"SiegeEngineer_Doll.M2", -- [3]
				},
				["N"] = "Siegeengineer",
			}, -- [876]
			{
				["T"] = {
					"SiegeVehicle.m2", -- [1]
					"SiegeVehicleHasGun.M2", -- [2]
					"SiegeVehicle_Weapon_Cannon.m2", -- [3]
				},
				["N"] = "Siegevehicle",
			}, -- [877]
			{
				["T"] = {
					"Creature_6IH_IronHorde_SiegeWeapon01.M2", -- [1]
				},
				["N"] = "Siegeweapon",
			}, -- [878]
			{
				["T"] = {
					"Silithid.M2", -- [1]
				},
				["N"] = "Silithid",
			}, -- [879]
			{
				["T"] = {
					"Scarab_Pet.M2", -- [1]
					"SilithidScarab.M2", -- [2]
				},
				["N"] = "Silithidscarab",
			}, -- [880]
			{
				["T"] = {
					"SilithidTank.M2", -- [1]
				},
				["N"] = "Silithidtank",
			}, -- [881]
			{
				["T"] = {
					"SilithidTankBoss.M2", -- [1]
					"SilithidTankBoss_Damaged.M2", -- [2]
				},
				["N"] = "Silithidtankboss",
			}, -- [882]
			{
				["T"] = {
					"SilithidWasp.M2", -- [1]
				},
				["N"] = "Silithidwasp",
			}, -- [883]
			{
				["T"] = {
					"SilithidWaspBoss.M2", -- [1]
				},
				["N"] = "Silithidwaspboss",
			}, -- [884]
			{
				["T"] = {
					"Silkworm.M2", -- [1]
				},
				["N"] = "Silkworm",
			}, -- [885]
			{
				["T"] = {
					"creature_6IH_IronHorde_singleturret.m2", -- [1]
				},
				["N"] = "Singleturret",
			}, -- [886]
			{
				["T"] = {
					"SkeletalRaptor.M2", -- [1]
					"SkeletalRaptorMount.M2", -- [2]
					"SkeletalRaptorPet.M2", -- [3]
				},
				["N"] = "Skeletalraptor",
			}, -- [887]
			{
				["T"] = {
					"SkeletalSerpent.M2", -- [1]
				},
				["N"] = "Skeletalserpent",
			}, -- [888]
			{
				["T"] = {
					"SkeletalWarhorse.M2", -- [1]
				},
				["N"] = "Skeletalwarhorse",
			}, -- [889]
			{
				["T"] = {
					"Skeleton.M2", -- [1]
					"SkeletonNoHelm.m2", -- [2]
				},
				["N"] = "Skeleton",
			}, -- [890]
			{
				["T"] = {
					"SkeletonMage.M2", -- [1]
				},
				["N"] = "Skeletonmage",
			}, -- [891]
			{
				["T"] = {
					"SkeletonNaked.M2", -- [1]
				},
				["N"] = "Skeletonnaked",
			}, -- [892]
			{
				["T"] = {
					"skunk.M2", -- [1]
				},
				["N"] = "Skunk",
			}, -- [893]
			{
				["T"] = {
					"SlagElemental.M2", -- [1]
					"SlagElemental_Fury.m2", -- [2]
					"SlagElemental_Sessile.M2", -- [3]
				},
				["N"] = "Slagelemental",
			}, -- [894]
			{
				["T"] = {
					"Slime.M2", -- [1]
					"SlimeLesser.M2", -- [2]
					"Slime_Flame.M2", -- [3]
				},
				["N"] = "Slime",
			}, -- [895]
			{
				["T"] = {
					"GiantSlime.M2", -- [1]
				},
				["N"] = "Slimegiant",
			}, -- [896]
			{
				["T"] = {
					"Slith.M2", -- [1]
				},
				["N"] = "Slith",
			}, -- [897]
			{
				["T"] = {
					"Snail.M2", -- [1]
				},
				["N"] = "Snail",
			}, -- [898]
			{
				["T"] = {
					"snake.M2", -- [1]
				},
				["N"] = "Snake",
			}, -- [899]
			{
				["T"] = {
					"Snobold.m2", -- [1]
				},
				["N"] = "Snobold",
			}, -- [900]
			{
				["T"] = {
					"SnowFlakeCreature.m2", -- [1]
				},
				["N"] = "Snowflakecreature",
			}, -- [901]
			{
				["T"] = {
					"SnowMan.M2", -- [1]
				},
				["N"] = "Snowman",
			}, -- [902]
			{
				["T"] = {
					"SolarFlare_Creature.M2", -- [1]
				},
				["N"] = "Solarflarecreature",
			}, -- [903]
			{
				["T"] = {
					"spacegoat.m2", -- [1]
				},
				["N"] = "Spacegoat",
			}, -- [904]
			{
				["T"] = {
					"SpectralGryphon.M2", -- [1]
				},
				["N"] = "Spectralgryphon",
			}, -- [905]
			{
				["T"] = {
					"SpectralPorcupine.M2", -- [1]
				},
				["N"] = "Spectralporcupine",
			}, -- [906]
			{
				["T"] = {
					"Sandbox_SpectralTiger_01.M2", -- [1]
					"SpectralTiger.M2", -- [2]
					"SpectralTigerCub.m2", -- [3]
					"SpectralTigerEpic.M2", -- [4]
				},
				["N"] = "Spectraltiger",
			}, -- [907]
			{
				["T"] = {
					"SpectralTigerFeral.m2", -- [1]
				},
				["N"] = "Spectraltigerferal",
			}, -- [908]
			{
				["T"] = {
					"SpectralWyvern.M2", -- [1]
				},
				["N"] = "Spectralwyvern",
			}, -- [909]
			{
				["T"] = {
					"6OC_OrcClans_Totem_Air.M2", -- [1]
					"6OC_OrcClans_Totem_Earth.M2", -- [2]
					"6OC_OrcClans_Totem_Fire.M2", -- [3]
					"6OC_OrcClans_Totem_Water.M2", -- [4]
					"AirElementalTotem.M2", -- [5]
					"BallLightning_Creature.M2", -- [6]
					"BallLightning_Creature_Corrupted.M2", -- [7]
					"BattleStandard_Alliance.M2", -- [8]
					"BattleStandard_Frostwolf_A_01.M2", -- [9]
					"BattleStandard_Horde.M2", -- [10]
					"BattleStandard_Stormpike_A_01.M2", -- [11]
					"BattleStandard_Stormshield_A_01.m2", -- [12]
					"BattleStandard_Warspear_A_01.m2", -- [13]
					"Creature_ArcanePower_State_Chest.M2", -- [14]
					"Creature_Goo_Orb.M2", -- [15]
					"Creature_Goo_Orb_Corrupt.M2", -- [16]
					"Creature_SpellPortal.M2", -- [17]
					"DarkShaman_AshFlare_totem.M2", -- [18]
					"DarkShaman_FoulStream_totem.M2", -- [19]
					"DarkShaman_PoisonMist_totem.M2", -- [20]
					"DarkShaman_RustedIron_totem.M2", -- [21]
					"DraeneiTotem_Air.M2", -- [22]
					"DraeneiTotem_Earth.M2", -- [23]
					"DraeneiTotem_Fire.M2", -- [24]
					"DraeneiTotem_Water.M2", -- [25]
					"DragonBreath_Sinestra.M2", -- [26]
					"DwarvenTotem_Air.M2", -- [27]
					"DwarvenTotem_Earth.M2", -- [28]
					"DwarvenTotem_Fire.M2", -- [29]
					"DwarvenTotem_Water.M2", -- [30]
					"EarthElementalTotem.M2", -- [31]
					"EyeOfKilrog.M2", -- [32]
					"EyeOfKilrog_Blue.M2", -- [33]
					"FireElementalTotem.M2", -- [34]
					"FireForceShield_Purple_Sinestra.M2", -- [35]
					"FireLightTotem.M2", -- [36]
					"FireTotem.M2", -- [37]
					"FlameTurret.M2", -- [38]
					"GoblinShamanTotem_Air.M2", -- [39]
					"GoblinShamanTotem_Earth.M2", -- [40]
					"GoblinShamanTotem_Fire.M2", -- [41]
					"GoblinShamanTotem_Water.M2", -- [42]
					"Goo_Splash_StateFire.M2", -- [43]
					"HealingTotem.M2", -- [44]
					"InvisibilityTotem.M2", -- [45]
					"LandMine01.m2", -- [46]
					"LightningBolt_Creature.M2", -- [47]
					"LightningBolt_Creature_corrupted.M2", -- [48]
					"ManaTotem.M2", -- [49]
					"Monk_Chiji_Low.M2", -- [50]
					"MonsterLure01.m2", -- [51]
					"MonsterLure_02.M2", -- [52]
					"OrcTotem_01.m2", -- [53]
					"OrcTotem_Air.M2", -- [54]
					"OrcTotem_Earth.M2", -- [55]
					"OrcTotem_Fire.M2", -- [56]
					"OrcTotem_Water.M2", -- [57]
					"PandarenTotem_Air.M2", -- [58]
					"PandarenTotem_Earth.M2", -- [59]
					"PandarenTotem_Fire.M2", -- [60]
					"PandarenTotem_Water.M2", -- [61]
					"SentryTotem.M2", -- [62]
					"Serpent_Totem.M2", -- [63]
					"Skywall_Djinn_Frost_B4_Fight.M2", -- [64]
					"Skywall_Djinn_Healing_B4_Fight.M2", -- [65]
					"Skywall_Djinn_Tornado_B4_Fight.M2", -- [66]
					"StasisTotem.M2", -- [67]
					"TrollTotem_Air.M2", -- [68]
					"TrollTotem_Earth.M2", -- [69]
					"TrollTotem_Fire.M2", -- [70]
					"TrollTotem_Water.M2", -- [71]
					"Turtle_Zone_Wind.M2", -- [72]
					"ValentinesDummy.m2", -- [73]
					"Voljin_SerpentWard.M2", -- [74]
					"Warrior_DemoBanner_Buff.M2", -- [75]
					"Warrior_MockBanner_Buff.M2", -- [76]
					"Warrior_SkullBanner_Buff.M2", -- [77]
					"WaterElementalTotem.M2", -- [78]
					"orctotem_nohordesymbol_01.m2", -- [79]
				},
				["N"] = "Spells",
			}, -- [910]
			{
				["T"] = {
					"SpiritHealer.M2", -- [1]
				},
				["N"] = "Spirithealer",
			}, -- [911]
			{
				["T"] = {
					"SpiritOfRedemption.m2", -- [1]
				},
				["N"] = "Spiritofredemption",
			}, -- [912]
			{
				["T"] = {
					"SPOREBAT2.M2", -- [1]
					"SporeBat.M2", -- [2]
				},
				["N"] = "Sporebat",
			}, -- [913]
			{
				["T"] = {
					"SporeCreature.M2", -- [1]
				},
				["N"] = "Sporecreature",
			}, -- [914]
			{
				["T"] = {
					"Sporeling.m2", -- [1]
				},
				["N"] = "Sporeling",
			}, -- [915]
			{
				["T"] = {
					"Squirrel.M2", -- [1]
				},
				["N"] = "Squirrel",
			}, -- [916]
			{
				["T"] = {
					"Stag.M2", -- [1]
				},
				["N"] = "Stag",
			}, -- [917]
			{
				["T"] = {
					"Collapsing_Star.M2", -- [1]
				},
				["N"] = "Star",
			}, -- [918]
			{
				["T"] = {
					"StBernardDogPet.M2", -- [1]
				},
				["N"] = "Stbernarddogpet",
			}, -- [919]
			{
				["T"] = {
					"Creature_6DW_DarkIron_SteamTankCustom.M2", -- [1]
					"Creature_6DW_DarkIron_SteamTankCustom_NoTurret.m2", -- [2]
				},
				["N"] = "Steamtank",
			}, -- [920]
			{
				["T"] = {
					"SteamTonk.M2", -- [1]
				},
				["N"] = "Steamtonk",
			}, -- [921]
			{
				["T"] = {
					"SteelWarhorse.M2", -- [1]
				},
				["N"] = "Steelwarhorse",
			}, -- [922]
			{
				["T"] = {
					"stingray.M2", -- [1]
				},
				["N"] = "Stingray",
			}, -- [923]
			{
				["T"] = {
					"StoneKeeper.M2", -- [1]
				},
				["N"] = "Stonekeeper",
			}, -- [924]
			{
				["T"] = {
					"StoneTreeLog02_Mount.m2", -- [1]
					"StoneTreeLog03_Mount.m2", -- [2]
				},
				["N"] = "Stonetreelog",
			}, -- [925]
			{
				["T"] = {
					"StormCrow.m2", -- [1]
				},
				["N"] = "Stormcrow",
			}, -- [926]
			{
				["T"] = {
					"StormCrowDruid.M2", -- [1]
					"StormCrowDruid_Q.M2", -- [2]
				},
				["N"] = "Stormcrowdruid",
			}, -- [927]
			{
				["T"] = {
					"StormCrowMount.M2", -- [1]
				},
				["N"] = "Stormcrowmount",
			}, -- [928]
			{
				["T"] = {
					"StormCrowMount_low.m2", -- [1]
					"Stormcrowmount_solar.m2", -- [2]
					"stormcrowmount_solar_low.m2", -- [3]
				},
				["N"] = "Stormcrowmount_solar",
			}, -- [929]
			{
				["T"] = {
					"Succubus.m2", -- [1]
				},
				["N"] = "Succubus",
			}, -- [930]
			{
				["T"] = {
					"superzombie.M2", -- [1]
				},
				["N"] = "Superzombie",
			}, -- [931]
			{
				["T"] = {
					"SuperZombieArm.M2", -- [1]
				},
				["N"] = "Superzombiearm",
			}, -- [932]
			{
				["T"] = {
					"SwiftWindsteed.M2", -- [1]
					"SwiftWindsteed_Mount.M2", -- [2]
				},
				["N"] = "Swiftwindsteed",
			}, -- [933]
			{
				["T"] = {
					"T_Robot.M2", -- [1]
				},
				["N"] = "T_robot",
			}, -- [934]
			{
				["T"] = {
					"Talbuk.M2", -- [1]
				},
				["N"] = "Talbuk",
			}, -- [935]
			{
				["T"] = {
					"TalbukDraenor.M2", -- [1]
					"TalbukDraenorMount.m2", -- [2]
				},
				["N"] = "Talbukdraenor",
			}, -- [936]
			{
				["T"] = {
					"TallStrider.M2", -- [1]
				},
				["N"] = "Tallstrider",
			}, -- [937]
			{
				["T"] = {
					"Tarantula.M2", -- [1]
				},
				["N"] = "Tarantula",
			}, -- [938]
			{
				["T"] = {
					"Tauren_MountedCanoe.M2", -- [1]
				},
				["N"] = "Tauren_mountedcanoe",
			}, -- [939]
			{
				["T"] = {
					"DeathGuard.m2", -- [1]
				},
				["N"] = "Tempdeathguard",
			}, -- [940]
			{
				["T"] = {
					"ScarletCrusaderHeavy.m2", -- [1]
				},
				["N"] = "Tempscarletcrusaderheavy",
			}, -- [941]
			{
				["T"] = {
					"ScarletCrusaderLight.m2", -- [1]
				},
				["N"] = "Tempscarletcrusaderlight",
			}, -- [942]
			{
				["T"] = {
					"ScourgeMaleNPC.m2", -- [1]
				},
				["N"] = "Tempscourgemalenpc",
			}, -- [943]
			{
				["T"] = {
					"Tentacle.M2", -- [1]
				},
				["N"] = "Tentacle",
			}, -- [944]
			{
				["T"] = {
					"TerenasMenethil.m2", -- [1]
				},
				["N"] = "Terenasmenethil",
			}, -- [945]
			{
				["T"] = {
					"TeronGorefiend.M2", -- [1]
				},
				["N"] = "Terongorefiend",
			}, -- [946]
			{
				["T"] = {
					"TeronGorefiend_Mounted.m2", -- [1]
				},
				["N"] = "Terongorefiend_mounted",
			}, -- [947]
			{
				["T"] = {
					"Tharazun.m2", -- [1]
				},
				["N"] = "Tharazun",
			}, -- [948]
			{
				["T"] = {
					"Therazane.M2", -- [1]
				},
				["N"] = "Therazane",
			}, -- [949]
			{
				["T"] = {
					"Thorum.M2", -- [1]
				},
				["N"] = "Thorum",
			}, -- [950]
			{
				["T"] = {
					"ThrallDoomplate.M2", -- [1]
					"ThrallDoomplate_noballs.m2", -- [2]
				},
				["N"] = "Thralldoomplate",
			}, -- [951]
			{
				["T"] = {
					"Threshadon.M2", -- [1]
				},
				["N"] = "Threshadon",
			}, -- [952]
			{
				["T"] = {
					"ThresherShark.M2", -- [1]
				},
				["N"] = "Threshershark",
			}, -- [953]
			{
				["T"] = {
					"Thunderaan.M2", -- [1]
					"Thunderaan_Stave.M2", -- [2]
				},
				["N"] = "Thunderaan",
			}, -- [954]
			{
				["T"] = {
					"ThunderBeaver.M2", -- [1]
				},
				["N"] = "Thunderbeaver",
			}, -- [955]
			{
				["T"] = {
					"ThunderHydraBoss_Head1.M2", -- [1]
					"ThunderHydraBoss_Head2.M2", -- [2]
					"ThunderHydraBoss_Head3.M2", -- [3]
					"thunderhydra.m2", -- [4]
				},
				["N"] = "Thunderhydra",
			}, -- [956]
			{
				["T"] = {
					"ThunderIsleBabyBird.M2", -- [1]
					"ThunderIsleBird.M2", -- [2]
					"ThunderIsleBirdBossMount.M2", -- [3]
					"ThunderIsleYoungBird.M2", -- [4]
				},
				["N"] = "Thunderislebird",
			}, -- [957]
			{
				["T"] = {
					"MoguThunderKing.M2", -- [1]
				},
				["N"] = "Thunderking",
			}, -- [958]
			{
				["T"] = {
					"ThunderLizard.M2", -- [1]
				},
				["N"] = "Thunderlizard",
			}, -- [959]
			{
				["T"] = {
					"ThunderPterodactyl.M2", -- [1]
					"ThunderPterodactylMount.M2", -- [2]
					"ThunderPterodactyl_LOW.M2", -- [3]
				},
				["N"] = "Thunderpterodactyl",
			}, -- [960]
			{
				["T"] = {
					"ThunderTroll.M2", -- [1]
				},
				["N"] = "Thundertroll",
			}, -- [961]
			{
				["T"] = {
					"Tiger.M2", -- [1]
					"TigerGem.m2", -- [2]
					"TigerJade.M2", -- [3]
					"Tiger_Ghost.M2", -- [4]
					"Tigercub.m2", -- [5]
					"Tigercub_mechanical.M2", -- [6]
				},
				["N"] = "Tiger",
			}, -- [962]
			{
				["T"] = {
					"TigerGodCub.M2", -- [1]
				},
				["N"] = "Tigergodcub",
			}, -- [963]
			{
				["T"] = {
					"TigonFemale.M2", -- [1]
					"TigonMale.M2", -- [2]
				},
				["N"] = "Tigon",
			}, -- [964]
			{
				["T"] = {
					"TikiMask.m2", -- [1]
				},
				["N"] = "Tikimask",
			}, -- [965]
			{
				["T"] = {
					"TikiMask_Pet01.M2", -- [1]
					"TikiMask_Pet02.M2", -- [2]
					"TikiMask_Pet03.M2", -- [3]
				},
				["N"] = "Tikimask_pet01",
			}, -- [966]
			{
				["T"] = {
					"Time_Rift1.M2", -- [1]
				},
				["N"] = "Timerift",
			}, -- [967]
			{
				["T"] = {
					"TitanCaptured.M2", -- [1]
				},
				["N"] = "Titancaptured",
			}, -- [968]
			{
				["T"] = {
					"TitanFemale.M2", -- [1]
				},
				["N"] = "Titanfemale",
			}, -- [969]
			{
				["T"] = {
					"TitanMale.M2", -- [1]
					"TitanMale_Ghost.M2", -- [2]
				},
				["N"] = "Titanmale",
			}, -- [970]
			{
				["T"] = {
					"TitanOrb.m2", -- [1]
					"TitanOrb_02.M2", -- [2]
				},
				["N"] = "Titanorb",
			}, -- [971]
			{
				["T"] = {
					"6HU_TitleGarrison.m2", -- [1]
					"6OR_TitleGarrison.m2", -- [2]
				},
				["N"] = "Titlecard",
			}, -- [972]
			{
				["T"] = {
					"Toad.M2", -- [1]
				},
				["N"] = "Toad",
			}, -- [973]
			{
				["T"] = {
					"TolBaradFlameLeviathan.M2", -- [1]
					"TolBaradFlameLeviathan_Weapon_Cannon.M2", -- [2]
					"TolBaradFlameLeviathan_Weapon_CannonRolled.M2", -- [3]
				},
				["N"] = "Tolbaradflameleviathan",
			}, -- [974]
			{
				["T"] = {
					"Tolvir.M2", -- [1]
				},
				["N"] = "Tolvir",
			}, -- [975]
			{
				["T"] = {
					"ToothedShark.M2", -- [1]
				},
				["N"] = "Toothedshark",
			}, -- [976]
			{
				["T"] = {
					"ToothlessShark.M2", -- [1]
				},
				["N"] = "Toothlessshark",
			}, -- [977]
			{
				["T"] = {
					"Toucan.M2", -- [1]
				},
				["N"] = "Toucan",
			}, -- [978]
			{
				["T"] = {
					"TravelersYak.M2", -- [1]
					"TravelersYakSeat1.M2", -- [2]
					"TravelersYakSeat2.M2", -- [3]
					"TravelersYakVendor1.M2", -- [4]
					"TravelersYakVendor2.M2", -- [5]
				},
				["N"] = "Travelersyak",
			}, -- [979]
			{
				["T"] = {
					"TreasureGoblinPet.M2", -- [1]
				},
				["N"] = "Treasuregoblinpet",
			}, -- [980]
			{
				["T"] = {
					"AshenvaleTreeFalling01.M2", -- [1]
					"AshenvaleTreeFalling01_Invisible.M2", -- [2]
				},
				["N"] = "Tree",
			}, -- [981]
			{
				["T"] = {
					"HordeArmoredTrex.M2", -- [1]
					"trex.M2", -- [2]
				},
				["N"] = "Trex",
			}, -- [982]
			{
				["T"] = {
					"Triceratops.M2", -- [1]
					"TriceratopsMount.M2", -- [2]
				},
				["N"] = "Triceratops",
			}, -- [983]
			{
				["T"] = {
					"Tripod.M2", -- [1]
				},
				["N"] = "Tripod",
			}, -- [984]
			{
				["T"] = {
					"TrM_Garrison_H_SpearThrower.m2", -- [1]
				},
				["N"] = "Trm_garrison_h_spearthrower",
			}, -- [985]
			{
				["T"] = {
					"Troglodyte.M2", -- [1]
				},
				["N"] = "Troglodyte",
			}, -- [986]
			{
				["T"] = {
					"Troll.M2", -- [1]
					"TrollForestBoss.m2", -- [2]
					"TrollForestCaster.m2", -- [3]
					"TrollJungleBoss.M2", -- [4]
					"TrollJungleCaster.M2", -- [5]
					"TrollMelee.M2", -- [6]
					"TrollWhelp.M2", -- [7]
				},
				["N"] = "Troll",
			}, -- [987]
			{
				["T"] = {
					"Troll_Canoe_02_creature.M2", -- [1]
				},
				["N"] = "Troll_canoe_02_creature",
			}, -- [988]
			{
				["T"] = {
					"TrollDire.M2", -- [1]
				},
				["N"] = "Trolldire",
			}, -- [989]
			{
				["T"] = {
					"Turkey.M2", -- [1]
				},
				["N"] = "Turkey",
			}, -- [990]
			{
				["T"] = {
					"TurnipPet.M2", -- [1]
				},
				["N"] = "Turnippet",
			}, -- [991]
			{
				["T"] = {
					"PA_turret_01.M2", -- [1]
				},
				["N"] = "Turret",
			}, -- [992]
			{
				["T"] = {
					"Turtle.M2", -- [1]
				},
				["N"] = "Turtle",
			}, -- [993]
			{
				["T"] = {
					"TurtleFlipperL.M2", -- [1]
					"TurtleFlipperR.M2", -- [2]
				},
				["N"] = "Turtleflipper",
			}, -- [994]
			{
				["T"] = {
					"TurtleHead.M2", -- [1]
				},
				["N"] = "Turtlehead",
			}, -- [995]
			{
				["T"] = {
					"UD_TS_Kite.M2", -- [1]
				},
				["N"] = "Tuskarkite",
			}, -- [996]
			{
				["T"] = {
					"TuskarrMaleFisherman.m2", -- [1]
				},
				["N"] = "Tuskarrmalefisherman",
			}, -- [997]
			{
				["T"] = {
					"TwighlightDragon.M2", -- [1]
				},
				["N"] = "Twighlightdragon",
			}, -- [998]
			{
				["T"] = {
					"AscendantAir.M2", -- [1]
					"TwilightAscendantAir.M2", -- [2]
				},
				["N"] = "Twilightascendantair",
			}, -- [999]
			{
				["T"] = {
					"AscendantEarth.M2", -- [1]
					"TwilightAscendantEarth.M2", -- [2]
				},
				["N"] = "Twilightascendantearth",
			}, -- [1000]
			{
				["T"] = {
					"TwilightAscendantElementium.M2", -- [1]
				},
				["N"] = "Twilightascendantelementium",
			}, -- [1001]
			{
				["T"] = {
					"TwilightAscendantIce.M2", -- [1]
				},
				["N"] = "Twilightascendantice",
			}, -- [1002]
			{
				["T"] = {
					"AscendantWater.M2", -- [1]
					"TwilightAscendantWater.M2", -- [2]
				},
				["N"] = "Twilightascendantwater",
			}, -- [1003]
			{
				["T"] = {
					"TwilightsHammer_DragonEgg.M2", -- [1]
				},
				["N"] = "Twilightshammer_dragonegg",
			}, -- [1004]
			{
				["T"] = {
					"AscendantFire.M2", -- [1]
					"TwillightAscendantFire.M2", -- [2]
				},
				["N"] = "Twillightascendantfire",
			}, -- [1005]
			{
				["T"] = {
					"TwinEmperor.M2", -- [1]
				},
				["N"] = "Twinemperor",
			}, -- [1006]
			{
				["T"] = {
					"TyraelMount.M2", -- [1]
				},
				["N"] = "Tyraelmount",
			}, -- [1007]
			{
				["T"] = {
					"TyraelPet.M2", -- [1]
				},
				["N"] = "Tyraelpet",
			}, -- [1008]
			{
				["T"] = {
					"Tyrande.M2", -- [1]
				},
				["N"] = "Tyrande",
			}, -- [1009]
			{
				["T"] = {
					"Garrison_UI_chest_bronze.M2", -- [1]
					"Garrison_UI_chest_goldAlliance.M2", -- [2]
					"Garrison_UI_chest_goldhorde.M2", -- [3]
					"Garrison_UI_chest_silver.M2", -- [4]
				},
				["N"] = "Uichest",
			}, -- [1010]
			{
				["T"] = {
					"UldumWatcherCenter.M2", -- [1]
					"UldumWatcherLeft.M2", -- [2]
					"UldumWatcherRight.M2", -- [3]
				},
				["N"] = "Uldumwatcher",
			}, -- [1011]
			{
				["T"] = {
					"Ultraxion.M2", -- [1]
				},
				["N"] = "Ultraxion",
			}, -- [1012]
			{
				["T"] = {
					"UnboundWaterElementalMercury.M2", -- [1]
				},
				["N"] = "Unboundwaterelementalmercury",
			}, -- [1013]
			{
				["T"] = {
					"Undead_Eagle.m2", -- [1]
				},
				["N"] = "Undead_eagle",
			}, -- [1014]
			{
				["T"] = {
					"UndeadBeast.M2", -- [1]
				},
				["N"] = "Undeadbeast",
			}, -- [1015]
			{
				["T"] = {
					"NorthrendUndeadDrake.M2", -- [1]
					"UndeadDrake.m2", -- [2]
				},
				["N"] = "Undeaddrake",
			}, -- [1016]
			{
				["T"] = {
					"RidingUndeadHorse.M2", -- [1]
					"UndeadHorse.M2", -- [2]
				},
				["N"] = "Undeadhorse",
			}, -- [1017]
			{
				["T"] = {
					"UndeadIceTroll.M2", -- [1]
				},
				["N"] = "Undeadicetroll",
			}, -- [1018]
			{
				["T"] = {
					"UndeadNerubianBeast.m2", -- [1]
				},
				["N"] = "Undeadnerubianbeast",
			}, -- [1019]
			{
				["T"] = {
					"Unicorn.m2", -- [1]
				},
				["N"] = "Unicorn",
			}, -- [1020]
			{
				["T"] = {
					"Valkier.M2", -- [1]
				},
				["N"] = "Valkier",
			}, -- [1021]
			{
				["T"] = {
					"ValkierDark.M2", -- [1]
				},
				["N"] = "Valkierdark",
			}, -- [1022]
			{
				["T"] = {
					"ValkierPet.M2", -- [1]
				},
				["N"] = "Valkierpet",
			}, -- [1023]
			{
				["T"] = {
					"VampyrBloodPrince.m2", -- [1]
				},
				["N"] = "Vampyrbloodprince",
			}, -- [1024]
			{
				["T"] = {
					"Vapor.m2", -- [1]
				},
				["N"] = "Vapor",
			}, -- [1025]
			{
				["T"] = {
					"Velen.M2", -- [1]
				},
				["N"] = "Velen",
			}, -- [1026]
			{
				["T"] = {
					"Velen2.M2", -- [1]
				},
				["N"] = "Velen2",
			}, -- [1027]
			{
				["T"] = {
					"Verming.M2", -- [1]
					"Verming_Melee.M2", -- [2]
					"Verming_Tinkerer.M2", -- [3]
					"Verming_low01.M2", -- [4]
				},
				["N"] = "Verming",
			}, -- [1028]
			{
				["T"] = {
					"ViciousWarRam.m2", -- [1]
				},
				["N"] = "Viciouswarram",
			}, -- [1029]
			{
				["T"] = {
					"VoidCaller.M2", -- [1]
					"VoidCaller_v2.m2", -- [2]
					"voidcaller_gold.m2", -- [3]
				},
				["N"] = "Voidcaller",
			}, -- [1030]
			{
				["T"] = {
					"VOIDGOD_GOLD.M2", -- [1]
					"VoidGod.M2", -- [2]
					"VoidGod_v2.m2", -- [3]
				},
				["N"] = "Voidgod",
			}, -- [1031]
			{
				["T"] = {
					"VoidLord.M2", -- [1]
					"VoidLord_v2.m2", -- [2]
				},
				["N"] = "Voidlord",
			}, -- [1032]
			{
				["T"] = {
					"VoidTendril.M2", -- [1]
				},
				["N"] = "Voidtendril",
			}, -- [1033]
			{
				["T"] = {
					"VoidTerror.M2", -- [1]
				},
				["N"] = "Voidterror",
			}, -- [1034]
			{
				["T"] = {
					"VoidWalker.M2", -- [1]
				},
				["N"] = "Voidwalker",
			}, -- [1035]
			{
				["T"] = {
					"VoidWalker_Outland.M2", -- [1]
					"VoidWalker_Outland_v2.m2", -- [2]
				},
				["N"] = "Voidwalkeroutland",
			}, -- [1036]
			{
				["T"] = {
					"VoidWraith.M2", -- [1]
					"Voidwraith_v2.m2", -- [2]
					"voidwraith_gold.m2", -- [3]
				},
				["N"] = "Voidwraith",
			}, -- [1037]
			{
				["T"] = {
					"Voljin.M2", -- [1]
				},
				["N"] = "Voljin",
			}, -- [1038]
			{
				["T"] = {
					"Transport_Vrykul_Medium.m2", -- [1]
					"Transport_Vrykul_MediumLight.M2", -- [2]
				},
				["N"] = "Vrykulboat",
			}, -- [1039]
			{
				["T"] = {
					"FemaleVrykulBoss.M2", -- [1]
					"FrostVrykulFemaleCaster.M2", -- [2]
					"FrostVrykulFemaleDruid.M2", -- [3]
					"FrostVrykulFemaleHunter.M2", -- [4]
					"FrostVrykulFemaleWarrior.M2", -- [5]
					"VrykulFemale.m2", -- [6]
					"VrykulFemaleCaster.M2", -- [7]
					"VrykulFemaleDruid.m2", -- [8]
					"VrykulFemaleHunter.m2", -- [9]
					"VrykulFemaleWarrior.M2", -- [10]
				},
				["N"] = "Vrykulfemale",
			}, -- [1040]
			{
				["T"] = {
					"WailingWindsCreature.m2", -- [1]
				},
				["N"] = "Wailingwindscreature",
			}, -- [1041]
			{
				["T"] = {
					"ArgentWarhorse.M2", -- [1]
					"PVPWarHorse.M2", -- [2]
					"WarHorse.M2", -- [3]
				},
				["N"] = "Warhorse",
			}, -- [1042]
			{
				["T"] = {
					"Creature_6IH_IronHorde_WarMachine02.M2", -- [1]
				},
				["N"] = "Warmachine",
			}, -- [1043]
			{
				["T"] = {
					"WarNightSaberMount.M2", -- [1]
				},
				["N"] = "Warnightsabermount",
			}, -- [1044]
			{
				["T"] = {
					"WarpStalker.M2", -- [1]
					"WarpStalker_low.M2", -- [2]
				},
				["N"] = "Warpstalker",
			}, -- [1045]
			{
				["T"] = {
					"WarpStorm.M2", -- [1]
					"WarpStorm_Large.M2", -- [2]
					"WarpStorm_XLarge.M2", -- [3]
				},
				["N"] = "Warpstorm",
			}, -- [1046]
			{
				["T"] = {
					"Watcher.M2", -- [1]
				},
				["N"] = "Watcher",
			}, -- [1047]
			{
				["T"] = {
					"WaterBubbleCreature.m2", -- [1]
					"WaterBubbleCreature_NoSound.m2", -- [2]
				},
				["N"] = "Waterbubblecreature",
			}, -- [1048]
			{
				["T"] = {
					"DarkSaurok.M2", -- [1]
					"WaterDragon.M2", -- [2]
				},
				["N"] = "Waterdragon",
			}, -- [1049]
			{
				["T"] = {
					"WaterElemental.M2", -- [1]
					"WaterElemental_NoSplash.M2", -- [2]
				},
				["N"] = "Waterelemental",
			}, -- [1050]
			{
				["T"] = {
					"WaterElementalBoss.M2", -- [1]
					"WaterElementalBossCorrupted.M2", -- [2]
					"WaterElementalBoss_Dessicus.m2", -- [3]
				},
				["N"] = "Waterelementalboss",
			}, -- [1051]
			{
				["T"] = {
					"WaterElementalDraenor.m2", -- [1]
				},
				["N"] = "Waterelementaldraenor",
			}, -- [1052]
			{
				["T"] = {
					"WaterElementalMercury.M2", -- [1]
				},
				["N"] = "Waterelementalmercury",
			}, -- [1053]
			{
				["T"] = {
					"WaterSpiritSmall.M2", -- [1]
					"WaterSpiritSmallLesser.M2", -- [2]
				},
				["N"] = "Waterspiritsmall",
			}, -- [1054]
			{
				["T"] = {
					"WaterStrider.M2", -- [1]
					"WaterStriderMount.M2", -- [2]
					"WaterStriderMount_noSaddle.M2", -- [3]
				},
				["N"] = "Waterstrider",
			}, -- [1055]
			{
				["T"] = {
					"WellofSouls.m2", -- [1]
					"WellofSoulsGrief.M2", -- [2]
					"WellofSoulsPain.M2", -- [3]
					"WellofSoulsSeduction.M2", -- [4]
				},
				["N"] = "Wellofsouls",
			}, -- [1056]
			{
				["T"] = {
					"Wendigo.M2", -- [1]
				},
				["N"] = "Wendigo",
			}, -- [1057]
			{
				["T"] = {
					"Wendigo_02.M2", -- [1]
				},
				["N"] = "Wendigo_02",
			}, -- [1058]
			{
				["T"] = {
					"whack_a_gnoll.M2", -- [1]
					"whack_a_gnoll_baby.M2", -- [2]
					"whack_a_gnoll_elite.M2", -- [3]
				},
				["N"] = "Whackagnoll",
			}, -- [1059]
			{
				["T"] = {
					"WhaleShark.M2", -- [1]
				},
				["N"] = "Whaleshark",
			}, -- [1060]
			{
				["T"] = {
					"Wight.M2", -- [1]
					"WightScientist.M2", -- [2]
				},
				["N"] = "Wight",
			}, -- [1061]
			{
				["T"] = {
					"WINDSERPENT_Blood.m2", -- [1]
					"WindSerpent.m2", -- [2]
				},
				["N"] = "Windserpent",
			}, -- [1062]
			{
				["T"] = {
					"WindSerpentOutland.M2", -- [1]
				},
				["N"] = "Windserpentoutland",
			}, -- [1063]
			{
				["T"] = {
					"WingedHorse.M2", -- [1]
					"WingedHorse_NonFlying.M2", -- [2]
				},
				["N"] = "Wingedhorse",
			}, -- [1064]
			{
				["T"] = {
					"WingedLionMount.M2", -- [1]
				},
				["N"] = "Wingedlionmount",
			}, -- [1065]
			{
				["T"] = {
					"WingedLionPet.M2", -- [1]
				},
				["N"] = "Wingedlionpet",
			}, -- [1066]
			{
				["T"] = {
					"Wisp.M2", -- [1]
				},
				["N"] = "Wisp",
			}, -- [1067]
			{
				["T"] = {
					"Wolf.M2", -- [1]
					"Wolf_ghost.M2", -- [2]
				},
				["N"] = "Wolf",
			}, -- [1068]
			{
				["T"] = {
					"WolfDraenor.M2", -- [1]
					"WolfDraenorMount.M2", -- [2]
					"WolfDraenorMountArmored.M2", -- [3]
					"WolfDraenor_Fel.m2", -- [4]
					"WolfDraenor_Fire.m2", -- [5]
					"WolfDraenor_Shadow.m2", -- [6]
				},
				["N"] = "Wolfdraenor",
			}, -- [1069]
			{
				["T"] = {
					"Wolpertinger.M2", -- [1]
				},
				["N"] = "Wolpertinger",
			}, -- [1070]
			{
				["T"] = {
					"Wolvar.m2", -- [1]
				},
				["N"] = "Wolvar",
			}, -- [1071]
			{
				["T"] = {
					"WoolyRhino.m2", -- [1]
					"WoolyRhinoMount.M2", -- [2]
				},
				["N"] = "Woolyrhino",
			}, -- [1072]
			{
				["T"] = {
					"Worgen.m2", -- [1]
				},
				["N"] = "Worgen",
			}, -- [1073]
			{
				["T"] = {
					"WorgenFemaleKid.M2", -- [1]
				},
				["N"] = "Worgenfemalekid",
			}, -- [1074]
			{
				["T"] = {
					"WorgenMaleKid.M2", -- [1]
				},
				["N"] = "Worgenmalekid",
			}, -- [1075]
			{
				["T"] = {
					"Worm.M2", -- [1]
				},
				["N"] = "Worm",
			}, -- [1076]
			{
				["T"] = {
					"WorseRobot.M2", -- [1]
				},
				["N"] = "Worserobot",
			}, -- [1077]
			{
				["T"] = {
					"Wrathguard.M2", -- [1]
					"Wrathguard_Pet.M2", -- [2]
				},
				["N"] = "Wrathguard",
			}, -- [1078]
			{
				["T"] = {
					"Wyvern.M2", -- [1]
					"Wyvern_Armored.M2", -- [2]
					"Wyvern_Mount.m2", -- [3]
				},
				["N"] = "Wyvern",
			}, -- [1079]
			{
				["T"] = {
					"WyvernPet.M2", -- [1]
					"WyvernPetGeneric.M2", -- [2]
				},
				["N"] = "Wyvernpet",
			}, -- [1080]
			{
				["T"] = {
					"Yak.M2", -- [1]
				},
				["N"] = "Yak",
			}, -- [1081]
			{
				["T"] = {
					"YakGod.M2", -- [1]
				},
				["N"] = "Yakgod",
			}, -- [1082]
			{
				["T"] = {
					"YakGodPet.M2", -- [1]
				},
				["N"] = "Yakgodpet",
			}, -- [1083]
			{
				["T"] = {
					"Ordos.M2", -- [1]
					"Yaunka.M2", -- [2]
				},
				["N"] = "Yaunka",
			}, -- [1084]
			{
				["T"] = {
					"Yeti.M2", -- [1]
				},
				["N"] = "Yeti",
			}, -- [1085]
			{
				["T"] = {
					"Yeti_Greench.M2", -- [1]
				},
				["N"] = "Yeti_greench",
			}, -- [1086]
			{
				["T"] = {
					"Cataclysm_Tentacle.M2", -- [1]
					"YoggSaron.M2", -- [2]
					"YoggSaronBrain.m2", -- [3]
					"YoggSaronStage2.M2", -- [4]
					"YoggSaronTentacle.M2", -- [5]
					"YoggSaronTentacleMace.m2", -- [6]
					"YoggSaronTentacleMace_lootable.M2", -- [7]
					"YoggSaronTentacleThin.m2", -- [8]
					"YoggSaronTentacleThin_Vine.M2", -- [9]
				},
				["N"] = "Yoggsaron",
			}, -- [1087]
			{
				["T"] = {
					"Ysera.M2", -- [1]
					"Ysera2.M2", -- [2]
				},
				["N"] = "Ysera",
			}, -- [1088]
			{
				["T"] = {
					"YseraDragon.M2", -- [1]
				},
				["N"] = "Yseradragon",
			}, -- [1089]
			{
				["T"] = {
					"ZandalariBabyRaptor.M2", -- [1]
				},
				["N"] = "Zandalaribabyraptor",
			}, -- [1090]
			{
				["T"] = {
					"ZandalariBattlesaur.M2", -- [1]
					"ZandalariDevilsaur.M2", -- [2]
				},
				["N"] = "Zandalaridevilsaur",
			}, -- [1091]
			{
				["T"] = {
					"ZandalariGolem.M2", -- [1]
					"ZandalariGolemBoss.M2", -- [2]
				},
				["N"] = "Zandalarigolem",
			}, -- [1092]
			{
				["T"] = {
					"ZandalariTriceratops.M2", -- [1]
				},
				["N"] = "Zandalaritriceratops",
			}, -- [1093]
			{
				["T"] = {
					"ZandalariTroll.M2", -- [1]
				},
				["N"] = "Zandalaritroll",
			}, -- [1094]
			{
				["T"] = {
					"ZebraMount.M2", -- [1]
				},
				["N"] = "Zebramount",
			}, -- [1095]
			{
				["T"] = {
					"ZerglingPet.m2", -- [1]
				},
				["N"] = "Zergling",
			}, -- [1096]
			{
				["T"] = {
					"ZigguratCrystal.M2", -- [1]
				},
				["N"] = "Zigguratcrystal",
			}, -- [1097]
			{
				["T"] = {
					"Zippelin.M2", -- [1]
				},
				["N"] = "Zippelin",
			}, -- [1098]
			{
				["T"] = {
					"Zombie.M2", -- [1]
					"ZombieArm.M2", -- [2]
					"ZombieSword.M2", -- [3]
				},
				["N"] = "Zombie",
			}, -- [1099]
			{
				["T"] = {
					"ZombiefiedVrykul.m2", -- [1]
				},
				["N"] = "Zombiefiedvrykul",
			}, -- [1100]
			{
				["T"] = {
					"ZombiefiedVrykulCaster.M2", -- [1]
				},
				["N"] = "Zombiefiedvrykulcaster",
			}, -- [1101]
			{
				["T"] = {
					"ZuldrakGolem.M2", -- [1]
				},
				["N"] = "Zuldrakgolem",
			}, -- [1102]
			{
				["T"] = {
					"Zuljin.m2", -- [1]
				},
				["N"] = "Zuljin",
			}, -- [1103]
		},
		["N"] = "Creature",
	}, -- [3]
	{
		["T"] = {
			{
				["T"] = {
					"Ashrand_Bright_Sky01.M2", -- [1]
					"Ashrand_Polluted_Coal_Sky01.M2", -- [2]
					"Ashrand_Polluted_Sky01.M2", -- [3]
					"Ashrand_Sky01.M2", -- [4]
					"Auchindoun_Finale_Sky.M2", -- [5]
					"Aurora.m2", -- [6]
					"AuroraOrange.m2", -- [7]
					"AuroraYellowGreen.m2", -- [8]
					"AzjolNerub_SkyA.m2", -- [9]
					"Battlefield_Dirty_SkyBox.M2", -- [10]
					"BladesedgeForestSkyBox.m2", -- [11]
					"BladesedgeNightElfSkyBox.m2", -- [12]
					"BladesedgeSkyBox.m2", -- [13]
					"BoneWastesSkyBox.m2", -- [14]
					"COT_sky01.m2", -- [15]
					"CavernsOfTimeSky.m2", -- [16]
					"ChamberAspectsBlackSky.M2", -- [17]
					"ColdarraLunarEclipseSky.M2", -- [18]
					"ColdarraSky.m2", -- [19]
					"CostalIslandSkyBox.M2", -- [20]
					"DalaranSkyBox.m2", -- [21]
					"DarkmoonSky01.M2", -- [22]
					"DeathClouds.m2", -- [23]
					"DeathKnightFireSkyBox.m2", -- [24]
					"DeathSkybox.M2", -- [25]
					"DeathwingFightSky01.M2", -- [26]
					"DeathwingSkyboxTest.M2", -- [27]
					"Deepholm_Sky01.M2", -- [28]
					"DireMaulSkybox.m2", -- [29]
					"DragonblightScarletSkyBox.m2", -- [30]
					"FallofAzeroth01.M2", -- [31]
					"FirelandsSky01.M2", -- [32]
					"FrostwindDesert_Sky01.M2", -- [33]
					"FrostwindDesert_Sky02.M2", -- [34]
					"GorgrondDry_Sky01.m2", -- [35]
					"Gorgrond_Sky01.m2", -- [36]
					"HellfireSkyBox.m2", -- [37]
					"Hour_Twilight_Rewind_Time.M2", -- [38]
					"Hyjal_SkyBox.M2", -- [39]
					"IceCrownArthasDeathSky.m2", -- [40]
					"IceCrownCitadelSky.m2", -- [41]
					"IceCrownDarkSky.m2", -- [42]
					"IceCrownRaidSky01.m2", -- [43]
					"IceCrownRaidSky02.m2", -- [44]
					"IceCrownScourgeSky.M2", -- [45]
					"IceCrownSky.m2", -- [46]
					"IceCrownStarrySky.m2", -- [47]
					"IceCrownStormySky.m2", -- [48]
					"IceCrownSunsetSky.m2", -- [49]
					"IsleoftheThunderKing_Sky01.M2", -- [50]
					"IsleoftheThunderKing_Sky01_Light.M2", -- [51]
					"IsleoftheThunderKing_Sky01_LightPurple.M2", -- [52]
					"IsleoftheThunderKing_Sky01_Purple.M2", -- [53]
					"JadeForestSky01.M2", -- [54]
					"KezanSkyBox.M2", -- [55]
					"KunLaiSky01.M2", -- [56]
					"KunLaiSkyMountain01.M2", -- [57]
					"LostIsleGloomySkyBox.M2", -- [58]
					"LostIsleSkyBox.M2", -- [59]
					"LostIsleVocanoSkyBox.M2", -- [60]
					"Maelstrom_Sky01.M2", -- [61]
					"Maelstrom_Sky02_DeathwingFight.M2", -- [62]
					"Maelstrom_Sky03_Stormbreak.M2", -- [63]
					"MantidDarkSky01.M2", -- [64]
					"MantidDarkSky01_sha.M2", -- [65]
					"MantidLightSky01.M2", -- [66]
					"MantidLightSky01_blue.M2", -- [67]
					"MantidShaCap01.M2", -- [68]
					"MantidShaSky_Terrace01.M2", -- [69]
					"NagrandSkyBox.m2", -- [70]
					"Nagrand_DarkSky01.M2", -- [71]
					"Nagrand_ForestSky01.M2", -- [72]
					"Nagrand_Sky01.M2", -- [73]
					"NetherstormSkyBox.m2", -- [74]
					"NexusRaid_NebulaSky.M2", -- [75]
					"NexusRaid_RuneEffects_Nebula.M2", -- [76]
					"NexusRaid_RuneEffects_Starry.M2", -- [77]
					"NexusRaid_SkyA.M2", -- [78]
					"NexusRaid_StarrySky.M2", -- [79]
					"NexusRaid_Wormhole.M2", -- [80]
					"Nexus_Arcane_Sanctum.M2", -- [81]
					"OrgrimmarRaid_FireSky01.M2", -- [82]
					"PortalWorldLegionSky.m2", -- [83]
					"RubySanctumSky.m2", -- [84]
					"ShadowmoonBurialGrounds_VoidSky01.M2", -- [85]
					"ShadowmoonIllidan.m2", -- [86]
					"ShadowmoonSkyBox.m2", -- [87]
					"Shadowmoon_Botani_Green_Sky_01.m2", -- [88]
					"Shadowmoon_Botani_Sky_01.m2", -- [89]
					"Shadowmoon_Burial_Sky_01.M2", -- [90]
					"Shadowmoon_Fog_Sky01.m2", -- [91]
					"Shadowmoon_Moonwillow_Sky_01.m2", -- [92]
					"Shadowmoon_Overlook_Sky_01.M2", -- [93]
					"Shadowmoon_Sky01.M2", -- [94]
					"Shadowmoon_Sky_Forest01.M2", -- [95]
					"Shadowmoon_Sky_darkStar_01.m2", -- [96]
					"SkywallRaidSkyBox.M2", -- [97]
					"SkywallRaidStormySkyBox.M2", -- [98]
					"SkywallSkyBox.M2", -- [99]
					"SpiresofArrak_Sky01.M2", -- [100]
					"SpiresofArrak_Thorns_Sky01.m2", -- [101]
					"Stars.m2", -- [102]
					"StormPeaks_SkyA.m2", -- [103]
					"StormPeaks_SkyB_Storm.m2", -- [104]
					"StormPeaks_SkyC_Ulduar.m2", -- [105]
					"StratholmeSkybox.m2", -- [106]
					"Talador_Sky01.M2", -- [107]
					"Tanaan_Sky01.m2", -- [108]
					"Tu_SkyBox.M2", -- [109]
					"TwilightHighlandsSky.M2", -- [110]
					"TwilightHighlandsSky2.M2", -- [111]
					"TwilightRealmSky01.M2", -- [112]
					"TwilightsHammerSky.M2", -- [113]
					"Uldum_Sky01.M2", -- [114]
					"UlduranCloudySky.m2", -- [115]
					"ValleyEternalSky01.M2", -- [116]
					"ValleyFourWindsSky01.M2", -- [117]
					"WellOfEternity01.M2", -- [118]
					"WintergraspSmokySky.m2", -- [119]
					"WintergraspSmokySky_NIGHT.m2", -- [120]
					"ZulDrakSkyA.m2", -- [121]
					"ZulDrakSkyB.M2", -- [122]
					"ashran_sky01.m2", -- [123]
					"draenor_cloudysky01.m2", -- [124]
					"gorgrondbotani_sky01.m2", -- [125]
					"nagrand_aridsky01.m2", -- [126]
					"shadowmoon_sky01_eclipse.m2", -- [127]
					"shadowmoonburialgrounds_voidsky02.m2", -- [128]
					"spiresofarrak_darkforest_sky01.m2", -- [129]
					"spiresofarrak_fog_sky01.m2", -- [130]
					"spiresofarrak_swamp_sky01.m2", -- [131]
					"spiresofarrak_zangar_sky01.m2", -- [132]
					"taladorforest_sky01.m2", -- [133]
					"tanaan_darkportal_front_sky01.m2", -- [134]
				},
				["N"] = "Stars",
			}, -- [1]
		},
		["N"] = "Environments",
	}, -- [4]
	{
		["T"] = {
			{
				["T"] = {
					"TalkToMe.M2", -- [1]
					"TalkToMeBlue.M2", -- [2]
					"TalkToMeGreen.M2", -- [3]
					"TalkToMeGrey.M2", -- [4]
					"TalkToMeQuestionMark.M2", -- [5]
					"TalkToMeQuestion_Grey.M2", -- [6]
					"TalkToMeQuestion_LTBlue.M2", -- [7]
					"TalkToMeQuestion_White.M2", -- [8]
					"TalkToMeRed.M2", -- [9]
					"TalkToMeTrainerClass.M2", -- [10]
					"TalkToMe_Chat.M2", -- [11]
					"TalkToMe_Gears.M2", -- [12]
					"TalkToMe_Legendary.M2", -- [13]
					"TalkToMe_PetBattles.M2", -- [14]
					"TalkToMe_PetBattles_Gold.M2", -- [15]
					"TalkToMe_QuestionLegendary.M2", -- [16]
					"UI-AutoCastButton.m2", -- [17]
					"UI-BuffOn.m2", -- [18]
				},
				["N"] = "Buttons",
			}, -- [1]
			{
				["T"] = {
					"UI-Cooldown-Indicator.m2", -- [1]
				},
				["N"] = "Cooldown",
			}, -- [2]
			{
				["T"] = {
					{
						["T"] = {
							{
								["T"] = {
									"UI_Alliance.M2", -- [1]
								},
								["N"] = "Ui_alliance",
							}, -- [1]
							{
								["T"] = {
									"UI_Alliance_lowres.M2", -- [1]
								},
								["N"] = "Ui_alliance_lowres",
							}, -- [2]
							{
								["T"] = {
									"UI_BloodElf.M2", -- [1]
								},
								["N"] = "Ui_bloodelf",
							}, -- [3]
							{
								["T"] = {
									"UI_CharacterSelect.M2", -- [1]
								},
								["N"] = "Ui_characterselect",
							}, -- [4]
							{
								["T"] = {
									"UI_DeathKnight.M2", -- [1]
								},
								["N"] = "Ui_deathknight",
							}, -- [5]
							{
								["T"] = {
									"UI_Draenei.M2", -- [1]
								},
								["N"] = "Ui_draenei",
							}, -- [6]
							{
								["T"] = {
									"UI_Dwarf.m2", -- [1]
								},
								["N"] = "Ui_dwarf",
							}, -- [7]
							{
								["T"] = {
									"UI_Gnome.M2", -- [1]
								},
								["N"] = "Ui_gnome",
							}, -- [8]
							{
								["T"] = {
									"UI_Goblin.M2", -- [1]
								},
								["N"] = "Ui_goblin",
							}, -- [9]
							{
								["T"] = {
									"UI_Horde.M2", -- [1]
								},
								["N"] = "Ui_horde",
							}, -- [10]
							{
								["T"] = {
									"UI_Horde_lowres.M2", -- [1]
								},
								["N"] = "Ui_horde_lowres",
							}, -- [11]
							{
								["T"] = {
									"UI_Human.M2", -- [1]
								},
								["N"] = "Ui_human",
							}, -- [12]
							{
								["T"] = {
									"UI_MainMenu.m2", -- [1]
								},
								["N"] = "Ui_mainmenu",
							}, -- [13]
							{
								["T"] = {
									"UI_MainMenu_BurningCrusade.m2", -- [1]
								},
								["N"] = "Ui_mainmenu_burningcrusade",
							}, -- [14]
							{
								["T"] = {
									"UI_MainMenu_Cata_LowBandwidth.M2", -- [1]
								},
								["N"] = "Ui_mainmenu_cata_lowbandwidth",
							}, -- [15]
							{
								["T"] = {
									"UI_MainMenu_Cataclysm.M2", -- [1]
								},
								["N"] = "Ui_mainmenu_cataclysm",
							}, -- [16]
							{
								["T"] = {
									"UI_MainMenu_LowBandwidth.M2", -- [1]
								},
								["N"] = "Ui_mainmenu_lowbandwidth",
							}, -- [17]
							{
								["T"] = {
									"UI_MainMenu_Northrend.M2", -- [1]
								},
								["N"] = "Ui_mainmenu_northrend",
							}, -- [18]
							{
								["T"] = {
									"UI_MainMenu_Pandaria.M2", -- [1]
								},
								["N"] = "Ui_mainmenu_pandaria",
							}, -- [19]
							{
								["T"] = {
									"UI_MainMenu_Warlords.m2", -- [1]
									"UI_MainMenu_Warlords_LowBandwidth.m2", -- [2]
								},
								["N"] = "Ui_mainmenu_warlords",
							}, -- [20]
							{
								["T"] = {
									"UI_NightElf.M2", -- [1]
								},
								["N"] = "Ui_nightelf",
							}, -- [21]
							{
								["T"] = {
									"UI_Orc.M2", -- [1]
								},
								["N"] = "Ui_orc",
							}, -- [22]
							{
								["T"] = {
									"UI_Pandaren.M2", -- [1]
								},
								["N"] = "Ui_pandaren",
							}, -- [23]
							{
								["T"] = {
									"UI_PandarenCharacterSelect.M2", -- [1]
								},
								["N"] = "Ui_pandarencharacterselect",
							}, -- [24]
							{
								["T"] = {
									"UI_PandarenCharacterSelect_lowres.M2", -- [1]
								},
								["N"] = "Ui_pandarencharacterselect_lowres",
							}, -- [25]
							{
								["T"] = {
									"UI_RS_Dwarf.m2", -- [1]
								},
								["N"] = "Ui_rs_dwarf",
							}, -- [26]
							{
								["T"] = {
									"UI_RS_Human.m2", -- [1]
								},
								["N"] = "Ui_rs_human",
							}, -- [27]
							{
								["T"] = {
									"UI_RS_NightElf.M2", -- [1]
								},
								["N"] = "Ui_rs_nightelf",
							}, -- [28]
							{
								["T"] = {
									"UI_RS_Orc.m2", -- [1]
								},
								["N"] = "Ui_rs_orc",
							}, -- [29]
							{
								["T"] = {
									"UI_RS_Scourge.m2", -- [1]
								},
								["N"] = "Ui_rs_scourge",
							}, -- [30]
							{
								["T"] = {
									"UI_RS_Tauren.M2", -- [1]
								},
								["N"] = "Ui_rs_tauren",
							}, -- [31]
							{
								["T"] = {
									"UI_Scourge.M2", -- [1]
								},
								["N"] = "Ui_scourge",
							}, -- [32]
							{
								["T"] = {
									"UI_Tauren.M2", -- [1]
								},
								["N"] = "Ui_tauren",
							}, -- [33]
							{
								["T"] = {
									"UI_Troll.M2", -- [1]
								},
								["N"] = "Ui_troll",
							}, -- [34]
							{
								["T"] = {
									"UI_Worgen.M2", -- [1]
								},
								["N"] = "Ui_worgen",
							}, -- [35]
						},
						["N"] = "Models",
					}, -- [1]
				},
				["N"] = "Glues",
			}, -- [3]
			{
				["T"] = {
					"ForcedBackpackItem.M2", -- [1]
				},
				["N"] = "Itemanimations",
			}, -- [4]
			{
				["T"] = {
					{
						["T"] = {
							"MinimapPing.m2", -- [1]
						},
						["N"] = "Ping",
					}, -- [1]
					"MinimapArrow.m2", -- [2]
					"MinimapCompassRing.M2", -- [3]
					"Rotating-MinimapArrow.m2", -- [4]
					"Rotating-MinimapGroupArrow.m2", -- [5]
				},
				["N"] = "Minimap",
			}, -- [5]
			{
				["T"] = {
					"6HU_Title_Garrison.m2", -- [1]
					"6IH_Title_Blackhand.m2", -- [2]
					"6IH_Title_Guldan.m2", -- [3]
					"6IH_Title_Kargath.m2", -- [4]
					"6IH_Title_Kilrogg.m2", -- [5]
					"6IH_Title_Nerzhul.m2", -- [6]
					"6OR_Title_Garrison.m2", -- [7]
				},
				["N"] = "Titlecards",
			}, -- [6]
			{
				["T"] = {
					"Vehicle_Target_01.m2", -- [1]
					"Vehicle_Target_02.M2", -- [2]
				},
				["N"] = "Vehicles",
			}, -- [7]
		},
		["N"] = "Interface",
	}, -- [5]
	{
		["T"] = {
			{
				["T"] = {
					{
						["T"] = {
							"ND_Forsaken_Barricade_Doodad.m2", -- [1]
							"ND_Forsaken_ShipWreckSkulls.m2", -- [2]
						},
						["N"] = "Nd_forsaken",
					}, -- [1]
				},
				["N"] = "Buildings",
			}, -- [1]
		},
		["N"] = "Interiors",
	}, -- [6]
	{
		["T"] = {
			{
				["T"] = {
					{
						["T"] = {
							"ArrowAcidFlight_01.M2", -- [1]
							"ArrowFireFlight_01.M2", -- [2]
							"ArrowFlight_01.M2", -- [3]
							"ArrowIceFlight_01.M2", -- [4]
							"ArrowMagicFlight_01.M2", -- [5]
							"BulletFlight_01.M2", -- [6]
							"arrow_firearm_2h_rifle_draenorraid_d_01.m2", -- [7]
						},
						["N"] = "Ammo",
					}, -- [1]
					{
						["T"] = {
							"Parachute_01.M2", -- [1]
						},
						["N"] = "Backpack",
					}, -- [2]
					{
						["T"] = {
							{
								["T"] = {
									"BattleStandard_Alliance_A_01.M2", -- [1]
								},
								["N"] = "Battlestandard_alliance_a_01",
							}, -- [1]
							{
								["T"] = {
									"BattleStandard_Horde_A_01.M2", -- [1]
								},
								["N"] = "Battlestandard_horde_a_01",
							}, -- [2]
						},
						["N"] = "Battlestandards",
					}, -- [3]
					{
						["T"] = {
							"Helm_Blindfold_A_01_BeF.m2", -- [1]
							"Helm_Blindfold_A_01_BeM.m2", -- [2]
							"Helm_Blindfold_A_01_DrF.m2", -- [3]
							"Helm_Blindfold_A_01_DrM.m2", -- [4]
							"helm_robe_raidmage_f_01electric_WoM.m2", -- [15040]
						},
						["N"] = "Head",
					}, -- [4]
					{
						["T"] = {
							"Quiver_A.m2", -- [1]
							"Quiver_Bolt_A_01.m2", -- [2]
							"Quiver_Horde_A_01.m2", -- [3]
						},
						["N"] = "Quiver",
					}, -- [5]
					{
						["T"] = {
							"Player_Scroll_animated.M2", -- [1]
							"Xmas_Player_Scroll_Animated.M2", -- [2]
						},
						["N"] = "Scroll",
					}, -- [6]
					{
						["T"] = {
							"Buckler_Damaged_A_01.m2", -- [1]
							"Buckler_Damaged_A_02.m2", -- [2]
							"Buckler_Oval_A_01.m2", -- [3]
							"shield_warsongclan_c_01.m2", -- [191]
						},
						["N"] = "Shield",
					}, -- [7]
					{
						["T"] = {
							"LShoulder_Cloth_Cataclysm_B_01.M2", -- [1]
							"LShoulder_Cloth_Cataclysm_B_02.M2", -- [2]
							"rshoulder_plate_raidwarrior_o_01.m2", -- [1162]
						},
						["N"] = "Shoulder",
					}, -- [8]
					{
						["T"] = {
							"Buckle_Cloth_ChallengeMage_D_01.M2", -- [1]
							"Buckle_Cloth_ChallengePriest_D_01.M2", -- [2]
							"kargathbladefist_buckle.m2", -- [132]
						},
						["N"] = "Waist",
					}, -- [9]
					{
						["T"] = {
							"1HTrollSpear01.M2", -- [1]
							"Ashbringer02.M2", -- [2]
							"Axe2H_PandariaTradeskill_C_01.M2", -- [3]
							"wand_1h_pvpdraenors1_d_01.m2", -- [2363]
						},
						["N"] = "Weapon",
					}, -- [10]
				},
				["N"] = "Objectcomponents",
			}, -- [1]
		},
		["N"] = "Item",
	}, -- [7]
	{
		["T"] = {
			{
				["T"] = {
					"BloodSpurt.M2", -- [1]
					"BloodSpurtBlack.M2", -- [2]
					"BloodSpurtBlackLarge.M2", -- [3]
					"BloodSpurtBlue.M2", -- [4]
					"BloodSpurtBlueLarge.M2", -- [5]
					"BloodSpurtGreen.M2", -- [6]
					"BloodSpurtGreenLarge.M2", -- [7]
					"BloodSpurtLarge.M2", -- [8]
				},
				["N"] = "Bloodspurts",
			}, -- [1]
			"Bubbles.M2", -- [2]
			"ColdBreath.M2", -- [3]
			"Ember_Trail.M2", -- [4]
			"FootStepSprayDirt.m2", -- [5]
			"FootStepSprayDirtWalk.m2", -- [6]
			"FootStepSpraySnow.m2", -- [7]
			"FootStepSpraySnowWalk.M2", -- [8]
			"FootStepSprayWater.M2", -- [9]
			"FootStepSprayWaterWalk.M2", -- [10]
			"LoginFX.m2", -- [11]
			"LootFX.M2", -- [12]
			"LootFX_Green.M2", -- [13]
			"MorphFX.M2", -- [14]
			"Pick_SpellObject.m2", -- [15]
			"greenleaves.m2", -- [16]
		},
		["N"] = "Particles",
	}, -- [8]
	{
		["T"] = {
			"SonicBoom_ImpactDD_Uber_Chest.M2", -- [1]
		},
		["N"] = "Spell",
	}, -- [9]
	{
		["T"] = {
			{
				["T"] = {
					"BattleMasterGlow_High.M2", -- [1]
					"BlackFlame_Low.M2", -- [2]
					"BlackGlow_High.M2", -- [3]
					"BlackGlow_Low.M2", -- [4]
					"BlueFlame_High.M2", -- [5]
					"BlueFlame_Low.M2", -- [6]
					"BlueGlow_High.M2", -- [7]
					"BlueGlow_Low.M2", -- [8]
					"BlueGlow_Med.M2", -- [9]
					"DisintigrateGlow_High.M2", -- [10]
					"Earthen_High.M2", -- [11]
					"ExecutionerGlow_High.M2", -- [12]
					"Fire_High.M2", -- [13]
					"Frost_High.M2", -- [14]
					"GreenFlame_Low.M2", -- [15]
					"GreenGlow_High.M2", -- [16]
					"GreenGlow_Low.M2", -- [17]
					"MongooseGlow_High.m2", -- [18]
					"Nature_High.M2", -- [19]
					"PoisonDrip.m2", -- [20]
					"PurpleFlame_Low.m2", -- [21]
					"PurpleGlow_High.m2", -- [22]
					"PurpleGlow_Low.m2", -- [23]
					"RedFlame_Low.m2", -- [24]
					"RedGlow_High.m2", -- [25]
					"RedGlow_Low.m2", -- [26]
					"Rune_Intellect.M2", -- [27]
					"SavageryGlow_High.m2", -- [28]
					"Shaman_Fire.M2", -- [29]
					"Shaman_Frost.M2", -- [30]
					"Shaman_Green.m2", -- [31]
					"Shaman_Purple.m2", -- [32]
					"Shaman_Red.m2", -- [33]
					"Shaman_Rock.m2", -- [34]
					"Shaman_Wind.M2", -- [35]
					"Shaman_Yellow.m2", -- [36]
					"SkullBalls.M2", -- [37]
					"SoulFrostGlow_High.m2", -- [38]
					"Sparkle_A.M2", -- [39]
					"SpellSurgeGlow_High.m2", -- [40]
					"SunFireGlow_High.m2", -- [41]
					"WhiteFlame_Low.M2", -- [42]
					"WhiteGlow_High.m2", -- [43]
					"WhiteGlow_Low.m2", -- [44]
					"Wind_High.M2", -- [45]
					"YellowFlame_Low.m2", -- [46]
					"YellowGlow_High.m2", -- [47]
					"YellowGlow_Low.m2", -- [48]
				},
				["N"] = "Enchantments",
			}, -- [1]
			{
				["T"] = {
					"Valentines_BrokenHeart.m2", -- [1]
					"Valentines_CupidsArrow_Impact_Chest.M2", -- [2]
					"Valentines_CupidsArrow_Missle.M2", -- [3]
					"Valentines_LookingForLoveHeart.m2", -- [4]
					"Valentines_RoseShower_Impact_Base.m2", -- [5]
					"Valentines_SpellObject_CupidsBow.M2", -- [6]
				},
				["N"] = "Holidays",
			}, -- [2]
			{
				["T"] = {
					"LevelUp.M2", -- [1]
				},
				["N"] = "Levelup",
			}, -- [3]
			{
				["T"] = {
					"LevelUpSpell.M2", -- [1]
				},
				["N"] = "Levelupspell",
			}, -- [4]
			"6FX_Bonfire.M2", -- [5]
			"6FX_Bonfire_withSmoke.M2", -- [6]
			"6FX_SmallFire.M2", -- [7]
			"6FX_SmallFire_Wind.m2", -- [8]
			"6SM_VoidFXDoor.m2", -- [9]
			"6_0_FlamesofRagnaros_Enchant.m2", -- [10]
			"6_0_WeaponEnchant_Armor_High.m2", -- [11]
			"6_0_WeaponEnchant_Armor_Low.m2", -- [12]
			"6_0_WeaponEnchant_Damage_High.m2", -- [13]
			"6_0_WeaponEnchant_Damage_Low.m2", -- [14]
			"6_0_WeaponEnchant_Haste_High.m2", -- [15]
			"6_0_WeaponEnchant_Haste_Low.m2", -- [16]
			"6_0_WeaponEnchant_Healing_High.m2", -- [17]
			"6_0_WeaponEnchant_Healing_Low.m2", -- [18]
			"6_0_WeaponEnchant_MultiStrike_High.m2", -- [19]
			"6_0_WeaponEnchant_MultiStrike_Low.m2", -- [20]
			"6_0_WeaponEnchant_PVP.m2", -- [21]
			"6fx_bonfire_wind.m2", -- [22]
			"6fx_bonfire_wind_withsmoke.m2", -- [23]
			"6fx_custom_crystalzap.m2", -- [24]
			"6fx_fire_medium_lowslow.m2", -- [25]
			"6oc_OrcClans_candleflame_purple.m2", -- [26]
			"6sm_nerzhulritual_state.m2", -- [27]
			"AbolishMagic_Base.M2", -- [28]
			"Abyssal_Ball.m2", -- [29]
			"Abyssal_Coral_Lamp_Lightning.M2", -- [30]
			"Abyssal_Coral_Lamp_Lightning_LowRes.M2", -- [31]
			"Abyssal_Impact_Base.M2", -- [32]
			"Achievement_OnRoot.M2", -- [33]
			"AcidBreath.M2", -- [34]
			"AcidBreath_SuperGreen.M2", -- [35]
			"AcidBurn.M2", -- [36]
			"AcidBurn_Black.M2", -- [37]
			"AcidBurn_Blue.M2", -- [38]
			"AcidBurn_LightBlue.M2", -- [39]
			"AcidBurn_Orange.M2", -- [40]
			"AcidBurn_Purple.M2", -- [41]
			"AcidBurn_Red.M2", -- [42]
			"AcidBurn_Small.M2", -- [43]
			"AcidBurn_Small_Black.M2", -- [44]
			"AcidBurn_Small_Black_wo_Bubbles.M2", -- [45]
			"AcidBurn_Small_Blue.M2", -- [46]
			"AcidBurn_Small_Orange.M2", -- [47]
			"AcidBurn_Small_Purple.M2", -- [48]
			"AcidBurn_Small_Red.M2", -- [49]
			"AcidBurn_Small_Yellow.M2", -- [50]
			"AcidBurn_Yellow.M2", -- [51]
			"AcidBurn_small_LightBlue.M2", -- [52]
			"AcidBurn_small_orange_V2.M2", -- [53]
			"AcidCloudBreath.M2", -- [54]
			"AcidCloudBreath_Fast.M2", -- [55]
			"AcidCloudBreath_Fast_Blue.m2", -- [56]
			"AcidCloudBreath_GroundSmoke.m2", -- [57]
			"AcidCloudBreath_GroundSmoke_Blue.M2", -- [58]
			"AcidLiquidBreath.M2", -- [59]
			"AcidLiquidBreathRed.M2", -- [60]
			"AcidLiquidBreath_Purple.M2", -- [61]
			"Acid_Ground_Cloud.m2", -- [62]
			"Acid_Ground_Cloud_Purple.m2", -- [63]
			"Acidliquidbreath_dark_beer.M2", -- [64]
			"Acidliquidbreath_medium_beer.M2", -- [65]
			"Acidliquidbreath_wheat_beer.M2", -- [66]
			"AdrenalineRush_Cast_Base.M2", -- [67]
			"Aegis.M2", -- [68]
			"AimedShot_Impact_Chest.M2", -- [69]
			"Alizabal_Whirlwind_State.M2", -- [70]
			"AllianceCTFflag_Generic_spell.M2", -- [71]
			"AllianceCTFflag_spell.M2", -- [72]
			"Alliance_ArenaFlagR1.m2", -- [73]
			"Alliance_ArenaFlagR2.m2", -- [74]
			"Alliance_ArenaFlagR3.m2", -- [75]
			"Alliance_ArenaFlagR4.m2", -- [76]
			"Altar_of_Ascension_FX.M2", -- [77]
			"Alysrazor_Wings_01.M2", -- [78]
			"AmberBarrier_Selectable.M2", -- [79]
			"AmberBarrier_State.M2", -- [80]
			"AmberSpirit_High.M2", -- [81]
			"AmplifyMagic_Impact_Base.M2", -- [82]
			"AnthricystChangeFX.M2", -- [83]
			"Anthricyst_Flamewall_01.M2", -- [84]
			"AntiMagic_PreCast_Hand.M2", -- [85]
			"AntiMagic_State_Base.M2", -- [86]
			"AntiMagic_State_Red.M2", -- [87]
			"AntiMagic_State_blue.M2", -- [88]
			"AnvilStrike.M2", -- [89]
			"ArcSection_Shadow_Goo_State_A.M2", -- [90]
			"ArcSection_Shadow_Goo_State_B.M2", -- [91]
			"ArcSection_Shadow_Goo_State_C.M2", -- [92]
			"ArcSection_Shadow_Goo_State_D.M2", -- [93]
			"ArcSection_Shadow_Goo_State_E.M2", -- [94]
			"ArcSection_Shadow_Goo_State_F.M2", -- [95]
			"ArcaneBomb_Missle.M2", -- [96]
			"ArcaneBreath.M2", -- [97]
			"ArcaneExplosion_Base.M2", -- [98]
			"ArcaneExplosion_Boss_Base.M2", -- [99]
			"ArcaneExplosion_Impact_Chest.M2", -- [100]
			"ArcaneForceShield_Blue.M2", -- [101]
			"ArcaneForceShield_Dark.M2", -- [102]
			"ArcaneForceShield_Green.M2", -- [103]
			"ArcaneForceShield_Purple.M2", -- [104]
			"ArcaneForceShield_Red.M2", -- [105]
			"ArcaneForceShield_Yellow.M2", -- [106]
			"ArcaneIntellect_Impact_Base.M2", -- [107]
			"ArcaneLightning.m2", -- [108]
			"ArcaneLightning01.m2", -- [109]
			"ArcaneLightning02.m2", -- [110]
			"ArcanePower_State_Chest.M2", -- [111]
			"ArcaneReflect_State_Chest.M2", -- [112]
			"ArcaneShot_Area.M2", -- [113]
			"ArcaneShot_Missile.M2", -- [114]
			"ArcaneShot_Missile2.M2", -- [115]
			"ArcaneSpirit_Impact_Base.M2", -- [116]
			"ArcaneTorrent.M2", -- [117]
			"ArcaneTorrent_Fiery.M2", -- [118]
			"ArcaneVolley_Missile.M2", -- [119]
			"ArcaneWard_Impact_Chest.M2", -- [120]
			"ArcaneZone.M2", -- [121]
			"Arcane_Fire_Weapon_Effect.M2", -- [122]
			"Arcane_Form_Precast.M2", -- [123]
			"Arcane_Missile.M2", -- [124]
			"Arcane_Missile_Lvl1.M2", -- [125]
			"Arcane_Missile_Lvl2.M2", -- [126]
			"Arcane_Missile_Lvl3.M2", -- [127]
			"Arcane_Missile_Lvl4.M2", -- [128]
			"Arcane_Missile_Lvl4_LowNoise.m2", -- [129]
			"Arcane_Missile_Orb_Pink.m2", -- [130]
			"Arcane_Missile_Orb_White.m2", -- [131]
			"Arcane_Missile_Orb_Yellow.m2", -- [132]
			"Arcane_Rune_Base_Impact.m2", -- [133]
			"Arcane_Rune_Impact_Base.m2", -- [134]
			"Arcane_Rune_Shield_Impact_Base.M2", -- [135]
			"Arcane_Shield_State_Base_Pink.m2", -- [136]
			"Archimonde_Blue_Fire.M2", -- [137]
			"Archimonde_Fire.M2", -- [138]
			"Archimonde_Fire_Sha.M2", -- [139]
			"Archimonde_Fire_V2.M2", -- [140]
			"Archimonde_Fire_V2_Jade.M2", -- [141]
			"Archimonde_Fire_V3.M2", -- [142]
			"Archimonde_PinkFire.M2", -- [143]
			"Archimonde_Purple_Fire.M2", -- [144]
			"ArgentCrusade_CTFflag_spell.M2", -- [145]
			"ArrowFrog_NoTrail.M2", -- [146]
			"Arrow_State.m2", -- [147]
			"Arsenal_Energy_Forcefield.M2", -- [148]
			"Arthas_Souls_Attack.M2", -- [149]
			"Ashran_ProtectionDome_State.m2", -- [150]
			"Ashran_SleepPowder_Missile.m2", -- [151]
			"AspectBeast_Impact_Head.M2", -- [152]
			"AspectCheetah_Impact_Head.M2", -- [153]
			"AspectHawk_Impact_Head.M2", -- [154]
			"AspectMonkey_Impact_Head.M2", -- [155]
			"AspectSnake_Impact_Head.M2", -- [156]
			"AspectWild_Impact_Head.M2", -- [157]
			"AspectWolf_Impact_Head.M2", -- [158]
			"Assassinate_Impact.M2", -- [159]
			"Assassinate_Missile.M2", -- [160]
			"Astral_Recall_Impact_Base.M2", -- [161]
			"Atmospheric_Fire_Ember_Cloud_State.m2", -- [162]
			"AttachmentDummyMesh.M2", -- [163]
			"Auchindoun_Shield01.M2", -- [164]
			"AuraBlackTall.M2", -- [165]
			"AuraCyanVeryTall.M2", -- [166]
			"AuraCyanVeryTall_V2.M2", -- [167]
			"AuraGreenVeryTall_V2.M2", -- [168]
			"AuraOrangeVeryTall.M2", -- [169]
			"AuraOrangeVeryTall_V2.M2", -- [170]
			"AuraPurpleVeryTall_V2.M2", -- [171]
			"AuraYellowVeryTall_V2.M2", -- [172]
			"AvengingWrath_Impact_Base.M2", -- [173]
			"AvengingWrath_State_Chest.M2", -- [174]
			"AxisTestObject.M2", -- [175]
			"AzsharasHand.M2", -- [176]
			"BackStab_Cast_Base.M2", -- [177]
			"BackStab_Impact_Chest.M2", -- [178]
			"BalanceOfNature_Impact_Base.M2", -- [179]
			"Ball_Water_01.M2", -- [180]
			"Ball_of_Shadow.M2", -- [181]
			"Banish_Chest.M2", -- [182]
			"Banish_Chest_Blue.M2", -- [183]
			"Banish_Chest_Dark.M2", -- [184]
			"Banish_Chest_Purple.M2", -- [185]
			"Banish_Chest_White.M2", -- [186]
			"Banish_Chest_Yellow.M2", -- [187]
			"BarkShield_State_Base.M2", -- [188]
			"BarkSkin_Impact_Base_Iron.M2", -- [189]
			"Barkskin_State_Base.m2", -- [190]
			"Barkskin_State_Base_Iron.M2", -- [191]
			"BaseFlagCapRed_Impact_Base.M2", -- [192]
			"BasicStrike.M2", -- [193]
			"BattleShout_Cast_Base.M2", -- [194]
			"BattleStance_Impact_Head.M2", -- [195]
			"BattlefieldBanner_Alliance01.m2", -- [196]
			"BattlefieldBanner_Horde01.m2", -- [197]
			"BattlefieldBanner_Neutral01.m2", -- [198]
			"BattlefieldBanner_Neutral_Post01.m2", -- [199]
			"Beacon_of_Light_Impact.M2", -- [200]
			"BeamTarget_OnGround.M2", -- [201]
			"BeamTarget_OnGround_Green.M2", -- [202]
			"BearFrenzy.m2", -- [203]
			"BearFrenzyImpact.M2", -- [204]
			"BearTrap.M2", -- [205]
			"BearTrap_State.M2", -- [206]
			"BeastCall_Impact_Head.M2", -- [207]
			"BeastLore_Impact_Base.M2", -- [208]
			"BeastLore_Impact_Head.M2", -- [209]
			"BeastRageCaster.M2", -- [210]
			"BeastRageState.M2", -- [211]
			"BeastSoothe_Impact_Head.M2", -- [212]
			"BeastSoothe_State_Head.M2", -- [213]
			"BeastWithin_State_Base.M2", -- [214]
			"Beholder_Icewall_Base.M2", -- [215]
			"BerzerkerStance_Impact_Head.M2", -- [216]
			"BestowDisease_Impact_Chest.m2", -- [217]
			"Bind2_Impact_Base.M2", -- [218]
			"Bind_Impact_Base.m2", -- [219]
			"BlackFuse_BombPile_State.M2", -- [220]
			"BlackFuse_LaserBeam_State.M2", -- [221]
			"BlackFuse_LaserBeam_State_Short.M2", -- [222]
			"BlackFuse_PartsExplosion_Impact.M2", -- [223]
			"BlackFuse_PartsExplosion_Impact_02.M2", -- [224]
			"BlackHole_White.M2", -- [225]
			"BlackHole_White_H.M2", -- [226]
			"BlackMagic_Precast_Base.M2", -- [227]
			"BlackRadiationFog.M2", -- [228]
			"BlackShot_Missile.M2", -- [229]
			"Black_RoseShower_Impact_Base.M2", -- [230]
			"Blackfuse_Explosion_Impact_Base.M2", -- [231]
			"Blackfuse_LaserTurret_GroundBurn_State_Base.M2", -- [232]
			"Blackfuse_LaserTurret_PreCast_Hand.M2", -- [233]
			"Blackfuse_MissileTurret_Hold_10.M2", -- [234]
			"Blackfuse_MissileTurret_Hold_110.M2", -- [235]
			"Blackfuse_MissileTurret_Hold_30.M2", -- [236]
			"Blackfuse_MissileTurret_Hold_50.M2", -- [237]
			"Blackfuse_MissileTurret_Hold_70.M2", -- [238]
			"Blackfuse_MissileTurret_Hold_90.M2", -- [239]
			"Blackfuse_MissileTurret_Missile.M2", -- [240]
			"Blackfuse_MissileTurret_Precast_10.M2", -- [241]
			"Blackfuse_MissileTurret_Precast_110.M2", -- [242]
			"Blackfuse_MissileTurret_Precast_30.M2", -- [243]
			"Blackfuse_MissileTurret_Precast_50.M2", -- [244]
			"Blackfuse_MissileTurret_Precast_70.M2", -- [245]
			"Blackfuse_MissileTurret_Precast_90.M2", -- [246]
			"Blackfuse_autohealbeam_impact.M2", -- [247]
			"Blackfuse_magnetpull.M2", -- [248]
			"Blackfuse_magnetpush.M2", -- [249]
			"Blackhand_Blaze_State.m2", -- [250]
			"Blackhand_Debri_Impact.m2", -- [251]
			"Blackhand_Erruption_15yard.m2", -- [252]
			"Blackhand_Erruption_30yard.m2", -- [253]
			"Blackhand_FireyDebri_Impact.m2", -- [254]
			"Blackhand_Slaghole_Large.m2", -- [255]
			"Blackhand_Slaghole_Small.m2", -- [256]
			"Blades_Ring.M2", -- [257]
			"BlazingFists_Base.M2", -- [258]
			"BleedingAltar_Blood_State.m2", -- [259]
			"BleedingAltar_Orb_State.m2", -- [260]
			"Blessed_Mending_Impact.M2", -- [261]
			"Blessed_Mending_Proc_Impact.M2", -- [262]
			"BlessingOfLight_Impact.M2", -- [263]
			"BlessingOfSacrifice_Impact.M2", -- [264]
			"BlessingOfSalvation_Impact.M2", -- [265]
			"BlessingOfSanctuary.M2", -- [266]
			"BlessingofAgility_Base.M2", -- [267]
			"BlessingofFreedom_Impact.M2", -- [268]
			"BlessingofFreedom_State.M2", -- [269]
			"BlessingofKings_Base.M2", -- [270]
			"BlessingofMight_Base.M2", -- [271]
			"BlessingofProtection_Base.M2", -- [272]
			"BlessingofProtection_Chest.M2", -- [273]
			"BlessingofProtection_Impact.M2", -- [274]
			"BlessingofSpellProtection_Base.M2", -- [275]
			"BlessingofStamina_Base.M2", -- [276]
			"BlessingofStrength_Base.M2", -- [277]
			"BlessingofWisdom_Base.M2", -- [278]
			"Blessingofprotection_State_Classic.M2", -- [279]
			"BlindingShot_Impact.M2", -- [280]
			"BlindingShot_Missile.M2", -- [281]
			"Blink_Impact_Chest.M2", -- [282]
			"Blizzard_Impact_Base.M2", -- [283]
			"Blizzard_Spawn.M2", -- [284]
			"BloodBoil_Impact_Chest.M2", -- [285]
			"BloodBolt_Chest.M2", -- [286]
			"BloodBolt_Missile_Low.M2", -- [287]
			"BloodGolem_ForceSphere_Orb.M2", -- [288]
			"BloodGolem_Missile.M2", -- [289]
			"BloodGolem_Orb.M2", -- [290]
			"BloodGolem_Orb_corrupt.M2", -- [291]
			"BloodLust_Cast_Hand.M2", -- [292]
			"BloodLust_Player_Cast_Head.M2", -- [293]
			"BloodLust_Player_State_Head.M2", -- [294]
			"BloodLust_State_Hand.M2", -- [295]
			"BloodQueen_Fire.M2", -- [296]
			"Blood_Rain.M2", -- [297]
			"Blood_Rain_Main_impact_Base.M2", -- [298]
			"Blood_Rain_impact_Base.m2", -- [299]
			"Blood_Splat_Purple.M2", -- [300]
			"Bloodsplat_01.M2", -- [301]
			"Bloodsplat_02.M2", -- [302]
			"BloodyBucket.M2", -- [303]
			"BloodyExplosion.M2", -- [304]
			"BloodyExplosionBlack.M2", -- [305]
			"BloodyExplosionGreen.M2", -- [306]
			"BloodyExplosionPurple.M2", -- [307]
			"BloodyExplosion_GlyphBloodier.M2", -- [308]
			"BlueRadiationFog.M2", -- [309]
			"Bomb_ExplosionA.m2", -- [310]
			"Bomb_State_Base_01.M2", -- [311]
			"BoneArm_01.m2", -- [312]
			"BoneArmor_Head.m2", -- [313]
			"BoneArmor_Recursive.M2", -- [314]
			"BoneArmor_State_Chest.M2", -- [315]
			"BoneGuardRockSpike.M2", -- [316]
			"BoneGuardRockSpike_spell.M2", -- [317]
			"BoneGuardSpike.m2", -- [318]
			"Bone_Cyclone_Impact.M2", -- [319]
			"Bone_Cyclone_State.m2", -- [320]
			"Bone_Raycast_Test.m2", -- [321]
			"Bone_Sha_High.M2", -- [322]
			"Bone_Sha_Low.M2", -- [323]
			"Boneswirl.M2", -- [324]
			"Boneworm_AttackEffects.m2", -- [325]
			"BoulderGiant_Missile.m2", -- [326]
			"Boulder_Missile.m2", -- [327]
			"Breath_Arcane_01.M2", -- [328]
			"Breath_Arcane_Precast_State.M2", -- [329]
			"Breath_Fire_01.M2", -- [330]
			"Breath_Frost_01.M2", -- [331]
			"Breath_Poison_01.M2", -- [332]
			"BrillianceAura.M2", -- [333]
			"Bubble_Drunk.M2", -- [334]
			"Bubble_Spell.M2", -- [335]
			"BurningIntellect_Impact_Base.M2", -- [336]
			"BurningSpirit_Impact_Base.M2", -- [337]
			"BurningSpirit_Impact_Head.M2", -- [338]
			"BurrowEarth_BoneWaste_Missile.m2", -- [339]
			"BurrowEarth_Brown_Missile.m2", -- [340]
			"BurrowEarth_Brown_Missile_V2.m2", -- [341]
			"BurrowEarth_Brown_Missile_V2_projected.M2", -- [342]
			"BurrowEarth_Brown_Missile_V3.M2", -- [343]
			"BurrowEarth_Brown_Missile_V3_low.M2", -- [344]
			"BurrowEarth_Brown_Missile_low.M2", -- [345]
			"BurrowEarth_Hellfire_Missile.m2", -- [346]
			"CINEMATIC_OMNI_LIGHT.M2", -- [347]
			"CallLightning_Impact.M2", -- [348]
			"Camera_State.M2", -- [349]
			"Camouflage_Base.M2", -- [350]
			"Camouflage_Hands.M2", -- [351]
			"Camouflage_Head.M2", -- [352]
			"Camouflage_Impact.M2", -- [353]
			"Canon_Impact_Dust.M2", -- [354]
			"CapeWingsCrane.M2", -- [355]
			"CapeWingsDragon.M2", -- [356]
			"CapeWingsOx.M2", -- [357]
			"CapeWingsTiger.M2", -- [358]
			"Cast_Arcane_Pink_01.m2", -- [359]
			"Cast_Template_01.M2", -- [360]
			"CatMark.m2", -- [361]
			"CatMark_Black.m2", -- [362]
			"CatMark_Blue.m2", -- [363]
			"CatMark_Green.m2", -- [364]
			"CatMark_Orange.m2", -- [365]
			"CatMark_Red.m2", -- [366]
			"CatMark_White.m2", -- [367]
			"CatMark_Yellow.m2", -- [368]
			"ChainLightning_Fel_Impact_Chest.M2", -- [369]
			"ChainLightning_Impact_Chest.M2", -- [370]
			"ChainsofIce_Low_Base.M2", -- [371]
			"ChallengingShout_Cast_Base.M2", -- [372]
			"Chaos_Blast_Proj_Impact.M2", -- [373]
			"ChargeTrail.M2", -- [374]
			"CheapShot_Cast_Base.M2", -- [375]
			"CheapShot_Impact_Chest.M2", -- [376]
			"CheapShot_State_Head.M2", -- [377]
			"Cheat_Death.M2", -- [378]
			"ChiWave_Missile_Hostile.M2", -- [379]
			"ChimeraShot_Impact.M2", -- [380]
			"ChimeraShot_Missile.M2", -- [381]
			"Chiwave_Impact_Hostile.M2", -- [382]
			"Chogall_PhysLaser.M2", -- [383]
			"Chogall_ShadowLaser.M2", -- [384]
			"ChristmasSnowRain.M2", -- [385]
			"Chromatic_Dragon_Beam.M2", -- [386]
			"Circle_of_Renewal_Impact.M2", -- [387]
			"Clearcasting_Impact_Chest.M2", -- [388]
			"Cleave_Cast_Base.M2", -- [389]
			"Cleave_Cast_Base_Purple.M2", -- [390]
			"Cleave_Circle_Arcane.M2", -- [391]
			"Cleave_Circle_Fast_Fire.M2", -- [392]
			"Cleave_Circle_Fire.M2", -- [393]
			"Cleave_Circle_Frost.M2", -- [394]
			"Cleave_Circle_Holy.M2", -- [395]
			"Cleave_Circle_Lightning.M2", -- [396]
			"Cleave_Circle_Shadow.M2", -- [397]
			"Cleave_Circle_Template.M2", -- [398]
			"Cleave_Circle_Weapon.M2", -- [399]
			"Cleave_Circle_Wind.M2", -- [400]
			"Cleave_Impact_Chest.M2", -- [401]
			"Clense_Base.m2", -- [402]
			"CobraStrikes_Impact.M2", -- [403]
			"CollapsingStar.M2", -- [404]
			"ConeofCold_Geo.M2", -- [405]
			"ConeofCold_Hand.m2", -- [406]
			"ConeofCold_Mouth.M2", -- [407]
			"ConeofFire_Hand.m2", -- [408]
			"Conflagrate_Impact_Chest.M2", -- [409]
			"Confused_State_Head.M2", -- [410]
			"ConjureItem.M2", -- [411]
			"ConjureItemCast.M2", -- [412]
			"Consecration_Impact_Base.M2", -- [413]
			"Consecration_Impact_BaseHostile.M2", -- [414]
			"Constellations_Crane.M2", -- [415]
			"Constellations_Crane_02.M2", -- [416]
			"Constellations_Ox.M2", -- [417]
			"Constellations_Ox_02.M2", -- [418]
			"Constellations_Serpent.M2", -- [419]
			"Constellations_Serpent_02.M2", -- [420]
			"Constellations_Tiger.M2", -- [421]
			"Constellations_Tiger_02.M2", -- [422]
			"Consume_Magic_Impact.M2", -- [423]
			"CorrosiveSandBreath.M2", -- [424]
			"Corrupted_Deathwing_Missile.M2", -- [425]
			"Corruption_ImpactDot_Med_Base.M2", -- [426]
			"CounterSpell_Impact_Chest.M2", -- [427]
			"CraneGod_SpellEffect.M2", -- [428]
			"CrashingDebris_Ring_Impact.M2", -- [429]
			"CreateSoulstone_Cast.M2", -- [430]
			"Creature_ScourgeRuneCircleCrystal.M2", -- [431]
			"Creature_ScourgeRuneCircleCrystal_No_Coll.M2", -- [432]
			"Creature_SpellPortalLarge_Blue.M2", -- [433]
			"Creature_SpellPortalLarge_Green.M2", -- [434]
			"Creature_SpellPortalLarge_LightRed.M2", -- [435]
			"Creature_SpellPortalLarge_Purple.M2", -- [436]
			"Creature_SpellPortalLarge_Red.M2", -- [437]
			"Creature_SpellPortalLarge_Yellow.M2", -- [438]
			"Creature_SpellPortal_Blue.M2", -- [439]
			"Creature_SpellPortal_Blue_Clickable.M2", -- [440]
			"Creature_SpellPortal_Clickable.M2", -- [441]
			"Creature_SpellPortal_Green.M2", -- [442]
			"Creature_SpellPortal_LargeShadow.M2", -- [443]
			"Creature_SpellPortal_Purple.M2", -- [444]
			"Creature_SpellPortal_Purple_Clickable.M2", -- [445]
			"Creature_SpellPortal_White.M2", -- [446]
			"Creature_SpellPortal_White_Clickable.M2", -- [447]
			"Creature_SpellPortal_Yellow.M2", -- [448]
			"Cripple_Impact_Base.M2", -- [449]
			"Cripple_State_Base.M2", -- [450]
			"Cripple_State_Chest.M2", -- [451]
			"Crow_Baked_noSparkles.M2", -- [452]
			"CthuneEyeAttack.M2", -- [453]
			"CurseElements_Impact_Head.M2", -- [454]
			"CurseOfTongues_Impact.M2", -- [455]
			"CurseOfTongues_State_Chest.M2", -- [456]
			"CurseofAgony_Head.M2", -- [457]
			"CurseofFrailty_Head.M2", -- [458]
			"CurseofMannoroth_Head.M2", -- [459]
			"CurseofRecklessness_Impact_Chest.M2", -- [460]
			"CurseofWeakness_Head.M2", -- [461]
			"CuttotheChase_Impact.M2", -- [462]
			"CycloneEarth_State.M2", -- [463]
			"CycloneFire_State.m2", -- [464]
			"CycloneGeo.M2", -- [465]
			"CycloneGeo2.M2", -- [466]
			"CycloneGeo2_Additive.M2", -- [467]
			"CycloneGeo3.M2", -- [468]
			"CycloneGeo3_Additive.M2", -- [469]
			"CycloneGeo_Additive.M2", -- [470]
			"CycloneRock1.m2", -- [471]
			"CycloneRock2.m2", -- [472]
			"CycloneWater_State.M2", -- [473]
			"Cyclone_Caster_State.M2", -- [474]
			"Cyclone_Caster_State_Scaled.M2", -- [475]
			"Cyclone_NoDebris.M2", -- [476]
			"Cyclone_State.M2", -- [477]
			"DEATHKNIGHT_pestilence_missile.m2", -- [478]
			"Dalaran_ForgeArms_SmokeFX.m2", -- [479]
			"DampenMagic_Impact_Base.M2", -- [480]
			"DarkPortal_Blasted_FX_Red.M2", -- [481]
			"DarkRitual_PreCast_Base.M2", -- [482]
			"DarkRitual_PreCast_BaseBlue.M2", -- [483]
			"DarkmoonVengeance_Impact_Chest.M2", -- [484]
			"DarkmoonVengeance_Impact_Head.M2", -- [485]
			"DarkmoonVengeance_Impact_Head_Hold.M2", -- [486]
			"Darkshade.M2", -- [487]
			"Darkshade_topOnly.M2", -- [488]
			"Deadly_Throw_Impact_Chest.M2", -- [489]
			"DeathAndDecay.M2", -- [490]
			"DeathAndDecayGreen.M2", -- [491]
			"DeathAndDecay_Area_Base.M2", -- [492]
			"DeathAndDecay_Area_Runes.M2", -- [493]
			"DeathAndDecay_Area_RunesGreen.M2", -- [494]
			"DeathAndDecay_Area_Runes_State.M2", -- [495]
			"DeathBolt_Missile_Low.M2", -- [496]
			"DeathCoil_Impact_Chest.M2", -- [497]
			"DeathCoil_Missile.M2", -- [498]
			"DeathKnight_AntiMagicZone.M2", -- [499]
			"DeathKnight_AntiMagicZone_Blue.M2", -- [500]
			"DeathKnight_AntiMagicZone_Green.M2", -- [501]
			"DeathKnight_AntiMagicZone_NoShadow.M2", -- [502]
			"DeathKnight_Asphyxiate.M2", -- [503]
			"DeathKnight_BladeBarrier.M2", -- [504]
			"DeathKnight_BloodBoil.M2", -- [505]
			"DeathKnight_BloodBoil_Cast.M2", -- [506]
			"DeathKnight_BloodBoil_New.M2", -- [507]
			"DeathKnight_BloodPresence.M2", -- [508]
			"DeathKnight_BloodStrike.m2", -- [509]
			"DeathKnight_BloodStrike_Impact.M2", -- [510]
			"DeathKnight_BloodTap.M2", -- [511]
			"DeathKnight_BoneArmor.M2", -- [512]
			"DeathKnight_Chains_of_Ice.M2", -- [513]
			"DeathKnight_CorpseExplosion.M2", -- [514]
			"DeathKnight_DancingRuneBlade_DeSpawn.M2", -- [515]
			"DeathKnight_DancingRuneBlade_Spawn.M2", -- [516]
			"DeathKnight_DancingRuneBlade_State.m2", -- [517]
			"DeathKnight_Dark_Simulacrum_Impact.M2", -- [518]
			"DeathKnight_Dark_Simulacrum_State.M2", -- [519]
			"DeathKnight_DeathCoil_Missile.M2", -- [520]
			"DeathKnight_DeathGate_Q.M2", -- [521]
			"DeathKnight_DeathPactCaster.M2", -- [522]
			"DeathKnight_DeathPactTarget.M2", -- [523]
			"DeathKnight_Death_Siphon_Impact.M2", -- [524]
			"DeathKnight_Death_Siphon_Missile.M2", -- [525]
			"DeathKnight_Deathchill.M2", -- [526]
			"DeathKnight_Defile.M2", -- [527]
			"DeathKnight_Defile_lowNoise.M2", -- [528]
			"DeathKnight_Desecration.M2", -- [529]
			"DeathKnight_DesecrationHostile.M2", -- [530]
			"DeathKnight_Desecration_Spawn.M2", -- [531]
			"DeathKnight_DestroyCorpse_02.m2", -- [532]
			"DeathKnight_DestroyCorpse_03.m2", -- [533]
			"DeathKnight_DestroyCorpse_Bones_01.m2", -- [534]
			"DeathKnight_EmpowerRuneblade.M2", -- [535]
			"DeathKnight_FrostPresence.M2", -- [536]
			"DeathKnight_FrostStrike.m2", -- [537]
			"DeathKnight_FrostStrike_Impact.m2", -- [538]
			"DeathKnight_FrozenRuneWeapon_Impact.M2", -- [539]
			"DeathKnight_FrozenRuneWeapon_State.m2", -- [540]
			"DeathKnight_Ghoul_Explode.M2", -- [541]
			"DeathKnight_Ghoul_Explode_simple.m2", -- [542]
			"DeathKnight_HowlingBlastPrimary.M2", -- [543]
			"DeathKnight_HowlingBlastSecondary.M2", -- [544]
			"DeathKnight_HungeringCold.M2", -- [545]
			"DeathKnight_Hysteria.M2", -- [546]
			"DeathKnight_IceboundFortitude.m2", -- [547]
			"DeathKnight_IcyTouch.M2", -- [548]
			"DeathKnight_Lichborne_State.M2", -- [549]
			"DeathKnight_MarkofBlood.M2", -- [550]
			"DeathKnight_MindFreeze.M2", -- [551]
			"DeathKnight_Necrotic_Strike_Impact.M2", -- [552]
			"DeathKnight_Necrotic_Strike_State.M2", -- [553]
			"DeathKnight_Obliterate.m2", -- [554]
			"DeathKnight_Obliterate_Impact.M2", -- [555]
			"DeathKnight_Outbreak.M2", -- [556]
			"DeathKnight_PathofFrost.M2", -- [557]
			"DeathKnight_PlagueStrikeCaster.m2", -- [558]
			"DeathKnight_PlagueStrikeCaster_Impact.M2", -- [559]
			"DeathKnight_PlagueStrikeCaster_ImpactRed.M2", -- [560]
			"DeathKnight_PlagueStrikeState.M2", -- [561]
			"DeathKnight_PlagueStrikeStateRed.M2", -- [562]
			"DeathKnight_RemorselessWinter_State.M2", -- [563]
			"DeathKnight_RuneTap.M2", -- [564]
			"DeathKnight_SoulReaper.M2", -- [565]
			"DeathKnight_Strangulate.M2", -- [566]
			"DeathKnight_Strangulate_Chain.m2", -- [567]
			"DeathKnight_SummonWarHorse_Impact_Base.M2", -- [568]
			"DeathKnight_UnholyBlight.M2", -- [569]
			"DeathKnight_UnholyBlight_State.m2", -- [570]
			"DeathKnight_UnholyPresence.M2", -- [571]
			"DeathKnight_WanderingPlague.M2", -- [572]
			"DeathWish_State_Hand.m2", -- [573]
			"DeathwingCorruptedClaw_FX.M2", -- [574]
			"Deathwing_Body_Fire.M2", -- [575]
			"Deathwing_Body_Fire_02.M2", -- [576]
			"Deathwing_Body_Fire_03.M2", -- [577]
			"Deathwing_Body_Fire_Small.M2", -- [578]
			"Deathwing_Body_Fire_b.M2", -- [579]
			"Deathwing_Body_Fire_c.M2", -- [580]
			"Deathwing_Body_Fire_d.M2", -- [581]
			"Deathwing_Lava_Burst.M2", -- [582]
			"Deathwing_Lava_BurstNoGeo.M2", -- [583]
			"Deathwing_Lava_Burst_Impact.M2", -- [584]
			"Decimate_Impact_Chest.M2", -- [585]
			"Decimate_Missile.M2", -- [586]
			"Decimate_Missile_Red.M2", -- [587]
			"Decimate_State.M2", -- [588]
			"DecisiveStrike_Impact_Chest.M2", -- [589]
			"DefensiveStance_Impact_Chest.m2", -- [590]
			"DefensiveStance_Impact_Head.M2", -- [591]
			"Demolisher_Missile.M2", -- [592]
			"Demolisher_Missile_Blue.M2", -- [593]
			"DemonArmor_Impact_Head.m2", -- [594]
			"DemonBreath_Impact_Head.M2", -- [595]
			"DemonicCircleSummon_Base.M2", -- [596]
			"DemonicCircleSummon_Teleport.M2", -- [597]
			"DemonicSacrifice_Felhunter_Chest.M2", -- [598]
			"DemonicSacrifice_Imp_Chest.M2", -- [599]
			"DemonicSacrifice_Succubus_Chest.M2", -- [600]
			"DemonicSacrifice_Voidwalker_Chest.M2", -- [601]
			"DemoralizingShout_Cast_Base.M2", -- [602]
			"DemoralizingShout_Impact_Head.m2", -- [603]
			"Dest_Tower_Damaged_On_Hit_Smoke_FX.m2", -- [604]
			"Dest_Tower_Damaged_Smoke_FX.m2", -- [605]
			"Dest_Tower_Impact_FX.M2", -- [606]
			"Dest_Tower_Impact_Smoke_FX.m2", -- [607]
			"Destructible_Ambient_FX01.M2", -- [608]
			"Destructible_Dustfall_FX01.M2", -- [609]
			"Destructible_Dustfall_FX02.M2", -- [610]
			"Destructible_On_Hit_FX01.M2", -- [611]
			"Destructible_Shake_FX01.m2", -- [612]
			"DetectInvis_Impact_Base.M2", -- [613]
			"DetectInvis_Impact_Head.M2", -- [614]
			"DetectMagic_Base.m2", -- [615]
			"DetectMagic_Recursive.M2", -- [616]
			"DetectSealth_State_Base.M2", -- [617]
			"DetectStealth_State_Head.M2", -- [618]
			"Deterrence_Impact.M2", -- [619]
			"Deterrence_State_Base.M2", -- [620]
			"Deterrence_State_Chest.M2", -- [621]
			"Devious_Impact.M2", -- [622]
			"DevotionAura_Base.M2", -- [623]
			"DisEnchant_Cast_Hand.M2", -- [624]
			"DisEnchant_PreCast_Hand.M2", -- [625]
			"Disarm_Impact_Chest.M2", -- [626]
			"DiseaseCloud.M2", -- [627]
			"Disembowel_Impact.M2", -- [628]
			"Dismantle_State.M2", -- [629]
			"Dispel_Low_Base.M2", -- [630]
			"Dispel_Low_Base_Simple.M2", -- [631]
			"Dispel_Low_Recursive.M2", -- [632]
			"Distract_Impact_Base.M2", -- [633]
			"Distract_Impact_Chest.M2", -- [634]
			"DivineBubble_Low_Base.M2", -- [635]
			"DivineIllumination_Base.M2", -- [636]
			"DivineShield_Low_Base.M2", -- [637]
			"DivineShield_Low_Chest.M2", -- [638]
			"DivineShield_V2_Chest.M2", -- [639]
			"Divine_Protector_State.M2", -- [640]
			"Divine_Storm_Impact_Damage.M2", -- [641]
			"Divine_Storm_Impact_Heal.M2", -- [642]
			"Divine_Storm_State.M2", -- [643]
			"DjinnDeath_Blizzard.M2", -- [644]
			"DjinnDeath_Fire.M2", -- [645]
			"DjinnDeath_Fire_02.M2", -- [646]
			"Draenor_Map_Spell.m2", -- [647]
			"DragonBreath_Arcane.m2", -- [648]
			"DragonBreath_CelestialBreath.M2", -- [649]
			"DragonBreath_Fire.m2", -- [650]
			"DragonBreath_Fire_Jade.M2", -- [651]
			"DragonBreath_Fire_Offset.m2", -- [652]
			"DragonBreath_Fire_Offset_withDecay.M2", -- [653]
			"DragonBreath_Frost.m2", -- [654]
			"DragonBreath_Infinite.M2", -- [655]
			"DragonBreath_Lightning.M2", -- [656]
			"DragonBreath_Lightning_withDecay.M2", -- [657]
			"DragonBreath_Shadow.m2", -- [658]
			"DragonFlameBreath.M2", -- [659]
			"DragonFlameBreath180.M2", -- [660]
			"DragonTurtle_SandBreath_180.M2", -- [661]
			"DragonsBreath_Shadow_Low.M2", -- [662]
			"Dreadlord_Carrion_Impact.M2", -- [663]
			"Dreadlord_Carrion_Swarm_Cast.M2", -- [664]
			"DruidMorph_Aqua_Impact_Base.M2", -- [665]
			"DruidMorph_Impact_Base.M2", -- [666]
			"Druid_Astral_Storm.M2", -- [667]
			"Druid_Astral_Storm_Funnels.M2", -- [668]
			"Druid_Berserk.M2", -- [669]
			"Druid_Eclipse.M2", -- [670]
			"Druid_Eclipse_Orange.M2", -- [671]
			"Druid_Efflorescence_Persistent.M2", -- [672]
			"Druid_Efflorescence_State.M2", -- [673]
			"Druid_Flourish.m2", -- [674]
			"Druid_Fungal_Growth_Area_State.M2", -- [675]
			"Druid_Fungal_Growth_Area_State_Enemy.M2", -- [676]
			"Druid_Genesis_Impact.m2", -- [677]
			"Druid_GlyphofStars_Base.M2", -- [678]
			"Druid_Hurricane_Base_V2.M2", -- [679]
			"Druid_Hurricane_Funnels_V2.M2", -- [680]
			"Druid_Hurricane_Impact_Base.M2", -- [681]
			"Druid_InfectedWounds.M2", -- [682]
			"Druid_Living_Seed.m2", -- [683]
			"Druid_Might_of_Ursoc.M2", -- [684]
			"Druid_MomentofClarity_State.m2", -- [685]
			"Druid_NaturesVigil_State_Head.M2", -- [686]
			"Druid_Non_Shapeshifted_Stampede.M2", -- [687]
			"Druid_Nourish.M2", -- [688]
			"Druid_Owlkin_Frenzy.M2", -- [689]
			"Druid_Pulverize_Impact.M2", -- [690]
			"Druid_Skullbash_Impact_01.M2", -- [691]
			"Druid_SolarBeam_Impact_Base.M2", -- [692]
			"Druid_SolarFall_Missile.M2", -- [693]
			"Druid_Stampeding_Roar_01.M2", -- [694]
			"Druid_StarfallMissile.M2", -- [695]
			"Druid_StarfallState.M2", -- [696]
			"Druid_Starsurge_Impact.M2", -- [697]
			"Druid_Starsurge_Missile.M2", -- [698]
			"Druid_Starsurge_Precast_NoFlash.M2", -- [699]
			"Druid_Starsurge_Precast_Omni.M2", -- [700]
			"Druid_Survival_Instincts.M2", -- [701]
			"Druid_Swarm_Impact.M2", -- [702]
			"Druid_Swarm_Impact_Old.M2", -- [703]
			"Druid_Swarm_State.M2", -- [704]
			"Druid_Thrash_Impact_01.M2", -- [705]
			"Druid_Thrash_State_01.M2", -- [706]
			"Druid_WildCharge_Caster_State.M2", -- [707]
			"Druid_Wild_Mushroom_01.M2", -- [708]
			"Druid_Wild_Mushroom_01Hostile.M2", -- [709]
			"Druid_Wild_Mushroom_02.M2", -- [710]
			"Druid_Wild_Mushroom_02Hostile.M2", -- [711]
			"Druid_Wild_Mushroom_03.M2", -- [712]
			"Druid_Wild_Mushroom_03Hostile.M2", -- [713]
			"Druid_Wild_Mushroom_Bloom.M2", -- [714]
			"Druid_Wild_Mushroom_Frenzy.M2", -- [715]
			"Druid_Windburst.M2", -- [716]
			"Druid_Wrath_Impact_V2.M2", -- [717]
			"Druid_Wrath_Missile_V2.M2", -- [718]
			"Druid_Wrath_Precast_V2.M2", -- [719]
			"Durumu_Beholder_Wedge_A.M2", -- [720]
			"Durumu_Beholder_Wedge_B.M2", -- [721]
			"Durumu_Beholder_Wedge_C.M2", -- [722]
			"Durumu_Beholder_Wedge_D.M2", -- [723]
			"Durumu_Beholder_Wedge_E.M2", -- [724]
			"Durumu_Beholder_Wedge_F.M2", -- [725]
			"Durumu_Beholder_Wedge_Full.M2", -- [726]
			"Durumu_Beholder_Wedge_G.M2", -- [727]
			"Durumu_Beholder_Wedge_H.M2", -- [728]
			"Durumu_Beholder_Wedge_I.M2", -- [729]
			"Durumu_Beholder_Wedge_J.M2", -- [730]
			"Durumu_Beholder_Wedge_K.M2", -- [731]
			"Durumu_Beholder_Wedge_L.M2", -- [732]
			"Durumu_Beholder_Wedge_M.M2", -- [733]
			"DustCloud_Land.M2", -- [734]
			"DustNova_Cast_Base.M2", -- [735]
			"Dustfall_FX.M2", -- [736]
			"DynamiteA_Missile.M2", -- [737]
			"DynamiteA_SpellObject.M2", -- [738]
			"EARTH_IMPACT_AREASPLASH.m2", -- [739]
			"ENTANGLINGROOTSSTATE_UPREZ.M2", -- [740]
			"EagleEye_Impact_Head.M2", -- [741]
			"EarthShield_Impact_Base.M2", -- [742]
			"EarthShield_State_Base.M2", -- [743]
			"EarthShock_Impact_Chest.M2", -- [744]
			"Eastern_Plaguelands_Beam_Effect.M2", -- [745]
			"Eden_Growth.M2", -- [746]
			"Enchant_Cast_Hand.M2", -- [747]
			"Enchant_PreCast_Hand.M2", -- [748]
			"EndlessRage_Impact_Head.M2", -- [749]
			"EndlessRage_State_Head.M2", -- [750]
			"EnergizeGain_Energy.M2", -- [751]
			"EnergizeGain_Mana.M2", -- [752]
			"EnergizeGain_Rage.M2", -- [753]
			"EnergizeLost_Energy.M2", -- [754]
			"EnergizeLost_Mana.M2", -- [755]
			"EnergizeLost_Rage.M2", -- [756]
			"Engineering_Hologram_Base_State.M2", -- [757]
			"Engineering_Wormhole.M2", -- [758]
			"Engy_Missile_Juggernaut.M2", -- [759]
			"EnslaveDemon_Impact_Base.M2", -- [760]
			"EnslaveDemon_Impact_Chest.m2", -- [761]
			"EnslaveDemon_Impact_Head.M2", -- [762]
			"EntanglingRootsBrown_State.M2", -- [763]
			"EntanglingRoots_State.M2", -- [764]
			"Envenom_Cast.M2", -- [765]
			"Envenom_Impact_Chest.M2", -- [766]
			"Eradication_Hand.M2", -- [767]
			"ErrorCube.M2", -- [768]
			"Everyman_Impact.M2", -- [769]
			"Eviscerate_Cast_Hands.M2", -- [770]
			"Eviscerate_Impact_Chest.M2", -- [771]
			"Exorcism_Impact_Chest.M2", -- [772]
			"Expanding_Force_Bubble.M2", -- [773]
			"ExploderTrail.m2", -- [774]
			"Exploding_Stone_Impact.M2", -- [775]
			"Explosion_Engy_Impact_01.M2", -- [776]
			"Explosion_Flour_Impact_Base.M2", -- [777]
			"ExplosiveGaseous_Nova.M2", -- [778]
			"ExplosiveTimer_State_Base_01.M2", -- [779]
			"ExplosiveTimer_State_Base_01_inFlightMissile.m2", -- [780]
			"ExplosiveTimer_State_Base_02.M2", -- [781]
			"ExplosiveTimer_State_Base_Orange_01.M2", -- [782]
			"ExplosiveTimer_State_Base_Orange_02.M2", -- [783]
			"ExplosiveTimer_State_Base_Purple_01.M2", -- [784]
			"ExplosiveTimer_State_Base_Purple_02.M2", -- [785]
			"ExplosiveTimer_State_Base_Rainbow.M2", -- [786]
			"ExplosiveTimer_State_Base_Yellow_01.M2", -- [787]
			"ExplosiveTimer_State_Base_Yellow_02.M2", -- [788]
			"ExplosiveTrap_Base.M2", -- [789]
			"ExplosiveTrap_Impact_Base.M2", -- [790]
			"ExplosiveTrap_Recursive.M2", -- [791]
			"Explosive_Shot_Impact.M2", -- [792]
			"Explosive_Shot_Missile.M2", -- [793]
			"ExposeArmor_Head.m2", -- [794]
			"External_Barrier_FX.m2", -- [795]
			"EyesofBeast_Impact_Head.M2", -- [796]
			"FaerieFire.M2", -- [797]
			"FaerieFire_Impact.M2", -- [798]
			"FaerieFire_NoGlow.M2", -- [799]
			"FaerieFire_NoGlow_Impact.M2", -- [800]
			"FanofBananas.M2", -- [801]
			"FanofKnives.M2", -- [802]
			"FanofKnives_Impact.M2", -- [803]
			"FanofKnives_Missile.M2", -- [804]
			"FanofKnives_Precast.m2", -- [805]
			"FarSight_Impact_Base.M2", -- [806]
			"Fear_Impact_Chest.M2", -- [807]
			"Fear_State_Base.M2", -- [808]
			"Fear_State_Base_V2.M2", -- [809]
			"Fear_State_Head.M2", -- [810]
			"Feint_Impact_Chest.M2", -- [811]
			"FelArmor_Impact_Head.M2", -- [812]
			"Fel_Archimonde_Fire.M2", -- [813]
			"Fel_DemonForm.M2", -- [814]
			"Fel_DjinnDeath_Fire_02.M2", -- [815]
			"Fel_FireBlast_Impact_Chest.M2", -- [816]
			"Fel_FireBolt_Missile_Low.M2", -- [817]
			"Fel_FireNova_Area.M2", -- [818]
			"Fel_FireNova_State.M2", -- [819]
			"Fel_FireShieldFinal_Impact_Head.M2", -- [820]
			"Fel_FireWard_Impact_Chest.M2", -- [821]
			"Fel_Fire_ImpactDD_High_Chest.M2", -- [822]
			"Fel_Fire_Precast_Hand.M2", -- [823]
			"Fel_Fire_Precast_High_Hand.M2", -- [824]
			"Fel_Fire_Precast_Uber_Hand.M2", -- [825]
			"Fel_Fireball_Missile_High.M2", -- [826]
			"Fel_FlameBreath.M2", -- [827]
			"Fel_FlameBreath180.M2", -- [828]
			"Fel_FlameCircleEffect.m2", -- [829]
			"Fel_FlameShock_Impact_Chest.M2", -- [830]
			"Fel_FlamestrikeSmall_Impact_Base.M2", -- [831]
			"Fel_Flamestrike_Impact_Base.M2", -- [832]
			"Fel_HellFire_Area_Base.M2", -- [833]
			"Fel_HellFire_Area_Base_State.M2", -- [834]
			"Fel_HellFire_FirePuff_Caster_Base.M2", -- [835]
			"Fel_HellFire_Impact_Base.M2", -- [836]
			"Fel_HellFire_Impact_Caster_Base.M2", -- [837]
			"Fel_Immolate_Impact_Chest.M2", -- [838]
			"Fel_Immolate_State_Base.M2", -- [839]
			"Fel_LowPolyFireAnim.M2", -- [840]
			"Fel_PyroBlast_Missile.M2", -- [841]
			"Fel_RainOfFire_Impact_Base.M2", -- [842]
			"Fel_RainOfFire_Missile.M2", -- [843]
			"Fel_Shield_State_Base.M2", -- [844]
			"Fel_Warlock_DemonologyCharge_Ribbon.M2", -- [845]
			"Felbreaker_Bolt_Missile.m2", -- [846]
			"Felbreaker_FelExplosion_Impact.m2", -- [847]
			"Felbreaker_Floor_FX_Wrap.m2", -- [848]
			"Felbreaker_Groundcrack_State_Base.m2", -- [849]
			"Felbreaker_NulificationZone_State.m2", -- [850]
			"Fill_Arcane_Cast_01.M2", -- [851]
			"Fill_Arcane_Precast_01.M2", -- [852]
			"Fill_Bubble_State.M2", -- [853]
			"Fill_Corruption_Cast.M2", -- [854]
			"Fill_Corruption_Precast.M2", -- [855]
			"Fill_Corruption_State_01.M2", -- [856]
			"Fill_Corruption_Wedge_State.M2", -- [857]
			"Fill_Dust_Cast_Dark_01.M2", -- [858]
			"Fill_Dust_Cast_Light_01.M2", -- [859]
			"Fill_Dust_Cast_Medium_01.M2", -- [860]
			"Fill_Dust_Precast_Dark_01.M2", -- [861]
			"Fill_Dust_Precast_Light_01.M2", -- [862]
			"Fill_Dust_Precast_Medium_01.M2", -- [863]
			"Fill_Earth_Cast_01.M2", -- [864]
			"Fill_Earth_Cast_01_SHORT.M2", -- [865]
			"Fill_Earth_Precast_01.M2", -- [866]
			"Fill_Fel_Cast_01.M2", -- [867]
			"Fill_Fel_Precast_01.M2", -- [868]
			"Fill_Fire_Cast_01.M2", -- [869]
			"Fill_Fire_Precast_01.M2", -- [870]
			"Fill_Fire_State_01.M2", -- [871]
			"Fill_Fire_State_02.M2", -- [872]
			"Fill_Fire_State_03.M2", -- [873]
			"Fill_Fire_State_03_fel.m2", -- [874]
			"Fill_Frost_Cast_01.M2", -- [875]
			"Fill_Frost_Precast_01.M2", -- [876]
			"Fill_Frost_State_01.M2", -- [877]
			"Fill_Holy_Cast_01.M2", -- [878]
			"Fill_Holy_Precast_01.M2", -- [879]
			"Fill_Lightning_Cast_01.M2", -- [880]
			"Fill_Lightning_Cast_02.M2", -- [881]
			"Fill_Lightning_Precast_01.M2", -- [882]
			"Fill_Lightning_Precast_01_LowRes.M2", -- [883]
			"Fill_Lightning_Precast_02.M2", -- [884]
			"Fill_Magma_Cast_01.M2", -- [885]
			"Fill_Magma_Precast_01.M2", -- [886]
			"Fill_Poison_Cast_01.M2", -- [887]
			"Fill_Poison_Precast_01.M2", -- [888]
			"Fill_Poison_State_01.M2", -- [889]
			"Fill_Rising_Shadow_State.M2", -- [890]
			"Fill_Sha_Cast_01.M2", -- [891]
			"Fill_Sha_Precast_01.M2", -- [892]
			"Fill_Sha_Precast_02.M2", -- [893]
			"Fill_Sha_Precast_pride.M2", -- [894]
			"Fill_Shadow_Cast_01.M2", -- [895]
			"Fill_Shadow_Precast_01.M2", -- [896]
			"Fill_Shadow_State.M2", -- [897]
			"Fill_Template_State_01.M2", -- [898]
			"Fill_Thick_Shadow_State.M2", -- [899]
			"Fill_Void_Cast.M2", -- [900]
			"Fill_Void_Precast.M2", -- [901]
			"Fill_Water_Cast_01.M2", -- [902]
			"Fill_Water_Precast_01.M2", -- [903]
			"Fill_Wind_Cast_01.M2", -- [904]
			"Fill_Wind_Cast_02.M2", -- [905]
			"Fill_Wind_Precast_01.M2", -- [906]
			"FireBeam_Neutral_State_Base.M2", -- [907]
			"FireBeam_State_Base.M2", -- [908]
			"FireBlast_Blue_Impact_Chest.M2", -- [909]
			"FireBlast_Impact_Chest.m2", -- [910]
			"FireBlast_Impact_Chest_Pink.M2", -- [911]
			"FireBlast_Impact_Chest_Sha.M2", -- [912]
			"FireBolt_Blue_ImpactDD_Med_Chest.M2", -- [913]
			"FireBolt_Blue_Missile_Low.M2", -- [914]
			"FireBolt_ImpactDD_Med_Chest.M2", -- [915]
			"FireBolt_ImpactDD_Med_Chest_Sha.M2", -- [916]
			"FireBolt_Missile_Low.M2", -- [917]
			"FireBomb_Missle.M2", -- [918]
			"FireElemental_kar_Low.m2", -- [919]
			"FireForceShield_Blue.M2", -- [920]
			"FireForceShield_Dark.M2", -- [921]
			"FireForceShield_Green.M2", -- [922]
			"FireForceShield_Purple.M2", -- [923]
			"FireForceShield_Red.M2", -- [924]
			"FireForceShield_Yellow.M2", -- [925]
			"FireHawkBodySmoke.M2", -- [926]
			"FireHawkWingSmoke.M2", -- [927]
			"FireNova_Area.M2", -- [928]
			"FireNova_Area_Sha.M2", -- [929]
			"FireNova_Blue_Area.M2", -- [930]
			"FireNova_Blue_State.M2", -- [931]
			"FireNova_State.M2", -- [932]
			"FireNova_State_Sha.M2", -- [933]
			"FireReflect_State_Chest.M2", -- [934]
			"FireResistance_Impact_Base.M2", -- [935]
			"FireShieldFinal_Impact_Head.M2", -- [936]
			"FireShield_Impact_Head.M2", -- [937]
			"FireShot_Missile.M2", -- [938]
			"FireStrike_Missile_Low.M2", -- [939]
			"FireWard_Impact_Chest.M2", -- [940]
			"Fire_2d_effect.M2", -- [941]
			"Fire_Blue_ImpactDD_High_Chest.M2", -- [942]
			"Fire_Blue_Precast_Hand.M2", -- [943]
			"Fire_Blue_Precast_High_Hand.M2", -- [944]
			"Fire_Blue_Precast_Uber_Hand.M2", -- [945]
			"Fire_Cast_Hand.M2", -- [946]
			"Fire_Cast_Hand_Jade.M2", -- [947]
			"Fire_DOT_State_Chest.m2", -- [948]
			"Fire_DOT_State_Chest_Jade.M2", -- [949]
			"Fire_Fill_State_02.M2", -- [950]
			"Fire_Form_Precast.M2", -- [951]
			"Fire_Form_Precast_Jade.M2", -- [952]
			"Fire_ImpactDD_Chest.M2", -- [953]
			"Fire_ImpactDD_High_Base.M2", -- [954]
			"Fire_ImpactDD_High_Chest.M2", -- [955]
			"Fire_ImpactDD_High_Chest_Sha.M2", -- [956]
			"Fire_ImpactDD_Low_Chest.M2", -- [957]
			"Fire_ImpactDD_Med_Chest.M2", -- [958]
			"Fire_ImpactDD_Uber_Base.M2", -- [959]
			"Fire_ImpactDD_Uber_Chest.M2", -- [960]
			"Fire_Precast_Hand.M2", -- [961]
			"Fire_Precast_Hand_Pink.M2", -- [962]
			"Fire_Precast_Hand_Sha.M2", -- [963]
			"Fire_Precast_High_Hand.M2", -- [964]
			"Fire_Precast_Low_Hand.M2", -- [965]
			"Fire_Precast_Med_Hand.M2", -- [966]
			"Fire_Precast_Uber_Hand.M2", -- [967]
			"Fire_Rune_Impact_Base.m2", -- [968]
			"Fire_Rune_Shield_Impact_Base.M2", -- [969]
			"Fire_SmokeTrail.M2", -- [970]
			"Fire_Stylized_Var3_Fel.M2", -- [971]
			"Fire_Stylized_var_1.M2", -- [972]
			"Fire_Stylized_var_2.M2", -- [973]
			"Fire_Stylized_var_3.M2", -- [974]
			"Fire_Stylized_var_3_Sha.M2", -- [975]
			"Firearm_2H_Rifle_01_SpellObject.M2", -- [976]
			"Firearm_2H_Rifle_02_SpellObject.M2", -- [977]
			"Firearm_2H_Rifle_Cataclysm_B_01_Spell.M2", -- [978]
			"Firearm_2H_Rifle_Plague_A_01_spell.M2", -- [979]
			"Fireball_Blue_Missile_High.M2", -- [980]
			"Fireball_Missile_High.M2", -- [981]
			"Fireball_Missile_Low.M2", -- [982]
			"Fireball_Missile_Shadow_High.M2", -- [983]
			"Firecrackers_Thrown.M2", -- [984]
			"FirelandsSky_Fireball01_Spell.M2", -- [985]
			"Firelands_Cocoon.M2", -- [986]
			"Firelands_Fire_2d.M2", -- [987]
			"Firelands_Fire_2d_B.M2", -- [988]
			"Firelands_Fire_2d_C.M2", -- [989]
			"Firelands_WebSpin.M2", -- [990]
			"Firelands_Web_Missile.M2", -- [991]
			"Firelands_Web_State.M2", -- [992]
			"Firework_RomanCandle_Impact_Chest_01.M2", -- [993]
			"Firework_RomanCandle_Missle_01.M2", -- [994]
			"Fireworks_Blue_01.M2", -- [995]
			"Fireworks_Blue_02.M2", -- [996]
			"Fireworks_Green_01.M2", -- [997]
			"Fireworks_JadeSerpent.M2", -- [998]
			"Fireworks_PandaCharacters.M2", -- [999]
			"Fireworks_PandaStyle.M2", -- [1000]
			"Fireworks_PandaStyle2.M2", -- [1001]
			"Fireworks_RWB_01.M2", -- [1002]
			"Fireworks_RedStreaks_01.M2", -- [1003]
			"Fireworks_RedStreaks_02.M2", -- [1004]
			"Fireworks_Red_01.M2", -- [1005]
			"Fireworks_Spirals.M2", -- [1006]
			"Fireworks_YellowRose.M2", -- [1007]
			"FireySeductress.m2", -- [1008]
			"FirstAid_Hand.M2", -- [1009]
			"FirstAid__Impact_Base.M2", -- [1010]
			"FistOfJustice_Cast_Base.M2", -- [1011]
			"FistOfJustice_Impact_Chest.M2", -- [1012]
			"Fixated_State.M2", -- [1013]
			"Fixated_State_blue.M2", -- [1014]
			"Fixated_State_green.M2", -- [1015]
			"Fixated_State_orange.M2", -- [1016]
			"Fixated_State_purple.M2", -- [1017]
			"Fixated_State_yellow.M2", -- [1018]
			"FlameBreath.M2", -- [1019]
			"FlameBreath180.M2", -- [1020]
			"FlameBreath180_Blue.M2", -- [1021]
			"FlameBreathMFF.M2", -- [1022]
			"FlameBreath_Blue.M2", -- [1023]
			"FlameCircleEffect.m2", -- [1024]
			"FlameCircleEffect_Blue.m2", -- [1025]
			"FlameShock_Blue_Impact_Chest.M2", -- [1026]
			"FlameShock_Impact_Chest.M2", -- [1027]
			"FlameStrike_Black_ImpactDD_Med_Base.M2", -- [1028]
			"FlameStrike_ImpactDD_Med_Base.M2", -- [1029]
			"FlameZone.m2", -- [1030]
			"FlamestrikeSmall_Blue_Impact_Base.M2", -- [1031]
			"FlamestrikeSmall_Impact_Base.M2", -- [1032]
			"Flamestrike_Area.M2", -- [1033]
			"Flamestrike_Blue_Impact_Base.M2", -- [1034]
			"Flamestrike_Impact.M2", -- [1035]
			"Flamestrike_Impact_Base.M2", -- [1036]
			"Flare_Cast_Base.M2", -- [1037]
			"Flare_State_Base.M2", -- [1038]
			"Flare_State_BaseHostile.M2", -- [1039]
			"FlashHeal_Base.M2", -- [1040]
			"FloatingMine.M2", -- [1041]
			"FloatingMineNexus.M2", -- [1042]
			"FloatingMineNexusPulse.M2", -- [1043]
			"FloatingMinePulse.M2", -- [1044]
			"FlowingWater_High.M2", -- [1045]
			"FocusedCasting_State_Chest.m2", -- [1046]
			"Focused_Attacks_Impact.M2", -- [1047]
			"Food_HealEffect_Base.M2", -- [1048]
			"Football_pigskin_missile.M2", -- [1049]
			"ForceShield_AndXplosion.M2", -- [1050]
			"ForceofNature_Impact.M2", -- [1051]
			"ForsakenCatapult_Missile.M2", -- [1052]
			"ForsakenCatapult_Missile_Blue.M2", -- [1053]
			"FotF_Wings_01.M2", -- [1054]
			"FotF_Wings_Slow.M2", -- [1055]
			"FrostArmorEffect_Impact_Chest.M2", -- [1056]
			"FrostArmor_Low_Head.m2", -- [1057]
			"FrostBeam_Neutral_State_Base.M2", -- [1058]
			"FrostBeam_State_Base.M2", -- [1059]
			"FrostBreath.M2", -- [1060]
			"FrostReflect_State_Chest.M2", -- [1061]
			"FrostShot_Missile.M2", -- [1062]
			"FrostSlash_Base_Cast.M2", -- [1063]
			"FrostTrap_Aura.M2", -- [1064]
			"FrostTrap_AuraHostile.M2", -- [1065]
			"FrostTrap_Aura_noMist.m2", -- [1066]
			"FrostTrap_Aura_noMist_Refelctive.m2", -- [1067]
			"FrostWard_Impact_Chest.M2", -- [1068]
			"FrostZone.M2", -- [1069]
			"Frost_Blades.M2", -- [1070]
			"Frost_Form_Precast.M2", -- [1071]
			"Frost_Ground_Trail_HighQ.M2", -- [1072]
			"Frost_Nova_area.M2", -- [1073]
			"Frost_Nova_area_noparticles.m2", -- [1074]
			"Frost_Nova_state.M2", -- [1075]
			"Frostbite_Nova.M2", -- [1076]
			"Frostbite_Nova_LessIntense.M2", -- [1077]
			"Frostbolt.M2", -- [1078]
			"Frostmourne_Shatters.M2", -- [1079]
			"Frostwhisper_Icewall_Base.M2", -- [1080]
			"FrostyCircle.m2", -- [1081]
			"FrostyCircle_Blue.M2", -- [1082]
			"FrostyCircle_Fire.M2", -- [1083]
			"FrostyCircle_Nature.M2", -- [1084]
			"FrostyCircle_Sand.M2", -- [1085]
			"FrostyCircle_Shadow.M2", -- [1086]
			"GOO_SPLASH_STATE_v2.M2", -- [1087]
			"GOREN_SPIKE_IMPACT_IRONHORDE.m2", -- [1088]
			"GOREN_SPIKE_MISSILE_BLUE.m2", -- [1089]
			"GOREN_SPIKE_MISSILE_FIRE.m2", -- [1090]
			"GOREN_SPIKE_MISSILE_IRONHORDE.m2", -- [1091]
			"G_Fireworks_Alliance.M2", -- [1092]
			"G_Fireworks_Horde.M2", -- [1093]
			"G_PetTrap_01Missile.M2", -- [1094]
			"G_PetTrap_02Missile.M2", -- [1095]
			"G_PetTrap_03Missile.M2", -- [1096]
			"G_ShannoxTrap.M2", -- [1097]
			"Garrison_Shipment_Pending_State.m2", -- [1098]
			"Garrosh_BloodDrip.M2", -- [1099]
			"Garrosh_BloodPool.M2", -- [1100]
			"Garrosh_Desecrate_Ooze.M2", -- [1101]
			"Garrosh_Engine_spell.M2", -- [1102]
			"Garrosh_Fire_Cast_01.M2", -- [1103]
			"Garrosh_Fire_Precast_01.M2", -- [1104]
			"Garrosh_Shockwave_State_Base.M2", -- [1105]
			"Garrosh_TransitionFX_01.M2", -- [1106]
			"Garrosh_TransitionFX_02.M2", -- [1107]
			"Garrosh_TransitionFX_Disintegrate.M2", -- [1108]
			"Garrosh_TransitionFX_FlashNova.M2", -- [1109]
			"Garrosh_TransitionFX_MissileRibbons.M2", -- [1110]
			"Garrosh_TransitionFX_Nova.M2", -- [1111]
			"Garrosh_TransitionFX_WhirlingCorruption.M2", -- [1112]
			"Garrosh_WhirlingCorruption_Missile.M2", -- [1113]
			"GaseousForm.M2", -- [1114]
			"GeoSet_Corrupted_ElbowR_01.M2", -- [1115]
			"Ghost_state.M2", -- [1116]
			"Ghost_state2.M2", -- [1117]
			"GhostlyStrike_Impact_Chest.M2", -- [1118]
			"GiantInsectSwarm_State_Chest.M2", -- [1119]
			"GiantInsectSwarm_State_Ground.M2", -- [1120]
			"Giant_Thunderlord_State_Base.M2", -- [1121]
			"GiftOfNaaru.M2", -- [1122]
			"GiftWaterSpirit_Impact_Base.M2", -- [1123]
			"GlaiveThrowerVehicle_Glaive_Spell_Purple.m2", -- [1124]
			"GlaiveThrowerVehicle_Glaive_Spell_Red.M2", -- [1125]
			"Glass_Explosion_Base_QuickFade.m2", -- [1126]
			"Goblin_Cannon_Missile.m2", -- [1127]
			"Goblin_Lightbulb_State.M2", -- [1128]
			"Goblin_Rocket_Particle.M2", -- [1129]
			"Goblin_Weather_Machine_Cloudy.M2", -- [1130]
			"Goblin_Weather_Machine_Lightning.M2", -- [1131]
			"Goblin_Weather_Machine_Rain.M2", -- [1132]
			"Goblin_Weather_Machine_Snow.M2", -- [1133]
			"Goblin_Weather_Machine_Sunny.M2", -- [1134]
			"GoldArenaflag_spell.m2", -- [1135]
			"GoldHordeflag_spell.m2", -- [1136]
			"GoldenLotus_Cranekick_State.M2", -- [1137]
			"GoldenLotus_DarkMeditation_AntiMagicZone.M2", -- [1138]
			"GoldenLotus_DarkMeditation_FX_Wrap.M2", -- [1139]
			"GoldenLotus_FrostyCircle_Sha.M2", -- [1140]
			"GoldenLotus_KegToss_Impact.M2", -- [1141]
			"GoldenLotus_MarkOfDeath_Eyes.M2", -- [1142]
			"GoldenLotus_MarkOfDeath_Missile.M2", -- [1143]
			"GoldenLotus_Sha_LightningBolt.M2", -- [1144]
			"GoldenLotus_Sha_LivingBomb.M2", -- [1145]
			"GoldenLotus_Sha_LivingBomb_pride.M2", -- [1146]
			"GoldenLotus_Sha_MindShear.M2", -- [1147]
			"GoldenLotus_Sha_ShadoPalm_Missile.M2", -- [1148]
			"GooBolt_Missile_Low.M2", -- [1149]
			"GooBolt_Missile_Low_Purple.M2", -- [1150]
			"Goo_Flow_State.m2", -- [1151]
			"Goo_Flow_StateBlack.M2", -- [1152]
			"Goo_Flow_StateBlue.M2", -- [1153]
			"Goo_Flow_StateFire.M2", -- [1154]
			"Goo_Flow_StatePurple.M2", -- [1155]
			"Goo_Flow_StateRed.M2", -- [1156]
			"Goo_Flow_StateSilver.M2", -- [1157]
			"Goo_Flow_StateYellow.M2", -- [1158]
			"Goo_Flow_StateYellow_02.M2", -- [1159]
			"Goo_Flow_State_02.M2", -- [1160]
			"Goo_Flow_State_Projected.M2", -- [1161]
			"Goo_Flow_State_Sha.M2", -- [1162]
			"Goo_Flow_Statewater.M2", -- [1163]
			"Goo_Root_StateBlack.M2", -- [1164]
			"Goo_Splash_State.M2", -- [1165]
			"Goo_Splash_StateBlack.M2", -- [1166]
			"Goo_Splash_StateBlack_Light.M2", -- [1167]
			"Goo_Splash_StateBlue.M2", -- [1168]
			"Goo_Splash_StateBlue_90.M2", -- [1169]
			"Goo_Splash_StateFire_V2.M2", -- [1170]
			"Goo_Splash_StatePurple.M2", -- [1171]
			"Goo_Splash_StatePurple_90.M2", -- [1172]
			"Goo_Splash_StateRed.M2", -- [1173]
			"Goo_Splash_StateYellow.M2", -- [1174]
			"Goo_flow_state_dark_beer.M2", -- [1175]
			"Goo_flow_state_medium_beer.M2", -- [1176]
			"Goo_flow_state_wheat_beer.M2", -- [1177]
			"Goo_splash_state_dark_beer.M2", -- [1178]
			"Goo_splash_state_medium_beer.M2", -- [1179]
			"Goo_splash_state_wheat_beer.M2", -- [1180]
			"Goop_Bolt_Missile_01.M2", -- [1181]
			"Goop_Cast_01.M2", -- [1182]
			"Goop_Impact_01.M2", -- [1183]
			"Goop_Impact_Base_01.M2", -- [1184]
			"Goop_Impact_Chest.M2", -- [1185]
			"Goop_Precast_01.M2", -- [1186]
			"Goop_State_01.M2", -- [1187]
			"Goop_State_03.M2", -- [1188]
			"Goop_State_04.M2", -- [1189]
			"Goren_Spike_Impact_Amber.m2", -- [1190]
			"Goren_Spike_Missile_Amber.m2", -- [1191]
			"Goren_Spike_Missile_Frost.m2", -- [1192]
			"Goren_Spike_Missile_Green.m2", -- [1193]
			"Gouge_Precast_State_Hand.M2", -- [1194]
			"GreaterBeholder_Egg.M2", -- [1195]
			"GreaterBeholder_Rock.M2", -- [1196]
			"GreaterHeal_Low_Base.M2", -- [1197]
			"GreenArenaflag_spell.m2", -- [1198]
			"GreenGhost_state.M2", -- [1199]
			"GreenHordeflag_spell.m2", -- [1200]
			"GreenRadiationFog.M2", -- [1201]
			"Green_Gas_Plague_Cloud.M2", -- [1202]
			"Gronn_Thunderlord_State_Base.M2", -- [1203]
			"GroundCrack_Fel_State.M2", -- [1204]
			"GroundCrack_Fire_State.M2", -- [1205]
			"GroundCrack_Fire_State_Large.M2", -- [1206]
			"GroundCrack_Holy_State.M2", -- [1207]
			"GroundCrack_Holy_State_Large.M2", -- [1208]
			"GroundCrack_Ice_State.M2", -- [1209]
			"GroundCrack_Ice_State_Large.M2", -- [1210]
			"GroundCrack_Lightning_State.M2", -- [1211]
			"GroundCrack_Lightning_State_Large.M2", -- [1212]
			"GroundCrack_Physical_State.M2", -- [1213]
			"GroundCrack_Physical_State_Large.M2", -- [1214]
			"GroundDust.M2", -- [1215]
			"GroundSpike_Impact.M2", -- [1216]
			"Ground_Rupture.M2", -- [1217]
			"GroundingTotem_Impact.M2", -- [1218]
			"Guarded_by_Light_Impact.M2", -- [1219]
			"Guldan_Caustics_FX_Wrap.m2", -- [1220]
			"Guldan_LightShaft_State.m2", -- [1221]
			"Guldan_Rune_State.m2", -- [1222]
			"Guldan_Soul_State.m2", -- [1223]
			"HIGHMAUL_ARCANERUNE_BASE_STATE_PINK.M2", -- [1224]
			"Hammer_of_the_Righteous_Cast.M2", -- [1225]
			"Hammer_of_the_Righteous_Impact.M2", -- [1226]
			"Hammer_of_the_Righteous_Missile.M2", -- [1227]
			"HansFranz_Hotplate_State.m2", -- [1228]
			"HansFranz_StampingPress_State.m2", -- [1229]
			"HarmUndeadAura_Base.M2", -- [1230]
			"Harpoon_Fire_Missile.M2", -- [1231]
			"Haunt_Heal.M2", -- [1232]
			"Haunt_Impact.M2", -- [1233]
			"Haunt_Missile.M2", -- [1234]
			"Haunt_Missile_Soul.M2", -- [1235]
			"HeadSplitter_Impact_Chest.m2", -- [1236]
			"HeadlesshorsemanHelmet.M2", -- [1237]
			"HealRag_State_Chest.M2", -- [1238]
			"Heal_Low_Base.m2", -- [1239]
			"HealingAura_Base.M2", -- [1240]
			"Heat_Signature.M2", -- [1241]
			"HellFire_Area_Base.M2", -- [1242]
			"HellFire_Blue_FirePuff_Caster_Base.m2", -- [1243]
			"HellFire_Blue_Impact_Base.M2", -- [1244]
			"HellFire_Blue_Impact_Caster_Base.M2", -- [1245]
			"HellFire_Channel_Base.m2", -- [1246]
			"HellFire_FirePuff_Caster_Base.M2", -- [1247]
			"HellFire_FirePuff_Caster_Base_Pink.M2", -- [1248]
			"HellFire_FirePuff_Caster_Base_V2.M2", -- [1249]
			"HellFire_FirePuff_Caster_Base_V3.M2", -- [1250]
			"HellFire_FirePuff_Caster_Base_V3_Sha.M2", -- [1251]
			"HellFire_Impact_Base.M2", -- [1252]
			"HellFire_Impact_Caster_Base.M2", -- [1253]
			"HellFire_Impact_Caster_Base_Sha.M2", -- [1254]
			"HellFire_Impact_Head.m2", -- [1255]
			"HellfireRaid_Dust_Brown_Impact_Base.M2", -- [1256]
			"HellfireRaid_Dust_Brown_Impact_Base_Shaded.M2", -- [1257]
			"HellfireRaid_Dust_Impact_Base.m2", -- [1258]
			"Hellfire_impact_caster_State.M2", -- [1259]
			"Helm_Engi_B_01_GoF_Spell.M2", -- [1260]
			"Heroism_Cast.M2", -- [1261]
			"Heroism_State.M2", -- [1262]
			"HitSplatFire.m2", -- [1263]
			"HolyBomb_Missle.M2", -- [1264]
			"HolyDivineShieldBlue_State_Base.M2", -- [1265]
			"HolyDivineShieldDarkRed_State_Base.M2", -- [1266]
			"HolyDivineShieldDark_State_Base.M2", -- [1267]
			"HolyDivineShieldGreen_State_Base.M2", -- [1268]
			"HolyDivineShieldPurple_State_Base.M2", -- [1269]
			"HolyDivineShieldRed_State_Base.M2", -- [1270]
			"HolyDivineShield_State_Base.M2", -- [1271]
			"HolyLight_Impact_Base_02.m2", -- [1272]
			"HolyLight_Impact_Head.M2", -- [1273]
			"HolyLight_Low_Head.M2", -- [1274]
			"HolyNova_Impact_Base.M2", -- [1275]
			"HolyProtection_Chest.M2", -- [1276]
			"HolyReflect_State_Chest.M2", -- [1277]
			"HolyShear.M2", -- [1278]
			"HolyShield_State.M2", -- [1279]
			"HolySmite_Low_Chest.M2", -- [1280]
			"HolyWard_Impact_Chest.M2", -- [1281]
			"HolyWard_State_Chest.M2", -- [1282]
			"HolyWordHeal_Base.M2", -- [1283]
			"HolyWordShield_Base.M2", -- [1284]
			"HolyWordShield_State_Base.m2", -- [1285]
			"HolyWordShield_State_Chest.m2", -- [1286]
			"HolyWord_Fortitude_Impact_Base.M2", -- [1287]
			"HolyZone.m2", -- [1288]
			"Holy_Form_Precast.M2", -- [1289]
			"Holy_Hammer_missile.M2", -- [1290]
			"Holy_ImpactDD_High_Base.m2", -- [1291]
			"Holy_ImpactDD_High_Chest.M2", -- [1292]
			"Holy_ImpactDD_Low_Chest.m2", -- [1293]
			"Holy_ImpactDD_Med_Chest.m2", -- [1294]
			"Holy_ImpactDD_Uber_Base.m2", -- [1295]
			"Holy_ImpactDD_Uber_Chest.M2", -- [1296]
			"Holy_Missile_High.M2", -- [1297]
			"Holy_Missile_Low.M2", -- [1298]
			"Holy_Missile_Med.M2", -- [1299]
			"Holy_Missile_Uber.M2", -- [1300]
			"Holy_Precast_High_Base.M2", -- [1301]
			"Holy_Precast_High_Hand.M2", -- [1302]
			"Holy_Precast_Low_Base.m2", -- [1303]
			"Holy_Precast_Low_Hand.M2", -- [1304]
			"Holy_Precast_Med_Hand.M2", -- [1305]
			"Holy_Precast_Med_Hand_Simple.M2", -- [1306]
			"Holy_Precast_Uber_Base.M2", -- [1307]
			"Holy_Precast_Uber_Hand.M2", -- [1308]
			"Holy_Rune_Impact_Base.M2", -- [1309]
			"Holy_Rune_Shield_Impact_Base.M2", -- [1310]
			"Holy_Vol_Fog.M2", -- [1311]
			"Honor_Among_Thieves_Impact.m2", -- [1312]
			"HordeCTFflag_spell.M2", -- [1313]
			"HordeCTFflag_spell_NoRibbon.M2", -- [1314]
			"Horde_ArenaFlagR1.m2", -- [1315]
			"Horde_ArenaFlagR2.m2", -- [1316]
			"Horde_ArenaFlagR3.m2", -- [1317]
			"Horde_ArenaFlagR4.m2", -- [1318]
			"Horn_01_SpellObject.m2", -- [1319]
			"Horridon_DoubleSwipe_Back_Cast.M2", -- [1320]
			"Horridon_DoubleSwipe_Back_Precast.M2", -- [1321]
			"Horridon_DoubleSwipe_Front_Cast.M2", -- [1322]
			"Horridon_DoubleSwipe_Front_Precast.M2", -- [1323]
			"Hour_of_Twilight_Area.M2", -- [1324]
			"Hour_of_Twilight_Precast.M2", -- [1325]
			"HungerForBlood_Impact.m2", -- [1326]
			"HungerforBlood_State.m2", -- [1327]
			"Hunter_Aspectofthefox_Impact_01.M2", -- [1328]
			"Hunter_BindingShot_State.M2", -- [1329]
			"Hunter_BindingShot_State_Base.M2", -- [1330]
			"Hunter_Focusfire_Impact_01.M2", -- [1331]
			"Hunter_GlaiveLeft_Impact.M2", -- [1332]
			"Hunter_GlaiveLeft_Missile.M2", -- [1333]
			"Hunter_GlaiveRight_Missile.M2", -- [1334]
			"Hunter_Killcommand_Impact_01.M2", -- [1335]
			"Hunter_LockandLoad.m2", -- [1336]
			"Hunter_Mastermarksman_Impact_01.M2", -- [1337]
			"Hunter_MastersCall_Base.M2", -- [1338]
			"Hunter_MastersCall_State.M2", -- [1339]
			"Hunter_MurderOfCrows_Impact_Chest.M2", -- [1340]
			"Hunter_MurderOfCrows_Missile.M2", -- [1341]
			"Hunter_MurderOfCrows_Missile_B.M2", -- [1342]
			"Hunter_MurderOfCrows_Missile_C.M2", -- [1343]
			"Hunter_RapidFire.M2", -- [1344]
			"HuntersMark_Impact_Chest.M2", -- [1345]
			"HuntersMark_Impact_Head.M2", -- [1346]
			"HuntersMark_Impact_Head_Hold.M2", -- [1347]
			"Hurricane_Wind.M2", -- [1348]
			"Hurricane_Wind_Hostile.M2", -- [1349]
			"Hurricane_Wind_Old.M2", -- [1350]
			"IMMOLATE_STATE_BASE_V2_FEL.M2", -- [1351]
			"IMMOLATE_STATE_BASE_V2_ILLIDARI.M2", -- [1352]
			"IMMOLATE_STATE_BASE_V2_TWILIGHT.M2", -- [1353]
			"IMMOLATE_STATE_V2_FEL.M2", -- [1354]
			"IMMOLATE_STATE_V2_ILLIDARI.M2", -- [1355]
			"INCINERATE_IMPACT_BASE_FEL.M2", -- [1356]
			"INCINERATE_IMPACT_BASE_ILLIDARI.M2", -- [1357]
			"INCINERATE_IMPACT_BASE_TWILIGHT.M2", -- [1358]
			"INCINERATE_LOW_BASE_FEL.M2", -- [1359]
			"INCINERATE_LOW_BASE_ILLIDARI.M2", -- [1360]
			"INCINERATE_LOW_BASE_TWILIGHT.M2", -- [1361]
			"IRONHORDE_CHAINSSHACKLE_STATE.m2", -- [1362]
			"ITK_Custom_Itoka_ElectricPoolFill_E.M2", -- [1363]
			"ITK_Custom_Itoka_ElectricPoolFill_N.M2", -- [1364]
			"ITK_Custom_Itoka_ElectricPoolFill_S.M2", -- [1365]
			"ITK_Custom_Itoka_ElectricPoolFill_W.M2", -- [1366]
			"IceArmor_Low_Head.m2", -- [1367]
			"IceBarrier_State.M2", -- [1368]
			"IceBarrier_State_Selectable.M2", -- [1369]
			"IceCrownRaid_arthas_precipice_phase1_Quad1.m2", -- [1370]
			"IceCrownRaid_arthas_precipice_phase1_Quad2.m2", -- [1371]
			"IceCrownRaid_arthas_precipice_phase1_Quad3.m2", -- [1372]
			"IceCrownRaid_arthas_precipice_phase1_Quad4.m2", -- [1373]
			"IceCrownRaid_arthas_precipice_phase2_Quad1.m2", -- [1374]
			"IceCrownRaid_arthas_precipice_phase2_Quad2.m2", -- [1375]
			"IceCrownRaid_arthas_precipice_phase2_Quad3.m2", -- [1376]
			"IceCrownRaid_arthas_precipice_phase2_Quad4.m2", -- [1377]
			"IceCrown_Frostmourne_Altar_Effect.M2", -- [1378]
			"IceCrown_LabBottle_01_Spell.m2", -- [1379]
			"IceCrown_LabBottle_02_Spell.m2", -- [1380]
			"IceCrown_LabBottle_03_Spell.m2", -- [1381]
			"IceNuke_Base_Impact.M2", -- [1382]
			"IceNuke_Missile.M2", -- [1383]
			"IcePrison_Base.M2", -- [1384]
			"IceShield_State.M2", -- [1385]
			"IceSpike_Impact_Base.M2", -- [1386]
			"IceSpike_Impact_Base_V2.M2", -- [1387]
			"IceSpike_Impact_New.M2", -- [1388]
			"Ice_Barrier_State_Chest.M2", -- [1389]
			"Ice_Cast_Low_Hand.M2", -- [1390]
			"Ice_DeepFreeze.m2", -- [1391]
			"Ice_ImpactDD_High_Chest.M2", -- [1392]
			"Ice_ImpactDD_Low_Chest.M2", -- [1393]
			"Ice_ImpactDD_Med_Chest.M2", -- [1394]
			"Ice_ImpactDD_Uber_Chest.M2", -- [1395]
			"Ice_Lance_Impact.M2", -- [1396]
			"Ice_Lance_Missile.M2", -- [1397]
			"Ice_Missile_High.M2", -- [1398]
			"Ice_Missile_Low.M2", -- [1399]
			"Ice_Missile_Med.M2", -- [1400]
			"Ice_Missile_Uber.M2", -- [1401]
			"Ice_Nova.m2", -- [1402]
			"Ice_Precast_High_Base.M2", -- [1403]
			"Ice_Precast_High_Hand.M2", -- [1404]
			"Ice_Precast_High_Head.M2", -- [1405]
			"Ice_Precast_Low_Hand.M2", -- [1406]
			"Ice_Precast_Med_Hand.M2", -- [1407]
			"Ice_Precast_Uber_Base.M2", -- [1408]
			"Ice_Precast_Uber_Base_Var2.M2", -- [1409]
			"Ice_Precast_Uber_Hand.M2", -- [1410]
			"Ice_Precast_Uber_Head.M2", -- [1411]
			"Ice_Rune_Impact_Base.m2", -- [1412]
			"Ice_Rune_Shield_Impact_Base.M2", -- [1413]
			"IceboundFortitude_Ground.m2", -- [1414]
			"Icecrown_Snowflake.m2", -- [1415]
			"Icespire_FX.M2", -- [1416]
			"IcyEnchant_High.m2", -- [1417]
			"IcyVeins_FX.M2", -- [1418]
			"Illidan_Glave_Missile.m2", -- [1419]
			"Immerseus_Static_Skirt.M2", -- [1420]
			"Immerseus_WaterBreath_State_Channel.M2", -- [1421]
			"Immerseus_WaterSha_State_Projected.M2", -- [1422]
			"Immerseus_Water_Column.M2", -- [1423]
			"Immerseus_Waterfall_State_Base.M2", -- [1424]
			"Immolate_Blue_Impact_Chest.m2", -- [1425]
			"Immolate_Blue_State_Base.m2", -- [1426]
			"Immolate_Impact_Chest.m2", -- [1427]
			"Immolate_Impact_Chest_Pink.M2", -- [1428]
			"Immolate_Impact_Chest_Sha.M2", -- [1429]
			"Immolate_State.m2", -- [1430]
			"Immolate_State_Base.m2", -- [1431]
			"Immolate_State_Base_Pink.M2", -- [1432]
			"Immolate_State_Base_Sha.M2", -- [1433]
			"Immolate_State_Base_V2.M2", -- [1434]
			"Immolate_State_Base_V2_Jade.M2", -- [1435]
			"Immolate_State_Base_V2_Sha.M2", -- [1436]
			"Immolate_State_V2.M2", -- [1437]
			"Immolate_State_V2_Sha.M2", -- [1438]
			"ImmolationTrap_Recursive.m2", -- [1439]
			"Impact_Corrupted_Chest_01.M2", -- [1440]
			"Impact_Dark.M2", -- [1441]
			"Impact_Light.m2", -- [1442]
			"Impact_Poison_Base_01.M2", -- [1443]
			"Impact_Template_Base_01.M2", -- [1444]
			"Impact_Template_Base_02.M2", -- [1445]
			"Impact_Template_Chest_01.M2", -- [1446]
			"Impact_Template_World_01.M2", -- [1447]
			"ImplosiveGaseous_Nova.M2", -- [1448]
			"IncinerateBlue_Impact_Base.m2", -- [1449]
			"IncinerateBlue_Low_Base.m2", -- [1450]
			"Incinerate_Impact_Base.m2", -- [1451]
			"Incinerate_Impact_Base_Sha.M2", -- [1452]
			"Incinerate_Low_Base.m2", -- [1453]
			"Incinerate_Low_Base_BossAOE.m2", -- [1454]
			"Infernal_Ball.m2", -- [1455]
			"Infernal_Ball_02.m2", -- [1456]
			"Infernal_Flare_Rec.m2", -- [1457]
			"Infernal_Geo.m2", -- [1458]
			"Infernal_Impact.M2", -- [1459]
			"Infernal_Impact_Base.M2", -- [1460]
			"Infernal_Smoke_Rec.m2", -- [1461]
			"Infinite_TimeBomb_Impact.M2", -- [1462]
			"Infinite_TimeBomb_Missile.M2", -- [1463]
			"Infinite_TimeBomb_Reticule.M2", -- [1464]
			"Infinite_TimeBomb_XPlosion.M2", -- [1465]
			"Infusion_of_Light_Impact.m2", -- [1466]
			"InnerFire_Base.M2", -- [1467]
			"InnerFocus_Impact_Chest.M2", -- [1468]
			"InnerRage_Impact_Chest.M2", -- [1469]
			"InsectSwarm_State_Chest.M2", -- [1470]
			"InstanceNewPortal_Base.M2", -- [1471]
			"InstanceNewPortal_Blue.m2", -- [1472]
			"InstanceNewPortal_Blue_Arcane.m2", -- [1473]
			"InstanceNewPortal_Green.m2", -- [1474]
			"InstanceNewPortal_Green_Skull.m2", -- [1475]
			"InstanceNewPortal_Purple.m2", -- [1476]
			"InstanceNewPortal_Purple_ChallengeMode.M2", -- [1477]
			"InstanceNewPortal_Purple_Skull.m2", -- [1478]
			"InstanceNewPortal_Red.m2", -- [1479]
			"InstanceNewPortal_Skull.M2", -- [1480]
			"InstancePortal_Green_10Man.m2", -- [1481]
			"InstancePortal_Green_10Man_Heroic.m2", -- [1482]
			"InstancePortal_Green_25Man.m2", -- [1483]
			"InstancePortal_Green_25Man_Heroic.m2", -- [1484]
			"InterveneTrail.M2", -- [1485]
			"Intervene_Impact_Chest.M2", -- [1486]
			"IntimidatingShout_Cast_Base.M2", -- [1487]
			"IntimidatingShout_Impact_Head.m2", -- [1488]
			"Invisibility.M2", -- [1489]
			"Invisibility_Impact_Base.m2", -- [1490]
			"Invisibility_Impact_Chest.M2", -- [1491]
			"Invisible.M2", -- [1492]
			"IronMaiden_Bombardment_Missile.m2", -- [1493]
			"IronMaiden_BoomerangAxe_State_World.m2", -- [1494]
			"IronMaiden_LingeringShadow_Impact.m2", -- [1495]
			"IronMaiden_LingeringShadow_Missile.m2", -- [1496]
			"Item_Bread.m2", -- [1497]
			"JadeSpirit_High.M2", -- [1498]
			"JetPack.m2", -- [1499]
			"JetPack_Flame.m2", -- [1500]
			"Jinrokh_ThunderTroll_ElectricWater_State.M2", -- [1501]
			"Jinrokh_ThunderTroll_LightningChaser_NearZ_State.M2", -- [1502]
			"Jinrokh_ThunderTroll_Statue_Water_Geyser.M2", -- [1503]
			"Jinyu_Lightning_Storm_Impact10.M2", -- [1504]
			"Jinyu_Lightning_Storm_Impact30.M2", -- [1505]
			"Jinyu_Lightning_Storm_Impact50.M2", -- [1506]
			"Jinyu_Lightning_Storm_Impact70.M2", -- [1507]
			"Jinyu_Lightning_Storm_Pre10.M2", -- [1508]
			"Jinyu_Lightning_Storm_Pre30.M2", -- [1509]
			"Jinyu_Lightning_Storm_Pre50.M2", -- [1510]
			"Jinyu_Lightning_Storm_Pre70.M2", -- [1511]
			"Judgement_Impact_Chest.M2", -- [1512]
			"Judgement_Impact_Chest_Axe.M2", -- [1513]
			"Judgement_Impact_Chest_Blue.M2", -- [1514]
			"Judgement_Impact_Chest_Red.M2", -- [1515]
			"Judgement_Impact_Chest_Sword.M2", -- [1516]
			"Judgement_of_the_Pure_Impact.M2", -- [1517]
			"Judgements_of_the_Wise_Impact.m2", -- [1518]
			"Juggernaut_Death_Legs.M2", -- [1519]
			"KARABOR_POSTNUKE_STATE.m2", -- [1520]
			"KARABOR_PURIFIED_STATE.m2", -- [1521]
			"Karabor_Nuke_Precast_State.m2", -- [1522]
			"Kick_Chest_Impact.m2", -- [1523]
			"KidneyShot_Base_Cast.M2", -- [1524]
			"KillCommand_Impact_Head.m2", -- [1525]
			"Kologarn_Arm_FadeIn.m2", -- [1526]
			"LShoulder_Mail_RaidShaman_H_01SPELL.M2", -- [1527]
			"LShoulder_Mail_RaidShaman_H_02SPELL_Green.M2", -- [1528]
			"LShoulder_Mail_RaidShaman_H_02SPELL_Red.M2", -- [1529]
			"Lacerate_Impact.M2", -- [1530]
			"LargeBlueGreenRadiationFog.m2", -- [1531]
			"LargeGreenRadiationFog.m2", -- [1532]
			"Lash_Cast_Base.M2", -- [1533]
			"Lavaworm_AshenFire_01.M2", -- [1534]
			"LayonHands_Low_Chest.M2", -- [1535]
			"LayonHands_Low_Head.M2", -- [1536]
			"Learn_Impact_Base.M2", -- [1537]
			"Learn_Impact_Base_Green.M2", -- [1538]
			"LegendaryCloak_Crane_Impact_Base.M2", -- [1539]
			"LegendaryCloak_JadeSerpent_Impact_Base.M2", -- [1540]
			"LegendaryCloak_Ox_Impact_Base.M2", -- [1541]
			"LegendaryCloak_Tiger_Impact_Base.M2", -- [1542]
			"LeiShen_LightningCall.M2", -- [1543]
			"LeiShen_LightningCrack_Impact.M2", -- [1544]
			"LeiShen_Lightning_Bone_State.M2", -- [1545]
			"LeiShen_Lightning_Burst_Missile.M2", -- [1546]
			"LeiShen_Lightning_Column.M2", -- [1547]
			"LeiShen_Lightning_Fill.M2", -- [1548]
			"LeiShen_Lightning_Nova_State.M2", -- [1549]
			"LeiShen_Lightning_Precast.M2", -- [1550]
			"LeiShen_Lightning_Storm.M2", -- [1551]
			"LeiShen_Lightning_Whip_Impact_Base.M2", -- [1552]
			"LeiShen_Lightning_Whip_State.M2", -- [1553]
			"LesserHeal_Base.m2", -- [1554]
			"LevelUp_Blue.M2", -- [1555]
			"LevelUp_Red.M2", -- [1556]
			"Levitate_Impact_Base.m2", -- [1557]
			"LifeBloom_Impact.m2", -- [1558]
			"LifeBloom_State.m2", -- [1559]
			"LifeDrain_Missile.M2", -- [1560]
			"LifeTap.M2", -- [1561]
			"Lifetap_State_Chest.M2", -- [1562]
			"LightingBeam_Neutral_State_Base.M2", -- [1563]
			"LightingBeam_State_Base.M2", -- [1564]
			"LightningBoltIvus_Missile.M2", -- [1565]
			"LightningBolt_Impact_Chest.M2", -- [1566]
			"LightningBolt_Missile.M2", -- [1567]
			"LightningElemental_Impact_Base.M2", -- [1568]
			"LightningShield_Impact_Base.M2", -- [1569]
			"LightningShield_State_Base.M2", -- [1570]
			"LightningShield_State_Base_S.M2", -- [1571]
			"LightningShield_State_Base_low.M2", -- [1572]
			"LightningStorm_CloudLow_State.M2", -- [1573]
			"LightningStorm_Cloud_State.M2", -- [1574]
			"LightningStorm_Cloud_State_2.M2", -- [1575]
			"LightningStreak_Missile.M2", -- [1576]
			"Lightning_Area_Disc_State.M2", -- [1577]
			"Lightning_Area_Impact.M2", -- [1578]
			"Lightning_Area_Square_Cast_01.M2", -- [1579]
			"Lightning_Area_Square_Precast_01.M2", -- [1580]
			"Lightning_Cast_Hand.M2", -- [1581]
			"Lightning_Fel_Cast_Hand.M2", -- [1582]
			"Lightning_Fel_PreCast_Low_Hand.M2", -- [1583]
			"Lightning_Ground_Rupture.M2", -- [1584]
			"Lightning_Halo_Missile.M2", -- [1585]
			"Lightning_PreCast_Low_Hand.M2", -- [1586]
			"Lightning_Ring_Nova.M2", -- [1587]
			"Lightning_Ring_Nova_State.M2", -- [1588]
			"Lightning_Twilight_Cast_Hand.M2", -- [1589]
			"Lightning_Vortex_Precast.M2", -- [1590]
			"Lightningbolt_Impact_NoGlow.M2", -- [1591]
			"LiquidBreath_DeepBlue.M2", -- [1592]
			"LiquidBreath_DeepRed.M2", -- [1593]
			"LiquidBreath_YellowOrange.M2", -- [1594]
			"Lovestruck_State_Chest.m2", -- [1595]
			"LowPolyFireAnim_Blue.m2", -- [1596]
			"LowPolyFireAnim_Sha.M2", -- [1597]
			"LoyaltyDown_Impact_Base.M2", -- [1598]
			"LoyaltyDown_Impact_Head.M2", -- [1599]
			"LoyaltyUp_Impact_Base.M2", -- [1600]
			"LoyaltyUp_Impact_Head.M2", -- [1601]
			"MageArmor_Impact_Head.M2", -- [1602]
			"MagePortal_Blank.m2", -- [1603]
			"MagePortal_Blank_purple.m2", -- [1604]
			"MagePortal_DalaranCrater.M2", -- [1605]
			"MagePortal_Stormshield.m2", -- [1606]
			"MagePortal_Warspear.m2", -- [1607]
			"Mage_AlterTime_Impact.M2", -- [1608]
			"Mage_ArcaneBarrage_Impact.M2", -- [1609]
			"Mage_ArcaneBarrage_Missile.M2", -- [1610]
			"Mage_ArcaneBarrage_Missile_V2.M2", -- [1611]
			"Mage_Combustion_Impact_Chest.m2", -- [1612]
			"Mage_Combustion_State_Chest.m2", -- [1613]
			"Mage_Combustion_State_Chest_Fel.m2", -- [1614]
			"Mage_Curtainoffrost_01.M2", -- [1615]
			"Mage_Curtainoffrost_01Hostile.M2", -- [1616]
			"Mage_Curtainoffrost_Impact.M2", -- [1617]
			"Mage_DeepFreeze.m2", -- [1618]
			"Mage_Dragon_Breath_V2.M2", -- [1619]
			"Mage_Dragons_Breath.M2", -- [1620]
			"Mage_FingersOfFrost_Hand.m2", -- [1621]
			"Mage_FireFrostBolt.M2", -- [1622]
			"Mage_Firestarter.m2", -- [1623]
			"Mage_FrostBomb_Explosion.M2", -- [1624]
			"Mage_FrostBomb_Impact_Chest.M2", -- [1625]
			"Mage_FrostBomb_Pulse.M2", -- [1626]
			"Mage_FrostBomb_State_Chest.M2", -- [1627]
			"Mage_FrostJaw_Mouth.M2", -- [1628]
			"Mage_FrostOrb_Missile.M2", -- [1629]
			"Mage_FrostOrb_Missile_Hostile.m2", -- [1630]
			"Mage_FrostOrb_Missile_NoRibbon.M2", -- [1631]
			"Mage_FrostOrb_Orb.M2", -- [1632]
			"Mage_GreaterInvis_State_Base.M2", -- [1633]
			"Mage_GreaterInvis_State_Chest.M2", -- [1634]
			"Mage_HotStreak.m2", -- [1635]
			"Mage_IceFlow_State.M2", -- [1636]
			"Mage_IceWard_Impact_Chest.M2", -- [1637]
			"Mage_IncantersAbsorbtion.m2", -- [1638]
			"Mage_LivingBomb_Area.m2", -- [1639]
			"Mage_LivingBomb_State.m2", -- [1640]
			"Mage_Meteor_ImpactState_World.m2", -- [1641]
			"Mage_MissileBarrage.m2", -- [1642]
			"Mage_NetherwingPresence.M2", -- [1643]
			"Mage_RainOfFire_Spawn.M2", -- [1644]
			"Mage_RingofFrost_State_Hostile_Low.M2", -- [1645]
			"Mage_RingofFrost_State_Low.M2", -- [1646]
			"Mage_Riptide_Impact.m2", -- [1647]
			"Mage_Riptide_State.m2", -- [1648]
			"Mage_RuneOfPower_High.M2", -- [1649]
			"Mage_RuneOfPower_Low.M2", -- [1650]
			"Mage_RuneOfPower_State.M2", -- [1651]
			"Mage_ShatterShield.M2", -- [1652]
			"Mage_Timewarp_Impact_01.M2", -- [1653]
			"Mage_Timewarp_Impact_Head.M2", -- [1654]
			"Mage_Timewarp_Precast_01.M2", -- [1655]
			"MagicBurst_Impact.M2", -- [1656]
			"MagicNet_Missile.m2", -- [1657]
			"MagicNet_State.M2", -- [1658]
			"MagicStoneHelmet_Green.m2", -- [1659]
			"MagicStoneHelmet_Red.m2", -- [1660]
			"MagicUnlock.M2", -- [1661]
			"Magic_Cast_Hand.M2", -- [1662]
			"Magic_Impact_Chest.M2", -- [1663]
			"Magic_PreCast_Hand.M2", -- [1664]
			"MagtheradonCeilingChunk.M2", -- [1665]
			"Maim_Impact_Chest.M2", -- [1666]
			"Malkorok_ArcingSmash_Impact_Base.M2", -- [1667]
			"Malkorok_ArcingSmash_Impact_Base_02.M2", -- [1668]
			"Malkorok_ArcingSmash_Precast_Base.M2", -- [1669]
			"Malkorok_ArcingSmash_Precast_Base_02.M2", -- [1670]
			"Malkorok_SeismicSlam_Impact_Base.M2", -- [1671]
			"Malkorok_SeismicSlam_Impact_Base_02.M2", -- [1672]
			"Mame_Impact.m2", -- [1673]
			"ManaBurn_Chest.m2", -- [1674]
			"ManaFunnel_Impact_Chest.M2", -- [1675]
			"ManaInfuse_Base.m2", -- [1676]
			"ManaShield_State_Base.M2", -- [1677]
			"ManaShield_State_Chest.M2", -- [1678]
			"ManaShot_Missile.M2", -- [1679]
			"ManaTideInfuse_Base.m2", -- [1680]
			"Mana_ImpactDot_Chest.m2", -- [1681]
			"Manchu_WildSmash_Cast.M2", -- [1682]
			"Manchu_WildSmash_Precast.M2", -- [1683]
			"Mangle_Impact.m2", -- [1684]
			"Mangle_Impact_Demon.m2", -- [1685]
			"Mantid_2wings.M2", -- [1686]
			"Mantid_4wings.M2", -- [1687]
			"Mantid_Bomb_Missile_Amber.M2", -- [1688]
			"Mantid_Bomb_Missile_Blue.M2", -- [1689]
			"Mantid_Bomb_Missile_Green.M2", -- [1690]
			"Mantid_Bomb_Missile_Purple.M2", -- [1691]
			"Mantid_Bomb_Missile_Red.M2", -- [1692]
			"Mantid_GaralonBoss_Amber_Cloud_V2.M2", -- [1693]
			"Mantid_GaralonBoss_Cloud_Amber.M2", -- [1694]
			"Mantid_GaralonBoss_Precast.M2", -- [1695]
			"Mantid_WingsDL.M2", -- [1696]
			"Mantid_WingsDL_Blue.M2", -- [1697]
			"Mantid_WingsDL_Brown.M2", -- [1698]
			"Mantid_WingsDL_Red.M2", -- [1699]
			"Mantid_WingsDR.M2", -- [1700]
			"Mantid_WingsDR_Blue.M2", -- [1701]
			"Mantid_WingsDR_Brown.M2", -- [1702]
			"Mantid_WingsDR_Red.M2", -- [1703]
			"Mantid_WingsUL.M2", -- [1704]
			"Mantid_WingsUL_Blue.M2", -- [1705]
			"Mantid_WingsUL_Brown.M2", -- [1706]
			"Mantid_WingsUL_Red.M2", -- [1707]
			"Mantid_WingsUR.M2", -- [1708]
			"Mantid_WingsUR_Blue.M2", -- [1709]
			"Mantid_WingsUR_Brown.M2", -- [1710]
			"Mantid_WingsUR_Red.M2", -- [1711]
			"Mantid_Wings_DL_Purple.M2", -- [1712]
			"Mantid_Wings_DL_Yellow.M2", -- [1713]
			"Mantid_Wings_DR_Purple.M2", -- [1714]
			"Mantid_Wings_DR_Yellow.M2", -- [1715]
			"Mantid_Wings_UL_purple.M2", -- [1716]
			"Mantid_Wings_UL_yellow.M2", -- [1717]
			"Mantid_Wings_UR_Purple.M2", -- [1718]
			"Mantid_Wings_UR_Yellow.M2", -- [1719]
			"MarkofBeast_Impact_Head.M2", -- [1720]
			"MarkofWild_Impact_Head.M2", -- [1721]
			"Mass_Dispell_Impact.M2", -- [1722]
			"MastersCall_Impact.M2", -- [1723]
			"Maul.m2", -- [1724]
			"MaulCasterBase.m2", -- [1725]
			"MaulCasterBase_Blue.M2", -- [1726]
			"MaulCasterBase_Green.M2", -- [1727]
			"MaulCasterBase_Orange.M2", -- [1728]
			"MaulCasterBase_Purple.M2", -- [1729]
			"MaulImpact.m2", -- [1730]
			"MaulImpact_Green.M2", -- [1731]
			"Metamorphosis.M2", -- [1732]
			"Meteor_Ball_Missile.m2", -- [1733]
			"Meteor_Ball_Shadow_Missile.M2", -- [1734]
			"Meteor_Bones_Shadow_Missile.M2", -- [1735]
			"Meteor_Impact_Base.m2", -- [1736]
			"Meteor_Impact_Base_Red.M2", -- [1737]
			"MightAura_Impact_Base.M2", -- [1738]
			"MightAura_Impact_Base_NoDecay.M2", -- [1739]
			"MindBlast_Head.m2", -- [1740]
			"MindRot_Head.M2", -- [1741]
			"MiningPick_SpellObject.m2", -- [1742]
			"MirrorImage_Impact.m2", -- [1743]
			"Misdirection_Impact_Head.m2", -- [1744]
			"Missile_Axe_1HOutlandRaidD06.m2", -- [1745]
			"Missile_Axe_Copper.m2", -- [1746]
			"Missile_Bomb.m2", -- [1747]
			"Missile_Bomb_Static.m2", -- [1748]
			"Missile_Boomerang.M2", -- [1749]
			"Missile_Corrupted_01.M2", -- [1750]
			"Missile_Dark.m2", -- [1751]
			"Missile_Energy_Red_01.M2", -- [1752]
			"Missile_Flare.m2", -- [1753]
			"Missile_Hammer.m2", -- [1754]
			"Missile_LeatherBall.m2", -- [1755]
			"Missile_Light.m2", -- [1756]
			"Missile_SawBlade.M2", -- [1757]
			"Missile_Sha_02.M2", -- [1758]
			"Missile_Snowball.M2", -- [1759]
			"Missile_Template_01.M2", -- [1760]
			"Missile_Template_02.M2", -- [1761]
			"Missile_Thorns.m2", -- [1762]
			"Missile_Water_Sha_Slime.M2", -- [1763]
			"Missile_Water_Slime.M2", -- [1764]
			"Missile_Wave_Arcane.m2", -- [1765]
			"Missile_Wave_Fire.m2", -- [1766]
			"Missile_Wave_Fire_Jade.M2", -- [1767]
			"Missile_Wave_Holy.M2", -- [1768]
			"Missile_Wave_Ice.m2", -- [1769]
			"Missile_Wave_Ice_Geo.M2", -- [1770]
			"Missile_Wave_Nature.m2", -- [1771]
			"Missile_Wave_Shadow.M2", -- [1772]
			"Missile_Wave_Stone.M2", -- [1773]
			"Missile_Wave_Stone_Durotar.M2", -- [1774]
			"Missile_Wave_Stone_Durotar_Geo.M2", -- [1775]
			"Missile_Wave_Stone_Geo.M2", -- [1776]
			"Missile_Wave_Stone_Ogre_Geo.m2", -- [1777]
			"Missile_Wave_WatePurple.m2", -- [1778]
			"Missile_Wave_Water.M2", -- [1779]
			"Missile_Wave_WaterGreen.m2", -- [1780]
			"Missile_Wrench.m2", -- [1781]
			"Missle_Rocket.M2", -- [1782]
			"Missle_Rocket_OFF.m2", -- [1783]
			"Missle_rocket02.M2", -- [1784]
			"Mogu_DirectionalShield_State_Base.M2", -- [1785]
			"Mogu_Raid_BossElegon_MagicWall.M2", -- [1786]
			"Mogu_Raid_EmpyrealFocus_01.M2", -- [1787]
			"Mogu_Titan_EnergyConduit_BossElegon.M2", -- [1788]
			"MohawkExplosion.M2", -- [1789]
			"MoltenBlast_Impact_Chest.m2", -- [1790]
			"MoltenBlast_Missile.M2", -- [1791]
			"MoltenBlast_Missile_Lvl2.M2", -- [1792]
			"MoltenBlast_Missile_Lvl3.M2", -- [1793]
			"Molten_Armor_Head.m2", -- [1794]
			"Monk_AvertHarm_Impact_Base.M2", -- [1795]
			"Monk_AvertHarm_State_Base.M2", -- [1796]
			"Monk_BlackoutKick_State.M2", -- [1797]
			"Monk_BreathofFire_State_Breath.M2", -- [1798]
			"Monk_ChargeTrail.M2", -- [1799]
			"Monk_ChargingOxWave_Impact.M2", -- [1800]
			"Monk_ChargingOxWave_Missile.M2", -- [1801]
			"Monk_ChiBlast_Impact.M2", -- [1802]
			"Monk_ChiBlast_Impact_Jade.M2", -- [1803]
			"Monk_ChiBlast_Missile.M2", -- [1804]
			"Monk_ChiBlast_Missile_Jade.M2", -- [1805]
			"Monk_ChiBlast_Precast.M2", -- [1806]
			"Monk_ChiBlast_Precast_Jade.M2", -- [1807]
			"Monk_ChiCocoon_State.M2", -- [1808]
			"Monk_ChiCocoon_State_Hostile.M2", -- [1809]
			"Monk_ChiWave_Impact.M2", -- [1810]
			"Monk_ChiWave_Missile.M2", -- [1811]
			"Monk_ClashingOxCharge_Impact_Base.M2", -- [1812]
			"Monk_ClashingOxCharge_State_Base.M2", -- [1813]
			"Monk_Convergence_State.M2", -- [1814]
			"Monk_CracklingLightning_Impact.M2", -- [1815]
			"Monk_CracklingLightning_Impact_Blue.M2", -- [1816]
			"Monk_CracklingLightning_Precast.M2", -- [1817]
			"Monk_CracklingLightning_Precast_Blue.M2", -- [1818]
			"Monk_CracklingLightning_State_Base.M2", -- [1819]
			"Monk_CracklingLightning_State_Base_Blue.M2", -- [1820]
			"Monk_CraneKick_Impact.M2", -- [1821]
			"Monk_Cranekick_State.M2", -- [1822]
			"Monk_DampenHarm_State_Base.M2", -- [1823]
			"Monk_DiffuseMagic_State_Base.M2", -- [1824]
			"Monk_DrunkenHaze_AE_Impact.M2", -- [1825]
			"Monk_DrunkenHaze_Base.M2", -- [1826]
			"Monk_DrunkenHaze_Impact.M2", -- [1827]
			"Monk_DrunkenHaze_Missile.M2", -- [1828]
			"Monk_ExpelHarm_Impact_Chest.M2", -- [1829]
			"Monk_ExpelHarm_Missile.M2", -- [1830]
			"Monk_ExplodingBlossom_Impact.M2", -- [1831]
			"Monk_ExplodingBlossom_Missile.M2", -- [1832]
			"Monk_ExplodingBlossom_World.M2", -- [1833]
			"Monk_ExplodingBlossom_World_Hostile.M2", -- [1834]
			"Monk_FistsofFury_Impact.M2", -- [1835]
			"Monk_FistsofFury_State_Hands.M2", -- [1836]
			"Monk_FlyingDragonKick_Base.M2", -- [1837]
			"Monk_FlyingDragonKick_ImpactBase.M2", -- [1838]
			"Monk_ForceSpere_Orb.M2", -- [1839]
			"Monk_ForceSphere_Impact_Chest.M2", -- [1840]
			"Monk_Generic_Impact.M2", -- [1841]
			"Monk_GrappleWeapon_Missile.M2", -- [1842]
			"Monk_Guard_Impact_Base.M2", -- [1843]
			"Monk_Guard_State_Base.M2", -- [1844]
			"Monk_Heal_Base_Low.M2", -- [1845]
			"Monk_Heal_Chest_Low.M2", -- [1846]
			"Monk_HealthGlobe_BlackHole.M2", -- [1847]
			"Monk_HealthGlobe_Dark.M2", -- [1848]
			"Monk_HealthGlobe_Hostile.M2", -- [1849]
			"Monk_HealthGlobe_Jade.M2", -- [1850]
			"Monk_HealthGlobe_JadeGold.M2", -- [1851]
			"Monk_HealthGlobe_Light.M2", -- [1852]
			"Monk_HealthGlobe_OrangeGold.M2", -- [1853]
			"Monk_HealthGlobe_OrangeGold_NearZ.M2", -- [1854]
			"Monk_HundredHandSlap.M2", -- [1855]
			"Monk_HundredHandSlap_BeF.M2", -- [1856]
			"Monk_HundredHandSlap_BeM.M2", -- [1857]
			"Monk_HundredHandSlap_DrF.M2", -- [1858]
			"Monk_HundredHandSlap_DrM.M2", -- [1859]
			"Monk_HundredHandSlap_DwF.M2", -- [1860]
			"Monk_HundredHandSlap_DwM.M2", -- [1861]
			"Monk_HundredHandSlap_GoF.M2", -- [1862]
			"Monk_HundredHandSlap_GoM.M2", -- [1863]
			"Monk_HundredHandSlap_HuF.M2", -- [1864]
			"Monk_HundredHandSlap_HuM.M2", -- [1865]
			"Monk_HundredHandSlap_NiF.M2", -- [1866]
			"Monk_HundredHandSlap_NiM.M2", -- [1867]
			"Monk_HundredHandSlap_OrF.M2", -- [1868]
			"Monk_HundredHandSlap_OrM.M2", -- [1869]
			"Monk_HundredHandSlap_PaF.M2", -- [1870]
			"Monk_HundredHandSlap_PaM.M2", -- [1871]
			"Monk_HundredHandSlap_ScF.M2", -- [1872]
			"Monk_HundredHandSlap_ScM.M2", -- [1873]
			"Monk_HundredHandSlap_TaF.M2", -- [1874]
			"Monk_HundredHandSlap_TaM.M2", -- [1875]
			"Monk_HundredHandSlap_TrF.M2", -- [1876]
			"Monk_HundredHandSlap_TrM.M2", -- [1877]
			"Monk_HundredHandSlap_WoF.M2", -- [1878]
			"Monk_HundredHandSlap_WoM.M2", -- [1879]
			"Monk_HurricaneStrikeTeleport_Impact_Chest.m2", -- [1880]
			"Monk_HurricaneStrike_Missile.m2", -- [1881]
			"Monk_InvokeXuen_Impact_Base.M2", -- [1882]
			"Monk_Jade_Precast.M2", -- [1883]
			"Monk_Jade_Precast_Left_Low.M2", -- [1884]
			"Monk_Jade_Precast_Right_Low.M2", -- [1885]
			"Monk_Jade_Precast_Uber_Left.M2", -- [1886]
			"Monk_Jade_Precast_Uber_Right.M2", -- [1887]
			"Monk_KegSmash_Impact.M2", -- [1888]
			"Monk_LegSweep_Impact.m2", -- [1889]
			"Monk_Legacy_Impact.M2", -- [1890]
			"Monk_Mist_Precast.M2", -- [1891]
			"Monk_Mist_Precast_Left_Low.M2", -- [1892]
			"Monk_Mist_Precast_Right_Low.M2", -- [1893]
			"Monk_Mist_Precast_Uber_Left.M2", -- [1894]
			"Monk_Mist_Precast_Uber_Right.M2", -- [1895]
			"Monk_NimbleBrew_State_Base.M2", -- [1896]
			"Monk_OxStatue_State_Base.M2", -- [1897]
			"Monk_Paralysis_State_Base.M2", -- [1898]
			"Monk_Precast_Low.m2", -- [1899]
			"Monk_Pride_Impact.M2", -- [1900]
			"Monk_QiTorpedo_State.M2", -- [1901]
			"Monk_RingOfPeace_State_Base.M2", -- [1902]
			"Monk_RingOfPeace_State_Hostile_Base.M2", -- [1903]
			"Monk_RisingSunKick_Impact_Base.M2", -- [1904]
			"Monk_RisingSunKick_Impact_Base_Orange.M2", -- [1905]
			"Monk_Roll_Base.M2", -- [1906]
			"Monk_RushingJadeWind_Grey.M2", -- [1907]
			"Monk_RushingJadeWind_Missile.M2", -- [1908]
			"Monk_RushingJadeWind_Missile_Short.M2", -- [1909]
			"Monk_SerpentStatue_State_Base.M2", -- [1910]
			"Monk_SoothingMist_Impact.M2", -- [1911]
			"Monk_SoothingMist_Missile.M2", -- [1912]
			"Monk_Sparring_Impact_Base.M2", -- [1913]
			"Monk_SurgingMists_Impact.M2", -- [1914]
			"Monk_TigerKick_Impact.M2", -- [1915]
			"Monk_TigerLust_Impact_Base.M2", -- [1916]
			"Monk_TigerPalm_Base.M2", -- [1917]
			"Monk_TigerPalm_Impact.M2", -- [1918]
			"Monk_TigerPalm_Impact_Old.M2", -- [1919]
			"Monk_TigersLust_State_Base.M2", -- [1920]
			"Monk_TouchofDeath_Impact.M2", -- [1921]
			"Monk_TouchofKarma_Impact.M2", -- [1922]
			"Monk_TouchofKarma_State_Base.M2", -- [1923]
			"Monk_TranscendenceSpirit_Impact_Base.M2", -- [1924]
			"Monk_TranscendenceTeleport_Impact_Base.M2", -- [1925]
			"Monk_TravelingMist_Impact.M2", -- [1926]
			"Monk_TravelingMist_Missile.M2", -- [1927]
			"Monk_TravelingMist_State.M2", -- [1928]
			"Monk_TravelingMist_State_desat.M2", -- [1929]
			"Monk_Uplift_Impact_Base.M2", -- [1930]
			"MoonBeamBlue_Impact_Base.M2", -- [1931]
			"MoonBeamRed_Impact_Base.M2", -- [1932]
			"MoonBeam_Impact_Base.M2", -- [1933]
			"MoonBeam_Impact_Base_Beams.m2", -- [1934]
			"Moon_State_01.M2", -- [1935]
			"Moonfire_Impact_Base.M2", -- [1936]
			"MountMorph_Impact.m2", -- [1937]
			"MovementImmunity_Base.m2", -- [1938]
			"Mug_Missile.m2", -- [1939]
			"Mug_Missile_HitBounce.m2", -- [1940]
			"MultiShot_Impact.M2", -- [1941]
			"MultiShot_Missile.M2", -- [1942]
			"Murder_Spree_Impact.m2", -- [1943]
			"Mutilate_Impact_Chest.M2", -- [1944]
			"NUKE.M2", -- [1945]
			"NagaLordShell_Impact.m2", -- [1946]
			"NagaLordShell_Missile.m2", -- [1947]
			"NatureBeam_Neutral_State_Base.M2", -- [1948]
			"NatureBeam_State_Base.M2", -- [1949]
			"NatureReflect_State_Chest.M2", -- [1950]
			"NatureResistance_Impact_Base.m2", -- [1951]
			"NatureWard_Impact_Chest.M2", -- [1952]
			"NatureZone.m2", -- [1953]
			"Nature_Cast_Hand.m2", -- [1954]
			"Nature_Cast_Hand_Blue.M2", -- [1955]
			"Nature_Cast_Hand_Purple.m2", -- [1956]
			"Nature_DustCloud_State_Dense.m2", -- [1957]
			"Nature_Form_Precast.M2", -- [1958]
			"Nature_PreCast_Low_Hand.M2", -- [1959]
			"Nature_Precast_Chest.M2", -- [1960]
			"Nature_Rune_Impact_Base.M2", -- [1961]
			"Nature_Rune_Shield_Impact_Base.M2", -- [1962]
			"NaxxramasStrike_ImpactDD_Med_Base.M2", -- [1963]
			"Nazgrim_Execute_Base_Impact.M2", -- [1964]
			"NefarianFlameBreath.m2", -- [1965]
			"NefarianFlameBreath_Impact.m2", -- [1966]
			"NefarianFlameBreath_V2.M2", -- [1967]
			"Nefarian_Impact_Base.m2", -- [1968]
			"Nefarian_State_Base.m2", -- [1969]
			"Nefarian_State_FX.M2", -- [1970]
			"Neptulon_Immerge_FX.M2", -- [1971]
			"Neptulon_Submerge_FX.M2", -- [1972]
			"Net_Missile.m2", -- [1973]
			"Net_State.m2", -- [1974]
			"NeutralCTFflag_spell.M2", -- [1975]
			"New_Windfury.m2", -- [1976]
			"Nexus_Raid_Floating_platform_BeamFX.M2", -- [1977]
			"Nexus_Raid_Floating_platform_FX.m2", -- [1978]
			"Nightbane_Area_Base.M2", -- [1979]
			"Nightbane_Bone_Missile.M2", -- [1980]
			"Nightbane_Bone_Spurs.M2", -- [1981]
			"Nightbane_Breath.m2", -- [1982]
			"Nightbane_Fire_Missile.M2", -- [1983]
			"Nightmare_Impact_Base.M2", -- [1984]
			"NoName_Area.M2", -- [1985]
			"Norushen_Light_Containment.M2", -- [1986]
			"Nova_Arcane_Pink.m2", -- [1987]
			"Nova_Corrupted_01.M2", -- [1988]
			"Nova_Fire_Raid_Low.M2", -- [1989]
			"Nova_Fire_Raid_Yellow_Low.M2", -- [1990]
			"Nova_Sha_01.M2", -- [1991]
			"Nova_Sha_02.M2", -- [1992]
			"Nova_Template_01.M2", -- [1993]
			"Nova_sha_pride01.M2", -- [1994]
			"NullifyDisease_Base.m2", -- [1995]
			"NullifyPoison_Base.M2", -- [1996]
			"OGRaid_Falling_Dust_Lg.M2", -- [1997]
			"OGRaid_Falling_Dust_Med.M2", -- [1998]
			"OGRaid_Falling_Dust_Sm.M2", -- [1999]
			"OGRaid_ShaRing_01.M2", -- [2000]
			"Ograid_MantidPotion_Blue.M2", -- [2001]
			"Ograid_MantidPotion_Blue_Impact.M2", -- [2002]
			"Ograid_MantidPotion_Green.M2", -- [2003]
			"Ograid_MantidPotion_Green_Impact.M2", -- [2004]
			"Ograid_MantidPotion_Orange.M2", -- [2005]
			"Ograid_MantidPotion_Orange_Impact.M2", -- [2006]
			"Ograid_MantidPotion_Purple.M2", -- [2007]
			"Ograid_MantidPotion_Purple_Impact.M2", -- [2008]
			"Ograid_MantidPotion_Red.M2", -- [2009]
			"Ograid_MantidPotion_Red_Impact.M2", -- [2010]
			"Ograid_MantidPotion_White.M2", -- [2011]
			"Ograid_MantidPotion_White_Impact.M2", -- [2012]
			"Ograid_MantidPotion_Yellow.M2", -- [2013]
			"Ograid_MantidPotion_Yellow_Impact.M2", -- [2014]
			"Ograid_PoisonReactions_Orange.M2", -- [2015]
			"Ograid_PoisonReactions_Purple.M2", -- [2016]
			"Ogre_Bloodsplat_Impact_World.m2", -- [2017]
			"Ogre_GemBoulder_Missile.M2", -- [2018]
			"Ogre_GemDust_Missile.m2", -- [2019]
			"Ogre_GemDust_Weapon_State.m2", -- [2020]
			"Ogre_StoneShield_State_Base.m2", -- [2021]
			"Ogre_WarHorn_Impact_Base.m2", -- [2022]
			"OilLiquidBreath.m2", -- [2023]
			"Oil_In_Water_State.M2", -- [2024]
			"Onyxia_Impact_Base.m2", -- [2025]
			"OrangeRadiationFog.m2", -- [2026]
			"Orange_Explosion.M2", -- [2027]
			"Orange_Gas_01.m2", -- [2028]
			"Orange_Gas_Plague_Cloud_L1.m2", -- [2029]
			"Orange_Gas_Plague_Cloud_L1_B.m2", -- [2030]
			"Orange_Gas_Plague_Cloud_L2.m2", -- [2031]
			"Orange_Gas_Plague_Cloud_L2_B.m2", -- [2032]
			"Orange_Gas_Plague_Cloud_L3.m2", -- [2033]
			"Orange_Gas_Plague_Cloud_L3_B.m2", -- [2034]
			"Orange_SlimeLesserNoExplode.M2", -- [2035]
			"Orange_SlimeLesser_Missile.M2", -- [2036]
			"Orange_blood_geyser.M2", -- [2037]
			"Oregorger_UnstableBlackrockOre01.m2", -- [2038]
			"OrgrimmarArena_FireFX.m2", -- [2039]
			"PA_arrow_Spell_01.M2", -- [2040]
			"PB_Bite_Impact_01.M2", -- [2041]
			"PB_Blood_Impact.M2", -- [2042]
			"PB_DefenseBuff_Impact.M2", -- [2043]
			"PB_DefenseDebuff_Impact.M2", -- [2044]
			"PB_Feather_Impact_01.M2", -- [2045]
			"PB_Feather_Impact_02.M2", -- [2046]
			"PB_Gear_Impact.M2", -- [2047]
			"PB_Gear_Missile.M2", -- [2048]
			"PB_HealthBuff_Impact.M2", -- [2049]
			"PB_HealthDebuff_Impact.M2", -- [2050]
			"PB_LevelUp_Blue.M2", -- [2051]
			"PB_LevelUp_Green.M2", -- [2052]
			"PB_LevelUp_Purple.M2", -- [2053]
			"PB_Poof_Impact_01.M2", -- [2054]
			"PB_PowerBuff_Impact.M2", -- [2055]
			"PB_PowerDebuff_Impact.M2", -- [2056]
			"PB_Rock_Impact_01.M2", -- [2057]
			"PB_SpeedBuff_Impact.M2", -- [2058]
			"PB_SpeedDebuff_Impact.M2", -- [2059]
			"PB_Water_Impact.M2", -- [2060]
			"PRIEST_CASCADE_MISSILE_CLUTTERFALLBACK.m2", -- [2061]
			"PRIEST_CASCADE_MISSILE_ClutterFallback_Shadow.m2", -- [2062]
			"PRIEST_LIGHTWELL_V2.M2", -- [2063]
			"PRIEST_LIGHTWELL_V2_BLUE.M2", -- [2064]
			"PVP_Rune_CoolDown.M2", -- [2065]
			"PainSuppression_State.m2", -- [2066]
			"Paladin_ArdentDefender_Impact_Base.M2", -- [2067]
			"Paladin_ArdentDefender_Impact_Head.M2", -- [2068]
			"Paladin_ArmoftheLaw_Base.M2", -- [2069]
			"Paladin_ArmoftheLaw_State.M2", -- [2070]
			"Paladin_AvengerShield_Impact.M2", -- [2071]
			"Paladin_BlindingLight_AE_Impact.M2", -- [2072]
			"Paladin_BlindingLight_Impact.M2", -- [2073]
			"Paladin_BlindingLight_Precast.M2", -- [2074]
			"Paladin_Clemency_Base_Impact.M2", -- [2075]
			"Paladin_Clemency_Impact.M2", -- [2076]
			"Paladin_EternalFlame_State_Base.M2", -- [2077]
			"Paladin_ExecutionSentence_VerticleMissile.M2", -- [2078]
			"Paladin_FistofJustice_Impact.M2", -- [2079]
			"Paladin_Guardianofancientkings_Impact_01.M2", -- [2080]
			"Paladin_HammeroftheRighteous_Cast.M2", -- [2081]
			"Paladin_Headlinghands_State_01.M2", -- [2082]
			"Paladin_Heal_Impact_Chest.M2", -- [2083]
			"Paladin_Heal_Impact_Head.M2", -- [2084]
			"Paladin_HolyPrism_Impact_Chest.M2", -- [2085]
			"Paladin_Holyshield_Missile.m2", -- [2086]
			"Paladin_Inquisition_Impact_01.M2", -- [2087]
			"Paladin_Lightofdawn_Coneimpact_01.M2", -- [2088]
			"Paladin_Lightofdawn_Impact_01.M2", -- [2089]
			"Paladin_LightsHammer_Impact.M2", -- [2090]
			"Paladin_LightsHammer_Missile.M2", -- [2091]
			"Paladin_LightsHammer_State.M2", -- [2092]
			"Paladin_Seraphim_Mace.m2", -- [2093]
			"Paladin_Seraphim_Shield.m2", -- [2094]
			"Paladin_SpeedofLight_State.M2", -- [2095]
			"Paladin_TemplarsVerdict_Impact_01.M2", -- [2096]
			"Paladin_UberHeal_Impact_Chest.M2", -- [2097]
			"Paladin_Veneration_Impact.M2", -- [2098]
			"PandaBowHelmet.M2", -- [2099]
			"Parachute.m2", -- [2100]
			"Parachute_Wings_Head.m2", -- [2101]
			"Paragon_Iyyokuk_Rune_State_Base.M2", -- [2102]
			"Paragon_Weaponslash_Impact_Base.M2", -- [2103]
			"Paragons_Hisek_Sonic_Missile_01.M2", -- [2104]
			"Paragons_KaRoz_Trail_Base.M2", -- [2105]
			"Pathfind_Cast_Head.M2", -- [2106]
			"Pestilence_Impact_Chest.M2", -- [2107]
			"PiercingHowl_Impact_Head.m2", -- [2108]
			"PiercingStrike.m2", -- [2109]
			"PiercingStrike_Cast_Hand.M2", -- [2110]
			"Plague_Gas_Blue_01.m2", -- [2111]
			"Plague_Gas_Orange_02.m2", -- [2112]
			"Podling_Impact_AreaSplash_orange.m2", -- [2113]
			"PoisonElemental_Impact_Base.m2", -- [2114]
			"PoisonElemental_Orange_Impact_Base.M2", -- [2115]
			"PoisonShield_State_Base.M2", -- [2116]
			"PoisonShot_Missile.M2", -- [2117]
			"Poison_Cloud_Grobbulus.m2", -- [2118]
			"Poison_ImpactDot_Med_Base.m2", -- [2119]
			"Poison_ImpactDot_Med_Chest.m2", -- [2120]
			"Poison_ImpactDot_Orange_Med_Base.m2", -- [2121]
			"Poison_Impact_Chest.m2", -- [2122]
			"Polymorph_Impact.m2", -- [2123]
			"Polymorph_Impact_Base.m2", -- [2124]
			"Portal_JadeForest.M2", -- [2125]
			"PortalofKathune_V2.m2", -- [2126]
			"PotionA_SpellObject.m2", -- [2127]
			"PotionB_SpellObject.m2", -- [2128]
			"Potion_Black01_SpellObject.m2", -- [2129]
			"Potion_Black02_SpellObject.m2", -- [2130]
			"Potion_Black03_SpellObject.m2", -- [2131]
			"Potion_Black04_SpellObject.m2", -- [2132]
			"Potion_Black05_SpellObject.m2", -- [2133]
			"Potion_Blue01_SpellObject.m2", -- [2134]
			"Potion_Blue02_SpellObject.m2", -- [2135]
			"Potion_Gold01_SpellObject.m2", -- [2136]
			"Potion_Green01_SpellObject.m2", -- [2137]
			"Potion_Green02_SpellObject.m2", -- [2138]
			"Potion_Green03_SpellObject.m2", -- [2139]
			"Potion_Green04_SpellObject.m2", -- [2140]
			"Potion_Iron01_SpellObject.m2", -- [2141]
			"Potion_Purple01_SpellObject.m2", -- [2142]
			"Potion_Purple02_SpellObject.m2", -- [2143]
			"Potion_Purple03_SpellObject.m2", -- [2144]
			"Potion_Red01_SpellObject.m2", -- [2145]
			"Potion_Red02_SpellObject.m2", -- [2146]
			"Potion_Red03_SpellObject.m2", -- [2147]
			"Potion_Silver01_SpellObject.m2", -- [2148]
			"PrayerofHealing_Chest.m2", -- [2149]
			"PrayerofMending_Impact_Head.m2", -- [2150]
			"Precast_Corrupted_01.M2", -- [2151]
			"Precast_Template_01.M2", -- [2152]
			"PresenceOfMind_Cast_Base.M2", -- [2153]
			"Priest_AngelicBulwark_State_Base.M2", -- [2154]
			"Priest_AngelicFeather_State.M2", -- [2155]
			"Priest_AngelicFeather_State_Chest.M2", -- [2156]
			"Priest_AngelicFeather_State_Hostile.M2", -- [2157]
			"Priest_Archangel_Impact_01.M2", -- [2158]
			"Priest_Archangel_Impact_02.M2", -- [2159]
			"Priest_Bodyandsoul_01.M2", -- [2160]
			"Priest_Cascade_Impact.M2", -- [2161]
			"Priest_Cascade_Impact_Shadow.M2", -- [2162]
			"Priest_Cascade_Missile.M2", -- [2163]
			"Priest_Cascade_Missile_Shadow.M2", -- [2164]
			"Priest_Chakra_Blue.M2", -- [2165]
			"Priest_Chakra_Green.M2", -- [2166]
			"Priest_Chakra_Red.M2", -- [2167]
			"Priest_Chakra_Yellow.M2", -- [2168]
			"Priest_DevouringPlague_Impact.M2", -- [2169]
			"Priest_Dispersion.m2", -- [2170]
			"Priest_DivineAegis.M2", -- [2171]
			"Priest_DivineHymn.m2", -- [2172]
			"Priest_DivineStar_Impact_Shadow.M2", -- [2173]
			"Priest_DivineStar_Impact_Yellow.M2", -- [2174]
			"Priest_DivineStar_Missile_Shadow.M2", -- [2175]
			"Priest_DivineStar_Missile_Yellow.M2", -- [2176]
			"Priest_DivineStar_Precast_Shadow.M2", -- [2177]
			"Priest_DivineStar_Precast_Yellow.M2", -- [2178]
			"Priest_GuardianSpirit.m2", -- [2179]
			"Priest_Halo_Missile.M2", -- [2180]
			"Priest_Halo_Missile_Shadow.M2", -- [2181]
			"Priest_Inner_Will_01.M2", -- [2182]
			"Priest_LeapofFate_Impact_01.M2", -- [2183]
			"Priest_LeapofFate_Impact_02.M2", -- [2184]
			"Priest_Leapoffaith_Target_Purple.M2", -- [2185]
			"Priest_Leapoffaith_Target_Red.M2", -- [2186]
			"Priest_Leapoffaith_Target_Yellow.M2", -- [2187]
			"Priest_MindShear.m2", -- [2188]
			"Priest_Mind_Spike_01.M2", -- [2189]
			"Priest_PathoftheDevout_State_Base.M2", -- [2190]
			"Priest_Pennance_Missile.m2", -- [2191]
			"Priest_Phantasm_Base_State.M2", -- [2192]
			"Priest_PowerInfusion.M2", -- [2193]
			"Priest_PowerWardBarrier.M2", -- [2194]
			"Priest_PowerWardBarrierHostile.M2", -- [2195]
			"Priest_Psyfiend.M2", -- [2196]
			"Priest_Psyfiend_Impact.M2", -- [2197]
			"Priest_Psyfiend_State_Base.M2", -- [2198]
			"Priest_Sanctuary_Persistent.M2", -- [2199]
			"Priest_Sanctuary_PersistentV2.m2", -- [2200]
			"Priest_Shadoworbs_01.M2", -- [2201]
			"Priest_Shadowyapparition_01.M2", -- [2202]
			"Priest_Shadowyapparition_Missile_Dwarf.M2", -- [2203]
			"Priest_Shadowyapparition_Missile_Gnome.M2", -- [2204]
			"Priest_Shadowyapparition_Missile_Human.M2", -- [2205]
			"Priest_Shadowyapparition_Missile_HumanFemale.M2", -- [2206]
			"Priest_Shadowyapparition_Missile_Troll.M2", -- [2207]
			"Priest_Shadowyapparition_precast.M2", -- [2208]
			"Priest_SurgeofDarkness_Base.M2", -- [2209]
			"Priest_Surgeoflight_Base.M2", -- [2210]
			"Priest_VoidShift_Missile.M2", -- [2211]
			"Priest_VoidShift_State_Chest.M2", -- [2212]
			"Priest_VoidTendril_Base_State.M2", -- [2213]
			"Priest_VoidTendril_Base_State_v2.M2", -- [2214]
			"ProtectionFromFire_Chest.M2", -- [2215]
			"ProtectionFromNature_Chest.M2", -- [2216]
			"ProvingGrounds_Coalesce_Impact_Blue.M2", -- [2217]
			"ProvingGrounds_Coalesce_Impact_Cyan.M2", -- [2218]
			"ProvingGrounds_Coalesce_Impact_Green.M2", -- [2219]
			"ProvingGrounds_Coalesce_Impact_Jade.M2", -- [2220]
			"ProvingGrounds_Coalesce_Impact_Orange.M2", -- [2221]
			"ProvingGrounds_Coalesce_Impact_Purple.M2", -- [2222]
			"ProvingGrounds_Coalesce_Impact_Red.M2", -- [2223]
			"ProvingGrounds_Coalesce_Impact_Yellow.M2", -- [2224]
			"PuffyMesh_01.M2", -- [2225]
			"Purge_Impact_Chest.m2", -- [2226]
			"Purge_New_Impact_Chest.m2", -- [2227]
			"Purify_Base.m2", -- [2228]
			"PurpleGhost_state.m2", -- [2229]
			"PvP_Trinket_Alliance_Impact.M2", -- [2230]
			"PvP_Trinket_Alliance_Impact_Billboarded.M2", -- [2231]
			"PvP_Trinket_Hord_Impact.M2", -- [2232]
			"PvP_Trinket_Hord_Impact_Billboarded.M2", -- [2233]
			"PyroBlast_Blue_Missile.M2", -- [2234]
			"PyroBlast_Missile.M2", -- [2235]
			"PyroBlast_Missile_Sha.M2", -- [2236]
			"Quiver_Horde_A_01_Spell.M2", -- [2237]
			"RAINOFFIRE_MISSILE_ILLIDARI.M2", -- [2238]
			"RAINOFFIRE_MISSILE_TWILIGHT.M2", -- [2239]
			"RShoulder_Mail_RaidShaman_H_01SPELL.M2", -- [2240]
			"RShoulder_Mail_RaidShaman_H_02SPELL_Green.M2", -- [2241]
			"RShoulder_Mail_RaidShaman_H_02SPELL_Red.M2", -- [2242]
			"RShoulder_Robe_Plague_A_01_spell.M2", -- [2243]
			"RShoulder_Robe_Plague_A_01_spell_Green.m2", -- [2244]
			"RShoulder_Robe_Plague_A_01_spell_Purple.m2", -- [2245]
			"Racial_Bloodelf_impact_base.M2", -- [2246]
			"Racial_Draenei_Impact_Base.M2", -- [2247]
			"Racial_Dwarf_Impact_Base.M2", -- [2248]
			"Racial_Gnome_Impact_Base.M2", -- [2249]
			"Racial_Goblin_impact_base.M2", -- [2250]
			"Racial_NightElf_Impact_Base.M2", -- [2251]
			"Racial_Orc_impact_base.M2", -- [2252]
			"Racial_Tauren_impact_base.M2", -- [2253]
			"Racial_Troll_impact_base.M2", -- [2254]
			"Racial_Undead_impact_base.M2", -- [2255]
			"Racial_Worgen_Impact_Base.M2", -- [2256]
			"Radial_Wind_Gust.M2", -- [2257]
			"Radiance_SonicRipple_Hold.M2", -- [2258]
			"Radiance_SonicRipple_Impact.M2", -- [2259]
			"Rag_FireNova_Area.M2", -- [2260]
			"Raid_UI_FX_Cyan.M2", -- [2261]
			"Raid_UI_FX_Green.M2", -- [2262]
			"Raid_UI_FX_Purple.M2", -- [2263]
			"Raid_UI_FX_Red.M2", -- [2264]
			"Raid_UI_FX_Yellow.M2", -- [2265]
			"RainOfCandys_Impact_Base.M2", -- [2266]
			"RainOfFire_Impact_Base.M2", -- [2267]
			"RainOfFire_Impact_Base_Sha.M2", -- [2268]
			"RainOfFire_Missile.M2", -- [2269]
			"Rake.m2", -- [2270]
			"Rampage_ Impact _Head.m2", -- [2271]
			"Rampage_State_Head.M2", -- [2272]
			"RapidFire_Base.M2", -- [2273]
			"Readiness_Impact_Chest.m2", -- [2274]
			"Recklessness_Impact_Chest.M2", -- [2275]
			"RedCTFflag_spell.M2", -- [2276]
			"RedGhost_state.m2", -- [2277]
			"RedRadiationFog.M2", -- [2278]
			"Reddustcloud.m2", -- [2279]
			"Redemption_Base.M2", -- [2280]
			"Regrowth_Impact_Base.m2", -- [2281]
			"Rejuvenation_Impact_Base.M2", -- [2282]
			"RemoveCurse_Base.M2", -- [2283]
			"Renew_Base.m2", -- [2284]
			"Renew_Chest.m2", -- [2285]
			"ReputationLevelUp.M2", -- [2286]
			"ResFX.m2", -- [2287]
			"ResistFrost_Chest.M2", -- [2288]
			"Resist_Immune_Effect.M2", -- [2289]
			"ResistanceAura_Base.m2", -- [2290]
			"Restoration_Impact_Base.M2", -- [2291]
			"Restoration_Impact_Base_Blue.M2", -- [2292]
			"Resurrection_Low_Base.m2", -- [2293]
			"Resurrection_Shafts_Unshaded.M2", -- [2294]
			"Resurrection_TerraceEndlessSpring_Boss.M2", -- [2295]
			"Retaliation_State_Chest.m2", -- [2296]
			"RetributionAuraRed_Base.M2", -- [2297]
			"RetributionAura_Base.M2", -- [2298]
			"RevivePet_Impact_Base.M2", -- [2299]
			"Rewind_Time_Impact.M2", -- [2300]
			"Rewind_Time_Impact_XPlosion.M2", -- [2301]
			"RibbonTrail.M2", -- [2302]
			"RighteousFury_Chest.M2", -- [2303]
			"RighteousnessAura_Base.M2", -- [2304]
			"Ring_Of_Smoke.m2", -- [2305]
			"Ring_Of_Smoke_Fwd.m2", -- [2306]
			"RitualSummoning_PreCast_Base.M2", -- [2307]
			"Ritual_Arcane_PreCast_Base.M2", -- [2308]
			"Ritual_Fire_PreCast_Base.M2", -- [2309]
			"Ritual_Frost_PreCast_Base.M2", -- [2310]
			"RocketBlast_Down.m2", -- [2311]
			"RocketLauncher_Cast.m2", -- [2312]
			"RocketLauncher_PreCast.M2", -- [2313]
			"Rocketblast.m2", -- [2314]
			"RockyFrost_Nova_state.M2", -- [2315]
			"Rogue_Combatreadiness_01.M2", -- [2316]
			"Rogue_CrimsonTempest.M2", -- [2317]
			"Rogue_Recuperate_01.M2", -- [2318]
			"Rogue_Redirect_01.M2", -- [2319]
			"Rogue_ShadowWalk_State_Base.M2", -- [2320]
			"Rogue_ShroudofConcealment_State_Base.M2", -- [2321]
			"Rogue_ShurikenToss_Missile.M2", -- [2322]
			"Rogue_Smokebomb_01.M2", -- [2323]
			"Rogue_Smokebomb_01Hostile.M2", -- [2324]
			"Rogue_Trick_of_the_Trade_Impact.m2", -- [2325]
			"Rogue_Trick_of_the_Trade_State.m2", -- [2326]
			"Rogue_Vendetta_01.M2", -- [2327]
			"RomanCandle_A_01.m2", -- [2328]
			"Rune_Shadow_01.M2", -- [2329]
			"Rune_Shadow_02.M2", -- [2330]
			"Rune_Shadow_03.M2", -- [2331]
			"Rune_Shadowmoon_State_02.m2", -- [2332]
			"SC_CTFflag_spell.m2", -- [2333]
			"SHA_ZONE_02.M2", -- [2334]
			"SKULLMARK_RED.m2", -- [2335]
			"SKYREACH_FIREWALL_DOOR.M2", -- [2336]
			"SMO_sacrificialDagger_Missile.M2", -- [2337]
			"SOLAR_Missile_Stormcrow.m2", -- [2338]
			"SPELL_2H_OutlandRaidShield.M2", -- [2339]
			"SPELL_HoppingGhost.M2", -- [2340]
			"Saberlash_Impact.M2", -- [2341]
			"Sacred_Cleansing_Impact.m2", -- [2342]
			"SandVortex_State_Base.m2", -- [2343]
			"SandWorm_AttackEffects.m2", -- [2344]
			"Sand_Cast_Hand.M2", -- [2345]
			"Sand_Explosion.M2", -- [2346]
			"Sand_Impact_Chest.M2", -- [2347]
			"Sand_Missile.M2", -- [2348]
			"Sand_Precast_Hand.M2", -- [2349]
			"Sand_Zone.M2", -- [2350]
			"Sap_Cast_Base.M2", -- [2351]
			"Sap_Impact_Chest.M2", -- [2352]
			"Sap_State_Head.M2", -- [2353]
			"SavageBlow_Impact_Chest.m2", -- [2354]
			"Scorch_Low_Chest.m2", -- [2355]
			"ScorpidShot_Missile.M2", -- [2356]
			"ScorpidSting_Impact_Base.m2", -- [2357]
			"ScourgeFemale_Arms_FX.M2", -- [2358]
			"ScourgeMale_Arms_FX.M2", -- [2359]
			"SeaFloor_FootSteps_RUN_FX.M2", -- [2360]
			"SeaFloor_FootSteps_WALK_FX.M2", -- [2361]
			"SeaFloor_Trails_FX.M2", -- [2362]
			"SealOfFury_Impact_Base.M2", -- [2363]
			"SealOfMight_Impact_Base.M2", -- [2364]
			"SealOfProtection_Impact_Base.M2", -- [2365]
			"SealOfSacrifice_Impact_Base.M2", -- [2366]
			"SealOfSalvation_Impact_Base.M2", -- [2367]
			"SealOfWisdom_Impact_Base.M2", -- [2368]
			"SealOfWrath_Impact_Base.M2", -- [2369]
			"SealofBlood_Impact_Base.M2", -- [2370]
			"SealofCommand_Impact_Base.M2", -- [2371]
			"SealofCrusader_Impact.M2", -- [2372]
			"SealofLight_Impact_Base.M2", -- [2373]
			"SealofMight_Low_Base.M2", -- [2374]
			"SealofRighteous_Impact_Base.M2", -- [2375]
			"SealofVengeance_Impact_Base.M2", -- [2376]
			"Seduction_State_Head.M2", -- [2377]
			"SeedOfCorruption_State.m2", -- [2378]
			"SeepingGaseous_Fel_Nova.M2", -- [2379]
			"SeepingGaseous_Nova.M2", -- [2380]
			"SeepingGaseous_Nova_Amber.M2", -- [2381]
			"SeepingGaseous_Nova_Red.M2", -- [2382]
			"SeepingGaseous_Twilight_Nova.M2", -- [2383]
			"SenseDemons_Impact_Head.M2", -- [2384]
			"ShaMask01.M2", -- [2385]
			"ShaMask02.M2", -- [2386]
			"ShaMask03.M2", -- [2387]
			"ShaMask04.M2", -- [2388]
			"ShaMask05.M2", -- [2389]
			"ShaMask06.M2", -- [2390]
			"ShaOfPride_Maze_FXwrap.M2", -- [2391]
			"ShaOfPride_MindShear.M2", -- [2392]
			"Sha_Bolt_Missile_Fear_V2.M2", -- [2393]
			"Sha_Bolt_Missile_V2.M2", -- [2394]
			"Sha_Breath.M2", -- [2395]
			"Sha_Breath180.M2", -- [2396]
			"Sha_Breath_02.M2", -- [2397]
			"Sha_Breath_Fear.M2", -- [2398]
			"Sha_Breath_Fear_02.M2", -- [2399]
			"Sha_Corruption_ImpactDot_Med_Base.M2", -- [2400]
			"Sha_Corruption_ImpactDot_Med_Base_withDecay.M2", -- [2401]
			"Sha_FireBolt_Missile_Low.M2", -- [2402]
			"Sha_Fireball_Missile_High.M2", -- [2403]
			"Sha_Firebolt_Missile_Low_Fear.M2", -- [2404]
			"Sha_Fog_warm.M2", -- [2405]
			"Sha_Form_Precast.M2", -- [2406]
			"Sha_Geyser_Impact_Base.M2", -- [2407]
			"Sha_Geyser_Impact_Base_Low.M2", -- [2408]
			"Sha_ImpactDD_High_Chest.M2", -- [2409]
			"Sha_ImpactDD_High_Chest_Fear.M2", -- [2410]
			"Sha_LavaBurst.M2", -- [2411]
			"Sha_LavaBurst_Missile_NoFlash.M2", -- [2412]
			"Sha_LavaBurst_Missile_NoFlash_pride.M2", -- [2413]
			"Sha_Nova_Area_Fear.M2", -- [2414]
			"Sha_Nova_area.M2", -- [2415]
			"Sha_Precast_Uber_Hand.M2", -- [2416]
			"Sha_Precast_Uber_Hand_pride.M2", -- [2417]
			"Sha_QueensRoomFX.M2", -- [2418]
			"Sha_Ritual_PreCast_Base.M2", -- [2419]
			"Sha_Rune_State.M2", -- [2420]
			"Sha_SonicRipple_Hold.M2", -- [2421]
			"Sha_SonicRipple_Impact.M2", -- [2422]
			"Sha_State_Base_High.M2", -- [2423]
			"Sha_State_Base_Low.M2", -- [2424]
			"Sha_Vortex_01.M2", -- [2425]
			"Sha_Vortex_Wall_01.M2", -- [2426]
			"Sha_WhirlwindGeoBlack.M2", -- [2427]
			"Sha_Whirlwind_State_Base.M2", -- [2428]
			"Sha_Zone.M2", -- [2429]
			"Sha_geyser_impact_base_pride.M2", -- [2430]
			"Sha_voidzone_corrupted_radial_pride01.M2", -- [2431]
			"Sha_voidzone_corrupted_radial_pride02.M2", -- [2432]
			"ShadesofDarkness_Cast.m2", -- [2433]
			"ShadoPalm_Impact_Blue.M2", -- [2434]
			"ShadoPalm_Impact_Red.M2", -- [2435]
			"ShadoPalm_Missile_Blue.M2", -- [2436]
			"ShadoPalm_Missile_Red.M2", -- [2437]
			"ShadoPalm_PreCast_Blue.M2", -- [2438]
			"ShadoPalm_PreCast_Red.M2", -- [2439]
			"ShadowBolt_Chest_Impact.M2", -- [2440]
			"ShadowBolt_Missile.M2", -- [2441]
			"ShadowBolt_Missile_NoRibbon.M2", -- [2442]
			"ShadowDance_State.m2", -- [2443]
			"ShadowDance_V2_State.M2", -- [2444]
			"ShadowMissile.M2", -- [2445]
			"ShadowMissile_NoShadow.m2", -- [2446]
			"ShadowProtection_Chest.M2", -- [2447]
			"ShadowReflect_State_Chest.M2", -- [2448]
			"ShadowRift_State_Base.M2", -- [2449]
			"ShadowShield_Impact.M2", -- [2450]
			"ShadowShield_State_Base.M2", -- [2451]
			"ShadowSteps_FX.m2", -- [2452]
			"ShadowStrike_Impact_Chest.m2", -- [2453]
			"ShadowWard_Impact_Chest.M2", -- [2454]
			"ShadowWordBefuddle_Head.M2", -- [2455]
			"ShadowWordDominate_Chest.M2", -- [2456]
			"ShadowWordFumble_Head.M2", -- [2457]
			"ShadowWordPain_Chest.m2", -- [2458]
			"ShadowWordSilence_Breath.m2", -- [2459]
			"ShadowWord_Death_Impact.M2", -- [2460]
			"Shadow_DotParticle.m2", -- [2461]
			"Shadow_Fissure_Base.m2", -- [2462]
			"Shadow_Fissure_BaseBlue.m2", -- [2463]
			"Shadow_Form_Precast.M2", -- [2464]
			"Shadow_Frost_Weapon_Effect.M2", -- [2465]
			"Shadow_ImpactBuff_Base.M2", -- [2466]
			"Shadow_ImpactDD_High_Chest.m2", -- [2467]
			"Shadow_ImpactDD_LowNoSkull_Chest.M2", -- [2468]
			"Shadow_ImpactDD_Low_Chest.M2", -- [2469]
			"Shadow_ImpactDD_Med_Base.M2", -- [2470]
			"Shadow_ImpactDD_Med_Chest.m2", -- [2471]
			"Shadow_ImpactDD_Uber_Chest.M2", -- [2472]
			"Shadow_ImpactDot_Med_Chest.m2", -- [2473]
			"Shadow_ImpactDot_Med_Head.m2", -- [2474]
			"Shadow_Mend_Impact.m2", -- [2475]
			"Shadow_Nova_area.M2", -- [2476]
			"Shadow_Nova_area_noProjection.M2", -- [2477]
			"Shadow_Precast_High.m2", -- [2478]
			"Shadow_Precast_High_Base.m2", -- [2479]
			"Shadow_Precast_High_Hand.M2", -- [2480]
			"Shadow_Precast_Low_Hand.M2", -- [2481]
			"Shadow_Precast_Med_Base.m2", -- [2482]
			"Shadow_Precast_Med_Hand.M2", -- [2483]
			"Shadow_Precast_Uber_Base.M2", -- [2484]
			"Shadow_Precast_Uber_Hand.M2", -- [2485]
			"Shadow_Rune_Impact_Base.m2", -- [2486]
			"Shadow_Rune_Shield_Impact_Base.M2", -- [2487]
			"Shadow_Snare_High_Base.m2", -- [2488]
			"Shadow_Strikes_State_Hand.M2", -- [2489]
			"Shadow_Vol_Fog.M2", -- [2490]
			"Shadow_Vortex.M2", -- [2491]
			"Shadow_Vortex_2.M2", -- [2492]
			"Shadow_Vortex_Hole.M2", -- [2493]
			"Shadow_Vortex_Precast.M2", -- [2494]
			"Shadowflame_Cast_Hand.m2", -- [2495]
			"Shadowflame_Caster.m2", -- [2496]
			"Shadowflame_Impact.m2", -- [2497]
			"Shadowflame_State.m2", -- [2498]
			"Shadowfury_Impact_Base.M2", -- [2499]
			"Shadowmourne_Cast_High.M2", -- [2500]
			"Shadowmourne_Cast_Low.m2", -- [2501]
			"Shadowmourne_Cast_Med.M2", -- [2502]
			"Shadowmourne_Missile.M2", -- [2503]
			"Shaman_AncestralAwakening.M2", -- [2504]
			"Shaman_AncestralGuidance_State_Base.M2", -- [2505]
			"Shaman_AstralShift.m2", -- [2506]
			"Shaman_Bind_Elemental.M2", -- [2507]
			"Shaman_Cloudburst_Impact.m2", -- [2508]
			"Shaman_Earthliving_Ground.m2", -- [2509]
			"Shaman_Earthliving_Target.M2", -- [2510]
			"Shaman_Earthquake.M2", -- [2511]
			"Shaman_Earthquake_New.M2", -- [2512]
			"Shaman_Elemental_Ice_Low.M2", -- [2513]
			"Shaman_Elemental_Lava_Green_Low.M2", -- [2514]
			"Shaman_Elemental_Lava_Low.M2", -- [2515]
			"Shaman_Elemental_Precast_Low.M2", -- [2516]
			"Shaman_Frost_Missile.M2", -- [2517]
			"Shaman_Greater_Healing_Wave.M2", -- [2518]
			"Shaman_Healing_Rain.M2", -- [2519]
			"Shaman_Healing_Rain_Proj.M2", -- [2520]
			"Shaman_Healing_Tide_State_Base.M2", -- [2521]
			"Shaman_Healing_Wave.m2", -- [2522]
			"Shaman_LavaBurst.m2", -- [2523]
			"Shaman_LavaBurst_Green.m2", -- [2524]
			"Shaman_LavaBurst_Green_Missile.m2", -- [2525]
			"Shaman_LavaBurst_Green_NoStrobe.M2", -- [2526]
			"Shaman_LavaBurst_Missile.m2", -- [2527]
			"Shaman_LavaBurst_Missile_NoFlash.M2", -- [2528]
			"Shaman_Lavaburst_Missile_NoFlash_XS.M2", -- [2529]
			"Shaman_LightningBolt_Impact_V2.M2", -- [2530]
			"Shaman_LightningBolt_Impact_V2_Red.M2", -- [2531]
			"Shaman_LightningBolt_Missile_V2.M2", -- [2532]
			"Shaman_LightningBolt_Missile_V2_Red.M2", -- [2533]
			"Shaman_LightningCall.m2", -- [2534]
			"Shaman_Lightning_Precast_V2.M2", -- [2535]
			"Shaman_Lightning_Precast_V2_Red.M2", -- [2536]
			"Shaman_Measured_Insight.M2", -- [2537]
			"Shaman_Measured_Insight_green.m2", -- [2538]
			"Shaman_SpiritLink.m2", -- [2539]
			"Shaman_SpiritLink_Hostile.m2", -- [2540]
			"Shaman_SpiritLink_State_Base.M2", -- [2541]
			"Shaman_SpiritLink_State_Base_Hostile.m2", -- [2542]
			"Shaman_SpiritwalkersGrace.M2", -- [2543]
			"Shaman_Thunder.M2", -- [2544]
			"Shaman_Thunder_Hold.m2", -- [2545]
			"Shaman_Tidal_Force.m2", -- [2546]
			"Shaman_Unleashedearth_01.M2", -- [2547]
			"Shaman_Unleashedwind_01.M2", -- [2548]
			"Shaman_Unleashedwind_Missile.M2", -- [2549]
			"Shaman_Water_Precast.M2", -- [2550]
			"Shaman_Water_Precast_Sha.M2", -- [2551]
			"Shaman_WindShear.m2", -- [2552]
			"Shaman_WindWalk_State.M2", -- [2553]
			"ShamanisticRage_Cast_Hand.M2", -- [2554]
			"ShamanisticRage_State_Hand.M2", -- [2555]
			"Shattering_Glass_Explosion.M2", -- [2556]
			"Shekzeer_SonicZone_Base.M2", -- [2557]
			"Shekzeer_SonicZone_Base_Sha.M2", -- [2558]
			"ShellShield_State_Base.m2", -- [2559]
			"ShieldBash_Impact_Chest.m2", -- [2560]
			"ShieldWallWar_Impact_Base.M2", -- [2561]
			"ShieldWall_Impact_Base.M2", -- [2562]
			"ShieldWall_Impact_Base_Blue.M2", -- [2563]
			"ShieldWall_Impact_Base_Red.M2", -- [2564]
			"Shield_2H_OutlandRaid_D_07_Spell.M2", -- [2565]
			"Shield_of_Vengeance_Cast.M2", -- [2566]
			"Shield_of_Vengeance_Impact.M2", -- [2567]
			"Shock_Impact_Chest.M2", -- [2568]
			"Shock_Missile.M2", -- [2569]
			"Shout_Cast.M2", -- [2570]
			"SiegeTank_Missile.M2", -- [2571]
			"Silence_State.M2", -- [2572]
			"Single_Firefly.M2", -- [2573]
			"SinisterStrike_Base_Cast.M2", -- [2574]
			"SinisterStrike_Impact_Chest.M2", -- [2575]
			"Skull.m2", -- [2576]
			"Skull180.M2", -- [2577]
			"Skywall_Wind_DraftEffect_Center.M2", -- [2578]
			"Slam_Impact_Chest.M2", -- [2579]
			"Sleep_State_Head.M2", -- [2580]
			"SliceDice_Chest.M2", -- [2581]
			"SliceDice_Impact_Chest.m2", -- [2582]
			"SlimeLesserExplode_Missile.m2", -- [2583]
			"SlimeLesserExplode_Missile_No_Flip.m2", -- [2584]
			"SlimeLesser_Missile.m2", -- [2585]
			"Sloppy_Blood_Pool.M2", -- [2586]
			"Sloppy_Blood_Pool_NoFade.M2", -- [2587]
			"Slow_Impact_Base.m2", -- [2588]
			"SlowingStrike_Cast_Hand.m2", -- [2589]
			"SlowingStrike_Impact_Base.m2", -- [2590]
			"SlowingStrike_Impact_Chest.m2", -- [2591]
			"Smash_Impact_Chest.m2", -- [2592]
			"SmokeFlare_Blue.m2", -- [2593]
			"SmokeFlare_Green.m2", -- [2594]
			"SmokeFlare_Purple.m2", -- [2595]
			"SmokeFlare_Red.m2", -- [2596]
			"SmokeFlare_White.m2", -- [2597]
			"Smoke_Dark_Fast.M2", -- [2598]
			"Smoke_Dark_Slow.M2", -- [2599]
			"Smoke_Dark_Wide.M2", -- [2600]
			"Smoke_From_Fire_Fast.M2", -- [2601]
			"Smoke_From_Fire_Slow.M2", -- [2602]
			"Smoke_From_Fire_Wide.M2", -- [2603]
			"Smoke_Grey_Fast.M2", -- [2604]
			"Smoke_Grey_Slow.M2", -- [2605]
			"Smoke_Grey_Wide.M2", -- [2606]
			"SnakeSpin.m2", -- [2607]
			"SnakeSpin_Hold.M2", -- [2608]
			"SnowFlakeCreature_Var1.M2", -- [2609]
			"SnowFlakeCreature_Var1_Missile.m2", -- [2610]
			"SnowFlakeCreature_Var2.M2", -- [2611]
			"Snow_Tempest_State.M2", -- [2612]
			"SnowballPowdery_Impact_Base.m2", -- [2613]
			"Snowball_Impact_Chest.m2", -- [2614]
			"SoccerBall_Missile.M2", -- [2615]
			"SolarZone_char_flat.m2", -- [2616]
			"SolarZone_char_proj.M2", -- [2617]
			"Solar_Chakram_Missile.M2", -- [2618]
			"Solar_Chakram_Missile_Reverse.M2", -- [2619]
			"Solar_Explosion_Impact_Base.M2", -- [2620]
			"SonicBoom_Missile_High.M2", -- [2621]
			"SonicBoom_Missile_High_Orange.M2", -- [2622]
			"SonicWave_Cast.m2", -- [2623]
			"SonicWave_Cast_Down.m2", -- [2624]
			"SonicWave_Impact.M2", -- [2625]
			"SonicWave_Missile.m2", -- [2626]
			"SonicWave_Missile_H.M2", -- [2627]
			"SonicWave_Missile_H_x3.M2", -- [2628]
			"SonicWave_Missile_V2.M2", -- [2629]
			"SonicWave_Missile_V3.M2", -- [2630]
			"Sonic_Zone_Large.M2", -- [2631]
			"Sonic_Zone_Small.M2", -- [2632]
			"SoothingKiss_Impact_Head.M2", -- [2633]
			"SoulFunnel_Impact_Chest.M2", -- [2634]
			"SoulShatter_Cast.M2", -- [2635]
			"SoulShatter_Impact.M2", -- [2636]
			"SoulShatter_Missile.M2", -- [2637]
			"SoulShatter_MissileBlue.M2", -- [2638]
			"SoulStoneResurrection_Base.m2", -- [2639]
			"SoulStoneResurrection_Base_02.m2", -- [2640]
			"SparkTrail.m2", -- [2641]
			"Sparkler_White.M2", -- [2642]
			"Spawn_Impact_Base.M2", -- [2643]
			"SpellBreak_Cast_Base.m2", -- [2644]
			"SpellLevelUp.M2", -- [2645]
			"SpellObject_Bomb.m2", -- [2646]
			"SpellObject_Boomerang.m2", -- [2647]
			"SpellObject_SmithingHammer.m2", -- [2648]
			"SpellObject_Wrench.m2", -- [2649]
			"SpellReflection_State_Shield.M2", -- [2650]
			"SpellSteal_Impact_Chest.m2", -- [2651]
			"SpellSteal_Missile.m2", -- [2652]
			"Spell_2H_Pitchfork_A_01.M2", -- [2653]
			"Spell_Axe_2H_Horde_D_03.M2", -- [2654]
			"Spell_Axe_2H_OrgrimmarRaid_D_01.M2", -- [2655]
			"Spell_Dagger.M2", -- [2656]
			"Spell_Durand.M2", -- [2657]
			"Spell_Great_PandarianBanquet_Generic.M2", -- [2658]
			"Spell_Great_PandarianBanquet_Grill.M2", -- [2659]
			"Spell_Great_PandarianBanquet_Oven.M2", -- [2660]
			"Spell_Great_PandarianBanquet_Pot.M2", -- [2661]
			"Spell_Great_PandarianBanquet_Steamer.M2", -- [2662]
			"Spell_Great_PandarianBanquet_Still.M2", -- [2663]
			"Spell_Great_PandarianBanquet_Wok.M2", -- [2664]
			"Spell_Hozen_Eat.M2", -- [2665]
			"Spell_Mantid_CellTower.M2", -- [2666]
			"Spell_MyEyes.M2", -- [2667]
			"Spell_PandarianBanquet_Generic.M2", -- [2668]
			"Spell_PandarianBanquet_Grill.M2", -- [2669]
			"Spell_PandarianBanquet_Oven.M2", -- [2670]
			"Spell_PandarianBanquet_Pot.M2", -- [2671]
			"Spell_PandarianBanquet_Steamer.M2", -- [2672]
			"Spell_PandarianBanquet_Still.M2", -- [2673]
			"Spell_PandarianBanquet_Wok.M2", -- [2674]
			"Spell_Pirate_TaM.M2", -- [2675]
			"Spell_QuilinDog_BossEncounter_Glow_Tile_Gold.M2", -- [2676]
			"Spell_ShaGroundEffect.M2", -- [2677]
			"Spell_ShaGroundEffect_inheritScale.M2", -- [2678]
			"Spell_Shuriken.M2", -- [2679]
			"Spell_WarlockMorphHorns.M2", -- [2680]
			"Spell_WarlockMorphHorns_fel.M2", -- [2681]
			"Spell_WarlockMorphWings.M2", -- [2682]
			"Spell_WarlockMorphWings_fel.M2", -- [2683]
			"Spike2_Impact_Base.M2", -- [2684]
			"Spike_Impact_Base.M2", -- [2685]
			"Spike_Low_Base.M2", -- [2686]
			"Spikes_Area.M2", -- [2687]
			"SpiralMesh_01.M2", -- [2688]
			"SpiritArmor_Impact_Head.M2", -- [2689]
			"Splintering_Wood.M2", -- [2690]
			"Sporeling_01.m2", -- [2691]
			"Sprint_Cast_Base.m2", -- [2692]
			"Sprint_Impact_Chest.M2", -- [2693]
			"StarShards_Impact_Base.M2", -- [2694]
			"Stardust_Trail_State.M2", -- [2695]
			"Starfall_State_NoSun.M2", -- [2696]
			"Starfire_Area.M2", -- [2697]
			"Starry_Impact_01.M2", -- [2698]
			"Starsurge_NoProjection_Missile.M2", -- [2699]
			"State_Arcane_Chest_Burn_Pink.m2", -- [2700]
			"State_Arcane_Hands.M2", -- [2701]
			"State_Template_Base_01.M2", -- [2702]
			"State_Template_Chest_01.M2", -- [2703]
			"Stave_2h_Cataclysm_C_01_Spell.M2", -- [2704]
			"StayofExecution_Impact.m2", -- [2705]
			"Steam.m2", -- [2706]
			"StoneSpike_Impact_Base.M2", -- [2707]
			"Stoneform_State_Base.M2", -- [2708]
			"Stranglethorn_DiamondMines_Circle_Effect_Cyan.M2", -- [2709]
			"Stranglethorn_DiamondMines_Circle_Effect_DarkBlue.M2", -- [2710]
			"Stranglethorn_DiamondMines_Circle_Effect_Green.M2", -- [2711]
			"Stranglethorn_DiamondMines_Circle_Effect_Pulse_Red.M2", -- [2712]
			"Stranglethorn_DiamondMines_Circle_Effect_Purple.M2", -- [2713]
			"Stranglethorn_DiamondMines_Circle_Effect_Red.M2", -- [2714]
			"Stranglethorn_DiamondMines_Circle_Effect_Solid_Cyan.M2", -- [2715]
			"Stranglethorn_DiamondMines_Circle_Effect_Solid_DarkBlue.M2", -- [2716]
			"Stranglethorn_DiamondMines_Circle_Effect_Solid_Green.M2", -- [2717]
			"Stranglethorn_DiamondMines_Circle_Effect_Solid_Purple.M2", -- [2718]
			"Stranglethorn_DiamondMines_Circle_Effect_Solid_Red.M2", -- [2719]
			"Stranglethorn_DiamondMines_Circle_Effect_Solid_White.M2", -- [2720]
			"Stranglethorn_DiamondMines_Circle_Effect_Solid_Yellow.M2", -- [2721]
			"Stranglethorn_DiamondMines_Circle_Effect_White.M2", -- [2722]
			"Stranglethorn_DiamondMines_Circle_Effect_Yellow.M2", -- [2723]
			"StratholmeFloatingEmbers_centered.m2", -- [2724]
			"Strike_Cast_Chest.M2", -- [2725]
			"Strike_Impact_Chest.m2", -- [2726]
			"StunSwirl_State_Head.M2", -- [2727]
			"SummerFest_RoseShower_Impact_Base.m2", -- [2728]
			"SummonGhouls.M2", -- [2729]
			"SummonGround_Blizzard.M2", -- [2730]
			"SummonGround_Blizzard_State.M2", -- [2731]
			"SummonGround_RainofFire.M2", -- [2732]
			"SummonPet_Cast_Impact_Base.M2", -- [2733]
			"SummonPet_Impact_Base.M2", -- [2734]
			"SummonWarHorse_Impact_Base.M2", -- [2735]
			"Summon_PreCast_Hand.M2", -- [2736]
			"Sunder_Impact_Chest.M2", -- [2737]
			"Sunfire_Impact_Base.M2", -- [2738]
			"Sunwell_BeamFX.M2", -- [2739]
			"Sunwell_BeamFX_3s.M2", -- [2740]
			"Sunwell_Fel_Portal.m2", -- [2741]
			"Sunwell_Fire_Barrier.m2", -- [2742]
			"Sunwell_Fire_Barrier_ext.m2", -- [2743]
			"Sunwell_Fire_Barrier_ext_Center.M2", -- [2744]
			"Sunwell_GroundFX.M2", -- [2745]
			"Sunwell_WallFX.m2", -- [2746]
			"SweepingStrike_Impact_Chest.M2", -- [2747]
			"SwipeCaster.m2", -- [2748]
			"SwipeCaster_Green.M2", -- [2749]
			"SwipeCaster_Orange.M2", -- [2750]
			"SwipeCaster_Purple.M2", -- [2751]
			"SwipeCaster_blue.M2", -- [2752]
			"SwipeImpact.m2", -- [2753]
			"SwipeImpact_Green.M2", -- [2754]
			"Sword_1H_QuelDelar_D_01_Spell.m2", -- [2755]
			"Sword_Cyclone_State.M2", -- [2756]
			"SymbolofHope_Impact_Base.M2", -- [2757]
			"TARGET_ARCANE_STATE_RimOnly_Projected.m2", -- [2758]
			"TARGET_FIRE_STATE_CENTERONLY_PROJECTED.m2", -- [2759]
			"TARGET_FIRE_STATE_RIMONLY.m2", -- [2760]
			"TARGET_FIRE_STATE_RIMONLY_PROJECTED.m2", -- [2761]
			"TARGET_HOLY_STATE_RIMONLY.m2", -- [2762]
			"TARGET_HOLY_STATE_RIMONLY_PROJECTED.m2", -- [2763]
			"TARGET_SAND_STATE_CENTERONLY.m2", -- [2764]
			"TARGET_SHADOW_STATE_PROJECTED.M2", -- [2765]
			"TARGET_VOID_STATE_RIMONLY.m2", -- [2766]
			"TARGET_VOID_STATE_RIMONLY_PROJECTED.m2", -- [2767]
			"TankardA_SpellObject.m2", -- [2768]
			"TankardB_SpellObject.m2", -- [2769]
			"Target_Arcane_State_CenterOnly_Projected.m2", -- [2770]
			"Target_Area_Template_01.M2", -- [2771]
			"Target_Felbreaker_State.m2", -- [2772]
			"Target_Holy_State_CenterOnly.m2", -- [2773]
			"Target_Water_State_RimOnly.m2", -- [2774]
			"Target_Water_State_RimOnly_Projected.m2", -- [2775]
			"Target_Wind_State_CenterOnly.m2", -- [2776]
			"Target_Wind_State_CenterOnly_Projected.m2", -- [2777]
			"Taunt_Cast.M2", -- [2778]
			"Taunt_Head.M2", -- [2779]
			"Taunt_Head_Orange.M2", -- [2780]
			"Taunt_Head_Yellow.M2", -- [2781]
			"Teleport.M2", -- [2782]
			"Test_Env_FXwrap.M2", -- [2783]
			"Test_geoParticle.M2", -- [2784]
			"Thanksgiving_Cranberry.m2", -- [2785]
			"Thanksgiving_Cranberry_Missile_HitBounce.m2", -- [2786]
			"Thanksgiving_Pie_Missile_HitBounce.m2", -- [2787]
			"Thanksgiving_Plate.m2", -- [2788]
			"Thanksgiving_Stuffing.m2", -- [2789]
			"Thanksgiving_Stuffing_Missile_HitBounce.m2", -- [2790]
			"Thanksgiving_Turkey.m2", -- [2791]
			"Thanksgiving_Turkey_Missile_HitBounce.m2", -- [2792]
			"Thanksgiving_Yams.m2", -- [2793]
			"Thanksgiving_Yams_Missile_HitBounce.m2", -- [2794]
			"Thanksgiving_pie.m2", -- [2795]
			"The_Art_of_War_Impact.m2", -- [2796]
			"Theramore_Nuke_DONOTUSE.M2", -- [2797]
			"Theramore_Nuke_Mini.M2", -- [2798]
			"Therazane_Base_01.M2", -- [2799]
			"Thorns_Base.M2", -- [2800]
			"Thorns_Damage_Base.M2", -- [2801]
			"Thorns_Low_Chest.M2", -- [2802]
			"Thorns_State_Base.M2", -- [2803]
			"Thorns_State_Base_S.M2", -- [2804]
			"ThreatReduce_Impact_Head.m2", -- [2805]
			"ThroatShot_Impact_Chest.m2", -- [2806]
			"ThunderClap_Cast_Base.M2", -- [2807]
			"ThunderClap_Cast_Base_State.M2", -- [2808]
			"ThunderKing_Cloud_BlueGreen.M2", -- [2809]
			"ThunderKing_Pillar_Bar.M2", -- [2810]
			"ThunderKing_Pillar_Ring.M2", -- [2811]
			"ThunderKing_Precast_Lightning.M2", -- [2812]
			"Time_Snapshot.M2", -- [2813]
			"Time_Twisted_State.M2", -- [2814]
			"Time_Vortex_State.M2", -- [2815]
			"Time_Vortex_State_Green.M2", -- [2816]
			"Titanium_WeaponChain_01.M2", -- [2817]
			"TorchLit.m2", -- [2818]
			"TorchSpell.M2", -- [2819]
			"Torch_Missile.M2", -- [2820]
			"Tornado_Corrupted_01.M2", -- [2821]
			"Tortos_DragonTurtle_DeathCollision.M2", -- [2822]
			"TotemB_SpellObject.m2", -- [2823]
			"Tournament_Brewfest_Pennant.M2", -- [2824]
			"TradeskillLevelUp.M2", -- [2825]
			"Tranquility_Area.M2", -- [2826]
			"Tranquility_Impact_Base.m2", -- [2827]
			"Transform_To_Dragon.M2", -- [2828]
			"Transform_To_Human.M2", -- [2829]
			"Transport_Ship_UD_FX.m2", -- [2830]
			"TreasureGoblinDeath.M2", -- [2831]
			"TreasureGoblin_CoinImpact.M2", -- [2832]
			"TreasureGoblin_CoinMissile.M2", -- [2833]
			"TreasureGoblin_CoinPile.M2", -- [2834]
			"TreasureGoblin_Portal.M2", -- [2835]
			"Treeform_StandVar2_Base.M2", -- [2836]
			"Treeform_StandVar4_Base.M2", -- [2837]
			"Treeform_StandVar4_Hand.M2", -- [2838]
			"TrickOrTreat_Treat_Head.M2", -- [2839]
			"TrickOrTreat_Trick_Head.M2", -- [2840]
			"Trueshot_Aura_Cast_Base.M2", -- [2841]
			"TurboBoltGun.M2", -- [2842]
			"TurnTheTables_Impact.m2", -- [2843]
			"TurnUndead_Impact.M2", -- [2844]
			"Turtle_Punt_01.M2", -- [2845]
			"TwilightSlash_Ground.M2", -- [2846]
			"TwilightSlash_Rip.M2", -- [2847]
			"Twilight_Archimonde_Fire.M2", -- [2848]
			"Twilight_FireBeam_State_Base.M2", -- [2849]
			"Twilight_FireBlast_Impact_Chest.M2", -- [2850]
			"Twilight_FireBolt_Missile_Low.M2", -- [2851]
			"Twilight_Fire_ImpactDD_High_Chest.M2", -- [2852]
			"Twilight_Fire_PreCast_High_Hand.M2", -- [2853]
			"Twilight_Fire_PreCast_Uber_Hand.M2", -- [2854]
			"Twilight_Fire_Precast_Hand.M2", -- [2855]
			"Twilight_Fireball_Missile_High.M2", -- [2856]
			"Twilight_FlameCircleEffect.M2", -- [2857]
			"Twilight_HellFire_FirePuff_Caster_Base.M2", -- [2858]
			"Twilight_Immolate_State_Base.M2", -- [2859]
			"TwilightsHammer_Portal.M2", -- [2860]
			"TwilightsHammer_Portal_Horizontal.M2", -- [2861]
			"TwistingNether_Portal_State.M2", -- [2862]
			"TwistingNether_Vortex_State.M2", -- [2863]
			"UD_BubbleGum_02.M2", -- [2864]
			"Ulduar_BlackHole.m2", -- [2865]
			"Ulduar_BlackHole_H.m2", -- [2866]
			"Ulduar_BossSmoke.m2", -- [2867]
			"Ulduar_Missile.M2", -- [2868]
			"Ulduar_StarMissile.M2", -- [2869]
			"Underwater_Xplosion_1.M2", -- [2870]
			"Undying_Strength_Impact_Chest.M2", -- [2871]
			"UnfairAdvantage_Cast.m2", -- [2872]
			"UnholyShackles_State_Base.M2", -- [2873]
			"UnholyShackles_State_Base_Shadow.M2", -- [2874]
			"UnitCube.m2", -- [2875]
			"UnstableAffliction_Impact_Chest.m2", -- [2876]
			"Unyielding_Will_Impact_Chest.M2", -- [2877]
			"Utgarde_Mirror_FX.m2", -- [2878]
			"VJ_GiantPearl_Cage_Spell.M2", -- [2879]
			"VOID_DEATHAURA_IMPACT_BASE.m2", -- [2880]
			"Valanry_Proc_01.M2", -- [2881]
			"ValentineFireWork.m2", -- [2882]
			"VampiricEmbrace_State_Base.m2", -- [2883]
			"Vanish_Cast_Base.m2", -- [2884]
			"Vengeance_State_Hand.M2", -- [2885]
			"Vertical_Plume_Explosion.M2", -- [2886]
			"Victory_Rush_Impact.M2", -- [2887]
			"Void_Slice_Impact_Base.m2", -- [2888]
			"Void_Totem.M2", -- [2889]
			"Voidzone_Corrupted_Radial_01.M2", -- [2890]
			"Voidzone_Corrupted_Radial_01_farz.M2", -- [2891]
			"Voidzone_Corrupted_Radial_02.M2", -- [2892]
			"Voidzone_Corrupted_Radial_03.M2", -- [2893]
			"Voidzone_Corrupted_Radial_04.M2", -- [2894]
			"Voidzone_Sha_03.M2", -- [2895]
			"Voljin_BigBadVoodoo.M2", -- [2896]
			"Voljin_SerpentWard_Impact.M2", -- [2897]
			"Voljin_SerpentWard_Missile.M2", -- [2898]
			"Voljin_SerpentWard_halfsize.M2", -- [2899]
			"VolumeFog_Corrupted_Funnel_Missile_01.M2", -- [2900]
			"VolumeFog_Corrupted_Funnel_State_01.M2", -- [2901]
			"VolumeFog_Corrupted_State_01.M2", -- [2902]
			"VrykulHarpoon.m2", -- [2903]
			"WARLOCK_INCINERATE_V2.m2", -- [2904]
			"Warlock_ArchimondesVengeance_Impact_Head.M2", -- [2905]
			"Warlock_Atrocity.m2", -- [2906]
			"Warlock_Backdraft.m2", -- [2907]
			"Warlock_Baneofhavoc_Impact_01.M2", -- [2908]
			"Warlock_BodyOfFlames_High_State_Base.M2", -- [2909]
			"Warlock_BodyOfFlames_High_State_Base_Green.M2", -- [2910]
			"Warlock_BodyOfFlames_High_State_Base_Purple.M2", -- [2911]
			"Warlock_BodyOfFlames_Low_State_Base.M2", -- [2912]
			"Warlock_BodyOfFlames_Low_State_Base_Green.M2", -- [2913]
			"Warlock_BodyOfFlames_Low_State_Base_Purple.M2", -- [2914]
			"Warlock_BodyOfFlames_Low_State_Hands.M2", -- [2915]
			"Warlock_BodyOfFlames_Low_State_Hands_Green.M2", -- [2916]
			"Warlock_BodyOfFlames_Low_State_Hands_Purple.M2", -- [2917]
			"Warlock_BodyOfFlames_Medium_State_Shoulder_Left.M2", -- [2918]
			"Warlock_BodyOfFlames_Medium_State_Shoulder_Left_Green.M2", -- [2919]
			"Warlock_BodyOfFlames_Medium_State_Shoulder_Left_Purple.M2", -- [2920]
			"Warlock_BodyOfFlames_Medium_State_Shoulder_Right.M2", -- [2921]
			"Warlock_BodyOfFlames_Medium_State_Shoulder_Right_Green.M2", -- [2922]
			"Warlock_BodyOfFlames_Medium_State_Shoulder_Right_Purple.M2", -- [2923]
			"Warlock_Carrion_Swarm.M2", -- [2924]
			"Warlock_Cataclysm.M2", -- [2925]
			"Warlock_Cataclysm_Explosion.M2", -- [2926]
			"Warlock_Cataclysm_Explosion_Fel.M2", -- [2927]
			"Warlock_Cataclysm_Ground.M2", -- [2928]
			"Warlock_Cataclysm_Ground_Fel.M2", -- [2929]
			"Warlock_Cataclysm_Precast.M2", -- [2930]
			"Warlock_Cataclysm_Precast_Base.M2", -- [2931]
			"Warlock_Cataclysm_Precast_Base_Fel.M2", -- [2932]
			"Warlock_Cataclysm_Precast_Fel.M2", -- [2933]
			"Warlock_Cataclysm_Precast_Ground_felGreen.M2", -- [2934]
			"Warlock_Cataclysm_felGreen.M2", -- [2935]
			"Warlock_ChaosWave_Missile.M2", -- [2936]
			"Warlock_DarkBargain_Impact.M2", -- [2937]
			"Warlock_DarkBargain_State_Chest_Purple.M2", -- [2938]
			"Warlock_Decimate_Impact.m2", -- [2939]
			"Warlock_Decimate_Impact_Chest_V2.m2", -- [2940]
			"Warlock_Decimate_Missile.M2", -- [2941]
			"Warlock_Decimate_State.M2", -- [2942]
			"Warlock_Decimate_impact_areasplash.m2", -- [2943]
			"Warlock_Demon_Soul_Impact.M2", -- [2944]
			"Warlock_Demon_Soul_Impact_Base.M2", -- [2945]
			"Warlock_Demon_Soul_Impact_Base_Felguard.M2", -- [2946]
			"Warlock_Demon_Soul_Impact_Base_Felhunter.M2", -- [2947]
			"Warlock_Demon_Soul_Impact_Base_Imp.M2", -- [2948]
			"Warlock_Demon_Soul_Impact_Base_Succubus.M2", -- [2949]
			"Warlock_Demon_Soul_Impact_Base_Voidwalker.M2", -- [2950]
			"Warlock_Demon_Soul_Impact_Felguard.M2", -- [2951]
			"Warlock_Demon_Soul_Impact_Felhunter.M2", -- [2952]
			"Warlock_Demon_Soul_Impact_Imp.M2", -- [2953]
			"Warlock_Demon_Soul_Impact_Succubus.M2", -- [2954]
			"Warlock_Demon_Soul_Impact_Voidwalker.M2", -- [2955]
			"Warlock_DemonicCircle_Summon.m2", -- [2956]
			"Warlock_DemonicCircle_Teleport.m2", -- [2957]
			"Warlock_DemonicPortal_Base.M2", -- [2958]
			"Warlock_DemonicPortal_Charge_Green_01.M2", -- [2959]
			"Warlock_DemonicPortal_Charge_Green_02.M2", -- [2960]
			"Warlock_DemonicPortal_Charge_Green_03.M2", -- [2961]
			"Warlock_DemonicPortal_Charge_Green_04.M2", -- [2962]
			"Warlock_DemonicPortal_Charge_Green_05.M2", -- [2963]
			"Warlock_DemonicPortal_Charge_Purple_01.M2", -- [2964]
			"Warlock_DemonicPortal_Charge_Purple_02.M2", -- [2965]
			"Warlock_DemonicPortal_Charge_Purple_03.M2", -- [2966]
			"Warlock_DemonicPortal_Charge_Purple_04.M2", -- [2967]
			"Warlock_DemonicPortal_Charge_Purple_05.M2", -- [2968]
			"Warlock_DemonicPortal_Fire.M2", -- [2969]
			"Warlock_DemonicPortal_Green.M2", -- [2970]
			"Warlock_DemonicPortal_Missile.M2", -- [2971]
			"Warlock_DemonicPortal_Precast.M2", -- [2972]
			"Warlock_DemonicPortal_Purple.M2", -- [2973]
			"Warlock_DemonicPortal_Travel_Green.M2", -- [2974]
			"Warlock_DemonicPortal_Travel_Purple.M2", -- [2975]
			"Warlock_Demonic_Empathy.m2", -- [2976]
			"Warlock_Demonic_Empowerment.m2", -- [2977]
			"Warlock_DemonologyCharge_Impact_Base.M2", -- [2978]
			"Warlock_DemonologyCharge_Impact_Chest.M2", -- [2979]
			"Warlock_DemonologyCharge_Ribbon.M2", -- [2980]
			"Warlock_DestructionCharge_Impact_Base.M2", -- [2981]
			"Warlock_DestructionCharge_Impact_Base_Fel.M2", -- [2982]
			"Warlock_DestructionCharge_Impact_Chest.M2", -- [2983]
			"Warlock_DestructionCharge_Impact_Chest_Fel.M2", -- [2984]
			"Warlock_Empoweredimp_Impact_01.M2", -- [2985]
			"Warlock_FelFlame_Impact.M2", -- [2986]
			"Warlock_FelFlame_Missile.M2", -- [2987]
			"Warlock_Focus_Shadow_Impact.M2", -- [2988]
			"Warlock_GlyphofNightmares_Base.M2", -- [2989]
			"Warlock_GlyphofNightmares_Base_Fel.M2", -- [2990]
			"Warlock_Guldan_Impact_Low.M2", -- [2991]
			"Warlock_Guldan_Missile_Low.M2", -- [2992]
			"Warlock_Handofguildan_01.M2", -- [2993]
			"Warlock_Handofguldan_Bolt.M2", -- [2994]
			"Warlock_Handofguldan_Bolt_Impact.M2", -- [2995]
			"Warlock_Handofguldan_Missile_01.M2", -- [2996]
			"Warlock_Handofguldan_State_01.M2", -- [2997]
			"Warlock_Handofguldan_State_01Hostile.M2", -- [2998]
			"Warlock_Haunt_Impact.m2", -- [2999]
			"Warlock_Haunt_Missile.M2", -- [3000]
			"Warlock_Haunt_State.M2", -- [3001]
			"Warlock_MaleficGrasp_Missile.M2", -- [3002]
			"Warlock_SacrificialPact.M2", -- [3003]
			"Warlock_SacrificialPact_Base.M2", -- [3004]
			"Warlock_SacrificialPact_Chest.M2", -- [3005]
			"Warlock_ShadowFlame.m2", -- [3006]
			"Warlock_ShadowFlame_Low.M2", -- [3007]
			"Warlock_Shadowbolt_Missile_V2.M2", -- [3008]
			"Warlock_SoulFire_Impact.M2", -- [3009]
			"Warlock_SoulHarvest_Channel.M2", -- [3010]
			"Warlock_SoulLink_State.M2", -- [3011]
			"Warlock_SoulShard_Indicator.M2", -- [3012]
			"Warlock_Soul_Burn_Impact.M2", -- [3013]
			"Warlock_Soulswap_Impact_01.M2", -- [3014]
			"Warlock_Soulswap_Missile_01.M2", -- [3015]
			"Warlock_SpellDrain_Chest.M2", -- [3016]
			"Warlock_UndyingResolve_Back.M2", -- [3017]
			"Warlock_UndyingResolve_Base.M2", -- [3018]
			"Warlock_UndyingResolve_Chest.M2", -- [3019]
			"Warlock_Whiplash_01.M2", -- [3020]
			"Warrior_Avatar_Cast.M2", -- [3021]
			"Warrior_BladeStorm.m2", -- [3022]
			"Warrior_BloodBath.m2", -- [3023]
			"Warrior_BloodSurge.m2", -- [3024]
			"Warrior_Colossusmash_Impact_01.M2", -- [3025]
			"Warrior_Devastate.M2", -- [3026]
			"Warrior_Devastate_Axe.M2", -- [3027]
			"Warrior_Devastate_Centered.M2", -- [3028]
			"Warrior_DisruptingShout_Base.M2", -- [3029]
			"Warrior_DragonRoar_Impact_Base.M2", -- [3030]
			"Warrior_DragonRoar_RingImpact_Base.M2", -- [3031]
			"Warrior_Gushing_Wound.M2", -- [3032]
			"Warrior_HeroicThrow_Impact.m2", -- [3033]
			"Warrior_HeroicThrow_Missile.m2", -- [3034]
			"Warrior_Heroic_Leap.M2", -- [3035]
			"Warrior_Inner_Rage.M2", -- [3036]
			"Warrior_Ravager.m2", -- [3037]
			"Warrior_Ravager_notrail.m2", -- [3038]
			"Warrior_SafeGuard.m2", -- [3039]
			"Warrior_ShockWave_Area.m2", -- [3040]
			"Warrior_ShockWave_Impact.m2", -- [3041]
			"Warrior_ShockWave_NoPulse.m2", -- [3042]
			"Warrior_Stormbolt_Missile.M2", -- [3043]
			"Warrior_SweepingStrikes.m2", -- [3044]
			"Warrior_Vigilance.M2", -- [3045]
			"Warrior_WildStrike_Base.M2", -- [3046]
			"WaterBolt_Missile_Low.M2", -- [3047]
			"WaterBubble.m2", -- [3048]
			"WaterElemental_Impact_Base.M2", -- [3049]
			"WaterLiquidBreath.m2", -- [3050]
			"WaterLiquidBreath_Sha.M2", -- [3051]
			"WaterShield_Impact_Base.M2", -- [3052]
			"WaterShield_State_Base.M2", -- [3053]
			"WaterShield_State_Base_S.M2", -- [3054]
			"WaterSteam_Impact.m2", -- [3055]
			"WaterSteam_Impact_02.M2", -- [3056]
			"WaterSteam_Impact_Dark.M2", -- [3057]
			"WaterWalking_Impact_Head.M2", -- [3058]
			"Water_Explosion.m2", -- [3059]
			"Water_Explosion_Sha.M2", -- [3060]
			"Water_Explosion_nofish.M2", -- [3061]
			"Water_Impact.M2", -- [3062]
			"Water_Jets_Engineering.M2", -- [3063]
			"Water_Nova.M2", -- [3064]
			"Water_Nova_2.M2", -- [3065]
			"Water_Precast.M2", -- [3066]
			"Water_State.M2", -- [3067]
			"Water_explosion_dark_beer.M2", -- [3068]
			"Water_explosion_medium_beer.M2", -- [3069]
			"Water_explosion_wheat_beer.M2", -- [3070]
			"Water_precast_dark_beer.M2", -- [3071]
			"Water_precast_medium_beer.M2", -- [3072]
			"Water_precast_wheat_beer.M2", -- [3073]
			"Water_state_dark_beer.M2", -- [3074]
			"Water_state_medium_beer.M2", -- [3075]
			"Water_state_wheat_beer.M2", -- [3076]
			"Waterbolt_dark_beer.M2", -- [3077]
			"Waterbolt_medium_beer.M2", -- [3078]
			"Waterbolt_wheat_beer.M2", -- [3079]
			"Waterbreathing_Impact_Base.m2", -- [3080]
			"WaterelementalLow_Impact_Base.M2", -- [3081]
			"Wave_Water.m2", -- [3082]
			"Waylay_State.m2", -- [3083]
			"WeaponEnchant_PVPPandariaS2.M2", -- [3084]
			"WeaponTrail_Solar.M2", -- [3085]
			"WeaponTrail_WarriorFury.M2", -- [3086]
			"WebSpin.m2", -- [3087]
			"Web_Missile.m2", -- [3088]
			"Web_State.m2", -- [3089]
			"WellOfSouls_Base.M2", -- [3090]
			"Well_Of_Souls_Base.m2", -- [3091]
			"WhirlwindGeo1.m2", -- [3092]
			"WhirlwindGeo2.m2", -- [3093]
			"WhirlwindGeoWhite.M2", -- [3094]
			"Whirlwind_State_Base.m2", -- [3095]
			"WhiteRadiationFog.M2", -- [3096]
			"WhiteRadiationFog_NoProjection.M2", -- [3097]
			"WindBlast.m2", -- [3098]
			"Wind_Chakram_Missile.M2", -- [3099]
			"Wind_Chakram_Missile_Reverse.M2", -- [3100]
			"WineGlass_01_SpellObject.m2", -- [3101]
			"WineGlass_02_SpellObject.m2", -- [3102]
			"WisdomAura_Impact_Base.M2", -- [3103]
			"WorgenCombatTransformation_wof.m2", -- [3104]
			"WorgenCombatTransformation_wof_hd.m2", -- [3105]
			"WorgenCombatTransformation_wom.m2", -- [3106]
			"WorgenCombatTransformation_wom_hd.m2", -- [3107]
			"Worgen_Combat_Transform_FX.M2", -- [3108]
			"Worgen_Transform_FX.M2", -- [3109]
			"Wrath_Impact_Chest.M2", -- [3110]
			"Wrath_Missile.M2", -- [3111]
			"Wrath_PreCast_Hand.M2", -- [3112]
			"Wrongfully_Accused_Impact.m2", -- [3113]
			"Xplosion_Dust_Impact.m2", -- [3114]
			"Xplosion_Dust_Impact_NoFlash.M2", -- [3115]
			"Xplosion_Fel_Impact.m2", -- [3116]
			"Xplosion_Fel_Impact_NoFlash.M2", -- [3117]
			"Xplosion_Fire_Impact.m2", -- [3118]
			"Xplosion_Fire_Impact_02.m2", -- [3119]
			"Xplosion_Fire_Impact_02_NoFlash.M2", -- [3120]
			"Xplosion_Fire_Impact_Blue.m2", -- [3121]
			"Xplosion_Fire_Impact_Blue_NoFlash.M2", -- [3122]
			"Xplosion_Fire_Impact_NoFlash.M2", -- [3123]
			"Xplosion_Frost_Impact.m2", -- [3124]
			"Xplosion_Frost_Impact_B.m2", -- [3125]
			"Xplosion_Frost_Impact_B_NoFlash.M2", -- [3126]
			"Xplosion_Frost_Impact_NoFlash.M2", -- [3127]
			"Xplosion_Lightning_Impact.m2", -- [3128]
			"Xplosion_Lightning_Impact_NoFlash.M2", -- [3129]
			"Xplosion_Nature_Impact.m2", -- [3130]
			"Xplosion_Nature_Impact_NoFlash.M2", -- [3131]
			"Xplosion_Twilight_Impact.M2", -- [3132]
			"Xplosion_Twilight_Impact_NoFlash.M2", -- [3133]
			"YoggSaron_Green.M2", -- [3134]
			"Zangarmarsh_Arcane_Impact.m2", -- [3135]
			"Zangarmarsh_Arcane_Missile.M2", -- [3136]
			"Zig_Missile.M2", -- [3137]
			"Zig_Missile_V2.M2", -- [3138]
			"ZigguratCrystal_V2.M2", -- [3139]
			"ZulAman_FireDoor_Unit.m2", -- [3140]
			"arakkoaoutcasts_curse_cloudy_state_base.m2", -- [3141]
			"arakkoaoutcasts_curse_cripple_state_base.m2", -- [3142]
			"arakkoaoutcasts_fire_missile.m2", -- [3143]
			"arakkoaoutcasts_illusion_impact_areasplash.m2", -- [3144]
			"arakkoaoutcasts_illusion_precast_hand.m2", -- [3145]
			"arcane_missile_orb.m2", -- [3146]
			"arcane_void_circle.m2", -- [3147]
			"arcane_zone_white.m2", -- [3148]
			"arcane_zone_yellow.m2", -- [3149]
			"archimonde_fire_Jade.M2", -- [3150]
			"arrow_state_animated.m2", -- [3151]
			"ashran_arcaneimprisonment_state.m2", -- [3152]
			"ashran_fullloot_state.m2", -- [3153]
			"ashran_loot_state.m2", -- [3154]
			"battlefieldbanner_alliance_flag01.m2", -- [3155]
			"battlefieldbanner_alliance_flag02_bw.m2", -- [3156]
			"battlefieldbanner_horde_flag01.m2", -- [3157]
			"battlefieldbanner_horde_flag02_bw.m2", -- [3158]
			"battlefieldbanner_neutral_flag01.m2", -- [3159]
			"beamtarget_onground_nonprojected.m2", -- [3160]
			"beastmaster_callofthepack_impact.m2", -- [3161]
			"beastmaster_essencetransfer_impact.m2", -- [3162]
			"beastmaster_essencetransfer_missile.m2", -- [3163]
			"beastmaster_firevoid_state.m2", -- [3164]
			"beholder_ice_waller.M2", -- [3165]
			"black_blood_geyser.M2", -- [3166]
			"bloodsplat_03.m2", -- [3167]
			"bloodsplat_04.m2", -- [3168]
			"boneguardrockspike_spell02.m2", -- [3169]
			"breath_earth_01.m2", -- [3170]
			"breath_fel_01.m2", -- [3171]
			"breath_fire_01_blue.m2", -- [3172]
			"breath_fire_precast_state.m2", -- [3173]
			"breath_frost_precast_state.m2", -- [3174]
			"breath_poison_precast_state.m2", -- [3175]
			"breath_shadow_01.m2", -- [3176]
			"breath_shadow_precast_state.m2", -- [3177]
			"breath_shrapnel_01.m2", -- [3178]
			"breath_solar_01.m2", -- [3179]
			"breath_void_01.m2", -- [3180]
			"burrowearth_brown_missile_v2_nodust.m2", -- [3181]
			"burrowice_missile.m2", -- [3182]
			"cast_arcane_01.m2", -- [3183]
			"cast_arcane_white_01.m2", -- [3184]
			"cast_arcane_yellow_01.m2", -- [3185]
			"channeldome_shadow_state_base.m2", -- [3186]
			"channeldome_shadow_state_dome.m2", -- [3187]
			"channeldome_shadow_state_souls.m2", -- [3188]
			"channeldome_shadow_state_uber.m2", -- [3189]
			"chimerashot_impact_frost.m2", -- [3190]
			"chimerashot_impact_poison.m2", -- [3191]
			"chimerashot_missile_frost.m2", -- [3192]
			"chimerashot_missile_poison.m2", -- [3193]
			"cleave_circle_wind_loop.m2", -- [3194]
			"consecration_impact_base_pulse.m2", -- [3195]
			"consecration_impact_base_pulse_hostile.m2", -- [3196]
			"construct_hand_state.m2", -- [3197]
			"construct_santifiedstrike_impact.m2", -- [3198]
			"construct_santifiedstrike_precast_state.m2", -- [3199]
			"construct_santifiedstrike_state.m2", -- [3200]
			"construct_shield_impact.m2", -- [3201]
			"corpseexplosion_impact_chest.m2", -- [3202]
			"crow_baked.M2", -- [3203]
			"dalaran_brilliance.m2", -- [3204]
			"deathknight_breathofsindragosa_cast.m2", -- [3205]
			"deathknight_breathofsindragosa_impact.m2", -- [3206]
			"deathknight_breathofsindragosa_state.m2", -- [3207]
			"deathknight_defile_impact.m2", -- [3208]
			"deathknight_necroticplague_cast.m2", -- [3209]
			"deathknight_necroticplague_impact.m2", -- [3210]
			"deathknight_necroticplague_missile.m2", -- [3211]
			"divine_storm_cast.m2", -- [3212]
			"djnnHandR_Sand.M2", -- [3213]
			"djnnHandR_Water.M2", -- [3214]
			"dragonSoul_HagaraCloud_01.M2", -- [3215]
			"dragonSoul_HagaraFrost_01.M2", -- [3216]
			"dragonbreath_leishen_lightning_withdecay.m2", -- [3217]
			"druid_eclipse_cycle.m2", -- [3218]
			"druid_efflorescence_persistentv2.m2", -- [3219]
			"druid_shootingstars.m2", -- [3220]
			"druid_solarfall_missile_noflash.m2", -- [3221]
			"druid_starfall_missile_noflash.m2", -- [3222]
			"druid_starsurge_impact_chest.m2", -- [3223]
			"druid_stellarflare.m2", -- [3224]
			"druid_sunfallstate.m2", -- [3225]
			"earth_dustcloud_state.m2", -- [3226]
			"earth_dustcloud_state_smalltrail.m2", -- [3227]
			"earth_groundspike_impact_nagrand.m2", -- [3228]
			"explosion_arcane_impact.m2", -- [3229]
			"explosion_earth_impact.m2", -- [3230]
			"explosion_fel_impact.m2", -- [3231]
			"explosion_fire_impact.m2", -- [3232]
			"explosion_fire_impact_ground.m2", -- [3233]
			"explosion_fire_impact_rotateme.m2", -- [3234]
			"explosion_fire_impact_scalevariation.m2", -- [3235]
			"explosion_frost_impact.m2", -- [3236]
			"explosion_holy_impact.m2", -- [3237]
			"explosion_lightning_impact.m2", -- [3238]
			"explosion_nature_impact.m2", -- [3239]
			"explosion_shadow_impact.m2", -- [3240]
			"explosion_water_impact.m2", -- [3241]
			"explosion_wind_impact.m2", -- [3242]
			"explosivetimer_state_base_blooddrop.m2", -- [3243]
			"explosivetimer_state_base_rainbow_inflightmissile.m2", -- [3244]
			"fel_combustion_impact_chest.m2", -- [3245]
			"fel_fire_state_base.m2", -- [3246]
			"fel_lash_impact_chest.m2", -- [3247]
			"fel_lavapillar_impact_base.m2", -- [3248]
			"fel_meteor_missile.m2", -- [3249]
			"fel_zone.m2", -- [3250]
			"felbreaker_areasplash_impact.m2", -- [3251]
			"felbreaker_chestburn_state.m2", -- [3252]
			"felbreaker_expelmagic_arcane_state.m2", -- [3253]
			"felbreaker_expelmagic_fire_state.m2", -- [3254]
			"felbreaker_expelmagic_frost_state.m2", -- [3255]
			"felbreaker_expelmagic_shadow_state.m2", -- [3256]
			"felbreaker_nova_impact.m2", -- [3257]
			"felbreaker_nulificationshield_state_base.m2", -- [3258]
			"felbreaker_orb_missile.m2", -- [3259]
			"felbreaker_streak_missile.m2", -- [3260]
			"felbreakerzone.m2", -- [3261]
			"feldspar_firefury_state.m2", -- [3262]
			"fill_fire_state_03_purple.m2", -- [3263]
			"fire_state_base.m2", -- [3264]
			"frost_nova_stun_state.m2", -- [3265]
			"fury_gooflow_state.m2", -- [3266]
			"garrison_nuke_impact.m2", -- [3267]
			"garrison_nuke_impact_low.m2", -- [3268]
			"garrison_orangebird_impact.m2", -- [3269]
			"giftofnaaru_shd.m2", -- [3270]
			"gladiatorstance_impact_head.m2", -- [3271]
			"glass_explosion_base.m2", -- [3272]
			"goobolt_acid_low.m2", -- [3273]
			"goren_acid_state.m2", -- [3274]
			"goren_spike_impact_blue.m2", -- [3275]
			"goren_spike_impact_green.m2", -- [3276]
			"goren_spike_impact_red.m2", -- [3277]
			"goren_spike_missile_acid.m2", -- [3278]
			"goren_spike_missile_earth.m2", -- [3279]
			"goren_spike_missile_red.m2", -- [3280]
			"groundcrack_ice_state_v2.m2", -- [3281]
			"groundcrack_physical_state_v2.m2", -- [3282]
			"gruul_dust_state_world.m2", -- [3283]
			"gruul_stalactite_precast_state.m2", -- [3284]
			"gruul_stalactite_precast_state_blue.m2", -- [3285]
			"gruul_stalactite_state_world.m2", -- [3286]
			"gunpowder_state_base.m2", -- [3287]
			"halo_missile_souls.m2", -- [3288]
			"hansfranz_fire_high_state.m2", -- [3289]
			"hansfranz_fire_low_state.m2", -- [3290]
			"hansfranz_hotplates_state.m2", -- [3291]
			"hellfire_firepuff_caster_base_v3_Fel.M2", -- [3292]
			"hellfire_firepuff_caster_base_v3_Illidari.M2", -- [3293]
			"hellfire_firepuff_caster_base_v3_Twilight.M2", -- [3294]
			"hellfire_impact_caster_statev2.m2", -- [3295]
			"highmaul_arcanerune_base_state_blue.m2", -- [3296]
			"highmaul_arcanerune_base_state_white.m2", -- [3297]
			"highmaul_arcanerune_base_state_yellow.m2", -- [3298]
			"highmaul_arcanerunecharged_blue_state.m2", -- [3299]
			"highmaul_arcanerunecharged_impact.m2", -- [3300]
			"highmaul_arcanerunecharged_pink_state.m2", -- [3301]
			"highmaul_arcanerunecharged_white_state.m2", -- [3302]
			"highmaul_arcanerunecharged_yellow_state.m2", -- [3303]
			"highmaul_bladefist_chainhurl_windtrail.m2", -- [3304]
			"highmaul_bladefist_maulingbrew_missile.m2", -- [3305]
			"highmaul_bladefist_sprint_missile.m2", -- [3306]
			"highmaul_bomb_blue.m2", -- [3307]
			"highmaul_bomb_pink.m2", -- [3308]
			"highmaul_bomb_white.m2", -- [3309]
			"highmaul_bomb_yellow.m2", -- [3310]
			"highmaul_displasionshield_state_base.m2", -- [3311]
			"highmaul_eplicationshield_state_base.m2", -- [3312]
			"highmaul_flamethrower_state.m2", -- [3313]
			"highmaul_forcenova_cast.m2", -- [3314]
			"highmaul_forcenova_cast_white.m2", -- [3315]
			"highmaul_forcenova_cast_yellow.m2", -- [3316]
			"highmaul_forcenova_pink.m2", -- [3317]
			"highmaul_fortificationshield_state_base.m2", -- [3318]
			"highmaul_fungalgiant_moss.m2", -- [3319]
			"highmaul_fungalgiant_mushroom_explode.m2", -- [3320]
			"highmaul_fungalgiant_mushroom_heal.m2", -- [3321]
			"highmaul_fungalgiant_mushroom_mana.m2", -- [3322]
			"highmaul_fungalgiant_mushroom_mind.m2", -- [3323]
			"highmaulraid_screamingskullfirepillar01_smoke.m2", -- [3324]
			"hobostick.M2", -- [3325]
			"holy_watershield_state.m2", -- [3326]
			"hunter_CobraShot.M2", -- [3327]
			"hunter_CobraShot_Impact.M2", -- [3328]
			"hunter_TrapLauncher_FireMissile.M2", -- [3329]
			"hunter_TrapLauncher_FrostMissile.M2", -- [3330]
			"hunter_TrapLauncher_NatureMissile.M2", -- [3331]
			"hunter_bola_impact.m2", -- [3332]
			"hunter_bola_missile.m2", -- [3333]
			"hunter_bola_state.m2", -- [3334]
			"hunter_cobrashot_impact_chest.m2", -- [3335]
			"hunter_firetrap.m2", -- [3336]
			"hunter_focusingshot_missile.m2", -- [3337]
			"hunter_focusingshot_precast_state.m2", -- [3338]
			"hunter_frosttrap.m2", -- [3339]
			"hunter_frozenammo_missile.m2", -- [3340]
			"hunter_incendiaryammo_missile.m2", -- [3341]
			"hunter_naturetrap.m2", -- [3342]
			"hunter_poisonedammo_missile.m2", -- [3343]
			"impact_arcane_areasplash.m2", -- [3344]
			"impact_arcane_chest.m2", -- [3345]
			"impact_arcane_chest_pink.m2", -- [3346]
			"impact_arcane_chest_white.m2", -- [3347]
			"impact_arcane_chest_yellow.m2", -- [3348]
			"impact_shadow_areasplash.m2", -- [3349]
			"impact_shadow_chest.m2", -- [3350]
			"ironhorde_chains_missile.m2", -- [3351]
			"ironhorde_flamingbullets.m2", -- [3352]
			"ironhorde_missile_weaponball.m2", -- [3353]
			"ironhorde_weaponball_impact_base.m2", -- [3354]
			"ironhorde_weaponball_impact_base02.m2", -- [3355]
			"ironmaiden_blood_precast_state.m2", -- [3356]
			"ironmaiden_blood_state.m2", -- [3357]
			"ironmaiden_bloodritual_breath.m2", -- [3358]
			"ironmaiden_bloodritual_missile.m2", -- [3359]
			"ironmaiden_cycloneslash_missile.m2", -- [3360]
			"ironmaiden_dash_impact.m2", -- [3361]
			"ironmaiden_disorientationgrenade_impact.m2", -- [3362]
			"ironmaiden_lingeringshadow_state.m2", -- [3363]
			"ironmaiden_seismicstrikes_impact.m2", -- [3364]
			"ironmaiden_tornado_state.m2", -- [3365]
			"karabor_nuke_impact.m2", -- [3366]
			"landshark_missile.M2", -- [3367]
			"lavaelemental_Impact_Base.M2", -- [3368]
			"leishen_lightning_precast_nosparks.m2", -- [3369]
			"lightningshield_fulmination.m2", -- [3370]
			"lighttest.m2", -- [3371]
			"lunarbeam_general_base.m2", -- [3372]
			"mage_arcaneorb_missile.m2", -- [3373]
			"mage_cometstorm_missile.m2", -- [3374]
			"mage_evanesce.m2", -- [3375]
			"mage_frostorb_orb_Hostile.m2", -- [3376]
			"mage_frostorb_orb_v2.m2", -- [3377]
			"mage_frostorb_orb_v2_Hostile.m2", -- [3378]
			"mage_meteor_missile.m2", -- [3379]
			"mage_meteor_state.m2", -- [3380]
			"mage_meteor_state_hostile.m2", -- [3381]
			"magmazone.m2", -- [3382]
			"mark_of_chaos_state.m2", -- [3383]
			"meteor_fast.m2", -- [3384]
			"missile_arcane_bolt.m2", -- [3385]
			"missile_arcane_bolt_pink.m2", -- [3386]
			"missile_arcane_bolt_white.m2", -- [3387]
			"missile_arcane_bolt_yellow.m2", -- [3388]
			"missile_arcane_streak.m2", -- [3389]
			"missile_earth_bolt.m2", -- [3390]
			"missile_fire_cannon.m2", -- [3391]
			"missile_fire_nosmoke.m2", -- [3392]
			"missile_shadow_bolt.m2", -- [3393]
			"missile_wave_stone_ogre.m2", -- [3394]
			"monk_breathoftheserpent_state.m2", -- [3395]
			"monk_chiexplosion_impact_base.m2", -- [3396]
			"monk_chiexplosion_impact_chest.m2", -- [3397]
			"monk_chiexplosionheal_impact_base.m2", -- [3398]
			"monk_chiserenity_state_base.m2", -- [3399]
			"monk_hurricanestrike_impact.m2", -- [3400]
			"monk_hurricanestrike_state.m2", -- [3401]
			"monk_revival_impact_base.m2", -- [3402]
			"monk_surgingmists_impact_standvariations.m2", -- [3403]
			"nature_dustcloud_state.m2", -- [3404]
			"nerzhul_souls_state.m2", -- [3405]
			"new_windfury_vertical.m2", -- [3406]
			"nova_arcane.m2", -- [3407]
			"nova_arcane_raid_low.m2", -- [3408]
			"nova_arcane_raid_low_yellow.m2", -- [3409]
			"nova_arcane_white.m2", -- [3410]
			"nova_arcane_yellow.m2", -- [3411]
			"nova_earth_raid_low.m2", -- [3412]
			"nova_fel_fire.m2", -- [3413]
			"nova_fel_raid_low.m2", -- [3414]
			"nova_frost_raid_low.m2", -- [3415]
			"nova_holy_raid_low.m2", -- [3416]
			"nova_lightning_raid_low.m2", -- [3417]
			"nova_nature_raid_low.m2", -- [3418]
			"nova_sha_raid_low.m2", -- [3419]
			"nova_shadow.m2", -- [3420]
			"nova_shadow_raid_low.m2", -- [3421]
			"nova_water_raid_low.m2", -- [3422]
			"nova_wind_raid_low.m2", -- [3423]
			"ograid_engine_flame.m2", -- [3424]
			"ograid_furnace_fire_effect.M2", -- [3425]
			"ogre_backdraft_impact.m2", -- [3426]
			"ogre_battletrance_impact_base.m2", -- [3427]
			"ogre_bloodyexplosion_impact_base.m2", -- [3428]
			"ogre_bloodyrage_impact_base.m2", -- [3429]
			"ogre_boulderbolt_missile.m2", -- [3430]
			"ogre_brawl_impact_base.m2", -- [3431]
			"ogre_earthslash.m2", -- [3432]
			"ogre_gemboulder_state_base.m2", -- [3433]
			"ogre_gemdust_impact_base.m2", -- [3434]
			"ogre_gemdust_precast_hand.m2", -- [3435]
			"ogre_groundsmash_impact_base.m2", -- [3436]
			"ogre_imperialorder_impact_base.m2", -- [3437]
			"ogre_lava_impact_chest.m2", -- [3438]
			"ogre_lava_nova.m2", -- [3439]
			"ogre_lava_state_chest.m2", -- [3440]
			"ogre_lavapillar_impact_base.m2", -- [3441]
			"ogre_lavaprecast_hand.m2", -- [3442]
			"ogre_lavaprecast_hand_withdrips.m2", -- [3443]
			"ogre_primalbloodlust_state_base.m2", -- [3444]
			"ogre_primalbloodlust_state_left_hand.m2", -- [3445]
			"ogre_primalbloodlust_state_right_hand.m2", -- [3446]
			"ogre_rampagingstrike_impact_base.m2", -- [3447]
			"ogre_stone_beamchannel_cast.m2", -- [3448]
			"ogre_stone_cast.m2", -- [3449]
			"ogre_stone_impact_chest.m2", -- [3450]
			"ogre_stonebolt_missile.m2", -- [3451]
			"ogre_stoneskin_state_base.m2", -- [3452]
			"ogre_stonevortex_state_base.m2", -- [3453]
			"ogre_thrash_impact_base.m2", -- [3454]
			"oregorger_goo_flow_state_lava01.m2", -- [3455]
			"oregorger_lavaburst_missile_row01.m2", -- [3456]
			"paladin_beaconofinsight.m2", -- [3457]
			"paladin_empoweredseals_base01.m2", -- [3458]
			"paladin_empoweredseals_insight_libram01.m2", -- [3459]
			"paladin_empoweredseals_justice_fist01.m2", -- [3460]
			"paladin_empoweredseals_righteousness_crown01.m2", -- [3461]
			"paladin_empoweredseals_truth_sword01.m2", -- [3462]
			"paladin_finalverdict_cast_01.m2", -- [3463]
			"paladin_finalverdict_impact_01.m2", -- [3464]
			"paladin_handofinsight_impact.m2", -- [3465]
			"paladin_lighthammer_holynova.m2", -- [3466]
			"paladin_lightofdawn_impact_base_v2.m2", -- [3467]
			"paladin_lightofdawn_impact_base_v2_low.m2", -- [3468]
			"paladin_seraphim_head.m2", -- [3469]
			"paladin_seraphim_mace1h.m2", -- [3470]
			"podling_barrage_impact_base.m2", -- [3471]
			"podling_barrage_impact_chest.m2", -- [3472]
			"podling_bloomingbreath_impact_chest.m2", -- [3473]
			"podling_impact_areasplash.m2", -- [3474]
			"podling_impact_chest.m2", -- [3475]
			"podling_peskypod_missile.m2", -- [3476]
			"podling_poison_impact_chest.m2", -- [3477]
			"podling_poisoncloud_state_base.m2", -- [3478]
			"podling_poisonspray_breath.m2", -- [3479]
			"podling_poisonspray_breath_doubledistance.m2", -- [3480]
			"podling_poisonsquirt_missile.m2", -- [3481]
			"podling_precast_hand.m2", -- [3482]
			"podling_root_state_base.m2", -- [3483]
			"podling_root_state_base_02.m2", -- [3484]
			"podling_tornado_state.m2", -- [3485]
			"podling_weaponslash_impact_base.m2", -- [3486]
			"podling_wrapbramble.m2", -- [3487]
			"podling_wrapvine.m2", -- [3488]
			"poison_impact_areasplash.m2", -- [3489]
			"poison_impact_chest_v2.m2", -- [3490]
			"polearm_2h_trident_naga_b_01green.M2", -- [3491]
			"precast_shadow_hand.m2", -- [3492]
			"priest_angelicfeather_state_chest02.m2", -- [3493]
			"priest_clarity_impact_base.m2", -- [3494]
			"priest_clarity_impact_spread.m2", -- [3495]
			"priest_clarityofwill_state_base.m2", -- [3496]
			"priest_guardianspirit_wings.m2", -- [3497]
			"priest_halo_cast.m2", -- [3498]
			"priest_halo_cast_shadow.m2", -- [3499]
			"priest_savinggrace_caster01.m2", -- [3500]
			"priest_savinggrace_target01.m2", -- [3501]
			"priest_voidentropy_state_chest.m2", -- [3502]
			"proc_arcane_impact_low.m2", -- [3503]
			"proc_fire_impact_low_green.m2", -- [3504]
			"proc_fire_impact_low_red.m2", -- [3505]
			"proc_frost_impact_low.m2", -- [3506]
			"raid_ui_fx_orange.m2", -- [3507]
			"raid_ui_fx_silver.m2", -- [3508]
			"raid_ui_fx_white.m2", -- [3509]
			"rogue_bladeflurry.m2", -- [3510]
			"rogue_deathfromabove_impact_air.m2", -- [3511]
			"rogue_deathfromabove_impact_base.m2", -- [3512]
			"rogue_deathfromabove_impact_fan.m2", -- [3513]
			"rogue_deathfromabove_impact_nova.m2", -- [3514]
			"rogue_deathfromabove_ribbon_charge.m2", -- [3515]
			"rogue_deathfromabove_ribbonswirl_impact.m2", -- [3516]
			"rune_lunar_01.m2", -- [3517]
			"rune_lunar_02.m2", -- [3518]
			"rune_lunar_03.m2", -- [3519]
			"rune_shadowmoon_state_01.m2", -- [3520]
			"rune_shadowmoon_state_03.m2", -- [3521]
			"saberon_incense_precast_cyan.m2", -- [3522]
			"saberon_incense_precast_orange.m2", -- [3523]
			"saberon_incense_precast_purple.m2", -- [3524]
			"saberon_incense_state_cyan.m2", -- [3525]
			"saberon_incense_state_orange.m2", -- [3526]
			"saberon_incense_state_purple.m2", -- [3527]
			"sand_risingsand_state.m2", -- [3528]
			"sha_impactdd_high_chest_pride.M2", -- [3529]
			"sha_missile_pride.M2", -- [3530]
			"shadow_precast_low.m2", -- [3531]
			"shadow_precast_medium.m2", -- [3532]
			"shadowgrow_base.m2", -- [3533]
			"shadowmourne_visual_low.M2", -- [3534]
			"shaman_Unleash_Flame.M2", -- [3535]
			"shaman_Unleash_Flame_Impact.M2", -- [3536]
			"shaman_Unleash_Frost.M2", -- [3537]
			"shaman_Unleash_Frost_Impact.M2", -- [3538]
			"shaman_Unleashlife.M2", -- [3539]
			"shaman_condensation_state_base.m2", -- [3540]
			"shaman_healing_rain_projv2.m2", -- [3541]
			"shaman_lavaburst_blue.m2", -- [3542]
			"shaman_lavaburst_fel.m2", -- [3543]
			"shaman_lavaburst_frost.m2", -- [3544]
			"shaman_lavalash.M2", -- [3545]
			"shaman_lavalash_Jade.M2", -- [3546]
			"shaman_lavapillar_impact_base.m2", -- [3547]
			"shaman_measured_insight_orange.m2", -- [3548]
			"shaman_soothing_wind_nova.m2", -- [3549]
			"shaman_stormele_eyeofthestorm.m2", -- [3550]
			"shaman_stormstrike.M2", -- [3551]
			"shaman_unleashedwind_missile_nosmoke.m2", -- [3552]
			"shield_shadow_state_base.m2", -- [3553]
			"shield_state_purple.m2", -- [3554]
			"shout_disc_blue.m2", -- [3555]
			"shout_disc_brown.m2", -- [3556]
			"shout_disc_cyan.m2", -- [3557]
			"shout_disc_green.m2", -- [3558]
			"shout_disc_jade.m2", -- [3559]
			"shout_disc_orange.m2", -- [3560]
			"shout_disc_purple.m2", -- [3561]
			"shout_disc_red.m2", -- [3562]
			"shout_disc_yellow.m2", -- [3563]
			"shout_sphere_blue.m2", -- [3564]
			"shout_sphere_brown.m2", -- [3565]
			"shout_sphere_cyan.m2", -- [3566]
			"shout_sphere_green.m2", -- [3567]
			"shout_sphere_jade.m2", -- [3568]
			"shout_sphere_orange.m2", -- [3569]
			"shout_sphere_purple.m2", -- [3570]
			"shout_sphere_red.m2", -- [3571]
			"shout_sphere_yellow.m2", -- [3572]
			"skyreach_ranjit_tornado_arm_a.m2", -- [3573]
			"skyreach_ranjit_tornado_arm_b.m2", -- [3574]
			"skyreach_ranjit_tornado_arm_c.m2", -- [3575]
			"skyreach_ranjit_tornado_arm_center.m2", -- [3576]
			"skyreach_ranjit_tornado_arm_center_reverse.m2", -- [3577]
			"skyreach_ranjit_tornado_arm_d.m2", -- [3578]
			"solar_eyes.m2", -- [3579]
			"solar_flashbang_cast.m2", -- [3580]
			"solar_forcesphere_orb.m2", -- [3581]
			"solar_golem_orb.m2", -- [3582]
			"solar_heavy_missile.m2", -- [3583]
			"solar_impact_chest.m2", -- [3584]
			"solar_lightning_column.m2", -- [3585]
			"solar_precast_hand.m2", -- [3586]
			"solar_shield_state.m2", -- [3587]
			"solar_summonpet_impact_base.m2", -- [3588]
			"solarbeam_general_base.m2", -- [3589]
			"solarzone.m2", -- [3590]
			"solarzone_nonprojected.m2", -- [3591]
			"soul_missile_orange.m2", -- [3592]
			"soul_missile_red.m2", -- [3593]
			"soul_missile_shadow.m2", -- [3594]
			"state_arcane_chest_burn.m2", -- [3595]
			"state_arcane_chest_burn_white.m2", -- [3596]
			"state_arcane_chest_burn_yellow.m2", -- [3597]
			"state_lightning_chest_burn.m2", -- [3598]
			"state_shadow_chest_burn.m2", -- [3599]
			"steamfilled_balloon.M2", -- [3600]
			"strength_eyes.m2", -- [3601]
			"target_arcane_state.m2", -- [3602]
			"target_arcane_state_centeronly.m2", -- [3603]
			"target_arcane_state_projected.m2", -- [3604]
			"target_arcane_state_rimonly.m2", -- [3605]
			"target_earth_state.m2", -- [3606]
			"target_earth_state_centeronly.m2", -- [3607]
			"target_earth_state_centeronly_projected.m2", -- [3608]
			"target_earth_state_falloff.m2", -- [3609]
			"target_earth_state_projected.m2", -- [3610]
			"target_earth_state_rimonly.m2", -- [3611]
			"target_earth_state_rimonly_projected.m2", -- [3612]
			"target_fel_state.m2", -- [3613]
			"target_fel_state_centeronly.m2", -- [3614]
			"target_fel_state_centeronly_projected.m2", -- [3615]
			"target_fel_state_projected.m2", -- [3616]
			"target_fel_state_rimonly.m2", -- [3617]
			"target_fel_state_rimonly_projected.m2", -- [3618]
			"target_fire_state.m2", -- [3619]
			"target_fire_state_centeronly.m2", -- [3620]
			"target_fire_state_projected.m2", -- [3621]
			"target_frost_state.m2", -- [3622]
			"target_frost_state_centeronly.m2", -- [3623]
			"target_frost_state_centeronly_projected.m2", -- [3624]
			"target_frost_state_projected.m2", -- [3625]
			"target_frost_state_rimonly.m2", -- [3626]
			"target_frost_state_rimonly_projected.m2", -- [3627]
			"target_holy_state.m2", -- [3628]
			"target_holy_state_centeronly_projected.m2", -- [3629]
			"target_holy_state_projected.m2", -- [3630]
			"target_nature_state.m2", -- [3631]
			"target_nature_state_centeronly.m2", -- [3632]
			"target_nature_state_centeronly_projected.m2", -- [3633]
			"target_nature_state_projected.m2", -- [3634]
			"target_nature_state_rimonly.m2", -- [3635]
			"target_nature_state_rimonly_projected.m2", -- [3636]
			"target_sand_state.m2", -- [3637]
			"target_sand_state_centeronly_projected.m2", -- [3638]
			"target_sand_state_projected.m2", -- [3639]
			"target_sand_state_rimonly.m2", -- [3640]
			"target_sand_state_rimonly_projected.m2", -- [3641]
			"target_shadow_state.m2", -- [3642]
			"target_shadow_state_centeronly.m2", -- [3643]
			"target_shadow_state_centeronly_projected.m2", -- [3644]
			"target_shadow_state_rimonly.m2", -- [3645]
			"target_shadow_state_rimonly_projected.m2", -- [3646]
			"target_void_state.m2", -- [3647]
			"target_void_state_centeronly.m2", -- [3648]
			"target_void_state_centeronly_projected.m2", -- [3649]
			"target_void_state_projected.m2", -- [3650]
			"target_water_state.m2", -- [3651]
			"target_water_state_centeronly.m2", -- [3652]
			"target_water_state_centeronly_projected.m2", -- [3653]
			"target_water_state_projected.m2", -- [3654]
			"target_wind_state.m2", -- [3655]
			"target_wind_state_projected.m2", -- [3656]
			"target_wind_state_rimonly.m2", -- [3657]
			"target_wind_state_rimonly_projected.m2", -- [3658]
			"tectus_dustfill_state.m2", -- [3659]
			"titan_sphere_state.m2", -- [3660]
			"tornado_malfurion_01.m2", -- [3661]
			"tournament_shield_green.m2", -- [3662]
			"tournament_shield_red.m2", -- [3663]
			"tournament_shield_yellow.m2", -- [3664]
			"void_circle_shadow.m2", -- [3665]
			"void_explosion_impact_base.m2", -- [3666]
			"void_eyes.m2", -- [3667]
			"void_form_med_base.m2", -- [3668]
			"void_impact_chest.m2", -- [3669]
			"void_lash_impact_base.m2", -- [3670]
			"void_missile.m2", -- [3671]
			"void_missile_nuke.m2", -- [3672]
			"void_missile_streak.m2", -- [3673]
			"void_nukeexplosion_impact_base.m2", -- [3674]
			"void_precast_hand.m2", -- [3675]
			"void_rune_shadowmoon_state_01.m2", -- [3676]
			"void_rune_shadowmoon_state_02.m2", -- [3677]
			"void_rune_shadowmoon_state_03.m2", -- [3678]
			"void_shield_state_base.m2", -- [3679]
			"void_slash_impact_base.m2", -- [3680]
			"void_slice_state_base.m2", -- [3681]
			"void_spike_impact_base.m2", -- [3682]
			"void_summonpet_impact_base.m2", -- [3683]
			"void_summonpet_impact_base_smallshadow.m2", -- [3684]
			"void_sweepingstrikes_state_base.m2", -- [3685]
			"warlock_decimate_missile_v2.m2", -- [3686]
			"warlock_decimate_missile_v2_low.m2", -- [3687]
			"warlock_demonbolt_impact01.m2", -- [3688]
			"warlock_demonbolt_missile01.m2", -- [3689]
			"warlock_demonbolt_precast_base01.m2", -- [3690]
			"warlock_demonbolt_precast_hand_flame01.m2", -- [3691]
			"warlock_demonbolt_precast_hand_shadow01.m2", -- [3692]
			"warlock_handofguldan_state_02.m2", -- [3693]
			"warlock_incinerate_v2_fel.m2", -- [3694]
			"warrior_Ground_Rupture.m2", -- [3695]
			"warrior_shout_orc_impact.m2", -- [3696]
			"warrior_sweepingstrikes_arms.m2", -- [3697]
			"whack_a_gnoll_burst.M2", -- [3698]
			"xplosion_fire_impact_noflash_Fel.M2", -- [3699]
			"xplosion_fire_impact_noflash_Illidari.M2", -- [3700]
			"xplosion_fire_impact_noflash_Twilight.M2", -- [3701]
			"zone_shrapnel01.m2", -- [3702]
		},
		["N"] = "Spells",
	}, -- [10]
	{
		["T"] = {
			"IGC_CartTest.m2", -- [1]
			"guildFlagTest.M2", -- [2]
		},
		["N"] = "Test",
	}, -- [11]
	{
		["T"] = {
			{
				["T"] = {
					{
						["T"] = {
							"xyz.m2", -- [1]
						},
						["N"] = "Boxtest",
					}, -- [1]
					{
						["T"] = {
							"ShaderTest_01.m2", -- [1]
						},
						["N"] = "Shader",
					}, -- [2]
				},
				["N"] = "Arttest",
			}, -- [1]
			{
				["T"] = {
					{
						["T"] = {
							{
								["T"] = {
									{
										["T"] = {
											"BootyBayEntrance_02.m2", -- [1]
										},
										["N"] = "Bootyentrance",
									}, -- [1]
									{
										["T"] = {
											"FishDeadBlue.m2", -- [1]
											"FishDeadGreen.m2", -- [2]
											"FishDeadOrange.m2", -- [3]
											"FishDeadPurple.m2", -- [4]
											"FishFrenzyBlue.m2", -- [5]
											"FishFrenzyGreen.m2", -- [6]
											"FishRack.m2", -- [7]
										},
										["N"] = "Deadfish",
									}, -- [2]
									{
										["T"] = {
											"FishingBox.m2", -- [1]
										},
										["N"] = "Fishingbox",
									}, -- [3]
									{
										["T"] = {
											"FishingPole01.m2", -- [1]
											"FishingPole02.m2", -- [2]
										},
										["N"] = "Fishingpoles",
									}, -- [4]
									{
										["T"] = {
											"GoblinStatueBooty.m2", -- [1]
										},
										["N"] = "Goblinstatue",
									}, -- [5]
									{
										["T"] = {
											"Harpoon01.m2", -- [1]
										},
										["N"] = "Harpoons",
									}, -- [6]
									{
										["T"] = {
											"SharkModel01.m2", -- [1]
										},
										["N"] = "Sharkmodels",
									}, -- [7]
								},
								["N"] = "Passivedoodad",
							}, -- [1]
						},
						["N"] = "Bootybay",
					}, -- [1]
					{
						["T"] = {
							{
								["T"] = {
									{
										["T"] = {
											"DarkIronNode.M2", -- [1]
											"DarkIronNodeParticleRock.M2", -- [2]
										},
										["N"] = "Darkironnode",
									}, -- [1]
								},
								["N"] = "Activedoodads",
							}, -- [1]
							{
								["T"] = {
									{
										["T"] = {
											"DeadHeadBoar.m2", -- [1]
											"DeadHeadDeer.m2", -- [2]
										},
										["N"] = "Animalheads",
									}, -- [1]
									{
										["T"] = {
											"AshPeople01.m2", -- [1]
											"AshPeople02.m2", -- [2]
											"AshPeople03.m2", -- [3]
											"AshPeople04.m2", -- [4]
											"AshPeople05.m2", -- [5]
										},
										["N"] = "Ashpeople",
									}, -- [2]
									{
										["T"] = {
											"OrcBonFire.M2", -- [1]
											"OrcBonFireOff.m2", -- [2]
											"OrcBonFire_blue.m2", -- [3]
										},
										["N"] = "Bonfire",
									}, -- [3]
									{
										["T"] = {
											"BurningRopeBridge.M2", -- [1]
										},
										["N"] = "Bridges",
									}, -- [4]
									{
										["T"] = {
											"BurningGiantWheel.M2", -- [1]
										},
										["N"] = "Burninggiantwheel",
									}, -- [5]
									{
										["T"] = {
											"BurningSteppsCliffRock01.m2", -- [1]
											"BurningSteppsCliffRock02.m2", -- [2]
											"BurningSteppsCliffRock03.m2", -- [3]
											"BurningSteppsCliffRock04.m2", -- [4]
											"BurningSteppsCliffRock05.m2", -- [5]
											"BurningSteppsCliffRock06.m2", -- [6]
										},
										["N"] = "Cliffrocks",
									}, -- [6]
									{
										["T"] = {
											"FallingEmbers.M2", -- [1]
										},
										["N"] = "Fallingembers",
									}, -- [7]
									{
										["T"] = {
											"BurningSteppesFence.m2", -- [1]
											"BurningSteppesFenceChain.m2", -- [2]
											"BurningSteppesFencePost.m2", -- [3]
										},
										["N"] = "Fences",
									}, -- [8]
									{
										["T"] = {
											"LavaAltar.m2", -- [1]
										},
										["N"] = "Lavaaltar",
									}, -- [9]
									{
										["T"] = {
											"LavaBridge.m2", -- [1]
										},
										["N"] = "Lavabridge",
									}, -- [10]
									{
										["T"] = {
											"LavaFallsBlackRock01.M2", -- [1]
											"LavaFallsBlackRock03.m2", -- [2]
											"LavaFallsBlackRock04.m2", -- [3]
											"lavafallsblackrock02.M2", -- [4]
										},
										["N"] = "Lavafalls",
									}, -- [11]
									{
										["T"] = {
											"LavaPillar01.m2", -- [1]
											"LavaPillar02.m2", -- [2]
											"LavaPillar03.m2", -- [3]
											"LavaPillar04.m2", -- [4]
										},
										["N"] = "Lavapillar",
									}, -- [12]
									{
										["T"] = {
											"LavaPlug01.M2", -- [1]
											"LavaPlug02.M2", -- [2]
										},
										["N"] = "Lavaplugs",
									}, -- [13]
									{
										["T"] = {
											"LavaShrine01.m2", -- [1]
											"LavaShrine02.m2", -- [2]
											"LavaShrine03.m2", -- [3]
											"LavaShrine04.m2", -- [4]
											"SearingGorgeLavaShrine.M2", -- [5]
										},
										["N"] = "Lavashrine",
									}, -- [14]
									{
										["T"] = {
											"LotharStatue.M2", -- [1]
										},
										["N"] = "Lotharstatue",
									}, -- [15]
									{
										["T"] = {
											"OgreHeadPike.m2", -- [1]
										},
										["N"] = "Ogreheadpike",
									}, -- [16]
									{
										["T"] = {
											"OrcAnvilStoneBurningSteppes.m2", -- [1]
										},
										["N"] = "Orcanvilstoneburningsteppes",
									}, -- [17]
									{
										["T"] = {
											"OrcStoneBurialPyre.m2", -- [1]
											"OrcStoneBurialPyreBody.m2", -- [2]
										},
										["N"] = "Orcburialpyres",
									}, -- [18]
									{
										["T"] = {
											"OrcSmallFoundryPit.m2", -- [1]
										},
										["N"] = "Orcfoundrypit",
									}, -- [19]
									{
										["T"] = {
											"OrcSleepMat01.m2", -- [1]
											"OrcSleepMat02.m2", -- [2]
											"OrcSleepMat03.m2", -- [3]
										},
										["N"] = "Orcsleepmats",
									}, -- [20]
									{
										["T"] = {
											"OrcTent.m2", -- [1]
										},
										["N"] = "Orctents",
									}, -- [21]
									{
										["T"] = {
											"OrcToolRackBurningSteppes.m2", -- [1]
										},
										["N"] = "Orctoolrackburningsteppes",
									}, -- [22]
									{
										["T"] = {
											"PentagramDirt.m2", -- [1]
										},
										["N"] = "Pentagramdirt",
									}, -- [23]
									{
										["T"] = {
											"BurningSteppesBoulders01.m2", -- [1]
											"BurningSteppesBoulders02.m2", -- [2]
											"BurningSteppesBoulders03.m2", -- [3]
											"BurningSteppesBoulders04.m2", -- [4]
											"BurningSteppesBoulders05.m2", -- [5]
											"BurningSteppesBoulders06.m2", -- [6]
											"LavaRock01.M2", -- [7]
											"LavaRock02.m2", -- [8]
											"LavaRock03.m2", -- [9]
											"LavaRock04.m2", -- [10]
											"LavaRock05.m2", -- [11]
											"LavaRock06.m2", -- [12]
										},
										["N"] = "Rocks",
									}, -- [24]
									{
										["T"] = {
											"BurnedBeam.m2", -- [1]
										},
										["N"] = "Ruins",
									}, -- [25]
									{
										["T"] = {
											"SmeltingCauldron.m2", -- [1]
										},
										["N"] = "Smeltingcauldron",
									}, -- [26]
									{
										["T"] = {
											"SmeltingWeapons.m2", -- [1]
										},
										["N"] = "Smeltingweapons",
									}, -- [27]
									{
										["T"] = {
											"AshTreeSmoke01.m2", -- [1]
										},
										["N"] = "Smoke",
									}, -- [28]
									{
										["T"] = {
											"StoneBlock01.m2", -- [1]
											"StoneBlock02.m2", -- [2]
											"StoneBracket01.m2", -- [3]
											"StoneBracket02.m2", -- [4]
											"StoneBracket03.m2", -- [5]
										},
										["N"] = "Stonebrackets",
									}, -- [29]
									{
										["T"] = {
											"StoneGolemStatue1-9.m2", -- [1]
											"StoneGolemStatue2-9.m2", -- [2]
											"StoneGolemStatue3-9.m2", -- [3]
											"StoneGolemStatue4-9.m2", -- [4]
											"StoneGolemStatue5-9.m2", -- [5]
											"StoneGolemStatue6-9.m2", -- [6]
											"StoneGolemStatue7-9.m2", -- [7]
											"StoneGolemStatue8-9.m2", -- [8]
											"StoneGolemStatue9-9.m2", -- [9]
										},
										["N"] = "Stonegolemstatue",
									}, -- [30]
									{
										["T"] = {
											"AshTree01.M2", -- [1]
											"AshTree02.m2", -- [2]
											"AshTree03.m2", -- [3]
											"BurningMidTree01.m2", -- [4]
											"BurningMidTree02.M2", -- [5]
											"BurningMidTree03.m2", -- [6]
											"BurningMidTree04.m2", -- [7]
											"BurningSteppesTree01.m2", -- [8]
											"BurningSteppesTree02.m2", -- [9]
										},
										["N"] = "Trees",
									}, -- [31]
									{
										["T"] = {
											"VolcanicVentLarge01.M2", -- [1]
											"VolcanicVentLargeOff01.M2", -- [2]
											"VolcanicVentMed01.m2", -- [3]
											"VolcanicVentMedOff01.m2", -- [4]
											"VolcanicVentSmall01.M2", -- [5]
											"VolcanicVentSmallOff01.m2", -- [6]
										},
										["N"] = "Volcanicvents",
									}, -- [32]
									{
										["T"] = {
											"WarlockShrine.m2", -- [1]
										},
										["N"] = "Warlockshrine",
									}, -- [33]
								},
								["N"] = "Passivedoodads",
							}, -- [2]
						},
						["N"] = "Burningsteppes",
					}, -- [2]
					{
						["T"] = {
							{
								["T"] = {
									{
										["T"] = {
											"GoblinMeltingPot.M2", -- [1]
										},
										["N"] = "Goblinmeltingpot",
									}, -- [1]
									"LavaSink.m2", -- [2]
								},
								["N"] = "Passivedoodads",
							}, -- [1]
						},
						["N"] = "Deadmines",
					}, -- [3]
					{
						["T"] = {
							{
								["T"] = {
									{
										["T"] = {
											"AbandonedHumanGuardTower.m2", -- [1]
										},
										["N"] = "Abandonedguardtower",
									}, -- [1]
									{
										["T"] = {
											"DeadwindRockBridge.m2", -- [1]
										},
										["N"] = "Rockbridge",
									}, -- [2]
								},
								["N"] = "Buildings",
							}, -- [1]
							{
								["T"] = {
									{
										["T"] = {
											"DeadwindTotem01.m2", -- [1]
											"DeadwindTotem02.m2", -- [2]
											"DeadwindTotem03.m2", -- [3]
											"DeadwindTotem04.m2", -- [4]
										},
										["N"] = "Deadwindtotems",
									}, -- [1]
									{
										["T"] = {
											"DeadwindHangingBody01.m2", -- [1]
											"DeadwindHangingBody02.m2", -- [2]
										},
										["N"] = "Hangingbodies",
									}, -- [2]
									{
										["T"] = {
											"DeadwindHangingTree.m2", -- [1]
										},
										["N"] = "Hangingtree",
									}, -- [3]
									{
										["T"] = {
											"Kharazan_brick.M2", -- [1]
										},
										["N"] = "Kharazan_brick",
									}, -- [4]
									{
										["T"] = {
											"DeadwindPassCliffRock01DNR.m2", -- [1]
											"DeadwindPassCliffRock02DNR.m2", -- [2]
											"DeadwindPassCliffRock03DNR.m2", -- [3]
											"DeadwindPassCliffRock04DNR.m2", -- [4]
											"DeadwindPassCliffRock05DNR.m2", -- [5]
											"DeadwindPassGroundRock01DNR.m2", -- [6]
											"DeadwindPassGroundRock02DNR.m2", -- [7]
											"DeadwindPassGroundRock03DNR.m2", -- [8]
											"RockArch01DNR.m2", -- [9]
											"RockArch02DNR.m2", -- [10]
											"RockArch03DNR.m2", -- [11]
										},
										["N"] = "Rocks",
									}, -- [5]
									{
										["T"] = {
											"DeadWindPassRockTree04.m2", -- [1]
											"DeadWindPassRockTree05.m2", -- [2]
											"DeadWindPassRockTree06.m2", -- [3]
											"DeadwindPassRockTree01.M2", -- [4]
											"DeadwindPassRockTree02.m2", -- [5]
											"DeadwindPassRockTree03.m2", -- [6]
											"DeadwindPassRockTreeBroken01.m2", -- [7]
											"DeadwindPassRockTreeBroken02.m2", -- [8]
											"DeadwindPassRockTreeBroken03.m2", -- [9]
										},
										["N"] = "Rocktrees",
									}, -- [6]
									{
										["T"] = {
											"DeadwindPassRoot01.m2", -- [1]
										},
										["N"] = "Roots",
									}, -- [7]
									{
										["T"] = {
											"DeadwindPassMidTree01.M2", -- [1]
											"DeadwindPassMidTree02.M2", -- [2]
										},
										["N"] = "Trees",
									}, -- [8]
									{
										["T"] = {
											"DeadWindHangingWeedsGroup01.m2", -- [1]
											"DeadWindHangingWeedsGroup02.m2", -- [2]
											"DeadWindHangingWeedsGroup03.m2", -- [3]
											"DeadWindHangingWeedsLarge01.m2", -- [4]
											"DeadWindHangingWeedsLarge02.m2", -- [5]
											"DeadWindHangingWeedsSmall01.m2", -- [6]
											"DeadWindHangingWeedsSmall02.m2", -- [7]
											"DeadWindHangingWeedsSmall03.m2", -- [8]
											"DeadWindHangingWeedsSmall04.m2", -- [9]
										},
										["N"] = "Weeds",
									}, -- [9]
								},
								["N"] = "Passivedoodads",
							}, -- [2]
						},
						["N"] = "Deadwindpass",
					}, -- [4]
					{
						["T"] = {
							{
								["T"] = {
									{
										["T"] = {
											"GnollTent02.M2", -- [1]
											"GnollTent03.m2", -- [2]
										},
										["N"] = "Gnolltent",
									}, -- [1]
									{
										["T"] = {
											"GypsyWagon.M2", -- [1]
										},
										["N"] = "Gypsywagon",
									}, -- [2]
									{
										["T"] = {
											"Ogremound.m2", -- [1]
										},
										["N"] = "Ogremound",
									}, -- [3]
								},
								["N"] = "Buildings",
							}, -- [1]
							{
								["T"] = {
									{
										["T"] = {
											"Duskwood_Barn_Closed.m2", -- [1]
										},
										["N"] = "Barn",
									}, -- [1]
									{
										["T"] = {
											"DuskWoodSpookyBush02.m2", -- [1]
											"DuskWoodSpookybush01.m2", -- [2]
											"DuskwoodBush01.m2", -- [3]
											"DuskwoodBush02.m2", -- [4]
											"DuskwoodBush03.m2", -- [5]
											"DuskwoodBush04.m2", -- [6]
											"DuskwoodBush05.m2", -- [7]
											"DuskwoodBush06.m2", -- [8]
											"DuskwoodBush07.m2", -- [9]
											"DuskwoodSpookyBush03.m2", -- [10]
											"DuskwoodSpookyBush04.m2", -- [11]
											"Pumpkin01.M2", -- [12]
											"PumpkinPatch01.M2", -- [13]
										},
										["N"] = "Bush",
									}, -- [2]
									{
										["T"] = {
											"DuskwoodChasmBridge.m2", -- [1]
										},
										["N"] = "Chasmbridge",
									}, -- [3]
									{
										["T"] = {
											"Coffin.M2", -- [1]
										},
										["N"] = "Coffin",
									}, -- [4]
									{
										["T"] = {
											"CoffinLid.M2", -- [1]
										},
										["N"] = "Coffinlid",
									}, -- [5]
									{
										["T"] = {
											"DuskwoodCoveredBridge.M2", -- [1]
										},
										["N"] = "Coveredbridge",
									}, -- [6]
									{
										["T"] = {
											"DarkshireEntrance01.m2", -- [1]
										},
										["N"] = "Darkshireentrance",
									}, -- [7]
									{
										["T"] = {
											{
												["T"] = {
													"DuskwoodCatails01.m2", -- [1]
												},
												["N"] = "Duskwoodcatails01",
											}, -- [1]
											{
												["T"] = {
													"DuskwoodGrass01.m2", -- [1]
												},
												["N"] = "Duskwoodgrass01",
											}, -- [2]
											{
												["T"] = {
													"DuskwoodLillyPad01.M2", -- [1]
												},
												["N"] = "Duskwoodlillypad01",
											}, -- [3]
											{
												["T"] = {
													"DuskwoodMushroom01.M2", -- [1]
												},
												["N"] = "Duskwoodmushroom01",
											}, -- [4]
											{
												["T"] = {
													"DuskwoodSeaWeed01.m2", -- [1]
												},
												["N"] = "Duskwoodseaweed01",
											}, -- [5]
											{
												["T"] = {
													"DuskwoodThornBush01.m2", -- [1]
												},
												["N"] = "Duskwoodthornbush01",
											}, -- [6]
											{
												["T"] = {
													"DuskwoodThornBush02.m2", -- [1]
												},
												["N"] = "Duskwoodthornbush02",
											}, -- [7]
											{
												["T"] = {
													"DuskwoodVine01.m2", -- [1]
												},
												["N"] = "Duskwoodvine01",
											}, -- [8]
											{
												["T"] = {
													"DuskwoodVine02.m2", -- [1]
												},
												["N"] = "Duskwoodvine02",
											}, -- [9]
										},
										["N"] = "Detail",
									}, -- [8]
									{
										["T"] = {
											"BarnDuskwood.m2", -- [1]
										},
										["N"] = "Duskwoodbarn",
									}, -- [9]
									{
										["T"] = {
											"DuskwoodHayStack.M2", -- [1]
										},
										["N"] = "Duskwoodhaystack",
									}, -- [10]
									{
										["T"] = {
											"DuskwoodHayWagon.m2", -- [1]
										},
										["N"] = "Duskwoodhaywagon",
									}, -- [11]
									{
										["T"] = {
											"DuskwoodHearse.m2", -- [1]
										},
										["N"] = "Duskwoodhearse",
									}, -- [12]
									{
										["T"] = {
											"DuskScarecrow.m2", -- [1]
										},
										["N"] = "Duskwoodscarecrow",
									}, -- [13]
									{
										["T"] = {
											"DuskwoodStraw.m2", -- [1]
										},
										["N"] = "Duskwoodstraw",
									}, -- [14]
									{
										["T"] = {
											"DuskWoodWheat.m2", -- [1]
										},
										["N"] = "Duskwoodwheat",
									}, -- [15]
									{
										["T"] = {
											"Duskwood_human_farm_closed.m2", -- [1]
											"Duskwood_lumbermill.m2", -- [2]
										},
										["N"] = "Farm",
									}, -- [16]
									{
										["T"] = {
											"DuskWoodFenceBrokenSegment.m2", -- [1]
											"DuskWoodFencePost.m2", -- [2]
											"DuskWoodFenceSegment.m2", -- [3]
											"DuskWoodFenceSegment02.m2", -- [4]
											"DuskwoodFenceBottom.m2", -- [5]
											"DuskwoodFenceBottomBroken.m2", -- [6]
											"DuskwoodFenceRail.m2", -- [7]
											"DuskwoodFenceTop.m2", -- [8]
											"DuskwoodFenceTopBroken.m2", -- [9]
											"RockWallEnd.m2", -- [10]
											"RockWallRubble.m2", -- [11]
										},
										["N"] = "Fence",
									}, -- [17]
									{
										["T"] = {
											"Duskwood_Fountain_01.M2", -- [1]
										},
										["N"] = "Fountains",
									}, -- [18]
									{
										["T"] = {
											"DuskWoodGate01.m2", -- [1]
											"DuskWoodTallCemetaryGate.m2", -- [2]
										},
										["N"] = "Gates",
									}, -- [19]
									{
										["T"] = {
											"DuskWoodGraveFrame.M2", -- [1]
										},
										["N"] = "Graveframe",
									}, -- [20]
									{
										["T"] = {
											"CemetaryGate01.m2", -- [1]
											"GatePost.m2", -- [2]
											"GateSegment01.m2", -- [3]
											"GateSegment02.m2", -- [4]
											"GateSegment03.m2", -- [5]
										},
										["N"] = "Irongate",
									}, -- [21]
									{
										["T"] = {
											"DuskwoodMausoleum.m2", -- [1]
											"MausoleumActiveDoors.m2", -- [2]
										},
										["N"] = "Mausoleum",
									}, -- [22]
									{
										["T"] = {
											"DuskwoodBoulder01.m2", -- [1]
											"DuskwoodBoulder02.m2", -- [2]
											"DuskwoodBoulder03.m2", -- [3]
										},
										["N"] = "Rocks",
									}, -- [23]
									{
										["T"] = {
											"DuskwoodChimney01.m2", -- [1]
											"DuskwoodRuins01.m2", -- [2]
											"DuskwoodRuins02.m2", -- [3]
											"DuskwoodRuins03.m2", -- [4]
											"DuskwoodRuins04.m2", -- [5]
											"DuskwoodRuinsBeam.m2", -- [6]
											"DuskwoodRuinsBrick.m2", -- [7]
											"DuskwoodRuinsFoundation01.m2", -- [8]
											"DuskwoodRuinsFoundation02.m2", -- [9]
										},
										["N"] = "Ruins",
									}, -- [24]
									{
										["T"] = {
											"DuskwoodCS01.m2", -- [1]
											"DuskwoodCS02.m2", -- [2]
											"DuskwoodTreeSpookless01.M2", -- [3]
											"DuskwoodTreeSpookless02.M2", -- [4]
										},
										["N"] = "Spooklesstrees",
									}, -- [25]
									{
										["T"] = {
											"Duskwood_Stable.m2", -- [1]
										},
										["N"] = "Stable",
									}, -- [26]
									{
										["T"] = {
											"DuskWoodStoneFrameCorner.m2", -- [1]
											"DuskWoodStoneFrameLong.m2", -- [2]
											"DuskWoodStoneFrameShort.m2", -- [3]
										},
										["N"] = "Stoneframes",
									}, -- [27]
									{
										["T"] = {
											"DuskwoodStraw02.m2", -- [1]
										},
										["N"] = "Straw",
									}, -- [28]
									{
										["T"] = {
											"DirtMound01.M2", -- [1]
											"TombStone05.m2", -- [2]
											"TombStone06.m2", -- [3]
											"TombStone07.m2", -- [4]
											"TombStone08.m2", -- [5]
											"TombStoneMonument01.m2", -- [6]
											"TombStoneMonument02.m2", -- [7]
											"WoodCross01.m2", -- [8]
											"WoodCross02.M2", -- [9]
										},
										["N"] = "Tombs",
									}, -- [29]
									{
										["T"] = {
											"DuskWoodFallenTree.m2", -- [1]
											"DuskWoodFallenTree02.m2", -- [2]
											"DuskwoodBrownTree.M2", -- [3]
											"DuskwoodSpookyTree01.m2", -- [4]
											"DuskwoodSpookyTree02.m2", -- [5]
											"DuskwoodSpookyTree03.m2", -- [6]
											"DuskwoodTree06.M2", -- [7]
											"DuskwoodTree07.M2", -- [8]
											"DuskwoodTreeCanopy01.M2", -- [9]
											"DuskwoodTreeCanopy02.M2", -- [10]
											"DuskwoodTreeCanopy03.m2", -- [11]
											"DuskwoodTreeStump01.m2", -- [12]
											"DuskwoodTreeStump02.m2", -- [13]
											"DuskwoodWhiteTree.M2", -- [14]
											"Duskwoodtree05.m2", -- [15]
											"NewDuskwoodTreeHuge.m2", -- [16]
										},
										["N"] = "Trees",
									}, -- [30]
									{
										["T"] = {
											"DuskWoodRockWall.m2", -- [1]
										},
										["N"] = "Walls",
									}, -- [31]
									{
										["T"] = {
											"WarningTree.m2", -- [1]
										},
										["N"] = "Warningtree",
									}, -- [32]
									{
										["T"] = {
											"DuskwoodWarpGate.m2", -- [1]
										},
										["N"] = "Warpgate",
									}, -- [33]
									{
										["T"] = {
											"WebDangle01.m2", -- [1]
											"WebDangle02.m2", -- [2]
											"WebStretch01.m2", -- [3]
										},
										["N"] = "Webs",
									}, -- [34]
								},
								["N"] = "Passivedoodads",
							}, -- [2]
						},
						["N"] = "Duskwood",
					}, -- [5]
					{
						["T"] = {
							{
								["T"] = {
									{
										["T"] = {
											"nsabbeyBell.m2", -- [1]
										},
										["N"] = "Abbeybell",
									}, -- [1]
								},
								["N"] = "Activedoodads",
							}, -- [1]
							{
								["T"] = {
									{
										["T"] = {
											"BlackSmith.m2", -- [1]
										},
										["N"] = "Blacksmith",
									}, -- [1]
									{
										["T"] = {
											"ElwynnFootbridge.m2", -- [1]
										},
										["N"] = "Bridges",
									}, -- [2]
									{
										["T"] = {
											"Distillery.M2", -- [1]
										},
										["N"] = "Distillery",
									}, -- [3]
									{
										["T"] = {
											"GoldmineTrackCurve.M2", -- [1]
											"GoldmineTracks.M2", -- [2]
											"goldmine.m2", -- [3]
										},
										["N"] = "Goldmine",
									}, -- [4]
									{
										["T"] = {
											"HumanGuardTower.M2", -- [1]
										},
										["N"] = "Humanguardtower",
									}, -- [5]
									{
										["T"] = {
											"HumanWatchTower.m2", -- [1]
										},
										["N"] = "Humanwatchtower",
									}, -- [6]
									{
										["T"] = {
											"StormwindGate.m2", -- [1]
										},
										["N"] = "Stormwindentrance",
									}, -- [7]
								},
								["N"] = "Buildings",
							}, -- [2]
							{
								["T"] = {
									{
										["T"] = {
											"Anvil.m2", -- [1]
										},
										["N"] = "Anvil",
									}, -- [1]
									{
										["T"] = {
											"Ballista.M2", -- [1]
										},
										["N"] = "Ballista",
									}, -- [2]
									{
										["T"] = {
											"BallistaRuined.M2", -- [1]
										},
										["N"] = "Ballistaruined",
									}, -- [3]
									{
										["T"] = {
											"BattleGladeBanner1.m2", -- [1]
										},
										["N"] = "Battlegladebanner1",
									}, -- [4]
									{
										["T"] = {
											"BattleGladeBanner2.m2", -- [1]
										},
										["N"] = "Battlegladebanner2",
									}, -- [5]
									{
										["T"] = {
											"BattleGladePolearmSkull.m2", -- [1]
										},
										["N"] = "Battlegladepolearmskull",
									}, -- [6]
									{
										["T"] = {
											"BattleGladeShield1.m2", -- [1]
										},
										["N"] = "Battlegladeshield1",
									}, -- [7]
									{
										["T"] = {
											"BattleGladeShield2.m2", -- [1]
										},
										["N"] = "Battlegladeshield2",
									}, -- [8]
									{
										["T"] = {
											"BattleGladeShield3.m2", -- [1]
										},
										["N"] = "Battlegladeshield3",
									}, -- [9]
									{
										["T"] = {
											"BattleGladeSkullHuman1.m2", -- [1]
										},
										["N"] = "Battlegladeskullhuman1",
									}, -- [10]
									{
										["T"] = {
											"BattleGladeSkullHuman2.m2", -- [1]
										},
										["N"] = "Battlegladeskullhuman2",
									}, -- [11]
									{
										["T"] = {
											"BattleGladeSkullOrc1.m2", -- [1]
										},
										["N"] = "Battlegladeskullorc1",
									}, -- [12]
									{
										["T"] = {
											"BattleGladeSkullOrc2.m2", -- [1]
										},
										["N"] = "Battlegladeskullorc2",
									}, -- [13]
									{
										["T"] = {
											"BattleGladeSword.m2", -- [1]
										},
										["N"] = "Battlegladesword",
									}, -- [14]
									{
										["T"] = {
											"BattleGladeSwordSkull.m2", -- [1]
										},
										["N"] = "Battlegladeswordskull",
									}, -- [15]
									{
										["T"] = {
											"BattleGladeWoodSpikes.m2", -- [1]
										},
										["N"] = "Battlegladewoodspikes",
									}, -- [16]
									{
										["T"] = {
											"Bellow.m2", -- [1]
										},
										["N"] = "Bellow",
									}, -- [17]
									{
										["T"] = {
											"ElwynnBush01.m2", -- [1]
											"ElwynnBush02.m2", -- [2]
											"ElwynnBush03.m2", -- [3]
											"ElwynnBush04.m2", -- [4]
											"ElwynnBush05.m2", -- [5]
											"ElwynnBush06.m2", -- [6]
											"ElwynnBush07.m2", -- [7]
											"ElwynnBush08.m2", -- [8]
											"ElwynnBush09.m2", -- [9]
										},
										["N"] = "Bush",
									}, -- [18]
									{
										["T"] = {
											"ElwynnCampfire.M2", -- [1]
											"ElwynnCampfire_blue.M2", -- [2]
										},
										["N"] = "Campfire",
									}, -- [19]
									{
										["T"] = {
											"Catapult.M2", -- [1]
										},
										["N"] = "Catapult",
									}, -- [20]
									{
										["T"] = {
											"ElwynnCliffRock01.M2", -- [1]
											"ElwynnCliffRock02.m2", -- [2]
											"ElwynnCliffRock03.m2", -- [3]
											"ElwynnCliffRock04.m2", -- [4]
											"ElwynnCliffRock05.m2", -- [5]
										},
										["N"] = "Cliffrocks",
									}, -- [21]
									{
										["T"] = {
											"CornCropLowPoly.m2", -- [1]
											"CornCropRow.m2", -- [2]
											"CornCropRowLowPoly01.m2", -- [3]
											"CornCropRowLowPoly02.m2", -- [4]
											"corn.m2", -- [5]
											"corncrop1.m2", -- [6]
											"corncrop2.m2", -- [7]
											"corncrop3.m2", -- [8]
											"corncropdead.m2", -- [9]
										},
										["N"] = "Corncrop",
									}, -- [22]
									{
										["T"] = {
											{
												["T"] = {
													"ElwynnCatails01.m2", -- [1]
												},
												["N"] = "Elwynncatails01",
											}, -- [1]
											{
												["T"] = {
													"ElwynnCatails02.m2", -- [1]
												},
												["N"] = "Elwynncatails02",
											}, -- [2]
											{
												["T"] = {
													"ElwynnDetailFlowers01.m2", -- [1]
													"ElwynnDetailFlowers02.m2", -- [2]
												},
												["N"] = "Elwynndetailflowers",
											}, -- [3]
											{
												["T"] = {
													"ElwynnDetailGrass01.m2", -- [1]
													"ElwynnDetailGrass02.m2", -- [2]
													"ElwynnDetailGrass03.m2", -- [3]
													"ElwynnDetailGrass04.m2", -- [4]
												},
												["N"] = "Elwynndetailgrass",
											}, -- [4]
											{
												["T"] = {
													"ElwynnDetailRock01.m2", -- [1]
													"ElwynnDetailRock02.m2", -- [2]
												},
												["N"] = "Elwynndetailrocks",
											}, -- [5]
											{
												["T"] = {
													"ElwynnGrass02.m2", -- [1]
												},
												["N"] = "Elwynngrass02",
											}, -- [6]
											{
												["T"] = {
													"ElwynnGrass1.m2", -- [1]
												},
												["N"] = "Elwynngrass1",
											}, -- [7]
											{
												["T"] = {
													"ElwynnLillyPad01.M2", -- [1]
												},
												["N"] = "Elwynnlillypad01",
											}, -- [8]
											{
												["T"] = {
													"ElwynnMushroom01.M2", -- [1]
												},
												["N"] = "Elwynnmushroom01",
											}, -- [9]
											{
												["T"] = {
													"ElwynnPoppy1.m2", -- [1]
												},
												["N"] = "Elwynnpoppy1",
											}, -- [10]
											{
												["T"] = {
													"ElwynnPoppy2.m2", -- [1]
												},
												["N"] = "Elwynnpoppy2",
											}, -- [11]
											{
												["T"] = {
													"ElwynnReeds01.m2", -- [1]
												},
												["N"] = "Elwynnreeds01",
											}, -- [12]
											{
												["T"] = {
													"ElwynnRock1.m2", -- [1]
												},
												["N"] = "Elwynnrock1",
											}, -- [13]
											{
												["T"] = {
													"ElwynnRock2.m2", -- [1]
												},
												["N"] = "Elwynnrock2",
											}, -- [14]
											{
												["T"] = {
													"ElwynnSeaWeed01.m2", -- [1]
												},
												["N"] = "Elwynnseaweed01",
											}, -- [15]
											{
												["T"] = {
													"ElwynnShrub1.m2", -- [1]
												},
												["N"] = "Elwynnshrub1",
											}, -- [16]
											{
												["T"] = {
													"ElwynnThornBush01.m2", -- [1]
												},
												["N"] = "Elwynnthornbush01",
											}, -- [17]
											{
												["T"] = {
													"ElwynnThornBush02.m2", -- [1]
												},
												["N"] = "Elwynnthornbush02",
											}, -- [18]
											{
												["T"] = {
													"ElwynnVines01.m2", -- [1]
												},
												["N"] = "Elwynnvines01",
											}, -- [19]
											{
												["T"] = {
													"ElwynnVines02.m2", -- [1]
												},
												["N"] = "Elwynnvines02",
											}, -- [20]
											{
												["T"] = {
													"ElwynnVineyard01.m2", -- [1]
												},
												["N"] = "Elwynnvineyard",
											}, -- [21]
											{
												["T"] = {
													"ElwynnWheat01.m2", -- [1]
												},
												["N"] = "Elwynnwheat",
											}, -- [22]
											"ElwynnFlower01.m2", -- [23]
											"ElwynnFlower02.m2", -- [24]
											"ElwynnGrass01.m2", -- [25]
											"ElwynnMelon01.m2", -- [26]
										},
										["N"] = "Detail",
									}, -- [23]
									{
										["T"] = {
											"ElwynnFenceSimple.m2", -- [1]
											"ElwynnFenceSimplePost.m2", -- [2]
											"ElwynnFenceTop.m2", -- [3]
											"ElwynnStoneFence.m2", -- [4]
											"ElwynnStoneFencePost.m2", -- [5]
											"ElwynnWoodFence01.m2", -- [6]
											"ElwynnWoodPost01.m2", -- [7]
										},
										["N"] = "Elwynnfences",
									}, -- [24]
									{
										["T"] = {
											"EyeOfAzora.M2", -- [1]
										},
										["N"] = "Eyeofazora",
									}, -- [25]
									{
										["T"] = {
											"GrapeBucket01.m2", -- [1]
											"GrapeBucket02.m2", -- [2]
										},
										["N"] = "Grapebuckets",
									}, -- [26]
									{
										["T"] = {
											"haystack01.m2", -- [1]
											"haystack02.m2", -- [2]
										},
										["N"] = "Haystacks",
									}, -- [27]
									{
										["T"] = {
											"Jar01.m2", -- [1]
											"Jar02.m2", -- [2]
											"Jar03.m2", -- [3]
										},
										["N"] = "Jars",
									}, -- [28]
									{
										["T"] = {
											"jug01.m2", -- [1]
											"jug02.M2", -- [2]
										},
										["N"] = "Jugs",
									}, -- [29]
									{
										["T"] = {
											"LampPost.M2", -- [1]
										},
										["N"] = "Lamppost",
									}, -- [30]
									{
										["T"] = {
											"ElwynnMineCart.m2", -- [1]
										},
										["N"] = "Minecart",
									}, -- [31]
									{
										["T"] = {
											"MonumentRock.m2", -- [1]
										},
										["N"] = "Monumentrock",
									}, -- [32]
									{
										["T"] = {
											"Pick.m2", -- [1]
										},
										["N"] = "Pick",
									}, -- [33]
									{
										["T"] = {
											"RuinedCatapult.m2", -- [1]
										},
										["N"] = "Ruinedcatapult",
									}, -- [34]
									{
										["T"] = {
											"RuinedFountain.m2", -- [1]
										},
										["N"] = "Ruinedfountain",
									}, -- [35]
									{
										["T"] = {
											"Shovel.M2", -- [1]
										},
										["N"] = "Shovel",
									}, -- [36]
									{
										["T"] = {
											{
												["T"] = {
													"Duskwooddirectionalsign.m2", -- [1]
													"Goldshiredirectionalsign.m2", -- [2]
													"Northshiredirectionalsign.m2", -- [3]
													"Runestonedirectionalsign.m2", -- [4]
													"Stormwinddirectionalsign.m2", -- [5]
													"Westfalldirectionalsign.m2", -- [6]
												},
												["N"] = "Directional",
											}, -- [1]
											{
												["T"] = {
													"GenericSmallSignPost01.m2", -- [1]
												},
												["N"] = "Genericposts",
											}, -- [2]
											{
												["T"] = {
													"HumanAlchemistSign.m2", -- [1]
													"HumanBaitandTackleSign.m2", -- [2]
													"HumanBankSign.m2", -- [3]
													"HumanBlacksmithSign.m2", -- [4]
													"HumanBoathouseSign.m2", -- [5]
													"HumanInnSign.m2", -- [6]
													"HumanInnSignPost.m2", -- [7]
													"HumanMagicshopSign.m2", -- [8]
													"HumanTannerSign.m2", -- [9]
												},
												["N"] = "Shop",
											}, -- [3]
										},
										["N"] = "Signs",
									}, -- [37]
									{
										["T"] = {
											"BattleGladeSkullHumanDark.M2", -- [1]
											"BattleGladeSpineHumanDark.m2", -- [2]
											"BattleGladebonesHumanDark.m2", -- [3]
											"BattleGladebskeletonhumandark.m2", -- [4]
										},
										["N"] = "Skeleton",
									}, -- [38]
									{
										["T"] = {
											"SmallDock.m2", -- [1]
										},
										["N"] = "Smalldock",
									}, -- [39]
									{
										["T"] = {
											"Spike.m2", -- [1]
										},
										["N"] = "Spike",
									}, -- [40]
									{
										["T"] = {
											"LionStatue.M2", -- [1]
										},
										["N"] = "Statue",
									}, -- [41]
									{
										["T"] = {
											"StonePyre.m2", -- [1]
										},
										["N"] = "Stonepyre",
									}, -- [42]
									{
										["T"] = {
											{
												["T"] = {
													"RoundTable.m2", -- [1]
												},
												["N"] = "Roundtable",
											}, -- [1]
										},
										["N"] = "Tables",
									}, -- [43]
									{
										["T"] = {
											"ElwynnLog01.m2", -- [1]
											"ElwynnLog02.m2", -- [2]
										},
										["N"] = "Tree",
									}, -- [44]
									{
										["T"] = {
											{
												["T"] = {
													"ElwynnPine01.m2", -- [1]
													"ElwynnPine02.m2", -- [2]
												},
												["N"] = "Elwynntree01",
											}, -- [1]
											{
												["T"] = {
													"ElwynnTreeStump01.m2", -- [1]
													"ElwynnTreeStump02.m2", -- [2]
												},
												["N"] = "Stumps",
											}, -- [2]
											"CanopylessTree01.M2", -- [3]
											"CanopylessTree02.m2", -- [4]
											"CanopylessTree03.m2", -- [5]
											"CanopylessTree04.m2", -- [6]
											"ElwynnFirTree01.m2", -- [7]
											"ElwynnTreeCanopy01.M2", -- [8]
											"ElwynnTreeCanopy02.M2", -- [9]
											"ElwynnTreeCanopy03.M2", -- [10]
											"ElwynnTreeCanopy04.M2", -- [11]
											"ElwynnTreeMid01.m2", -- [12]
										},
										["N"] = "Trees",
									}, -- [45]
									{
										["T"] = {
											"Vineyard.m2", -- [1]
											"VineyardCube01.m2", -- [2]
											"VineyardCube02.m2", -- [3]
											"VineyardLowpoly.m2", -- [4]
											"VineyardWired.m2", -- [5]
										},
										["N"] = "Vineyard",
									}, -- [46]
									{
										["T"] = {
											"WaterBasin.M2", -- [1]
										},
										["N"] = "Waterbasin",
									}, -- [47]
									{
										["T"] = {
											"ElwynnMediumWaterfall01.M2", -- [1]
											"ElwynnTallWaterfall01.M2", -- [2]
										},
										["N"] = "Waterfall",
									}, -- [48]
								},
								["N"] = "Passivedoodads",
							}, -- [3]
						},
						["N"] = "Elwynn",
					}, -- [6]
					{
						["T"] = {
							{
								["T"] = {
									"KarazahnPortcullis.m2", -- [1]
									"Karazahn_CptnQrtzDoors.m2", -- [2]
									"Karazahn_SecretDoor.m2", -- [3]
									"Karazahn_SecretDoor01.m2", -- [4]
									"Karazahn_bridgedoors.m2", -- [5]
									"Karazahn_chessroomdoors.m2", -- [6]
									"Karazahn_diningDoors.m2", -- [7]
									"Karazahn_diningruinDoor.m2", -- [8]
									"Karazahn_gatedoors.m2", -- [9]
									"Karazahn_secretroomDoor.m2", -- [10]
									"Karazahn_silverrmDoor01.m2", -- [11]
									"Karazahn_silverrmDoor02.m2", -- [12]
									"Karazahn_stageDoor.m2", -- [13]
									"Karazhan_Red_Curtain.m2", -- [14]
									"karazhan_observe_door.m2", -- [15]
								},
								["N"] = "Activedoodads",
							}, -- [1]
							{
								["T"] = {
									{
										["T"] = {
											"KarazahnBarrel01.m2", -- [1]
											"KarazahnBarrel02.m2", -- [2]
										},
										["N"] = "Barrel",
									}, -- [1]
									{
										["T"] = {
											"KarazahnBonFire01.m2", -- [1]
											"KarazahnBonFire02.m2", -- [2]
											"KarazahnBonFireBlue01.m2", -- [3]
										},
										["N"] = "Bonfire",
									}, -- [2]
									{
										["T"] = {
											"KarazahnBookshelfLarge.M2", -- [1]
											"KarazahnBookshelfSmall.M2", -- [2]
											"KarazahnBookshelfXtralarge.m2", -- [3]
										},
										["N"] = "Bookshelves",
									}, -- [3]
									{
										["T"] = {
											"KN_BrokenCart.m2", -- [1]
											"KN_BrokenCart02.m2", -- [2]
										},
										["N"] = "Brokencart",
									}, -- [4]
									{
										["T"] = {
											"BooksOnFire.M2", -- [1]
										},
										["N"] = "Burningbooks",
									}, -- [5]
									{
										["T"] = {
											"KarazanChandelier_01.m2", -- [1]
											"KarazanChandelier_02.m2", -- [2]
											"KarazanChandelier_03.m2", -- [3]
											"KarazanChandelier_03_broken.m2", -- [4]
										},
										["N"] = "Chandeliers",
									}, -- [6]
									{
										["T"] = {
											"KarazahnCrate01.m2", -- [1]
											"KarazahnCrate02.m2", -- [2]
										},
										["N"] = "Crates",
									}, -- [7]
									{
										["T"] = {
											"KN_GrainSack01.m2", -- [1]
											"KN_GrainSack02.m2", -- [2]
											"KN_GrainSack03.m2", -- [3]
											"KN_SpilledSack01.m2", -- [4]
										},
										["N"] = "Grainsacks",
									}, -- [8]
									{
										["T"] = {
											"KarazahnWeb01.m2", -- [1]
											"KarazahnWeb02.m2", -- [2]
											"KarazahnWeb03.m2", -- [3]
										},
										["N"] = "Karazahnwebs",
									}, -- [9]
									{
										["T"] = {
											"Karazahn_owlstatue.M2", -- [1]
										},
										["N"] = "Owlstatue",
									}, -- [10]
									{
										["T"] = {
											"KarazahnPedestals01.m2", -- [1]
											"KarazahnPedestals02.m2", -- [2]
										},
										["N"] = "Pedestals",
									}, -- [11]
									{
										["T"] = {
											"KarazahnRockRubble01.m2", -- [1]
											"KarazahnRockRubble02.m2", -- [2]
											"Karazahn_Rubble_Floating.m2", -- [3]
										},
										["N"] = "Rubble",
									}, -- [12]
									{
										["T"] = {
											"KarazahnSconce01.m2", -- [1]
											"KarazahnSconce02.m2", -- [2]
											"KarazahnSconce03.m2", -- [3]
											"KarazahnSconce04.m2", -- [4]
											"KarazahnSconce05.m2", -- [5]
											"KarazahnSconce06.m2", -- [6]
											"KarazahnSconce07.m2", -- [7]
										},
										["N"] = "Sconces",
									}, -- [13]
									{
										["T"] = {
											"KarazahnStarlab.m2", -- [1]
										},
										["N"] = "Starlab",
									}, -- [14]
									{
										["T"] = {
											"KarazahnTableBig.m2", -- [1]
											"KarazahnTableSmall.m2", -- [2]
										},
										["N"] = "Tables",
									}, -- [15]
									{
										["T"] = {
											"KarazanTapestry01.m2", -- [1]
											"KarazanTapestry02.m2", -- [2]
										},
										["N"] = "Tapestries",
									}, -- [16]
									{
										["T"] = {
											"Karazahn_RJ_Balcony.m2", -- [1]
											"Karazahn_RJ_Moon.m2", -- [2]
											"Karazahn_RJ_Stars.m2", -- [3]
											"Karazahn_RRH_Forest.m2", -- [4]
											"Karazahn_RRH_House.m2", -- [5]
											"Karazahn_RRH_Tree.m2", -- [6]
											"Karazahn_WO_Hay.m2", -- [7]
											"Karazan_WO_BrickRoad.m2", -- [8]
										},
										["N"] = "Theater",
									}, -- [17]
									{
										["T"] = {
											"KarazahnThrone01.M2", -- [1]
										},
										["N"] = "Throne",
									}, -- [18]
								},
								["N"] = "Passivedoodads",
							}, -- [2]
						},
						["N"] = "Karazahn",
					}, -- [7]
					{
						["T"] = {
							{
								["T"] = {
									{
										["T"] = {
											"pvp_bridge_parts01.m2", -- [1]
											"pvp_bridge_parts02.m2", -- [2]
											"pvp_bridge_parts03.m2", -- [3]
											"pvp_bridge_parts04.m2", -- [4]
											"pvp_bridge_parts05.m2", -- [5]
										},
										["N"] = "Bridgeruins",
									}, -- [1]
								},
								["N"] = "Passivedoodads",
							}, -- [1]
						},
						["N"] = "Pvp",
					}, -- [8]
					{
						["T"] = {
							{
								["T"] = {
									{
										["T"] = {
											"RedRidge_Barn_Closed.m2", -- [1]
										},
										["N"] = "Barn",
									}, -- [1]
									{
										["T"] = {
											"RedRidgeBridgeBrick01.m2", -- [1]
											"RedRidgeBridgeBrick02.m2", -- [2]
											"RedRidgeBridgeBrick03.m2", -- [3]
										},
										["N"] = "Bricks",
									}, -- [2]
									{
										["T"] = {
											"RedridgeBush01.m2", -- [1]
											"RedridgeBush02.m2", -- [2]
											"RedridgeBush03.m2", -- [3]
										},
										["N"] = "Bush",
									}, -- [3]
									{
										["T"] = {
											{
												["T"] = {
													"catailpatch01.m2", -- [1]
												},
												["N"] = "Catailpatch",
											}, -- [1]
										},
										["N"] = "Detail",
									}, -- [4]
									{
										["T"] = {
											"RedRidgeDocksBeam01.m2", -- [1]
											"RedRidgeDocksBoardwalk01.m2", -- [2]
											"RedRidgeDocksPlank01.m2", -- [3]
											"RedRidgeDocksPylon01.m2", -- [4]
											"RedRidgeDocksboardwalk02.m2", -- [5]
											"RedRidgeDocksboardwalk03.m2", -- [6]
										},
										["N"] = "Dockpieces",
									}, -- [5]
									{
										["T"] = {
											"RedRidgeDocks01.m2", -- [1]
											"RedRidgeDocks03.m2", -- [2]
										},
										["N"] = "Docks",
									}, -- [6]
									{
										["T"] = {
											"RedRidge_human_farm_closed.m2", -- [1]
										},
										["N"] = "Farm",
									}, -- [7]
									{
										["T"] = {
											"RedRidge_lumbermill.m2", -- [1]
										},
										["N"] = "Lumbermill",
									}, -- [8]
									{
										["T"] = {
											"InsectMound.m2", -- [1]
										},
										["N"] = "Misc",
									}, -- [9]
									{
										["T"] = {
											"RedridgeRock01.m2", -- [1]
											"RedridgeRock02.m2", -- [2]
											"RedridgeRock03.m2", -- [3]
										},
										["N"] = "Rocks",
									}, -- [10]
									{
										["T"] = {
											"RowBoat01.m2", -- [1]
										},
										["N"] = "Rowboat",
									}, -- [11]
									{
										["T"] = {
											"BattleGladeWoodSpikesLongRow.M2", -- [1]
											"BattleGladeWoodSpikesShortRow.m2", -- [2]
										},
										["N"] = "Spikewall",
									}, -- [12]
									{
										["T"] = {
											"RedRidge_Stable.m2", -- [1]
										},
										["N"] = "Stable",
									}, -- [13]
									{
										["T"] = {
											"RedridgeStump02.M2", -- [1]
										},
										["N"] = "Stumps",
									}, -- [14]
									{
										["T"] = {
											"RedRidgeFallenTree01.m2", -- [1]
											"RedRidgeFallenTree01Moss.m2", -- [2]
											"RedRidgeFallenTree02.m2", -- [3]
											"RedRidgeFallenTree02Moss.m2", -- [4]
											"RedRidgeFallenTree03.m2", -- [5]
											"RedridgeTree01.m2", -- [6]
											"RedridgeTree02.m2", -- [7]
											"RedridgeTreeCanopy01.M2", -- [8]
											"RedridgeTreeCanopy02.M2", -- [9]
											"RedridgeTreeCanopy03.M2", -- [10]
											"RedridgeTreeCanopy04.M2", -- [11]
											"RedridgeTreeMid01.M2", -- [12]
											"RedridgeTreeStump01.M2", -- [13]
										},
										["N"] = "Trees",
									}, -- [15]
								},
								["N"] = "Passivedoodads",
							}, -- [1]
						},
						["N"] = "Redridge",
					}, -- [9]
					{
						["T"] = {
							{
								["T"] = {
									{
										["T"] = {
											"Cage01.m2", -- [1]
											"Cage02.m2", -- [2]
											"Cage03.m2", -- [3]
										},
										["N"] = "Cages",
									}, -- [1]
									{
										["T"] = {
											"HoldingPen.m2", -- [1]
										},
										["N"] = "Holdingpen",
									}, -- [2]
								},
								["N"] = "Activedoodads",
							}, -- [1]
							{
								["T"] = {
									{
										["T"] = {
											"CrashZeppelin.m2", -- [1]
										},
										["N"] = "Crashzeppelin",
									}, -- [1]
									{
										["T"] = {
											"OilRig.m2", -- [1]
										},
										["N"] = "Oilrig",
									}, -- [2]
									{
										["T"] = {
											"RuneStoneMoss_01.M2", -- [1]
										},
										["N"] = "Runestonemoss_01",
									}, -- [3]
									{
										["T"] = {
											"TrollWatchTower.M2", -- [1]
										},
										["N"] = "Trollwatchtower",
									}, -- [4]
								},
								["N"] = "Buildings",
							}, -- [2]
							{
								["T"] = {
									{
										["T"] = {
											"aquaductstone_corner1.m2", -- [1]
											"aquaductstone_corner2.m2", -- [2]
											"aquaductstone_longpillar.m2", -- [3]
											"aquaductstone_pillar1.m2", -- [4]
											"aquaductstone_pillar2.m2", -- [5]
											"aquaductstone_pillar3.m2", -- [6]
											"aquaductstone_short.m2", -- [7]
											"aquaductstone_straight.m2", -- [8]
											"aquaductstone_straight6.m2", -- [9]
										},
										["N"] = "Aquaduct",
									}, -- [1]
									{
										["T"] = {
											"JaguarStatue.m2", -- [1]
											"RopeBridge.m2", -- [2]
											"StonebridgeLong.m2", -- [3]
											"StonebridgeShort.m2", -- [4]
											"StrangleChasmBridge.m2", -- [5]
										},
										["N"] = "Bridge",
									}, -- [2]
									{
										["T"] = {
											"CrystallizedHuman01.m2", -- [1]
											"CrystallizedHuman02.m2", -- [2]
											"CrystallizedHuman03.m2", -- [3]
											"CrystallizedTroll01.m2", -- [4]
											"CrystallizedTroll02.m2", -- [5]
											"CrystallizedTroll03.m2", -- [6]
										},
										["N"] = "Crystalcreatures",
									}, -- [3]
									{
										["T"] = {
											"StranglePlant06.M2", -- [1]
											"StranglePlant07.m2", -- [2]
											"StranglePlant08.M2", -- [3]
											"StranglePlant09.m2", -- [4]
											"StranglePlant10.m2", -- [5]
											"StrangleThornFern01.m2", -- [6]
											"StrangleThornFern05.m2", -- [7]
											"StrangleThornFern06.m2", -- [8]
											"StrangleThornPlant01.m2", -- [9]
											"StrangleThornPlant02.m2", -- [10]
											"StrangleThornPlant05.m2", -- [11]
											"StranglethornFern02.m2", -- [12]
											"StranglethornFern03.m2", -- [13]
											"StranglethornFern04.m2", -- [14]
											"StranglethornPlant03.m2", -- [15]
											"StranglethornPlant04.m2", -- [16]
										},
										["N"] = "Detail",
									}, -- [4]
									{
										["T"] = {
											"DiamondMineWallLantern.m2", -- [1]
										},
										["N"] = "Diamondminewalllantern",
									}, -- [5]
									{
										["T"] = {
											"GemMineCar01.m2", -- [1]
										},
										["N"] = "Gemminecar01",
									}, -- [6]
									{
										["T"] = {
											"GemMineCar02.m2", -- [1]
											"GemMineCar03.m2", -- [2]
										},
										["N"] = "Gemminecar02",
									}, -- [7]
									{
										["T"] = {
											"HolySpringWell.m2", -- [1]
										},
										["N"] = "Holyspringwell",
									}, -- [8]
									{
										["T"] = {
											"Mine_Cart_Anim01.M2", -- [1]
										},
										["N"] = "Mine_cart_anim01",
									}, -- [9]
									{
										["T"] = {
											"OverGrowth02.m2", -- [1]
										},
										["N"] = "Overgrowth02",
									}, -- [10]
									{
										["T"] = {
											"BootyBayPost.m2", -- [1]
										},
										["N"] = "Post",
									}, -- [11]
									{
										["T"] = {
											"StranglethornCliffRock01.m2", -- [1]
											"StranglethornCliffRock02.m2", -- [2]
											"StranglethornCliffRock03.m2", -- [3]
										},
										["N"] = "Rocks",
									}, -- [12]
									{
										["T"] = {
											"StranglethornRuins01.m2", -- [1]
											"StranglethornRuins02.m2", -- [2]
											"StranglethornRuins03.m2", -- [3]
											"StranglethornRuins04.m2", -- [4]
											"StranglethornRuins05.m2", -- [5]
											"StranglethornRuins06.M2", -- [6]
											"StranglethornRuins07.m2", -- [7]
											"StranglethornRuins08.m2", -- [8]
											"StranglethornRuins09.m2", -- [9]
											"StranglethornRuins10.m2", -- [10]
											"StranglethornRuins11.m2", -- [11]
											"StranglethornRuins12.m2", -- [12]
											"StranglethornRuins13.M2", -- [13]
											"StranglethornRuins14.m2", -- [14]
											"StranglethornRuins15.m2", -- [15]
											"StranglethornRuins16.m2", -- [16]
											"StranglethornRuins17.m2", -- [17]
											"StranglethornRuins18.M2", -- [18]
											"StranglethornRuins19.M2", -- [19]
											"StranglethornRuins20.m2", -- [20]
											"StranglethornRuins21.M2", -- [21]
											"Stranglethornruins_pylon.m2", -- [22]
										},
										["N"] = "Ruins",
									}, -- [13]
									{
										["T"] = {
											"Sack01_01.m2", -- [1]
										},
										["N"] = "Sack01_01",
									}, -- [14]
									{
										["T"] = {
											"BootyBay_SeaWeed_01.M2", -- [1]
											"BootyBay_SeaWeed_02.M2", -- [2]
											"BootyBay_SeaWeed_03.M2", -- [3]
											"BootyBay_SeaWeed_04.M2", -- [4]
											"BootyBay_SeaWeed_05.M2", -- [5]
										},
										["N"] = "Seaweed",
									}, -- [15]
									{
										["T"] = {
											"SerpentStatue02.m2", -- [1]
										},
										["N"] = "Serpentstatue02",
									}, -- [16]
									{
										["T"] = {
											"StrangleDeadTree01.M2", -- [1]
										},
										["N"] = "Strangledeadtrees",
									}, -- [17]
									{
										["T"] = {
											{
												["T"] = {
													"StranglethornTree01.M2", -- [1]
												},
												["N"] = "Stranglethorntree01",
											}, -- [1]
											{
												["T"] = {
													"StranglethornTree02.m2", -- [1]
												},
												["N"] = "Stranglethorntree02",
											}, -- [2]
											{
												["T"] = {
													"StranglethornTree04.M2", -- [1]
												},
												["N"] = "Stranglethorntree04",
											}, -- [3]
											"StrangleDeadTreeNoVine.m2", -- [4]
											"StrangleThornRoot01.M2", -- [5]
											"StrangleThornRoot02.m2", -- [6]
											"StrangleThornRoot03.m2", -- [7]
											"bootybayTree01.M2", -- [8]
										},
										["N"] = "Trees",
									}, -- [18]
									{
										["T"] = {
											"TrollDrumSoundObj.m2", -- [1]
											"TrollDungeonDrum03.m2", -- [2]
											"TrollDungeonDrum03_noCol.M2", -- [3]
											"TrollRuinsDrum01.M2", -- [4]
										},
										["N"] = "Trolldrum",
									}, -- [19]
									{
										["T"] = {
											"TrollDungeonBasinWall.m2", -- [1]
										},
										["N"] = "Trolldungeonbasin Wall",
									}, -- [20]
									{
										["T"] = {
											"TrollDungeonFountain.m2", -- [1]
										},
										["N"] = "Trolldungeonfountain",
									}, -- [21]
									{
										["T"] = {
											"TrollDungeonPottery01.m2", -- [1]
											"TrollDungeonPottery02.m2", -- [2]
											"TrollDungeonPottery03.m2", -- [3]
										},
										["N"] = "Trolldungeonpottery",
									}, -- [22]
									{
										["T"] = {
											"TrollDungeonRing.m2", -- [1]
										},
										["N"] = "Trolldungeonring",
									}, -- [23]
									{
										["T"] = {
											"TrollDungeonSacks.m2", -- [1]
										},
										["N"] = "Trolldungeonsacks",
									}, -- [24]
									{
										["T"] = {
											"TrollDungeonSerpentStatue.m2", -- [1]
										},
										["N"] = "Trolldungeonserpentstatue",
									}, -- [25]
									{
										["T"] = {
											"TrollRuinsGong03.m2", -- [1]
										},
										["N"] = "Trollruinsgong",
									}, -- [26]
									{
										["T"] = {
											"TrollShrine.m2", -- [1]
											"stranglethorntikihead.m2", -- [2]
										},
										["N"] = "Trollshrine",
									}, -- [27]
									{
										["T"] = {
											"Strangle_GiantWaterfall01.M2", -- [1]
											"StranglethornWaterfall01.m2", -- [2]
										},
										["N"] = "Waterfall",
									}, -- [28]
									{
										["T"] = {
											"Strangle_Whirlpool01.M2", -- [1]
										},
										["N"] = "Whirlpools",
									}, -- [29]
								},
								["N"] = "Passivedoodads",
							}, -- [3]
						},
						["N"] = "Stranglethorn",
					}, -- [10]
					{
						["T"] = {
							{
								["T"] = {
									{
										["T"] = {
											"SerpentAltar.m2", -- [1]
										},
										["N"] = "Serpentaltar",
									}, -- [1]
								},
								["N"] = "Passivedoodads",
							}, -- [1]
						},
						["N"] = "Sunkentemple",
					}, -- [11]
					{
						["T"] = {
							{
								["T"] = {
									{
										["T"] = {
											"RuneStoneCrud_01.M2", -- [1]
										},
										["N"] = "Runestonecrud_01",
									}, -- [1]
								},
								["N"] = "Buildings",
							}, -- [1]
							{
								["T"] = {
									{
										["T"] = {
											"SwampPlant03.m2", -- [1]
											"SwampPlant04.M2", -- [2]
											"SwampPlant05.M2", -- [3]
											"SwampSorrowPlant01.m2", -- [4]
											"SwampSorrowPlant02.m2", -- [5]
											"SwampSorrowRoot01.m2", -- [6]
											"SwampSorrowRoot02.m2", -- [7]
											"SwampSorrowRoot03.m2", -- [8]
											"SwampofSorrowLilyPad01.m2", -- [9]
											"SwampofSorrowLilyPad02.m2", -- [10]
										},
										["N"] = "Plants",
									}, -- [1]
									{
										["T"] = {
											"SwampSorrowRock01.m2", -- [1]
											"SwampSorrowRock02.m2", -- [2]
											"SwampSorrowRock03.m2", -- [3]
										},
										["N"] = "Rocks",
									}, -- [2]
									{
										["T"] = {
											"SwampBeastBone01.m2", -- [1]
											"SwampBeastBone01_noCol.m2", -- [2]
										},
										["N"] = "Swampbeastbones",
									}, -- [3]
									{
										["T"] = {
											"SwampBoat01.M2", -- [1]
										},
										["N"] = "Swampboats",
									}, -- [4]
									{
										["T"] = {
											"SwampSkulls01.M2", -- [1]
											"SwampSkulls02.M2", -- [2]
										},
										["N"] = "Swampskulls",
									}, -- [5]
									{
										["T"] = {
											"SwampSnakeStatue01.m2", -- [1]
										},
										["N"] = "Swampsnakestatue",
									}, -- [6]
									{
										["T"] = {
											"SwampWagon01.m2", -- [1]
										},
										["N"] = "Swampwagon",
									}, -- [7]
									{
										["T"] = {
											"LostTreeHuts01.M2", -- [1]
											"LostTreeHuts02.M2", -- [2]
											"LostTreeHuts03.m2", -- [3]
										},
										["N"] = "Treehuts",
									}, -- [8]
									{
										["T"] = {
											"SwampTreeBlowUp01.M2", -- [1]
											"SwampTreeBroken01.M2", -- [2]
											"SwampTreeBroken02.M2", -- [3]
											"SwampTreeBurned01.M2", -- [4]
											"SwampTreeBurned02.M2", -- [5]
											"SwampTreeChopped01.M2", -- [6]
											"SwampTreeChopped02.M2", -- [7]
											"SwampTreeLog01.M2", -- [8]
											"SwampTreeLog02.M2", -- [9]
											"SwampTreeLog03.M2", -- [10]
											"SwampTreeLog04.M2", -- [11]
										},
										["N"] = "Treelogs",
									}, -- [9]
									{
										["T"] = {
											"SwampSorrowCanopyTree01.M2", -- [1]
											"SwampSorrowCanopyTree02.M2", -- [2]
											"SwampSorrowCanopyTree03.M2", -- [3]
											"SwampSorrowCanopyTree04.m2", -- [4]
											"SwampSorrowCanopyTree05.m2", -- [5]
											"SwampSorrowCanopyTree06.m2", -- [6]
											"SwampSorrowStump01.M2", -- [7]
											"SwampSorrowStump02.M2", -- [8]
											"SwampSorrowStump03.M2", -- [9]
											"SwampSorrowStump04.M2", -- [10]
											"SwampSorrowTree01.m2", -- [11]
											"SwampSorrowTree02.m2", -- [12]
										},
										["N"] = "Trees",
									}, -- [10]
									{
										["T"] = {
											"SwampHangingVines01.m2", -- [1]
											"SwampHangingVines02.M2", -- [2]
										},
										["N"] = "Vines",
									}, -- [11]
									{
										["T"] = {
											"WaterHut01.m2", -- [1]
											"WaterHut02.m2", -- [2]
										},
										["N"] = "Waterhuts",
									}, -- [12]
								},
								["N"] = "Passivedoodads",
							}, -- [2]
						},
						["N"] = "Swamposorrow",
					}, -- [12]
					{
						["T"] = {
							{
								["T"] = {
									{
										["T"] = {
											"BlastedLandsBlastedCow.m2", -- [1]
											"BlastedLandsBlastedCow_noCol.m2", -- [2]
											"BlastedLandsBlastedMule.m2", -- [3]
											"BlastedLandsBonePile02.m2", -- [4]
											"BlastedLandsBonePile03.m2", -- [5]
											"BlastedLandsSkull01.m2", -- [6]
											"BlastedLandsSkull02.m2", -- [7]
											"BlastedLandsSpine01.m2", -- [8]
											"BlastedLandsbone01.m2", -- [9]
											"BlastedLandsbone01_noCol.m2", -- [10]
										},
										["N"] = "Bones",
									}, -- [1]
									{
										["T"] = {
											"BlastedlandsBrokenColumn01.m2", -- [1]
											"BlastedlandsBrokenColumn02.m2", -- [2]
										},
										["N"] = "Column",
									}, -- [2]
									{
										["T"] = {
											"BlastedlandsRock01.m2", -- [1]
										},
										["N"] = "Detail",
									}, -- [3]
									{
										["T"] = {
											"BlastedLands_DwellingWater_01.M2", -- [1]
										},
										["N"] = "Dwelling",
									}, -- [4]
									{
										["T"] = {
											"BlastedlandsPortalRock01.M2", -- [1]
											"BlastedlandsPortalRock02.M2", -- [2]
											"BlastedlandsPortalRock03.m2", -- [3]
											"BlastedlandsRock02.m2", -- [4]
											"BlastedlandsRock03.m2", -- [5]
										},
										["N"] = "Rocks",
									}, -- [5]
									{
										["T"] = {
											"BlastedLandsRoot01.m2", -- [1]
											"BlastedLandsRoot03.m2", -- [2]
										},
										["N"] = "Roots",
									}, -- [6]
									{
										["T"] = {
											"BlastedLandsPortalRuins01.m2", -- [1]
											"BlastedLandsPortalRuins02.m2", -- [2]
											"BlastedLandsPortalRuins03.m2", -- [3]
											"BlastedLandsRuins01.m2", -- [4]
											"BlastedLandsRuins02.m2", -- [5]
											"BlastedLandsRuins03.m2", -- [6]
											"BlastedLandsRuinsTusk.m2", -- [7]
											"BrokenGateArch.M2", -- [8]
											"BrokenGateChain01.m2", -- [9]
											"BrokenGateChain02.m2", -- [10]
											"BrokenGateSide01.m2", -- [11]
											"BrokenGateSide02.m2", -- [12]
											"BrokenGateWall.m2", -- [13]
											"BrokenGateWood01.m2", -- [14]
											"BrokenGateWood02.m2", -- [15]
											"BrokenGateWood03.m2", -- [16]
										},
										["N"] = "Ruins",
									}, -- [7]
									{
										["T"] = {
											"BlastedLandsAshTree02.m2", -- [1]
											"BlastedLandsAshTree03.m2", -- [2]
											"BlastedLandsBlastedTree01.m2", -- [3]
											"BlastedLandsBlastedTree03.m2", -- [4]
											"BlastedLandsBlastedTree04.m2", -- [5]
											"BlastedLandsTree01.m2", -- [6]
											"BlastedLands_TwistedTree01.M2", -- [7]
											"BlastedLands_TwistedTree02.M2", -- [8]
											"BlastedLands_TwistedTree03.M2", -- [9]
										},
										["N"] = "Trees",
									}, -- [8]
								},
								["N"] = "Passivedoodads",
							}, -- [1]
						},
						["N"] = "Theblastedlands",
					}, -- [13]
					{
						["T"] = {
							{
								["T"] = {
									{
										["T"] = {
											"WestfallChurch.m2", -- [1]
										},
										["N"] = "Church",
									}, -- [1]
									{
										["T"] = {
											"WestFallGrainSilo01.m2", -- [1]
										},
										["N"] = "Grainsilo",
									}, -- [2]
									{
										["T"] = {
											"LighthouseRed.m2", -- [1]
											"WestfallLighthouse.M2", -- [2]
										},
										["N"] = "Lighthouse",
									}, -- [3]
									{
										["T"] = {
											"WestfallShed.m2", -- [1]
										},
										["N"] = "Shed",
									}, -- [4]
									{
										["T"] = {
											"WestfallWindmill.M2", -- [1]
										},
										["N"] = "Windmill",
									}, -- [5]
								},
								["N"] = "Buildings",
							}, -- [1]
							{
								["T"] = {
									{
										["T"] = {
											"aquaduct_corner1.m2", -- [1]
											"aquaduct_corner2.m2", -- [2]
											"aquaduct_longpillar.m2", -- [3]
											"aquaduct_pillar1.m2", -- [4]
											"aquaduct_pillar2.m2", -- [5]
											"aquaduct_pillar3.m2", -- [6]
											"aquaduct_short.m2", -- [7]
											"aquaduct_straight.m2", -- [8]
											"aquaduct_straight6.m2", -- [9]
											"aquaduct_xsupport.m2", -- [10]
										},
										["N"] = "Aquaduct",
									}, -- [1]
									{
										["T"] = {
											"WestFallBarrel01.m2", -- [1]
										},
										["N"] = "Barrel",
									}, -- [2]
									{
										["T"] = {
											"BrokenCart.M2", -- [1]
										},
										["N"] = "Brokencart",
									}, -- [3]
									{
										["T"] = {
											"ButterChurner.m2", -- [1]
										},
										["N"] = "Butterchurner",
									}, -- [4]
									{
										["T"] = {
											"HangingCage01.m2", -- [1]
											"HangingCage02.m2", -- [2]
										},
										["N"] = "Cages",
									}, -- [5]
									{
										["T"] = {
											"WestFallCrate.m2", -- [1]
										},
										["N"] = "Crate",
									}, -- [6]
									{
										["T"] = {
											"deadcow.m2", -- [1]
										},
										["N"] = "Deadcow",
									}, -- [7]
									{
										["T"] = {
											"deadmule.m2", -- [1]
										},
										["N"] = "Deadmule",
									}, -- [8]
									{
										["T"] = {
											"DeadSeaMonster.M2", -- [1]
											"DeadSeaMonster02.M2", -- [2]
											"DeadSeaMonster03.M2", -- [3]
											"SeaMonsterChunk.m2", -- [4]
										},
										["N"] = "Deadseamonster",
									}, -- [9]
									{
										["T"] = {
											"WestFallBerryBush.m2", -- [1]
											"WestFallBush01.m2", -- [2]
											"WestFallCabbage.m2", -- [3]
											"WestFallCatails.m2", -- [4]
											"WestFallCotton.m2", -- [5]
											"WestFallDandilion.m2", -- [6]
											"WestFallDriftwood.m2", -- [7]
											"WestFallMandrake.m2", -- [8]
											"WestFallTobbaco.m2", -- [9]
											"WestFallWheat01.m2", -- [10]
											"WestFallWheat02.m2", -- [11]
											"WestfallCornField.m2", -- [12]
											"WestfallReeds01.m2", -- [13]
											"WestfallWheat03.m2", -- [14]
										},
										["N"] = "Detail",
									}, -- [10]
									{
										["T"] = {
											"Westfall_ElementalVortex.M2", -- [1]
										},
										["N"] = "Elementalvortex",
									}, -- [11]
									{
										["T"] = {
											"westfallbed01.m2", -- [1]
										},
										["N"] = "Furniture",
									}, -- [12]
									{
										["T"] = {
											"GrindStone.m2", -- [1]
										},
										["N"] = "Grindstone",
									}, -- [13]
									{
										["T"] = {
											"HaremPillow01.m2", -- [1]
										},
										["N"] = "Harempillow01",
									}, -- [14]
									{
										["T"] = {
											"HaremPillow02.m2", -- [1]
										},
										["N"] = "Harempillow02",
									}, -- [15]
									{
										["T"] = {
											"harness.m2", -- [1]
										},
										["N"] = "Harness",
									}, -- [16]
									{
										["T"] = {
											"WestFallHayStack01.m2", -- [1]
											"WestFallHayStack02.m2", -- [2]
										},
										["N"] = "Haystack",
									}, -- [17]
									{
										["T"] = {
											"WestfallHayWagon.m2", -- [1]
										},
										["N"] = "Haywagon",
									}, -- [18]
									{
										["T"] = {
											"LampDeadMines.m2", -- [1]
										},
										["N"] = "Lampdeadmines",
									}, -- [19]
									{
										["T"] = {
											"WestfallLampPost.m2", -- [1]
											"WestfallLampPost01.m2", -- [2]
											"WestfallLampPost02.m2", -- [3]
										},
										["N"] = "Lamppost",
									}, -- [20]
									{
										["T"] = {
											"LightHouseEffect.m2", -- [1]
										},
										["N"] = "Lighthousebeam",
									}, -- [21]
									{
										["T"] = {
											"OutHouse.m2", -- [1]
											"OutHouse_ClosedBottom.M2", -- [2]
										},
										["N"] = "Outhouse",
									}, -- [22]
									{
										["T"] = {
											"Plow.m2", -- [1]
										},
										["N"] = "Plow",
									}, -- [23]
									{
										["T"] = {
											"RakeCart.m2", -- [1]
										},
										["N"] = "Rakecart",
									}, -- [24]
									{
										["T"] = {
											"WestFallBoulder01.m2", -- [1]
											"WestFallBoulder02.m2", -- [2]
										},
										["N"] = "Rocks",
									}, -- [25]
									{
										["T"] = {
											"RugRack01.m2", -- [1]
											"RugRack02.m2", -- [2]
										},
										["N"] = "Rugracks",
									}, -- [26]
									{
										["T"] = {
											"WestFallScarecrow.m2", -- [1]
										},
										["N"] = "Scarecrow",
									}, -- [27]
									{
										["T"] = {
											"SunkenAnchor.m2", -- [1]
										},
										["N"] = "Sunkenanchor",
									}, -- [28]
									{
										["T"] = {
											"TombStone01.m2", -- [1]
											"TombStone02.m2", -- [2]
											"TombStone03.m2", -- [3]
											"TombStone04.m2", -- [4]
										},
										["N"] = "Tombstones",
									}, -- [29]
									{
										["T"] = {
											"WestFallTree01.M2", -- [1]
											"WestFallTree02.M2", -- [2]
											"WestFallTree03.M2", -- [3]
											"WestFallTree04.M2", -- [4]
											"WestFallTreeCanopy01.M2", -- [5]
										},
										["N"] = "Trees",
									}, -- [30]
									{
										["T"] = {
											"WestFallTreeStump01.m2", -- [1]
											"WestFallTreeStump02.m2", -- [2]
										},
										["N"] = "Treestumps",
									}, -- [31]
									{
										["T"] = {
											"Bowl.m2", -- [1]
											"Plate.m2", -- [2]
											"Stein.m2", -- [3]
										},
										["N"] = "Utensils",
									}, -- [32]
									{
										["T"] = {
											"WestFallStable01.m2", -- [1]
										},
										["N"] = "Westfall Stable",
									}, -- [33]
									{
										["T"] = {
											"WestfallWagon01.M2", -- [1]
										},
										["N"] = "Westfall Wagon",
									}, -- [34]
									{
										["T"] = {
											"WestfallChair.m2", -- [1]
										},
										["N"] = "Westfallchair",
									}, -- [35]
									{
										["T"] = {
											"WestfallFence.m2", -- [1]
											"WestfallFenceEnd.m2", -- [2]
											"WestfallFencepost.m2", -- [3]
										},
										["N"] = "Westfallfence",
									}, -- [36]
									{
										["T"] = {
											"WestfallFountain.m2", -- [1]
										},
										["N"] = "Westfallfountain",
									}, -- [37]
									{
										["T"] = {
											"WestfallRuins01.m2", -- [1]
											"WestfallRuins02.m2", -- [2]
											"WestfallRuins03.m2", -- [3]
											"WestfallRuins04.m2", -- [4]
										},
										["N"] = "Westfallruins",
									}, -- [38]
									{
										["T"] = {
											"WestfallSkeleton.m2", -- [1]
										},
										["N"] = "Westfallskeleton",
									}, -- [39]
									{
										["T"] = {
											"WestfallTable.m2", -- [1]
										},
										["N"] = "Westfalltable",
									}, -- [40]
									{
										["T"] = {
											"WestfallVineyard01.m2", -- [1]
										},
										["N"] = "Westfallvineyards",
									}, -- [41]
									{
										["T"] = {
											"WreckedRowBoat.m2", -- [1]
										},
										["N"] = "Wreckedrowboat",
									}, -- [42]
								},
								["N"] = "Passivedoodads",
							}, -- [2]
						},
						["N"] = "Westfall",
					}, -- [14]
					{
						["T"] = {
							{
								["T"] = {
									{
										["T"] = {
											"CollisionWallPenDoor01.m2", -- [1]
											"ZulGurubForcefield.M2", -- [2]
											"ZulGurubPenDoor.m2", -- [3]
											"ZulGurub_PenDoor_Gate.M2", -- [4]
										},
										["N"] = "Doors",
									}, -- [1]
									{
										["T"] = {
											"ZulGurubMainDoor.m2", -- [1]
										},
										["N"] = "Maindoor",
									}, -- [2]
									{
										["T"] = {
											"NastySpiderEgg.M2", -- [1]
										},
										["N"] = "Spiderarea",
									}, -- [3]
									{
										["T"] = {
											"VoodooPile01.M2", -- [1]
										},
										["N"] = "Voodoopile",
									}, -- [4]
								},
								["N"] = "Activedoodads",
							}, -- [1]
							{
								["T"] = {
									{
										["T"] = {
											"TrollBatTotem.m2", -- [1]
										},
										["N"] = "Battotem",
									}, -- [1]
									{
										["T"] = {
											"cauldronbeam_fire_base.M2", -- [1]
											"cauldronbeam_ice_base.M2", -- [2]
											"cauldronbeam_poison_base.M2", -- [3]
											"zg_cauldron_fire.M2", -- [4]
											"zg_cauldron_ice.M2", -- [5]
											"zg_cauldron_poison.M2", -- [6]
										},
										["N"] = "Cauldrons",
									}, -- [2]
									{
										["T"] = {
											"heartofhakkar.M2", -- [1]
										},
										["N"] = "Heart",
									}, -- [3]
									{
										["T"] = {
											"ZulGurubLightningMadness.m2", -- [1]
										},
										["N"] = "Lightning",
									}, -- [4]
									{
										["T"] = {
											"ZulGurubRuins04.M2", -- [1]
											"ZulGurubRuins05.M2", -- [2]
											"ZulGurubRuins06.M2", -- [3]
											"ZulGurubRuins07.M2", -- [4]
										},
										["N"] = "Ruins",
									}, -- [5]
									{
										["T"] = {
											"NastySpiderWeb01.m2", -- [1]
											"NastySpiderWeb02.m2", -- [2]
											"NastySpiderWeb03.m2", -- [3]
											"SpiderPod01.m2", -- [4]
											"SpiderPod02.m2", -- [5]
										},
										["N"] = "Spiderarea",
									}, -- [6]
									{
										["T"] = {
											"ZulGurubTree01.m2", -- [1]
											"ZulGurubTree02.M2", -- [2]
											"ZulGurubTree03.M2", -- [3]
											"ZulGurubTree04.M2", -- [4]
											"ZulGurubTree05.m2", -- [5]
										},
										["N"] = "Trees",
									}, -- [7]
									{
										["T"] = {
											"Zulgurub_Vines_01.M2", -- [1]
											"Zulgurub_Vines_02.M2", -- [2]
											"Zulgurub_Vines_03.M2", -- [3]
											"Zulgurub_Vines_04.M2", -- [4]
										},
										["N"] = "Vines",
									}, -- [8]
								},
								["N"] = "Passivedoodads",
							}, -- [2]
						},
						["N"] = "Zulgurub",
					}, -- [15]
				},
				["N"] = "Azeroth",
			}, -- [2]
			{
				["T"] = {
					{
						["T"] = {
							"BlackrockV2_AlchemyRoom_DragonStatue_01.M2", -- [1]
							"BlackrockV2_BonesChewed_01.M2", -- [2]
							"BlackrockV2_BonesChewed_02.M2", -- [3]
							"BlackrockV2_BonesChewed_03.M2", -- [4]
							"BlackrockV2_BonesChewed_04.M2", -- [5]
							"BlackrockV2_BonesChewed_05.M2", -- [6]
							"BlackrockV2_BonesChewed_06.M2", -- [7]
							"BlackrockV2_BonesChewed_07.M2", -- [8]
							"BlackrockV2_Chains01.M2", -- [9]
							"BlackrockV2_Chains02.M2", -- [10]
							"BlackrockV2_Chains03.M2", -- [11]
							"BlackrockV2_Chains04.M2", -- [12]
							"BlackrockV2_DarkIronBomb_01.M2", -- [13]
							"BlackrockV2_DarkIronBomb_02.M2", -- [14]
							"BlackrockV2_DarkIronBomb_03.M2", -- [15]
							"BlackrockV2_DarkIronBomb_Peg_01.M2", -- [16]
							"BlackrockV2_DarkIronLight_01.M2", -- [17]
							"BlackrockV2_Drake.M2", -- [18]
							"BlackrockV2_HangingDragon_01.M2", -- [19]
							"BlackrockV2_HangingDragon_02.M2", -- [20]
							"BlackrockV2_HangingDragon_03.M2", -- [21]
							"BlackrockV2_HangingDragon_04.M2", -- [22]
							"BlackrockV2_HangingDragon_05.M2", -- [23]
							"BlackrockV2_HangingDragon_06.M2", -- [24]
							"BlackrockV2_HangingDragon_07.M2", -- [25]
							"BlackrockV2_HangingDragon_08.M2", -- [26]
							"BlackrockV2_Hanging_Cage.M2", -- [27]
							"BlackrockV2_LabRoom_01.M2", -- [28]
							"BlackrockV2_LabRoom_01Broken.M2", -- [29]
							"BlackrockV2_LabRoom_BloodVial_Breaker01.M2", -- [30]
							"BlackrockV2_LabRoom_BloodVial_Breaker02.M2", -- [31]
							"BlackrockV2_LabRoom_Cauldron.M2", -- [32]
							"BlackrockV2_LavaColumn.M2", -- [33]
							"BlackrockV2_LavaRock_Buckets01.M2", -- [34]
							"BlackrockV2_LavaRock_Buckets02.M2", -- [35]
							"BlackrockV2_LavaRock_Buckets03.M2", -- [36]
							"BlackrockV2_LavaRock_Buckets_Broken.M2", -- [37]
							"BlackrockV2_Lava_Bucket.M2", -- [38]
							"BlackrockV2_Main_Cage.M2", -- [39]
							"BlackrockV2_Portcullis_01.M2", -- [40]
							"BlackrockV2_Portcullis_02.M2", -- [41]
							"BlackrockV2_Portcullis_03.M2", -- [42]
							"BlackrockV2_ShieldGong_Collision.M2", -- [43]
							"BlackrockV2_Windgust_01.M2", -- [44]
							"blackwing_portcullis.M2", -- [45]
						},
						["N"] = "Passivedoodads",
					}, -- [1]
				},
				["N"] = "Blackrockv2",
			}, -- [3]
			{
				["T"] = {
					{
						["T"] = {
							"BlackWingV2_Elevator01.M2", -- [1]
							"BlackWingV2_Elevator_Onyxia.M2", -- [2]
							"BlackwingV2_DarkIronDwarfStatue_01.M2", -- [3]
							"BlackwingV2_DarkIronDwarfStatue_01Broken.M2", -- [4]
							"BlackwingV2_DarkIron_Bell_01.M2", -- [5]
							"Blackwingdescent_Lava_Heads_Room_01.M2", -- [6]
							"Blackwingdescent_Lava_Heads_Room_02.M2", -- [7]
							"Blackwingdescent_Lava_Heads_Room_03.M2", -- [8]
							"Blackwingdescent_Lava_Heads_Room_04.M2", -- [9]
							"Blackwingdescent_Lava_Library_01.M2", -- [10]
							"Blackwingdescent_Lava_Library_02.M2", -- [11]
							"Blackwingdescent_Lava_Round_Room_01.M2", -- [12]
							"Blackwingdescent_Lava_Round_Room_02.M2", -- [13]
							"Blackwingdescent_Lava_Round_Room_03.M2", -- [14]
							"Blackwingdescent_Lava_Round_Room_04.M2", -- [15]
							"Blackwingdescent_Lava_Round_Room_05.M2", -- [16]
							"Blackwingdescent_Lava_Round_Room_06.M2", -- [17]
							"Blackwingdescent_Lava_Round_Room_07.M2", -- [18]
							"Blackwingdescent_Lava_Round_Room_08.M2", -- [19]
							"Blackwingdescent_Lava_Round_Room_09.M2", -- [20]
							"Blackwingdescent_Lava_Round_Room_10.M2", -- [21]
							"Blackwingdescent_Lava_Round_Room_11.M2", -- [22]
							"Blackwingdescent_Lava_Round_Room_12.M2", -- [23]
							"Blackwingdescent_Lava_Statue_01.M2", -- [24]
							"Blackwingdescent_Lava_Statue_Broken_01.M2", -- [25]
						},
						["N"] = "Passivedoodads",
					}, -- [1]
				},
				["N"] = "Blackwingv2",
			}, -- [4]
			{
				["T"] = {
					{
						["T"] = {
							"Bat01.m2", -- [1]
							"Bat02.m2", -- [2]
							"Bats_01.M2", -- [3]
						},
						["N"] = "Bats",
					}, -- [1]
					{
						["T"] = {
							"Bird01.m2", -- [1]
							"Bird02.m2", -- [2]
							"Birds_Condor_01.M2", -- [3]
							"Wasp01.m2", -- [4]
							"Wasp02.m2", -- [5]
						},
						["N"] = "Birds",
					}, -- [2]
					{
						["T"] = {
							"ButterflyOrange01.m2", -- [1]
							"ButterflyPurple01.m2", -- [2]
							"ButterflyWhite01.m2", -- [3]
						},
						["N"] = "Butterflies",
					}, -- [3]
					{
						["T"] = {
							"FireFlies01.m2", -- [1]
						},
						["N"] = "Fireflies",
					}, -- [4]
					{
						["T"] = {
							"Fish01.m2", -- [1]
							"FishBasic01.m2", -- [2]
							"FishBasic02.m2", -- [3]
							"FishBasic03.m2", -- [4]
							"FishBasic04.m2", -- [5]
							"FishPiranha01.m2", -- [6]
							"FishPiranha02.m2", -- [7]
							"FishPiranha03.m2", -- [8]
							"FishSkinny01.m2", -- [9]
							"FishSkinny02.m2", -- [10]
							"FishSkinny03.m2", -- [11]
						},
						["N"] = "Fish",
					}, -- [5]
					{
						["T"] = {
							"Flies01.m2", -- [1]
						},
						["N"] = "Flies",
					}, -- [6]
				},
				["N"] = "Critter",
			}, -- [5]
			{
				["T"] = {
					{
						["T"] = {
							{
								["T"] = {
									"6DR_Draenei_Platform_Elevator_Object.m2", -- [1]
								},
								["N"] = "Doodad_elevators",
							}, -- [1]
						},
						["N"] = "Transports",
					}, -- [1]
				},
				["N"] = "Doodad",
			}, -- [6]
			{
				["T"] = {
					{
						["T"] = {
							{
								["T"] = {
									"EmeraldDreamCatcher01.m2", -- [1]
									"EmeraldDreamCatcher02.m2", -- [2]
									"EmeraldDreamCatcher03.m2", -- [3]
									"EmeraldDreamCatcher04.m2", -- [4]
								},
								["N"] = "Dreamcatchers",
							}, -- [1]
							{
								["T"] = {
									"EmeraldDreamGiant01.m2", -- [1]
								},
								["N"] = "Emeralddreamgiant",
							}, -- [2]
							{
								["T"] = {
									"EmeraldDreamGiant_Destroyed.M2", -- [1]
								},
								["N"] = "Emeralddreamgiant_destroyed",
							}, -- [3]
							{
								["T"] = {
									"DNRDreamBellFlower01.m2", -- [1]
									"DNRDreamBellFlower02.m2", -- [2]
									"DNRDreamBellFlower03.m2", -- [3]
									"DNRDreamDrippingFlower01.M2", -- [4]
									"DNRDreamDrippingFlower02.m2", -- [5]
									"DNRDreamDroopingFlower01.m2", -- [6]
									"DNRDreamDroopingFlower02.m2", -- [7]
									"DNRDreamOrangeFlower01.m2", -- [8]
									"DNRDreamOrangeFlower02.M2", -- [9]
									"DNRDreamPurpleFlower01.m2", -- [10]
									"DNRDreamPurpleFlower02.m2", -- [11]
									"DNRDreamPurpleFlower03.m2", -- [12]
									"DNRDreamSpinningFlower01.M2", -- [13]
								},
								["N"] = "Flowers",
							}, -- [4]
							{
								["T"] = {
									"EmeraldDreamBush01.M2", -- [1]
									"EmeraldDreamFountainTree01.M2", -- [2]
									"EmeraldDreamFountainTree02.M2", -- [3]
									"EmeraldDreamFountainTree03.M2", -- [4]
									"EmeraldDreamFountainTree04.M2", -- [5]
									"EmeraldDreamFountainTree05.M2", -- [6]
									"EmeraldDreamTree01.M2", -- [7]
									"EmeraldDreamTree02.M2", -- [8]
								},
								["N"] = "Trees",
							}, -- [5]
						},
						["N"] = "Passivedoodads",
					}, -- [1]
				},
				["N"] = "Dreaming",
			}, -- [7]
			{
				["T"] = {
					{
						["T"] = {
							"HU_SpotLight_01.M2", -- [1]
						},
						["N"] = "Alliancebase",
					}, -- [1]
					{
						["T"] = {
							{
								["T"] = {
									{
										["T"] = {
											"BasiliskCrystal02.m2", -- [1]
											"CaveMineCrystalFormation01.m2", -- [2]
											"CaveMineCrystalFormation02.m2", -- [3]
											"CaveMineCrystalFormation03.m2", -- [4]
											"CaveMineCrystalFormation04.m2", -- [5]
											"CaveMineCrystalFormation05.m2", -- [6]
											"CaveMineCrystalFormation06.m2", -- [7]
											"CaveMineCrystalFormation07.m2", -- [8]
											"CaveMineCrystalFormation08.m2", -- [9]
										},
										["N"] = "Crystals",
									}, -- [1]
									{
										["T"] = {
											"Caveicicle1.m2", -- [1]
											"Caveicicle2.m2", -- [2]
										},
										["N"] = "Icicles",
									}, -- [2]
									{
										["T"] = {
											"Stalagmite01.m2", -- [1]
										},
										["N"] = "Stalagmite",
									}, -- [3]
									{
										["T"] = {
											"DeadminesStalagtite01.m2", -- [1]
											"DeadminesStalagtite02.m2", -- [2]
											"Stalagtite01.m2", -- [3]
											"Stalagtite02.m2", -- [4]
										},
										["N"] = "Stalagtite",
									}, -- [4]
								},
								["N"] = "Passivedoodads",
							}, -- [1]
						},
						["N"] = "Cave",
					}, -- [2]
					{
						["T"] = {
							{
								["T"] = {
									{
										["T"] = {
											"CavernDoor.m2", -- [1]
										},
										["N"] = "Cavernsoftimedoor",
									}, -- [1]
								},
								["N"] = "Activedoodads",
							}, -- [1]
							{
								["T"] = {
									{
										["T"] = {
											"COT_arcaneOrb_01.M2", -- [1]
										},
										["N"] = "Arcaneorb",
									}, -- [1]
									{
										["T"] = {
											"COT_portalparticles.M2", -- [1]
											"COT_standingstone01.m2", -- [2]
											"COT_standingstone02.m2", -- [3]
										},
										["N"] = "Darkportal",
									}, -- [2]
									{
										["T"] = {
											"EnergyTrail01.M2", -- [1]
											"EnergyTrail01B.M2", -- [2]
											"EnergyTrail01C.M2", -- [3]
											"EnergyTrail02.M2", -- [4]
											"EnergyTrail02B.M2", -- [5]
											"EnergyTrail03.M2", -- [6]
											"EnergyTrail03B.M2", -- [7]
											"EnergyTrail04.M2", -- [8]
											"EnergyTrail04B.M2", -- [9]
											"EnergyTrail05.M2", -- [10]
											"EnergyTrail05B.M2", -- [11]
											"EnergyTrail05C.M2", -- [12]
											"EnergyTrailHourglass.m2", -- [13]
											"EnergyTrailHourglassB.m2", -- [14]
											"EnergyTrailHourglassBlue.m2", -- [15]
											"EnergyTrailHourglassPink.m2", -- [16]
											"EnergyTrailHourglassRed.m2", -- [17]
										},
										["N"] = "Energytrails",
									}, -- [3]
									{
										["T"] = {
											"COT_HourGlass.M2", -- [1]
											"COT_HourGlass_redo.m2", -- [2]
										},
										["N"] = "Hourglass",
									}, -- [4]
									{
										["T"] = {
											"COT_portal01.M2", -- [1]
											"COT_portalFX.M2", -- [2]
										},
										["N"] = "Portal",
									}, -- [5]
								},
								["N"] = "Passivedoodads",
							}, -- [2]
						},
						["N"] = "Cavernsoftime",
					}, -- [3]
					{
						["T"] = {
							"ChallengeMode_Pedestal_1.M2", -- [1]
							"ChallengeMode_Wall_Dome.M2", -- [2]
							"ChallengeMode_Wall_Flat.M2", -- [3]
						},
						["N"] = "Challenge",
					}, -- [4]
					{
						["T"] = {
							{
								["T"] = {
									"DragonSoul_chest_01.M2", -- [1]
								},
								["N"] = "Chest",
							}, -- [1]
							{
								["T"] = {
									"dragonSoul_HagaraCrystal_01.M2", -- [1]
									"dragonSoul_HagaraCrystal_GREEN.M2", -- [2]
									"dragonSoul_HagaraCrystal_PURPLE.M2", -- [3]
									"dragonSoul_HagaraCrystal_RED.M2", -- [4]
								},
								["N"] = "Hagaracrystal",
							}, -- [2]
							{
								["T"] = {
									"Dragonsoul_DeathwingJaw_01.M2", -- [1]
									"Dragonsoul_DeathwingJaw_Trophy.M2", -- [2]
								},
								["N"] = "Jaw",
							}, -- [3]
							{
								["T"] = {
									"Dragonsoul_HagaraLightningRod_01.M2", -- [1]
								},
								["N"] = "Lightningrod",
							}, -- [4]
							{
								["T"] = {
									"DragonSoul_MorchokSpike_01.M2", -- [1]
									"DragonSoul_MorchokSpike_02.M2", -- [2]
								},
								["N"] = "Morchokspike",
							}, -- [5]
							"DeathwingAirshipSky.M2", -- [6]
						},
						["N"] = "Dragonsoul",
					}, -- [5]
					{
						["T"] = {
							{
								["T"] = {
									"PA_EastTemple_Bench_01.M2", -- [1]
								},
								["N"] = "Bench",
							}, -- [1]
							{
								["T"] = {
									"PA_EastTempleRailing01.M2", -- [1]
									"PA_EastTempleRailing02.M2", -- [2]
									"PA_EastTempleRailing03.M2", -- [3]
								},
								["N"] = "Railing",
							}, -- [2]
							{
								["T"] = {
									"PA_EastTempleSconce1.M2", -- [1]
									"PA_EastTempleSconce2.M2", -- [2]
								},
								["N"] = "Sconce",
							}, -- [3]
							{
								["T"] = {
									"PA_EastTemple_Screen_01.M2", -- [1]
								},
								["N"] = "Screen",
							}, -- [4]
							{
								["T"] = {
									"PA_Scroll_Long_01.M2", -- [1]
									"PA_Scroll_Long_02.M2", -- [2]
								},
								["N"] = "Scroll",
							}, -- [5]
							{
								["T"] = {
									"PA_EastTemple_WallLantern_01.M2", -- [1]
								},
								["N"] = "Walllantern",
							}, -- [6]
							{
								["T"] = {
									"PA_EastTemple_WaterDoor_01.M2", -- [1]
									"PA_EastTemple_WaterDoor_02.M2", -- [2]
								},
								["N"] = "Waterdoor",
							}, -- [7]
							{
								["T"] = {
									"PA_EastTemple_Water_Effect_01.M2", -- [1]
								},
								["N"] = "Watereffect",
							}, -- [8]
							{
								["T"] = {
									"PA_EastTempleWindow1.M2", -- [1]
									"PA_EastTempleWindow2.M2", -- [2]
								},
								["N"] = "Window",
							}, -- [9]
							"PA_EastTempleDetail_Fencing1.M2", -- [10]
							"PA_EastTempleDetail_Shutter.M2", -- [11]
							"PA_EastTempleDetail_Window.M2", -- [12]
							"PA_EastTemple_DoorLarge.M2", -- [13]
							"PA_EastTemple_DoorRound.M2", -- [14]
							"PA_EastTemple_DoorTower.M2", -- [15]
							"PA_EastTemple_EyeoftheSerpent.M2", -- [16]
							"PA_EastTemple_Giant_IncenseBurner.M2", -- [17]
							"PA_EastTemple_Giant_IncenseBurner_Hanging.M2", -- [18]
							"PA_EastTemple_WaterEffect01.M2", -- [19]
							"PA_EastTemple_WaterEffect02.M2", -- [20]
							"PA_EastTemple_WaterEffect03.M2", -- [21]
							"PA_EastTemple_WaterEffect04.M2", -- [22]
							"PA_EastTemple_WaterEffect05.M2", -- [23]
							"PA_EastTemple_library_books01.M2", -- [24]
							"PA_EastTemple_library_books01_a.M2", -- [25]
							"PA_EastTemple_library_books01_b.M2", -- [26]
							"PA_EastTemple_library_books01_c.M2", -- [27]
							"PA_EastTemple_library_books02.M2", -- [28]
							"PA_EastTemple_library_books02_a.M2", -- [29]
							"PA_EastTemple_library_books02_b.M2", -- [30]
							"PA_EastTemple_library_books02_c.M2", -- [31]
							"PA_EastTemple_library_books03.M2", -- [32]
							"PA_EastTemple_library_books03_a.M2", -- [33]
							"PA_EastTemple_library_books03_b.M2", -- [34]
							"PA_EastTemple_library_books04.M2", -- [35]
							"PA_EastTemple_library_books04_a.M2", -- [36]
							"PA_EastTemple_library_books04_b.M2", -- [37]
							"PA_EastTemple_library_books_top.M2", -- [38]
						},
						["N"] = "Easttemple",
					}, -- [6]
					{
						["T"] = {
							{
								["T"] = {
									"FOA_BurntTree_01.M2", -- [1]
									"FOA_BurntTree_02.M2", -- [2]
								},
								["N"] = "Burnttree",
							}, -- [1]
							{
								["T"] = {
									"FOA_chest_01.M2", -- [1]
								},
								["N"] = "Chest",
							}, -- [2]
							{
								["T"] = {
									"Deathwing_Dead.M2", -- [1]
								},
								["N"] = "Deathing_dead",
							}, -- [3]
							{
								["T"] = {
									"FOA_hourglass.M2", -- [1]
								},
								["N"] = "Hourglass",
							}, -- [4]
							{
								["T"] = {
									"FOA_portal_01.M2", -- [1]
								},
								["N"] = "Portal",
							}, -- [5]
							{
								["T"] = {
									"FOA_Blowing_Sand.M2", -- [1]
								},
								["N"] = "Sand",
							}, -- [6]
							{
								["T"] = {
									"Wyrmrest_Destroyed_Rubble_01.M2", -- [1]
									"Wyrmrest_Destroyed_Rubble_02.M2", -- [2]
									"Wyrmrest_Destroyed_Rubble_03.M2", -- [3]
									"Wyrmrest_Destroyed_Rubble_04.M2", -- [4]
									"Wyrmrest_Destroyed_Rubble_05.M2", -- [5]
									"Wyrmrest_Destroyed_Rubble_06.M2", -- [6]
									"Wyrmrest_Destroyed_Rubble_07.M2", -- [7]
									"Wyrmrest_Destroyed_Rubble_08.M2", -- [8]
									"Wyrmrest_Destroyed_Rubble_09.M2", -- [9]
									"Wyrmrest_Destroyed_Rubble_10.M2", -- [10]
									"Wyrmrest_Destroyed_Rubble_11.M2", -- [11]
									"Wyrmrest_Destroyed_Rubble_12.M2", -- [12]
								},
								["N"] = "Wyrmrest_rubble",
							}, -- [7]
						},
						["N"] = "Fallofazeroth",
					}, -- [7]
					{
						["T"] = {
							"PA_GhostBrewery_Door_01.M2", -- [1]
							"PA_GhostBrewery_VermingBossKeg.M2", -- [2]
							"PA_GhostBrewery_WaterHammer_Left.M2", -- [3]
							"PA_GhostBrewery_WaterHammer_Right.M2", -- [4]
							"PA_GhostBrewery_WaterWheel_Large.M2", -- [5]
							"PA_GhostBrewery_WaterWheel_Large_Mechanism.M2", -- [6]
							"PA_GhostBrewery_WaterWheel_Small.M2", -- [7]
						},
						["N"] = "Ghostbrewery",
					}, -- [8]
					{
						["T"] = {
							{
								["T"] = {
									{
										["T"] = {
											"CaveMineLantern01.m2", -- [1]
											"CaveMineLantern02.m2", -- [2]
											"CaveMineLantern03.m2", -- [3]
										},
										["N"] = "Cavelanterns",
									}, -- [1]
									{
										["T"] = {
											"CaveKoboldDangerSign_Red_01.M2", -- [1]
											"CaveMineKobold01.m2", -- [2]
											"CaveMineKobold02.m2", -- [3]
											"CaveMineKobold04.M2", -- [4]
											"CaveMineKobold05.m2", -- [5]
											"CaveMineKobold06.m2", -- [6]
										},
										["N"] = "Caveminekobolds",
									}, -- [2]
									{
										["T"] = {
											"CaveMineSpiderPillar01.m2", -- [1]
										},
										["N"] = "Caveminespiderpillar01",
									}, -- [3]
									{
										["T"] = {
											"CaveSpiderWeb01.m2", -- [1]
											"CaveSpiderWeb02.m2", -- [2]
										},
										["N"] = "Cavespiderwebs",
									}, -- [4]
								},
								["N"] = "Passivedoodads",
							}, -- [1]
						},
						["N"] = "Goldmine",
					}, -- [9]
					{
						["T"] = {
							{
								["T"] = {
									"InnBarrel.M2", -- [1]
								},
								["N"] = "Innbarrel",
							}, -- [1]
							{
								["T"] = {
									"InnBed.m2", -- [1]
								},
								["N"] = "Innbed",
							}, -- [2]
							{
								["T"] = {
									"InnBedCanopy.m2", -- [1]
								},
								["N"] = "Innbedcanopy",
							}, -- [3]
							{
								["T"] = {
									"InnChandelier.m2", -- [1]
								},
								["N"] = "Innchandelier",
							}, -- [4]
							{
								["T"] = {
									"InnLantern.m2", -- [1]
								},
								["N"] = "Innlantern",
							}, -- [5]
							{
								["T"] = {
									"InnPillow.M2", -- [1]
								},
								["N"] = "Innpillow",
							}, -- [6]
						},
						["N"] = "Goldshireinn",
					}, -- [10]
					{
						["T"] = {
							"GreatWall_Banner_01.M2", -- [1]
							"GreatWall_Brazier_Floor_01.M2", -- [2]
							"GreatWall_Brazier_Hanging_01.M2", -- [3]
							"GreatWall_Brazier_HotOilCauldron_01.M2", -- [4]
							"GreatWall_Brazier_Mounted_01.M2", -- [5]
							"GreatWall_Brazier_Wall_01.M2", -- [6]
							"GreatWall_Door_01.M2", -- [7]
							"GreatWall_Door_02.M2", -- [8]
							"GreatWall_Door_03.M2", -- [9]
							"GreatWall_GiantBanner.M2", -- [10]
							"GreatWall_GiantBanner_Tattered.M2", -- [11]
							"GreatWall_MoguStatue_01.M2", -- [12]
							"GreatWall_MoguStatue_02.M2", -- [13]
							"PA_GreatWall_Destruction_01.M2", -- [14]
							"PA_GreatWall_Destruction_02.M2", -- [15]
							"PA_GreatWall_Destruction_03.M2", -- [16]
							"PA_arrow_01.M2", -- [17]
							"PA_arrows_01stack.M2", -- [18]
							"PA_arrows_02stack.M2", -- [19]
							"PA_cannon_01blue.M2", -- [20]
							"PA_cannon_01green.M2", -- [21]
							"PA_cannon_01red.M2", -- [22]
							"PA_cannon_01stack.M2", -- [23]
							"PA_cannonballStack_01.M2", -- [24]
							"PA_weaponRack_04.M2", -- [25]
						},
						["N"] = "Greatwall",
					}, -- [11]
					{
						["T"] = {
							"PA_cannonball_single.M2", -- [1]
							"PA_oilspew.M2", -- [2]
						},
						["N"] = "Hordebase",
					}, -- [12]
					{
						["T"] = {
							{
								["T"] = {
									"HoT_Old_God_Lightning01.M2", -- [1]
									"HoT_Old_God_Lightning02.M2", -- [2]
									"HoT_Old_God_Lightning03.M2", -- [3]
									"HoT_Old_God_Lightning04.M2", -- [4]
								},
								["N"] = "Lightning",
							}, -- [1]
						},
						["N"] = "Houroftwilight",
					}, -- [13]
					{
						["T"] = {
							"Garrosh_Stormwind_FXwrap.M2", -- [1]
							"GoldenLotus_Sha_Door.M2", -- [2]
							"Norushen_Light_Containment_bottom.M2", -- [3]
							"Norushen_Light_Containment_side1.M2", -- [4]
							"Norushen_Light_Containment_side2.M2", -- [5]
							"Norushen_Light_Containment_side3.M2", -- [6]
							"Norushen_Light_Containment_side4.M2", -- [7]
							"Norushen_Light_Containment_top.M2", -- [8]
							"OGRAID_HOTCOALFIRE_BARRACKS_CENTER.M2", -- [9]
							"OGRAID_HOTCOALFIRE_BARRACKS_LEFT.M2", -- [10]
							"OGRAID_HOTCOALFIRE_BARRACKS_RIGHT.M2", -- [11]
							"OGRAID_HOTCOALFIRE_GARROSH.M2", -- [12]
							"OGRAID_HOTCOALFIRE_GOBLIN.M2", -- [13]
							"OGRAID_HOTCOALFIRE_HALLWAY.M2", -- [14]
							"OGRAID_HOTCOALFIRE_SUMMONING.M2", -- [15]
							"OGRaid_Alarm_01.M2", -- [16]
							"OGRaid_ArmorStand_01.M2", -- [17]
							"OGRaid_ArmorStand_02.M2", -- [18]
							"OGRaid_ArmorStand_03.M2", -- [19]
							"OGRaid_Banner01.M2", -- [20]
							"OGRaid_Brazier_01.M2", -- [21]
							"OGRaid_BrokenElevator01.M2", -- [22]
							"OGRaid_Cage01.M2", -- [23]
							"OGRaid_CageDoor01.M2", -- [24]
							"OGRaid_Cart.M2", -- [25]
							"OGRaid_ChainLink_01.M2", -- [26]
							"OGRaid_ChainLink_02.M2", -- [27]
							"OGRaid_Chains_01.M2", -- [28]
							"OGRaid_Chains_02.M2", -- [29]
							"OGRaid_Chains_03.M2", -- [30]
							"OGRaid_Chandelier_01.M2", -- [31]
							"OGRaid_Chandelier_02.M2", -- [32]
							"OGRaid_ConveyorBelt01.M2", -- [33]
							"OGRaid_Conveyorwheel.M2", -- [34]
							"OGRaid_Crate_Horde01.M2", -- [35]
							"OGRaid_Crate_Lg_Mantid.M2", -- [36]
							"OGRaid_Crate_Lg_Mogu.M2", -- [37]
							"OGRaid_Crate_Lg_PA.M2", -- [38]
							"OGRaid_Crate_Med_Mantid.M2", -- [39]
							"OGRaid_Crate_Med_Mogu.M2", -- [40]
							"OGRaid_Crate_Med_PA.M2", -- [41]
							"OGRaid_Crate_Sm_Mantid.M2", -- [42]
							"OGRaid_Crate_Sm_Mogu.M2", -- [43]
							"OGRaid_Crate_Sm_PA.M2", -- [44]
							"OGRaid_Door_01.M2", -- [45]
							"OGRaid_Elevator01.M2", -- [46]
							"OGRaid_Engine01.M2", -- [47]
							"OGRaid_FrontGate_01.M2", -- [48]
							"OGRaid_Godray_01.M2", -- [49]
							"OGRaid_Hammock_01.M2", -- [50]
							"OGRaid_Hammock_02.M2", -- [51]
							"OGRaid_LargeDoor01.M2", -- [52]
							"OGRaid_Lever.M2", -- [53]
							"OGRaid_Piston01.M2", -- [54]
							"OGRaid_Portcullis_01.M2", -- [55]
							"OGRaid_Rope01.M2", -- [56]
							"OGRaid_Rope02.M2", -- [57]
							"OGRaid_Rope03.M2", -- [58]
							"OGRaid_Sconce_01.M2", -- [59]
							"OGRaid_ShaFalls01.M2", -- [60]
							"OGRaid_ShaWall_SouthernTemple_01.M2", -- [61]
							"OGRaid_ShaWalls01.M2", -- [62]
							"OGRaid_Small_Door_01.M2", -- [63]
							"OGRaid_SteamJets01.M2", -- [64]
							"OGRaid_TRexDoor01.M2", -- [65]
							"OGRaid_TeslaCoil_01.M2", -- [66]
							"OGRaid_TitanConsole_Chest.M2", -- [67]
							"OGRaid_WeaponRack01.M2", -- [68]
							"OGRaid_Weapon_Axe.M2", -- [69]
							"OGRaid_Weapon_Sword.M2", -- [70]
							"OGRaid_heartchest.M2", -- [71]
							"Pa_HordeMineVaultAnnexLights.M2", -- [72]
							"ShaOfPride_Maze_Center.M2", -- [73]
							"ShaOfPride_Maze_FXwrap_Center_01.M2", -- [74]
							"ShaOfPride_Maze_FXwrap_Center_02.M2", -- [75]
							"ShaOfPride_Maze_FXwrap_Center_03.M2", -- [76]
							"ShaOfPride_Maze_FXwrap_Center_04.M2", -- [77]
							"ShaOfPride_Maze_FXwrap_Circle_01.M2", -- [78]
							"ShaOfPride_Maze_FXwrap_LgL_02.M2", -- [79]
							"ShaOfPride_Maze_Fxwrap_LgL_01.M2", -- [80]
							"ShaOfPride_Maze_Fxwrap_LgL_03.M2", -- [81]
							"ShaOfPride_Maze_Fxwrap_LgL_04.M2", -- [82]
							"ShaOfPride_Maze_Fxwrap_smL_01.M2", -- [83]
							"ShaOfPride_Maze_Fxwrap_smL_02.M2", -- [84]
							"TrollSiegeWeapon.M2", -- [85]
							"UL_TeleportationPad_GroundFX.M2", -- [86]
							"UL_TeleportationPad_Sha.M2", -- [87]
							"Vale_Sha_Bubble.M2", -- [88]
							"ograid_bossdoor.M2", -- [89]
							"ograid_engine_flame2.M2", -- [90]
							"ograid_engine_flamefx.M2", -- [91]
							"ograid_fog_01.M2", -- [92]
							"ograid_horn.M2", -- [93]
							"ograid_mach_part01.M2", -- [94]
							"ograid_mach_part02.M2", -- [95]
							"ograid_mach_part03.M2", -- [96]
							"ograid_machinery.M2", -- [97]
							"ograid_spike.M2", -- [98]
							"ograid_spikelarge.M2", -- [99]
						},
						["N"] = "Orgrimmarraid",
					}, -- [14]
					{
						["T"] = {
							"PA_RoyalDoor_01.M2", -- [1]
							"PA_RoyalDoor_02.M2", -- [2]
							"PA_SecretSteps.M2", -- [3]
						},
						["N"] = "Royalquarters",
					}, -- [15]
					{
						["T"] = {
							{
								["T"] = {
									{
										["T"] = {
											"FishFountain.M2", -- [1]
											"MonasteryFalls.M2", -- [2]
										},
										["N"] = "Fountains",
									}, -- [1]
									{
										["T"] = {
											"StatueFountain.m2", -- [1]
											"StatueFountain_Mk2.M2", -- [2]
											"statueDMmountainking.m2", -- [3]
											"statueHEFranger.m2", -- [4]
											"statueHEMmage.M2", -- [5]
											"statueHFspear.m2", -- [6]
											"statueHFsunshield.m2", -- [7]
											"statueHFsunshieldClean.m2", -- [8]
											"statueHFtwinblades.m2", -- [9]
											"statueHMcaptain.m2", -- [10]
											"statueHMcaptainClean.m2", -- [11]
											"statueHMcrusader.m2", -- [12]
											"statueHMcrusaderClean.m2", -- [13]
											"statueHMcrusaderSoldier.M2", -- [14]
											"statueHMonearm.m2", -- [15]
											"statueHMpaladin.m2", -- [16]
											"statueHMpriest.m2", -- [17]
										},
										["N"] = "Statues",
									}, -- [2]
								},
								["N"] = "Passivedoodads",
							}, -- [1]
						},
						["N"] = "Scarletmonastery",
					}, -- [16]
					{
						["T"] = {
							{
								["T"] = {
									"PA_Shadowpan_SiegeWeapon_Large_01.M2", -- [1]
									"PA_Shadowpan_SiegeWeapon_Small_01.M2", -- [2]
								},
								["N"] = "Siegeweapon",
							}, -- [1]
							"PA_Banner_Shadowpan_TripleBanner_wall.M2", -- [2]
							"PA_ShadowpanBrazier.M2", -- [3]
							"PA_ShadowpanBrazierLong.M2", -- [4]
							"PA_ShadowpanBrazier_floor.M2", -- [5]
							"PA_ShadowpanDoor.M2", -- [6]
							"PA_ShadowpanDoorBroken.M2", -- [7]
							"PA_ShadowpanTentLarge.M2", -- [8]
							"PA_ShadowpanTentLarge_Destroyed_01.M2", -- [9]
							"PA_ShadowpanTentLarge_Destroyed_02.M2", -- [10]
							"PA_ShadowpanTentSmall.M2", -- [11]
							"PA_ShadowpanTentSmall_Destroyed_01.M2", -- [12]
							"PA_Shadowpan_ArenaThrone_01.M2", -- [13]
							"PA_Shadowpan_ArenaThrone_02.M2", -- [14]
							"PA_Shadowpan_Arenagate_01.M2", -- [15]
							"PA_Shadowpan_Barricade_01.M2", -- [16]
							"PA_Shadowpan_BigDojoDoor.M2", -- [17]
							"PA_Shadowpan_Containment_FX.M2", -- [18]
							"PA_Shadowpan_Gong_01.M2", -- [19]
							"PA_Shadowpan_IncenseHanging.M2", -- [20]
							"PA_Shadowpan_IncenseHangingLong.M2", -- [21]
							"PA_Shadowpan_Shrine.M2", -- [22]
							"PA_Shadowpan_Shrine_NoBase.M2", -- [23]
							"PA_Shadowpan_Torch_01.M2", -- [24]
							"PA_shadowpan_cage.M2", -- [25]
							"PA_shadowpan_cage_FX.M2", -- [26]
							"PA_shadowpan_candelabra.M2", -- [27]
							"PA_shadowpan_chainpost.M2", -- [28]
							"PA_shadowpan_circle_filigree.M2", -- [29]
							"PA_shadowpan_flat_filigree.M2", -- [30]
							"PA_shadowpan_largechain.M2", -- [31]
							"PA_shadowpan_lightrays.M2", -- [32]
							"PA_shadowpan_masters_Smallchain.M2", -- [33]
							"PA_shadowpan_masters_largechain.M2", -- [34]
							"PA_shadowpan_masters_mediumchain.M2", -- [35]
							"PA_shadowpan_mediumchain.M2", -- [36]
							"PA_shadowpan_post_mid_filigree.M2", -- [37]
							"PA_shadowpan_post_tiger.M2", -- [38]
							"PA_shadowpan_post_top_filigree.M2", -- [39]
							"PA_shadowpan_smallchain.M2", -- [40]
							"PA_shadowpan_squarepost_filigree.M2", -- [41]
						},
						["N"] = "Shadowpanhideout",
					}, -- [17]
					{
						["T"] = {
							"DWR_Plate_01.M2", -- [1]
							"DWR_Plate_02.M2", -- [2]
							"DWR_Plate_03.M2", -- [3]
							"DWR_Plate_04.M2", -- [4]
							"DWR_Plate_05.M2", -- [5]
						},
						["N"] = "Spineofthedestroyer",
					}, -- [18]
					{
						["T"] = {
							"Sunwell_Bushes.M2", -- [1]
							"Sunwell_Lamps.m2", -- [2]
							"Sunwell_Trees.m2", -- [3]
						},
						["N"] = "Sunwell",
					}, -- [19]
					{
						["T"] = {
							"PA_TerraceofEternity_falls1.M2", -- [1]
						},
						["N"] = "Terraceofeternity",
					}, -- [20]
					{
						["T"] = {
							{
								["T"] = {
									"Banner_Azshara_NightElf_01.M2", -- [1]
								},
								["N"] = "Banners",
							}, -- [1]
							"WOE_DemonSoul_01.M2", -- [2]
							"Well_Vortex_01.M2", -- [3]
							"WoE_Courtyard_Door01.M2", -- [4]
							"WoE_Fountain_Pool.M2", -- [5]
							"WoE_Palace_Doors.M2", -- [6]
							"WoE_Palace_Roots01.M2", -- [7]
							"WoE_Palace_Roots02.M2", -- [8]
							"WoE_Palace_Roots03.M2", -- [9]
							"WoE_Palace_Roots04.M2", -- [10]
							"WoE_Palace_platform.M2", -- [11]
							"WoE_Palace_stairway.M2", -- [12]
							"WoE_RedTree03.M2", -- [13]
							"WoE_Redstump.M2", -- [14]
							"WoE_Redtree01.M2", -- [15]
							"WoE_Redtree02.M2", -- [16]
							"WoE_Redtree04.M2", -- [17]
							"WoE_RedtreeTwisted01.M2", -- [18]
							"WoE_RedtreeTwisted02.M2", -- [19]
							"WoE_RedtreeTwistedPurple.M2", -- [20]
							"WoE_Well.M2", -- [21]
							"WoE_Well_02.M2", -- [22]
							"WoE_fallenTree.M2", -- [23]
						},
						["N"] = "Wellofeternity",
					}, -- [21]
				},
				["N"] = "Dungeon",
			}, -- [8]
			{
				["T"] = {
					{
						["T"] = {
							{
								["T"] = {
									{
										["T"] = {
											"Hive_Fireflies_01.m2", -- [1]
											"Hive_Fireflies_Large.m2", -- [2]
										},
										["N"] = "Fireflies",
									}, -- [1]
									{
										["T"] = {
											"Hive_lightshaft01.m2", -- [1]
											"Hive_lightshaft02.m2", -- [2]
										},
										["N"] = "Lightshaft",
									}, -- [2]
									{
										["T"] = {
											"Hive_Sand.m2", -- [1]
											"Hive_SandWaterfall.m2", -- [2]
										},
										["N"] = "Sandwaterfall",
									}, -- [3]
									{
										["T"] = {
											"HiveSteam.m2", -- [1]
										},
										["N"] = "Steam",
									}, -- [4]
								},
								["N"] = "Anquiraj",
							}, -- [1]
							{
								["T"] = {
									{
										["T"] = {
											"Carnival_Balloon_01.M2", -- [1]
											"Carnival_Balloon_02.M2", -- [2]
											"Carnival_Balloon_03.M2", -- [3]
										},
										["N"] = "Balloon",
									}, -- [1]
									{
										["T"] = {
											"Balloon_Bunch_01.M2", -- [1]
											"Balloon_Bunch_02.M2", -- [2]
										},
										["N"] = "Balloon_bunch",
									}, -- [2]
									"AnimalTrainer.M2", -- [3]
									"Carni_Cannon.M2", -- [4]
									"Carni_CannonTarget.m2", -- [5]
									"Carni_Wagon01.M2", -- [6]
									"Carni_Wagon_empty01.M2", -- [7]
									"CarnieTent_small01.m2", -- [8]
									"CarnieTent_small02.M2", -- [9]
									"Carnie_Merchant01.m2", -- [10]
									"CarnivalRailing.m2", -- [11]
									"Carnival_Banner01.m2", -- [12]
									"Carnival_Banner02.M2", -- [13]
									"CokeTent.m2", -- [14]
									"DarkMoonFairePoster.m2", -- [15]
									"DarkmoonFaire_Banners_01.M2", -- [16]
									"DarkmoonFaire_Banners_02.M2", -- [17]
									"DarkmoonFaire_Banners_03.M2", -- [18]
									"DarkmoonFaire_Entrance.M2", -- [19]
									"DarkmoonFaire_Fence_01.M2", -- [20]
									"DarkmoonFaire_Fence_Post.M2", -- [21]
									"DarkmoonFaire_GoldRing_01.M2", -- [22]
									"DarkmoonFaire_Post.M2", -- [23]
									"DarkmoonFaire_TonkWall_01.M2", -- [24]
									"DarkmoonFaire_TonkWall_02.M2", -- [25]
									"DarkmoonFaire_TonkWall_03.M2", -- [26]
									"DarkmoonFaire_TonkWall_04.M2", -- [27]
									"DarkmoonFaire_Wall_01.M2", -- [28]
									"Darkmoon_Eye.M2", -- [29]
									"Darkmoon_stringlights_all_large.M2", -- [30]
									"Darkmoon_stringlights_green.M2", -- [31]
									"Darkmoon_stringlights_purple.M2", -- [32]
									"Darkmoon_stringlights_yellow.M2", -- [33]
									"Darkmoon_whackagnoll_barrel.M2", -- [34]
									"Darkmoonbanner_ape.M2", -- [35]
									"Darkmoonbanner_cannon.M2", -- [36]
									"Darkmoonbanner_fortune.M2", -- [37]
									"Darkmoonbanner_pole.M2", -- [38]
									"Darkmoonbanner_wench.M2", -- [39]
									"FoodVendor.M2", -- [40]
									"FortuneTeller.M2", -- [41]
									"HayBail01.m2", -- [42]
									"HayBail02.m2", -- [43]
									"MerrygoRound_EyeFlags.M2", -- [44]
									"MerrygoRound_Mount_Dragon.M2", -- [45]
									"MerrygoRound_Mount_Gryphon.M2", -- [46]
									"MerrygoRound_Mount_Murloc.M2", -- [47]
									"MerrygoRound_Mount_Rocket.M2", -- [48]
									"MerrygoRound_Mount_Wyvern.M2", -- [49]
									"MerrygoRound_transport.M2", -- [50]
									"ShoutBox.m2", -- [51]
									"SouvenireShop.M2", -- [52]
									"SpookyEyes_01.M2", -- [53]
									"TargetPractice.M2", -- [54]
									"TicketMaster.M2", -- [55]
									"darkmoon_platform_gate.M2", -- [56]
								},
								["N"] = "Carnival",
							}, -- [2]
							{
								["T"] = {
									{
										["T"] = {
											"AltarTidalMastery01.m2", -- [1]
										},
										["N"] = "Altaroftidalmastery",
									}, -- [1]
									{
										["T"] = {
											"AirRift.M2", -- [1]
											"EarthRift.M2", -- [2]
											"FireRift.M2", -- [3]
											"WaterRift.m2", -- [4]
										},
										["N"] = "Elementalrifts",
									}, -- [2]
									{
										["T"] = {
											"Helpwantedposter.m2", -- [1]
										},
										["N"] = "Helpwantedposter",
									}, -- [3]
									{
										["T"] = {
											"NE_LanternBlue01.M2", -- [1]
										},
										["N"] = "Nightelflanternblue",
									}, -- [4]
									{
										["T"] = {
											"NE_Glaive01.M2", -- [1]
											"NE_Glaive02.m2", -- [2]
											"NE_Glaive03.m2", -- [3]
											"NE_Glaive04.M2", -- [4]
										},
										["N"] = "Nightelfweapons",
									}, -- [5]
									{
										["T"] = {
											"NovaGrave1.m2", -- [1]
										},
										["N"] = "Novagrave",
									}, -- [6]
									{
										["T"] = {
											"Horde_package01.M2", -- [1]
										},
										["N"] = "Package",
									}, -- [7]
									{
										["T"] = {
											"PaladinShrine.m2", -- [1]
										},
										["N"] = "Paladinshrine",
									}, -- [8]
									{
										["T"] = {
											"Generic_Steam_Cloud_Deepholm.M2", -- [1]
											"Generic_Steam_Cloud_Purple.M2", -- [2]
											"Generic_Steam_Cloud_Small.M2", -- [3]
											"Generic_Steam_Cloud_Teal.M2", -- [4]
											"Generic_Steam_Cloud_Thin.M2", -- [5]
											"Generic_Steam_Cloud_Thinner.M2", -- [6]
											"Generic_Steam_Cloud_Thinnest.M2", -- [7]
										},
										["N"] = "Steamclouds",
									}, -- [9]
								},
								["N"] = "Generaldoodads",
							}, -- [3]
							{
								["T"] = {
									"IcyRune01.m2", -- [1]
								},
								["N"] = "Naxxramas",
							}, -- [4]
							{
								["T"] = {
									{
										["T"] = {
											"PlagueCauldronActive.m2", -- [1]
											"PlagueCauldronActiveBase.m2", -- [2]
										},
										["N"] = "Activedoodads",
									}, -- [1]
								},
								["N"] = "Plaguelands",
							}, -- [5]
							{
								["T"] = {
									{
										["T"] = {
											"cracked_ice01.m2", -- [1]
										},
										["N"] = "Crackedice",
									}, -- [1]
								},
								["N"] = "Winterspringgrove",
							}, -- [6]
						},
						["N"] = "Doodad",
					}, -- [1]
				},
				["N"] = "Environment",
			}, -- [9]
			{
				["T"] = {
					{
						["T"] = {
							{
								["T"] = {
									{
										["T"] = {
											{
												["T"] = {
													"Arakkoahouse_InteriorGlow.m2", -- [1]
													"Arakkoahut_InteriorGlow.M2", -- [2]
													"Arakkoashack_InsideGlow.m2", -- [3]
												},
												["N"] = "Arakkoa_hut_glow",
											}, -- [1]
										},
										["N"] = "Passivedoodads",
									}, -- [1]
								},
								["N"] = "Arakkoa",
							}, -- [1]
							{
								["T"] = {
									{
										["T"] = {
											{
												["T"] = {
													"Auchindoun_Bridge_FX.M2", -- [1]
													"Auchindoun_Bridge_Spirits_Floating.m2", -- [2]
													"Auchindoun_Bridge_Spirits_Flying.M2", -- [3]
													"Auchindoun_Bridge_Spirits_Simple.m2", -- [4]
													"Auchindoun_Bridge_Swirl_Filler.M2", -- [5]
													"Auchindoun_Bridge_VolumeLight.m2", -- [6]
												},
												["N"] = "Bridge_fx",
											}, -- [1]
											{
												["T"] = {
													"Ancient_D_Coffin.m2", -- [1]
												},
												["N"] = "Coffin",
											}, -- [2]
											{
												["T"] = {
													"Auchindoun_Door_Swinging.m2", -- [1]
												},
												["N"] = "Doors",
											}, -- [3]
											{
												["T"] = {
													"Auchindoun_Ethereal_Ribbon_Type1.m2", -- [1]
													"Auchindoun_Ethereal_Ribbon_Type2.m2", -- [2]
													"Auchindoun_Ethereal_Ribbon_Type3.m2", -- [3]
													"Auchindoun_Ethereal_Ribbon_Type4.m2", -- [4]
													"Auchindoun_Ethereal_Ribbon_Type5.m2", -- [5]
												},
												["N"] = "Ethereal_ribbons",
											}, -- [4]
											{
												["T"] = {
													"Auch_Etherreal_Ribbon_Type1_Part_A.m2", -- [1]
													"Auch_Etherreal_Ribbon_Type1_Part_B.m2", -- [2]
													"Auch_Etherreal_Ribbon_Type1_Part_C.m2", -- [3]
													"Auch_Etherreal_Ribbon_Type2_Part_A.m2", -- [4]
													"Auch_Etherreal_Ribbon_Type2_Part_B.m2", -- [5]
													"Auch_Etherreal_Ribbon_Type2_Part_C.m2", -- [6]
													"Auch_Etherreal_Ribbon_Type3_Part_A.m2", -- [7]
													"Auch_Etherreal_Ribbon_Type3_Part_B.m2", -- [8]
													"Auch_Etherreal_Ribbon_Type3_Part_C.m2", -- [9]
													"Auch_Etherreal_Ribbon_Type4_Part_A.m2", -- [10]
													"Auch_Etherreal_Ribbon_Type4_Part_B.m2", -- [11]
													"Auch_Etherreal_Ribbon_Type4_Part_C.m2", -- [12]
													"Auch_Etherreal_Ribbon_Type5_Part_A.m2", -- [13]
													"Auch_Etherreal_Ribbon_Type5_Part_B.m2", -- [14]
													"Auch_Etherreal_Ribbon_Type5_Part_C.m2", -- [15]
												},
												["N"] = "Ethereal_ribbons_individual",
											}, -- [5]
											{
												["T"] = {
													"Draenei_Spirit_Head.M2", -- [1]
													"Draenei_Spirit_Red.M2", -- [2]
												},
												["N"] = "Spirit_fx",
											}, -- [6]
										},
										["N"] = "Passivedoodads",
									}, -- [1]
								},
								["N"] = "Auchindoun",
							}, -- [2]
							{
								["T"] = {
									{
										["T"] = {
											{
												["T"] = {
													"BT_CommonDoor.M2", -- [1]
													"BT_Gate.m2", -- [2]
													"BT_Gate_Solid.M2", -- [3]
													"BT_Illidan_Door.M2", -- [4]
													"BT_Illidan_Door_Left.M2", -- [5]
													"BT_Illidan_Door_Right.M2", -- [6]
													"BT_MainDoor.m2", -- [7]
													"BlackTemple_Gen_Door.m2", -- [8]
												},
												["N"] = "Doors",
											}, -- [1]
										},
										["N"] = "Activedoodads",
									}, -- [1]
									{
										["T"] = {
											{
												["T"] = {
													"BlackTemple_Waterfall_Type1.M2", -- [1]
												},
												["N"] = "Blueenergy",
											}, -- [1]
											{
												["T"] = {
													"BT_Brazier.m2", -- [1]
													"BT_Brazier_Blue.M2", -- [2]
													"BT_Brazier_Green.M2", -- [3]
													"BT_Brazier_Red.M2", -- [4]
													"BT_Brazier_Violet.M2", -- [5]
													"BT_Brazier_Yellow.M2", -- [6]
													"BT_Brazier_broken.m2", -- [7]
												},
												["N"] = "Brazier",
											}, -- [2]
											{
												["T"] = {
													"BT_Drapes.m2", -- [1]
												},
												["N"] = "Drapes",
											}, -- [3]
											{
												["T"] = {
													"BT_SewerFall.m2", -- [1]
													"BT_SewerGutter_Hall.m2", -- [2]
													"BT_SewerGutter_Section2.m2", -- [3]
													"BT_SewerRamp.m2", -- [4]
													"BT_SewerWater_BossRoom.m2", -- [5]
													"BT_SewerWater_Section1.m2", -- [6]
												},
												["N"] = "Sewerwater",
											}, -- [4]
											{
												["T"] = {
													"BT_StatueEyes.M2", -- [1]
													"BT_StatueEyes_Green.M2", -- [2]
												},
												["N"] = "Statue",
											}, -- [5]
											{
												["T"] = {
													"BT_Vines01.m2", -- [1]
													"BT_Vines02.m2", -- [2]
												},
												["N"] = "Vines",
											}, -- [6]
										},
										["N"] = "Passivedoodads",
									}, -- [2]
								},
								["N"] = "Blacktemple",
							}, -- [3]
							{
								["T"] = {
									{
										["T"] = {
											"BladesEdgeBush01.m2", -- [1]
											"BladesEdgeBush02.m2", -- [2]
										},
										["N"] = "Bush",
									}, -- [1]
									{
										["T"] = {
											"DarkPortal_BladesEdge_Particles.M2", -- [1]
										},
										["N"] = "Darkportal",
									}, -- [2]
									{
										["T"] = {
											"BEM_Dragon_01.m2", -- [1]
											"BEM_Dragon_02.m2", -- [2]
											"BEM_Dragon_03.m2", -- [3]
											"BEM_Dragon_04.m2", -- [4]
											"BEM_Dragon_05.m2", -- [5]
										},
										["N"] = "Dragon",
									}, -- [3]
									{
										["T"] = {
											{
												["T"] = {
													"Ogrila_Crystal01.m2", -- [1]
													"Ogrila_Crystal02.m2", -- [2]
													"Ogrila_Crystal03.m2", -- [3]
												},
												["N"] = "Ogrilacrystals",
											}, -- [1]
											{
												["T"] = {
													"Ogrila_Banner.m2", -- [1]
													"Ogrila_Hut.m2", -- [2]
												},
												["N"] = "Ogrilahut",
											}, -- [2]
										},
										["N"] = "Ogrila",
									}, -- [4]
									{
										["T"] = {
											"BladesEdgeCliffRock01.m2", -- [1]
											"BladesEdgeCliffRock02.m2", -- [2]
											"BladesEdgeCliffRock03.m2", -- [3]
											"BladesEdgeGroundRock01.m2", -- [4]
											"BladesEdgeGroundRock02.m2", -- [5]
											"BladesEdgeGroundRock03.m2", -- [6]
											"BladesEdgeRock_Finger01.m2", -- [7]
											"BladesEdgeRock_Finger02.m2", -- [8]
											"BladesEdgeRock_Finger03.m2", -- [9]
											"BladesEdgeRockarch01.m2", -- [10]
											"BladesEdgeRockarch02.m2", -- [11]
											"BladesEdgeRockbridge01.m2", -- [12]
											"BladesEdge_FloatingSmall01.m2", -- [13]
											"BladesEdge_FloatingSmall02.m2", -- [14]
											"BladesEdge_OverhangRock_Large_01.m2", -- [15]
											"BladesEdge_OverhangRock_Large_02.m2", -- [16]
											"BladesEdge_OverhangRock_Small_01.m2", -- [17]
											"BladesEdge_OverhangRock_Small_02.m2", -- [18]
											"BladesEdge_OverhangRock_Small_03.m2", -- [19]
										},
										["N"] = "Rocks",
									}, -- [5]
									{
										["T"] = {
											"SimonGame_FloatingCrystal.M2", -- [1]
											"SimonGame_LargeBase.m2", -- [2]
											"SimonGame_LargeBlueTree.m2", -- [3]
											"SimonGame_LargeGreenTree.m2", -- [4]
											"SimonGame_LargeRedTree.m2", -- [5]
											"SimonGame_LargeYellowTree.m2", -- [6]
											"SimonGame_SmallBlueBase.m2", -- [7]
											"SimonGame_SmallBlueTree.m2", -- [8]
											"SimonGame_SmallGreenBase.m2", -- [9]
											"SimonGame_SmallGreenTree.m2", -- [10]
											"SimonGame_SmallRedBase.m2", -- [11]
											"SimonGame_SmallRedTree.m2", -- [12]
											"SimonGame_SmallYellowBase.m2", -- [13]
											"SimonGame_SmallYellowTree.m2", -- [14]
										},
										["N"] = "Simon",
									}, -- [6]
									{
										["T"] = {
											"BladesEdgeCrater01.m2", -- [1]
											"BladesEdgeTree01.m2", -- [2]
											"BladesEdgeTree02.m2", -- [3]
											"BladesEdgeTree03.m2", -- [4]
											"BladesEdgeTree04.m2", -- [5]
											"BladesEdgeTree05.m2", -- [6]
											"BladesEdgeTree06.m2", -- [7]
											"BladesEdgeTree07.m2", -- [8]
											"BladesEdgeTree08.m2", -- [9]
											"BladesEdgeTreeStump.m2", -- [10]
											"BladesTerokkarBush01.m2", -- [11]
											"BladesTerokkarFallenTree.m2", -- [12]
											"BladesTerokkarTreeLarge.m2", -- [13]
											"BladesTerokkarTreeMedium.m2", -- [14]
											"BladesTerokkarTreeNoLeaves01.m2", -- [15]
											"BladesTerokkarTreeNoLeaves02.m2", -- [16]
											"BladesTerokkarTreeSapling.m2", -- [17]
											"BladesTerokkarTreeSmall.m2", -- [18]
											"BladesTerokkarTreeStump.m2", -- [19]
											"BladesTerokkarTreeStump02.m2", -- [20]
										},
										["N"] = "Trees",
									}, -- [7]
								},
								["N"] = "Bladesedge",
							}, -- [4]
							{
								["T"] = {
									{
										["T"] = {
											"Bloodmyst_BE_Portal.M2", -- [1]
										},
										["N"] = "Be_portal",
									}, -- [1]
									{
										["T"] = {
											"BloodmystCrystal01.m2", -- [1]
											"BloodmystCrystal02.m2", -- [2]
											"BloodmystCrystal03.m2", -- [3]
											"BloodmystCrystalAparatus01.m2", -- [4]
											"BloodmystCrystalBig01_Corrupted.m2", -- [5]
											"BloodmystCrystalBig02_Corrupted.m2", -- [6]
											"BloodmystCrystalBig03_Corrupted.m2", -- [7]
											"BloodmystCrystalFloating01.m2", -- [8]
											"BloodmystCrystalSmall01_Corrupted.m2", -- [9]
											"BloodmystCrystalSmall02_Corrupted.m2", -- [10]
											"BloodmystCrystalSmall03_Corrupted.m2", -- [11]
										},
										["N"] = "Crystals",
									}, -- [2]
									{
										["T"] = {
											"Bloodmyst_powercore.M2", -- [1]
											"PowerCore_Coil_FX.M2", -- [2]
										},
										["N"] = "Powercore",
									}, -- [3]
									{
										["T"] = {
											"BloodmystRockRune01.m2", -- [1]
											"BloodmystRockRune02.m2", -- [2]
										},
										["N"] = "Rocks",
									}, -- [4]
									{
										["T"] = {
											"BloodMystRedWaterfall.m2", -- [1]
											"BloodMystTree01_Web.m2", -- [2]
											"BloodMystTree02_Web.m2", -- [3]
											"BloodMystTree03_Web.m2", -- [4]
											"BloodMystTree07_Web.m2", -- [5]
											"BloodmystBush01.m2", -- [6]
											"BloodmystBush02.m2", -- [7]
											"BloodmystBush03.m2", -- [8]
											"BloodmystTree01.m2", -- [9]
											"BloodmystTree02.m2", -- [10]
											"BloodmystTreeCrystal01.m2", -- [11]
											"BloodmystTreeCrystal02.m2", -- [12]
											"BloodmystTreeFallen.m2", -- [13]
											"BloodmystTreeRunes01.m2", -- [14]
											"BloodmystTreeRunes02.M2", -- [15]
										},
										["N"] = "Trees",
									}, -- [5]
									{
										["T"] = {
											"CocoonTrap_Yellow.m2", -- [1]
											"Cocoon_Yellow.m2", -- [2]
											"NastySpiderWeb_Yellow.m2", -- [3]
											"SpiderEggSack_Yellow.m2", -- [4]
											"SpiderEggsGround_Yellow.m2", -- [5]
											"WebDangle_Yellow.m2", -- [6]
										},
										["N"] = "Webs",
									}, -- [6]
								},
								["N"] = "Bloodmyst",
							}, -- [5]
							{
								["T"] = {
									{
										["T"] = {
											"BoneWastesBoneShrine01.m2", -- [1]
										},
										["N"] = "Boneshrine",
									}, -- [1]
									{
										["T"] = {
											"BoneWastesTreeTrunk01.m2", -- [1]
											"BoneWastesTreeTrunk02.m2", -- [2]
											"BoneWastesTreeTrunk03.m2", -- [3]
											"BoneWastesTreeTrunk04.m2", -- [4]
											"BoneWastesTreeTrunk05.m2", -- [5]
											"BoneWastesTreeTrunk06.m2", -- [6]
										},
										["N"] = "Trees",
									}, -- [2]
								},
								["N"] = "Bonewastes",
							}, -- [6]
							{
								["T"] = {
									{
										["T"] = {
											{
												["T"] = {
													"CF_elevatorPlatform.m2", -- [1]
													"CF_elevatorPlatform_small.m2", -- [2]
												},
												["N"] = "Elevator",
											}, -- [1]
											{
												["T"] = {
													"Coilfang Towers E_Particle.M2", -- [1]
												},
												["N"] = "Energytower",
											}, -- [2]
											{
												["T"] = {
													"Coilfang_PumpingDoor.m2", -- [1]
												},
												["N"] = "Pumpingdoor",
											}, -- [3]
											{
												["T"] = {
													"Coilfang_Raid_Bridge_Part1.M2", -- [1]
													"Coilfang_Raid_Bridge_Part2.M2", -- [2]
													"Coilfang_Raid_Bridge_Part3.M2", -- [3]
												},
												["N"] = "Raid_bridge",
											}, -- [4]
											{
												["T"] = {
													"Coilfang_Raid_Bridge_Controls.m2", -- [1]
													"Coilfang_Raid_Console.M2", -- [2]
													"Coilfang_Raid_Gate.M2", -- [3]
												},
												["N"] = "Raid_bridge_control",
											}, -- [5]
											{
												["T"] = {
													"Coilfang_Raid_Door.m2", -- [1]
												},
												["N"] = "Raid_door",
											}, -- [6]
											{
												["T"] = {
													"Coilfang_steam_off_on.M2", -- [1]
												},
												["N"] = "Steam",
											}, -- [7]
										},
										["N"] = "Activedoodads",
									}, -- [1]
									{
										["T"] = {
											{
												["T"] = {
													"Coilfang_Blue_Energy.M2", -- [1]
												},
												["N"] = "Blueenergy",
											}, -- [1]
											{
												["T"] = {
													"cf_groundcage.m2", -- [1]
													"cf_hangingcage.m2", -- [2]
												},
												["N"] = "Cages",
											}, -- [2]
											{
												["T"] = {
													"Coilfang_Floor_Light.M2", -- [1]
													"Coilfang_Orb.M2", -- [2]
													"Coilfang_Orb_Orange.M2", -- [3]
													"Coilfang_Wall_Light.M2", -- [4]
													"Coilfang_circularLightwindow_BLUE.M2", -- [5]
												},
												["N"] = "Lights",
											}, -- [3]
											{
												["T"] = {
													"ZangarMushroom06_BlueGlow.m2", -- [1]
													"ZangarMushroom07_BlueGlow.m2", -- [2]
												},
												["N"] = "Mushrooms",
											}, -- [4]
											{
												["T"] = {
													"CF_pipeA.m2", -- [1]
													"CF_pipeB.m2", -- [2]
													"CF_pipeC.m2", -- [3]
												},
												["N"] = "Pipepieces",
											}, -- [5]
											{
												["T"] = {
													"Coilfang_pump.M2", -- [1]
													"Coilfang_pump_Raidwater.M2", -- [2]
												},
												["N"] = "Pump",
											}, -- [6]
											{
												["T"] = {
													"CF_Raid_giantpump.M2", -- [1]
												},
												["N"] = "Raid",
											}, -- [7]
											{
												["T"] = {
													"CF_railing.m2", -- [1]
												},
												["N"] = "Railing",
											}, -- [8]
											{
												["T"] = {
													"Coilfang_steam.M2", -- [1]
													"Coilfang_steam_Choppy.M2", -- [2]
												},
												["N"] = "Steam",
											}, -- [9]
											{
												["T"] = {
													"Coilfang_Marsh_Waterfall.M2", -- [1]
													"Coilfang_waterfall_Type1.m2", -- [2]
													"Coilfang_waterfall_Type2.m2", -- [3]
													"Coilfang_waterfall_Type3.m2", -- [4]
												},
												["N"] = "Waterfalls",
											}, -- [10]
											{
												["T"] = {
													"giantGlasswindow01.m2", -- [1]
												},
												["N"] = "Windows",
											}, -- [11]
										},
										["N"] = "Passivedoodads",
									}, -- [2]
								},
								["N"] = "Coilfang",
							}, -- [7]
							{
								["T"] = {
									{
										["T"] = {
											"BE_Fence_Eversong01.m2", -- [1]
											"BE_Fence_Eversong02.m2", -- [2]
											"BE_Fence_Eversong03.m2", -- [3]
										},
										["N"] = "Fence",
									}, -- [1]
									{
										["T"] = {
											"BE_Lamppost_Eversong01-optimized.M2", -- [1]
											"BE_Lamppost_Eversong01.M2", -- [2]
										},
										["N"] = "Lamppost",
									}, -- [2]
									{
										["T"] = {
											"BE_Signpost_Eversong.m2", -- [1]
											"BE_Signpost_Sign_Eversong.m2", -- [2]
										},
										["N"] = "Signpost",
									}, -- [3]
								},
								["N"] = "Eversong",
							}, -- [8]
							{
								["T"] = {
									{
										["T"] = {
											{
												["T"] = {
													"AO_Banner01.m2", -- [1]
													"AO_Banner02.m2", -- [2]
													"AO_Wall_Hanging_01.m2", -- [3]
													"AO_Wall_Hanging_02.m2", -- [4]
													"AO_Wall_Hanging_03.m2", -- [5]
													"AO_Wall_Hanging_04.m2", -- [6]
												},
												["N"] = "Banners",
											}, -- [1]
											{
												["T"] = {
													"AO_Barrel01.m2", -- [1]
												},
												["N"] = "Barrel",
											}, -- [2]
											{
												["T"] = {
													"AO_Boardwalk01.m2", -- [1]
													"AO_Boardwalk02.m2", -- [2]
													"AO_Boardwalk03.m2", -- [3]
													"AO_Boardwalk04.m2", -- [4]
													"AO_Boardwalk05.m2", -- [5]
													"AO_Boardwalk_Corner.m2", -- [6]
												},
												["N"] = "Boardwalk",
											}, -- [3]
											{
												["T"] = {
													"AO_BridgeLong01.m2", -- [1]
													"AO_BridgeLong02.m2", -- [2]
													"AO_Bridgerock01.m2", -- [3]
													"AO_Bridgetree01.m2", -- [4]
												},
												["N"] = "Bridgepieces",
											}, -- [4]
											{
												["T"] = {
													"AO_OrcCrate01.m2", -- [1]
													"AO_OrcCrate02.m2", -- [2]
													"AO_OrcCrate03.m2", -- [3]
												},
												["N"] = "Crates",
											}, -- [5]
											{
												["T"] = {
													"AO_Lamppost01.M2", -- [1]
													"AO_Lamppost02.M2", -- [2]
												},
												["N"] = "Lampost",
											}, -- [6]
											{
												["T"] = {
													"AO_OutpostWall01.m2", -- [1]
													"AO_OutpostWall02.m2", -- [2]
													"AO_OutpostWall03.m2", -- [3]
													"AO_OutpostWall04.m2", -- [4]
													"AO_OutpostWall05.m2", -- [5]
													"AO_OutpostWall06.m2", -- [6]
													"AO_OutpostWall07.m2", -- [7]
												},
												["N"] = "Outpostwalls",
											}, -- [7]
											{
												["T"] = {
													"AO_Pyre01.m2", -- [1]
													"AO_Pyre02.m2", -- [2]
												},
												["N"] = "Pyres",
											}, -- [8]
											{
												["T"] = {
													"AO_Signpost01.m2", -- [1]
													"AO_Signpostpointer01.m2", -- [2]
												},
												["N"] = "Signposts",
											}, -- [9]
											{
												["T"] = {
													"AO_Sticks_01.m2", -- [1]
												},
												["N"] = "Sticks",
											}, -- [10]
											{
												["T"] = {
													"AO_Totem01.m2", -- [1]
												},
												["N"] = "Totem",
											}, -- [11]
											{
												["T"] = {
													"AO_Windmill.m2", -- [1]
												},
												["N"] = "Windmill",
											}, -- [12]
										},
										["N"] = "Ancientorc",
									}, -- [1]
									{
										["T"] = {
											{
												["T"] = {
													"AK_banner01.m2", -- [1]
												},
												["N"] = "Banners",
											}, -- [1]
											{
												["T"] = {
													"AK_CrystalBall01.m2", -- [1]
													"AK_CrystalBall02.m2", -- [2]
												},
												["N"] = "Crystalball",
											}, -- [2]
											{
												["T"] = {
													"AK_Egg01.M2", -- [1]
													"AK_Egg02.m2", -- [2]
													"AK_Nest01.M2", -- [3]
													"AK_NestDebris01.M2", -- [4]
												},
												["N"] = "Nest",
											}, -- [3]
											{
												["T"] = {
													"AK_Scarecrow01.m2", -- [1]
												},
												["N"] = "Scarecrow",
											}, -- [4]
											{
												["T"] = {
													"Ak_Shelter01.m2", -- [1]
													"Ak_Shelter02.m2", -- [2]
													"Ak_Shelter03.m2", -- [3]
												},
												["N"] = "Shelters",
											}, -- [5]
											{
												["T"] = {
													"AK_Torch01.M2", -- [1]
												},
												["N"] = "Torch",
											}, -- [6]
											{
												["T"] = {
													"AK_Totem01.m2", -- [1]
													"AK_Totem02.m2", -- [2]
												},
												["N"] = "Totem",
											}, -- [7]
											{
												["T"] = {
													"AK_AlchemySet01.M2", -- [1]
													"AK_BlacksmithSet01.m2", -- [2]
												},
												["N"] = "Tradeskill",
											}, -- [8]
											"AK_AlchemyBottle01.M2", -- [9]
											"AK_AlchemyBottle02.m2", -- [10]
											"AK_AlchemyBottle03.m2", -- [11]
										},
										["N"] = "Arakkoa",
									}, -- [2]
									{
										["T"] = {
											{
												["T"] = {
													"BE_Ballista01.m2", -- [1]
													"BE_BallistaArm.m2", -- [2]
													"BE_BallistaRail.m2", -- [3]
													"BE_BallistaShield.m2", -- [4]
													"BE_BallistaSlide.m2", -- [5]
													"BE_BallistaWheel.m2", -- [6]
													"BE_BallistaWinch.m2", -- [7]
													"BE_BallistaWrecked01.m2", -- [8]
													"BE_StatueGhostlands01.M2", -- [9]
												},
												["N"] = "Ballista",
											}, -- [1]
											{
												["T"] = {
													"BE_Banner01.m2", -- [1]
													"BE_Banner02.m2", -- [2]
													"BE_Banner03.M2", -- [3]
													"BE_Banner04.M2", -- [4]
													"BE_Banner_Kael_01.M2", -- [5]
													"BE_Banner_Kael_02.m2", -- [6]
													"BE_Banner_Kael_03.m2", -- [7]
													"BE_Banner_ShatariSkyguard.M2", -- [8]
													"BE_Banner_TallBlack.m2", -- [9]
													"BE_Banner_TallBlue.m2", -- [10]
													"BE_Banner_TallPurple.m2", -- [11]
													"BE_Banner_TallRed.m2", -- [12]
													"BE_Banner_Wide_Black.m2", -- [13]
													"BE_Banner_Wide_Blue.m2", -- [14]
													"BE_Banner_Wide_Purple.m2", -- [15]
													"BE_Banner_Wide_Red.m2", -- [16]
													"BE_Banner_Wide_Red_Anim.m2", -- [17]
													"BE_Banner_Wide_Red_Anim02.m2", -- [18]
													"BE_Banner_Wide_Red_Anim03.m2", -- [19]
													"BE_Banner_Wide_Red_Torn01.m2", -- [20]
												},
												["N"] = "Banners",
											}, -- [2]
											{
												["T"] = {
													"be_bannister.m2", -- [1]
												},
												["N"] = "Bannister",
											}, -- [3]
											{
												["T"] = {
													"BE_Barrel_01.m2", -- [1]
													"BE_Barrel_01_NoCollision.m2", -- [2]
													"BE_Barrel_Broken_01.m2", -- [3]
													"BE_Barrel_Broken_02.m2", -- [4]
													"BE_Barrel_Fruit01.m2", -- [5]
												},
												["N"] = "Barrel",
											}, -- [4]
											{
												["T"] = {
													"BE_BarrierSpikes01.m2", -- [1]
													"BE_BarrierSpikes02.m2", -- [2]
													"BE_BarrierSpikes03.m2", -- [3]
												},
												["N"] = "Barrierspikes",
											}, -- [5]
											{
												["T"] = {
													"BE_Bed_01.M2", -- [1]
													"BE_Bed_02.m2", -- [2]
													"BE_Bed_Wrecked_01.m2", -- [3]
												},
												["N"] = "Beds",
											}, -- [6]
											{
												["T"] = {
													"BE_Bench01.m2", -- [1]
													"BE_Bench_Garden01.m2", -- [2]
													"BE_Bench_Wrecked_01.m2", -- [3]
												},
												["N"] = "Benches",
											}, -- [7]
											{
												["T"] = {
													"BE_Book_Large01.m2", -- [1]
													"BE_Book_Large02.m2", -- [2]
													"BE_Book_Large05.m2", -- [3]
													"BE_Book_Medium01.m2", -- [4]
													"BE_Book_Medium02.m2", -- [5]
													"BE_Book_Small01.m2", -- [6]
													"BE_Book_Small02.m2", -- [7]
												},
												["N"] = "Books",
											}, -- [8]
											{
												["T"] = {
													"BE_BookshelfEmpty_01.m2", -- [1]
													"BE_BookshelfEmpty_02.m2", -- [2]
													"BE_BookshelfFilled_01.M2", -- [3]
													"BE_BookshelfFilled_02.M2", -- [4]
													"BE_BookshelfShort.m2", -- [5]
													"BE_BookshelfSpiral.m2", -- [6]
													"BE_BookshelfTall.m2", -- [7]
													"BE_Bookshelf_Wrecked_01.M2", -- [8]
													"BE_Bookshelf_Wrecked_02.m2", -- [9]
												},
												["N"] = "Bookshelf",
											}, -- [9]
											{
												["T"] = {
													"BE_Bottle01.m2", -- [1]
													"BE_Bottle02.m2", -- [2]
													"BE_Bottle03.m2", -- [3]
													"BE_Bottle03_NoCollision.m2", -- [4]
													"BE_Bottle04.m2", -- [5]
													"BE_Bottle04_NoCollision.m2", -- [6]
												},
												["N"] = "Bottles",
											}, -- [10]
											{
												["T"] = {
													"BE_Mop01.M2", -- [1]
												},
												["N"] = "Broom",
											}, -- [11]
											{
												["T"] = {
													"BE_Campfire01.M2", -- [1]
													"BE_Campfire02.M2", -- [2]
												},
												["N"] = "Campfire",
											}, -- [12]
											{
												["T"] = {
													"BE_Candle_01.M2", -- [1]
													"BE_Candle_02.M2", -- [2]
													"BE_Candleabra01.m2", -- [3]
												},
												["N"] = "Candles",
											}, -- [13]
											{
												["T"] = {
													"BE_Chair01.m2", -- [1]
													"BE_Chair02.m2", -- [2]
													"BE_Chair03.M2", -- [3]
													"BE_Chair04.M2", -- [4]
													"BE_Chair_Wrecked_01.m2", -- [5]
													"BE_Chair_Wrecked_02.m2", -- [6]
													"BE_Throne_01.M2", -- [7]
												},
												["N"] = "Chairs",
											}, -- [14]
											{
												["T"] = {
													"BE_chandelier01.M2", -- [1]
												},
												["N"] = "Chandelier",
											}, -- [15]
											{
												["T"] = {
													"BE_cookPot01.M2", -- [1]
												},
												["N"] = "Cookpot",
											}, -- [16]
											{
												["T"] = {
													"BE_Couch01.m2", -- [1]
												},
												["N"] = "Couch",
											}, -- [17]
											{
												["T"] = {
													"BE_Crate01.m2", -- [1]
												},
												["N"] = "Crate",
											}, -- [18]
											{
												["T"] = {
													"BE_Cup01.m2", -- [1]
													"BE_Cup02.m2", -- [2]
													"BE_Mug01.m2", -- [3]
												},
												["N"] = "Cups",
											}, -- [19]
											{
												["T"] = {
													"BE_DemonCrystal_01.M2", -- [1]
													"BE_DemonCrystal_02.M2", -- [2]
												},
												["N"] = "Demoncrystals",
											}, -- [20]
											{
												["T"] = {
													"BE_DemonEnergyCollector01.M2", -- [1]
												},
												["N"] = "Demonenergycollectors",
											}, -- [21]
											{
												["T"] = {
													"BE_DraperyCircle_07.M2", -- [1]
													"BE_Drapery_01.m2", -- [2]
													"BE_Drapery_02.m2", -- [3]
													"BE_Drapery_03.m2", -- [4]
													"BE_Drapery_04.m2", -- [5]
													"BE_Drapery_05.m2", -- [6]
													"BE_Drapery_06.m2", -- [7]
												},
												["N"] = "Drapery",
											}, -- [22]
											{
												["T"] = {
													"BE_Fish01.m2", -- [1]
													"BE_Meat01.m2", -- [2]
												},
												["N"] = "Food",
											}, -- [23]
											{
												["T"] = {
													"BE_Forge.m2", -- [1]
													"BE_Forge01.m2", -- [2]
												},
												["N"] = "Forge",
											}, -- [24]
											{
												["T"] = {
													"BE_Fountain01.M2", -- [1]
													"BE_Fountain01_base.m2", -- [2]
													"BE_FountainInnardsSilvermoon.M2", -- [3]
												},
												["N"] = "Fountains",
											}, -- [25]
											{
												["T"] = {
													"BE_Gravestone01.m2", -- [1]
													"BE_Gravestone02.m2", -- [2]
													"BE_Gravestone03.m2", -- [3]
													"BE_Tomb01.m2", -- [4]
												},
												["N"] = "Graveyard",
											}, -- [26]
											{
												["T"] = {
													"BE_Hedge_Hanging01.m2", -- [1]
													"BE_Hedge_Hanging02.m2", -- [2]
													"BE_Hedge_Hanging03.m2", -- [3]
													"BE_Hedge_Hanging04.m2", -- [4]
													"BE_Hedge_Hanging05.m2", -- [5]
													"BE_Hedge_Hanging06.m2", -- [6]
													"BE_Hedge_Hanging07.m2", -- [7]
													"BE_Hedge_Hanging08.m2", -- [8]
													"BE_Hedge_Hanging09.m2", -- [9]
													"BE_Hedge_Hanging10.m2", -- [10]
													"BE_Hedge_Hanging11.m2", -- [11]
													"BE_Hedge_Hanging12.m2", -- [12]
													"SilvermoonHedge01.m2", -- [13]
												},
												["N"] = "Hedge",
											}, -- [27]
											{
												["T"] = {
													"BE_Hookah_01.m2", -- [1]
													"BE_Hookah_02.m2", -- [2]
												},
												["N"] = "Hookah",
											}, -- [28]
											{
												["T"] = {
													"BE_Incense_01.M2", -- [1]
												},
												["N"] = "Incense",
											}, -- [29]
											{
												["T"] = {
													"BE_Harp01.m2", -- [1]
													"BE_Lute01.m2", -- [2]
												},
												["N"] = "Instruments",
											}, -- [30]
											{
												["T"] = {
													"BE_jar_03.m2", -- [1]
													"BE_jar_04.m2", -- [2]
												},
												["N"] = "Jars",
											}, -- [31]
											{
												["T"] = {
													"BE_MagicalKnickKnack02.M2", -- [1]
													"BE_MagicalKnickKnack03.m2", -- [2]
													"BE_MagicalKnickKnack04.M2", -- [3]
												},
												["N"] = "Knickknacks",
											}, -- [32]
											{
												["T"] = {
													"BE_Lamp01.M2", -- [1]
												},
												["N"] = "Lamp",
											}, -- [33]
											{
												["T"] = {
													"BE_Lantern01.M2", -- [1]
												},
												["N"] = "Lantern",
											}, -- [34]
											{
												["T"] = {
													"BE_LavaPool.m2", -- [1]
												},
												["N"] = "Lava",
											}, -- [35]
											{
												["T"] = {
													"BE_Loom_01.m2", -- [1]
												},
												["N"] = "Loom",
											}, -- [36]
											{
												["T"] = {
													"BE_MerchantStand01.M2", -- [1]
													"BE_MerchantStand02.m2", -- [2]
													"BE_MerchantStand03.m2", -- [3]
													"BE_MerchantStand04.M2", -- [4]
												},
												["N"] = "Merchantstand",
											}, -- [37]
											{
												["T"] = {
													"BE_Roadpillar01.m2", -- [1]
												},
												["N"] = "Pillar",
											}, -- [38]
											{
												["T"] = {
													"BE_Pillow_01.m2", -- [1]
													"BE_Pillow_02.m2", -- [2]
													"BE_Pillow_03.m2", -- [3]
													"BE_Pillow_04.m2", -- [4]
												},
												["N"] = "Pillows",
											}, -- [39]
											{
												["T"] = {
													"BE_Planetarium.M2", -- [1]
													"BE_PlanetariumDestroyed01.m2", -- [2]
													"BE_PlanetariumDestroyed02.M2", -- [3]
													"BE_PlanetariumDestroyed03.m2", -- [4]
													"BE_PlanetariumDestroyed04.m2", -- [5]
													"BE_Planetarium_Active.M2", -- [6]
												},
												["N"] = "Planetarium",
											}, -- [40]
											{
												["T"] = {
													"BE_planter_flowers_01.m2", -- [1]
													"BE_planter_long_01.m2", -- [2]
													"BE_planter_long_02.m2", -- [3]
													"BE_planter_long_03.m2", -- [4]
													"BE_planter_medium_01.m2", -- [5]
													"BE_planter_medium_02.m2", -- [6]
													"BE_planter_medium_03.m2", -- [7]
													"BE_planter_short_01.m2", -- [8]
													"BE_planter_short_02.m2", -- [9]
													"BE_planter_short_03.m2", -- [10]
												},
												["N"] = "Planters",
											}, -- [41]
											{
												["T"] = {
													"BE_Podium01.M2", -- [1]
												},
												["N"] = "Podium",
											}, -- [42]
											{
												["T"] = {
													"BE_Signs_Wanted.m2", -- [1]
												},
												["N"] = "Posters",
											}, -- [43]
											{
												["T"] = {
													"BloodElf_PowerOrb_Green.M2", -- [1]
													"BloodElf_PowerOrb_Red.M2", -- [2]
													"BloodElf_PowerOrb_Red_NoSound.M2", -- [3]
												},
												["N"] = "Powerorb",
											}, -- [44]
											{
												["T"] = {
													"BE_RoadSign_Sign01.m2", -- [1]
												},
												["N"] = "Roadsign",
											}, -- [45]
											{
												["T"] = {
													"BE_Rowboat.m2", -- [1]
													"BE_Rowboatwrecked.m2", -- [2]
												},
												["N"] = "Rowboat",
											}, -- [46]
											{
												["T"] = {
													"BE_Rug_Large01.m2", -- [1]
													"BE_Rug_Large02.m2", -- [2]
													"BE_Rug_LargeRuined01.m2", -- [3]
													"BE_Rug_LargeRuined02.m2", -- [4]
													"BE_Rug_Medium01.m2", -- [5]
													"BE_Rug_Medium02.m2", -- [6]
													"BE_Rug_MediumRuined01.m2", -- [7]
													"BE_Rug_MediumRuined02.m2", -- [8]
													"BE_Rug_Small01.m2", -- [9]
													"BE_Rug_Small02.m2", -- [10]
													"BE_Rug_SmallRuined01.m2", -- [11]
													"BE_Rug_SmallRuined02.m2", -- [12]
												},
												["N"] = "Rugs",
											}, -- [47]
											{
												["T"] = {
													"BE_Runestone01.m2", -- [1]
												},
												["N"] = "Runestone",
											}, -- [48]
											{
												["T"] = {
													"BE_Sconce01.M2", -- [1]
													"BE_Sconce02.M2", -- [2]
												},
												["N"] = "Sconce",
											}, -- [49]
											{
												["T"] = {
													"BE_ScryingOrb.M2", -- [1]
													"BE_ScryingOrb_Epic.M2", -- [2]
												},
												["N"] = "Scryingorb",
											}, -- [50]
											{
												["T"] = {
													"BE_Shield01.m2", -- [1]
													"BE_Shield02.m2", -- [2]
													"BE_Shield03.m2", -- [3]
												},
												["N"] = "Shield",
											}, -- [51]
											{
												["T"] = {
													"BE_Signs_Alchemy.m2", -- [1]
													"BE_Signs_Axe.m2", -- [2]
													"BE_Signs_Bank.m2", -- [3]
													"BE_Signs_Book.m2", -- [4]
													"BE_Signs_Bow.m2", -- [5]
													"BE_Signs_Bread.m2", -- [6]
													"BE_Signs_Cheese.m2", -- [7]
													"BE_Signs_Cooking.m2", -- [8]
													"BE_Signs_Drink.m2", -- [9]
													"BE_Signs_Engineering.m2", -- [10]
													"BE_Signs_GeneralShop.m2", -- [11]
													"BE_Signs_Helm.m2", -- [12]
													"BE_Signs_Herbalism.m2", -- [13]
													"BE_Signs_Meat.m2", -- [14]
													"BE_Signs_Poison.m2", -- [15]
													"BE_Signs_Shield.m2", -- [16]
													"BE_Signs_Staff.m2", -- [17]
													"BE_Signs_Sword.m2", -- [18]
													"BE_Signs_Tailor.m2", -- [19]
													"BE_Signs_Tavern.m2", -- [20]
												},
												["N"] = "Shopsigns",
											}, -- [52]
											{
												["T"] = {
													"GhostlandsShroom01.m2", -- [1]
													"GhostlandsSporeMound01.m2", -- [2]
												},
												["N"] = "Shrooms",
											}, -- [53]
											{
												["T"] = {
													"BE_Statue01.m2", -- [1]
													"BE_Statue02.m2", -- [2]
													"BE_StatueBig.m2", -- [3]
													"BE_StatueMale.m2", -- [4]
													"BE_StatueRanger.m2", -- [5]
												},
												["N"] = "Statues",
											}, -- [54]
											{
												["T"] = {
													"BE_Table_Large01.m2", -- [1]
													"BE_Table_Large02.m2", -- [2]
													"BE_Table_Large03.m2", -- [3]
													"BE_Table_Wrecked_01.m2", -- [4]
													"BE_Table_Wrecked_02.m2", -- [5]
													"BE_table_small01.m2", -- [6]
												},
												["N"] = "Tables",
											}, -- [55]
											{
												["T"] = {
													"BE_Teleporter_01.m2", -- [1]
												},
												["N"] = "Teleporter",
											}, -- [56]
											{
												["T"] = {
													"BE_Tent01.m2", -- [1]
													"BE_Tent02.m2", -- [2]
													"BE_Tent03.m2", -- [3]
													"BE_Tent04.m2", -- [4]
													"BE_TentWrecked01.m2", -- [5]
													"BE_TentWrecked02.m2", -- [6]
													"BE_Tent_Red_01.M2", -- [7]
													"BE_Tent_Red_02.M2", -- [8]
												},
												["N"] = "Tents",
											}, -- [57]
											{
												["T"] = {
													"BE_Translocator.m2", -- [1]
													"BE_Translocator_minor.M2", -- [2]
												},
												["N"] = "Translocator",
											}, -- [58]
											{
												["T"] = {
													"GhostlandsSmallTree01.m2", -- [1]
													"GhostlandsSmallTree02.m2", -- [2]
													"GhostlandsSmallTree03.m2", -- [3]
													"GhostlandsTree01.m2", -- [4]
													"GhostlandsTree02.m2", -- [5]
													"GhostlandsTree03.m2", -- [6]
													"GhostlandsTree04.M2", -- [7]
													"GhostlandsTree05.M2", -- [8]
													"SilvermoonBush01.m2", -- [9]
													"SilvermoonBush02.m2", -- [10]
													"SilvermoonBush03.m2", -- [11]
													"SilvermoonBush04.m2", -- [12]
													"SilvermoonTree09.M2", -- [13]
													"SilvermoonTree10.M2", -- [14]
												},
												["N"] = "Trees",
											}, -- [59]
											{
												["T"] = {
													"BE_Wagon.m2", -- [1]
													"BE_Wagon02.m2", -- [2]
													"BE_Wagon_Wrecked.m2", -- [3]
												},
												["N"] = "Wagon",
											}, -- [60]
											{
												["T"] = {
													"BE_Weaponrack_01.m2", -- [1]
													"BE_Weaponrack_02.m2", -- [2]
												},
												["N"] = "Weaponracks",
											}, -- [61]
											{
												["T"] = {
													"BE_Knife01.m2", -- [1]
													"BE_Knife02.m2", -- [2]
													"BE_Knife03.m2", -- [3]
													"BE_Stave01.m2", -- [4]
													"BE_Stave02.m2", -- [5]
													"BE_Sword01.m2", -- [6]
													"BE_Sword02.m2", -- [7]
													"BE_Sword03.m2", -- [8]
												},
												["N"] = "Weapons",
											}, -- [62]
											"BE_Floating_Sunreaver_Symbol_01.M2", -- [63]
										},
										["N"] = "Bloodelf",
									}, -- [3]
									{
										["T"] = {
											{
												["T"] = {
													"BU_Banner_01.M2", -- [1]
													"BU_Banner_02.M2", -- [2]
												},
												["N"] = "Banners",
											}, -- [1]
											{
												["T"] = {
													"BU_Brazier_01.M2", -- [1]
												},
												["N"] = "Braziers",
											}, -- [2]
											{
												["T"] = {
													"BU_Cannon_01.M2", -- [1]
													"BU_Cannon_Base.m2", -- [2]
													"BU_Cannon_Base_02.m2", -- [3]
												},
												["N"] = "Cannon",
											}, -- [3]
											{
												["T"] = {
													"BU_CrystalForge.m2", -- [1]
													"BU_CrystalForgeController.m2", -- [2]
												},
												["N"] = "Crystalforge",
											}, -- [4]
											{
												["T"] = {
													"FelCannonBalls01.m2", -- [1]
													"FelCannonBalls02.m2", -- [2]
												},
												["N"] = "Felcannonballs",
											}, -- [5]
											{
												["T"] = {
													"BU_Felreaver_01.m2", -- [1]
													"BU_Felreaver_02.m2", -- [2]
													"BU_Felreaver_03.m2", -- [3]
													"BU_Felreaver_04.m2", -- [4]
													"BU_Felreaver_05.m2", -- [5]
													"BU_Felreaver_06.m2", -- [6]
												},
												["N"] = "Felreaver",
											}, -- [6]
											{
												["T"] = {
													"BU_Generator_01.M2", -- [1]
												},
												["N"] = "Generator",
											}, -- [7]
											{
												["T"] = {
													"BU_Junk_01.M2", -- [1]
													"BU_Junk_02.m2", -- [2]
													"BU_Oblisk_01.m2", -- [3]
													"BU_Smoke_Stack_01.M2", -- [4]
												},
												["N"] = "Ruins",
											}, -- [8]
											{
												["T"] = {
													"BU_Teleporter_01.M2", -- [1]
													"BU_Teleporter_02.M2", -- [2]
												},
												["N"] = "Teleporter",
											}, -- [9]
											{
												["T"] = {
													"BU_Forge_01.M2", -- [1]
												},
												["N"] = "Tradeskill",
											}, -- [10]
										},
										["N"] = "Burninglegion",
									}, -- [4]
									{
										["T"] = {
											{
												["T"] = {
													"DR_Banner01.M2", -- [1]
												},
												["N"] = "Banner",
											}, -- [1]
											{
												["T"] = {
													"Draenei_bed01.m2", -- [1]
												},
												["N"] = "Bed",
											}, -- [2]
											{
												["T"] = {
													"DR_Bench_01.m2", -- [1]
													"DR_Bench_01_NoSound.M2", -- [2]
												},
												["N"] = "Bench",
											}, -- [3]
											{
												["T"] = {
													"DR_Anvil_01.m2", -- [1]
													"DR_Forge_01.M2", -- [2]
													"DR_Forge_01_NoSound.M2", -- [3]
												},
												["N"] = "Blacksmith",
											}, -- [4]
											{
												["T"] = {
													"DR_Bottle_01.m2", -- [1]
													"DR_Bottle_02.m2", -- [2]
												},
												["N"] = "Bottles",
											}, -- [5]
											{
												["T"] = {
													"DR_Bowl_01.m2", -- [1]
													"DR_Bowl_02.m2", -- [2]
												},
												["N"] = "Bowls",
											}, -- [6]
											{
												["T"] = {
													"DR_Brazier_01.M2", -- [1]
													"DR_Brazier_02.M2", -- [2]
													"DR_Brazier_03.M2", -- [3]
												},
												["N"] = "Brazier",
											}, -- [7]
											{
												["T"] = {
													"DR_CABLE_WIDE_SILENT.M2", -- [1]
													"DR_cable_medium.m2", -- [2]
													"DR_cable_thin.M2", -- [3]
													"DR_cable_wide.m2", -- [4]
												},
												["N"] = "Cables",
											}, -- [8]
											{
												["T"] = {
													"DR_Chandelier_01.M2", -- [1]
													"DR_Chandelier_01_NoSound.M2", -- [2]
												},
												["N"] = "Chandelier",
											}, -- [9]
											{
												["T"] = {
													"DR_Cookpot_01.M2", -- [1]
												},
												["N"] = "Cookpots",
											}, -- [10]
											{
												["T"] = {
													"DR_crashplate01.m2", -- [1]
													"DR_crashplate02.m2", -- [2]
												},
												["N"] = "Crashplate",
											}, -- [11]
											{
												["T"] = {
													"DR_Crate_01.m2", -- [1]
													"DR_Crate_02.m2", -- [2]
												},
												["N"] = "Crates",
											}, -- [12]
											{
												["T"] = {
													"DR_CryoPod_Bottom.m2", -- [1]
													"DR_CryoPod_Intact.m2", -- [2]
													"DR_CryoPod_Top.m2", -- [3]
													"DR_CryoPod_Wrecked.m2", -- [4]
												},
												["N"] = "Cryopods",
											}, -- [13]
											{
												["T"] = {
													"HellfireCrystalFormation_01_pink.m2", -- [1]
												},
												["N"] = "Crystals",
											}, -- [14]
											{
												["T"] = {
													"DR_cup_01.m2", -- [1]
													"DR_cup_02.m2", -- [2]
												},
												["N"] = "Cups",
											}, -- [15]
											{
												["T"] = {
													"Tech_Arch01.M2", -- [1]
													"Tech_Arch02.M2", -- [2]
												},
												["N"] = "Draenei_arches",
											}, -- [16]
											{
												["T"] = {
													"Draenei_Wreckage_claw.m2", -- [1]
													"Draenei_Wreckage_frame.m2", -- [2]
													"Draenei_Wreckage_smallwindow.m2", -- [3]
												},
												["N"] = "Draenei_wreckage",
											}, -- [17]
											{
												["T"] = {
													"ExodarBridge01.M2", -- [1]
													"ExodarBridge02.m2", -- [2]
													"ExodarBridge03.M2", -- [3]
													"Exodarplatform01.M2", -- [4]
												},
												["N"] = "Exodar",
											}, -- [18]
											{
												["T"] = {
													"DR_ExodarWall01.m2", -- [1]
													"DR_ExodarWall02.m2", -- [2]
												},
												["N"] = "Exxodarwalls",
											}, -- [19]
											{
												["T"] = {
													"GlowyWaterStream01.m2", -- [1]
												},
												["N"] = "Fountain",
											}, -- [20]
											{
												["T"] = {
													"DR_fountian.m2", -- [1]
													"DR_fountian_ruined.m2", -- [2]
												},
												["N"] = "Fountian",
											}, -- [21]
											{
												["T"] = {
													"DR_glow.m2", -- [1]
													"DR_glow_blue.m2", -- [2]
													"DR_rays_blue.m2", -- [3]
													"DR_rays_orange.m2", -- [4]
													"DR_rays_pink.m2", -- [5]
												},
												["N"] = "Glow",
											}, -- [22]
											{
												["T"] = {
													"DR_Tomb.m2", -- [1]
													"DR_Tombstone01.m2", -- [2]
													"DR_Tombstone01_noCol.M2", -- [3]
													"DR_Tombstone02.m2", -- [4]
													"DR_Tombstone03.m2", -- [5]
												},
												["N"] = "Graveyard",
											}, -- [23]
											{
												["T"] = {
													"DR_Draenei_HoloRunes01.m2", -- [1]
													"DR_Draenei_HoloRunes01_Big.m2", -- [2]
													"DR_Draenei_HoloRunes01_BigRed.m2", -- [3]
													"DR_Draenei_HoloRunes02.m2", -- [4]
													"DR_Draenei_HoloRunes02_Big.m2", -- [5]
													"DR_Draenei_HoloRunes02_BigRed.m2", -- [6]
													"DR_Draenei_HoloRunes03.m2", -- [7]
													"DR_Draenei_HoloRunes03_Big.m2", -- [8]
													"DR_Draenei_HoloRunes03_BigRed.m2", -- [9]
												},
												["N"] = "Holo",
											}, -- [24]
											{
												["T"] = {
													"DR_holographic_stand.M2", -- [1]
												},
												["N"] = "Holographicstand",
											}, -- [25]
											{
												["T"] = {
													"DR_Banner02.m2", -- [1]
													"DR_CryoPod_Intact2.m2", -- [2]
													"DR_KnickKnack_01.M2", -- [3]
													"DR_KnickKnack_02.M2", -- [4]
													"DR_KnickKnack_02b.M2", -- [5]
													"DR_KnickKnack_02b_NoSound.M2", -- [6]
													"DR_KnickKnack_03.m2", -- [7]
													"DR_KnickKnack_04.M2", -- [8]
													"doodadSword_1H_Draenei_B_01.M2", -- [9]
													"doodadSword_1H_Draenei_C_01.M2", -- [10]
												},
												["N"] = "Knickknacks",
											}, -- [26]
											{
												["T"] = {
													"DR_Lamppost_01.m2", -- [1]
													"DR_Lamppost_02.m2", -- [2]
												},
												["N"] = "Lampposts",
											}, -- [27]
											{
												["T"] = {
													"DR_Lantern_01.M2", -- [1]
												},
												["N"] = "Lanterns",
											}, -- [28]
											{
												["T"] = {
													"DR_Loom_01.m2", -- [1]
												},
												["N"] = "Loom",
											}, -- [29]
											{
												["T"] = {
													"DR_MachineParts01.m2", -- [1]
												},
												["N"] = "Machines",
											}, -- [30]
											{
												["T"] = {
													"DalaranPostbox.M2", -- [1]
													"DraeneiPostbox.m2", -- [2]
												},
												["N"] = "Mailbox",
											}, -- [31]
											{
												["T"] = {
													"DR_Parasol_large.m2", -- [1]
													"DR_Parasol_small.m2", -- [2]
												},
												["N"] = "Parasol",
											}, -- [32]
											{
												["T"] = {
													"DR_signs_wanted.m2", -- [1]
												},
												["N"] = "Posters",
											}, -- [33]
											{
												["T"] = {
													"DR_signs_alchemy.m2", -- [1]
													"DR_signs_anvil.m2", -- [2]
													"DR_signs_axes.m2", -- [3]
													"DR_signs_bank.m2", -- [4]
													"DR_signs_book.m2", -- [5]
													"DR_signs_bow.m2", -- [6]
													"DR_signs_bread.m2", -- [7]
													"DR_signs_cheese.m2", -- [8]
													"DR_signs_container.m2", -- [9]
													"DR_signs_cooking.m2", -- [10]
													"DR_signs_engineering.m2", -- [11]
													"DR_signs_generalshop.m2", -- [12]
													"DR_signs_helm.m2", -- [13]
													"DR_signs_herbalism.m2", -- [14]
													"DR_signs_meat.m2", -- [15]
													"DR_signs_poisons.m2", -- [16]
													"DR_signs_shield.m2", -- [17]
													"DR_signs_staff.m2", -- [18]
													"DR_signs_swords.m2", -- [19]
													"DR_signs_tailor.m2", -- [20]
													"DR_signs_tavern.m2", -- [21]
												},
												["N"] = "Shopsigns",
											}, -- [34]
											{
												["T"] = {
													"DR_Signpost_01.m2", -- [1]
													"DR_Signpost_Sign01.m2", -- [2]
												},
												["N"] = "Signs",
											}, -- [35]
											{
												["T"] = {
													"DR_Table_Medium_01.m2", -- [1]
													"DR_Table_Small_02.m2", -- [2]
												},
												["N"] = "Tables",
											}, -- [36]
											{
												["T"] = {
													"FactoryBridge.M2", -- [1]
													"FactoryElevator.M2", -- [2]
													"FactoryEnergyCube.M2", -- [3]
													"FactoryEnergyCube_3x3.m2", -- [4]
													"FactoryFloor.M2", -- [5]
													"Narru_Crystal_Corrupted.m2", -- [6]
													"Narru_Crystal_Corrupted_NO_Lightning.m2", -- [7]
													"Raid_Circle_floor.M2", -- [8]
													"atriumbridge.M2", -- [9]
												},
												["N"] = "Tempestkeep",
											}, -- [37]
											{
												["T"] = {
													"DR_Tent_01.m2", -- [1]
													"DR_Tent_02.m2", -- [2]
												},
												["N"] = "Tents",
											}, -- [38]
											{
												["T"] = {
													"draenei_tubes.m2", -- [1]
													"draenei_tubes_NoSound.M2", -- [2]
													"draenei_tubes_offset.m2", -- [3]
												},
												["N"] = "Tubes",
											}, -- [39]
											{
												["T"] = {
													"Draenei_AncientWall01.m2", -- [1]
													"Draenei_AncientWall02.M2", -- [2]
												},
												["N"] = "Wall",
											}, -- [40]
										},
										["N"] = "Draenei",
									}, -- [5]
									{
										["T"] = {
											{
												["T"] = {
													"ET_Barrel01.M2", -- [1]
													"ET_Barrel01Off.m2", -- [2]
													"ET_Barrel01_NoSound.M2", -- [3]
												},
												["N"] = "Barrel",
											}, -- [1]
											{
												["T"] = {
													"ET_Cage.m2", -- [1]
													"ET_CageBase.m2", -- [2]
													"ET_CageBase_NoSound.M2", -- [3]
												},
												["N"] = "Cage",
											}, -- [2]
											{
												["T"] = {
													"ET_Collector01.M2", -- [1]
													"ET_Collector01_NoSound.M2", -- [2]
												},
												["N"] = "Collector",
											}, -- [3]
											{
												["T"] = {
													"ET_Crate01.M2", -- [1]
													"ET_Crate01Off.m2", -- [2]
													"ET_Crate01_NoSound.M2", -- [3]
												},
												["N"] = "Crate",
											}, -- [4]
											{
												["T"] = {
													"ET_CrystalForge.M2", -- [1]
													"ET_CrystalForgeController.M2", -- [2]
													"ET_CrystalForgeController_NoSound.M2", -- [3]
													"ET_CrystalForge_NoSound.M2", -- [4]
												},
												["N"] = "Crystalforge",
											}, -- [5]
											{
												["T"] = {
													"ET_Holographic_Stand.M2", -- [1]
												},
												["N"] = "Holographicstand",
											}, -- [6]
											{
												["T"] = {
													"ET_Lamppost01.M2", -- [1]
													"ET_Lamppost01Off.m2", -- [2]
												},
												["N"] = "Lamppost",
											}, -- [7]
											{
												["T"] = {
													"ET_Portal01.m2", -- [1]
													"ET_Portal01Off.m2", -- [2]
													"ET_Portal01OffHalf.m2", -- [3]
												},
												["N"] = "Portal",
											}, -- [8]
											{
												["T"] = {
													"ET_Standard.m2", -- [1]
												},
												["N"] = "Standard",
											}, -- [9]
											{
												["T"] = {
													"ET_Tent01.m2", -- [1]
													"ET_Tent02.m2", -- [2]
												},
												["N"] = "Tents",
											}, -- [10]
										},
										["N"] = "Ethereal",
									}, -- [6]
									{
										["T"] = {
											"FishFrenzy.m2", -- [1]
										},
										["N"] = "Fishfrenzy",
									}, -- [7]
									{
										["T"] = {
											{
												["T"] = {
													"Ghostlands_Gravestone01.m2", -- [1]
													"Ghostlands_Gravestone02.m2", -- [2]
													"Ghostlands_Gravestone03.m2", -- [3]
													"Ghostlands_Tomb01.m2", -- [4]
												},
												["N"] = "Graveyard",
											}, -- [1]
										},
										["N"] = "Ghostlands",
									}, -- [8]
									{
										["T"] = {
											"Hologram_DoomGuard.m2", -- [1]
											"Hologram_Dreadlord.M2", -- [2]
											"Hologram_Eredar.m2", -- [3]
											"Hologram_FelHound.m2", -- [4]
											"Hologram_Felguard.m2", -- [5]
											"Hologram_Ganarg.M2", -- [6]
											"Hologram_Imp.m2", -- [7]
											"Hologram_Infernal.m2", -- [8]
											"Hologram_Moarg.M2", -- [9]
											"Hologram_Pitlord.M2", -- [10]
											"Hologram_Shivan.M2", -- [11]
											"Hologram_Succubus.m2", -- [12]
											"Hologram_VoidWalker.M2", -- [13]
											"Hologram_Wrathguard.m2", -- [14]
										},
										["N"] = "Holograms",
									}, -- [9]
									{
										["T"] = {
											{
												["T"] = {
													"BannerIllidan.m2", -- [1]
												},
												["N"] = "Banners",
											}, -- [1]
										},
										["N"] = "Illidan",
									}, -- [10]
									{
										["T"] = {
											{
												["T"] = {
													"LO_Wagon_01.m2", -- [1]
												},
												["N"] = "Wagon",
											}, -- [1]
											{
												["T"] = {
													"LO_Weaponrack.m2", -- [1]
												},
												["N"] = "Weaponrack",
											}, -- [2]
										},
										["N"] = "Lostones",
									}, -- [11]
									{
										["T"] = {
											{
												["T"] = {
													"NA_Ark.M2", -- [1]
												},
												["N"] = "Ark",
											}, -- [1]
											{
												["T"] = {
													"NA_Artifact01.M2", -- [1]
												},
												["N"] = "Artifact",
											}, -- [2]
											{
												["T"] = {
													"NA_Banner01.m2", -- [1]
												},
												["N"] = "Banner",
											}, -- [3]
											{
												["T"] = {
													"NA_Barricade_01.M2", -- [1]
													"NA_Barricade_Pole.M2", -- [2]
													"NA_Barricade_Shell_01.M2", -- [3]
													"NA_Barricade_Shell_02.M2", -- [4]
													"NA_Crate01.m2", -- [5]
													"NA_Crate02.m2", -- [6]
													"NA_TankStopper_01.M2", -- [7]
												},
												["N"] = "Crates",
											}, -- [4]
											{
												["T"] = {
													"NA_Distiller.m2", -- [1]
												},
												["N"] = "Distiller",
											}, -- [5]
											{
												["T"] = {
													"NA_Jar01.m2", -- [1]
													"NA_Jar02.m2", -- [2]
												},
												["N"] = "Jars",
											}, -- [6]
											{
												["T"] = {
													"NagaPagodaHut01.m2", -- [1]
												},
												["N"] = "Pagoda",
											}, -- [7]
											{
												["T"] = {
													"NA_Torch01.m2", -- [1]
												},
												["N"] = "Torch",
											}, -- [8]
											{
												["T"] = {
													"NA_Weapon_01.M2", -- [1]
													"NA_Weapon_02.M2", -- [2]
													"NA_Weapon_03.M2", -- [3]
												},
												["N"] = "Weapons",
											}, -- [9]
											{
												["T"] = {
													"NA_WeaponRack01.M2", -- [1]
													"NA_WeaponRack01_no_weapons.M2", -- [2]
													"NA_WeaponRack02.M2", -- [3]
													"NA_WeaponRack02_no_weapons.M2", -- [4]
													"NA_WeaponRack03.M2", -- [5]
													"NA_WeaponRack03_no_weapons.M2", -- [6]
													"NA_WeaponStack01.M2", -- [7]
													"NA_WeaponStack02.m2", -- [8]
												},
												["N"] = "Weaponstacks",
											}, -- [10]
										},
										["N"] = "Naga",
									}, -- [12]
									{
										["T"] = {
											{
												["T"] = {
													"OM_Bones_01.m2", -- [1]
													"OM_Bones_02.m2", -- [2]
													"OM_Bones_03.m2", -- [3]
												},
												["N"] = "Bones",
											}, -- [1]
											{
												["T"] = {
													"OM_Chains_01.m2", -- [1]
													"OM_Chains_02.m2", -- [2]
													"OM_Chains_03.m2", -- [3]
													"OM_Chains_04.m2", -- [4]
												},
												["N"] = "Chains",
											}, -- [2]
											{
												["T"] = {
													"OM_Chair_01.m2", -- [1]
												},
												["N"] = "Chair",
											}, -- [3]
											{
												["T"] = {
													"OM_Campfire_01.m2", -- [1]
													"OM_Torch_01.m2", -- [2]
												},
												["N"] = "Fires",
											}, -- [4]
											{
												["T"] = {
													"OM_Forge_01.M2", -- [1]
												},
												["N"] = "Forge",
											}, -- [5]
											{
												["T"] = {
													"OM_Pillar_01.m2", -- [1]
													"OM_Pillar_01_Gray.M2", -- [2]
												},
												["N"] = "Pillar",
											}, -- [6]
											{
												["T"] = {
													"OM_Rock_01.m2", -- [1]
													"OM_Rock_02.m2", -- [2]
													"OM_Rock_03.m2", -- [3]
													"OM_Rock_04.m2", -- [4]
													"OM_Rock_05.m2", -- [5]
												},
												["N"] = "Rocks",
											}, -- [7]
											{
												["T"] = {
													"OM_Iron_Spike_01.m2", -- [1]
													"OM_Iron_Spike_02.m2", -- [2]
												},
												["N"] = "Spikes",
											}, -- [8]
											{
												["T"] = {
													"OM_Stonehenge_01.m2", -- [1]
													"OM_Stonehenge_02.m2", -- [2]
													"OM_Stonehenge_03.m2", -- [3]
												},
												["N"] = "Stonehenge",
											}, -- [9]
											{
												["T"] = {
													"OM_Table_01.m2", -- [1]
												},
												["N"] = "Table",
											}, -- [10]
											{
												["T"] = {
													"OM_Tent_01.m2", -- [1]
													"OM_Tent_02.m2", -- [2]
													"OM_Tent_03.m2", -- [3]
												},
												["N"] = "Tents",
											}, -- [11]
											{
												["T"] = {
													"OM_Totem_01.m2", -- [1]
												},
												["N"] = "Totem",
											}, -- [12]
											{
												["T"] = {
													"OM_Weaponrack_01.m2", -- [1]
													"OM_Weapons_01.M2", -- [2]
													"OM_Weapons_02.m2", -- [3]
													"OM_Weapons_03.m2", -- [4]
													"OM_Weapons_04.m2", -- [5]
												},
												["N"] = "Weapons",
											}, -- [13]
										},
										["N"] = "Ogre",
									}, -- [13]
									{
										["T"] = {
											{
												["T"] = {
													"OverhangRock_Large_01.m2", -- [1]
													"OverhangRock_Large_02.m2", -- [2]
													"OverhangRock_Large_03.m2", -- [3]
													"OverhangRock_Small_01.m2", -- [4]
													"OverhangRock_Small_02.m2", -- [5]
													"OverhangRock_Small_03.m2", -- [6]
												},
												["N"] = "Rocks",
											}, -- [1]
										},
										["N"] = "Outland",
									}, -- [14]
									{
										["T"] = {
											{
												["T"] = {
													"ShadowCouncil_Banner01.m2", -- [1]
													"ShadowCouncil_Banner02.m2", -- [2]
												},
												["N"] = "Banners",
											}, -- [1]
											{
												["T"] = {
													"ShadowCouncil_MagicDevice01.m2", -- [1]
													"ShadowCouncil_MagicDevice02.M2", -- [2]
												},
												["N"] = "Magicdevices",
											}, -- [2]
											{
												["T"] = {
													"ShadowCouncil_Tent01.m2", -- [1]
													"ShadowCouncil_Tent02.m2", -- [2]
												},
												["N"] = "Tents",
											}, -- [3]
											{
												["T"] = {
													"ShadowCouncil_Torch.m2", -- [1]
												},
												["N"] = "Torch",
											}, -- [4]
										},
										["N"] = "Shadowcouncil",
									}, -- [15]
									{
										["T"] = {
											{
												["T"] = {
													"JewelCraft_BlueHeart_01.M2", -- [1]
													"JewelCraft_Figurine01.M2", -- [2]
													"JewelCraft_Figurine02.M2", -- [3]
													"JewelCraft_Figurine03.M2", -- [4]
													"JewelCraft_GemCut_01.M2", -- [5]
													"JewelCraft_GemCut_02.m2", -- [6]
													"JewelCraft_GemCut_03.M2", -- [7]
													"JewelCraft_GemCut_04.M2", -- [8]
													"JewelCraft_GemUncut_01.m2", -- [9]
													"JewelCraft_GemUncut_02.m2", -- [10]
													"JewelCraft_GemUncut_03.M2", -- [11]
													"JewelCraft_Grinder01.M2", -- [12]
													"JewelCraft_Necklace01.M2", -- [13]
													"JewelCraft_Necklace02.M2", -- [14]
													"JewelCraft_Ring01.M2", -- [15]
													"JewelCraft_Ring02.M2", -- [16]
													"JewelCraft_Ring03.M2", -- [17]
												},
												["N"] = "Jewelcrafting",
											}, -- [1]
										},
										["N"] = "Tradeskill",
									}, -- [16]
									{
										["T"] = {
											{
												["T"] = {
													"VR_WeaponRack_01.m2", -- [1]
												},
												["N"] = "Weaponracks",
											}, -- [1]
										},
										["N"] = "Vrykul",
									}, -- [17]
								},
								["N"] = "Generic",
							}, -- [9]
							{
								["T"] = {
									{
										["T"] = {
											"Ghostlands_Arch_01.M2", -- [1]
										},
										["N"] = "Arch",
									}, -- [1]
									{
										["T"] = {
											"GhostlandsBush01.m2", -- [1]
											"GhostlandsBush02.m2", -- [2]
										},
										["N"] = "Bushes",
									}, -- [2]
									{
										["T"] = {
											"Fence_Ghostlands01.m2", -- [1]
											"Fence_Ghostlands02.m2", -- [2]
											"Fence_Ghostlands03.m2", -- [3]
											"Fence_Ghostlands04.m2", -- [4]
										},
										["N"] = "Fence",
									}, -- [3]
									{
										["T"] = {
											"BE_Lamppost_Ghostlands01.M2", -- [1]
											"BE_Lamppost_Ghostlands02.M2", -- [2]
										},
										["N"] = "Lampposts",
									}, -- [4]
									{
										["T"] = {
											"ghostlands_moonstone.M2", -- [1]
										},
										["N"] = "Moonstone",
									}, -- [5]
									{
										["T"] = {
											"ghostland_Obelisk_01.m2", -- [1]
											"ghostland_Obelisk_02.m2", -- [2]
											"ghostland_Obelisk_03.m2", -- [3]
										},
										["N"] = "Obelisk",
									}, -- [6]
									{
										["T"] = {
											"ghostland_planter_01.m2", -- [1]
											"ghostland_planter_02.m2", -- [2]
											"ghostland_planter_03.m2", -- [3]
										},
										["N"] = "Planter",
									}, -- [7]
									{
										["T"] = {
											"GL_BluePollen.m2", -- [1]
										},
										["N"] = "Pollen",
									}, -- [8]
									{
										["T"] = {
											"GhostlandsCliffRock01.m2", -- [1]
											"GhostlandsCliffRock02.m2", -- [2]
										},
										["N"] = "Rocks",
									}, -- [9]
									{
										["T"] = {
											"GhostlandsSmallRoots01.m2", -- [1]
											"GhostlandsSmallRoots02.m2", -- [2]
											"GhostlandsSmallRoots03.M2", -- [3]
											"GhostlandsSmallRoots04.M2", -- [4]
										},
										["N"] = "Roots",
									}, -- [10]
									{
										["T"] = {
											"BE_Signpost_Ghostlands.m2", -- [1]
											"BE_Signpost_Sign_Ghostlands.m2", -- [2]
										},
										["N"] = "Signpost",
									}, -- [11]
									{
										["T"] = {
											"Swath_Skull.m2", -- [1]
										},
										["N"] = "Skulls",
									}, -- [12]
									{
										["T"] = {
											"GhostlandsWebDangle_01.m2", -- [1]
											"GhostlandsWebDangle_02.m2", -- [2]
											"GhostlandsWeb_01.m2", -- [3]
											"GhostlandsWeb_02.m2", -- [4]
											"GhostlandsWeb_03.m2", -- [5]
											"Ghostlands_WebStretch_01.m2", -- [6]
										},
										["N"] = "Webs",
									}, -- [13]
								},
								["N"] = "Ghostlands",
							}, -- [10]
							{
								["T"] = {
									{
										["T"] = {
											{
												["T"] = {
													"MagtheradonCube.m2", -- [1]
												},
												["N"] = "Cube",
											}, -- [1]
											{
												["T"] = {
													"HF_Mag_door.M2", -- [1]
													"hellfire_Bossdoor01.m2", -- [2]
												},
												["N"] = "Doors",
											}, -- [2]
											{
												["T"] = {
													"Hellfire_Raid_FX.m2", -- [1]
													"Raid_Column_FX.m2", -- [2]
												},
												["N"] = "Raid_fx",
											}, -- [3]
										},
										["N"] = "Activedoodads",
									}, -- [1]
									{
										["T"] = {
											{
												["T"] = {
													{
														["T"] = {
														},
														["N"] = "Chamber",
													}, -- [1]
													{
														["T"] = {
														},
														["N"] = "Cracks",
													}, -- [2]
													{
														["T"] = {
														},
														["N"] = "Doors",
													}, -- [3]
													{
														["T"] = {
														},
														["N"] = "Summon_door",
													}, -- [4]
													{
														["T"] = {
														},
														["N"] = "Summoning_power_room",
													}, -- [5]
													{
														["T"] = {
														},
														["N"] = "Switches",
													}, -- [6]
												},
												["N"] = "Activedoodads",
											}, -- [1]
											{
												["T"] = {
													{
														["T"] = {
														},
														["N"] = "Chamber",
													}, -- [1]
													{
														["T"] = {
														},
														["N"] = "Cracks",
													}, -- [2]
													{
														["T"] = {
														},
														["N"] = "Doors",
													}, -- [3]
													{
														["T"] = {
														},
														["N"] = "Dw_banners",
													}, -- [4]
													{
														["T"] = {
														},
														["N"] = "Dw_braizer",
													}, -- [5]
													{
														["T"] = {
														},
														["N"] = "Dw_hooks",
													}, -- [6]
													{
														["T"] = {
														},
														["N"] = "Dw_lantern",
													}, -- [7]
													{
														["T"] = {
														},
														["N"] = "Dw_pipes",
													}, -- [8]
													{
														["T"] = {
														},
														["N"] = "Lantern",
													}, -- [9]
													{
														["T"] = {
														},
														["N"] = "Machine",
													}, -- [10]
												},
												["N"] = "Passivedoodads",
											}, -- [2]
										},
										["N"] = "Demonwing",
									}, -- [2]
									{
										["T"] = {
											{
												["T"] = {
													"Hellfire_banner_Type01.m2", -- [1]
													"Hellfire_banner_Type01_burning.m2", -- [2]
													"Hellfire_banner_Type02.m2", -- [3]
													"Hellfire_banner_Type03.m2", -- [4]
													"Hellfire_banner_Type04.m2", -- [5]
													"Hellfire_banner_TypeLarge_LongChain.m2", -- [6]
													"Hellfire_banner_TypeSmall_ShortChain.m2", -- [7]
													"Hellfire_banner_TypeWide.m2", -- [8]
												},
												["N"] = "Banners",
											}, -- [1]
											{
												["T"] = {
													"Hellfire_barrier.m2", -- [1]
												},
												["N"] = "Barrier",
											}, -- [2]
											{
												["T"] = {
													"Hellfire_FloorBraizer.m2", -- [1]
													"Hellfire_FloorBraizer_Broken.m2", -- [2]
													"Hellfire_FloorBraizer_Purple.m2", -- [3]
													"Hellfire_HangingBraizer.M2", -- [4]
													"Hellfire_HangingBraizer_PurpleFlame.M2", -- [5]
													"Hellfire_StandingBraizer_Purple.m2", -- [6]
												},
												["N"] = "Braizers",
											}, -- [3]
											{
												["T"] = {
													"Hellfire_militaryWing_Throne.m2", -- [1]
												},
												["N"] = "Throne",
											}, -- [4]
											{
												["T"] = {
													"Hellfire_GasTorch01.m2", -- [1]
												},
												["N"] = "Torches",
											}, -- [5]
										},
										["N"] = "Passivedoodads",
									}, -- [3]
								},
								["N"] = "Hellfirecitadel",
							}, -- [11]
							{
								["T"] = {
									{
										["T"] = {
											"Hellfire_OldOrcBanner01.m2", -- [1]
											"Hellfire_OldOrcBanner02.m2", -- [2]
										},
										["N"] = "Banners",
									}, -- [1]
									{
										["T"] = {
											"HellfireBushThorn01.m2", -- [1]
											"HellfireBushThorn02.m2", -- [2]
											"HellfireBushThorn03.m2", -- [3]
										},
										["N"] = "Bushes",
									}, -- [2]
									{
										["T"] = {
											"HellfireCrystal01.M2", -- [1]
											"HellfireCrystalFormation_01.m2", -- [2]
											"HellfireCrystalFormation_02.m2", -- [3]
											"HellfireCrystalFormation_03.m2", -- [4]
										},
										["N"] = "Crystals",
									}, -- [3]
									{
										["T"] = {
											"HellfireCurb_01.m2", -- [1]
											"HellfireCurb_02.m2", -- [2]
											"HellfireCurb_03.m2", -- [3]
											"HellfireCurb_Fire_01.m2", -- [4]
											"HellfireCurb_Fire_02.m2", -- [5]
											"Hellfire_fireparticle.M2", -- [6]
										},
										["N"] = "Curb",
									}, -- [4]
									{
										["T"] = {
											"Hellfire_DarkPortal_FX.M2", -- [1]
										},
										["N"] = "Darkportal",
									}, -- [5]
									{
										["T"] = {
											"DR_post_hellfire.m2", -- [1]
											"DR_post_hellfire_ruin.m2", -- [2]
											"DR_wall_hellfire.m2", -- [3]
											"DR_wall_hellfire_ruin.m2", -- [4]
										},
										["N"] = "Draeneifence",
									}, -- [6]
									{
										["T"] = {
											"Hellfire_Fel_Firewall_01.m2", -- [1]
											"Hellfire_Firewall_01.m2", -- [2]
										},
										["N"] = "Firewall",
									}, -- [7]
									{
										["T"] = {
											"Hellfire_gravestones_Alliance_01.m2", -- [1]
											"Hellfire_gravestones_Alliance_02.m2", -- [2]
											"Hellfire_gravestones_Alliance_03.m2", -- [3]
											"Hellfire_gravestones_Horde_01.m2", -- [4]
											"Hellfire_gravestones_Horde_02.m2", -- [5]
											"Hellfire_gravestones_Horde_03.m2", -- [6]
										},
										["N"] = "Gravestones",
									}, -- [8]
									{
										["T"] = {
											"HellfireFloatingRock_Large_01.m2", -- [1]
											"HellfireFloatingRock_Large_02.m2", -- [2]
											"HellfireFloatingRock_Large_03.m2", -- [3]
											"HellfireFloatingRock_Small_01.m2", -- [4]
											"HellfireFloatingRock_Small_02.m2", -- [5]
											"HellfireFloatingRock_Small_03.m2", -- [6]
										},
										["N"] = "Hellfirefloatingrock",
									}, -- [9]
									{
										["T"] = {
											"Hellfire_OverhangRock_Large_01.m2", -- [1]
											"Hellfire_OverhangRock_Large_02.m2", -- [2]
											"Hellfire_OverhangRock_Large_03.m2", -- [3]
											"Hellfire_OverhangRock_Small_01.m2", -- [4]
											"Hellfire_OverhangRock_Small_02.m2", -- [5]
											"Hellfire_OverhangRock_Small_03.m2", -- [6]
										},
										["N"] = "Hellfireoverhangrock",
									}, -- [10]
									{
										["T"] = {
											"HellfireWarpStorm01.M2", -- [1]
										},
										["N"] = "Hellfirewarpstorm",
									}, -- [11]
									{
										["T"] = {
											"Ancient_Drainei_LampPost.M2", -- [1]
											"Ancient_Drainei_LampPost_Ruined.m2", -- [2]
											"DR_Signpost_Sign_ancient.m2", -- [3]
											"DR_Signpost_ancient.m2", -- [4]
										},
										["N"] = "Lamppost",
									}, -- [12]
									{
										["T"] = {
											"HellfireMonolith01.m2", -- [1]
										},
										["N"] = "Monolith",
									}, -- [13]
									{
										["T"] = {
											"Ancient_draenei_plaform_06.m2", -- [1]
											"Ancient_draenei_plaform_07.m2", -- [2]
										},
										["N"] = "Platform",
									}, -- [14]
									{
										["T"] = {
											"Hellfire_PVPFlags_NorthFort.m2", -- [1]
											"Hellfire_PVPFlags_NorthFortFlagsA.M2", -- [2]
											"Hellfire_PVPFlags_NorthFortFlagsH.m2", -- [3]
											"Hellfire_PVPFlags_NorthFortFlagsN.M2", -- [4]
											"Hellfire_PVPFlags_SouthFort.m2", -- [5]
											"Hellfire_PVPFlags_SouthFortFlagsA.M2", -- [6]
											"Hellfire_PVPFlags_SouthFortFlagsH.m2", -- [7]
											"Hellfire_PVPFlags_SouthFortFlagsN.M2", -- [8]
											"Hellfire_PVPFlags_WestFort.m2", -- [9]
											"Hellfire_PVPFlags_WestFortFlagsA.M2", -- [10]
											"Hellfire_PVPFlags_WestFortFlagsH.m2", -- [11]
											"Hellfire_PVPFlags_WestFortFlagsN.M2", -- [12]
										},
										["N"] = "Pvpflags",
									}, -- [15]
									{
										["T"] = {
											"HellfireRock_Razor01.m2", -- [1]
											"HellfireRock_Razor02.m2", -- [2]
											"HellfireRock_Razor03.m2", -- [3]
											"HellfireRock_Short01.m2", -- [4]
											"HellfireRock_Short02.m2", -- [5]
											"HellfireRock_Short03.m2", -- [6]
											"HellfireRock_tall01.m2", -- [7]
											"HellfireRock_tall02.m2", -- [8]
											"HellfireRock_tall03.m2", -- [9]
										},
										["N"] = "Rocks",
									}, -- [16]
									{
										["T"] = {
											"HellfireCliffRocks01.m2", -- [1]
											"HellfireCliffRocks02.m2", -- [2]
											"HellfireCliffRocks03.m2", -- [3]
											"HellfireCliffRocks04.m2", -- [4]
											"HellfireCliffRocks05.m2", -- [5]
										},
										["N"] = "Rockscliff",
									}, -- [17]
									{
										["T"] = {
											"HellfireRocks_FloatingLarge01.m2", -- [1]
											"HellfireRocks_FloatingLarge02.m2", -- [2]
											"HellfireRocks_FloatingLarge03.m2", -- [3]
											"HellfireRocks_FloatingMedium01.m2", -- [4]
											"HellfireRocks_FloatingMedium02.m2", -- [5]
											"HellfireRocks_FloatingMedium03.m2", -- [6]
											"HellfireRocks_FloatingSmall01.m2", -- [7]
											"HellfireRocks_FloatingSmall02.m2", -- [8]
											"HellfireRocks_FloatingSmall03.m2", -- [9]
										},
										["N"] = "Rocksfloating",
									}, -- [18]
									{
										["T"] = {
											"HellfireSandTrap.m2", -- [1]
										},
										["N"] = "Sandtrap",
									}, -- [19]
									{
										["T"] = {
											"HellfireSupplies_01.m2", -- [1]
											"HellfireSupplies_02.M2", -- [2]
											"HellfireSupplies_03.M2", -- [3]
											"HellfireSupplies_04.M2", -- [4]
											"HellfireSupplies_05.m2", -- [5]
											"HellfireSupplies_06.m2", -- [6]
										},
										["N"] = "Supplies",
									}, -- [20]
									{
										["T"] = {
											"HellfireSeedPod01.m2", -- [1]
											"HellfireTreeThorns01.m2", -- [2]
											"HellfireTreeThorns02.m2", -- [3]
											"HellfireTreeThorns03.m2", -- [4]
											"HellfireTreeThorns04.m2", -- [5]
											"HellfireTreeThorns05.m2", -- [6]
											"HellfireTreeThorns06.m2", -- [7]
											"HellfireTreeThornsPods01.m2", -- [8]
										},
										["N"] = "Trees",
									}, -- [21]
									{
										["T"] = {
											"HumanWagon01.m2", -- [1]
											"OrcWagon07.m2", -- [2]
										},
										["N"] = "Wagons",
									}, -- [22]
								},
								["N"] = "Hellfirepeninsula",
							}, -- [12]
							{
								["T"] = {
									"m2_light_lightblue.m2", -- [1]
								},
								["N"] = "M2lights",
							}, -- [13]
							{
								["T"] = {
									{
										["T"] = {
											"NagrandBush01.m2", -- [1]
											"NagrandBush02.m2", -- [2]
											"NagrandBush03.m2", -- [3]
											"NagrandBush04.m2", -- [4]
										},
										["N"] = "Bush",
									}, -- [1]
									{
										["T"] = {
											"DarkPortal_Nagrand_Particles.M2", -- [1]
										},
										["N"] = "Darkportal",
									}, -- [2]
									{
										["T"] = {
											"DM_Crystal_Bunch.M2", -- [1]
											"DM_Crystal_Large.M2", -- [2]
											"DM_Crystal_Slim.M2", -- [3]
											"Diamond Moutain.M2", -- [4]
											"DiamondMountain_Bit.M2", -- [5]
											"DiamondMountain_Final.M2", -- [6]
											"DiamondMountain_MediumBit.M2", -- [7]
										},
										["N"] = "Diamondmount",
									}, -- [3]
									{
										["T"] = {
											"NagrandTest.m2", -- [1]
										},
										["N"] = "Grass",
									}, -- [4]
									{
										["T"] = {
											"Nagrand_Arch_01.m2", -- [1]
											"Nagrand_Arch_02.m2", -- [2]
											"Nagrand_Arch_03.m2", -- [3]
											"Nagrand_Arch_04.m2", -- [4]
											"Nagrand_Arch_05.m2", -- [5]
											"Nagrand_Arch_06.m2", -- [6]
											"Nagrand_Arch_07.m2", -- [7]
											"Nagrand_Arch_08.m2", -- [8]
											"Nagrand_Arch_09.m2", -- [9]
											"Nagrand_Arch_10.m2", -- [10]
											"Nagrand_Arch_11.m2", -- [11]
											"Nagrand_LargeRock_01.m2", -- [12]
											"Nagrand_LargeRock_02.m2", -- [13]
											"Nagrand_LargeRock_03.m2", -- [14]
											"Nagrand_RockFloating_Huge01.m2", -- [15]
											"Nagrand_SmallRock_01.m2", -- [16]
											"Nagrand_SmallRock_02.m2", -- [17]
											"Nagrand_SmallRock_03.m2", -- [18]
											"Nagrand_SmallRock_04.m2", -- [19]
											"Nagrand_SmallRock_05.m2", -- [20]
											"Nagrand_SmallRock_06.m2", -- [21]
											"Nagrand_Waterfalls_ForFloatingRocks.m2", -- [22]
										},
										["N"] = "Rocks",
									}, -- [5]
									{
										["T"] = {
											"NagrandCorruptedRoot01.m2", -- [1]
											"NagrandCorruptedRoot02.m2", -- [2]
											"NagrandRoot01.m2", -- [3]
											"NagrandRoot01varA.m2", -- [4]
											"NagrandRoot02.m2", -- [5]
											"NagrandRoot02varA.m2", -- [6]
											"NagrandRoot03.m2", -- [7]
											"NagrandRoot03varA.m2", -- [8]
											"NagrandRoot04.m2", -- [9]
											"NagrandRoot04varA.m2", -- [10]
											"NagrandRoot05.m2", -- [11]
											"NagrandRoot05varA.m2", -- [12]
										},
										["N"] = "Roots",
									}, -- [6]
									{
										["T"] = {
											"NagrandCorruptedTree01.m2", -- [1]
											"NagrandCorruptedTree02.m2", -- [2]
											"NagrandCorruptedTree03.m2", -- [3]
											"NagrandTree01.m2", -- [4]
											"NagrandTree02.m2", -- [5]
											"NagrandTree03.m2", -- [6]
											"NagrandTree04.m2", -- [7]
											"NagrandTree05.m2", -- [8]
											"NagrandTree06.m2", -- [9]
											"NagrandTree07.m2", -- [10]
											"NagrandTree08.m2", -- [11]
											"NagrandTree09.m2", -- [12]
										},
										["N"] = "Trees",
									}, -- [7]
								},
								["N"] = "Nagrand",
							}, -- [14]
							{
								["T"] = {
									{
										["T"] = {
											"NS_BioDome_All_FX_North.m2", -- [1]
											"NS_BioDome_All_FX_South.m2", -- [2]
											"NS_BioDome_All_FX_Stormspire.m2", -- [3]
											"NS_BioDome_BG.m2", -- [4]
											"NS_BioDome_Generic.m2", -- [5]
											"NS_BioDome_Stormspire.m2", -- [6]
											"NS_BioDome_device.M2", -- [7]
											"NS_BioDome_pylon_effects.m2", -- [8]
										},
										["N"] = "Biodomes",
									}, -- [1]
									{
										["T"] = {
											"NetherCollectorCap.m2", -- [1]
										},
										["N"] = "Collectorcap",
									}, -- [2]
									{
										["T"] = {
											"CollectorTop.m2", -- [1]
											"CollectorTop_Nether.m2", -- [2]
											"CollectorTop_off.m2", -- [3]
										},
										["N"] = "Collectortop",
									}, -- [3]
									{
										["T"] = {
											"CollectorTubes.M2", -- [1]
											"CollectorTubes_building_attach.m2", -- [2]
											"CollectorTubes_building_attach_off.m2", -- [3]
											"CollectorTubes_joint_45.m2", -- [4]
											"CollectorTubes_joint_90.m2", -- [5]
											"CollectorTubes_joint_ground.m2", -- [6]
											"CollectorTubes_straight.m2", -- [7]
											"CollectorTubes_straight_medium.m2", -- [8]
											"CollectorTubes_straight_medium_off.m2", -- [9]
											"CollectorTubes_straight_off.m2", -- [10]
											"CollectorTubes_straight_short.m2", -- [11]
											"CollectorTubes_straight_short_off.m2", -- [12]
											"CollectorTubes_straight_states.m2", -- [13]
											"CollectorTubes_support.m2", -- [14]
										},
										["N"] = "Collectortubes",
									}, -- [4]
									{
										["T"] = {
											"NetherstormCrackSmoke01.m2", -- [1]
											"NetherstormCrackSmokeBlue.m2", -- [2]
										},
										["N"] = "Crackeffects",
									}, -- [5]
									{
										["T"] = {
											"NetherGraveDirtMound01.m2", -- [1]
										},
										["N"] = "Dirt",
									}, -- [6]
									{
										["T"] = {
											"Netherstorm_Particles.m2", -- [1]
											"Netherstorm_Particles_Pink.m2", -- [2]
										},
										["N"] = "Float_particles",
									}, -- [7]
									{
										["T"] = {
											"Netherstorm_FloatingSmall01.M2", -- [1]
											"Netherstorm_FloatingSmall02.M2", -- [2]
											"Netherstorm_OverhangRock_Large_01.m2", -- [3]
											"Netherstorm_OverhangRock_Large_02.m2", -- [4]
											"Netherstorm_OverhangRock_Small_01.m2", -- [5]
											"Netherstorm_OverhangRock_Small_02.m2", -- [6]
											"Netherstorm_OverhangRock_Small_03.m2", -- [7]
											"Netherstorm_Short02.m2", -- [8]
										},
										["N"] = "Floatingrocks",
									}, -- [8]
									{
										["T"] = {
											"OL_GoblinBridge_Gears01.m2", -- [1]
										},
										["N"] = "Goblinbridge",
									}, -- [9]
									{
										["T"] = {
											"Netherstorm_GoblinWall01.m2", -- [1]
											"Netherstorm_GoblinWall02.m2", -- [2]
											"Netherstorm_GoblinWallCurve01.m2", -- [3]
											"Netherstorm_GoblinWallGate01.m2", -- [4]
											"Netherstorm_GoblinWallPost01.m2", -- [5]
											"Netherstorm_GoblinWall_BlastEast.m2", -- [6]
											"Netherstorm_GoblinWall_BlastWest.m2", -- [7]
										},
										["N"] = "Goblinwall",
									}, -- [10]
									{
										["T"] = {
											"NetherstormCrackLighting01.m2", -- [1]
											"NetherstormCrackSmokeOnly01.m2", -- [2]
											"NetherstormLightning01.m2", -- [3]
											"NetherstormLightning02.m2", -- [4]
											"NetherstormLightning03.m2", -- [5]
											"NetherstormLightning04.m2", -- [6]
											"NetherstormLightning05.m2", -- [7]
											"NetherstormLightning06.m2", -- [8]
										},
										["N"] = "Lightning",
									}, -- [11]
									{
										["T"] = {
											"NS_Rock_01.m2", -- [1]
											"NS_Rock_02.m2", -- [2]
											"NS_Rock_03.m2", -- [3]
											"NS_Rock_04.m2", -- [4]
											"NS_Rock_05.m2", -- [5]
											"NS_Rock_06.m2", -- [6]
											"NS_Rock_07.m2", -- [7]
											"NS_Rock_08.m2", -- [8]
											"NS_Rock_09.m2", -- [9]
											"NS_Rock_10.m2", -- [10]
											"NS_Rock_11.m2", -- [11]
											"NS_Rock_12.m2", -- [12]
											"NS_Rock_13.m2", -- [13]
											"NS_Rock_14.m2", -- [14]
										},
										["N"] = "Rocks",
									}, -- [12]
									{
										["T"] = {
											"NetherstormSporeMound01.m2", -- [1]
										},
										["N"] = "Sporemound",
									}, -- [13]
								},
								["N"] = "Netherstorm",
							}, -- [15]
							{
								["T"] = {
									{
										["T"] = {
											{
												["T"] = {
													"PVP_Lordaeron_Door.m2", -- [1]
													"PVP_Ogre_Door_Front.m2", -- [2]
													"PVP_Ogre_Door_Interior.m2", -- [3]
													"PVP_Orc_Door_Front.m2", -- [4]
													"PVP_Orc_Door_Interior.m2", -- [5]
												},
												["N"] = "Doors",
											}, -- [1]
										},
										["N"] = "Activedoodads",
									}, -- [1]
								},
								["N"] = "Pvp",
							}, -- [16]
							{
								["T"] = {
									{
										["T"] = {
											"OL_DwarvenBattlementMossy01.m2", -- [1]
											"OL_DwarvenBattlementMossy02.m2", -- [2]
											"OL_DwarvenBattlementMossy03.m2", -- [3]
											"OL_DwarvenBattlementMossy04.m2", -- [4]
											"OL_DwarvenBattlementMossy05.m2", -- [5]
											"OL_DwarvenBattlementMossy06.m2", -- [6]
											"OL_DwarvenBattlementMossy07.m2", -- [7]
											"OL_LochLampPost.m2", -- [8]
											"OL_LochModanStoneFence02.m2", -- [9]
										},
										["N"] = "Base",
									}, -- [1]
									{
										["T"] = {
											"ShadowmoonBlackTempleBrazier01.m2", -- [1]
										},
										["N"] = "Brazier",
									}, -- [2]
									{
										["T"] = {
											"ChromaticCrystralFormation_01.m2", -- [1]
											"ChromaticCrystralFormation_02.m2", -- [2]
											"ChromaticCrystralFormation_03.m2", -- [3]
										},
										["N"] = "Crystals",
									}, -- [3]
									{
										["T"] = {
											"Shadowmoon_gravestones_Horde_01.m2", -- [1]
											"Shadowmoon_gravestones_Horde_02.m2", -- [2]
											"Shadowmoon_gravestones_Horde_03.m2", -- [3]
										},
										["N"] = "Graveyard",
									}, -- [4]
									{
										["T"] = {
											"Shadowmoon_lavaguyser.m2", -- [1]
											"Shadowmoon_lavasplash01.m2", -- [2]
											"Shadowmoon_lavasplash02.M2", -- [3]
										},
										["N"] = "Guyser",
									}, -- [5]
									{
										["T"] = {
											"ShadowmoonLavaPlaug01.m2", -- [1]
											"ShadowmoonLavaPlaug02.m2", -- [2]
										},
										["N"] = "Lavaplugs",
									}, -- [6]
									{
										["T"] = {
											"MarkofKael.m2", -- [1]
										},
										["N"] = "Markofkael",
									}, -- [7]
									{
										["T"] = {
											"ShadowmoonMeteorA.M2", -- [1]
											"ShadowmoonMeteorB.M2", -- [2]
											"ShadowmoonMeteorC.M2", -- [3]
											"ShadowmoonMeteorD.M2", -- [4]
											"ShadowmoonMeteorE.M2", -- [5]
										},
										["N"] = "Meteor",
									}, -- [8]
									{
										["T"] = {
											"infernallowpoly.m2", -- [1]
										},
										["N"] = "Quest",
									}, -- [9]
									{
										["T"] = {
											"Shadowmoon_FloatingSmall01.M2", -- [1]
											"Shadowmoon_FloatingSmall02.m2", -- [2]
											"Shadowmoon_OverhangRock_Large_01.m2", -- [3]
											"Shadowmoon_OverhangRock_Large_02.m2", -- [4]
											"Shadowmoon_OverhangRock_Small_01.m2", -- [5]
											"Shadowmoon_OverhangRock_Small_02.m2", -- [6]
											"Shadowmoon_OverhangRock_Small_03.m2", -- [7]
											"Shadowmoon_Short02.m2", -- [8]
											"Shadowmoon_rock_01.m2", -- [9]
											"Shadowmoon_rock_02.m2", -- [10]
											"Shadowmoon_rock_03.m2", -- [11]
											"Shadowmoon_rock_04.m2", -- [12]
											"Shadowmoon_rock_05.m2", -- [13]
											"Shadowmoon_rock_06.m2", -- [14]
											"Shadowmoon_rock_07.m2", -- [15]
										},
										["N"] = "Rocks",
									}, -- [10]
									{
										["T"] = {
											"shadowmoon_rune1.M2", -- [1]
											"shadowmoon_rune2.M2", -- [2]
										},
										["N"] = "Rune",
									}, -- [11]
									{
										["T"] = {
											"Shadowmoon_scaffolding01.m2", -- [1]
											"Shadowmoon_scaffolding02.m2", -- [2]
											"Shadowmoon_scaffolding03.m2", -- [3]
										},
										["N"] = "Scaffolding",
									}, -- [12]
									{
										["T"] = {
											"BurningAsh02.M2", -- [1]
											"BurningAsh03.M2", -- [2]
											"ShadowmoonCrackSmoke01.m2", -- [3]
										},
										["N"] = "Smoke",
									}, -- [13]
									{
										["T"] = {
											"ShadowmoonVolcanoTop.m2", -- [1]
										},
										["N"] = "Volcano",
									}, -- [14]
								},
								["N"] = "Shadowmoon",
							}, -- [17]
							{
								["T"] = {
									{
										["T"] = {
											{
												["T"] = {
													"AncDrae_elevatorPiece.m2", -- [1]
													"AncDrae_elevatorPiece_netherstorm.m2", -- [2]
												},
												["N"] = "Elevator",
											}, -- [1]
											{
												["T"] = {
													"shattrathSoupTent.m2", -- [1]
												},
												["N"] = "Events",
											}, -- [2]
										},
										["N"] = "Activedoodads",
									}, -- [1]
									{
										["T"] = {
											{
												["T"] = {
													"BattlemasterPedestal.m2", -- [1]
												},
												["N"] = "Battlemasterpedestal",
											}, -- [1]
											{
												["T"] = {
													"Ancient_D_Bookshelf.m2", -- [1]
												},
												["N"] = "Bookshelf",
											}, -- [2]
											{
												["T"] = {
													"Shattrath_Narru_Energy_FX.m2", -- [1]
												},
												["N"] = "Central_energy_fx",
											}, -- [3]
											{
												["T"] = {
													"HF_outpostcrystals.m2", -- [1]
													"Outpost_Crystals1.m2", -- [2]
													"Shattrath_Crystal_Bank.m2", -- [3]
													"Shattrath_Crystal_Inn_Bottom.m2", -- [4]
													"Shattrath_Crystal_Inn_Floating.M2", -- [5]
													"Shattrath_Crystal_Temple_EXT.m2", -- [6]
													"Shattrath_Crystal_Temple_INT.m2", -- [7]
													"Shattrath_Crystal_Terrace.m2", -- [8]
													"Shattrath_Crystal_holyAldurtemple.m2", -- [9]
													"Shattrath_Crystal_hutA.m2", -- [10]
													"Shattrath_Crystal_hutB.m2", -- [11]
													"Shattrath_Crystal_hutC.m2", -- [12]
													"Shattrath_Crystal_outpost.m2", -- [13]
												},
												["N"] = "Crystal_tops",
											}, -- [4]
											{
												["T"] = {
													"Shattrath_scryerDoodads.M2", -- [1]
													"Shattrath_scryerDoodads_backcrates.M2", -- [2]
													"Shattrath_scryerHedges.M2", -- [3]
												},
												["N"] = "Giantdoodads",
											}, -- [5]
											{
												["T"] = {
													"Shattrath_Draenei_Holy_FX.m2", -- [1]
												},
												["N"] = "Holy_energy_fx",
											}, -- [6]
											{
												["T"] = {
													"Ancient_D_Braizer.M2", -- [1]
													"Ancient_D_Braizer_Blue.M2", -- [2]
													"Ancient_D_Braizer_Blue_LowBatch.M2", -- [3]
													"Ancient_D_Braizer_Blue_ShortSmoke.M2", -- [4]
													"Ancient_D_Braizer_Broken.m2", -- [5]
													"Ancient_D_Braizer_Red.M2", -- [6]
													"Ancient_D_Sconce.M2", -- [7]
													"Ancient_D_Sconce_Off.m2", -- [8]
													"Ancient_D_Standing_Light.M2", -- [9]
													"Ancient_D_Standing_Light_off.m2", -- [10]
												},
												["N"] = "Lighting",
											}, -- [7]
										},
										["N"] = "Passivedoodads",
									}, -- [2]
								},
								["N"] = "Shattrath",
							}, -- [18]
							{
								["T"] = {
									{
										["T"] = {
											"SilvermoonBush05.m2", -- [1]
											"SilvermoonBush06.m2", -- [2]
										},
										["N"] = "Bushes",
									}, -- [1]
									{
										["T"] = {
											"FloatingDandelions01.M2", -- [1]
										},
										["N"] = "Floatingdandelions",
									}, -- [2]
									{
										["T"] = {
											"SilvermoonFlower01.m2", -- [1]
											"SilvermoonFlower02.m2", -- [2]
											"SilvermoonFlower03.m2", -- [3]
											"SilvermoonFlower04.m2", -- [4]
											"SilvermoonFlower05.m2", -- [5]
											"SilvermoonFlower06.m2", -- [6]
										},
										["N"] = "Flowers",
									}, -- [3]
									{
										["T"] = {
											"EversongCliffRock01.m2", -- [1]
											"EversongCliffRock02.m2", -- [2]
										},
										["N"] = "Rocks",
									}, -- [4]
									{
										["T"] = {
											"SilvermoonTree08.M2", -- [1]
										},
										["N"] = "Trees",
									}, -- [5]
									{
										["T"] = {
											"BigFountainWater.m2", -- [1]
										},
										["N"] = "Water",
									}, -- [6]
								},
								["N"] = "Silvermoon",
							}, -- [19]
							{
								["T"] = {
									{
										["T"] = {
											"SilvermystBush01.m2", -- [1]
											"SilvermystBush02.m2", -- [2]
											"SilvermystBush03.m2", -- [3]
										},
										["N"] = "Bushes",
									}, -- [1]
									{
										["T"] = {
											"SilvermystCompass01.m2", -- [1]
										},
										["N"] = "Compass",
									}, -- [2]
									{
										["T"] = {
											"SilvermystCrystal01.m2", -- [1]
											"SilvermystCrystal01_Orange.m2", -- [2]
											"SilvermystCrystal01_Yellow.m2", -- [3]
											"SilvermystCrystal02.m2", -- [4]
											"SilvermystCrystal02_Orange.m2", -- [5]
											"SilvermystCrystal02_Yellow.m2", -- [6]
											"SilvermystCrystal03.m2", -- [7]
											"SilvermystCrystal03_Orange.m2", -- [8]
											"SilvermystCrystal03_Yellow.m2", -- [9]
											"SilvermystCrystalBig01.m2", -- [10]
											"SilvermystCrystalBig01_Orange.M2", -- [11]
											"SilvermystCrystalBig01_Yellow.M2", -- [12]
											"SilvermystCrystalBig02.m2", -- [13]
											"SilvermystCrystalBig02_Orange.M2", -- [14]
											"SilvermystCrystalBig02_Yellow.M2", -- [15]
											"SilvermystCrystalBig03.m2", -- [16]
											"SilvermystCrystalBig03_Orange.M2", -- [17]
											"SilvermystCrystalBig03_Yellow.M2", -- [18]
											"silvermystCrystalSmall01.m2", -- [19]
											"silvermystCrystalSmall01_Orange.m2", -- [20]
											"silvermystCrystalSmall01_Yellow.m2", -- [21]
											"silvermystCrystalSmall02.m2", -- [22]
											"silvermystCrystalSmall02_Orange.m2", -- [23]
											"silvermystCrystalSmall02_Yellow.m2", -- [24]
											"silvermystCrystalSmall03.m2", -- [25]
											"silvermystCrystalSmall03_Orange.m2", -- [26]
											"silvermystCrystalSmall03_Yellow.m2", -- [27]
											"silvermyst_Elfinn_Crystal.m2", -- [28]
										},
										["N"] = "Crystals",
									}, -- [3]
									{
										["T"] = {
											"Silvermyst_LeafPile.m2", -- [1]
										},
										["N"] = "Leafpile",
									}, -- [4]
									{
										["T"] = {
											"SilverMystLightningbolt01.m2", -- [1]
										},
										["N"] = "Lightning",
									}, -- [5]
									{
										["T"] = {
											"silvermyst_lightshaft.m2", -- [1]
											"silvermyst_lightshaft02.m2", -- [2]
											"silvermyst_lightshaft03.m2", -- [3]
										},
										["N"] = "Lightshaft",
									}, -- [6]
									{
										["T"] = {
											"silvermyst_moonstone_blue.M2", -- [1]
											"silvermyst_moonstone_green.M2", -- [2]
											"silvermyst_moonstone_red.M2", -- [3]
										},
										["N"] = "Moonstone",
									}, -- [7]
									{
										["T"] = {
											"D_smoke.M2", -- [1]
										},
										["N"] = "Smoke",
									}, -- [8]
									{
										["T"] = {
											"SilvermystTree01.m2", -- [1]
											"SilvermystTree02.m2", -- [2]
											"SilvermystTree03.m2", -- [3]
											"SilvermystTree04.m2", -- [4]
											"SilvermystTree05.M2", -- [5]
											"SilvermystTreeRoots01.m2", -- [6]
											"SilvermystTreeTorn01.m2", -- [7]
											"SilvermystTreeTorn02.m2", -- [8]
											"SilvermystTreeTorn03.m2", -- [9]
											"SilvermystTreeTorn04.m2", -- [10]
											"silvermystTree_fallen01.m2", -- [11]
										},
										["N"] = "Trees",
									}, -- [9]
								},
								["N"] = "Silvermyst",
							}, -- [20]
							{
								["T"] = {
									{
										["T"] = {
											{
												["T"] = {
													"FrostwurmFellfire_Birth.M2", -- [1]
													"SunwellRaid_Gate_01.m2", -- [2]
													"SunwellRaid_Gate_02.m2", -- [3]
													"SunwellRaid_Gate_03.m2", -- [4]
													"SunwellRaid_Gate_04.m2", -- [5]
													"Sunwell_BossCollision01.M2", -- [6]
													"Sunwell_BossCollision02.M2", -- [7]
													"Sunwell_BossForceField.m2", -- [8]
													"Sunwell_FX.M2", -- [9]
													"Sunwell_Ice_Barrier.M2", -- [10]
													"Sunwell_Replica.m2", -- [11]
													"Sunwell_WindowDust.m2", -- [12]
												},
												["N"] = "Sunwell",
											}, -- [1]
										},
										["N"] = "Passivedoodads",
									}, -- [1]
								},
								["N"] = "Sunwell",
							}, -- [21]
							{
								["T"] = {
									{
										["T"] = {
											{
												["T"] = {
													"TK_Boss_Pod.M2", -- [1]
												},
												["N"] = "Arcane_boss_pod",
											}, -- [1]
											{
												["T"] = {
													"TK_Arcane_Door_Horiz.M2", -- [1]
													"TK_Arcane_Door_Vert.M2", -- [2]
												},
												["N"] = "Arcane_doors",
											}, -- [2]
											{
												["T"] = {
													"TK_Prison_Cell.M2", -- [1]
												},
												["N"] = "Arcane_pod",
											}, -- [3]
											{
												["T"] = {
													"TK_Main_Control_Console.m2", -- [1]
													"TK_Short_Control_Console.M2", -- [2]
													"TK_Tall_Control_Console.M2", -- [3]
												},
												["N"] = "Control_console",
											}, -- [4]
											{
												["T"] = {
													"TK_Exterior_Crystals.M2", -- [1]
												},
												["N"] = "Crystals",
											}, -- [5]
											{
												["T"] = {
													"TK_Factory_Door.m2", -- [1]
													"TK_Factory_Door_Vert.m2", -- [2]
												},
												["N"] = "Factory_door",
											}, -- [6]
											{
												["T"] = {
													"Kael_Explode_FX_Left.M2", -- [1]
													"Kael_Explode_FX_Right.M2", -- [2]
												},
												["N"] = "Kael_statue",
											}, -- [7]
											{
												["T"] = {
													"TK_Raid_Door.M2", -- [1]
												},
												["N"] = "Raid_door",
											}, -- [8]
											{
												["T"] = {
													"TK_Raid_Windows_Tall.m2", -- [1]
												},
												["N"] = "Raid_windows",
											}, -- [9]
										},
										["N"] = "Activedoodads",
									}, -- [1]
									{
										["T"] = {
											{
												["T"] = {
													"TK_bridge_graphics.M2", -- [1]
													"TK_bridge_graphics2.M2", -- [2]
												},
												["N"] = "Bridges",
											}, -- [1]
											{
												["T"] = {
													"TK_Container_01.m2", -- [1]
													"TK_Container_02.m2", -- [2]
												},
												["N"] = "Container",
											}, -- [2]
											{
												["T"] = {
													"TK_Exterior_Crystals_Bottom.M2", -- [1]
													"TK_Exterior_Crystals_Top.M2", -- [2]
													"TK_SmallWing_Arcane_Crystals_Bottom.M2", -- [3]
													"TK_SmallWing_Arcane_Crystals_Top.M2", -- [4]
													"TK_SmallWing_Crystals.M2", -- [5]
													"TK_SmallWing_Crystals_Bottom.M2", -- [6]
													"TK_SmallWing_Crystals_Top.M2", -- [7]
													"TK_SmallWing_Factory_Crystals_Bottom.M2", -- [8]
													"TK_SmallWing_Factory_Crystals_Top.M2", -- [9]
												},
												["N"] = "Crystals",
											}, -- [3]
											{
												["T"] = {
													"TK_Energy_Exhaust_01.m2", -- [1]
													"TK_forcefield_atrium_outline.m2", -- [2]
													"TK_forcefield_entry_outline.m2", -- [3]
													"TK_forcefield_outline.m2", -- [4]
												},
												["N"] = "Forcefields",
											}, -- [4]
											{
												["T"] = {
													"TK_Helix_Floor_Reflection.M2", -- [1]
													"TK_Main_Bridge_Reflection.m2", -- [2]
													"TK_Ramp_Reflection.m2", -- [3]
												},
												["N"] = "Prisonbridges",
											}, -- [5]
											{
												["T"] = {
													"TK_Prison_Cell_Dark.m2", -- [1]
													"TK_Prison_Cell_Illuminated.M2", -- [2]
													"TK_Prison_Cell_TopOnly.m2", -- [3]
												},
												["N"] = "Prisoncellglass",
											}, -- [6]
											{
												["T"] = {
													"TK_Lightning_Ball.m2", -- [1]
													"TK_Lightning_Diagonal.m2", -- [2]
													"TK_Lightning_Diagonal_Ball.m2", -- [3]
													"TK_Lightning_FX_3_Sides_Room.m2", -- [4]
													"TK_Lightning_FX_Helix_Room.m2", -- [5]
													"TK_Lightning_FX_Tri_Room.m2", -- [6]
													"TK_Lightning_Horizontal.m2", -- [7]
													"TK_Prison_FX.m2", -- [8]
												},
												["N"] = "Prisonfx",
											}, -- [7]
										},
										["N"] = "Passivedoodads",
									}, -- [2]
								},
								["N"] = "Tempestkeep",
							}, -- [22]
							{
								["T"] = {
									{
										["T"] = {
											"BE_ArcaneBomb.M2", -- [1]
											"BE_ArcaneBomb_Orb.M2", -- [2]
										},
										["N"] = "Bomb",
									}, -- [1]
									{
										["T"] = {
											"Terokkar_bonepile01.m2", -- [1]
											"Terokkar_bonepile02.m2", -- [2]
										},
										["N"] = "Bonepile",
									}, -- [2]
									{
										["T"] = {
											"ChokeberryBush.m2", -- [1]
											"TerokkarBush01.m2", -- [2]
										},
										["N"] = "Bushes",
									}, -- [3]
									{
										["T"] = {
											"TerokkarCrystal01.m2", -- [1]
											"TerokkarCrystal02.m2", -- [2]
											"TerokkarCrystal03.m2", -- [3]
										},
										["N"] = "Crystal",
									}, -- [4]
									{
										["T"] = {
											"Terokkar_Lightray01.m2", -- [1]
											"Terokkar_Lightray02.m2", -- [2]
										},
										["N"] = "Lightray",
									}, -- [5]
									{
										["T"] = {
											"TerokkarPineCone.m2", -- [1]
										},
										["N"] = "Pinecone",
									}, -- [6]
									{
										["T"] = {
											"Terokkar_FloatingSmall01.m2", -- [1]
											"Terokkar_FloatingSmall02.m2", -- [2]
											"Terokkar_OverhangRock_Large_01.m2", -- [3]
											"Terokkar_OverhangRock_Large_02.m2", -- [4]
											"Terokkar_OverhangRock_Small_01.m2", -- [5]
											"Terokkar_OverhangRock_Small_02.m2", -- [6]
											"Terokkar_OverhangRock_Small_03.m2", -- [7]
										},
										["N"] = "Rocks",
									}, -- [7]
									{
										["T"] = {
											"Terokkar_Auch_ruin01.m2", -- [1]
											"Terokkar_Auch_ruin02.m2", -- [2]
											"Terokkar_Auch_ruin03.m2", -- [3]
											"Terokkar_Auch_ruin04.m2", -- [4]
											"Terokkar_Auch_ruin05.m2", -- [5]
											"Terokkar_Auch_ruin06.m2", -- [6]
											"Terokkar_Auch_ruin07.m2", -- [7]
											"Terokkar_Auch_ruin08.m2", -- [8]
											"Terokkar_Auch_ruin09.m2", -- [9]
											"Terokkar_Auch_ruin10.m2", -- [10]
										},
										["N"] = "Ruin",
									}, -- [8]
									{
										["T"] = {
											"Terokkar_boneshrine_arch01.m2", -- [1]
											"Terokkar_boneshrine_arch02.m2", -- [2]
										},
										["N"] = "Shrine",
									}, -- [9]
									{
										["T"] = {
											"Terokkar_Signpost_01.m2", -- [1]
											"Terokkar_Signpost_Sign.m2", -- [2]
										},
										["N"] = "Signposts",
									}, -- [10]
									{
										["T"] = {
											"TerokkarFallenTree.m2", -- [1]
											"TerokkarTreeLarge.m2", -- [2]
											"TerokkarTreeLargePineCones.m2", -- [3]
											"TerokkarTreeMedium.m2", -- [4]
											"TerokkarTreeMediumPineCones.m2", -- [5]
											"TerokkarTreeNoLeaves01.m2", -- [6]
											"TerokkarTreeNoLeaves02.m2", -- [7]
											"TerokkarTreeSapling.m2", -- [8]
											"TerokkarTreeSmall.m2", -- [9]
											"TerokkarTreeStump.m2", -- [10]
											"TerokkarTreeStump02.m2", -- [11]
										},
										["N"] = "Trees",
									}, -- [11]
									{
										["T"] = {
											"Terokkar_post_01.m2", -- [1]
											"Terokkar_post_ruin_01.m2", -- [2]
											"Terokkar_wall_01.m2", -- [3]
											"Terokkar_wall_ruin_01.m2", -- [4]
										},
										["N"] = "Walls",
									}, -- [12]
									{
										["T"] = {
											"TerokkarWeb01.m2", -- [1]
											"TerokkarWeb02.m2", -- [2]
											"TerokkarWeb03.m2", -- [3]
											"TerokkarWeb04.M2", -- [4]
										},
										["N"] = "Webs",
									}, -- [13]
								},
								["N"] = "Terokkar",
							}, -- [23]
							{
								["T"] = {
									{
										["T"] = {
											{
												["T"] = {
													"Exodar_Long_Banner.m2", -- [1]
													"Exodar_Long_Banner_Anim.m2", -- [2]
													"Exodar_Medium_Banner.m2", -- [3]
													"Exodar_Medium_Banner_anim.m2", -- [4]
													"Exodar_Medium_Hang_Banner.m2", -- [5]
													"Exodar_Medium_Hang_Banner_Anim.m2", -- [6]
													"Exodar_Medium_Hang_Banner_Anim_Type2.m2", -- [7]
													"Exodar_Thin2_Hang_Banner.m2", -- [8]
													"Exodar_Thin_Banner.m2", -- [9]
													"Exodar_Thin_Banner_anim.m2", -- [10]
													"Exodar_Thin_Hang_Banner.m2", -- [11]
													"Exodar_Thin_Hang_Banner_Anim.m2", -- [12]
													"Exodar_Thin_Hang_Banner_AnimType2.m2", -- [13]
													"Exodar_Thin_Hang_Banner_AnimType3.m2", -- [14]
													"Exodar_Tri_Banner_Blue.m2", -- [15]
													"Exodar_Tri_Banner_Red.m2", -- [16]
													"Exodar_Tri_Banner_S_Blue.m2", -- [17]
													"Exodar_Tri_Banner_S_Red.m2", -- [18]
													"Exodar_wide_Banner.m2", -- [19]
													"Exodar_wide_Banner_Anim.m2", -- [20]
													"Exodar_wide_Hang_Banner.m2", -- [21]
													"Exodar_wide_Hang_Banner_Anim.m2", -- [22]
													"Exodar_wide_Hang_Banner_Anim_Type2.m2", -- [23]
													"Exodar_wide_Hang_Banner_Anim_Type3.m2", -- [24]
												},
												["N"] = "Clothobjects",
											}, -- [1]
											{
												["T"] = {
													"Crystal_Corrupted.M2", -- [1]
													"Narru_Crystal_Pot.m2", -- [2]
													"Narru_Crystal_Pure.m2", -- [3]
												},
												["N"] = "Crystal",
											}, -- [2]
											{
												["T"] = {
													"Exodar_Center_Naaru_Crystals.M2", -- [1]
													"Exodar_Crystal_Chandelier.M2", -- [2]
													"Exodar_Crystal_Large.M2", -- [3]
													"Exodar_Crystal_Large_Yelllow.M2", -- [4]
													"Exodar_Crystal_Thin.M2", -- [5]
													"Exodar_Crystal_Thin_Type2.M2", -- [6]
													"Exodar_Crystal_Thin_Yellow.M2", -- [7]
													"Exodar_Crystal_Yellow_Bunch.M2", -- [8]
												},
												["N"] = "Crystals",
											}, -- [3]
											{
												["T"] = {
													"Exodar_Sconce.M2", -- [1]
													"Exodar_Sconce_Blue.M2", -- [2]
													"Exodar_Sconce_Magenta.M2", -- [3]
												},
												["N"] = "Light_sconces",
											}, -- [4]
											{
												["T"] = {
													"Exodar_NaruCore_FX.m2", -- [1]
												},
												["N"] = "Naaru_core",
											}, -- [5]
											{
												["T"] = {
													"Exodar_Paladin_Shrine_EnergyFX.M2", -- [1]
												},
												["N"] = "Paladin_energy_fx",
											}, -- [6]
											{
												["T"] = {
													"Draenei_Shamen_Stones_T1.m2", -- [1]
													"Draenei_Shamen_Stones_T1_Broken.m2", -- [2]
													"Draenei_Shamen_Stones_T2.m2", -- [3]
													"Draenei_Shamen_Stones_Yellow_T1.m2", -- [4]
													"Draenei_Shamen_Stones_Yellow_T1_Broken.m2", -- [5]
													"Draenei_Shamen_Stones_Yellow_T2.m2", -- [6]
												},
												["N"] = "Shamen_stones",
											}, -- [7]
											{
												["T"] = {
													"Exodar_Cheese_Sign.m2", -- [1]
													"Exodar_Herbalism_Sign.m2", -- [2]
													"Exodar_Hunter_Sign.m2", -- [3]
													"Exodar_Inn_Sign.m2", -- [4]
													"Exodar_Smith_Sign.m2", -- [5]
													"Exodar_Warrior_Sign.m2", -- [6]
												},
												["N"] = "Signs",
											}, -- [8]
											{
												["T"] = {
													"Exodar_Sky_portal.m2", -- [1]
												},
												["N"] = "Sky_portal",
											}, -- [9]
										},
										["N"] = "Passivedoodads",
									}, -- [1]
								},
								["N"] = "Theexodar",
							}, -- [24]
							{
								["T"] = {
									{
										["T"] = {
											"ZangarGrass01.m2", -- [1]
											"ZangarGrass01_husk.m2", -- [2]
										},
										["N"] = "Bush",
									}, -- [1]
									{
										["T"] = {
											"ZM_Big_Spore_Anim_01.m2", -- [1]
											"ZM_Big_Spore_Anim_02.m2", -- [2]
											"ZM_Big_Spore_Anim_03.m2", -- [3]
											"ZM_Big_spore_01.m2", -- [4]
											"ZM_Big_spore_02.m2", -- [5]
											"ZM_Big_spore_03.m2", -- [6]
											"ZangarMarsh_floatingSpore01.M2", -- [7]
											"ZangarMarsh_floatingSpore02.m2", -- [8]
										},
										["N"] = "Floatingspore",
									}, -- [2]
									{
										["T"] = {
											"ZangarFogring01.m2", -- [1]
										},
										["N"] = "Fog",
									}, -- [3]
									{
										["T"] = {
											"ZangarFountain01.m2", -- [1]
										},
										["N"] = "Fountain",
									}, -- [4]
									{
										["T"] = {
											"ZangarLamppost01.m2", -- [1]
										},
										["N"] = "Lamp",
									}, -- [5]
									{
										["T"] = {
											"ZangarLilypad01.m2", -- [1]
											"ZangarLilypad02.m2", -- [2]
											"ZangarLilypad03.m2", -- [3]
											"ZangarLilypad04.m2", -- [4]
											"ZangarLilypad05.m2", -- [5]
											"ZangarLilypad06.m2", -- [6]
										},
										["N"] = "Lilypads",
									}, -- [6]
									{
										["T"] = {
											"ZangarLog01.m2", -- [1]
											"ZangarLog02.m2", -- [2]
										},
										["N"] = "Logs",
									}, -- [7]
									{
										["T"] = {
											"LO_well_01.m2", -- [1]
										},
										["N"] = "Lostones",
									}, -- [8]
									{
										["T"] = {
											"ZangarFallenShroom01.m2", -- [1]
											"ZangarFallenShroom02.m2", -- [2]
											"ZangarMushroom01.m2", -- [3]
											"ZangarMushroom02.m2", -- [4]
											"ZangarMushroom03.M2", -- [5]
											"ZangarMushroom04.m2", -- [6]
											"ZangarMushroom05.m2", -- [7]
											"ZangarMushroom06_Blue.m2", -- [8]
											"ZangarMushroom06_Green.m2", -- [9]
											"ZangarMushroom06_Orange.m2", -- [10]
											"ZangarMushroom07_Blue.m2", -- [11]
											"ZangarMushroom07_Green.m2", -- [12]
											"ZangarMushroom07_Orange.m2", -- [13]
											"ZangarMushroomBlue.m2", -- [14]
											"ZangarMushroomGreen.m2", -- [15]
											"ZangarMushroomPurple.m2", -- [16]
											"ZangarMushroomShelf01.m2", -- [17]
											"ZangarMushroomShelf02.m2", -- [18]
											"ZangarMushroomShelf03.m2", -- [19]
											"ZangarMushroomTree05.m2", -- [20]
											"ZangarMushroomTree06.m2", -- [21]
											"ZangarMushroomTree07.m2", -- [22]
											"ZangarMushroomTree08Dead.m2", -- [23]
											"ZangarMushroomTree09Dying.m2", -- [24]
											"ZangarMushroomTreeSmall01.m2", -- [25]
											"ZangarMushroomTreeSmall02.m2", -- [26]
											"ZangarMushroomTreeSmall03.m2", -- [27]
											"ZangarMushroomWater01.M2", -- [28]
											"ZangarMushroomWater02.m2", -- [29]
											"ZangarMushroomWater03.m2", -- [30]
											"ZangarTreeSmallBlue.m2", -- [31]
											"ZangarTreeSmallBlue01.m2", -- [32]
											"ZangarTreeSmallGreen.m2", -- [33]
											"ZangarTreeSmallGreen01.m2", -- [34]
											"ZangarTreeSmallPurple.m2", -- [35]
											"ZangarTreeSmallPurple01.m2", -- [36]
										},
										["N"] = "Mushroom",
									}, -- [9]
									{
										["T"] = {
											"mushroombase_beacon.m2", -- [1]
											"mushroombase_bottom.m2", -- [2]
											"mushroombase_elevator.m2", -- [3]
										},
										["N"] = "Mushroombase",
									}, -- [10]
									{
										["T"] = {
											"ZangarBushWithered01.m2", -- [1]
											"ZangarBushWithered02.m2", -- [2]
											"ZangarMushroomTree01.m2", -- [3]
											"ZangarMushroomTree02.m2", -- [4]
											"ZangarMushroomTree03.M2", -- [5]
											"ZangarMushroomTree04.m2", -- [6]
											"ZangarTreeBlue01.m2", -- [7]
											"ZangarTreeBlue02.m2", -- [8]
											"ZangarTreeBlue03.m2", -- [9]
											"ZangarTreeBlue04.m2", -- [10]
											"ZangarTreeGreen01.m2", -- [11]
											"ZangarTreeGreen02.m2", -- [12]
											"ZangarTreeGreen03.m2", -- [13]
											"ZangarTreeGreen04.m2", -- [14]
											"ZangarTreePurple01.m2", -- [15]
											"ZangarTreePurple02.m2", -- [16]
											"ZangarTreePurple03.m2", -- [17]
											"ZangarTreePurple04.m2", -- [18]
											"ZangarTreeWithered01.m2", -- [19]
											"ZangarTreeWithered02.m2", -- [20]
											"ZangarTreeWithered03.m2", -- [21]
											"ZangarTreeWithered04.m2", -- [22]
											"ZangarTreeWithered05.m2", -- [23]
										},
										["N"] = "Mushroomtrees",
									}, -- [11]
									{
										["T"] = {
											"ZangarPlantGroup01.m2", -- [1]
											"ZangarPlantGroup02.m2", -- [2]
											"ZangarPlantGroup03.m2", -- [3]
											"ZangarPlantGroup04.m2", -- [4]
											"ZangarPlantGroup05.m2", -- [5]
										},
										["N"] = "Plantgroups",
									}, -- [12]
									{
										["T"] = {
											"ZM_OrangePollen.m2", -- [1]
											"ZM_bluePollen.m2", -- [2]
										},
										["N"] = "Pollen",
									}, -- [13]
									{
										["T"] = {
											"ZangarWalkway01.m2", -- [1]
											"ZangarWalkway02.m2", -- [2]
											"ZangarWalkway03.m2", -- [3]
											"ZangarWalkwayEnd01.m2", -- [4]
											"ZangarWalkwayEnd02.m2", -- [5]
											"ZangarWalkway_board.m2", -- [6]
											"ZangarWalkway_pole.m2", -- [7]
											"ZangarWalkway_wide01.m2", -- [8]
											"ZangarWalkway_wide02.m2", -- [9]
											"ZangarWalkway_wide03.m2", -- [10]
											"ZangarWalkway_wide04.m2", -- [11]
										},
										["N"] = "Road",
									}, -- [14]
									{
										["T"] = {
											"DirtMound_Zangar.m2", -- [1]
											"Zangar_FloatingSmall01.m2", -- [2]
											"Zangar_FloatingSmall02.m2", -- [3]
											"Zangar_OverhangRock_Large_01.m2", -- [4]
											"Zangar_OverhangRock_Large_02.m2", -- [5]
											"Zangar_OverhangRock_Small_01.m2", -- [6]
											"Zangar_OverhangRock_Small_02.m2", -- [7]
											"Zangar_OverhangRock_Small_03.m2", -- [8]
										},
										["N"] = "Rocks",
									}, -- [15]
									{
										["T"] = {
											"ZangarSignpost01.m2", -- [1]
											"ZangarSignpostpointer01.m2", -- [2]
										},
										["N"] = "Signposts",
									}, -- [16]
									{
										["T"] = {
											"ZangarShroomStump01.m2", -- [1]
											"ZangarShroomStump02.m2", -- [2]
											"ZangarShroomStump03.m2", -- [3]
										},
										["N"] = "Stump",
									}, -- [17]
								},
								["N"] = "Zangar",
							}, -- [25]
							{
								["T"] = {
									{
										["T"] = {
											"ZulAman_EntranceGate.m2", -- [1]
											"ZulAman_FireDoor.M2", -- [2]
											"ZulAman_LynxGate.m2", -- [3]
											"ZulAman_TorchFire.m2", -- [4]
											"ZulAman_WindDoor.m2", -- [5]
										},
										["N"] = "Doors",
									}, -- [1]
									{
										["T"] = {
											"ForestTrollDungeonFountain.m2", -- [1]
										},
										["N"] = "Fountain",
									}, -- [2]
									{
										["T"] = {
											"EagleGargoyle.m2", -- [1]
										},
										["N"] = "Gargoyle",
									}, -- [3]
									{
										["T"] = {
											"ForestTrollDungeonGong.m2", -- [1]
										},
										["N"] = "Gong",
									}, -- [4]
									{
										["T"] = {
											"TrollRuins_ZulAman_01.m2", -- [1]
											"TrollRuins_ZulAman_02.m2", -- [2]
											"TrollRuins_ZulAman_03.m2", -- [3]
											"TrollRuins_ZulAman_04.m2", -- [4]
											"TrollRuins_ZulAman_05.m2", -- [5]
											"TrollRuins_ZulAman_06.m2", -- [6]
											"TrollRuins_ZulAman_07.m2", -- [7]
											"TrollRuins_ZulAman_08.m2", -- [8]
											"TrollRuins_ZulAman_09.m2", -- [9]
											"TrollRuins_ZulAman_10.m2", -- [10]
											"TrollRuins_ZulAman_11.m2", -- [11]
											"TrollRuins_ZulAman_12.m2", -- [12]
											"TrollRuins_ZulAman_14.m2", -- [13]
											"TrollRuins_ZulAman_15.m2", -- [14]
											"TrollRuins_ZulAman_16.m2", -- [15]
											"TrollRuins_ZulAman_17.m2", -- [16]
											"TrollRuins_ZulAman_18.m2", -- [17]
											"TrollRuins_ZulAman_20.m2", -- [18]
											"TrollRuins_ZulAman_21.m2", -- [19]
										},
										["N"] = "Ruins",
									}, -- [5]
									{
										["T"] = {
											"EagleStatue01.m2", -- [1]
										},
										["N"] = "Statues",
									}, -- [6]
									{
										["T"] = {
											"ForestTrollTablet.m2", -- [1]
										},
										["N"] = "Tablet",
									}, -- [7]
									{
										["T"] = {
											"EagleThrone01.m2", -- [1]
										},
										["N"] = "Throne",
									}, -- [8]
									{
										["T"] = {
											"TrollSkullTiki.m2", -- [1]
										},
										["N"] = "Tiki",
									}, -- [9]
									{
										["T"] = {
											"ZulAmanTree01.m2", -- [1]
											"ZulAmanTree02.M2", -- [2]
											"ZulAmanTree03.m2", -- [3]
										},
										["N"] = "Trees",
									}, -- [10]
									{
										["T"] = {
											"ForestTrollDungeonBasinWall.m2", -- [1]
										},
										["N"] = "Wall",
									}, -- [11]
									{
										["T"] = {
											"ZulAmanWaterFalls.M2", -- [1]
										},
										["N"] = "Waterfalls",
									}, -- [12]
								},
								["N"] = "Zulaman",
							}, -- [26]
						},
						["N"] = "Doodads",
					}, -- [1]
				},
				["N"] = "Expansion01",
			}, -- [10]
			{
				["T"] = {
					{
						["T"] = {
							{
								["T"] = {
									{
										["T"] = {
											"Azjol_BigArchHalf01.m2", -- [1]
											"Azjol_SpiderArch01.m2", -- [2]
											"Azjol_arch_a.m2", -- [3]
											"Azjol_arch_a_closed.m2", -- [4]
											"Azjol_arch_b.m2", -- [5]
											"Azjol_arch_b_closed.m2", -- [6]
											"Azjol_arch_corner.m2", -- [7]
											"Azjol_arch_corner_b.m2", -- [8]
											"Azjol_arch_corner_b_closed.m2", -- [9]
											"Azjol_arch_corner_closed.m2", -- [10]
											"Azjol_wall_arch.m2", -- [11]
											"Azjol_wall_arch_closed.m2", -- [12]
											"Azjol_wall_arch_window.m2", -- [13]
										},
										["N"] = "Arches",
									}, -- [1]
									{
										["T"] = {
											"Azjol_Bridge01.m2", -- [1]
											"Azjol_Bridge02.m2", -- [2]
											"Azjol_Bridge03.m2", -- [3]
											"Azjol_bridge_a.m2", -- [4]
											"Azjol_bridge_b.m2", -- [5]
										},
										["N"] = "Bridges",
									}, -- [2]
									{
										["T"] = {
											"Azjol_ArchBuilding01.m2", -- [1]
											"Azjol_Building01.m2", -- [2]
											"Azjol_Building02.m2", -- [3]
											"Azjol_Building03.m2", -- [4]
											"Azjol_Facade1.m2", -- [5]
											"Azjol_Facade2.m2", -- [6]
											"Azjol_Facade3.m2", -- [7]
											"Azjol_Facade4.m2", -- [8]
											"Azjol_Facade5.m2", -- [9]
											"Azjol_Pyramid1.m2", -- [10]
											"Azjol_Pyramid2.m2", -- [11]
											"Azjol_Pyramid3.m2", -- [12]
											"Azjol_final_boss.m2", -- [13]
										},
										["N"] = "Buildings",
									}, -- [3]
									{
										["T"] = {
											"Azjol_Obelisk01.m2", -- [1]
											"Azjol_ObeliskGold01.m2", -- [2]
											"Azjol_ObeliskObsidian01.m2", -- [3]
											"Azjol_ObeliskOrange.m2", -- [4]
											"Azjol_SpiderColumn01.m2", -- [5]
											"Azjol_SpiderColumn02.m2", -- [6]
											"Azjol_column_a.m2", -- [7]
											"Azjol_column_b.m2", -- [8]
											"Azjol_column_c.m2", -- [9]
										},
										["N"] = "Columns",
									}, -- [4]
									{
										["T"] = {
											"Azjol_EggSacks_01.m2", -- [1]
											"Azjol_EggSacks_02.m2", -- [2]
											"Azjol_EggTower_01.m2", -- [3]
											"Azjol_EggTower_02.m2", -- [4]
										},
										["N"] = "Eggs",
									}, -- [5]
									{
										["T"] = {
											"OmniLight_Purple.m2", -- [1]
										},
										["N"] = "Omnilights",
									}, -- [6]
									{
										["T"] = {
											"Azjol_RockColumn01.m2", -- [1]
											"Azjol_RockColumn02.m2", -- [2]
											"Azjol_RockColumn03.m2", -- [3]
											"Azjol_RockColumn04.m2", -- [4]
											"Azjol_RockColumn05.m2", -- [5]
										},
										["N"] = "Rockcolumns",
									}, -- [7]
									{
										["T"] = {
											"Azjol_Roof02.m2", -- [1]
											"Azjol_Roof03.m2", -- [2]
											"Azjol_Roof04.m2", -- [3]
										},
										["N"] = "Roof",
									}, -- [8]
									{
										["T"] = {
											"Saronite_Arrow_01.M2", -- [1]
											"Saronite_Node_01.m2", -- [2]
											"Saronite_Node_01_PoS.m2", -- [3]
											"Saronite_rock01.m2", -- [4]
											"Saronite_rock02.m2", -- [5]
											"Saronite_slimefalls.m2", -- [6]
										},
										["N"] = "Saronite",
									}, -- [9]
									{
										["T"] = {
											"Azjol_Fern_01.m2", -- [1]
											"Azjol_Fern_02.m2", -- [2]
											"Azjol_GlowThread_Blue.m2", -- [3]
											"Azjol_GlowThread_White.m2", -- [4]
											"Azjol_GlowThread_White_02.m2", -- [5]
											"Azjol_GlowThread_Yellow.m2", -- [6]
											"Azjol_HangingFern_01.m2", -- [7]
											"Azjol_Mushroom01.m2", -- [8]
											"Azjol_Mushroom02.m2", -- [9]
											"Azjol_Mushroom03.m2", -- [10]
											"Azjol_ShelfMushroom_01.m2", -- [11]
											"Azjol_ShelfMushroom_03.m2", -- [12]
											"Azjol_Spore_Blue_01.m2", -- [13]
											"Azjol_Spore_White_01.m2", -- [14]
											"Azjol_ThinMushroom_01.m2", -- [15]
											"Azjol_ThinMushroom_02.m2", -- [16]
											"Azjol_ThinMushroom_03.m2", -- [17]
											"Azjol_ThinMushroom_04.m2", -- [18]
										},
										["N"] = "Shrubs",
									}, -- [10]
									{
										["T"] = {
											"Azjol_Stairs01.m2", -- [1]
											"Azjol_Stairs02.m2", -- [2]
											"Azjol_stairs_lg.m2", -- [3]
											"Azjol_stairs_sm.m2", -- [4]
										},
										["N"] = "Stairs",
									}, -- [11]
									{
										["T"] = {
											"Azjol_Wall01.m2", -- [1]
											"Azjol_Wall02.m2", -- [2]
											"Azjol_WallEnd01.m2", -- [3]
											"Azjol_Wall_Curved01.m2", -- [4]
											"Azjol_wall_corner.m2", -- [5]
											"Azjol_wall_divider.m2", -- [6]
											"Azjol_wall_long_seg.m2", -- [7]
											"Azjol_wall_long_sideangle.m2", -- [8]
											"Azjol_wall_long_vertangle.m2", -- [9]
										},
										["N"] = "Walls",
									}, -- [12]
									{
										["T"] = {
											"Waterfalls_Azjol_Uppercity.m2", -- [1]
										},
										["N"] = "Waterfalls",
									}, -- [13]
									"AzjolColumn01.m2", -- [14]
									"AzjolColumn02.m2", -- [15]
									"AzjolColumn03.m2", -- [16]
									"AzjolColumn04.m2", -- [17]
									"AzjolColumn05.m2", -- [18]
									"AzjolColumn06.m2", -- [19]
									"AzjolColumn06_Long.m2", -- [20]
									"AzjolColumn07.m2", -- [21]
									"AzjolColumn08.m2", -- [22]
									"AzjolColumn08_Long.m2", -- [23]
									"AzjolColumn09.m2", -- [24]
									"AzjolColumn10.m2", -- [25]
									"AzjolColumn11.m2", -- [26]
									"AzjolColumn12.m2", -- [27]
									"AzjolColumn13.m2", -- [28]
									"AzjolColumn14.m2", -- [29]
									"AzjolColumn15.m2", -- [30]
									"AzjolColumn16.m2", -- [31]
									"AzjolColumn17.m2", -- [32]
									"AzjolColumn18.m2", -- [33]
									"AzjolColumn19.m2", -- [34]
									"AzjolColumn20.m2", -- [35]
									"AzjolColumn21.m2", -- [36]
									"AzjolColumn22.m2", -- [37]
									"AzjolColumn23.m2", -- [38]
									"AzjolColumn24.m2", -- [39]
									"AzjolColumn25.m2", -- [40]
									"AzjolColumn26.m2", -- [41]
									"AzjolRoofGiant.m2", -- [42]
									"Azjol_Arch01.m2", -- [43]
									"Azjol_Arch02.m2", -- [44]
									"Azjol_Banner_01.m2", -- [45]
									"Azjol_Banner_02.m2", -- [46]
									"Azjol_Banner_03.m2", -- [47]
									"Azjol_Banner_04.m2", -- [48]
									"Azjol_Banner_05.m2", -- [49]
									"Azjol_Brazier_01.M2", -- [50]
									"Azjol_Brazier_02.M2", -- [51]
									"Azjol_Brazier_03.M2", -- [52]
									"Azjol_Brazier_04.M2", -- [53]
									"Azjol_Brazier_05.M2", -- [54]
									"Azjol_Brazier_06.M2", -- [55]
									"Azjol_Chandelier_01.M2", -- [56]
									"Azjol_Chandelier_02.M2", -- [57]
									"Azjol_CirclePlatform01.m2", -- [58]
									"Azjol_CirclePlatform02.m2", -- [59]
									"Azjol_Cliff01.m2", -- [60]
									"Azjol_Cliff02.m2", -- [61]
									"Azjol_Cliff03.m2", -- [62]
									"Azjol_Cliff04.m2", -- [63]
									"Azjol_Console_01.M2", -- [64]
									"Azjol_Door_Boss_01.M2", -- [65]
									"Azjol_Door_Boss_02.m2", -- [66]
									"Azjol_Door_Boss_03.m2", -- [67]
									"Azjol_Door_Large_01.m2", -- [68]
									"Azjol_Door_Small_01.m2", -- [69]
									"Azjol_GhostBats_01.m2", -- [70]
									"Azjol_GiantMushroom01.m2", -- [71]
									"Azjol_GiantMushroom02.m2", -- [72]
									"Azjol_GiantMushroom03.m2", -- [73]
									"Azjol_Glow_Worms_01.M2", -- [74]
									"Azjol_Mushroom04.m2", -- [75]
									"Azjol_Mushroom05.m2", -- [76]
									"Azjol_Mushroom06.M2", -- [77]
									"Azjol_OrnateSpider.m2", -- [78]
									"Azjol_OrnateSpike.m2", -- [79]
									"Azjol_Platform_Bottom_01.m2", -- [80]
									"Azjol_Platform_FX_01.m2", -- [81]
									"Azjol_Platform_Top_01.m2", -- [82]
									"Azjol_Roof.m2", -- [83]
									"Azjol_Sarcophagus_01.m2", -- [84]
									"Azjol_Sconce_01.M2", -- [85]
									"Azjol_Sconce_02.M2", -- [86]
									"Azjol_Sconce_03.M2", -- [87]
									"Azjol_Sconce_04.M2", -- [88]
									"Azjol_Sconce_05.M2", -- [89]
									"Azjol_Sconce_06.M2", -- [90]
									"Azjol_ShelfMushroom_02.m2", -- [91]
									"Azjol_ShelfMushroom_04.m2", -- [92]
									"Azjol_ShelfMushroom_05.m2", -- [93]
									"Azjol_ShelfMushroom_06.m2", -- [94]
									"Azjol_SpiderFinger01.m2", -- [95]
									"Azjol_Spiderleg01.m2", -- [96]
									"Azjol_Spiderleg02.m2", -- [97]
									"Azjol_Spike01.m2", -- [98]
									"Azjol_Statue_01.m2", -- [99]
									"Azjol_Statue_02.m2", -- [100]
									"Azjol_Vase_01.M2", -- [101]
									"Azjol_Vase_01_noCol.M2", -- [102]
									"Azjol_Vase_02.m2", -- [103]
									"Azjol_Water_Pool_01.M2", -- [104]
									"Azjol_Water_Pool_02.m2", -- [105]
									"Azjol_WebBridge_01.m2", -- [106]
									"Azjol_WebBridge_02.m2", -- [107]
									"Azjol_WebBridge_03.m2", -- [108]
									"Azjol_WebBridge_04.m2", -- [109]
									"Azjol_Web_01.m2", -- [110]
									"Azjol_Web_02.m2", -- [111]
									"Azjol_Web_Rope_Angled_01.m2", -- [112]
									"Azjol_Web_Rope_Angled_02.m2", -- [113]
									"Azjol_Web_Rope_Angled_03.m2", -- [114]
									"Azjol_Web_Rope_Looped_01.m2", -- [115]
									"Azjol_Web_Rope_Looped_02.m2", -- [116]
									"Azjol_Web_Rope_Looped_03.m2", -- [117]
									"Azjol_Web_Rope_Looped_04.m2", -- [118]
									"Azjol_Web_Rope_Straight_01.m2", -- [119]
									"Azjol_Web_Rope_Straight_02.m2", -- [120]
									"Azjol_Web_Rope_Straight_03.m2", -- [121]
									"Azjol_Webfloor_01.m2", -- [122]
									"Azjol_Webfloor_01B.m2", -- [123]
									"Azjol_Webfloor_02.m2", -- [124]
									"Azjol_Webfloor_02B.m2", -- [125]
									"Azjol_Webfloor_03.m2", -- [126]
									"Azjol_Webfloor_03B.m2", -- [127]
									"Azjol_platform01.m2", -- [128]
								},
								["N"] = "Azjol-Nerub",
							}, -- [1]
							{
								["T"] = {
									{
										["T"] = {
											"BT_Airport_Light_Red_Blink.M2", -- [1]
											"BT_Airport_Light_White_Blink.M2", -- [2]
											"BT_Airport_Light_White_Static.M2", -- [3]
										},
										["N"] = "Airport",
									}, -- [1]
									{
										["T"] = {
											"Statue_VarianWynn.m2", -- [1]
										},
										["N"] = "Alliancestatue",
									}, -- [2]
									{
										["T"] = {
											"borean_barnacleLG.m2", -- [1]
											"borean_barnacleSM01.m2", -- [2]
											"borean_barnacleSM02.m2", -- [3]
											"borean_barnacleSM03.m2", -- [4]
											"borean_barnacle_plane.m2", -- [5]
											"borean_starfish.M2", -- [6]
										},
										["N"] = "Barnacles",
									}, -- [3]
									{
										["T"] = {
											"Borean_DeadOrca_01.M2", -- [1]
											"Borean_DeadOrca_02.m2", -- [2]
											"Borean_SeaWeed_01.m2", -- [3]
											"Borean_SeaWeed_02.M2", -- [4]
											"Borean_SeaWeed_03.m2", -- [5]
											"Borean_Starfish_01.M2", -- [6]
										},
										["N"] = "Beach",
									}, -- [4]
									{
										["T"] = {
											"Broken_Bridge_Pillar.m2", -- [1]
										},
										["N"] = "Bridgepillar",
									}, -- [5]
									{
										["T"] = {
											"Borean_Bush_01.m2", -- [1]
											"Borean_Bush_02.m2", -- [2]
											"Borean_Bush_04.m2", -- [3]
											"Borean_Bush_05.m2", -- [4]
											"Borean_GroundCover_01.m2", -- [5]
											"Borean_GroundCover_02.m2", -- [6]
											"Borean_GroundCover_03.m2", -- [7]
											"Borean_Shrub_02.m2", -- [8]
											"Borean_Shrub_03.m2", -- [9]
											"Borean_Shrub_04.m2", -- [10]
											"Borean_Shrub_05_Q.m2", -- [11]
										},
										["N"] = "Bushes",
									}, -- [6]
									{
										["T"] = {
											"Borean_Corrupted_Crystals_01.M2", -- [1]
										},
										["N"] = "Crystals",
									}, -- [7]
									{
										["T"] = {
											"Borean_Bubbles_01.m2", -- [1]
											"Borean_GeyserEffect.M2", -- [2]
											"Borean_GeyserNoSteam_04.m2", -- [3]
											"Borean_GeyserNoSteam_05.m2", -- [4]
											"Borean_GeyserSteam.M2", -- [5]
											"Borean_Geyser_01.m2", -- [6]
											"Borean_Geyser_02.M2", -- [7]
											"Borean_Geyser_03.M2", -- [8]
											"Borean_MineralPool_01.m2", -- [9]
										},
										["N"] = "Geysers",
									}, -- [8]
									{
										["T"] = {
											"borean_towerparts.m2", -- [1]
										},
										["N"] = "Gnometower",
									}, -- [9]
									{
										["T"] = {
											"Borean_MagnataurBed_01.m2", -- [1]
											"Borean_RedPlant_Bowl_01.m2", -- [2]
											"Borean_RedPlant_Bowl_02.m2", -- [3]
											"Borean_RedPlant_BurningPile_01.M2", -- [4]
											"Borean_RedPlant_BurningPile_02.m2", -- [5]
											"Borean_RedPlant_BurningPile_03.m2", -- [6]
											"Borean_RedPlant_Drying_01.M2", -- [7]
											"Borean_RedPlant_Drying_02.m2", -- [8]
											"Borean_RedPlant_Drying_03.m2", -- [9]
											"Magnataur_Axe01.m2", -- [10]
											"Magnataur_LegFoot01.m2", -- [11]
											"Magnataur_LegFull01.m2", -- [12]
											"Magnataur_LegFull02.m2", -- [13]
											"Magnataur_LegThigh01.m2", -- [14]
											"Magnataur_Mace01.m2", -- [15]
											"Magnataur_Ribcage01.m2", -- [16]
											"Magnataur_Skull01.m2", -- [17]
											"Magnataur_Skull02.m2", -- [18]
											"Magnataur_Spear01.m2", -- [19]
											"Magnataur_Torso01.m2", -- [20]
											"Magnataur_WeaponBroken01.m2", -- [21]
											"Snobold_Alter01.M2", -- [22]
											"Snobold_Cage_01.m2", -- [23]
											"Snobold_Candle01.m2", -- [24]
											"Snobold_Candle02.m2", -- [25]
											"Snobold_Candle03.m2", -- [26]
											"Snobold_Candle04.m2", -- [27]
											"Snobold_Candle_Group01.m2", -- [28]
											"Snobold_Candle_Group02.m2", -- [29]
											"Snobold_WarningRock01_HiBatch.m2", -- [30]
											"Snobold_WarningRock02_HiBatch.m2", -- [31]
											"Snobold_WarningRock03.m2", -- [32]
										},
										["N"] = "Magnatauritems",
									}, -- [10]
									{
										["T"] = {
											"Borean_RockLarge_01.m2", -- [1]
											"Borean_RockLarge_01_Snowy.m2", -- [2]
											"Borean_RockLarge_02.m2", -- [3]
											"Borean_RockLarge_02_Snowy.m2", -- [4]
											"Borean_RockLarge_03.m2", -- [5]
											"Borean_RockLarge_03_Snowy.m2", -- [6]
											"Borean_RockLarge_04.m2", -- [7]
											"Borean_RockLarge_04_Snowy.m2", -- [8]
											"Borean_RockLarge_05.m2", -- [9]
											"Borean_RockLarge_05_Snowy.m2", -- [10]
											"Borean_RockLarge_06.m2", -- [11]
											"Borean_RockLarge_07.m2", -- [12]
											"Borean_RockLarge_08.m2", -- [13]
											"Borean_Rock_01.m2", -- [14]
											"Borean_Rock_02.m2", -- [15]
											"Borean_Rock_03.m2", -- [16]
											"Borean_Rock_04.m2", -- [17]
											"Borean_Rock_05.m2", -- [18]
										},
										["N"] = "Rocks",
									}, -- [11]
									{
										["T"] = {
											"Borean_Rope_01.m2", -- [1]
										},
										["N"] = "Ropes",
									}, -- [12]
									{
										["T"] = {
											"ND_ScourgeWalls_skulls.m2", -- [1]
										},
										["N"] = "Scourgewalls",
									}, -- [13]
									{
										["T"] = {
											"Borean_Snowpile_01.m2", -- [1]
											"Borean_Snowpile_02.m2", -- [2]
											"Borean_Snowpile_03.m2", -- [3]
											"Borean_Snowpile_04.m2", -- [4]
										},
										["N"] = "Snowpiles",
									}, -- [14]
									{
										["T"] = {
											"Borean_Flag_03.m2", -- [1]
											"Borean_Flag_04.m2", -- [2]
											"Borean_Flag_05.m2", -- [3]
											"Borean_Flags_01.m2", -- [4]
											"Borean_Flags_02.m2", -- [5]
										},
										["N"] = "Stoneflags",
									}, -- [15]
									{
										["T"] = {
											"Borean_TuskarrStatue_01.m2", -- [1]
											"Borean_TuskarrStatue_03.m2", -- [2]
											"Borean_TuskarrStatue_Broken_01.m2", -- [3]
										},
										["N"] = "Stoneheads",
									}, -- [16]
								},
								["N"] = "Boreantundra",
							}, -- [2]
							{
								["T"] = {
									{
										["T"] = {
											"Chamber_LavaFalls_01.m2", -- [1]
											"Chamber_LavaFalls_02.m2", -- [2]
											"Chamber_LavaFalls_03.M2", -- [3]
											"Chamber_LavaFalls_04.m2", -- [4]
											"Chamber_LavaFalls_05.m2", -- [5]
											"Chamber_LavaFalls_06.m2", -- [6]
											"Chamber_LavaFountain01.M2", -- [7]
										},
										["N"] = "Aspects_lavafalls",
									}, -- [1]
								},
								["N"] = "Chamber_aspects_black",
							}, -- [3]
							{
								["T"] = {
									{
										["T"] = {
											"ColdarraBerry_Bush_01.m2", -- [1]
											"ColdarraFrosty_Bush01.m2", -- [2]
										},
										["N"] = "Bushes",
									}, -- [1]
									{
										["T"] = {
											"CamouflageBubble_Coldarra.M2", -- [1]
										},
										["N"] = "Camouflagebubble",
									}, -- [2]
									{
										["T"] = {
											"ColdarraTree_Stump01.m2", -- [1]
										},
										["N"] = "Trees",
									}, -- [3]
									"ColdarraLocus.m2", -- [4]
								},
								["N"] = "Coldarra",
							}, -- [4]
							{
								["T"] = {
									{
										["T"] = {
											"CamouflageBubble_Crystalsong.M2", -- [1]
										},
										["N"] = "Bubble",
									}, -- [1]
									{
										["T"] = {
											"CrystalSongAspenRock01.m2", -- [1]
											"CrystalSongAspenRock02.m2", -- [2]
											"CrystalSongAspenRock03.m2", -- [3]
											"CrystalSongAspenRock04.m2", -- [4]
											"CrystalSongAspenRock05.m2", -- [5]
											"CrystalSongAspenRock06.m2", -- [6]
											"CrystalSongMagicRock01.m2", -- [7]
											"CrystalSongMagicRock02.m2", -- [8]
											"CrystalSongMagicRock03.m2", -- [9]
											"Crystalsong_RockA.m2", -- [10]
											"Crystalsong_RockB.m2", -- [11]
											"Crystalsong_RockC.m2", -- [12]
											"Crystalsong_RockD.m2", -- [13]
										},
										["N"] = "Rocks",
									}, -- [2]
									{
										["T"] = {
											"Crystalsong_Ruins_Column_01.m2", -- [1]
											"Crystalsong_Ruins_Ramp_01.m2", -- [2]
										},
										["N"] = "Ruins",
									}, -- [3]
									{
										["T"] = {
											"Crystalsong_Glow01.m2", -- [1]
											"Crystalsong_Sparkles01.M2", -- [2]
											"Crystalsong_Sparkles02.M2", -- [3]
											"Crystalsong_Sparkles03.m2", -- [4]
										},
										["N"] = "Sparkles",
									}, -- [4]
									{
										["T"] = {
											"CrystallineHeartwood01.m2", -- [1]
											"CrystalsongAspenBush01.m2", -- [2]
											"CrystalsongAspenBush02.m2", -- [3]
											"CrystalsongAspenTree01.m2", -- [4]
											"CrystalsongAspenTree02.m2", -- [5]
											"CrystalsongAspenTree03.m2", -- [6]
											"CrystalsongAspenTree04.m2", -- [7]
											"CrystalsongAspenTree05.m2", -- [8]
											"CrystalsongAspenTree06.m2", -- [9]
											"CrystalsongAspenTree07.m2", -- [10]
											"CrystalsongAspenTree08.m2", -- [11]
											"CrystalsongBush01.m2", -- [12]
											"CrystalsongBush02.M2", -- [13]
											"CrystalsongGuardianTree01.M2", -- [14]
											"CrystalsongGuardianTree02.M2", -- [15]
											"Crystalsongtree01.m2", -- [16]
											"Crystalsongtree02.m2", -- [17]
											"Crystalsongtree03.m2", -- [18]
											"Crystalsongtree04.M2", -- [19]
										},
										["N"] = "Trees",
									}, -- [5]
								},
								["N"] = "Crystalsongforest",
							}, -- [5]
							{
								["T"] = {
									{
										["T"] = {
											"HF_BurningShip_FrontPiece.m2", -- [1]
											"HF_BurningShip_Mast.m2", -- [2]
											"HF_BurningShip_Plank1.m2", -- [3]
											"HF_BurningShip_Plank2.m2", -- [4]
											"HF_BurningShip_Plank3.m2", -- [5]
											"HF_BurningShip_Plank4.m2", -- [6]
											"HF_BurningShip_Rail.m2", -- [7]
											"HowlingFjord_BurningShip.M2", -- [8]
										},
										["N"] = "Burningship",
									}, -- [1]
								},
								["N"] = "Daggercap",
							}, -- [6]
							{
								["T"] = {
									{
										["T"] = {
											"DalaranSewer01.m2", -- [1]
											"DalaranSewer_ArenaWaterFall.M2", -- [2]
											"DalaranSewer_ArenaWaterFall_Collision.m2", -- [3]
											"DalaranSewer_Arena_Wave_01.M2", -- [4]
											"DalaranSewer_SewerWater_01.M2", -- [5]
											"DalaranSewer_SewerWater_02.M2", -- [6]
											"DalaranSewer_SewerWater_03.M2", -- [7]
											"DalaranSewer_SewerWater_04.M2", -- [8]
											"DalaranSewer_SewerWater_05.m2", -- [9]
											"DalaranSewer_WaterFall_EndTube_Long.m2", -- [10]
											"DalaranSewer_WaterFall_EndTube_Med.m2", -- [11]
											"DalaranSewer_WaterFall_EndTube_Short.m2", -- [12]
											"DalaranSewer_WaterFall_HalfTube_Long.m2", -- [13]
											"DalaranSewer_WaterFall_HalfTube_Med.m2", -- [14]
											"DalaranSewer_WaterFall_HalfTube_Short.m2", -- [15]
											"DalaranSewer_WaterFall_Tube_01.m2", -- [16]
										},
										["N"] = "Sewer",
									}, -- [1]
									{
										["T"] = {
											"Dalaran_TirionStatue_Plaque.m2", -- [1]
										},
										["N"] = "Statue",
									}, -- [2]
									{
										["T"] = {
											"DalaranBigTree_01.m2", -- [1]
											"DalaranBush_01.m2", -- [2]
											"DalaranTree_01.m2", -- [3]
											"DalaranTree_02.m2", -- [4]
										},
										["N"] = "Tree",
									}, -- [3]
									"Carrot_On_A_Stick.m2", -- [4]
									"DalaranCounter_01.M2", -- [5]
									"Dalaran_AirportStatue_01.M2", -- [6]
									"Dalaran_Anvil.m2", -- [7]
									"Dalaran_Aquarium_01.M2", -- [8]
									"Dalaran_Assorted_Counter01.M2", -- [9]
									"Dalaran_Assorted_Counter02.M2", -- [10]
									"Dalaran_BannerWall_01.M2", -- [11]
									"Dalaran_BannerWall_02.m2", -- [12]
									"Dalaran_BannerWall_03.M2", -- [13]
									"Dalaran_Banner_01.m2", -- [14]
									"Dalaran_Banner_02.m2", -- [15]
									"Dalaran_Banner_Alliance_01.m2", -- [16]
									"Dalaran_Banner_Alliance_02.M2", -- [17]
									"Dalaran_Banner_Horde_01.m2", -- [18]
									"Dalaran_Banner_Horde_02.M2", -- [19]
									"Dalaran_Banner_Main_01.m2", -- [20]
									"Dalaran_Barrel_01.m2", -- [21]
									"Dalaran_Bed_01.m2", -- [22]
									"Dalaran_Bed_02.m2", -- [23]
									"Dalaran_BeerTable_01.m2", -- [24]
									"Dalaran_BeerTable_Seat_01.m2", -- [25]
									"Dalaran_Bench01.M2", -- [26]
									"Dalaran_Bench02.m2", -- [27]
									"Dalaran_Bookcase_01.m2", -- [28]
									"Dalaran_Bookcase_Empty_01.m2", -- [29]
									"Dalaran_BuildingCrystal_01.M2", -- [30]
									"Dalaran_BuildingCrystal_02.M2", -- [31]
									"Dalaran_BuildingCrystal_02Off.M2", -- [32]
									"Dalaran_CakeSlice_01.m2", -- [33]
									"Dalaran_CakeSlice_02.m2", -- [34]
									"Dalaran_CakeSlice_03.m2", -- [35]
									"Dalaran_CakeSlice_04.m2", -- [36]
									"Dalaran_CakeStandLid_01.M2", -- [37]
									"Dalaran_CakeStand_01.M2", -- [38]
									"Dalaran_Cake_01.m2", -- [39]
									"Dalaran_Cake_02.m2", -- [40]
									"Dalaran_Cake_03.m2", -- [41]
									"Dalaran_Chair01.m2", -- [42]
									"Dalaran_Chair_01.M2", -- [43]
									"Dalaran_Chair_02.m2", -- [44]
									"Dalaran_CherryBlossoms.M2", -- [45]
									"Dalaran_Cloth_Counter01.M2", -- [46]
									"Dalaran_Cloth_Counter02.M2", -- [47]
									"Dalaran_Cookie_01.m2", -- [48]
									"Dalaran_Cookie_02.m2", -- [49]
									"Dalaran_Cookie_03.m2", -- [50]
									"Dalaran_Cookie_04.m2", -- [51]
									"Dalaran_Cookie_05.m2", -- [52]
									"Dalaran_Counter_01.M2", -- [53]
									"Dalaran_Counter_Alchemy.M2", -- [54]
									"Dalaran_Crate_01.m2", -- [55]
									"Dalaran_Crate_03.m2", -- [56]
									"Dalaran_Crate_04.m2", -- [57]
									"Dalaran_CraterDome.m2", -- [58]
									"Dalaran_CrystalBall_01.m2", -- [59]
									"Dalaran_Cupcake_01.m2", -- [60]
									"Dalaran_Cupcake_02.m2", -- [61]
									"Dalaran_Cupcake_03.m2", -- [62]
									"Dalaran_Cupcake_04.m2", -- [63]
									"Dalaran_Doughnut_01.m2", -- [64]
									"Dalaran_Doughnut_02.m2", -- [65]
									"Dalaran_Doughnut_stand.M2", -- [66]
									"Dalaran_Eye_01.M2", -- [67]
									"Dalaran_Flower_stand.m2", -- [68]
									"Dalaran_ForSale_01.m2", -- [69]
									"Dalaran_Forge.M2", -- [70]
									"Dalaran_ForgeArms.m2", -- [71]
									"Dalaran_ForgeSmelter.m2", -- [72]
									"Dalaran_Fountain_01.M2", -- [73]
									"Dalaran_Fountain_02.m2", -- [74]
									"Dalaran_Fruit_stand.m2", -- [75]
									"Dalaran_GuildVault_01.M2", -- [76]
									"Dalaran_Guild_Counter01.M2", -- [77]
									"Dalaran_Guild_Counter02.M2", -- [78]
									"Dalaran_Hat_01.m2", -- [79]
									"Dalaran_Helm_DeepDiveHelm_Space.m2", -- [80]
									"Dalaran_Helm_Mail_Northrend_D_01.M2", -- [81]
									"Dalaran_Helm_Mask_Plague.M2", -- [82]
									"Dalaran_Helm_Plate_Northrend_D_01.M2", -- [83]
									"Dalaran_Helm_Plate_Viking_D_01.m2", -- [84]
									"Dalaran_Helm_Robe_Mage_B_01.m2", -- [85]
									"Dalaran_Helm_Robe_RaidMage_B_01.M2", -- [86]
									"Dalaran_Helm_Robe_RaidMage_D_01.m2", -- [87]
									"Dalaran_Helm_Robe_RaidMage_F_01.M2", -- [88]
									"Dalaran_JewelCounter.M2", -- [89]
									"Dalaran_LampWall01.m2", -- [90]
									"Dalaran_Lamppost01.M2", -- [91]
									"Dalaran_LongBanners01.m2", -- [92]
									"Dalaran_MagePortal_01.M2", -- [93]
									"Dalaran_MagicalTrash_01.M2", -- [94]
									"Dalaran_MagicalTrash_02.m2", -- [95]
									"Dalaran_MagicalTrash_03.m2", -- [96]
									"Dalaran_MagicalTrash_04.m2", -- [97]
									"Dalaran_Painting_01.m2", -- [98]
									"Dalaran_Painting_02.m2", -- [99]
									"Dalaran_Painting_03.m2", -- [100]
									"Dalaran_Painting_04.m2", -- [101]
									"Dalaran_Painting_05.m2", -- [102]
									"Dalaran_Painting_06.m2", -- [103]
									"Dalaran_Painting_07.m2", -- [104]
									"Dalaran_Painting_08.m2", -- [105]
									"Dalaran_Painting_09.m2", -- [106]
									"Dalaran_Painting_10.m2", -- [107]
									"Dalaran_Painting_11.m2", -- [108]
									"Dalaran_PetCage_01.M2", -- [109]
									"Dalaran_Planter_01.m2", -- [110]
									"Dalaran_Planter_02.m2", -- [111]
									"Dalaran_PrisonDoor_01.m2", -- [112]
									"Dalaran_PrisonDoor_02.M2", -- [113]
									"Dalaran_PrisonDoor_03.M2", -- [114]
									"Dalaran_PrisonDoor_04.m2", -- [115]
									"Dalaran_PrisonDoor_05.m2", -- [116]
									"Dalaran_PrisonDoor_Glow.m2", -- [117]
									"Dalaran_RhinoRug_01.m2", -- [118]
									"Dalaran_Rug_01.m2", -- [119]
									"Dalaran_Rug_02.m2", -- [120]
									"Dalaran_Rug_03.m2", -- [121]
									"Dalaran_Rug_04.m2", -- [122]
									"Dalaran_Sconce_Indoor_01.M2", -- [123]
									"Dalaran_Sconce_Indoor_02.M2", -- [124]
									"Dalaran_Sconce_Indoor_03.M2", -- [125]
									"Dalaran_Sculpture.M2", -- [126]
									"Dalaran_SewerDoor_01.m2", -- [127]
									"Dalaran_SewerGrate_01.m2", -- [128]
									"Dalaran_Sign_Alchemy.m2", -- [129]
									"Dalaran_Sign_ArmorShop.m2", -- [130]
									"Dalaran_Sign_Bank.m2", -- [131]
									"Dalaran_Sign_CheeseShop.m2", -- [132]
									"Dalaran_Sign_Enchanting.m2", -- [133]
									"Dalaran_Sign_Engineering.m2", -- [134]
									"Dalaran_Sign_FirstAid.m2", -- [135]
									"Dalaran_Sign_GeneralGoods.m2", -- [136]
									"Dalaran_Sign_InformationCenter.m2", -- [137]
									"Dalaran_Sign_Inscription.m2", -- [138]
									"Dalaran_Sign_Jewelcrafting.m2", -- [139]
									"Dalaran_Sign_Leatherworking.m2", -- [140]
									"Dalaran_Sign_MagicShop.m2", -- [141]
									"Dalaran_Sign_Mining.m2", -- [142]
									"Dalaran_Sign_PetShop.m2", -- [143]
									"Dalaran_Sign_RangedWeaponShop.m2", -- [144]
									"Dalaran_Sign_StavesWands.m2", -- [145]
									"Dalaran_Sign_Tailoring.m2", -- [146]
									"Dalaran_Sign_Tavern.m2", -- [147]
									"Dalaran_Sign_ToyShop.m2", -- [148]
									"Dalaran_Sign_WeaponShop.m2", -- [149]
									"Dalaran_Signpost.m2", -- [150]
									"Dalaran_SignpostSign.m2", -- [151]
									"Dalaran_Skinning_stand.M2", -- [152]
									"Dalaran_StatueAntonidas.M2", -- [153]
									"Dalaran_StatueAntonidas_Plaque.m2", -- [154]
									"Dalaran_Table_01.m2", -- [155]
									"Dalaran_Toy_Counter.M2", -- [156]
									"Dalaran_Toy_Shelves01.m2", -- [157]
									"Dalaran_Toy_Shelves02.m2", -- [158]
									"Dalaran_Toy_Shelves03.M2", -- [159]
									"Dalaran_Toy_Shelves04.m2", -- [160]
									"Dalaran_Wagon01.m2", -- [161]
									"Dalaran_Wand_stand.M2", -- [162]
									"Dalaran_Weapon_stand.M2", -- [163]
									"Dalaran_Well_01.M2", -- [164]
									"Dalaran_chandelier01.M2", -- [165]
									"Dalaran_chandelier01_Short.m2", -- [166]
									"Dalaran_chandelier02.m2", -- [167]
									"Dalaran_chandelier02_Short.m2", -- [168]
									"Dalaran_greenhouse.m2", -- [169]
									"Dalaran_inn_window.M2", -- [170]
									"Dalaran_sewer_oldworld_pipe01.m2", -- [171]
									"Dalaran_sewer_oldworld_pipe02.m2", -- [172]
									"Dalaranshrub.m2", -- [173]
									"InscriptionShopDoodads.M2", -- [174]
									"JewelryStore_Rug_01.m2", -- [175]
									"Jewelry_PosterScroll_01.m2", -- [176]
									"Jewelry_PosterScroll_02.m2", -- [177]
									"Nifty_StopWatch.M2", -- [178]
									"Robe_Female_A_01.m2", -- [179]
									"Robe_Mage_B_01.m2", -- [180]
									"Robe_Mage_D_01.m2", -- [181]
									"Robe_Mage_F_01.m2", -- [182]
									"Shoulder_Mage_B_01.m2", -- [183]
									"Shoulder_Mage_F_01.m2", -- [184]
									"Tradeskill_Enchanting_01.m2", -- [185]
									"Tradeskill_Enchanting_02.M2", -- [186]
									"Tradeskill_FirstAid_01.M2", -- [187]
									"Tradeskill_FirstAid_02.m2", -- [188]
									"Tradeskill_Fishing_01.m2", -- [189]
									"Tradeskill_Herbs_01.m2", -- [190]
									"Tradeskill_Herbs_02.m2", -- [191]
									"Tradeskill_Leatherworking_01.m2", -- [192]
									"Tradeskill_Leatherworking_02.m2", -- [193]
									"Tradeskill_Skinning_01.m2", -- [194]
									"Tradeskill_Skinning_02.m2", -- [195]
									"Tradeskill_Tailoring_01.m2", -- [196]
									"Tradeskill_Tailoring_02.m2", -- [197]
									"dalaran_greenhouse_glass.m2", -- [198]
								},
								["N"] = "Dalaran",
							}, -- [7]
							{
								["T"] = {
									{
										["T"] = {
											"HugeProtoDragonSkull01.m2", -- [1]
										},
										["N"] = "Hugeprotodragonskull",
									}, -- [1]
									{
										["T"] = {
											"ND_cavespiderweb.m2", -- [1]
										},
										["N"] = "Nerubianspiderwebs",
									}, -- [2]
									{
										["T"] = {
											"DragonBlight_Combin_WaterFall_01.m2", -- [1]
											"DragonBlight_Combin_WaterFall_02.m2", -- [2]
											"DragonBlight_Combin_WaterFall_03.m2", -- [3]
											"DragonBlight_Combin_WaterFall_04.m2", -- [4]
											"DragonBlight_Combin_WaterFall_05.m2", -- [5]
											"DragonBlight_Combin_WaterFall_06.m2", -- [6]
											"DragonBlight_Combin_WaterFall_07.m2", -- [7]
										},
										["N"] = "Waterfalls",
									}, -- [3]
									{
										["T"] = {
											"DragonBlight_WindGust_01.M2", -- [1]
										},
										["N"] = "Weatherfx",
									}, -- [4]
									"BD_Lavafall01.m2", -- [5]
									"BD_Lavafall02.m2", -- [6]
									"BD_Lavafall03.m2", -- [7]
									"DB_DragonArm01_Left.m2", -- [8]
									"DB_DragonArm01_LeftBlack.m2", -- [9]
									"DB_DragonArm01_LeftBlue.m2", -- [10]
									"DB_DragonArm01_LeftGray.m2", -- [11]
									"DB_DragonArm01_LeftWhite.m2", -- [12]
									"DB_DragonArm01_Right.m2", -- [13]
									"DB_DragonArm01_RightBlack.M2", -- [14]
									"DB_DragonArm01_RightBlue.m2", -- [15]
									"DB_DragonArm01_RightGray.m2", -- [16]
									"DB_DragonArm01_RightWhite.m2", -- [17]
									"DB_DragonArmStraight_Left.m2", -- [18]
									"DB_DragonArmStraight_LeftBlack.m2", -- [19]
									"DB_DragonArmStraight_LeftBlue.m2", -- [20]
									"DB_DragonArmStraight_Right.m2", -- [21]
									"DB_DragonArmStraight_RightBlack.m2", -- [22]
									"DB_DragonArmStraight_RightBlue.m2", -- [23]
									"DB_DragonClaw01_LeftBlue.m2", -- [24]
									"DB_DragonFrozen001.m2", -- [25]
									"DB_DragonFrozen002.M2", -- [26]
									"DB_DragonFrozen002_Burned.M2", -- [27]
									"DB_DragonFrozen002_Burned02.M2", -- [28]
									"DB_DragonFrozen003.m2", -- [29]
									"DB_DragonHead01.m2", -- [30]
									"DB_DragonHead02.m2", -- [31]
									"DB_DragonHead03.m2", -- [32]
									"DB_DragonHead04.m2", -- [33]
									"DB_DragonJaw01.m2", -- [34]
									"DB_DragonJaw02.M2", -- [35]
									"DB_DragonJaw03.m2", -- [36]
									"DB_DragonJaw04.m2", -- [37]
									"DB_DragonLeg01_Left.m2", -- [38]
									"DB_DragonLeg01_Left2.M2", -- [39]
									"DB_DragonLeg01_Right.m2", -- [40]
									"DB_DragonRib01.m2", -- [41]
									"DB_DragonRib01Black.m2", -- [42]
									"DB_DragonRib01Blue.m2", -- [43]
									"DB_DragonRib01Gray.m2", -- [44]
									"DB_DragonRib01White.m2", -- [45]
									"DB_DragonRibCage01.m2", -- [46]
									"DB_DragonRibCage02.m2", -- [47]
									"DB_DragonRibCage03.m2", -- [48]
									"DB_DragonRibCage05.M2", -- [49]
									"DB_DragonShoulder01.m2", -- [50]
									"DB_DragonShoulder02.m2", -- [51]
									"DB_DragonSingleRib01.m2", -- [52]
									"DB_DragonSingleRib02.m2", -- [53]
									"DB_DragonSingleRib03.m2", -- [54]
									"DB_DragonSkull01.m2", -- [55]
									"DB_DragonSkull02.m2", -- [56]
									"DB_DragonSkull02_Burned.M2", -- [57]
									"DB_DragonSkull03.m2", -- [58]
									"DB_DragonSkull03_Burned.M2", -- [59]
									"DB_DragonSkull04.m2", -- [60]
									"DB_DragonSkull04_Burned.M2", -- [61]
									"DB_DragonSkull05.m2", -- [62]
									"DB_DragonSkull_Black.m2", -- [63]
									"DB_DragonSpareRib01.m2", -- [64]
									"DB_DragonSpareRibs01.m2", -- [65]
									"DB_DragonSpareRibs01Blue.m2", -- [66]
									"DB_DragonSpareRibs01_Burned.M2", -- [67]
									"DB_DragonSpareRibs02.m2", -- [68]
									"DB_DragonSpike01.m2", -- [69]
									"DB_DragonSpike01black.M2", -- [70]
									"DB_DragonSpike01blue.m2", -- [71]
									"DB_DragonSpike01tan.m2", -- [72]
									"DB_DragonSpike02.m2", -- [73]
									"DB_DragonSpike03.m2", -- [74]
									"DB_DragonSpine01.m2", -- [75]
									"DB_DragonSpine01_Black.m2", -- [76]
									"DB_DragonSpine01_Blue.m2", -- [77]
									"DB_DragonSpine01_Gray.m2", -- [78]
									"DB_DragonSpine01_White.m2", -- [79]
									"DB_DragonSpine02.m2", -- [80]
									"DB_DragonSpine02Blue.m2", -- [81]
									"DB_DragonSpine02Blue_Burned.M2", -- [82]
									"DB_DragonSpine03.m2", -- [83]
									"DB_DragonSpine04.m2", -- [84]
									"DB_DragonSpine04_Burned.M2", -- [85]
									"DB_DragonSpinePiece01.m2", -- [86]
									"DB_DragonSpinePiece02.m2", -- [87]
									"DB_DragonSpinePiece03.m2", -- [88]
									"DB_DragonWing01_Left.m2", -- [89]
									"DB_DragonWing01_LeftBlack.m2", -- [90]
									"DB_DragonWing01_LeftBlue.m2", -- [91]
									"DB_DragonWing01_LeftGray.m2", -- [92]
									"DB_DragonWing01_LeftWhite.m2", -- [93]
									"DB_DragonWing01_Right.m2", -- [94]
									"DB_DragonWing01_RightBlack.m2", -- [95]
									"DB_DragonWing01_RightBlue.m2", -- [96]
									"DB_DragonWing01_RightGray.m2", -- [97]
									"DB_DragonWing01_RightWhite.m2", -- [98]
									"DB_Flowers01.m2", -- [99]
									"DB_Flowers02.m2", -- [100]
									"DB_Flowers03.m2", -- [101]
									"DB_FrostmorneAltar_01.M2", -- [102]
									"DB_FrostmorneAltar_02.M2", -- [103]
									"DB_Lilypads01.m2", -- [104]
									"DB_Lilypads02.m2", -- [105]
									"DB_Red_Dragon_Shrine_Leafs.m2", -- [106]
									"DB_leaves_fall.M2", -- [107]
									"DB_leaves_fall02.m2", -- [108]
									"DRAGONBLIGHT_FIRES_UPPER_NORTH_03_QUIETER.M2", -- [109]
									"DragonBlight_Bush01.m2", -- [110]
									"DragonBlight_Bush02.m2", -- [111]
									"DragonBlight_Bush03.m2", -- [112]
									"DragonBlight_Cliff_01.m2", -- [113]
									"DragonBlight_Cliff_02.m2", -- [114]
									"DragonBlight_Cliff_03.m2", -- [115]
									"DragonBlight_Cliff_04.m2", -- [116]
									"DragonBlight_Cliff_05.m2", -- [117]
									"DragonBlight_Cliff_06.m2", -- [118]
									"DragonBlight_Cliff_Grey_01.m2", -- [119]
									"DragonBlight_Cliff_Grey_02.m2", -- [120]
									"DragonBlight_Cliff_Grey_03.m2", -- [121]
									"DragonBlight_Cliff_Grey_04.m2", -- [122]
									"DragonBlight_Cliff_Grey_05.m2", -- [123]
									"DragonBlight_Cliff_Grey_06.m2", -- [124]
									"DragonBlight_Fires_Lower_01.M2", -- [125]
									"DragonBlight_Fires_Lower_East_02.M2", -- [126]
									"DragonBlight_Fires_Lower_West_03.M2", -- [127]
									"DragonBlight_Fires_Upper_East_01.M2", -- [128]
									"DragonBlight_Fires_Upper_North_03.M2", -- [129]
									"DragonBlight_Fires_Upper_West_02.M2", -- [130]
									"DragonBlight_IceArch_01.m2", -- [131]
									"DragonBlight_IceArch_02.m2", -- [132]
									"DragonBlight_IceCliff_01.m2", -- [133]
									"DragonBlight_IceCliff_02.m2", -- [134]
									"DragonBlight_IceCliff_03.m2", -- [135]
									"DragonBlight_IceCliff_04.m2", -- [136]
									"DragonBlight_IceCliff_05.m2", -- [137]
									"DragonBlight_IceCliff_06.m2", -- [138]
									"DragonBlight_IceDragonWall_01.m2", -- [139]
									"DragonBlight_IceRock_01.m2", -- [140]
									"DragonBlight_IceRock_02.m2", -- [141]
									"DragonBlight_IceRock_03.m2", -- [142]
									"DragonBlight_IceRock_04.m2", -- [143]
									"DragonBlight_IceRock_05.m2", -- [144]
									"DragonBlight_IceRock_06.m2", -- [145]
									"DragonBlight_IceShard_01.m2", -- [146]
									"DragonBlight_IceShard_02.m2", -- [147]
									"DragonBlight_IceShard_03.m2", -- [148]
									"DragonBlight_IceShard_04.m2", -- [149]
									"DragonBlight_IceShard_05.m2", -- [150]
									"DragonBlight_IceShard_06.m2", -- [151]
									"DragonBlight_Iceberg_Large_01.m2", -- [152]
									"DragonBlight_Iceberg_Large_02.m2", -- [153]
									"DragonBlight_Iceberg_Large_03.m2", -- [154]
									"DragonBlight_Iceberg_Large_04.m2", -- [155]
									"DragonBlight_Iceberg_Large_05.m2", -- [156]
									"DragonBlight_Iceberg_Large_06.m2", -- [157]
									"DragonBlight_Icicle_01.m2", -- [158]
									"DragonBlight_Icicle_02.M2", -- [159]
									"DragonBlight_Rock_01.m2", -- [160]
									"DragonBlight_Rock_02.m2", -- [161]
									"DragonBlight_Rock_03.m2", -- [162]
									"DragonBlight_Rock_04.m2", -- [163]
									"DragonBlight_Rock_05.m2", -- [164]
									"DragonBlight_Rock_06.m2", -- [165]
									"DragonBlight_Rock_Grey_01.m2", -- [166]
									"DragonBlight_Rock_Grey_02.m2", -- [167]
									"DragonBlight_Rock_Grey_03.m2", -- [168]
									"DragonBlight_Rock_Grey_04.m2", -- [169]
									"DragonBlight_Rock_Grey_05.m2", -- [170]
									"DragonBlight_Rock_Grey_06.m2", -- [171]
									"DragonBlight_Shard_01.m2", -- [172]
									"DragonBlight_Shard_02.m2", -- [173]
									"DragonBlight_Shard_03.m2", -- [174]
									"DragonBlight_Shard_04.m2", -- [175]
									"DragonBlight_Shard_05.m2", -- [176]
									"DragonBlight_Shard_06.m2", -- [177]
									"DragonBlight_Shard_Grey_01.m2", -- [178]
									"DragonBlight_Shard_Grey_02.m2", -- [179]
									"DragonBlight_Shard_Grey_03.m2", -- [180]
									"DragonBlight_Shard_Grey_04.m2", -- [181]
									"DragonBlight_Shard_Grey_05.m2", -- [182]
									"DragonBlight_Shard_Grey_06.m2", -- [183]
									"DragonBlight_Shoreline_Ice_01.M2", -- [184]
									"DragonBlight_Shoreline_Ice_02.M2", -- [185]
									"DragonBlight_Shoreline_Ice_Single.M2", -- [186]
									"DragonBlight_TitanIceSheet_01.m2", -- [187]
									"DragonBlight_TitanIceSheet_02.M2", -- [188]
									"DragonBlight_TitanIceSheet_03.m2", -- [189]
									"DragonBlight_Tree01.m2", -- [190]
									"DragonBlight_Tree02.m2", -- [191]
									"DragonBlight_Tree03.m2", -- [192]
									"DragonBlight_Tree04.m2", -- [193]
									"DragonBlight_Tree05.m2", -- [194]
									"DragonBlight_Tree06.m2", -- [195]
									"DragonBlight_Tree07.m2", -- [196]
									"DragonBlight_TreeInfected01.m2", -- [197]
									"DragonBlight_TreeInfected02.m2", -- [198]
									"DragonBlight_TreeInfected03.m2", -- [199]
									"DragonBlight_TreeInfected04.m2", -- [200]
									"Dragonblight_DebrisPile_01.m2", -- [201]
									"Dragonblight_DebrisPile_02.m2", -- [202]
									"Dragonblight_LeavesLarge.M2", -- [203]
									"Dragonblight_Leaves_01.M2", -- [204]
									"ScytheOfAntiok.m2", -- [205]
								},
								["N"] = "Dragonblight",
							}, -- [8]
							{
								["T"] = {
									{
										["T"] = {
											"DT_bigDoor.M2", -- [1]
										},
										["N"] = "Doors",
									}, -- [1]
									{
										["T"] = {
											"GunDrak_TrapDoor01.m2", -- [1]
										},
										["N"] = "Trapdoors",
									}, -- [2]
								},
								["N"] = "Draktheron",
							}, -- [9]
							{
								["T"] = {
									"FB_BeeHive.M2", -- [1]
									"FB_Darkshore_Totem01.m2", -- [2]
									"FB_Darkshore_Totem02.m2", -- [3]
									"FB_Lampost_GH_Alone.M2", -- [4]
									"FB_Lamppost_Darkshore_01.M2", -- [5]
									"FB_Lamppost_GH_01.M2", -- [6]
									"FB_LogHouse_Darkshore_01.m2", -- [7]
									"FB_LogHouse_Darkshore_02.m2", -- [8]
									"FB_LogHouse_Darkshore_03.m2", -- [9]
									"FB_LogHouse_GH_01.M2", -- [10]
									"FB_LogHouse_GH_02.M2", -- [11]
									"FB_LogHouse_GH_03.M2", -- [12]
									"FB_LogHouse_GH_Snow_01.m2", -- [13]
									"FB_LogHouse_GH_Snow_02.m2", -- [14]
									"FB_LogHouse_GH_Snow_03.m2", -- [15]
									"FB_Totem01.M2", -- [16]
									"FB_Totem01_Snow.m2", -- [17]
									"FB_Totem02.m2", -- [18]
									"FB_Totem02_Snow.m2", -- [19]
									"FB_WallGateTeeth_01_Darkshore.m2", -- [20]
									"FB_WallGateTeeth_01_GrizzlyHills.M2", -- [21]
									"FB_WallGateTeeth_01_GrizzlyHills_Snow.m2", -- [22]
									"FB_WallGate_01_Darkshore.m2", -- [23]
									"FB_WallGate_01_GrizzlyHills.m2", -- [24]
									"FB_WallGate_01_GrizzlyHills_Snow.m2", -- [25]
									"FB_Wall_01_Darkshore.m2", -- [26]
									"FB_Wall_01_GrizzlyHills.m2", -- [27]
									"FB_Wall_01_GrizzlyHills_snow.m2", -- [28]
									"FB_Wall_02_Darkshore.m2", -- [29]
									"FB_Wall_02_GrizzlyHills.m2", -- [30]
									"FB_Wall_02_GrizzlyHills_snow.m2", -- [31]
									"FB_Wall_03_Darkshore.m2", -- [32]
									"FB_Wall_03_GrizzlyHills.M2", -- [33]
									"FB_Wall_03_GrizzlyHills_snow.m2", -- [34]
								},
								["N"] = "Furbolgs",
							}, -- [10]
							{
								["T"] = {
									{
										["T"] = {
											"Borean_BrokenRoadLamp01.m2", -- [1]
											"Borean_RoadLamp01.m2", -- [2]
											"Borean_SignPost01.m2", -- [3]
										},
										["N"] = "Ancientnightelf",
									}, -- [1]
									{
										["T"] = {
											{
												["T"] = {
													"ArgentCursade_WindyPennant01.m2", -- [1]
													"Tournament_Banner_BE02.m2", -- [2]
													"Tournament_Banner_Bloodelf01.M2", -- [3]
													"Tournament_Banner_Bloodelf02.M2", -- [4]
													"Tournament_Banner_Bloodelf02_noCol.M2", -- [5]
													"Tournament_Banner_Draenei01.m2", -- [6]
													"Tournament_Banner_Draenei02.M2", -- [7]
													"Tournament_Banner_Draenei02_noCol.M2", -- [8]
													"Tournament_Banner_Dwarf01.m2", -- [9]
													"Tournament_Banner_Dwarf02.M2", -- [10]
													"Tournament_Banner_Dwarf02_noCol.M2", -- [11]
													"Tournament_Banner_FK01.m2", -- [12]
													"Tournament_Banner_FK02.M2", -- [13]
													"Tournament_Banner_FK02_noCol.M2", -- [14]
													"Tournament_Banner_Gnome01.M2", -- [15]
													"Tournament_Banner_Gnome02.M2", -- [16]
													"Tournament_Banner_Gnome02_noCol.M2", -- [17]
													"Tournament_Banner_Horde01.m2", -- [18]
													"Tournament_Banner_Horde02.M2", -- [19]
													"Tournament_Banner_Horde02_noCol.M2", -- [20]
													"Tournament_Banner_Human01.M2", -- [21]
													"Tournament_Banner_Human02.M2", -- [22]
													"Tournament_Banner_Human02_noCol.M2", -- [23]
													"Tournament_Banner_NELF01.m2", -- [24]
													"Tournament_Banner_NELF02.M2", -- [25]
													"Tournament_Banner_NELF02_noCol.M2", -- [26]
													"Tournament_Banner_Tauren01.M2", -- [27]
													"Tournament_Banner_Tauren02.M2", -- [28]
													"Tournament_Banner_Tauren02_noCol.M2", -- [29]
													"Tournament_Banner_Trolls01.m2", -- [30]
													"Tournament_Banner_Trolls02.M2", -- [31]
													"Tournament_Banner_Trolls02_noCol.M2", -- [32]
												},
												["N"] = "Banners",
											}, -- [1]
											{
												["T"] = {
													"Tournament_Pennant_ArgentCru01.m2", -- [1]
													"Tournament_Pennant_ArgentCru02.M2", -- [2]
													"Tournament_Pennant_ArgentCru03.m2", -- [3]
													"Tournament_Pennant_ArgentCru_Low.m2", -- [4]
													"Tournament_Pennant_BE01.m2", -- [5]
													"Tournament_Pennant_BE02.m2", -- [6]
													"Tournament_Pennant_BE03.m2", -- [7]
													"Tournament_Pennant_BE_Low.m2", -- [8]
													"Tournament_Pennant_Draenei01.M2", -- [9]
													"Tournament_Pennant_Draenei02.M2", -- [10]
													"Tournament_Pennant_Draenei03.M2", -- [11]
													"Tournament_Pennant_Draenei_Low.M2", -- [12]
													"Tournament_Pennant_Dwarf01.M2", -- [13]
													"Tournament_Pennant_Dwarf02.M2", -- [14]
													"Tournament_Pennant_Dwarf03.M2", -- [15]
													"Tournament_Pennant_Dwarf_Low.M2", -- [16]
													"Tournament_Pennant_EbonBlade01.m2", -- [17]
													"Tournament_Pennant_EbonBlade02.m2", -- [18]
													"Tournament_Pennant_EbonBlade03.m2", -- [19]
													"Tournament_Pennant_EbonBlade_Low.m2", -- [20]
													"Tournament_Pennant_FK01.M2", -- [21]
													"Tournament_Pennant_FK02.M2", -- [22]
													"Tournament_Pennant_FK03.M2", -- [23]
													"Tournament_Pennant_FK_Low.M2", -- [24]
													"Tournament_Pennant_Gnome01.M2", -- [25]
													"Tournament_Pennant_Gnome02.M2", -- [26]
													"Tournament_Pennant_Gnome03.M2", -- [27]
													"Tournament_Pennant_Gnome_Low.M2", -- [28]
													"Tournament_Pennant_Goblin01.M2", -- [29]
													"Tournament_Pennant_Goblin02.M2", -- [30]
													"Tournament_Pennant_Goblin03.M2", -- [31]
													"Tournament_Pennant_Goblin_Low.M2", -- [32]
													"Tournament_Pennant_Human01.m2", -- [33]
													"Tournament_Pennant_Human02.m2", -- [34]
													"Tournament_Pennant_Human03.m2", -- [35]
													"Tournament_Pennant_Human_Low.m2", -- [36]
													"Tournament_Pennant_NELF01.m2", -- [37]
													"Tournament_Pennant_NELF02.m2", -- [38]
													"Tournament_Pennant_NELF03.m2", -- [39]
													"Tournament_Pennant_NELF_Low.m2", -- [40]
													"Tournament_Pennant_Orc01.m2", -- [41]
													"Tournament_Pennant_Orc02.m2", -- [42]
													"Tournament_Pennant_Orc03.m2", -- [43]
													"Tournament_Pennant_Orc_Low.m2", -- [44]
													"Tournament_Pennant_Pandaren01.M2", -- [45]
													"Tournament_Pennant_Pandaren02.M2", -- [46]
													"Tournament_Pennant_Pandaren03.M2", -- [47]
													"Tournament_Pennant_Pandaren_Low.M2", -- [48]
													"Tournament_Pennant_Tauren01.M2", -- [49]
													"Tournament_Pennant_Tauren02.M2", -- [50]
													"Tournament_Pennant_Tauren03.M2", -- [51]
													"Tournament_Pennant_Tauren_Low.M2", -- [52]
													"Tournament_Pennant_Troll01.M2", -- [53]
													"Tournament_Pennant_Troll02.M2", -- [54]
													"Tournament_Pennant_Troll03.M2", -- [55]
													"Tournament_Pennant_Troll_Low.M2", -- [56]
													"Tournament_Pennant_Worgen01.M2", -- [57]
													"Tournament_Pennant_Worgen02.M2", -- [58]
													"Tournament_Pennant_Worgen03.M2", -- [59]
													"Tournament_Pennant_Worgen_Low.M2", -- [60]
												},
												["N"] = "Pennants",
											}, -- [2]
											"ArgentCrusade_Arch_01.M2", -- [3]
											"ArgentCrusade_Banner01.M2", -- [4]
											"ArgentCrusade_Banner01_NoColl.M2", -- [5]
											"ArgentCrusade_Banner02.M2", -- [6]
											"ArgentCrusade_BatteringRam_01.m2", -- [7]
											"ArgentCrusade_BatteringRam_02.M2", -- [8]
											"ArgentCrusade_BeerVendor.M2", -- [9]
											"ArgentCrusade_Brick_01.m2", -- [10]
											"ArgentCrusade_Brick_02.m2", -- [11]
											"ArgentCrusade_Chest_01.m2", -- [12]
											"ArgentCrusade_Fence_01.m2", -- [13]
											"ArgentCrusade_FoodTent.M2", -- [14]
											"ArgentCrusade_FoodTent_02.M2", -- [15]
											"ArgentCrusade_Jousting_Lane_End.m2", -- [16]
											"ArgentCrusade_Jousting_Lane_Middle.m2", -- [17]
											"ArgentCrusade_Log_01.m2", -- [18]
											"ArgentCrusade_MonsterDoor.m2", -- [19]
											"ArgentCrusade_OpenTent.M2", -- [20]
											"ArgentCrusade_Sword_In_Ice.M2", -- [21]
											"ArgentCrusade_Sword_N_Stone.m2", -- [22]
											"ArgentCrusade_Tent05.m2", -- [23]
											"ArgentCrusade_Tent06.m2", -- [24]
											"ArgentCrusade_Tent07.m2", -- [25]
											"ArgentCrusade_Wall_01.m2", -- [26]
											"ArgentCrusade_Wall_02.m2", -- [27]
											"ArgentCrusade_small01.m2", -- [28]
											"Argent_Long_Banner_01.m2", -- [29]
											"Argent_Shield.m2", -- [30]
											"Argent_Web_Door_01.m2", -- [31]
											"ND_ArgentCrusadeColiseum_Trapdoor_01.m2", -- [32]
											"ND_ArgentCrusadeColiseum_floorpieces.M2", -- [33]
										},
										["N"] = "Argentcrusade",
									}, -- [2]
									{
										["T"] = {
											"Barbershop_Chair01.M2", -- [1]
											"Barbershop_Mirror_01.m2", -- [2]
											"Barbershop_PoleStanding.m2", -- [3]
											"Barbershop_PoleWall.m2", -- [4]
											"Barbershop_Poster01.m2", -- [5]
											"Barbershop_Poster02.m2", -- [6]
											"Barbershop_Razor.m2", -- [7]
											"Barbershop_ShaveBrush.m2", -- [8]
											"Barbershop_ShaveCup.m2", -- [9]
											"Barbershop_Wig01.m2", -- [10]
											"Barbershop_Wig02.m2", -- [11]
											"Barbershop_Wig03.m2", -- [12]
											"Barbershop_Wig04.m2", -- [13]
											"Barbershop_Wig05.m2", -- [14]
										},
										["N"] = "Barbershop",
									}, -- [3]
									{
										["T"] = {
											"BonfireNorthrend_01.M2", -- [1]
											"BonfireNorthrend_01Blue.M2", -- [2]
										},
										["N"] = "Bonfire",
									}, -- [4]
									{
										["T"] = {
											"catwolf_footprint_brush01.m2", -- [1]
											"catwolf_footprint_brush01_flipped.M2", -- [2]
											"catwolf_footprint_debris01.m2", -- [3]
											"catwolf_footprint_debris01_flipped.M2", -- [4]
											"catwolf_footprint_grass01.m2", -- [5]
											"catwolf_footprint_grass01_flipped.M2", -- [6]
											"catwolf_footprint_moss01.m2", -- [7]
											"catwolf_footprint_moss01_flipped.M2", -- [8]
											"catwolf_footprint_mud01.m2", -- [9]
											"catwolf_footprint_mud01_flipped.M2", -- [10]
											"catwolf_footprint_snow01.m2", -- [11]
											"catwolf_footprint_snow01_flipped.M2", -- [12]
										},
										["N"] = "Catwolftracks",
									}, -- [5]
									{
										["T"] = {
											{
												["T"] = {
													"Dest_Tower_1_a.m2", -- [1]
													"Dest_Tower_1_b.m2", -- [2]
													"Dest_Tower_1_c.m2", -- [3]
													"Dest_Tower_1_d.m2", -- [4]
													"Dest_Tower_1_e.m2", -- [5]
													"Dest_Tower_1_f.m2", -- [6]
													"Dest_Tower_1_g.m2", -- [7]
													"Dest_Tower_1_h.m2", -- [8]
													"Dest_Tower_1_i.m2", -- [9]
													"Dest_Tower_1_j.m2", -- [10]
													"Dest_Tower_1_k.m2", -- [11]
													"Dest_Tower_1_l.m2", -- [12]
													"Dest_Tower_1_m.m2", -- [13]
													"Dest_Tower_2_a.m2", -- [14]
													"Dest_Tower_2_b.m2", -- [15]
													"Dest_Tower_2_c.m2", -- [16]
													"Dest_Tower_2_d.m2", -- [17]
													"Dest_Tower_2_e.m2", -- [18]
													"Dest_Tower_2_f.m2", -- [19]
													"Dest_Tower_2_g.m2", -- [20]
													"Dest_Tower_2_h.m2", -- [21]
													"Dest_Tower_2_i.m2", -- [22]
													"Dest_Tower_2_j.m2", -- [23]
													"Dest_Tower_2_k.m2", -- [24]
													"Dest_Tower_2_l.m2", -- [25]
													"Dest_Tower_2_m.m2", -- [26]
													"Dest_Tower_damaged.M2", -- [27]
													"Dest_Tower_destroyed.M2", -- [28]
													"Dest_Tower_pieces.m2", -- [29]
													"GuardTower_damaged_fade.M2", -- [30]
													"GuardTower_destroyed_fade.M2", -- [31]
													"GuardTower_intact_fade.M2", -- [32]
												},
												["N"] = "Guardtower",
											}, -- [1]
										},
										["N"] = "Destructible",
									}, -- [6]
									{
										["T"] = {
											"EbonBlade_Banner01.m2", -- [1]
											"EbonBlade_Banner02.m2", -- [2]
											"EbonBlade_Banner02_NoCollision.m2", -- [3]
										},
										["N"] = "Ebonblade",
									}, -- [7]
									{
										["T"] = {
											"Firstaid_NoCollision.M2", -- [1]
										},
										["N"] = "Firstaid",
									}, -- [8]
									{
										["T"] = {
											"FK_Banner01.m2", -- [1]
											"FK_Banner01Wall.m2", -- [2]
											"FK_Banner02Wall.m2", -- [3]
											"FK_Barricade_01.m2", -- [4]
											"FK_Catapult_Broke.M2", -- [5]
											"FK_ChemistrySet_02.M2", -- [6]
											"FK_ChemistrySet_03.M2", -- [7]
											"FK_ChemistrySet_04.m2", -- [8]
											"FK_ChemistrySet_05.M2", -- [9]
											"FK_ChemistrySet_06.m2", -- [10]
											"FK_ChemistrySet_07.M2", -- [11]
											"FK_ChemistrySet_forbuilding_01.m2", -- [12]
											"FK_ChemistrySet_forbuilding_02.m2", -- [13]
											"FK_ChemistryTube_01.m2", -- [14]
											"FK_ChemistryTube_02.m2", -- [15]
											"FK_ChemistryTube_03.m2", -- [16]
											"FK_ChemistryTube_04.m2", -- [17]
											"FK_Fence01.m2", -- [18]
											"FK_Fence02.m2", -- [19]
											"FK_Fence03.M2", -- [20]
											"FK_Fence04.M2", -- [21]
											"FK_Fence05.M2", -- [22]
											"FK_FencePost.m2", -- [23]
											"FK_FencePost01.M2", -- [24]
											"FK_LampHanging.m2", -- [25]
											"FK_Lamppost.m2", -- [26]
											"FK_Lamppost_Unlit.m2", -- [27]
											"FK_Painting01.m2", -- [28]
											"FK_Painting02.m2", -- [29]
											"FK_Painting03.m2", -- [30]
											"FK_Painting04.m2", -- [31]
											"FK_Painting05.m2", -- [32]
											"FK_PlagueBarrel.m2", -- [33]
											"FK_PlagueBarrelBroken01.m2", -- [34]
											"FK_PlagueBarrelBroken02.m2", -- [35]
											"FK_PlagueBarrelEmpty.M2", -- [36]
											"FK_PlagueCistern.M2", -- [37]
											"FK_PlagueWagon.M2", -- [38]
											"FK_PlagueWagon_Empty.m2", -- [39]
											"FK_PlagueWagon_Low.M2", -- [40]
											"FK_SignPost.m2", -- [41]
											"FK_SignPost_Sign.m2", -- [42]
											"FK_Tent01.m2", -- [43]
											"FK_Tent01_Ruined.m2", -- [44]
											"FK_Tent02.m2", -- [45]
											"FK_Tent02_Ruined.m2", -- [46]
											"FK_Tent03.m2", -- [47]
											"FK_Tent04.m2", -- [48]
											"FK_Tent05.m2", -- [49]
											"FK_Wagon01.M2", -- [50]
											"FK_Wagon02.m2", -- [51]
										},
										["N"] = "Forsaken",
									}, -- [9]
									{
										["T"] = {
											"FrostGiant_Club01.m2", -- [1]
											"FrostGiant_Collumn01.m2", -- [2]
											"FrostGiant_Collumn02.m2", -- [3]
											"FrostGiant_FrostOrb01.M2", -- [4]
											"FrostGiant_FrostOrbBroken01.M2", -- [5]
											"FrostGiant_Shield01.m2", -- [6]
											"FrostGiant_Shield02.m2", -- [7]
											"FrostGiant_Shield03.m2", -- [8]
											"FrostGiant_Shield04.m2", -- [9]
											"FrostGiant_Spear01.m2", -- [10]
											"FrostGiant_Spear02.m2", -- [11]
										},
										["N"] = "Frostgiant",
									}, -- [10]
									{
										["T"] = {
											"Gnome_Pipe_01.m2", -- [1]
											"Gnome_Pipe_02.M2", -- [2]
											"Gnome_Pipe_03.m2", -- [3]
											"Gnome_Pipe_04.m2", -- [4]
											"Gnome_Pipe_05.m2", -- [5]
											"Gnome_Pipe_06.m2", -- [6]
											"Gnome_Pipe_08.m2", -- [7]
											"Gnome_Pipe_09.m2", -- [8]
											"Gnome_Radiation_Bomb_01.M2", -- [9]
											"Gnome_WaterPack.M2", -- [10]
										},
										["N"] = "Gnome",
									}, -- [11]
									{
										["T"] = {
											{
												["T"] = {
													"GoblinBench01.m2", -- [1]
												},
												["N"] = "Bench",
											}, -- [1]
											{
												["T"] = {
													"RadioTowerFlag01.m2", -- [1]
												},
												["N"] = "Radiotower",
											}, -- [2]
											"Goblin_FuelCell.M2", -- [3]
										},
										["N"] = "Goblin",
									}, -- [12]
									{
										["T"] = {
											"Hanging_Strider01.m2", -- [1]
										},
										["N"] = "Hangingmeat",
									}, -- [13]
									{
										["T"] = {
											"HE_Ballista_01.m2", -- [1]
											"HE_Banner_01.m2", -- [2]
											"HE_Banner_02.m2", -- [3]
											"HE_Banner_03.M2", -- [4]
											"HE_Tent_01.m2", -- [5]
											"HE_Wagon_01.m2", -- [6]
										},
										["N"] = "Highelf",
									}, -- [14]
									{
										["T"] = {
											{
												["T"] = {
													"ND_Human_Barrier.M2", -- [1]
													"ND_Human_Barrier_End.M2", -- [2]
												},
												["N"] = "Barriers",
											}, -- [1]
											{
												["T"] = {
													"Cuckooclock_01.m2", -- [1]
													"Grandfather_Clock_01.m2", -- [2]
												},
												["N"] = "Clocks",
											}, -- [2]
											{
												["T"] = {
													"CrateGrainNormal_01.m2", -- [1]
													"CrateGrainPlagued_01.M2", -- [2]
												},
												["N"] = "Crates",
											}, -- [3]
											{
												["T"] = {
													"HU_Fence01_Northrend.m2", -- [1]
													"HU_Fence02_Northrend.m2", -- [2]
													"HU_Fence03_Northrend.m2", -- [3]
													"HU_Fence04_Northrend.m2", -- [4]
													"HU_Fence05_Northrend.m2", -- [5]
													"HU_Fence06_Northrend.m2", -- [6]
													"HU_Fencepost_Northrend.m2", -- [7]
												},
												["N"] = "Fence",
											}, -- [4]
											{
												["T"] = {
													"Alliance_Banner_01.M2", -- [1]
												},
												["N"] = "Flags",
											}, -- [5]
											{
												["T"] = {
													"HU_Lamp_Northrend.m2", -- [1]
												},
												["N"] = "Lamp",
											}, -- [6]
											{
												["T"] = {
													"HU_Lamp_Arm_Northrend.m2", -- [1]
													"HU_Lamppost_Northrend.m2", -- [2]
												},
												["N"] = "Lamppost",
											}, -- [7]
											{
												["T"] = {
													{
														["T"] = {
														},
														["N"] = "Final",
													}, -- [1]
												},
												["N"] = "Northrend Human Mailbox Dodad",
											}, -- [8]
											{
												["T"] = {
													{
														["T"] = {
														},
														["N"] = "Final",
													}, -- [1]
												},
												["N"] = "Northrend_humanladder",
											}, -- [9]
											{
												["T"] = {
													"HU_Signpost_Northrend.m2", -- [1]
													"HU_Signpost_Sign_Northrend.m2", -- [2]
												},
												["N"] = "Signpost",
											}, -- [10]
											{
												["T"] = {
													"HU_Tent01.m2", -- [1]
													"HU_Tent02.m2", -- [2]
													"HU_Tents_HordeStartLowerLeft.M2", -- [3]
													"HU_Tents_HordeStartUpperLeft.M2", -- [4]
													"HU_Tents_HordeStartUpperRight.M2", -- [5]
												},
												["N"] = "Tents",
											}, -- [11]
											{
												["T"] = {
													"NorthrendTorch_01.M2", -- [1]
													"NorthrendTorch_01Blue.M2", -- [2]
												},
												["N"] = "Torch",
											}, -- [12]
											"HU_Brick_Pile01.m2", -- [13]
											"HU_Brick_Pile02.m2", -- [14]
											"HU_Cannon_01.M2", -- [15]
											"HU_Crane_Dock.M2", -- [16]
											"HU_Crane_WoodPile.m2", -- [17]
											"HU_Dock_Destruction_Piling.M2", -- [18]
											"HU_Jail_Door_01.m2", -- [19]
											"HU_Justice_Flags_01.m2", -- [20]
											"HU_Justice_Flags_02.m2", -- [21]
											"HU_Justice_Flags_03.m2", -- [22]
											"HU_Justice_Flags_04.m2", -- [23]
											"HU_Justice_Flags_05.M2", -- [24]
											"HU_Justice_Flags_06.m2", -- [25]
											"HU_Justice_Flags_08.M2", -- [26]
											"HU_Northrend_CrowdStand_01.M2", -- [27]
											"HU_Piling.m2", -- [28]
											"HU_Portcullis.m2", -- [29]
											"HU_Pulley.m2", -- [30]
											"HU_Pulley_Crates.M2", -- [31]
											"HU_Rope01.M2", -- [32]
											"HU_Scaffolding.M2", -- [33]
											"HU_Scaffolding02.M2", -- [34]
											"HU_Scaffolding03.m2", -- [35]
											"HU_Scaffolding04.m2", -- [36]
											"HU_Tarp_Boxes.m2", -- [37]
											"ND_Human_Gate_ClosedFX.m2", -- [38]
											"ND_Human_Gate_ClosedFX_Door.m2", -- [39]
											"ND_Human_Gate_Closed_collision.m2", -- [40]
											"ND_Human_Wall_End_Small_damagedfx02.m2", -- [41]
											"ND_Human_Wall_End_damagedfx.m2", -- [42]
											"ND_Human_Wall_Small_damagedfx02.m2", -- [43]
											"ND_Human_Wall_damagedfx.m2", -- [44]
											"nd_human_Brick_Pile01.M2", -- [45]
											"nd_human_Brick_Pile02.M2", -- [46]
										},
										["N"] = "Human",
									}, -- [15]
									{
										["T"] = {
											"Inscription_InkBottle_Black01.m2", -- [1]
											"Inscription_InkBottle_Black02.m2", -- [2]
											"Inscription_InkBottle_Black03.m2", -- [3]
											"Inscription_InkBottle_Black04.m2", -- [4]
											"Inscription_InkBottle_Black05.m2", -- [5]
											"Inscription_InkBottle_Blue01.m2", -- [6]
											"Inscription_InkBottle_Blue02.m2", -- [7]
											"Inscription_InkBottle_Blue03.m2", -- [8]
											"Inscription_InkBottle_Gold01.m2", -- [9]
											"Inscription_InkBottle_Green01.m2", -- [10]
											"Inscription_InkBottle_Green02.m2", -- [11]
											"Inscription_InkBottle_Green03.m2", -- [12]
											"Inscription_InkBottle_Green04.m2", -- [13]
											"Inscription_InkBottle_Iron01.m2", -- [14]
											"Inscription_InkBottle_Purple01.m2", -- [15]
											"Inscription_InkBottle_Purple02.m2", -- [16]
											"Inscription_InkBottle_Purple03.m2", -- [17]
											"Inscription_InkBottle_Red01.m2", -- [18]
											"Inscription_InkBottle_Red02.m2", -- [19]
											"Inscription_InkBottle_Red03.m2", -- [20]
											"Inscription_InkBottle_Red04.m2", -- [21]
											"Inscription_InkBottle_Silver01.m2", -- [22]
											"Inscription_Quill01.m2", -- [23]
											"Inscription_Quill02.m2", -- [24]
											"Inscription_Quill03.m2", -- [25]
											"Inscription_Quill04.m2", -- [26]
											"Inscription_QuillOstrich01.m2", -- [27]
											"Inscription_QuillPeacock01.m2", -- [28]
											"Inscription_Quill_Frosty.m2", -- [29]
											"Inscription_Quill_Phoenix.m2", -- [30]
											"Inscription_Scroll_BoxSide.m2", -- [31]
											"Inscription_Scroll_BoxUp.m2", -- [32]
											"Inscription_Scroll_RolledBlank.m2", -- [33]
											"Inscription_Scroll_RolledBlue.m2", -- [34]
											"Inscription_Scroll_RolledGreen.m2", -- [35]
											"Inscription_Scroll_RolledPin01.m2", -- [36]
											"Inscription_Scroll_RolledPin02.m2", -- [37]
											"Inscription_Scroll_RolledPin03.m2", -- [38]
											"Inscription_Scroll_RolledPin04.m2", -- [39]
											"Inscription_Scroll_RolledPinDouble01.m2", -- [40]
											"Inscription_Scroll_RolledPurple.m2", -- [41]
											"Inscription_Scroll_RolledRed.m2", -- [42]
											"Inscription_Scroll_Sealed01.m2", -- [43]
											"Inscription_Scroll_Sealed02.m2", -- [44]
											"Inscription_Scroll_Sealed03.m2", -- [45]
											"Inscription_Scroll_Sealed04.m2", -- [46]
										},
										["N"] = "Inscription",
									}, -- [16]
									{
										["T"] = {
											{
												["T"] = {
													"ID_Cage-active.m2", -- [1]
												},
												["N"] = "Quest",
											}, -- [1]
											"ID_Anvil.m2", -- [2]
											"ID_Banner1.m2", -- [3]
											"ID_Banner2.m2", -- [4]
											"ID_BenchSimple.m2", -- [5]
											"ID_Cage.m2", -- [6]
											"ID_ChairMedium.m2", -- [7]
											"ID_ChairMedium_Broken.m2", -- [8]
											"ID_ChairSmall.m2", -- [9]
											"ID_ChairSmall_Broken.m2", -- [10]
											"ID_ChairThrone.m2", -- [11]
											"ID_Chandelier-off.m2", -- [12]
											"ID_Chandelier.m2", -- [13]
											"ID_Crate.m2", -- [14]
											"ID_Crate2.m2", -- [15]
											"ID_Crate3.m2", -- [16]
											"ID_Crate4.m2", -- [17]
											"ID_Forge.M2", -- [18]
											"ID_Forge_02.M2", -- [19]
											"ID_KegMetalFree.m2", -- [20]
											"ID_KegMetalStand.m2", -- [21]
											"ID_Lamppost-Off.m2", -- [22]
											"ID_Lamppost.m2", -- [23]
											"ID_Lantern.m2", -- [24]
											"ID_Large-Lantern.m2", -- [25]
											"ID_LowStairs.m2", -- [26]
											"ID_LowStairs_Small.m2", -- [27]
											"ID_LowWall.m2", -- [28]
											"ID_Pillar.m2", -- [29]
											"ID_PillarBase.M2", -- [30]
											"ID_Signpost.m2", -- [31]
											"ID_Signpost_Sign.m2", -- [32]
											"ID_TableLarge.m2", -- [33]
											"ID_TableMedium.m2", -- [34]
											"ID_TableMedium_Broken.m2", -- [35]
											"ID_TableSmall.m2", -- [36]
											"ID_TableSmall_Broken.m2", -- [37]
											"ID_Wall_Lamp-off.m2", -- [38]
											"ID_Wall_Lamp.m2", -- [39]
											"ID_cliff_facade01.m2", -- [40]
											"ID_cliff_facade02.m2", -- [41]
											"ID_elevator.m2", -- [42]
											"ID_fencepost01.m2", -- [43]
											"ID_fencepost02.m2", -- [44]
											"ID_fencepost03.m2", -- [45]
											"ID_fencepost_Base.m2", -- [46]
											"ID_lamppost_broken.m2", -- [47]
											"ID_lightning01_blue.m2", -- [48]
											"Id_Barrel.m2", -- [49]
											"Id_Bed1.m2", -- [50]
											"Id_Bed2.m2", -- [51]
											"Id_Bed3.m2", -- [52]
										},
										["N"] = "Irondwarf",
									}, -- [17]
									{
										["T"] = {
											"ND_WinterOrc_Column.M2", -- [1]
											"ND_WinterOrc_Wall.M2", -- [2]
											"ND_WinterOrc_Wall2.M2", -- [3]
											"ND_WinterOrc_WallFX.m2", -- [4]
											"ND_WinterOrc_WallMedium.M2", -- [5]
											"ND_WinterOrc_Wall_GateFX.m2", -- [6]
											"ND_WinterOrc_Wall_GateFX_Door.m2", -- [7]
										},
										["N"] = "Nd_winterorc",
									}, -- [18]
									{
										["T"] = {
											{
												["T"] = {
													"NB_SmallSinkhole01.m2", -- [1]
												},
												["N"] = "Pits",
											}, -- [1]
											"Nerubian_LivingEgg_01.m2", -- [2]
											"Nerubian_ScourgeEgg_01.m2", -- [3]
											"Nerubian_Water_01.m2", -- [4]
										},
										["N"] = "Nerubian",
									}, -- [19]
									{
										["T"] = {
											"NorthrendElwynnCampfire.M2", -- [1]
											"NorthrendElwynnCampfire_blue.M2", -- [2]
											"NorthrendFreestandingTorch04_GIANT.M2", -- [3]
											"NorthrendGeneralTorch01.m2", -- [4]
											"NorthrendGeneralTorch02.m2", -- [5]
											"NorthrendOrcBonFire.m2", -- [6]
											"NorthrendTallBrazierNoOmni01.M2", -- [7]
											"NorthrendUndeadCampFire.m2", -- [8]
										},
										["N"] = "Northrend Fires",
									}, -- [20]
									{
										["T"] = {
											"O_Crystal_01.m2", -- [1]
											"O_Crystal_02.m2", -- [2]
											"O_Crystal_Large.m2", -- [3]
											"O_Egg_01.m2", -- [4]
											"O_Egg_02.m2", -- [5]
											"O_Egg_03.m2", -- [6]
											"O_Egg_04.m2", -- [7]
											"O_Egg_05.m2", -- [8]
											"O_Hanger_Bones.m2", -- [9]
											"O_Hanger_Coconuts.m2", -- [10]
											"O_Hanger_Crystal01.m2", -- [11]
											"O_Hanger_Crystal02.m2", -- [12]
											"O_Hanger_Extension.m2", -- [13]
											"O_LampWall_01.m2", -- [14]
											"O_Lamppost_01.m2", -- [15]
											"O_SurfBoard01.m2", -- [16]
											"O_SurfBoard02.m2", -- [17]
											"O_SurfBoard03.m2", -- [18]
											"O_SurfBoard04.m2", -- [19]
											"O_Totem_01.m2", -- [20]
											"O_TrashPile_01.m2", -- [21]
											"O_TrashPile_02.m2", -- [22]
										},
										["N"] = "Oracle",
									}, -- [21]
									{
										["T"] = {
											"Potion_Black01.m2", -- [1]
											"Potion_Black03.m2", -- [2]
											"Potion_Blue01.m2", -- [3]
											"Potion_Empty01.m2", -- [4]
											"Potion_Empty02.m2", -- [5]
											"Potion_Gold01.m2", -- [6]
											"Potion_Green01.m2", -- [7]
											"Potion_Green04.m2", -- [8]
											"Potion_Iron01.m2", -- [9]
											"Potion_Purple01.m2", -- [10]
											"Potion_Red01.m2", -- [11]
											"Potion_Red04.m2", -- [12]
											"Potion_Silver01.m2", -- [13]
										},
										["N"] = "Potions",
									}, -- [22]
									{
										["T"] = {
											"ScarletO_Banner01.m2", -- [1]
											"ScarletO_Banner01Wall.m2", -- [2]
											"ScarletO_Banner02.m2", -- [3]
											"ScarletO_Banner02Wall.m2", -- [4]
											"ScarletO_Brazier_Fire.m2", -- [5]
											"ScarletO_Brazier_Lit.m2", -- [6]
											"ScarletO_Brazier_Smoker.m2", -- [7]
											"ScarletO_Brazier_UnLit.m2", -- [8]
											"ScarletO_Brazier_UnLit_Base.m2", -- [9]
											"ScarletO_Gallows.m2", -- [10]
										},
										["N"] = "Scarletonslaught",
									}, -- [23]
									{
										["T"] = {
											{
												["T"] = {
													"CD_Altar_02.m2", -- [1]
												},
												["N"] = "Cd",
											}, -- [1]
											"Icecrown_Stairs01.m2", -- [2]
											"SC_Banner.m2", -- [3]
											"SC_Banner_02.m2", -- [4]
											"SC_Banner_03.M2", -- [5]
											"SC_Banner_04.m2", -- [6]
											"SC_Banner_05.m2", -- [7]
											"SC_Banner_06.m2", -- [8]
											"SC_Barrel_01.m2", -- [9]
											"SC_Barrel_01_Broken.m2", -- [10]
											"SC_Barrel_02_Broken.m2", -- [11]
											"SC_Barricade.m2", -- [12]
											"SC_Barricade_Broken.m2", -- [13]
											"SC_Blighter.M2", -- [14]
											"SC_Blighter2.m2", -- [15]
											"SC_Blighter2_Green.m2", -- [16]
											"SC_Blighter_Broken.m2", -- [17]
											"SC_Blighter_Green.m2", -- [18]
											"SC_BloodOrb.m2", -- [19]
											"SC_BodyCart_01.m2", -- [20]
											"SC_BodyCart_02.m2", -- [21]
											"SC_BodyCart_Destroyed.m2", -- [22]
											"SC_BodyCart_Nobody.m2", -- [23]
											"SC_BodyHook.m2", -- [24]
											"SC_BodyHook_Arm_01.m2", -- [25]
											"SC_BodyHook_Arm_02.m2", -- [26]
											"SC_BodyHook_Boot.m2", -- [27]
											"SC_BodyHook_Torso.m2", -- [28]
											"SC_Bodycart_Body.m2", -- [29]
											"SC_Bodyjar.m2", -- [30]
											"SC_Bodyjar_03.m2", -- [31]
											"SC_Bodyjar_Ghoul.m2", -- [32]
											"SC_Bodyjar_Orange.m2", -- [33]
											"SC_Bodyjar_Orange_02.m2", -- [34]
											"SC_Bodyjar_Orange_03.m2", -- [35]
											"SC_Bodyjar_Skeleton.m2", -- [36]
											"SC_BoneArm_01.m2", -- [37]
											"SC_BoneArm_Green_01.m2", -- [38]
											"SC_BonesawTable_01.m2", -- [39]
											"SC_Brazier1.m2", -- [40]
											"SC_Brazier1_Long.m2", -- [41]
											"SC_Brazier1_Long_Orange.m2", -- [42]
											"SC_Brazier2.m2", -- [43]
											"SC_Brazier2_Orange.m2", -- [44]
											"SC_Brazier2_Short.m2", -- [45]
											"SC_Brazier2_long.m2", -- [46]
											"SC_Brazier2_long_orange.m2", -- [47]
											"SC_Brazier3.m2", -- [48]
											"SC_Brazier3_Orange.m2", -- [49]
											"SC_Cages_01.m2", -- [50]
											"SC_Cages_02.m2", -- [51]
											"SC_CastingCircle_01.M2", -- [52]
											"SC_Cauldron.M2", -- [53]
											"SC_Cauldron_Empty.m2", -- [54]
											"SC_Cauldron_Green.M2", -- [55]
											"SC_Cauldron_Green_02.m2", -- [56]
											"SC_Chain.m2", -- [57]
											"SC_Chest.m2", -- [58]
											"SC_Conveyer.m2", -- [59]
											"SC_Crane_01.m2", -- [60]
											"SC_Crane_02.m2", -- [61]
											"SC_Crate_01.m2", -- [62]
											"SC_Crate_02.m2", -- [63]
											"SC_DeathStar_01.M2", -- [64]
											"SC_EmbalmingFluid.m2", -- [65]
											"SC_EngineOfSouls_Effect_01.m2", -- [66]
											"SC_EyeofAcherus.M2", -- [67]
											"SC_EyeofAcherus_02.M2", -- [68]
											"SC_EyeofAcherus_03.m2", -- [69]
											"SC_Fence.m2", -- [70]
											"SC_Fence_Base.m2", -- [71]
											"SC_Fleshgiant_Arm_01.m2", -- [72]
											"SC_Fleshgiant_Arm_02.m2", -- [73]
											"SC_Fleshgiant_Boot.m2", -- [74]
											"SC_Fleshgiant_Leg.m2", -- [75]
											"SC_Fleshgiant_Torso.m2", -- [76]
											"SC_Floor_Decoration_01.m2", -- [77]
											"SC_FrostGlow.m2", -- [78]
											"SC_MeatWagon_01.m2", -- [79]
											"SC_MeatWagon_01_Broken.M2", -- [80]
											"SC_Obelisk1.m2", -- [81]
											"SC_Obelisk2.m2", -- [82]
											"SC_PitCylinder.m2", -- [83]
											"SC_PitCylinder_02.m2", -- [84]
											"SC_PitCylinder_TEMP.m2", -- [85]
											"SC_PlagueBarrel.M2", -- [86]
											"SC_PlagueBarrel_02.m2", -- [87]
											"SC_PlagueBomb_Green.m2", -- [88]
											"SC_PlagueBomb_Orange.m2", -- [89]
											"SC_Platform.m2", -- [90]
											"SC_Platform2.m2", -- [91]
											"SC_RuneForge_01.M2", -- [92]
											"SC_RuneForge_02.M2", -- [93]
											"SC_SkullPikes_01.m2", -- [94]
											"SC_SkullPikes_02.m2", -- [95]
											"SC_SlimePool_Green.m2", -- [96]
											"SC_SlimePool_Orange.M2", -- [97]
											"SC_SpiritEffect_01.m2", -- [98]
											"SC_Spirits_01.M2", -- [99]
											"SC_Spirits_02.m2", -- [100]
											"SC_Spirits_03.m2", -- [101]
											"SC_Stairs.m2", -- [102]
											"SC_Stairs2.m2", -- [103]
											"SC_SurgicalTable_01.m2", -- [104]
											"SC_SurgicalTable_02.m2", -- [105]
											"SC_TeleportPad.M2", -- [106]
											"SC_TeleportPad2.m2", -- [107]
											"SC_TeleportPad3.m2", -- [108]
											"SC_Tent1.m2", -- [109]
											"SC_Tent1_Destroyed.m2", -- [110]
											"SC_Tent2.m2", -- [111]
											"SC_Tent_Destroyed.m2", -- [112]
											"SC_Wagon.M2", -- [113]
											"SC_Wagon_02.m2", -- [114]
											"SC_Wagon_02_Broken.m2", -- [115]
											"SC_Wagon_Broken.M2", -- [116]
											"SC_Wall_01.m2", -- [117]
											"SC_Wall_01_Cap.m2", -- [118]
											"SC_Wall_01_Ramp.m2", -- [119]
											"SC_Wall_02.m2", -- [120]
											"SC_Wall_02_Cap.m2", -- [121]
											"SC_Wall_02_Ramp.m2", -- [122]
											"SC_Wall_03.m2", -- [123]
											"SC_Wall_04.m2", -- [124]
											"SC_Wall_05.m2", -- [125]
											"SC_Wall_05_Piece.m2", -- [126]
											"SC_Wall_06.m2", -- [127]
											"SC_Wall_06_Piece.m2", -- [128]
											"SC_Wall_Decoration_01.m2", -- [129]
											"SC_Wall_Decoration_02.m2", -- [130]
											"SC_WarMachine_01.M2", -- [131]
											"SC_WarMachine_01_Broken.M2", -- [132]
											"SC_WarMachine_01_Green.M2", -- [133]
											"SC_WeaponRack-Deathknight.m2", -- [134]
											"SC_WeaponRack-Empty.m2", -- [135]
											"SC_WeaponRack-weapon1.m2", -- [136]
											"SC_WeaponRack-weapon2.m2", -- [137]
											"SC_WeaponRack-weapon3.m2", -- [138]
											"SC_WeaponRack-weapon4.m2", -- [139]
											"SC_WeaponRack-weapon5.m2", -- [140]
											"SC_WeaponRack1.m2", -- [141]
											"SC_WeaponRack2.m2", -- [142]
											"SC_WolfSkull_Green_01.m2", -- [143]
											"SC_YoggthoriteBar_01.m2", -- [144]
											"SC_YoggthoriteBar_Stack_01.m2", -- [145]
											"SC_operation_table.m2", -- [146]
											"SC_tools_table.m2", -- [147]
											"SC_whole_body.m2", -- [148]
											"Sc_Crystal.m2", -- [149]
											"Sc_Crystal_Base.m2", -- [150]
											"Sc_Trench_C_Long.m2", -- [151]
											"Sc_Trench_C_Medium.m2", -- [152]
											"Sc_Trench_C_Tall.m2", -- [153]
											"Sc_Trench_M_Brace.m2", -- [154]
											"Sc_Trench_M_Long.m2", -- [155]
											"Sc_Trench_M_Medium.m2", -- [156]
											"Sc_Trench_M_Tall.m2", -- [157]
											"Sc_Trench_P_Bar.m2", -- [158]
											"Sc_Trench_P_Bone1.m2", -- [159]
											"Sc_Trench_P_Bone2.m2", -- [160]
											"Sc_Trench_P_Bone3.m2", -- [161]
											"Sc_Trench_P_Bracer.m2", -- [162]
											"Sc_Trench_P_Chain.m2", -- [163]
											"sc_TankTrap.M2", -- [164]
											"sc_alchemy_table.m2", -- [165]
										},
										["N"] = "Scourge",
									}, -- [24]
									{
										["T"] = {
											"SeaMine_01.M2", -- [1]
											"SeaMine_02.M2", -- [2]
										},
										["N"] = "Seamines",
									}, -- [25]
									{
										["T"] = {
											{
												["T"] = {
													"VRS_Chest_01.m2", -- [1]
													"VRS_Crate_01.m2", -- [2]
													"VRS_Crate_Destroyed_01.m2", -- [3]
													"VRS_Netpile_01.m2", -- [4]
													"VRS_Tent_01.m2", -- [5]
													"VRS_Tent_02.m2", -- [6]
												},
												["N"] = "Shore",
											}, -- [1]
											{
												["T"] = {
													"VRS_WeaponRack_01.m2", -- [1]
													"VRS_WeaponRack_02.m2", -- [2]
												},
												["N"] = "Weapons",
											}, -- [2]
										},
										["N"] = "Seavrykul",
									}, -- [26]
									{
										["T"] = {
											"DemolisherStatic.M2", -- [1]
											"SiegeTankStatic.m2", -- [2]
										},
										["N"] = "Seigeequipment",
									}, -- [27]
									{
										["T"] = {
											"Skull_ProtoDragon.m2", -- [1]
											"Skull_ShovelTusk.m2", -- [2]
											"Skull_Wolf.m2", -- [3]
											"Skull_Yeti.m2", -- [4]
										},
										["N"] = "Skulls",
									}, -- [28]
									{
										["T"] = {
											{
												["T"] = {
													"Sunshatter_Banner01.m2", -- [1]
													"Sunshatter_Banner02.M2", -- [2]
													"Sunshatter_Banner03.M2", -- [3]
													"Sunshatter_Monument.m2", -- [4]
												},
												["N"] = "Banner",
											}, -- [1]
										},
										["N"] = "Sunshatter",
									}, -- [29]
									{
										["T"] = {
											"TI_Arch.m2", -- [1]
											"TI_ArchSingle.m2", -- [2]
											"TI_BattlegroundPortal_01.m2", -- [3]
											"TI_Block01.m2", -- [4]
											"TI_Bottom01.m2", -- [5]
											"TI_Bottom02.m2", -- [6]
											"TI_Bridge.m2", -- [7]
											"TI_BrokenPillar.m2", -- [8]
											"TI_BrokenRoad01.m2", -- [9]
											"TI_BrokenRoad02.m2", -- [10]
											"TI_BrokenRoad03.m2", -- [11]
											"TI_BrokenRoad05.m2", -- [12]
											"TI_BrokenRoad05_Small.m2", -- [13]
											"TI_BrokenRoad06.m2", -- [14]
											"TI_BrokenRoad07.m2", -- [15]
											"TI_BrokenRoad08.m2", -- [16]
											"TI_Brokenroad04.m2", -- [17]
											"TI_Building01.m2", -- [18]
											"TI_Building02.m2", -- [19]
											"TI_BuildingBlock01.m2", -- [20]
											"TI_BuildingBlock02.m2", -- [21]
											"TI_BuildingBlock03.m2", -- [22]
											"TI_BuildingBlock04.m2", -- [23]
											"TI_ChamberPortal_Black01.m2", -- [24]
											"TI_ChamberPortal_Blue01.m2", -- [25]
											"TI_ChamberPortal_Bronze01.m2", -- [26]
											"TI_ChamberPortal_Green01.m2", -- [27]
											"TI_ChamberPortal_Red01.m2", -- [28]
											"TI_ChamberPortal_Red01_Broken.m2", -- [29]
											"TI_CurveStair.m2", -- [30]
											"TI_Disc_01.M2", -- [31]
											"TI_Dome.m2", -- [32]
											"TI_Dome02.m2", -- [33]
											"TI_DomeSmall.m2", -- [34]
											"TI_Dragon_Roar_01.M2", -- [35]
											"TI_Dragon_Sit_01.M2", -- [36]
											"TI_ElevatedRoad01.m2", -- [37]
											"TI_ElevatedRoadEnd01.m2", -- [38]
											"TI_FieldGenerator_01.M2", -- [39]
											"TI_FieldGenerator_02.M2", -- [40]
											"TI_FieldGenerator_03.M2", -- [41]
											"TI_FieldGenerator_04.M2", -- [42]
											"TI_FieldGenerator_05.M2", -- [43]
											"TI_LargeWall01.m2", -- [44]
											"TI_LargeWall01_End.m2", -- [45]
											"TI_LowWall01.m2", -- [46]
											"TI_LowWall02.m2", -- [47]
											"TI_MainTower.m2", -- [48]
											"TI_MainTower02.m2", -- [49]
											"TI_Mid01.m2", -- [50]
											"TI_Mid02.m2", -- [51]
											"TI_Mid03.m2", -- [52]
											"TI_Mid04.m2", -- [53]
											"TI_Mid05.m2", -- [54]
											"TI_Mid06.m2", -- [55]
											"TI_MountainBridge01.m2", -- [56]
											"TI_MountainBridge02.m2", -- [57]
											"TI_MountainBridge03.m2", -- [58]
											"TI_MountainStairs01.m2", -- [59]
											"TI_Obelisk01.m2", -- [60]
											"TI_Pillar01.m2", -- [61]
											"TI_Pillar02.m2", -- [62]
											"TI_Pillar04.m2", -- [63]
											"TI_Resurrection_Off_01.m2", -- [64]
											"TI_Resurrection_On_01.m2", -- [65]
											"TI_RoadBroken01.m2", -- [66]
											"TI_RoadBroken02.m2", -- [67]
											"TI_RoadColumn01.m2", -- [68]
											"TI_RoadColumn02.m2", -- [69]
											"TI_RoadColumn03.m2", -- [70]
											"TI_RoadColumnArchPiece.m2", -- [71]
											"TI_RoadColumnBroken.m2", -- [72]
											"TI_RoadColumnPiece.m2", -- [73]
											"TI_RoadCurbBroken01.m2", -- [74]
											"TI_RoadCurbLong01.m2", -- [75]
											"TI_RoadCurbLong02.m2", -- [76]
											"TI_RoadCurbNub01.m2", -- [77]
											"TI_RoadCurbShort01.m2", -- [78]
											"TI_RoadCurbShort02.m2", -- [79]
											"TI_RoadPiece01.m2", -- [80]
											"TI_RoadPiece02.m2", -- [81]
											"TI_RoadPiece03.m2", -- [82]
											"TI_RoadPiece04.m2", -- [83]
											"TI_RoadPiece05.m2", -- [84]
											"TI_RoadPiece06.m2", -- [85]
											"TI_RoadPiece07.m2", -- [86]
											"TI_RoadPiece08.m2", -- [87]
											"TI_RoadSolid01.m2", -- [88]
											"TI_RoadWall01.m2", -- [89]
											"TI_RoadWall02.m2", -- [90]
											"TI_RoadWall03.m2", -- [91]
											"TI_Roof01.m2", -- [92]
											"TI_Shrine_01.m2", -- [93]
											"TI_SinglePillar.m2", -- [94]
											"TI_SmallWall01.m2", -- [95]
											"TI_SmallWall01_End.m2", -- [96]
											"TI_SmallWall02.m2", -- [97]
											"TI_SmallWall02_End.m2", -- [98]
											"TI_SpinningPiece01.m2", -- [99]
											"TI_Stair.m2", -- [100]
											"TI_Stair02.m2", -- [101]
											"TI_TallWall01.m2", -- [102]
											"TI_TallWall02.m2", -- [103]
											"TI_TallWallPillar.m2", -- [104]
											"TI_TallwallCurve.m2", -- [105]
											"TI_Top01.m2", -- [106]
											"TI_Top02.m2", -- [107]
											"TI_Top03.m2", -- [108]
											"TI_Tower_part01.m2", -- [109]
											"TI_Tower_part02.m2", -- [110]
											"TI_Tower_part03.m2", -- [111]
											"TI_Tower_part04.m2", -- [112]
											"TI_Tower_part05.m2", -- [113]
											"TI_Tower_part06.m2", -- [114]
											"TI_Triangleroof01.m2", -- [115]
											"TI_Triangleroof02.m2", -- [116]
											"TI_Trim01.m2", -- [117]
											"TI_Trim02.m2", -- [118]
											"TI_Trim03.m2", -- [119]
											"TI_Trim04.m2", -- [120]
											"TI_Trim05.m2", -- [121]
											"TI_Trim06.m2", -- [122]
											"TI_WallOval01.m2", -- [123]
											"TI_WallOval02.m2", -- [124]
											"TI_WallOval03.m2", -- [125]
											"TI_Waygate_01.m2", -- [126]
											"TI_WeatherGenerator.M2", -- [127]
											"TI_WeatherGenerator_Broken.m2", -- [128]
										},
										["N"] = "Titan",
									}, -- [30]
									{
										["T"] = {
											{
												["T"] = {
													"TS_CrabBasket_01.m2", -- [1]
													"TS_FishingBasket_01.m2", -- [2]
												},
												["N"] = "Crate",
											}, -- [1]
											{
												["T"] = {
													"TS_Dock_01.m2", -- [1]
												},
												["N"] = "Dock",
											}, -- [2]
											{
												["T"] = {
													"TS_Fishingpole_01.m2", -- [1]
												},
												["N"] = "Fishing",
											}, -- [3]
											{
												["T"] = {
													"TS_FishLight.m2", -- [1]
												},
												["N"] = "Fishlamp",
											}, -- [4]
											{
												["T"] = {
													"TS_Log_Pile_01.m2", -- [1]
													"TS_Log_Pile_Snowed_01.m2", -- [2]
												},
												["N"] = "Logs",
											}, -- [5]
											{
												["T"] = {
													"TS_Fence01.m2", -- [1]
													"TS_Fence02.m2", -- [2]
													"TS_Light02.m2", -- [3]
													"TS_Tarp_01.m2", -- [4]
													"TS_Tarp_02.m2", -- [5]
												},
												["N"] = "Misc",
											}, -- [6]
											"TS_Long_Table_02.m2", -- [7]
										},
										["N"] = "Tuskar",
									}, -- [31]
									{
										["T"] = {
											{
												["T"] = {
													"TS_Banner_01.m2", -- [1]
												},
												["N"] = "Banner",
											}, -- [1]
											{
												["T"] = {
													"TS_Chair_01.m2", -- [1]
												},
												["N"] = "Chairs",
											}, -- [2]
											{
												["T"] = {
													"TS_CrabBasket_Empty01.m2", -- [1]
													"TS_FishingBasket_empty_02.M2", -- [2]
													"TS_FishingLine_01.m2", -- [3]
												},
												["N"] = "Fishing",
											}, -- [3]
											{
												["T"] = {
													"TS_Anvil_01.m2", -- [1]
													"TS_Forge_01.M2", -- [2]
												},
												["N"] = "Forge",
											}, -- [4]
											{
												["T"] = {
													"TS_GiantNet01.m2", -- [1]
													"TS_GiantNet01Destroyed.m2", -- [2]
													"TS_GiantNet02.m2", -- [3]
													"TS_GiantNet02Destroyed.m2", -- [4]
												},
												["N"] = "Giantnets",
											}, -- [5]
											{
												["T"] = {
													"ts_incenseburner_01.m2", -- [1]
												},
												["N"] = "Incenseburner",
											}, -- [6]
											{
												["T"] = {
													"TS_Kite_01.m2", -- [1]
												},
												["N"] = "Kites",
											}, -- [7]
											{
												["T"] = {
													"TS_Lantern01.m2", -- [1]
													"TS_Light.m2", -- [2]
													"TS_LightHanging.m2", -- [3]
													"TS_LightPole.m2", -- [4]
												},
												["N"] = "Lights",
											}, -- [8]
											{
												["T"] = {
													"TS_LogRoller_01.m2", -- [1]
												},
												["N"] = "Logs",
											}, -- [9]
											{
												["T"] = {
													"TS_Mailbox_01.m2", -- [1]
												},
												["N"] = "Mailbox",
											}, -- [10]
											{
												["T"] = {
													"TS_Long_Table_01.m2", -- [1]
													"TS_ShortTable_01.m2", -- [2]
												},
												["N"] = "Tables",
											}, -- [11]
											{
												["T"] = {
													"ND_TuskarrWhale.m2", -- [1]
												},
												["N"] = "Tempfootprints",
											}, -- [12]
											"TS_Boat_01.m2", -- [13]
											"TS_Boat_02.m2", -- [14]
											"TS_Chair_Broken01.m2", -- [15]
											"TS_CrabBasket_Broken.m2", -- [16]
											"TS_Dock_01_Destroyed.m2", -- [17]
											"TS_FishingBasket_Broken02.m2", -- [18]
											"TS_FishingHook_Broken.m2", -- [19]
											"TS_FishingHook_Hook.m2", -- [20]
											"TS_Idols_01.m2", -- [21]
											"TS_Idols_02.m2", -- [22]
											"TS_LightHanging02.m2", -- [23]
											"TS_LightHanging_Broken.m2", -- [24]
											"TS_LightPole_Broken.m2", -- [25]
											"TS_Light_Broken02.m2", -- [26]
											"TS_Long_Table_Broken02.m2", -- [27]
											"TS_Tarp_Broken01.m2", -- [28]
										},
										["N"] = "Tuskarr",
									}, -- [32]
									{
										["T"] = {
											{
												["T"] = {
													"VR_Anvil_Cold_01.m2", -- [1]
													"VR_Anvil_Glow_01.m2", -- [2]
												},
												["N"] = "Anvil",
											}, -- [1]
											{
												["T"] = {
													"VR_Banner_01.m2", -- [1]
													"VR_Banner_02.m2", -- [2]
													"VR_Banner_03.m2", -- [3]
													"VR_Sea_Banner_01.m2", -- [4]
													"VR_Wall_Banner_01.m2", -- [5]
													"VR_Wall_Banner_02.m2", -- [6]
													"VR_Wall_Banner_03.m2", -- [7]
												},
												["N"] = "Banner",
											}, -- [2]
											{
												["T"] = {
													"VR_Bed_01.m2", -- [1]
													"VR_Bed_02.m2", -- [2]
													"VR_Wrecked_Bed_01.m2", -- [3]
												},
												["N"] = "Bed",
											}, -- [3]
											{
												["T"] = {
													"VR_Bellows_01.m2", -- [1]
												},
												["N"] = "Bellows",
											}, -- [4]
											{
												["T"] = {
													"Transport_Vrykul_MediumLight_Doodad.M2", -- [1]
													"Transport_Vrykul_Medium_Doodad.m2", -- [2]
												},
												["N"] = "Boats",
											}, -- [5]
											{
												["T"] = {
													"VR_Bookshelf_Large_01.m2", -- [1]
													"VR_Bookshelf_Small_01.m2", -- [2]
													"VR_Bookshelf_Wrecked_01.m2", -- [3]
													"VR_Bookshelf_Wrecked_02.m2", -- [4]
												},
												["N"] = "Bookshelf",
											}, -- [6]
											{
												["T"] = {
													"VR_Brazier_01.M2", -- [1]
													"VR_Brazier_01_Blue.M2", -- [2]
												},
												["N"] = "Brazier",
											}, -- [7]
											{
												["T"] = {
													"VR_BurialMound_01.m2", -- [1]
													"VR_BurialMound_02.m2", -- [2]
												},
												["N"] = "Burialmound",
											}, -- [8]
											{
												["T"] = {
													"VR_Buttress_01.m2", -- [1]
													"VR_Buttress_Snow01.m2", -- [2]
												},
												["N"] = "Buttress",
											}, -- [9]
											{
												["T"] = {
													"VR_Cage_01.m2", -- [1]
													"VR_Cage_01_Snow.m2", -- [2]
													"VR_Cage_02.m2", -- [3]
													"VR_Cage_Base.m2", -- [4]
													"VR_Cage_Top.m2", -- [5]
												},
												["N"] = "Cage",
											}, -- [10]
											{
												["T"] = {
													"VR_Candle_Stand_01.m2", -- [1]
												},
												["N"] = "Candles",
											}, -- [11]
											{
												["T"] = {
													"VR_CenterPiece_01.M2", -- [1]
													"VR_CenterPiece_01Blue.m2", -- [2]
												},
												["N"] = "Centerpiece",
											}, -- [12]
											{
												["T"] = {
													"VR_Chains_01.m2", -- [1]
													"VR_Chains_02.m2", -- [2]
												},
												["N"] = "Chains",
											}, -- [13]
											{
												["T"] = {
													"VR_Chair_01.m2", -- [1]
												},
												["N"] = "Chairs",
											}, -- [14]
											{
												["T"] = {
													"VR_Chandelier_01.m2", -- [1]
												},
												["N"] = "Chandelier",
											}, -- [15]
											{
												["T"] = {
													"VR_Cookpot_01.m2", -- [1]
													"VR_Cookpot_02.m2", -- [2]
													"VR_Cookpot_Off_01.m2", -- [3]
												},
												["N"] = "Cooking",
											}, -- [16]
											{
												["T"] = {
													"VR_BM_Wood_01.m2", -- [1]
													"VR_Crate_01.m2", -- [2]
													"VR_Crate_02.m2", -- [3]
													"VR_Crate_03.m2", -- [4]
													"VR_Crate_04.m2", -- [5]
													"VR_Crate_Snow_01.m2", -- [6]
													"VR_Crate_Snow_02.m2", -- [7]
													"VR_Crate_Snow_03.m2", -- [8]
													"VR_wrecked_Crate_01.m2", -- [9]
													"VR_wrecked_Crate_02.m2", -- [10]
													"VR_wrecked_Crate_Snow_01.m2", -- [11]
													"VR_wrecked_Crate_Snow_02.m2", -- [12]
												},
												["N"] = "Crates",
											}, -- [17]
											{
												["T"] = {
													"VR_CrestWood_01.m2", -- [1]
													"VR_CrestWood_02.m2", -- [2]
												},
												["N"] = "Crest",
											}, -- [18]
											{
												["T"] = {
													"VR_Elevator_Gate.m2", -- [1]
													"VR_Elevator_Gears.m2", -- [2]
													"VR_Elevator_Lift.M2", -- [3]
													"VR_Elevator_Pulley.M2", -- [4]
												},
												["N"] = "Elevator",
											}, -- [19]
											{
												["T"] = {
													"VR_CliffPost.m2", -- [1]
													"VR_Fence_01.m2", -- [2]
													"VR_Fence_02.m2", -- [3]
													"VR_Fence_03.m2", -- [4]
													"VR_Fence_04.m2", -- [5]
													"VR_Fence_05.m2", -- [6]
													"VR_Fence_Snow02.m2", -- [7]
													"VR_Fence_Snow04.m2", -- [8]
													"VR_Fence_Snow05.m2", -- [9]
												},
												["N"] = "Fence",
											}, -- [20]
											{
												["T"] = {
													"VR_ForgeFire_01.M2", -- [1]
												},
												["N"] = "Fires",
											}, -- [21]
											{
												["T"] = {
													"VR_FloorGrate.m2", -- [1]
												},
												["N"] = "Floorgrate",
											}, -- [22]
											{
												["T"] = {
													"VR_Gondola_Pole_01.m2", -- [1]
													"VR_Gondola_Wheel_02.m2", -- [2]
													"VR_Gondola_Wheel_03.m2", -- [3]
													"Vrykul_Gondola.M2", -- [4]
													"Vrykul_Gondola_02.M2", -- [5]
												},
												["N"] = "Gondola",
											}, -- [23]
											{
												["T"] = {
													"VR_Harpoon_02.m2", -- [1]
												},
												["N"] = "Harpoon",
											}, -- [24]
											{
												["T"] = {
													"HayBail_Floating.M2", -- [1]
													"VR_HayBail_01.m2", -- [2]
													"VR_Straw_Large_01.m2", -- [3]
													"VR_Straw_Small_01.M2", -- [4]
												},
												["N"] = "Hay",
											}, -- [25]
											{
												["T"] = {
													"VR_LampPost_01.M2", -- [1]
													"VR_LampPost_02.m2", -- [2]
													"VR_LampPost_03.m2", -- [3]
													"VR_LampPost_Snow_01.M2", -- [4]
													"VR_LampPost_Snow_01Blue.M2", -- [5]
												},
												["N"] = "Lamppost",
											}, -- [26]
											{
												["T"] = {
													"VR_Chandelier_Broken_01.m2", -- [1]
													"VR_Chandelier_Purple_01.M2", -- [2]
													"VR_HangingLight_01.M2", -- [3]
													"VR_HangingLight_01_Blue.M2", -- [4]
													"VR_HangingLight_02.M2", -- [5]
													"VR_HangingLight_02_Blue.M2", -- [6]
													"VR_HangingLight_03.M2", -- [7]
													"VR_HangingLight_03_Blue.M2", -- [8]
													"VR_HangingLight_Broken_01.m2", -- [9]
													"VR_HangingLight_Purple_01.M2", -- [10]
													"VR_StandingLight_01.M2", -- [11]
													"VR_StandingLight_Broken_01.m2", -- [12]
													"VR_StandingLight_Purple_01.M2", -- [13]
													"VR_StandingLight_Snow_01.M2", -- [14]
													"VR_StandingLight_Snow_Blue_01.M2", -- [15]
												},
												["N"] = "Lights",
											}, -- [27]
											{
												["T"] = {
													"VR_Map_01.m2", -- [1]
													"VR_WallMap_01.m2", -- [2]
												},
												["N"] = "Map",
											}, -- [28]
											{
												["T"] = {
													"VR_Portcullis.m2", -- [1]
													"VR_Portculliswithchain.m2", -- [2]
												},
												["N"] = "Portcullis",
											}, -- [29]
											{
												["T"] = {
													"VR_Banner_01_Q.m2", -- [1]
													"VR_Banner_02_Q.m2", -- [2]
													"VR_Bones_01_Q.m2", -- [3]
													"VR_Crate_01_Q.m2", -- [4]
													"VR_Crate_01_Q_noCol.M2", -- [5]
													"VR_CrystalNode_01_Q.m2", -- [6]
													"VR_Plants_01_Q.m2", -- [7]
													"VR_Plants_02_Q.m2", -- [8]
													"VR_Plants_03_Q.m2", -- [9]
													"VR_Plants_04_Q.m2", -- [10]
													"VR_Plants_05_Q.m2", -- [11]
													"VR_Sack_01_Q.m2", -- [12]
													"VR_Sack_02_Q.m2", -- [13]
													"VR_Sack_03_Q.m2", -- [14]
													"VR_Vase_01_Q.m2", -- [15]
													"VR_WeaponRack_01_Q.m2", -- [16]
												},
												["N"] = "Quest",
											}, -- [30]
											{
												["T"] = {
													"VR_FootBridge_Snow_01.m2", -- [1]
													"VR_RoadEdge_01.m2", -- [2]
													"VR_RoadPlankAndCurb_01.m2", -- [3]
													"VR_RoadPlankAndCurb_02.m2", -- [4]
													"VR_RoadPlankAndCurb_03.m2", -- [5]
													"VR_RoadPlankAndCurb_04.m2", -- [6]
													"VR_RoadPlankAndCurb_Wide_01.m2", -- [7]
													"VR_RoadPlankAndCurb_Wide_02.m2", -- [8]
													"VR_RoadPlankAndCurb_Wide_04.m2", -- [9]
													"VR_RoadPlankAndCurb_Wide_05.m2", -- [10]
													"VR_RoadPlank_01.m2", -- [11]
													"VR_RoadPlank_02.m2", -- [12]
													"VR_RoadPlank_03.m2", -- [13]
													"VR_RoadPlank_04.m2", -- [14]
													"VR_RoadPlank_05.m2", -- [15]
													"VR_RoadPlank_06.m2", -- [16]
													"VR_RoadPlank_Snow02.m2", -- [17]
													"VR_RoadPlank_Snow03.m2", -- [18]
													"VR_RoadPlank_Snow04.m2", -- [19]
													"VR_RoadPlank_Snow05.m2", -- [20]
													"VR_RoadPlank_Snow06.m2", -- [21]
													"VR_RoadPlank_Wide_01.m2", -- [22]
													"VR_RoadPlank_Wide_02.m2", -- [23]
													"VR_RoadPlank_Wide_03.m2", -- [24]
													"VR_RoadPlank_Wide_04.m2", -- [25]
													"VR_RoadPlank_Wide_Snow01.m2", -- [26]
													"VR_RoadPlank_Wide_Snow02.m2", -- [27]
													"VR_RoadPlank_Wide_Snow03.m2", -- [28]
													"VR_RoadPlank_Wide_Snow04.m2", -- [29]
												},
												["N"] = "Road",
											}, -- [31]
											{
												["T"] = {
													"VR_Rubble_01.m2", -- [1]
													"VR_Rubble_02.m2", -- [2]
													"VR_Rubble_03.m2", -- [3]
												},
												["N"] = "Rubble",
											}, -- [32]
											{
												["T"] = {
													"VR_Rug_Large_01.m2", -- [1]
													"VR_Rug_Long_01.m2", -- [2]
													"VR_Rug_Small_01.m2", -- [3]
												},
												["N"] = "Rug",
											}, -- [33]
											{
												["T"] = {
													"SeaVrykul_Dead_Seaweed.m2", -- [1]
												},
												["N"] = "Seavrykul_dead",
											}, -- [34]
											{
												["T"] = {
													"VR_CrestShield_01.m2", -- [1]
													"VR_CrestShield_02.m2", -- [2]
													"VR_CrestShield_03.m2", -- [3]
													"VR_Crest_01.m2", -- [4]
													"VR_Crest_02.m2", -- [5]
													"VR_Crest_03.m2", -- [6]
													"VR_Shield_01.m2", -- [7]
													"VR_Shield_02.m2", -- [8]
													"VR_Shield_03.m2", -- [9]
												},
												["N"] = "Shield",
											}, -- [35]
											{
												["T"] = {
													"VR_SignPost_01.M2", -- [1]
													"VR_SignPost_Sign_01.m2", -- [2]
													"VR_SignPost_Snow01.M2", -- [3]
												},
												["N"] = "Signs",
											}, -- [36]
											{
												["T"] = {
													"Valgarde_Skulls.m2", -- [1]
													"Valgarde_Skulls02.m2", -- [2]
												},
												["N"] = "Skulls",
											}, -- [37]
											{
												["T"] = {
													"VR_UtgardePinnacleSnow_01.m2", -- [1]
												},
												["N"] = "Snow",
											}, -- [38]
											{
												["T"] = {
													"VR_BM_Spike_01.m2", -- [1]
												},
												["N"] = "Spike",
											}, -- [39]
											{
												["T"] = {
													"VR_Destroyed_Table_01.m2", -- [1]
													"VR_MapTable_01.m2", -- [2]
													"VR_MapTable_02.m2", -- [3]
													"VR_Table_Large_01.m2", -- [4]
													"VR_Table_Medium_01.m2", -- [5]
													"VR_Table_Small_01.m2", -- [6]
													"VR_Table_Small_02.m2", -- [7]
												},
												["N"] = "Table",
											}, -- [40]
											{
												["T"] = {
													"VR_Tent_01.m2", -- [1]
												},
												["N"] = "Tent",
											}, -- [41]
											{
												["T"] = {
													"VR_Torch_01.M2", -- [1]
													"VR_Torch_01_Blue.M2", -- [2]
													"VR_Torch_Broken_01.m2", -- [3]
													"VR_Torch_Broken_Snow01.m2", -- [4]
													"VR_Torch_Snow01.M2", -- [5]
												},
												["N"] = "Torch",
											}, -- [42]
											{
												["T"] = {
													"VR_Trough.m2", -- [1]
												},
												["N"] = "Trough",
											}, -- [43]
											{
												["T"] = {
													"VR_Wagon_01.m2", -- [1]
													"VR_Wagon_Snow_01.m2", -- [2]
												},
												["N"] = "Wagon",
											}, -- [44]
											{
												["T"] = {
													"VR_WallArch.m2", -- [1]
													"VR_WallArch_Snow.m2", -- [2]
												},
												["N"] = "Wallarch",
											}, -- [45]
											{
												["T"] = {
													"VR_BM_ Shield_01.m2", -- [1]
													"VR_BM_ Shield_02.m2", -- [2]
													"VR_BM_ Sword_01.m2", -- [3]
													"VR_BM_ Sword_02.m2", -- [4]
													"VR_BM_ Sword_03.m2", -- [5]
													"VR_CrestAxe_01.m2", -- [6]
													"VR_CrestAxe_02.m2", -- [7]
													"VR_CrestSword_01.m2", -- [8]
												},
												["N"] = "Weapons",
											}, -- [46]
										},
										["N"] = "Vrykul",
									}, -- [33]
									{
										["T"] = {
											"NorthrendFrozenWaterfall_Short.m2", -- [1]
											"NorthrendFrozenWaterfall_StormPeaks.m2", -- [2]
											"NorthrendFrozenWaterfall_Tall.m2", -- [3]
											"NorthrendFrozenWaterfall_Wide.m2", -- [4]
											"WaterFalls_Set1_High.M2", -- [5]
											"WaterFalls_Set1_High_Hat.m2", -- [6]
											"WaterFalls_Set1_High_Ripples.M2", -- [7]
											"WaterFalls_Set1_Low.M2", -- [8]
											"WaterFalls_Set1_Low_Hat.m2", -- [9]
											"WaterFalls_Set1_Low_Ripples.m2", -- [10]
											"WaterFalls_Set1_Med.M2", -- [11]
											"WaterFalls_Set1_Med_Hat.m2", -- [12]
											"WaterFalls_Set1_Med_Ripples.m2", -- [13]
											"WaterFalls_Set2_High_Hat.m2", -- [14]
											"WaterFalls_Set2_High_Hat_Flat.M2", -- [15]
											"WaterFalls_Set2_Med.m2", -- [16]
											"WaterFalls_Set2_Med_Chop.m2", -- [17]
											"WaterFalls_Set2_Med_DoubleWide.m2", -- [18]
											"WaterFalls_Set2_Med_DoubleWide_Short.m2", -- [19]
											"WaterFalls_Set2_Med_DoubleWide_withChop.m2", -- [20]
											"WaterFalls_Set2_Med_Short.m2", -- [21]
											"WaterFalls_Set2_Med_Tall.m2", -- [22]
											"WaterFalls_Set2_Med_Tall_withChop.m2", -- [23]
											"WaterFalls_Set2_Med_Top.m2", -- [24]
											"WaterFalls_Set2_Med_withChop.m2", -- [25]
											"WaterFalls_Set2_Rapids_Divided.m2", -- [26]
											"WaterFalls_Set2_Rapids_Long.m2", -- [27]
											"WaterFalls_Set2_Rapids_Short.m2", -- [28]
											"WaterFalls_Set2_Wide.m2", -- [29]
											"WaterFalls_Set2_Wide_Chop.m2", -- [30]
											"WaterFalls_Set2_Wide_Short.m2", -- [31]
											"WaterFalls_Set2_Wide_Tall.m2", -- [32]
											"WaterFalls_Set2_Wide_Tall_Chop.m2", -- [33]
										},
										["N"] = "Waterfalls",
									}, -- [34]
									{
										["T"] = {
											"Orc_Fortress_Elevator01.m2", -- [1]
											"Orc_Ship_Broken_Front_01.m2", -- [2]
											"Orc_Ship_Broken_Ropes_01.m2", -- [3]
											"Orc_Ship_Broken_Sail_01.M2", -- [4]
											"WOrc_Barricade.M2", -- [5]
											"WOrc_ExcavationCrane.m2", -- [6]
											"WOrc_MineMachine.m2", -- [7]
										},
										["N"] = "Winterorc",
									}, -- [35]
									{
										["T"] = {
											"Wolvar_Anvil.m2", -- [1]
											"Wolvar_Anvil_DragonBlight.m2", -- [2]
											"Wolvar_Cage01.m2", -- [3]
											"Wolvar_Cage01_DragonBlight.m2", -- [4]
											"Wolvar_Coals01.m2", -- [5]
											"Wolvar_Coals02.m2", -- [6]
											"Wolvar_CookPot.m2", -- [7]
											"Wolvar_CookPot_DragonBlight.m2", -- [8]
											"Wolvar_Forge.m2", -- [9]
											"Wolvar_God_Bot.m2", -- [10]
											"Wolvar_God_ProtoDragon.m2", -- [11]
											"Wolvar_God_ShovelTusk.m2", -- [12]
											"Wolvar_God_Yeti.m2", -- [13]
											"Wolvar_Quench.m2", -- [14]
											"Wolvar_Quench_DragonBlight.m2", -- [15]
											"Wolvar_Spikes01.m2", -- [16]
											"Wolvar_Spikes02.m2", -- [17]
											"Wolvar_Spikes03.m2", -- [18]
											"Wolvar_Totem01.m2", -- [19]
											"Wolvar_Totem01_DragonBlight.m2", -- [20]
											"Wolvar_Totem02.m2", -- [21]
											"Wolvar_Totem02_DragonBlight.m2", -- [22]
											"Wolvar_Totem03.m2", -- [23]
											"Wolvar_Totem03_DragonBlight.m2", -- [24]
											"Wolvar_doorway01.m2", -- [25]
											"Wolvar_doorway01_Sholazar.m2", -- [26]
											"Wolvar_doorway01_Snowy.m2", -- [27]
											"Wolvar_hut01.m2", -- [28]
											"Wolvar_hut01_Sholazar.m2", -- [29]
											"Wolvar_hut01_Snowy.m2", -- [30]
											"Wolvar_hut02.m2", -- [31]
											"Wolvar_hut02_Sholazar.m2", -- [32]
											"Wolvar_hut02_Snowy.m2", -- [33]
											"Wolvar_hut03.m2", -- [34]
											"Wolvar_hut03_Sholazar.m2", -- [35]
											"Wolvar_window01.m2", -- [36]
											"Wolvar_window01_Sholazar.M2", -- [37]
											"Wolvar_window01_Snowy.M2", -- [38]
											"Wolvar_window02.m2", -- [39]
											"Wolvar_window02_Sholazar.M2", -- [40]
											"Wolvar_window02_Snowy.M2", -- [41]
										},
										["N"] = "Wolvar",
									}, -- [36]
									{
										["T"] = {
											"CrashedZeppelinPiece_03.M2", -- [1]
											"CrashedZeppelinPiece_04.m2", -- [2]
										},
										["N"] = "Zeppelin",
									}, -- [37]
									"Alliance_Tabard.m2", -- [38]
									"Dalaran_Tabard.m2", -- [39]
									"Horde_Gunship_DeckFlakGun.m2", -- [40]
									"Horde_Gunship_DeckFlakGun_Base.M2", -- [41]
									"Horde_Tabard.m2", -- [42]
									"Leather_Chest_Armor_01.m2", -- [43]
									"Mail_Chest_Armor_01.m2", -- [44]
									"Northrend_Armor_01.m2", -- [45]
									"Northrend_Armor_02.m2", -- [46]
									"Northrend_Helm_01.m2", -- [47]
									"Northrend_Helm_02.m2", -- [48]
									"Northrend_Helm_03.m2", -- [49]
									"Northrend_Helm_04.m2", -- [50]
									"Northrend_Helm_05.M2", -- [51]
									"Northrend_Helm_06.m2", -- [52]
									"Northrend_Helm_07.m2", -- [53]
									"Northrend_Helm_08.m2", -- [54]
									"Northrend_Helm_09.m2", -- [55]
									"Northrend_Shoulder_01.m2", -- [56]
									"Northrend_Shoulder_02.m2", -- [57]
									"Northrend_Shoulder_03.m2", -- [58]
									"Northrend_Shoulder_04.m2", -- [59]
									"Northrend_Shoulder_05.m2", -- [60]
									"Sandbag_Wall_01.M2", -- [61]
								},
								["N"] = "Generic",
							}, -- [11]
							{
								["T"] = {
									{
										["T"] = {
											"Grizzly_BearShrine_Snow.m2", -- [1]
											"Grizzly_FurbolgBearShrine.m2", -- [2]
										},
										["N"] = "Bearshrine",
									}, -- [1]
									{
										["T"] = {
											"GrizzlyHills_FurbolgRoad_01.m2", -- [1]
											"GrizzlyHills_FurbolgRoad_02.m2", -- [2]
											"GrizzlyHills_FurbolgRoad_03.m2", -- [3]
											"GrizzlyHills_FurbolgRoad_Snow_01.m2", -- [4]
											"GrizzlyHills_FurbolgRoad_Snow_02.m2", -- [5]
											"GrizzlyHills_FurbolgRoad_Snow_03.m2", -- [6]
											"GrizzlyHills_RoadLog01.m2", -- [7]
										},
										["N"] = "Roadlogs",
									}, -- [2]
									{
										["T"] = {
											"GrizzlyHills_Boulder01.m2", -- [1]
											"GrizzlyHills_Rock_01.m2", -- [2]
											"GrizzlyHills_Rock_02.m2", -- [3]
											"GrizzlyHills_Rock_03.m2", -- [4]
											"GrizzlyHills_Rock_04.m2", -- [5]
											"GrizzlyHills_Rock_Large_01.m2", -- [6]
											"GrizzlyHills_Rock_Large_02.m2", -- [7]
										},
										["N"] = "Rocks",
									}, -- [3]
									{
										["T"] = {
											"GrizzlemawTermiteChunk01.m2", -- [1]
											"GrizzlemawTermiteChunk02.m2", -- [2]
											"GrizzlemawTermiteChunk03.m2", -- [3]
											"GrizzlyHills_Termite_Tree.m2", -- [4]
											"TermiteDust.m2", -- [5]
											"Termite_Rock01.m2", -- [6]
											"Termite_Rock02.m2", -- [7]
											"Termite_Shaft.m2", -- [8]
										},
										["N"] = "Termites",
									}, -- [4]
									{
										["T"] = {
											"GH_trapperdraping.m2", -- [1]
											"TrapperFence_01.m2", -- [2]
											"TrapperFence_02.m2", -- [3]
											"TrapperFence_03.m2", -- [4]
											"TrapperFence_Large01.m2", -- [5]
											"TrapperFence_Large03.m2", -- [6]
											"TrapperLamppost_01.M2", -- [7]
											"TrapperLamppost_01_Unlit.m2", -- [8]
											"TrapperSignpost.M2", -- [9]
											"TrapperSignpost_Sign.m2", -- [10]
											"Trapper_Potbellystove_01.m2", -- [11]
											"Trapper_Snowshoe_01.m2", -- [12]
											"Trapper_Wall01.m2", -- [13]
											"Trapper_Wall02.m2", -- [14]
											"Trapper_Wall03.m2", -- [15]
											"Trapper_Wall04.m2", -- [16]
											"Trapper_Wall05.m2", -- [17]
										},
										["N"] = "Trappers",
									}, -- [5]
									{
										["T"] = {
											"GH_bridgelightbeams.m2", -- [1]
											"GrizzlyHillsHUGE_Tree.m2", -- [2]
											"GrizzlyHills_Blurpleflower01.m2", -- [3]
											"GrizzlyHills_Blurpleflower02.m2", -- [4]
											"GrizzlyHills_Bush01.m2", -- [5]
											"GrizzlyHills_Bush02.m2", -- [6]
											"GrizzlyHills_Bush03.m2", -- [7]
											"GrizzlyHills_Bush04.m2", -- [8]
											"GrizzlyHills_Bush06.m2", -- [9]
											"GrizzlyHills_Clovers01.m2", -- [10]
											"GrizzlyHills_Clovers02.m2", -- [11]
											"GrizzlyHills_Clovers03.m2", -- [12]
											"GrizzlyHills_GoldShrubs01.m2", -- [13]
											"GrizzlyHills_Greenflower01.m2", -- [14]
											"GrizzlyHills_Greenflower02.m2", -- [15]
											"GrizzlyHills_Log01.m2", -- [16]
											"GrizzlyHills_Log02.m2", -- [17]
											"GrizzlyHills_Log03.m2", -- [18]
											"GrizzlyHills_Log04.m2", -- [19]
											"GrizzlyHills_Log05.m2", -- [20]
											"GrizzlyHills_Mushroom01.m2", -- [21]
											"GrizzlyHills_Mushroom02.m2", -- [22]
											"GrizzlyHills_Mushroom03.m2", -- [23]
											"GrizzlyHills_MushroomGroup01.m2", -- [24]
											"GrizzlyHills_MushroomGroup02.m2", -- [25]
											"GrizzlyHills_MushroomGroup03.m2", -- [26]
											"GrizzlyHills_Redishflower01.m2", -- [27]
											"GrizzlyHills_Redishflower02.m2", -- [28]
											"GrizzlyHills_Root01.m2", -- [29]
											"GrizzlyHills_Root02.m2", -- [30]
											"GrizzlyHills_Root03.m2", -- [31]
											"GrizzlyHills_Root04.m2", -- [32]
											"GrizzlyHills_RopeTree01.m2", -- [33]
											"GrizzlyHills_Sapling.m2", -- [34]
											"GrizzlyHills_Shrubs01.m2", -- [35]
											"GrizzlyHills_Shrubs02.m2", -- [36]
											"GrizzlyHills_Shrubs03.m2", -- [37]
											"GrizzlyHills_Tree01.m2", -- [38]
											"GrizzlyHills_Tree02.m2", -- [39]
											"GrizzlyHills_Tree03.m2", -- [40]
											"GrizzlyHills_Tree04.m2", -- [41]
											"GrizzlyHills_Tree05.m2", -- [42]
											"GrizzlyHills_Tree06.m2", -- [43]
											"GrizzlyHills_Tree07.m2", -- [44]
											"GrizzlyHills_Tree08.m2", -- [45]
											"GrizzlyHills_Tree09.m2", -- [46]
											"GrizzlyHills_Tree10.m2", -- [47]
											"GrizzlyHills_Tree11.m2", -- [48]
											"GrizzlyHills_Tree12.m2", -- [49]
											"GrizzlyHills_TreeTrunk01.m2", -- [50]
											"GrizzlyHills_TreeTrunk02.m2", -- [51]
											"GrizzlyHills_TreeTrunk03.m2", -- [52]
											"GrizzlyHills_TreeTrunk04.m2", -- [53]
											"GrizzlyHills_TreeTrunk05.m2", -- [54]
											"GrizzlyHills_TreeTrunk06.m2", -- [55]
											"GrizzlyHills_TunnelBridge01.m2", -- [56]
											"GrizzlyHills_TunnelTree.m2", -- [57]
											"GrizzlyHills_Yellowflower01.m2", -- [58]
											"GrizzlyHills_Yellowflower02.m2", -- [59]
											"Grizzly_AmberPineTree.m2", -- [60]
											"grizzlyhills_mushroom03_chair.M2", -- [61]
										},
										["N"] = "Trees",
									}, -- [6]
									{
										["T"] = {
											"GrizzlyHillsLogMachine01.m2", -- [1]
											"LogRun_Gate.m2", -- [2]
											"LogRun_Pump01.m2", -- [3]
											"LogRun_Pump02.m2", -- [4]
											"LogRun_PumpElevator01.m2", -- [5]
											"LogRun_PumpElevator02.m2", -- [6]
											"LogRun_PumpElevator03.m2", -- [7]
											"ND_Grizzly_LogRuns_Water01.m2", -- [8]
											"ND_Grizzly_LogRuns_Water02.m2", -- [9]
										},
										["N"] = "Ventureco",
									}, -- [7]
								},
								["N"] = "Grizzlyhills",
							}, -- [12]
							{
								["T"] = {
									{
										["T"] = {
											"TempVrykulBridge.m2", -- [1]
										},
										["N"] = "Bridges",
									}, -- [1]
									{
										["T"] = {
											"HFjord_CoastCliffWaterfall_01.M2", -- [1]
											"HFjord_CoastCliffWaterfall_02.M2", -- [2]
											"HFjord_CoastCliffWaterfall_03.M2", -- [3]
										},
										["N"] = "Coastcliff",
									}, -- [2]
									{
										["T"] = {
											"BurntGround01.M2", -- [1]
											"BurntStoneTree01_VFX.m2", -- [2]
											"BurntStoneTree01_VFX2.m2", -- [3]
											"BurntStoneTree07_VFX.m2", -- [4]
											"BurntStoneTree08_VFX.m2", -- [5]
											"BurntStoneTreeFireFlies_VFX.m2", -- [6]
											"BurntStoneTreeSmoke_VFX.M2", -- [7]
										},
										["N"] = "Firefx",
									}, -- [3]
									{
										["T"] = {
											"HFjord_Fog_01.m2", -- [1]
											"HFjord_Fog_02.M2", -- [2]
											"HFjord_Fog_03.m2", -- [3]
											"HFjord_Fog_04.M2", -- [4]
											"HFjord_Fog_05.M2", -- [5]
										},
										["N"] = "Fog",
									}, -- [4]
									{
										["T"] = {
											"Apothecary_FX.M2", -- [1]
										},
										["N"] = "Forsaken",
									}, -- [5]
									{
										["T"] = {
											"HF_WaterFall_Cap_01.m2", -- [1]
											"HFjord_CoastRock_01.m2", -- [2]
											"HFjord_CoastRock_02.m2", -- [3]
											"HFjord_CoastRock_03.m2", -- [4]
											"HFjord_CoastRock_04.m2", -- [5]
											"HFjord_CoastRock_05.m2", -- [6]
											"HFjord_ForestRock_01.m2", -- [7]
											"HFjord_ForestRock_02.m2", -- [8]
											"HFjord_ForestRock_03.m2", -- [9]
											"HFjord_ForestRock_04.m2", -- [10]
											"HFjord_ForestRock_05.m2", -- [11]
											"HFjord_ForestRock_Cluster_01.m2", -- [12]
										},
										["N"] = "Rocks",
									}, -- [6]
									{
										["T"] = {
											"TitanHead_waterfall.m2", -- [1]
										},
										["N"] = "Titanstatues",
									}, -- [7]
									"HF_Elevator_Gate.M2", -- [8]
									"HF_Elevator_Lift.m2", -- [9]
									"HF_Elevator_Lift_02.M2", -- [10]
									"HFjord_Bush_01.m2", -- [11]
									"HFjord_Bush_02.m2", -- [12]
									"HFjord_Bush_03.m2", -- [13]
									"HFjord_Bush_04.m2", -- [14]
									"HFjord_Bush_05.m2", -- [15]
									"HFjord_Bush_SNOW_04.m2", -- [16]
									"HFjord_CanyonTreeStump_01.m2", -- [17]
									"HFjord_CanyonTreeStump_02.m2", -- [18]
									"HFjord_CanyonTree_01.m2", -- [19]
									"HFjord_CanyonTree_02.m2", -- [20]
									"HFjord_CanyonTree_03.m2", -- [21]
									"HFjord_CoastBush_01.m2", -- [22]
									"HFjord_CoastBush_02.m2", -- [23]
									"HFjord_DryadShrine01.m2", -- [24]
									"HFjord_DryadShrine02.m2", -- [25]
									"HFjord_Roots_01.m2", -- [26]
									"HFjord_Roots_02.m2", -- [27]
									"HFjord_Roots_03.m2", -- [28]
									"HFjord_TreeFallen_01.m2", -- [29]
									"HFjord_TreeStump_01.m2", -- [30]
									"HFjord_Tree_01.m2", -- [31]
									"HFjord_Tree_01_Lowpoly.m2", -- [32]
									"HFjord_Tree_02.m2", -- [33]
									"HFjord_Tree_02_Lowpoly.m2", -- [34]
									"HFjord_Tree_03.m2", -- [35]
									"HFjord_Tree_03_Lowpoly.m2", -- [36]
									"HFjord_Tree_04.m2", -- [37]
									"HFjord_Tree_04_Lowpoly.m2", -- [38]
									"HFjord_Tree_05.m2", -- [39]
									"HFjord_Tree_06.m2", -- [40]
									"HFjord_Tree_Mid_01.m2", -- [41]
									"HFjord_Tree_Mid_02.m2", -- [42]
									"HFjord_Tree_Mid_03.m2", -- [43]
									"HFjord_Tree_Mid_04.m2", -- [44]
									"HFjord_Tree_Mid_04_Lowpoly.m2", -- [45]
									"HFjord_Tree_Mid_05.m2", -- [46]
									"HFjord_Tree_Mid_06.m2", -- [47]
									"HFjord_Tree_Mid_07.m2", -- [48]
									"HFjord_Tree_SNOW_01.m2", -- [49]
									"HFjord_Tree_SNOW_05.m2", -- [50]
								},
								["N"] = "Howlingfjord",
							}, -- [13]
							{
								["T"] = {
									{
										["T"] = {
											"AGS_Bomb.m2", -- [1]
											"AGS_BombHolder.m2", -- [2]
											"AGS_BrassCannon.m2", -- [3]
											"AGS_Engines.m2", -- [4]
											"AGS_Engines_BG.M2", -- [5]
											"AGS_Engines_destroy1.M2", -- [6]
											"AGS_Engines_destroy2.M2", -- [7]
											"AGS_Engines_destroy3.M2", -- [8]
											"AGS_Engines_destroy4.M2", -- [9]
											"AGS_Engines_destroy5.M2", -- [10]
											"AGS_Engines_destroy6.M2", -- [11]
											"AGS_Engines_destroy7.M2", -- [12]
											"AGS_HazardLight_Yellow.M2", -- [13]
											"BrassCannon.M2", -- [14]
										},
										["N"] = "Alliance_gunship",
									}, -- [1]
									{
										["T"] = {
											"IceCrown_Frostmourne_Altar.m2", -- [1]
										},
										["N"] = "Altar",
									}, -- [2]
									{
										["T"] = {
											"IceCrown_BloodPrince_Banner_02.m2", -- [1]
											"IceCrown_BloodPrince_BloodOrb.m2", -- [2]
											"IceCrown_BloodPrince_Crest.m2", -- [3]
											"IceCrown_BloodPrince_RoofFog.m2", -- [4]
											"Icecrown_BloodChandelier_01.M2", -- [5]
											"Icecrown_BloodPrince_Banner.m2", -- [6]
										},
										["N"] = "Bloodprince",
									}, -- [3]
									{
										["T"] = {
											"Icecrown_Bodyjar.m2", -- [1]
										},
										["N"] = "Bodyjar",
									}, -- [4]
									{
										["T"] = {
											"IceCrown_Bonepile_01.M2", -- [1]
											"IceCrown_Bonepile_02.m2", -- [2]
											"IceCrown_Bonepile_Light_01.m2", -- [3]
											"IceCrown_Bonepile_Light_02.M2", -- [4]
											"IceCrown_Bonepile_Skull.m2", -- [5]
											"IceCrown_Bonepile_Skull_Light.M2", -- [6]
										},
										["N"] = "Bones",
									}, -- [5]
									{
										["T"] = {
											"IceCrown_Cavein.M2", -- [1]
										},
										["N"] = "Cavein",
									}, -- [6]
									{
										["T"] = {
											"IceCrown_FrostmourneSkyChains.m2", -- [1]
											"IceCrown_FrostmourneSkyChains_02.m2", -- [2]
											"Icecrown_FrostmourneGhosts.m2", -- [3]
										},
										["N"] = "Chains",
									}, -- [7]
									{
										["T"] = {
											"IceCrown_Bench_01.m2", -- [1]
											"IceCrown_Chair_01.m2", -- [2]
										},
										["N"] = "Chairs",
									}, -- [8]
									{
										["T"] = {
											"IC_Citadel_door01.m2", -- [1]
											"IC_Citadel_mouthDoor01.m2", -- [2]
											"IceCrown_BloodDoor_01.M2", -- [3]
											"IceCrown_BloodPrince_Door_01.M2", -- [4]
											"IceCrown_ColdDoor_01.M2", -- [5]
											"IceCrown_Door_01.m2", -- [6]
											"IceCrown_Door_02Collision.m2", -- [7]
											"IceCrown_Door_02Left.m2", -- [8]
											"IceCrown_Door_02Right.m2", -- [9]
											"IceCrown_Door_02_Disappearing_Green.m2", -- [10]
											"IceCrown_Door_02_Disappearing_Orange.m2", -- [11]
											"IceCrown_Door_02_Main.m2", -- [12]
											"IceCrown_Door_03.M2", -- [13]
											"IceCrown_Door_04.m2", -- [14]
											"IceCrown_Grate_01.M2", -- [15]
											"IceCrown_Portcullis_01.m2", -- [16]
											"IceCrown_Portcullis_02.m2", -- [17]
											"IceCrown_RoostPortcullis_01.m2", -- [18]
										},
										["N"] = "Doors",
									}, -- [9]
									{
										["T"] = {
											"IceCrownRaid_IceCore_precipice.m2", -- [1]
											"IceCrown_Citadel_ExteriorEffects.m2", -- [2]
											"Icecrown_FrozenThrone_Particle.m2", -- [3]
											"Icecrown_Icecore.m2", -- [4]
											"Icecrown_ThroneFrostyEdge.m2", -- [5]
										},
										["N"] = "Effects",
									}, -- [10]
									{
										["T"] = {
											"icecrown_elevator.m2", -- [1]
											"icecrown_elevator02.m2", -- [2]
										},
										["N"] = "Elevator",
									}, -- [11]
									{
										["T"] = {
											"Icecrown_Fence.m2", -- [1]
											"Icecrown_Fence_base.m2", -- [2]
										},
										["N"] = "Fence",
									}, -- [12]
									{
										["T"] = {
											"IceCrown_FrozenWurm_01.m2", -- [1]
										},
										["N"] = "Frozen",
									}, -- [13]
									{
										["T"] = {
											"IceCrownGateFog01.M2", -- [1]
											"IceCrownGateFog02.m2", -- [2]
											"IceCrown_WallAnim.m2", -- [3]
										},
										["N"] = "Gatefog",
									}, -- [14]
									{
										["T"] = {
											"ic_glow01.M2", -- [1]
											"ic_glow02.M2", -- [2]
										},
										["N"] = "Glows",
									}, -- [15]
									{
										["T"] = {
											"Icecrown_Grinder.m2", -- [1]
										},
										["N"] = "Grinder",
									}, -- [16]
									{
										["T"] = {
											"Icecrown_groundSpikes01.m2", -- [1]
										},
										["N"] = "Groundspikes",
									}, -- [17]
									{
										["T"] = {
											"Icecrown_Icecore_Middle.m2", -- [1]
										},
										["N"] = "Icecore",
									}, -- [18]
									{
										["T"] = {
											"IceShardA.m2", -- [1]
											"IceShard_standing.m2", -- [2]
										},
										["N"] = "Iceshards",
									}, -- [19]
									{
										["T"] = {
											"IceCrown_Icewall.m2", -- [1]
											"IceCrown_Icewall_V2.M2", -- [2]
										},
										["N"] = "Icewall",
									}, -- [20]
									{
										["T"] = {
											"IceCrown_BossFacade.m2", -- [1]
											"IceCrown_BossFacade_02.m2", -- [2]
											"IceCrown_BossTubes.m2", -- [3]
											"IceCrown_ChemistrySet_02.M2", -- [4]
											"IceCrown_GreenBall.m2", -- [5]
											"IceCrown_LabBottle_01.m2", -- [6]
											"IceCrown_LabBottle_02.m2", -- [7]
											"IceCrown_LabBottle_03.m2", -- [8]
											"IceCrown_LabTable_02.M2", -- [9]
											"IceCrown_LabTable_03.m2", -- [10]
											"IceCrown_LabTable_03_Potions.m2", -- [11]
											"IceCrown_OrangeBall.m2", -- [12]
											"IceCrown_TeslaCoil_BAsic.m2", -- [13]
											"IceCrown_TeslaCoil_Green.m2", -- [14]
											"IceCrown_TeslaCoil_Orange.m2", -- [15]
											"IceCrown_TeslaCoil_Orange_NewSound.M2", -- [16]
											"Icecrown_ChemistrySet_03.m2", -- [17]
											"IcrCrown_ChemistrySet_01.m2", -- [18]
											"IcrCrown_ChemistrySet_04.m2", -- [19]
											"icecrown_deathknight_shield.m2", -- [20]
										},
										["N"] = "Lab Items",
									}, -- [21]
									{
										["T"] = {
											"Icecrown_Lavaman_Chained.m2", -- [1]
											"Icecrown_Lavaman_UnChained.m2", -- [2]
											"Icecrown_Lavaman_sit.m2", -- [3]
										},
										["N"] = "Lava",
									}, -- [22]
									{
										["T"] = {
											"IceCrown_Lever.m2", -- [1]
										},
										["N"] = "Lever",
									}, -- [23]
									{
										["T"] = {
											"IceCrown_BlueGlow_01.m2", -- [1]
											"IceCrown_BlueGlow_02.m2", -- [2]
											"IceCrown_GreenGlow_01.m2", -- [3]
											"IceCrown_HangingBase.m2", -- [4]
											"IceCrown_HangingBraizer_01.m2", -- [5]
											"IceCrown_RedGlow_01.m2", -- [6]
											"Icecrown_Chandelier.m2", -- [7]
											"Icecrown_LabLamp.m2", -- [8]
											"Icecrown_Rays.m2", -- [9]
											"Icecrown_WallSconce_01.m2", -- [10]
											"icecrown_blue_Fire.M2", -- [11]
											"icecrown_green_Fire.m2", -- [12]
											"icecrown_greenpillar_Fire.m2", -- [13]
										},
										["N"] = "Lights",
									}, -- [24]
									{
										["T"] = {
											"Icecrown_MetalSkull.M2", -- [1]
										},
										["N"] = "Metalskull",
									}, -- [25]
									{
										["T"] = {
											"IceCrown_BloodPrince_Portal_Effect.m2", -- [1]
											"IceCrown_BloodPrince_Portal_Floor.M2", -- [2]
											"IceCrown_BloodPrince_Portal_Left.M2", -- [3]
											"IceCrown_BloodPrince_Portal_Middle.m2", -- [4]
											"IceCrown_BloodPrince_Portal_Right.m2", -- [5]
											"icecrown_Portal.m2", -- [6]
										},
										["N"] = "Portals",
									}, -- [26]
									{
										["T"] = {
											"IceCrown_PressurePlate.m2", -- [1]
										},
										["N"] = "Pressureplate",
									}, -- [27]
									{
										["T"] = {
											"Icecrown_Railing01.m2", -- [1]
											"Icecrown_Railing02.m2", -- [2]
											"Icecrown_Railing_Rail.m2", -- [3]
										},
										["N"] = "Railing",
									}, -- [28]
									{
										["T"] = {
											"IceCrown_Rock_01.m2", -- [1]
											"IceCrown_Rock_02.m2", -- [2]
											"IceCrown_Rock_03.m2", -- [3]
											"IceCrown_Rock_04.m2", -- [4]
											"IceCrown_Rock_05.m2", -- [5]
											"IceCrown_Rock_06.m2", -- [6]
										},
										["N"] = "Rocks",
									}, -- [29]
									{
										["T"] = {
											"Icecrown_Rug_Long_01.m2", -- [1]
											"Icecrown_Rug_Long_02.m2", -- [2]
										},
										["N"] = "Rugs",
									}, -- [30]
									{
										["T"] = {
											"IceCrown_RuneForge_Green.m2", -- [1]
											"IceCrown_RuneForge_Orange.M2", -- [2]
										},
										["N"] = "Runeforge",
									}, -- [31]
									{
										["T"] = {
											"IceCrown_PrecipiceRunes_01.M2", -- [1]
										},
										["N"] = "Runes",
									}, -- [32]
									{
										["T"] = {
											"Sindragosa_Iceblock_Collision.m2", -- [1]
										},
										["N"] = "Sindragosacollision",
									}, -- [33]
									{
										["T"] = {
											"Icecrown_SnowEdgeWarning.m2", -- [1]
										},
										["N"] = "Snowledge",
									}, -- [34]
									{
										["T"] = {
											"IceCrown_Spigot.m2", -- [1]
										},
										["N"] = "Spigot",
									}, -- [35]
									{
										["T"] = {
											"IceCrown_Tentacles_01.M2", -- [1]
										},
										["N"] = "Tentacles",
									}, -- [36]
									{
										["T"] = {
											"IceCrown_Throne.M2", -- [1]
											"Icecrown_ThroneFrostyWind.m2", -- [2]
											"Icecrown_throne_exteriorspires.M2", -- [3]
										},
										["N"] = "Throne",
									}, -- [37]
									{
										["T"] = {
											"IceCrown_Tree_01.m2", -- [1]
											"IceCrown_Tree_02.m2", -- [2]
											"IceCrown_Tree_03.m2", -- [3]
											"IceCrown_Tree_04.m2", -- [4]
										},
										["N"] = "Trees",
									}, -- [38]
									{
										["T"] = {
											"IceCrown_GreenTubes.m2", -- [1]
											"IceCrown_GreenTubes_Grate.m2", -- [2]
											"IceCrown_OrangeTubes.m2", -- [3]
										},
										["N"] = "Tubes",
									}, -- [39]
									{
										["T"] = {
											"IceCrown_Valve.m2", -- [1]
										},
										["N"] = "Valve",
									}, -- [40]
									{
										["T"] = {
											"IceCrown_Axe_ShadowsEdge.m2", -- [1]
										},
										["N"] = "Weapon",
									}, -- [41]
									{
										["T"] = {
											"wingsigil_blue.m2", -- [1]
											"wingsigil_green.m2", -- [2]
											"wingsigil_red.m2", -- [3]
										},
										["N"] = "Wingsigils",
									}, -- [42]
									"IC_Citadel_Chest.m2", -- [43]
									"IC_arthas_iceshard01.m2", -- [44]
									"IC_arthas_iceshard02.m2", -- [45]
									"IC_arthas_iceshard03.m2", -- [46]
									"IC_arthas_iceshard04.m2", -- [47]
									"IC_arthas_iceshard05.m2", -- [48]
									"IC_arthas_iceshard06.m2", -- [49]
									"IC_arthas_iceshard07.m2", -- [50]
								},
								["N"] = "Icecrown",
							}, -- [14]
							{
								["T"] = {
									"IsleofConcquest_Alliance_Banner_01.m2", -- [1]
									"IsleofConcquest_Horde_Banner_01.m2", -- [2]
									"IsleofConquest_Portal_Niche_Alliance_01.M2", -- [3]
									"IsleofConquest_Portal_Niche_Horde_01.M2", -- [4]
								},
								["N"] = "Isleofconquest",
							}, -- [15]
							{
								["T"] = {
									{
										["T"] = {
											"Wintergrasp_Bush_01.m2", -- [1]
											"Wintergrasp_Bush_02.m2", -- [2]
											"Wintergrasp_Bush_03.m2", -- [3]
											"Wintergrasp_Bush_04.m2", -- [4]
										},
										["N"] = "Bushes",
									}, -- [1]
									{
										["T"] = {
											"Wintergrasp_KeepCurb01.m2", -- [1]
											"Wintergrasp_KeepCurb02.m2", -- [2]
											"Wintergrasp_KeepCurb03.m2", -- [3]
										},
										["N"] = "Titanpieces",
									}, -- [2]
									{
										["T"] = {
											"Wintergrasp_BrokenTree_01.m2", -- [1]
											"Wintergrasp_BrokenTree_02.m2", -- [2]
											"Wintergrasp_BrokenTree_03.m2", -- [3]
											"Wintergrasp_BrokenTree_04.m2", -- [4]
											"Wintergrasp_Tree_02.m2", -- [5]
											"Wintergrasp_Tree_03.m2", -- [6]
											"Wintergrasp_Tree_04.m2", -- [7]
											"Wintergrasp_Tree_05.m2", -- [8]
											"Wintergrasp_Tree_Scourge_02.m2", -- [9]
											"Wintergrasp_Tree_Scourge_03.m2", -- [10]
											"Wintergrasp_Tree_Scourge_04.m2", -- [11]
											"Wintergrasp_Tree_Scourge_05.m2", -- [12]
										},
										["N"] = "Trees",
									}, -- [3]
									{
										["T"] = {
											"WintergraspWaterfall-01.m2", -- [1]
										},
										["N"] = "Waterfalls",
									}, -- [4]
									"Alliance_Vehicle_Piece_01.m2", -- [5]
									"Alliance_Vehicle_Piece_02.m2", -- [6]
									"Alliance_Vehicle_Piece_03.m2", -- [7]
									"Horde_Vehicle_PIece_01.m2", -- [8]
									"Horde_Vehicle_Piece_02.m2", -- [9]
									"Horde_Vehicle_Piece_03.m2", -- [10]
									"WG_Bridge02_FX1.m2", -- [11]
									"WG_Bridge02_FX2.m2", -- [12]
									"WG_Gate01_FX1.m2", -- [13]
									"WG_Gate01_FX2.M2", -- [14]
									"WG_Invisible_Door.M2", -- [15]
									"WG_Keep_Door01_FX1.m2", -- [16]
									"WG_Keep_Door01_FX2.m2", -- [17]
									"WG_Siege01_FX1.m2", -- [18]
									"WG_Siege01_FX2.M2", -- [19]
									"WG_Siege_Door.m2", -- [20]
									"WG_Tower01_FX1.m2", -- [21]
									"WG_Tower01_FX2.m2", -- [22]
									"WG_Tower01_FX2b.m2", -- [23]
									"WG_Wall01_FX1.m2", -- [24]
									"WG_Wall01_FX2.m2", -- [25]
									"WG_Wall02_FX1.m2", -- [26]
									"WG_Wall02_FX2.m2", -- [27]
								},
								["N"] = "Lakewintergrasp",
							}, -- [16]
							{
								["T"] = {
									"Nexus_Cage_Active_01.m2", -- [1]
									"Nexus_Cage_Active_Door_01.m2", -- [2]
									"Nexus_Crashed_Platform_01.m2", -- [3]
									"Nexus_Crashed_Platform_02.m2", -- [4]
									"Nexus_Crystals_01.M2", -- [5]
									"Nexus_DragonEgg_01.m2", -- [6]
									"Nexus_DragonEgg_02.m2", -- [7]
									"Nexus_DragonOrb_01.M2", -- [8]
									"Nexus_Dragon_Broken_Body.m2", -- [9]
									"Nexus_Dragon_Broken_Head.m2", -- [10]
									"Nexus_Dragon_Broken_LeftWing.m2", -- [11]
									"Nexus_Dragon_Broken_RightArm.m2", -- [12]
									"Nexus_Dragon_Broken_RightWing.m2", -- [13]
									"Nexus_Dragon_Broken_Rubble.m2", -- [14]
									"Nexus_Dragon_Broken_Tail.m2", -- [15]
									"Nexus_Dragon_Broken_TailEnd.m2", -- [16]
									"Nexus_Elevator_BaseStructure_01.m2", -- [17]
									"Nexus_EnergyChains.m2", -- [18]
									"Nexus_EnergyFalls_01.m2", -- [19]
									"Nexus_EnergyTrail_01.M2", -- [20]
									"Nexus_EnergyTrail_02.M2", -- [21]
									"Nexus_FX_exterior_Beam.M2", -- [22]
									"Nexus_Falling_MagicLeaf_01.m2", -- [23]
									"Nexus_Hanging_Energy_Beads_01.m2", -- [24]
									"Nexus_IcicleA.m2", -- [25]
									"Nexus_Library_MainFX.m2", -- [26]
									"Nexus_Library_MainFX_ORIGIN.M2", -- [27]
									"Nexus_Library_PlatformFX.m2", -- [28]
									"Nexus_Library_Trickle_A.m2", -- [29]
									"Nexus_Library_Trickle_B.m2", -- [30]
									"Nexus_Library_Trickle_C.m2", -- [31]
									"Nexus_MagicDrop_Blue_01.m2", -- [32]
									"Nexus_MagicDrop_Blue_02.m2", -- [33]
									"Nexus_MagicDrop_Orange_01.m2", -- [34]
									"Nexus_MagicOrb_Blue_01.M2", -- [35]
									"Nexus_MagicOrb_Orange_01.M2", -- [36]
									"Nexus_ManaNeedlePlatform_Effects_01.M2", -- [37]
									"Nexus_PillarA.m2", -- [38]
									"Nexus_Raid_Floating_platform_Model.M2", -- [39]
									"Nexus_Sigil_Blue_01.m2", -- [40]
									"Nexus_Sigil_Blue_02.m2", -- [41]
									"Nexus_Sigil_Blue_Small_01.m2", -- [42]
									"Nexus_Sigil_Blue_Small_02.m2", -- [43]
									"Nexus_Sigil_Orange_01.m2", -- [44]
									"Nexus_Sigil_Orange_02.m2", -- [45]
									"Nexus_Spike_A_ice.m2", -- [46]
									"Nexus_Spike_A_rock.m2", -- [47]
									"Nexus_Spike_B_ice.m2", -- [48]
									"Nexus_Spike_B_rock.m2", -- [49]
									"Nexus_Spike_C_ice.m2", -- [50]
									"Nexus_Spike_C_rock.m2", -- [51]
									"Nexus_Spike_D_ice.m2", -- [52]
									"Nexus_Spike_D_rock.m2", -- [53]
									"Nexus_VortexRoom_MainFX.m2", -- [54]
									"Nexus_VortexRoom_MainFX_2.M2", -- [55]
									"Nexus_blueEnergywell.m2", -- [56]
									"nexus_Blue_Energyball_fast.m2", -- [57]
									"nexus_White_Bush_A.m2", -- [58]
									"nexus_bossROOM_lightshaft01.M2", -- [59]
									"nexus_fire_conduit.M2", -- [60]
									"nexus_frost_ritualdesign01.m2", -- [61]
									"nexus_frost_ritualdesign02_red.m2", -- [62]
									"nexus_hallway_lightshaft01.m2", -- [63]
									"nexus_ice_conduit.m2", -- [64]
									"nexus_library_lightshaft01.m2", -- [65]
									"nexus_octoroom01_conduit.m2", -- [66]
									"nexus_octoroom02_conduit.m2", -- [67]
									"nexus_octoroom03_conduit.M2", -- [68]
									"nexus_octoroom04_conduit.M2", -- [69]
									"nexus_octoroom_lightshaft01.m2", -- [70]
								},
								["N"] = "Nexus",
							}, -- [17]
							{
								["T"] = {
									{
										["T"] = {
											"Oracle_Hut01.m2", -- [1]
											"Oracle_Hut02.m2", -- [2]
											"Oracle_Hut03.m2", -- [3]
										},
										["N"] = "Huts",
									}, -- [1]
								},
								["N"] = "Oracle",
							}, -- [18]
							{
								["T"] = {
									"ND_BFDPot_01.m2", -- [1]
									"ND_BFDPot_02.m2", -- [2]
									"ND_BFDPot_03.m2", -- [3]
									"ND_BFDPot_04.m2", -- [4]
									"ND_BFDPot_Broken_01.m2", -- [5]
									"ND_BFDPot_Broken_02.m2", -- [6]
									"ND_NEStoneBench_01.m2", -- [7]
									"ND_NightElfRuins_01.m2", -- [8]
									"ND_NightElfRuins_02.m2", -- [9]
									"ND_NightElfRuins_03.m2", -- [10]
									"ND_NightElfRuins_04.m2", -- [11]
									"ND_NightElfRuins_05.m2", -- [12]
									"ND_NightElfRuins_06.m2", -- [13]
									"ND_NightElfRuins_07.m2", -- [14]
									"ND_NightElfRuins_08.m2", -- [15]
									"ND_NightElfRuins_09.m2", -- [16]
									"ND_NightElfRuins_10.m2", -- [17]
									"ND_NightElfRuins_11.m2", -- [18]
									"ND_NightElfRuins_12.m2", -- [19]
									"ND_NightElfRuins_13.m2", -- [20]
									"ND_NightElfRuins_14.m2", -- [21]
									"ND_NightElfRuins_15.m2", -- [22]
									"ND_NightElfRuins_16.m2", -- [23]
									"ND_NightElfRuins_17.m2", -- [24]
									"ND_NightElfRuins_18.m2", -- [25]
									"ND_NightElfRuins_19.m2", -- [26]
									"ND_NightElfRuins_20.m2", -- [27]
									"ND_NightElfRuins_21.m2", -- [28]
									"ND_NightElfRuins_22.m2", -- [29]
									"ND_NightElfRuins_23.m2", -- [30]
								},
								["N"] = "Riplash",
							}, -- [19]
							{
								["T"] = {
									"RedDragonShrine_Tree01.M2", -- [1]
									"RedDragonShrine_Tree02.m2", -- [2]
									"RedDragonShrine_Tree03.M2", -- [3]
									"RedDragonShrine_Tree04.m2", -- [4]
									"RedDragonShrine_Tree04_Burned.M2", -- [5]
									"RedDragonShrine_Tree04_Burned_Anim.M2", -- [6]
									"RedDragonShrine_Tree05.M2", -- [7]
									"RedDragonShrine_Tree06.M2", -- [8]
									"RedDragonShrine_Tree07.M2", -- [9]
									"RedDragonShrine_Tree08.M2", -- [10]
									"RubySanctum_Door_01.M2", -- [11]
									"RubySanctum_Door_02.M2", -- [12]
									"RubySanctum_Door_03.M2", -- [13]
									"RubySanctum_Door_04.M2", -- [14]
								},
								["N"] = "Rubysanctum",
							}, -- [20]
							{
								["T"] = {
									{
										["T"] = {
											"SholazarPalm_Bridge01.m2", -- [1]
										},
										["N"] = "Bridge",
									}, -- [1]
									{
										["T"] = {
											"SholazarShrub04.m2", -- [1]
											"SholazarShrub05.m2", -- [2]
											"SholazarShrub07.m2", -- [3]
											"SholazarShrub09.m2", -- [4]
											"Sholazar_AloeA.m2", -- [5]
											"Sholazar_AloeB.m2", -- [6]
											"Sholazar_BambooA.m2", -- [7]
											"Sholazar_BambooB.m2", -- [8]
											"Sholazar_CattailA.m2", -- [9]
											"Sholazar_CattailB.m2", -- [10]
											"Sholazar_FernA.m2", -- [11]
											"Sholazar_FernA_Dark.m2", -- [12]
											"Sholazar_FernB.m2", -- [13]
											"Sholazar_FernB_Dark.m2", -- [14]
											"Sholazar_Fern_QuestOnly.m2", -- [15]
											"Sholazar_FlowerA.m2", -- [16]
											"Sholazar_FlowerB.m2", -- [17]
											"Sholazar_GrassA.m2", -- [18]
											"Sholazar_GrassA_Dark.m2", -- [19]
											"Sholazar_GrassB.m2", -- [20]
											"Sholazar_GrassB_Dark.m2", -- [21]
											"Sholazar_LeafyBushA.m2", -- [22]
											"Sholazar_LeafyBushA_Dark.m2", -- [23]
											"Sholazar_LeafyBushB.m2", -- [24]
											"Sholazar_LeafyBushB_Dark.m2", -- [25]
										},
										["N"] = "Bushes",
									}, -- [2]
									{
										["T"] = {
											"SholazarBasin_Fog_cool.m2", -- [1]
											"SholazarBasin_Fog_warm.m2", -- [2]
										},
										["N"] = "Fog",
									}, -- [3]
									{
										["T"] = {
											"Sholazar_Lightray_01.m2", -- [1]
											"Sholazar_Lightray_02.m2", -- [2]
										},
										["N"] = "Lightfx",
									}, -- [4]
									{
										["T"] = {
											"Sholazar_RockA.m2", -- [1]
											"Sholazar_RockA_Dark.m2", -- [2]
											"Sholazar_RockB.m2", -- [3]
											"Sholazar_RockB_Dark.m2", -- [4]
											"Sholazar_RockC.m2", -- [5]
											"Sholazar_RockC_Dark.m2", -- [6]
											"Sholazar_RockD.m2", -- [7]
											"Sholazar_RockD_Dark.m2", -- [8]
											"Sholazar_RockE.m2", -- [9]
											"Sholazar_RockE_Dark.m2", -- [10]
											"Sholazar_RockSmallA.m2", -- [11]
											"Sholazar_RockSmallB.m2", -- [12]
											"Sholazar_RockSmallC.m2", -- [13]
											"Sholazar_RockSmallD.m2", -- [14]
										},
										["N"] = "Rocks",
									}, -- [5]
									{
										["T"] = {
											"Shipwreck_Sails.m2", -- [1]
										},
										["N"] = "Shipwreck_d",
									}, -- [6]
									{
										["T"] = {
											"SholazarBroadLeaf_Bush01.m2", -- [1]
											"SholazarBroadLeaf_Bush01_Dark.m2", -- [2]
											"SholazarBroadLeaf_Bush02.m2", -- [3]
											"SholazarBroadLeaf_Bush02_Dark.m2", -- [4]
											"SholazarBroadLeaf_Bush_Scourge_01.m2", -- [5]
											"SholazarCanopy_Log01.m2", -- [6]
											"SholazarCanopy_Trunk01.m2", -- [7]
											"SholazarHugeCanopy_Doodad.m2", -- [8]
											"SholazarHugeCanopy_Tree01.m2", -- [9]
											"SholazarHugeCanopy_Tree02.m2", -- [10]
											"SholazarHugeCanopy_Tree03.m2", -- [11]
											"SholazarHugeCanopy_Tree_Scourge_01.m2", -- [12]
											"SholazarPalm_Burning01.m2", -- [13]
											"SholazarPalm_FallenTree01.m2", -- [14]
											"SholazarPalm_FallenTree02.m2", -- [15]
											"SholazarPalm_Fruit.m2", -- [16]
											"SholazarPalm_Log01.m2", -- [17]
											"SholazarPalm_Log02.m2", -- [18]
											"SholazarPalm_Tree01.m2", -- [19]
											"SholazarPalm_Tree02.m2", -- [20]
											"SholazarPalm_Tree03.m2", -- [21]
											"SholazarPalm_Tree_Scourge_01.m2", -- [22]
											"SholazarPalm_Tree_Scourge_02.m2", -- [23]
											"SholazarPalm_Trunk01.m2", -- [24]
											"SholazarPalm_Trunk02.m2", -- [25]
											"Sholazar_Branch_Large01.m2", -- [26]
											"Sholazar_Branch_Medium01.m2", -- [27]
											"Sholazar_Branch_Small01.m2", -- [28]
											"Sholazar_Fruit01.m2", -- [29]
											"Sholazar_Root01.m2", -- [30]
											"Sholazar_Root02.m2", -- [31]
											"Sholazar_Root03.m2", -- [32]
											"Sholazar_Root04.m2", -- [33]
											"Sholazar_Root05.m2", -- [34]
											"Sholazar_Root06.m2", -- [35]
											"Sholazar_Root07.m2", -- [36]
											"Sholazar_TreeLeafA.m2", -- [37]
											"Sholazar_TreeLeafB.m2", -- [38]
											"Sholazar_Vine01.m2", -- [39]
											"Sholazar_Vine02.m2", -- [40]
										},
										["N"] = "Trees",
									}, -- [7]
									{
										["T"] = {
											"Wasp_SmallHive01.m2", -- [1]
										},
										["N"] = "Waspkit",
									}, -- [8]
									{
										["T"] = {
											"SholazarNorthOceanWF04.m2", -- [1]
											"SholazarSouthOceanWaterfall-01.m2", -- [2]
											"SholazarSouthOceanWaterfall-03.m2", -- [3]
											"SholazarSouthOceanWaterfall_Center.m2", -- [4]
											"SholazarSouthoceanWaterfall-04.m2", -- [5]
											"SholazarSouthoceanWaterfall-05.m2", -- [6]
											"SholazarSouthoceanWaterfall-06.m2", -- [7]
											"SholazarSouthoceanWaterfall-07.m2", -- [8]
											"Sholazar_Dirty_Waterfall.m2", -- [9]
											"Sholazar_Dirty_Waterfall_Chop.m2", -- [10]
											"Sholazar_NorthOceanWaterfall_Center01.m2", -- [11]
										},
										["N"] = "Waterfalls",
									}, -- [9]
									"HatchWindow.m2", -- [10]
									"LostHatch.m2", -- [11]
									"Sholazar_Crystal_01.m2", -- [12]
									"Sholazar_Crystal_02.m2", -- [13]
									"Sholazar_Crystal_03.m2", -- [14]
									"Sholazar_Crystal_03a.m2", -- [15]
									"Sholazar_Crystal_04.m2", -- [16]
									"Sholazar_Crystal_04a.m2", -- [17]
									"Sholazar_Crystal_05.m2", -- [18]
									"Sholazar_Crystal_06.m2", -- [19]
									"Sholazar_Crystal_07.m2", -- [20]
									"Sholazar_Geode_Crys_1.m2", -- [21]
									"Sholazar_Geode_Crys_2.m2", -- [22]
									"Sholazar_Geode_Crys_3.m2", -- [23]
								},
								["N"] = "Scholazar",
							}, -- [21]
							{
								["T"] = {
									"ND_Icebreaker_ship_BG.M2", -- [1]
									"ND_Icebreaker_ship_BG_Flip.M2", -- [2]
									"ND_Ship_UD_BG.m2", -- [3]
									"ND_Ship_UD_BG_Flip.m2", -- [4]
									"Transport_Ship_UD_Sails.m2", -- [5]
								},
								["N"] = "Ships",
							}, -- [22]
							{
								["T"] = {
									{
										["T"] = {
											"Sholazar_RainBow.m2", -- [1]
										},
										["N"] = "Rainbow",
									}, -- [1]
									"SB_AloeA.m2", -- [2]
									"SB_AloeB.m2", -- [3]
									"SB_FernA.m2", -- [4]
									"SB_FernB.m2", -- [5]
									"SB_GrassA.m2", -- [6]
									"SB_GrassB.m2", -- [7]
									"SB_LeafyBushA.M2", -- [8]
									"SB_LeafyBushB.m2", -- [9]
									"Sholazar_Vine_Quest_01.m2", -- [10]
								},
								["N"] = "Sholazarbasin",
							}, -- [23]
							{
								["T"] = {
									{
										["T"] = {
											"StormPeaks_BushA.m2", -- [1]
										},
										["N"] = "Bushes",
									}, -- [1]
									{
										["T"] = {
											"StormPeaks_Fog_01.m2", -- [1]
											"StormPeaks_Ulduar_Clouds.m2", -- [2]
											"StormPeaks_Ulduar_Clouds_02.m2", -- [3]
											"StormPeaks_Ulduar_Clouds_03.m2", -- [4]
										},
										["N"] = "Fog",
									}, -- [2]
									{
										["T"] = {
											"FrozenGiantKing.m2", -- [1]
											"GiantBattle_Attack_01.M2", -- [2]
											"GiantBattle_Magic.m2", -- [3]
										},
										["N"] = "Giantbattle",
									}, -- [3]
									{
										["T"] = {
											"FrostGiantIceShard01.m2", -- [1]
											"FrostGiantIceShard02.m2", -- [2]
											"FrostGiantIceShard03.m2", -- [3]
											"FrostGiantIceShard04.m2", -- [4]
											"FrostGiant_CitadelPiece01.M2", -- [5]
											"FrostGiant_CitadelPiece02.M2", -- [6]
											"FrostGiant_CitadelPiece03.M2", -- [7]
											"FrostGiant_CitadelPiece04.M2", -- [8]
											"FrostGiant_IceArch_01.m2", -- [9]
											"FrostGiant_IceArch_02.m2", -- [10]
											"FrostGiant_IceCliff_01.m2", -- [11]
											"FrostGiant_IceCliff_02.m2", -- [12]
											"FrostGiant_IceCliff_04.m2", -- [13]
											"FrostGiant_IceCliff_05.m2", -- [14]
										},
										["N"] = "Iceshards",
									}, -- [4]
									{
										["T"] = {
											"StormPeaksLightning01.m2", -- [1]
											"StormPeaksLightning02.m2", -- [2]
											"StormPeaksLightning03.m2", -- [3]
											"StormPeaksLightning04.m2", -- [4]
											"StormPeaksLightning05.m2", -- [5]
											"StormPeaksLightning06.m2", -- [6]
										},
										["N"] = "Lightning",
									}, -- [5]
									{
										["T"] = {
											"StormPeaks_RockA.m2", -- [1]
											"StormPeaks_RockB.m2", -- [2]
											"StormPeaks_RockC.m2", -- [3]
											"StormPeaks_RockD.m2", -- [4]
											"StormPeaks_RockE.m2", -- [5]
											"StormPeaks_RockF.m2", -- [6]
										},
										["N"] = "Rocks",
									}, -- [6]
									{
										["T"] = {
											"SP_RocNest01.m2", -- [1]
											"SP_RocNest03collision.m2", -- [2]
										},
										["N"] = "Rocs",
									}, -- [7]
									{
										["T"] = {
											"OrangeScourgeBubbles.m2", -- [1]
											"OrangeScourgeBubbles2.m2", -- [2]
											"OrangeScourgeSteam.m2", -- [3]
										},
										["N"] = "Scourge",
									}, -- [8]
									{
										["T"] = {
											"StormPeaks_SnowDrift_Wind_01.m2", -- [1]
											"StormPeaks_snowdrift_01.m2", -- [2]
											"StormPeaks_snowdrift_02.m2", -- [3]
											"StormPeaks_snowdrift_03.m2", -- [4]
											"StormPeaks_snowdrift_04.m2", -- [5]
										},
										["N"] = "Snow",
									}, -- [9]
									{
										["T"] = {
											"StormPeaks_TreeA.m2", -- [1]
											"StormPeaks_TreeB.m2", -- [2]
											"StormPeaks_TreeC.m2", -- [3]
											"StormPeaks_TreeD.m2", -- [4]
											"StormPeaks_TreeE.m2", -- [5]
											"StormPeaks_TreeF.m2", -- [6]
											"StormPeaks_TreeG.m2", -- [7]
											"StormPeaks_TreeH.m2", -- [8]
											"StormPeaks_TreeI.m2", -- [9]
										},
										["N"] = "Trees",
									}, -- [10]
								},
								["N"] = "Stormpeaks",
							}, -- [24]
							{
								["T"] = {
									{
										["T"] = {
											"LD_Stratholme_Banner01.m2", -- [1]
											"LD_Stratholme_Banner02.m2", -- [2]
											"LD_Stratholme_Banner03.m2", -- [3]
											"LD_Stratholme_Banner04.m2", -- [4]
											"LD_Stratholme_Banner05.m2", -- [5]
											"LD_Stratholme_Banner06.m2", -- [6]
											"LD_Stratholme_Banner07.m2", -- [7]
											"LD_Stratholme_Banner08.m2", -- [8]
											"LD_Stratholme_FoodTent.m2", -- [9]
											"LD_Stratholme_LongBanners01.m2", -- [10]
											"LD_Stratholme_OpenTent.m2", -- [11]
											"LD_Stratholme_Platform01.m2", -- [12]
										},
										["N"] = "Banners",
									}, -- [1]
									"LD_Arc_OldStratholme.m2", -- [2]
									"LD_FlowerBunch.m2", -- [3]
									"LD_FoodCart01.m2", -- [4]
									"LD_GrainCrate01.m2", -- [5]
									"LD_GrainSack01.m2", -- [6]
									"LD_GrainSack02.m2", -- [7]
									"LD_Green_Smoke_haystack.m2", -- [8]
									"LD_OldStratholme_Rug.m2", -- [9]
									"LD_OldStratholme_Rug02.m2", -- [10]
									"LD_OldStratholme_Rug03.m2", -- [11]
									"LD_OldStratholme_Rug04.m2", -- [12]
									"LD_StratholmeStreetlamp01.m2", -- [13]
									"LD_Stratholme_Clothingline01.m2", -- [14]
									"LD_Stratholme_Platform02.m2", -- [15]
									"LD_Stratholme_Tent01.m2", -- [16]
									"LD_Stratholme_Tent02.m2", -- [17]
									"LD_Stratholme_Tent03.m2", -- [18]
									"LD_Stratholme_Tent04.m2", -- [19]
									"LD_Stratholme_Tent05.m2", -- [20]
									"LD_Stratholme_Tent06.m2", -- [21]
									"LD_hidden_door_room.m2", -- [22]
								},
								["N"] = "Stratholme_past",
							}, -- [25]
							{
								["T"] = {
									{
										["T"] = {
											"TS_FishingHook_01.m2", -- [1]
											"TS_FishingPet_01.m2", -- [2]
										},
										["N"] = "Fishingstuff",
									}, -- [1]
									{
										["T"] = {
											"TS_Teapot_01.m2", -- [1]
										},
										["N"] = "Misc",
									}, -- [2]
								},
								["N"] = "Tuskar",
							}, -- [26]
							{
								["T"] = {
									"TI_WeatherGenerator_Blue.M2", -- [1]
									"TI_WeatherGenerator_Green.M2", -- [2]
									"TI_WeatherGenerator_Red.M2", -- [3]
									"TI_WeatherGenerator_Yellow.M2", -- [4]
									"UL_Anvil.M2", -- [5]
									"UL_Aquarium_Window.M2", -- [6]
									"UL_Banister01.M2", -- [7]
									"UL_BrainParts_01.m2", -- [8]
									"UL_BrainParts_02.m2", -- [9]
									"UL_BrainRoomDoor_01.M2", -- [10]
									"UL_Brain_01.m2", -- [11]
									"UL_Brazier01.M2", -- [12]
									"UL_Brazier_Broken.M2", -- [13]
									"UL_Brazier_Broken_02.M2", -- [14]
									"UL_Bridge01.m2", -- [15]
									"UL_Chains_01.m2", -- [16]
									"UL_Chains_02.m2", -- [17]
									"UL_Chains_03.m2", -- [18]
									"UL_Chains_04.m2", -- [19]
									"UL_Chains_05.m2", -- [20]
									"UL_Chandelier.m2", -- [21]
									"UL_Chandelier02.m2", -- [22]
									"UL_Chandelier_Effects01.M2", -- [23]
									"UL_Chandelier_NOFX.M2", -- [24]
									"UL_Chest_Cosmic.m2", -- [25]
									"UL_Chest_Gears.m2", -- [26]
									"UL_Chest_Ice.M2", -- [27]
									"UL_Chest_Leaf.m2", -- [28]
									"UL_Chest_Lightning.m2", -- [29]
									"UL_Chest_Plain.m2", -- [30]
									"UL_Crystal_Light01.m2", -- [31]
									"UL_Crystal_Light01_Broken.M2", -- [32]
									"UL_Crystal_Light02.M2", -- [33]
									"UL_DataRoom_Heads_01.M2", -- [34]
									"UL_Destructible_Gate01.m2", -- [35]
									"UL_Dirty_Glass_01.M2", -- [36]
									"UL_Dirty_Glass_02.M2", -- [37]
									"UL_Dirty_Glass_03.M2", -- [38]
									"UL_Dirty_Glass_04.M2", -- [39]
									"UL_Dirty_Glass_05.M2", -- [40]
									"UL_Drapery01.M2", -- [41]
									"UL_Drapery02.M2", -- [42]
									"UL_Face_Rotate.m2", -- [43]
									"UL_Floating_Glass01.M2", -- [44]
									"UL_Floating_Glass02.M2", -- [45]
									"UL_Floor01.m2", -- [46]
									"UL_Floor01_Blue.m2", -- [47]
									"UL_Forge_Iron_Press.M2", -- [48]
									"UL_Forge_Lava.M2", -- [49]
									"UL_Fountain_01.m2", -- [50]
									"UL_Frostwall_01.m2", -- [51]
									"UL_Garbage_Bits.M2", -- [52]
									"UL_Garbage_Bits2.M2", -- [53]
									"UL_Garbage_Bits3.M2", -- [54]
									"UL_Garbage_Bits4.m2", -- [55]
									"UL_Garbage_Bits5.M2", -- [56]
									"UL_Garbage_Bits6.m2", -- [57]
									"UL_Garbage_Pile.m2", -- [58]
									"UL_Gnome_Machine_01.m2", -- [59]
									"UL_Gnome_Machine_01_silent.M2", -- [60]
									"UL_Gnome_Machine_02.m2", -- [61]
									"UL_Gnome_Machine_02_silent.M2", -- [62]
									"UL_Gnome_Machine_03.m2", -- [63]
									"UL_Gnome_Machine_03_silent.M2", -- [64]
									"UL_Gnome_Machine_04.m2", -- [65]
									"UL_Gnome_Machine_05.m2", -- [66]
									"UL_Gnomewing_ButtonBigRed.m2", -- [67]
									"UL_Head_Female01.M2", -- [68]
									"UL_Head_Female02.M2", -- [69]
									"UL_Head_Male01.M2", -- [70]
									"UL_Hexagon_Floor.m2", -- [71]
									"UL_HubPrison_01.m2", -- [72]
									"UL_IcePlatform_01.m2", -- [73]
									"UL_IceWall_01.m2", -- [74]
									"UL_IceWall_02.m2", -- [75]
									"UL_IceWall_03.m2", -- [76]
									"UL_IceWall_04.m2", -- [77]
									"UL_IceWall_05.m2", -- [78]
									"UL_IceWall_06.m2", -- [79]
									"UL_IceWall_07.m2", -- [80]
									"UL_IronVrykulArmy_Eight01.m2", -- [81]
									"UL_IronVrykulArmy_Four01.m2", -- [82]
									"UL_IronVrykulArmy_Single01.m2", -- [83]
									"UL_Iron_Vrykul_Chest.m2", -- [84]
									"UL_Iron_Vrykul_Head.m2", -- [85]
									"UL_Iron_Vrykul_Left_Arm.m2", -- [86]
									"UL_Iron_Vrykul_Left_Leg.m2", -- [87]
									"UL_Iron_Vrykul_Right_Boot.m2", -- [88]
									"UL_Iron_Vrykul_Right_Hand.m2", -- [89]
									"UL_Iron_Vrykul_Right_Shoulder.m2", -- [90]
									"UL_Iron_Vrykul_Waist.m2", -- [91]
									"UL_LavaMouth_01.M2", -- [92]
									"UL_Light_Effect_Blue.M2", -- [93]
									"UL_Light_Effect_Green.M2", -- [94]
									"UL_Light_Effect_Purple.M2", -- [95]
									"UL_Light_Effect_Saronite_Towers.M2", -- [96]
									"UL_Light_Effect_Yellow.M2", -- [97]
									"UL_Lighting_Door01.M2", -- [98]
									"UL_Lighting_Door02.M2", -- [99]
									"UL_Lighting_Door02_Pillars.M2", -- [100]
									"UL_Lighting_Door03.M2", -- [101]
									"UL_Lighting_Door03_Pillars.M2", -- [102]
									"UL_Lightning_Tunnel.m2", -- [103]
									"UL_Machine_TramRing_02.M2", -- [104]
									"UL_MountainGiantCrystal.M2", -- [105]
									"UL_Orb_01.M2", -- [106]
									"UL_Planet_02.M2", -- [107]
									"UL_Planet_03.M2", -- [108]
									"UL_Planet_04.M2", -- [109]
									"UL_Planet_05.M2", -- [110]
									"UL_Planet_06.M2", -- [111]
									"UL_Planet_07.M2", -- [112]
									"UL_Planet_08.M2", -- [113]
									"UL_Planet_Azeroth.M2", -- [114]
									"UL_Planet_Azeroth_NoBase.M2", -- [115]
									"UL_Portal_Blue.m2", -- [116]
									"UL_Pot01.M2", -- [117]
									"UL_Pot02.M2", -- [118]
									"UL_Pot03.M2", -- [119]
									"UL_Power_Orb01.M2", -- [120]
									"UL_Power_Orb02.m2", -- [121]
									"UL_PyriteFuelCell.m2", -- [122]
									"UL_PyriteFuelCellLarge.m2", -- [123]
									"UL_RaidPrison_Floor.m2", -- [124]
									"UL_RaidTempleFloor_01.m2", -- [125]
									"UL_Rune_FloorCircle.m2", -- [126]
									"UL_SaronitePool_01.m2", -- [127]
									"UL_Sigil01.m2", -- [128]
									"UL_Sigil02.m2", -- [129]
									"UL_Sigil03.m2", -- [130]
									"UL_Sigil04.m2", -- [131]
									"UL_Sigil05.m2", -- [132]
									"UL_SigilDoor_01.m2", -- [133]
									"UL_SigilDoor_02.m2", -- [134]
									"UL_SkyRoom_Floor.M2", -- [135]
									"UL_Sky_Ceiling.m2", -- [136]
									"UL_SmallStatue_Druid.m2", -- [137]
									"UL_SmallStatue_Hero_01.m2", -- [138]
									"UL_StainGlass_Broken01.M2", -- [139]
									"UL_StainGlass_Broken02.M2", -- [140]
									"UL_StainGlass_Broken03.M2", -- [141]
									"UL_Stalagtit_01.m2", -- [142]
									"UL_Statue_01.m2", -- [143]
									"UL_Statue_02.m2", -- [144]
									"UL_Statue_03.M2", -- [145]
									"UL_Statue_04.m2", -- [146]
									"UL_Swirl_Orb_Cloud.m2", -- [147]
									"UL_TargetCrystal_Blue.m2", -- [148]
									"UL_TargetCrystal_Green.m2", -- [149]
									"UL_TargetCrystal_Red.m2", -- [150]
									"UL_TargetCrystal_Yellow.m2", -- [151]
									"UL_TeleportationPad.m2", -- [152]
									"UL_Throne.M2", -- [153]
									"UL_ThroneBase.M2", -- [154]
									"UL_Throne_02.M2", -- [155]
									"UL_Throne_Room_Floor.M2", -- [156]
									"UL_TitanBall_01.m2", -- [157]
									"UL_TitanEnergy_02.m2", -- [158]
									"UL_TitanSteam_01.m2", -- [159]
									"UL_TitanSteam_02.m2", -- [160]
									"UL_Torch01.M2", -- [161]
									"UL_Torch02.M2", -- [162]
									"UL_TowerBlueBeam.M2", -- [163]
									"UL_Train_Floor_Glass.m2", -- [164]
									"UL_Train_GearWindows.m2", -- [165]
									"UL_Train_RocketBlast.M2", -- [166]
									"UL_Train_Turnaround.m2", -- [167]
									"UL_TramGlass_01.m2", -- [168]
									"UL_Ulduar_Trapdoor_01.m2", -- [169]
									"UL_Ulduar_Trapdoor_02.m2", -- [170]
									"UL_Ulduar_doors01.M2", -- [171]
									"UL_Ulduar_doors02.M2", -- [172]
									"UL_Ulduar_doors03.M2", -- [173]
									"UL_Ulduar_doors04.M2", -- [174]
									"UL_Ulduar_doors05.M2", -- [175]
									"UL_UniverseFloor_01.m2", -- [176]
									"UL_UniverseFloor_02.M2", -- [177]
									"UL_UniverseGlobe.M2", -- [178]
									"UL_VehicleRepairBay_01.m2", -- [179]
									"UL_War_Machine_Pipe.M2", -- [180]
									"UL_War_machine01.m2", -- [181]
									"UL_Window.M2", -- [182]
									"UL_button_Control_Unit.M2", -- [183]
									"UL_button_Control_Unit02.M2", -- [184]
									"UL_gnomewing_ArmPulse.m2", -- [185]
									"UL_gnomewing_Door_01.M2", -- [186]
									"UL_gnomewing_LightBeam.m2", -- [187]
									"UL_gnomewing_LightTower.m2", -- [188]
									"UL_gnomewing_SpinningRoomRings.m2", -- [189]
									"UL_gnomewing_TeleportPad.m2", -- [190]
									"UL_gnomewing_TorsoElevator.m2", -- [191]
									"UL_gnomewing_Walkway.m2", -- [192]
									"UL_lightning.m2", -- [193]
									"UL_lightning02.m2", -- [194]
									"UL_lightning_Blue01.m2", -- [195]
									"Ul_Sigil_Gear.m2", -- [196]
									"Ul_Sigil_Leaf.m2", -- [197]
									"Ul_Sigil_Lightning.m2", -- [198]
									"Ul_Sigil_Snowflake.m2", -- [199]
									"Ul_Sigil_Star.m2", -- [200]
									"Ulduar_Arch01Dfx.m2", -- [201]
									"Ulduar_Arch02Dfx.m2", -- [202]
									"Ulduar_Building01Dfx.M2", -- [203]
									"Ulduar_Tower01_FX1.m2", -- [204]
									"Ulduar_Tower01_FX2.m2", -- [205]
									"Ulduar_Tower01_FX2b.m2", -- [206]
									"ulduarRaid_gnomeWing_transport_DOODAD.m2", -- [207]
								},
								["N"] = "Ulduar",
							}, -- [27]
							{
								["T"] = {
									{
										["T"] = {
											"UL_PowerOrb_Fusion.M2", -- [1]
										},
										["N"] = "Ul_powerorb_fusion",
									}, -- [1]
								},
								["N"] = "Uldum",
							}, -- [28]
							{
								["T"] = {
									{
										["T"] = {
											"Valgarde_Fire.M2", -- [1]
										},
										["N"] = "Valgrade_fire",
									}, -- [1]
								},
								["N"] = "Valgrade",
							}, -- [29]
							{
								["T"] = {
									"WG_Keep_Door01_collision.m2", -- [1]
								},
								["N"] = "Wintergrasp",
							}, -- [30]
							{
								["T"] = {
									"WT_Basket_01.m2", -- [1]
									"WT_Basket_02.m2", -- [2]
									"WT_Basket_03.m2", -- [3]
									"WT_Bench_01.m2", -- [4]
									"WT_Brazier_Lit.m2", -- [5]
									"WT_Brazier_Unlit.m2", -- [6]
									"WT_Chair_01.m2", -- [7]
									"WT_HangingScroll_01.m2", -- [8]
									"WT_HangingScroll_02.m2", -- [9]
									"WT_HangingScroll_03.m2", -- [10]
									"WT_HangingScroll_04.m2", -- [11]
									"WT_HangingScroll_05.m2", -- [12]
									"WT_HangingScroll_06.m2", -- [13]
									"WT_Hanging_01.m2", -- [14]
									"WT_Hanging_02.m2", -- [15]
									"WT_Hanging_03.m2", -- [16]
									"WT_Hanging_04.m2", -- [17]
									"WT_Lamppost01.m2", -- [18]
									"WT_Lamppost01_WreckedA.m2", -- [19]
									"WT_Lamppost01_WreckedB.m2", -- [20]
									"WT_Lamppost01_WreckedC.m2", -- [21]
									"WT_Lantern01.m2", -- [22]
									"WT_LanternHanging01.m2", -- [23]
									"WT_Mummy01.m2", -- [24]
									"WT_Pyre01.m2", -- [25]
									"WT_Pyre02.m2", -- [26]
									"WT_Roadsign.m2", -- [27]
									"WT_Roadsign_Post.m2", -- [28]
									"WT_Rug_01.m2", -- [29]
									"WT_Rug_02.m2", -- [30]
									"WT_Rug_03.m2", -- [31]
									"WT_Rug_04.m2", -- [32]
									"WT_Scroll_01.m2", -- [33]
									"WT_Scroll_02.m2", -- [34]
									"WT_Sled_01.m2", -- [35]
									"WT_Sled_01Packed.m2", -- [36]
									"WT_Sled_01Packed_WreckedA.m2", -- [37]
									"WT_Sled_01Packed_WreckedB.m2", -- [38]
									"WT_Sled_02.m2", -- [39]
									"WT_Sled_02Packed.m2", -- [40]
									"WT_Sled_02_WreckedA.m2", -- [41]
									"WT_Standard_01.m2", -- [42]
									"WT_Tent01.M2", -- [43]
									"WT_Tent01_WreckedA.m2", -- [44]
									"WT_Tent01_WreckedB.m2", -- [45]
									"WT_Tent02.m2", -- [46]
									"WT_Tent03.m2", -- [47]
									"WT_Totem01.m2", -- [48]
									"WT_Totem01Snow.m2", -- [49]
									"WT_Totem02.m2", -- [50]
									"WT_Totem02Snow.m2", -- [51]
									"WT_Windbreak01.m2", -- [52]
									"WT_Windbreak01_WreckedA.m2", -- [53]
									"WT_Windbreak01_WreckedB.m2", -- [54]
									"WT_Windbreak02.m2", -- [55]
								},
								["N"] = "Wintertauren",
							}, -- [31]
							{
								["T"] = {
									{
										["T"] = {
											"ZulDrak_Aqueduct_01.M2", -- [1]
											"ZulDrak_Aqueduct_02.m2", -- [2]
											"ZulDrak_Aqueduct_03.m2", -- [3]
										},
										["N"] = "Aqueduct",
									}, -- [1]
									{
										["T"] = {
											{
												["T"] = {
													"ZulDrakWaterDrip_01.m2", -- [1]
													"ZulDrakWaterSteps_01.M2", -- [2]
													"ZulDrak_Trollfountainhead_01.m2", -- [3]
												},
												["N"] = "Waterfalls",
											}, -- [1]
											"GunDrak_Coffin_01.m2", -- [2]
											"GunDrak_Collision_01.m2", -- [3]
											"GunDrak_Collision_02.m2", -- [4]
											"GunDrak_Key_Mammoth.M2", -- [5]
											"GunDrak_Key_Rhino.M2", -- [6]
											"GunDrak_Key_Snake.M2", -- [7]
											"GunDrak_Key_Troll.M2", -- [8]
											"GundrakCrystal_01.m2", -- [9]
											"Gundrak_Snake.M2", -- [10]
											"ZulDrak_Alter.m2", -- [11]
											"ZulDrak_Banner_01.m2", -- [12]
											"ZulDrak_Banner_02.m2", -- [13]
											"ZulDrak_Banner_03.m2", -- [14]
											"ZulDrak_Bats_Lower_01.m2", -- [15]
											"ZulDrak_Brazier_01.M2", -- [16]
											"ZulDrak_BurningLog_01.M2", -- [17]
											"ZulDrak_Crystal_01.m2", -- [18]
											"ZulDrak_Flag_01.M2", -- [19]
											"ZulDrak_Flag_02.m2", -- [20]
											"ZulDrak_Floating_Light_01.M2", -- [21]
											"ZulDrak_Gem_Blue_01.m2", -- [22]
											"ZulDrak_Gem_Green_01.m2", -- [23]
											"ZulDrak_Gem_Green_02.m2", -- [24]
											"ZulDrak_Gem_Purple_01.m2", -- [25]
											"ZulDrak_Gem_White_01.m2", -- [26]
											"ZulDrak_HangingSkulls_01.m2", -- [27]
											"ZulDrak_HangingSkulls_02.m2", -- [28]
											"ZulDrak_HangingSkulls_03.m2", -- [29]
											"ZulDrak_Hanging_Light_01.M2", -- [30]
											"ZulDrak_Hanging_Light_02.M2", -- [31]
											"ZulDrak_Heart_01.m2", -- [32]
											"ZulDrak_Lever.m2", -- [33]
											"ZulDrak_Pile_01.m2", -- [34]
											"ZulDrak_Pile_02.m2", -- [35]
											"ZulDrak_Pile_03.m2", -- [36]
											"ZulDrak_Red_Gem_01.m2", -- [37]
											"ZulDrak_Ropes_01.m2", -- [38]
											"ZulDrak_Ropes_02.m2", -- [39]
											"ZulDrak_Ropes_03.m2", -- [40]
											"ZulDrak_Ropes_04.m2", -- [41]
											"ZulDrak_Ropes_05.m2", -- [42]
											"ZulDrak_Ropes_06.m2", -- [43]
											"ZulDrak_Shield_01.m2", -- [44]
											"ZulDrak_Shield_02.m2", -- [45]
											"ZulDrak_SkullPile_01.m2", -- [46]
											"ZulDrak_SkullPile_02.m2", -- [47]
											"ZulDrak_SkullPile_03.m2", -- [48]
											"ZulDrak_Skullpole_01.m2", -- [49]
											"ZulDrak_Skullpole_01_Low.m2", -- [50]
											"ZulDrak_Skullpole_02.m2", -- [51]
											"ZulDrak_Skullpole_02_Low.m2", -- [52]
											"ZulDrak_Spears_01.m2", -- [53]
											"ZulDrak_Spears_02.m2", -- [54]
											"ZulDrak_Spears_03.m2", -- [55]
											"ZulDrak_Spikestrip_01.m2", -- [56]
											"ZulDrak_Spikestructure_01.m2", -- [57]
											"ZulDrak_Sword_01.m2", -- [58]
											"ZulDrak_Torch_01.M2", -- [59]
											"ZulDrak_Torch_01_Low.M2", -- [60]
											"ZulDrak_Torch_02.M2", -- [61]
											"ZulDrak_Torch_02b.M2", -- [62]
											"ZulDrak_Torch_03.m2", -- [63]
											"ZulDrak_Torch_04.M2", -- [64]
											"ZulDrak_Waterspout_01.m2", -- [65]
											"ZulDrak_Weaponrack_01.m2", -- [66]
											"ZulDrak_Windchime_01.m2", -- [67]
											"ZulDrak_Windchime_02.m2", -- [68]
											"ZulDrak_Windchime_03.m2", -- [69]
										},
										["N"] = "Decorations",
									}, -- [2]
									{
										["T"] = {
											"ZulDrak_FencePost_01.m2", -- [1]
											"ZulDrak_Fence_01.m2", -- [2]
											"ZulDrak_Fence_02.m2", -- [3]
											"ZulDrak_Fence_03.m2", -- [4]
										},
										["N"] = "Fences",
									}, -- [3]
									{
										["T"] = {
											"GunDrak_Elevator_01.m2", -- [1]
											"GunDrak_Fence_Door.m2", -- [2]
											"GunDrak_Short_Door.M2", -- [3]
											"GunDrak_Trapdoor_02.m2", -- [4]
											"GunDrak_UnderwaterHatch_Door.m2", -- [5]
											"GundrakGrateIce.m2", -- [6]
										},
										["N"] = "Gundrak",
									}, -- [4]
									{
										["T"] = {
											"ZulDrak_Fog_Blue.m2", -- [1]
											"ZulDrak_Fog_Blue_toggleable.M2", -- [2]
											"ZulDrak_Fog_Red.M2", -- [3]
											"ZulDrak_Lightray_01.m2", -- [4]
											"Zuldrak_Blue_Fire.M2", -- [5]
											"Zuldrak_Blue_Fire02.M2", -- [6]
										},
										["N"] = "Lightfx",
									}, -- [5]
									{
										["T"] = {
											"ZulDrak_MojoStreams.m2", -- [1]
										},
										["N"] = "Mojostreams",
									}, -- [6]
									{
										["T"] = {
											"ZulDrak_PathStoneSnow_01.m2", -- [1]
											"ZulDrak_PathStoneSnow_02.m2", -- [2]
											"ZulDrak_PathStoneSnow_03.m2", -- [3]
											"ZulDrak_PathStoneSnow_04.m2", -- [4]
											"ZulDrak_PathStone_01.m2", -- [5]
											"ZulDrak_PathStone_02.m2", -- [6]
											"ZulDrak_PathStone_03.m2", -- [7]
											"ZulDrak_PathStone_04.m2", -- [8]
										},
										["N"] = "Rocks",
									}, -- [7]
									{
										["T"] = {
											"ZulDrak_SkyVortex.m2", -- [1]
										},
										["N"] = "Skyvortex",
									}, -- [8]
									{
										["T"] = {
											"ZulDrak_Statue_Base_01.m2", -- [1]
											"ZulDrak_Statue_Bear_01.m2", -- [2]
											"ZulDrak_Statue_Mammoth_01.m2", -- [3]
											"ZulDrak_Statue_Rhino_01.m2", -- [4]
											"ZulDrak_Statue_Serpent_01.m2", -- [5]
											"ZulDrak_Statue_Snake_01.m2", -- [6]
											"ZulDrak_Statue_SnowLeopard_01.m2", -- [7]
										},
										["N"] = "Statues",
									}, -- [9]
									{
										["T"] = {
											"ZulDrak_Bush_01.m2", -- [1]
											"ZulDrak_Bush_02.m2", -- [2]
											"ZulDrak_Bush_03.m2", -- [3]
											"ZulDrak_Bush_04.m2", -- [4]
											"ZulDrak_Bush_05.m2", -- [5]
											"ZulDrak_Bush_07.M2", -- [6]
											"ZulDrak_Bush_07_Int.M2", -- [7]
											"ZulDrak_Bush_09.m2", -- [8]
											"ZulDrak_Bush_09_Snowy.m2", -- [9]
											"ZulDrak_Bush_11.m2", -- [10]
											"ZulDrak_Crop_01.m2", -- [11]
											"ZulDrak_Crop_02.m2", -- [12]
											"ZulDrak_LargeTree_01.m2", -- [13]
											"ZulDrak_LargeTree_01_Snowy.m2", -- [14]
											"ZulDrak_LargeTree_02.m2", -- [15]
											"ZulDrak_LargeTree_02_Snowy.m2", -- [16]
											"ZulDrak_LargeTree_03.m2", -- [17]
											"ZulDrak_LargeTree_04.m2", -- [18]
											"ZulDrak_LargeTree_04_Snowy.m2", -- [19]
											"ZulDrak_RedBush_01.m2", -- [20]
											"ZulDrak_Roots_01.m2", -- [21]
											"ZulDrak_Roots_01_Snowy.m2", -- [22]
											"ZulDrak_Roots_02.m2", -- [23]
											"ZulDrak_Roots_03.m2", -- [24]
											"ZulDrak_Roots_03_Snowy.m2", -- [25]
											"ZulDrak_Roots_04.m2", -- [26]
											"ZulDrak_Roots_04_Snowy.m2", -- [27]
											"ZulDrak_Roots_05.m2", -- [28]
											"ZulDrak_Roots_06.m2", -- [29]
											"ZulDrak_ShelfMushroom_01.m2", -- [30]
											"ZulDrak_ShelfMushroom_02.m2", -- [31]
											"ZulDrak_ThinMushroom_01.m2", -- [32]
											"ZulDrak_Tree_01.m2", -- [33]
											"ZulDrak_Tree_02.m2", -- [34]
											"ZulDrak_Tree_03.m2", -- [35]
											"ZulDrak_Tree_04.m2", -- [36]
											"ZulDrak_VinePlane_01.m2", -- [37]
										},
										["N"] = "Trees",
									}, -- [10]
									{
										["T"] = {
											"IT_Brazier01.m2", -- [1]
											"IT_Brazier02.m2", -- [2]
											"IT_Brazier03.m2", -- [3]
											"ZD_RoadPiece_01.m2", -- [4]
											"ZulDrak_Archpost_01.m2", -- [5]
											"ZulDrak_Archpost_02.m2", -- [6]
											"ZulDrak_Archpost_03.m2", -- [7]
											"ZulDrak_Archpost_04.m2", -- [8]
											"ZulDrak_Archpost_05.M2", -- [9]
											"ZulDrak_Archpost_06.M2", -- [10]
											"ZulDrak_Archway_01.m2", -- [11]
											"ZulDrak_Archway_02.m2", -- [12]
											"ZulDrak_Archway_03.m2", -- [13]
											"ZulDrak_Archway_04.m2", -- [14]
											"ZulDrak_Archway_Broken_02.m2", -- [15]
											"ZulDrak_Archway_Broken_03.m2", -- [16]
											"ZulDrak_Archway_Snow_02.m2", -- [17]
											"ZulDrak_Archway_Snow_03.m2", -- [18]
											"ZulDrak_ColiseumGong.m2", -- [19]
											"ZulDrak_Gong_01.m2", -- [20]
											"ZulDrak_Incense_01.M2", -- [21]
											"ZulDrak_RoadCurb_01.m2", -- [22]
											"ZulDrak_RoadCurb_02.m2", -- [23]
											"ZulDrak_RoadCurb_02Reverse.m2", -- [24]
											"ZulDrak_RoadCurb_03.m2", -- [25]
											"ZulDrak_RoadCurb_03Wide.m2", -- [26]
											"ZulDrak_RoadCurb_03_simple.m2", -- [27]
											"ZulDrak_RoadCurb_04.m2", -- [28]
											"ZulDrak_RoadCurb_05.m2", -- [29]
											"ZulDrak_RoadCurb_05Short.m2", -- [30]
											"ZulDrak_RoadCurb_06.M2", -- [31]
											"ZulDrak_RoadCurb_07.m2", -- [32]
											"ZulDrak_RuinBlocks_01.m2", -- [33]
											"ZulDrak_Ruin_03.m2", -- [34]
											"ZulDrak_Ruin_03_Basic.m2", -- [35]
											"ZulDrak_Ruin_04.m2", -- [36]
											"ZulDrak_Ruin_05.m2", -- [37]
											"ZulDrak_Ruin_06.m2", -- [38]
											"ZulDrak_Ruin_10.m2", -- [39]
											"ZulDrak_Ruin_11.m2", -- [40]
											"ZulDrak_Ruin_12.m2", -- [41]
											"ZulDrak_Ruin_15.m2", -- [42]
											"ZulDrak_Ruin_16.m2", -- [43]
											"ZulDrak_Ruin_17.m2", -- [44]
											"ZulDrak_Ruin_CornerTall01.m2", -- [45]
											"ZulDrak_Ruin_Cornersmall01.m2", -- [46]
											"ZulDrak_Ruin_Stairs_02.m2", -- [47]
											"ZulDrak_Ruin_Stairs_03.m2", -- [48]
											"ZulDrak_Ruin_Stairs_03_Wide.m2", -- [49]
											"ZulDrak_Ruin_Wall_02.m2", -- [50]
											"ZulDrak_StoneFace_01.m2", -- [51]
											"ZulDrak_StonePost_01.m2", -- [52]
											"ZulDrak_StonePost_02.m2", -- [53]
											"ZulDrak_StonePost_End_01.m2", -- [54]
											"ZulDrak_WallEnd_01.m2", -- [55]
											"ZulDrak_WallRubble_01.m2", -- [56]
											"ZulDrak_WallRubble_02.m2", -- [57]
											"Zuldrak_Head_01.m2", -- [58]
										},
										["N"] = "Trollruins",
									}, -- [11]
									{
										["T"] = {
											"ZulDrak_GunDrak_Hub_Ripples.m2", -- [1]
											"ZulDrak_Purple_Water_Mist.m2", -- [2]
											"ZulDrak_WaterFalls_Set1_Circle_Ripples.m2", -- [3]
											"ZulDrak_WaterFalls_Set1_High_Purple.m2", -- [4]
											"ZulDrak_WaterFalls_Set1_High_Ripples.m2", -- [5]
											"ZulDrak_WaterFog_01.m2", -- [6]
											"ZulDrak_waterfall_Type1.m2", -- [7]
											"ZulDrak_waterfall_Type1_Purple.m2", -- [8]
											"ZulDrak_waterfall_Type2.m2", -- [9]
											"ZulDrak_waterfall_Type2_Purple.m2", -- [10]
											"ZulDrak_waterfall_Type2_Purple_B.m2", -- [11]
											"ZulDrak_waterfall_Type2_Purple_C.m2", -- [12]
										},
										["N"] = "Waterfalls",
									}, -- [12]
								},
								["N"] = "Zuldrak",
							}, -- [32]
						},
						["N"] = "Doodads",
					}, -- [1]
				},
				["N"] = "Expansion02",
			}, -- [11]
			{
				["T"] = {
					{
						["T"] = {
							{
								["T"] = {
									{
										["T"] = {
											"Abyssal_BubbleFX_01.M2", -- [1]
										},
										["N"] = "Bubblefx",
									}, -- [1]
									{
										["T"] = {
											"Abyssal_Bubbles_01.M2", -- [1]
											"Abyssal_BushCoral01.M2", -- [2]
											"Abyssal_CoralChunk_01.M2", -- [3]
											"Abyssal_CoralTube_01.M2", -- [4]
											"Abyssal_CoralTube_02.M2", -- [5]
											"Abyssal_CoralTube_03.M2", -- [6]
											"Abyssal_CoralTube_04.M2", -- [7]
											"Abyssal_CoralTube_05.M2", -- [8]
											"Abyssal_CoralTube_06.M2", -- [9]
											"Abyssal_Coral_01.M2", -- [10]
											"Abyssal_Coral_02.M2", -- [11]
											"Abyssal_Coral_03.M2", -- [12]
											"Abyssal_Coral_04.M2", -- [13]
											"Abyssal_Coral_05.M2", -- [14]
											"Abyssal_Coral_06.M2", -- [15]
											"Abyssal_Coral_07.M2", -- [16]
											"Abyssal_Coral_07_Glow.M2", -- [17]
											"Abyssal_Coral_Chunk01.M2", -- [18]
											"Abyssal_Coral_Chunk02.M2", -- [19]
											"Abyssal_Coral_Chunk03.M2", -- [20]
											"Abyssal_Coral_Chunk04.M2", -- [21]
											"Abyssal_Coral_Chunk05.M2", -- [22]
											"Abyssal_Coral_Chunk_Ceiling01.M2", -- [23]
											"Abyssal_Coral_Chunk_Ceiling01_Break.M2", -- [24]
											"Abyssal_Coral_Chunk_Ceiling02.M2", -- [25]
											"Abyssal_Coral_Chunk_Ceiling03.M2", -- [26]
											"Abyssal_Coral_Lamp_01.M2", -- [27]
											"Abyssal_Coral_Lamp_02.M2", -- [28]
											"Abyssal_Coral_Lamp_03.M2", -- [29]
											"Abyssal_Coral_Rock_01.M2", -- [30]
											"Abyssal_Coral_Rock_02.M2", -- [31]
											"Abyssal_Coral_Rock_03.M2", -- [32]
											"Abyssal_Coral_SeaFan.M2", -- [33]
											"Abyssal_Fish01.M2", -- [34]
											"Abyssal_Fish02.M2", -- [35]
											"Abyssal_GoldenFish_Light.M2", -- [36]
											"Abyssal_Jellyfish01.M2", -- [37]
											"Abyssal_Jellyfish_Elevator.M2", -- [38]
											"Abyssal_Maw_GiantClam.M2", -- [39]
											"Abyssal_Maw_GiantClam_02.M2", -- [40]
											"Abyssal_Maw_GiantClam_03.M2", -- [41]
											"Abyssal_Maw_GiantClam_04.M2", -- [42]
											"Abyssal_Maw_GiantClam_05.M2", -- [43]
											"Abyssal_Maw_Shell_01.M2", -- [44]
											"Abyssal_Maw_Shell_02.M2", -- [45]
											"Abyssal_Maw_Shell_Fountain.M2", -- [46]
											"Abyssal_SeaHorse_01.M2", -- [47]
											"Abyssal_SeaSponge01.M2", -- [48]
											"Abyssal_Sea_Shelf.M2", -- [49]
											"Abyssal_Seagrass01.M2", -- [50]
											"Abyssal_SeaweedBlueStatic01.M2", -- [51]
											"Abyssal_SeaweedLong_01.M2", -- [52]
											"Abyssal_Seaweed_02.M2", -- [53]
											"Abyssal_Seaweed_03.M2", -- [54]
											"Abyssal_Seaweed_04.M2", -- [55]
											"Abyssal_Seaweed_Blue_01.M2", -- [56]
											"Abyssal_Seaweed_Blue_02.M2", -- [57]
											"Abyssal_Seaweed_Blue_03.M2", -- [58]
											"Abyssal_Seaweed_Blue_04.M2", -- [59]
											"Abyssal_Seaweed_Drape.M2", -- [60]
											"Abyssal_Seaweed_Drape02.M2", -- [61]
											"Abyssal_StarFish_Red.M2", -- [62]
										},
										["N"] = "Coral",
									}, -- [2]
									{
										["T"] = {
											"Abyssal_Maw_Door_01.M2", -- [1]
										},
										["N"] = "Doors",
									}, -- [3]
									{
										["T"] = {
											"Abyssal_Vortex_01.M2", -- [1]
											"Abyssal_Waterfall_01.M2", -- [2]
										},
										["N"] = "Water",
									}, -- [4]
									"Abyssal_Leviathan_Tentacle.M2", -- [5]
									"Abyssal_Leviathan_Tentacle_fromBelow.M2", -- [6]
								},
								["N"] = "Abyssalmaw",
							}, -- [1]
							{
								["T"] = {
									"TradeSkill_Archaeology_SurveyTool_Green.M2", -- [1]
									"TradeSkill_Archaeology_SurveyTool_Red.M2", -- [2]
									"TradeSkill_Archaeology_SurveyTool_Yellow.M2", -- [3]
								},
								["N"] = "Archaeology",
							}, -- [2]
							{
								["T"] = {
									"Worgen_Fence_01_Battlegrounds.M2", -- [1]
									"Worgen_Fence_02_Battlegrounds.M2", -- [2]
									"Worgen_Fence_03_Battlegrounds.M2", -- [3]
									"Worgen_Fence_04_Battlegrounds.M2", -- [4]
									"Worgen_Gate_Wood_01.M2", -- [5]
									"Worgen_TownFence_01_Battlegrounds.M2", -- [6]
									"Worgen_TownFence_02_Battlegrounds.M2", -- [7]
									"Worgen_TownFence_03_Battlegrounds.M2", -- [8]
									"Worgen_TownLamp_01_Battlegrounds.M2", -- [9]
								},
								["N"] = "Battleofgilneas",
							}, -- [3]
							{
								["T"] = {
									"Uldum_Brazier.M2", -- [1]
								},
								["N"] = "Braziers",
							}, -- [4]
							{
								["T"] = {
									"Hyjal_Cenarion_Banner_01.M2", -- [1]
									"Hyjal_Cenarion_Banner_02.M2", -- [2]
									"Hyjal_Cenarion_Banner_Burning_01.M2", -- [3]
									"Hyjal_Cenarion_Banner_Burning_02.M2", -- [4]
								},
								["N"] = "Cenarion",
							}, -- [5]
							{
								["T"] = {
									"DarkshoreTree_BaseRoots02.M2", -- [1]
									"DarkshoreTree_BaseRoots03.M2", -- [2]
									"Darkshore_GiantWaterfall01.M2", -- [3]
									"Darkshore_StormTree01.M2", -- [4]
									"Darkshore_StormTree02.M2", -- [5]
									"Darkshore_WaterFall_Dungeon_01.M2", -- [6]
									"Darkshore_WaterFall_Mist01.M2", -- [7]
									"Darkshore_Whirlpool01.M2", -- [8]
									"Darkshore_Whirlpool02.M2", -- [9]
									"Darkshore_Wind_01.M2", -- [10]
									"Duskwood_MageTower_brick.M2", -- [11]
									"Duskwood_MageTower_shingle.M2", -- [12]
									"Malfurion_Darkshore_Cyclone.M2", -- [13]
								},
								["N"] = "Darkshorerework",
							}, -- [6]
							{
								["T"] = {
									"Deathwing_Ash_Test.M2", -- [1]
									"Deathwing_Backplate_Door_Test01.M2", -- [2]
									"Deathwing_Backplate_Test01.M2", -- [3]
									"Deathwing_Backplate_Test02.M2", -- [4]
									"Deathwing_Backplate_Test03.M2", -- [5]
									"Deathwing_Doodad_Head.M2", -- [6]
									"Deathwing_Doodad_Legs.M2", -- [7]
									"Deathwing_Doodad_Tail.M2", -- [8]
									"Deathwing_Doodad_Wings.M2", -- [9]
									"Deathwing_Ember_Test.M2", -- [10]
									"Deathwing_Parts_01.M2", -- [11]
									"Deathwing_Parts_02.M2", -- [12]
									"Deathwing_Parts_03.M2", -- [13]
									"Deathwing_Parts_04.M2", -- [14]
									"Deathwing_Parts_05.M2", -- [15]
									"Deathwing_Parts_06.M2", -- [16]
									"Deathwing_Parts_07.M2", -- [17]
									"Deathwing_bloodpool.M2", -- [18]
								},
								["N"] = "Deathwing",
							}, -- [7]
							{
								["T"] = {
									{
										["T"] = {
											"Deepholm_ArchstoneCombined_01.M2", -- [1]
											"Deepholm_ArchstoneCombined_02.M2", -- [2]
											"Deepholm_ArchstoneFragment_01.M2", -- [3]
											"Deepholm_ArchstoneFragment_02.M2", -- [4]
											"Deepholm_ArchstoneFragment_03.M2", -- [5]
											"Deepholm_Archstone_01.M2", -- [6]
										},
										["N"] = "Archstones",
									}, -- [1]
									{
										["T"] = {
											"Deepholm_Beams_Elbow_01.M2", -- [1]
											"Deepholm_Beams_Elbow_01_Dirty.M2", -- [2]
											"Deepholm_Beams_Short_01.M2", -- [3]
											"Deepholm_Beams_Short_01_Dirty.M2", -- [4]
											"Deepholm_Beams_Tall_01.M2", -- [5]
											"Deepholm_Beams_Tall_01_Dirty.M2", -- [6]
										},
										["N"] = "Beams",
									}, -- [2]
									{
										["T"] = {
											"Deepholm_Boulder01.M2", -- [1]
											"Deepholm_Boulder02.M2", -- [2]
											"Deepholm_Boulder03.M2", -- [3]
											"Deepholm_Boulder04.M2", -- [4]
											"Deepholm_Boulder05.M2", -- [5]
										},
										["N"] = "Boulders",
									}, -- [3]
									{
										["T"] = {
											"Deepholm_CliffPiece01.M2", -- [1]
											"Deepholm_CliffPiece02.M2", -- [2]
											"Deepholm_CliffPiece03.M2", -- [3]
											"Deepholm_CliffPiece04.M2", -- [4]
										},
										["N"] = "Cliff",
									}, -- [4]
									{
										["T"] = {
											"Deepholm_CrystalBlock01.M2", -- [1]
											"Deepholm_CrystalBlock01_Blue.M2", -- [2]
											"Deepholm_CrystalBlock01_Chalk.M2", -- [3]
											"Deepholm_CrystalBlock01_Green.M2", -- [4]
											"Deepholm_CrystalBlock01_Orange.M2", -- [5]
											"Deepholm_CrystalBlock01_Red.M2", -- [6]
											"Deepholm_CrystalBlock01_Silver.M2", -- [7]
											"Deepholm_CrystalBlock02.M2", -- [8]
											"Deepholm_CrystalBlock02_Blue.M2", -- [9]
											"Deepholm_CrystalBlock02_Chalk.M2", -- [10]
											"Deepholm_CrystalBlock02_Green.M2", -- [11]
											"Deepholm_CrystalBlock02_Orange.M2", -- [12]
											"Deepholm_CrystalBlock02_Red.M2", -- [13]
											"Deepholm_CrystalBlock02_Silver.M2", -- [14]
											"Deepholm_CrystalBlock03.M2", -- [15]
											"Deepholm_CrystalBlock03_Blue.M2", -- [16]
											"Deepholm_CrystalBlock03_Chalk.M2", -- [17]
											"Deepholm_CrystalBlock03_Green.M2", -- [18]
											"Deepholm_CrystalBlock03_Orange.M2", -- [19]
											"Deepholm_CrystalBlock03_Red.M2", -- [20]
											"Deepholm_CrystalBlock03_Silver.M2", -- [21]
											"Deepholm_CrystalBlock04.M2", -- [22]
											"Deepholm_CrystalBlock04_Blue.M2", -- [23]
											"Deepholm_CrystalBlock04_Chalk.M2", -- [24]
											"Deepholm_CrystalBlock04_Green.M2", -- [25]
											"Deepholm_CrystalBlock04_Orange.M2", -- [26]
											"Deepholm_CrystalBlock04_Red.M2", -- [27]
											"Deepholm_CrystalBlock04_Silver.M2", -- [28]
											"Deepholm_CrystalBlock05.M2", -- [29]
											"Deepholm_CrystalBlock05_Blue.M2", -- [30]
											"Deepholm_CrystalBlock05_Chalk.M2", -- [31]
											"Deepholm_CrystalBlock05_Green.M2", -- [32]
											"Deepholm_CrystalBlock05_Orange.M2", -- [33]
											"Deepholm_CrystalBlock05_Red.M2", -- [34]
											"Deepholm_CrystalBlock05_Silver.M2", -- [35]
											"Deepholm_CrystalRock01_Blue.M2", -- [36]
											"Deepholm_CrystalRock01_Green.M2", -- [37]
											"Deepholm_CrystalRock01_Orange.M2", -- [38]
											"Deepholm_CrystalRock01_Red.M2", -- [39]
											"Deepholm_CrystalRock01_Silver.M2", -- [40]
											"Deepholm_CrystalRock02_Blue.M2", -- [41]
											"Deepholm_CrystalRock02_Green.M2", -- [42]
											"Deepholm_CrystalRock02_Mossy.M2", -- [43]
											"Deepholm_CrystalRock02_Orange.M2", -- [44]
											"Deepholm_CrystalRock02_Red.M2", -- [45]
											"Deepholm_CrystalRock02_Silver.M2", -- [46]
											"Deepholm_CrystalRock03_Blue.M2", -- [47]
											"Deepholm_CrystalRock03_Green.M2", -- [48]
											"Deepholm_CrystalRock03_Mossy.M2", -- [49]
											"Deepholm_CrystalRock03_Orange.M2", -- [50]
											"Deepholm_CrystalRock03_Red.M2", -- [51]
											"Deepholm_CrystalRock03_Silver.M2", -- [52]
											"Deepholm_CrystalRock04_Blue.M2", -- [53]
											"Deepholm_CrystalRock04_Green.M2", -- [54]
											"Deepholm_CrystalRock04_Orange.M2", -- [55]
											"Deepholm_CrystalRock04_Red.M2", -- [56]
											"Deepholm_CrystalRock04_Silver.M2", -- [57]
											"Deepholm_CrystalRock05_Blue.M2", -- [58]
											"Deepholm_CrystalRock05_Green.M2", -- [59]
											"Deepholm_CrystalRock05_Orange.M2", -- [60]
											"Deepholm_CrystalRock05_Red.M2", -- [61]
											"Deepholm_CrystalRock05_Silver.M2", -- [62]
											"Deepholm_Crystalrock01_Mossy.M2", -- [63]
											"Deepholm_Crystals01.M2", -- [64]
											"Deepholm_Crystals02.M2", -- [65]
											"Deepholm_Crystals03.M2", -- [66]
											"Deepholm_Crystals04.M2", -- [67]
											"Deepholm_Crystals05.M2", -- [68]
											"Deepholm_Crystals06.M2", -- [69]
											"Deepholm_Crystals07.M2", -- [70]
											"Deepholm_Crystals08.M2", -- [71]
											"Deepholm_Crystals09.M2", -- [72]
											"Deepholm_Crystals11.M2", -- [73]
											"Deepholm_Crystals12.M2", -- [74]
											"Deepholm_Crystals13.M2", -- [75]
											"Deepholm_Crystals14.M2", -- [76]
											"Deepholm_Crystals15.M2", -- [77]
											"Deepholm_Crystals16.M2", -- [78]
											"Deepholm_Crystals17.M2", -- [79]
											"Deepholm_Crystals18.M2", -- [80]
											"Deepholm_Crystals19.M2", -- [81]
											"Deepholm_Crystals20.M2", -- [82]
										},
										["N"] = "Crystals",
									}, -- [5]
									{
										["T"] = {
											"Deepholm_Gems01.M2", -- [1]
											"Deepholm_Gems02.M2", -- [2]
											"Deepholm_Gems03.M2", -- [3]
											"Deepholm_Gems04.M2", -- [4]
										},
										["N"] = "Gems",
									}, -- [6]
									{
										["T"] = {
											"DeepHolm_BluGrenBrtGlow_01.M2", -- [1]
											"DeepHolm_BluGrenGlow_01.M2", -- [2]
											"DeepHolm_BlueGlow_01.M2", -- [3]
											"DeepHolm_DkBlueGlow_01.M2", -- [4]
											"DeepHolm_DkBlueRedGlow_01.M2", -- [5]
											"DeepHolm_PurpleGlow_01.M2", -- [6]
											"DeepHolm_RedGlow_01.M2", -- [7]
										},
										["N"] = "Glow",
									}, -- [7]
									{
										["T"] = {
											"Deepholm_MercuryDrip01.M2", -- [1]
											"Deepholm_MercuryDrip02.M2", -- [2]
											"Deepholm_MercuryPool01.M2", -- [3]
											"Deepholm_MercuryPool02.M2", -- [4]
											"Deepholm_MercuryPool03.M2", -- [5]
											"Deepholm_MercuryPool04.M2", -- [6]
											"Deepholm_MercuryPool05.M2", -- [7]
											"Deepholm_MercuryPool06.M2", -- [8]
											"Deepholm_MercuryPool07.M2", -- [9]
											"Deepholm_MercuryPool08.M2", -- [10]
											"Deepholm_MercuryPool09.M2", -- [11]
											"Deepholm_MercuryPool10.M2", -- [12]
											"Deepholm_TarPit01.M2", -- [13]
										},
										["N"] = "Mercurypools",
									}, -- [8]
									{
										["T"] = {
											"Deepholm_MineralBridge01.M2", -- [1]
											"Deepholm_MineralColumn01_Chalk.M2", -- [2]
											"Deepholm_MineralColumn01_Mossy.M2", -- [3]
											"Deepholm_MineralColumn01_VFX.M2", -- [4]
											"Deepholm_MineralColumn02_Broken.M2", -- [5]
											"Deepholm_MineralColumn02_Chalk.M2", -- [6]
											"Deepholm_MineralColumn03_Chalk.M2", -- [7]
											"Deepholm_MineralColumn03_VFX.M2", -- [8]
											"Deepholm_MineralColumn04_Chalk.M2", -- [9]
											"Deepholm_MineralColumn04_VFX.M2", -- [10]
											"Deepholm_MineralColumn05_Chalk.M2", -- [11]
											"Deepholm_MineralColumn06_Chalk.M2", -- [12]
											"Deepholm_MineralCrystal01_Blue.M2", -- [13]
											"Deepholm_MineralCrystal01_Chalk.M2", -- [14]
											"Deepholm_MineralCrystal01_Green.M2", -- [15]
											"Deepholm_MineralCrystal01_Orange.M2", -- [16]
											"Deepholm_MineralCrystal01_Red.M2", -- [17]
											"Deepholm_MineralCrystal01_Silver.M2", -- [18]
											"Deepholm_MineralCrystal02_Blue.M2", -- [19]
											"Deepholm_MineralCrystal02_Chalk.M2", -- [20]
											"Deepholm_MineralCrystal02_Green.M2", -- [21]
											"Deepholm_MineralCrystal02_Orange.M2", -- [22]
											"Deepholm_MineralCrystal02_Red.M2", -- [23]
											"Deepholm_MineralCrystal02_Silver.M2", -- [24]
											"Deepholm_MineralRocks01.M2", -- [25]
											"Deepholm_MineralRocks02.M2", -- [26]
											"Deepholm_MineralRocks03.M2", -- [27]
											"Deepholm_MineralRocks04.M2", -- [28]
											"Deepholm_MineralRocks05.M2", -- [29]
											"Deepholm_MineralRocks06.M2", -- [30]
											"Deepholm_MineralRocks07.M2", -- [31]
											"Deepholm_MineralRocks08.M2", -- [32]
											"Deepholm_MineralRocks09.M2", -- [33]
											"Deepholm_MineralRocks10.M2", -- [34]
											"Deepholm_MineralRocks11.M2", -- [35]
											"Deepholm_MineralRocks12.M2", -- [36]
											"Deepholm_MineralRocks13.M2", -- [37]
											"Deepholm_MineralRocks14.M2", -- [38]
											"Deepholm_MineralRocks15.M2", -- [39]
											"Deepholm_MineralRocks16.M2", -- [40]
											"Deepholm_MineralRocks17.M2", -- [41]
											"Deepholm_MineralRocks18.M2", -- [42]
											"Deepholm_MineralRocks18_Mossy.M2", -- [43]
											"Deepholm_MineralRocks19.M2", -- [44]
											"Deepholm_MineralRocks19_Mossy.M2", -- [45]
											"Deepholm_MineralRocks20.M2", -- [46]
											"Deepholm_MineralRocks21.M2", -- [47]
											"Deepholm_MineralRocks22.M2", -- [48]
											"Deepholm_MineralRocks23.M2", -- [49]
											"Deepholm_MineralRocks24.M2", -- [50]
											"Deepholm_MineralRocks25.M2", -- [51]
											"Deepholm_MineralRocks26.M2", -- [52]
											"Deepholm_MineralRocks27.M2", -- [53]
											"Deepholm_MineralRocks28.M2", -- [54]
											"Deepholm_MineralRocks28_Top.M2", -- [55]
											"Deepholm_MineralRocks29.M2", -- [56]
											"Deepholm_MineralRocks29_Top.M2", -- [57]
											"Deepholm_MineralRocks30.M2", -- [58]
											"Deepholm_MineralRocks30_Top.M2", -- [59]
											"Deepholm_MineralRocks31.M2", -- [60]
											"Deepholm_MineralRocks31_Broken.M2", -- [61]
											"Deepholm_MineralRocks32.M2", -- [62]
											"Deepholm_MineralRocks33.M2", -- [63]
										},
										["N"] = "Minerals",
									}, -- [9]
									{
										["T"] = {
											"Deepholm_MoltenSphere01.M2", -- [1]
										},
										["N"] = "Moltensphere",
									}, -- [10]
									{
										["T"] = {
											"DeepHolm_Small_Moth_01.M2", -- [1]
										},
										["N"] = "Moths",
									}, -- [11]
									{
										["T"] = {
											"Deepholm_MossyMushroom01.M2", -- [1]
											"Deepholm_MossyMushroom02.M2", -- [2]
											"Deepholm_MushroomGroup01.M2", -- [3]
											"Deepholm_MushroomGroup02.M2", -- [4]
											"Deepholm_MushroomGroup03.M2", -- [5]
											"Deepholm_MushroomGroup04.M2", -- [6]
											"Deepholm_MushroomGroup05.M2", -- [7]
											"Deepholm_MushroomGroup06.M2", -- [8]
											"Deepholm_Mushrooms01.M2", -- [9]
											"Deepholm_Mushrooms02.M2", -- [10]
											"Deepholm_Mushrooms03.M2", -- [11]
											"Deepholm_Mushrooms04.M2", -- [12]
											"Deepholm_Mushrooms05.M2", -- [13]
											"Deepholm_Mushrooms06.M2", -- [14]
											"Deepholm_Mushrooms07.M2", -- [15]
											"Deepholm_Mushrooms08.M2", -- [16]
											"Deepholm_Mushrooms09.M2", -- [17]
											"Deepholm_Mushrooms10.M2", -- [18]
											"Deepholm_SkinnyShroom01.M2", -- [19]
											"Deepholm_SkinnyShroom02.M2", -- [20]
											"Deepholm_SkinnyShroom03.M2", -- [21]
											"Deepholm_SkinnyShroom04.M2", -- [22]
											"Deepholm_SkinnyShroom05.M2", -- [23]
											"Deepholm_SkinnyShroom05_Silver.M2", -- [24]
											"Deepholm_SkinnyShroom06.M2", -- [25]
											"Deepholm_SkinnyShroom06_Silver.M2", -- [26]
											"Deepholm_SkinnyShroom07.M2", -- [27]
											"Deepholm_SkinnyShroom07_Silver.M2", -- [28]
											"Deepholm_SkinnyShroom08.M2", -- [29]
											"Deepholm_SkinnyShroom08_Silver.M2", -- [30]
											"Deepholm_SkinnyShroomGroup01.M2", -- [31]
											"Deepholm_SkinnyShroomGroup02.M2", -- [32]
											"Deepholm_SkinnyShroomGroup03.M2", -- [33]
											"Deepholm_SkinnyShroomGroup04.M2", -- [34]
											"Deepholm_SkinnyShroomGroup04_Silver.M2", -- [35]
											"Deepholm_SkinnyShroomGroup05.M2", -- [36]
											"Deepholm_SkinnyShroomGroup05_Silver.M2", -- [37]
											"Deepholm_SkinnyShroomGroup06.M2", -- [38]
											"Deepholm_SkinnyShroomGroup06_Silver.M2", -- [39]
										},
										["N"] = "Mushrooms",
									}, -- [12]
									{
										["T"] = {
											"Deepholm_DustStreak_Rock01.M2", -- [1]
											"Deepholm_FloatingRock04_Angle.M2", -- [2]
											"Deepholm_FloatingRock05_Angle.M2", -- [3]
											"Deepholm_FloatingRock06_Angle.M2", -- [4]
											"Deepholm_FloatingRocks04.M2", -- [5]
											"Deepholm_FloatingRocks05.M2", -- [6]
											"Deepholm_FloatingRocks07.M2", -- [7]
											"Deepholm_FloatingRocks08.M2", -- [8]
											"Deepholm_FloatingRocks09.M2", -- [9]
											"Deepholm_FloatingSmall01.M2", -- [10]
											"Deepholm_FloatingSmall02.M2", -- [11]
											"Deepholm_FloatingSmall02_Blue.M2", -- [12]
											"Deepholm_FloatingSmall02_Chalk.M2", -- [13]
											"Deepholm_FloatingSmall02_Green.M2", -- [14]
											"Deepholm_FloatingSmall02_Orange.M2", -- [15]
											"Deepholm_FloatingSmall02_Red.M2", -- [16]
											"Deepholm_FloatingSmall02_Silver.M2", -- [17]
											"Deepholm_FloatingSmall03_Blue.M2", -- [18]
											"Deepholm_FloatingSmall03_Chalk.M2", -- [19]
											"Deepholm_FloatingSmall03_Green.M2", -- [20]
											"Deepholm_FloatingSmall03_Orange.M2", -- [21]
											"Deepholm_FloatingSmall03_Red.M2", -- [22]
											"Deepholm_FloatingSmall03_Silver.M2", -- [23]
											"Deepholm_PulsingRockLight01_Green.M2", -- [24]
											"Deepholm_PulsingRockLight01_Red.M2", -- [25]
											"Deepholm_Rock01.M2", -- [26]
											"Deepholm_Rock01_Chalk.M2", -- [27]
											"Deepholm_Rock02.M2", -- [28]
											"Deepholm_Rock02_Chalk.M2", -- [29]
											"Deepholm_Rock03.M2", -- [30]
											"Deepholm_Rock03_Chalk.M2", -- [31]
											"Deepholm_Rock04.M2", -- [32]
											"Deepholm_Rock04_Chalk.M2", -- [33]
											"Deepholm_RockGeode01.M2", -- [34]
											"Deepholm_RockGeode02.M2", -- [35]
											"Deepholm_RockGeode03.M2", -- [36]
											"Deepholm_RockGeode04.M2", -- [37]
											"Deepholm_RockGeode05.M2", -- [38]
											"Deepholm_RockGeode06.M2", -- [39]
										},
										["N"] = "Rocks",
									}, -- [13]
									{
										["T"] = {
											"Deepholm_Scaffold_01.M2", -- [1]
											"Deepholm_Scaffold_02.M2", -- [2]
											"Deepholm_Scaffold_03.M2", -- [3]
											"Deepholm_Scaffold_Corner_01.M2", -- [4]
											"Deepholm_Scaffold_Corner_02.M2", -- [5]
											"Deepholm_Scaffold_Corner_03.M2", -- [6]
										},
										["N"] = "Scaffolding",
									}, -- [14]
									{
										["T"] = {
											"Deepholm_ShellSpike_01.M2", -- [1]
											"Deepholm_ShellSpike_02.M2", -- [2]
										},
										["N"] = "Shellspikes",
									}, -- [15]
									{
										["T"] = {
											"Deepholm_Sparkles01.M2", -- [1]
										},
										["N"] = "Sparkles",
									}, -- [16]
									{
										["T"] = {
											"Deepholm_Spike_Large_01.M2", -- [1]
										},
										["N"] = "Spikes",
									}, -- [17]
									{
										["T"] = {
											"Deepholm_Stalagmite01.M2", -- [1]
											"Deepholm_Stalagmite02.M2", -- [2]
											"Deepholm_Stalagmite03.M2", -- [3]
										},
										["N"] = "Stalagmites",
									}, -- [18]
									{
										["T"] = {
											"Deepholm_Stalagtite01.M2", -- [1]
											"Deepholm_Stalagtite02.M2", -- [2]
										},
										["N"] = "Stalagtites",
									}, -- [19]
									{
										["T"] = {
											"Deepholm_Striations01.M2", -- [1]
											"Deepholm_Striations02.M2", -- [2]
											"Deepholm_Striations03.M2", -- [3]
											"Deepholm_Striations04.M2", -- [4]
										},
										["N"] = "Striations",
									}, -- [20]
									{
										["T"] = {
											"Deepholm_WindTunnelPillar01.M2", -- [1]
											"Deepholm_WindTunnelPillar02.M2", -- [2]
											"Deepholm_WindTunnelStriations01.M2", -- [3]
										},
										["N"] = "Windtunnel",
									}, -- [21]
									"Deepholm_DeathwingAfterglow.M2", -- [22]
									"Deepholm_MineralColumn01.M2", -- [23]
									"Deepholm_MineralColumn01_NoBase.M2", -- [24]
									"Deepholm_MineralColumn02.M2", -- [25]
									"Deepholm_MineralColumn02_NoBase.M2", -- [26]
									"Deepholm_MineralColumn03.M2", -- [27]
									"Deepholm_MineralColumn04.M2", -- [28]
									"Deepholm_MineralColumn05.M2", -- [29]
									"Deepholm_MineralColumn06.M2", -- [30]
									"Deepholm_Rockdoor_Break.M2", -- [31]
									"Deepholm_Rockwall.M2", -- [32]
									"Deepholm_TherazaneThrone.M2", -- [33]
									"Deepholm_cluster.M2", -- [34]
									"Stonecore_Altar.M2", -- [35]
									"Therazane_Crystal_01.M2", -- [36]
									"Therazane_Crystal_02.M2", -- [37]
									"Therazane_Crystal_03.M2", -- [38]
									"Therazane_Crystal_04.M2", -- [39]
									"Therazane_Crystal_05.M2", -- [40]
								},
								["N"] = "Deepholm",
							}, -- [8]
							{
								["T"] = {
									{
										["T"] = {
											"Desolace_DruidBranch_Large01.M2", -- [1]
											"Desolace_DruidBranch_Small01.M2", -- [2]
											"Desolace_DruidRoot_01.M2", -- [3]
											"Desolace_DruidRoot_02.M2", -- [4]
											"Desolace_DruidRoot_03.M2", -- [5]
											"Desolace_DruidTree_01.M2", -- [6]
											"Desolace_DruidTree_02.M2", -- [7]
											"Desolace_DruidTree_03.M2", -- [8]
										},
										["N"] = "Desolacetrees",
									}, -- [1]
								},
								["N"] = "Desolace",
							}, -- [9]
							{
								["T"] = {
									"DB_IceWallDoor_01.M2", -- [1]
								},
								["N"] = "Doors",
							}, -- [10]
							{
								["T"] = {
									{
										["T"] = {
											"Dragonmaw_Banner01.M2", -- [1]
											"Dragonmaw_Banner02.M2", -- [2]
										},
										["N"] = "Banners",
									}, -- [1]
									{
										["T"] = {
											"Dragonmaw_DragonButchered_01.M2", -- [1]
											"Dragonmaw_DragonButchered_02.M2", -- [2]
											"Dragonmaw_DragonButchered_03.M2", -- [3]
											"Dragonmaw_DragonButchered_04.M2", -- [4]
										},
										["N"] = "Dragonbutchered",
									}, -- [2]
									{
										["T"] = {
											"Dragonmaw_TrophyFrame01.M2", -- [1]
											"Dragonmaw_TrophyFrame02.M2", -- [2]
											"Dragonmaw_TrophyPole01.M2", -- [3]
											"Dragonmaw_TrophyPole02.M2", -- [4]
											"Dragonmaw_TrophyPole03.M2", -- [5]
											"Dragonmaw_TrophyPole04.M2", -- [6]
											"Dragonmaw_TrophyPole05.M2", -- [7]
											"Dragonmaw_TrophyPole06.M2", -- [8]
											"Dragonmaw_TrophyPole07.M2", -- [9]
											"Dragonmaw_TrophyPole08.M2", -- [10]
											"Dragonmaw_TrophyPole09.M2", -- [11]
										},
										["N"] = "Trophies",
									}, -- [3]
									{
										["T"] = {
											"Dragonmaw_Weapon01.M2", -- [1]
											"Dragonmaw_Weapon02.M2", -- [2]
											"Dragonmaw_Weapon03.M2", -- [3]
										},
										["N"] = "Weapons",
									}, -- [4]
									"Dragonmaw_OrcTent01.M2", -- [5]
									"Dragonmaw_OrcWagon01.M2", -- [6]
									"Dragonmaw_OrcWagon02.M2", -- [7]
									"Dragonmaw_OrcWagon05.M2", -- [8]
									"Dragonmaw_Outpost01.M2", -- [9]
									"Dragonmaw_Outpost01_A.M2", -- [10]
									"Dragonmaw_Outpost01_B.M2", -- [11]
									"Dragonmaw_Outpost02.M2", -- [12]
									"Dragonmaw_Outpost02_A.M2", -- [13]
									"Dragonmaw_Outpost03.M2", -- [14]
									"Dragonmaw_Outpost03_A.M2", -- [15]
									"Dragonmaw_Outpost04.M2", -- [16]
									"Dragonmaw_Outpost05.M2", -- [17]
									"Dragonmaw_Outpost06.M2", -- [18]
									"Dragonmaw_Outpost07.M2", -- [19]
									"Dragonmaw_Outpost07_A.M2", -- [20]
									"Dragonmaw_Outpost08.M2", -- [21]
									"Dragonmaw_Outpost08_A.M2", -- [22]
									"Dragonmaw_SwampBoat01.M2", -- [23]
									"Dragonmaw_barrel_04.M2", -- [24]
									"Dragonmaw_crate_01.M2", -- [25]
									"Dragonmaw_crate_02.M2", -- [26]
									"Dragonmaw_crate_07.M2", -- [27]
									"Dragonmaw_crate_09.M2", -- [28]
									"Dragonmaw_crate_10.M2", -- [29]
									"Dragonmaw_supplies_01.M2", -- [30]
									"Dragonmaw_supplies_02.M2", -- [31]
									"Dragonmaw_supplies_03.M2", -- [32]
								},
								["N"] = "Dragonmaw",
							}, -- [11]
							{
								["T"] = {
									{
										["T"] = {
											"Earthen_Rock_Banner_01.M2", -- [1]
											"Earthen_Rock_Banner_02.M2", -- [2]
											"Earthen_Rock_Banner_03.M2", -- [3]
										},
										["N"] = "Banners",
									}, -- [1]
									{
										["T"] = {
											"Earthen_Building_01.M2", -- [1]
											"Earthen_Building_02.M2", -- [2]
										},
										["N"] = "Buildings",
									}, -- [2]
									{
										["T"] = {
											"Earthen_Fence_01.M2", -- [1]
											"Earthen_Fence_02.M2", -- [2]
											"Earthen_Fence_03.M2", -- [3]
											"Earthen_Fence_04.M2", -- [4]
											"Earthen_Fence_Post_01.M2", -- [5]
										},
										["N"] = "Fence",
									}, -- [3]
									{
										["T"] = {
											"Earthen_Portal_Deepholm.M2", -- [1]
											"Earthen_Portal_Hyjal.M2", -- [2]
											"Earthen_Portal_Twilight_Highlands.M2", -- [3]
											"Earthen_Portal_Uldum.M2", -- [4]
											"Earthen_Portal_Vashjir.M2", -- [5]
										},
										["N"] = "Portal",
									}, -- [4]
									"Earten_Crate_01.M2", -- [5]
									"Earten_Crate_02.M2", -- [6]
									"Earten_Crate_Lid_.M2", -- [7]
									"Earthen_Floor_01.M2", -- [8]
									"Earthen_Light_01.M2", -- [9]
									"Earthen_Light_02.M2", -- [10]
									"Earthen_Onager_01.M2", -- [11]
									"Earthen_Onager_Arm.M2", -- [12]
									"Earthen_Onager_Beam_01.M2", -- [13]
									"Earthen_Onager_Beam_02.M2", -- [14]
									"Earthen_Onager_Trunk_01.M2", -- [15]
									"Earthen_Onager_Trunk_02.M2", -- [16]
									"Earthen_Onager_Wheel_01.M2", -- [17]
									"Earthen_Projectile_01.M2", -- [18]
									"Earthen_Pylon_01.M2", -- [19]
									"Earthen_Pylon_02.M2", -- [20]
									"Earthen_Pylon_03.M2", -- [21]
									"Earthen_Pylon_04.M2", -- [22]
									"Earthen_Wagon_01.M2", -- [23]
									"Org_Earthen_Floor_01.M2", -- [24]
									"Org_Earthen_Pylon_01.M2", -- [25]
									"Org_Earthen_Pylon_02.M2", -- [26]
									"Org_Earthen_Pylon_03.M2", -- [27]
									"Org_Earthen_Pylon_04.M2", -- [28]
									"Twilightshammer_Earthen_Floor_01.M2", -- [29]
									"Twilightshammer_Earthen_Pylon_01.M2", -- [30]
									"Twilightshammer_Earthen_Pylon_02.M2", -- [31]
									"Twilightshammer_Earthen_Pylon_03.M2", -- [32]
									"Twilightshammer_Earthen_Pylon_04.M2", -- [33]
								},
								["N"] = "Earthen",
							}, -- [12]
							{
								["T"] = {
									{
										["T"] = {
											"Firelands_BrazierFlame_Big_01.M2", -- [1]
											"Firelands_BrazierFlame_Big_02.M2", -- [2]
										},
										["N"] = "Brazierflame_big",
									}, -- [1]
									{
										["T"] = {
											"Firelands_Breakable_Rock_Platform_01.M2", -- [1]
										},
										["N"] = "Breakable_rock_platform",
									}, -- [2]
									{
										["T"] = {
											"Firelands_BridgeFX.M2", -- [1]
											"Firelands_BridgeFX_Empty.M2", -- [2]
										},
										["N"] = "Bridgefx",
									}, -- [3]
									{
										["T"] = {
											"Firelands_CanopyGlow.M2", -- [1]
										},
										["N"] = "Canopyglow",
									}, -- [4]
									{
										["T"] = {
											"Firelands_CanopyWeb1.M2", -- [1]
											"Firelands_CanopyWeb1_Burning.M2", -- [2]
										},
										["N"] = "Canopyweb",
									}, -- [5]
									{
										["T"] = {
											"Chest_Sulfuron.M2", -- [1]
										},
										["N"] = "Chest",
									}, -- [6]
									{
										["T"] = {
											"Firelands_Door_01.M2", -- [1]
										},
										["N"] = "Door",
									}, -- [7]
									{
										["T"] = {
											"Firelands_Druid_Fire_Portal.M2", -- [1]
										},
										["N"] = "Druid_fire_portal",
									}, -- [8]
									{
										["T"] = {
											"Firelands_Druid_Hyjal_Portal.M2", -- [1]
										},
										["N"] = "Druid_hyjal_portal",
									}, -- [9]
									{
										["T"] = {
											"Firelands_Druid_Portal.M2", -- [1]
										},
										["N"] = "Druid_portal",
									}, -- [10]
									{
										["T"] = {
											"Firelands_druidtree_stage03_canopy.M2", -- [1]
											"firelands_druidtree_scale.M2", -- [2]
											"firelands_druidtree_supports.M2", -- [3]
										},
										["N"] = "Druidtree",
									}, -- [11]
									{
										["T"] = {
											"Firelands_Embers_01.M2", -- [1]
										},
										["N"] = "Embers",
									}, -- [12]
									{
										["T"] = {
											"FL_Fire_FX_01.M2", -- [1]
											"FL_Fire_FX_02.M2", -- [2]
											"FL_Fire_FX_03.M2", -- [3]
											"FL_Fire_FX_04.M2", -- [4]
											"FL_Fire_FX_05.M2", -- [5]
											"FL_Fire_FX_06.M2", -- [6]
											"FL_Fire_FX_07.M2", -- [7]
											"FL_Fire_FX_08.M2", -- [8]
											"FL_Fire_FX_09.M2", -- [9]
											"FL_Fire_FX_10.M2", -- [10]
											"FL_Fire_FX_11.M2", -- [11]
											"FL_Fire_FX_12.M2", -- [12]
											"FL_Fire_FX_13.M2", -- [13]
										},
										["N"] = "Fire",
									}, -- [13]
									{
										["T"] = {
											"FirelandsSky_Fireball02.M2", -- [1]
										},
										["N"] = "Fireball",
									}, -- [14]
									{
										["T"] = {
											"Firelands_FireClouds.M2", -- [1]
										},
										["N"] = "Fireclouds",
									}, -- [15]
									{
										["T"] = {
											"Firelands_FireEffect_01.M2", -- [1]
										},
										["N"] = "Fireeffect",
									}, -- [16]
									{
										["T"] = {
											"Firelands_Gate_end.M2", -- [1]
										},
										["N"] = "Firelands_gate",
									}, -- [17]
									{
										["T"] = {
											"Firelands_FireWaterfalls_01.M2", -- [1]
										},
										["N"] = "Firewaterfalls",
									}, -- [18]
									{
										["T"] = {
											"Firelands_FireWaterfalls_Bottom_01.M2", -- [1]
										},
										["N"] = "Firewaterfalls_bottom",
									}, -- [19]
									{
										["T"] = {
											"Firelands_FireWaterfalls_Large_01.M2", -- [1]
										},
										["N"] = "Firewaterfalls_large",
									}, -- [20]
									{
										["T"] = {
											"Firelands_FloatingMoth_01.M2", -- [1]
										},
										["N"] = "Floatingmoth",
									}, -- [21]
									{
										["T"] = {
											"Firelands_FloatingRockSmall01.M2", -- [1]
											"Firelands_FloatingRockSmall02.M2", -- [2]
											"Firelands_FloatingRockSmall03.M2", -- [3]
											"Firelands_FloatingRockSmall04.M2", -- [4]
											"Firelands_FloatingRock_01.M2", -- [5]
											"Firelands_FloatingRock_02.M2", -- [6]
											"Firelands_FloatingRock_03.M2", -- [7]
											"Firelands_FloatingRock_04.M2", -- [8]
											"Firelands_FloatingRock_05.M2", -- [9]
										},
										["N"] = "Floatingrocks",
									}, -- [22]
									{
										["T"] = {
											"FirelandsFogSphere.M2", -- [1]
										},
										["N"] = "Fogsphere",
									}, -- [23]
									{
										["T"] = {
											"GlobeOfAzeroth.M2", -- [1]
										},
										["N"] = "Globeofazeroth",
									}, -- [24]
									{
										["T"] = {
											"Firelands_LavaFissure01.M2", -- [1]
											"Firelands_LavaFissure02.M2", -- [2]
											"Firelands_LavaFissure03.M2", -- [3]
											"Firelands_LavaFissure04.M2", -- [4]
											"Firelands_LavaFissure05.M2", -- [5]
											"Firelands_Lava_Ball_01.M2", -- [6]
											"Firelands_Lava_Ball_02.M2", -- [7]
										},
										["N"] = "Lava",
									}, -- [25]
									{
										["T"] = {
											"Firelands_Lava_Splash_01.M2", -- [1]
											"Firelands_Lava_Splash_Particle_01.M2", -- [2]
										},
										["N"] = "Lava_splash",
									}, -- [26]
									{
										["T"] = {
											"firelands_lavaboss_bridge_creation.M2", -- [1]
											"firelands_lavaboss_bridge_destruction.M2", -- [2]
										},
										["N"] = "Lavaboss_bridge",
									}, -- [27]
									{
										["T"] = {
											"Firelands_LavaBoss_Bridge_Anim.M2", -- [1]
										},
										["N"] = "Lavaboss_bridge_anim",
									}, -- [28]
									{
										["T"] = {
											"Firelands_lavaboss_platform_FX.M2", -- [1]
										},
										["N"] = "Lavaboss_platform",
									}, -- [29]
									{
										["T"] = {
											"Firelands_LavaFalls_01.M2", -- [1]
											"Firelands_LavaFalls_02.M2", -- [2]
											"Firelands_LavaFalls_Custom_01.M2", -- [3]
											"Firelands_LavaFalls_Custom_02.M2", -- [4]
											"Firelands_LavaFalls_Custom_03.M2", -- [5]
											"Firelands_LavaFalls_Custom_04.M2", -- [6]
											"Firelands_LavaFalls_Custom_05.M2", -- [7]
											"Firelands_LavaFalls_Custom_06.M2", -- [8]
											"Firelands_LavaFalls_Custom_07.M2", -- [9]
											"Firelands_LavaFalls_Custom_08.M2", -- [10]
										},
										["N"] = "Lavafalls",
									}, -- [30]
									{
										["T"] = {
											"Firelands_LavaPool.M2", -- [1]
											"Firelands_LavaPool_Explode_lava.M2", -- [2]
											"Firelands_LavaPool_Hard.M2", -- [3]
											"Firelands_LavaPool_Hard_LavaHole.M2", -- [4]
										},
										["N"] = "Lavapool",
									}, -- [31]
									{
										["T"] = {
											"Firelands_LavaPool_FireRing.M2", -- [1]
										},
										["N"] = "Lavapool_firering",
									}, -- [32]
									{
										["T"] = {
											"Firelands_MiniVolcano_Doodad_01.M2", -- [1]
										},
										["N"] = "Minivolcano_doodad",
									}, -- [33]
									{
										["T"] = {
											"Firelands_MiniVolcano_Smoke_01.M2", -- [1]
										},
										["N"] = "Minivolcano_smoke",
									}, -- [34]
									{
										["T"] = {
											"Firelands_OverhangRock_Large_01.M2", -- [1]
											"Firelands_OverhangRock_Large_02.M2", -- [2]
											"Firelands_OverhangRock_Small_01.M2", -- [3]
											"Firelands_OverhangRock_Small_02.M2", -- [4]
											"Firelands_OverhangRock_Small_03.M2", -- [5]
										},
										["N"] = "Overhangrock",
									}, -- [35]
									{
										["T"] = {
											"firelands_phoenixshell_FX1.M2", -- [1]
										},
										["N"] = "Phoenixshell_fx",
									}, -- [36]
									{
										["T"] = {
											"Ragnaros_Firewall.M2", -- [1]
										},
										["N"] = "Ragnaros_firewall",
									}, -- [37]
									{
										["T"] = {
											"Firelands_Rock01.M2", -- [1]
											"Firelands_Rock02.M2", -- [2]
											"Firelands_Rock03.M2", -- [3]
											"Firelands_Rock04.M2", -- [4]
											"Firelands_Rock05.M2", -- [5]
											"Firelands_Rock06.M2", -- [6]
											"Firelands_Rock07.M2", -- [7]
											"firelands_flatrock_01.M2", -- [8]
											"firelands_flatrock_02.M2", -- [9]
											"firelands_flatrock_03.M2", -- [10]
											"firelands_flatrock_04.M2", -- [11]
											"firelands_flatrock_05.M2", -- [12]
											"firelands_flatrock_06.M2", -- [13]
											"firelands_hexrock01.M2", -- [14]
											"firelands_hexrock02.M2", -- [15]
											"firelands_hexrock03.M2", -- [16]
											"firelands_hexrock04.M2", -- [17]
											"firelands_hexrock05.M2", -- [18]
											"firelands_hexrock06.M2", -- [19]
											"firelands_hexrock07.M2", -- [20]
											"firelands_hexrock08.M2", -- [21]
											"firelands_hexrock09.M2", -- [22]
											"firelands_hexrock10.M2", -- [23]
											"firelands_hexrock11.M2", -- [24]
											"firelands_hexrock12.M2", -- [25]
											"firelands_hexrock13.M2", -- [26]
											"firelands_hexrock14.M2", -- [27]
											"firelands_hexrock15.M2", -- [28]
											"firelands_hexrock16.M2", -- [29]
											"firelands_hexrock17.M2", -- [30]
											"firelands_hexrock18.M2", -- [31]
										},
										["N"] = "Rocks",
									}, -- [38]
									{
										["T"] = {
											"Firelands_Roots.M2", -- [1]
										},
										["N"] = "Roots",
									}, -- [39]
									{
										["T"] = {
											"FirelandsSky_Fireball01.M2", -- [1]
											"FirelandsSky_Fireball_Basic.M2", -- [2]
										},
										["N"] = "Sky_fireball",
									}, -- [40]
									{
										["T"] = {
											"Firelands_HugeSmoke01.M2", -- [1]
											"Firelands_HugeSmoke02.M2", -- [2]
										},
										["N"] = "Smoke",
									}, -- [41]
									{
										["T"] = {
											"Firelands_SmokeFog.M2", -- [1]
										},
										["N"] = "Smokefog",
									}, -- [42]
									{
										["T"] = {
											"firelands_sulfuronkeep_door.M2", -- [1]
										},
										["N"] = "Sulfuronkeep_door",
									}, -- [43]
									{
										["T"] = {
											"Firelands_SulfuronTowerFlame.M2", -- [1]
										},
										["N"] = "Sulfurontowerflame",
									}, -- [44]
									{
										["T"] = {
											"Firelands_Throne_FX.M2", -- [1]
										},
										["N"] = "Throne_fx",
									}, -- [45]
									{
										["T"] = {
											"Firelands_destructible_tower01_FX1.M2", -- [1]
										},
										["N"] = "Tower",
									}, -- [46]
									{
										["T"] = {
											"Firelands_TowerFlame01.M2", -- [1]
										},
										["N"] = "Towerflame",
									}, -- [47]
									{
										["T"] = {
											"Firelands_Volcano_Doodad.M2", -- [1]
											"Firelands_Volcano_Doodad_active.M2", -- [2]
										},
										["N"] = "Volcano",
									}, -- [48]
									{
										["T"] = {
											"Firelands_VolcanoEruption_01.M2", -- [1]
										},
										["N"] = "Volcanoeruption",
									}, -- [49]
									{
										["T"] = {
											"Firelands_VolcanoExplosion_01.M2", -- [1]
										},
										["N"] = "Volcanoexplosion",
									}, -- [50]
									{
										["T"] = {
											"Firelands_WebbedCreature_01.M2", -- [1]
											"Firelands_WebbedCreature_02.M2", -- [2]
											"Firelands_WebbedCreature_03.M2", -- [3]
										},
										["N"] = "Webbedcreature",
									}, -- [51]
									{
										["T"] = {
											"Firelands_WebDoor_01.M2", -- [1]
										},
										["N"] = "Webdoor",
									}, -- [52]
									{
										["T"] = {
											"Firelands_WebDoor_Frame_01.M2", -- [1]
										},
										["N"] = "Webdoor_frame",
									}, -- [53]
									{
										["T"] = {
											"Firelands_SpiderEgg01.M2", -- [1]
											"Firelands_SpiderEgg02.M2", -- [2]
											"Firelands_SpiderEgg03.M2", -- [3]
										},
										["N"] = "Webs",
									}, -- [54]
									"FL_Blowing_Sand.M2", -- [55]
									"FL_Blowing_Sand2.M2", -- [56]
									"FL_Thermal_Air.M2", -- [57]
									"Firelands_Web01.M2", -- [58]
									"Firelands_Web02.M2", -- [59]
									"Firelands_Web03.M2", -- [60]
									"Firelands_Web04.M2", -- [61]
									"Firelands_Web05.M2", -- [62]
									"Firelands_Web06.M2", -- [63]
									"Firelands_Web07.M2", -- [64]
									"Firelands_Web08.M2", -- [65]
									"Firelands_Web09.M2", -- [66]
									"Firelands_Web10.M2", -- [67]
								},
								["N"] = "Firelands",
							}, -- [13]
							{
								["T"] = {
									"FK_SylvanasStatue.M2", -- [1]
								},
								["N"] = "Forsaken",
							}, -- [14]
							{
								["T"] = {
									{
										["T"] = {
											"G_Fireworks_DarkMoonFaire.M2", -- [1]
										},
										["N"] = "Darkmoonfaire",
									}, -- [1]
									{
										["T"] = {
											"Elementium_Ore_01.M2", -- [1]
											"Elementium_Ore_02.M2", -- [2]
											"Elementium_Ore_03.M2", -- [3]
											"Elementium_Ore_04.M2", -- [4]
										},
										["N"] = "Elementiumore",
									}, -- [2]
									{
										["T"] = {
											"IceCream_01.M2", -- [1]
											"IceCream_02.M2", -- [2]
											"IceCream_03.M2", -- [3]
											"IceCream_04.M2", -- [4]
										},
										["N"] = "Icecream",
									}, -- [3]
									{
										["T"] = {
											"Maelstrom.M2", -- [1]
											"MaelstromMagicVortex.M2", -- [2]
											"MaelstromSmallSplash01.M2", -- [3]
											"MaelstromSmallSplash02.M2", -- [4]
											"MaelstromSmallSplash03.M2", -- [5]
											"Maelstrom_DeathwingFight.M2", -- [6]
											"Maelstrom_DeathwingSteam.M2", -- [7]
											"Maelstrom_Lightning01.M2", -- [8]
											"Maelstrom_Lightning02.M2", -- [9]
											"Maelstrom_Ocean01.M2", -- [10]
											"Maelstrom_Ocean02.M2", -- [11]
											"Maelstrom_Ocean03.M2", -- [12]
											"Maelstrom_Ocean04.M2", -- [13]
											"Maelstrom_SunRays01.M2", -- [14]
											"Maelstrom_Temp.M2", -- [15]
										},
										["N"] = "Maelstrom",
									}, -- [4]
									{
										["T"] = {
											"RustySpearGunBlue.M2", -- [1]
											"RustySpearGunGreen.M2", -- [2]
											"RustySpearGunPurple.M2", -- [3]
											"RustySpearGunRed.M2", -- [4]
											"RustySpearGunRust.M2", -- [5]
										},
										["N"] = "Rustyspeargun",
									}, -- [5]
									{
										["T"] = {
											"RustySpearGun.m2", -- [1]
										},
										["N"] = "Weapons",
									}, -- [6]
									"Alliance_Ship01.M2", -- [7]
									"Alliance_Ship02.M2", -- [8]
									"Alliance_Submarine.M2", -- [9]
									"Alliance_Submarine_Animations.M2", -- [10]
									"Alliance_Submarine_Door.M2", -- [11]
									"Alliance_Submarine_Sealed.M2", -- [12]
									"Alliance_Taskboard.M2", -- [13]
									"Alliance_Taskboard_Pillars.M2", -- [14]
									"Alliance_submarineDoor_Bottom.M2", -- [15]
									"Axe_2H_War_C_01_quest.M2", -- [16]
									"Clickable_Box.M2", -- [17]
									"Clickable_Box2.M2", -- [18]
									"DinoFishingPole.M2", -- [19]
									"Flying_Horde_Zeppelin.M2", -- [20]
									"Flying_Zeppelin.M2", -- [21]
									"Horde_Ship01.M2", -- [22]
									"Horde_Taskboard.M2", -- [23]
									"Horde_Taskboard_Pillars.M2", -- [24]
									"Horde_submarine.M2", -- [25]
									"Horde_submarineDoor_Bottom.M2", -- [26]
									"Horde_submarine_Tail.M2", -- [27]
									"LavaTube_01.M2", -- [28]
									"LavaTube_02.M2", -- [29]
									"Metal_Ring_01.M2", -- [30]
									"ND_Hgunship_chain.M2", -- [31]
									"ND_Hgunship_door.M2", -- [32]
									"ND_Hgunship_plank.M2", -- [33]
									"NightElfGlaiveThrowBurned.M2", -- [34]
									"NightElfGlaiveThrowBurning.M2", -- [35]
									"PulsatingPlant.M2", -- [36]
									"Seahorsestand.M2", -- [37]
									"SharkTooth.M2", -- [38]
									"Spyglass.M2", -- [39]
									"Transport_Pirate_ship_sails.M2", -- [40]
									"TwilightCloudVortex.M2", -- [41]
									"goblin_tesla.M2", -- [42]
								},
								["N"] = "Generic",
							}, -- [15]
							{
								["T"] = {
									{
										["T"] = {
											"Gilneas_Alliance_Banner_01.M2", -- [1]
											"Gilneas_Horde_Banner_01.M2", -- [2]
										},
										["N"] = "Banners",
									}, -- [1]
									{
										["T"] = {
											"Gilneas_Bramble_01.M2", -- [1]
											"Gilneas_Bramble_02.M2", -- [2]
											"Gilneas_Bramble_03.M2", -- [3]
											"Gilneas_Bramble_Branch01.M2", -- [4]
											"Gilneas_Bramble_Branch02.M2", -- [5]
											"Gilneas_Bush_01.M2", -- [6]
											"Gilneas_Bush_02.M2", -- [7]
											"Gilneas_Bush_03.M2", -- [8]
											"Gilneas_Bush_04.M2", -- [9]
											"Gilneas_Bush_05.M2", -- [10]
											"Gilneas_Bush_06.M2", -- [11]
											"Gilneas_Bush_Dark_01.M2", -- [12]
											"Gilneas_Bush_Dark_02.M2", -- [13]
											"Gilneas_Bush_Green_01.M2", -- [14]
											"Gilneas_Bush_Green_02.M2", -- [15]
											"Gilneas_Bush_PurpleRose.M2", -- [16]
											"Gilneas_Bush_WhiteRose.M2", -- [17]
											"Gilneas_Cattails01.M2", -- [18]
											"Gilneas_CornBramble_01.M2", -- [19]
											"Gilneas_Corn_01.M2", -- [20]
											"Gilneas_CornstalkPatch_01.M2", -- [21]
											"Gilneas_Cornstalk_01.M2", -- [22]
											"Gilneas_GroundFog_01.M2", -- [23]
											"Gilneas_GroundFog_02.M2", -- [24]
											"Gilneas_LumpyGrass01.M2", -- [25]
											"Gilneas_MarshGrass01.M2", -- [26]
											"Gilneas_Rose_01.M2", -- [27]
											"Gilneas_Rose_02.M2", -- [28]
											"Gilneas_Thorn_Vine_Bush_01.M2", -- [29]
											"Gilneas_Thorn_Vine_Bush_02.M2", -- [30]
											"Gilneas_Thorn_Vine_Bush_03.M2", -- [31]
											"Gilneas_Vines_01.M2", -- [32]
											"Gilneas_Vines_02.M2", -- [33]
											"Gilneas_Vines_03.M2", -- [34]
											"Gilneas_Vines_04.M2", -- [35]
											"GrassClump01.M2", -- [36]
											"GrassClump02.M2", -- [37]
											"GrassClump03.M2", -- [38]
											"GrassClump04.M2", -- [39]
											"ThornBush01.M2", -- [40]
											"ThornBush02.M2", -- [41]
											"ThornBush03.M2", -- [42]
											"ThornBush04.M2", -- [43]
										},
										["N"] = "Bushes",
									}, -- [2]
									{
										["T"] = {
											"Gilneas_CathedralWindow_Large.M2", -- [1]
											"Gilneas_CathedralWindow_Small_01.M2", -- [2]
											"Gilneas_CathedralWindow_Small_02.M2", -- [3]
										},
										["N"] = "Cathedralwindows",
									}, -- [3]
									{
										["T"] = {
											"CobbleStones01.M2", -- [1]
											"CobbleStones02.M2", -- [2]
											"CobbleStones03.M2", -- [3]
											"CobbleStones04.M2", -- [4]
											"CobbleStones05.M2", -- [5]
											"CobbleStones06.M2", -- [6]
											"CobbleStones07.M2", -- [7]
											"CobbleStones08.M2", -- [8]
											"CobbleStones_Dark_01.M2", -- [9]
											"CobbleStones_Dark_02.M2", -- [10]
											"CobbleStones_Dark_03.M2", -- [11]
											"CobbleStones_Dark_04.M2", -- [12]
											"CobbleStones_Dark_05.M2", -- [13]
											"CobbleStones_Dark_06.M2", -- [14]
											"CobbleStones_Dark_07.M2", -- [15]
											"CobbleStones_Dark_08.M2", -- [16]
										},
										["N"] = "Cobblestones",
									}, -- [4]
									{
										["T"] = {
											"GNleaves01.M2", -- [1]
											"GNleaves02.M2", -- [2]
											"GNleaves03.M2", -- [3]
										},
										["N"] = "Detaildoodads",
									}, -- [5]
									{
										["T"] = {
											"Gilneas_Fountain01.M2", -- [1]
											"Gilneas_Fountain02.M2", -- [2]
											"Gilneas_Fountain03.M2", -- [3]
											"Gilneas_FountainBroken01.M2", -- [4]
										},
										["N"] = "Fountains",
									}, -- [6]
									{
										["T"] = {
											"Gilneas_mosquito_01.M2", -- [1]
											"Gilneas_mosquito_brown_01.M2", -- [2]
										},
										["N"] = "Insects",
									}, -- [7]
									{
										["T"] = {
											"Gilneas_Lilypads01.M2", -- [1]
											"Gilneas_Lilypads02.M2", -- [2]
										},
										["N"] = "Lilypads",
									}, -- [8]
									{
										["T"] = {
											"GN_Large_Rocks_01.M2", -- [1]
											"GN_Large_Rocks_02.M2", -- [2]
											"GN_Large_Rocks_03.M2", -- [3]
											"GN_Large_Rocks_04.M2", -- [4]
											"GN_Large_Rocks_05.M2", -- [5]
											"GN_Large_Rocks_06.M2", -- [6]
											"GN_Rocks_01.M2", -- [7]
											"GN_Rocks_02.M2", -- [8]
											"GN_Rocks_03.M2", -- [9]
											"GN_Rocks_04.M2", -- [10]
											"GN_Rocks_05.M2", -- [11]
											"GN_Rocks_06.M2", -- [12]
										},
										["N"] = "Rocks",
									}, -- [9]
									{
										["T"] = {
											"StoneWall01.M2", -- [1]
											"StoneWall02.M2", -- [2]
											"StoneWall03.M2", -- [3]
											"StoneWall04.M2", -- [4]
											"StoneWall05.M2", -- [5]
											"StoneWall06.M2", -- [6]
										},
										["N"] = "Stonewalls",
									}, -- [10]
									{
										["T"] = {
											"Gilneas_TreeThorns01.M2", -- [1]
											"Gilneas_TreeThorns02.M2", -- [2]
											"Gilneas_TreeThorns03.M2", -- [3]
											"Gilneas_TreeThorns04.M2", -- [4]
											"Gilneas_TreeThorns_Dark_01.M2", -- [5]
											"Gilneas_TreeThorns_Dark_02.M2", -- [6]
											"Gilneas_TreeThorns_Dark_03.M2", -- [7]
											"Gilneas_TreeThorns_Dark_04.M2", -- [8]
										},
										["N"] = "Thorntrees",
									}, -- [11]
									{
										["T"] = {
											"DarkForestTree01.M2", -- [1]
											"DarkForestTree02.M2", -- [2]
											"DarkForestTree03.M2", -- [3]
											"DarkForestTree04.M2", -- [4]
											"DarkForestTree05.M2", -- [5]
											"DarkForestTree06.M2", -- [6]
											"DarkForestTree_Roots_01.M2", -- [7]
											"DarkForestTree_Roots_02.M2", -- [8]
											"DarkForestTree_Roots_03.M2", -- [9]
											"DarkForestTree_Roots_04.M2", -- [10]
											"DarkForestTree_Thorns_01.M2", -- [11]
											"DarkForestTree_Thorns_03.M2", -- [12]
											"DarkForestTree_Thorns_05.M2", -- [13]
											"FallingOakLeaves01.M2", -- [14]
											"FallingOakLeaves02.M2", -- [15]
											"Gilneas_PineSapling01.M2", -- [16]
											"Gilneas_PineTrunk01.M2", -- [17]
											"Gilneas_PineTrunk02.M2", -- [18]
											"Gilneas_PineTrunk03.M2", -- [19]
											"Gilneas_TreeSapling01.M2", -- [20]
											"Gilneas_WorgenDwelling_01.M2", -- [21]
											"OakTree01.M2", -- [22]
											"OakTree02.M2", -- [23]
											"OakTree02_green.M2", -- [24]
											"OakTree03.M2", -- [25]
											"OakTree03_green.M2", -- [26]
											"OakTree04.M2", -- [27]
											"OakTree04_green.M2", -- [28]
											"OakTree05.M2", -- [29]
											"OakTree06.M2", -- [30]
											"OakTreeRoot01.M2", -- [31]
											"OakTreeRoot02.M2", -- [32]
											"OakTreeRoot03.M2", -- [33]
											"OakTreeRoot04.M2", -- [34]
											"PineTree01.M2", -- [35]
											"PineTree01_Blue.M2", -- [36]
											"PineTree02.M2", -- [37]
											"PineTree02_Blue.M2", -- [38]
											"PineTree03.M2", -- [39]
											"PineTree04.M2", -- [40]
											"PineTree05.M2", -- [41]
											"PineTree06.M2", -- [42]
											"PineTree07.M2", -- [43]
											"PineTree08.M2", -- [44]
										},
										["N"] = "Trees",
									}, -- [12]
									"Gilneas_Barricade_Collision.M2", -- [13]
									"Gilneas_City_Waterfalls_01.M2", -- [14]
								},
								["N"] = "Gilneas",
							}, -- [16]
							{
								["T"] = {
									{
										["T"] = {
											"TwilightsHammer_Banner_GrimBatolEntrance_01.M2", -- [1]
										},
										["N"] = "Banner",
									}, -- [1]
									{
										["T"] = {
											"Dwarven_GrimBatol_Banner_01.M2", -- [1]
											"Dwarven_GrimBatol_Banner_02.M2", -- [2]
											"Dwarven_GrimBatol_Banner_03.M2", -- [3]
										},
										["N"] = "Banners",
									}, -- [2]
									{
										["T"] = {
											"Dwarven_GrimBatol_Chandelier_01.M2", -- [1]
											"Dwarven_GrimBatol_Chandelier_02.M2", -- [2]
											"Dwarven_GrimBatol_Chandelier_03.M2", -- [3]
										},
										["N"] = "Chandelier",
									}, -- [3]
									{
										["T"] = {
											"Dwarven_GrimBatol_Lava_01.M2", -- [1]
											"GrimBatol_CaveSparks_01.M2", -- [2]
											"GrimBatol_CaveSparks_02.M2", -- [3]
											"GrimBatol_Cave_LavaFalls_01.M2", -- [4]
											"GrimBatol_Cave_LavaFalls_02.M2", -- [5]
											"GrimBatol_Cave_LavaFalls_Drop_01.M2", -- [6]
											"GrimBatol_Cave_LavaFalls_Drop_02.M2", -- [7]
											"GrimBatol_Cave_Small_LavaFalls_01.M2", -- [8]
											"GrimBatol_Cave_Small_LavaFalls_02.M2", -- [9]
											"GrimBatol_Cave_Small_LavaFalls_03.M2", -- [10]
											"GrimBatol_Lava_Floor_Splash_01.M2", -- [11]
											"GrimBatol_Lava_In_Floor_01.M2", -- [12]
											"GrimBatol_Lava_In_Floor_02.M2", -- [13]
											"GrimBatol_Lava_Splash_01.M2", -- [14]
											"GrimBatol_Lava_Splash_02.M2", -- [15]
											"GrimBatol_Stairway_LavaFalls_01.M2", -- [16]
										},
										["N"] = "Lava",
									}, -- [4]
									{
										["T"] = {
											"grimbatol_rubble01.M2", -- [1]
											"grimbatol_rubble02.M2", -- [2]
										},
										["N"] = "Rubble",
									}, -- [5]
									"GrimBatol_Net.M2", -- [6]
									"GrimBatol_Tower_01.M2", -- [7]
									"GrimBatol_Tower_02.M2", -- [8]
									"GrimBatol_Tower_03.M2", -- [9]
									"GrimBatol_Tower_04.M2", -- [10]
									"GrimBatol_Tower_05.M2", -- [11]
									"GrimBatol_Tower_06.M2", -- [12]
									"GrimBatol_Tower_07.M2", -- [13]
									"Grimbatol_Raid_Door_01.M2", -- [14]
								},
								["N"] = "Grimbatol",
							}, -- [17]
							{
								["T"] = {
									"GrimBatolRaid_Chandelier_01.M2", -- [1]
									"GrimBatolRaid_Chogall_Throne.M2", -- [2]
									"GrimBatolRaid_Fire_Wall_01.M2", -- [3]
									"GrimBatolRaid_Fire_Wall_02.M2", -- [4]
									"GrimBatolRaid_LavaGlow_01.M2", -- [5]
									"GrimBatolRaid_Portal.M2", -- [6]
									"GrimBatolRaid_TrapDoor.M2", -- [7]
								},
								["N"] = "Grimbatolraid",
							}, -- [18]
							{
								["T"] = {
									{
										["T"] = {
											"LI_Aloe01.M2", -- [1]
											"LI_Bush01.M2", -- [2]
											"LI_Bush02.M2", -- [3]
											"LI_BushBurnt01.M2", -- [4]
											"LI_BushBurnt02.M2", -- [5]
											"LI_Edge_Bush01.M2", -- [6]
											"LI_Edge_Bush02.M2", -- [7]
											"LI_Fern01.M2", -- [8]
											"LI_Fern02.M2", -- [9]
											"LI_Ivy01.M2", -- [10]
											"LI_Ivy02.M2", -- [11]
											"LI_Ivy03.M2", -- [12]
											"LI_Ivy04.M2", -- [13]
											"LI_Ivy05.M2", -- [14]
											"LostIsles_CarnivorousPlant01.M2", -- [15]
											"LostIsles_CarnivorousPlant_02.M2", -- [16]
											"LostIsles_FanPalm_01.M2", -- [17]
											"LostIsles_FanPalm_02.M2", -- [18]
											"LostIsles_FanPalm_03.M2", -- [19]
											"LostIsles_FanPalm_04.M2", -- [20]
											"LostIsles_FlowerVine_01.M2", -- [21]
											"LostIsles_GiantFlower_01.M2", -- [22]
											"LostIsles_GiantFlower_02.M2", -- [23]
											"LostIsles_GiantFlower_03.M2", -- [24]
											"LostIsles_GiantFlower_04.M2", -- [25]
											"LostIsles_MossyRock_02.M2", -- [26]
										},
										["N"] = "Bushes",
									}, -- [1]
									{
										["T"] = {
											"LostIsles_CactusPalmBurnt_01.M2", -- [1]
											"LostIsles_CactusPalmBurnt_02.M2", -- [2]
											"LostIsles_CactusPalmBurnt_04.M2", -- [3]
											"LostIsles_CactusPalmBurnt_06.M2", -- [4]
											"LostIsles_CactusPalmDead_01.M2", -- [5]
											"LostIsles_CactusPalmDead_02.M2", -- [6]
											"LostIsles_CactusPalm_01.M2", -- [7]
											"LostIsles_CactusPalm_02.M2", -- [8]
											"LostIsles_CactusPalm_04.M2", -- [9]
											"LostIsles_CactusPalm_05.M2", -- [10]
											"LostIsles_CactusPalm_06.M2", -- [11]
											"LostIsles_CactusPalm_07.M2", -- [12]
											"LostIsles_CactusPalm_08.M2", -- [13]
											"LostIsles_CactusPalm_09.M2", -- [14]
										},
										["N"] = "Cactus",
									}, -- [2]
									{
										["T"] = {
											"LI_Edge_TallGrass01.M2", -- [1]
										},
										["N"] = "Grass",
									}, -- [3]
									{
										["T"] = {
											"LostIsles_Dragonfly_01.M2", -- [1]
										},
										["N"] = "Insects",
									}, -- [4]
									{
										["T"] = {
											"LI_VolcanicRock_01.M2", -- [1]
											"LI_VolcanicRock_02.M2", -- [2]
											"LostIsles_CliffPiece_02.M2", -- [3]
											"LostIsles_CliffPiece_03.M2", -- [4]
											"LostIsles_MossyRock_01.M2", -- [5]
											"LostIsles_MossyRock_03.M2", -- [6]
										},
										["N"] = "Rocks",
									}, -- [5]
									{
										["T"] = {
											"LI_Bamboo01.M2", -- [1]
											"LI_Bamboo02.M2", -- [2]
											"LI_Bamboo03.M2", -- [3]
											"LI_Bamboo04.M2", -- [4]
											"LI_Bamboo05.M2", -- [5]
											"LI_Bamboo07.M2", -- [6]
											"LI_Bamboo08.M2", -- [7]
											"LI_Bamboo09.M2", -- [8]
											"LI_Tree01.M2", -- [9]
											"LI_Tree02.M2", -- [10]
											"LI_Tree03.M2", -- [11]
											"LI_Tree04.M2", -- [12]
											"LI_Tree05.M2", -- [13]
											"LostIsles_BambooBurnt_04.M2", -- [14]
											"LostIsles_BambooStump_01.M2", -- [15]
											"LostIsles_BambooStump_02.M2", -- [16]
											"LostIsles_Bamboo_01.M2", -- [17]
											"LostIsles_Bamboo_02.M2", -- [18]
											"LostIsles_Bamboo_03.M2", -- [19]
											"LostIsles_Bamboo_04.M2", -- [20]
											"LostIsles_Bamboo_05.M2", -- [21]
											"LostIsles_Bamboo_06.M2", -- [22]
											"LostIsles_Bamboo_07.M2", -- [23]
											"LostIsles_Bamboo_08.M2", -- [24]
											"LostIsles_Bamboo_09.M2", -- [25]
											"LostIsles_Bamboo_10.M2", -- [26]
											"LostIsles_Log01.M2", -- [27]
											"LostIsles_MammothTree01.M2", -- [28]
											"LostIsles_MammothTree02.M2", -- [29]
											"LostIsles_MammothTreeBurnt01.M2", -- [30]
											"LostIsles_MammothTreeBurnt02.M2", -- [31]
											"LostIsles_ThornTree_01.M2", -- [32]
											"LostIsles_ThornTree_02.M2", -- [33]
											"LostIsles_TreeFire_01.M2", -- [34]
											"LostIsles_TreeFire_02.M2", -- [35]
											"LostIsles_TreeRoot_01.M2", -- [36]
											"LostIsles_TreeRoot_02.M2", -- [37]
											"LostIsles_TreeRoot_03.M2", -- [38]
											"LostIsles_TreeRoot_04.M2", -- [39]
											"LostIsles_TreeRoot_05.M2", -- [40]
											"LostIsles_TreeRoot_06.M2", -- [41]
											"LostIsles_Trunk01.M2", -- [42]
											"LostIsles_Trunk02.M2", -- [43]
											"LostIsles_Trunk03.M2", -- [44]
											"LostIsles_Trunk04.M2", -- [45]
											"LostIsles_Vine01.M2", -- [46]
											"LostIsles_Vine02.M2", -- [47]
										},
										["N"] = "Trees",
									}, -- [6]
									{
										["T"] = {
											"LostIsles_VolcanoSmoke01.M2", -- [1]
										},
										["N"] = "Volcano",
									}, -- [7]
									{
										["T"] = {
											"LostIsles_LavaFall01.M2", -- [1]
											"LostIsles_WaterFall01.M2", -- [2]
											"LostIsles_WaterFall02.M2", -- [3]
											"LostIsles_WaterFallBit01.M2", -- [4]
											"LostIsles_WaterFallCustom01.M2", -- [5]
											"LostIsles_WaterFallMist01.M2", -- [6]
										},
										["N"] = "Waterfalls",
									}, -- [8]
								},
								["N"] = "Lostisles",
							}, -- [19]
							{
								["T"] = {
									{
										["T"] = {
											"OM_Rock_01_Gray.M2", -- [1]
											"OM_Rock_02_Gray.M2", -- [2]
											"OM_Rock_03_Gray.M2", -- [3]
											"OM_Rock_04_Gray.M2", -- [4]
											"OM_Rock_05_Gray.M2", -- [5]
										},
										["N"] = "Rock",
									}, -- [1]
									"OM_Chair_01_Gray.M2", -- [2]
									"OM_Forge_01_Gray.M2", -- [3]
									"OM_Stonehenge_01_Gray.M2", -- [4]
									"OM_Stonehenge_02_Gray.M2", -- [5]
									"OM_Stonehenge_03_Gray.M2", -- [6]
									"OM_Table_01_Gray.M2", -- [7]
									"OM_Tent_01_Gray.M2", -- [8]
									"OM_Tent_02_Gray.M2", -- [9]
									"OM_Tent_03_Gray.M2", -- [10]
									"OM_Totem_01_Gray.M2", -- [11]
								},
								["N"] = "Ogre",
							}, -- [20]
							{
								["T"] = {
									{
										["T"] = {
											"Pygmy_Bowl_01.M2", -- [1]
											"Pygmy_Bowl_02.M2", -- [2]
											"Pygmy_CookPot_01.M2", -- [3]
										},
										["N"] = "Cookpot",
									}, -- [1]
									{
										["T"] = {
											"Pygmy_Drums_stage.M2", -- [1]
										},
										["N"] = "Drums",
									}, -- [2]
									{
										["T"] = {
											"Pygmy_Fence_01.M2", -- [1]
										},
										["N"] = "Fence",
									}, -- [3]
									{
										["T"] = {
											"PigmyFire_01.M2", -- [1]
										},
										["N"] = "Fire",
									}, -- [4]
									{
										["T"] = {
											"Pygmy_Food_01.M2", -- [1]
										},
										["N"] = "Food",
									}, -- [5]
									{
										["T"] = {
											"Pygmy_GroundHut.M2", -- [1]
											"Pygmy_HangingHut.M2", -- [2]
											"Pygmy_volcanohut.M2", -- [3]
										},
										["N"] = "Huts",
									}, -- [6]
									{
										["T"] = {
											"Pygmy_Idol_01.M2", -- [1]
										},
										["N"] = "Idols",
									}, -- [7]
									{
										["T"] = {
											"Pygmy_Drums_01.M2", -- [1]
											"Pygmy_Drums_02.M2", -- [2]
											"Pygmy_Drums_03.M2", -- [3]
											"Pygmy_Drums_04.M2", -- [4]
											"Pygmy_Drums_Hanging_01.M2", -- [5]
											"Pygmy_Drums_Hanging_02.M2", -- [6]
											"Pygmy_Firestick_01.M2", -- [7]
											"Pygmy_Firestick_02.M2", -- [8]
											"Pygmy_HangingWreckage_01.M2", -- [9]
											"Pygmy_HangingWreckage_02.M2", -- [10]
											"Pygmy_HangingWreckage_03.M2", -- [11]
											"Pygmy_HangingWreckage_04.M2", -- [12]
											"Pygmy_Ladder_01.M2", -- [13]
											"Pygmy_Ladder_02.M2", -- [14]
											"Pygmy_Sconce_Base.M2", -- [15]
											"Pygmy_Torch_01.M2", -- [16]
											"Pygmy_Torch_02.M2", -- [17]
											"Pygmy_Totem_01.M2", -- [18]
											"Pygmy_Totem_Animations.M2", -- [19]
											"Pygmy_Wall_01.M2", -- [20]
											"Pygmy_Wall_02.M2", -- [21]
											"Pygmy_WarriorHelm.M2", -- [22]
											"Pygmy_WeaponRack_01.M2", -- [23]
											"Pygmy_WeaponRack_02.M2", -- [24]
											"Pygmy_Weapon_01.M2", -- [25]
											"Pygmy_Weapon_02.M2", -- [26]
											"Pygmy_Weapon_03.M2", -- [27]
											"Pygmy_shell.M2", -- [28]
										},
										["N"] = "Items",
									}, -- [8]
									{
										["T"] = {
											"Pygmy_TurtlePot01.M2", -- [1]
										},
										["N"] = "Turtlepot",
									}, -- [9]
									"KongDoor.M2", -- [10]
								},
								["N"] = "Pygmy",
							}, -- [21]
							{
								["T"] = {
									{
										["T"] = {
											"Skywall_bigwind_01.M2", -- [1]
											"Skywall_bigwind_02.M2", -- [2]
											"Skywall_bigwind_03.M2", -- [3]
										},
										["N"] = "Bigwind",
									}, -- [1]
									{
										["T"] = {
											"Skywall_building_01.M2", -- [1]
											"Skywall_building_02.M2", -- [2]
											"Skywall_building_03.M2", -- [3]
											"Skywall_building_04.M2", -- [4]
											"Skywall_building_05.M2", -- [5]
											"Skywall_collapsing_platform_01.M2", -- [6]
											"Skywall_collapsing_platform_02.M2", -- [7]
											"Skywall_collapsing_platform_03.M2", -- [8]
											"Skywall_collapsing_platform_04.M2", -- [9]
										},
										["N"] = "Buildings",
									}, -- [2]
									{
										["T"] = {
											"Skywall_Cloud_Black_01.M2", -- [1]
										},
										["N"] = "Cloud_black",
									}, -- [3]
									{
										["T"] = {
											"Skywall_Djinn_Frost.M2", -- [1]
											"Skywall_Djinn_Healing.M2", -- [2]
											"Skywall_Djinn_Tornado.M2", -- [3]
										},
										["N"] = "Djinn",
									}, -- [4]
									{
										["T"] = {
											"Skywall_Orange_Lamp_01.M2", -- [1]
											"Skywall_Purple_Lamp_01.M2", -- [2]
											"Skywall_Round_Lamps_01.M2", -- [3]
											"Skywall_TopPost_Lamps_01.M2", -- [4]
											"Skywall_Wall_Lamps_01.M2", -- [5]
										},
										["N"] = "Lamps",
									}, -- [5]
									{
										["T"] = {
											"Skywall_Cloud_Steam_01.M2", -- [1]
											"Skywall_Cloud_Steam_02.M2", -- [2]
											"Skywall_Cloud_Steam_03.M2", -- [3]
											"Skywall_Cloud_Steam_04.M2", -- [4]
											"Skywall_Cloud_Steam_05.M2", -- [5]
											"Skywall_Cloud_Steam_06.M2", -- [6]
										},
										["N"] = "Steam",
									}, -- [6]
									{
										["T"] = {
											"Skywall_Urn1.M2", -- [1]
											"Skywall_Urn2.M2", -- [2]
											"Skywall_Urn3.M2", -- [3]
										},
										["N"] = "Urns",
									}, -- [7]
									"Skywall_AlakirPlatform_Collision.M2", -- [8]
									"Skywall_BlueGlow_01.M2", -- [9]
									"Skywall_Boss_Floor_Tornado.M2", -- [10]
									"Skywall_Boss_Tornado.M2", -- [11]
									"Skywall_Chains.M2", -- [12]
									"Skywall_Chandelier_01.M2", -- [13]
									"Skywall_Cloud_Ring.M2", -- [14]
									"Skywall_Cyclone_Jump_Draft.M2", -- [15]
									"Skywall_LightBall_01.M2", -- [16]
									"Skywall_LightBall_02.M2", -- [17]
									"Skywall_OrangeGlow_01.M2", -- [18]
									"Skywall_OrangeGlow_02.M2", -- [19]
									"Skywall_Particles_01.M2", -- [20]
									"Skywall_Storm_Dragon_Effect_01.M2", -- [21]
									"Skywall_WindStorm01.M2", -- [22]
									"Skywall_Wind_DraftEffect_01.M2", -- [23]
									"Skywall_Wind_DraftEffect_02.M2", -- [24]
									"Skywall_Wind_DraftEffect_03.M2", -- [25]
									"Skywall_Wind_DraftEffect_04.M2", -- [26]
									"Skywall_Wisps_01.M2", -- [27]
								},
								["N"] = "Skywall",
							}, -- [22]
							{
								["T"] = {
									"Steamwheedle_Banner_01.M2", -- [1]
								},
								["N"] = "Steamwheedle",
							}, -- [23]
							{
								["T"] = {
									"StoneTalon_Bush01.M2", -- [1]
								},
								["N"] = "Stonetalonrework",
							}, -- [24]
							{
								["T"] = {
									"DiamondMine_MineCart_01.M2", -- [1]
									"DiamondMine_MineCart_Prop_01.M2", -- [2]
									"DiamondMine_MineDepot.M2", -- [3]
									"DiamondMine_MineDepot_Collision.M2", -- [4]
									"DiamondMine_TrackSwitch.M2", -- [5]
								},
								["N"] = "Stranglethorndiamondmine",
							}, -- [25]
							{
								["T"] = {
									{
										["T"] = {
											"TolBarad_BarbedWireFence_CornerPiece_01.M2", -- [1]
											"TolBarad_BarbedWireFence_CornerPiece_Destroyed_01.M2", -- [2]
											"TolBarad_BarbedWireFence_EndPiece_01.M2", -- [3]
											"TolBarad_BarbedWireFence_EndPiece_Destroyed_01.M2", -- [4]
											"TolBarad_BarbedWireFence_MiddlePiece_01.M2", -- [5]
											"TolBarad_BarbedWireFence_MiddlePiece_02.M2", -- [6]
											"TolBarad_BarbedWireFence_MiddlePiece_03.M2", -- [7]
											"TolBarad_BarbedWireFence_MiddlePiece_Destroyed_01.M2", -- [8]
											"TolBarad_BarbedWireFence_MiddlePiece_Destroyed_02.M2", -- [9]
											"TolBarad_BarbedWireFence_MiddlePiece_Destroyed_03.M2", -- [10]
										},
										["N"] = "Barbedwirefences",
									}, -- [1]
									{
										["T"] = {
											"TolBarad_Barricade_EndPiece_01.M2", -- [1]
											"TolBarad_Barricade_EndPiece_Destroyed_01.M2", -- [2]
											"TolBarad_Barricade_MiddlePiece_01.M2", -- [3]
											"TolBarad_Barricade_MiddlePiece_01_Collision.M2", -- [4]
											"TolBarad_Barricade_MiddlePiece_02.M2", -- [5]
											"TolBarad_Barricade_MiddlePiece_02_Collision.M2", -- [6]
											"TolBarad_Barricade_MiddlePiece_03.M2", -- [7]
											"TolBarad_Barricade_MiddlePiece_03_Collision.M2", -- [8]
											"TolBarad_Barricade_MiddlePiece_Destroyed_01.M2", -- [9]
											"TolBarad_Barricade_MiddlePiece_Destroyed_01_Collision.M2", -- [10]
											"TolBarad_Barricade_MiddlePiece_Destroyed_02.M2", -- [11]
											"TolBarad_Barricade_MiddlePiece_Destroyed_03.M2", -- [12]
											"TolBarad_Barricade_MiddlePiece_Destroyed_03_Collision.M2", -- [13]
											"TolBarad_Vehicle_Barricade_01.M2", -- [14]
											"TolBarad_Vehicle_Barricade_02.M2", -- [15]
											"TolBarad_Vehicle_Barricade_03.M2", -- [16]
											"TolBarad_Vehicle_Barricade_04.M2", -- [17]
											"TolBarad_Vehicle_Barricade_05.M2", -- [18]
										},
										["N"] = "Barricade",
									}, -- [2]
									{
										["T"] = {
											"TolBarad_Cage_01.M2", -- [1]
											"TolBarad_Cage_02.M2", -- [2]
										},
										["N"] = "Cages",
									}, -- [3]
									{
										["T"] = {
											"TolBarad_Chain_Fence_01.M2", -- [1]
											"TolBarad_Chain_Fence_02.M2", -- [2]
											"TolBarad_Chain_Fence_03.M2", -- [3]
										},
										["N"] = "Chainfence",
									}, -- [4]
									{
										["T"] = {
											"TolBarad_Door_01.M2", -- [1]
											"TolBarad_Door_02.M2", -- [2]
											"TolBarad_Door_03.M2", -- [3]
										},
										["N"] = "Doors",
									}, -- [5]
									{
										["T"] = {
											"TolBarad_Pipe_01.M2", -- [1]
											"TolBarad_Pipe_02.M2", -- [2]
											"TolBarad_Pipe_03.M2", -- [3]
											"TolBarad_Pipe_04.M2", -- [4]
											"TolBarad_Pipe_05.M2", -- [5]
											"TolBarad_Pipe_06.M2", -- [6]
											"TolBarad_Pipe_07.M2", -- [7]
											"TolBarad_Pipe_08.M2", -- [8]
											"TolBarad_Pipe_Connecter_01.M2", -- [9]
											"TolBarad_Pipe_Connecter_02.M2", -- [10]
										},
										["N"] = "Pipes",
									}, -- [6]
									{
										["T"] = {
											"TolBarad_Rubble_01.M2", -- [1]
											"TolBarad_Rubble_02.M2", -- [2]
											"TolBarad_Rubble_03.M2", -- [3]
											"TolBarad_Rubble_04.M2", -- [4]
											"TolBarad_Rubble_05.M2", -- [5]
											"TolBarad_Rubble_06.M2", -- [6]
											"TolBarad_Rubble_07.M2", -- [7]
											"TolBarad_Rubble_08.M2", -- [8]
										},
										["N"] = "Rubble",
									}, -- [7]
									"BattleStandard_Alliance_TolBarad.M2", -- [8]
									"BattleStandard_Horde_TolBarad.M2", -- [9]
									"TB_destroytower_FX1.M2", -- [10]
									"TB_destroytower_FX2.M2", -- [11]
									"TolBarad_Banner_Alliance01.M2", -- [12]
									"TolBarad_Banner_Horde01.M2", -- [13]
									"TolBarad_Door_04.M2", -- [14]
									"TolBarad_Gates_01.M2", -- [15]
									"TolBarad_Gates_02.M2", -- [16]
									"TolBarad_Gates_03.M2", -- [17]
									"TolBarad_GearBox_01.M2", -- [18]
									"TolBarad_GearBox_02.M2", -- [19]
									"TolBarad_Lamp_01.M2", -- [20]
									"TolBarad_Lamp_02.M2", -- [21]
									"TolBarad_Lamp_03.M2", -- [22]
									"TolBarad_Searchlight_01.M2", -- [23]
									"TolBarad_Searchlight_02.M2", -- [24]
									"TolBarad_Searchlight_03.M2", -- [25]
									"TolBarad_Searchlight_04.M2", -- [26]
									"Tolbarad_Ripped_Fabric_01.M2", -- [27]
									"Tolbarad_Ripped_Fabric_02.M2", -- [28]
									"tolbarad_searchlight_03_NoCollision.M2", -- [29]
								},
								["N"] = "Tolbarad",
							}, -- [26]
							{
								["T"] = {
									"Tolvir_BackArmor_Jackel.M2", -- [1]
									"Tolvir_BackArmor_Ram.M2", -- [2]
									"Tolvir_BackArmor_Raven.M2", -- [3]
									"Tolvir_Helm_Jackel.M2", -- [4]
									"Tolvir_Helm_Ram.M2", -- [5]
									"Tolvir_Helm_Raven.M2", -- [6]
									"tolvir_central_building_01_FX.M2", -- [7]
									"tolvir_central_building_02_FX.M2", -- [8]
									"tolvir_city_dome01.M2", -- [9]
									"tolvir_godstatue_01.M2", -- [10]
									"tolvir_godstatue_02.M2", -- [11]
									"tolvir_godstatue_03.M2", -- [12]
									"tolvir_godstatue_04.M2", -- [13]
									"tolvir_pool.M2", -- [14]
								},
								["N"] = "Tolvir",
							}, -- [27]
							{
								["T"] = {
									{
										["T"] = {
											"Trog_Cage_01.M2", -- [1]
										},
										["N"] = "Cage",
									}, -- [1]
									{
										["T"] = {
											"Trog_Crate_01.M2", -- [1]
											"Trog_Crate_02.M2", -- [2]
										},
										["N"] = "Crates",
									}, -- [2]
									{
										["T"] = {
											"Deepholm_TrogDwelling01.M2", -- [1]
											"Deepholm_TrogDwelling02.M2", -- [2]
											"Deepholm_TrogDwelling03.M2", -- [3]
										},
										["N"] = "Dwelings",
									}, -- [3]
									{
										["T"] = {
											"Trogg_Fence_01.M2", -- [1]
											"Trogg_Fence_02.M2", -- [2]
										},
										["N"] = "Fences",
									}, -- [4]
									{
										["T"] = {
											"Trog_MushroomShield_01.M2", -- [1]
											"Trog_MushroomShield_02.M2", -- [2]
											"Trog_MushroomShield_03.M2", -- [3]
											"Trog_SlingShot_01.M2", -- [4]
											"Trog_SlingShot_02.M2", -- [5]
											"Trog_WeaponRack_01.M2", -- [6]
											"Trog_WeaponRack_02.M2", -- [7]
											"Trog_WeaponRack_03.M2", -- [8]
											"Trog_Weapon_01.M2", -- [9]
											"Trog_Weapon_02.M2", -- [10]
											"Trog_Weapon_03.M2", -- [11]
										},
										["N"] = "Items",
									}, -- [5]
									{
										["T"] = {
											"Trog_Light_01.M2", -- [1]
											"Trog_WallLight_01.M2", -- [2]
											"Trog_WallLight_02.M2", -- [3]
										},
										["N"] = "Lights",
									}, -- [6]
									{
										["T"] = {
											"Trog_Ropes_01.M2", -- [1]
											"Trog_Ropes_02.M2", -- [2]
											"Trog_Ropes_03.M2", -- [3]
										},
										["N"] = "Ropes",
									}, -- [7]
									{
										["T"] = {
											"Trog_Skeleton_01.M2", -- [1]
										},
										["N"] = "Skeleton",
									}, -- [8]
								},
								["N"] = "Trogg",
							}, -- [28]
							{
								["T"] = {
									{
										["T"] = {
											"TwilightsHammer_Altar01.M2", -- [1]
											"TwilightsHammer_Pillar01_Broken.M2", -- [2]
										},
										["N"] = "Altar",
									}, -- [1]
									{
										["T"] = {
											"TwilightHammer_Orb_01.M2", -- [1]
											"TwilightsHammer_BannerCat_Ceiling_01.M2", -- [2]
											"TwilightsHammer_BannerCat_Ceiling_01Tattered.M2", -- [3]
											"TwilightsHammer_BannerCat_Wall_01.M2", -- [4]
											"TwilightsHammer_BannerCat_Wall_01Tattered.M2", -- [5]
											"TwilightsHammer_BannerCataclysm_01.M2", -- [6]
											"TwilightsHammer_BannerCataclysm_02.M2", -- [7]
											"TwilightsHammer_Barricades01.M2", -- [8]
											"TwilightsHammer_Barricades01_Broken.M2", -- [9]
											"TwilightsHammer_Barricades02.M2", -- [10]
											"TwilightsHammer_Dragon_Banner.M2", -- [11]
											"TwilightsHammer_Symbol_Hanging_01.M2", -- [12]
											"TwilightsHammer_Symbol_WallMount_01.M2", -- [13]
										},
										["N"] = "Banners",
									}, -- [2]
									{
										["T"] = {
											"TwilightsHammer_Barrel01.M2", -- [1]
											"TwilightsHammer_Barrel02.M2", -- [2]
										},
										["N"] = "Barrel",
									}, -- [3]
									{
										["T"] = {
											"TwilightsHammer_Brazier_01.M2", -- [1]
										},
										["N"] = "Brazier",
									}, -- [4]
									{
										["T"] = {
											"TwilightsHammer_Cabinet_01.M2", -- [1]
											"TwilightsHammer_Cabinet_02.M2", -- [2]
										},
										["N"] = "Cabinets",
									}, -- [5]
									{
										["T"] = {
											"TwilightsHammer_Cage_01.M2", -- [1]
											"TwilightsHammer_Cage_02.M2", -- [2]
											"TwilightsHammer_Hanging_Cage_01.M2", -- [3]
										},
										["N"] = "Cage",
									}, -- [6]
									{
										["T"] = {
											"TwilightsHammer_Chain_01.M2", -- [1]
											"TwilightsHammer_Chain_02.M2", -- [2]
											"TwilightsHammer_Chain_03.M2", -- [3]
											"TwilightsHammer_Chain_04.M2", -- [4]
											"TwilightsHammer_Chain_05.M2", -- [5]
											"TwilightsHammer_Chain_06.M2", -- [6]
											"TwilightsHammer_Chain_07.M2", -- [7]
											"TwilightsHammer_Chain_08.M2", -- [8]
											"TwilightsHammer_Chain_09.M2", -- [9]
										},
										["N"] = "Chains",
									}, -- [7]
									{
										["T"] = {
											"TwilightsHammer_Chest.M2", -- [1]
										},
										["N"] = "Chest",
									}, -- [8]
									{
										["T"] = {
											"TwilightsHammer_Crate02.M2", -- [1]
											"TwilightsHammer_Crate03.M2", -- [2]
										},
										["N"] = "Crate",
									}, -- [9]
									{
										["T"] = {
											"TwilightsHammer_DragonButchered_01.M2", -- [1]
											"TwilightsHammer_DragonButchered_02.M2", -- [2]
											"TwilightsHammer_DragonButchered_03.M2", -- [3]
											"TwilightsHammer_DragonButchered_04.M2", -- [4]
										},
										["N"] = "Dragonbutchered",
									}, -- [10]
									{
										["T"] = {
											"TwilightsHammer_DragonEgg_01.M2", -- [1]
											"TwilightsHammer_DragonEgg_02.M2", -- [2]
											"TwilightsHammer_DragonEgg_03.M2", -- [3]
											"TwilightsHammer_DragonEgg_04.M2", -- [4]
											"TwilightsHammer_DragonEgg_05.M2", -- [5]
											"TwilightsHammer_DragonEgg_06.M2", -- [6]
											"TwilightsHammer_DragonEgg_Red_01.M2", -- [7]
										},
										["N"] = "Dragoneggs",
									}, -- [11]
									{
										["T"] = {
											"TwilightsHammer_ElementalGate.M2", -- [1]
											"TwilightsHammer_ElementalGate_Fire01.M2", -- [2]
										},
										["N"] = "Elementalgates",
									}, -- [12]
									{
										["T"] = {
											"TwilightsHammer_Fence_01.M2", -- [1]
											"TwilightsHammer_Fence_02.M2", -- [2]
											"TwilightsHammer_Fence_Post_01.M2", -- [3]
											"TwilightsHammer_Fence_Post_02.M2", -- [4]
										},
										["N"] = "Fence",
									}, -- [13]
									{
										["T"] = {
											"TwilightsHammer_Arch.M2", -- [1]
											"TwilightsHammer_Arch_02.M2", -- [2]
											"TwilightsHammer_Crate01.M2", -- [3]
											"TwilightsHammer_DragonPerch.M2", -- [4]
											"TwilightsHammer_Lamppost_01.M2", -- [5]
											"TwilightsHammer_Lamppost_02.M2", -- [6]
											"TwilightsHammer_Lamppost_03.M2", -- [7]
											"TwilightsHammer_Lamppost_Water_01.M2", -- [8]
											"TwilightsHammer_Lava_Brick01.M2", -- [9]
											"TwilightsHammer_Lava_Brick02.M2", -- [10]
											"TwilightsHammer_Lava_Bucket.M2", -- [11]
											"TwilightsHammer_Lava_MagicBall.M2", -- [12]
											"TwilightsHammer_Lava_Pole.M2", -- [13]
											"TwilightsHammer_Pillar01.M2", -- [14]
											"TwilightsHammer_Pillar02.M2", -- [15]
											"TwilightsHammer_Pillar03.M2", -- [16]
										},
										["N"] = "Lamppost",
									}, -- [14]
									{
										["T"] = {
											"TwilightsHammer_HangingLamp_01.M2", -- [1]
											"TwilightsHammer_LampWall_01.M2", -- [2]
											"TwilightsHammer_Lamp_01.M2", -- [3]
										},
										["N"] = "Lamps",
									}, -- [15]
									{
										["T"] = {
											"TwilightsHammer_HugeLava_Brick01.M2", -- [1]
											"TwilightsHammer_HugeLava_Brick02.M2", -- [2]
										},
										["N"] = "Lava",
									}, -- [16]
									{
										["T"] = {
											"TwilightsHammerLightning01.M2", -- [1]
											"TwilightsHammerLightning02.M2", -- [2]
										},
										["N"] = "Lightning",
									}, -- [17]
									{
										["T"] = {
											"TwilightsHammer_LargeDevice_01.M2", -- [1]
											"TwilightsHammer_LargeDevice_02.M2", -- [2]
											"TwilightsHammer_MagicalDevice_01.M2", -- [3]
											"TwilightsHammer_MagicalDevice_02.M2", -- [4]
											"TwilightsHammer_MagicalDevice_02Air.M2", -- [5]
											"TwilightsHammer_MagicalDevice_02Earth.M2", -- [6]
											"TwilightsHammer_MagicalDevice_02Fire.M2", -- [7]
											"TwilightsHammer_MagicalDevice_02Water.M2", -- [8]
											"TwilightsHammer_MagicalDevice_03.M2", -- [9]
											"TwilightsHammer_MagicalDevice_04.M2", -- [10]
											"TwilightsHammer_MagicalDevice_04Air.M2", -- [11]
											"TwilightsHammer_MagicalDevice_04Earth.M2", -- [12]
											"TwilightsHammer_MagicalDevice_04Fire.M2", -- [13]
											"TwilightsHammer_MagicalDevice_04Water.M2", -- [14]
										},
										["N"] = "Magicaldevices",
									}, -- [18]
									{
										["T"] = {
											"TwilightsHammer_Pillar04.M2", -- [1]
											"TwilightsHammer_Pillar04_Dirty.M2", -- [2]
											"twilighthammer_pillarglow_01.M2", -- [3]
											"twilighthammer_pillarglow_02.M2", -- [4]
											"twilighthammer_pillarglow_03.M2", -- [5]
										},
										["N"] = "Pillar",
									}, -- [19]
									{
										["T"] = {
											"TwilightsHammer_Rug01.M2", -- [1]
											"TwilightsHammer_Rug02.M2", -- [2]
										},
										["N"] = "Rugs",
									}, -- [20]
									{
										["T"] = {
											"TwilightsHammer_Altar_Sand.M2", -- [1]
											"TwilightsHammer_BannerCataclysm_Sand_01.M2", -- [2]
											"TwilightsHammer_Barrel_Sand.M2", -- [3]
											"TwilightsHammer_Barrel_Sand02.M2", -- [4]
											"TwilightsHammer_Barricades_Sand01.M2", -- [5]
											"TwilightsHammer_Barricades_Sand02.M2", -- [6]
											"TwilightsHammer_Brazier_Sand.M2", -- [7]
											"TwilightsHammer_Cage_Sand01.M2", -- [8]
											"TwilightsHammer_Cage_Sand02.M2", -- [9]
											"TwilightsHammer_Crate_Sand01.M2", -- [10]
											"TwilightsHammer_Crate_Sand02.M2", -- [11]
											"TwilightsHammer_Crate_Sand03.M2", -- [12]
											"TwilightsHammer_DragonPerch_Sand.M2", -- [13]
											"TwilightsHammer_LargeDevice_Sand01.M2", -- [14]
											"TwilightsHammer_Pillar_Sand_01.M2", -- [15]
											"TwilightsHammer_Pillar_Sand_01_Broken.M2", -- [16]
											"TwilightsHammer_Pillar_Sand_02.M2", -- [17]
											"TwilightsHammer_Pillar_Sand_03.M2", -- [18]
											"TwilightsHammer_Tent_Sand_01.M2", -- [19]
											"TwilightsHammer_Tent_Sand_02.M2", -- [20]
										},
										["N"] = "Sand",
									}, -- [21]
									{
										["T"] = {
											"TwilightsHammer_SandwichBoardSign_01.M2", -- [1]
										},
										["N"] = "Sandwichboardsign",
									}, -- [22]
									{
										["T"] = {
											"TwilightsHammer_Signpost_01.M2", -- [1]
											"TwilightsHammer_Signpost_Sign_Upper_02.M2", -- [2]
										},
										["N"] = "Signpost",
									}, -- [23]
									{
										["T"] = {
											"TwilightsHammer_SmeltingPot_01.M2", -- [1]
											"TwilightsHammer_SmeltingPot_02.M2", -- [2]
											"TwilightsHammer_SmeltingPot_03.M2", -- [3]
										},
										["N"] = "Smeltingpots",
									}, -- [24]
									{
										["T"] = {
											"twilightshammer_spike_01.M2", -- [1]
											"twilightshammer_spike_02.M2", -- [2]
											"twilightshammer_spike_03.M2", -- [3]
											"twilightshammer_spike_04.M2", -- [4]
											"twilightshammer_spike_05.M2", -- [5]
											"twilightshammer_spike_06.M2", -- [6]
											"twilightshammer_spike_07.M2", -- [7]
											"twilightshammer_spike_08.M2", -- [8]
											"twilightshammer_spike_09.M2", -- [9]
											"twilightshammer_spike_10.M2", -- [10]
										},
										["N"] = "Spikes",
									}, -- [25]
									{
										["T"] = {
											"TwilightHammer_Stonethrower_01.M2", -- [1]
										},
										["N"] = "Stonethrower",
									}, -- [26]
									{
										["T"] = {
											"TwilightsHammer_SummoningPortal_Air01.M2", -- [1]
											"TwilightsHammer_SummoningPortal_Earth01.M2", -- [2]
											"TwilightsHammer_SummoningPortal_Fire01.M2", -- [3]
											"TwilightsHammer_SummoningPortal_Water01.M2", -- [4]
										},
										["N"] = "Summoningportals",
									}, -- [27]
									{
										["T"] = {
											"TwilightsHammer_Table01.M2", -- [1]
											"TwilightsHammer_Table02.M2", -- [2]
											"TwilightsHammer_Table03.M2", -- [3]
										},
										["N"] = "Tables",
									}, -- [28]
									{
										["T"] = {
											"TwilightsHammer_Tent01.M2", -- [1]
											"TwilightsHammer_Tent01_Dirty.M2", -- [2]
											"TwilightsHammer_Tent02.M2", -- [3]
											"TwilightsHammer_Tent02_Dirty.M2", -- [4]
											"TwilightsHammer_Tent03.M2", -- [5]
											"TwilightsHammer_Tent03_Dirty.M2", -- [6]
											"TwilightsHammer_TentPole01.M2", -- [7]
										},
										["N"] = "Tents",
									}, -- [29]
									{
										["T"] = {
											"TwilightsHammer_TrophyFrame_01.M2", -- [1]
											"TwilightsHammer_TrophyFrame_02.M2", -- [2]
										},
										["N"] = "Trophyframe",
									}, -- [30]
									{
										["T"] = {
											"TwilightsHammer_Wagon_01.M2", -- [1]
											"TwilightsHammer_Wagon_02.M2", -- [2]
											"TwilightsHammer_Wagon_03.M2", -- [3]
										},
										["N"] = "Wagons",
									}, -- [31]
									"TwilightMagicVortex.M2", -- [32]
									"TwilightMagicVortex_Lesser.M2", -- [33]
								},
								["N"] = "Twilighthammer",
							}, -- [29]
							{
								["T"] = {
									{
										["T"] = {
											"TH_ObsidianBranch01.M2", -- [1]
											"TH_ObsidianBranch02.M2", -- [2]
											"TH_ObsidianBranch03.M2", -- [3]
										},
										["N"] = "Branches",
									}, -- [1]
									{
										["T"] = {
											"TH_Bush01.M2", -- [1]
											"TH_Bush02.M2", -- [2]
											"TH_Bush03.M2", -- [3]
											"TH_Bush04.M2", -- [4]
											"TH_Bush05.M2", -- [5]
											"TH_ObsidianBush01.M2", -- [6]
											"TH_ObsidianBush02.M2", -- [7]
											"TH_ObsidianBush03.M2", -- [8]
										},
										["N"] = "Bushes",
									}, -- [2]
									{
										["T"] = {
											"TH_CraterGlow_01.M2", -- [1]
											"TH_CraterGlow_Particle_01.M2", -- [2]
											"TH_CraterGlow_Particle_02.M2", -- [3]
											"TH_CraterGlow_Particle_03.M2", -- [4]
											"TH_CraterGlow_Particle_04.M2", -- [5]
										},
										["N"] = "Crater",
									}, -- [3]
									{
										["T"] = {
											"DrownedDwarfMale01.M2", -- [1]
											"DrownedDwarfMale02.M2", -- [2]
											"DrownedDwarfMale03.M2", -- [3]
											"DrownedDwarfMale04.M2", -- [4]
											"DrownedDwarfMale05.M2", -- [5]
											"DrowningAnchor.M2", -- [6]
										},
										["N"] = "Drowneddwarves",
									}, -- [4]
									{
										["T"] = {
											"TH_LowlandFlower01.M2", -- [1]
											"TH_LowlandFlower02.M2", -- [2]
										},
										["N"] = "Flowers",
									}, -- [5]
									{
										["T"] = {
											"TH_LowlndGrass01.M2", -- [1]
											"TH_LowlndGrass02.M2", -- [2]
											"TH_LowlndGrass03.M2", -- [3]
											"TH_LowlndGrass04.M2", -- [4]
										},
										["N"] = "Grass",
									}, -- [6]
									{
										["T"] = {
											"TH_ObsidianRock01.M2", -- [1]
											"TH_ObsidianRock01_Corrupted.M2", -- [2]
											"TH_ObsidianRock02.M2", -- [3]
											"TH_ObsidianRock02_Corrupted.M2", -- [4]
											"TH_ObsidianRock03.M2", -- [5]
											"TH_ObsidianRock03_Corrupted.M2", -- [6]
											"TH_ObsidianRock04.M2", -- [7]
											"TH_ObsidianRock04_Corrupted.M2", -- [8]
											"TH_ObsidianRock05.M2", -- [9]
											"TH_ObsidianRock05_Corrupted.M2", -- [10]
											"TH_PebblePile01.M2", -- [11]
											"TH_RockA.M2", -- [12]
											"TH_RockB.M2", -- [13]
											"TH_RockC.M2", -- [14]
											"TH_RockD.M2", -- [15]
											"TH_RockE.M2", -- [16]
											"TH_RockPlinth01.M2", -- [17]
											"TH_RockPlinth02.M2", -- [18]
											"TH_RockPlinth03.M2", -- [19]
											"TH_Small_RockA.M2", -- [20]
											"TH_Small_RockB.M2", -- [21]
											"TH_Small_RockC.M2", -- [22]
											"TH_Small_RockD.M2", -- [23]
											"TH_Small_RockE.M2", -- [24]
											"TH_Small_RockF.M2", -- [25]
										},
										["N"] = "Rocks",
									}, -- [7]
									{
										["T"] = {
											"TH_Tentacle_01.M2", -- [1]
											"TH_Tentacle_02.M2", -- [2]
											"TH_Tentacle_02_lootable.M2", -- [3]
											"TH_Tentacle_03.M2", -- [4]
										},
										["N"] = "Tentacles",
									}, -- [8]
									{
										["T"] = {
											"TH_BristleConeTree01.M2", -- [1]
											"TH_BristleConeTree01_Corrupted.M2", -- [2]
											"TH_BristleConeTree02.M2", -- [3]
											"TH_BristleConeTree02_Corrupted.M2", -- [4]
											"TH_BristleConeTree03.M2", -- [5]
											"TH_BristleConeTree03_Corrupted.M2", -- [6]
											"TH_BristleConeTree04.M2", -- [7]
											"TH_BristleConeTree05.M2", -- [8]
											"TH_BristleConeTree06.M2", -- [9]
											"TH_BristleConeTree07.M2", -- [10]
											"TH_ObsidianTree01.M2", -- [11]
											"TH_ObsidianTree02.M2", -- [12]
											"TH_ObsidianTree03.M2", -- [13]
											"TH_ObsidianTree03_Corrupted.M2", -- [14]
											"TH_ObsidianTree04.M2", -- [15]
											"TH_ObsidianTree05.M2", -- [16]
											"TH_ObsidianTree06.M2", -- [17]
											"TH_OldGodPineTree01.M2", -- [18]
											"TH_OldGodPineTree02.M2", -- [19]
											"TH_OldGodPineTree03.M2", -- [20]
											"TH_OldGodPineTree04.M2", -- [21]
											"TH_PineFallen01.M2", -- [22]
											"TH_PineFallen02.M2", -- [23]
											"TH_PineStump01.M2", -- [24]
											"TH_PineStump02.M2", -- [25]
											"TH_PineTree01.M2", -- [26]
											"TH_PineTree02.M2", -- [27]
											"TH_PineTree03.M2", -- [28]
											"TH_PineTree04.M2", -- [29]
											"TH_Tree01.M2", -- [30]
											"TH_Tree02.M2", -- [31]
											"TH_Tree03.M2", -- [32]
											"TH_Tree04.M2", -- [33]
											"TH_Tree05.M2", -- [34]
											"TH_TreeSapling_01.M2", -- [35]
											"TH_TreeSapling_02.M2", -- [36]
										},
										["N"] = "Trees",
									}, -- [9]
									{
										["T"] = {
											"TH_ObsidianTrunk01.M2", -- [1]
											"TH_ObsidianTrunk02.M2", -- [2]
											"TH_ObsidianTrunk03.M2", -- [3]
											"TH_ObsidianTrunk04.M2", -- [4]
										},
										["N"] = "Trunks",
									}, -- [10]
									{
										["T"] = {
											"TH_WaterFalls_Large_01.M2", -- [1]
											"TH_WaterFalls_Small.M2", -- [2]
										},
										["N"] = "Waterfalls",
									}, -- [11]
								},
								["N"] = "Twilighthighlands",
							}, -- [30]
							{
								["T"] = {
									"TwinPeaks_Dwarven_Gate_01.M2", -- [1]
									"TwinPeaks_Dwarven_Gate_02.M2", -- [2]
									"TwinPeaks_Dwarven_Gate_03.M2", -- [3]
									"TwinPeaks_Orc_Gate_01.M2", -- [4]
									"TwinPeaks_Orc_Gate_02.M2", -- [5]
									"TwinPeaks_Orc_Gate_03.M2", -- [6]
								},
								["N"] = "Twinpeaks",
							}, -- [31]
							{
								["T"] = {
									{
										["T"] = {
											"Uldum_Basket_01.M2", -- [1]
											"Uldum_Basket_02.M2", -- [2]
											"Uldum_Basket_03.M2", -- [3]
											"Uldum_Basket_04.M2", -- [4]
											"Uldum_Basket_05.M2", -- [5]
											"Uldum_Basket_06.M2", -- [6]
											"Uldum_Basket_07.M2", -- [7]
											"Uldum_Basket_08.M2", -- [8]
											"Uldum_Basket_09.M2", -- [9]
											"Uldum_Basket_Lid_01.M2", -- [10]
											"Uldum_Basket_Lid_light_01.M2", -- [11]
											"Uldum_Basket_Light_01.M2", -- [12]
											"Uldum_Basket_Light_02.M2", -- [13]
											"Uldum_Basket_Light_03.M2", -- [14]
											"Uldum_Basket_Light_04.M2", -- [15]
											"Uldum_Basket_Light_05.M2", -- [16]
											"Uldum_Basket_Light_06.M2", -- [17]
											"Uldum_Basket_Light_07.M2", -- [18]
											"Uldum_Basket_Light_08.M2", -- [19]
											"Uldum_Basket_Light_09.M2", -- [20]
											"Uldum_Food_Bundle_01.M2", -- [21]
											"Uldum_Micro_fence_01.M2", -- [22]
											"Uldum_Micro_fence_02.M2", -- [23]
											"Uldum_Micro_lampbase_01.M2", -- [24]
										},
										["N"] = "Baskets",
									}, -- [1]
									{
										["T"] = {
											"Uldum_LaserBeams.M2", -- [1]
											"Uldum_LaserBeams_02.M2", -- [2]
											"Uldum_LaserBeams_03.M2", -- [3]
											"Uldum_LaserBeams_04.M2", -- [4]
											"Uldum_LaserBeams_Glow_Wall.M2", -- [5]
											"Uldum_Micro_Laserbeams.M2", -- [6]
											"Uldum_Micro_OutSide_Beam_01.M2", -- [7]
											"Uldum_Micro_OutSide_Beam_02.M2", -- [8]
											"Uldum_Micro_OutSide_Beam_03.M2", -- [9]
											"Uldum_Micro_OutSide_Beam_Top.M2", -- [10]
											"Uldum_Titan_Micro_Moon_Beam.M2", -- [11]
											"Uldum_Titan_Micro_Stars_Beam.M2", -- [12]
											"Uldum_Titan_Micro_Sun_Beam.M2", -- [13]
											"Uldum_Window_Beam02_Aqua.M2", -- [14]
											"Uldum_Window_Beam02_Red.M2", -- [15]
											"Uldum_Window_Beam02_Yellow.M2", -- [16]
											"Uldum_Window_Beam_Aqua.M2", -- [17]
											"Uldum_Window_Beam_Red.M2", -- [18]
											"Uldum_Window_Beam_Yellow.M2", -- [19]
										},
										["N"] = "Beams",
									}, -- [2]
									{
										["T"] = {
											"Uldum_Bench_01.M2", -- [1]
										},
										["N"] = "Benches",
									}, -- [3]
									{
										["T"] = {
											"Uldum_Blowing_Sand.M2", -- [1]
											"Uldum_Blowing_Sand_Particle_01.M2", -- [2]
										},
										["N"] = "Blowingsand",
									}, -- [4]
									{
										["T"] = {
											"Uldum_Bread_01.M2", -- [1]
											"Uldum_Bread_02.M2", -- [2]
											"Uldum_Bread_03.M2", -- [3]
											"Uldum_Bread_Paddle.M2", -- [4]
										},
										["N"] = "Bread",
									}, -- [5]
									{
										["T"] = {
											"Uldum_bridge.M2", -- [1]
										},
										["N"] = "Bridges",
									}, -- [6]
									{
										["T"] = {
											"Uldum_Bulrushes01.M2", -- [1]
											"Uldum_Bulrushes02.M2", -- [2]
											"Uldum_Bulrushes03.M2", -- [3]
											"Uldum_Bulrushes04.M2", -- [4]
											"Uldum_Bulrushes05.M2", -- [5]
											"Uldum_Bulrushes06.M2", -- [6]
											"Uldum_Bulrushes07.M2", -- [7]
											"Uldum_Bulrushes08.M2", -- [8]
											"Uldum_Bulrushes09.M2", -- [9]
											"Uldum_Bulrushes10.M2", -- [10]
											"Uldum_Bulrushes_Brown01.M2", -- [11]
											"Uldum_Bulrushes_Brown02.M2", -- [12]
											"Uldum_Bulrushes_Brown03.M2", -- [13]
											"Uldum_Bulrushes_Brown04.M2", -- [14]
											"Uldum_Bulrushes_Brown05.M2", -- [15]
											"Uldum_Bulrushes_Brown06.M2", -- [16]
											"Uldum_Bulrushes_Brown07.M2", -- [17]
											"Uldum_Bulrushes_Brown08.M2", -- [18]
											"Uldum_Bulrushes_Brown09.M2", -- [19]
											"Uldum_Bulrushes_Brown10.M2", -- [20]
											"Uldum_Bulrushes_Green01.M2", -- [21]
											"Uldum_Bulrushes_Green02.M2", -- [22]
											"Uldum_Bulrushes_Green03.M2", -- [23]
											"Uldum_Bulrushes_Green04.M2", -- [24]
											"Uldum_Bulrushes_Green05.M2", -- [25]
											"Uldum_Bulrushes_Green06.M2", -- [26]
											"Uldum_Bulrushes_Green07.M2", -- [27]
											"Uldum_Bulrushes_Green08.M2", -- [28]
											"Uldum_Bulrushes_Green09.M2", -- [29]
											"Uldum_Bulrushes_Green10.M2", -- [30]
											"Uldum_Reeds06.M2", -- [31]
											"Uldum_Reeds_Brown06.M2", -- [32]
											"Uldum_Reeds_Green06.M2", -- [33]
										},
										["N"] = "Bulrushes",
									}, -- [7]
									{
										["T"] = {
											"Uldum_OasisBush_01.M2", -- [1]
											"Uldum_OasisBush_01_Dry.M2", -- [2]
											"Uldum_OasisBush_01b.M2", -- [3]
											"Uldum_OasisBush_01c.M2", -- [4]
											"Uldum_OasisBush_02.M2", -- [5]
											"Uldum_OasisBush_02_Dry.M2", -- [6]
											"Uldum_OasisBush_03.M2", -- [7]
											"Uldum_OasisBush_03_Dry.M2", -- [8]
											"Uldum_OasisBush_04.M2", -- [9]
											"Uldum_OasisBush_04_Dry.M2", -- [10]
											"Uldum_OasisBush_05.M2", -- [11]
											"Uldum_OasisBush_05_Dry.M2", -- [12]
											"Uldum_OasisBush_06.M2", -- [13]
											"Uldum_OasisBush_07.M2", -- [14]
											"Uldum_OasisBush_08.M2", -- [15]
											"Uldum_RiverBush01.M2", -- [16]
											"Uldum_RiverBush02.M2", -- [17]
											"Uldum_RiverBush03.M2", -- [18]
											"Uldum_RiverBush04.M2", -- [19]
											"Uldum_RiverBush05.M2", -- [20]
										},
										["N"] = "Bush",
									}, -- [8]
									{
										["T"] = {
											"Uldum_Dead_Chickens_01.M2", -- [1]
											"Uldum_Dead_Chickens_02.M2", -- [2]
										},
										["N"] = "Chickens",
									}, -- [9]
									{
										["T"] = {
											"Uldum_Coffin_Lid_01.M2", -- [1]
											"Uldum_Crypt_Coffin_01.M2", -- [2]
											"Uldum_Crypt_Coffin_02.M2", -- [3]
											"Uldum_Crypt_Coffin_03.M2", -- [4]
										},
										["N"] = "Coffins",
									}, -- [10]
									{
										["T"] = {
											"Uldum_Copper_01.M2", -- [1]
											"Uldum_Copper_02.M2", -- [2]
										},
										["N"] = "Copper",
									}, -- [11]
									{
										["T"] = {
											"Uldum_Crate_01.M2", -- [1]
											"Uldum_Crate_02.M2", -- [2]
											"Uldum_Crate_03.M2", -- [3]
											"Uldum_Crate_04.M2", -- [4]
											"Uldum_Crate_05.M2", -- [5]
										},
										["N"] = "Crates",
									}, -- [12]
									{
										["T"] = {
											"Uldum_Crops_Aloe01.M2", -- [1]
											"Uldum_Crops_Aloe02.M2", -- [2]
											"Uldum_Crops_Aloe03.M2", -- [3]
											"Uldum_Crops_AloeFlower01.M2", -- [4]
											"Uldum_Crops_AloeFlower02.M2", -- [5]
											"Uldum_Crops_AloeRow01.M2", -- [6]
											"Uldum_Crops_AloeRow02.M2", -- [7]
											"Uldum_Crops_AloeRow03.M2", -- [8]
											"Uldum_Crops_DatePalm01.M2", -- [9]
											"Uldum_Crops_DatePalm02.M2", -- [10]
											"Uldum_Crops_DatePalm03.M2", -- [11]
											"Uldum_Crops_DatePalmRow01.M2", -- [12]
											"Uldum_Crops_DatePalmRow02.M2", -- [13]
											"Uldum_Crops_SpiralAloe01.M2", -- [14]
											"Uldum_Crops_SpiralAloe02.M2", -- [15]
											"Uldum_Crops_SpiralAloe03.M2", -- [16]
											"Uldum_Crops_SpiralAloeRow01.M2", -- [17]
											"Uldum_Crops_SpiralAloeRow02.M2", -- [18]
											"Uldum_Crops_SpiralAloeRow03.M2", -- [19]
											"Uldum_Crops_SugarCane01.M2", -- [20]
											"Uldum_Crops_SugarCane02.M2", -- [21]
											"Uldum_Crops_SugarCane03.M2", -- [22]
											"Uldum_Crops_SugarCane04.M2", -- [23]
											"Uldum_Crops_SugarCane05.M2", -- [24]
											"Uldum_Crops_SugarCane06.M2", -- [25]
											"Uldum_Crops_SugarCaneRow01.M2", -- [26]
											"Uldum_Crops_SugarCaneRow02.M2", -- [27]
											"Uldum_Crops_SugarCaneRow03.M2", -- [28]
											"Uldum_Crops_SugarCaneRow04.M2", -- [29]
											"Uldum_Crops_SugarCaneRow05.M2", -- [30]
											"Uldum_Crops_SugarCaneRow06.M2", -- [31]
											"Uldum_Crops_SugarCaneRow07.M2", -- [32]
											"Uldum_Crops_SugarCaneRow08.M2", -- [33]
										},
										["N"] = "Crops",
									}, -- [13]
									{
										["T"] = {
											"Uldum_DesertFlowers01.M2", -- [1]
											"Uldum_DesertFlowers02.M2", -- [2]
											"Uldum_DesertFlowers03.M2", -- [3]
											"Uldum_DesertFlowers04.M2", -- [4]
											"Uldum_DesertFlowers05.M2", -- [5]
										},
										["N"] = "Desertflowers",
									}, -- [14]
									{
										["T"] = {
											"Uldum_Door_01.M2", -- [1]
											"Uldum_Door_02.M2", -- [2]
											"Uldum_Door_03.M2", -- [3]
											"Uldum_Door_Gem_Aqua.M2", -- [4]
											"Uldum_Door_Gem_Red.M2", -- [5]
											"Uldum_Door_Gem_Yellow.M2", -- [6]
											"Uldum_Door_Knocker01.M2", -- [7]
											"Uldum_Door_Knocker02.M2", -- [8]
										},
										["N"] = "Doors",
									}, -- [15]
									{
										["T"] = {
											"Uldum_Elevator_01_transport_DOODAD.M2", -- [1]
											"Uldum_Elevator_BurialChamber.M2", -- [2]
											"Uldum_Elevator_BurialChamber_COL.M2", -- [3]
											"Uldum_Elevator_Glass_Star.M2", -- [4]
											"Uldum_TopOfElevator_Glass_Floor.M2", -- [5]
										},
										["N"] = "Elevators",
									}, -- [16]
									{
										["T"] = {
											"Uldum_Farming_01.M2", -- [1]
											"Uldum_Farming_02.M2", -- [2]
											"Uldum_Farming_03.M2", -- [3]
											"Uldum_Farming_04.M2", -- [4]
										},
										["N"] = "Farming",
									}, -- [17]
									{
										["T"] = {
											"Uldum_Fish_01.M2", -- [1]
											"Uldum_Fish_02.M2", -- [2]
											"Uldum_Fish_03.M2", -- [3]
											"Uldum_Fish_04.M2", -- [4]
											"Uldum_Hanging_Fish.M2", -- [5]
										},
										["N"] = "Fish",
									}, -- [18]
									{
										["T"] = {
											"Uldum_Flag_01.M2", -- [1]
											"Uldum_Flag_02.M2", -- [2]
										},
										["N"] = "Flags",
									}, -- [19]
									{
										["T"] = {
											"Uldum_Flagstone01.M2", -- [1]
											"Uldum_Flagstone02.M2", -- [2]
											"Uldum_Flagstone03.M2", -- [3]
											"Uldum_Flagstone04.M2", -- [4]
											"Uldum_Flagstone05.M2", -- [5]
											"Uldum_Flagstone06.M2", -- [6]
											"Uldum_Flagstone07.M2", -- [7]
											"Uldum_Flagstone08.M2", -- [8]
											"Uldum_Flagstone09.M2", -- [9]
											"Uldum_Flagstone10.M2", -- [10]
										},
										["N"] = "Flagstones",
									}, -- [20]
									{
										["T"] = {
											"Uldum_Floor_01.M2", -- [1]
											"Uldum_Floor_02.M2", -- [2]
											"Uldum_Floor_03.M2", -- [3]
										},
										["N"] = "Floor",
									}, -- [21]
									{
										["T"] = {
											"uldum_fountain.M2", -- [1]
											"uldum_fountain_02.M2", -- [2]
										},
										["N"] = "Fountain",
									}, -- [22]
									{
										["T"] = {
											"Uldum_ConduitFX_ElevatorRoom.M2", -- [1]
											"Uldum_pillarglow.M2", -- [2]
										},
										["N"] = "Fx",
									}, -- [23]
									{
										["T"] = {
											"uldum_glass_dam.M2", -- [1]
										},
										["N"] = "Glassdam",
									}, -- [24]
									{
										["T"] = {
											"Uldum_Grass01.M2", -- [1]
											"Uldum_Grass01_Dry.M2", -- [2]
											"Uldum_Grass02.M2", -- [3]
											"Uldum_Grass02_Dry.M2", -- [4]
											"Uldum_Grass03.M2", -- [5]
											"Uldum_Grass03_Dry.M2", -- [6]
											"Uldum_Grass04.M2", -- [7]
											"Uldum_Grass04_Dry.M2", -- [8]
											"Uldum_GrassReeds01.M2", -- [9]
											"Uldum_GrassReeds02.M2", -- [10]
											"Uldum_GrassReeds03.M2", -- [11]
											"Uldum_GrassReeds04.M2", -- [12]
											"Uldum_GrassReeds05.M2", -- [13]
											"Uldum_GrassReeds06.M2", -- [14]
											"Uldum_GrassReeds07.M2", -- [15]
											"Uldum_GrassReeds08.M2", -- [16]
											"Uldum_GrassReeds09.M2", -- [17]
											"Uldum_GrassReeds10.M2", -- [18]
										},
										["N"] = "Grass",
									}, -- [25]
									{
										["T"] = {
											"Uldum_Head_God_01.M2", -- [1]
											"Uldum_Head_God_02.M2", -- [2]
											"Uldum_Head_God_03.M2", -- [3]
											"Uldum_Head_God_04.M2", -- [4]
											"Uldum_Head_Wall_01.M2", -- [5]
										},
										["N"] = "Heads",
									}, -- [26]
									{
										["T"] = {
											"Uldum_Irrigation_01.M2", -- [1]
											"Uldum_Irrigation_02.M2", -- [2]
											"Uldum_Irrigation_03.M2", -- [3]
											"Uldum_Irrigation_04.M2", -- [4]
											"Uldum_Irrigation_05.M2", -- [5]
											"Uldum_Irrigation_06.M2", -- [6]
										},
										["N"] = "Irrigation",
									}, -- [27]
									{
										["T"] = {
											"Uldum_Floor_Lamp_01.M2", -- [1]
											"Uldum_Floor_Lamp_Active.M2", -- [2]
											"Uldum_Lamp_01.M2", -- [3]
											"Uldum_Lattice_Lamp_01.M2", -- [4]
											"Uldum_Lattice_Lamp_02.M2", -- [5]
											"Uldum_Oil_Lamp_01.M2", -- [6]
											"Uldum_Scarab_Sconce_01.M2", -- [7]
											"Uldum_Wall_Sconce_01.M2", -- [8]
										},
										["N"] = "Lamps",
									}, -- [28]
									{
										["T"] = {
											"Uldum_LaserLense.M2", -- [1]
											"Uldum_LaserMachine.M2", -- [2]
										},
										["N"] = "Lasermachine",
									}, -- [29]
									{
										["T"] = {
											"Uldum_LightMachine_01.M2", -- [1]
										},
										["N"] = "Lightmachines",
									}, -- [30]
									{
										["T"] = {
											"Uldum_Lightshaft_01.M2", -- [1]
										},
										["N"] = "Lightshaft",
									}, -- [31]
									{
										["T"] = {
											"Uld_Mailbox.M2", -- [1]
										},
										["N"] = "Mailbox",
									}, -- [32]
									{
										["T"] = {
											"Uldum_Market_Post_01.M2", -- [1]
											"Uldum_Market_Shelf_01.M2", -- [2]
											"Uldum_Market_Stand_01.M2", -- [3]
											"Uldum_Market_Stand_02.M2", -- [4]
											"Uldum_Market_Stand_03.M2", -- [5]
											"Uldum_Market_Stand_04.M2", -- [6]
											"Uldum_Market_Stand_05.M2", -- [7]
											"Uldum_Market_Stand_06.M2", -- [8]
											"Uldum_Market_Stand_07.M2", -- [9]
											"Uldum_Market_Stand_08.M2", -- [10]
											"Uldum_Market_Stand_09.M2", -- [11]
											"Uldum_Market_Stand_10.M2", -- [12]
											"Uldum_Market_Stand_11.M2", -- [13]
											"Uldum_Market_Table_01.M2", -- [14]
										},
										["N"] = "Marketstand",
									}, -- [33]
									{
										["T"] = {
											"Uldum_Markettents_Arch_01.M2", -- [1]
											"Uldum_Markettents_Arch_01blue.M2", -- [2]
											"Uldum_Markettents_Arch_01red.M2", -- [3]
											"Uldum_Markettents_Arch_02.M2", -- [4]
											"Uldum_Markettents_Arch_02blue.M2", -- [5]
											"Uldum_Markettents_Arch_02red.M2", -- [6]
											"Uldum_Markettents_Corner_01.M2", -- [7]
											"Uldum_Markettents_Corner_02.M2", -- [8]
											"Uldum_Markettents_Jewels_02.M2", -- [9]
											"Uldum_Markettents_Large_01.M2", -- [10]
											"Uldum_Markettents_Large_02.M2", -- [11]
											"Uldum_Markettents_Large_03.M2", -- [12]
											"Uldum_Markettents_Med_01.M2", -- [13]
											"Uldum_Markettents_Small_01.M2", -- [14]
											"Uldum_Markettents_Streamer_01.M2", -- [15]
											"Uldum_Markettents_Streamer_01blue.M2", -- [16]
											"Uldum_Markettents_Streamer_01red.M2", -- [17]
											"Uldum_Markettents_Streamer_02.M2", -- [18]
											"Uldum_Markettents_Streamer_03.M2", -- [19]
											"Uldum_Markettents_XLarge_01.M2", -- [20]
											"Uldum_Markettents_XLarge_02.M2", -- [21]
											"Uldum_Markettents_XLarge_02blue.M2", -- [22]
											"Uldum_Markettents_XLarge_02red.M2", -- [23]
										},
										["N"] = "Markettents",
									}, -- [34]
									{
										["T"] = {
											"Uldum_MillWheel_01.M2", -- [1]
											"Uldum_MillWheel_02.M2", -- [2]
										},
										["N"] = "Millwheel",
									}, -- [35]
									{
										["T"] = {
											"Uldum_Mirror01.M2", -- [1]
											"Uldum_Mirror01_Wall_Mount.M2", -- [2]
											"Uldum_Mirror02.M2", -- [3]
											"Uldum_Mirror_Sun_01.M2", -- [4]
										},
										["N"] = "Mirrors",
									}, -- [36]
									{
										["T"] = {
											"Uldum_MovingMachines_01.M2", -- [1]
											"Uldum_MovingMachines_02.M2", -- [2]
											"Uldum_MovingMachines_03.M2", -- [3]
											"Uldum_MovingMachines_04.M2", -- [4]
											"Uldum_MovingMachines_05.M2", -- [5]
											"Uldum_MovingMachines_06.M2", -- [6]
										},
										["N"] = "Movingmachines",
									}, -- [37]
									{
										["T"] = {
											"Uldum_OasisBellFlower01.M2", -- [1]
											"Uldum_OasisBellFlower02.M2", -- [2]
											"Uldum_OasisBellFlower03.M2", -- [3]
										},
										["N"] = "Oasisbellflowers",
									}, -- [38]
									{
										["T"] = {
											"Uldum_OasisWhiteflower01.M2", -- [1]
											"Uldum_OasisWhiteflower02.M2", -- [2]
											"Uldum_OasisWhiteflower03.M2", -- [3]
											"Uldum_OasisWhiteflower04.M2", -- [4]
											"Uldum_OasisWhiteflower05.M2", -- [5]
											"Uldum_OasisWhiteflower06.M2", -- [6]
											"Uldum_OasisWhiteflower07.M2", -- [7]
											"Uldum_OasisWhiteflower08.M2", -- [8]
										},
										["N"] = "Oasiswhiteflowers",
									}, -- [39]
									{
										["T"] = {
											"Uldum_Obelisk_01.M2", -- [1]
											"Uldum_Obelisk_02.M2", -- [2]
											"Uldum_Obelisk_03.M2", -- [3]
											"Uldum_Obelisk_04.M2", -- [4]
											"Uldum_Obelisk_Broken_01.M2", -- [5]
											"Uldum_Obelisk_Broken_02.M2", -- [6]
											"Uldum_Obelisk_Broken_03.M2", -- [7]
											"Uldum_Obelisk_Broken_04.M2", -- [8]
											"Uldum_Obelisk_Broken_05.M2", -- [9]
											"Uldum_Obelisk_Broken_06.M2", -- [10]
										},
										["N"] = "Obelisks",
									}, -- [40]
									{
										["T"] = {
											"Uldum_Pillar_Brick_01.M2", -- [1]
											"Uldum_Pillar_Brick_02.M2", -- [2]
											"Uldum_Pillar_Brick_03.M2", -- [3]
											"Uldum_Pillar_Brick_04.M2", -- [4]
											"Uldum_Pillar_Brick_05.M2", -- [5]
											"Uldum_Pillar_Brick_06.M2", -- [6]
										},
										["N"] = "Pillars",
									}, -- [41]
									{
										["T"] = {
											"Uldum_Pot_01.M2", -- [1]
											"Uldum_Pot_02.M2", -- [2]
											"Uldum_Pot_03.M2", -- [3]
										},
										["N"] = "Pots",
									}, -- [42]
									{
										["T"] = {
											"Uldum_Pyramid_01.M2", -- [1]
										},
										["N"] = "Pyramid",
									}, -- [43]
									{
										["T"] = {
											"Uldum_Pyramid_Peak.M2", -- [1]
										},
										["N"] = "Pyramidpeak",
									}, -- [44]
									{
										["T"] = {
											"Uldum_Reeds01.M2", -- [1]
											"Uldum_Reeds02.M2", -- [2]
											"Uldum_Reeds03.M2", -- [3]
											"Uldum_Reeds04.M2", -- [4]
											"Uldum_Reeds05.M2", -- [5]
											"Uldum_Reeds_Brown01.M2", -- [6]
											"Uldum_Reeds_Brown02.M2", -- [7]
											"Uldum_Reeds_Brown03.M2", -- [8]
											"Uldum_Reeds_Brown04.M2", -- [9]
											"Uldum_Reeds_Brown05.M2", -- [10]
											"Uldum_Reeds_Green01.M2", -- [11]
											"Uldum_Reeds_Green02.M2", -- [12]
											"Uldum_Reeds_Green03.M2", -- [13]
											"Uldum_Reeds_Green04.M2", -- [14]
											"Uldum_Reeds_Green05.M2", -- [15]
										},
										["N"] = "Reeds",
									}, -- [45]
									{
										["T"] = {
											"Uldum_RiverLotus01.M2", -- [1]
											"Uldum_RiverLotus02.M2", -- [2]
											"Uldum_RiverLotus03.M2", -- [3]
											"Uldum_RiverLotus04.M2", -- [4]
											"Uldum_RiverLotus05.M2", -- [5]
											"Uldum_RiverLotus06.M2", -- [6]
											"Uldum_RiverLotus07.M2", -- [7]
											"Uldum_RiverLotus08.M2", -- [8]
											"Uldum_RiverLotus09.M2", -- [9]
											"Uldum_RiverLotus10.M2", -- [10]
										},
										["N"] = "Riverlotus",
									}, -- [46]
									{
										["T"] = {
											"Uldum_RiverRocksGrass_01.M2", -- [1]
											"Uldum_RiverRocksGrass_03.M2", -- [2]
											"Uldum_RiverRocksGrass_04.M2", -- [3]
											"Uldum_RiverRocksGrass_05.M2", -- [4]
											"Uldum_RiverRocksGrass_06.M2", -- [5]
											"Uldum_RiverRocksGrass_07.M2", -- [6]
										},
										["N"] = "Riverrockgrass",
									}, -- [47]
									{
										["T"] = {
											"Uldum_RiverRocks_01.M2", -- [1]
											"Uldum_RiverRocks_02.M2", -- [2]
											"Uldum_RiverRocks_03.M2", -- [3]
											"Uldum_RiverRocks_04.M2", -- [4]
											"Uldum_RiverRocks_05.M2", -- [5]
											"Uldum_RiverRocks_06.M2", -- [6]
											"Uldum_RiverRocks_07.M2", -- [7]
										},
										["N"] = "Rocks",
									}, -- [48]
									{
										["T"] = {
											"Uldum_Rope_01.M2", -- [1]
											"Uldum_Rope_02.M2", -- [2]
										},
										["N"] = "Ropes",
									}, -- [49]
									{
										["T"] = {
											"Uldum_Rug_01.M2", -- [1]
											"Uldum_Rug_02.M2", -- [2]
											"Uldum_Rug_03.M2", -- [3]
											"Uldum_Rug_04.M2", -- [4]
											"Uldum_Rug_05.M2", -- [5]
											"Uldum_Rug_06.M2", -- [6]
											"Uldum_Rug_07.M2", -- [7]
											"Uldum_Rug_08.M2", -- [8]
											"Uldum_Rug_09.M2", -- [9]
											"Uldum_Rug_10.M2", -- [10]
											"Uldum_Rug_11.M2", -- [11]
											"Uldum_Rug_Pile_01.M2", -- [12]
											"Uldum_Rug_Pile_02.M2", -- [13]
										},
										["N"] = "Rugs",
									}, -- [50]
									{
										["T"] = {
											"Uldum_Sack_01.M2", -- [1]
											"Uldum_Sack_02.M2", -- [2]
											"Uldum_Sack_03.M2", -- [3]
											"Uldum_Sack_04.M2", -- [4]
											"Uldum_Sack_05.M2", -- [5]
											"Uldum_Sack_06.M2", -- [6]
											"Uldum_Sack_07.M2", -- [7]
											"Uldum_Sack_08.M2", -- [8]
											"Uldum_Sack_09.M2", -- [9]
											"Uldum_Sack_10.M2", -- [10]
											"Uldum_Sack_11.M2", -- [11]
											"Uldum_Sack_Scoop_01.M2", -- [12]
											"Uldum_Sack_Sign_01.M2", -- [13]
											"Uldum_Sack_Sign_02.M2", -- [14]
											"Uldum_Sack_Sign_03.M2", -- [15]
											"Uldum_Sack_Sign_04.M2", -- [16]
										},
										["N"] = "Sacks",
									}, -- [51]
									{
										["T"] = {
											"Uldum_Sandfall_01.M2", -- [1]
											"Uldum_Sandfall_LightShaft_01.M2", -- [2]
											"Uldum_Sandfall_Short_01.M2", -- [3]
										},
										["N"] = "Sandfalls",
									}, -- [52]
									{
										["T"] = {
											"Uldum_SandStorm01.M2", -- [1]
										},
										["N"] = "Sandstorm",
									}, -- [53]
									{
										["T"] = {
											"Uldum_SlidingFloor.M2", -- [1]
										},
										["N"] = "Slidingfloor",
									}, -- [54]
									{
										["T"] = {
											"Uldum_Ammunae_Statue_01.M2", -- [1]
											"Uldum_Ammunae_Statue_02.M2", -- [2]
											"Uldum_Crocodile_Statue_01.M2", -- [3]
											"Uldum_Crocodile_Statue_02.M2", -- [4]
											"Uldum_Falcon_Statue_03.M2", -- [5]
											"Uldum_Falcon_Statue_04.M2", -- [6]
											"Uldum_Jackal_Statue_01.M2", -- [7]
											"Uldum_Jackal_Statue_02.M2", -- [8]
											"Uldum_Ram_Statue.M2", -- [9]
											"Uldum_Ram_Statue_01.M2", -- [10]
											"Uldum_Ram_Statue_02.M2", -- [11]
											"Uldum_Ram_Statue_03.M2", -- [12]
											"Uldum_Ram_Statue_04.M2", -- [13]
											"Uldum_Titan_Statue06.M2", -- [14]
											"Uldum_Titan_Statue07.M2", -- [15]
											"uldum_falcon_01.M2", -- [16]
											"uldum_falcon_statue_02.M2", -- [17]
										},
										["N"] = "Statues",
									}, -- [55]
									{
										["T"] = {
											"Uldum_large_structure.M2", -- [1]
											"Uldum_large_structure2.M2", -- [2]
											"Uldum_large_structure3.M2", -- [3]
										},
										["N"] = "Structure",
									}, -- [56]
									{
										["T"] = {
											"Uldum_Teapot_01.M2", -- [1]
											"Uldum_Teapot_02.M2", -- [2]
										},
										["N"] = "Teapots",
									}, -- [57]
									{
										["T"] = {
											"Uldum_Tent_01.M2", -- [1]
											"Uldum_Tent_02.M2", -- [2]
											"Uldum_Tent_03.M2", -- [3]
										},
										["N"] = "Tents",
									}, -- [58]
									{
										["T"] = {
											"Uldum_Titan_Banister01.M2", -- [1]
											"Uldum_Titan_Banister02.M2", -- [2]
											"Uldum_Titan_Banister03.M2", -- [3]
											"Uldum_Titan_Banister04.M2", -- [4]
											"Uldum_Titan_Banister05.M2", -- [5]
											"Uldum_Titan_Chest01.M2", -- [6]
											"Uldum_Titan_Chest02.M2", -- [7]
											"Uldum_Titan_Columns01.M2", -- [8]
											"Uldum_Titan_Columns02.M2", -- [9]
											"Uldum_Titan_Columns03.M2", -- [10]
											"Uldum_Titan_Columns04.M2", -- [11]
											"Uldum_Titan_Columns05.M2", -- [12]
											"Uldum_Titan_Columns06.M2", -- [13]
											"Uldum_Titan_Columns07.M2", -- [14]
											"Uldum_Titan_Columns08.M2", -- [15]
											"Uldum_Titan_Columns09.M2", -- [16]
											"Uldum_Titan_Columns10.M2", -- [17]
											"Uldum_Titan_DoorWay01.M2", -- [18]
											"Uldum_Titan_DoorWay02.M2", -- [19]
											"Uldum_Titan_Pipes01.M2", -- [20]
											"Uldum_Titan_Pyramid01.M2", -- [21]
											"Uldum_Titan_Pyramid02.M2", -- [22]
											"Uldum_Titan_Railing01.M2", -- [23]
											"Uldum_Titan_Stairs01.M2", -- [24]
											"Uldum_Titan_Stairs02.M2", -- [25]
											"Uldum_Titan_Statue01.M2", -- [26]
											"Uldum_Titan_Statue02.M2", -- [27]
											"Uldum_Titan_Statue03.M2", -- [28]
											"Uldum_Titan_Statue04.M2", -- [29]
											"Uldum_Titan_Statue05.M2", -- [30]
											"Uldum_Titan_Wall01.M2", -- [31]
											"Uldum_Titan_Wall02.M2", -- [32]
										},
										["N"] = "Titan",
									}, -- [59]
									{
										["T"] = {
											"Uldum_Tomb_Dirt_01.M2", -- [1]
											"Uldum_Tomb_Dirt_02.M2", -- [2]
											"Uldum_Tomb_Dirt_03.M2", -- [3]
											"Uldum_Tomb_Dirt_04.M2", -- [4]
											"Uldum_Tombstone_01.M2", -- [5]
											"Uldum_Tombstone_02.M2", -- [6]
											"Uldum_Tombstone_03.M2", -- [7]
											"Uldum_Tombstone_04.M2", -- [8]
											"Uldum_Tombstone_05.M2", -- [9]
											"Uldum_Tombstone_06.M2", -- [10]
											"Uldum_Tombstone_07.M2", -- [11]
											"Uldum_Tombstone_08.M2", -- [12]
											"Uldum_Tombstone_Base_01.M2", -- [13]
											"Uldum_Tombstone_Base_02.M2", -- [14]
											"Uldum_Tombstone_Base_03.M2", -- [15]
											"Uldum_Tombstone_Base_04.M2", -- [16]
											"Uldum_Tombstone_Base_05.M2", -- [17]
											"Uldum_Tombstone_Base_06.M2", -- [18]
											"Uldum_Tombstone_Top_01.M2", -- [19]
											"Uldum_Tombstone_Top_02.M2", -- [20]
											"Uldum_Tombstone_Top_03.M2", -- [21]
											"Uldum_Tombstone_Top_04.M2", -- [22]
											"Uldum_Tombstone_Top_06.M2", -- [23]
											"Uldum_Tombstone_Top_07.M2", -- [24]
										},
										["N"] = "Tombstones",
									}, -- [60]
									{
										["T"] = {
											"Uldum_Torch_01.M2", -- [1]
											"Uldum_Torch_01_Blue.M2", -- [2]
											"Uldum_Torch_01_Frame.M2", -- [3]
											"Uldum_Torch_02.M2", -- [4]
											"Uldum_Torch_02_Blue.M2", -- [5]
											"Uldum_Torch_03.M2", -- [6]
											"Uldum_Torch_03_Blue.M2", -- [7]
											"Uldum_Torch_04.M2", -- [8]
											"Uldum_Torch_04_Blue.M2", -- [9]
											"Uldum_Torch_05.M2", -- [10]
										},
										["N"] = "Torches",
									}, -- [61]
									{
										["T"] = {
											"Uldum_OasisTree_01.M2", -- [1]
											"Uldum_OasisTree_01_Dry.M2", -- [2]
											"Uldum_OasisTree_02.M2", -- [3]
											"Uldum_OasisTree_02_Dry.M2", -- [4]
											"Uldum_OasisTree_03.M2", -- [5]
											"Uldum_OasisTree_03_Dry.M2", -- [6]
											"Uldum_PalmDebris01.M2", -- [7]
											"Uldum_PalmDebris02.M2", -- [8]
											"Uldum_PalmDebris03.M2", -- [9]
											"Uldum_PalmDebris04.M2", -- [10]
											"Uldum_PalmDebris05.M2", -- [11]
											"Uldum_PalmDebris06.M2", -- [12]
											"Uldum_PalmDebris07.M2", -- [13]
											"Uldum_PalmDebris09.M2", -- [14]
											"Uldum_PalmTree_01.M2", -- [15]
											"Uldum_PalmTree_01_Dry.M2", -- [16]
											"Uldum_PalmTree_02.M2", -- [17]
											"Uldum_PalmTree_02_Dry.M2", -- [18]
											"Uldum_PalmTree_03.M2", -- [19]
											"Uldum_PalmTree_03_Dry.M2", -- [20]
											"Uldum_PalmTree_04.M2", -- [21]
											"Uldum_PalmTree_04_Dry.M2", -- [22]
											"Uldum_PalmTree_05.M2", -- [23]
											"Uldum_PalmTree_06.M2", -- [24]
											"Uldum_RiverTree02_01.M2", -- [25]
											"Uldum_RiverTree02_02.M2", -- [26]
											"Uldum_RiverTree02_03.M2", -- [27]
											"Uldum_RiverTree_01.M2", -- [28]
											"Uldum_RiverTree_02.M2", -- [29]
											"Uldum_RiverTree_03.M2", -- [30]
											"Uldum_RiverTree_04.M2", -- [31]
											"Uldum_RiverTree_05.M2", -- [32]
											"Uldum_RiverTree_06.M2", -- [33]
										},
										["N"] = "Trees",
									}, -- [62]
									{
										["T"] = {
											"uldum_urn_01.M2", -- [1]
											"uldum_urn_01_noCol.M2", -- [2]
											"uldum_urn_02.M2", -- [3]
										},
										["N"] = "Urns",
									}, -- [63]
									{
										["T"] = {
											"Uldum_end_piece.M2", -- [1]
											"Uldum_entrance_piece.M2", -- [2]
											"Uldum_entrance_piece1.M2", -- [3]
											"Uldum_one_story.M2", -- [4]
											"Uldum_one_story1.M2", -- [5]
											"Uldum_two_story.M2", -- [6]
											"Uldum_wall.M2", -- [7]
											"Uldum_wall_corner.M2", -- [8]
											"Uldum_wall_curved.M2", -- [9]
											"Uldum_wall_curved_short.M2", -- [10]
											"Uldum_wall_long.M2", -- [11]
											"Uldum_wall_long_curved.M2", -- [12]
										},
										["N"] = "Walls",
									}, -- [64]
									{
										["T"] = {
											"Uldum_Watcher_Center_Anims.M2", -- [1]
										},
										["N"] = "Watcher",
									}, -- [65]
									{
										["T"] = {
											"Uldum_Dam_WaterFalls_01.M2", -- [1]
											"Uldum_Dam_WaterFalls_02.M2", -- [2]
											"Uldum_Dam_WaterFalls_03.M2", -- [3]
											"Uldum_Oasis_WaterFall_Left.M2", -- [4]
											"Uldum_Oasis_WaterFall_Right.M2", -- [5]
											"Uldum_WaterFalls_East_01.M2", -- [6]
											"Uldum_WaterFalls_East_02.M2", -- [7]
											"Uldum_WaterFalls_East_03.M2", -- [8]
											"Uldum_WaterFalls_East_04.M2", -- [9]
											"Uldum_WaterFalls_East_05.M2", -- [10]
											"Uldum_WaterFalls_East_06.M2", -- [11]
											"Uldum_WaterFalls_East_07.M2", -- [12]
											"Uldum_WaterFalls_East_08.M2", -- [13]
											"Uldum_WaterFalls_West_01.M2", -- [14]
											"Uldum_WaterFalls_West_02.M2", -- [15]
											"Uldum_WaterFalls_West_03.M2", -- [16]
											"Uldum_WaterFalls_West_04.M2", -- [17]
											"Uldum_Waterfall_Large.M2", -- [18]
										},
										["N"] = "Waterfalls",
									}, -- [66]
									{
										["T"] = {
											"Uldum_WhiteLotus01.M2", -- [1]
											"Uldum_WhiteLotus02.M2", -- [2]
											"Uldum_WhiteLotus03.M2", -- [3]
										},
										["N"] = "Whitelotus",
									}, -- [67]
									"Mummy_Hand_01.M2", -- [68]
									"Uldum_Centerpiece_01.M2", -- [69]
									"Uldum_Cook_Stove_01.M2", -- [70]
									"Uldum_Dam_Drain.M2", -- [71]
									"Uldum_Elevator_01.M2", -- [72]
									"Uldum_Floating_Lamp_01.M2", -- [73]
									"Uldum_Incense_Burner_01.M2", -- [74]
									"Uldum_Micro_Glass_01.M2", -- [75]
									"Uldum_Pedestal_01.M2", -- [76]
									"Uldum_Sailboat02.M2", -- [77]
									"Uldum_Sailboat03.M2", -- [78]
									"Uldum_Star_Portal_01.M2", -- [79]
									"Uldum_Sundial.M2", -- [80]
									"Uldum_Sunsigil_Beam.M2", -- [81]
									"Uldum_mausoleum.M2", -- [82]
									"uldum_anvil.M2", -- [83]
									"uldum_anvil_02.M2", -- [84]
									"uldum_anvil_hammer.M2", -- [85]
									"uldum_sailboat.M2", -- [86]
									"uldum_scarab_01.M2", -- [87]
									"uldum_wagon.M2", -- [88]
								},
								["N"] = "Uldum",
							}, -- [32]
							{
								["T"] = {
									{
										["T"] = {
											"VJ_AnemoneLRG01.M2", -- [1]
											"VJ_AnemoneLRG02.M2", -- [2]
											"VJ_AnemoneLRG03.M2", -- [3]
											"VJ_AnemoneLRG04.M2", -- [4]
											"VJ_AnemoneLRG05.M2", -- [5]
											"VJ_AnemoneSM01.M2", -- [6]
											"VJ_AnemoneSm02.M2", -- [7]
											"VJ_AnemoneSm03.M2", -- [8]
											"VJ_GiantAnemone01.M2", -- [9]
											"VJ_GiantAnemone02.M2", -- [10]
											"VJ_GiantAnemone03.M2", -- [11]
										},
										["N"] = "Anemone",
									}, -- [1]
									{
										["T"] = {
											"VJ_Blood_drips_01.M2", -- [1]
										},
										["N"] = "Blood",
									}, -- [2]
									{
										["T"] = {
											"VJ_WhaleBones_01.M2", -- [1]
											"VJ_WhaleBones_02.M2", -- [2]
											"VJ_WhaleBones_03.M2", -- [3]
											"VJ_WhaleBones_04.M2", -- [4]
										},
										["N"] = "Bones",
									}, -- [3]
									{
										["T"] = {
											"VJ_BushCoralBrown01.M2", -- [1]
											"VJ_BushCoralGray01.M2", -- [2]
											"VJ_BushCoralGray02.M2", -- [3]
											"VJ_CoralBush_Bluegreen01.M2", -- [4]
											"VJ_CoralBush_Gray01.M2", -- [5]
											"VJ_CoralBush_Gray02.M2", -- [6]
											"VJ_CoralBush_Green01.M2", -- [7]
											"VJ_CoralBush_Green02.M2", -- [8]
											"VJ_CoralBush_Orange01.M2", -- [9]
											"VJ_CoralBush_Pink01.M2", -- [10]
											"VJ_CoralBush_Pink02.M2", -- [11]
											"VJ_CoralBush_Purple01.M2", -- [12]
											"VJ_CoralBush_Purple02.M2", -- [13]
											"VJ_CoralBush_Red01.M2", -- [14]
											"VJ_CoralBush_Red02.M2", -- [15]
											"VJ_CoralBush_Red03.M2", -- [16]
											"VJ_CoralBush_Violet01.M2", -- [17]
											"VJ_CoralClusterTop01.M2", -- [18]
											"VJ_CoralClusterTop02.M2", -- [19]
											"VJ_CoralFlatGold_02.M2", -- [20]
											"VJ_CoralFlatGreen_01.M2", -- [21]
											"VJ_CoralFlatPurple_01.M2", -- [22]
											"VJ_CoralFlatRed_01.M2", -- [23]
											"VJ_CoralFlatRed_02.M2", -- [24]
											"VJ_CoralFlat_01.M2", -- [25]
											"VJ_CoralFlat_02.M2", -- [26]
											"VJ_CoralFlat_03.M2", -- [27]
											"VJ_CoralMutated01.M2", -- [28]
											"VJ_CoralMutated02.M2", -- [29]
											"VJ_CoralMutated03.M2", -- [30]
											"VJ_CoralSpikey_01.M2", -- [31]
											"VJ_CoralSpikey_02.M2", -- [32]
											"VJ_CoralSpikey_03.M2", -- [33]
											"VJ_CoralTableMid01.M2", -- [34]
											"VJ_CoralTableMid02.M2", -- [35]
											"VJ_CoralTableMid03.M2", -- [36]
											"VJ_CoralTableMid04.M2", -- [37]
											"VJ_CoralTableMid05.M2", -- [38]
											"VJ_CoralTableSpiky01.M2", -- [39]
											"VJ_CoralTableSpiky02.M2", -- [40]
											"VJ_CoralTableSpiky03.M2", -- [41]
											"VJ_CoralTableSpikyCluster01.M2", -- [42]
											"VJ_CoralTableTop01.M2", -- [43]
											"VJ_CoralTableTop02.M2", -- [44]
											"VJ_CoralTableTop03.M2", -- [45]
											"VJ_CoralTableTop04.M2", -- [46]
											"VJ_CoralTableTop05.M2", -- [47]
											"VJ_CoralTableTopBlue01.M2", -- [48]
											"VJ_CoralTableTopGold01.M2", -- [49]
											"VJ_CoralTableTopGreen01.M2", -- [50]
											"VJ_CoralTableTopRed01.M2", -- [51]
											"VJ_CoralThickBlue_02.M2", -- [52]
											"VJ_CoralThickGold_02.M2", -- [53]
											"VJ_CoralThickOrange_01.M2", -- [54]
											"VJ_CoralThickOrange_02.M2", -- [55]
											"VJ_CoralThickPink_02.M2", -- [56]
											"VJ_CoralThickPink_03.M2", -- [57]
											"VJ_CoralThickPurple_02.M2", -- [58]
											"VJ_CoralThickPurple_03.M2", -- [59]
											"VJ_CoralThickRed_02.M2", -- [60]
											"VJ_CoralThick_01.M2", -- [61]
											"VJ_CoralThick_02.M2", -- [62]
											"VJ_CoralThick_03.M2", -- [63]
											"VJ_Coral_Tree_Large_01.M2", -- [64]
											"VJ_Coral_Tree_Large_02.M2", -- [65]
											"VJ_Coral_Tree_Large_03.M2", -- [66]
											"VJ_CucumberCoralGreen01.M2", -- [67]
											"VJ_FanCoralMid01.M2", -- [68]
											"VJ_FanCoralMid02.M2", -- [69]
											"VJ_FanCoral_Large_01.M2", -- [70]
											"VJ_GiantClam01.M2", -- [71]
											"VJ_GiantCoral01.M2", -- [72]
											"VJ_GiantCoral02.M2", -- [73]
											"VJ_GiantCoral03.M2", -- [74]
											"VJ_GiantCoral04.M2", -- [75]
											"VJ_GiantCoral06.M2", -- [76]
											"VJ_GiantCoral_BlueGreen01.M2", -- [77]
											"VJ_GiantCoral_BlueGreen02.M2", -- [78]
											"VJ_GiantCoral_BlueGreen03.M2", -- [79]
											"VJ_GiantCoral_BlueGreen04.M2", -- [80]
											"VJ_GiantCoral_Glowy01.M2", -- [81]
											"VJ_GiantCoral_Glowy02.M2", -- [82]
											"VJ_GiantCoral_Glowy03.M2", -- [83]
											"VJ_GiantCoral_Glowy04.M2", -- [84]
											"VJ_GiantCoral_Glowy05.M2", -- [85]
											"VJ_GiantCoral_Glowy06.M2", -- [86]
											"VJ_GiantCoral_Glowy07.M2", -- [87]
											"VJ_GiantCoral_Glowy08.M2", -- [88]
											"VJ_GiantCoral_Pink01.M2", -- [89]
											"VJ_GiantCoral_Pink02.M2", -- [90]
											"VJ_GiantCoral_Pink03.M2", -- [91]
											"VJ_GiantCoral_Pink04.M2", -- [92]
											"VJ_GiantCoral_Pink05.M2", -- [93]
											"VJ_GiantCoral_Pink06.M2", -- [94]
											"VJ_GiantCoral_Pink07.M2", -- [95]
											"VJ_GiantCoral_Pink08.M2", -- [96]
											"VJ_GiantCoral_Pink09.M2", -- [97]
											"VJ_GiantCoral_Pink10.M2", -- [98]
											"VJ_GiantCoral_Pink11.M2", -- [99]
											"VJ_GiantCoral_Pink12.M2", -- [100]
											"VJ_GiantCoral_Pink13.M2", -- [101]
											"VJ_GiantCoral_Pink14.M2", -- [102]
											"VJ_GiantCoral_Violet01.M2", -- [103]
											"VJ_GiantCoral_Violet02.M2", -- [104]
											"VJ_GiantCoral_Violet03.M2", -- [105]
											"VJ_GiantCoral_Violet04.M2", -- [106]
											"VJ_GiantFanCoral_01.M2", -- [107]
											"VJ_GiantFanCoral_02.M2", -- [108]
											"VJ_GiantFanCoral_03.M2", -- [109]
											"VJ_GiantFanCoral_04.M2", -- [110]
											"VJ_MushroomCoralGreen01.M2", -- [111]
											"VJ_PipeCoralOrange01.M2", -- [112]
											"VJ_SeaSpongeBrown01.M2", -- [113]
											"VJ_SeagrassGreen01.M2", -- [114]
											"VJ_SpikedBushCoral01.M2", -- [115]
											"VJ_SpikedBushCoral02.M2", -- [116]
											"VJ_SpikedBushCoral03.M2", -- [117]
											"VJ_SpikedBushCoral04.M2", -- [118]
											"VJ_SpikedTreeCoral01.M2", -- [119]
											"VJ_SpikedTreeCoral02.M2", -- [120]
											"VJ_SpikedTreeCoral03.M2", -- [121]
											"VJ_SpikedTreeCoral04.M2", -- [122]
											"VJ_SpikedTreeCoral05.M2", -- [123]
											"VJ_SpikedTreeCoral06.M2", -- [124]
											"VJ_SpikedTreeCoral07.M2", -- [125]
											"VJ_SpongeCoral_01.M2", -- [126]
											"VJ_SpongeCoral_02.M2", -- [127]
											"VJ_SpongeCoral_03.M2", -- [128]
											"VJ_SpongeCoral_04.M2", -- [129]
											"VJ_SpongeCoral_05.M2", -- [130]
											"VJ_SpongeCoral_06.M2", -- [131]
											"VJ_SpongeCoral_07.M2", -- [132]
											"VJ_SpongeCoral_08.M2", -- [133]
											"VJ_SpongeCoral_09.M2", -- [134]
											"VJ_SpongeCoral_10.M2", -- [135]
											"VJ_SpongeCoral_10_Orange.M2", -- [136]
											"VJ_SpongeCoral_11.M2", -- [137]
											"VJ_SpongeCoral_11_Orange.M2", -- [138]
											"VJ_SpongeCoral_12.M2", -- [139]
											"VJ_SpongeCoral_12_Orange.M2", -- [140]
											"VJ_TreeCoralGray01.M2", -- [141]
											"VJ_TreeCoralGray02.M2", -- [142]
											"VJ_TreeCoralGray03.M2", -- [143]
										},
										["N"] = "Corals",
									}, -- [4]
									{
										["T"] = {
											"VJ_Demigod_Door.M2", -- [1]
											"VJ_Demigod_Lightshaft_01.M2", -- [2]
											"VJ_Demigod_Skin_Flakes.M2", -- [3]
											"VJ_Demigod_heart1.M2", -- [4]
											"VJ_Demigod_organ1.M2", -- [5]
										},
										["N"] = "Demigod",
									}, -- [5]
									{
										["T"] = {
											"VJ_Dome_01.M2", -- [1]
											"VJ_Dome_Eye_01.M2", -- [2]
											"VJ_Dome_Glowcards.M2", -- [3]
										},
										["N"] = "Domes",
									}, -- [6]
									{
										["T"] = {
											"VJ_Drapes_01.M2", -- [1]
											"VJ_Drapes_02.M2", -- [2]
											"VJ_Drapes_03.M2", -- [3]
											"VJ_Drapes_04.M2", -- [4]
										},
										["N"] = "Drapes",
									}, -- [7]
									{
										["T"] = {
											"VJ_BluGrenBrtGlow_01.M2", -- [1]
											"VJ_BluGrenBrtGlow_01_long.M2", -- [2]
											"VJ_BluGrenGlow_01.M2", -- [3]
											"VJ_BluGrenGlow_01_long.M2", -- [4]
											"VJ_BlueGlow_01.M2", -- [5]
											"VJ_BlueGlow_01_long.M2", -- [6]
											"VJ_DkBlueGlow_01.M2", -- [7]
											"VJ_DkBlueGlow_01_long.M2", -- [8]
											"VJ_DkBlueRedGlow_01.M2", -- [9]
											"VJ_DkBlueRedGlow_01_long.M2", -- [10]
											"VJ_PurpleGlow_01.M2", -- [11]
											"VJ_PurpleGlow_01_long.M2", -- [12]
										},
										["N"] = "Glows",
									}, -- [8]
									{
										["T"] = {
											"VJ_BullKelp01.M2", -- [1]
											"VJ_BullKelp02.M2", -- [2]
											"VJ_BullKelp03.M2", -- [3]
											"VJ_BullKelp04.M2", -- [4]
											"VJ_BullKelp05.M2", -- [5]
											"VJ_BullKelp06.M2", -- [6]
											"VJ_BullKelp07.M2", -- [7]
											"VJ_HangingKelpRed01.M2", -- [8]
											"VJ_HangingKelpRed02.M2", -- [9]
											"VJ_HangingKelpRed03.M2", -- [10]
											"VJ_Kelp01.M2", -- [11]
											"VJ_KelpBlue01.M2", -- [12]
											"VJ_KelpGreen01.M2", -- [13]
											"VJ_KelpRed01.M2", -- [14]
											"VJ_KelpStatic01.M2", -- [15]
											"VJ_KelpYellow01.M2", -- [16]
											"VJ_SeaWeed_01.M2", -- [17]
											"VJ_SeaWeed_02.M2", -- [18]
										},
										["N"] = "Kelp",
									}, -- [9]
									{
										["T"] = {
											"VJ_GiantPearl.M2", -- [1]
											"VJ_GiantPearl_Cage.M2", -- [2]
										},
										["N"] = "Pearl",
									}, -- [10]
									{
										["T"] = {
											"VJ_RockFormationBit_01.M2", -- [1]
											"VJ_RockFormationBit_02.M2", -- [2]
											"VJ_RockFormationBit_03.M2", -- [3]
											"VJ_RockFormation_01.M2", -- [4]
											"VJ_RockFormation_02.M2", -- [5]
											"VJ_RockFormation_03.M2", -- [6]
											"VJ_RockHole_01.M2", -- [7]
											"VJ_RockHole_02.M2", -- [8]
											"VJ_RockLarge_01.M2", -- [9]
											"VJ_RockLarge_02.M2", -- [10]
											"VJ_Rocks_01.M2", -- [11]
											"VJ_Rocks_02.M2", -- [12]
											"VJ_Rocks_03.M2", -- [13]
											"VJ_VortexRock_01.M2", -- [14]
										},
										["N"] = "Rocks",
									}, -- [11]
									{
										["T"] = {
											"VJ_WhiteSandPile01.M2", -- [1]
										},
										["N"] = "Sand",
									}, -- [12]
									{
										["T"] = {
											"VJ_SeaMonster_BonesSkull_01.M2", -- [1]
											"VJ_SeaMonster_BonesSkull_02.M2", -- [2]
											"VJ_SeaMonster_BonesSkull_03.M2", -- [3]
											"VJ_SeaMonster_BonesSkull_04.M2", -- [4]
										},
										["N"] = "Seamonster",
									}, -- [13]
									{
										["T"] = {
											"VJ_Giant_Shells01.M2", -- [1]
											"VJ_Giant_Shells02.M2", -- [2]
											"VJ_Giant_Shells03.M2", -- [3]
											"VJ_Giant_Shells04.M2", -- [4]
											"VJ_Giant_Shells05.M2", -- [5]
											"VJ_Giant_Shells06.M2", -- [6]
											"VJ_Giant_Shells07.M2", -- [7]
											"VJ_Giant_Shells08.M2", -- [8]
											"VJ_Giant_Shells08_Purple.M2", -- [9]
											"VJ_Giant_Shells08_tilt.M2", -- [10]
											"VJ_Giant_Shells09.M2", -- [11]
											"VJ_Giant_Shells09_Blue.M2", -- [12]
											"VJ_Giant_Shells10.M2", -- [13]
											"VJ_Giant_Shells10_Orange.M2", -- [14]
											"VJ_Giant_Shells11.M2", -- [15]
											"VJ_Giant_Shells11_Purple.M2", -- [16]
										},
										["N"] = "Shells",
									}, -- [14]
									{
										["T"] = {
											"Shipwreck_UD_pieces01.M2", -- [1]
											"Shipwreck_UD_pieces02.M2", -- [2]
											"Shipwreck_pieces01.M2", -- [3]
											"Shipwreck_pieces02.M2", -- [4]
										},
										["N"] = "Shipwreck",
									}, -- [15]
									{
										["T"] = {
											"Vashjir_Sparkles01.M2", -- [1]
										},
										["N"] = "Sparkles",
									}, -- [16]
									{
										["T"] = {
											"VJ_Dome_Tentacles_01.M2", -- [1]
										},
										["N"] = "Tentacles",
									}, -- [17]
									{
										["T"] = {
											"VJ_DeepSeaTubeworm01.M2", -- [1]
											"VJ_DeepSeaTubeworm02.M2", -- [2]
											"VJ_DeepSeaTubeworm03.M2", -- [3]
											"VJ_GlowingTubewormCluster01.M2", -- [4]
											"VJ_GlowingTubewormCluster02.M2", -- [5]
											"VJ_GlowingTubewormCluster03.M2", -- [6]
											"VJ_GlowingTubewormCluster04.M2", -- [7]
											"VJ_GlowingTubewormCluster05.M2", -- [8]
											"VJ_GlowingTubewormPlume01.M2", -- [9]
											"VJ_GlowingTubewormPlume02.M2", -- [10]
											"VJ_GlowingTubeworms01.M2", -- [11]
											"VJ_GlowingTubeworms02.M2", -- [12]
											"VJ_GlowingTubeworms03.M2", -- [13]
											"VJ_GlowingTubeworms04.M2", -- [14]
											"VJ_LiveTubewormCluster01.M2", -- [15]
											"VJ_TubewormCluster01.M2", -- [16]
											"VJ_TubewormCluster02.M2", -- [17]
											"VJ_TubewormCluster03.M2", -- [18]
											"VJ_TubewormCluster04.M2", -- [19]
											"VJ_TubewormPlume01.M2", -- [20]
											"VJ_TubewormPlume02.M2", -- [21]
											"VJ_TubewormPlume03.M2", -- [22]
											"VJ_Tubeworm_01.M2", -- [23]
											"VJ_Tubeworm_02.M2", -- [24]
											"VJ_Tubeworm_03.M2", -- [25]
											"VJ_Tubeworm_04.M2", -- [26]
										},
										["N"] = "Tubeworms",
									}, -- [18]
									{
										["T"] = {
											"VJ_Veins_medium.M2", -- [1]
											"VJ_Veins_thin.M2", -- [2]
											"VJ_Veins_wide.M2", -- [3]
										},
										["N"] = "Veins",
									}, -- [19]
									{
										["T"] = {
											"VJ_VolcanicVent02.M2", -- [1]
											"VJ_VolcanicVent02_Off.M2", -- [2]
											"VJ_VolcanicVent03.M2", -- [3]
											"VJ_VolcanicVent03_Off.M2", -- [4]
											"VJ_VolcanicVent04.M2", -- [5]
											"VJ_VolcanicVent04_Off.M2", -- [6]
											"VJ_VolcanicVent05.M2", -- [7]
											"VJ_VolcanicVent05_Off.M2", -- [8]
											"VJ_VolcanicVent_Steam_01.M2", -- [9]
											"VJ_VolcanicVent_Steam_02.M2", -- [10]
										},
										["N"] = "Volcano",
									}, -- [20]
									{
										["T"] = {
											"VJ_VortexWind_01.M2", -- [1]
											"VJ_VortexWind_02.M2", -- [2]
											"VJ_VortexWind_03.M2", -- [3]
											"VJ_VortexWind_04.M2", -- [4]
											"VJ_VortexWind_05.M2", -- [5]
										},
										["N"] = "Vortex",
									}, -- [21]
									{
										["T"] = {
											"VJ_Domes_Webs_01.M2", -- [1]
											"VJ_Domes_Webs_02.M2", -- [2]
										},
										["N"] = "Webs",
									}, -- [22]
									{
										["T"] = {
											"VJ_Whirlpool01.M2", -- [1]
										},
										["N"] = "Whirlpools",
									}, -- [23]
									"VJ_FloorTile_01.M2", -- [24]
									"VJ_FloorTile_02.M2", -- [25]
									"VJ_FloorTile_03.M2", -- [26]
									"VJ_Quest_Mushroom.M2", -- [27]
								},
								["N"] = "Vashjir",
							}, -- [33]
							{
								["T"] = {
									{
										["T"] = {
											"Wildhammer_Banner_01.M2", -- [1]
											"Wildhammer_Banner_02.M2", -- [2]
										},
										["N"] = "Banner",
									}, -- [1]
									{
										["T"] = {
											"Wildhammer_Fountain_01.M2", -- [1]
										},
										["N"] = "Fountain",
									}, -- [2]
									{
										["T"] = {
											"Wildhammer_Gryphon_Chicks.M2", -- [1]
										},
										["N"] = "Gryphonchicks",
									}, -- [3]
									{
										["T"] = {
											"Wildhammer_Gryphon_Incubator.M2", -- [1]
										},
										["N"] = "Gryphonincubator",
									}, -- [4]
									{
										["T"] = {
											"Wildhammer_Gryphon_Shed.M2", -- [1]
											"Wildhammer_Gryphon_Shed_Broken_01.M2", -- [2]
											"Wildhammer_Gryphon_Shed_Broken_02.M2", -- [3]
											"Wildhammer_Gryphon_Shed_No_Gryphon.M2", -- [4]
											"Wildhammer_Shed_01.M2", -- [5]
											"Wildhammer_Shed_01_Broken.M2", -- [6]
										},
										["N"] = "Gryphonshed",
									}, -- [5]
									{
										["T"] = {
											"Wildhammer_RuinedPillar1.M2", -- [1]
											"Wildhammer_RuinedPillar2.M2", -- [2]
											"Wildhammer_RuinedPillar3.M2", -- [3]
										},
										["N"] = "Pillars",
									}, -- [6]
									{
										["T"] = {
											"Wildhammer_Road_Marker_01.M2", -- [1]
											"Wildhammer_Road_Marker_Post.M2", -- [2]
											"Wildhammer_Road_Marker_Post_Destroyed.M2", -- [3]
											"Wildhammer_Road_Marker_Post_Destroyed_02.M2", -- [4]
											"Wildhammer_Road_Marker_Post_OFF.M2", -- [5]
										},
										["N"] = "Roadmarker",
									}, -- [7]
									{
										["T"] = {
											"Wildhammer_Rubble_01.M2", -- [1]
											"Wildhammer_Rubble_02.M2", -- [2]
										},
										["N"] = "Rubble",
									}, -- [8]
									{
										["T"] = {
											"Wildhammer_shelf_01.M2", -- [1]
										},
										["N"] = "Shelf",
									}, -- [9]
									{
										["T"] = {
											"Wildhammer_Stonethrower_01.M2", -- [1]
										},
										["N"] = "Stonethrower",
									}, -- [10]
									{
										["T"] = {
											"Wildhammer_StonePole_01.M2", -- [1]
											"Wildhammer_StoneWall_01.M2", -- [2]
											"Wildhammer_StoneWall_01_Broken.M2", -- [3]
											"Wildhammer_StoneWall_02.M2", -- [4]
											"Wildhammer_StoneWall_03.M2", -- [5]
											"Wildhammer_StoneWall_04.M2", -- [6]
											"Wildhammer_StoneWall_05.M2", -- [7]
											"Wildhammer_StoneWall_06.M2", -- [8]
											"Wildhammer_StoneWall_06_Broken.M2", -- [9]
											"Wildhammer_StoneWall_07.M2", -- [10]
											"Wildhammer_StoneWall_07_Broken.M2", -- [11]
											"Wildhammer_StoneWall_08.M2", -- [12]
											"Wildhammer_StoneWall_09.M2", -- [13]
											"Wildhammer_StoneWall_10.M2", -- [14]
											"Wildhammer_StoneWall_11.M2", -- [15]
										},
										["N"] = "Stonewall",
									}, -- [11]
									{
										["T"] = {
											"Wildhammer_StormHammer_01.M2", -- [1]
											"Wildhammer_StormHammer_02.M2", -- [2]
											"Wildhammer_StormHammer_03.M2", -- [3]
										},
										["N"] = "Stormhammer",
									}, -- [12]
									{
										["T"] = {
											"wildhammer_stove.M2", -- [1]
										},
										["N"] = "Stove",
									}, -- [13]
									{
										["T"] = {
											"Wildhammer_Wagon_01.M2", -- [1]
										},
										["N"] = "Wagon",
									}, -- [14]
									{
										["T"] = {
											"Wildhammer_Well_02.M2", -- [1]
											"Wildhammer_Well_02_Broken.M2", -- [2]
										},
										["N"] = "Well",
									}, -- [15]
									"Wildhammer_ChimneySmoke.M2", -- [16]
									"Wildhammer_Fog.M2", -- [17]
									"Wildhammer_support.M2", -- [18]
								},
								["N"] = "Wildhammer",
							}, -- [34]
							{
								["T"] = {
									{
										["T"] = {
											"Worgen_Footbridgebridge_01.M2", -- [1]
											"Worgen_Footbridgebridge_02.M2", -- [2]
										},
										["N"] = "Bridges",
									}, -- [1]
									{
										["T"] = {
											"Gilneas_DwellingWater_01.M2", -- [1]
											"Gilneas_Sparkles01.M2", -- [2]
											"Worgen_PuddleSplash_01.M2", -- [3]
											"Worgen_Raindrips_01.M2", -- [4]
										},
										["N"] = "Effects",
									}, -- [2]
									{
										["T"] = {
											"Worgen_ChickenCoup_01.M2", -- [1]
											"Worgen_ChickenCoup_02.M2", -- [2]
											"Worgen_ChickenCoup_03.M2", -- [3]
											"Worgen_ChickenCoup_ALL.M2", -- [4]
											"Worgen_Windmill_01.M2", -- [5]
											"Worgen_Windmill_02.M2", -- [6]
										},
										["N"] = "Farm",
									}, -- [3]
									{
										["T"] = {
											"Worgen_FenceArch_01.M2", -- [1]
											"Worgen_FenceArch_02.M2", -- [2]
											"Worgen_FenceArch_03.M2", -- [3]
											"Worgen_FencePost_01.M2", -- [4]
											"Worgen_Fence_01.M2", -- [5]
											"Worgen_Fence_02.M2", -- [6]
											"Worgen_Fence_03.M2", -- [7]
											"Worgen_Fence_04.M2", -- [8]
											"Worgen_Gate_01.M2", -- [9]
											"Worgen_Tent_01.M2", -- [10]
											"Worgen_Tent_02.M2", -- [11]
											"Worgen_TownFence_01.M2", -- [12]
											"Worgen_TownFence_02.M2", -- [13]
											"Worgen_TownFence_03.M2", -- [14]
											"Worgen_TownGate_01.M2", -- [15]
											"Worgen_TownLamp_01.M2", -- [16]
											"Worgen_TownLamp_01_OFF.M2", -- [17]
											"Worgen_TownLamp_02.M2", -- [18]
											"Worgen_TownLamp_03.M2", -- [19]
											"Worgen_TownLamp_03_Broke.M2", -- [20]
											"Worgen_TownLamp_03_OFF.M2", -- [21]
										},
										["N"] = "Fences",
									}, -- [4]
									{
										["T"] = {
											"Worgen_Afgan_01.M2", -- [1]
											"Worgen_Afgan_02.M2", -- [2]
											"Worgen_Anvil_01.M2", -- [3]
											"Worgen_Banner_01.M2", -- [4]
											"Worgen_Banner_02.M2", -- [5]
											"Worgen_Barrel_01.M2", -- [6]
											"Worgen_Barrel_01_Fire.M2", -- [7]
											"Worgen_Barrel_Apple_01.M2", -- [8]
											"Worgen_Barrel_Broken.M2", -- [9]
											"Worgen_Barrel_Corn_01.M2", -- [10]
											"Worgen_Barricade_01.M2", -- [11]
											"Worgen_Barricade_02.M2", -- [12]
											"Worgen_Barricade_03.M2", -- [13]
											"Worgen_Barricade_04.M2", -- [14]
											"Worgen_Barricade_05.M2", -- [15]
											"Worgen_BedBunk_01.M2", -- [16]
											"Worgen_BedBunk_02.M2", -- [17]
											"Worgen_BedLadder.M2", -- [18]
											"Worgen_Bed_Kid_01.M2", -- [19]
											"Worgen_Bed_Kid_02.M2", -- [20]
											"Worgen_Bed_Large_01.M2", -- [21]
											"Worgen_Bed_Large_02.M2", -- [22]
											"Worgen_Bed_Mid_01.M2", -- [23]
											"Worgen_Bed_Mid_02.M2", -- [24]
											"Worgen_Bench_01.M2", -- [25]
											"Worgen_Bench_02.M2", -- [26]
											"Worgen_Bottle_01.M2", -- [27]
											"Worgen_Bottle_02.M2", -- [28]
											"Worgen_Bottle_03.M2", -- [29]
											"Worgen_Bottle_04.M2", -- [30]
											"Worgen_Bottle_05.M2", -- [31]
											"Worgen_Bottle_06.M2", -- [32]
											"Worgen_Bottle_07.M2", -- [33]
											"Worgen_Bottle_08.M2", -- [34]
											"Worgen_Bottle_09.M2", -- [35]
											"Worgen_Bottle_10.M2", -- [36]
											"Worgen_Brazier_01.M2", -- [37]
											"Worgen_Brick.M2", -- [38]
											"Worgen_Brick02.M2", -- [39]
											"Worgen_Cage_01.M2", -- [40]
											"Worgen_Cage_01_Active.M2", -- [41]
											"Worgen_Cage_02_Active.M2", -- [42]
											"Worgen_Cage_Tall.M2", -- [43]
											"Worgen_Candle.M2", -- [44]
											"Worgen_Cauldron_01.M2", -- [45]
											"Worgen_Cauldron_01_noCollision.M2", -- [46]
											"Worgen_Cellar_Door_01.M2", -- [47]
											"Worgen_Chair_01.M2", -- [48]
											"Worgen_Charm.M2", -- [49]
											"Worgen_Clothes_01.M2", -- [50]
											"Worgen_Clothes_02.M2", -- [51]
											"Worgen_Clothes_03.M2", -- [52]
											"Worgen_Clothes_04.M2", -- [53]
											"Worgen_Clothes_05.M2", -- [54]
											"Worgen_Clothes_06.M2", -- [55]
											"Worgen_Clothes_07.M2", -- [56]
											"Worgen_Crate01.M2", -- [57]
											"Worgen_Crate_Broken_01.M2", -- [58]
											"Worgen_Crate_Broken_02.M2", -- [59]
											"Worgen_Crate_Broken_03.M2", -- [60]
											"Worgen_Crypt_01.M2", -- [61]
											"Worgen_Crypt_02.M2", -- [62]
											"Worgen_Crypt_03.M2", -- [63]
											"Worgen_Debris_01_Fire.M2", -- [64]
											"Worgen_Debris_02_Fire.M2", -- [65]
											"Worgen_Door_01.M2", -- [66]
											"Worgen_Door_02.M2", -- [67]
											"Worgen_FarmMoth_01.M2", -- [68]
											"Worgen_FarmMoth_02.M2", -- [69]
											"Worgen_Fish_Barrel.M2", -- [70]
											"Worgen_Fishing_Rack_01.M2", -- [71]
											"Worgen_Flag.M2", -- [72]
											"Worgen_Flag_02.M2", -- [73]
											"Worgen_Flagpole_01.M2", -- [74]
											"Worgen_FloatingBarrel_01.M2", -- [75]
											"Worgen_FloatingCrate_01.M2", -- [76]
											"Worgen_FloatingPlank_01.M2", -- [77]
											"Worgen_FloatingPlank_02.M2", -- [78]
											"Worgen_FloatingScarecrow_01.M2", -- [79]
											"Worgen_FloatingShed_01.M2", -- [80]
											"Worgen_FloatingWheelbarrow_01.M2", -- [81]
											"Worgen_FlowersDry_01.M2", -- [82]
											"Worgen_Forge_01.M2", -- [83]
											"Worgen_Gallows.M2", -- [84]
											"Worgen_Gallows2.M2", -- [85]
											"Worgen_Gibbet.M2", -- [86]
											"Worgen_Gibbet_02.M2", -- [87]
											"Worgen_GraveStone01.M2", -- [88]
											"Worgen_GraveStone02.M2", -- [89]
											"Worgen_GraveStone03.M2", -- [90]
											"Worgen_GraveStone04.M2", -- [91]
											"Worgen_GraveStone05.M2", -- [92]
											"Worgen_GraveStone06.M2", -- [93]
											"Worgen_InnTable.M2", -- [94]
											"Worgen_IronMaiden_01.M2", -- [95]
											"Worgen_IronMaiden_02.M2", -- [96]
											"Worgen_Keg_01.M2", -- [97]
											"Worgen_Lamp_02.M2", -- [98]
											"Worgen_Lamp_03.M2", -- [99]
											"Worgen_Lamp_04.M2", -- [100]
											"Worgen_Lamp_05.M2", -- [101]
											"Worgen_Lamp_06.M2", -- [102]
											"Worgen_Luggage_01.M2", -- [103]
											"Worgen_Luggage_02.M2", -- [104]
											"Worgen_Luggage_03.M2", -- [105]
											"Worgen_Luggage_04.M2", -- [106]
											"Worgen_Luggage_05.M2", -- [107]
											"Worgen_Luggage_06.M2", -- [108]
											"Worgen_Mailbox.M2", -- [109]
											"Worgen_Nail.M2", -- [110]
											"Worgen_Nail_02.M2", -- [111]
											"Worgen_OldRubbleRocks_01.M2", -- [112]
											"Worgen_OldRubbleRocks_02.M2", -- [113]
											"Worgen_OldRubbleRocks_03.M2", -- [114]
											"Worgen_OldRubbleRocks_04.M2", -- [115]
											"Worgen_OldRubbleRocks_05.M2", -- [116]
											"Worgen_OldRubble_01.M2", -- [117]
											"Worgen_OldRubble_02.M2", -- [118]
											"Worgen_OldRubble_03.M2", -- [119]
											"Worgen_OldRubble_04.M2", -- [120]
											"Worgen_OldRubble_05.M2", -- [121]
											"Worgen_OldRubble_06.M2", -- [122]
											"Worgen_OldRubble_07.M2", -- [123]
											"Worgen_OldRubble_08.M2", -- [124]
											"Worgen_OldRubble_09.M2", -- [125]
											"Worgen_OutHouse.M2", -- [126]
											"Worgen_Paddle.M2", -- [127]
											"Worgen_Paper_01.M2", -- [128]
											"Worgen_Paper_02.M2", -- [129]
											"Worgen_Paper_03.M2", -- [130]
											"Worgen_Paper_04.M2", -- [131]
											"Worgen_Paper_05.M2", -- [132]
											"Worgen_Paper_06.M2", -- [133]
											"Worgen_Paper_07.M2", -- [134]
											"Worgen_Paper_08.M2", -- [135]
											"Worgen_Paper_09.M2", -- [136]
											"Worgen_Paper_10.M2", -- [137]
											"Worgen_Paper_11.M2", -- [138]
											"Worgen_Paper_12.M2", -- [139]
											"Worgen_Paper_Animated_01.M2", -- [140]
											"Worgen_Paper_Animated_02.M2", -- [141]
											"Worgen_Paper_Animated_03.M2", -- [142]
											"Worgen_Paper_Quest.M2", -- [143]
											"Worgen_Pillow_01.M2", -- [144]
											"Worgen_Pillow_02.M2", -- [145]
											"Worgen_Pillow_03.M2", -- [146]
											"Worgen_Pillow_04.M2", -- [147]
											"Worgen_Pitchfork_01.M2", -- [148]
											"Worgen_Plank_01.M2", -- [149]
											"Worgen_Plank_01_Fire.M2", -- [150]
											"Worgen_Poodad_Horse.M2", -- [151]
											"Worgen_Rakecart.M2", -- [152]
											"Worgen_RockingChair.M2", -- [153]
											"Worgen_RoofCap.M2", -- [154]
											"Worgen_RowBoat01.M2", -- [155]
											"Worgen_RowBoat02.M2", -- [156]
											"Worgen_RowBoat03.M2", -- [157]
											"Worgen_RowBoat_Broken01.M2", -- [158]
											"Worgen_RowBoat_Broken02.M2", -- [159]
											"Worgen_RowBoat_Broken03.M2", -- [160]
											"Worgen_Saddle_01.M2", -- [161]
											"Worgen_Scarecrow.M2", -- [162]
											"Worgen_Sheers_01.M2", -- [163]
											"Worgen_Shelf_01.M2", -- [164]
											"Worgen_Shelf_02.M2", -- [165]
											"Worgen_Shingle_01.M2", -- [166]
											"Worgen_Shingle_02.M2", -- [167]
											"Worgen_Sign01.M2", -- [168]
											"Worgen_Sign01_Broken.M2", -- [169]
											"Worgen_Sign_Post.M2", -- [170]
											"Worgen_Sign_Post_Broken.M2", -- [171]
											"Worgen_Sign_Post_Broken_02.M2", -- [172]
											"Worgen_Stagecoach_01.M2", -- [173]
											"Worgen_Stagecoach_Wrecked_01.M2", -- [174]
											"Worgen_Stocks_01.M2", -- [175]
											"Worgen_Stocks_02.M2", -- [176]
											"Worgen_StoneCage_01.M2", -- [177]
											"Worgen_TableLamp_01.M2", -- [178]
											"Worgen_Table_01.M2", -- [179]
											"Worgen_Table_02.M2", -- [180]
											"Worgen_TackleBox_01.M2", -- [181]
											"Worgen_Tapestry_01.M2", -- [182]
											"Worgen_Tapestry_02.M2", -- [183]
											"Worgen_Test.M2", -- [184]
											"Worgen_TrainTrack_Angle_01.M2", -- [185]
											"Worgen_TrainTrack_Curve_01.M2", -- [186]
											"Worgen_TrainTrack_Straight_01.M2", -- [187]
											"Worgen_TrainTrack_Straight_02.M2", -- [188]
											"Worgen_Trellis_01.M2", -- [189]
											"Worgen_Trellis_02.M2", -- [190]
											"Worgen_Trellis_03.M2", -- [191]
											"Worgen_Trough.M2", -- [192]
											"Worgen_Wagon_01.M2", -- [193]
											"Worgen_Wagon_02.M2", -- [194]
											"Worgen_Wagon_03.M2", -- [195]
											"Worgen_Wagon_04.M2", -- [196]
											"Worgen_Wagon_05.M2", -- [197]
											"Worgen_Warning_Sign01.M2", -- [198]
											"Worgen_Warning_Sign02.M2", -- [199]
											"Worgen_Waterwheel.M2", -- [200]
											"Worgen_Wheel.M2", -- [201]
											"Worgen_Wheelbarrow01.M2", -- [202]
											"Worgen_WoodCross_01.M2", -- [203]
											"Worgen_guillotine.M2", -- [204]
											"Worgen_paper_Pile.M2", -- [205]
											"Worgen_paper_Pile_02.M2", -- [206]
											"Worgen_telescope.M2", -- [207]
										},
										["N"] = "Items",
									}, -- [5]
									{
										["T"] = {
											"Worgen_MarketShade_01.M2", -- [1]
											"Worgen_MarketShade_01_Broken.M2", -- [2]
											"Worgen_MarketShade_02.M2", -- [3]
											"Worgen_MarketShade_02_Broken.M2", -- [4]
											"Worgen_MarketShade_03.M2", -- [5]
											"Worgen_MarketShade_03_Broken.M2", -- [6]
											"Worgen_MarketShade_04.M2", -- [7]
											"Worgen_MarketStall_01.M2", -- [8]
											"Worgen_MarketStall_02.M2", -- [9]
											"Worgen_MarketStall_03.M2", -- [10]
											"Worgen_MarketStall_04.M2", -- [11]
											"Worgen_MarketStall_Broken_01.M2", -- [12]
											"Worgen_MarketStall_Broken_02.M2", -- [13]
											"Worgen_MarketStall_Broken_03.M2", -- [14]
											"Worgen_MarketStall_Broken_04.M2", -- [15]
											"Worgen_MarketStall_Broken_05.M2", -- [16]
											"Worgen_MarketStall_Broken_06.M2", -- [17]
										},
										["N"] = "Market",
									}, -- [6]
									{
										["T"] = {
											"Worgen_Painting_01.M2", -- [1]
											"Worgen_Painting_02.M2", -- [2]
											"Worgen_Painting_03.M2", -- [3]
											"Worgen_Painting_04.M2", -- [4]
											"Worgen_Painting_05.M2", -- [5]
											"Worgen_Painting_06.M2", -- [6]
											"Worgen_Painting_07.M2", -- [7]
											"Worgen_Painting_08.M2", -- [8]
											"Worgen_Painting_09.M2", -- [9]
											"Worgen_Painting_10.M2", -- [10]
											"Worgen_Painting_11.M2", -- [11]
											"Worgen_Painting_12.M2", -- [12]
										},
										["N"] = "Paintings",
									}, -- [7]
									{
										["T"] = {
											"Worgen_GuardCheck_01.M2", -- [1]
											"Worgen_GuardHouse_01.M2", -- [2]
											"Worgen_GuardHouse_02.M2", -- [3]
											"Worgen_Shed_01.M2", -- [4]
											"Worgen_Stable_01.M2", -- [5]
											"Worgen_Stable_02.M2", -- [6]
										},
										["N"] = "Sheds",
									}, -- [8]
									{
										["T"] = {
											"Worgen_CityGate01.M2", -- [1]
											"Worgen_CityGate01_ruined.M2", -- [2]
											"Worgen_CityGate02.M2", -- [3]
											"Worgen_CityGate_Cap.M2", -- [4]
											"Worgen_CityGate_Cap_02.M2", -- [5]
											"Worgen_CityWall_01.M2", -- [6]
											"Worgen_CityWall_01_Broken.M2", -- [7]
											"Worgen_CityWall_02.M2", -- [8]
											"Worgen_CityWall_02_Broken.M2", -- [9]
											"Worgen_CityWall_Brick_01.M2", -- [10]
											"Worgen_CityWall_Cap_01.M2", -- [11]
											"Worgen_CityWall_Cap_02.M2", -- [12]
											"Worgen_CityWall_Corner_01.M2", -- [13]
											"Worgen_GateWall01.M2", -- [14]
											"Worgen_Spike_01.M2", -- [15]
											"Worgen_Spike_02.M2", -- [16]
											"Worgen_Spike_03.M2", -- [17]
											"Worgen_StoneCorner_01.M2", -- [18]
											"Worgen_StoneCorner_02.M2", -- [19]
											"Worgen_StoneGate_01.M2", -- [20]
											"Worgen_StoneLamp_01.M2", -- [21]
											"Worgen_StoneMiddle_01.M2", -- [22]
											"Worgen_StoneWall_01.M2", -- [23]
											"Worgen_StoneWall_01_Broken.M2", -- [24]
											"Worgen_StoneWall_02.M2", -- [25]
											"Worgen_StoneWall_02_Broken.M2", -- [26]
											"Worgen_StoneWall_03.M2", -- [27]
											"Worgen_StoneWall_04.M2", -- [28]
											"Worgen_StoneWall_06.M2", -- [29]
										},
										["N"] = "Walls",
									}, -- [9]
									{
										["T"] = {
											"Worgen_Well.M2", -- [1]
										},
										["N"] = "Waterwell",
									}, -- [10]
									{
										["T"] = {
											"Worgen_HouseWindow_01.M2", -- [1]
											"Worgen_ManorWindow_01.M2", -- [2]
											"Worgen_WindowAnimated_01.M2", -- [3]
											"Worgen_WindowAnimated_02.M2", -- [4]
											"Worgen_WindowAnimated_04.M2", -- [5]
											"Worgen_WindowAnimated_05.M2", -- [6]
											"Worgen_WindowAnimated_06.M2", -- [7]
											"Worgen_WindowBroken_01.M2", -- [8]
										},
										["N"] = "Windows",
									}, -- [11]
									{
										["T"] = {
											"Worgen_MineCar_01.M2", -- [1]
											"Worgen_Mine_Buttress_01.M2", -- [2]
											"Worgen_Mine_Buttress_02.M2", -- [3]
											"Worgen_Mine_Rock_Ground_01.M2", -- [4]
											"Worgen_Mine_Rock_Ground_02.M2", -- [5]
											"Worgen_Mine_Rock_Ground_03.M2", -- [6]
											"Worgen_Mine_Rock_Ground_04.M2", -- [7]
											"Worgen_Mine_Rock_Ground_05.M2", -- [8]
											"Worgen_Mine_Rock_Ground_06.M2", -- [9]
											"Worgen_Mine_Rock_Ground_07.M2", -- [10]
											"Worgen_Mine_Rock_Pillar_01.M2", -- [11]
											"Worgen_Mine_Rock_Pillar_02.M2", -- [12]
											"Worgen_Mine_Rock_Pillar_03.M2", -- [13]
											"Worgen_Mine_Rock_Pillar_04.M2", -- [14]
											"Worgen_Mine_Rock_wall_01.M2", -- [15]
											"Worgen_Mine_Rock_wall_02.M2", -- [16]
											"Worgen_Mine_Rock_wall_03.M2", -- [17]
											"Worgen_Mine_Rock_wall_04.M2", -- [18]
											"Worgen_Mine_Rock_wall_05.M2", -- [19]
											"Worgen_Mine_Wood_01.M2", -- [20]
											"Worgen_Mine_Wood_02.M2", -- [21]
											"Worgen_Mine_Wood_Beam_01.M2", -- [22]
											"Worgen_Mine_Wood_Beam_02.M2", -- [23]
											"Worgen_Mine_Wood_Beam_03.M2", -- [24]
											"Worgen_Mine_Wood_Beam_04.M2", -- [25]
											"Worgen_Mine_Wood_CrossBeam_01.M2", -- [26]
											"Worgen_Mine_Wood_CrossBeam_02.M2", -- [27]
											"Worgen_Mine_Wood_CrossBeam_03.M2", -- [28]
											"Worgen_Mine_Wood_CrossBeam_04.M2", -- [29]
										},
										["N"] = "Worgenmicro",
									}, -- [12]
									"Worgen_CrowdStand_01.M2", -- [13]
								},
								["N"] = "Worgen",
							}, -- [35]
						},
						["N"] = "Doodads",
					}, -- [1]
				},
				["N"] = "Expansion03",
			}, -- [12]
			{
				["T"] = {
					{
						["T"] = {
							{
								["T"] = {
									{
										["T"] = {
											"Transport_Alliance_Battleship.M2", -- [1]
											"Transport_Alliance_Battleship_Low.M2", -- [2]
										},
										["N"] = "Boat",
									}, -- [1]
									{
										["T"] = {
											"alliance_human_cage.M2", -- [1]
										},
										["N"] = "Cages",
									}, -- [2]
									"human_wagon02_open.M2", -- [3]
								},
								["N"] = "Alliance",
							}, -- [1]
							{
								["T"] = {
									"PA_Alliance_Arena_Gate.M2", -- [1]
								},
								["N"] = "Alliancearena",
							}, -- [2]
							{
								["T"] = {
									"Alliance_MineCart_Prop_01.M2", -- [1]
									"PA_Alliance_Mine_Gears_01.M2", -- [2]
									"PA_Alliance_Mine_Gears_02.M2", -- [3]
									"PA_Alliance_Mine_Gears_03.M2", -- [4]
									"PA_Alliance_Mine_Gears_04.M2", -- [5]
									"PA_Alliance_Mine_Gears_05.M2", -- [6]
									"PA_Alliance_Mine_Gears_06.M2", -- [7]
									"PA_Alliance_Mine_Gears_07.M2", -- [8]
									"PA_Alliance_Mine_Pully_01.M2", -- [9]
									"PA_Alliance_Mine_Pully_02.M2", -- [10]
									"PA_Alliance_Mine_Pully_03.M2", -- [11]
								},
								["N"] = "Alliancemine",
							}, -- [3]
							{
								["T"] = {
									"TRADESKILL_ARCHAEOLOGYFIND_MANTID_01.M2", -- [1]
									"Tradeskill_ArchaeologyFind_Mogu_01.M2", -- [2]
									"Tradeskill_ArchaeologyFind_Mogu_02.M2", -- [3]
									"Tradeskill_ArchaeologyFind_Mogu_03.M2", -- [4]
									"Tradeskill_ArchaeologyFind_Pandaren_01.M2", -- [5]
									"Tradeskill_ArchaeologyFind_Pandaren_02.M2", -- [6]
									"Tradeskill_ArchaeologyFind_Pandaren_03.M2", -- [7]
									"Tradeskill_Archaeology_JadeEgg01.M2", -- [8]
									"Tradeskill_Archaeology_MoguBook01.M2", -- [9]
								},
								["N"] = "Archaeology",
							}, -- [4]
							{
								["T"] = {
									"Deathwing_Doodad.M2", -- [1]
								},
								["N"] = "Deathwing",
							}, -- [5]
							{
								["T"] = {
									"Tradeskill_Engineering_Anvil.M2", -- [1]
								},
								["N"] = "Engineering",
							}, -- [6]
							{
								["T"] = {
									{
										["T"] = {
											{
												["T"] = {
													"BloodElf_MiniSunwell_Orb.M2", -- [1]
												},
												["N"] = "Powerorb",
											}, -- [1]
										},
										["N"] = "Bloodelf",
									}, -- [1]
									{
										["T"] = {
											"nd_winterorc_construction_rockpile_large.M2", -- [1]
											"nd_winterorc_construction_rockpile_small.M2", -- [2]
											"nd_winterorc_construction_scaffolding_small.M2", -- [3]
											"nd_winterorc_construction_scaffolding_small_2.M2", -- [4]
											"nd_winterorc_wall_underconstruction_doodad.M2", -- [5]
										},
										["N"] = "Nd_winterorc",
									}, -- [2]
									"Axe_Doodad_01.M2", -- [3]
									"Beerhat_Doodad.M2", -- [4]
									"Club1HTorchA_Doodad.M2", -- [5]
									"Fezhat_Doodad.M2", -- [6]
									"Firearm_2H_Rifle_PVPCataclysmS3_C_01_Prop.M2", -- [7]
									"Hammer2HMoguB_Doodad.M2", -- [8]
									"Helm_Doodad_01.M2", -- [9]
									"LeiShen_LightningCrack_Impact_Doodad.M2", -- [10]
									"Polearm2HBladedA_Doodad.M2", -- [11]
									"Polearm_Doodad_01.M2", -- [12]
									"Polearm_Doodad_02.M2", -- [13]
									"Purplehat_Doodad.M2", -- [14]
									"Stave2hPanProgB_Doodad.M2", -- [15]
									"Stave_2H_Jeweled_C_01_Prop.M2", -- [16]
									"flyingbomber_02static.M2", -- [17]
								},
								["N"] = "Generic",
							}, -- [7]
							{
								["T"] = {
									"GoldRush_Crane_Dock.M2", -- [1]
									"GoldRush_ExcavationCrane.M2", -- [2]
									"Gold_rush_cart_high.M2", -- [3]
									"Gold_rush_cart_low.M2", -- [4]
									"Gold_rush_cart_med.M2", -- [5]
									"Goldrush_GoldVeins_01.M2", -- [6]
									"Goldrush_GoldVeins_02.M2", -- [7]
									"Goldrush_GoldVeins_03.M2", -- [8]
									"Goldrush_Goldnuget_lg.M2", -- [9]
									"Goldrush_Goldnugget_sm.M2", -- [10]
								},
								["N"] = "Goldrush",
							}, -- [8]
							{
								["T"] = {
									{
										["T"] = {
											"HZ_HangingTorchJungle_01.M2", -- [1]
											"HZ_TorchJungle_01.M2", -- [2]
											"HZ_TorchJungle_02.M2", -- [3]
											"HZ_TorchJungle_03.M2", -- [4]
											"HZ_TorchMountain_01.M2", -- [5]
											"HZ_TorchMountain_02.M2", -- [6]
										},
										["N"] = "Torches",
									}, -- [1]
									{
										["T"] = {
											"HZ_Totem_FeralHozu.M2", -- [1]
											"HZ_Totem_FeralHozu_Broken.M2", -- [2]
											"HZ_Totem_MountainHozu_01.M2", -- [3]
											"HZ_Totem_MountainHozu_Broken_01.M2", -- [4]
										},
										["N"] = "Totem",
									}, -- [2]
									"HZ_Cage_01.M2", -- [3]
									"HZ_Cage_02.M2", -- [4]
									"HZ_Camp_Fire_01.M2", -- [5]
									"HZ_Camp_Fire_02.M2", -- [6]
									"HZ_Crate.M2", -- [7]
									"HZ_CrateBroken.M2", -- [8]
									"HZ_CrateClosed.M2", -- [9]
									"HZ_Fence_Blue_01.M2", -- [10]
									"HZ_Fence_Blue_02.M2", -- [11]
									"HZ_Fence_Blue_03.M2", -- [12]
									"HZ_Fence_Blue_04.M2", -- [13]
									"HZ_Fence_Blue_05.M2", -- [14]
									"HZ_Fence_Blue_06.M2", -- [15]
									"HZ_Fence_Blue_07.M2", -- [16]
									"HZ_Fence_Blue_08.M2", -- [17]
									"HZ_HangingRopes_Connector_Large.M2", -- [18]
									"HZ_HangingRopes_Connector_Medium.M2", -- [19]
									"HZ_HangingRopes_Connector_Small.M2", -- [20]
									"HZ_HangingRopes_Large.M2", -- [21]
									"HZ_HangingRopes_Medium.M2", -- [22]
									"HZ_HangingRopes_Small.M2", -- [23]
									"HZ_Jar.M2", -- [24]
									"HZ_JarClosed.M2", -- [25]
									"HZ_MountainHozu_Cage_01.M2", -- [26]
									"HZ_MountainHozu_Cage_02.M2", -- [27]
									"HZ_Pouch.M2", -- [28]
									"HZ_PouchClosed.M2", -- [29]
								},
								["N"] = "Hozu",
							}, -- [9]
							{
								["T"] = {
									{
										["T"] = {
											"OrcRefugeBoard.M2", -- [1]
											"OrcRefugeBoard2.M2", -- [2]
											"OrcRefugeBoard3.M2", -- [3]
											"OrcRefugePike.M2", -- [4]
											"OrcRefugePike2.M2", -- [5]
											"OrcRefugePike3.M2", -- [6]
											"OrcRefugePillar.M2", -- [7]
											"OrcRefugePillar2.M2", -- [8]
										},
										["N"] = "Orcrefuge",
									}, -- [1]
								},
								["N"] = "Jadeforest",
							}, -- [10]
							{
								["T"] = {
									"Jinyu_Anvil_01.M2", -- [1]
									"Jinyu_Banner_01.M2", -- [2]
									"Jinyu_Basket_01.M2", -- [3]
									"Jinyu_Basket_01_Broken.M2", -- [4]
									"Jinyu_Basket_02.M2", -- [5]
									"Jinyu_Basket_Top.M2", -- [6]
									"Jinyu_Bowl_Empty.M2", -- [7]
									"Jinyu_Bowl_Food.M2", -- [8]
									"Jinyu_FishBasket_01.M2", -- [9]
									"Jinyu_Fish_Trap.M2", -- [10]
									"Jinyu_FishingNet_01.M2", -- [11]
									"Jinyu_FishingRack_01.M2", -- [12]
									"Jinyu_Forge.M2", -- [13]
									"Jinyu_Fountain_01.M2", -- [14]
									"Jinyu_MailBox.M2", -- [15]
									"Jinyu_Raft_01.M2", -- [16]
									"Jinyu_Shell_Shield_Wall_01.M2", -- [17]
									"Jinyu_Totem_01.M2", -- [18]
									"Jinyu_Totem_01_Broken.M2", -- [19]
									"Jinyu_Water_Jug.M2", -- [20]
									"Jinyu_Water_Light_01.M2", -- [21]
									"Jinyu_Water_Light_02.M2", -- [22]
									"Jinyu_Water_Whirlpool_Magic.M2", -- [23]
									"Jinyu_Weapon_Rack_01.M2", -- [24]
									"Jinyu_Weapon_Rack_No_Weapons.M2", -- [25]
									"Tuskarrspear_fishskewer.M2", -- [26]
								},
								["N"] = "Jinyu",
							}, -- [11]
							{
								["T"] = {
									"Korkron_Banner_01.M2", -- [1]
									"Korkron_Banner_02.M2", -- [2]
									"Korkron_Crate_01.M2", -- [3]
								},
								["N"] = "Korkron",
							}, -- [12]
							{
								["T"] = {
									{
										["T"] = {
											"KLS_waterfall02.M2", -- [1]
											"KLS_waterfall03.M2", -- [2]
											"KLS_waterfall04.M2", -- [3]
											"KLS_waterfall05.M2", -- [4]
											"KLS_waterfall06.M2", -- [5]
											"KLS_waterfall07.M2", -- [6]
										},
										["N"] = "Waterfalls",
									}, -- [1]
									"KLS_Boulder01.M2", -- [2]
									"KLS_Boulder02.M2", -- [3]
									"KLS_Boulder03.M2", -- [4]
									"KLS_Boulder04.M2", -- [5]
									"KLS_Boulder05.M2", -- [6]
									"KLS_Boulder06.M2", -- [7]
									"KLS_Boulder07.M2", -- [8]
									"KLS_FlatRocks_01_mossy.M2", -- [9]
									"KLS_FlatRocks_02_mossy.M2", -- [10]
									"KLS_FlatRocks_03_mossy.M2", -- [11]
									"KLS_FlatRocks_04_mossy.M2", -- [12]
									"KLS_FlatRocks_05_mossy.M2", -- [13]
									"KLS_FlatRocks_06_mossy.M2", -- [14]
									"KLS_HiddenPassTransition_01.M2", -- [15]
									"KLS_JungleBush01.M2", -- [16]
									"KLS_JungleBush02.M2", -- [17]
									"KLS_JungleRoots01.M2", -- [18]
									"KLS_JungleRoots02.M2", -- [19]
									"KLS_JungleRoots03.M2", -- [20]
									"KLS_JungleRoots04.M2", -- [21]
									"KLS_JungleTree01.M2", -- [22]
									"KLS_JungleTree02.M2", -- [23]
									"KLS_JungleTree03.M2", -- [24]
									"KLS_Redtree01.M2", -- [25]
									"KLS_Redtree02.M2", -- [26]
									"KLS_Redtree03.M2", -- [27]
									"KLS_Rocks_01.M2", -- [28]
									"KLS_Rocks_02.M2", -- [29]
									"KLS_Rocks_03.M2", -- [30]
									"KLS_Rocks_04.M2", -- [31]
									"KLS_Rocks_05.M2", -- [32]
									"KLS_Rocks_06.M2", -- [33]
									"KLS_Rocks_07.M2", -- [34]
									"KLS_Rocks_08.M2", -- [35]
									"KLS_Rocks_09.M2", -- [36]
									"KLS_Rocks_10.M2", -- [37]
									"KLS_Rocks_11.M2", -- [38]
									"KLS_Rocks_12.M2", -- [39]
									"KLS_Rocks_13.M2", -- [40]
									"KLS_Rocks_14.M2", -- [41]
									"KLS_Rocks_15.M2", -- [42]
									"KLS_Rocks_16.M2", -- [43]
									"KLS_Rocks_17.M2", -- [44]
									"KLS_Rocks_18.M2", -- [45]
									"KLS_ShaRock.M2", -- [46]
									"KLS_SnowDrift_01.M2", -- [47]
									"KLS_SnowDrift_02.M2", -- [48]
									"KLS_SnowDrift_04.M2", -- [49]
									"KLS_dryBush01.M2", -- [50]
									"KLS_dryBush02.M2", -- [51]
									"KLS_dryGrass01.M2", -- [52]
									"KLS_goldBush01.M2", -- [53]
									"KLS_goldBush02.M2", -- [54]
									"KLS_goldGrass01.M2", -- [55]
									"KLS_goldGrass02.M2", -- [56]
									"KLS_greenGrass01.M2", -- [57]
									"KLS_greenGrass02.M2", -- [58]
									"KLS_redBush01.M2", -- [59]
									"KLS_redBush02.M2", -- [60]
									"KLS_redBush03.M2", -- [61]
									"KLS_redBush04.M2", -- [62]
									"KLS_snowBush01.M2", -- [63]
									"KLS_snowBush02.M2", -- [64]
									"KLS_snowFlower01.M2", -- [65]
									"KLS_snowFlower02.M2", -- [66]
									"KLS_snowFlower03.M2", -- [67]
									"KLS_snowFlower04.M2", -- [68]
									"KLS_snowTree01.M2", -- [69]
									"KLS_snowTree02.M2", -- [70]
									"KLS_snowTree03.M2", -- [71]
									"KLS_snowTree04.M2", -- [72]
									"KLS_tree01.M2", -- [73]
									"KLS_tree02.M2", -- [74]
									"KLS_tree03.M2", -- [75]
									"KLS_treeBranches.M2", -- [76]
									"KLS_treeRoot01.M2", -- [77]
									"KLS_treeRoot02.M2", -- [78]
									"KLS_treeRoot03.M2", -- [79]
									"KLS_treeRoot04.M2", -- [80]
									"KLS_tumbleweed.M2", -- [81]
									"KLS_waterGrass01.M2", -- [82]
									"KLS_waterGrass02.M2", -- [83]
									"KLS_waterPlant01.M2", -- [84]
									"KLS_weeds01.M2", -- [85]
								},
								["N"] = "Kunlaisummit",
							}, -- [13]
							{
								["T"] = {
									"Mantid_Amber_Door01.M2", -- [1]
									"Mantid_Banner_1.M2", -- [2]
									"Mantid_Banner_sha.M2", -- [3]
									"Mantid_Barricade_Cage_01.M2", -- [4]
									"Mantid_BeaconLight.M2", -- [5]
									"Mantid_BeaconLight_Sha.M2", -- [6]
									"Mantid_BeaconLight_Short.M2", -- [7]
									"Mantid_BodyParts_Head.M2", -- [8]
									"Mantid_BodyParts_Leg.M2", -- [9]
									"Mantid_BodyParts_Pincer.M2", -- [10]
									"Mantid_Brazier.M2", -- [11]
									"Mantid_Brazier_Unlit.M2", -- [12]
									"Mantid_Cage_1.M2", -- [13]
									"Mantid_Catapult.M2", -- [14]
									"Mantid_CeilingShatter.M2", -- [15]
									"Mantid_CellTower_Gemmed_01.M2", -- [16]
									"Mantid_CellTower_Ungemmed_01.M2", -- [17]
									"Mantid_CenterPiece_1.M2", -- [18]
									"Mantid_CenterPiece_Sha.M2", -- [19]
									"Mantid_Chandelier.M2", -- [20]
									"Mantid_Container_1.M2", -- [21]
									"Mantid_Crate.M2", -- [22]
									"Mantid_CrateBroken.M2", -- [23]
									"Mantid_Crate_Long.M2", -- [24]
									"Mantid_Crate_Short.M2", -- [25]
									"Mantid_CryoChamber.M2", -- [26]
									"Mantid_CryoChamber_02.M2", -- [27]
									"Mantid_Door_01.M2", -- [28]
									"Mantid_Egg_hatched.M2", -- [29]
									"Mantid_Egg_hatched_Sha.M2", -- [30]
									"Mantid_Egg_single01.M2", -- [31]
									"Mantid_Egg_single01_Sha.M2", -- [32]
									"Mantid_Egg_single02.M2", -- [33]
									"Mantid_Egg_single02_Sha.M2", -- [34]
									"Mantid_Egg_single03.M2", -- [35]
									"Mantid_Egg_single03_Sha.M2", -- [36]
									"Mantid_Eggs_1.M2", -- [37]
									"Mantid_Eggs_1_cracked.M2", -- [38]
									"Mantid_FeedingDevice.M2", -- [39]
									"Mantid_Knife_1H_01.M2", -- [40]
									"Mantid_Knife_1H_02.M2", -- [41]
									"Mantid_LandingPlatform_01.M2", -- [42]
									"Mantid_LandingPlatform_02.M2", -- [43]
									"Mantid_Lightpost_1.M2", -- [44]
									"Mantid_Mailbox.M2", -- [45]
									"Mantid_Polearm_2H_01.M2", -- [46]
									"Mantid_PollenCollector_01.M2", -- [47]
									"Mantid_PollenCollector_Basket_01.M2", -- [48]
									"Mantid_PollenCollector_Large_01.M2", -- [49]
									"Mantid_Scythe_1.M2", -- [50]
									"Mantid_Sigil.M2", -- [51]
									"Mantid_SleepingPerch_01.M2", -- [52]
									"Mantid_Staff_2H_01.M2", -- [53]
									"Mantid_Statue_1.M2", -- [54]
									"Mantid_Sword_1.M2", -- [55]
									"Mantid_Sword_1H_01.M2", -- [56]
									"Mantid_Sword_1H_02.M2", -- [57]
									"Mantid_Sword_2H_01.M2", -- [58]
									"Mantid_Throne_Center.M2", -- [59]
									"Mantid_Throne_Pillar.M2", -- [60]
									"Mantid_TuningFork_01.M2", -- [61]
									"Mantid_WallBanner.M2", -- [62]
									"Mantid_WarWagon.M2", -- [63]
									"Mantid_WarWagonBroken_Front.M2", -- [64]
									"Mantid_WarWagonBroken_Middle.M2", -- [65]
									"Mantid_WarWagonBroken_Rear.M2", -- [66]
									"Mantid_WarWagonBroken_Wheel.M2", -- [67]
									"Mantid_WarWagon_Prop.M2", -- [68]
									"Mantid_WaterContainer_01.M2", -- [69]
									"Mantid_WeaponRack_1.M2", -- [70]
									"Mantid_WeaponRack_2.M2", -- [71]
									"Mantid_WeaponRack_3.M2", -- [72]
									"Mantid_WeaponRack_noweapons.M2", -- [73]
									"Mantid_WingBanner.M2", -- [74]
									"Mantid_Worker_Busy.M2", -- [75]
									"Mantid_Worker_Busy_Sha.M2", -- [76]
									"Mantid_Worker_Carry.M2", -- [77]
									"Mantid_Worker_Carry_Sha.M2", -- [78]
									"Mantid_Worker_Idle.M2", -- [79]
									"Mantid_Worker_Idle_Sha.M2", -- [80]
									"Mantid_fence_Sha.M2", -- [81]
									"Mantid_spike.M2", -- [82]
									"Mantid_spike_Organic.M2", -- [83]
									"Mantid_spike_Sha.M2", -- [84]
									"Mantid_window_1.M2", -- [85]
									"Mantid_window_2.M2", -- [86]
									"Mantid_window_3.M2", -- [87]
									"Mantid_window_4.M2", -- [88]
									"PA_MantidDungeon_SmokeEffect.M2", -- [89]
									"Sha_GroundPatch_Small.M2", -- [90]
									"Sha_GroundPatch_Small_tendrils.M2", -- [91]
									"Sha_GroundPatch_Small_tendrils_pride.M2", -- [92]
									"Sha_GroundPatch_large.M2", -- [93]
									"Sha_GroundPatch_large_tendrils.M2", -- [94]
									"Sha_GroundPatch_large_tendrils_pride.M2", -- [95]
									"Sha_GroundPatch_med.M2", -- [96]
									"Sha_GroundPatch_med_tendrils.M2", -- [97]
									"Sha_GroundPatch_med_tendrils_pride.M2", -- [98]
									"Sha_Pool.M2", -- [99]
									"Sha_SpiritArc.M2", -- [100]
									"Sha_Vortex.M2", -- [101]
									"mantid_bomb.M2", -- [102]
									"mantid_bomb_blue.M2", -- [103]
									"mantid_bomb_green.M2", -- [104]
									"mantid_bomb_purple.M2", -- [105]
									"mantid_bomb_red.M2", -- [106]
									"mantid_sap_extract_emp.M2", -- [107]
									"mantid_sap_extract_full.M2", -- [108]
									"mantid_sap_extract_jar.M2", -- [109]
								},
								["N"] = "Mantid",
							}, -- [14]
							{
								["T"] = {
									{
										["T"] = {
											"Mogu_Wall_Pristine_01.M2", -- [1]
											"Mogu_Wall_Pristine_02.M2", -- [2]
											"Mogu_Wall_Pristine_Arch01.M2", -- [3]
											"Mogu_Wall_Pristine_Arch02.M2", -- [4]
											"Mogu_Wall_Pristine_Corner.M2", -- [5]
											"Mogu_Wall_Pristine_Curve45.M2", -- [6]
											"Mogu_Wall_Pristine_Curve90.M2", -- [7]
											"Mogu_Wall_Pristine_End.M2", -- [8]
											"Mogu_Wall_Pristine_Open01.M2", -- [9]
											"Mogu_Wall_Pristine_Open02.M2", -- [10]
											"Mogu_Wall_Pristine_OpenCorner.M2", -- [11]
											"Mogu_Wall_Pristine_OpenCurve45.M2", -- [12]
											"Mogu_Wall_Pristine_OpenCurve90.M2", -- [13]
											"Mogu_Wall_Pristine_OpenEnd.M2", -- [14]
											"Mogu_Wall_Pristine_Short01.M2", -- [15]
											"Mogu_Wall_Pristine_Short02.M2", -- [16]
											"Mogu_Wall_Pristine_ShortCorner.M2", -- [17]
											"Mogu_Wall_Pristine_ShortCurve45.M2", -- [18]
											"Mogu_Wall_Pristine_ShortCurve90.M2", -- [19]
											"Mogu_Wall_Pristine_ShortEnd.M2", -- [20]
											"Mogu_Wall_Pristine_Tall01.M2", -- [21]
											"Mogu_Wall_Pristine_Tall02.M2", -- [22]
											"Mogu_Wall_Pristine_TallCorner.M2", -- [23]
											"Mogu_Wall_Pristine_TallCurve45.M2", -- [24]
											"Mogu_Wall_Pristine_TallCurve90.M2", -- [25]
											"Mogu_Wall_Pristine_TallEnd.M2", -- [26]
											"Mogu_Wall_Pristine_TallOpenTrans.M2", -- [27]
										},
										["N"] = "Walls",
									}, -- [1]
									"AncientMogu_Burial_Urn_01.M2", -- [2]
									"AncientMogu_Burial_Urn_02.M2", -- [3]
									"AncientMogu_Burial_Urn_03.M2", -- [4]
									"AncientMogu_Burial_Urn_03old.M2", -- [5]
									"AncientMogu_Burial_Urn_04.M2", -- [6]
									"AncientMogu_Burial_Urn_04old.M2", -- [7]
									"MOGU_STATUE_BASE_Thunder_Moss.M2", -- [8]
									"Mogu-Ancient_Brazier_01.M2", -- [9]
									"Mogu-Ancient_Brazier_02.M2", -- [10]
									"Mogu-Ancient_Brazier_Huge_01.M2", -- [11]
									"Mogu-Ancient_Sconce_01.M2", -- [12]
									"Mogu1b_Statue_01.M2", -- [13]
									"Mogu1b_Statue_02.M2", -- [14]
									"Mogu1b_Statue_03.M2", -- [15]
									"Mogu1b_Statue_04.M2", -- [16]
									"Mogu_Altar_01.M2", -- [17]
									"Mogu_Altar_01Ruin.M2", -- [18]
									"Mogu_Altar_01Snow.M2", -- [19]
									"Mogu_Ancient_Doorway01.M2", -- [20]
									"Mogu_Ancient_Doorway02.M2", -- [21]
									"Mogu_Ancient_Doorway03.M2", -- [22]
									"Mogu_Ancient_Lever_Gold.M2", -- [23]
									"Mogu_Ancient_Light_Sconce.M2", -- [24]
									"Mogu_Anvil_01.M2", -- [25]
									"Mogu_Arena_Gate_Large_01.M2", -- [26]
									"Mogu_Arena_Gate_Small_01_Amani.M2", -- [27]
									"Mogu_Arena_Gate_Small_01_Drakkari.M2", -- [28]
									"Mogu_Arena_Gate_Small_01_Farraki.M2", -- [29]
									"Mogu_Arena_Gate_Small_01_Gurubashi.M2", -- [30]
									"Mogu_Bench.M2", -- [31]
									"Mogu_Blocking_Gate_01.M2", -- [32]
									"Mogu_BloodLetting_Device_01.M2", -- [33]
									"Mogu_Brazier_Floor-BlueFlame_01.M2", -- [34]
									"Mogu_Brazier_Floor_01.M2", -- [35]
									"Mogu_Brazier_Hanging_01.M2", -- [36]
									"Mogu_Brazier_Hanging_02.M2", -- [37]
									"Mogu_Brazier_Mounted_01.M2", -- [38]
									"Mogu_Brazier_Sconce_01.M2", -- [39]
									"Mogu_Cage_01.M2", -- [40]
									"Mogu_Cannon.M2", -- [41]
									"Mogu_CastingMold_Bottom.M2", -- [42]
									"Mogu_CastingMold_BottomBroken.M2", -- [43]
									"Mogu_CastingMold_Closed.M2", -- [44]
									"Mogu_CastingMold_Top.M2", -- [45]
									"Mogu_CastingMold_TopBroken.M2", -- [46]
									"Mogu_Chair.M2", -- [47]
									"Mogu_Chandelier.M2", -- [48]
									"Mogu_Container_01.M2", -- [49]
									"Mogu_Crest.M2", -- [50]
									"Mogu_Crucible.M2", -- [51]
									"Mogu_Crucible_Pour.M2", -- [52]
									"Mogu_DivineBell.M2", -- [53]
									"Mogu_DivineBell_Snowy.M2", -- [54]
									"Mogu_DivineBell_bellCollision.M2", -- [55]
									"Mogu_DivineBell_shatterCollision.M2", -- [56]
									"Mogu_Doorway01.M2", -- [57]
									"Mogu_Doorway02.M2", -- [58]
									"Mogu_Doorway03.M2", -- [59]
									"Mogu_Doorway03_Broken.M2", -- [60]
									"Mogu_Drapes_Hanging.M2", -- [61]
									"Mogu_Drapes_Straight.M2", -- [62]
									"Mogu_FencePost_01.M2", -- [63]
									"Mogu_Fence_01.M2", -- [64]
									"Mogu_Forge.M2", -- [65]
									"Mogu_LampPost_01.M2", -- [66]
									"Mogu_LampPost_02.M2", -- [67]
									"Mogu_LampPost_Stone_01.M2", -- [68]
									"Mogu_LampPost_Stone_Off_01.M2", -- [69]
									"Mogu_Lamppost01.M2", -- [70]
									"Mogu_Lamppost01Unlit.M2", -- [71]
									"Mogu_Library_Crate_1.M2", -- [72]
									"Mogu_Library_Crate_10.M2", -- [73]
									"Mogu_Library_Crate_2.M2", -- [74]
									"Mogu_Library_Crate_3.M2", -- [75]
									"Mogu_Library_Crate_4.M2", -- [76]
									"Mogu_Library_Crate_5.M2", -- [77]
									"Mogu_Library_Crate_6.M2", -- [78]
									"Mogu_Library_Crate_7.M2", -- [79]
									"Mogu_Library_Crate_8.M2", -- [80]
									"Mogu_Library_Crate_9.M2", -- [81]
									"Mogu_LightningDrill.M2", -- [82]
									"Mogu_LightningRod.M2", -- [83]
									"Mogu_LightningRod_Anim.M2", -- [84]
									"Mogu_LightningRod_Anim_StoneTop.M2", -- [85]
									"Mogu_Map.M2", -- [86]
									"Mogu_Metalworking_Tools_01.M2", -- [87]
									"Mogu_Metalworking_Tools_Hammer.M2", -- [88]
									"Mogu_Metalworking_Trough.M2", -- [89]
									"Mogu_NorthGate_Door_01.M2", -- [90]
									"Mogu_NorthGate_Door_01_Slide.M2", -- [91]
									"Mogu_NorthGate_Door_02.M2", -- [92]
									"Mogu_NorthGate_Door_03.M2", -- [93]
									"Mogu_NorthGate_Door_03CollisionClosed.M2", -- [94]
									"Mogu_NorthGate_Door_03CollisionOpen.M2", -- [95]
									"Mogu_OldBrazier.M2", -- [96]
									"Mogu_OldBrazier_noCollide.M2", -- [97]
									"Mogu_Pillar_Fire_Blue.M2", -- [98]
									"Mogu_Pillar_Fire_Blue_BlendRamp.M2", -- [99]
									"Mogu_Pillar_Fire_Blue_Slanted.M2", -- [100]
									"Mogu_Pillar_Fire_Jade.M2", -- [101]
									"Mogu_RaidPuzzleDoor.M2", -- [102]
									"Mogu_Raised_Gate01.M2", -- [103]
									"Mogu_Rubble_1.M2", -- [104]
									"Mogu_Rubble_2.M2", -- [105]
									"Mogu_Rubble_3.M2", -- [106]
									"Mogu_Ruins_GroundTile_01.M2", -- [107]
									"Mogu_Ruins_GroundTile_Broken_01.M2", -- [108]
									"Mogu_Ruins_GroundTile_Broken_02.M2", -- [109]
									"Mogu_Stairs_Destroyed_Ancient.M2", -- [110]
									"Mogu_Stairs_Destroyed_Ancient_02.M2", -- [111]
									"Mogu_Stairs_Destroyed_Snow.M2", -- [112]
									"Mogu_Stairs_Wide_Ancient.M2", -- [113]
									"Mogu_Stairs_Wide_Ancient_02.M2", -- [114]
									"Mogu_Stairs_Wide_Pristine.M2", -- [115]
									"Mogu_Stairs_Wide_Snow.M2", -- [116]
									"Mogu_Standard_01.M2", -- [117]
									"Mogu_Standard_01Blue.M2", -- [118]
									"Mogu_StatueBase_01.M2", -- [119]
									"Mogu_Statue_01.M2", -- [120]
									"Mogu_Statue_01Broken_Base.M2", -- [121]
									"Mogu_Statue_01Broken_BaseLarge.M2", -- [122]
									"Mogu_Statue_01Broken_BaseSnow.M2", -- [123]
									"Mogu_Statue_01Broken_Piece01.M2", -- [124]
									"Mogu_Statue_01Broken_Piece02.M2", -- [125]
									"Mogu_Statue_01Broken_Piece02Large.M2", -- [126]
									"Mogu_Statue_01Broken_Piece03.M2", -- [127]
									"Mogu_Statue_01Broken_Piece03_Thunder_Moss.M2", -- [128]
									"Mogu_Statue_01Broken_Piece04.M2", -- [129]
									"Mogu_Statue_01Gold.M2", -- [130]
									"Mogu_Statue_01GoldBase.M2", -- [131]
									"Mogu_Statue_01Ruined.M2", -- [132]
									"Mogu_Statue_01RuinedSnow.M2", -- [133]
									"Mogu_Statue_01_BaseOnlySnow.M2", -- [134]
									"Mogu_Statue_01_Thunder.M2", -- [135]
									"Mogu_Statue_02.M2", -- [136]
									"Mogu_Statue_02Broken_Base.M2", -- [137]
									"Mogu_Statue_02Broken_BaseHuge.M2", -- [138]
									"Mogu_Statue_02Broken_BaseHuge_02.M2", -- [139]
									"Mogu_Statue_02Broken_BaseSnow.M2", -- [140]
									"Mogu_Statue_02Broken_Base_Thunder_Moss.M2", -- [141]
									"Mogu_Statue_02Broken_Piece01.M2", -- [142]
									"Mogu_Statue_02Broken_Piece01Huge.M2", -- [143]
									"Mogu_Statue_02Broken_Piece02.M2", -- [144]
									"Mogu_Statue_02Broken_Piece03.M2", -- [145]
									"Mogu_Statue_02Broken_Piece03Large.M2", -- [146]
									"Mogu_Statue_02Gold.M2", -- [147]
									"Mogu_Statue_02GoldBase.M2", -- [148]
									"Mogu_Statue_02GoldLarge.M2", -- [149]
									"Mogu_Statue_02Large.M2", -- [150]
									"Mogu_Statue_02Ruined.M2", -- [151]
									"Mogu_Statue_02RuinedSnow.M2", -- [152]
									"Mogu_Statue_02_Thunder.M2", -- [153]
									"Mogu_Statue_03.M2", -- [154]
									"Mogu_Statue_03Broken_Base.M2", -- [155]
									"Mogu_Statue_03Broken_BaseHuge.M2", -- [156]
									"Mogu_Statue_03Broken_BaseSnow.M2", -- [157]
									"Mogu_Statue_03Broken_Base_Thunder.M2", -- [158]
									"Mogu_Statue_03Broken_Base_Thunder_Moss.M2", -- [159]
									"Mogu_Statue_03Broken_Piece01.M2", -- [160]
									"Mogu_Statue_03Broken_Piece01Large.M2", -- [161]
									"Mogu_Statue_03Broken_Piece01_Thunder_Moss.M2", -- [162]
									"Mogu_Statue_03Broken_Piece02.M2", -- [163]
									"Mogu_Statue_03Broken_Piece02Large.M2", -- [164]
									"Mogu_Statue_03Broken_Piece03.M2", -- [165]
									"Mogu_Statue_03Gold.M2", -- [166]
									"Mogu_Statue_03GoldBase.M2", -- [167]
									"Mogu_Statue_03GoldLarge.M2", -- [168]
									"Mogu_Statue_03Ruined.M2", -- [169]
									"Mogu_Statue_03RuinedSnow.M2", -- [170]
									"Mogu_Statue_03_Thunder.M2", -- [171]
									"Mogu_Statue_03_Thunder_Moss.M2", -- [172]
									"Mogu_Statue_04.M2", -- [173]
									"Mogu_Statue_04Gold.M2", -- [174]
									"Mogu_Statue_04GoldBase.M2", -- [175]
									"Mogu_Statue_04_Thunder.M2", -- [176]
									"Mogu_Statue_04_Thunder_Moss.M2", -- [177]
									"Mogu_Statue_Double.M2", -- [178]
									"Mogu_Statue_Hub.M2", -- [179]
									"Mogu_Statue_LightningSoldier_01.M2", -- [180]
									"Mogu_Statue_LightningSoldier_01Unlit.M2", -- [181]
									"Mogu_Statue_LightningSoldier_01Unlit_Moss.M2", -- [182]
									"Mogu_Statue_LightningSoldier_02.M2", -- [183]
									"Mogu_Statue_LightningSoldier_02Unlit.M2", -- [184]
									"Mogu_Statue_LightningSoldier_02Unlit_Moss.M2", -- [185]
									"Mogu_Statue_MoguShanVaults01.M2", -- [186]
									"Mogu_Statue_MoguShanVaults02.M2", -- [187]
									"Mogu_Statue_MoguShanVaults03.M2", -- [188]
									"Mogu_Statue_MoguShanVaults03_COL.M2", -- [189]
									"Mogu_Statue_MoguShanVaults04.M2", -- [190]
									"Mogu_Statue_ThunderKing01.M2", -- [191]
									"Mogu_Statue_ancient.M2", -- [192]
									"Mogu_Table.M2", -- [193]
									"Mogu_Table_Map.M2", -- [194]
									"Mogu_Tent_01.M2", -- [195]
									"Mogu_Tent_02.M2", -- [196]
									"Mogu_Throne.M2", -- [197]
									"Mogu_ThunderIsland_ForgeChains_01.M2", -- [198]
									"Mogu_ThunderIsle_CoffinLid_01.M2", -- [199]
									"Mogu_ThunderIsle_CoffinLid_Broken_01.M2", -- [200]
									"Mogu_ThunderIsle_CoffinLid_Broken_02.M2", -- [201]
									"Mogu_ThunderIsle_Coffin_01.M2", -- [202]
									"Mogu_ThunderIsle_Corpse_01.M2", -- [203]
									"Mogu_ThunderIsle_Corpse_01_horizontal.M2", -- [204]
									"Mogu_ThunderIsle_Gate.M2", -- [205]
									"Mogu_ThunderIsle_LampPost_Stone_01.M2", -- [206]
									"Mogu_ThunderIsle_LampPost_Stone_Off_01.M2", -- [207]
									"Mogu_ThunderIsle_Obelisk_01.M2", -- [208]
									"Mogu_ThunderIsle_Obelisk_02.M2", -- [209]
									"Mogu_ThunderIsle_Obelisk_03.M2", -- [210]
									"Mogu_ThunderIsle_Obelisk_04.M2", -- [211]
									"Mogu_ThunderIsle_Obelisk_Large_01.M2", -- [212]
									"Mogu_ThunderIsle_Obelisk_Large_Broken_01.M2", -- [213]
									"Mogu_ThunderIsle_Obelisk_Large_Broken_02.M2", -- [214]
									"Mogu_ThunderIsle_RoadsideMarker01.M2", -- [215]
									"Mogu_ThunderIsle_RoadsideMarker02.M2", -- [216]
									"Mogu_ThunderIsle_RoadsideMarker03.M2", -- [217]
									"Mogu_ThunderIsle_RoadsideMarker04.M2", -- [218]
									"Mogu_ThunderIsle_Sarcophagus_Anim_01.M2", -- [219]
									"Mogu_ThunderIsle_Sarcophagus_Closed_01.M2", -- [220]
									"Mogu_ThunderIsle_Sarcophagus_Lid_01.M2", -- [221]
									"Mogu_ThunderIsle_Sarcophagus_Lid_02.M2", -- [222]
									"Mogu_ThunderIsle_Sarcophagus_Lid_Broken_01.M2", -- [223]
									"Mogu_ThunderIsle_Sarcophagus_Lid_Broken_02.M2", -- [224]
									"Mogu_ThunderIsle_Sarcophagus_Open_01.M2", -- [225]
									"Mogu_ThunderIsle_Sarcophagus_Open_02.M2", -- [226]
									"Mogu_ThunderIsle_Sarcophagus_Open_Empty_01.M2", -- [227]
									"Mogu_Tile_Cloud.M2", -- [228]
									"Mogu_Tile_Fire.M2", -- [229]
									"Mogu_Tile_Lightning.M2", -- [230]
									"Mogu_Tile_Spear.M2", -- [231]
									"Mogu_TitanGong.M2", -- [232]
									"Mogu_TitanVault_Door_01.M2", -- [233]
									"Mogu_Titan_Barrier01.M2", -- [234]
									"Mogu_Titan_EnergyRings.M2", -- [235]
									"Mogu_Titan_Platform.M2", -- [236]
									"Mogu_TreasureDoors_Inner.M2", -- [237]
									"Mogu_TreasureDoors_Outer.M2", -- [238]
									"Mogu_TreasureDoors_Straight.M2", -- [239]
									"Mogu_Wall_Thunder_01.M2", -- [240]
									"Mogu_Wall_Thunder_02.M2", -- [241]
									"Mogu_Wall_Thunder_Corner.M2", -- [242]
									"Mogu_Wall_Thunder_Curve45.M2", -- [243]
									"Mogu_Wall_Thunder_Curve90.M2", -- [244]
									"Mogu_Wall_Thunder_End.M2", -- [245]
									"Mogu_Water_Fountain_01.M2", -- [246]
									"Mogu_bell.M2", -- [247]
									"Mogu_pot_1.M2", -- [248]
									"Mogu_pot_2.M2", -- [249]
									"Mogu_pot_3.M2", -- [250]
									"Mogu_pot_4.M2", -- [251]
									"Mogu_pot_5.M2", -- [252]
									"Mogu_pot_6.M2", -- [253]
									"Mogu_pot_7.M2", -- [254]
									"Mogu_pot_8.M2", -- [255]
									"Mogu_thunderking_chest.M2", -- [256]
									"PA_AncientMogu_ThunderIsland_Walls_Right_Destruction.M2", -- [257]
									"PA_MoguRaid_ext_Sha_FXwrap.M2", -- [258]
									"PA_MoguShan_Bookcase_01.M2", -- [259]
									"PA_MoguShan_Bookcase_01_Deco_A.M2", -- [260]
									"PA_MoguShan_Bookcase_01_Deco_B.M2", -- [261]
									"PA_MoguShan_Bookcase_01_Deco_C.M2", -- [262]
									"ThunderIsle_AncientMogu_Brazier.M2", -- [263]
									"ThunderIsle_AncientMogu_BrazierBroken.M2", -- [264]
									"ThunderIsle_AncientMogu_Brazier_WindBlow.M2", -- [265]
									"ThunderIsle_AncientMogu_Brazier_WindBlow_02.M2", -- [266]
									"ThunderIsle_AncientMogu_Sconce.M2", -- [267]
									"ThunderIsle_AncientMogu_SconceBroken.M2", -- [268]
									"ThunderIsle_Mogu_Plaque_01.M2", -- [269]
									"ThunderIsle_Raid_Door_1.M2", -- [270]
									"ThunderIsle_Raid_Door_2.M2", -- [271]
									"ThunderIsle_Raid_Door_Tall.M2", -- [272]
									"ThunderIsle_Sewer_Gate_1.M2", -- [273]
									"ThunderIsle_Sewer_Gate_2.M2", -- [274]
									"ThunderIsle_Sunwell.M2", -- [275]
									"ThunderKing_BeholderGrate_Large_01.M2", -- [276]
									"ThunderKing_BeholderGrate_Small_01.M2", -- [277]
									"ThunderKing_BloodFloor_Design_01.M2", -- [278]
									"ThunderKing_BloodFloor_Design_02.M2", -- [279]
									"ThunderKing_BloodVial_01.M2", -- [280]
									"ThunderKing_Disc.M2", -- [281]
									"ThunderKing_Disc_Collision.M2", -- [282]
									"ThunderKing_Door_Short_01.M2", -- [283]
									"ThunderKing_Door_Tall_01.M2", -- [284]
									"ThunderKing_Grate.M2", -- [285]
									"ThunderKing_Grate_NoGlow.M2", -- [286]
									"ThunderKing_LightningColumn_BaseC.M2", -- [287]
									"ThunderKing_LightningColumn_BaseCC.M2", -- [288]
									"ThunderKing_LightningColumn_Taper.M2", -- [289]
									"ThunderKing_LightningColumn_Top.M2", -- [290]
									"ThunderKing_Pillar.M2", -- [291]
									"ThunderKing_PowerOrb_01.M2", -- [292]
									"ThunderKing_Sconce.M2", -- [293]
									"ThunderKing_Sconce_Off.M2", -- [294]
									"ThunderKing_Teleport_Pad_01.M2", -- [295]
									"ThunderKing_TitanDevice_01.M2", -- [296]
									"Thunderking_Bridge_Destruction.M2", -- [297]
									"Thunderking_TurtleDoor.M2", -- [298]
									"Thunderking_Window_01.M2", -- [299]
									"Thunderking_Window_Platform_01.M2", -- [300]
									"mogu_ancient_minecart.M2", -- [301]
									"mogu_chandelier_crypt.M2", -- [302]
									"mogu_runes_blue.M2", -- [303]
									"mogu_runes_blue_nop.M2", -- [304]
									"mogu_runes_green.M2", -- [305]
									"mogu_runes_purple.M2", -- [306]
									"mogu_runes_red.M2", -- [307]
									"mogu_runes_yellow.M2", -- [308]
									"mogu_statue_sunken.M2", -- [309]
									"thunderisle_BuildingCrystal_01.M2", -- [310]
									"thunderisle_BuildingCrystal_02.M2", -- [311]
									"thunderking_iris_blood_pool.M2", -- [312]
									"thunderking_large_blood_vat.M2", -- [313]
									"thunderking_large_blood_vat_b.M2", -- [314]
									"thunderking_large_blood_vat_c.M2", -- [315]
									"thunderking_large_blood_vat_d.M2", -- [316]
									"thunderking_large_blood_vat_e.M2", -- [317]
									"thunderking_statue_Quilin.M2", -- [318]
								},
								["N"] = "Mogu",
							}, -- [15]
							{
								["T"] = {
									"Murderball_Ball.M2", -- [1]
									"Murderball_Ball_Fx.M2", -- [2]
									"Murderball_Pedestal.M2", -- [3]
									"Murderball_Pedestal_ball.M2", -- [4]
								},
								["N"] = "Murderball",
							}, -- [16]
							{
								["T"] = {
									{
										["T"] = {
											"PA_Alchemy_01.M2", -- [1]
											"PA_Alchemy_02.M2", -- [2]
											"PA_Alchemy_03.M2", -- [3]
											"PA_Alchemy_04.M2", -- [4]
											"PA_Alchemy_05.M2", -- [5]
											"PA_Alchemy_06.M2", -- [6]
											"PA_Alchemy_07.M2", -- [7]
											"PA_Alchemy_08.M2", -- [8]
											"PA_Alchemy_09.M2", -- [9]
											"PA_Alchemy_10.M2", -- [10]
											"PA_Alchemy_11.M2", -- [11]
											"PA_Alchemy_12.M2", -- [12]
											"PA_Alchemy_13.M2", -- [13]
											"PA_Alchemy_14.M2", -- [14]
											"PA_Alchemy_15.M2", -- [15]
											"PA_Alchemy_Kit_01.M2", -- [16]
											"PA_Alchemy_Kit_02.M2", -- [17]
											"PA_Alchemy_Kit_03.M2", -- [18]
											"PA_Alchemy_Kit_04.M2", -- [19]
											"PA_Alchemy_Kit_05.M2", -- [20]
											"PA_Alchemy_Ladle.M2", -- [21]
											"PA_Alchemy_Stand.M2", -- [22]
											"PA_Alchemy_Tongs.M2", -- [23]
										},
										["N"] = "Alchemy",
									}, -- [1]
									{
										["T"] = {
											"PA_AnimalPillarWeapon_01.M2", -- [1]
											"PA_AnimalPillarWeapon_02.M2", -- [2]
											"PA_AnimalPillarWeapon_Base.M2", -- [3]
										},
										["N"] = "Animalpillarweapon",
									}, -- [2]
									{
										["T"] = {
											"PA_Anvil_01.M2", -- [1]
											"PA_Anvil_Hammer_01.M2", -- [2]
										},
										["N"] = "Anvil",
									}, -- [3]
									{
										["T"] = {
											"PA_ApothecaryDesk.M2", -- [1]
										},
										["N"] = "Apothecarydesk",
									}, -- [4]
									{
										["T"] = {
											"PA_Stone_Arched_Gateway.M2", -- [1]
											"PA_Stone_Arched_Gateway_02.M2", -- [2]
											"PA_Stone_Arched_Gateway_Door.M2", -- [3]
											"PA_Stone_Arched_Gateway_Door_02.M2", -- [4]
											"PA_Stone_Arched_Gateway_Door_RamOpen.M2", -- [5]
										},
										["N"] = "Arched_gateway",
									}, -- [5]
									{
										["T"] = {
											"PA_Arch_01.M2", -- [1]
										},
										["N"] = "Arches",
									}, -- [6]
									{
										["T"] = {
											"Helm_ChallengeDeathKnight_Doodad.M2", -- [1]
											"Helm_ChallengeDruid_Doodad.M2", -- [2]
											"Helm_ChallengeHunter_Doodad.M2", -- [3]
											"Helm_ChallengeHunter_Doodad1.M2", -- [4]
											"Helm_ChallengeMage_Doodad.M2", -- [5]
											"Helm_ChallengeMonk_Doodad.M2", -- [6]
											"Helm_ChallengePaladin_Doodad.M2", -- [7]
											"Helm_ChallengePriest_Doodad.M2", -- [8]
											"Helm_ChallengeRogue_Doodad.M2", -- [9]
											"Helm_ChallengeShaman_Doodad.M2", -- [10]
											"Helm_ChallengeWarlock_Doodad.M2", -- [11]
											"Helm_ChallengeWarrior_Doodad.M2", -- [12]
											"LShoulder_ChallengeDeathKnight_Doodad.M2", -- [13]
											"LShoulder_ChallengeHunter_Doodad.M2", -- [14]
											"LShoulder_ChallengeMage_Doodad.M2", -- [15]
											"LShoulder_ChallengeMonk_Doodad.M2", -- [16]
											"LShoulder_ChallengePaladin_Doodad.M2", -- [17]
											"LShoulder_ChallengePriest_Doodad.M2", -- [18]
											"LShoulder_ChallengeRogue_Doodad.M2", -- [19]
											"LShoulder_ChallengeShaman_Doodad.M2", -- [20]
											"LShoulder_ChallengeWarlock_Doodad.M2", -- [21]
											"LShoulder_ChallengeWarrior_Doodad.M2", -- [22]
											"Lshoulder_ChallengeDruid_Doodad.M2", -- [23]
											"RShoulder_ChallengeDeathKnight_Doodad.M2", -- [24]
											"RShoulder_ChallengeHunter_Doodad.M2", -- [25]
											"RShoulder_ChallengeMage_Doodad.M2", -- [26]
											"RShoulder_ChallengeMonk_Doodad.M2", -- [27]
											"RShoulder_ChallengePaladin_Doodad.M2", -- [28]
											"RShoulder_ChallengePriest_Doodad.M2", -- [29]
											"RShoulder_ChallengeRogue_Doodad.M2", -- [30]
											"RShoulder_ChallengeShaman_Doodad.M2", -- [31]
											"RShoulder_ChallengeWarlock_Doodad.M2", -- [32]
											"RShoulder_ChallengeWarrior_Doodad.M2", -- [33]
											"Rshoulder_ChallengeDruid_Doodad.M2", -- [34]
										},
										["N"] = "Armordisplay",
									}, -- [7]
									{
										["T"] = {
											"PA_Balance_Post_01.M2", -- [1]
											"PA_Balance_Post_02.M2", -- [2]
										},
										["N"] = "Balancepost",
									}, -- [8]
									{
										["T"] = {
											"PA_BambooCluster.M2", -- [1]
											"PA_Bamboo_Step_01.M2", -- [2]
											"StackOfBamboo.M2", -- [3]
										},
										["N"] = "Bamboo",
									}, -- [9]
									{
										["T"] = {
											"PA_Bamboo_Waterpipe_01.M2", -- [1]
											"PA_Bamboo_Waterpipe_upgrade.M2", -- [2]
										},
										["N"] = "Bamboo_waterpipe",
									}, -- [10]
									{
										["T"] = {
											"PA_Banner_Flags_01.M2", -- [1]
											"PA_Banner_Flags_02.M2", -- [2]
											"PA_Banner_Flags_03.M2", -- [3]
											"PA_Banner_Flags_04.M2", -- [4]
											"PA_Banner_Shadowpan_DoublePennant.M2", -- [5]
											"PA_Banner_Shadowpan_DoublePennantsOnly_Blue.M2", -- [6]
											"PA_Banner_Shadowpan_DoublePennantsOnly_GREEN.M2", -- [7]
											"PA_Banner_Shadowpan_DoublePennantsOnly_RED.M2", -- [8]
											"PA_Banner_Shadowpan_DoublePennantsOnly_Yellow.M2", -- [9]
											"PA_Banner_Shadowpan_FlagpoleStatic.M2", -- [10]
											"PA_Banner_Shadowpan_PennantsandBanner.M2", -- [11]
											"PA_Banner_Shadowpan_SingleBanner.M2", -- [12]
											"PA_Banner_Shadowpan_SquareBanners.M2", -- [13]
											"PA_Banner_Shadowpan_TripleBanner.M2", -- [14]
											"PA_Banner_Stone.M2", -- [15]
											"PA_Banner_StoneOld.M2", -- [16]
											"PA_Banner_TallBlue.M2", -- [17]
											"PA_Banner_TallRed.M2", -- [18]
											"PA_Banner_WallHanging_01.M2", -- [19]
											"PA_Banner_WallHanging_02.M2", -- [20]
											"PA_Banner_Wood.M2", -- [21]
											"PA_Standard_01.M2", -- [22]
											"PA_Standard_02.M2", -- [23]
											"PA_Standard_GoldenLotus_01.M2", -- [24]
											"PA_Standard_Hanging_Alliance.M2", -- [25]
											"PA_Standard_Hanging_Horde.M2", -- [26]
											"PA_Standard_Huojin_Horde.M2", -- [27]
											"PA_Standard_Huojin_Traditional.M2", -- [28]
											"PA_Standard_Tushui_Alliance.M2", -- [29]
											"PA_Standard_Tushui_Traditional.M2", -- [30]
										},
										["N"] = "Banner",
									}, -- [11]
									{
										["T"] = {
											"PA_Barrel_01.M2", -- [1]
											"PA_Barrel_02.M2", -- [2]
										},
										["N"] = "Barrel",
									}, -- [12]
									{
										["T"] = {
											"PA_Barrel_Wrecked_01.M2", -- [1]
											"PA_Barrel_Wrecked_02.M2", -- [2]
										},
										["N"] = "Barrel_wrecked",
									}, -- [13]
									{
										["T"] = {
											"PA_Basket_Rural_01.M2", -- [1]
											"PA_Basket_Rural_02.M2", -- [2]
											"PA_Basket_Rural_Lid_01.M2", -- [3]
											"PA_Basket_Rural_Lid_02.M2", -- [4]
											"PA_Basket_Rural_Open_01.M2", -- [5]
											"PA_Basket_Rural_Open_02.M2", -- [6]
										},
										["N"] = "Basket",
									}, -- [14]
									{
										["T"] = {
											"PA_House_Bed.M2", -- [1]
											"PA_House_Bed_02.M2", -- [2]
											"PA_House_Bed_Country.M2", -- [3]
										},
										["N"] = "Bed",
									}, -- [15]
									{
										["T"] = {
											"PA_Bell_01.M2", -- [1]
										},
										["N"] = "Bell",
									}, -- [16]
									{
										["T"] = {
											"PA_butterfly_red_loop.M2", -- [1]
											"PA_dragonfly_red_loop.M2", -- [2]
											"PA_greenBird_stand.M2", -- [3]
											"PA_redBird_stand.M2", -- [4]
											"PA_sunbirds_fly.M2", -- [5]
											"PA_sunbirds_loop.M2", -- [6]
											"PA_sunbirds_loopNoDip.M2", -- [7]
											"PA_sunbirds_standfly.M2", -- [8]
										},
										["N"] = "Birds",
									}, -- [17]
									{
										["T"] = {
											"PA_BlockCluster.M2", -- [1]
											"StackOfBlocks.M2", -- [2]
										},
										["N"] = "Blocks",
									}, -- [18]
									{
										["T"] = {
											"PA_Boat_01.M2", -- [1]
											"PA_Boat_02.M2", -- [2]
											"PA_Boat_03.M2", -- [3]
											"PA_Boat_04.M2", -- [4]
											"PA_Boat_05.M2", -- [5]
											"PA_Boat_BrokenHull_01.M2", -- [6]
											"PA_Boat_BrokenHull_02.M2", -- [7]
											"PA_Boat_Lantern.M2", -- [8]
											"PA_Boat_Paddle.M2", -- [9]
											"PA_Boat_Planks_01.M2", -- [10]
											"PA_Boat_Planks_02.M2", -- [11]
											"PA_Boat_RepairPosts.M2", -- [12]
											"PA_Boat_UnderConstruction.M2", -- [13]
										},
										["N"] = "Boat",
									}, -- [19]
									{
										["T"] = {
											"PA_Bonsei_Tree_01.M2", -- [1]
											"PA_Bonsei_Tree_02.M2", -- [2]
											"PA_Bonsei_Tree_03.M2", -- [3]
										},
										["N"] = "Bonsei",
									}, -- [20]
									{
										["T"] = {
											"PA_Book_01.M2", -- [1]
											"PA_Book_02.M2", -- [2]
											"PA_Book_03.M2", -- [3]
											"PA_Book_04.M2", -- [4]
											"PA_Book_05.M2", -- [5]
											"PA_Book_06.M2", -- [6]
											"PA_Book_07.M2", -- [7]
											"PA_Book_08.M2", -- [8]
											"PA_Book_Open_01.M2", -- [9]
											"PA_Book_Open_02.M2", -- [10]
											"PA_Book_Open_03.M2", -- [11]
											"PA_Book_Open_04.M2", -- [12]
											"PA_Book_Open_05.M2", -- [13]
											"PA_Book_Open_06.M2", -- [14]
											"PA_Book_Open_07.M2", -- [15]
											"PA_Book_Open_08.M2", -- [16]
											"PA_Book_Unbound_01.M2", -- [17]
											"PA_Book_Unbound_02.M2", -- [18]
											"PA_Book_Unbound_03.M2", -- [19]
											"PA_Book_Unbound_04.M2", -- [20]
											"PA_Book_Unbound_05.M2", -- [21]
											"PA_Book_Unbound_06.M2", -- [22]
											"PA_Book_Unbound_07.M2", -- [23]
											"PA_Book_Unbound_08.M2", -- [24]
											"PA_Book_Wooden_01.M2", -- [25]
											"PA_Book_Wooden_02.M2", -- [26]
											"PA_Book_Wooden_03.M2", -- [27]
											"PA_Book_Wooden_04.M2", -- [28]
											"PA_Book_Wooden_05.M2", -- [29]
											"PA_Book_Wooden_06.M2", -- [30]
											"PA_Bookcase_01.M2", -- [31]
											"PA_Bookcase_02.M2", -- [32]
											"PA_Bookcase_04.M2", -- [33]
											"PA_Bookcase_05.M2", -- [34]
											"PA_Bookcase_NoBooks.M2", -- [35]
											"PA_Scroll_Wooden_01.M2", -- [36]
											"PA_Scroll_Wooden_02.M2", -- [37]
											"PA_Scroll_Wooden_03.M2", -- [38]
											"PA_Scroll_Wooden_04.M2", -- [39]
											"PA_Scroll_Wooden_05.M2", -- [40]
											"PA_Scroll_Wooden_06.M2", -- [41]
											"PA_Scroll_Wooden_07.M2", -- [42]
											"PA_Scroll_Wooden_08.M2", -- [43]
											"PA_Scroll_Wooden_Huge_01.M2", -- [44]
											"PA_Scroll_Wooden_Huge_02.M2", -- [45]
											"PA_Scroll_Wooden_Huge_03.M2", -- [46]
											"PA_Scroll_Wooden_Huge_04.M2", -- [47]
										},
										["N"] = "Books",
									}, -- [21]
									{
										["T"] = {
											"PA_brazier_01.M2", -- [1]
											"PA_brazier_01blue.M2", -- [2]
											"PA_brazier_01purple.M2", -- [3]
											"PA_brazier_01red.M2", -- [4]
											"PA_brazier_rural.M2", -- [5]
										},
										["N"] = "Brazier",
									}, -- [22]
									{
										["T"] = {
											"PA_BrewFather_01.M2", -- [1]
											"PA_BrewFather_01Stone.M2", -- [2]
											"PA_BrewFather_02.M2", -- [3]
											"PA_BrewFather_02Stone.M2", -- [4]
											"PA_BrewFather_03.M2", -- [5]
											"PA_BrewFather_03Stone.M2", -- [6]
										},
										["N"] = "Brewfather",
									}, -- [23]
									{
										["T"] = {
											"PA_BrewingRecipe_01.M2", -- [1]
											"PA_BrewingRecipe_02.M2", -- [2]
											"PA_BrewingRecipe_03.M2", -- [3]
											"PA_BrewingRecipe_Deluxe_01.M2", -- [4]
											"PA_BrewingRecipe_Deluxe_02.M2", -- [5]
											"PA_BrewingRecipe_Deluxe_03.M2", -- [6]
										},
										["N"] = "Brewrecipes",
									}, -- [24]
									{
										["T"] = {
											"PA_Cage_01.M2", -- [1]
											"PA_Cage_02.M2", -- [2]
										},
										["N"] = "Cage",
									}, -- [25]
									{
										["T"] = {
											"PA_Bonfire.M2", -- [1]
											"PA_campfire_01.M2", -- [2]
											"PA_campfire_01_NoSmoke.M2", -- [3]
											"PA_campfire_wind_01.M2", -- [4]
										},
										["N"] = "Campfire",
									}, -- [26]
									{
										["T"] = {
											"PA_CarrotChewed.M2", -- [1]
											"PA_CarrotRoots.M2", -- [2]
											"PA_CarrotUnderground.M2", -- [3]
										},
										["N"] = "Carrot",
									}, -- [27]
									{
										["T"] = {
											"PA_Cart_01.M2", -- [1]
											"PA_Cart_01_Vehicle.M2", -- [2]
											"PA_Cart_02.M2", -- [3]
											"PA_Cart_Beam.M2", -- [4]
											"PA_Cart_Husk.M2", -- [5]
											"PA_Cart_UnderConstruction.M2", -- [6]
											"PA_Cart_Wheel.M2", -- [7]
											"PA_Cart_Yoke.M2", -- [8]
										},
										["N"] = "Cart",
									}, -- [28]
									{
										["T"] = {
											"PA_Chair_01.M2", -- [1]
										},
										["N"] = "Chair",
									}, -- [29]
									{
										["T"] = {
											"PA_Chandelier_01.M2", -- [1]
										},
										["N"] = "Chandelier",
									}, -- [30]
									{
										["T"] = {
											"PA_chimney_01.M2", -- [1]
											"PA_chimney_02.M2", -- [2]
										},
										["N"] = "Chimney",
									}, -- [31]
									{
										["T"] = {
											"pa_cloudserpent_egg_black.M2", -- [1]
											"pa_cloudserpent_egg_black_broken.M2", -- [2]
											"pa_cloudserpent_egg_blue.M2", -- [3]
											"pa_cloudserpent_egg_blue_broken.M2", -- [4]
											"pa_cloudserpent_egg_gold.M2", -- [5]
											"pa_cloudserpent_egg_gold_broken.M2", -- [6]
											"pa_cloudserpent_egg_green.M2", -- [7]
											"pa_cloudserpent_egg_green_broken.M2", -- [8]
											"pa_cloudserpent_egg_red.M2", -- [9]
											"pa_cloudserpent_egg_red_broken.M2", -- [10]
										},
										["N"] = "Cloudserpentegg",
									}, -- [32]
									{
										["T"] = {
											"PA_Chopsticks_01.M2", -- [1]
											"PA_Fork_01.M2", -- [2]
											"PA_Ladle_01.M2", -- [3]
											"PA_Oven_01.M2", -- [4]
											"PA_Pan_02.M2", -- [5]
											"PA_Pan_03.M2", -- [6]
											"PA_Pan_04.M2", -- [7]
											"PA_Spoon_01.M2", -- [8]
											"PA_bowl_01.M2", -- [9]
										},
										["N"] = "Cookware",
									}, -- [33]
									{
										["T"] = {
											"PA_CountryHouse_WoodFrame_01.M2", -- [1]
										},
										["N"] = "Countryhouse",
									}, -- [34]
									{
										["T"] = {
											"PA_crate_01.M2", -- [1]
											"PA_crate_02.M2", -- [2]
											"PA_crate_04.M2", -- [3]
											"PA_crate_04_Lid.M2", -- [4]
											"PA_crate_04_Open.M2", -- [5]
											"PA_crate_05.M2", -- [6]
											"PA_crate_05_Lid.M2", -- [7]
											"PA_crate_05_Open.M2", -- [8]
											"PA_crate_06.M2", -- [9]
											"PA_crate_06_Lid.M2", -- [10]
											"PA_crate_06_Opened.M2", -- [11]
											"PA_crate_Huojin_Horde_01.M2", -- [12]
											"PA_crate_Huojin_Horde_01_Lid.M2", -- [13]
											"PA_crate_Huojin_Horde_01_Open.M2", -- [14]
											"PA_crate_Huojin_Horde_02.M2", -- [15]
											"PA_crate_Huojin_Horde_02_Lid.M2", -- [16]
											"PA_crate_Huojin_Horde_02_Open.M2", -- [17]
											"PA_crate_Huojin_Traditional_01.M2", -- [18]
											"PA_crate_Huojin_Traditional_01_Lid.M2", -- [19]
											"PA_crate_Huojin_Traditional_01_Open.M2", -- [20]
											"PA_crate_Huojin_Traditional_02.M2", -- [21]
											"PA_crate_Huojin_Traditional_02_Lid.M2", -- [22]
											"PA_crate_Huojin_Traditional_02_Open.M2", -- [23]
											"PA_crate_Tushui_Alliance_01.M2", -- [24]
											"PA_crate_Tushui_Alliance_01_Lid.M2", -- [25]
											"PA_crate_Tushui_Alliance_01_Open.M2", -- [26]
											"PA_crate_Tushui_Alliance_02.M2", -- [27]
											"PA_crate_Tushui_Alliance_02_Lid.M2", -- [28]
											"PA_crate_Tushui_Alliance_02_Open.M2", -- [29]
											"PA_crate_Tushui_Traditional_01.M2", -- [30]
											"PA_crate_Tushui_Traditional_01_Lid.M2", -- [31]
											"PA_crate_Tushui_Traditional_01_Open.M2", -- [32]
											"PA_crate_Tushui_Traditional_02.M2", -- [33]
											"PA_crate_Tushui_Traditional_02_Lid.M2", -- [34]
											"PA_crate_Tushui_Traditional_02_Open.M2", -- [35]
											"PA_crate_wrecked_01.M2", -- [36]
											"PA_crate_wrecked_02.M2", -- [37]
											"PA_crate_wrecked_03.M2", -- [38]
											"PA_crate_wrecked_04.M2", -- [39]
											"PA_crate_wrecked_05.M2", -- [40]
											"PA_crate_wrecked_06.M2", -- [41]
										},
										["N"] = "Crate",
									}, -- [35]
									{
										["T"] = {
											"PA_DebrisPile_01.M2", -- [1]
											"PA_DebrisPile_01_Burning.M2", -- [2]
											"PA_DebrisPile_02.M2", -- [3]
											"PA_DebrisPile_02_Burning.M2", -- [4]
											"PA_DebrisPile_Fire.M2", -- [5]
										},
										["N"] = "Debris",
									}, -- [36]
									{
										["T"] = {
											"PA_EastTemple_Desk_01.M2", -- [1]
										},
										["N"] = "Desk",
									}, -- [37]
									{
										["T"] = {
											"PA_Drowning_Sign_CoyFish.M2", -- [1]
											"PA_Drowning_Sign_Crane.M2", -- [2]
											"PA_Drowning_Sign_Crocodile.M2", -- [3]
											"PA_Drowning_Sign_Frog.M2", -- [4]
											"PA_Drowning_Sign_Skunk.M2", -- [5]
											"PA_Drowning_Sign_Snake.M2", -- [6]
											"PA_Drowning_Sign_Turtle.M2", -- [7]
										},
										["N"] = "Drowningsigns",
									}, -- [38]
									{
										["T"] = {
											"PA_Drum_01.M2", -- [1]
										},
										["N"] = "Drum",
									}, -- [39]
									{
										["T"] = {
											"PA_Firefly_Jar.M2", -- [1]
										},
										["N"] = "Fireflyjar",
									}, -- [40]
									{
										["T"] = {
											"PA_fireplace_01.M2", -- [1]
										},
										["N"] = "Fireplace",
									}, -- [41]
									{
										["T"] = {
											"PA_FireworkLauncher01.M2", -- [1]
										},
										["N"] = "Fireworklauncher",
									}, -- [42]
									{
										["T"] = {
											"PA_FishingBarrel_01.M2", -- [1]
											"PA_FishingNet_01.M2", -- [2]
											"PA_FishingNet_Mound_01.M2", -- [3]
											"PA_FishingNet_Mound_02.M2", -- [4]
											"PA_FishingRack_01.M2", -- [5]
											"PA_Fishing_OctopusStand_01.M2", -- [6]
											"PA_Fishing_TrapBait_01.M2", -- [7]
											"PA_Fishing_TrapCrabs_01.M2", -- [8]
											"PA_Fishing_Trap_01.M2", -- [9]
											"PA_RopeCoil_Mound_01.M2", -- [10]
											"PA_fishingBoom_01.M2", -- [11]
										},
										["N"] = "Fishing",
									}, -- [43]
									{
										["T"] = {
											"PA_FlightRoost_01.M2", -- [1]
											"PA_FlightRoost_02.M2", -- [2]
										},
										["N"] = "Flightroost",
									}, -- [44]
									{
										["T"] = {
											"PA_Flower_Petal_Yellow.M2", -- [1]
										},
										["N"] = "Flower",
									}, -- [45]
									{
										["T"] = {
											"PA_Forge_01.M2", -- [1]
											"PA_Forge_Tongs_01.M2", -- [2]
										},
										["N"] = "Forge",
									}, -- [46]
									{
										["T"] = {
											"PA_ShaFresco_01.M2", -- [1]
											"PA_ShaFresco_02.M2", -- [2]
											"PA_ShaFresco_03.M2", -- [3]
											"PA_ShaFresco_Panel_01.M2", -- [4]
											"PA_ShaFresco_Panel_02.M2", -- [5]
											"PA_ShaFresco_Panel_03.M2", -- [6]
										},
										["N"] = "Fresco",
									}, -- [47]
									{
										["T"] = {
											"PA_Game_Tiles01.M2", -- [1]
											"PA_Game_Tiles02.M2", -- [2]
										},
										["N"] = "Game",
									}, -- [48]
									{
										["T"] = {
											"PA_Gazebo_Railing1.M2", -- [1]
											"PA_Gazebo_Railing2.M2", -- [2]
										},
										["N"] = "Gazeborailing",
									}, -- [49]
									{
										["T"] = {
											"PA_Gong_01.M2", -- [1]
											"PA_Mallet_01.M2", -- [2]
										},
										["N"] = "Gong",
									}, -- [50]
									{
										["T"] = {
											"PA_Gourd_1.M2", -- [1]
											"PA_Gourd_1_NoWater.M2", -- [2]
										},
										["N"] = "Gourd",
									}, -- [51]
									{
										["T"] = {
											"PA_GrainBasket_01.M2", -- [1]
											"PA_GrainBasket_02.M2", -- [2]
											"PA_GrainBasket_03.M2", -- [3]
											"PA_GrainBasket_04.M2", -- [4]
											"PA_GrainBasket_05.M2", -- [5]
											"PA_GrainBasket_Lid_01.M2", -- [6]
											"PA_GrainBasket_Open_01.M2", -- [7]
											"PA_GrainBasket_Open_02.M2", -- [8]
											"PA_GrainBasket_Open_03.M2", -- [9]
											"PA_GrainBasket_Open_04.M2", -- [10]
											"PA_GrainBasket_Open_05.M2", -- [11]
											"PA_GrainBucket_01.M2", -- [12]
											"PA_GrainBucket_02.M2", -- [13]
											"PA_GrainBucket_03.M2", -- [14]
											"PA_GrainBucket_04.M2", -- [15]
											"PA_GrainBucket_05.M2", -- [16]
											"PA_GrainBucket_Lid_01.M2", -- [17]
											"PA_GrainBucket_Lid_02.M2", -- [18]
											"PA_GrainBucket_Lid_03.M2", -- [19]
											"PA_GrainBucket_Lid_04.M2", -- [20]
											"PA_GrainBucket_Lid_05.M2", -- [21]
											"PA_GrainBucket_Open_01.M2", -- [22]
											"PA_GrainBucket_Open_02.M2", -- [23]
											"PA_GrainBucket_Open_03.M2", -- [24]
											"PA_GrainBucket_Open_04.M2", -- [25]
											"PA_GrainBucket_Open_05.M2", -- [26]
											"PA_GrainSack_01.M2", -- [27]
											"PA_GrainSack_02.M2", -- [28]
											"PA_GrainSack_03.M2", -- [29]
											"PA_GrainSack_04.M2", -- [30]
											"PA_GrainSack_Open_01.M2", -- [31]
											"PA_GrainSack_Open_02.M2", -- [32]
											"PA_GrainSack_Open_03.M2", -- [33]
											"PA_GrainSack_Open_04.M2", -- [34]
											"PA_Grain_Pile_01.M2", -- [35]
											"PA_Grain_Pile_02.M2", -- [36]
											"PA_Grain_Pile_03.M2", -- [37]
											"PA_Grain_Pile_04.M2", -- [38]
										},
										["N"] = "Grain",
									}, -- [52]
									{
										["T"] = {
											"PA_GraveStone_01.M2", -- [1]
											"PA_GraveStone_02.M2", -- [2]
											"PA_GraveStone_03.M2", -- [3]
											"PA_GraveStone_04.M2", -- [4]
											"PA_GraveStone_05.M2", -- [5]
											"PA_GraveStone_06.M2", -- [6]
											"PA_GraveStone_NoBase_01.M2", -- [7]
											"PA_GraveStone_NoBase_02.M2", -- [8]
											"PA_GraveStone_NoBase_03.M2", -- [9]
											"PA_Graveyard_Focal_01.M2", -- [10]
											"PA_Graveyard_Headstone_01.M2", -- [11]
											"PA_Graveyard_Headstone_02.M2", -- [12]
											"PA_Graveyard_Headstone_03.M2", -- [13]
											"PA_Graveyard_Headstone_04.M2", -- [14]
											"PA_Graveyard_Headstone_05.M2", -- [15]
										},
										["N"] = "Gravestone",
									}, -- [53]
									{
										["T"] = {
											"PA_HangingCharm_Long_01.M2", -- [1]
											"PA_HangingCharm_Long_01b.M2", -- [2]
											"PA_HangingCharm_Long_02.M2", -- [3]
											"PA_HangingCharm_Long_04.M2", -- [4]
											"PA_HangingCharm_Long_05.M2", -- [5]
											"PA_HangingCharm_Long_06.M2", -- [6]
											"PA_HangingCharm_Short_01.M2", -- [7]
											"PA_HangingCharm_Short_01b.M2", -- [8]
											"PA_HangingCharm_Short_02.M2", -- [9]
											"PA_HangingCharm_Short_03.M2", -- [10]
											"PA_HangingCharm_Short_04.M2", -- [11]
											"PA_HangingCharm_Short_05.M2", -- [12]
											"PA_HangingCharm_Short_06.M2", -- [13]
										},
										["N"] = "Hangingcharm",
									}, -- [54]
									{
										["T"] = {
											"PA_Garlic_01.M2", -- [1]
											"PA_Garlic_Single_01.M2", -- [2]
											"PA_Hook_01.M2", -- [3]
											"PA_Hook_02.M2", -- [4]
											"PA_Pepper_Single_01.M2", -- [5]
											"PA_Pepper_Single_02.M2", -- [6]
											"PA_Pepper_Single_03.M2", -- [7]
											"PA_Peppers_01.M2", -- [8]
										},
										["N"] = "Hangingfood",
									}, -- [55]
									{
										["T"] = {
											"PA_HayBale_01.M2", -- [1]
										},
										["N"] = "Haybale",
									}, -- [56]
									{
										["T"] = {
											"PA_HotAirBalloon.M2", -- [1]
										},
										["N"] = "Hotairballoon",
									}, -- [57]
									{
										["T"] = {
											"PA_House_WoodFrame_01.M2", -- [1]
										},
										["N"] = "House",
									}, -- [58]
									{
										["T"] = {
											"PA_incenseStick_01bundle.M2", -- [1]
											"PA_incenseStick_01burn.M2", -- [2]
											"PA_incenseStick_01burn2.M2", -- [3]
											"PA_incenseStick_01burn2_NoCol.M2", -- [4]
											"PA_incenseStick_01burn_NoCol.M2", -- [5]
											"PA_incenseStick_01unburnt.M2", -- [6]
										},
										["N"] = "Incense",
									}, -- [59]
									{
										["T"] = {
											"PA_innBench_01.M2", -- [1]
											"PA_innTable_01.M2", -- [2]
										},
										["N"] = "Inn",
									}, -- [60]
									{
										["T"] = {
											"PA_JadeDragonSculpture_DestroyedHead.M2", -- [1]
											"PA_JadeDragonSculpture_DestroyedLeg.M2", -- [2]
											"PA_JadeDragonSculpture_DestroyedLeg02.M2", -- [3]
											"PA_JadeDragonSculpture_DestroyedTorso.M2", -- [4]
										},
										["N"] = "Jadedragonsculpture",
									}, -- [61]
									{
										["T"] = {
											"PA_JadeMine_Web01.M2", -- [1]
											"PA_JadeMine_Web02.M2", -- [2]
											"PA_JadeMine_Web03.M2", -- [3]
											"PA_JadeMine_Web04.M2", -- [4]
											"PA_JadeMine_Web05.M2", -- [5]
											"PA_JadeMine_Web06.M2", -- [6]
											"PA_JadeMine_Web07.M2", -- [7]
											"PA_JadeMine_Web08.M2", -- [8]
											"PA_JadeMine_Web09.M2", -- [9]
											"PA_JadeMine_Web10.M2", -- [10]
										},
										["N"] = "Jademine",
									}, -- [62]
									{
										["T"] = {
											"PA_JadeBarrel_01.M2", -- [1]
											"PA_JadeChunks_01.M2", -- [2]
											"Pa_JadeMineCart_01.M2", -- [3]
											"Pa_JadeMineCart_01_Anim.M2", -- [4]
											"Pa_JadeMineCart_Empty.M2", -- [5]
										},
										["N"] = "Jademinecart",
									}, -- [63]
									{
										["T"] = {
											"PA_Keg_01.M2", -- [1]
											"PA_Keg_01U.M2", -- [2]
											"PA_Keg_02.M2", -- [3]
											"PA_Keg_02U.M2", -- [4]
											"PA_Keg_03.M2", -- [5]
											"PA_Keg_03U.M2", -- [6]
											"PA_Keg_04.M2", -- [7]
											"PA_Keg_04U.M2", -- [8]
											"PA_Keg_05.M2", -- [9]
											"PA_Keg_05U.M2", -- [10]
											"PA_Keg_06.M2", -- [11]
											"PA_Keg_06U.M2", -- [12]
											"PA_Keg_07.M2", -- [13]
											"PA_Keg_07U.M2", -- [14]
											"PA_Keg_08.M2", -- [15]
											"PA_Keg_08U.M2", -- [16]
											"PA_Keg_09.M2", -- [17]
											"PA_Keg_09U.M2", -- [18]
											"PA_Keg_10.M2", -- [19]
											"PA_Keg_10U.M2", -- [20]
											"PA_Keg_11.M2", -- [21]
											"PA_Keg_11U.M2", -- [22]
											"PA_Keg_12.M2", -- [23]
											"PA_Keg_12U.M2", -- [24]
											"PA_Keg_13.M2", -- [25]
											"PA_Keg_13U.M2", -- [26]
											"PA_Keg_14.M2", -- [27]
											"PA_Keg_15.M2", -- [28]
											"PA_Keg_15U.M2", -- [29]
											"PA_Keg_16.M2", -- [30]
											"PA_Keg_16U.M2", -- [31]
											"PA_Keg_Deluxe_01U.M2", -- [32]
											"PA_Keg_Deluxe_02U.M2", -- [33]
											"PA_Keg_Deluxe_04U.M2", -- [34]
											"PA_Keg_Deluxe_05U.M2", -- [35]
											"PA_Keg_Deluxe_06U.M2", -- [36]
											"PA_Keg_Deluxe_07U.M2", -- [37]
											"PA_Keg_Deluxe_08U.M2", -- [38]
											"PA_Keg_Stand01.M2", -- [39]
											"PA_Keg_Stand02.M2", -- [40]
										},
										["N"] = "Keg",
									}, -- [64]
									{
										["T"] = {
											"PA_kitcheninset_01.M2", -- [1]
											"PA_kitcheninset_small.M2", -- [2]
											"PA_kitcheninset_small_country.M2", -- [3]
										},
										["N"] = "Kitcheninset",
									}, -- [65]
									{
										["T"] = {
											"PA_kitchenTable_01.M2", -- [1]
										},
										["N"] = "Kitchentable",
									}, -- [66]
									{
										["T"] = {
											"PA_Kite_01.M2", -- [1]
											"PA_Kite_02.M2", -- [2]
											"PA_Kite_03.M2", -- [3]
										},
										["N"] = "Kite",
									}, -- [67]
									{
										["T"] = {
											"PA_Kite_Lamp_01.M2", -- [1]
										},
										["N"] = "Kite_lamp",
									}, -- [68]
									{
										["T"] = {
											"PA_KungFuGear_01.M2", -- [1]
											"PA_KungFuGear_02.M2", -- [2]
											"PA_KungFuGear_Bag_Left.M2", -- [3]
										},
										["N"] = "Kungfugear",
									}, -- [69]
									{
										["T"] = {
											"PA_KunlaiRoadlamp_01.M2", -- [1]
											"PA_KunlaiRoadlamp_02.M2", -- [2]
											"PA_KunlaiRoadsign_01.M2", -- [3]
											"PA_KunlaiRoadsign_Post_01.M2", -- [4]
											"PA_KunlaiRoadsign_Rock_01.M2", -- [5]
											"PA_KunlaiRoadsign_Sign_01.M2", -- [6]
											"PA_Kunlai_FencePost_01.M2", -- [7]
											"PA_Kunlai_Fence_01.M2", -- [8]
										},
										["N"] = "Kunlai",
									}, -- [70]
									{
										["T"] = {
											"PA_Ladder_01.M2", -- [1]
										},
										["N"] = "Ladder",
									}, -- [71]
									{
										["T"] = {
											"PA_Water_LampPost_01.M2", -- [1]
											"PA_Water_LampPost_02.M2", -- [2]
										},
										["N"] = "Lamppost",
									}, -- [72]
									{
										["T"] = {
											"PA_Lamps_Outdoor_Stone_01.M2", -- [1]
											"PA_Lamps_Outdoor_Stone_No_Green_01.M2", -- [2]
											"PA_Lamps_Outdoor_Stone_Snowy_01.M2", -- [3]
										},
										["N"] = "Lamps_outdoor_stone",
									}, -- [73]
									{
										["T"] = {
											"PA_Lamps_Outdoor_Wood_01.M2", -- [1]
											"PA_Lamps_Outdoor_Wood_Wrecked_01.M2", -- [2]
											"PA_Lamps_Outdoor_Wood_Wrecked_02.M2", -- [3]
											"PA_Lamps_Outdoor_Wood_Wrecked_03.M2", -- [4]
											"PA_Lamps_Outdoor_Wood_Wrecked_04.M2", -- [5]
										},
										["N"] = "Lamps_outdoor_wood",
									}, -- [74]
									{
										["T"] = {
											"PA_Lamps_Outdoors_Wood_LampOnly_01.M2", -- [1]
											"PA_Lamps_Outdoors_Wood_PostOnly_01.M2", -- [2]
										},
										["N"] = "Lamps_outdoors_wood",
									}, -- [75]
									{
										["T"] = {
											"PA_Lantern_Floating_01.M2", -- [1]
											"PA_Lantern_Floating_01_Destroyed.M2", -- [2]
											"PA_Lantern_Glow_EastTemple_01.M2", -- [3]
											"PA_Lantern_House_01.M2", -- [4]
										},
										["N"] = "Lantern",
									}, -- [76]
									{
										["T"] = {
											"PA_Lantern_Paper_Round_Red_01.M2", -- [1]
											"PA_Lantern_Paper_Round_Red_01_Wind.M2", -- [2]
											"PA_Lantern_Paper_Round_Red_Fancy_01.M2", -- [3]
											"PA_Lantern_Paper_Round_Red_Unlit_01.M2", -- [4]
										},
										["N"] = "Lantern_paper",
									}, -- [77]
									{
										["T"] = {
											"PA_MailBox_01.M2", -- [1]
										},
										["N"] = "Mailbox",
									}, -- [78]
									{
										["T"] = {
											"PA_Mug_01.M2", -- [1]
											"PA_Mug_02.M2", -- [2]
											"PA_Mug_03.M2", -- [3]
											"PA_Mug_04.M2", -- [4]
											"PA_Mug_05.M2", -- [5]
											"PA_Mug_06.M2", -- [6]
											"PA_Mug_Bamboo_01.M2", -- [7]
											"PA_Mug_Bamboo_01_SpellObject.M2", -- [8]
											"PA_Mug_Bamboo_02.M2", -- [9]
											"PA_Mug_Bamboo_03.M2", -- [10]
											"PA_Mug_Bamboo_04.M2", -- [11]
											"PA_Mug_Bamboo_05.M2", -- [12]
										},
										["N"] = "Mugs",
									}, -- [79]
									{
										["T"] = {
											"PA_BundledPaper_01.M2", -- [1]
											"PA_BundledPaper_02.M2", -- [2]
										},
										["N"] = "Paper",
									}, -- [80]
									{
										["T"] = {
											"PA_Antique_Bugsprayer.M2", -- [1]
											"PA_Antique_Bugsprayer_Fire.M2", -- [2]
											"PA_Antique_Bugsprayer_Poison.M2", -- [3]
											"PA_Farm_Bellsofharmony01.M2", -- [4]
											"PA_Farm_Bellsofharmony02.M2", -- [5]
											"PA_Farm_EnigmaSeed01.M2", -- [6]
											"PA_Farm_Magebulb01.M2", -- [7]
											"PA_Farm_Magebulb02.M2", -- [8]
											"PA_Farm_Snakeroot01.M2", -- [9]
											"PA_Farm_Snakeroot02.M2", -- [10]
											"PA_Farm_raptorLeaf01.M2", -- [11]
											"PA_Farm_raptorLeaf02.M2", -- [12]
											"PA_Farm_windShearCactus01.M2", -- [13]
											"PA_Farm_windShearCactus02.M2", -- [14]
											"PA_Pulse_Wave_Emitter.M2", -- [15]
											"PA_Rusty_WateringCan_01.M2", -- [16]
											"PA_Rusty_WateringCan_01_FX.M2", -- [17]
											"PA_farmSoil_Untilled.M2", -- [18]
											"PA_farmSoil_tilled.M2", -- [19]
											"Pa_Farm_dirtPiece01.M2", -- [20]
											"Pa_Farm_dirtPiece02.M2", -- [21]
											"Pa_Farm_dirtPiece03.M2", -- [22]
											"Pa_Farm_dirtPiece04.M2", -- [23]
											"Pa_Farm_dirtPiece05.M2", -- [24]
											"Pa_Farm_dirtPiece06.M2", -- [25]
											"Pa_Farm_magicdust.M2", -- [26]
										},
										["N"] = "Playerfarm",
									}, -- [81]
									{
										["T"] = {
											"PA_Plow_01.M2", -- [1]
										},
										["N"] = "Plow",
									}, -- [82]
									{
										["T"] = {
											"PA_PostwithRopes_01.M2", -- [1]
										},
										["N"] = "Postwithropes",
									}, -- [83]
									{
										["T"] = {
											"PA_Pot_01.M2", -- [1]
											"PA_Pot_02.M2", -- [2]
											"PA_Pot_03.M2", -- [3]
											"PA_Pot_Empty_01.M2", -- [4]
											"PA_Pot_Empty_02.M2", -- [5]
											"PA_Pot_Empty_03.M2", -- [6]
										},
										["N"] = "Pot",
									}, -- [84]
									{
										["T"] = {
											"PA_PunchingSand.M2", -- [1]
										},
										["N"] = "Punchingstand",
									}, -- [85]
									{
										["T"] = {
											"PA_PunchingTarget.M2", -- [1]
										},
										["N"] = "Punchingtarget",
									}, -- [86]
									{
										["T"] = {
											"PA_Broom_01.M2", -- [1]
											"PA_Hoe_01.M2", -- [2]
											"PA_Rake_01.M2", -- [3]
										},
										["N"] = "Rake",
									}, -- [87]
									{
										["T"] = {
											"PA_Rice_BananaLeaves_01.M2", -- [1]
											"PA_Rice_BananaLeaves_02.M2", -- [2]
											"PA_Rice_BananaLeaves_03.M2", -- [3]
											"PA_Rice_BananaLeaves_04.M2", -- [4]
										},
										["N"] = "Rice",
									}, -- [88]
									{
										["T"] = {
											"RiceSeedling_01.M2", -- [1]
											"RiceSeedling_02.M2", -- [2]
										},
										["N"] = "Rice_seedling",
									}, -- [89]
									{
										["T"] = {
											"PA_RiceSieve_01.M2", -- [1]
										},
										["N"] = "Ricesieve",
									}, -- [90]
									{
										["T"] = {
											"PA_Rickshaw_01.M2", -- [1]
										},
										["N"] = "Rickshaw",
									}, -- [91]
									{
										["T"] = {
											"PA_Ritual_Stone_01.M2", -- [1]
											"PA_Ritual_Stone_02.M2", -- [2]
											"PA_Ritual_Stone_Scrolls_01.M2", -- [3]
											"PA_Ritual_Stone_Scrolls_02.M2", -- [4]
											"PA_Ritual_Stone_Snowy_01.M2", -- [5]
										},
										["N"] = "Ritual_stone",
									}, -- [92]
									{
										["T"] = {
											"PA_RoadSign_Pointer_01.M2", -- [1]
											"PA_RoadSign_Post_01.M2", -- [2]
										},
										["N"] = "Roadsign",
									}, -- [93]
									{
										["T"] = {
											"PA_RockPond_01.M2", -- [1]
											"PA_RockPond_02.M2", -- [2]
											"PA_RockPond_03.M2", -- [3]
											"PA_RockPond_04.M2", -- [4]
											"PA_RockPond_05.M2", -- [5]
										},
										["N"] = "Rockpond",
									}, -- [94]
									{
										["T"] = {
											"PA_Rugs_01.M2", -- [1]
											"PA_Rugs_02.M2", -- [2]
										},
										["N"] = "Rugs",
									}, -- [95]
									{
										["T"] = {
											"PA_Ruins_WallPieces_01.M2", -- [1]
											"PA_Ruins_WallPieces_02.M2", -- [2]
											"PA_Ruins_WallPieces_03.M2", -- [3]
											"PA_Ruins_WallPieces_04.M2", -- [4]
											"PA_Ruins_WallPieces_05.M2", -- [5]
											"PA_Ruins_WallPieces_06.M2", -- [6]
											"PA_Ruins_WallPieces_07.M2", -- [7]
											"PA_Ruins_WallPieces_08.M2", -- [8]
											"PA_Ruins_WallPieces_09.M2", -- [9]
											"PA_Ruins_WallPieces_10.M2", -- [10]
											"PA_Ruins_WallPieces_11.M2", -- [11]
											"PA_Ruins_WallPieces_12.M2", -- [12]
											"PA_Ruins_WallPieces_13.M2", -- [13]
											"PA_Ruins_WallPieces_14.M2", -- [14]
											"PA_Ruins_WallPieces_15.M2", -- [15]
											"PA_Ruins_WallPieces_16.M2", -- [16]
										},
										["N"] = "Ruins",
									}, -- [96]
									{
										["T"] = {
											"PA_Rural_Shed01.M2", -- [1]
										},
										["N"] = "Rural_shed",
									}, -- [97]
									{
										["T"] = {
											"PA_Rural_Water_Tower.M2", -- [1]
										},
										["N"] = "Rural_water_tower",
									}, -- [98]
									{
										["T"] = {
											"PA_Sack_01.M2", -- [1]
											"PA_Sack_02.M2", -- [2]
											"PA_Sack_03.M2", -- [3]
											"PA_Sack_04.M2", -- [4]
											"PA_Sack_05.M2", -- [5]
										},
										["N"] = "Sack",
									}, -- [99]
									{
										["T"] = {
											"PA_Scaffolding_01.M2", -- [1]
											"PA_Scaffolding_02.M2", -- [2]
											"PA_Scaffolding_Broken_01.M2", -- [3]
											"PA_Scaffolding_Broken_02.M2", -- [4]
											"PA_Scaffolding_Broken_Pole_01.M2", -- [5]
											"PA_Scaffolding_Broken_Pole_02.M2", -- [6]
											"PA_Scaffolding_Pulley_01.M2", -- [7]
										},
										["N"] = "Scaffolding",
									}, -- [100]
									{
										["T"] = {
											"PA_SCARECROW_01NoCollision.M2", -- [1]
											"PA_scarecrow_01.M2", -- [2]
										},
										["N"] = "Scarecrow",
									}, -- [101]
									{
										["T"] = {
											"PA_EastTemple_Room_Scrolls.M2", -- [1]
											"PA_EastTemple_Room_Scrolls_02.M2", -- [2]
											"PA_EastTemple_Room_Scrolls_03.M2", -- [3]
											"PA_EastTemple_Room_Scrolls_04.M2", -- [4]
											"PA_EastTemple_Room_Scrolls_05.M2", -- [5]
											"PA_EastTemple_Room_Scrolls_06.M2", -- [6]
											"PA_EastTemple_Room_Scrolls_07.M2", -- [7]
											"PA_EastTemple_Room_Scrolls_08.M2", -- [8]
											"PA_EastTemple_Room_Scrolls_09.M2", -- [9]
											"PA_Scroll_01.M2", -- [10]
											"PA_Scroll_02.M2", -- [11]
											"PA_Scroll_03.M2", -- [12]
											"PA_Scroll_04.M2", -- [13]
											"PA_Scroll_05.M2", -- [14]
											"PA_Scroll_06.M2", -- [15]
											"PA_Scroll_07.M2", -- [16]
											"PA_Scroll_08.M2", -- [17]
											"PA_Scroll_09.M2", -- [18]
											"PA_Scroll_10.M2", -- [19]
											"PA_Scroll_Huge_01.M2", -- [20]
											"PA_Scroll_Huge_02.M2", -- [21]
											"PA_Scroll_Huge_03.M2", -- [22]
											"PA_Scroll_Huge_04.M2", -- [23]
											"PA_Scroll_Huge_05.M2", -- [24]
											"PA_Scroll_Huge_06.M2", -- [25]
											"PA_Scroll_Huge_07.M2", -- [26]
											"PA_Scroll_Huge_08.M2", -- [27]
											"PA_Scroll_Huge_09.M2", -- [28]
										},
										["N"] = "Scroll",
									}, -- [102]
									{
										["T"] = {
											"PA_Shrine_Crane_01.M2", -- [1]
											"PA_Shrine_Crane_02.M2", -- [2]
											"PA_Shrine_Crane_03.M2", -- [3]
											"PA_Shrine_Crane_04.M2", -- [4]
										},
										["N"] = "Shrine_crane",
									}, -- [103]
									{
										["T"] = {
											"PA_Shrine_JadeDragon_Large_01.M2", -- [1]
											"PA_Shrine_JadeDragon_Large_02.M2", -- [2]
											"PA_Shrine_Large_01.M2", -- [3]
											"PA_Shrine_Large_02.M2", -- [4]
											"PA_Shrine_Large_03.M2", -- [5]
											"PA_Shrine_Large_05.M2", -- [6]
											"PA_Shrine_Large_06.M2", -- [7]
											"PA_Shrine_Large_Destroyed_01.M2", -- [8]
											"PA_Shrine_Large_Destroyed_02.M2", -- [9]
											"PA_Shrine_Large_Snowy_01.M2", -- [10]
											"PA_Shrine_Small_Destroyed_01.M2", -- [11]
											"PA_Shrine_Small_Destroyed_02.M2", -- [12]
										},
										["N"] = "Shrine_large",
									}, -- [104]
									{
										["T"] = {
											"PA_shrine_med_01.M2", -- [1]
											"PA_shrine_med_02.M2", -- [2]
										},
										["N"] = "Shrine_med",
									}, -- [105]
									{
										["T"] = {
											"PA_ShrineBowl_01.M2", -- [1]
											"PA_Shrine_Props_Medallion_01.M2", -- [2]
											"PA_Shrine_Props_Scroll_Long_01.M2", -- [3]
											"PA_Shrine_Props_Scroll_Short_01.M2", -- [4]
											"PA_Shrine_Props_Tray_01.M2", -- [5]
											"PA_apple_01.M2", -- [6]
											"PA_bananaBunch_01.M2", -- [7]
											"PA_bananaBunch_02.M2", -- [8]
											"PA_bananaBunch_03.M2", -- [9]
											"PA_bananaBunch_04.M2", -- [10]
											"PA_bananaBunch_05.M2", -- [11]
											"PA_banana_01.M2", -- [12]
											"PA_candle_01.M2", -- [13]
											"PA_flowerPot_01.M2", -- [14]
											"PA_fruitBowl_01.M2", -- [15]
											"PA_riceBowl_01.M2", -- [16]
										},
										["N"] = "Shrine_props",
									}, -- [106]
									{
										["T"] = {
											"PA_Shrine_RoadSide_01.M2", -- [1]
											"PA_Shrine_RoadSide_02.M2", -- [2]
										},
										["N"] = "Shrine_road",
									}, -- [107]
									{
										["T"] = {
											"PA_Signs_Bank.M2", -- [1]
											"PA_Signs_Bank_Vertical.M2", -- [2]
											"PA_Signs_GeneralShop.M2", -- [3]
											"PA_Signs_GeneralShop_Vertical.M2", -- [4]
											"PA_Signs_Inn.M2", -- [5]
											"PA_Signs_Inn_Vertical.M2", -- [6]
										},
										["N"] = "Signs",
									}, -- [108]
									{
										["T"] = {
											"PA_SilkCocoonTub_01.M2", -- [1]
											"PA_SilkCocoon_01.M2", -- [2]
											"PA_SilkLoom_01.M2", -- [3]
											"PA_SilkLoom_02.M2", -- [4]
										},
										["N"] = "Silk",
									}, -- [109]
									{
										["T"] = {
											"PA_SpiritWall.M2", -- [1]
											"PA_SpiritWall_Wide.M2", -- [2]
										},
										["N"] = "Spiritwall",
									}, -- [110]
									{
										["T"] = {
											"PA_dragonDoorStatue_01.M2", -- [1]
											"PA_dragonDoorStatue_02.M2", -- [2]
											"PA_dragonDoorStatue_03.M2", -- [3]
										},
										["N"] = "Statues",
									}, -- [111]
									{
										["T"] = {
											"PA_SteppingStone_01.M2", -- [1]
											"PA_SteppingStone_02.M2", -- [2]
											"PA_SteppingStone_03.M2", -- [3]
										},
										["N"] = "Steppingstone",
									}, -- [112]
									{
										["T"] = {
											"PA_Still_01.M2", -- [1]
											"PA_Still_02.M2", -- [2]
										},
										["N"] = "Still",
									}, -- [113]
									{
										["T"] = {
											"PA_Stone_Fence_01.M2", -- [1]
											"PA_Stone_Fence_02.M2", -- [2]
											"PA_Stone_Fence_Post_01.M2", -- [3]
											"PA_Stone_Fence_Post_02.M2", -- [4]
											"PA_Stone_Fence_Post_03.M2", -- [5]
											"PA_Stone_Fence_Post_04.M2", -- [6]
											"PA_Stone_Rail_Fence_01.M2", -- [7]
											"PA_Stone_Rail_Fence_Post.M2", -- [8]
										},
										["N"] = "Stone_fence",
									}, -- [114]
									{
										["T"] = {
											"PA_Stone_Post_01.M2", -- [1]
											"PA_Stone_Post_01wide.M2", -- [2]
											"PA_Stone_Post_EastTemple_01.M2", -- [3]
											"PA_Stone_Post_EastTemple_01_Wide.M2", -- [4]
										},
										["N"] = "Stone_post",
									}, -- [115]
									{
										["T"] = {
											"PA_Stone_Walls_01.M2", -- [1]
											"PA_Stone_Walls_02.M2", -- [2]
											"PA_Stone_Walls_03.M2", -- [3]
											"PA_Stone_Walls_03window.M2", -- [4]
											"PA_Stone_Walls_04.M2", -- [5]
											"PA_Stone_Walls_EastTemple_01.M2", -- [6]
											"PA_Stone_Walls_EastTemple_02.M2", -- [7]
											"PA_Stone_Walls_EastTemple_03.M2", -- [8]
											"PA_Stone_Walls_EastTemple_03_Window.M2", -- [9]
											"PA_Stone_Walls_EastTemple_04.M2", -- [10]
											"PA_Stone_Walls_EastTemple_Arched_Gateway.M2", -- [11]
											"PA_Stone_Walls_EastTemple_Arched_Gateway_02.M2", -- [12]
										},
										["N"] = "Stone_walls",
									}, -- [116]
									{
										["T"] = {
											"PA_Stool_02.M2", -- [1]
											"PA_stool_01.M2", -- [2]
										},
										["N"] = "Stool",
									}, -- [117]
									{
										["T"] = {
											"PA_stove_all_01.M2", -- [1]
											"PA_stove_cook_01.M2", -- [2]
											"PA_stove_lid_01.M2", -- [3]
											"PA_stove_open_01.M2", -- [4]
										},
										["N"] = "Stove",
									}, -- [118]
									{
										["T"] = {
											"PA_Table_01.M2", -- [1]
											"PA_Table_02.M2", -- [2]
										},
										["N"] = "Table",
									}, -- [119]
									{
										["T"] = {
											"PA_table_arc_01.M2", -- [1]
										},
										["N"] = "Table_arc",
									}, -- [120]
									{
										["T"] = {
											"PA_BambooHouse_Lamp_01.M2", -- [1]
											"PA_tableLamp_01.M2", -- [2]
										},
										["N"] = "Tablelamp",
									}, -- [121]
									{
										["T"] = {
											"PA_tents_01.M2", -- [1]
											"PA_tents_02.M2", -- [2]
											"PA_tents_03.M2", -- [3]
											"PA_tents_04.M2", -- [4]
											"PA_tents_alliance.M2", -- [5]
											"PA_tents_alliance_small.M2", -- [6]
											"PA_tents_horde.M2", -- [7]
											"PA_tents_horde_small.M2", -- [8]
											"PA_tents_wrecked_01.M2", -- [9]
											"PA_tents_wrecked_02.M2", -- [10]
										},
										["N"] = "Tents",
									}, -- [122]
									{
										["T"] = {
											"Immerseus_Center_Pool_FX_Wrap.M2", -- [1]
											"Immerseus_WaterBall.M2", -- [2]
											"Immerseus_Waterfall_Channel_FX_Wrap.M2", -- [3]
											"PA_TitanVaultDoor01.M2", -- [4]
										},
										["N"] = "Titanvault",
									}, -- [123]
									{
										["T"] = {
											"PA_Silk_Dye_Tub_Blue.M2", -- [1]
											"PA_Silk_Dye_Tub_Brown.M2", -- [2]
											"PA_Silk_Dye_Tub_Green.M2", -- [3]
											"PA_Silk_Dye_Tub_Red.M2", -- [4]
											"PA_Spool_Silk_Blue.M2", -- [5]
											"PA_Spool_Silk_Brown.M2", -- [6]
											"PA_Spool_Silk_Green.M2", -- [7]
											"PA_Spool_Silk_Red.M2", -- [8]
											"PA_Spool_Silk_White.M2", -- [9]
											"PA_Tools_Axe.M2", -- [10]
											"PA_Tools_Chisel.M2", -- [11]
											"PA_Tools_Hammer.M2", -- [12]
											"PA_Tools_Pickaxe.M2", -- [13]
											"PA_Tools_Planer.M2", -- [14]
											"PA_Tools_Saw.M2", -- [15]
											"PA_Tools_Toolbox.M2", -- [16]
										},
										["N"] = "Tools",
									}, -- [124]
									{
										["T"] = {
											"PA_turret_inactive_01.M2", -- [1]
										},
										["N"] = "Turret",
									}, -- [125]
									{
										["T"] = {
											"PA_turtleshrineCollision_01.M2", -- [1]
											"PA_turtleshrine_01.M2", -- [2]
											"PA_turtleshrine_ext.M2", -- [3]
											"PA_turtleshrine_ext_notree.M2", -- [4]
										},
										["N"] = "Turtleshrine",
									}, -- [126]
									{
										["T"] = {
											"PA_Temple_Door_01.M2", -- [1]
											"PA_templeFountain_01.M2", -- [2]
										},
										["N"] = "Turtletemple",
									}, -- [127]
									{
										["T"] = {
											"PA_WalkingStick_01.M2", -- [1]
											"PA_WalkingStick_02.M2", -- [2]
											"PA_WalkingStick_BlossomAnim_01.M2", -- [3]
											"PA_WalkingStick_Mound_01.M2", -- [4]
											"PA_WalkingStick_Sapling_01.M2", -- [5]
										},
										["N"] = "Walkingstick",
									}, -- [128]
									{
										["T"] = {
											"PA_WallHanging_01.M2", -- [1]
											"PA_WallHanging_02.M2", -- [2]
											"PA_WallHanging_03.M2", -- [3]
											"PA_WallHanging_04.M2", -- [4]
											"PA_WallHanging_05.M2", -- [5]
										},
										["N"] = "Wallhanging",
									}, -- [129]
									{
										["T"] = {
											"PA_WaterWheel_01.M2", -- [1]
											"PA_WaterWheel_BrewhouseGears.M2", -- [2]
											"PA_WaterWheel_Fancy.M2", -- [3]
										},
										["N"] = "Waterwheel",
									}, -- [130]
									{
										["T"] = {
											"PA_WeaponRack_01.M2", -- [1]
											"PA_WeaponRack_02.M2", -- [2]
											"PA_WeaponRack_03.M2", -- [3]
										},
										["N"] = "Weaponrack",
									}, -- [131]
									{
										["T"] = {
											"PA_Weapon_01.M2", -- [1]
											"PA_Weapon_02.M2", -- [2]
											"PA_Weapon_03.M2", -- [3]
										},
										["N"] = "Weapons",
									}, -- [132]
									{
										["T"] = {
											"PA_Well_01.M2", -- [1]
											"PA_Well_Country_01.M2", -- [2]
										},
										["N"] = "Well",
									}, -- [133]
									{
										["T"] = {
											"PA_WheelBarrow_01.M2", -- [1]
											"PA_WheelBarrow_02.M2", -- [2]
										},
										["N"] = "Wheelbarrows",
									}, -- [134]
									{
										["T"] = {
											"PA_WhiteTiger_Statue.M2", -- [1]
											"PA_WhiteTiger_Statue02.M2", -- [2]
											"PA_WhiteTiger_Statue_Huge.M2", -- [3]
											"PA_WhiteTiger_Statue_Moss.M2", -- [4]
										},
										["N"] = "Whitetiger",
									}, -- [135]
									{
										["T"] = {
											"PA_WoodCluster.M2", -- [1]
											"StackOfWood.M2", -- [2]
										},
										["N"] = "Wood",
									}, -- [136]
									{
										["T"] = {
											"PA_Wood_Fence_01.M2", -- [1]
											"PA_Wood_Fence_02.M2", -- [2]
											"PA_Wood_Fence_Post_01.M2", -- [3]
											"PA_Wood_Fence_Post_02.M2", -- [4]
											"PA_Wood_Fence_Skinny_01.M2", -- [5]
											"PA_Wood_Fence_Skinny_Post.M2", -- [6]
											"PA_Wood_Rail_Fence_01.M2", -- [7]
											"PA_Wood_Rail_Fence_Burned_01.M2", -- [8]
											"PA_Wood_Rail_Fence_Burned_02.M2", -- [9]
											"PA_Wood_Rail_Fence_Burned_03.M2", -- [10]
											"PA_Wood_Rail_Fence_Post.M2", -- [11]
											"PA_Wood_Rail_Fence_Post_Burned_01.M2", -- [12]
											"PA_Wood_Rail_Fence_Post_Burned_02.M2", -- [13]
											"PA_Wood_Rail_Fence_Post_Burned_03.M2", -- [14]
											"PA_Wood_Rail_Fence_Post_Wrecked_01.M2", -- [15]
											"PA_Wood_Rail_Fence_Post_Wrecked_02.M2", -- [16]
											"PA_Wood_Rail_Fence_Post_Wrecked_03.M2", -- [17]
											"PA_Wood_Rail_Fence_Post_Wrecked_04.M2", -- [18]
											"PA_Wood_Rail_Fence_Wrecked_01.M2", -- [19]
											"PA_Wood_Rail_Fence_Wrecked_02.M2", -- [20]
											"PA_Wood_Rail_Fence_Wrecked_03.M2", -- [21]
											"PA_Wood_Rail_Fence_Wrecked_04.M2", -- [22]
											"PA_Wood_Rail_Fence_Wrecked_05.M2", -- [23]
										},
										["N"] = "Wood_fence",
									}, -- [137]
									{
										["T"] = {
											"PA_Wood_Retaining_Posts.M2", -- [1]
											"PA_Wood_Retaining_Posts02.M2", -- [2]
											"PA_Wood_Retaining_Wall_01.M2", -- [3]
											"PA_Wood_Retaining_Walls.M2", -- [4]
										},
										["N"] = "Wood_retaining_posts",
									}, -- [138]
									{
										["T"] = {
											"PA_WoodCarving_01.M2", -- [1]
											"PA_WoodCarving_02.M2", -- [2]
										},
										["N"] = "Woodcarving",
									}, -- [139]
									{
										["T"] = {
											"PA_WoodPlank_01.M2", -- [1]
											"PA_WoodPlank_02.M2", -- [2]
										},
										["N"] = "Woodplank",
									}, -- [140]
									"BAKED_Misc_2H_Shovel_A_01.M2", -- [141]
									"Baked_Gorehowl.M2", -- [142]
									"Blowing_Smoke_Generic_01.M2", -- [143]
									"Brawlgar_Tablechairs.M2", -- [144]
									"Brawlgar_bar.M2", -- [145]
									"GSE_DynamiteConsole.M2", -- [146]
									"Great_PandarianBanquet_Generic.M2", -- [147]
									"Great_PandarianBanquet_Grill.M2", -- [148]
									"Great_PandarianBanquet_Oven.M2", -- [149]
									"Great_PandarianBanquet_Pot.M2", -- [150]
									"Great_PandarianBanquet_Steamer.M2", -- [151]
									"Great_PandarianBanquet_Still.M2", -- [152]
									"Great_PandarianBanquet_Wok.M2", -- [153]
									"ND_AllianceGunship_Doodad.M2", -- [154]
									"ND_HordeGunship_Doodad.M2", -- [155]
									"PA_CelestialMallet_Head.M2", -- [156]
									"PA_CelestialMallet_Shaft.M2", -- [157]
									"PA_CinematicHammer.M2", -- [158]
									"PA_CinematicHammer_broken.M2", -- [159]
									"PA_Dias.M2", -- [160]
									"PA_DragonNest_01.M2", -- [161]
									"PA_Fence_Rope_01.M2", -- [162]
									"PA_Food_BakedFish_01.M2", -- [163]
									"PA_Food_BakedWildfowl_01.M2", -- [164]
									"PA_Food_Brew_01.M2", -- [165]
									"PA_Food_Dumplings_01.M2", -- [166]
									"PA_Food_Dumplings_02.M2", -- [167]
									"PA_Food_FriedRice_01.M2", -- [168]
									"PA_Food_FriedRice_02.M2", -- [169]
									"PA_Food_FriedRice_03.M2", -- [170]
									"PA_Food_GrilledFish_01.M2", -- [171]
									"PA_Food_Melon_01.M2", -- [172]
									"PA_Food_Ribs_01.M2", -- [173]
									"PA_Food_Soup_01.M2", -- [174]
									"PA_Food_Soup_02.M2", -- [175]
									"PA_Food_Soup_03.M2", -- [176]
									"PA_Food_Springrolls_01.M2", -- [177]
									"PA_Food_Steak_01.M2", -- [178]
									"PA_Food_SteamedCrab_01.M2", -- [179]
									"PA_Food_SteamedCrab_02.M2", -- [180]
									"PA_Food_SteamedSalmon_01.M2", -- [181]
									"PA_Food_SteamedSalmon_02.M2", -- [182]
									"PA_Food_Tea_01.M2", -- [183]
									"PA_GuildVault.M2", -- [184]
									"PA_HeartofYsaarj2.M2", -- [185]
									"PA_HeartofYsaarj2_Container.M2", -- [186]
									"PA_HeartofYsaarj2_Hanging.M2", -- [187]
									"PA_HeartofYsaarj2_Hanging_husk.M2", -- [188]
									"PA_HeartofYsaarj_Container.M2", -- [189]
									"PA_Pillar_01.M2", -- [190]
									"PA_Pillar_01_Broken.M2", -- [191]
									"PA_Pillar_02.M2", -- [192]
									"PA_Raft_1.M2", -- [193]
									"PA_Smoky_Ash.M2", -- [194]
									"PA_WalkingRope_01.M2", -- [195]
									"PA_YakWash_Brushes.M2", -- [196]
									"PA_hopSack.M2", -- [197]
									"PandarianBanquet_Generic.M2", -- [198]
									"PandarianBanquet_Grill.M2", -- [199]
									"PandarianBanquet_Oven.M2", -- [200]
									"PandarianBanquet_Pot.M2", -- [201]
									"PandarianBanquet_Steamer.M2", -- [202]
									"PandarianBanquet_Still.M2", -- [203]
									"PandarianBanquet_Wok.M2", -- [204]
									"Staff_PandaRaid_Doodad.M2", -- [205]
									"pa_abstract_painting.M2", -- [206]
									"pa_anduin_painting.M2", -- [207]
									"pa_claycask.M2", -- [208]
									"pa_claycask_small.M2", -- [209]
									"pa_crude_painting.M2", -- [210]
									"pa_heroic_painting.M2", -- [211]
								},
								["N"] = "Pandaren",
							}, -- [17]
							{
								["T"] = {
									"ragefire_gate.M2", -- [1]
									"ragefire_gate_destroy.M2", -- [2]
								},
								["N"] = "Ragefire",
							}, -- [18]
							{
								["T"] = {
									"Saurok_Altar_01.M2", -- [1]
									"Saurok_Banner_01.M2", -- [2]
									"Saurok_Banner_02.M2", -- [3]
									"Saurok_Banner_03.M2", -- [4]
									"Saurok_Bones_01.M2", -- [5]
									"Saurok_Bones_02.M2", -- [6]
									"Saurok_Bones_03.M2", -- [7]
									"Saurok_Bones_04.M2", -- [8]
									"Saurok_Bones_05.M2", -- [9]
									"Saurok_Bones_06.M2", -- [10]
									"Saurok_Bones_07.M2", -- [11]
									"Saurok_Bones_08.M2", -- [12]
									"Saurok_Bones_09.M2", -- [13]
									"Saurok_Bones_10.M2", -- [14]
									"Saurok_Bones_11.M2", -- [15]
									"Saurok_Campfire_01.M2", -- [16]
									"Saurok_DragonTurtleShell_01.M2", -- [17]
									"Saurok_Forge_01.M2", -- [18]
									"Saurok_HangingBanner_01.M2", -- [19]
									"Saurok_HangingTrophy_Long_01.M2", -- [20]
									"Saurok_HangingTrophy_Long_02.M2", -- [21]
									"Saurok_HangingTrophy_Short_01.M2", -- [22]
									"Saurok_HangingTrophy_Short_02.M2", -- [23]
									"Saurok_Tent_01.M2", -- [24]
									"Saurok_Torch_01.M2", -- [25]
									"Saurok_Weapon_01.M2", -- [26]
									"Saurok_Weapon_02.M2", -- [27]
									"saurok_large_stone_table.M2", -- [28]
									"saurok_trapdoor_iris.M2", -- [29]
								},
								["N"] = "Saurok",
							}, -- [19]
							{
								["T"] = {
									{
										["T"] = {
											"Sherpa_Tent_01.M2", -- [1]
											"Sherpa_Tent_01wrecked.M2", -- [2]
											"Sherpa_Tent_01wreckedlid.M2", -- [3]
										},
										["N"] = "Tent",
									}, -- [1]
									"Sherpa_bedroll_01.M2", -- [2]
									"Sherpa_bedroll_02.M2", -- [3]
									"Sherpa_flag_01.M2", -- [4]
								},
								["N"] = "Sherpa",
							}, -- [20]
							{
								["T"] = {
									{
										["T"] = {
											"ITK_AccentBush01.M2", -- [1]
											"ITK_AccentBush02.M2", -- [2]
											"ITK_AccentBush03.M2", -- [3]
											"ITK_Bush01_A.M2", -- [4]
											"ITK_Bush01_B.M2", -- [5]
											"ITK_Bush01_C.M2", -- [6]
											"ITK_Bush02_A.M2", -- [7]
											"ITK_Bush02_B.M2", -- [8]
											"ITK_Bush02_C.M2", -- [9]
											"ITK_CypressKnee01.M2", -- [10]
											"ITK_CypressKnee02.M2", -- [11]
											"ITK_CypressKnee03.M2", -- [12]
											"ITK_CypressKnee04.M2", -- [13]
											"ITK_DarkForestTree04.M2", -- [14]
											"ITK_DarkForestTree06.M2", -- [15]
											"ITK_DarkForest_Root01.M2", -- [16]
											"ITK_DarkForest_Root02.M2", -- [17]
											"ITK_DarkForest_Root03.M2", -- [18]
											"ITK_DarkForest_Root04.M2", -- [19]
											"ITK_DarkForest_Root05.M2", -- [20]
											"ITK_DarkForest_Root06.M2", -- [21]
											"ITK_DarkForest_Root07.M2", -- [22]
											"ITK_FlatRock01.M2", -- [23]
											"ITK_FlatRock02.M2", -- [24]
											"ITK_FlatRock03.M2", -- [25]
											"ITK_Fog_01.M2", -- [26]
											"ITK_Fog_02.M2", -- [27]
											"ITK_Fog_03.M2", -- [28]
											"ITK_Forge_FX_Wrap.M2", -- [29]
											"ITK_Fungus01.M2", -- [30]
											"ITK_Fungus02.M2", -- [31]
											"ITK_HangingMoss01.M2", -- [32]
											"ITK_HangingMoss02.M2", -- [33]
											"ITK_HangingMoss03.M2", -- [34]
											"ITK_KirinTor_Banner_01.M2", -- [35]
											"ITK_KirinTor_Banner_01_NoCol.M2", -- [36]
											"ITK_LargeTree01.M2", -- [37]
											"ITK_LargeTree01_nomoss.M2", -- [38]
											"ITK_LeafDebris01.M2", -- [39]
											"ITK_LeafDebris02.M2", -- [40]
											"ITK_LeafDebris03.M2", -- [41]
											"ITK_LeiShenEncounter_FX_Wrap.M2", -- [42]
											"ITK_LeiShenEncounter_FX_Wrap_flipped.M2", -- [43]
											"ITK_Lichen01.M2", -- [44]
											"ITK_Lichen02.M2", -- [45]
											"ITK_Lichen03.M2", -- [46]
											"ITK_Lichen04.M2", -- [47]
											"ITK_Lightning_Bug_01.M2", -- [48]
											"ITK_Lightning_Exterior_A.M2", -- [49]
											"ITK_Lightning_Exterior_B.M2", -- [50]
											"ITK_MarshMushroom01.M2", -- [51]
											"ITK_MarshMushroom02.M2", -- [52]
											"ITK_MarshMushroom03.M2", -- [53]
											"ITK_MarshPlant01.M2", -- [54]
											"ITK_MarshPlant03.M2", -- [55]
											"ITK_MoguGraveyard_FX_Wrap.M2", -- [56]
											"ITK_MossWeb01.M2", -- [57]
											"ITK_MossWeb02.M2", -- [58]
											"ITK_Ocean_Wave_02.M2", -- [59]
											"ITK_PVPTower_FX_Wrap.M2", -- [60]
											"ITK_Rock01.M2", -- [61]
											"ITK_Rock01_mossy.M2", -- [62]
											"ITK_Rock02.M2", -- [63]
											"ITK_Rock02_mossy.M2", -- [64]
											"ITK_Rock03.M2", -- [65]
											"ITK_Rock03_mossy.M2", -- [66]
											"ITK_Rock04.M2", -- [67]
											"ITK_Rock04_mossy.M2", -- [68]
											"ITK_Rock05.M2", -- [69]
											"ITK_Rock05_mossy.M2", -- [70]
											"ITK_Rock06.M2", -- [71]
											"ITK_Rock06_mossy.M2", -- [72]
											"ITK_Shrub01.M2", -- [73]
											"ITK_Shrub02.M2", -- [74]
											"ITK_SmallBush01.M2", -- [75]
											"ITK_SmallBush02.M2", -- [76]
											"ITK_SmallMushroom01.M2", -- [77]
											"ITK_SmallMushroom02.M2", -- [78]
											"ITK_SmallMushroom03.M2", -- [79]
											"ITK_Sunreaver_Banner_01.M2", -- [80]
											"ITK_Sunreaver_Banner_01_NoCol.M2", -- [81]
											"ITK_ThornyBush01.M2", -- [82]
											"ITK_ThornyBush02.M2", -- [83]
											"ITK_TreeCustom01.M2", -- [84]
											"ITK_TreeCustom02.M2", -- [85]
											"ITK_WaterDrips_01.M2", -- [86]
											"ITK_WaterDrips_02.M2", -- [87]
											"ITK_WaterFall_Cave_01.M2", -- [88]
											"ITK_WaterFall_Cave_02.M2", -- [89]
											"ITK_WaterFall_Raid_01.M2", -- [90]
											"ITK_WaterFall_Raid_02.M2", -- [91]
											"ITK_WaterFall_Raid_03.M2", -- [92]
											"ITK_WaterFall_Raid_04.M2", -- [93]
											"ITK_WaterFall_Raid_05.M2", -- [94]
											"ITK_WaterFall_Raid_06.M2", -- [95]
											"ITK_WaterFall_Raid_07.M2", -- [96]
											"ITK_WaterFall_Raid_08.M2", -- [97]
											"ITK_WaterFall_Raid_Cave_01.M2", -- [98]
											"ITK_WaterFall_Raid_Sewer_01.M2", -- [99]
											"ITK_WaterFall_Raid_Sewer_02.M2", -- [100]
											"ITK_WaterFall_Raid_Sewer_03.M2", -- [101]
											"ITK_WaterFall_Raid_Sewer_04.M2", -- [102]
											"ITK_WaterFall_Raid_Sewer_05.M2", -- [103]
											"ITK_WaterFall_Raid_Sewer_05a.M2", -- [104]
											"ITK_WaterFall_Raid_Sewer_06.M2", -- [105]
											"ITK_WaterFall_Raid_Sewer_06a.M2", -- [106]
											"ITK_WaterFall_Raid_Sewer_07.M2", -- [107]
											"ITK_WaterFall_Raid_Sewer_07a.M2", -- [108]
											"ITK_WaterFall_Small07.M2", -- [109]
											"ITK_WaterFall_Small_01.M2", -- [110]
											"ITK_WaterFall_Small_02.M2", -- [111]
											"ITK_WaterFall_Small_03.M2", -- [112]
											"ITK_WaterFall_Small_04.M2", -- [113]
											"ITK_WaterFall_Small_05.M2", -- [114]
											"ITK_WaterFall_Small_06.M2", -- [115]
											"ITK_WaterRipple_01.M2", -- [116]
											"ITK_WaterSprigs01.M2", -- [117]
											"ITK_WaterSprigs02.M2", -- [118]
											"ITK_Waterfall_Raid_Sewer_Steam.M2", -- [119]
											"ITK_WhiteFungus01.M2", -- [120]
											"ITK_WhiteFungus02.M2", -- [121]
											"ITK_algae01.M2", -- [122]
											"ITK_algae02.M2", -- [123]
											"ITK_algae03.M2", -- [124]
											"ITK_bramble01.M2", -- [125]
											"ITK_bramble02.M2", -- [126]
											"ITK_cattails01.M2", -- [127]
											"ITK_cattails02.M2", -- [128]
											"ITK_cattails03.M2", -- [129]
											"ITK_cattails04.M2", -- [130]
											"ITK_cypresstree01.M2", -- [131]
											"ITK_cypresstree02.M2", -- [132]
											"ITK_cypresstree03.M2", -- [133]
											"ITK_cypresstree_burnt01.M2", -- [134]
											"ITK_cypresstree_burnt02.M2", -- [135]
											"ITK_cypresstree_burnt03.M2", -- [136]
											"ITK_cypresstree_sapling01.M2", -- [137]
											"ITK_cypresstree_sapling02.M2", -- [138]
											"ITK_eyeball01.M2", -- [139]
											"ITK_fence01.M2", -- [140]
											"ITK_fence02.M2", -- [141]
											"ITK_fence03.M2", -- [142]
											"ITK_fence04.M2", -- [143]
											"ITK_fencepost01.M2", -- [144]
											"ITK_fishbones01.M2", -- [145]
											"ITK_graveyardLeaves01.M2", -- [146]
											"ITK_graveyardLeaves02.M2", -- [147]
											"ITK_graveyardstump.M2", -- [148]
											"ITK_meatjunk01.M2", -- [149]
											"ITK_meatjunk02.M2", -- [150]
											"ITK_meatjunk03.M2", -- [151]
											"ITK_organ01.M2", -- [152]
											"ITK_organ02.M2", -- [153]
											"ITK_organ03.M2", -- [154]
											"ITK_pondscum01.M2", -- [155]
											"ITK_pondscum01_FullAlpha.M2", -- [156]
											"ITK_pondscum02.M2", -- [157]
											"ITK_pondscum02_FullAlpha.M2", -- [158]
											"ITK_pondscum03.M2", -- [159]
											"ITK_pondscum03_FullAlpha.M2", -- [160]
											"ITK_rubble01.M2", -- [161]
											"ITK_rubble02.M2", -- [162]
											"ITK_rubble03.M2", -- [163]
											"ITK_rubble04.M2", -- [164]
											"ITK_swampStump.M2", -- [165]
											"ITK_swamplog.M2", -- [166]
											"ITK_tallgrass01.M2", -- [167]
											"ITK_tallgrass02.M2", -- [168]
											"ITK_talltree01.M2", -- [169]
											"ITK_talltree02.M2", -- [170]
											"ITK_talltree03.M2", -- [171]
											"ITK_thornyroot01.M2", -- [172]
											"ITK_thornyroot02.M2", -- [173]
											"ITK_thornyroot03.M2", -- [174]
											"ITK_thornyroot04.M2", -- [175]
											"ITK_thornyvine01.M2", -- [176]
											"ITK_thornyvine02.M2", -- [177]
											"ITK_thornyvine03.M2", -- [178]
											"ITK_thornyvine04.M2", -- [179]
											"ITK_tree03_LightningStrike.M2", -- [180]
											"ITK_treeRoot01.M2", -- [181]
											"ITK_treeRoot02.M2", -- [182]
											"ITK_treeRoot03.M2", -- [183]
											"ITK_treeRoot04.M2", -- [184]
											"ITK_treeRoot05.M2", -- [185]
											"ITK_treeRoot06.M2", -- [186]
											"ITK_treeRoot07.M2", -- [187]
											"ITK_witheringbush01.M2", -- [188]
											"ITK_witheringbush02.M2", -- [189]
											"itk_stalactite01.M2", -- [190]
										},
										["N"] = "Doodads",
									}, -- [1]
									{
										["T"] = {
											"ITK_tile01_broken01.M2", -- [1]
											"ITK_tile01_broken01_mossy.M2", -- [2]
											"ITK_tile01_broken02_mossy.M2", -- [3]
											"ITK_tile01_fragment01_mossy.M2", -- [4]
											"ITK_tile01_fragment02_mossy.M2", -- [5]
											"ITK_tile01_fragment03_mossy.M2", -- [6]
											"ITK_tile01_fragment04_mossy.M2", -- [7]
											"ITK_tile01_fragment05_mossy.M2", -- [8]
											"ITK_tile01_fragment06_mossy.M2", -- [9]
											"ITK_tile01_mossy01.M2", -- [10]
											"ITK_tile01_whole01_mossy.M2", -- [11]
											"ITK_tile01_whole02_mossy.M2", -- [12]
											"ITK_tile01_whole03_mossy.M2", -- [13]
											"ITK_tile01_whole04_mossy.M2", -- [14]
											"ITK_tile02_broken01.M2", -- [15]
											"ITK_tile02_broken01_mossy.M2", -- [16]
											"ITK_tile02_broken02.M2", -- [17]
											"ITK_tile02_broken02_mossy.M2", -- [18]
											"ITK_tile02_broken03.M2", -- [19]
											"ITK_tile02_broken03_mossy.M2", -- [20]
											"ITK_tile02_fragment01.M2", -- [21]
											"ITK_tile02_fragment01_mossy.M2", -- [22]
											"ITK_tile02_fragment02.M2", -- [23]
											"ITK_tile02_fragment02_mossy.M2", -- [24]
											"ITK_tile02_fragment03.M2", -- [25]
											"ITK_tile02_fragment03_mossy.M2", -- [26]
											"ITK_tile02_fragment04.M2", -- [27]
											"ITK_tile02_fragment04_mossy.M2", -- [28]
											"ITK_tile02_fragment05.M2", -- [29]
											"ITK_tile02_fragment05_mossy.M2", -- [30]
											"ITK_tile02_fragment06.M2", -- [31]
											"ITK_tile02_fragment06_mossy.M2", -- [32]
											"ITK_tile02_whole01.M2", -- [33]
											"ITK_tile02_whole01_mossy.M2", -- [34]
											"ITK_tile02_whole02.M2", -- [35]
											"ITK_tile02_whole02_mossy.M2", -- [36]
											"ITK_tile02_whole03.M2", -- [37]
											"ITK_tile02_whole03_mossy.M2", -- [38]
											"ITK_tile02_whole04.M2", -- [39]
											"ITK_tile02_whole04_mossy.M2", -- [40]
											"ITK_tile02_whole05.M2", -- [41]
											"ITK_tile02_whole05_mossy.M2", -- [42]
											"ITK_tile02_whole06.M2", -- [43]
											"ITK_tile02_whole06_mossy.M2", -- [44]
											"ITK_tile02_whole07.M2", -- [45]
											"ITK_tile02_whole07_mossy.M2", -- [46]
											"itk_tile01_broken02.M2", -- [47]
											"itk_tile01_fragment02.M2", -- [48]
											"itk_tile01_fragment03.M2", -- [49]
											"itk_tile01_fragment04.M2", -- [50]
											"itk_tile01_fragment05.M2", -- [51]
											"itk_tile01_fragment06.M2", -- [52]
											"itk_tile01_whole01.M2", -- [53]
											"itk_tile01_whole02.M2", -- [54]
											"itk_tile01_whole03.M2", -- [55]
											"itk_tile01_whole04.M2", -- [56]
										},
										["N"] = "Tiles",
									}, -- [2]
									{
										["T"] = {
											"ITK_graveyardTree01.M2", -- [1]
											"ITK_graveyardTree02.M2", -- [2]
											"ITK_graveyardTree03.M2", -- [3]
											"ITK_skinnytree01.M2", -- [4]
											"ITK_skinnytree02.M2", -- [5]
											"ITK_skinnytree03.M2", -- [6]
											"ITK_skinnytree_sapling01.M2", -- [7]
											"ITK_skinnytree_sapling02.M2", -- [8]
											"ITK_tree01.M2", -- [9]
											"ITK_tree01_nomoss.M2", -- [10]
											"ITK_tree01_roots.M2", -- [11]
											"ITK_tree02.M2", -- [12]
											"ITK_tree02_nomoss.M2", -- [13]
											"ITK_tree02_roots.M2", -- [14]
											"ITK_tree03.M2", -- [15]
											"ITK_tree03_nomoss.M2", -- [16]
										},
										["N"] = "Trees",
									}, -- [3]
									"ThunderIsle_Dalaran_Tower_Base.M2", -- [4]
									"ThunderIsle_Dalaran_Tower_Floating_Crystals01.M2", -- [5]
									"ThunderIsle_Dalaran_Tower_Top.M2", -- [6]
									"ThunderIsle_SmallPhoenixNest.M2", -- [7]
									"ThunderIsle_SmallPhoenixNest_Branch.M2", -- [8]
									"ThunderIsle_SmallPhoenixNest_Branches.M2", -- [9]
									"thunderisle_kirintor_tent.M2", -- [10]
								},
								["N"] = "Thunderisle",
							}, -- [21]
							{
								["T"] = {
									{
										["T"] = {
											"PA_Western_Ox_Temple_Coin.M2", -- [1]
											"PA_Western_Ox_Temple_Rope1.M2", -- [2]
											"PA_Western_Ox_Temple_RopeRing.M2", -- [3]
											"PA_Western_Ox_Temple_Tassle.M2", -- [4]
										},
										["N"] = "Bridge",
									}, -- [1]
									{
										["T"] = {
											"MZ_GiantTree01.M2", -- [1]
											"MZ_GiantTree02.M2", -- [2]
											"MZ_GiantTree02_sha_doodad_01.M2", -- [3]
											"MZ_GiantTree02_sha_doodad_02.M2", -- [4]
											"MZ_GiantTree02_sha_doodad_03.M2", -- [5]
											"MZ_GiantTree02_sha_doodad_04.M2", -- [6]
											"MZ_GiantTree02_sha_doodad_05.M2", -- [7]
											"MZ_GiantTree02_sha_doodad_06.M2", -- [8]
											"MZ_GiantTreeRoots01.M2", -- [9]
											"MZ_GiantTreeRoots02.M2", -- [10]
											"MZ_GiantTreeRoots03.M2", -- [11]
											"MZ_GiantTreeRoots04.M2", -- [12]
											"MZ_GiantTreeRoots05.M2", -- [13]
											"MZ_GiantTreeRoots06.M2", -- [14]
											"MZ_GiantTreeRoots07.M2", -- [15]
											"MZ_GiantTreeRoots08.M2", -- [16]
											"MZ_GiantTreeRoots09.M2", -- [17]
											"MZ_GiantTreeRoots10.M2", -- [18]
											"MZ_GiantTreeRoots11.M2", -- [19]
											"MZ_GiantTree_BranchWisps.M2", -- [20]
											"MZ_GiantTree_BranchWisps02.M2", -- [21]
											"MZ_GiantTree_TarDripFX.M2", -- [22]
											"MZ_GiantTree_WrapFX.M2", -- [23]
											"MZ_Rock01.M2", -- [24]
											"MZ_Rock02.M2", -- [25]
											"MZ_Rock03.M2", -- [26]
											"MZ_Rock04.M2", -- [27]
											"MZ_Rock05.M2", -- [28]
											"MZ_Rock06.M2", -- [29]
											"MZ_Rock07.M2", -- [30]
											"MZ_Rock08.M2", -- [31]
											"MZ_Rock09.M2", -- [32]
											"MZ_Rock10.M2", -- [33]
											"MZ_Rock11.M2", -- [34]
											"MZ_Rock12.M2", -- [35]
											"MZ_Rock13.M2", -- [36]
											"MZ_Rock14.M2", -- [37]
											"MZ_Rock15.M2", -- [38]
											"MZ_Rock16.M2", -- [39]
											"MZ_Rock17.M2", -- [40]
											"MZ_RockPillar01.M2", -- [41]
											"MZ_RockPillar02.M2", -- [42]
											"MZ_RockPillar03.M2", -- [43]
											"MZ_RockPillar04.M2", -- [44]
											"MZ_RockPillar05.M2", -- [45]
											"MZ_RockPillar06.M2", -- [46]
											"MZ_RockPillar07.M2", -- [47]
											"MZ_Tree01.M2", -- [48]
											"MZ_Tree02.M2", -- [49]
										},
										["N"] = "Gianttree",
									}, -- [2]
									{
										["T"] = {
											"MZ_TreeBridge01.M2", -- [1]
										},
										["N"] = "Treebridge",
									}, -- [3]
									"MZ_Boulder01.M2", -- [4]
									"MZ_Boulder02.M2", -- [5]
									"MZ_Boulder03.M2", -- [6]
									"MZ_Boulder04.M2", -- [7]
									"MZ_Boulder05.M2", -- [8]
									"MZ_Boulder06.M2", -- [9]
									"MZ_Boulder07.M2", -- [10]
									"MZ_Bush01.M2", -- [11]
									"MZ_Bush01_B.M2", -- [12]
									"MZ_Bush02.M2", -- [13]
									"MZ_Bush02_B.M2", -- [14]
									"MZ_Bush03.M2", -- [15]
									"MZ_Bush03_B.M2", -- [16]
									"MZ_Bush04.M2", -- [17]
									"MZ_Bush04_B.M2", -- [18]
									"MZ_DragonNest_01.M2", -- [19]
									"MZ_FlatRocks_01_mossy.M2", -- [20]
									"MZ_FlatRocks_02_mossy.M2", -- [21]
									"MZ_FlatRocks_03_mossy.M2", -- [22]
									"MZ_GiantLeaves02.M2", -- [23]
									"MZ_Grass06.M2", -- [24]
									"MZ_GrassClump01.M2", -- [25]
									"MZ_HeartFlower01.M2", -- [26]
									"MZ_HeartFlower02.M2", -- [27]
									"MZ_HeartFlower03.M2", -- [28]
									"MZ_HeartFlower04.M2", -- [29]
									"MZ_Rock_Cavein.M2", -- [30]
									"MZ_ShaBush01.M2", -- [31]
									"MZ_ShaBush02.M2", -- [32]
									"MZ_ShaBush03.M2", -- [33]
									"MZ_ShaBush04.M2", -- [34]
									"MZ_ShaEffect01.M2", -- [35]
									"MZ_ShaEffect02.M2", -- [36]
									"MZ_ShaEffect03.M2", -- [37]
									"MZ_ShaEffect04.M2", -- [38]
									"MZ_Sh