--------------------------------------------------------------------------
-- GTFO_Spells_BFA.lua 
--------------------------------------------------------------------------
--[[
GTFO Spell List - Battle for Azeroth
]]--

if (not GTFO.ClassicMode) then

--- ******************************
--- * Battle for Azeroth (World) *
--- ******************************

GTFO.SpellID["206224"] = {
  --desc = "Burning Blaze";
  sound = 1;
};

GTFO.SpellID["254850"] = {
  --desc = "Lob Flames (Battle for Lordaeron)";
  sound = 1;
  test = true;
};

GTFO.SpellID["248958"] = {
  --desc = "Blight";
  sound = 1;
  damageMinimum = 1;
};

GTFO.SpellID["222345"] = {
  --desc = "Bladestorm (High Overlord Saurfang)";
  sound = 1;
};

GTFO.SpellID["268224"] = {
  --desc = "Shrapnel Blast (Cannon)";
  sound = 1;
};

GTFO.SpellID["271634"] = {
  --desc = "Blizzard (Mage Commander Lyra)";
  sound = 1;
  test = true; -- Didn't work in alpha, might be worth checking out
};

GTFO.SpellID["271703"] = {
  --desc = "Tar Fire";
  sound = 1;
};

GTFO.SpellID["266281"] = {
  --desc = "Burning Pitch";
  sound = 1;
};

GTFO.SpellID["258004"] = {
  --desc = "Sanguine Pool (Blood Witch Pakkala)";
  sound = 1;
};

GTFO.SpellID["255307"] = {
  --desc = "Whirling Spin (Akakakoo)";
  sound = 1;
};

GTFO.SpellID["270161"] = {
  --desc = "Soul Burst (Emily Mayville)";
  sound = 1;
};

GTFO.SpellID["271715"] = {
  --desc = "Volatile Expulsion (Unbound Azerite)";
  sound = 1;
};

GTFO.SpellID["261477"] = {
  --desc = "Dervish (Faithless Watcher)";
  sound = 1;
};

GTFO.SpellID["260378"] = {
  --desc = "Nullifying Singularity";
  sound = 1;
};

GTFO.SpellID["280446"] = {
  --desc = "Bane of the Drust King (Gorak Tul)";
  sound = 1;
};

GTFO.SpellID["277972"] = {
  --desc = "Firestorm (Adhara White)";
  sound = 1;
};

GTFO.SpellID["257065"] = {
  --desc = "Decaying Ground (Matron Morana)";
  sound = 1;
};

GTFO.SpellID["277579"] = {
  --desc = "Murderous Volley (Man-Hunter Rog)";
  sound = 1;
};

GTFO.SpellID["273665"] = {
  --desc = "Seismic Disturbance";
  sound = 1;
};

GTFO.SpellID["273495"] = {
  --desc = "Fire Bomb";
  sound = 1;
};

GTFO.SpellID["261474"] = {
  --desc = "Windwall (Emperor Korthek)";
  sound = 1;
  tankSound = 2;
};

GTFO.SpellID["281034"] = {
  --desc = "Noxious Swamp Gas";
  sound = 2;
};

GTFO.SpellID["286732"] = {
  --desc = "Blight Barrel (Blightguard Captain Thedric)";
  sound = 1;
};

GTFO.SpellID["286805"] = {
  --desc = "Blighted Edge (Blightguard Captain Thedric)";
  sound = 1;
};

GTFO.SpellID["283869"] = {
  --desc = "Shrapnel Blasta (Base Cap'n Crankshot)";
  sound = 1;
  tankSound = 2;
};

GTFO.SpellID["284102"] = {
  --desc = "AzerMEK Lazer Area (AzerMEK Beam Target)";
  sound = 1;
};

GTFO.SpellID["282755"] = {
  --desc = "Defense Barrage (Warfronts)";
  sound = 1;
};

GTFO.SpellID["282414"] = {
  --desc = "Frost Patch (Ivus the Forest Lord)";
  sound = 1;
};

GTFO.SpellID["282487"] = {
  --desc = "Lunar Strike (Ivus the Forest Lord)";
  sound = 1;
};

GTFO.SpellID["282404"] = {
  --desc = "Frost Breath (Ivus the Forest Lord)";
  sound = 1;
  tankSound = 0;
};

GTFO.SpellID["287537"] = {
  --desc = "Plague Breath (Ivus the Decayed)";
  sound = 1;
};

GTFO.SpellID["287543"] = {
  --desc = "Fungal Bloom (Ivus the Decayed)";
  sound = 1;
};

GTFO.SpellID["287538"] = {
  --desc = "Plagued Bog (Ivus the Decayed)";
  sound = 1;
};

GTFO.SpellID["288924"] = {
  --desc = "Smoldering Flames (Aman)";
  sound = 1;
};

GTFO.SpellID["288897"] = {
  --desc = "Shadow Crash (Soggoth the Slitherer)";
  sound = 1;
};

GTFO.SpellID["291166"] = {
  --desc = "Flame Jet";
  sound = 1;
};

GTFO.SpellID["286466"] = {
  --desc = "Purifying Flame";
  sound = 1;
};

GTFO.SpellID["297252"] = {
  --desc = "Residual Gas";
  sound = 1;
};

GTFO.SpellID["288700"] = {
  --desc = "Windwall (Cyclarus)";
  sound = 1;
};

GTFO.SpellID["303132"] = {
  --desc = "Unstable Orb (Shirakess Starseeker)";
  sound = 1;
};

GTFO.SpellID["303716"] = {
  --desc = "Geyser (Deepwater Maw)";
  sound = 1;
};

GTFO.SpellID["297537"] = {
  --desc = "Intense Flames";
  sound = 1;
};

GTFO.SpellID["304335"] = {
  --desc = "Flamestrike (Magister Hathorel)";
  sound = 1;
};

GTFO.SpellID["303436"] = {
  --desc = "EM Field (Mr. Fixthis)";
  sound = 1;
};

GTFO.SpellID["304360"] = {
  --desc = "Caustic Fumes (Deepglider)";
  sound = 1;
  damageMinimum = 1;
};

GTFO.SpellID["299401"] = {
  --desc = "Fragment of the Void (Infestation of Madness)";
  sound = 1;
};

GTFO.SpellID["301839"] = {
  --desc = "Void Dance (Ulmath)";
  sound = 1;
};

GTFO.SpellID["278069"] = {
  --desc = "Rocket Boots (Pest Remover Mk. II)";
  sound = 1;
};

GTFO.SpellID["273178"] = {
  --desc = "Blessed Consecration (Lady Liadrin)";
  sound = 1;
};

GTFO.SpellID["302524"] = {
  --desc = "Dark Orb (Grip of Horror)";
  sound = 1;
};

GTFO.SpellID["302521"] = {
  --desc = "Dark Orb (Grip of Horror)";
  sound = 1;
};

GTFO.SpellID["318391"] = {
  --desc = "Great Worm's Foul Stench (Great Worm From Beyond)";
  applicationOnly = true;
  sound = 2;
};

GTFO.SpellID["315161"] = {
  --desc = "Eye of Corruption";
  sound = 2;
  category = "EyeOfCorruption2";
};

GTFO.SpellID["315197"] = {
  --desc = "Grand Delusions (Thing From Beyond)";
  sound = 3;
};

GTFO.SpellID["314579"] = {
  --desc = "Shadow Wreath (Shadowy Nexus)";
  sound = 1;
};

GTFO.SpellID["312687"] = {
  --desc = "Shadow Crash (Black Warden Rhothkozz)";
  sound = 1;
};

GTFO.SpellID["314956"] = {
  --desc = "Fragmented Halo (Black Warden Rhothkozz)";
  sound = 1;
};

GTFO.SpellID["302390"] = {
  --desc = "Twilight Flames (Vexiona)";
  sound = 1;
};

GTFO.SpellID["313017"] = {
  --desc = "Solar Orb";
  sound = 1;
};

GTFO.SpellID["314718"] = {
  --desc = "Concentrated Sunlight (Watcher Rehu)";
  sound = 1;
};

GTFO.SpellID["313190"] = {
  --desc = "Deep Water (Depths Monstrosity)";
  sound = 1;
};

GTFO.SpellID["313281"] = {
  --desc = "Hurled Void (Squidtail Screamer)";
  sound = 1;
};

GTFO.SpellID["303864"] = {
  --desc = "Electrified";
  sound = 1;
};

GTFO.SpellID["303867"] = {
  --desc = "Burning";
  applicationOnly = true;
  sound = 1;
};

GTFO.SpellID["310832"] = {
  --desc = "Void Tear";
  sound = 1;
  alwaysAlert = true;
};

GTFO.SpellID["296733"] = {
  --desc = "Dark Smash (Faceless Destroyer)";
  sound = 1;
};

GTFO.SpellID["301516"] = {
  --desc = "Unsettling Mist";
  sound = 1;
  alwaysAlert = true;
};

GTFO.SpellID["312682"] = {
  --desc = "Shadow Crash (Faceless Ruiner)";
  sound = 1;
};

GTFO.SpellID["316258"] = {
  --desc = "Bile (Aqir Goliath)";
  sound = 1;
};

GTFO.SpellID["314565"] = {
  --desc = "Defiled Ground (Blood of the Corruptor)";
  sound = 1;
};

GTFO.SpellID["308807"] = {
  --desc = "Rain of Fire (Zardeth of the Black Claw)";
  sound = 1;
};

GTFO.SpellID["309665"] = {
  --desc = "Empowered Forge Breath (Therum Deepforge)";
  sound = 1;
};

GTFO.SpellID["312121"] = {
  --desc = "Explosive Ordnance (Therum Deepforge)";
  sound = 1;
};

GTFO.SpellID["311400"] = {
  --desc = "Blade Flourish (Armsmaster Terenson)";
  sound = 1;
};

GTFO.SpellID["314432"] = {
  --desc = "Force and Verve (Grand Empress Shek'zara)";
  negatingDebuffSpellID = 314332;  -- Sound Barrier
  sound = 1;
};

-- ***********************
-- * Shrine of the Storm *
-- ***********************

GTFO.SpellID["276286"] = {
  --desc = "Slicing Hurricane";
  sound = 1;
};

GTFO.SpellID["274438"] = {
  --desc = "Tempest (Windspeaker Heldis)";
  sound = 1;
};

GTFO.SpellID["274714"] = {
  --desc = "Twisting Void";
  sound = 1;
};

GTFO.SpellID["269419"] = {
  --desc = "Yawning Gate (Vol'zith the Whisperer)";
  sound = 1;
};

GTFO.SpellID["279249"] = {
  --desc = "Tiki Blaze";
  sound = 1;
};

-- ******************
-- * Waycrest Manor *
-- ******************

GTFO.SpellID["264712"] = {
  --desc = "Rotten Expulsion";
  applicationOnly = true;
  sound = 1;
};

GTFO.SpellID["264698"] = {
  --desc = "Rotten Expulsion (Raal the Gluttonous)";
  sound = 1;
};

GTFO.SpellID["260569"] = {
  --desc = "Wildfire";
  sound = 1;
};

GTFO.SpellID["264040"] = {
  --desc = "Uprooted Thorns";
  sound = 1;
};

GTFO.SpellID["268308"] = {
  --desc = "Discordant Cadenza (Lady Waycrest)";
  sound = 1;
};

GTFO.SpellID["268086"] = {
  --desc = "Aura of Dread (Sisters)";
  applicationOnly = true;
  sound = 1;
  minimumStacks = 3;
};

-- ************
-- * Freehold *
-- ************

GTFO.SpellID["257274"] = {
  --desc = "Vile Coating";
  sound = 1;
};

GTFO.SpellID["256016"] = {
  --desc = "Vile Coating (Skycap'n Kragg)";
  sound = 1;
  test = true;
};

GTFO.SpellID["256552"] = {
  --desc = "Flailing Shark (Sawtooth Shark)";
  sound = 1;
};

GTFO.SpellID["256546"] = {
  --desc = "Shark Tornado (Trothak)";
  sound = 1;
};

GTFO.SpellID["257737"] = {
  --desc = "Thundering Squall (Irontide Stormcaller)";
  sound = 1;
};

GTFO.SpellID["257871"] = {
  --desc = "Blade Barrage (Irontide Buccaneer)";
  sound = 1;
  tankSound = 0;
};

GTFO.SpellID["257460"] = {
  --desc = "Flaming Shrapnel (Harlan Sweete)";
  sound = 1;
};

GTFO.SpellID["268287"] = {
  --desc = "Rotten Food (Booty Fanatic)";
  sound = 1;
};

GTFO.SpellID["268283"] = {
  --desc = "Obscured Vision (Booty Fanatic)";
  applicationOnly = true;
  sound = 1;
};

-- *************
-- * Tol Dagor *
-- *************

-- TBA...

-- ****************
-- * The Underrot *
-- ****************

GTFO.SpellID["265542"] = {
  --desc = "Rotten Bile (Fetid Maggot)";
  sound = 1;
};

GTFO.SpellID["265540"] = {
  --desc = "Rotten Bile (Fetid Maggot)";
  sound = 1;
};

GTFO.SpellID["261498"] = {
  --desc = "Creeping Rot (Elder Leaxa)";
  applicationOnly = true;
  sound = 1;
  test = true;
};

GTFO.SpellID["265687"] = {
  --desc = "Noxious Poison (Venomous Lasher)";
  sound = 1;
  test = true;
};

GTFO.SpellID["269838"] = {
  --desc = "Vile Expulsion (Unbound Abomination)";
  sound = 1;
};

GTFO.SpellID["278789"] = {
  --desc = "Wave of Decay";
  sound = 1;
};

-- ************************
-- * Temple of Sethraliss *
-- ************************

GTFO.SpellID["272696"] = {
  --desc = "Oil of Immolation (Crazed Incubator)";
  sound = 1;
};

GTFO.SpellID["263927"] = {
  --desc = "Toxic Pool (Merektha)";
  sound = 1;
};

-- ********************
-- * The MOTHERLODE!! *
-- ********************

GTFO.SpellID["258628"] = {
  --desc = "Resonant Quake (Azerokk)";
  sound = 1;
};

GTFO.SpellID["263105"] = {
  --desc = "Blowtorch (Feckless Assistant)";
  sound = 1;
  tankSound = 0;
};

GTFO.SpellID["269831"] = {
  --desc = "Azerite Toxicity";
  sound = 1;
};

GTFO.SpellID["260103"] = {
  --desc = "Propellant Blast (Rixxa Fluxflame)";
  sound = 1;
};

GTFO.SpellID["259533"] = {
  --desc = "Agent Azerite (Rixxa Fluxflame)";
  sound = 1;
};

GTFO.SpellID["260279"] = {
  --desc = "Gatling Gun (Mogul Razdunk)";
  sound = 1;
};

-- **************
-- * Atal'Dazar *
-- **************

GTFO.SpellID["255842"] = {
  --desc = "Blood-Tainted Cauldron of Gold";
  sound = 1;
};

GTFO.SpellID["257692"] = {
  --desc = "Tiki Blaze";
  applicationOnly = true;
  sound = 1;
};

GTFO.SpellID["250585"] = {
  --desc = "Toxic Pool (Vol'kaal)";
  sound = 1;
};

GTFO.SpellID["250036"] = {
  --desc = "Shadowy Remains";
  sound = 1;
};

GTFO.SpellID["265625"] = {
  --desc = "Dark Omen (Befouled Spirit)";
  sound = 4;
  negatingDebuffSpellID = 265568;  -- Befouled Spirit
  negatingIgnoreTime = 1;
  test = true;
};

GTFO.SpellID["258723"] = {
  --desc = "Grotesque Pool";
  sound = 1;
};

GTFO.SpellID["253666"] = {
  --desc = "Fiery Bolt (Dazar'ai Juggernaut)";
  sound = 1;
};


-- ***************
-- * King's Rest *
-- ***************

-- TODO: Hunting Leap (Reban)

GTFO.SpellID["269932"] = {
  --desc = "Gust Slash";
  applicationOnly = true;
  sound = 1;
};

GTFO.SpellID["265914"] = {
  --desc = "Molten Gold (The Golden Serpent)";
  sound = 1;
};

GTFO.SpellID["267874"] = {
  --desc = "Burning Ground (Mchimba the Embalmer)";
  sound = 1;
};

GTFO.SpellID["270891"] = {
  --desc = "Channel Lightning (King Rahu'ai)";
  sound = 1;
};

GTFO.SpellID["270931"] = {
  --desc = "Darkshot";
  sound = 1;
};

GTFO.SpellID["270503"] = {
  --desc = "Hunting Leap (Skeletal Hunting Raptor)";
  sound = 1;
};

GTFO.SpellID["270868"] = {
  --desc = "Lingering Poison";
  sound = 1;
};

GTFO.SpellID["270928"] = {
  --desc = "Bladestorm (King Timalji)";
  sound = 1;
};

GTFO.SpellID["270292"] = {
  --desc = "Purifying Flame";
  sound = 1;
};

GTFO.SpellID["271564"] = {
  --desc = "Embalming Fluid";
  applicationOnly = true;
  sound = 1;
};

GTFO.SpellID["266191"] = {
  --desc = "Whirling Axe";
  sound = 1;
  applicationOnly = true;
};


-- ********************
-- * Siege of Boralus *
-- ********************

GTFO.SpellID["256663"] = {
  --desc = "Burning Tar";
  sound = 1;
};

GTFO.SpellID["272140"] = {
  --desc = "Iron Volley";
  sound = 1;
};

GTFO.SpellID["257886"] = {
  --desc = "Brine Pools (Hadal Darkfathom)";
  sound = 1;
};

-- *********
-- * Uldir *
-- *********

-- TODO: Plasma Discharge (Taloc) -- Alert when standing next to someone that has it
-- TODO: Ruptured Blood (Zul) -- Supposed to avoid this?
-- TODO: Matrix Surge (G'huun)
-- TODO: Unclean Contagion (G'huun)
-- TODO: Putrid Blood (G'huun)
-- TODO: Malignant Growth (G'huun)

GTFO.SpellID["275057"] = {
  --desc = "Coagulated Corruption (Tendril of Gore)";
  sound = 1;
};

GTFO.SpellID["270290"] = {
  --desc = "Blood Storm (Taloc)";
  sound = 1;
};

GTFO.SpellID["274113"] = {
  --desc = "Obliteration Beam (Mythrax the Unraveler)";
  sound = 1;
  negatingDebuffSpellID = 272407;  -- Oblivion Sphere
};

GTFO.SpellID["270287"] = {
  --desc = "Blighted Ground (G'huun)";
  sound = 1;
};

GTFO.SpellID["284631"] = {
  --desc = "Uldir Defensive Beam";
  sound = 1;
};

GTFO.SpellID["275432"] = {
  --desc = "Uldir Defensive Beam";
  sound = 1;
  test = true;
};

GTFO.SpellID["275445"] = {
  --desc = "Uldir Defensive Beam";
  sound = 1;
};

GTFO.SpellID["268253"] = {
  --desc = "Uldir Defensive Beam";
  sound = 1;
  test = true;
};

GTFO.SpellID["268277"] = {
  --desc = "Purifying Flame (MOTHER)";
  sound = 1;
};

GTFO.SpellID["274804"] = {
  --desc = "Bloodstorm (Nazmani Reaver)";
  sound = 1;
  damageMinimum = 1;
};

GTFO.SpellID["277804"] = {
  --desc = "Hunting Leap (Malformed Raptor)";
  sound = 1;
};

GTFO.SpellID["277148"] = {
  --desc = "Seeping Rot";
  sound = 1;
};

GTFO.SpellID["265127"] = {
  --desc = "Lingering Infection (Vectis)";
  applicationOnly = true;
  sound = 1;
  ignoreEvent = "OmegaVector";
  test = true;
};

GTFO.SpellID["265143"] = {
  --desc = "Omega Vector (Vectis)";
  soundFunction = function() 
      GTFO_AddEvent("OmegaVector", 4);
      return 0;
  end;
  test = true;
};

GTFO.SpellID["279012"] = {
  --desc = "Blood Ritual";
  sound = 1;
};

GTFO.SpellID["274195"] = {
  --desc = "Corrupted Blood (Zul)";
  applicationOnly = true;
  sound = 1;
  test = true;
};

GTFO.SpellID["276834"] = {
  --desc = "Arcing Discharge (G'huun)";
  sound = 1;
};

GTFO.SpellID["279575"] = {
  --desc = "Choking Miasma (G'huun)";
  sound = 1;
};

--- *************************
--- * Battle for Dazar'alor *
--- *************************

GTFO.SpellID["283582"] = {
  --desc = "Consecration (Ra'wani Kanae)";
  sound = 1;
};

GTFO.SpellID["286373"] = {
  --desc = "Chill of Death (Grong)";
  sound = 1;
};

GTFO.SpellID["286501"] = {
  --desc = "Creeping Blaze (Yalat's Bulwark)";
  sound = 1;
};

GTFO.SpellID["283063"] = {
  --desc = "Flames of Punishment (Yalat's Bulwark)";
  applicationOnly = true;
  sound = 1;
};

GTFO.SpellID["287513"] = {
  --desc = "Flames of Punishment (Yalat's Bulwark)";
  applicationOnly = true;
  sound = 1;
};

GTFO.SpellID["284424"] = {
  --desc = "Scorching Ground (Yalat's Bulwark)";
  sound = 1;
};

GTFO.SpellID["285479"] = {
  --desc = "Flame Jet (Yalat's Bulwark)";
  sound = 1;
};

GTFO.SpellID["284470"] = {
  --desc = "Hex of Lethargy (Opulence)";
  sound = 2;
  damageMinimum = 1;
  test = true;
};

GTFO.SpellID["287074"] = {
  --desc = "Molten Gold (Opulence)";
  sound = 1;
};

GTFO.SpellID["285894"] = {
  --desc = "Wild Maul (Gonk's Aspect)";
  sound = 1;
  tankSound = 0;
};

GTFO.SpellID["290448"] = {
  --desc = "Seal of Purification (King Rhast)";
  sound = 1;
};

GTFO.SpellID["271737"] = {
  --desc = "Rocket Barrage (Gnomish Gyro-Engineer)";
  tankSound = 2;
  sound = 1;
};

GTFO.SpellID["286680"] = {
  --desc = "Roiling Tides";
  sound = 1;
};

GTFO.SpellID["284369"] = {
  --desc = "Sea Storm";
  sound = 1;
};

GTFO.SpellID["285075"] = {
  --desc = "Freezing Tidepool (Stormwall Blockade)";
  sound = 1;
  tankSound = 2;
};

GTFO.SpellID["288051"] = {
  --desc = "Dragon's Breath (Ma'ra Grimfang)";
  sound = 1;
};

GTFO.SpellID["288297"] = {
  --desc = "Arctic Ground (Lady Jaina Proudmoore)";
  sound = 1;
};

GTFO.SpellID["287993"] = {
  --desc = "Chilling Touch (Lady Jaina Proudmoore)";
  applicationOnly = true;
  affirmingDebuffSpellID = 288297; -- Arctic Ground
  sound = 1;
};

GTFO.SpellID["287365"] = {
  --desc = "Searing Pitch (Lady Jaina Proudmoore)";
  sound = 1;
  negatingDebuffSpellID = 287993;  -- Chilling Touch
};

GTFO.SpellID["288808"] = {
  --desc = "Consecration";
  applicationOnly = true;
  heroicSound = 1;
  mythicSound = 1;
  sound = 0;
  test = true;
};


--- **********************
--- * Crucible of Storms *
--- **********************

-- TODO: Promises of Power (Restless Cabal) -- sound = 4 [Requires investigation]

GTFO.SpellID["287876"] = {
  --desc = "Enveloping Darkness (Restless Cabal)";
  sound = 1;
};

GTFO.SpellID["287876"] = {
  --desc = "Gift of N'Zoth: Obscurity (Uu'nat)";
  sound = 1;
};


-- ***********************
-- * Operation: Mechagon *
-- ***********************

GTFO.SpellID["302384"] = {
  --desc = "Static Discharge (HK-8 Aerial Oppression Unit)";
  sound = 1;
};

GTFO.SpellID["294890"] = {
  --desc = "Gyro-Scrap (Malfunctioning Scrapbot)";
  sound = 1;
};

GTFO.SpellID["296560"] = {
  --desc = "Clinging Static (King Gobbamak)";
  sound = 1;
};

GTFO.SpellID["301680"] = {
  --desc = "Rapid Fire (Mechagon Cavalry)";
  sound = 1;
};

GTFO.SpellID["300160"] = {
  --desc = "Gyro-Scrap (Heavy Scrapbot)";
  sound = 1;
};

GTFO.SpellID["300675"] = {
  --desc = "Toxic Fog (Toxic Lurker)";
  sound = 1;
};

GTFO.SpellID["298212"] = {
  --desc = "Sludge Bolt (Gunker)";
  tankSound = 1;
  sound = 0;
};

GTFO.SpellID["285020"] = {
  --desc = "Whirling Edge (The Platinum Pummeler)";
  sound = 1;
};

GTFO.SpellID["294291"] = {
  --desc = "Process Waste (Waste Processing Unit)";
  sound = 1;
};

GTFO.SpellID["294549"] = {
  --desc = "Furnace Flames";
  sound = 1;
};

GTFO.SpellID["291949"] = {
  --desc = "Venting Flames (K.U.-J.0.)";
  sound = 1;
};

GTFO.SpellID["285443"] = {
  --desc = "Hidden Flame Cannon (Head Machinist Sparkflux)";
  applicationOnly = true;
  sound = 1;
};


-- **********************
-- * The Eternal Palace *
-- **********************

-- TODO: Arcing Azerite (Lady Ashvane) 296944 -- Does this trigger on players empowered?  How to tell when wrongfully hit
-- TODO: Raging Rapids (Orgozoa)
-- TODO: Form Ranks/In Formation (The Queen's Court)
-- TODO: Sphere of Influence (The Queen's Court) - Mythic, avoidable?
-- TODO: Static Shock (Queen Azshara)
-- TODO: Piercing Gaze (Queen Azshara)


GTFO.SpellID["300961"] = {
  --desc = "Frozen Ground (Abyssal Commander Sivara)";
  sound = 1;
};

GTFO.SpellID["300962"] = {
  --desc = "Septic Ground (Abyssal Commander Sivara)";
  sound = 1;
};

GTFO.SpellID["292307"] = {
  --desc = "Gaze from Below (Blackwater Behemoth)";
  sound = 1;
  --affirmingDebuffSpellID = 292133; -- Bioluminescence
};

GTFO.SpellID["292247"] = {
  --desc = "Bioelectric Feelers (Blackwater Behemoth)";
  sound = 4;
};

GTFO.SpellID["295920"] = {
  --desc = "Ancient Tempest (Radiance of Azshara)";
  applicationOnly = true;
  sound = 1;
  test = true;
};

GTFO.SpellID["299152"] = {
  --desc = "Waterlogged";
  applicationOnly = true;
  sound = 0;
};

GTFO.SpellID["296752"] = {
  --desc = "Cutting Coral (Lady Ashvane)";
  sound = 1;
};

GTFO.SpellID["300244"] = {
  --desc = "Raging Rapids (Orgozoa)";
  sound = 1;
};

GTFO.SpellID["297672"] = {
  --desc = "Stand Alone (The Queen's Court)";
  sound = 4;
  test = true;
};

GTFO.SpellID["297673"] = {
  --desc = "Stand Alone (The Queen's Court)";
  sound = 4;
  test = true;
};

GTFO.SpellID["303306"] = {
  --desc = "Sphere of Influence (The Queen's Court)";
  sound = 1;
  test = true;
};

GTFO.SpellID["300545"] = {
  --desc = "Mighty Rupture (The Queen's Court)";
  sound = 1;
};

GTFO.SpellID["303913"] = {
  --desc = "Lingering Soul (Shirakess Voidreaper)";
  sound = 1;
};

GTFO.SpellID["303958"] = {
  --desc = "Nightmare Pool";
  sound = 1;
};

GTFO.SpellID["298192"] = {
  --desc = "Dark Beyond (Za'qul)";
  sound = 1;
  damageMinimum = 1;
};

GTFO.SpellID["303819"] = {
  --desc = "Nightmare Pool (Za'qul)";
  sound = 1;
};

GTFO.SpellID["297907"] = {
  --desc = "Cursed Heart (Queen Azshara)";
  sound = 1;
};

GTFO.SpellID["303981"] = {
  --desc = "Nether Portal (Queen Azshara)";
  sound = 1;
};

GTFO.SpellID["303422"] = {
  --desc = "Blizzard";
  sound = 1;
};

GTFO.SpellID["299276"] = {
  --desc = "Sanction (Queen Azshara)";
  applicationOnly = true;
  sound = 1;
};

GTFO.SpellID["298569"] = {
  --desc = "Drained Soul (Queen Azshara)";
  applicationOnly = true;
  sound = 1;
  minimumStacks = 5;
};

-- *************
-- * Ny'alotha *
-- *************

-- TODO: Crackling Shard (Wrathion) -- Alert when NOT afflicated with Burning Madness
-- TODO: Infinite Void (Carapace of N'Zoth) 
-- TODO: Paranoia (N'Zoth) -- FF, complicated mechanic to track?
-- TODO: Devour Thoughts (N'Zoth) -- FF
-- TODO: Contempt (N'Zoth) -- Low damage?

GTFO.SpellID["306824"] = {
  --desc = "Molten Pool (Wrathion)";
  sound = 1;
};

GTFO.SpellID["313959"] = {
  --desc = "Scorching Blisters (Wrathion)";
  sound = 1;
};

GTFO.SpellID["307053"] = {
  --desc = "Lava Pools (Wrathion)";
  sound = 1;
};

GTFO.SpellID["305575"] = {
  --desc = "Ritual Field (Dark Inquisitor Xanesh)";
  sound = 1;
};

GTFO.SpellID["310322"] = {
  --desc = "Morass of Corruption (Il'gynoth, Corruption Reborn)";
  sound = 1;
};

GTFO.SpellID["307343"] = {
  --desc = "Shadowy Residue (Vexiona)";
  sound = 1;
};

GTFO.SpellID["307250"] = {
  --desc = "Twilight Decimator (Vexiona)";
  sound = 1;
};

GTFO.SpellID["309991"] = {
  --desc = "Anguish (N'Zoth)";
  sound = 1;
};

GTFO.SpellID["307421"] = {
  --desc = "Annihilation (Void Ascendant)";
  sound = 1;
  tankSound = 0;
};

GTFO.SpellID["317999"] = {
  --desc = "Gaze from Beyond";
  sound = 1;
};

GTFO.SpellID["314430"] = {
  --desc = "Lingering Blood";
  sound = 1;
};

GTFO.SpellID["309704"] = {
  --desc = "Caustic Coating";
  sound = 1;
};

GTFO.SpellID["310406"] = {
  --desc = "Void Glare (Eyes of Drest'agath)";
  sound = 1;
};

GTFO.SpellID["308995"] = {
  --desc = "Reality Tear (Tentacle of Drest'agath)";
  sound = 1;
};

GTFO.SpellID["307061"] = {
  --desc = "Mycelial Growth (Fury of N'Zoth)";
  sound = 1;
};

GTFO.SpellID["313672"] = {
  --desc = "Acid Pool (Ka'zir)";
  sound = 1;
};

end
