local rawset = rawset
local tostring = tostring

local L = setmetatable({ }, {__index = function(t, k)
	local v = tostring(k)
	rawset(t, k, v)
	return v
end})

Gladius.L = L

local locale = GetLocale()

if locale == "enUS" or locale == "enGB" then
	L["xCT"] = "xCT"
	L["xCT Plus"] = "xCT Plus"
	L["You can't use this function inside arenas."] = "You can't use this function inside arenas."
	L["Frame"] = "Frame"
	L["Welcome to Gladius!"] = "Welcome to Gladius!"
	L["First run has been detected displaying test frame."] = "First run has been detected displaying test frame."
	L["Valid slash commands are:"] = "Valid slash commands are:"
	L["/gladius ui"] = "/gladius ui"
	L["/gladius test 2-5"] = "/gladius test 2-5"
	L["/gladius hide"] = "/gladius hide"
	L["/gladius reset"] = "/gladius reset"
	L["If this is not your first run please lock or move the frame to prevent this from happening."] = "If this is not your first run please lock or move the frame to prevent this from happening."
	L["LEFT"] = "LEFT"
	L["CENTER"] = "CENTER"
	L["RIGHT"] = "RIGHT"
	L["Top Left"] = "Top Left"
	L["Top Right"] = "Top Right"
	L["Center Left"] = "Center Left"
	L["Center Right"] = "Center Right"
	L["Bottom Left"] = "Bottom Left"
	L["Bottom Right"] = "Bottom Right"
	L["Enable Module"] = "Enable Module"
	L["Reset Module"] = "Reset Module"
	L["Reset Auras"] = "Reset Auras"
	L["Module Templates"] = "Module Templates"
	L["General"] = "General"
	L["General settings"] = "General settings"
	L["Lock frame"] = "Lock frame"
	L["Toggle if the frame can be moved"] = "Toggle if the frame can be moved"
	L["Grow frame upwards"] = "Grow frame upwards"
	L["If this is toggled the frame will grow upwards instead of downwards."] = "If this is toggled the frame will grow upwards instead of downwards."
	L["Group Buttons"] = "Group Buttons"
	L["If this is toggled then arena frames can be moved individually"] = "If this is toggled then arena frames can be moved individually"
	L["Advanced Options"] = "Advanced Options"
	L["Toggle advanced options"] = "Toggle advanced options"
	L["Frame settings"] = "Frame settings"
	L["Background Color"] = "Background Color"
	L["Color of the frame background"] = "Color of the frame background"
	L["Background Padding"] = "Background Padding"
	L["Padding of the background"] = "Padding of the background"
	L["Bottom Margin"] = "Bottom Margin"
	L["Margin between each button"] = "Margin between each button"
	L["Size"] = "Size"
	L["Size settings"] = "Size settings"
	L["Bar width"] = "Bar width"
	L["Width of the module bars"] = "Width of the module bars"
	L["Frame scale"] = "Frame scale"
	L["Scale of the frame"] = "Scale of the frame"
	L["Font"] = "Font"
	L["Font settings"] = "Font settings"
	L["Global Font"] = "Global Font"
	L["Global font used by the modules"] = "Global font used by the modules"
	L["Global Font Size"] = "Global Font Size"
	L["Text size of the power info text"] = "Text size of the power info text"
	L["Use Global Font Size"] = "Use Global Font Size"
	L["Toggle if you want to use the global font size"] = "Toggle if you want to use the global font size"
	L["Arms"] = "Arms"
	L["Fury"] = "Fury"
	L["Protection"] = "Protection"
	L["Holy"] = "Holy"
	L["Retribution"] = "Retribution"
	L["Assassination"] = "Assassination"
	L["Combat"] = "Combat"
	L["Subtlety"] = "Subtlety"
	L["Discipline"] = "Discipline"
	L["Shadow"] = "Shadow"
	L["Blood"] = "Blood"
	L["Frost"] = "Frost"
	L["Unholy"] = "Unholy"
	L["Arcane"] = "Arcane"
	L["Fire"] = "Fire"
	L["Affliction"] = "Affliction"
	L["Demonology"] = "Demonology"
	L["Destruction"] = "Destruction"
	L["Elemental"] = "Elemental"
	L["Enhancement"] = "Enhancement"
	L["Restoration"] = "Restoration"
	L["Beast Mastery"] = "Beast Mastery"
	L["Marksmanship"] = "Marksmanship"
	L["Survival"] = "Survival"
	L["Balance"] = "Balance"
	L["Feral"] = "Feral"
	L["Guardian"] = "Guardian"
	L["%s - %s"] = "%s - %s"
	L["SPEC DETECTED: %s (%s)"] = "SPEC DETECTED: %s (%s)"
	L["LOW HEALTH: %s (%s)"] = "LOW HEALTH: %s (%s)"
	L["DRINKING: %s (%s)"] = "DRINKING: %s (%s)"
	L["RESURRECTING: %s (%s)"] = "RESURRECTING: %s (%s)"
	L["Self"] = "Self"
	L["Party"] = "Party"
	L["Say"] = "Say"
	L["Raid Warning"] = "Raid Warning"
	L["Scrolling Combat Text"] = "Scrolling Combat Text"
	L["MikScrollingBattleText"] = "MikScrollingBattleText"
	L["Blizzard's Floating Combat Text"] = "Blizzard's Floating Combat Text"
	L["Parrot"] = "Parrot"
	L["Options"] = "Options"
	L["Destination"] = "Destination"
	L["Choose how your announcements are displayed."] = "Choose how your announcements are displayed."
	L["Low health threshold"] = "Low health threshold"
	L["Choose how low an enemy must be before low health is announced."] = "Choose how low an enemy must be before low health is announced."
	L["Announcement toggles"] = "Announcement toggles"
	L["New enemies"] = "New enemies"
	L["Announces when new enemies are discovered."] = "Announces when new enemies are discovered."
	L["Drinking"] = "Drinking"
	L["Announces when enemies sit down to drink."] = "Announces when enemies sit down to drink."
	L["Low health"] = "Low health"
	L["Announces when an enemy drops below a certain health threshold."] = "Announces when an enemy drops below a certain health threshold."
	L["Resurrection"] = "Resurrection"
	L["Announces when an enemy tries to resurrect a teammate."] = "Announces when an enemy tries to resurrect a teammate."
	L["Spec Detection"] = "Spec Detection"
	L["Announces when the spec of an enemy was detected."] = "Announces when the spec of an enemy was detected."
	L["Buffs"] = "Buffs"
	L["Widget"] = "Widget"
	L["Widget settings"] = "Widget settings"
	L["Auras Buffs"] = "Auras Buffs"
	L["Toggle aura buffs"] = "Toggle aura buffs"
	L["Auras Column Grow"] = "Auras Column Grow"
	L["Grow direction of the auras"] = "Grow direction of the auras"
	L["Up Left"] = "Up Left"
	L["Up Right"] = "Up Right"
	L["Down Left"] = "Down Left"
	L["Down Right"] = "Down Right"
	L["Aura Icons Per Column"] = "Aura Icons Per Column"
	L["Number of aura icons per column"] = "Number of aura icons per column"
	L["Aura Icons Max"] = "Aura Icons Max"
	L["Number of max buffs"] = "Number of max buffs"
	L["Auras Gloss"] = "Auras Gloss"
	L["Toggle gloss on the auras icon"] = "Toggle gloss on the auras icon"
	L["Auras Gloss Color"] = "Auras Gloss Color"
	L["Color of the auras icon gloss"] = "Color of the auras icon gloss"
	L["Aura Icon Width"] = "Aura Icon Width"
	L["Width of the aura icons"] = "Width of the aura icons"
	L["Aura Icon Height"] = "Aura Icon Height"
	L["Height of the aura icon"] = "Height of the aura icon"
	L["Auras Spacing Vertical"] = "Auras Spacing Vertical"
	L["Vertical spacing of the auras"] = "Vertical spacing of the auras"
	L["Auras Spacing Horizontal"] = "Auras Spacing Horizontal"
	L["Horizontal spacing of the auras"] = "Horizontal spacing of the auras"
	L["Position"] = "Position"
	L["Position settings"] = "Position settings"
	L["Auras Attach To"] = "Auras Attach To"
	L["Attach auras to the given frame"] = "Attach auras to the given frame"
	L["Auras Anchor"] = "Auras Anchor"
	L["Anchor of the auras"] = "Anchor of the auras"
	L["Auras Relative Point"] = "Auras Relative Point"
	L["Relative point of the auras"] = "Relative point of the auras"
	L["Auras Offset X"] = "Auras Offset X"
	L["X offset of the auras"] = "X offset of the auras"
	L["Auras Offset Y"] = "Auras Offset Y"
	L["Y offset of the auras"] = "Y offset of the auras"
	L["Filter"] = "Filter"
	L["Whitelist"] = "Whitelist"
	L["Blacklist"] = "Blacklist"
	L["Filter Function"] = "Filter Function"
	L["Debuffs"] = "Debuffs"
	L["Auras Debuffs"] = "Auras Debuffs"
	L["Toggle aura debuffs"] = "Toggle aura debuffs"
	L["Number of max Debuffs"] = "Number of max Debuffs"
	L["Auras"] = "Auras"
	L["New Aura"] = "New Aura"
	L["Name"] = "Name"
	L["Name of the aura"] = "Name of the aura"
	L["Priority"] = "Priority"
	L["Select what priority the aura should have - higher equals more priority"] = "Select what priority the aura should have - higher equals more priority"
	L["Add new Aura"] = "Add new Aura"
	L["Delete"] = "Delete"
	L["Example Spell Name"] = "Example Spell Name"
	L["Bar"] = "Bar"
	L["Bar settings"] = "Bar settings"
	L["Cast Bar Color"] = "Cast Bar Color"
	L["Color of the cast bar"] = "Color of the cast bar"
	L["Cast Bar Background Color"] = "Cast Bar Background Color"
	L["Color of the cast bar background"] = "Color of the cast bar background"
	L["Cast Bar Inverse"] = "Cast Bar Inverse"
	L["Inverse the cast bar"] = "Inverse the cast bar"
	L["Cast Bar Texture"] = "Cast Bar Texture"
	L["Texture of the cast bar"] = "Texture of the cast bar"
	L["Cast Bar Icon"] = "Cast Bar Icon"
	L["Toggle the cast icon"] = "Toggle the cast icon"
	L["Cast Bar Icon Position"] = "Cast Bar Icon Position"
	L["Position of the cast bar icon"] = "Position of the cast bar icon"
	L["Cast Bar Adjust Width"] = "Cast Bar Adjust Width"
	L["Adjust cast bar width to the frame width"] = "Adjust cast bar width to the frame width"
	L["Cast Bar Width"] = "Cast Bar Width"
	L["Width of the cast bar"] = "Width of the cast bar"
	L["Cast Bar Height"] = "Cast Bar Height"
	L["Height of the cast bar"] = "Height of the cast bar"
	L["Cast Bar Attach To"] = "Cast Bar Attach To"
	L["Attach cast bar to the given frame"] = "Attach cast bar to the given frame"
	L["Cast Bar Anchor"] = "Cast Bar Anchor"
	L["Anchor of the cast bar"] = "Anchor of the cast bar"
	L["Cast Bar Relative Point"] = "Cast Bar Relative Point"
	L["Relative point of the cast bar"] = "Relative point of the cast bar"
	L["Cast Bar Offset X"] = "Cast Bar Offset X"
	L["X offset of the cast bar"] = "X offset of the cast bar"
	L["Cast Bar Offset Y"] = "Cast Bar Offset Y"
	L["Y offset of the castbar"] = "Y offset of the castbar"
	L["Cast Text"] = "Cast Text"
	L["Text"] = "Text"
	L["Text settings"] = "Text settings"
	L["Toggle cast text"] = "Toggle cast text"
	L["Cast Text Color"] = "Cast Text Color"
	L["Text color of the cast text"] = "Text color of the cast text"
	L["Cast Text Size"] = "Cast Text Size"
	L["Text size of the cast text"] = "Text size of the cast text"
	L["Cast Text Align"] = "Cast Text Align"
	L["Text align of the cast text"] = "Text align of the cast text"
	L["Cast Text Offset X"] = "Cast Text Offset X"
	L["X offset of the cast text"] = "X offset of the cast text"
	L["Cast Text Offset Y"] = "Cast Text Offset Y"
	L["Y offset of the cast text"] = "Y offset of the cast text"
	L["Cast Time Text"] = "Cast Time Text"
	L["Toggle cast time text"] = "Toggle cast time text"
	L["Cast Time Text Color"] = "Cast Time Text Color"
	L["Text color of the cast time text"] = "Text color of the cast time text"
	L["Cast Time Text Size"] = "Cast Time Text Size"
	L["Text size of the cast time text"] = "Text size of the cast time text"
	L["Cast Time Text Align"] = "Cast Time Text Align"
	L["Text align of the cast time text"] = "Text align of the cast time text"
	L["Cast Time Offset X"] = "Cast Time Offset X"
	L["X Offset of the cast time text"] = "X Offset of the cast time text"
	L["Cast Time Offset Y"] = "Cast Time Offset Y"
	L["Y Offset of the cast time text"] = "Y Offset of the cast time text"
	L["Class Icon Important Auras"] = "Class Icon Important Auras"
	L["Show important auras instead of the class icon"] = "Show important auras instead of the class icon"
	L["Class Icon Crop Borders"] = "Class Icon Crop Borders"
	L["Toggle if the class icon borders should be cropped or not."] = "Toggle if the class icon borders should be cropped or not."
	L["Class Icon Cooldown Spiral"] = "Class Icon Cooldown Spiral"
	L["Display the cooldown spiral for important auras"] = "Display the cooldown spiral for important auras"
	L["Class Icon Cooldown Reverse"] = "Class Icon Cooldown Reverse"
	L["Invert the dark/bright part of the cooldown spiral"] = "Invert the dark/bright part of the cooldown spiral"
	L["Class Icon Gloss"] = "Class Icon Gloss"
	L["Toggle gloss on the class icon"] = "Toggle gloss on the class icon"
	L["Class Icon Gloss Color"] = "Class Icon Gloss Color"
	L["Color of the class icon gloss"] = "Color of the class icon gloss"
	L["Class Icon Frame Level"] = "Class Icon Frame Level"
	L["Frame level of the class icon"] = "Frame level of the class icon"
	L["Class Icon Adjust Size"] = "Class Icon Adjust Size"
	L["Adjust class icon size to the frame size"] = "Adjust class icon size to the frame size"
	L["Class Icon Size"] = "Class Icon Size"
	L["Size of the class icon"] = "Size of the class icon"
	L["Class Icon Attach To"] = "Class Icon Attach To"
	L["Attach class icon to given frame"] = "Attach class icon to given frame"
	L["Class Icon Position"] = "Class Icon Position"
	L["Position of the class icon"] = "Position of the class icon"
	L["Left"] = "Left"
	L["Right"] = "Right"
	L["Class Icon Anchor"] = "Class Icon Anchor"
	L["Anchor of the class icon"] = "Anchor of the class icon"
	L["Class Icon Relative Point"] = "Class Icon Relative Point"
	L["Relative point of the class icon"] = "Relative point of the class icon"
	L["Class Icon Offset X"] = "Class Icon Offset X"
	L["X offset of the class icon"] = "X offset of the class icon"
	L["Class Icon Offset Y"] = "Class Icon Offset Y"
	L["Y offset of the class icon"] = "Y offset of the class icon"
	L["Middle"] = "Middle"
	L["Button 4"] = "Button 4"
	L["Button 5"] = "Button 5"
	L["None"] = "None"
	L["ctrl-"] = "ctrl-"
	L["shift-"] = "shift-"
	L["alt-"] = "alt-"
	L["Click Actions"] = "Click Actions"
	L["Add click action"] = "Add click action"
	L["Mouse button"] = "Mouse button"
	L["Select which mouse button this click action uses"] = "Select which mouse button this click action uses"
	L["Modifier"] = "Modifier"
	L["Select a modifier for this click action"] = "Select a modifier for this click action"
	L["Add"] = "Add"
	L["Delete Click Action"] = "Delete Click Action"
	L["Action"] = "Action"
	L["Select what this Click Action does"] = "Select what this Click Action does"
	L["Cast Spell"] = "Cast Spell"
	L["Spell Name / Macro Text"] = "Spell Name / Macro Text"
	L["DRTracker Space"] = "DRTracker Space"
	L["Space between the icons"] = "Space between the icons"
	L["DRTracker Cooldown Spiral"] = "DRTracker Cooldown Spiral"
	L["DRTracker Cooldown Reverse"] = "DRTracker Cooldown Reverse"
	L["DRTracker Gloss"] = "DRTracker Gloss"
	L["Toggle gloss on the drTracker icon"] = "Toggle gloss on the drTracker icon"
	L["DRTracker Gloss Color"] = "DRTracker Gloss Color"
	L["Color of the drTracker icon gloss"] = "Color of the drTracker icon gloss"
	L["DRTracker Frame Level"] = "DRTracker Frame Level"
	L["Frame level of the drTracker"] = "Frame level of the drTracker"
	L["DRTracker Adjust Size"] = "DRTracker Adjust Size"
	L["Adjust drTracker size to the frame size"] = "Adjust drTracker size to the frame size"
	L["DRTracker Size"] = "DRTracker Size"
	L["Size of the drTracker"] = "Size of the drTracker"
	L["DR Text Color"] = "DR Text Color"
	L["Text color of the DR text"] = "Text color of the DR text"
	L["DR Text Size"] = "DR Text Size"
	L["Text size of the DR text"] = "Text size of the DR text"
	L["DRTracker Attach To"] = "DRTracker Attach To"
	L["Attach drTracker to the given frame"] = "Attach drTracker to the given frame"
	L["DRTracker Position"] = "DRTracker Position"
	L["DRTracker Anchor"] = "DRTracker Anchor"
	L["Anchor of the drTracker"] = "Anchor of the drTracker"
	L["DRTracker Relative Point"] = "DRTracker Relative Point"
	L["Relative point of the drTracker"] = "Relative point of the drTracker"
	L["DRTracker Offset X"] = "DRTracker Offset X"
	L["X offset of the drTracker"] = "X offset of the drTracker"
	L["DRTracker Offset Y"] = "DRTracker Offset Y"
	L["Y offset of the drTracker"] = "Y offset of the drTracker"
	L["Categories"] = "Categories"
	L["Category settings"] = "Category settings"
	L["Health bar class color"] = "Health bar class color"
	L["Toggle health bar class color"] = "Toggle health bar class color"
	L["Health bar color"] = "Health bar color"
	L["Color of the health bar"] = "Color of the health bar"
	L["Health bar background color"] = "Health bar background color"
	L["Color of the health bar background"] = "Color of the health bar background"
	L["Health bar inverse"] = "Health bar inverse"
	L["Inverse the health bar"] = "Inverse the health bar"
	L["Health bar texture"] = "Health bar texture"
	L["Texture of the health bar"] = "Texture of the health bar"
	L["Health bar adjust width"] = "Health bar adjust width"
	L["Adjust health bar width to the frame width"] = "Adjust health bar width to the frame width"
	L["Health bar width"] = "Health bar width"
	L["Width of the health bar"] = "Width of the health bar"
	L["Health bar height"] = "Health bar height"
	L["Height of the health bar"] = "Height of the health bar"
	L["Health Bar Attach To"] = "Health Bar Attach To"
	L["Attach health bar to the given frame"] = "Attach health bar to the given frame"
	L["Health Bar Anchor"] = "Health Bar Anchor"
	L["Anchor of the health bar"] = "Anchor of the health bar"
	L["Health Bar Relative Point"] = "Health Bar Relative Point"
	L["Relative point of the health bar"] = "Relative point of the health bar"
	L["Health bar offset X"] = "Health bar offset X"
	L["X offset of the health bar"] = "X offset of the health bar"
	L["Health bar offset Y"] = "Health bar offset Y"
	L["Y offset of the health bar"] = "Y offset of the health bar"
	L["Health colors"] = "Health colors"
	L["Default priest color"] = "Default priest color"
	L["Toggle default priest color"] = "Toggle default priest color"
	L["Priest color"] = "Priest color"
	L["Default paladin color"] = "Default paladin color"
	L["Toggle default paladin color"] = "Toggle default paladin color"
	L["Paladin color"] = "Paladin color"
	L["Default shaman color"] = "Default shaman color"
	L["Toggle default shaman color"] = "Toggle default shaman color"
	L["Shaman color"] = "Shaman color"
	L["Default druid color"] = "Default druid color"
	L["Toggle default druid color"] = "Toggle default druid color"
	L["Druid color"] = "Druid color"
	L["Default mage color"] = "Default mage color"
	L["Toggle default mage color"] = "Toggle default mage color"
	L["Mage color"] = "Mage color"
	L["Default warlock color"] = "Default warlock color"
	L["Toggle default warlock color"] = "Toggle default warlock color"
	L["Warlock color"] = "Warlock color"
	L["Default hunter color"] = "Default hunter color"
	L["Toggle default hunter color"] = "Toggle default hunter color"
	L["Hunter color"] = "Hunter color"
	L["Default warrior color"] = "Default warrior color"
	L["Toggle default warrior color"] = "Toggle default warrior color"
	L["Warrior color"] = "Warrior color"
	L["Default rogue color"] = "Default rogue color"
	L["Toggle default eogue color"] = "Toggle default eogue color"
	L["Rogue color"] = "Rogue color"
	L["Default death knight color"] = "Default death knight color"
	L["Toggle default death knight color"] = "Toggle default death knight color"
	L["Death knight color"] = "Death knight color"
	L["Hover"] = "Hover"
	L["Hover settings"] = "Hover settings"
	L["Highlight On Mouseover"] = "Highlight On Mouseover"
	L["Highlight frame on mouseover"] = "Highlight frame on mouseover"
	L["Highlight Color"] = "Highlight Color"
	L["Color of the highlight frame"] = "Color of the highlight frame"
	L["Player Target"] = "Player Target"
	L["Player target settings"] = "Player target settings"
	L["Highlight Target"] = "Highlight Target"
	L["Show border around player target"] = "Show border around player target"
	L["Highlight Target Color"] = "Highlight Target Color"
	L["Color of the target border"] = "Color of the target border"
	L["Highlight Target Priority"] = "Highlight Target Priority"
	L["Priority of the target border"] = "Priority of the target border"
	L["Player Focus Target"] = "Player Focus Target"
	L["Player focus target settings"] = "Player focus target settings"
	L["Highlight Focus Target"] = "Highlight Focus Target"
	L["Highlight Focus Target Color"] = "Highlight Focus Target Color"
	L["Color of the focus target border"] = "Color of the focus target border"
	L["Highlight Focus Target Priority"] = "Highlight Focus Target Priority"
	L["Priority of the focus target border"] = "Priority of the focus target border"
	L["Raid Assist Target"] = "Raid Assist Target"
	L["Raid assist settings"] = "Raid assist settings"
	L["Highlight Raid Assist"] = "Highlight Raid Assist"
	L["Show border around raid assist"] = "Show border around raid assist"
	L["Highlight Raid Assist Color"] = "Highlight Raid Assist Color"
	L["Color of the raid assist border"] = "Color of the raid assist border"
	L["Highlight Raid Assist Priority"] = "Highlight Raid Assist Priority"
	L["Priority of the raid assist border"] = "Priority of the raid assist border"
	L["Raid Icon Targets"] = "Raid Icon Targets"
	L["Raid Icon target 1 settings"] = "Raid Icon target 1 settings"
	L["Raid Icon target 2 settings"] = "Raid Icon target 2 settings"
	L["Raid Icon target 3 settings"] = "Raid Icon target 3 settings"
	L["Raid Icon target 4 settings"] = "Raid Icon target 4 settings"
	L["Raid Icon target 5 settings"] = "Raid Icon target 5 settings"
	L["Raid Icon target 6 settings"] = "Raid Icon target 6 settings"
	L["Raid Icon target 7 settings"] = "Raid Icon target 7 settings"
	L["Raid Icon target 8 settings"] = "Raid Icon target 8 settings"
	L["Layout Code"] = "Layout Code"
	L["Code of your layout."] = "Code of your layout."
	L["Import layout"] = "Import layout"
	L["Import your layout code."] = "Import your layout code."
	L["Error while importing layout: %s"] = "Error while importing layout: %s"
	L["Power Bar Default Color"] = "Power Bar Default Color"
	L["Toggle power bar default color"] = "Toggle power bar default color"
	L["Power Bar Color"] = "Power Bar Color"
	L["Color of the power bar"] = "Color of the power bar"
	L["Power Bar Background Color"] = "Power Bar Background Color"
	L["Color of the power bar background"] = "Color of the power bar background"
	L["Power Bar Inverse"] = "Power Bar Inverse"
	L["Inverse the power bar"] = "Inverse the power bar"
	L["Power Bar Texture"] = "Power Bar Texture"
	L["Texture of the power bar"] = "Texture of the power bar"
	L["Power Bar Adjust Width"] = "Power Bar Adjust Width"
	L["Adjust power bar width to the frame width"] = "Adjust power bar width to the frame width"
	L["Power Bar Width"] = "Power Bar Width"
	L["Width of the power bar"] = "Width of the power bar"
	L["Power Bar Height"] = "Power Bar Height"
	L["Height of the power bar"] = "Height of the power bar"
	L["Power Bar Attach To"] = "Power Bar Attach To"
	L["Attach power bar to the given frame"] = "Attach power bar to the given frame"
	L["Power Bar Anchor"] = "Power Bar Anchor"
	L["Anchor of the power bar"] = "Anchor of the power bar"
	L["Power Bar Relative Point"] = "Power Bar Relative Point"
	L["Relative point of the power bar"] = "Relative point of the power bar"
	L["Power Bar Offset X"] = "Power Bar Offset X"
	L["X offset of the power bar"] = "X offset of the power bar"
	L["Power Bar Offset Y"] = "Power Bar Offset Y"
	L["Power colors"] = "Power colors"
	L["Default Power Mana Color"] = "Default Power Mana Color"
	L["Toggle default power mana color"] = "Toggle default power mana color"
	L["Power Mana Color"] = "Power Mana Color"
	L["Default Power Rage Color"] = "Default Power Rage Color"
	L["Toggle default power rage color"] = "Toggle default power rage color"
	L["Power Rage Color"] = "Power Rage Color"
	L["Default Power Focus Color"] = "Default Power Focus Color"
	L["Toggle default power focus color"] = "Toggle default power focus color"
	L["Power Focus Color"] = "Power Focus Color"
	L["Default Power Energy Color"] = "Default Power Energy Color"
	L["Toggle default power energy color"] = "Toggle default power energy color"
	L["Power Energy Color"] = "Power Energy Color"
	L["Default Power Runic Power Color"] = "Default Power Runic Power Color"
	L["Toggle default power runic power color"] = "Toggle default power runic power color"
	L["Power Runic Power Color"] = "Power Runic Power Color"
	L["Texts"] = "Texts"
	L["Add text"] = "Add text"
	L["Name of the text element"] = "Name of the text element"
	L["Text Attach To"] = "Text Attach To"
	L["Attach text to module bar"] = "Attach text to module bar"
	L["Add Text"] = "Add Text"
	L["Tags"] = "Tags"
	L["Add tag"] = "Add tag"
	L["Name of the tag"] = "Name of the tag"
	L["Add Tag"] = "Add Tag"
	L["Tag: %s"] = "Tag: %s"
	L["Text to be displayed"] = "Text to be displayed"
	L["Delete Text"] = "Delete Text"
	L["Tag"] = "Tag"
	L["Tag settings"] = "Tag settings"
	L["Text Color"] = "Text Color"
	L["Text color of the text"] = "Text color of the text"
	L["Text Size"] = "Text Size"
	L["Text size of the text"] = "Text size of the text"
	L["Text Align"] = "Text Align"
	L["Text align of the text"] = "Text align of the text"
	L["Text Offset X"] = "Text Offset X"
	L["X offset of the text"] = "X offset of the text"
	L["Text Offset Y"] = "Text Offset Y"
	L["Y offset of the text"] = "Y offset of the text"
	L["Delete Tag"] = "Delete Tag"
	L["Events"] = "Events"
	L["Events which update the tag"] = "Events which update the tag"
	L["Function"] = "Function"
	L["DEAD"] = "DEAD"
	L["Target bar health bar"] = "Target bar health bar"
	L["Toggle health bar display"] = "Toggle health bar display"
	L["Target bar class color"] = "Target bar class color"
	L["Target bar color"] = "Target bar color"
	L["Target bar background color"] = "Target bar background color"
	L["Target bar inverse"] = "Target bar inverse"
	L["Target bar texture"] = "Target bar texture"
	L["Target bar class icon"] = "Target bar class icon"
	L["Toggle the target bar class icon"] = "Toggle the target bar class icon"
	L["Target bar icon position"] = "Target bar icon position"
	L["Position of the target bar class icon"] = "Position of the target bar class icon"
	L["Target bar adjust width"] = "Target bar adjust width"
	L["Target bar width"] = "Target bar width"
	L["Target bar height"] = "Target bar height"
	L["Target Bar Attach To"] = "Target Bar Attach To"
	L["Target Bar Anchor"] = "Target Bar Anchor"
	L["Target Bar Relative Point"] = "Target Bar Relative Point"
	L["Target bar offset X"] = "Target bar offset X"
	L["Target bar offset Y"] = "Target bar offset Y"
	L["Timer Soon Color"] = "Timer Soon Color"
	L["Color of the timer when timeleft is less than 5 seconds."] = "Color of the timer when timeleft is less than 5 seconds."
	L["Timer Soon Size"] = "Timer Soon Size"
	L["Text size of the timer when timeleft is less than 5 seconds."] = "Text size of the timer when timeleft is less than 5 seconds."
	L["Timer Seconds Color"] = "Timer Seconds Color"
	L["Color of the timer when timeleft is less than 60 seconds."] = "Color of the timer when timeleft is less than 60 seconds."
	L["Timer Seconds Size"] = "Timer Seconds Size"
	L["Text size of the timer when timeleft is less than 60 seconds."] = "Text size of the timer when timeleft is less than 60 seconds."
	L["Timer Minutes Color"] = "Timer Minutes Color"
	L["Color of the timer when timeleft is greater than 60 seconds."] = "Color of the timer when timeleft is greater than 60 seconds."
	L["Timer Minutes Size"] = "Timer Minutes Size"
	L["Text size of the timer when timeleft is greater than 60 seconds."] = "Text size of the timer when timeleft is greater than 60 seconds."
	L["TRINKET USED: %s (%s)"] = "TRINKET USED: %s (%s)"
	L["TRINKET READY: %s (%s)"] = "TRINKET READY: %s (%s)"
	L["Trinket"] = "Trinket"
	L["Announces when an enemy uses a PvP trinket."] = "Announces when an enemy uses a PvP trinket."
	L["Trinket Grid Style Icon"] = "Trinket Grid Style Icon"
	L["Toggle trinket grid style icon"] = "Toggle trinket grid style icon"
	L["Trinket Grid Style Icon Color"] = "Trinket Grid Style Icon Color"
	L["Color of the trinket grid style icon"] = "Color of the trinket grid style icon"
	L["Trinket Grid Style Icon Used Color"] = "Trinket Grid Style Icon Used Color"
	L["Color of the trinket grid style icon when it's on cooldown"] = "Color of the trinket grid style icon when it's on cooldown"
	L["Trinket Cooldown Spiral"] = "Trinket Cooldown Spiral"
	L["Trinket Cooldown Reverse"] = "Trinket Cooldown Reverse"
	L["Trinket Gloss"] = "Trinket Gloss"
	L["Toggle gloss on the trinket icon"] = "Toggle gloss on the trinket icon"
	L["Trinket Gloss Color"] = "Trinket Gloss Color"
	L["Color of the trinket icon gloss"] = "Color of the trinket icon gloss"
	L["Trinket Icon Border Crop"] = "Trinket Icon Border Crop"
	L["Toggle if the borders of the trinket icon should be cropped"] = "Toggle if the borders of the trinket icon should be cropped"
	L["Trinket Icon Faction"] = "Trinket Icon Faction"
	L["Toggle if the trinket icon should be changing based on the opponents faction"] = "Toggle if the trinket icon should be changing based on the opponents faction"
	L["Trinket Frame Level"] = "Trinket Frame Level"
	L["Frame level of the trinket"] = "Frame level of the trinket"
	L["Trinket Adjust Size"] = "Trinket Adjust Size"
	L["Adjust trinket size to the frame size"] = "Adjust trinket size to the frame size"
	L["Trinket Size"] = "Trinket Size"
	L["Size of the trinket"] = "Size of the trinket"
	L["Trinket Attach To"] = "Trinket Attach To"
	L["Attach trinket to the given frame"] = "Attach trinket to the given frame"
	L["Trinket Position"] = "Trinket Position"
	L["Position of the trinket"] = "Position of the trinket"
	L["Trinket Anchor"] = "Trinket Anchor"
	L["Anchor of the trinket"] = "Anchor of the trinket"
	L["Trinket Relative Point"] = "Trinket Relative Point"
	L["Relative point of the trinket"] = "Relative point of the trinket"
	L["Trinket Offset X"] = "Trinket Offset X"
	L["X offset of the trinket"] = "X offset of the trinket"
	L["Trinket Offset Y"] = "Trinket Offset Y"
	L["Y offset of the trinket"] = "Y offset of the trinket"
	L["Export layout"] = "Export layout"
	L["Export your layout code."] = "Export your layout code."
	L["Target Bar Icon Crop Borders"] = "Target Bar Icon Crop Borders"
	L["Toggle if the target bar icon borders should be cropped or not."] = "Toggle if the target bar icon borders should be cropped or not."
	L["Timer Use OmniCC"] = "Timer Use OmniCC"
	L["The timer module will use OmniCC for text display"] = "The timer module will use OmniCC for text display"
	L["maxhealthTag"] = "Max Health"
	L["maxpower:shortTag"] = "Max Power (Short)"
	L["powerTag"] = "Power"
	L["health:shortTag"] = "Health (Short)"
	L["classTag"] = "Unit Class"
	L["power:percentageTag"] = "Power (Percentage)"
	L["power:shortTag"] = "Power (Short)"
	L["raceTag"] = "Unit Race"
	L["nameTag"] = "Unit Name"
	L["name:statusTag"] = "Unit Name/Status"
	L["specTag"] = "Unit Spec"
	L["health:percentageTag"] = "Health (Percentage)"
	L["healthTag"] = "Health"
	L["maxhealth:shortTag"] = "Max Health (Short)"
	L["maxpowerTag"] = "Max Power"
	L["Unholy:short"] = "Unh"
	L["Frost:short"] = "Frost"
	L["Blood:short"] = "Blood"
	L["Fire:short"] = "Fire"
	L["Arcane:short"] = "Arcane"
	L["Marksmanship:short"] = "Marks"
	L["Survival:short"] = "Surv"
	L["Beast Mastery:short"] = "BM"
	L["Elemental:short"] = "Ele"
	L["Enhancement:short"] = "Enh"
	L["Restoration:short"] = "Resto"
	L["Feral:short"] = "Feral"
	L["Balance:short"] = "Balance"
	L["Guardian:short"] = "Guardian"
	L["Demonology:short"] = "Demo"
	L["Destruction:short"] = "Destro"
	L["Affliction:short"] = "Affli"
	L["Subtlety:short"] = "Sub"
	L["Combat:short"] = "Combat"
	L["Assassination:short"] = "Assa"
	L["Shadow:short"] = "Shadow"
	L["Discipline:short"] = "Disc"
	L["Holy:short"] = "Holy"
	L["Retribution:short"] = "Ret"
	L["Protection:short"] = "Prot"
	L["Arms:short"] = "Arms"
	L["Fury:short"] = "Fury"
	L["Brewmaster:short"] = "Brewm"
	L["Mistweaver:short"] = "Mistw"
	L["Windwalker:short"] = "Windw"
	L["Warrior:short"] = "Warr"
	L["Death Knight:short"] = "DK"
	L["Warlock:short"] = "Lock"
	L["Priest:short"] = "Priest"
	L["Hunter:short"] = "Hunter"
	L["Rogue:short"] = "Rogue"
	L["Shaman:short"] = "Shaman"
	L["Druid:short"] = "Druid"
	L["Paladin:short"] = "Pala"
	L["Mage:short"] = "Mage"
	L["Monk:short"] = "Monk"
elseif locale == "deDE" then
	L["Add"] = "Hinzufügen"
	L["Add text"] = "Text hinzufügen"
	L["Add Text"] = "Text hinzufügen"
	L["Adjust cast bar width to the frame width"] = "Anpassen der Zauberleistenbreite an die Rahmenbreite"
	L["Adjust class icon size to the frame size"] = "Anpassen der Klassensymbolbreite an die Rahmenbreite"
	L["Adjust health bar width to the frame width"] = "Anpassen der Lebensleistenbreite an die Rahmenbreite"
	L["Advanced Options"] = "Erweiterte Optionen"
	L["Affliction"] = "Gebrechen"
	L["Affliction:short"] = "Gebr"
	L["Anchor of the auras"] = "Ankerpunkt von Auren"
	L["Anchor of the cast bar"] = "Ankerpunkt der Zauberleiste"
	L["Anchor of the class icon"] = "Ankerpunkt des Klassnsymbols"
	L["Anchor of the health bar"] = "Ankerpunkt der Lebensleiste"
	L["Anchor of the power bar"] = "Ankerpunkte der Energieleiste"
	L["Anchor of the trinket"] = "Ankerpunkt des Schmuckstücks"
	L["Announcement toggles"] = "Umschalten der Benachrichtigung"
	L["Announces when an enemy drops below a certain health threshold."] = "Benachrichtigung wenn ein Gegner unter den eingestellten Lebenswert fällt."
	L["Announces when an enemy tries to resurrect a teammate."] = "Benachrichtigung wenn ein Gegner versucht einen gegnerischen Spieler wiederzubeleben."
	L["Announces when an enemy uses a PvP trinket."] = "Benachrichtigung wenn ein Gegner ein Schmuckstück benutzt."
	L["Announces when enemies sit down to drink."] = "Benachrichtigung wenn ein Gegner sich zum Trinken hinsetzt."
	L["Announces when new enemies are discovered."] = "Anzeige wenn ein neuer Gegner entdeckt wird."
	L["Background Color"] = "Hintergrundfarbe"
	L["Balance"] = "Gleichgewicht"
	L["Balance:short"] = "Eule"
	L["Bar"] = "Leiste"
	L["Bar settings"] = "Leisteneinstellung"
	L["Bar width"] = "Leistenbreite"
	L["Beast Mastery"] = "Tierherrschaft"
	L["Beast Mastery:short"] = "BM"
	L["Blood"] = "Blut"
	L["Blood:short"] = "Blut"
	L["Bottom Left"] = "Unten Links"
	L["Bottom Margin"] = "Unten Mittig"
	L["Bottom Right"] = "Unten Rechts"
	L["Buffs"] = "Buffs"
	L["Center Left"] = "Zentriert Links"
	L["Center Right"] = "Zentriert Rechts"
	L["Choose how low an enemy must be before low health is announced."] = "Wähle wieviel Leben ein Gegner verloren haben muss, bevor niedriges Leben angekündigt wird."
	L["Choose how your announcements are displayed."] = "Wähle wie deine Benachrichtigungen angezeigt werden sollen."
	L["Class Icon Adjust Size"] = "Klassensymbolgröße verändern"
	L["Class Icon Anchor"] = "Ankerpunkt des Klassensymbols"
	L["Class Icon Cooldown Reverse"] = "Klassensymbolcooldown rückwärts"
	L["Color of the focus target border"] = "Farbe der Umrandung des Fokusziels"
	L["Color of the frame background"] = "Farbe des Rahmenhintergrunds"
	L["Color of the health bar"] = "Farbe des Lebensbalkens"
	L["Color of the health bar background"] = "Farbe vom Hintergrund des Lebensbalkens"
	L["Color of the highlight frame"] = "Farbe des Rahmens der im Vordergrund ist"
	L["Color of the target border"] = "Rahmenfarbe des Ziels"
	L["Feral"] = "Katze"
	L["Feral:short"] = "Katze"
	L["Fire"] = "Feuer"
	L["Fire:short"] = "Feuer"
	L["First run has been detected displaying test frame."] = "Erststart wurde festgestellt, es wird die Testumgebung angezeigt."
	L["Font"] = "Schriftart"
	L["Font settings"] = "Schriftarteinstellung"
	L["Frame"] = "Rahmen"
	L["Frame scale"] = "Rahmenskalierung"
	L["Frame settings"] = "Rahmeneinstellungen"
	L["Frost"] = "Frost"
	L["Frost:short"] = "Frost"
	L["Function"] = "Funktion"
	L["Fury"] = "Furor"
	L["Fury:short"] = "Furor"
	L["General"] = "Generell"
	L["General settings"] = "Generelle Einstellungen"
	L["/gladius hide"] = "/gladius hide"
	L["/gladius reset"] = "/gladius reset"
	L["/gladius test 2-5"] = "/gladius test 2-5"
	L["/gladius ui"] = "/gladius ui"
	L["Global Font"] = "Allgemeine Schriftart"
	L["Global Font Size"] = "Allgemeine Schriftartgröße"
	L["Global font used by the modules"] = "Allgemeine Schriftart (von Modulen verwendet)"
	L["If this is not your first run please lock or move the frame to prevent this from happening."] = "Wenn dies nicht das erste Mal ist, das Gladius geladen wird, verschiebe oder sperre den Rahmen um dies zu verhindern."
	L["Left"] = "Links"
	L["LEFT"] = "LINKS"
	L["Lock frame"] = "Sperre Rahmen"
	L["Low health"] = "Wenig Leben"
	L["LOW HEALTH: %s (%s)"] = "WENIG LEBEN: %s (%s)"
	L["Low health threshold"] = "Grenzwert der Wenig Leben Anzeige"
	L["Mage color"] = "Magier Farbe"
	L["Mage:short"] = "Magier"
	L["Middle"] = "Mitte"
	L["Number of max buffs"] = "Anzahl der Maximalen Buffs"
	L["Options"] = "Optionen"
	L["Paladin color"] = "Paladin Anzeigefarbe"
	L["Paladin:short"] = "Pala"
	L["Party"] = "Gruppe"
	L["Player Focus Target"] = "Spieler Fokus Ziel"
	L["Player focus target settings"] = "Spieler Fokus Ziel Einstellungen"
	L["Player Target"] = "Spieler Ziel"
	L["Raid Warning"] = "Schlachtzugswarnung"
	L["Restoration"] = "Wiederherstellung"
	L["Restoration:short"] = "Baum"
	L["RESURRECTING: %s (%s)"] = "WIEDERBELEBEN: %s (%s)"
	L["Resurrection"] = "Wiederbelebung"
	L["Retribution"] = "Vergelter"
	L["Retribution:short"] = "Retri"
	L["Right"] = "Rechts"
	L["RIGHT"] = "RECHTS"
	L["Rogue color"] = "Schurken Farbe"
	L["Rogue:short"] = "Schurke"
	L["Say"] = "Sagen"
	L["Scale of the frame"] = "Skallierung des Rahmens"
	L["Self"] = "Selbst"
	L["Shadow"] = "Schatten"
	L["Size"] = "Größe"
	L["Size of the class icon"] = "Größe des Klassensymbols"
	L["Size settings"] = "Größeneinstellungen"
	L["SPEC DETECTED: %s (%s)"] = "SPEZIALISIERUNG ENTDECKT: %s (%s)"
	L["Spec Detection"] = "Spezialisierungserkennung"
	L["Spell Name / Macro Text"] = "Zaubername / Makrotext"
	L["Survival"] = "Überleben"
	L["Survival:short"] = "Überleben"
	L["TRINKET READY: %s (%s)"] = "SCHMUCKSTÜCK BEREIT %s (%s)"
	L["TRINKET USED: %s (%s)"] = "SCHMUCKSTÜCK BENUTZT %s (%s)"
	L["Unholy"] = "Unheilig"
	L["Unholy:short"] = "Unheilig"
	L["Up Left"] = "Oben Links"
	L["Up Right"] = "Oben Rechts"
	L["Use Global Font Size"] = "Verwende Generelle Schriftart Größe"
	L["Warlock color"] = "Farbe des Hexenmeisters"
	L["Warlock:short"] = "Lock"
	L["Warrior color"] = "Farbe des Kriegers"
	L["Warrior:short"] = "Warr"
	L["Welcome to Gladius!"] = "Willkommen bei Gladius!"
	L["Width of the cast bar"] = "Breite der Zauberleiste"
elseif locale == "esES" then
	L["Action"] = "Accion"
	L["Add"] = "Añadir"
	L["Affliction"] = "Afliccion"
	L["Arcane"] = "Arcano"
	L["Arms"] = "Armas"
	L["Assassination"] = "Asesinato"
	L["Auras"] = "Auras"
	L["Balance"] = "Equilibrio"
	L["Bar settings"] = "Ajuste de barras"
	L["Bar width"] = "Ancho de la barra"
	L["Beast Mastery"] = "Maestro de bestias"
	L["Blizzard's Floating Combat Text"] = "Texto de Combate Flotante de Blizzard"
	L["Blood"] = "Sangre"
	L["Button 4"] = "Boton 4"
	L["Button 5"] = "Boton 5"
	L["Cast Spell"] = "Lanzar Hechizo"
	L["Color of the cast bar"] = "Color de la barra de lanzamiento"
	L["Color of the cast bar background"] = "Color de fondo de la barra de lanzamiento"
	L["Color of the health bar"] = "Color de la barra de salud"
	L["Combat"] = "Combate"
	L["Delete"] = "Borrar"
	L["Demonology"] = "Demonologia"
	L["Destruction"] = "Destruccion"
	L["Discipline"] = "Disciplina"
	L["Drinking"] = "Bebiendo"
	L["DRINKING: %s (%s)"] = "BEBIENDO: %s (%s)"
	L["Elemental"] = "Elemental"
	L["Enhancement"] = "Mejora"
	L["Feral"] = "Combate Feral"
	L["Fire"] = "Fuego"
	L["Frame scale"] = "Escala del marco"
	L["Frost"] = "Escarcha"
	L["Fury"] = "Furia"
	L["General"] = "General"
	L["General settings"] = "Ajustes generales"
	L["/gladius hide"] = "/gladius hide"
	L["/gladius ui"] = "/gladius ui"
	L["Grow frame upwards"] = "Crecer los macros hacia arriba"
	L["Health bar color"] = "Color de la barra de salud"
	L["Health bar height"] = "Alto de la barra de salud"
	L["Holy"] = "Sagrado"
	L["If this is not your first run please lock or move the frame to prevent this from happening."] = "Si esta no es la primera ejecucion por favor bloquea o mueve el marco para evitar que esto suceda."
	L["If this is toggled the frame will grow upwards instead of downwards."] = "Activando esto el marco crecerá hacia arriba en vez de hacia abajo."
	L["Left"] = "Izquierda"
	L["Lock frame"] = "Bloquear marco"
	L["Marksmanship"] = "Punteria"
	L["MikScrollingBattleText"] = "MikScrollingBattleText"
	L["Modifier"] = "Modificador"
	L["Name"] = "Nombre"
	L["Name of the aura"] = "Nombre del aura"
	L["New enemies"] = "Nuevos enemigos"
	L["None"] = "Ninguno"
	L["Parrot"] = "Loro"
	L["Party"] = "Grupo"
	L["Priority"] = "Prioridad"
	L["Protection"] = "Proteccion"
	L["Raid Warning"] = "Alerta de banda"
	L["Restoration"] = "Restauracion"
	L["RESURRECTING: %s (%s)"] = "RESUCITANDO: %s (%s)"
	L["Retribution"] = "Reprension"
	L["Right"] = "Derecha"
	L["Say"] = "Decir"
	L["Scale of the frame"] = "Escala del marco"
	L["Scrolling Combat Text"] = "Texto deslizante de Combate"
	L["Select what priority the aura should have - higher equals more priority"] = "Prioridad"
	L["Self"] = "A si mismo"
	L["Shadow"] = "Sombras"
	L["Subtlety"] = "Sutileza"
	L["Survival"] = "Supervivencia"
	L["Text"] = "Texto"
	L["Text settings"] = "Ajustes de texto"
	L["Toggle if the frame can be moved"] = "Indique si se puede mover el marco"
	L["TRINKET READY: %s (%s)"] = "ABALORIO LISTO: %s (%s)"
	L["TRINKET USED: %s (%s)"] = "ABALORIO UTILIZADO: %s (%s)"
	L["Unholy"] = "Profano"
	L["Valid slash commands are:"] = "Los comandos de barra validos son:"
	L["Welcome to Gladius!"] = "Bienvenido a Gladius!"
elseif locale == "esMX" then
	L["Affliction"] = "Aflicción"
	L["Arcane"] = "Arcano"
	L["Arms"] = "Armas"
	L["Assassination"] = "Asesinato"
	L["Balance"] = "Balance"
	L["Beast Mastery"] = "Bestias"
	L["Blood"] = "Sangre"
	L["Combat"] = "Combate"
	L["Demonology"] = "Demonología"
	L["Destruction"] = "Destrucción"
	L["Discipline"] = "Disciplina"
	L["Elemental"] = "Elemental"
	L["Enhancement"] = "Mejora"
	L["Feral"] = "Combate feral"
	L["Fire"] = "Fuego"
	L["Frost"] = "Escarcha"
	L["Fury"] = "Furia"
	L["Holy"] = "Sagrado"
	L["Marksmanship"] = "Puntería"
	L["Protection"] = "Protección"
	L["Restoration"] = "Restauración"
	L["Retribution"] = "Reprensión"
	L["Shadow"] = "Sombra"
	L["Subtlety"] = "Sutileza"
	L["Survival"] = "Supervivencia"
	L["Unholy"] = "Profano"
elseif locale == "frFR" then
	L["Action"] = "Action"
	L["Add"] = "Ajouter"
	L["Add click action"] = "Ajouter une action par clic"
	L["Add new Aura"] = "ajouter nouvel aura"
	L["Add text"] = "Ajouter texte"
	L["Add Text"] = "Ajouter texte"
	L["Adjust cast bar width to the frame width"] = "Ajuster la barre d'incantation au cadre"
	L["Adjust class icon size to the frame size"] = "Ajuster la taille de l'icone de classe au cadre"
	L["Adjust health bar width to the frame width"] = "ajuster la barre de vie au cadre"
	L["Adjust power bar width to the frame width"] = "ajuster la barre d'énergie au cadre"
	L["Adjust trinket size to the frame size"] = "ajuster la taille du bijou au cadre"
	L["Advanced Options"] = "options avancées"
	L["Affliction"] = "Affliction"
	L["Anchor of the auras"] = "ancre des auras"
	L["Anchor of the cast bar"] = "ancre de la barre d'incantation"
	L["Anchor of the class icon"] = "ancre de l'icone de classe"
	L["Anchor of the health bar"] = "Ancre de la barre de vie"
	L["Anchor of the power bar"] = "Ancre de la barre d'énergie"
	L["Anchor of the trinket"] = "ancre du bijou"
	L["Announces when an enemy drops below a certain health threshold."] = "Annonce quand un ennemi passe en dessous d'un seuil de points de vie"
	L["Announces when an enemy tries to resurrect a teammate."] = "Annonce quand un ennemi tente de ressusciter un équipier"
	L["Announces when an enemy uses a PvP trinket."] = "Annonce quand un ennemi utilise un bijou PVP"
	L["Announces when enemies sit down to drink."] = "Annonce quand un ennemi s'assoit pour boire"
	L["Announces when new enemies are discovered."] = "Annonce quand un ennemi est visible"
	L["Announces when the spec of an enemy was detected."] = "Annonce quand la spécialisation d'un ennemi est detectée"
	L["Arcane"] = "Arcane"
	L["Arms"] = "Armes"
	L["Arms:short"] = "Armes"
	L["Assassination"] = "Assassinat"
	L["Attach auras to the given frame"] = "Attache les auras au cadre donné"
	L["Attach cast bar to the given frame"] = "Attachela barre d'incantation au cadre donné"
	L["Attach class icon to given frame"] = "Attache l'icone de classe au cadre donné"
	L["Attach health bar to the given frame"] = "Attache la barre de vie au cadre donné"
	L["Attach power bar to the given frame"] = "Attache la barre d'énergie au cadre donné"
	L["Attach text to module bar"] = "Attache le texte à la barre de module"
	L["Auras"] = "Auras"
	L["Balance"] = "Equilibre"
	L["Bar settings"] = "Paramètres de la barre"
	L["Bar width"] = "Largeur de la barre"
	L["Beast Mastery"] = "Maîtrise des bêtes"
	L["Blizzard's Floating Combat Text"] = "Texte de combats flottants de Blizzard"
	L["Blood"] = "Sang"
	L["Button 4"] = "Bouton 4"
	L["Button 5"] = "Bouton 5"
	L["Cast Spell"] = "Lancer le sort"
	L["Color of the cast bar"] = "Couleur de la barre d'incantation"
	L["Color of the cast bar background"] = "Couleur de fond de la barre d'incantation"
	L["Color of the health bar"] = "Couleur de la barre de vie "
	L["Combat"] = "Combat"
	L["Delete"] = "Effacer"
	L["Demonology"] = "Démonologie"
	L["Destruction"] = "Destruction"
	L["Discipline"] = "Discipline"
	L["Drinking"] = "Boire"
	L["DRINKING: %s (%s)"] = "Boire: %s (%s)"
	L["Elemental"] = "Elémentaire"
	L["Enhancement"] = "Amélioration"
	L["Feral"] = "Combat farouche"
	L["Fire"] = "Feu"
	L["Frame scale"] = "Taille des fenêtres"
	L["Frost"] = "Givre"
	L["Fury"] = "Fureur"
	L["General"] = "Général"
	L["General settings"] = "Configuration générale"
	L["/gladius hide"] = "/gladius hide"
	L["/gladius reset"] = "/gladius reset"
	L["/gladius test 2-5"] = "/gladius test 2-5"
	L["/gladius ui"] = "/gladius ui"
	L["Grow frame upwards"] = "Diriger vers le haut"
	L["Health bar color"] = "Couleur de la barre de vie"
	L["Health bar height"] = "Hauteur de la barre de vie"
	L["Holy"] = "Sacré"
	L["If this is not your first run please lock or move the frame to prevent this from happening."] = "Si ce n'est pas votre première arène s'il vous plaît verrouillez ou déplacez le cadre pour éviter que cela se produise"
	L["If this is toggled the frame will grow upwards instead of downwards."] = "Si cela est activé le cadre sera diriger vers le haut au lieu de vers le bas"
	L["Left"] = "Gauche"
	L["Lock frame"] = "Verrouiller cadre"
	L["Marksmanship"] = "Précision"
	L["MikScrollingBattleText"] = "Défilement du texte de combat"
	L["Modifier"] = "Modifier"
	L["Name"] = "Nom"
	L["Name of the aura"] = "Nom de l'aura"
	L["New enemies"] = "Nouveaux ennemis"
	L["None"] = "Aucun"
	L["Parrot"] = "Perroquet"
	L["Party"] = "Groupe"
	L["Priority"] = "Priorité"
	L["Protection"] = "Protection"
	L["Raid Warning"] = "Avertissement de Raid"
	L["Restoration"] = "Restauration"
	L["RESURRECTING: %s (%s)"] = "RESURRECTION: %s (%s)"
	L["Retribution"] = "Vindicte"
	L["Right"] = "Droite"
	L["Say"] = "Dire"
	L["Scale of the frame"] = "Echelle du cadre"
	L["Scrolling Combat Text"] = "Défilement du Texte de Combat"
	L["Select what priority the aura should have - higher equals more priority"] = "Priorité"
	L["Self"] = "Soi-même"
	L["Shadow"] = "Ombre"
	L["Subtlety"] = "Finesse"
	L["Survival"] = "Survie"
	L["Text"] = "Texte"
	L["Text settings"] = "Réglages du texte"
	L["Toggle if the frame can be moved"] = "Sélectionnez si le cadre peut être bougé"
	L["Trinket"] = "Bijou"
	L["TRINKET READY: %s (%s)"] = "BIJOU PRET: %s (%s)"
	L["TRINKET USED: %s (%s)"] = "BIJOU UTILISE: %s (%s)"
	L["Unholy"] = "Impie"
	L["Valid slash commands are:"] = "Commandes slash valides sont:"
	L["Welcome to Gladius!"] = "Bienvenue sur Gladius!"
elseif locale == "itIT" then
	L["Action"] = "Azione"
	L["Add"] = "Aggiungi"
	L["Auras"] = "Aure"
	L["Bar settings"] = "Impostazioni Barra"
	L["Bar width"] = "Spessore Barra"
	L["Blizzard's Floating Combat Text"] = "Testo di Combattimento Flottante della Blizzard"
	L["Button 4"] = "Bottone 4"
	L["Button 5"] = "Bottone 5"
	L["Cast Spell"] = "Lancio Magia"
	L["Color of the cast bar"] = "Colore della barra di lancio magia"
	L["/gladius ui"] = "/gladius ui"
elseif locale == "koKR" then
	L["Action"] = "행동"
	L["Add"] = "추가"
	L["Add click action"] = "클릭 액션 추가"
	L["Add new Aura"] = "새 오라 추가"
	L["Add tag"] = "태그 추가"
	L["Add Tag"] = "태그 추가"
	L["Add text"] = "문자 추가"
	L["Add Text"] = "문자 추가"
	L["Adjust cast bar width to the frame width"] = "시전 바의 프레임 너비를 조절합니다."
	L["Adjust class icon size to the frame size"] = "직업 아이콘의 프레임 크기를 조절합니다."
	L["Adjust drTracker size to the frame size"] = "점감표시기의 프레임 크기를 조절합니다."
	L["Adjust health bar width to the frame width"] = "생명력 바의 프레임 너비를 조절합니다."
	L["Adjust power bar width to the frame width"] = "파워바 프레임의 너비를 조절합니다."
	L["Adjust trinket size to the frame size"] = "계급장 프레임의 크기를 조절합니다."
	L["Advanced Options"] = "설정 확장"
	L["Affliction"] = "고통"
	L["Affliction:short"] = "고통"
	L["alt-"] = "alt-"
	L["Anchor of the auras"] = "오라 표시 기준점을 설정합니다"
	L["Anchor of the cast bar"] = "시전 바의 기준 점을 설정합니다."
	L["Anchor of the class icon"] = "직업 아이콘의 기준점을 설정합니다"
	L["Anchor of the drTracker"] = "점감표시기의 기준점을 설정합니다."
	L["Anchor of the health bar"] = "생명력 바의 기준점을 설정합니다."
	L["Anchor of the power bar"] = "파워 바의 기준 점을 설정합니다."
	L["Anchor of the trinket"] = "계급장 기준점을 설정합니다."
	L["Announcement toggles"] = "알림 토글"
	L["Announces when an enemy drops below a certain health threshold."] = "적의 생명력이 지정한 수치까지 떨어지면 알립니다"
	L["Announces when an enemy tries to resurrect a teammate."] = "적이 자신의 팀원을 부활하려고 할 때 알립니다."
	L["Announces when an enemy uses a PvP trinket."] = "적이 계급장을 사용 했을 시에 알립니다."
	L["Announces when enemies sit down to drink."] = "적이 물빵을 먹기 위해 앉았을 때 알립니다."
	L["Announces when new enemies are discovered."] = "새로운 적이 등장했을 때 알립니다."
	L["Announces when the spec of an enemy was detected."] = "적 스펙이 감지 되었을 때 알립니다."
	L["Arcane"] = "비전"
	L["Arcane:short"] = "비전"
	L["Arms"] = "무기"
	L["Arms:short"] = "무분"
	L["Assassination"] = "암살"
	L["Assassination:short"] = "암살"
	L["Attach auras to the given frame"] = "프레임 어느 쪽에 오라를 위치시킬 지를 설정합니다."
	L["Attach cast bar to the given frame"] = "시전 바가 메인 바의 어느 위치에 표시될 지를 설정합니다."
	L["Attach class icon to given frame"] = "프레임에서 직업 아이콘 위치 방향을 지정합니다."
	L["Attach drTracker to the given frame"] = "메인 프레임에서의 점감표시기 위치를 설정합니다."
	L["Attach health bar to the given frame"] = "생명력 바의 위치 기준 프레임을 설정합니다."
	L["Attach power bar to the given frame"] = "파워 바가 위치 할 기준 프레임을 설정합니다."
	L["Attach text to module bar"] = "바 모듈의 문자 위치 기준을 설정합니다."
	L["Attach trinket to the given frame"] = "계급장 프레임의 위치 기준을 설정합니다."
	L["Aura Icon Height"] = "오라 아이콘 높이"
	L["Aura Icons Max"] = "최대 오라 아이콘"
	L["Aura Icons Per Column"] = "줄 당 오라 숫자"
	L["Aura Icon Width"] = "오라 아이콘 너비"
	L["Auras"] = "오러"
	L["Auras Anchor"] = "오라 기준점"
	L["Auras Attach To"] = "오라 위치"
	L["Auras Buffs"] = "오라 버프"
	L["Auras Column Grow"] = "오라 생성 방향"
	L["Auras Debuffs"] = "디버프 오라"
	L["Auras Gloss"] = "오라 글래스"
	L["Auras Gloss Color"] = "오라 글래스 색상"
	L["Auras Offset X"] = "오라 X 단차"
	L["Auras Offset Y"] = "오라 Y 단차"
	L["Auras Relative Point"] = "오라 상대 기준점"
	L["Auras Spacing Horizontal"] = "오라 수평 간격"
	L["Auras Spacing Vertical"] = "오라 수직 간격"
	L["Background Color"] = "배경 색상"
	L["Background Padding"] = "배경 범위"
	L["Balance"] = "조화"
	L["Balance:short"] = "조화"
	L["Bar"] = "바"
	L["Bar settings"] = "바 설정"
	L["Bar width"] = "바 길이"
	L["Beast Mastery"] = "야수"
	L["Beast Mastery:short"] = "야수"
	L["Blacklist"] = "금지항목"
	L["Blizzard's Floating Combat Text"] = "블리자드의 전투 메세지 형태"
	L["Blood"] = "혈기"
	L["Blood:short"] = "혈기"
	L["Bottom Left"] = "좌측 하단"
	L["Bottom Margin"] = "하단 여백"
	L["Bottom Right"] = "우측 하단"
	L["Brewmaster:short"] = "풍운"
	L["Buffs"] = "버프"
	L["Button 4"] = "버튼 4"
	L["Button 5"] = "버튼 5"
	L["Cast Bar Adjust Width"] = "시전 바 너비 조절"
	L["Cast Bar Anchor"] = "시전 바 기준점"
	L["Cast Bar Attach To"] = "시전 바 위치"
	L["Cast Bar Background Color"] = "시전 바 배경 색상"
	L["Cast Bar Color"] = "시전 바 색상"
	L["Cast Bar Height"] = "시전 바 두께"
	L["Cast Bar Icon"] = "시전 바 아이콘"
	L["Cast Bar Icon Position"] = "시전 바 아이콘 위치"
	L["Cast Bar Inverse"] = "시전 바 반전"
	L["Cast Bar Offset X"] = "시전 바 X 단차"
	L["Cast Bar Offset Y"] = "시전 바 Y 단차"
	L["Cast Bar Relative Point"] = "시전 바 상대 기준점"
	L["Cast Bar Texture"] = "시전 바 무늬"
	L["Cast Bar Width"] = "시전 바 너비"
	L["Cast Spell"] = "주문 시전"
	L["Cast Text"] = "시전 문자"
	L["Cast Text Align"] = "시전 문자 정렬 방향"
	L["Cast Text Color"] = "시전 문자 색상"
	L["Cast Text Offset X"] = "시전 문자 X 단차"
	L["Cast Text Offset Y"] = "시전 문자 Y 단차"
	L["Cast Text Size"] = "시전 문자 크기"
	L["Cast Time Offset X"] = "시전 시간 X 단차"
	L["Cast Time Offset Y"] = "시전 시간 Y 단차"
	L["Cast Time Text"] = "시전 시간 문자"
	L["Cast Time Text Align"] = "시전 시간 문자 정렬 방향"
	L["Cast Time Text Color"] = "시전 시간 문자 색상"
	L["Cast Time Text Size"] = "시전 시간 문자 크기"
	L["Categories"] = "카테고리"
	L["Category settings"] = "카테고리 설정"
	L["CENTER"] = "중앙"
	L["Center Left"] = "좌측 중앙"
	L["Center Right"] = "우측 중앙"
	L["Choose how low an enemy must be before low health is announced."] = "낮은 생명력 알림 시에 적의 생명력이 얼마나 낮을 지에 대한 기준점을 설정합니다."
	L["Choose how your announcements are displayed."] = "알림을 어디에 표시할 지를 선택합니다."
	L["Class Icon Adjust Size"] = "직업 아이콘 크기 조절"
	L["Class Icon Anchor"] = "직업 아이콘 기준점"
	L["Class Icon Attach To"] = "직업 아이콘 위치"
	L["Class Icon Cooldown Reverse"] = "직업 아이콘 쿨다운 반전"
	L["Class Icon Cooldown Spiral"] = "직업 아이콘 쿨다운 파이 표시"
	L["Class Icon Crop Borders"] = "직업 아이콘 테두리 제거"
	L["Class Icon Frame Level"] = "직업 아이콘 프레임 레벨"
	L["Class Icon Gloss"] = "직업 아이콘 글래스"
	L["Class Icon Gloss Color"] = "직업 아이콘 글래스 색상"
	L["Class Icon Important Auras"] = "직업 아이콘에 중요 오라 표시"
	L["Class Icon Offset X"] = "직업 아이콘 X 단차"
	L["Class Icon Offset Y"] = "직업 아이콘 Y 단차"
	L["Class Icon Position"] = "직업 아이콘 위치 값"
	L["Class Icon Relative Point"] = "직업 아이콘 상대 기준점"
	L["Class Icon Size"] = "직업 아이콘 크기"
	L["classTag"] = "유닛 직업"
	L["Click Actions"] = "클릭 액션"
	L["Code of your layout."] = "당신의 레이아웃에 대한 코드"
	L["Color of the auras icon gloss"] = "오라 아이콘 글래스의 색상을 지정합니다."
	L["Color of the cast bar"] = "시전 바의 색상"
	L["Color of the cast bar background"] = " Color of the cast bar background"
	L["Color of the class icon gloss"] = "직업 아이콘 글래스의 색상을 설정합니다"
	L["Color of the drTracker icon gloss"] = "점감표시기 글래스의 색상을 지정합니다."
	L["Color of the focus target border"] = "주시 대상 테두리에 대한 색상을 설정합니다."
	L["Color of the frame background"] = "프레임 배경의 색상을 지정합니다."
	L["Color of the health bar"] = "체력바의 색깔"
	L["Color of the health bar background"] = "생명력 바의 배경 색상을 설정합니다."
	L["Color of the highlight frame"] = "프레임 강조에 사용할 색상"
	L["Color of the power bar"] = "파워 바 색상을 설정합니다."
	L["Color of the power bar background"] = "파워 바의 배경 색상을 설정합니다."
	L["Color of the raid assist border"] = "공대 지원 대상 테두리에 사용할 색상을 설정합니다."
	L["Color of the target border"] = "대상 테두리에 사용할 색상을 설정합니다."
	L["Color of the timer when timeleft is greater than 60 seconds."] = "타이머 종료 60초 이상의 타이머 색상을 설정합니다."
	L["Color of the timer when timeleft is less than 5 seconds."] = "타이머 종료 5초 전의 타이머 색상을 설정합니다."
	L["Color of the timer when timeleft is less than 60 seconds."] = "타이머 종료 60초 전의 타이머 색상을 설정합니다."
	L["Color of the trinket grid style icon"] = "계급장 Grid 스타일 아이콘의 색상을 표시합니다."
	L["Color of the trinket grid style icon when it's on cooldown"] = "이미 사용한 계급장에 대한 Grid 스타일 아이콘의 색상을 설정합니다."
	L["Color of the trinket icon gloss"] = "계급장 글래스의 색상을 설정합니다."
	L["Combat"] = "전투"
	L["Combat:short"] = "전투"
	L["ctrl-"] = "ctrl-"
	L["DEAD"] = "죽음"
	L["Death knight color"] = "기본 죽음의기사 색상"
	L["Death Knight:short"] = "죽기"
	L["Debuffs"] = "디버프"
	L["Default death knight color"] = "기본 죽음의기사 색상"
	L["Default druid color"] = "기본 드루이드 색상"
	L["Default hunter color"] = "기본 사냥꾼 색상"
	L["Default mage color"] = "기본 마법사 색상"
	L["Default paladin color"] = "기본 성기사 색상"
	L["Default Power Energy Color"] = "기본 기력 바 색상"
	L["Default Power Focus Color"] = "기본 집중 바 색상"
	L["Default Power Mana Color"] = "기본 마나 바 색상"
	L["Default Power Rage Color"] = "기본 분노 바 색상"
	L["Default Power Runic Power Color"] = "기본 룬마력 바 색상"
	L["Default priest color"] = "기본 사제 색상"
	L["Default rogue color"] = "기본 도적 색상"
	L["Default shaman color"] = "기본 주술사 색상"
	L["Default warlock color"] = "기본 흑마법사 색상"
	L["Default warrior color"] = "기본 전사 색상"
	L["Delete"] = "삭제"
	L["Delete Click Action"] = "클릭 액션 삭제"
	L["Delete Tag"] = "태그 삭제"
	L["Delete Text"] = "문자 삭제"
	L["Demonology"] = "악마"
	L["Demonology:short"] = "악마"
	L["Destination"] = "표시채널"
	L["Destruction"] = "파괴"
	L["Destruction:short"] = "파괴"
	L["Discipline"] = "수양"
	L["Discipline:short"] = "수양"
	L["Display the cooldown spiral for important auras"] = "중요 오라의 쿨다운 파이를 표시합니다."
	L["Down Left"] = "좌측 하단"
	L["Down Right"] = "우측 하단"
	L["Drinking"] = "음료"
	L["DRINKING: %s (%s)"] = "음료마시기: %s (%s)"
	L["DR Text Color"] = "점감 문자 색상"
	L["DR Text Size"] = "점감 문자 크기"
	L["DRTracker Adjust Size"] = "점감표시기 크기 조절"
	L["DRTracker Anchor"] = "점감표시기 기준점"
	L["DRTracker Attach To"] = "점감표시기 위치"
	L["DRTracker Cooldown Reverse"] = "점감표시기 쿨다운 반전"
	L["DRTracker Cooldown Spiral"] = "점감표시기 쿨다운 파이"
	L["DRTracker Frame Level"] = "점감표시기 프레임 깊이"
	L["DRTracker Gloss"] = "점감표시기 글래스"
	L["DRTracker Gloss Color"] = "점감표시기 글래스 색상"
	L["DRTracker Offset X"] = "점감표시기 X 단차"
	L["DRTracker Offset Y"] = "점감표시기 Y 단차"
	L["DRTracker Position"] = "점감표시기 위치값"
	L["DRTracker Relative Point"] = "점감표시기 상대 기준점"
	L["DRTracker Size"] = "점감표시기 상대 기준점"
	L["DRTracker Space"] = "점감표시기 영역"
	L["Druid color"] = "기본 드루이드 색상"
	L["Druid:short"] = "드루"
	L["Elemental"] = "정기"
	L["Elemental:short"] = "정기"
	L["Enable Module"] = "모듈 활성화"
	L["Enhancement"] = "고양"
	L["Enhancement:short"] = "고양"
	L["Error while importing layout: %s"] = "레이아웃을 가져오는 동안 오류가 발생했습니다: %s"
	L["Events"] = "이벤트"
	L["Events which update the tag"] = "이벤트 시 태그를 업데이트 합니다."
	L["Example Spell Name"] = "주문 명 예제"
	L["Export layout"] = "레이아웃 내보내기"
	L["Export your layout code."] = "당신의 레이아웃 코드를 내보냅니다."
	L["Feral"] = "야성"
	L["Feral:short"] = "야성"
	L["Filter"] = "필터"
	L["Filter Function"] = "필터 기능"
	L["Fire"] = "화염"
	L["Fire:short"] = "화염"
	L["First run has been detected displaying test frame."] = "첫 로딩일 경우 테스트 프레임을 보여줍니다."
	L["Font"] = "글꼴"
	L["Font settings"] = "글꼴을 설정합니다."
	L["Frame"] = "프레임"
	L["Frame level of the class icon"] = "직업 아이콘의 프레임 깊이를 설정합니다."
	L["Frame level of the drTracker"] = "점감표시기의 프레임 깊이를 설정합니다."
	L["Frame level of the trinket"] = "계급장 프레임의 깊이를 설정합니다."
	L["Frame scale"] = "프레임 크기"
	L["Frame settings"] = "창 설정"
	L["Frost"] = "냉기"
	L["Frost:short"] = "냉기"
	L["Function"] = "기능"
	L["Fury"] = "분노"
	L["Fury:short"] = "분노"
	L["General"] = "일반"
	L["General settings"] = "일반 설정"
	L["/gladius hide"] = "/gladius hide"
	L["/gladius reset"] = "/gladius reset"
	L["/gladius test 2-5"] = "/gladius test 2-5"
	L["/gladius ui"] = "/gladius ui"
	L["Global Font"] = "공통 글꼴"
	L["Global Font Size"] = "공통 글꼴 크기"
	L["Global font used by the modules"] = "각 모듈에 사용될 공통된 공통 글꼴을 설정합니다."
	L["Group Buttons"] = "그룹 버튼"
	L["Grow direction of the auras"] = "오라가 생성되는 방향을 설정합니다."
	L["Grow frame upwards"] = "프레임 위로 쌓기"
	L["Health bar adjust width"] = "생명력 바 너비 조절"
	L["Health Bar Anchor"] = "생명력 바 기준점"
	L["Health Bar Attach To"] = "생명력 바 위치 기준"
	L["Health bar background color"] = "생명력 바 배경 색상"
	L["Health bar class color"] = "생명력 바 직업별 색상"
	L["Health bar color"] = "체력바 색상"
	L["Health bar height"] = "체력 바 높이"
	L["Health bar inverse"] = "생명력 바 반전"
	L["Health bar offset X"] = "생명력 바 X 축"
	L["Health bar offset Y"] = "생명력 바 Y 축"
	L["Health Bar Relative Point"] = "생명력 바 상대 기준점"
	L["Health bar texture"] = "생명력 바 무늬"
	L["Health bar width"] = "생명력 바 너비"
	L["Health colors"] = "생명력 색상"
	L["health:percentageTag"] = "생명력 (퍼센트)"
	L["health:shortTag"] = "생명력 (짧은표시)"
	L["healthTag"] = "생명력"
	L["Height of the aura icon"] = "오라 아이콘의 높이를 설정합니다."
	L["Height of the cast bar"] = "시전 바의 두께를 설정합니다."
	L["Height of the health bar"] = "생명력 바의 높이를 설정합니다."
	L["Height of the power bar"] = "파워 바의 높이를 설정합니다."
	L["Highlight Color"] = "강조 색상"
	L["Highlight Focus Target"] = "주시 대상 강조"
	L["Highlight Focus Target Color"] = "주시 대상 강조 색상"
	L["Highlight Focus Target Priority"] = "주시 대상 강조 우선 순위"
	L["Highlight frame on mouseover"] = "마우스오버 시 프레임을 강조합니다."
	L["Highlight On Mouseover"] = "마우스오버 시 강조"
	L["Highlight Raid Assist"] = "공대 지원 강조"
	L["Highlight Raid Assist Color"] = "공대 지원 강조 색상"
	L["Highlight Raid Assist Priority"] = "공대 지원 강조 우선순위"
	L["Highlight Target"] = "대상 강조"
	L["Highlight Target Color"] = "대상 강조 색상"
	L["Highlight Target Priority"] = "대상 강조 우선순위"
	L["Holy"] = "신성"
	L["Holy:short"] = "신성"
	L["Horizontal spacing of the auras"] = "오라의 수평 가격을 설정합니다."
	L["Hover"] = "마우스오버"
	L["Hover settings"] = "마우스오버 설정"
	L["Hunter color"] = "사냥꾼 색상"
	L["Hunter:short"] = "사냥꾼"
	L["If this is not your first run please lock or move the frame to prevent this from happening."] = "만약 첫 로딩이 아닐 시 프레임을 잠그거나 혹은 이동하여 불편한 사항이 없도록 하세요."
	L["If this is toggled the frame will grow upwards instead of downwards."] = "프레임을 위로 쌓거나 혹은 아래로 쌓고 싶을 경우 옵션으로 전환할 수 있습니다."
	L["Import layout"] = "레이아웃 가져오기"
	L["Import your layout code."] = "다른 레이아웃 코드를 가져옵니다."
	L["Inverse the cast bar"] = "시전 바의 방향을 반전 시킵니다."
	L["Inverse the health bar"] = "생명력 바를 반전해서 표시합니다."
	L["Inverse the power bar"] = "파워 바를 반전시킵니다."
	L["Invert the dark/bright part of the cooldown spiral"] = "쿨다운 파이의 명암을 반대로 표시합니다."
	L["Layout Code"] = "레이아웃 코드"
	L["Left"] = "왼쪽"
	L["LEFT"] = "좌측"
	L["Lock frame"] = "프레임 잠금"
	L["Low health"] = "낮은 생명력"
	L["LOW HEALTH: %s (%s)"] = "낮은 체력: %s (%s)"
	L["Low health threshold"] = "낮은 생명력 기준"
	L["Mage color"] = "마법사 색상"
	L["Mage:short"] = "법사"
	L["Margin between each button"] = "버튼 사이의 간격을 지정합니다."
	L["Marksmanship"] = "사격"
	L["Marksmanship:short"] = "사격"
	L["maxhealth:shortTag"] = "최대 생명력 (짧은표시)"
	L["maxhealthTag"] = "최대 생명력"
	L["maxpower:shortTag"] = "최대 파워 (짧은표시)"
	L["maxpowerTag"] = "최대 파워"
	L["Middle"] = "중앙"
	L["MikScrollingBattleText"] = "MikScrollingBattleText"
	L["Mistweaver:short"] = "운무"
	L["Modifier"] = "조합키"
	L["Module Templates"] = "모듈 템플릿"
	L["Monk:short"] = "수도사"
	L["Mouse button"] = "마우스 버튼"
	L["Name"] = "이름"
	L["Name of the aura"] = "오라 이름"
	L["Name of the tag"] = "태그 이름"
	L["Name of the text element"] = "문자 요소의 이름"
	L["name:statusTag"] = "유닛 이름/상태"
	L["nameTag"] = "유닛 이름"
	L["New Aura"] = "새로운 오라"
	L["New enemies"] = "새로운 적"
	L["None"] = "없음"
	L["Number of aura icons per column"] = "한 줄에 표시될 오라의 숫자를 설정합니다."
	L["Number of max buffs"] = "표시될 버프의 최대 갯수를 설정합니다."
	L["Number of max Debuffs"] = "최대 디버프 갯수"
	L["Options"] = "설정"
	L["Padding of the background"] = "배경의 범위를 지정합니다."
	L["Paladin color"] = "성기사 색상"
	L["Paladin:short"] = "기사"
	L["Parrot"] = "Parrot"
	L["Party"] = "파티"
	L["Player Focus Target"] = "플레이어 주시 대상"
	L["Player focus target settings"] = "플레이어 주시 대상에 대한 설정"
	L["Player Target"] = "플레이어 대상"
	L["Player target settings"] = "플레이어 대상 설정"
	L["Position"] = "위치"
	L["Position of the cast bar icon"] = "시전 바 아이콘의 위치를 설정합니다."
	L["Position of the class icon"] = "직업 아이콘의 위치값를 설정합니다."
	L["Position of the target bar class icon"] = "대상 바의 아이콘 위치를 설정합니다."
	L["Position of the trinket"] = "계급장 위치를 설정합니다."
	L["Position settings"] = "위치를 설정합니다."
	L["Power Bar Adjust Width"] = "파워 바 너비 조절"
	L["Power Bar Anchor"] = "파워 바 기준점"
	L["Power Bar Attach To"] = "파워 바 위치 기준"
	L["Power Bar Background Color"] = "파워 바 배경 색상"
	L["Power Bar Color"] = "파워 바 색상"
	L["Power Bar Default Color"] = "파워바 기본 색상"
	L["Power Bar Height"] = "파워 바 높이"
	L["Power Bar Inverse"] = "파워 바 반전"
	L["Power Bar Offset X"] = "파워 바 X 단차"
	L["Power Bar Offset Y"] = "파워 바 Y 단차"
	L["Power Bar Relative Point"] = "파워 바 상대 기준점"
	L["Power Bar Texture"] = "파워 바 무늬"
	L["Power Bar Width"] = "파워 바 너비"
	L["Power colors"] = "바 색상"
	L["Power Energy Color"] = "기력 바 색상"
	L["Power Focus Color"] = "집중 바 색상"
	L["Power Mana Color"] = "마나 바 색상"
	L["power:percentageTag"] = "파워 (퍼센트)"
	L["Power Rage Color"] = "분노 바 색상"
	L["Power Runic Power Color"] = "룬마력 바 색상"
	L["power:shortTag"] = "파워 (짧은표시)"
	L["powerTag"] = "파워"
	L["Priest color"] = "사제 색상"
	L["Priest:short"] = "사제"
	L["Priority"] = "중요도"
	L["Priority of the focus target border"] = "주시 대상 테두리에 대한 우선순위를 설정합니다."
	L["Priority of the raid assist border"] = "공대 지원 테두리에 대한 우선순위를 설정합니다."
	L["Priority of the target border"] = "대상 테두리에 대한 우선순위를 설정합니다."
	L["Protection"] = "방어"
	L["Protection:short"] = "보호"
	L["raceTag"] = "유닛 종족"
	L["Raid assist settings"] = "공대 지원 대상 설정"
	L["Raid Assist Target"] = "공대 지원 대상"
	L["Raid Icon target 1 settings"] = "공대 아이콘 대상 1 설정"
	L["Raid Icon target 2 settings"] = "공대 아이콘 대상 2 설정"
	L["Raid Icon target 3 settings"] = "공대 아이콘 대상 3 설정"
	L["Raid Icon target 4 settings"] = "공대 아이콘 대상 4 설정"
	L["Raid Icon target 5 settings"] = "공대 아이콘 대상 5 설정"
	L["Raid Icon target 6 settings"] = "공대 아이콘 대상 6 설정"
	L["Raid Icon target 7 settings"] = "공대 아이콘 대상 7 설정"
	L["Raid Icon target 8 settings"] = "공대 아이콘 대상 8 설정"
	L["Raid Icon Targets"] = "공대 아이콘 대상"
	L["Raid Warning"] = "공격대 경보"
	L["Relative point of the auras"] = "오라 아이콘의 상대 기준점을 설정합니다."
	L["Relative point of the cast bar"] = "시전 바의 상대 기준점을 설정합니다."
	L["Relative point of the class icon"] = "직업 아이콘의 상대 기준점을 설정합니다."
	L["Relative point of the drTracker"] = "점감표시기의 상대 기준점을 설정합니다."
	L["Relative point of the health bar"] = "생명력 바의 상대 기준점을 설정합니다."
	L["Relative point of the power bar"] = "파워 바의 상대 기준점을 설정합니다."
	L["Relative point of the trinket"] = "계급장 상대 기준점을 설정합니다."
	L["Reset Module"] = "모듈 초기화"
	L["Restoration"] = "복원"
	L["Restoration:short"] = "복원"
	L["RESURRECTING: %s (%s)"] = "부활중: %s(%s)"
	L["Resurrection"] = "부활"
	L["Retribution"] = "징벌"
	L["Retribution:short"] = "징벌"
	L["Right"] = "오른쪽"
	L["RIGHT"] = "우측"
	L["Rogue color"] = "도적 색상"
	L["Rogue:short"] = "도적"
	L["Say"] = "말하기"
	L["Scale of the frame"] = "프레임의 크기"
	L["Scrolling Combat Text"] = "Scrolling Combat Text"
	L["Select a modifier for this click action"] = "클릭 액션에 사용할 조정자를 지정합니다."
	L["Select what priority the aura should have - higher equals more priority"] = "오라 중요도 선택 - 높거나/같거나/추가적인 것"
	L["Select what this Click Action does"] = "사용할 클릭 액션을 선택하세요."
	L["Select which mouse button this click action uses"] = "클릭 액션에 사용될 마우스 버튼을 지정합니다."
	L["Self"] = "자신"
	L["Shadow"] = "암흑"
	L["Shadow:short"] = "암흑"
	L["Shaman color"] = "주술사 색상\""
	L["Shaman:short"] = "술사"
	L["shift-"] = "shift-"
	L["Show border around player target"] = "플레이어 대상에 테두리를 써서 강조합니다."
	L["Show border around raid assist"] = "공대 지원 대상 테두리를 표시합니다."
	L["Show important auras instead of the class icon"] = "직업 아이콘 대신 중요한 오라를 표시합니다."
	L["Size"] = "크기"
	L["Size of the class icon"] = "직업 아이콘의 크기를 설정합니다."
	L["Size of the drTracker"] = "점감표시기의 크기를 조절합니다."
	L["Size of the trinket"] = "계급장의 크기를 설정합니다."
	L["Size settings"] = "크기를 설정합니다."
	L["Space between the icons"] = "아이콘 간의 간격 영역"
	L["SPEC DETECTED: %s (%s)"] = "특성 탐색: %s (%s)"
	L["Spec Detection"] = "스펙 감지"
	L["specTag"] = "유닛 스펙"
	L["Spell Name / Macro Text"] = "주문 명 / 매크로 내용"
	L["%s - %s"] = "%s - %s"
	L["Subtlety:short"] = "잠행"
	L["Subtlety"] = "잠행"
	L["Survival"] = "생존"
	L["Survival:short"] = "생존"
	L["Tag"] = "태그"
	L["Tags"] = "태그"
	L["Tag: %s"] = "태그: %s"
	L["Tag settings"] = "태그 설정"
	L["Target bar adjust width"] = "대상바 너비 조절"
	L["Target Bar Anchor"] = "대상바 기준점"
	L["Target Bar Attach To"] = "대상 바 위치 기준"
	L["Target bar background color"] = "대상 바 배경 색상"
	L["Target bar class color"] = "대상 바 직업별 색상"
	L["Target bar class icon"] = "대상 바 직업 아이콘"
	L["Target bar color"] = "대상 바 색상"
	L["Target bar health bar"] = "대상 생명력 바"
	L["Target bar height"] = "대상 바 높이"
	L["Target Bar Icon Crop Borders"] = "대상 바 아이콘 테두리 제거\""
	L["Target bar icon position"] = "대상 바 아이콘 위치"
	L["Target bar inverse"] = "대상 바 반전"
	L["Target bar offset X"] = "대상 바 X 단차"
	L["Target bar offset Y"] = "대상 바 Y 단차"
	L["Target Bar Relative Point"] = "대상바 상대 기준점"
	L["Target bar texture"] = "대상 바 무늬"
	L["Target bar width"] = "대상 바 너비"
	L["Text"] = "텍스트"
	L["Text Align"] = "문자 정렬 기준"
	L["Text align of the cast text"] = "시전 문자의 정렬 방향을 지정합니다."
	L["Text align of the cast time text"] = "시전 시간 문자의 정렬 방향을 지정합니다."
	L["Text align of the text"] = "문자 정렬 기준을 설정합니다."
	L["Text Attach To"] = "문자 기준 위치"
	L["Text Color"] = "문자 색상"
	L["Text color of the cast text"] = "시전 문자의 문자 색을 지정합니다."
	L["Text color of the cast time text"] = "시전 시간 문자의 색상을 설정합니다."
	L["Text color of the DR text"] = "점감 문자 색상을 설정합니다."
	L["Text color of the text"] = "문자의 색상을 설정합니다."
	L["Text Offset X"] = "문자 X 단차"
	L["Text Offset Y"] = "문자 Y 단차"
	L["Texts"] = "문자"
	L["Text settings"] = "텍스트 설정"
	L["Text Size"] = "문자 크기"
	L["Text size of the cast text"] = "시전 문자의 크기를 설정합니다."
	L["Text size of the cast time text"] = "시전 시간 문자의 크기를 설정합니다."
	L["Text size of the DR text"] = "점감 문자의 크기를 설정합니다."
	L["Text size of the power info text"] = "각 자원(마나 기력 등)을 표시할 문자의 크기를 설정합니다."
	L["Text size of the text"] = "문자의 크기를 설정합니다."
	L["Text size of the timer when timeleft is greater than 60 seconds."] = "타이머 종료 60초 이상의 타이머 문자 크기를 설정합니다."
	L["Text size of the timer when timeleft is less than 5 seconds."] = "타이머 종료 5초 전의 타이머 문자 크기를 설정합니다."
	L["Text size of the timer when timeleft is less than 60 seconds."] = "타이머 종료 60초 전의 타이머 문자 크기를 설정합니다."
	L["Text to be displayed"] = "표시된 문자"
	L["Texture of the cast bar"] = "시전 바의 무늬를 설정합니다."
	L["Texture of the health bar"] = "생명력 바의 무늬를 설정합니다."
	L["Texture of the power bar"] = "파워 바의 무늬를 설정합니다."
	L["The timer module will use OmniCC for text display"] = "문자 표시를 위해 OmniCC를 사용한 타이머 모듈을 사용합니다."
	L["Timer Minutes Color"] = "타이머 분 색상"
	L["Timer Minutes Size"] = "타이머 2차 색상"
	L["Timer Seconds Color"] = "타이머 초 색상"
	L["Timer Seconds Size"] = "타이머 초 색상"
	L["Timer Soon Color"] = "시간 임박 색상"
	L["Timer Soon Size"] = "시간 임박 크기"
	L["Timer Use OmniCC"] = "OmniCC 타이머 사용"
	L["Toggle advanced options"] = "확장 설정으로 전환"
	L["Toggle aura buffs"] = "오라 버프를 토글합니다."
	L["Toggle aura debuffs"] = "디버프 오라를 토글합니다."
	L["Toggle cast text"] = "시전 문자 토글"
	L["Toggle cast time text"] = "시전 시간 문자를 토글합니다."
	L["Toggle default death knight color"] = "기본 죽음의기사 색상을 토글합니다."
	L["Toggle default druid color"] = "기본 드루이드 색상을 토글합니다."
	L["Toggle default eogue color"] = "기본 도적 색상을 토글합니다."
	L["Toggle default hunter color"] = "기본 사냥꾼 색상을 토글합니다."
	L["Toggle default mage color"] = "기본 마법사 색상을 토글합니다."
	L["Toggle default paladin color"] = "기본 성기사 색상을 토글합니다."
	L["Toggle default power energy color"] = "기본 기력 바 색상을 토글합니다."
	L["Toggle default power focus color"] = "기본 집중 바 색상을 토글합니다."
	L["Toggle default power mana color"] = "기본 마나 바 색상을 토글합니다."
	L["Toggle default power rage color"] = "기본 분노 바 색상을 토글합니다."
	L["Toggle default power runic power color"] = "기본 룬마력 바 색상을 토글합니다."
	L["Toggle default priest color"] = "기본 사제 색상을 토글합니다."
	L["Toggle default shaman color"] = "기본 주술사 색상을 토글합니다."
	L["Toggle default warlock color"] = "기본 흑마법사 색상을 토글합니다."
	L["Toggle default warrior color"] = "기본 전사 색상을 토글합니다."
	L["Toggle gloss on the auras icon"] = "오라 아이콘에 유리창 형태의 글래스를 씌울지를 토글합니다."
	L["Toggle gloss on the class icon"] = "직업 아이콘에 유리창 형태의 무늬를 추가로 표시합니다."
	L["Toggle gloss on the drTracker icon"] = "점감표시기 가이콘에 유리창 형태를 표시할 지를 토글합니다."
	L["Toggle gloss on the trinket icon"] = "계급장 아이콘에 글래스를 토글합니다."
	L["Toggle health bar class color"] = "생명력 바에 직업별 색상을 적용할 지를 토글합니다."
	L["Toggle health bar display"] = "생명력 바를 토글합니다."
	L["Toggle if the borders of the trinket icon should be cropped"] = "계급장 아이콘의 테두리를 제거하여 좀더 크게 보여줍니다."
	L["Toggle if the class icon borders should be cropped or not."] = "토글 하면 직업아이콘의 테두리를 제거해 좀더 크게 표시합니다."
	L["Toggle if the frame can be moved"] = "프레임을 움직일 수 있다면 토글기능을 켭니다."
	L["Toggle if the target bar icon borders should be cropped or not."] = "대상 바의 아이콘 테두리를 제거하여 좀더 크게 보이도록 합니다."
	L["Toggle if the trinket icon should be changing based on the opponents faction"] = "해당 진영에 알맞는 계급장 아이콘을 표시합니다."
	L["Toggle if you want to use the global font size"] = "만약 토글하게 되면 설정한 공통 글꼴 크기를 적용합니다."
	L["Toggle power bar default color"] = "파워 바 기본 색상을 토글합니다."
	L["Toggle the cast icon"] = "시전 바의 아이콘을 토글합니다."
	L["Toggle the target bar class icon"] = "대상 바의 직업 아이콘을 토글합니다."
	L["Toggle trinket grid style icon"] = "계급장을 Grid 스타일 아이콘으로 표시합니다."
	L["Top Left"] = "좌측 상단"
	L["Top Right"] = "우측 상단"
	L["Trinket"] = "PvP 장신구 상태 보기"
	L["Trinket Adjust Size"] = "계급장 크기 조절"
	L["Trinket Anchor"] = "계급장 기준점"
	L["Trinket Attach To"] = "계급장 위치 기준"
	L["Trinket Cooldown Reverse"] = "계급장 쿨다운 파이 반전"
	L["Trinket Cooldown Spiral"] = "계급장 쿨다운 파이"
	L["Trinket Frame Level"] = "계급장 프레임 깊이"
	L["Trinket Gloss"] = "계급장 글래스"
	L["Trinket Gloss Color"] = "계급장 글래스 색상"
	L["Trinket Grid Style Icon"] = "계급장 Grid 스타일 아이콘"
	L["Trinket Grid Style Icon Color"] = "계급장 Grid 스타일 아이콘 색상"
	L["Trinket Grid Style Icon Used Color"] = "사용된 계급장 Grid 스타일 아이콘 색상"
	L["Trinket Icon Border Crop"] = "계급장 테두리 제거"
	L["Trinket Icon Faction"] = "진영별 계급장 아이콘"
	L["Trinket Offset X"] = "계급장 X 단차"
	L["Trinket Offset Y"] = "계급장 Y 단차"
	L["Trinket Position"] = "계급장 위치"
	L["TRINKET READY: %s (%s)"] = "장신구 준비완료: %s (%s)"
	L["Trinket Relative Point"] = "계급장 상대 기준점"
	L["Trinket Size"] = "계급장 크기"
	L["TRINKET USED: %s (%s)"] = "장신구 사용: %s (%s)"
	L["Unholy"] = "부정"
	L["Unholy:short"] = "부정"
	L["Up Left"] = "좌측 상단"
	L["Up Right"] = "우측 상단"
	L["Use Global Font Size"] = "공통 글꼴 크기 사용"
	L["Valid slash commands are:"] = "명령어는 다음과 같습니다.:"
	L["Vertical spacing of the auras"] = "오라의 수직 간격을 설정합니다."
	L["Warlock color"] = "흑마법사 색상"
	L["Warlock:short"] = "흑마"
	L["Warrior color"] = "전사 색상"
	L["Warrior:short"] = "전사"
	L["Welcome to Gladius!"] = "환영합니다. Gladius 입니다!"
	L["Whitelist"] = "추가항목"
	L["Widget"] = "위젯"
	L["Widget settings"] = "위젯 셋팅"
	L["Width of the aura icons"] = "오라 아이콘의 너비를 설정합니다."
	L["Width of the cast bar"] = "시전 바의 너비를 설정합니다."
	L["Width of the health bar"] = "생명력 바의 너비를 설정합니다."
	L["Width of the module bars"] = "바 모듈의 너비를 설정합니다."
	L["Width of the power bar"] = "파워 바의 너비를 설정합니다."
	L["Windwalker:short"] = "풍운"
	L["X offset of the auras"] = "오라 아이콘의 X 좌표 단차값을 설정합니다."
	L["X offset of the cast bar"] = "시전 바의 X 좌표 단차를 설정합니다."
	L["X offset of the cast text"] = "시전 문자의 X 좌표 단차를 설정합니다."
	L["X Offset of the cast time text"] = "시전 시간 문자의 X 좌표 단차를 설정합니다."
	L["X offset of the class icon"] = "직업 아이콘의 X 좌표 단차를 설정합니다."
	L["X offset of the drTracker"] = "점감표시기의 X 좌표 단차를 설정합니다."
	L["X offset of the health bar"] = "생명력 바의 X 좌표 단차를 설정합니다."
	L["X offset of the power bar"] = "파워 바의 X 좌표 단차를 설정합니다."
	L["X offset of the text"] = "문자의 X 좌표 단차를 설정합니다."
	L["X offset of the trinket"] = "계급장 X 좌표 단차를 설정합니다."
	L["Y offset of the auras"] = "오라 아이콘의 Y 좌표 단차값을 설정합니다."
	L["Y offset of the castbar"] = "시전 바의 Y 좌표 단차를 설정합니다."
	L["Y offset of the cast text"] = "시전 문자의 Y 좌표 단차를 설정합니다."
	L["Y Offset of the cast time text"] = "시전 시간 문자의 Y 좌표 단차를 설정합니다."
	L["Y offset of the class icon"] = "직업 아이콘의 Y 좌표 단차를 설정합니다."
	L["Y offset of the drTracker"] = "점감표시기의 Y 좌표 단차를 설정합니다."
	L["Y offset of the health bar"] = "생명력 바의 Y 좌표 단차를 설정합니다."
	L["Y offset of the text"] = "문자의 Y 좌표 단차를 설정합니다."
	L["Y offset of the trinket"] = "계급장 Y 좌표 단차를 설정합니다."
elseif locale == "ptBR" then
	L["Action"] = "Ação"
	L["Add"] = "Adicionar"
	L["Auras"] = "Auras"
	L["Bar settings"] = "Configuraçoes de Barras"
	L["Bar width"] = "Largura da Barra"
	L["Blizzard's Floating Combat Text"] = "Texto de combate flutuante da Blizzard"
	L["Button 4"] = "Botão 4"
	L["Button 5"] = "Botão 5"
	L["Cast Spell"] = "Lançar feitiço"
	L["Color of the cast bar"] = "Cor da barra de cast"
	L["Delete"] = "Apagar"
	L["Drinking"] = "Beber"
	L["DRINKING: %s (%s)"] = "Bebida: %s (%s)"
	L["Frame scale"] = "Escala do quadro"
	L["General"] = "Geral"
	L["General settings"] = "Configurações Gerais"
	L["/gladius ui"] = "/gladius ui"
	L["Grow frame upwards"] = "Crescer quadros para cima"
	L["Health bar height"] = "Altura da barra de vida"
	L["If this is not your first run please lock or move the frame to prevent this from happening."] = "Se esta não é sua primeira execução por favor bloquear ou mover o quadro para evitar que isso aconteça."
	L["If this is toggled the frame will grow upwards instead of downwards."] = "Se alternado o quadro vai crescer para cima em vez de para baixo."
	L["Lock frame"] = "Bloquear quadro"
	L["MikScrollingBattleText"] = "MikScrollingBattleText"
	L["Modifier"] = "Modificador"
	L["Name"] = "Nome"
	L["Name of the aura"] = "Nome da aura"
	L["None"] = "Nenhum"
	L["Party"] = "Grupo"
	L["Priority"] = "Prioridade"
	L["Raid Warning"] = "Aviso de Raide"
	L["Scale of the frame"] = "Tamanho do quadro"
	L["Scrolling Combat Text"] = "Rolagem do texto combate "
	L["Select what priority the aura should have - higher equals more priority"] = "Prioridade"
	L["Text"] = "Texto"
	L["Trinket"] = "Berloque"
elseif locale == "ruRU" then
	L["Action"] = "Действие"
	L["Add"] = "Добавить"
	L["Add new Aura"] = "Добавить новую ауру"
	L["Add Tag"] = "Добавить метку"
	L["Add text"] = "Добавить текст"
	L["Add Text"] = "Добавить текст"
	L["Adjust cast bar width to the frame width"] = "Полоса заклинаний под ширину фрейма"
	L["Adjust class icon size to the frame size"] = "Классовая иконка под размер фрейма"
	L["Affliction"] = "Колдовство"
	L["Affliction:short"] = "Колдов"
	L["Announces when an enemy drops below a certain health threshold."] = "Объявляет, когда здоровье противника падает ниже определенного порога."
	L["Announces when an enemy tries to resurrect a teammate."] = "Объявляет, когда противник пытается возродить товарища по команде."
	L["Announces when an enemy uses a PvP trinket."] = "Объявляет, когда противник использует ПВП аксессуар."
	L["Announces when new enemies are discovered."] = "Объявляет, если будут обнаружены новые противники."
	L["Announces when the spec of an enemy was detected."] = "Объявляет, когда была обнаружена специализация противника."
	L["Arcane"] = "Тайная магия"
	L["Arcane:short"] = "Тайнм"
	L["Arms"] = "Оружие"
	L["Arms:short"] = "Оружие"
	L["Assassination"] = "Ликвидация"
	L["Assassination:short"] = "Скрытн"
	L["Attach trinket to the given frame"] = "Прикрепить иконку аксессуара к данному фрейму"
	L["Auras"] = "Ауры"
	L["Balance"] = "Баланс"
	L["Balance:short"] = "Баланс"
	L["Bar settings"] = "Настройки полос"
	L["Bar width"] = "Ширина полос"
	L["Beast Mastery"] = "Повелитель зверей"
	L["Beast Mastery:short"] = "Повзвер"
	L["Blizzard's Floating Combat Text"] = "Плавающий текст боя Близзард"
	L["Blood"] = "Кровь"
	L["Blood:short"] = "Кровь"
	L["Brewmaster:short"] = "Хмел"
	L["Button 4"] = "Кнопка 4"
	L["Button 5"] = "Кнопка 5"
	L["Cast Spell"] = "Применение заклинания"
	L["Class Icon Gloss Color"] = "Цвет свечения иконки класса"
	L["Class Icon Important Auras"] = "Важные ауры на иконке класса"
	L["Class Icon Position"] = "Позиция иконки класса"
	L["Class Icon Size"] = "Размер иконки класса"
	L["classTag"] = "Класс"
	L["Color of the cast bar"] = "Цвет полосы применения заклинания"
	L["Color of the cast bar background"] = "Цвет фона полосы заклинаний"
	L["Color of the health bar"] = "Цвет полосы здоровья"
	L["Combat"] = "Бой"
	L["Combat:short"] = "Бой"
	L["Death Knight:short"] = "Рыцсм"
	L["Delete"] = "Удалить"
	L["Demonology"] = "Демонология"
	L["Demonology:short"] = "Демо"
	L["Destruction"] = "Разрушение"
	L["Destruction:short"] = "Разруш"
	L["Discipline"] = "Послушание"
	L["Discipline:short"] = "Послуш"
	L["Drinking"] = "Питьё"
	L["DRINKING: %s (%s)"] = "ОТПИВАЕТСЯ: %s (%s)"
	L["Druid:short"] = "Друид"
	L["Elemental"] = "Стихии"
	L["Elemental:short"] = "Стихии"
	L["Enhancement"] = "Совершенствование"
	L["Enhancement:short"] = "Соверш"
	L["Feral"] = "Сила зверя"
	L["Feral:short"] = "Силазв"
	L["Fire"] = "Огонь"
	L["Fire:short"] = "Огонь"
	L["Frame scale"] = "Масштаб фрейма"
	L["Frost"] = "Лед"
	L["Frost:short"] = "Лёд"
	L["Fury"] = "Неистовство"
	L["Fury:short"] = "Неист"
	L["General"] = "Общие"
	L["General settings"] = "Общие настройки"
	L["/gladius hide"] = "/gladius hide"
	L["/gladius reset"] = "/gladius reset"
	L["/gladius test 2-5"] = "/gladius test 2-5"
	L["/gladius ui"] = "/gladius ui"
	L["Grow frame upwards"] = "Рост фрейма вверх"
	L["Health bar background color"] = "Цвет фона полосы здоровья"
	L["Health bar class color"] = "Цвет полосы здоровья"
	L["Health bar color"] = "Цвет полосы здоровья"
	L["Health bar height"] = "Высота полосы здоровья"
	L["Health bar inverse"] = "Отразить полосу здоровья"
	L["Health bar texture"] = "Текстура полосы здоровья"
	L["Health colors"] = "Цвета здоровья"
	L["health:percentageTag"] = "Здоровье (В процентах)"
	L["health:shortTag"] = "Здоровье (Кратко)"
	L["healthTag"] = "Здоровье"
	L["Height of the aura icon"] = "Ширина иконки аур"
	L["Height of the cast bar"] = "Ширина полосы заклинаний"
	L["Height of the health bar"] = "Ширина полосы здоровья"
	L["Height of the power bar"] = "Ширина полосы ресурса"
	L["Holy"] = "Свет"
	L["Holy:short"] = "Свет"
	L["Hunter:short"] = "Охотн"
	L["If this is not your first run please lock or move the frame to prevent this from happening."] = "Если это не первый ваш запуск, пожалуйста, заблокируйте или переместите фрейм, чтобы этого не происходило."
	L["If this is toggled the frame will grow upwards instead of downwards."] = "Если включено, фрейм будет расти вверх, а не вниз."
	L["Left"] = "Лево"
	L["Lock frame"] = "Закрепить фрейм"
	L["Mage:short"] = "Маг"
	L["Marksmanship"] = "Стрельба"
	L["Marksmanship:short"] = "Стрел"
	L["maxhealth:shortTag"] = "Всего здоровья (Кратко)"
	L["maxhealthTag"] = "Всего здоровья"
	L["maxpower:shortTag"] = "Всего ресурса (Кратко)"
	L["maxpowerTag"] = "Всего ресурса"
	L["MikScrollingBattleText"] = "MikScrollingBattleText"
	L["Mistweaver:short"] = "Ткачт"
	L["Modifier"] = "Модификатор"
	L["Monk:short"] = "Монах"
	L["Name"] = "Название"
	L["Name of the aura"] = "Название ауры"
	L["name:statusTag"] = "Имя юнита/статус"
	L["nameTag"] = "Имя"
	L["New enemies"] = "Новые вражеские игроки"
	L["None"] = "Не назначено"
	L["Paladin:short"] = "Пал"
	L["Parrot"] = "Попугай"
	L["Party"] = "Группа"
	L["Power Bar Texture"] = "Текстура полосы ресурсов"
	L["Power Bar Width"] = "Ширина полосы ресурсов"
	L["power:percentageTag"] = "Ресурс (В процентах)"
	L["power:shortTag"] = "Ресурс (Кратко)"
	L["powerTag"] = "Ресурс"
	L["Priest:short"] = "Жрец"
	L["Priority"] = "Приоритет"
	L["Protection"] = "Защита"
	L["Protection:short"] = "Защ"
	L["raceTag"] = "Раса"
	L["Raid Warning"] = "Объявление рейду"
	L["Restoration"] = "Исцеление"
	L["Restoration:short"] = "Исц"
	L["RESURRECTING: %s (%s)"] = "ВОСКРЕШАЕТ: %s (%s)"
	L["Retribution"] = "Воздаяние"
	L["Retribution:short"] = "Возд"
	L["Right"] = "Право"
	L["Rogue:short"] = "Разб"
	L["Say"] = "Сказать"
	L["Scale of the frame"] = "Масштаб фрейма"
	L["Scrolling Combat Text"] = "Scrolling Combat Text"
	L["Select what priority the aura should have - higher equals more priority"] = "Выбрать приоритет ауры – более высокое значение означает более высокий приоритет"
	L["Self"] = "Себя"
	L["Shadow"] = "Тьма"
	L["Shadow:short"] = "Тьма"
	L["Shaman:short"] = "Шаман"
	L["Size of the trinket"] = "Размер иконки аксессуара"
	L["specTag"] = "Специализация"
	L["%s - %s"] = "%s - %s"
	L["Subtlety"] = "Скрытность"
	L["Survival"] = "Выживание"
	L["Survival:short"] = "Выж"
	L["Text"] = "Текст"
	L["Text settings"] = "Настройки текста"
	L["Timer Use OmniCC"] = "Использовать OmniCC для таймера"
	L["Toggle advanced options"] = "Включить расширенные настройки"
	L["Toggle cast text"] = "Отображать текст каста"
	L["Toggle cast time text"] = "Отображать время каста"
	L["Toggle default death knight color"] = "Использовать стандартный цвет рыцаря смерти"
	L["Toggle default druid color"] = "Использовать стандартный цвет друида"
	L["Toggle default eogue color"] = "Использовать стандартный цвет разбойника"
	L["Toggle default hunter color"] = "Использовать стандартный цвет охотника"
	L["Toggle default mage color"] = "Использовать стандартный цвет мага"
	L["Toggle default paladin color"] = "Использовать стандартный цвет паладина"
	L["Toggle default power energy color"] = "Использовать стандартный цвет энергии"
	L["Toggle default power focus color"] = "Использовать стандартный цвет концентрации"
	L["Toggle default power mana color"] = "Использовать стандартный цвет маны"
	L["Toggle default power rage color"] = "Использовать стандартный цвет ярости"
	L["Toggle default power runic power color"] = "Использовать стандартный цвет силы рун"
	L["Toggle default priest color"] = "Использовать стандартный цвет приста"
	L["Toggle default shaman color"] = "Использовать стандартный цвет шамана"
	L["Toggle default warlock color"] = "Использовать стандартный цвет чернокнижника"
	L["Toggle default warrior color"] = "Использовать стандартный цвет война"
	L["Toggle health bar class color"] = "Полоса здоровья под цвет класса"
	L["Toggle health bar display"] = "Включить отображение полосы здоровья"
	L["Toggle if the frame can be moved"] = "Включить перемещение фрейма"
	L["Toggle if the trinket icon should be changing based on the opponents faction"] = "Выбра"
	L["Top Left"] = "Сверху слева"
	L["Trinket"] = "Аксессуар"
	L["TRINKET READY: %s (%s)"] = "АКСЕССУАР ГОТОВ: %s (%s)"
	L["TRINKET USED: %s (%s)"] = "%s (%s) ИСПОЛЬЗОВАЛ АКСЕССУАР"
	L["Unholy"] = "Нечестивость"
	L["Unholy:short"] = "Неч"
	L["Valid slash commands are:"] = "Правильные слеш-команды:"
	L["Warlock:short"] = "Чернкн"
	L["Warrior:short"] = "Воин"
	L["Welcome to Gladius!"] = "Вас приветствует Gladius!"
	L["Widget settings"] = "Настройки виджета"
	L["Windwalker:short"] = "Танцсв"
elseif locale == "zhCN" then
	L["Frame"] = "框体"
	L["Welcome to Gladius!"] = "欢迎使用Gladius!"
	L["First run has been detected displaying test frame."] = "侦测到为第一次使用，显示测试框架。"
	L["Valid slash commands are:"] = "有效命令:"
	L["/gladius ui"] = "/gladius ui"
	L["/gladius test 2-5"] = "/gladius test 2-5"
	L["/gladius hide"] = "/gladius hide"
	L["/gladius reset"] = "/gladius reset"
	L["If this is not your first run please lock or move the frame to prevent this from happening."] = "如果您不是第一次使用，请锁定或者移动此框架以防止这类情况发生。"
	L["LEFT"] = "左"
	L["CENTER"] = "中"
	L["RIGHT"] = "右"
	L["Top Left"] = "左上"
	L["Top Right"] = "右上"
	L["Center Left"] = "左中"
	L["Center Right"] = "右中"
	L["Bottom Left"] = "左下"
	L["Bottom Right"] = "右下"
	L["Enable Module"] = "启用模块"
	L["Reset Module"] = "重置模块"
	L["Module Templates"] = "模块的样板"
	L["General"] = "一般"
	L["General settings"] = "一般设定"
	L["Lock frame"] = "锁定框架"
	L["Toggle if the frame can be moved"] = "勾选后框架就不能被移动了"
	L["Grow frame upwards"] = "框架向上延伸"
	L["If this is toggled the frame will grow upwards instead of downwards."] = "勾选后框架将向上延伸而不是向下。"
	L["Group Buttons"] = "队伍按钮"
	L["Advanced Options"] = "进阶选项"
	L["Toggle advanced options"] = "切换进阶选项"
	L["Frame settings"] = "框架设定"
	L["Background Color"] = "背景颜色"
	L["Color of the frame background"] = "框架背景的颜色"
	L["Background Padding"] = "背景间距"
	L["Padding of the background"] = "背景的间距"
	L["Bottom Margin"] = "按钮间隔"
	L["Margin between each button"] = "按钮的间隔"
	L["Size"] = "大小"
	L["Size settings"] = "大小设定"
	L["Bar width"] = "状态条宽"
	L["Width of the module bars"] = "模块状态条的宽度"
	L["Frame scale"] = "框架比例"
	L["Scale of the frame"] = "框架的比例"
	L["Font"] = "字型"
	L["Font settings"] = "字型设定"
	L["Global Font"] = "整体字型"
	L["Global font used by the modules"] = "使用于模块的整体字型"
	L["Global Font Size"] = "整体字号"
	L["Text size of the power info text"] = "能量条信息文字的大小"
	L["Use Global Font Size"] = "使用整体字号"
	L["Toggle if you want to use the global font size"] = "勾选后将使用整体字号"
	L["Arms"] = "武器"
	L["Fury"] = "狂怒"
	L["Protection"] = "防护"
	L["Holy"] = "神圣"
	L["Retribution"] = "惩戒"
	L["Assassination"] = "刺杀"
	L["Combat"] = "战斗"
	L["Subtlety"] = "敏锐"
	L["Discipline"] = "戒律"
	L["Shadow"] = "暗影"
	L["Blood"] = "血魄"
	L["Frost"] = "冰霜"
	L["Unholy"] = "邪恶"
	L["Arcane"] = "奥术"
	L["Fire"] = "火焰"
	L["Affliction"] = "痛苦"
	L["Demonology"] = "恶魔"
	L["Destruction"] = "毁灭"
	L["Elemental"] = "元素"
	L["Enhancement"] = "增强"
	L["Restoration"] = "恢复"
	L["Beast Mastery"] = "野兽控制"
	L["Marksmanship"] = "射击"
	L["Survival"] = "生存"
	L["Balance"] = "平衡"
	L["Feral"] = "野性"
	L["%s - %s"] = "%s - %s"
	L["SPEC DETECTED: %s (%s)"] = "侦测到天赋: %s (%s)"
	L["LOW HEALTH: %s (%s)"] = "低生命值: %s (%s)"
	L["DRINKING: %s (%s)"] = "喝水: %s (%s)"
	L["RESURRECTING: %s (%s)"] = "复活中: %s (%s)"
	L["Self"] = "自己"
	L["Party"] = "队伍"
	L["Say"] = "说"
	L["Raid Warning"] = "团队警告"
	L["Scrolling Combat Text"] = "滚动战斗信息"
	L["MikScrollingBattleText"] = "插件MikScrollingBattleText"
	L["Blizzard's Floating Combat Text"] = "暴雪的浮动战斗信息"
	L["Parrot"] = "插件Parrot"
	L["Options"] = "选项"
	L["Destination"] = "通知方式"
	L["Choose how your announcements are displayed."] = "选择您想要的显示通知告方式。"
	L["Low health threshold"] = "低生命值阀值"
	L["Choose how low an enemy must be before low health is announced."] = "选择敌人低于多少生命值时通告。"
	L["Announcement toggles"] = "切换通知"
	L["New enemies"] = "新敌人"
	L["Announces when new enemies are discovered."] = "当发现新敌人时通告。"
	L["Drinking"] = "喝水"
	L["Announces when enemies sit down to drink."] = "当敌人坐下喝水时通告。"
	L["Low health"] = "低生命值"
	L["Announces when an enemy drops below a certain health threshold."] = "当敌人的生命值低于设置的阀值时通知。"
	L["Resurrection"] = "复活"
	L["Announces when an enemy tries to resurrect a teammate."] = "当敌人试图复活队友时通告。"
	L["Spec Detection"] = "侦测天赋"
	L["Announces when the spec of an enemy was detected."] = "当侦测到敌人的天赋时通告。"
	L["Buffs"] = "增益"
	L["Widget"] = "小工具"
	L["Widget settings"] = "小工具设定"
	L["Auras Buffs"] = "增益光环"
	L["Toggle aura buffs"] = "切换增益光环"
	L["Auras Column Grow"] = "光环列延伸"
	L["Grow direction of the auras"] = "光环的延伸方向"
	L["Up Left"] = "左上"
	L["Up Right"] = "右上"
	L["Down Left"] = "左下"
	L["Down Right"] = "右下"
	L["Aura Icons Per Column"] = "每列光环图示"
	L["Number of aura icons per column"] = "每列光环图示的数量"
	L["Aura Icons Max"] = "最大光环图示"
	L["Number of max buffs"] = "增益的最大数量"
	L["Auras Gloss"] = "覆盖光环"
	L["Toggle gloss on the auras icon"] = "选择覆盖的光环图示"
	L["Auras Gloss Color"] = "覆盖光环颜色"
	L["Color of the auras icon gloss"] = "覆盖光环图示的颜色"
	L["Aura Icon Width"] = "光环图示宽"
	L["Width of the aura icons"] = "光环图示的宽度"
	L["Aura Icon Height"] = "光环图示高"
	L["Height of the aura icon"] = "光环图示的高度"
	L["Auras Spacing Vertical"] = "光环垂直间距"
	L["Vertical spacing of the auras"] = "光环的垂直间距"
	L["Auras Spacing Horizontal"] = "光环水平间距"
	L["Horizontal spacing of the auras"] = "光环的水平间距"
	L["Position"] = "位置"
	L["Position settings"] = "位置设定"
	L["Auras Attach To"] = "光环附加到"
	L["Attach auras to the given frame"] = "附加光环到选定的框架"
	L["Auras Anchor"] = "光环锚点"
	L["Anchor of the auras"] = "光环的锚点"
	L["Auras Relative Point"] = "光环相对定位点"
	L["Relative point of the auras"] = "光环的相对定位点"
	L["Auras Offset X"] = "光环位移 X"
	L["X offset of the auras"] = "光环的位移 X"
	L["Auras Offset Y"] = "光环位移 Y"
	L["Y offset of the auras"] = "光环的位移 Y"
	L["Filter"] = "筛选"
	L["Whitelist"] = "白名单"
	L["Blacklist"] = "黑名单"
	L["Filter Function"] = "筛选功能"
	L["Debuffs"] = "减益"
	L["Auras Debuffs"] = "减益光环"
	L["Toggle aura debuffs"] = "切换减益光环"
	L["Number of max Debuffs"] = "减益的最大数量"
	L["Auras"] = "光环"
	L["New Aura"] = "新光环"
	L["Name"] = "名称"
	L["Name of the aura"] = "光环的名称"
	L["Priority"] = "优先级"
	L["Select what priority the aura should have - higher equals more priority"] = "选择光环的优先级，数字越大优先级越高"
	L["Add new Aura"] = "新增新光环"
	L["Delete"] = "删除"
	L["Example Spell Name"] = "法术名称范例"
	L["Bar"] = "状态条"
	L["Bar settings"] = "状态条设定"
	L["Cast Bar Color"] = "施法条颜色"
	L["Color of the cast bar"] = "施法条的颜色"
	L["Cast Bar Background Color"] = "施法条背景颜色"
	L["Color of the cast bar background"] = "施法条背景的颜色"
	L["Cast Bar Inverse"] = "施法条反向"
	L["Inverse the cast bar"] = "施法条反向"
	L["Cast Bar Texture"] = "施法条材质"
	L["Texture of the cast bar"] = "施法条的材质"
	L["Cast Bar Icon"] = "施法条图示"
	L["Toggle the cast icon"] = "切换施法条图示"
	L["Cast Bar Icon Position"] = "施法条图标位置"
	L["Position of the cast bar icon"] = "施法条图标的位置"
	L["Cast Bar Adjust Width"] = "调整施法条宽度"
	L["Adjust cast bar width to the frame width"] = "调整施法条宽跟框架一样宽"
	L["Cast Bar Width"] = "施法条宽"
	L["Width of the cast bar"] = "施法条的宽度"
	L["Cast Bar Height"] = "施法条高"
	L["Height of the cast bar"] = "施法条的高度"
	L["Cast Bar Attach To"] = "施法条附加到"
	L["Attach cast bar to the given frame"] = "附加施法条到选定的框架"
	L["Cast Bar Anchor"] = "施法条锚点"
	L["Anchor of the cast bar"] = "施法条的锚点"
	L["Cast Bar Relative Point"] = "施法条相对定位点"
	L["Relative point of the cast bar"] = "施法条的相对定位点"
	L["Cast Bar Offset X"] = "施法条位移 X"
	L["X offset of the cast bar"] = "施法条的位移 X"
	L["Cast Bar Offset Y"] = "施法条位移 Y"
	L["Y offset of the castbar"] = "施法条的位移 Y"
	L["Cast Text"] = "施法文字"
	L["Text"] = "文字"
	L["Text settings"] = "文字设定"
	L["Toggle cast text"] = "切换施法文字"
	L["Cast Text Color"] = "施法文字颜色"
	L["Text color of the cast text"] = "施法文字的颜色"
	L["Cast Text Size"] = "施法文字大小"
	L["Text size of the cast text"] = "施法文字的大小"
	L["Cast Text Align"] = "施法文字对齐"
	L["Text align of the cast text"] = "施法文字的对齐"
	L["Cast Text Offset X"] = "施法文字位移 X"
	L["X offset of the cast text"] = "施法文字的位移 X"
	L["Cast Text Offset Y"] = "施法文字位移 Y"
	L["Y offset of the cast text"] = "施法文字的位移 Y"
	L["Cast Time Text"] = "施法时间文字"
	L["Toggle cast time text"] = "切换施法时间文字"
	L["Cast Time Text Color"] = "施法时间文字颜色"
	L["Text color of the cast time text"] = "施法时间文字的颜色"
	L["Cast Time Text Size"] = "施法时间文字大小"
	L["Text size of the cast time text"] = "施法时间文字的大小"
	L["Cast Time Text Align"] = "施法时间文字对齐"
	L["Text align of the cast time text"] = "施法时间文字的对齐"
	L["Cast Time Offset X"] = "施法时间文字位移 X"
	L["X Offset of the cast time text"] = "施法时间文字的位移 X"
	L["Cast Time Offset Y"] = "施法时间文字位移 Y"
	L["Y Offset of the cast time text"] = "施法时间文字的位移 Y"
	L["Class Icon Important Auras"] = "职业图示里的重要光环"
	L["Show important auras instead of the class icon"] = "在职业图标里显示重要光环"
	L["Class Icon Crop Borders"] = "裁剪职业图示边框"
	L["Toggle if the class icon borders should be cropped or not."] = "是否需要裁剪职业图示边框。"
	L["Class Icon Cooldown Spiral"] = "职业图示里的冷却倒数"
	L["Display the cooldown spiral for important auras"] = "为重要光环显示冷却倒数"
	L["Class Icon Cooldown Reverse"] = "职业图示里的冷却反转"
	L["Invert the dark/bright part of the cooldown spiral"] = "冷却倒数中的明暗反向"
	L["Class Icon Gloss"] = "覆盖职业图示"
	L["Toggle gloss on the class icon"] = "切换覆盖的职业图示"
	L["Class Icon Gloss Color"] = "覆盖职业图示颜色"
	L["Color of the class icon gloss"] = "覆盖职业图示的颜色"
	L["Class Icon Frame Level"] = "职业图示框架层级"
	L["Frame level of the class icon"] = "职业图示的框架层级"
	L["Class Icon Adjust Size"] = "调整职业图示大小"
	L["Adjust class icon size to the frame size"] = "调整职业图示的大小"
	L["Class Icon Size"] = "职业图示大小"
	L["Size of the class icon"] = "职业图示的大小"
	L["Class Icon Attach To"] = "职业图示附加到"
	L["Attach class icon to given frame"] = "附加职业图示到选定的框架"
	L["Class Icon Position"] = "职业图标位置"
	L["Position of the class icon"] = "职业图标的位置"
	L["Left"] = "左"
	L["Right"] = "右"
	L["Class Icon Anchor"] = "职业图示锚点"
	L["Anchor of the class icon"] = "职业图示的锚点"
	L["Class Icon Relative Point"] = "职业图示相对定位点"
	L["Relative point of the class icon"] = "职业图示的相对定位点"
	L["Class Icon Offset X"] = "职业图示位移 X"
	L["X offset of the class icon"] = "职业图示的位移 X"
	L["Class Icon Offset Y"] = "职业图示位移 Y"
	L["Y offset of the class icon"] = "职业图示的位移 Y"
	L["Middle"] = "中键"
	L["Button 4"] = "按钮 4"
	L["Button 5"] = "按钮 5"
	L["None"] = "无"
	L["ctrl-"] = "ctrl-"
	L["shift-"] = "shift-"
	L["alt-"] = "alt-"
	L["Click Actions"] = "点击执行"
	L["Add click action"] = "新增点击执行"
	L["Mouse button"] = "鼠标按钮"
	L["Select which mouse button this click action uses"] = "选择哪个鼠标按钮来点击执行"
	L["Modifier"] = "附加主键"
	L["Select a modifier for this click action"] = "选择修改此点击执行"
	L["Add"] = "新增"
	L["Delete Click Action"] = "删除点击执行"
	L["Action"] = "执行"
	L["Select what this Click Action does"] = "选择点击执行该做甚么指令"
	L["Cast Spell"] = "施放法术"
	L["Spell Name / Macro Text"] = "法术名称 / 宏指令"
	L["DRTracker Space"] = "控场追踪间隔"
	L["Space between the icons"] = "图示之间的间隔"
	L["DRTracker Cooldown Spiral"] = "控场追踪冷却倒数"
	L["DRTracker Cooldown Reverse"] = "控场追踪冷却反转"
	L["DRTracker Gloss"] = "覆盖控场追踪"
	L["Toggle gloss on the drTracker icon"] = "切换覆盖控场追踪图示"
	L["DRTracker Gloss Color"] = "覆盖控场追踪颜色"
	L["Color of the drTracker icon gloss"] = "覆盖控场追踪的颜色"
	L["DRTracker Frame Level"] = "控场追踪框架层级"
	L["Frame level of the drTracker"] = "控场追踪框架的层级"
	L["DRTracker Adjust Size"] = "调整控场追踪大小"
	L["Adjust drTracker size to the frame size"] = "调整控场追踪大小跟框架一样大"
	L["DRTracker Size"] = "控场追踪大小"
	L["Size of the drTracker"] = "控场追踪的大小"
	L["DR Text Color"] = "控场文字颜色"
	L["Text color of the DR text"] = "控场文字的颜色"
	L["DR Text Size"] = "控场文字大小"
	L["Text size of the DR text"] = "控场文字的大小"
	L["DRTracker Attach To"] = "控场追踪附加到"
	L["Attach drTracker to the given frame"] = "附加控场追踪到选定的框架"
	L["DRTracker Position"] = "控场追踪位置"
	L["DRTracker Anchor"] = "控场追踪锚点"
	L["Anchor of the drTracker"] = "控场追踪的锚点"
	L["DRTracker Relative Point"] = "控场追踪相对定位点"
	L["Relative point of the drTracker"] = "控场追踪的相对定位点"
	L["DRTracker Offset X"] = "控场追踪位移 X"
	L["X offset of the drTracker"] = "控场追踪的位移 X"
	L["DRTracker Offset Y"] = "控场追踪位移 Y"
	L["Y offset of the drTracker"] = "控场追踪的位移 Y"
	L["Categories"] = "类别"
	L["Category settings"] = "类别设定"
	L["Health bar class color"] = "生命条职业颜色"
	L["Toggle health bar class color"] = "切换生命条的职业颜色"
	L["Health bar color"] = "生命条颜色"
	L["Color of the health bar"] = "生命条的颜色"
	L["Health bar background color"] = "生命条背景颜色"
	L["Color of the health bar background"] = "生命条背景的颜色"
	L["Health bar inverse"] = "生命条反向"
	L["Inverse the health bar"] = "生命条的反向"
	L["Health bar texture"] = "生命条材质"
	L["Texture of the health bar"] = "生命条的材质"
	L["Health bar adjust width"] = "调整生命条宽"
	L["Adjust health bar width to the frame width"] = "调整生命条宽跟框架一样宽"
	L["Health bar width"] = "生命条宽"
	L["Width of the health bar"] = "生命条的宽度"
	L["Health bar height"] = "生命条高"
	L["Height of the health bar"] = "生命条的高度"
	L["Health Bar Attach To"] = "生命条附加到"
	L["Attach health bar to the given frame"] = "附加生命条到选定的框架"
	L["Health Bar Anchor"] = "生命条锚点"
	L["Anchor of the health bar"] = "生命条的锚点"
	L["Health Bar Relative Point"] = "生命条相对定位点"
	L["Relative point of the health bar"] = "生命条的相对定位点"
	L["Health bar offset X"] = "生命条位移 X"
	L["X offset of the health bar"] = "生命条的位移 X"
	L["Health bar offset Y"] = "生命条位移 Y"
	L["Y offset of the health bar"] = "生命条的位移 Y"
	L["Health colors"] = "生命条颜色"
	L["Default priest color"] = "预设的牧师颜色"
	L["Toggle default priest color"] = "切换预设的牧师颜色"
	L["Priest color"] = "牧师颜色"
	L["Default paladin color"] = "预设的圣骑士颜色"
	L["Toggle default paladin color"] = "切换预设的圣骑士颜色"
	L["Paladin color"] = "圣骑士颜色"
	L["Default shaman color"] = "预设的萨满颜色"
	L["Toggle default shaman color"] = "切换预设的萨满颜色"
	L["Shaman color"] = "萨满颜色"
	L["Default druid color"] = "预设的德鲁伊颜色"
	L["Toggle default druid color"] = "切换预设的德鲁伊颜色"
	L["Druid color"] = "德鲁伊颜色"
	L["Default mage color"] = "预设的法师颜色"
	L["Toggle default mage color"] = "切换预设的法师颜色"
	L["Mage color"] = "法师颜色"
	L["Default warlock color"] = "预设的术士颜色"
	L["Toggle default warlock color"] = "切换预设的术士颜色"
	L["Warlock color"] = "术士颜色"
	L["Default hunter color"] = "预设的猎人颜色"
	L["Toggle default hunter color"] = "切换预设的猎人颜色"
	L["Hunter color"] = "猎人颜色"
	L["Default warrior color"] = "预设的战士颜色"
	L["Toggle default warrior color"] = "切换预设的战士颜色"
	L["Warrior color"] = "战士颜色"
	L["Default rogue color"] = "预设的盗贼颜色"
	L["Toggle default eogue color"] = "切换预设的盗贼颜色"
	L["Rogue color"] = "盗贼颜色"
	L["Default death knight color"] = "预设的死亡骑士颜色"
	L["Toggle default death knight color"] = "切换预设的死亡骑士颜色"
	L["Death knight color"] = "死亡骑士颜色"
	L["Hover"] = "悬停"
	L["Hover settings"] = "悬停设定"
	L["Highlight On Mouseover"] = "高亮游标悬停"
	L["Highlight frame on mouseover"] = "高亮游标悬停的框架"
	L["Highlight Color"] = "高亮颜色"
	L["Color of the highlight frame"] = "高亮框架的颜色"
	L["Player Target"] = "玩家目标"
	L["Player target settings"] = "玩家目标设定"
	L["Highlight Target"] = "高亮目标"
	L["Show border around player target"] = "显示玩家目标周围边框"
	L["Highlight Target Color"] = "高亮目标颜色"
	L["Color of the target border"] = "目标边框的颜色"
	L["Highlight Target Priority"] = "高亮目标优先权"
	L["Priority of the target border"] = "目标边框的优先权"
	L["Player Focus Target"] = "玩家焦点目标"
	L["Player focus target settings"] = "玩家焦点目标设定"
	L["Highlight Focus Target"] = "高亮焦点目标"
	L["Highlight Focus Target Color"] = "高亮专注目标颜色"
	L["Color of the focus target border"] = "专注目标边框的颜色"
	L["Highlight Focus Target Priority"] = "高亮专注目目标优先权"
	L["Priority of the focus target border"] = "专注目标边框的优先权"
	L["Raid Assist Target"] = "团队助攻目标"
	L["Raid assist settings"] = "团队助攻设定"
	L["Highlight Raid Assist"] = "高亮团队助攻"
	L["Show border around raid assist"] = "显示团队助攻周围边框"
	L["Highlight Raid Assist Color"] = "高亮团队助攻颜色"
	L["Color of the raid assist border"] = "团队助攻边框的颜色"
	L["Highlight Raid Assist Priority"] = "高亮团队助攻优先权"
	L["Priority of the raid assist border"] = "团队助攻边框的优先权"
	L["Raid Icon Targets"] = "团队目标图标"
	L["Raid Icon target 1 settings"] = "团队目标图标 1 设定"
	L["Raid Icon target 2 settings"] = "团队目标图标 2 设定"
	L["Raid Icon target 3 settings"] = "团队目标图标 3 设定"
	L["Raid Icon target 4 settings"] = "团队目标图标 4 设定"
	L["Raid Icon target 5 settings"] = "团队目标图标 5 设定"
	L["Raid Icon target 6 settings"] = "团队目标图标 6 设定"
	L["Raid Icon target 7 settings"] = "团队目标图标 7 设定"
	L["Raid Icon target 8 settings"] = "团队目标图标 8 设定"
	L["Layout Code"] = "编排代码"
	L["Code of your layout."] = "你的编排代码。"
	L["Import layout"] = "汇入编排"
	L["Import your layout code."] = "汇入你的编排代码。"
	L["Error while importing layout: %s"] = "汇入编排代码错误: %s"
	L["Power Bar Default Color"] = "能量条预设颜色"
	L["Toggle power bar default color"] = "切换能量条预设的颜色"
	L["Power Bar Color"] = "能量条颜色"
	L["Color of the power bar"] = "能量条的颜色"
	L["Power Bar Background Color"] = "能量条背景颜色"
	L["Color of the power bar background"] = "能量条背景的颜色"
	L["Power Bar Inverse"] = "能量条反向"
	L["Inverse the power bar"] = "能量条的反向"
	L["Power Bar Texture"] = "能量条材质"
	L["Texture of the power bar"] = "能量条的材质"
	L["Power Bar Adjust Width"] = "调整能量条宽"
	L["Adjust power bar width to the frame width"] = "调整能量条宽跟框架一样宽"
	L["Power Bar Width"] = "能量条宽"
	L["Width of the power bar"] = "能量条的宽度"
	L["Power Bar Height"] = "能量条高"
	L["Height of the power bar"] = "能量条的高度"
	L["Power Bar Attach To"] = "能量条附加到"
	L["Attach power bar to the given frame"] = "附加能量条到选定的框架"
	L["Power Bar Anchor"] = "能量条锚点"
	L["Anchor of the power bar"] = "能量条的锚点"
	L["Power Bar Relative Point"] = "能量条相对定位点"
	L["Relative point of the power bar"] = "能量条的相对定位点"
	L["Power Bar Offset X"] = "能量条位移 X"
	L["X offset of the power bar"] = "能量条的位移 X"
	L["Power Bar Offset Y"] = "能量条位移 Y"
	L["Power colors"] = "能量颜色"
	L["Default Power Mana Color"] = "预设的法力颜色"
	L["Toggle default power mana color"] = "切换预设的法力颜色"
	L["Power Mana Color"] = "法力颜色"
	L["Default Power Rage Color"] = "预设的怒气颜色"
	L["Toggle default power rage color"] = "切换预设的怒气颜色"
	L["Power Rage Color"] = "怒气颜色"
	L["Default Power Focus Color"] = "预设的集中颜色"
	L["Toggle default power focus color"] = "切换预设的集中颜色"
	L["Power Focus Color"] = "集中颜色"
	L["Default Power Energy Color"] = "预设的能量颜色"
	L["Toggle default power energy color"] = "切换预设的能量颜色"
	L["Power Energy Color"] = "能量颜色"
	L["Default Power Runic Power Color"] = "预设的符能颜色"
	L["Toggle default power runic power color"] = "切换预设的符能颜色"
	L["Power Runic Power Color"] = "符能颜色"
	L["Texts"] = "文字选项"
	L["Add text"] = "新增文字"
	L["Name of the text element"] = "文字要素名称"
	L["Text Attach To"] = "文字附加到"
	L["Attach text to module bar"] = "附加文字到模块条"
	L["Add Text"] = "新增文字"
	L["Tags"] = "标签"
	L["Add tag"] = "新增标签"
	L["Name of the tag"] = "标签的名称"
	L["Add Tag"] = "新增标签"
	L["Tag: %s"] = "标签: %s"
	L["Text to be displayed"] = "要显示的文字"
	L["Delete Text"] = "删除文字"
	L["Tag"] = "标签"
	L["Tag settings"] = "标签设置"
	L["Text Color"] = "文字颜色"
	L["Text color of the text"] = "文字的颜色"
	L["Text Size"] = "文字大小"
	L["Text size of the text"] = "文字的大小"
	L["Text Align"] = "文字对齐"
	L["Text align of the text"] = "文字的对齐"
	L["Text Offset X"] = "文字位移 X"
	L["X offset of the text"] = "文字的位移 X"
	L["Text Offset Y"] = "文字位移 Y"
	L["Y offset of the text"] = "文字的位移 Y"
	L["Delete Tag"] = "删除标签"
	L["Events"] = "事件"
	L["Events which update the tag"] = "标签随着事件更新"
	L["Function"] = "功能"
	L["DEAD"] = "死亡"
	L["Target bar health bar"] = "目标生命条"
	L["Toggle health bar display"] = "切换显示为生命条"
	L["Target bar class color"] = "目标条职业颜色"
	L["Target bar color"] = "目标条颜色"
	L["Target bar background color"] = "目标条的背景颜色"
	L["Target bar inverse"] = "目标条反向"
	L["Target bar texture"] = "目标条材质"
	L["Target bar class icon"] = "目标条职业图标"
	L["Toggle the target bar class icon"] = "切换目标条的职业图标"
	L["Target bar icon position"] = "目标条图标位置"
	L["Position of the target bar class icon"] = "目标条的职业图标位置"
	L["Target bar adjust width"] = "调整目标条宽"
	L["Target bar width"] = "目标条宽"
	L["Target bar height"] = "目标条高"
	L["Target Bar Attach To"] = "目标条附加到"
	L["Target Bar Anchor"] = "目标条锚点"
	L["Target Bar Relative Point"] = "目标条相对定位点"
	L["Target bar offset X"] = "目标条位移 X"
	L["Target bar offset Y"] = "目标条位移 Y"
	L["Timer Soon Color"] = "临时定时器颜色"
	L["Color of the timer when timeleft is less than 5 seconds."] = "当计时低于5秒时的定时器颜色。"
	L["Timer Soon Size"] = "临时定时器大小"
	L["Text size of the timer when timeleft is less than 5 seconds."] = "当计时低于5秒时的定时器文字颜色。"
	L["Timer Seconds Color"] = "定时器秒数颜色"
	L["Color of the timer when timeleft is less than 60 seconds."] = "当计时低于60秒时的定时器颜色。"
	L["Timer Seconds Size"] = "定时器秒数大小"
	L["Text size of the timer when timeleft is less than 60 seconds."] = "当计时低于60秒时的定时器文字颜色。"
	L["Timer Minutes Color"] = "定时器分钟颜色"
	L["Color of the timer when timeleft is greater than 60 seconds."] = "当计时高于60秒时的定时器颜色。"
	L["Timer Minutes Size"] = "定时器分钟大小"
	L["Text size of the timer when timeleft is greater than 60 seconds."] = "当计时高于60秒时的定时器文字颜色。"
	L["TRINKET USED: %s (%s)"] = "已使用饰品: %s (%s)"
	L["TRINKET READY: %s (%s)"] = "饰品准备完毕: %s (%s)"
	L["Trinket"] = "饰品"
	L["Announces when an enemy uses a PvP trinket."] = "当一个敌人使用了PvP饰品时通告。"
	L["Trinket Grid Style Icon"] = "Grid风格饰品图示"
	L["Toggle trinket grid style icon"] = "切换Grid风格的饰品图示"
	L["Trinket Grid Style Icon Color"] = "Grid风格饰品图示颜色"
	L["Color of the trinket grid style icon"] = "Grid风格的饰品图示颜色"
	L["Trinket Grid Style Icon Used Color"] = "Grid风格的饰品图示已使用的颜色"
	L["Color of the trinket grid style icon when it's on cooldown"] = "Grid风格的饰品图示冷却中的颜色"
	L["Trinket Cooldown Spiral"] = "饰品冷却倒数"
	L["Trinket Cooldown Reverse"] = "饰品冷却反转"
	L["Trinket Gloss"] = "饰品覆盖"
	L["Toggle gloss on the trinket icon"] = "切换覆盖的饰品图示"
	L["Trinket Gloss Color"] = "饰品覆盖颜色"
	L["Color of the trinket icon gloss"] = "饰品图示覆盖的颜色"
	L["Trinket Icon Border Crop"] = "裁剪饰品图示边框"
	L["Toggle if the borders of the trinket icon should be cropped"] = "是否需要裁剪职业图示边框"
	L["Trinket Icon Faction"] = "阵营饰品图示"
	L["Toggle if the trinket icon should be changing based on the opponents faction"] = "若要切换饰品图示需在对方阵营的基础上变更才行"
	L["Trinket Frame Level"] = "饰品框架层级"
	L["Frame level of the trinket"] = "饰品框架的层级"
	L["Trinket Adjust Size"] = "调整饰品大小"
	L["Adjust trinket size to the frame size"] = "调整饰品大小跟框架一样大"
	L["Trinket Size"] = "饰品大小"
	L["Size of the trinket"] = "饰品的大小"
	L["Trinket Attach To"] = "饰品附加到"
	L["Attach trinket to the given frame"] = "附加饰品到选定的框架"
	L["Trinket Position"] = "饰品位置"
	L["Position of the trinket"] = "饰品的位置"
	L["Trinket Anchor"] = "饰品锚点"
	L["Anchor of the trinket"] = "饰品的锚点"
	L["Trinket Relative Point"] = "饰品相对定位点"
	L["Relative point of the trinket"] = "饰品的相对定位点"
	L["Trinket Offset X"] = "饰品位移 X"
	L["X offset of the trinket"] = "饰品位移 X"
	L["Trinket Offset Y"] = "饰品位移 Y"
	L["Y offset of the trinket"] = "饰品位移 Y"
	L["Export layout"] = "汇出编排"
	L["Export your layout code."] = "汇出你的编排代码。"
	L["Target Bar Icon Crop Borders"] = "裁剪目标条图标边框"
	L["Toggle if the target bar icon borders should be cropped or not."] = "是否需要裁剪目标条的图标边框。"
	L["Timer Use OmniCC"] = "仿OmniCC定时器"
	L["The timer module will use OmniCC for text display"] = "定时器模块将使用OmniCC方式来显示计时"
	L["maxhealthTag"] = "最大生命值"
	L["maxpower:shortTag"] = "最大能量值 (简短)"
	L["powerTag"] = "能量值"
	L["health:shortTag"] = "生命值 (简短)"
	L["classTag"] = "单位职业"
	L["power:percentageTag"] = "能量值 (百分比)"
	L["power:shortTag"] = "能量值 (简短)"
	L["raceTag"] = "单位种族"
	L["nameTag"] = "单位名称"
	L["name:statusTag"] = "单位名称/状态"
	L["specTag"] = "单位天赋"
	L["health:percentageTag"] = "生命值 (百分比)"
	L["healthTag"] = "生命值"
	L["maxhealth:shortTag"] = "最大生命值 (简短)"
	L["maxpowerTag"] = "最大能量值"
	L["Unholy:short"] = "邪恶"
	L["Frost:short"] = "冰霜"
	L["Blood:short"] = "鲜血"
	L["Fire:short"] = "火焰"
	L["Arcane:short"] = "奥术"
	L["Marksmanship:short"] = "射击"
	L["Survival:short"] = "生存"
	L["Beast Mastery:short"] = "兽王"
	L["Elemental:short"] = "元素"
	L["Enhancement:short"] = "增强"
	L["Restoration:short"] = "恢复"
	L["Feral:short"] = "野性"
	L["Balance:short"] = "平衡"
	L["Demonology:short"] = "恶魔"
	L["Destruction:short"] = "毁灭"
	L["Affliction:short"] = "痛苦"
	L["Subtlety:short"] = "敏锐"
	L["Combat:short"] = "战斗"
	L["Assassination:short"] = "刺杀"
	L["Shadow:short"] = "暗影"
	L["Discipline:short"] = "戒律"
	L["Holy:short"] = "神圣"
	L["Retribution:short"] = "惩戒"
	L["Protection:short"] = "防护"
	L["Arms:short"] = "武器"
	L["Fury:short"] = "狂怒"
	L["Brewmaster:short"] = "酒仙"
	L["Mistweaver:short"] = "织雾"
	L["Windwalker:short"] = "踏风"
	L["Warrior:short"] = "战"
	L["Death Knight:short"] = "死"
	L["Warlock:short"] = "术"
	L["Priest:short"] = "牧"
	L["Hunter:short"] = "猎"
	L["Rogue:short"] = "贼"
	L["Shaman:short"] = "萨"
	L["Druid:short"] = "德"
	L["Paladin:short"] = "圣"
	L["Mage:short"] = "法"
	L["Monk:short"] = "僧"
elseif locale == "zhTW" then
	L["Frame"] = "框體"
	L["Welcome to Gladius!"] = "歡迎使用Gladius!"
	L["First run has been detected displaying test frame."] = "偵測到為第一次使用，顯示測試框架。"
	L["Valid slash commands are:"] = "有效的斜線+指令是:"
	L["/gladius ui"] = "/gladius ui"
	L["/gladius test 2-5"] = "/gladius test 2-5"
	L["/gladius hide"] = "/gladius hide"
	L["/gladius reset"] = "/gladius reset"
	L["If this is not your first run please lock or move the frame to prevent this from happening."] = "如果您不是第一次使用，請鎖定或者移動此框架以防止這類情況發生。"
	L["LEFT"] = "左"
	L["CENTER"] = "中"
	L["RIGHT"] = "右"
	L["Top Left"] = "左上"
	L["Top Right"] = "右上"
	L["Center Left"] = "左中"
	L["Center Right"] = "右中"
	L["Bottom Left"] = "左下"
	L["Bottom Right"] = "右下"
	L["Enable Module"] = "啟用模組"
	L["Reset Module"] = "重置模組"
	L["Module Templates"] = "模組的樣板"
	L["General"] = "一般"
	L["General settings"] = "一般設定"
	L["Lock frame"] = "鎖定框架"
	L["Toggle if the frame can be moved"] = "勾選後框架就不能被移動了"
	L["Grow frame upwards"] = "框架向上延伸"
	L["If this is toggled the frame will grow upwards instead of downwards."] = "勾選後框架將向上延伸而不是向下。"
	L["Group Buttons"] = "隊伍按鈕"
	L["Advanced Options"] = "進階選項"
	L["Toggle advanced options"] = "切換進階選項"
	L["Frame settings"] = "框架設定"
	L["Background Color"] = "背景顏色"
	L["Color of the frame background"] = "框架背景的顏色"
	L["Background Padding"] = "背景間距"
	L["Padding of the background"] = "背景的間距"
	L["Bottom Margin"] = "按鈕間隔"
	L["Margin between each button"] = "按鈕的間隔"
	L["Size"] = "大小"
	L["Size settings"] = "大小設定"
	L["Bar width"] = "狀態條寬"
	L["Width of the module bars"] = "模組狀態條的寬度"
	L["Frame scale"] = "框架比例"
	L["Scale of the frame"] = "框架的比例"
	L["Font"] = "字型"
	L["Font settings"] = "字型設定"
	L["Global Font"] = "整體字型"
	L["Global font used by the modules"] = "使用於模組的整體字型"
	L["Global Font Size"] = "整體字型大小"
	L["Text size of the power info text"] = "動能條資訊文字的大小"
	L["Use Global Font Size"] = "使用整體字型大小"
	L["Toggle if you want to use the global font size"] = "勾選後將使用整體字型大小"
	L["Arms"] = "武器"
	L["Fury"] = "狂怒"
	L["Protection"] = "防護"
	L["Holy"] = "神聖"
	L["Retribution"] = "懲戒"
	L["Assassination"] = "刺殺"
	L["Combat"] = "戰鬥"
	L["Subtlety"] = "敏銳"
	L["Discipline"] = "戒律"
	L["Shadow"] = "暗影"
	L["Blood"] = "血魄"
	L["Frost"] = "冰霜"
	L["Unholy"] = "穢邪"
	L["Arcane"] = "秘法"
	L["Fire"] = "火焰"
	L["Affliction"] = "痛苦"
	L["Demonology"] = "惡魔學識"
	L["Destruction"] = "毀滅"
	L["Elemental"] = "元素"
	L["Enhancement"] = "增強"
	L["Restoration"] = "恢復"
	L["Beast Mastery"] = "野獸控制"
	L["Marksmanship"] = "射擊"
	L["Survival"] = "生存"
	L["Balance"] = "平衡"
	L["Feral"] = "野性戰鬥"
	L["%s - %s"] = "%s - %s"
	L["SPEC DETECTED: %s (%s)"] = "偵測到天賦: %s (%s)"
	L["LOW HEALTH: %s (%s)"] = "低生命值: %s (%s)"
	L["DRINKING: %s (%s)"] = "喝水: %s (%s)"
	L["RESURRECTING: %s (%s)"] = "復活中: %s (%s)"
	L["Self"] = "自身"
	L["Party"] = "隊伍"
	L["Say"] = "說"
	L["Raid Warning"] = "團隊警告"
	L["Scrolling Combat Text"] = "SCT"
	L["MikScrollingBattleText"] = "MSCT"
	L["Blizzard's Floating Combat Text"] = "暴雪的FCT"
	L["Parrot"] = "Parrot"
	L["Options"] = "選項"
	L["Destination"] = "通告方式"
	L["Choose how your announcements are displayed."] = "選擇您想要的顯示通告方式。"
	L["Low health threshold"] = "低生命值門檻"
	L["Choose how low an enemy must be before low health is announced."] = "選擇敵人低於多少生命值時通告。"
	L["Announcement toggles"] = "切換通告"
	L["New enemies"] = "新敵人"
	L["Announces when new enemies are discovered."] = "當發現新敵人時通告。"
	L["Drinking"] = "喝水"
	L["Announces when enemies sit down to drink."] = "當敵人坐下喝水時通告。"
	L["Low health"] = "低生命值"
	L["Announces when an enemy drops below a certain health threshold."] = "當敵人的生命值低於門檻時通告。"
	L["Resurrection"] = "復活"
	L["Announces when an enemy tries to resurrect a teammate."] = "當敵人試圖復活隊友時通告。"
	L["Spec Detection"] = "偵測天賦"
	L["Announces when the spec of an enemy was detected."] = "當偵測到敵人的天賦時通告。"
	L["Buffs"] = "增益"
	L["Widget"] = "小工具"
	L["Widget settings"] = "小工具設定"
	L["Auras Buffs"] = "增益光環"
	L["Toggle aura buffs"] = "切換增益光環"
	L["Auras Column Grow"] = "光環列延伸"
	L["Grow direction of the auras"] = "光環的延伸方向"
	L["Up Left"] = "左上"
	L["Up Right"] = "右上"
	L["Down Left"] = "左下"
	L["Down Right"] = "右下"
	L["Aura Icons Per Column"] = "每列光環圖示"
	L["Number of aura icons per column"] = "每列光環圖示的數量"
	L["Aura Icons Max"] = "最大光環圖示"
	L["Number of max buffs"] = "增益的最大數量"
	L["Auras Gloss"] = "覆蓋光環"
	L["Toggle gloss on the auras icon"] = "選擇覆蓋的光環圖示"
	L["Auras Gloss Color"] = "覆蓋光環顏色"
	L["Color of the auras icon gloss"] = "覆蓋光環圖示的顏色"
	L["Aura Icon Width"] = "光環圖示寬"
	L["Width of the aura icons"] = "光環圖示的寬度"
	L["Aura Icon Height"] = "光環圖示高"
	L["Height of the aura icon"] = "光環圖示的高度"
	L["Auras Spacing Vertical"] = "光環垂直間距"
	L["Vertical spacing of the auras"] = "光環的垂直間距"
	L["Auras Spacing Horizontal"] = "光環水平間距"
	L["Horizontal spacing of the auras"] = "光環的水平間距"
	L["Position"] = "位置"
	L["Position settings"] = "位置設定"
	L["Auras Attach To"] = "光環附加到"
	L["Attach auras to the given frame"] = "附加光環到選定的框架"
	L["Auras Anchor"] = "光環錨點"
	L["Anchor of the auras"] = "光環的錨點"
	L["Auras Relative Point"] = "光環相對定位點"
	L["Relative point of the auras"] = "光環的相對定位點"
	L["Auras Offset X"] = "光環位移 X"
	L["X offset of the auras"] = "光環的位移 X"
	L["Auras Offset Y"] = "光環位移 Y"
	L["Y offset of the auras"] = "光環的位移 Y"
	L["Filter"] = "篩選"
	L["Whitelist"] = "白名單"
	L["Blacklist"] = "黑名單"
	L["Filter Function"] = "篩選功能"
	L["Debuffs"] = "減益"
	L["Auras Debuffs"] = "減益光環"
	L["Toggle aura debuffs"] = "切換減益光環"
	L["Number of max Debuffs"] = "減益的最大數量"
	L["Auras"] = "光環"
	L["New Aura"] = "新光環"
	L["Name"] = "名稱"
	L["Name of the aura"] = "光環的名稱"
	L["Priority"] = "優先順序"
	L["Select what priority the aura should have - higher equals more priority"] = "選擇光環的優先順序，數字越大優先順序越高"
	L["Add new Aura"] = "新增新光環"
	L["Delete"] = "刪除"
	L["Example Spell Name"] = "法術名稱範例"
	L["Bar"] = "狀態條"
	L["Bar settings"] = "狀態條設定"
	L["Cast Bar Color"] = "施法條顏色"
	L["Color of the cast bar"] = "施法條的顏色"
	L["Cast Bar Background Color"] = "施法條背景顏色"
	L["Color of the cast bar background"] = "施法條背景的顏色"
	L["Cast Bar Inverse"] = "施法條反向"
	L["Inverse the cast bar"] = "施法條反向"
	L["Cast Bar Texture"] = "施法條材質"
	L["Texture of the cast bar"] = "施法條的材質"
	L["Cast Bar Icon"] = "施法條圖示"
	L["Toggle the cast icon"] = "切換施法條圖示"
	L["Cast Bar Icon Position"] = "施法條圖示位置"
	L["Position of the cast bar icon"] = "施法條圖示的位置"
	L["Cast Bar Adjust Width"] = "調整施法條寬度"
	L["Adjust cast bar width to the frame width"] = "調整施法條寬跟框架一樣寬"
	L["Cast Bar Width"] = "施法條寬"
	L["Width of the cast bar"] = "施法條的寬度"
	L["Cast Bar Height"] = "施法條高"
	L["Height of the cast bar"] = "施法條的高度"
	L["Cast Bar Attach To"] = "施法條附加到"
	L["Attach cast bar to the given frame"] = "附加施法條到選定的框架"
	L["Cast Bar Anchor"] = "施法條錨點"
	L["Anchor of the cast bar"] = "施法條的錨點"
	L["Cast Bar Relative Point"] = "施法條相對定位點"
	L["Relative point of the cast bar"] = "施法條的相對定位點"
	L["Cast Bar Offset X"] = "施法條位移 X"
	L["X offset of the cast bar"] = "施法條的位移 X"
	L["Cast Bar Offset Y"] = "施法條位移 Y"
	L["Y offset of the castbar"] = "施法條的位移 Y"
	L["Cast Text"] = "施法文字"
	L["Text"] = "文字"
	L["Text settings"] = "文字設定"
	L["Toggle cast text"] = "切換施法文字"
	L["Cast Text Color"] = "施法文字顏色"
	L["Text color of the cast text"] = "施法文字的顏色"
	L["Cast Text Size"] = "施法文字大小"
	L["Text size of the cast text"] = "施法文字的大小"
	L["Cast Text Align"] = "施法文字對齊"
	L["Text align of the cast text"] = "施法文字的對齊"
	L["Cast Text Offset X"] = "施法文字位移 X"
	L["X offset of the cast text"] = "施法文字的位移 X"
	L["Cast Text Offset Y"] = "施法文字位移 Y"
	L["Y offset of the cast text"] = "施法文字的位移 Y"
	L["Cast Time Text"] = "施法時間文字"
	L["Toggle cast time text"] = "切換施法時間文字"
	L["Cast Time Text Color"] = "施法時間文字顏色"
	L["Text color of the cast time text"] = "施法時間文字的顏色"
	L["Cast Time Text Size"] = "施法時間文字大小"
	L["Text size of the cast time text"] = "施法時間文字的大小"
	L["Cast Time Text Align"] = "施法時間文字對齊"
	L["Text align of the cast time text"] = "施法時間文字的對齊"
	L["Cast Time Offset X"] = "施法時間文字位移 X"
	L["X Offset of the cast time text"] = "施法時間文字的位移 X"
	L["Cast Time Offset Y"] = "施法時間文字位移 Y"
	L["Y Offset of the cast time text"] = "施法時間文字的位移 Y"
	L["Class Icon Important Auras"] = "職業圖示裡的重要光環"
	L["Show important auras instead of the class icon"] = "在職業圖示裡顯示重要光環"
	L["Class Icon Crop Borders"] = "裁剪職業圖示邊框"
	L["Toggle if the class icon borders should be cropped or not."] = "是否需要裁剪職業圖示邊框。"
	L["Class Icon Cooldown Spiral"] = "職業圖示裡的冷卻倒數"
	L["Display the cooldown spiral for important auras"] = "為重要光環顯示冷卻倒數"
	L["Class Icon Cooldown Reverse"] = "職業圖示裡的冷卻反轉"
	L["Invert the dark/bright part of the cooldown spiral"] = "冷卻倒數中的明暗反向"
	L["Class Icon Gloss"] = "覆蓋職業圖示"
	L["Toggle gloss on the class icon"] = "切換覆蓋的職業圖示"
	L["Class Icon Gloss Color"] = "覆蓋職業圖示顏色"
	L["Color of the class icon gloss"] = "覆蓋職業圖示的顏色"
	L["Class Icon Frame Level"] = "職業圖示框架層級"
	L["Frame level of the class icon"] = "職業圖示的框架層級"
	L["Class Icon Adjust Size"] = "調整職業圖示大小"
	L["Adjust class icon size to the frame size"] = "調整職業圖示的大小"
	L["Class Icon Size"] = "職業圖示大小"
	L["Size of the class icon"] = "職業圖示的大小"
	L["Class Icon Attach To"] = "職業圖示附加到"
	L["Attach class icon to given frame"] = "附加職業圖示到選定的框架"
	L["Class Icon Position"] = "職業圖示位置"
	L["Position of the class icon"] = "職業圖示的位置"
	L["Left"] = "左"
	L["Right"] = "右"
	L["Class Icon Anchor"] = "職業圖示錨點"
	L["Anchor of the class icon"] = "職業圖示的錨點"
	L["Class Icon Relative Point"] = "職業圖示相對定位點"
	L["Relative point of the class icon"] = "職業圖示的相對定位點"
	L["Class Icon Offset X"] = "職業圖示位移 X"
	L["X offset of the class icon"] = "職業圖示的位移 X"
	L["Class Icon Offset Y"] = "職業圖示位移 Y"
	L["Y offset of the class icon"] = "職業圖示的位移 Y"
	L["Middle"] = "中鍵"
	L["Button 4"] = "按鈕 4"
	L["Button 5"] = "按鈕 5"
	L["None"] = "無"
	L["ctrl-"] = "ctrl-"
	L["shift-"] = "shift-"
	L["alt-"] = "alt-"
	L["Click Actions"] = "點擊執行"
	L["Add click action"] = "新增點擊執行"
	L["Mouse button"] = "滑鼠按鈕"
	L["Select which mouse button this click action uses"] = "選擇哪個滑鼠按鈕來點擊執行"
	L["Modifier"] = "附加主鍵"
	L["Select a modifier for this click action"] = "選擇修改此點擊執行"
	L["Add"] = "新增"
	L["Delete Click Action"] = "刪除點擊執行"
	L["Action"] = "執行"
	L["Select what this Click Action does"] = "選擇點擊執行該做甚麼指令"
	L["Cast Spell"] = "施放法術"
	L["Spell Name / Macro Text"] = "法術名稱 / 巨集指令"
	L["DRTracker Space"] = "控場追蹤間隔"
	L["Space between the icons"] = "圖示之間的間隔"
	L["DRTracker Cooldown Spiral"] = "控場追蹤冷卻倒數"
	L["DRTracker Cooldown Reverse"] = "控場追蹤冷卻反轉"
	L["DRTracker Gloss"] = "覆蓋控場追蹤"
	L["Toggle gloss on the drTracker icon"] = "切換覆蓋控場追蹤圖示"
	L["DRTracker Gloss Color"] = "覆蓋控場追蹤顏色"
	L["Color of the drTracker icon gloss"] = "覆蓋控場追蹤的顏色"
	L["DRTracker Frame Level"] = "控場追蹤框架層級"
	L["Frame level of the drTracker"] = "控場追蹤框架的層級"
	L["DRTracker Adjust Size"] = "調整控場追蹤大小"
	L["Adjust drTracker size to the frame size"] = "調整控場追蹤大小跟框架一樣大"
	L["DRTracker Size"] = "控場追蹤大小"
	L["Size of the drTracker"] = "控場追蹤的大小"
	L["DR Text Color"] = "控場文字顏色"
	L["Text color of the DR text"] = "控場文字的顏色"
	L["DR Text Size"] = "控場文字大小"
	L["Text size of the DR text"] = "控場文字的大小"
	L["DRTracker Attach To"] = "控場追蹤附加到"
	L["Attach drTracker to the given frame"] = "附加控場追蹤到選定的框架"
	L["DRTracker Position"] = "控場追蹤位置"
	L["DRTracker Anchor"] = "控場追蹤錨點"
	L["Anchor of the drTracker"] = "控場追蹤的錨點"
	L["DRTracker Relative Point"] = "控場追蹤相對定位點"
	L["Relative point of the drTracker"] = "控場追蹤的相對定位點"
	L["DRTracker Offset X"] = "控場追蹤位移 X"
	L["X offset of the drTracker"] = "控場追蹤的位移 X"
	L["DRTracker Offset Y"] = "控場追蹤位移 Y"
	L["Y offset of the drTracker"] = "控場追蹤的位移 Y"
	L["Categories"] = "類別"
	L["Category settings"] = "類別設定"
	L["Health bar class color"] = "生命條職業顏色"
	L["Toggle health bar class color"] = "切換生命條的職業顏色"
	L["Health bar color"] = "生命條顏色"
	L["Color of the health bar"] = "生命條的顏色"
	L["Health bar background color"] = "生命條背景顏色"
	L["Color of the health bar background"] = "生命條背景的顏色"
	L["Health bar inverse"] = "生命條反向"
	L["Inverse the health bar"] = "生命條的反向"
	L["Health bar texture"] = "生命條材質"
	L["Texture of the health bar"] = "生命條的材質"
	L["Health bar adjust width"] = "調整生命條寬"
	L["Adjust health bar width to the frame width"] = "調整生命條寬跟框架一樣寬"
	L["Health bar width"] = "生命條寬"
	L["Width of the health bar"] = "生命條的寬度"
	L["Health bar height"] = "生命條高"
	L["Height of the health bar"] = "生命條的高度"
	L["Health Bar Attach To"] = "生命條附加到"
	L["Attach health bar to the given frame"] = "附加生命條到選定的框架"
	L["Health Bar Anchor"] = "生命條錨點"
	L["Anchor of the health bar"] = "生命條的錨點"
	L["Health Bar Relative Point"] = "生命條相對定位點"
	L["Relative point of the health bar"] = "生命條的相對定位點"
	L["Health bar offset X"] = "生命條位移 X"
	L["X offset of the health bar"] = "生命條的位移 X"
	L["Health bar offset Y"] = "生命條位移 Y"
	L["Y offset of the health bar"] = "生命條的位移 Y"
	L["Health colors"] = "生命條顏色"
	L["Default priest color"] = "預設的牧師顏色"
	L["Toggle default priest color"] = "切換預設的牧師顏色"
	L["Priest color"] = "牧師顏色"
	L["Default paladin color"] = "預設的聖騎士顏色"
	L["Toggle default paladin color"] = "切換預設的聖騎士顏色"
	L["Paladin color"] = "聖騎士顏色"
	L["Default shaman color"] = "預設的薩滿顏色"
	L["Toggle default shaman color"] = "切換預設的薩滿顏色"
	L["Shaman color"] = "薩滿顏色"
	L["Default druid color"] = "預設的德魯伊顏色"
	L["Toggle default druid color"] = "切換預設的德魯伊顏色"
	L["Druid color"] = "德魯伊顏色"
	L["Default mage color"] = "預設的法師顏色"
	L["Toggle default mage color"] = "切換預設的法師顏色"
	L["Mage color"] = "法師顏色"
	L["Default warlock color"] = "預設的術士顏色"
	L["Toggle default warlock color"] = "切換預設的術士顏色"
	L["Warlock color"] = "術士顏色"
	L["Default hunter color"] = "預設的獵人顏色"
	L["Toggle default hunter color"] = "切換預設的獵人顏色"
	L["Hunter color"] = "獵人顏色"
	L["Default warrior color"] = "預設的戰士顏色"
	L["Toggle default warrior color"] = "切換預設的戰士顏色"
	L["Warrior color"] = "戰士顏色"
	L["Default rogue color"] = "預設的盜賊顏色"
	L["Toggle default eogue color"] = "切換預設的盜賊顏色"
	L["Rogue color"] = "盜賊顏色"
	L["Default death knight color"] = "預設的死亡騎士顏色"
	L["Toggle default death knight color"] = "切換預設的死亡騎士顏色"
	L["Death knight color"] = "死亡騎士顏色"
	L["Hover"] = "懸停"
	L["Hover settings"] = "懸停設定"
	L["Highlight On Mouseover"] = "高亮游標懸停"
	L["Highlight frame on mouseover"] = "高亮游標懸停的框架"
	L["Highlight Color"] = "高亮顏色"
	L["Color of the highlight frame"] = "高亮框架的顏色"
	L["Player Target"] = "玩家目標"
	L["Player target settings"] = "玩家目標設定"
	L["Highlight Target"] = "高亮目標"
	L["Show border around player target"] = "顯示玩家目標周圍邊框"
	L["Highlight Target Color"] = "高亮目標顏色"
	L["Color of the target border"] = "目標邊框的顏色"
	L["Highlight Target Priority"] = "高亮目標優先權"
	L["Priority of the target border"] = "目標邊框的優先權"
	L["Player Focus Target"] = "玩家專注目標"
	L["Player focus target settings"] = "玩家專注目標設定"
	L["Highlight Focus Target"] = "高亮專注目標"
	L["Highlight Focus Target Color"] = "高亮專注目標顏色"
	L["Color of the focus target border"] = "專注目標邊框的顏色"
	L["Highlight Focus Target Priority"] = "高亮專注目標的優先權"
	L["Priority of the focus target border"] = "專注目標邊框的優先權"
	L["Raid Assist Target"] = "團隊助攻目標"
	L["Raid assist settings"] = "團隊助攻設定"
	L["Highlight Raid Assist"] = "高亮團隊助攻"
	L["Show border around raid assist"] = "顯示團隊助攻周圍邊框"
	L["Highlight Raid Assist Color"] = "高亮團隊助攻顏色"
	L["Color of the raid assist border"] = "團隊助攻邊框的顏色"
	L["Highlight Raid Assist Priority"] = "高亮團隊助攻優先權"
	L["Priority of the raid assist border"] = "團隊助攻邊框的優先權"
	L["Raid Icon Targets"] = "團隊目標圖示"
	L["Raid Icon target 1 settings"] = "團隊目標圖示 1 設定"
	L["Raid Icon target 2 settings"] = "團隊目標圖示 2 設定"
	L["Raid Icon target 3 settings"] = "團隊目標圖示 3 設定"
	L["Raid Icon target 4 settings"] = "團隊目標圖示 4 設定"
	L["Raid Icon target 5 settings"] = "團隊目標圖示 5 設定"
	L["Raid Icon target 6 settings"] = "團隊目標圖示 6 設定"
	L["Raid Icon target 7 settings"] = "團隊目標圖示 7 設定"
	L["Raid Icon target 8 settings"] = "團隊目標圖示 8 設定"
	L["Layout Code"] = "編排代碼"
	L["Code of your layout."] = "你的編排代碼。"
	L["Import layout"] = "匯入編排"
	L["Import your layout code."] = "匯入你的編排代碼。"
	L["Error while importing layout: %s"] = "匯入編排代碼錯誤: %s"
	L["Power Bar Default Color"] = "動能條預設顏色"
	L["Toggle power bar default color"] = "切換動能條預設的顏色"
	L["Power Bar Color"] = "動能條顏色"
	L["Color of the power bar"] = "動能條的顏色"
	L["Power Bar Background Color"] = "動能條背景顏色"
	L["Color of the power bar background"] = "動能條背景的顏色"
	L["Power Bar Inverse"] = "動能條反向"
	L["Inverse the power bar"] = "動能條的反向"
	L["Power Bar Texture"] = "動能條材質"
	L["Texture of the power bar"] = "動能條的材質"
	L["Power Bar Adjust Width"] = "調整動能條寬"
	L["Adjust power bar width to the frame width"] = "調整動能條寬跟框架一樣寬"
	L["Power Bar Width"] = "動能條寬"
	L["Width of the power bar"] = "動能條的寬度"
	L["Power Bar Height"] = "動能條高"
	L["Height of the power bar"] = "動能條的高度"
	L["Power Bar Attach To"] = "動能條附加到"
	L["Attach power bar to the given frame"] = "附加動能條到選定的框架"
	L["Power Bar Anchor"] = "動能條錨點"
	L["Anchor of the power bar"] = "動能條的錨點"
	L["Power Bar Relative Point"] = "動能條相對定位點"
	L["Relative point of the power bar"] = "動能條的相對定位點"
	L["Power Bar Offset X"] = "動能條位移 X"
	L["X offset of the power bar"] = "動能條的位移 X"
	L["Power Bar Offset Y"] = "動能條位移 Y"
	L["Power colors"] = "動能顏色"
	L["Default Power Mana Color"] = "預設的法力顏色"
	L["Toggle default power mana color"] = "切換預設的法力顏色"
	L["Power Mana Color"] = "法力顏色"
	L["Default Power Rage Color"] = "預設的怒氣顏色"
	L["Toggle default power rage color"] = "切換預設的怒氣顏色"
	L["Power Rage Color"] = "怒氣顏色"
	L["Default Power Focus Color"] = "預設的集中顏色"
	L["Toggle default power focus color"] = "切換預設的集中顏色"
	L["Power Focus Color"] = "集中顏色"
	L["Default Power Energy Color"] = "預設的動能顏色"
	L["Toggle default power energy color"] = "切換預設的動能顏色"
	L["Power Energy Color"] = "動能顏色"
	L["Default Power Runic Power Color"] = "預設的符能顏色"
	L["Toggle default power runic power color"] = "切換預設的符能顏色"
	L["Power Runic Power Color"] = "符能顏色"
	L["Texts"] = "文字選項"
	L["Add text"] = "新增文字"
	L["Name of the text element"] = "文字要素名稱"
	L["Text Attach To"] = "文字附加到"
	L["Attach text to module bar"] = "附加文字到模組條"
	L["Add Text"] = "新增文字"
	L["Tags"] = "標籤"
	L["Add tag"] = "新增標籤"
	L["Name of the tag"] = "標籤的名稱"
	L["Add Tag"] = "新增標籤"
	L["Tag: %s"] = "標籤: %s"
	L["Text to be displayed"] = "要顯示的文字"
	L["Delete Text"] = "刪除文字"
	L["Tag"] = "標籤"
	L["Tag settings"] = "標籤設定"
	L["Text Color"] = "文字顏色"
	L["Text color of the text"] = "文字的顏色"
	L["Text Size"] = "文字大小"
	L["Text size of the text"] = "文字的大小"
	L["Text Align"] = "文字對齊"
	L["Text align of the text"] = "文字的對齊"
	L["Text Offset X"] = "文字位移 X"
	L["X offset of the text"] = "文字的位移 X"
	L["Text Offset Y"] = "文字位移 Y"
	L["Y offset of the text"] = "文字的位移 Y"
	L["Delete Tag"] = "刪除標籤"
	L["Events"] = "事件"
	L["Events which update the tag"] = "標籤隨著事件更新"
	L["Function"] = "功能"
	L["DEAD"] = "死亡"
	L["Target bar health bar"] = "目標生命條"
	L["Toggle health bar display"] = "切換顯示為生命條"
	L["Target bar class color"] = "目標條職業顏色"
	L["Target bar color"] = "目標條顏色"
	L["Target bar background color"] = "目標條的背景顏色"
	L["Target bar inverse"] = "目標條反向"
	L["Target bar texture"] = "目標條材質"
	L["Target bar class icon"] = "目標條職業圖示"
	L["Toggle the target bar class icon"] = "切換目標條的職業圖示"
	L["Target bar icon position"] = "目標條圖示位置"
	L["Position of the target bar class icon"] = "目標條的職業圖示位置"
	L["Target bar adjust width"] = "調整目標條寬"
	L["Target bar width"] = "目標條寬"
	L["Target bar height"] = "目標條高"
	L["Target Bar Attach To"] = "目標條附加到"
	L["Target Bar Anchor"] = "目標條錨點"
	L["Target Bar Relative Point"] = "目標條相對定位點"
	L["Target bar offset X"] = "目標條位移 X"
	L["Target bar offset Y"] = "目標條位移 Y"
	L["Timer Soon Color"] = "臨時計時器顏色"
	L["Color of the timer when timeleft is less than 5 seconds."] = "當計時低於5秒時的計時器顏色。"
	L["Timer Soon Size"] = "臨時計時器大小"
	L["Text size of the timer when timeleft is less than 5 seconds."] = "當計時低於5秒時的計時器文字顏色。"
	L["Timer Seconds Color"] = "計時器秒數顏色"
	L["Color of the timer when timeleft is less than 60 seconds."] = "當計時低於60秒時的計時器顏色。"
	L["Timer Seconds Size"] = "計時器秒數大小"
	L["Text size of the timer when timeleft is less than 60 seconds."] = "當計時低於60秒時的計時器文字顏色。"
	L["Timer Minutes Color"] = "計時器分鐘顏色"
	L["Color of the timer when timeleft is greater than 60 seconds."] = "當計時高於60秒時的計時器顏色。"
	L["Timer Minutes Size"] = "計時器分鐘大小"
	L["Text size of the timer when timeleft is greater than 60 seconds."] = "當計時高於60秒時的計時器文字顏色。"
	L["TRINKET USED: %s (%s)"] = "已使用飾品: %s (%s)"
	L["TRINKET READY: %s (%s)"] = "飾品準備完畢: %s (%s)"
	L["Trinket"] = "飾品"
	L["Announces when an enemy uses a PvP trinket."] = "當一個敵人使用了PvP飾品時通告。"
	L["Trinket Grid Style Icon"] = "Grid風格飾品圖示"
	L["Toggle trinket grid style icon"] = "切換Grid風格的飾品圖示"
	L["Trinket Grid Style Icon Color"] = "Grid風格飾品圖示顏色"
	L["Color of the trinket grid style icon"] = "Grid風格的飾品圖示顏色"
	L["Trinket Grid Style Icon Used Color"] = "Grid風格的飾品圖示已使用的顏色"
	L["Color of the trinket grid style icon when it's on cooldown"] = "Grid風格的飾品圖示冷卻中的顏色"
	L["Trinket Cooldown Spiral"] = "飾品冷卻倒數"
	L["Trinket Cooldown Reverse"] = "飾品冷卻反轉"
	L["Trinket Gloss"] = "飾品覆蓋"
	L["Toggle gloss on the trinket icon"] = "切換覆蓋的飾品圖示"
	L["Trinket Gloss Color"] = "飾品覆蓋顏色"
	L["Color of the trinket icon gloss"] = "飾品圖示覆蓋的顏色"
	L["Trinket Icon Border Crop"] = "裁剪飾品圖示邊框"
	L["Toggle if the borders of the trinket icon should be cropped"] = "是否需要裁剪職業圖示邊框"
	L["Trinket Icon Faction"] = "陣營飾品圖示"
	L["Toggle if the trinket icon should be changing based on the opponents faction"] = "若要切換飾品圖示需在對方陣營的基礎上變更才行"
	L["Trinket Frame Level"] = "飾品框架層級"
	L["Frame level of the trinket"] = "飾品框架的層級"
	L["Trinket Adjust Size"] = "調整飾品大小"
	L["Adjust trinket size to the frame size"] = "調整飾品大小跟框架一樣大"
	L["Trinket Size"] = "飾品大小"
	L["Size of the trinket"] = "飾品的大小"
	L["Trinket Attach To"] = "飾品附加到"
	L["Attach trinket to the given frame"] = "附加飾品到選定的框架"
	L["Trinket Position"] = "飾品位置"
	L["Position of the trinket"] = "飾品的位置"
	L["Trinket Anchor"] = "飾品錨點"
	L["Anchor of the trinket"] = "飾品的錨點"
	L["Trinket Relative Point"] = "飾品相對定位點"
	L["Relative point of the trinket"] = "飾品的相對定位點"
	L["Trinket Offset X"] = "飾品位移 X"
	L["X offset of the trinket"] = "飾品的位移 X"
	L["Trinket Offset Y"] = "飾品位移 Y"
	L["Y offset of the trinket"] = "飾品的位移 Y"
	L["Export layout"] = "匯出編排"
	L["Export your layout code."] = "匯出你的編排代碼。"
	L["Target Bar Icon Crop Borders"] = "裁剪目標條圖示邊框"
	L["Toggle if the target bar icon borders should be cropped or not."] = "是否需要裁剪目標條的圖示邊框。"
	L["Timer Use OmniCC"] = "仿OmniCC計時器"
	L["The timer module will use OmniCC for text display"] = "計時器模組將使用OmniCC方式來顯示計時"
	L["maxhealthTag"] = "最大生命值"
	L["maxpower:shortTag"] = "最大動能值 (簡短)"
	L["powerTag"] = "動能值"
	L["health:shortTag"] = "生命值 (簡短)"
	L["classTag"] = "單位職業"
	L["power:percentageTag"] = "動能值 (百分比)"
	L["power:shortTag"] = "動能值 (簡短)"
	L["raceTag"] = "單位種族"
	L["nameTag"] = "單位名稱"
	L["name:statusTag"] = "單位名稱/狀態"
	L["specTag"] = "單位天賦"
	L["health:percentageTag"] = "生命值 (百分比)"
	L["healthTag"] = "生命值"
	L["maxhealth:shortTag"] = "最大生命值 (簡短)"
	L["maxpowerTag"] = "最大動能值"
	L["Unholy:short"] = "邪"
	L["Frost:short"] = "冰"
	L["Blood:short"] = "血"
	L["Fire:short"] = "火"
	L["Arcane:short"] = "秘"
	L["Marksmanship:short"] = "射"
	L["Survival:short"] = "生"
	L["Beast Mastery:short"] = "獸"
	L["Elemental:short"] = "元"
	L["Enhancement:short"] = "增"
	L["Restoration:short"] = "恢"
	L["Feral:short"] = "野"
	L["Balance:short"] = "平"
	L["Demonology:short"] = "惡"
	L["Destruction:short"] = "毀"
	L["Affliction:short"] = "痛"
	L["Subtlety:short"] = "敏"
	L["Combat:short"] = "戰"
	L["Assassination:short"] = "刺"
	L["Shadow:short"] = "暗"
	L["Discipline:short"] = "戒"
	L["Holy:short"] = "神"
	L["Retribution:short"] = "懲"
	L["Protection:short"] = "防"
	L["Arms:short"] = "武"
	L["Fury:short"] = "狂"
	L["Brewmaster:short"] = "酒"
	L["Mistweaver:short"] = "霧"
	L["Windwalker:short"] = "風"
	L["Warrior:short"] = "戰"
	L["Death Knight:short"] = "死騎"
	L["Warlock:short"] = "術"
	L["Priest:short"] = "牧"
	L["Hunter:short"] = "獵"
	L["Rogue:short"] = "賊"
	L["Shaman:short"] = "薩"
	L["Druid:short"] = "德"
	L["Paladin:short"] = "聖"
	L["Mage:short"] = "法"
	L["Monk:short"] = "僧"
end
