local GetCurrencyInfo = GetCurrencyInfo;
if GetCurrencyInfo == nil and C_CurrencyInfo.GetCurrencyInfo ~= nil then
    local __GetCurrencyInfo = C_CurrencyInfo.GetCurrencyInfo;
    GetCurrencyInfo = function(index)
        if index ~= nil then
            local info = __GetCurrencyInfo(index);
            return info.name, info.quantity, info.iconFileID, info.quantityEarnedThisWeek, info.maxWeeklyQuantity, info.maxQuantity, info.discovered, info.quality;
        end
	end
end
local WorldMapTooltip = WorldMapTooltip or _G.GameTooltip

DraenorTreasures = LibStub("AceAddon-3.0"):NewAddon("DraenorTreasures", "AceBucket-3.0", "AceConsole-3.0", "AceEvent-3.0", "AceTimer-3.0")
local HandyNotes = LibStub("AceAddon-3.0"):GetAddon("HandyNotes", true)

if not HandyNotes then return end

local iconDefaults = {
    default = "Interface\\Icons\\TRADE_ARCHAEOLOGY_CHESTOFTINYGLASSANIMALS",
    unknown = "Interface\\Addons\\HandyNotes_DraenorTreasures\\Artwork\\chest_normal_daily.tga",
    swprare = "Interface\\Icons\\Trade_Archaeology_Fossil_SnailShell",
    shrine = "Interface\\Icons\\inv_misc_statue_02",
    glider = "Interface\\Icons\\inv_feather_04",
    rocket = "Interface\\Icons\\ability_mount_rocketmount",
    skull_blue = "Interface\\Addons\\HandyNotes_DraenorTreasures\\Artwork\\RareIconBlue.tga",
    skull_green = "Interface\\Addons\\HandyNotes_DraenorTreasures\\Artwork\\RareIconGreen.tga",
    skull_grey = "Interface\\Addons\\HandyNotes_DraenorTreasures\\Artwork\\RareIcon.tga",
    skull_orange = "Interface\\Addons\\HandyNotes_DraenorTreasures\\Artwork\\RareIconOrange.tga",
    skull_purple = "Interface\\Addons\\HandyNotes_DraenorTreasures\\Artwork\\RareIconPurple.tga",
    skull_red = "Interface\\Addons\\HandyNotes_DraenorTreasures\\Artwork\\RareIconRed.tga",
    skull_yellow = "Interface\\Addons\\HandyNotes_DraenorTreasures\\Artwork\\RareIconYellow.tga",
}

local PlayerFaction, _ = UnitFactionGroup("player")
DraenorTreasures.nodes = { }

local nodes = DraenorTreasures.nodes
local isTomTomloaded = false
local isDBMloaded = false
local isHN_LRTloaded = false


nodes["ShadowmoonValleyDR"] = {
    [54924501]={ "35581", "炼金师的包裹", "草药", "", "default", "treasure_smv","109124"},
    [52834837]={ "35584", "先祖巨斧", "i519 力量双手斧", "", "default", "treasure_smv","113560"},
    [41422798]={ "33869", "装甲雷象獠牙", "i518 饰品 护甲加成+使用后精通", "", "default", "treasure_smv","108902"},
    [37784435]={ "33584", "阿库伯的灰烬", "休息奖励经验值的消耗品", "", "default", "treasure_smv","113531"},
    [49313760]={ "33867", "占星家的盒子", "玩具", "", "default", "treasure_smv","109739"},
    [36774142]={ "33046", "爱人的祭品", "趣味物品 - 副手", "", "default", "treasure_smv","113547"},
    [37182313]={ "33613", "冒泡的大锅", "i516 法术副手", "在一个山洞内; 入口在东北 38, 22.3 附近", "default", "treasure_smv","108945"},
    [84564478]={ "33885", "渡鸦女皇的货物", "要塞物资", "", "default", "treasure_smv","824"},
    [33453961]={ "33569", "雕饰饮水角", "可重复使用的法力药水", "", "default", "treasure_smv","113545"},
    [61706790]={ "34743", "托瓦斯的水晶之刃", "垃圾物品", "与物件互动的是三个银叶古树; 杀掉他们后才可以拾取物品", "default", "treasure_smv","111636"},
    [20383065]={ "33575", "恶魔宝箱", "i550 智力项链", "", "default", "treasure_smv","108904"},
    [29853748]={ "36879", "尘封的宝箱", "随机绿装和金币", "在巨石拱门上; 从其他的拱门跳跃到那里，起始点在西边的悬崖边上", "default", "treasure_smv","824"},
    [51753549]={ "33037", "带夹层的罐子", "金钱", "", "default", "treasure_smv","824"},
    [26530568]={ "34174", "神奇鱼", "要塞物资", "", "default", "treasure_smv","824"},
    [34394623]={ "33891", "巨型月柳球果", "i522 魔杖", "", "default", "treasure_smv","108901"},
    [48724753]={ "35798", "发光的洞穴蘑菇", "草药", "", "default", "treasure_smv","109127"},
    [38484308]={ "33614", "格瑞卡的坛子", "i528 饰品 急速+力量触发", "", "default", "treasure_smv","113408"},
    [47154603]={ "33564", "挂起的背包", "i518 敏捷/智力 皮甲手套", "", "default", "treasure_smv","108900"},
    [42106130]={ "33041", "钢铁部落货箱", "要塞物资", "", "default", "treasure_smv","824"},
    [37515925]={ "33567", "钢铁部落贡品", "饰品 溅射+使用后伤害", "", "default", "treasure_smv","108903"},
    [57924531]={ "33568", "卡利鸟蛋", "25 要塞物资", "", "default", "treasure_smv","113271"},
    [58882193]={ "35603", "米卡尔的箱子", "垃圾物品", "", "default", "treasure_smv","113215"},
    [52882486]={ "37254", "长满蘑菇的宝箱", "25 要塞物资", "", "default", "treasure_smv","113388"},
    [66963349]={ "36507", "兽人骷髅", "i526 力量戒指", "", "default", "treasure_smv","116875"},
    [43756062]={ "33611", "和平祭礼 1", "垃圾物品", "", "default", "treasure_smv","107650"},
    [45226049]={ "33610", "和平祭礼 2", "垃圾物品", "", "default", "treasure_smv","107650"},
    [44486357]={ "33384", "和平祭礼 3", "垃圾物品", "", "default", "treasure_smv","107650"},
    [44495914]={ "33612", "和平祭礼 4", "垃圾物品", "", "default", "treasure_smv","107650"},
    [31223905]={ "33886", "罗诺克的物品", "i522 力量披风", "", "default", "treasure_smv","109081"},
    [22893385]={ "33572", "腐朽的篮子", "垃圾物品", "在血棘洞穴内", "default", "treasure_smv","113373"},
    [36684455]={ "33573", "罗沃的匕首", "i520 敏捷匕首", "", "default", "treasure_smv","113378"},
    [67058418]={ "33565", "带鳞片的双头飞龙蛋", "垃圾物品", "!!! 等级100区域 !!!", "default", "treasure_smv","44722"},
    [45822458]={ "33570", "影月流亡者宝箱", "25 要塞物资", "在一个山洞内的放逐者下面", "default", "treasure_smv","113388"},
    [29994536]={ "35919", "影月祭祀匕首", "i524 法术匕首", "", "default", "treasure_smv","113563"},
    [28233924]={ "33883", "影月宝藏", "要塞物资", "", "default", "treasure_smv","824"},
    [27050248]={ "35280", "失窃的宝藏", "要塞物资", "", "default", "treasure_smv","824"},
    [55821997]={ "35600", "奇异孢子", "宠物", "在巨型蘑菇顶上", "default", "treasure_smv","118104"},
    [37192601]={ "35677", "沉没的渔船", "鱼类", "", "default", "treasure_smv","118414"},
    [28820720]={ "35279", "沉没的宝箱", "要塞物资", "", "default", "treasure_smv","824"},
    [55297487]={ "35580", "沼泽荧光虫蜂巢", "玩具", "", "default", "treasure_smv","117550"},
    [35854087]={ "33540", "乌兹克的小玩意儿", "i525 敏捷/智力 皮甲鞋", "", "default", "treasure_smv","113546"},
    [34214353]={ "33866", "威玛的草药包", "草药", "", "default", "treasure_smv","109124"},
    [51147912]={ "33574", "守备官宝箱", "玩具", "!!! 等级100区域 !!!", "default", "treasure_smv","113375"},
    [39208391]={ "33566", "进水的宝箱", "i520 力量拳套+要塞物资", "", "default", "treasure_smv","113372"},
    [37203640]={ "33061", "阿莫卡瓦", "i516 敏捷/智力 锁甲胸", "在非常大区域内盘旋", "skull_grey", "rare_smv","109060"},
    [50807880]={ "37356", "阿夸利亚", "i620 智力戒指", "!!! 等级101 !!!", "skull_blue", "rare_h_smv","119387"},
    [68208480]={ "37410", "雪崩", "i620 力量单手锤", "!!! 等级100 !!!", "skull_blue", "rare_h_smv","119400"},
    [52801680]={ "35731", "巴鲁恩", "无增益的重复性食物", "", "skull_grey", "rare_smv","113540"},
    [43807740]={ "33383", "荆棘大王菲里", "i620 敏捷法杖", "!!! 等级100 !!!", "skull_blue", "rare_h_smv","117551"},
    [48604360]={ "33064", "暗影余孽", "i516 智力拳套", "在洞穴内; 杀掉邪教徒使其可以被攻击", "skull_grey", "rare_smv","109075"},
    [41008300]={ "35448", "黑暗大师高维德", "i525 智力法杖+龙虾人召唤", "", "skull_grey", "rare_smv","113548"},
    [49604200]={ "35555", "暗爪", "i520 敏捷披风", "", "skull_grey", "rare_smv","113541"},
    [46007160]={ "37351", "戴米多斯", "i620 敏捷/力量 坦克项链+宠物+成就", "!!! 等级102 !!! 从索克雷萨高地到他的平台，从东边的石头上跳过去", "skull_green", "rare_h_smv","119377"},
    [67806380]={ "35688", "爱娜瓦拉", "i523 智力项链", "与她的尸体进行交互后与其刷新的灵魂作战", "skull_grey", "rare_smv","113556"},
    [61606180]={ "35725", "灵光", "i526 敏捷/智力 皮甲腿", "", "skull_grey", "rare_smv","113557"},
    [37404880]={ "35558", "催眠魔蛙", "玩具", "", "skull_green", "rare_smv","113631"},
    [57404840]={ "35909", "伊沙塔尔", "i520 敏捷/智力 锁甲鞋", "", "skull_grey", "rare_smv","113571"},
    [40804440]={ "33043", "戮喉", "i516 敏捷匕首", "", "skull_grey", "rare_smv","109078"},
    [32203500]={ "33039", "虚空先知库塔格", "i516 敏捷/智力 锁甲手套", "", "skull_grey", "rare_smv","109061"},
    [48007760]={ "37355", "魔女泰普特莎", "i620 敏捷/智力 皮甲鞋", "!!! 等级101 !!!", "skull_blue", "rare_h_smv","119360"},
    [37601460]={ "33055", "读叶者库里", "i518 饰品 全能+治疗触发", "", "skull_grey", "rare_smv","108907"},
    [44802080]={ "35906", "“疯王”斯波隆", "i519 敏捷法杖", "", "skull_grey", "rare_smv","113561"},
    [29605080]={ "37357", "马尔高什·护影", "i620 敏捷/智力 锁甲头盔", "!!! 等级100 !!!", "skull_blue", "rare_h_smv","119369"},
    [51807920]={ "37353", "军士长米格拉", "i620 敏捷/智力 锁甲手套", "!!! 等级101 !!!", "skull_blue", "rare_h_smv","119368"},
    [38607020]={ "35523", "莫尔瓦·屈魂者", "i520 单手 法术锤", "", "skull_grey", "rare_smv","113559"},
    [44005760]={ "33642", "主母奥姆拉", "i522 饰品 智力 +精通触发", "杀掉邪教徒使其可以被攻击", "skull_grey", "rare_smv","113527"},
    [58408680]={ "37409", "纳吉达", "i620 敏捷/智力 皮甲肩", "!!! 等级100 !!! 在山洞内 - 入口在 59,89", "skull_blue", "rare_h_smv","119364"},
    [50207240]={ "37352", "军需官赫沙克", "i620 力量/智力 板甲腿", "!!! 等级101 !!!", "skull_blue", "rare_h_smv","119382"},
    [48602260]={ "35553", "莱沃什", "重复性缓落物品", "", "skull_grey", "rare_smv","113542"},
    [53005060]={ "34068", "岩蹄", "i516 力量盾", "", "skull_grey", "rare_smv","109077"},
    [48208100]={ "37354", "暗影语者纳尔", "i620 法术匕首", "!!! 等级101 !!!", "skull_blue", "rare_h_smv","119396"},
    [61005520]={ "35732", "辛利", "400% 有CD的陆地坐骑", "在大范围游荡 - 时常躲避和消失", "skull_grey", "rare_smv","113543"},
    [61408880]={ "37411", "银喉", "i620 力量双手剑", "!!! 等级100 !!!", "skull_blue", "rare_h_smv","119411"},
    [27604360]={ "36880", "斯尼维尔", "i519 布甲腿", "", "skull_grey", "rare_smv","118734"},
    [21602100]={ "33640", "维洛斯", "i516 智力戒指", "", "skull_grey", "rare_smv","108906"},
    [54607060]={ "33643", "毒影", "i516 敏捷/智力 皮甲鞋", "", "skull_grey", "rare_smv","108957"},
    [31905720]={ "37359", "虚空掠夺者乌奈", "i620 敏捷单手斧", "!!! 等级100 !!!", "skull_blue", "rare_h_smv","119392"},
    [32604140]={ "35847", "虚空先知卡鲁格", "i516 布甲腰带", "杀掉邪教徒使其可以被攻击", "skull_grey", "rare_smv","109074"},
    [48806640]={ "33389", "伊格德尔", "玩具", "", "skull_green", "rare_smv","113570"},
    [29405150]={ "37357", "马尔高什·护影", "i620 敏捷/智力 锁甲头盔", "!!! 等级100 !!!", "skull_blue", "rare_h_smv","119369"},
    [54003040]={ "99999900", "觅径者", "", "", "skull_orange", "mount_pr", "116773"},
    [43003220]={ "99999900", "觅径者", "", "", "skull_orange", "mount_pr", "116773"},
    [39603660]={ "99999900", "觅径者", "", "", "skull_orange", "mount_pr", "116773"},
    [44604380]={ "99999900", "觅径者", "", "", "skull_orange", "mount_pr", "116773"},
    [56205240]={ "99999900", "觅径者", "", "", "skull_orange", "mount_pr", "116773"},
    [45806820]={ "99999900", "觅径者", "", "", "skull_orange", "mount_pr", "116773"},
    [50907250]={ "99999901", "灵爪飞鹰", "传送门随机出现", "", "skull_purple", "mount_vt", "121815"},
    [49607160]={ "99999901", "灵爪飞鹰", "传送门随机出现", "", "skull_purple", "mount_vt", "121815"},
    [41907570]={ "99999901", "灵爪飞鹰", "传送门随机出现", "", "skull_purple", "mount_vt", "121815"},
    [48706990]={ "99999901", "灵爪飞鹰", "传送门随机出现", "", "skull_purple", "mount_vt", "121815"},
    [43207100]={ "99999901", "灵爪飞鹰", "传送门随机出现", "", "skull_purple", "mount_vt", "121815"},
    [46607000]={ "99999901", "灵爪飞鹰", "传送门随机出现", "", "skull_purple", "mount_vt", "121815"},
    [50307130]={ "99999901", "灵爪飞鹰", "传送门随机出现", "", "skull_purple", "mount_vt", "121815"},
}

nodes["FrostfireRidge"] = {
    [23172495]={ "33916", "竞技场大师的作战号角", "玩具", "在竞技场上面的看台上", "default", "treasure_ffr","108735"},
    [24242712]={ "33501", "观众的箱子", "酒精饮料", "在石拱门顶上; 从附近的塔上跳过去", "default", "treasure_ffr","63293"},
    [61904254]={ "33511", "吞噬者布罗克", "i516 智力盾", "喂给它10个食人魔后掉落", "default", "treasure_ffr","112110"},
    [42161930]={ "34520", "燃烧的珍珠", "i525 饰品 溅射+精通触发", "!!! 等级100区域 !!!", "default", "treasure_ffr","120341"},
    [50161870]={ "33531", "笨拙的库拉戈莫蛮兵", "i516 敏捷/智力 锁甲头盔", "!!! 等级100区域 !!! 在低悬崖边上", "default", "treasure_ffr","112096"},
    [42663175]={ "33940", "攀岩者的宝箱", "i516 敏捷/智力 锁甲鞋", "从墙上的长矛跳过去到达那里", "default", "treasure_ffr","112187"},
    [40902010]={ "34473", "特使的袋子", "垃圾物品", "!!! 等级100区域 !!!", "default", "treasure_ffr","110536"},
    [43665562]={ "34841", "被遗忘的补给品", "要塞物资", "", "default", "treasure_ffr","824"},
    [24184860]={ "34507", "冰封的霜狼战斧", "i516 法强斧", "在一个山洞内", "default", "treasure_ffr","110689"},
    [57175216]={ "34476", "冰封的兽人骷髅 ", "i516 饰品精通+宠物触发", "", "default", "treasure_ffr","111554"},
    [25522050]={ "34648", "啃过的骨头", "i516 敏捷匕首", "", "default", "treasure_ffr","111415"},
    [66712640]={ "33948", "鬣蜥人残渣", "25 要塞物资", "!!! 等级100区域 !!! 在山顶的洞上，向上的路径开始为69.3, 24", "default", "treasure_ffr","111543"},
    [68124586]={ "33947", "肃霜宝箱", "要塞物资", "", "default", "treasure_ffr","824"},
    [56727186]={ "36863", "钢铁部落军需品", "要塞物资", "", "default", "treasure_ffr","824"},
    [68906910]={ "33017", "钢铁部落补给品", "要塞物资", "", "default", "treasure_ffr","824"},
    [21890963]={ "33926", "环礁池塘", "玩具", "需要钓鱼", "default", "treasure_ffr","108739"},
    [19211202]={ "34642", "幸运硬币", "趣味物品 - 硬币", "卖价25金", "default", "treasure_ffr","111408"},
    [38303782]={ "33502", "黑曜石岩画", "5%休息经验的消耗品", "在山上; 上山斜路在39, 42.5", "default", "treasure_ffr","112087"},
    [28296663]={ "34470", "白鬼鱼贩", "鱼", "", "default", "treasure_ffr","111666"},
    [21685076]={ "34931", "一袋白鬼战利品", "要塞物资", "在洞里", "default", "treasure_ffr","824"},
    [37265914]={ "34967", "抢来的战利品", "要塞物资", "在塔顶上", "default", "treasure_ffr","824"},
    [09834533]={ "34641", "密封的罐子", "趣味物品 - 箴言", "", "default", "treasure_ffr","111407"},
    [27654280]={ "33500", "奴隶的宝贝", "酒精饮料", "", "default", "treasure_ffr","43696"},
    [23971291]={ "34647", "积雪覆盖的保险箱", "金钱", "", "default", "treasure_ffr",""},
    [16124972]={ "33942", "遗弃的补给品", "要塞物资", "", "default", "treasure_ffr","824"},
    [64722573]={ "33946", "生存专家的宝箱", "要塞物资", "", "default", "treasure_ffr","824"},
    [34192348]={ "32803", "雷神储备点", "i516 敏捷/力量长柄", "", "default", "treasure_ffr","107658"},
    [64406586]={ "33505", "震动的蛋", "宠物", "", "default", "treasure_ffr","112107"},
    [54843545]={ "33525", "年轻的兽人旅行者", "未知", "您需要收集部份的年轻的女兽人和年轻的兽人旅行者来完成这个", "default", "treasure_ffr","112206"},
    [63401470]={ "33525", "年轻的女兽人", "未知", "您需要收集部份的年轻的女兽人和年轻的兽人旅行者来完成这个", "default", "treasure_ffr","112206"},
    [39661718]={ "33532", "库拉戈莫的箱子", "原始之灵+埃匹希斯水晶", "!!! 等级100区域 !!!", "default", "treasure_ffr","120945"},
    [45365034]={ "33011", "白发苍苍的霜狼老兵", "i516 耐力饰品+2%击杀治疗", "击败兽人进攻后与 NPC 交谈从尘封宝箱获得拾取", "default", "treasure_ffr","106899"},
    [88605740]={ "37525", "“屠夫”阿奥克斯", "i620 敏捷/智力 皮甲腰带", "!!! 等级100 !!!", "skull_blue", "rare_h_ffr","119365"},
    [27405000]={ "34497", "无息", "玩具", "", "skull_green", "rare_ffr","111476"},
    [66403140]={ "33843", "巢母里戈艾克", "i516 饰品 智力+溅射触发", "", "skull_grey", "rare_ffr","111533"},
    [34002320]={ "32941", "深峡冰母蜥蜴", "25 要塞物资", "", "skull_grey", "rare_ffr","101436"},
    [41206820]={ "34843", "冻牙", "i513 敏捷/智力 皮甲腿", "", "skull_grey", "rare_ffr","111953"},
    [40404700]={ "33014", "烬喉", "i516 法术匕首", "", "skull_grey", "rare_ffr","111490"},
    [25405500]={ "34129", "哀恸者冰蹄", "i516 智力项链", "", "skull_grey", "rare_ffr","112066"},
    [54606940]={ "34131", "冷牙", "i516 敏捷/力量 单手剑", "", "skull_grey", "rare_ffr","111484"},
    [67407820]={ "34477", "飓风之怒", "i516 布甲肩", "", "skull_grey", "rare_ffr","112086"},
    [71404680]={ "33504", "炎怒巨灵", "i516 副手", "", "skull_grey", "rare_ffr","107661"},
    [54602220]={ "32918", "巨人屠夫库尔", "i516 饰品 全能+敏捷触发", "", "skull_grey", "rare_ffr","111530"},
    [70003600]={ "37562", "熔岩鲸吸者高戈阿克", "i620 力量拳套", "!!! 等级100 !!!", "skull_blue", "rare_h_ffr","111545"},
    [38001400]={ "37388", "高里瓦克斯", "i620 智力布甲手腕", "", "skull_blue", "rare_h_ffr","119358"},
    [38606300]={ "34865", "劫掠者古图什", "i513 敏捷/智力 锁甲腿", "", "skull_grey", "rare_ffr","112077"},
    [50305260]={ "34825", "古鲁克", "i513 饰品 急速+暴击", "", "skull_grey", "rare_ffr","111948"},
    [47005520]={ "34839", "戈伦", "i513 力量披风", "", "skull_grey", "rare_ffr","111955"},
    [68801940]={ "37382", "霜降", "i620 智力/精神 戒指", "!!! 等级101 !!!", "skull_blue", "rare_h_ffr","119415"},
    [58603420]={ "34130", "狩猎大师康恩", "要塞物资", "", "skull_grey", "rare_ffr","824"},
    [48202340]={ "37386", "刺颚", "i620 法术盾", "!!! 等级101 !!!", "skull_blue", "rare_h_ffr","119390"},
    [61602640]={ "34708", "攀岩者杰希尔", "i516 敏捷/智力 皮甲鞋", "", "skull_grey", "rare_ffr","112078"},
    [43002100]={ "37387", "莫托玛", "i620 布甲肩", "!!! 等级101 !!!", "skull_blue", "rare_h_ffr","119356"},
    [70002700]={ "37381", "鬣蜥人主母", "i620 力量项链", "!!! 等级101 !!!", "skull_blue", "rare_h_ffr","119376"},
    [83604720]={ "37402", "“绞肉机”奥戈姆", "i620 敏捷/智力 皮甲手腕", "!!! 等级100 !!!", "skull_blue", "rare_h_ffr","119366"},
    [36803400]={ "33938", "指挥官穆尔格", "i516 布甲腿", "", "skull_grey", "rare_ffr","111576"},
    [86604880]={ "37401", "拉戈尔·逐流", "i620 敏捷/智力 皮甲胸", "!!! 等级100 !!!", "skull_blue", "rare_h_ffr","119359"},
    [76406340]={ "34132", "斥候高斯克", "i516 敏捷/智力 皮甲胸", "", "skull_grey", "rare_ffr","112094"},
    [45001500]={ "37385", "食尸者暴牙", "i620 敏捷/智力 皮甲头", "!!! 等级101 !!!", "skull_blue", "rare_h_ffr","119362"},
    [38201600]={ "37383", "高拉摩尔之子", "i620 法术锤", "!!! 等级101 !!!", "skull_blue", "rare_h_ffr","119399"},
    [26803160]={ "34133", "打击者", "i516 力量 双手锤", "", "skull_grey", "rare_ffr","111475"},
    [72203300]={ "37361", "白骨爬行者", "i620 智力/力量 板甲胸", "!!! 等级101 !!!", "skull_blue", "rare_h_ffr","111534"},
    [43600940]={ "37384", "托格洛斯", "i620 副手", "!!! 等级101 !!!", "skull_blue", "rare_h_ffr","119379"},
    [40601240]={ "34522", "冰封者乌戈洛克", "i620 智力法杖", "!!! 等级101 !!!", "skull_blue", "rare_h_ffr","119409"},
    [72402420]={ "37378", "沃卡尔", "100要塞物资", "!!! 等级101 !!!", "skull_blue", "rare_h_ffr","119416"},
    [70603900]={ "37379", "古老的沃罗克", "100要塞物资", "!!! 等级101 !!!", "skull_blue", "rare_h_ffr","119416"},
    [40402780]={ "34559", "疤脸雅佳", "i516 敏捷/智力 皮甲腰带", "在低悬崖边上", "skull_grey", "rare_ffr","111477"},
    [84604680]={ "37403", "震地者霍拉", "i620 敏捷项链", "!!! 等级100 !!!", "skull_blue", "rare_h_ffr","119374"},
    [66602540]={ "37380", "胆小的吉布利特", "i620 敏捷披风+趣味物品", "!!! 等级101 !!! 在山顶的洞上，向上的路径开始为69.3, 24", "skull_blue", "rare_h_ffr","119349"},
    [86804500]={ "37404", "折铁者卡加", "i620 敏捷/智力 锁甲腰带", "!!! 等级100 !!!", "skull_blue", "rare_h_ffr","119372"},
    [63407940]={ "99999902", "戈罗克", "", "", "skull_orange", "mount_go", "116674"},
    [22806640]={ "99999902", "戈罗克", "", "", "skull_orange", "mount_go", "116674"},
    [64806300]={ "99999902", "戈罗克", "", "", "skull_orange", "mount_go", "116674"},
    [51805060]={ "99999902", "戈罗克", "", "", "skull_orange", "mount_go", "116674"},
    [58001840]={ "99999902", "戈罗克", "", "", "skull_orange", "mount_go", "116674"},
    [15804900]={ "99999903", "诺卡罗什", "", "此位置附近", "skull_yellow", "mount_no", "116794"},
    [51001990]={ "99999904", "灵爪飞鹰", "传送门随机出现", "", "skull_purple", "mount_vt", "121815"},
    [52501780]={ "99999904", "灵爪飞鹰", "传送门随机出现", "", "skull_purple", "mount_vt", "121815"},
    [53801730]={ "99999904", "灵爪飞鹰", "传送门随机出现", "", "skull_purple", "mount_vt", "121815"},
    [47702750]={ "99999904", "灵爪飞鹰", "传送门随机出现", "", "skull_purple", "mount_vt", "121815"},
}

nodes["BladespireFortress"] = {
    [37106980]={ "35370", "多罗戈的秘密宝箱", "金钱+垃圾物品", "刀塔堡垒二层, 户外", "default", "treasure_ffr_bsf","113189"},
    [31406670]={ "35367", "戈尔索格的私人金库", "酒精饮料", "刀塔堡垒顶层, 靠近王座", "default", "treasure_ffr_bsf","118108"},
    [36402880]={ "35347", "食人魔战利品", "要塞资源", "刀塔堡垒二层", "default", "treasure_ffr_bsf","824"},
    [53102790]={ "35368", "食人魔战利品", "金钱", "刀塔堡垒一层; 要爬上箱子才能拿到", "default", "treasure_ffr_bsf",""},
    [49106790]={ "35369", "食人魔战利品", "金钱", "刀塔堡垒一层; 要爬上箱子才能拿到", "default", "treasure_ffr_bsf",""},
    [46201560]={ "35371", "食人魔战利品", "金钱", "刀塔堡垒二层", "default", "treasure_ffr_bsf",""},
    [52605200]={ "35373", "食人魔战利品", "金钱", "刀塔堡垒二层; 要爬上箱子才能拿到", "default", "treasure_ffr_bsf",""},
    [51301790]={ "35567", "食人魔战利品", "要塞资源", "刀塔堡垒二层", "default", "treasure_ffr_bsf","824"},
    [76806220]={ "35568", "食人魔战利品", "要塞资源", "刀塔堡垒二层", "default", "treasure_ffr_bsf","824"},
    [70506780]={ "35569", "食人魔战利品", "要塞资源", "刀塔堡垒二层", "default", "treasure_ffr_bsf","824"},
    [44706450]={ "35570", "食人魔战利品", "金钱", "刀塔堡垒一层", "default", "treasure_ffr_bsf",""},
}

nodes["Gorgrond"] = {
    [41735297]={ "36506", "波尔卡的袋子", "i538 法术法杖", "", "default", "treasure_gg","118702"},
    [42368341]={ "36625", "被遗弃的包裹", "金钱+随机绿装", "", "default", "treasure_gg",""},
    [41827802]={ "36658", "永晨补给篮", "随机绿装", "", "default", "treasure_gg",""},
    [40367660]={ "36621", "探险家罐子", "50 要塞物资", "", "default", "treasure_gg","118710"},
    [40047223]={ "36170", "稀有腿骨", "垃圾物品", "", "default", "treasure_gg","118715"},
    [46104999]={ "36651", "可收获的珍贵水晶", "要塞物资", "", "default", "treasure_gg","824"},
    [42584685]={ "35056", "长角的颅骨", "要塞物资", "", "default", "treasure_gg","824"},
    [43694248]={ "36618", "钢铁补给箱", "要塞物资", "", "default", "treasure_gg","824"},
    [44207427]={ "35709", "嘲颅包裹", "要塞物资", "在树上", "default", "treasure_gg","824"},
    [43109290]={ "34241", "奥卡巴的包裹", "垃圾物品", "", "default", "treasure_gg","118227"},
    [52516696]={ "36509", "奇怪的颅骨", "i535 副手", "", "default", "treasure_gg","118717"},
    [46244295]={ "36521", "石化的双头飞龙蛋", "垃圾物品", "", "default", "treasure_gg","118707"},
    [43957055]={ "36118", "一堆碎石", "随机绿装", "", "default", "treasure_gg",""},
    [53127449]={ "36654", "巴里克·碎矿的遗骸", "垃圾物品", "", "default", "treasure_gg","118714"},
    [57845597]={ "36605", "波迪尔·深岩的遗物", "垃圾物品", "", "default", "treasure_gg","118703"},
    [39036805]={ "36631", "萨莎的秘密包裹", "金钱+随机绿装", "", "default", "treasure_gg",""},
    [44954262]={ "36634", "狙击手的强弩", "i539 弩", "", "default", "treasure_gg","118713"},
    [48129337]={ "36604", "隐秘的急救背包", "金钱+随机绿装", "", "default", "treasure_gg",""},
    [52977995]={ "34940", "样子古怪的匕首", "i537 敏捷匕首", "", "default", "treasure_gg","118718"},
    [57086530]={ "37249", "奇怪的孢子", "宠物", "在悬崖顶伸长出的蘑菇上", "default", "treasure_gg","118106"},
    [45694972]={ "36610", "日灼之矛", "垃圾物品", "", "default", "treasure_gg","118708"},
    [59296379]={ "36628", "守备官的战锤", "i539 力量 双手锤", "", "default", "treasure_gg","118712"},
    [48944731]={ "36203", "热乎乎的鬣蜥人蛋", "7天后会孵出玩具的蛋", "", "default", "treasure_gg","118705"},
    [49284363]={ "36596", "武器架", "100 要塞物资", "", "default", "treasure_gg","107645"},
    [58604120]={ "37371", "阿卡利", "i620 敏捷/智力 皮甲 手套", "!!! 等级100 !!!", "skull_blue", "rare_h_gg","119361"},
    [40007900]={ "35335", "巴肖克", "玩具", "", "skull_green", "rare_gg","118222"},
    [69204460]={ "37369", "巴斯滕+努尔塔+瓦斯提尔", "玩具+i620 布甲腰带", "!!! 等级100 !!! 3个在一起", "skull_green", "rare_h_gg","119357"},
    [39407460]={ "36597", "贝索拉", "i532 敏捷/智力 锁甲肩", "", "skull_grey", "rare_gg","118232"},
    [46003360]={ "37368", "剑圣罗戈尔", "i620 布甲鞋", "!!! 等级101 !!!", "skull_blue", "rare_h_gg","119228"},
    [53404460]={ "35503", "炽燃的焦皮", "i536 双手 法术锤", "", "skull_grey", "rare_gg","118212"},
    [48202100]={ "37362", "背叛者达兹戈", "i620 力量长柄", "!!! 等级101 !!!", "skull_blue", "rare_h_gg","119224"},
    [57603580]={ "37370", "深渊之根", "i620 敏捷长柄", "!!! 等级100 !!! 2个刷新点其中之一", "skull_blue", "rare_h_gg","119406"},
    [72604040]={ "37370", "深渊之根", "i620 敏捷长柄", "!!! 等级100 !!! 2个刷新点其中之一", "skull_blue", "rare_h_gg","119406"},
    [50002380]={ "37366", "可恨的杜普", "i620 敏捷皮甲腰带", "!!! 等级101 !!!", "skull_blue", "rare_h_gg","119225"},
    [72803580]={ "37373", "纵火者格拉什", "i620 力量/智力 板甲手", "!!! 等级100 !!! 2个刷新点其中之一", "skull_blue", "rare_h_gg","119381"},
    [58003640]={ "37373", "纵火者格拉什", "i620 力量/智力 板甲手", "!!! 等级100 !!! 2个刷新点其中之一", "skull_blue", "rare_h_gg","119381"},
    [57406860]={ "36387", "石化的岩木", "玩具", "", "skull_green", "rare_gg","118221"},
    [41804540]={ "36391", "“蓝焰”戈尔高", "i534 饰品 全能+智力触发", "", "skull_grey", "rare_gg","118230"},
    [46205080]={ "36204", "格鲁特", "i534 饰品 敏捷+溅射触发", "", "skull_grey", "rare_gg","118229"},
    [52805360]={ "37413", "瘤颚", "i620 智力拳套", "!!! 等级100 !!!", "skull_blue", "rare_h_gg","119397"},
    [46804320]={ "36186", "狡猾的戈尔多克", "i534 力量 单手锤", "", "skull_grey", "rare_gg","118210"},
    [59604300]={ "37375", "林地守卫者雅尔", "i620 智力 披风", "!!! 等级100 !!!", "skull_blue", "rare_h_gg","119414"},
    [52207020]={ "35908", "虫巢女王斯基卡", "i534 法强斧", "", "skull_grey", "rare_gg","118209"},
    [47002380]={ "37365", "豪格", "i620 敏捷/智力 锁甲胸", "!!! 等级100 !!!", "skull_blue", "rare_h_gg","119229"},
    [55004660]={ "37377", "猎人巴尔拉", "i620 弓", "!!! 等级100 !!!", "skull_blue", "rare_h_gg","119412"},
    [47603060]={ "37367", "发明家布拉莫", "i620 敏捷枪+趣味物品", "!!! 等级101 !!!", "skull_blue", "rare_h_gg","119226"},
    [52205580]={ "37412", "软泥怪大王", "i620 力量披风", "!!! 等级100 !!!", "skull_blue", "rare_h_gg","119351"},
    [50605320]={ "36178", "曼达科尔", "宠物", "", "skull_green", "rare_gg","118709"},
    [49003380]={ "37363", "疯狂的麦德加", "i620 智力项链", "!!! 等级101 !!!", "skull_blue", "rare_h_gg","119230"},
    [61803930]={ "37376", "莫伽玛戈", "i620 力量盾", "!!! 等级100 !!!", "skull_blue", "rare_h_gg","119391"},
    [47002580]={ "37364", "莫尔戈·凯恩", "i620 力量/智力 板甲头", "!!! 等级100 !!!", "skull_blue", "rare_h_gg","119227"},
    [53407820]={ "34726", "蛛后阿兰妮艾", "i534 敏捷匕首", "", "skull_grey", "rare_gg","118208"},
    [37608140]={ "36600", "里普塔尔", "i539 法术匕首", "", "skull_grey", "rare_gg","118231"},
    [47804140]={ "36393", "洛克尔", "i539 饰品 力量+暴击触发", "", "skull_grey", "rare_gg","118211"},
    [54207240]={ "36837", "怒蹄", "i537  敏捷/力量 双手锤", "", "skull_grey", "rare_gg","118228"},
    [38206620]={ "35910", "践踏者克罗格", "食人魔酿造工具组", "每7天可以产出酒精饮料", "skull_grey", "rare_gg","118224"},
    [40205960]={ "36394", "硫磺之怒", "玩具", "", "skull_green", "rare_gg","114227"},
    [44609220]={ "36656", "日爪", "i533 敏捷拳套", "", "skull_grey", "rare_gg","118223"},
    [59903200]={ "37374", "迅捷黑色掠夺者", "i620 敏捷/智力 锁甲鞋", "!!! 等级100 !!!", "skull_blue", "rare_h_gg","119367"},
    [64006180]={ "36794", "塞尔多斯", "i540 敏捷/智力 皮甲鞋", "", "skull_grey", "rare_gg","118213"},
    [76004200]={ "37405", "提丰", "埃匹希斯水晶", "!!! 等级100 !!!", "skull_blue", "rare_h_gg","823"},
    [63803160]={ "37372", "维诺拉斯克", "i620 敏捷匕首", "!!! 等级100 !!!", "skull_blue", "rare_h_gg","119395"},
    [41402640]={ "99999905", "重拳", "", "", "skull_orange", "mount_po", "116792"},
    [50404180]={ "99999905", "重拳", "", "", "skull_orange", "mount_po", "116792"},
    [45404760]={ "99999905", "重拳", "", "", "skull_orange", "mount_po", "116792"},
    [43205540]={ "99999905", "重拳", "", "", "skull_orange", "mount_po", "116792"},
    [48805540]={ "99999905", "重拳", "", "", "skull_orange", "mount_po", "116792"},
    [56004000]={ "99999906", "灵爪飞鹰", "传送门随机出现", "", "skull_purple", "mount_vt", "121815"},
    [51603880]={ "99999906", "灵爪飞鹰", "传送门随机出现", "", "skull_purple", "mount_vt", "121815"},
    [54004500]={ "99999906", "灵爪飞鹰", "传送门随机出现", "", "skull_purple", "mount_vt", "121815"},
    [43403440]={ "99999906", "灵爪飞鹰", "传送门随机出现", "", "skull_purple", "mount_vt", "121815"},
}

nodes["Talador"] = {
    [36509610]={ "34182", "阿尔克的传家宝", "i557 弩", "", "default", "treasure_td","117567"},
    [62083238]={ "34236", "艾米瑟尔水晶", "100 要塞物资", "", "default", "treasure_td","116131"},
    [81843494]={ "34260", "阿鲁纳矿车", "矿物", "", "default", "treasure_td","109118"},
    [62414797]={ "34252", "一桶鱼", "鱼", "", "default", "treasure_td","110506"},
    [33297680]={ "34259", "噬骨遗物", "要塞物资", "", "default", "treasure_td","824"},
    [37607490]={ "34148", "噬骨长矛", "i566 敏捷/智力 锁甲手套", "从蛇鞭的尸体上找到长矛", "default", "treasure_td","112371"},
    [73525137]={ "34471", "闪亮硬币", "i560 饰品 全能+护甲加成触发", "", "default", "treasure_td","116127"},
    [70100700]={ "36937", "火刃宝箱", "埃匹希斯水晶", "", "default", "treasure_td","823"},
    [77044996]={ "34248", "烧焦的长剑", "i563 力量双手剑", "", "default", "treasure_td","116116"},
    [66508694]={ "34239", "古怪的逝网蛛卵", "玩具", "", "default", "treasure_td","117569"},
    [58901200]={ "33933", "德塞普提亚的冒烟靴子", "玩具", "", "default", "treasure_td","108743"},
    [55256671]={ "34253", "德莱尼武器", "100 要塞物资", "", "default", "treasure_td","116118"},
    [35419656]={ "34249", "农夫的宝贝", "要塞物资", "", "default", "treasure_td","824"},
    [57362866]={ "34238", "工头的午餐盒", "重复性 食物/饮料", "", "default", "treasure_td","116120"},
    [64587920]={ "34251", "铁盒子", "i554 力量单手锤", "", "default", "treasure_td","117571"},
    [75003600]={ "33649", "钢铁斥候", "要塞资源", "", "default", "treasure_td","824"},
    [57207540]={ "34134", "伊萨莉宝箱", "i564 敏捷项链", "", "default", "treasure_td","117563"},
    [65471137]={ "34233", "一大壶陈年黑铁佳酿", "酒精饮料", "", "default", "treasure_td","117568"},
    [75684140]={ "34261", "克鲁的物品  ", "金钱", "", "default", "treasure_td",""},
    [53972769]={ "34290", "凯特娅的宝箱", "宠物", "", "default", "treasure_td","116402"},
    [38191242]={ "34258", "海洋之光", "金钱", "", "default", "treasure_td",""},
    [68805620]={ "34101", "圣光使者", "垃圾物品", "", "default", "treasure_td","109192"},
    [52562954]={ "34235", "微光贝壳", "i557 智力项链", "", "default", "treasure_td","116132"},
    [78211471]={ "34263", "纯净水晶尘", "i554 敏捷戒指", "", "default", "treasure_td","117572"},
    [75784472]={ "34250", "阿鲁纳遗物", "垃圾物品", "", "default", "treasure_td","116128"},
    [46969174]={ "34256", "泰尔莫遗物", "垃圾物品", "", "default", "treasure_td","116128"},
    [64901330]={ "34232", "鲁克的工具盒", "+4 钓鱼线", "", "default", "treasure_td","116117"},
    [65968513]={ "34276", "生锈宝箱", "随机绿装", "", "default", "treasure_td",""},
    [39505520]={ "34254", "缚魂者的圣物箱", "i558 智力戒指", "", "default", "treasure_td","117570"},
    [74602930]={ "35162", "恐爪鸟巢穴 1", "宠物", "只有一个恐爪巢可以拾取", "default", "treasure_td","112699"},
    [39307770]={ "35162", "恐爪鸟巢穴 10", "宠物", "只有一个恐爪巢可以拾取", "default", "treasure_td","112699"},
    [73503070]={ "35162", "恐爪鸟巢穴 2", "宠物", "只有一个恐爪巢可以拾取", "default", "treasure_td","112699"},
    [74303400]={ "35162", "恐爪鸟巢穴 3", "宠物", "只有一个恐爪巢可以拾取", "default", "treasure_td","112699"},
    [72803560]={ "35162", "恐爪鸟巢穴 4", "宠物", "只有一个恐爪巢可以拾取", "default", "treasure_td","112699"},
    [72403700]={ "35162", "恐爪鸟巢穴 5", "宠物", "只有一个恐爪巢可以拾取", "default", "treasure_td","112699"},
    [70903550]={ "35162", "恐爪鸟巢穴 6", "宠物", "只有一个恐爪巢可以拾取", "default", "treasure_td","112699"},
    [70803200]={ "35162", "恐爪鸟巢穴 7", "宠物", "只有一个恐爪巢可以拾取", "default", "treasure_td","112699"},
    [54105630]={ "35162", "恐爪鸟巢穴 8", "宠物", "只有一个恐爪巢可以拾取", "default", "treasure_td","112699"},
    [39807670]={ "35162", "恐爪鸟巢穴 9", "宠物", "只有一个恐爪巢可以拾取", "default", "treasure_td","112699"},
    [38338450]={ "34257", "安葛洛什宝藏", "趣味物品 - 投掷的岩石", "", "default", "treasure_td","116119"},
    [65448860]={ "34255", "结网的囊袋", "金钱", "", "default", "treasure_td",""},
    [40608950]={ "34140", "尤里的礼物", "要塞物资", "", "default", "treasure_td","824"},
    [28397419]={ "36829", "古树的礼物", "i563 智力戒指", "在洞中; 旋转全部三个石像使它们面背对中间时将刷新宝箱", "default", "treasure_td","118686"},
    [39304172]={ "34207", "闪光之池", "要塞资源+钓鱼物品", "需要钓鱼", "default", "treasure_td","112623"},
    [46603520]={ "37338", "索克雷萨的化身", "i620 副手", "!!! 等级101 !!!", "skull_blue", "rare_h_td","119378"},
    [44003800]={ "37339", "炮兵古戈克", "i620 弩", "!!! 等级101 !!!", "skull_blue", "rare_h_td","119413"},
    [37607040]={ "34165", "考尔·裂肉者", "i558 力量单手锤", "", "skull_grey", "rare_td","116123"},
    [68201580]={ "34142", "格鲁姆博士", "趣味物品 - 臭气弹", "", "skull_grey", "rare_td","112499"},
    [34205700]={ "34221", "摩摩尔的回响", "玩具", "", "skull_green", "rare_td","113670"},
    [50808380]={ "35018", "邪皮", "i554 法术盾", "", "skull_grey", "rare_td","112373"},
    [50203520]={ "37341", "魔火扈从", "i620 敏捷戒指", "!!! 等级101 !!!", "skull_blue", "rare_h_td","119386"},
    [46005500]={ "34145", "疯狂的魔像", "i563 敏捷/力量 单手剑 或 i563 法术匕首", "", "skull_grey", "rare_td","113287"},
    [67408060]={ "34929", "加纳迪安", "i558 饰品 敏捷+精通触发", "", "skull_grey", "rare_td","116075"},
    [31806380]={ "34189", "闪翼", "有使用次数限制的短期加速增益", "", "skull_grey", "rare_td","116113"},
    [22207400]={ "36919", "格布戈尔", "i588 敏捷/智力 皮甲腰带", "点击躁动的箱子", "skull_grey", "rare_td",""},
    [47603900]={ "37340", "古托尔", "i620 法术剑", "!!! 等级101 !!!", "skull_blue", "rare_h_td","119402"},
    [48002500]={ "37312", "吞天者哈坤", "i620 力量单手剑", "!!! 等级100 !!!", "skull_blue", "rare_h_td","119403"},
    [62004600]={ "34185", "槌牙", "i558 敏捷/智力 锁甲胸", "", "skull_grey", "rare_td","116124"},
    [78005040]={ "34167", "雌鸟哈米", "i556 智力披风", "", "skull_grey", "rare_td","112369"},
    [56606360]={ "35219", "自负的卡拉佐斯/戈尔佐玛/杀戮魔女丝科西丝", "玩具", "其中之一 - 只能拾取一次", "skull_green", "rare_td","116122"},
    [66808540]={ "34498", "克里奇克斯", "玩具", "", "skull_green", "rare_td","116125"},
    [37203760]={ "37348", "库尔洛什·灭牙", "i620 敏捷匕首", "!!! 等级102 !!!", "skull_blue", "rare_h_td","119394"},
    [33803780]={ "37346", "魔女德姆拉什", "i620 布甲胸", "!!! 等级102 !!!", "skull_blue", "rare_h_td","119352"},
    [37802140]={ "37342", "燃烧军团先锋", "i620 力量/智力 板甲手腕", "!!! 等级101 !!!", "skull_blue", "rare_h_td","119385"},
    [49009200]={ "34208", "洛玛格·碎颚", "i558 力量项链", "", "skull_grey", "rare_td","116070"},
    [30502640]={ "37345", "领主考利纳克", "i620 力量戒指", "!!! 等级102 !!!", "skull_blue", "rare_h_td","119388"},
    [39004960]={ "37349", "罪孽魔女", "i620 布甲手套", "!!! 等级102 !!!", "skull_blue", "rare_h_td","119353"},
    [86403040]={ "34859", "诺洛什", "i558 饰品 全能+智力触发", "", "skull_grey", "rare_td","116077"},
    [31404750]={ "37344", "观察者奥鲁莫", "i620 智力项链+宠物", "!!! 等级102 !!! 需要5个玩家点击物品召唤", "skull_green", "rare_h_td","119375"},
    [59505960]={ "34196", "拉坎", "i563 敏捷拳套", "", "skull_grey", "rare_td","116112"},
    [41004200]={ "37347", "暗焰恐惧行者", "i620 力量单手斧", "!!! 等级102 !!!", "skull_blue", "rare_h_td","119393"},
    [41805940]={ "34671", "沙兹尔", "i554 敏捷/智力 皮甲鞋", "", "skull_grey", "rare_td","112370"},
    [67703550]={ "36858", "钢牙", "i559 敏捷长柄", "", "skull_grey", "rare_td","117562"},
    [46002740]={ "37337", "战略家安克尔、大魔导师泰卡尔、缚魂者奈拉娜", "i620 智力披风", "!!! 等级101 !!! 3个在一起", "skull_blue", "rare_h_td","119350"},
    [59008800]={ "34171", "塔拉多寡妇蛛", "i565 敏捷剑", "", "skull_grey", "rare_td","116126"},
    [53909100]={ "34668", "鸦爪祭司佐卡拉", "i560 布甲头盔", "", "skull_grey", "rare_td","116110"},
    [63802070]={ "34945", "低阶监工血鬃", "i554 力量戒指", "别杀死他的宠物", "skull_grey", "rare_td","112475"},
    [36804100]={ "37350", "警戒者帕索斯", "i620 智力/力量 板甲肩", "!!! 等级102 !!!", "skull_blue", "rare_h_td","119383"},
    [69603340]={ "34205", "游荡的守备官", "i554 力量单手剑", "", "skull_grey", "rare_td","112261"},
    [38001460]={ "37343", "毁灭者埃索瑟尔", "i620 敏捷/智力 锁甲肩+趣味物品", "!!! 等级100 !!!", "skull_blue", "rare_h_td","119371"},
    [53802580]={ "34135", "焚化者亚兹拉", "i554 敏捷/智力 锁甲手腕", "", "skull_grey", "rare_td","112263"},
    [78805540]={ "99999907", "泥皮", "", "", "skull_orange", "mount_si", "116767"},
    [67406000]={ "99999907", "泥皮", "", "", "skull_orange", "mount_si", "116767"},
    [61803220]={ "99999907", "泥皮", "", "", "skull_orange", "mount_si", "116767"},
    [62104500]={ "99999907", "泥皮", "", "", "skull_orange", "mount_si", "116767"},
    [55608060]={ "99999907", "泥皮", "", "", "skull_orange", "mount_si", "116767"},
    [47004800]={ "99999908", "灵爪飞鹰", "传送门随机出现", "", "skull_purple", "mount_vt", "121815"},
    [39705540]={ "99999908", "灵爪飞鹰", "传送门随机出现", "", "skull_purple", "mount_vt", "121815"},
    [52002600]={ "99999908", "灵爪飞鹰", "传送门随机出现", "", "skull_purple", "mount_vt", "121815"},
    [46205260]={ "99999908", "灵爪飞鹰", "传送门随机出现", "", "skull_purple", "mount_vt", "121815"},
    [51904120]={ "99999908", "灵爪飞鹰", "传送门随机出现", "", "skull_purple", "mount_vt", "121815"},
}

nodes["SpiresOfArak"] = {
    [40595497]={ "36458", "被遗弃的采矿锄", "i578 力量单手斧", "在德拉诺允许更加快速的采矿", "default", "treasure_soa","116913"},
    [36195446]={ "36462", "海军上将泰勒的保险箱", "要塞物资", "需要一把旧钥匙", "default", "treasure_soa","824"},
    [37705640]={ "36462", "旧钥匙", "海军上将泰勒资源宝箱钥匙", "", "default", "treasure_soa","116020"},
    [49203721]={ "36445", "刺客的长矛", "i580 敏捷长柄", "", "default", "treasure_soa","116835"},
    [55539086]={ "36367", "战争捐赠物资", "金钱", "", "default", "treasure_soa",""},
    [68428898]={ "36453", "折币的报酬", "要塞物资", "", "default", "treasure_soa","824"},
    [36585791]={ "36418", "厄菲阿尔的黑暗魔典", "i579 副手", "", "default", "treasure_soa","116914"},
    [50502210]={ "36246", "龟裂的太阳石", "垃圾物品", "", "default", "treasure_soa","116919"},
    [37154750]={ "36420", "要塞补给品", "要塞物资", "", "default", "treasure_soa","824"},
    [41855042]={ "36451", "要塞工匠的锤子", "i580 力量单手锤", "", "default", "treasure_soa","116918"},
    [48604450]={ "36386", "安苏之赐", "i585 弩", "饮用一个暗影视觉药剂 靠近圣物盒以获取安苏之赐", "default", "treasure_soa","118237"},
    [57007900]={ "36390", "安苏之赐", "i585 法术单手剑", "饮用一个暗影视觉药剂 靠近圣物盒以获取安苏之赐", "default", "treasure_soa","118241"},
    [46954044]={ "36389", "安苏之赐", "i585 敏捷/力量长柄", "饮用一个暗影视觉药剂 靠近圣物盒以获取安苏之赐", "default", "treasure_soa","118238"},
    [52031958]={ "36392", "安苏之赐", "i585 法术法杖", "饮用一个暗影视觉药剂 靠近圣物盒以获取安苏之赐", "default", "treasure_soa","118239"},
    [42402670]={ "36388", "安苏之赐", "i585 魔杖", "饮用一个暗影视觉药剂 靠近圣物盒以获取安苏之赐", "default", "treasure_soa","118242"},
    [61105537]={ "36381", "安苏之赐", "i585 敏捷/力量 单手剑", "饮用一个暗影视觉药剂 靠近圣物盒以获取安苏之赐", "default", "treasure_soa","118240"},
    [50332579]={ "36444", "钢铁部落炸药", "垃圾物品", "", "default", "treasure_soa","118691"},
    [50782874]={ "36247", "失落的草药袋", "草药", "", "default", "treasure_soa","109124"},
    [47773612]={ "36411", "失落的戒指", "i578 智力戒指", "", "default", "treasure_soa","116911"},
    [52474280]={ "36416", "遗失的卷轴", "考古碎片", "要求考古学和可能一点跳跃", "default", "treasure_soa_a",""},
    [42691832]={ "36244", "遗失的卷轴", "考古碎片", "要求考古学和可能一点跳跃", "default", "treasure_soa_a",""},
    [63586737]={ "36454", "神秘菌菇", "草药", "", "default", "treasure_soa","109127"},
    [60808780]={ "35481", "尼兹克西的箱子", "要塞资源", "点击尼兹克西逃生舱在60.9 88.0并跟随他到岸边", "default", "treasure_soa","824"},
    [53315552]={ "36403", "鸦母的供品 1", "奖励5%休息经验值的消耗品", "", "default", "treasure_soa","118267"},
    [48355261]={ "36405", "鸦母的供品 2", "奖励5%休息经验值的消耗品", "", "default", "treasure_soa","118267"},
    [48905470]={ "36406", "鸦母的供品 3", "奖励5%休息经验值的消耗品", "", "default", "treasure_soa","118267"},
    [51886465]={ "36407", "鸦母的供品 4", "奖励5%休息经验值的消耗品", "", "default", "treasure_soa","118267"},
    [60976387]={ "36410", "鸦母的供品 5", "奖励5%休息经验值的消耗品", "", "default", "treasure_soa","118267"},
    [58706024]={ "36340", "独眼魔战利品", "垃圾物品", "", "default", "treasure_soa","116921"},
    [36283934]={ "36402", "兽人信号号角", "i577 饰品 溅射+力量触发", "", "default", "treasure_soa","120337"},
    [36821716]={ "36243", "流亡者财物 1", "金钱+随机绿装", "", "default", "treasure_soa",""},
    [42172168]={ "36447", "流亡者财物 2", "金钱+随机绿装", "", "default", "treasure_soa",""},
    [46903406]={ "36446", "流亡者袋子", "金钱+随机绿装", "", "default", "treasure_soa",""},
    [42961637]={ "36245", "流亡者圣物 1", "考古碎片", "要求考古学和可能一点跳跃", "default", "treasure_soa_a",""},
    [45964415]={ "36354", "流亡者圣物 2", "考古碎片", "要求考古学和可能一点跳跃", "default", "treasure_soa_a",""},
    [43162726]={ "36355", "流亡者圣物 3", "考古碎片", "要求考古学和可能一点跳跃", "default", "treasure_soa_a",""},
    [67373983]={ "36356", "流亡者圣物 4", "考古碎片", "要求考古学和可能一点跳跃", "default", "treasure_soa_a",""},
    [60215391]={ "36359", "流亡者圣物 5", "考古碎片", "要求考古学和可能一点跳跃", "default", "treasure_soa_a",""},
    [51894892]={ "36360", "流亡者圣物 6", "考古碎片", "要求考古学和可能一点跳跃", "default", "treasure_soa_a",""},
    [37375056]={ "36657", "鲁比的洛洛", "i581 力量项链", "你需要在地窖中从厨师拿到鲁比饼干来喂狗", "default", "treasure_soa","116887"},
    [44331204]={ "36377", "鲁克玛的影像", "垃圾物品", "", "default", "treasure_soa","118693"},
    [59179064]={ "36366", "水手扎祖克的高纯度朗姆酒  ", "酒精饮料", "", "default", "treasure_soa","116917"},
    [68333893]={ "36375", "塞泰克神像", "垃圾物品", "", "default", "treasure_soa","118692"},
    [71644859]={ "36450", "塞泰克仪式用酒", "治疗药水+酒精饮料", "", "default", "treasure_soa","109223"},
    [56232881]={ "36362", "碎手宝箱", "要塞物资", "", "default", "treasure_soa","824"},
    [47923065]={ "36361", "碎手保险箱", "真钢宝箱", "", "default", "treasure_soa","116920"},
    [60868461]={ "36456", "切割机零件", "要塞物资", "", "default", "treasure_soa","824"},
    [56294531]={ "36433", "走私的埃匹希斯遗物", "考古碎片", "要求考古学和可能一点跳跃", "default", "treasure_soa_a",""},
    [59638134]={ "36365", "自动喷洒机5000XT型", "要塞物资", "", "default", "treasure_soa","824"},
    [34142751]={ "36421", "烈日宝箱 1", "要塞物资", "", "default", "treasure_soa","824"},
    [33292727]={ "36422", "烈日宝箱 2", "考古碎片", "要求考古学和可能一点跳跃", "default", "treasure_soa_a",""},
    [54353255]={ "36364", "毒牙毒液", "100 要塞物资", "", "default", "treasure_soa","118695"},
    [66475653]={ "36455", "浸水的背包", "金钱+随机绿装", "", "default", "treasure_soa",""},
    [57802220]={ "36374", "安苏的雕像", "垃圾物品", "", "default", "treasure_soa","118694"},
    [58208460]={ "36291", "贝蒂斯·爆篮", "i583 枪", "", "skull_grey", "rare_soa","116907"},
    [46802300]={ "35599", "剑舞者艾瑞克斯", "垃圾物品", "", "skull_grey", "rare_soa","116839"},
    [64006480]={ "36283", "凋零之光", "i586 敏捷/智力 皮甲肩", "", "skull_grey", "rare_soa","118205"},
    [46402860]={ "36267", "杜卡斯·钢喉", "i586 敏捷/智力 锁甲鞋", "", "skull_grey", "rare_soa","118198"},
    [69005400]={ "37406", "艾奇迪纳", "未知", "!!! 等级100 !!!", "skull_blue", "rare_h_soa",""},
    [54803960]={ "36297", "脓花", "i584 副手", "", "skull_grey", "rare_soa","118200"},
    [25202420]={ "36943", "加兹", "要塞物资", "", "skull_grey", "rare_soa","824"},
    [74404280]={ "37390", "暴食巨人", "i620 魔杖", "!!! 等级100 !!!", "skull_blue", "rare_h_soa","119404"},
    [33005900]={ "36305", "贪鳍", "垃圾物品", "", "skull_grey", "rare_soa","116836"},
    [59201500]={ "36887", "独居的白鬃", "i582 布甲头盔", "", "skull_grey", "rare_soa","118279"},
    [56609460]={ "36306", "孢子吞噬者贾斯卡", "i589 饰品 急速+智力触发", "", "skull_grey", "rare_soa","118202"},
    [62603740]={ "36268", "浴血的卡洛斯", "i588 布甲胸", "", "skull_grey", "rare_soa","118735"},
    [53208900]={ "36396", "穆塔芬", "i589 力量双手锤", "", "skull_grey", "rare_soa","118206"},
    [36405240]={ "36129", "纳斯·杜柏林", "i578 敏捷/力量长柄", "", "skull_grey", "rare_soa","116837"},
    [66005500]={ "36288", "复仇者奥斯奇拉", "i589 敏捷匕首", "", "skull_grey", "rare_soa","118204"},
    [59403740]={ "36279", "毒药大师波塔斯克", "i583 饰品 溅射+使用后伤害", "", "skull_grey", "rare_soa","118199"},
    [38402780]={ "36470", "烂菌", "宠物", "", "skull_green", "rare_soa","118107"},
    [69004880]={ "36276", "桑里卡斯", "i589 敏捷/智力 皮甲胸", "", "skull_grey", "rare_soa","118203"},
    [71203380]={ "37392", "暗影巨人", "i620 敏捷/智力 皮甲腿", "!!! 等级100 !!!", "skull_blue", "rare_h_soa","119363"},
    [52003540]={ "36478", "影皮", "i579 法术盾", "", "skull_grey", "rare_soa","118201"},
    [51800720]={ "37394", "日光放大器", "i620 智力长柄", "!!! 等级100 !!!", "skull_blue", "rare_h_soa","119407"},
    [33402200]={ "36265", "岩怒", "i577 敏捷/智力 锁甲腿", "", "skull_grey", "rare_soa","116858"},
    [58604520]={ "36298", "碎棘", "i578 敏捷单手剑", "", "skull_grey", "rare_soa","116855"},
    [52805480]={ "36472", "沼叶", "i582 法术法杖", "", "skull_grey", "rare_soa","116857"},
    [54606320]={ "36278", "断爪者", "i578 敏捷项链", "", "skull_grey", "rare_soa","116838"},
    [57407400]={ "36254", "破碎者特斯卡", "i578 智力项链", "", "skull_grey", "rare_soa","116852"},
    [71702010]={ "37360", "无形梦魇怪", "i620 敏捷/智力 锁甲手腕", "!!! 等级100 !!! 位于虚空传送门界面内", "skull_blue", "rare_h_soa","119373"},
    [71404500]={ "37393", "吉加哨兵", "i620 敏捷单手剑", "!!! 等级100 !!!", "skull_blue", "rare_h_soa","119401"},
    [70402380]={ "37361", "拆解者基诺斯", "i620 布甲头盔", "!!! 等级100 !!! 位于虚空传送门界面内; 需要3名玩家点击符文石召唤", "skull_blue", "rare_h_soa","119354"},
    [74413864]={ "37391", "机械掠夺者", "i620 敏捷单手锤", "!!! 等级100 !!!", "skull_blue", "rare_h_soa","119398"},
    [72401940]={ "37358", "锢魂者托雷克", "玩具+i620 法术法杖", "!!! 等级100 !!!", "skull_green", "rare_h_soa","119410"},
    [72903090]={ "37359", "虚空掠夺者乌奈", "i620 敏捷单手斧", "!!! 等级100 !!!", "skull_blue", "rare_h_soa","119392"},
    [47002000]={ "99999909", "灵爪飞鹰", "传送门随机出现", "", "skull_purple", "mount_vt", "121815"},
    [50400610]={ "99999909", "灵爪飞鹰", "传送门随机出现", "", "skull_purple", "mount_vt", "121815"},
    [36551820]={ "99999909", "灵爪飞鹰", "传送门随机出现", "", "skull_purple", "mount_vt", "121815"},
    [60801120]={ "99999909", "灵爪飞鹰", "传送门随机出现", "", "skull_purple", "mount_vt", "121815"},
}

nodes["NagrandDraenor"] = {
    [73071080]={ "35951", "一堆泥土", "要塞物资", "", "default", "treasure_ng","824"},
    [67655971]={ "35759", "被遗弃的货箱", "随机绿装", "", "default", "treasure_ng",""},
    [38404940]={ "36711", "阿布加尔最爱的鱼饵", "阿布加尔最爱的鱼饵", "结合阿布加尔的其他部份以获得追随者", "default", "treasure_ng","114245"},
    [85403870]={ "36711", "阿布加尔丢失的线轮", "阿布加尔最好的线轮", "结合阿布加尔的其他部份以获得追随者", "default", "treasure_ng","114243"},
    [65906120]={ "36711", "阿布加尔的活力", "阿布加尔的活力", "结合阿布加尔的其他部份以获得追随者", "default", "treasure_ng","114242"},
    [75816203]={ "36077", "冒险者的钉锤", "随机绿装锤子", "", "default", "treasure_ng",""},
    [82275660]={ "35765", "冒险者的包裹", "随机绿装", "", "default", "treasure_ng",""},
    [45635200]={ "35969", "冒险者的包裹", "随机绿装", "", "default", "treasure_ng",""},
    [69955244]={ "35597", "冒险者的包裹", "随机绿装", "", "default", "treasure_ng",""},
    [56567294]={ "36050", "冒险者的钱袋", "要塞物资", "在悬崖边下面; 你需要从顶部下落到那里", "default", "treasure_ng","824"},
    [73931405]={ "35955", "冒险者的袋子", "随机绿装", "", "default", "treasure_ng",""},
    [81461307]={ "35953", "冒险者的法杖", "i593 法术法杖", "", "default", "treasure_ng","116640"},
    [73057554]={ "35673", "偷来的战歌补给品", "要塞物资", "", "default", "treasure_ng","824"},
    [62546708]={ "36116", "一袋草药", "草药", "", "default", "treasure_ng","109124"},
    [77312807]={ "35986", "骨质匕首", "i597 敏捷匕首", "", "default", "treasure_ng","116760"},
    [77081662]={ "36174", "元素的宝藏", "要塞物资", "使用元素石来取得", "default", "treasure_ng","824"},
    [81083725]={ "35661", "闪亮的梦境花瓣", "回魔药水", "乘探险家伦佐的滑翔翼到那里     [这里的东北方]", "default", "treasure_ng","118262"},
    [85415347]={ "35696", "火刃宝箱", "随机绿装", "", "default", "treasure_ng","824"},
    [66961949]={ "35954", "元素祭品", "垃圾物品", "", "default", "treasure_ng","118234"},
    [78901556]={ "36036", "元素镣铐", "i605 敏捷戒指", "", "default", "treasure_ng","118251"},
    [53407320]={ "900003", "探险家比斯伯", "无 - 需要 2 财宝 在南边", "您需要使用火箭到他那边     [他位置的东南方]", "glider", "treasure_ng",""},
    [67601420]={ "900004", "探险家德兹", "无 - 需要 2 财宝 [1 东南, 1 西南]", "你能联系到他在元素高原东边开始的地方", "glider", "treasure_ng",""},
    [87204100]={ "900005", "探险家加里克斯", "无", "需要 2 财宝 [1 南方, 1 东南]", "glider", "treasure_ng",""},
    [75606460]={ "900006", "探险家拉祖克", "无", "需要 3 财宝 [1 北, 1 东, 1 南]", "glider", "treasure_ng",""},
    [83803380]={ "900007", "探险家伦佐", "无", "需要 3 财宝 [2 东北, 1 西南]", "glider", "treasure_ng",""},
    [45866629]={ "36020", "沃舒古碎片", "i607 智力盾", "", "default", "treasure_ng","117981"},
    [73052153]={ "35692", "淡水蛤蜊", "垃圾物品", "", "default", "treasure_ng","118233"},
    [88901824]={ "35660", "长满真菌的宝箱", "要塞物资", "乘探险家伦佐的滑翔翼到那里 [这里的西南方]", "default", "treasure_ng","824"},
    [75374711]={ "36074", "赌徒的钱袋", "趣味物品", "", "default", "treasure_ng","118236"},
    [43225755]={ "35987", "吉尼达尔残骸", "要塞物资", "", "default", "treasure_ng","824"},
    [48066011]={ "35999", "吉尼达尔残骸", "要塞物资", "", "default", "treasure_ng","824"},
    [48587279]={ "36008", "吉尼达尔残骸", "要塞物资", "", "default", "treasure_ng","824"},
    [44696757]={ "36002", "吉尼达尔残骸", "要塞物资", "", "default", "treasure_ng","824"},
    [55356828]={ "36011", "吉尼达尔残骸", "要塞物资", "", "default", "treasure_ng","824"},
    [72976212]={ "35590", "地精包裹", "要塞物资", "乘探险家拉祖克的滑翔翼到那里 [这里的东南方]", "default", "treasure_ng","824"},
    [47207425]={ "35576", "地精包裹", "要塞物资", "乘探险家比斯伯的滑翔翼到那里 [这里的东方]", "default", "treasure_ng","824"},
    [58285249]={ "35694", "金色卡利鸟蛋", "垃圾物品", "在树上的鸟巢里", "default", "treasure_ng","118266"},
    [38345872]={ "36109", "金趾的战利品", "金钱", "钥匙在鹦鹉上", "default", "treasure_ng",""},
    [87107288]={ "36051", "灰喉的骨头堆", "宠物 玩具", "", "default", "treasure_ng","118054"},
    [87624498]={ "35622", "藏匿物", "要塞物资", "乘探险家加里克斯的滑翔翼到那里 [这里的北方]", "default", "treasure_ng","824"},
    [67384906]={ "36039", "悬槌大锤", "i605 力量戒指", "", "default", "treasure_ng","118252"},
    [75236563]={ "36099", "重要的探索补给", "酒精饮料", "", "default", "treasure_ng","61986"},
    [61765747]={ "36082", "遗失的吊坠", "i593 随机绿装项链", "", "default", "treasure_ng","116687"},
    [70531385]={ "35643", "登山者的包裹", "要塞物资", "乘探险家德兹的滑翔翼到那里 [这里的西方]", "default", "treasure_ng","824"},
    [80967979]={ "36049", "食人魔念珠", "i605 力量戒指", "", "default", "treasure_ng","118255"},
    [57796205]={ "36115", "白鬼药剂", "回魔药水", "", "default", "treasure_ng","118278"},
    [58295931]={ "36021", "波卡尔的第十三把斧子", "i605 力量单手斧", "", "default", "treasure_ng","116688"},
    [72716092]={ "36035", "抛光的刃牙虎人颅骨", "i605 敏捷/力量戒指", "", "default", "treasure_ng","118254"},
    [58507630]={ "900008", "地精火箭", "无", "使用火箭到探险家比斯伯那里", "rocket", "treasure_ng",""},
    [75186494]={ "36102", "刃牙虎人储物箱", "金钱", "", "default", "treasure_ng",""},
    [89073313]={ "36857", "走私者的箱子", "要塞物资", "", "default", "treasure_ng","824"},
    [40346864]={ "37435", "幽灵宝箱", "要塞物资", "", "default", "treasure_ng","824"},
    [50128228]={ "35577", "热砂补给品", "要塞物资", "乘探险家比斯伯的滑翔翼到那里 [这里的东北方]", "default", "treasure_ng","824"},
    [52678008]={ "35583", "热砂补给品", "要塞物资", "乘探险家比斯伯的滑翔翼到那里 [这里的北方]", "default", "treasure_ng","824"},
    [77835195]={ "35591", "热砂补给品", "要塞物资", "乘探险家拉祖克的滑翔翼到那里 [这里的南方]", "default", "treasure_ng","824"},
    [64591762]={ "35648", "热砂补给品", "要塞物资", "乘探险家德兹的滑翔翼到那里 [这里的东北方]", "default", "treasure_ng","824"},
    [70601860]={ "35646", "热砂补给品", "要塞物资", "乘探险家德兹的滑翔翼到那里 [这里的西北方]", "default", "treasure_ng","824"},
    [87602028]={ "35662", "热砂补给品", "要塞物资", "乘探险家伦佐的滑翔翼到那里 [这里的西南方]", "default", "treasure_ng","824"},
    [88274262]={ "35616", "热砂补给品", "要塞物资", "乘探险家加里克斯的滑翔翼到那里 [这里的西北方]", "default", "treasure_ng","824"},
    [64716583]={ "36046", "塔拉防御护盾", "i605 敏捷/智力戒指", "", "default", "treasure_ng","118253"},
    [37717065]={ "34760", "库尔克罗什的宝藏", "要塞物资", "", "default", "treasure_ng","824"},
    [49976651]={ "35579", "注灵水晶", "i613 力量双手剑", "", "default", "treasure_ng","118264"},
    [51726029]={ "35695", "战歌宝箱", "要塞物资", "", "default", "treasure_ng","824"},
    [52414438]={ "36073", "战歌头盔", "i609 敏捷/智力锁甲头盔", "", "default", "treasure_ng","118250"},
    [73047036]={ "35678", "战歌保险箱", "要塞物资", "", "default", "treasure_ng","824"},
    [76066990]={ "35682", "战歌长矛", "垃圾物品", "乘探险家拉祖克的滑翔翼到那里 [这里的北方]", "default", "treasure_ng","118678"},
    [80656054]={ "35593", "战歌战利品", "要塞物资", "乘探险家拉祖克的滑翔翼到那里 [这里的西方]", "default", "treasure_ng","824"},
    [89406588]={ "35976", "战歌补给品", "要塞物资", "", "default", "treasure_ng","824"},
    [64763573]={ "36071", "防水袋", "20格包", "", "default", "treasure_ng","118235"},
    [53386425]={ "36088", "冒险者的袋子", "随机绿装", "在洞里; 入口在东面", "default", "treasure_ng","824"},
    [35475725]={ "36846", "幽灵的礼物", "要塞资源", "", "default", "treasure_ng","824"},
    [84605340]={ "35778", "先祖剑圣", "i598 力量项链", "", "skull_grey", "rare_ng","116832"},
    [51001600]={ "37210", "奥盖克松", "热砂保护协会的声望物品", "", "swprare", "rare_s_ng","118654"},
    [62601680]={ "37211", "伯格鲁", "热砂保护协会的声望物品", "", "swprare", "rare_s_ng","118655"},
    [77006400]={ "35735", "狂暴T-300系列II型", "要塞物资", "在一个山洞内, 使用一个开关开启", "skull_grey", "rare_ng","824"},
    [39501330]={ "37396", "碎骨者", "i620 敏捷/智力 锁甲腿", "", "skull_blue", "rare_h_ng","119370"},
    [43003640]={ "37400", "布塔格·利刃", "i620 智力/力量板甲鞋", "!!! 等级100 !!!", "skull_blue", "rare_h_ng","119380"},
    [34607700]={ "34727", "铁须队长", "玩具+i607 枪", "", "skull_green", "rare_ng","118244"},
    [64203000]={ "37221", "德考汉", "热砂保护协会的声望物品", "", "swprare", "rare_s_ng","118656"},
    [60003800]={ "37222", "恐蹄", "热砂保护协会的声望物品", "", "swprare", "rare_s_ng","118657"},
    [38602240]={ "37395", "杜戈·碎脊", "i620 敏捷双手锤", "", "skull_blue", "rare_h_ng","119405"},
    [89004120]={ "35623", "探险家诺赞德 ", "垃圾物品", "", "skull_grey", "rare_ng","118679"},
    [74801180]={ "35836", "锯齿", "垃圾物品", "", "skull_grey", "rare_ng","116836"},
    [70004180]={ "35893", "燧皮", "i609 力量盾", "", "skull_grey", "rare_ng","116807"},
    [48202220]={ "37223", "野蛮的伽罗格", "热砂保护协会的声望物品", "", "swprare", "rare_s_ng","118658"},
    [52205580]={ "35715", "加鲁尔", "i605 饰品 溅射+狼触发", "", "skull_grey", "rare_ng","118246"},
    [42207860]={ "34725", "加兹奥达", "i602 智力戒指", "在洞穴内", "skull_grey", "rare_ng","116798"},
    [66605660]={ "35717", "狂暴的瘤蹄", "i598 饰品 溅射+敏捷触发", "", "skull_grey", "rare_ng","116824"},
    [93202820]={ "35898", "血花", "i602 敏捷/智力 皮甲手套", "这手套可以让你在德拉诺采草快点", "skull_grey", "rare_ng","116916"},
    [42003680]={ "37472", "高塔格·钢握", "埃匹希斯水晶", "使用秘密接头详情后从传信号角物品召唤", "skull_blue", "rare_h_ng","824"},
    [84603660]={ "36159", "砂齿", "i609 敏捷/智力 皮甲手腕", "", "skull_grey", "rare_ng","118689"},
    [66805120]={ "35714", "巨羽", "i600 布甲胸", "", "skull_grey", "rare_ng","116795"},
    [86007160]={ "35784", "灰喉", "i610 力量披风", "", "skull_grey", "rare_ng","118687"},
    [80603040]={ "35923", "猎手黑齿", "i609 敏捷双手锤", "", "skull_grey", "rare_ng","118245"},
    [87005500]={ "34862", "亥伯里奥斯", "i597 饰品 急速+精通触发", "", "skull_grey", "rare_ng","116799"},
    [45803480]={ "37399", "卡洛什·黑风", "i620 布甲腿", "", "skull_blue", "rare_h_ng","119355"},
    [43803440]={ "37473", "卡拉尔·死眼", "埃匹希斯水晶", "使用秘密接头详情后从传信号角物品召唤", "skull_blue", "rare_h_ng",""},
    [58201200]={ "37398", "开膛者克鲁德", "i620 智力/力量 板甲腰带+成就", "在他旁边杀死15个小怪会使其可被攻击", "skull_blue", "rare_h_ng","119384"},
    [52009000]={ "37408", "莱纳亚", "未知", "", "skull_blue", "rare_h_ng",""},
    [81206000]={ "35932", "马尔洛克·裂石", "i597 敏捷法杖", "", "skull_grey", "rare_ng","116796"},
    [45801520]={ "36229", "老钳子先生", "i616 饰品 溅射+龙虾人触发", "", "skull_grey", "rare_ng","118690"},
    [34005100]={ "37224", "穆格拉", "热砂保护协会的声望物品", "", "swprare", "rare_s_ng","118659"},
    [47607080]={ "35865", "灵魔", "宠物", "", "skull_green", "rare_ng","116815"},
    [42804920]={ "35875", "奥菲斯", "i602 布甲腿", "", "skull_grey", "rare_ng","116765"},
    [61806900]={ "35943", "侦察骑兵杜莉萨", "i598 敏捷/智力 皮甲鞋", "", "skull_grey", "rare_ng","116800"},
    [58201800]={ "37637", "竞技场野兽", "i620 敏捷/力量 坦克披风", "", "skull_blue", "rare_h_ng","120317"},
    [39701440]={ "37397", "角斗场屠杀者", "i620 力量戒指", "", "skull_blue", "rare_h_ng","119389"},
    [73605780]={ "35712", "狂野的赤爪", "i604 智力拳套", "", "skull_grey", "rare_ng","118243"},
    [58008400]={ "35900", "鲁克拉", "i608 智力/力量 板甲肩", "", "skull_grey", "rare_ng","118688"},
    [54806120]={ "35931", "斥候波卡尔", "i601 力量单手斧", "", "skull_grey", "rare_ng","116797"},
    [60934775]={ "35912", "西恩·怀特斯", "i600 敏捷/智力 皮甲腰带", "当遗弃的箱子刷新时可拾取", "skull_grey", "rare_ng","116834"},
    [75606500]={ "36128", "灵牙", "i597 智力剑", "", "skull_grey", "rare_ng","116806"},
    [58403580]={ "37225", "泰克塔伦", "热砂保护协会的声望物品", "", "swprare", "rare_s_ng","118660"},
    [65003900]={ "35920", "图拉卡", "i609 敏捷披风", "", "skull_grey", "rare_ng","116814"},
    [37003800]={ "37520", "邪爪", "热砂保护协会的声望物品", "", "swprare", "rare_s_ng","120172"},
    [82607620]={ "34645", "战争大师布格索尔", "i600 力量/智力 板甲手腕", "", "skull_grey", "rare_ng","116805"},
    [70602940]={ "35877", "唤风者科拉斯特", "i598 法术法杖", "", "skull_grey", "rare_ng","116808"},
    [41004400]={ "37226", "艾克加纳克", "热砂保护协会的声望物品", "", "swprare", "rare_s_ng","118661"},
    [26203420]={ "98198", "鲁克都格", "宠物", "", "skull_green", "rare_h_ng","129216"},
    [28503030]={ "98199", "普格", "宠物", "", "skull_green", "rare_h_ng","129217"},
    [23803790]={ "98200", "甘克", "宠物", "", "skull_green", "rare_h_ng","129218"},
    [50003440]={ "99999910", "雷霆纳克", "", "", "skull_yellow", "mount_na", "116659"},
    [55003500]={ "99999910", "雷霆纳克", "", "", "skull_yellow", "mount_na", "116659"},
    [62801540]={ "99999910", "雷霆纳克", "", "", "skull_yellow", "mount_na", "116659"},
    [64601980]={ "99999910", "雷霆纳克", "", "", "skull_yellow", "mount_na", "116659"},
    [76203180]={ "99999911", "鲁克胡克", "", "", "skull_orange", "mount_lu", "116661"},
    [66604400]={ "99999911", "鲁克胡克", "", "", "skull_orange", "mount_lu", "116661"},
    [72805360]={ "99999911", "鲁克胡克", "", "", "skull_orange", "mount_lu", "116661"},
    [79205600]={ "99999911", "鲁克胡克", "", "", "skull_orange", "mount_lu", "116661"},
    [84206360]={ "99999911", "鲁克胡克", "", "", "skull_orange", "mount_lu", "116661"},
    [57302670]={ "99999912", "灵爪飞鹰", "传送门随机出现", "", "skull_purple", "mount_vt", "121815"},
    [40504760]={ "99999912", "灵爪飞鹰", "传送门随机出现", "", "skull_purple", "mount_vt", "121815"},
    [45903140]={ "99999912", "灵爪飞鹰", "传送门随机出现", "", "skull_purple", "mount_vt", "121815"},
    [51001600]={ "37210", "奥盖克松", "热砂保护协会的声望物品", "", "swprare", "rare_s_ng","118654"},
}

nodes["TanaanJungle"] = {
    [15005440]={ "38754", "哀狼之斧", "i650 力量双手斧", "东北塔第一层", "default", "treasure_tj","127325"},
    [15905930]={ "38757", "格兰诺克之眼", "i650 智力/急速/溅射 饰品", "东南塔第二层", "default", "treasure_tj","128220"},
    [17305690]={ "38755", "战争横财", "250 要塞物资", "", "default", "treasure_tj","824"},
    [17005300]={ "38283", "失窃的船长宝箱", "少量金钱", "", "default", "treasure_tj",""},
    [15904980]={ "38208", "风化的斧子", "i650 敏捷单手斧", "魔荚人洞穴内", "default", "treasure_tj","127324"},
    [25305020]={ "38735", "“借来”的魔法望远镜", "i650 智力/暴击 饰品", "位于东塔顶层", "default", "treasure_tj","128222"},
    [22004780]={ "38678", "血环战场储物箱", "100 要塞物资", ".", "default", "treasure_tj","824"},
    [26804410]={ "38683", "抢来的血环宝藏", "变形物品", "塔纳安任务线#3完成后解锁", "default", "treasure_tj","127709"},
    [19304090]={ "38320", "卡纳克之刃", "i650 敏捷单手剑", "水下", "default", "treasure_tj","127338"},
    [31403110]={ "38732", "鸦人嵌宝雕像", "德拉诺之王宝石", "从岩石上跳过去", "default", "treasure_tj","127413"},
    [28803460]={ "38863", "挖过的埃匹希斯水晶", "埃匹希斯水晶", "洞穴入口在 29.2 / 31.1", "default", "treasure_tj","823"},
    [34703460]={ "38742", "疯狂酋长之颅", "缓速降落/水上行走物品", "洞穴入口在 32.5 / 37.4", "default", "treasure_tj","127669"},
    [26506300]={ "38741", "抢来的血环宝藏", "埃匹希斯水晶和要塞物资", "在塔顶端", "default", "treasure_tj","823"},
    [32407040]={ "38426", "隐秘之书", "玩具", "", "default", "treasure_tj","127670"},
    [30407200]={ "38629", "抛光水晶", "德拉诺之王宝石", "", "default", "treasure_tj","127390"},
    [37004620]={ "38640", "反白鬼设备", "要塞物资", "", "default", "treasure_tj","824"},
    [36304350]={ "37956", "古怪的蓝宝石", "i650 耐力/护甲饰品", "", "default", "treasure_tj","127397"},
    [43203830]={ "38821", "指挥官的盾牌", "i650 力量/智力盾", "", "default", "treasure_tj","127348"},
    [42803540]={ "38822", "炫目之杖", "玩具", "位于东北塔顶层", "default", "treasure_tj","127859"},
    [46904210]={ "38776", "献祭之刃", "i650 法强匕首", "", "default", "treasure_tj","127328"},
    [46904440]={ "38773", "被邪能侵蚀的背包", "头部装饰品（护目镜）", "", "default", "treasure_tj","128218"},
    [46903660]={ "38771", "茨兹克的书", "i650 法系副手", "", "default", "treasure_tj","127347"},
    [50806490]={ "38731", "巨型遗物", "i650 敏捷/力量戒指", "", "default", "treasure_tj","127412"},
    [54806930]={ "38593", "倒伏的狩猎长矛", "i650 敏捷长柄", "", "default", "treasure_tj","127334"},
    [47907040]={ "38705", "晶化元素精华", "i650 法系拳套", "", "default", "treasure_tj","127329"},
    [57006500]={ "38591", "被遗忘的袋子", "趣味物品+兽皮", "", "default", "treasure_tj","110609"},
    [46207280]={ "38739", "神秘的腐化方尖碑", "附属品", "塔纳安任务线#5完成后解锁", "default", "treasure_tj","128320"},
    [41607330]={ "38657", "被遗忘的勇士之剑", "i650 力量双手剑", "", "default", "treasure_tj","127339"},
    [40807550]={ "38639", "完美之花", "玩具", "从旁边的神秘水果获取免疫的增益防止拾取被打断。", "default", "treasure_tj","127766"},
    [40607980]={ "38638", "驯蛇人的笛子", "i650 法系双手锤", "", "default", "treasure_tj","127333"},
    [34407830]={ "38762", "隐藏的铁海宝藏#3", "金钱和要塞物资", "洞穴入口在 37.5 / 76.0", "default", "treasure_tj","824"},
    [35007730]={ "38761", "隐藏的铁海宝藏#2", "金钱和要塞物资", "洞穴入口在 37.5 / 76.0", "default", "treasure_tj","824"},
    [33907810]={ "38760", "隐藏的铁海宝藏#1", "金钱和要塞物资", "洞穴入口在 37.5 / 76.0", "default", "treasure_tj","824"},
    [35907860]={ "38758", "铁须的宝藏", "金钱和要塞物资", "", "default", "treasure_tj","824"},
    [37708070]={ "38788", "觉醒火盆", "复活附属品", "", "default", "treasure_tj","127770"},
    [48507520]={ "38814", "抢来的神秘法杖", "i650 法系法杖", "洞穴入口在 44.4 / 77.5", "default", "treasure_tj","127337"},
    [49907680]={ "38809", "血环蘑菇桶", "有副作用的食物", "洞穴入口在 44.4 / 77.5", "default", "treasure_tj","128223"},
    [62107070]={ "38602", "晶化邪能尖刺", "i650 智力/精神饰品", "", "default", "treasure_tj","128217"},
    [61207580]={ "38601", "黑齿岛宝箱", "要塞物资", "", "default", "treasure_tj","824"},
    [49907960]={ "38703", "斥候的财物", "i650 敏捷披风", "洞穴顶端", "default", "treasure_tj","127354"},
    [49908120]={ "38702", "被遗弃的头盔", "i650 敏捷/智力锁甲头盔", "在洞穴内", "default", "treasure_tj","127312"},
    [64704280]={ "38701", "松散的土壤", "变形玩具", "", "default", "treasure_tj","127396"},
    [51702430]={ "38686", "铭文腿骨", "i650 魔杖", "", "default", "treasure_tj","127341"},
    [58502520]={ "38679", "坠星珠宝", "德拉诺之王宝石", "", "default", "treasure_tj","115524"},
    [62602050]={ "38682", "苦难熏炉", "i650 力量/全能饰品", "", "default", "treasure_tj","127401"},
    [51603270]={ "39075", "被邪能污染的埃匹希斯晶体", "埃匹希斯水晶", "挂在柱子的边缘", "default", "treasure_tj","823"},
    [28702330]={ "38334", "地狱火珠宝", "玩具", "", "default", "treasure_tj","127668"},
    [63402810]={ "38740", "被遗忘的秘文碎片", "宠物", "塔纳安任务线#6完成后解锁", "default", "treasure_tj","128309"},
    [54909070]={ "39470", "亡灵宝藏", "要塞物资", "", "default", "treasure_tj","824"},
    [65908500]={ "39469", "珠玉彩蛋", "垃圾物品", "", "default", "treasure_tj","128386"},
    [69705600]={ "38704", "被遗忘的钢铁部落补给品", "要塞物资", "", "default", "treasure_tj","824"},
    [73604320]={ "38779", "隐藏的血环战利品", "金钱+垃圾物品", "位于东北塔第一层", "default", "treasure_tj",""},
    [13605680]={ "38747", "索戈尔·血拳", "i655 敏捷/智力锁甲靴子", "", "skull_blue", "rare_h_tj","127310","28347"},
    [13005700]={ "38751", "钢铁训犬师", "i655 力量/智力板甲护肩", "夺取据点（西）后会出现。需要钢铁前线事件", "skull_blue", "rare_h_tj","127321","28350"},
    [16005920]={ "38750", "格兰诺克", "i655 智力项链", "位于东南塔顶层。", "skull_blue", "rare_h_tj","127649","28348"},
    [15005420]={ "38746", "指挥官卡格高斯", "i655 力量/智力 板甲手套", "位于东北塔顶层", "skull_blue", "rare_h_tj","127319", "28346"},
    [16005720]={ "38752", "扭曲的兹里克", "i655 布甲手套", "夺取据点（西）后会出现。需要钢铁前线事件", "skull_blue", "rare_h_tj","127296","28349"},
    [16804860]={ "38282", "魔荚大王瓦卡瓦姆", "i655 敏捷法杖", "", "skull_blue", "rare_h_tj","127336", "28329"},
    [23605200]={ "38262", "投掷者比尔克", "i655 敏捷/智力 皮甲肩", "", "skull_blue", "rare_h_tj","127307","28351"},
    [20404980]={ "38263", "追踪者罗贡德", "i655 敏捷/智力 锁甲肩", "", "skull_blue", "rare_h_tj","127314","28352"},
    [19805360]={ "38736", "德里斯·瓦伊尔", "i655 枪械", "位于南塔顶层", "skull_blue", "rare_h_tj","127331","28369"},
    [25504620]={ "38264", "德努尔", "i655 布甲裤子", "", "skull_blue", "rare_h_tj","127298","28354"},
    [23204840]={ "38265", "嗜血的多格", "i655 布甲腰带", "在区域内击杀怪物将使其在某处出现", "skull_blue", "rare_h_tj","127301","28353"},
    [22805120]={ "38266", "猎血者祖尔克", "i655 敏捷/智力 皮甲靴子", "打断血月仪式事件后会使他出现", "skull_blue", "rare_h_tj","127303","28355"},
    [22205080]={ "39159", "血月残骸", "玩具", "吸空血月之后会出现。需要泽斯高事件。", "skull_green", "rare_h_tj","127666"},
    [16804340]={ "38034", "拉瑟", "i655 暴击/精通/多重 饰品", "", "skull_blue", "rare_h_tj","127661","28341"},
    [20404000]={ "38028", "高阶祭司伊克赞", "变形附属品", "在营地内游荡", "skull_green", "rare_h_tj","122117"},
    [27603280]={ "37937", "该死的瓦里克斯", "i655 智力戒指", "需要5名玩家打开牢笼", "skull_blue", "rare_h_tj","127351", "28340"},
    [26305420]={ "38496", "瑞格儿", "i655 敏捷长柄", "", "skull_blue", "rare_h_tj","127335","28356"},
    [28605080]={ "38775", "邪钻", "i655 力量戒指", "洞穴入口在 31.3 / 53.5", "skull_blue", "rare_h_tj","127350","28372"},
    [31406800]={ "38031", "塞拉卡斯", "邪能幼崽-宠物", "其实怪不掉宠物，但是任务会在就杀它之后出现", "skull_green", "rare_h_tj","","28336"},
    [27607480]={ "38030", "贾克索尔", "i655 力量/智力 板甲腰带", "洞穴入口在 29.6 / 70.6", "skull_blue", "rare_h_tj","127322","28335"},
    [25807900]={ "38032", "妖女萨弗拉", "i655 布甲肩s", "洞穴入口在 29.6 / 70.6", "skull_blue", "rare_h_tj","127300","28337"},
    [25407720]={ "38029", "奥兰", "i655 敏捷/智力 锁甲 Wrist", "洞穴入口在 29.6 / 70.6", "skull_blue", "rare_h_tj","127316","28334"},
    [31607280]={ "38026", "小鬼领主瓦勒萨", "附属品", "", "skull_green", "rare_h_tj","127655","28333"},
    [35404680]={ "38609", "贝尔高克", "i655 力量/智力盾", "", "skull_blue", "rare_h_tj","127650","28363"},
    [34004440]={ "38620", "断肠者索玛", "i655 敏捷匕首", "", "skull_blue", "rare_h_tj","127327","28362"},
    [33003570]={ "38709", "高拉博什", "i655 敏捷/智力 皮甲手套", "", "skull_blue", "rare_h_tj","127304","28368"},
    [37003280]={ "39045", "大块头佐格", "i655 敏捷/智力 皮甲腰带", "", "skull_blue", "rare_h_tj","127308","28723"},
    [39603260]={ "39046", "港务长库拉克", "i655 敏捷/智力 锁甲胸甲", "", "skull_blue", "rare_h_tj","127309","28724"},
    [42403730]={ "37953", "莫加克中士", "i655 力量/智力 板甲靴子", "", "skull_blue", "rare_h_tj","127318","28339"},
    [44603760]={ "37990", "“野火”辛达尔", "i655 全能/精通/多重 饰品", "在熔炉杀掉全部辛达尔残骸之后出现", "skull_blue", "rare_h_tj","127660","28338"},
    [45804700]={ "38634", "邪能工匠达莫卡", "i655 敏捷/智力 皮甲胸甲", "", "skull_blue", "rare_h_tj","127302","28726"},
    [50003600]={ "38411", "执行官里洛斯", "i655 力量/智力 板甲护腕", "", "skull_blue", "rare_h_tj","127323","28380"},
    [46204240]={ "38400", "高阶术士奈瑟库斯", "i655 布甲胸甲", "", "skull_blue", "rare_h_tj","127299","28343"},
    [51004600]={ "38749", "指挥官奥格莫克", "i655 敏捷/智力 锁甲裤子", "在区域内巡逻", "skull_blue", "rare_h_tj","127313","28731"},
    [48005720]={ "38820", "高克玛上尉", "i655 力量/智力 板甲裤子", "", "skull_blue", "rare_h_tj","127664","28730"},
    [49706140]={ "38812", "鞭影", "i655 敏捷/智力 皮甲护腕", "", "skull_blue", "rare_h_tj","127665","28725"},
    [52206510]={ "38726", "麦格威", "i655 力量单手锤", "", "skull_blue", "rare_h_tj","127332","28345"},
    [40807000]={ "38209", "落棘", "玩具 - 烹饪用火", "", "skull_green", "rare_h_tj","127652" ,"28330"},
    [39606810]={ "38825", "堕落的科斯卡尔", "i655 力量单手剑", "洞穴入口在 42.5 / 68.9", "skull_blue", "rare_h_tj","127653","28377"},
    [34307250]={ "38654", "血爪", "i655 敏捷/智力 皮甲头盔", "洞穴入口在 36.2 / 72.4", "skull_blue", "rare_h_tj","127305","28367"},
    [39407380]={ "38632", "暗夜游魂", "i655 力量披风", "获得10层他的减益之后真身出现，方法为攻击他的“分身”或搜索被肢解的尸体", "skull_blue", "rare_h_tj","127355","28366"},
    [41007880]={ "38628", "希利萨", "i655 敏捷/智力 锁甲手套", "", "skull_blue", "rare_h_tj","127311","28364"},
    [41807380]={ "38631", "伦达克", "i655 智力披风", "", "skull_blue", "rare_h_tj","127356","28365"},
    [36207970]={ "38756", "铁须船长", "玩具", "洞穴入口在 37.5 / 76.0", "skull_green", "rare_h_tj","127659","28370"},
    [34607820]={ "38764", "古鲁布洛克", "i655 力量/智力 板甲胸甲", "洞穴入口在 37.5 / 76.0. 需要打开宝箱使其出现", "skull_blue", "rare_h_tj","127317","28371"},
    [51007440]={ "38696", "血环恐魔", "i655 耐力/护甲 饰品", "洞穴入口在 44.4 / 77.5", "skull_blue", "rare_h_tj","127654","28376"},
    [57606720]={ "38589", "巢母艾克斯科", "i655 敏捷戒指", "", "skull_blue", "rare_h_tj","127349","28357"},
    [62607200]={ "38600", "刈魂者", "i655 敏捷/智力 锁甲腰带", "", "skull_blue", "rare_h_tj","127315","28358"},
    [63608110]={ "38604", "黯爪", "i655 敏捷/智力 皮甲裤子", "", "skull_blue", "rare_h_tj","127306","28359"},
    [52108390]={ "38605", "冷静的克莱尔", "i655 敏捷/多重 饰品", "", "skull_blue", "rare_h_tj","127418","28360"},
    [48807280]={ "38597", "黑齿", "i655 敏捷拳套", "", "skull_blue", "rare_h_tj","127330","28361"},
    [48402850]={ "38207", "泽特尔", "i655 力量双手剑", "洞穴入口在 48.1 / 33.0", "skull_blue", "rare_h_tj","127340","28331"},
    [52802560]={ "38211", "魔芒", "i655 布甲护腕", "", "skull_blue", "rare_h_tj","127656","28332"},
    [53602170]={ "38557", "苦痛妖女塞萝拉", "i655 布甲头盔", "杀死多波怪物事件之后她会出现", "skull_blue", "rare_h_tj","127297","28342"},
    [57102280]={ "38457", "普崔萨", "i655 智力/精神 饰品", "", "skull_blue", "rare_h_tj","127657","28727"},
    [53002000]={ "38580", "大统领玛古斯", "i655 力量/智力 板甲头盔", "", "skull_blue", "rare_h_tj","127320","28729"},
    [60202090]={ "38579", "不朽的艾萨兹", "i655 智力副手", "", "skull_blue", "rare_h_tj","127658","28728"},
    [65403660]={ "38700", "钢吻", "i655 敏捷/力量披风", "", "skull_blue", "rare_h_tj","127357","28344"},
    [52604020]={ "38430", "毁灭者阿格什", "i655 弩", "", "skull_blue", "rare_h_tj","127326","28722"},
    [41407960]={ "37407", "科拉诺斯", "未知", "", "skull_blue", "rare_h_tj",""},
    [88005550]={ "40104", "萨姆逊·强掠", "玩具", "", "skull_green", "rare_h_tj","108634"},
    [83504380]={ "40105", "达库姆", "玩具", "", "skull_green", "rare_h_tj","108631"},
    [80405680]={ "40106", "贡达", "玩具", "", "skull_green", "rare_h_tj","108633"},
    [40705630]={ "40107", "邪能监工玛德拉普", "打下坐骑物品", "", "skull_green", "rare_h_tj","129295"},
    [13505900]={ "39288", "泰罗菲斯特", "坐骑+原油", "在刷新时弗甘喊道： 一头巨型小戈隆正冲向游侠避难所！我们需要援助！", "skull_red", "mount_tj",""},
    [23204040]={ "39287", "死爪", "坐骑+原油", "在刷新时暗影领主艾斯卡喊道： 在彼岸，你能找到的只有死亡！", "skull_red", "mount_tj",""},
    [32407400]={ "39290", "维金斯", "坐骑+原油", "在刷新时暴君维哈里喊道： 爬虫只配被碾死！", "skull_red", "mount_tj",""},
    [47005260]={ "39289", "末日之轮", "坐骑+原油", "在刷新时攻城大师玛塔克喊道： 哈哈！狠狠践踏他们的尸体吧！", "skull_red", "mount_tj",""},
}

nodes["garrisonsmvalliance_tier1"] = {
    [49604380]={ "35530", "坠月鸟蛋", "要塞物资", "在一辆货车上", "default", "treasure_smv","824"},
    [42405436]={ "35381", "派普斯埋藏的补给品 1", "要塞物资", "", "default", "treasure_smv","824"},
    [50704850]={ "35382", "派普斯埋藏的补给品 2", "要塞物资", "", "default", "treasure_smv","824"},
    [30802830]={ "35383", "派普斯埋藏的补给品 3", "要塞物资", "", "default", "treasure_smv","824"},
    [49197683]={ "35384", "派普斯埋藏的补给品 4", "要塞物资", "", "default", "treasure_smv","824"},
    [51800110]={ "35289", "斯帕克的失窃补给", "要塞物资", "在湖中的洞穴中", "default", "treasure_smv","824"},
}

nodes["garrisonsmvalliance_tier2"] = {
    [37306590]={ "35530", "坠月鸟蛋", "要塞物资", "在一辆货车上", "default", "treasure_smv","824"},
    [41685803]={ "35381", "派普斯埋藏的补给品 1", "要塞物资", "", "default", "treasure_smv","824"},
    [51874545]={ "35382", "派普斯埋藏的补给品 2", "要塞物资", "", "default", "treasure_smv","824"},
    [34972345]={ "35383", "派普斯埋藏的补给品 3", "要塞物资", "", "default", "treasure_smv","824"},
    [46637608]={ "35384", "派普斯埋藏的补给品 4", "要塞物资", "", "default", "treasure_smv","824"},
    [51800110]={ "35289", "斯帕克的失窃补给", "要塞物资", "在湖中的洞穴中", "default", "treasure_smv","824"},
}

nodes["garrisonsmvalliance_tier3"] = {
    [61277261]={ "35530", "坠月鸟蛋", "要塞物资", "在帐篷里", "default", "treasure_smv","824"},
    [60575515]={ "35381", "派普斯埋藏的补给品 1", "要塞物资", "", "default", "treasure_smv","824"},
    [37307491]={ "35382", "派普斯埋藏的补给品 2", "要塞物资", "", "default", "treasure_smv","824"},
    [37864378]={ "35383", "派普斯埋藏的补给品 3", "要塞物资", "", "default", "treasure_smv","824"},
    [61527154]={ "35384", "派普斯埋藏的补给品 4", "要塞物资", "", "default", "treasure_smv","824"},
    [51800110]={ "35289", "斯帕克的失窃补给", "要塞物资", "在湖中的洞穴中", "default", "treasure_smv","824"},
}

nodes["garrisonffhorde_tier1"] = {
    [74505620]={ "34937", "塞娜小姐的备用物资", "要塞物资", "", "default", "treasure_ffr","824"},
}

nodes["garrisonffhorde_tier2"] = {
    [74505620]={ "34937", "塞娜小姐的备用物资", "要塞物资", "", "default", "treasure_ffr","824"},
}

nodes["garrisonffhorde_tier3"] = {
    [74505620]={ "34937", "塞娜小姐的备用物资", "要塞物资", "", "default", "treasure_ffr","824"},
}

nodes["MardumtheShatteredAbyss"] = {
	[34857020]={ "39970", "小宝箱", "", "", "default", "treasure_dh", "129210"},
	[45017785]={ "39971", "小宝箱", "可重复使用药水", "", "default", "treasure_dh", "129192"},
	[41763761]={ "40759", "小宝箱", "", "", "default", "treasure_dh", "129196"},
	[51135079]={ "40743", "小宝箱", "", "", "default", "treasure_dh", "129210"},
	[76243899]={ "40338", "小宝箱", "", "洞穴入口在 77.0 / 41.4", "default", "treasure_dh", "129210"},
	[82075043]={ "40820", "小宝箱", "", "", "default", "treasure_dh", "129196"},
	[78755047]={ "40274", "小宝箱", "", "", "default", "treasure_dh", "129210"},
	[73494892]={ "39975", "小宝箱", "", "", "default", "treasure_dh", "129195"},
	[42194916]={ "40223", "小宝箱", "", "", "default", "treasure_dh", "129210"},
	[23065389]={ "40797", "小宝箱", "", "洞穴入口在 23.6 / 54.2", "default", "treasure_dh", "129210"},
	[66922767]={ "39974", "小宝箱", "", "", "default", "treasure_dh", "129210"},
	[74285453]={ "39977", "小宝箱", "", "洞穴入口在 70.7 / 54.0", "default", "treasure_dh", "129210"},
	[69704240]={ "39976", "小宝箱", "", "", "default", "treasure_dh", "129210"},
	
	[68852759]={ "40234", "沃罗斯将军", "", "", "skull_grey", "rare_dh", "128947"},
	[81034124]={ "40233", "工头布鲁塔格", "", "", "skull_grey", "rare_dh", "133580"},
	[74475731]={ "40232", "蛛王沃拉斯", "", "", "skull_grey", "rare_dh", "128944"},
}

nodes["CrypticHollow"] = {
	[48761530]={ "39972", "小宝箱", "", "", "default", "treasure_dh", "129196"},
	[54855845]={ "39973", "小宝箱", "", "", "default", "treasure_dh", "128946"},
}

nodes["SoulEngine"] = {
	[50304964]={ "40772", "小宝箱", "", "", "default", "treasure_dh", "129210"},
	[51235740]={ "40231", "Count Nefarious", "", "", "skull_grey", "rare_dh", "128948"},
}

nodes["VaultOfTheWardensDH"] = {
	[58693475]={ "40909", "小宝箱", "", "第一层", "default", "treasure_dh", "129210"},
	[47325464]={ "38690", "小宝箱", "", "第一层", "default", "treasure_dh", "129210"},
	[32104817]={ "40911", "小宝箱", "", "第二层", "default", "treasure_dh", "129196"},
	[41506361]={ "40914", "小宝箱", "", "第二层", "default", "treasure_dh", "129196"},
	[56994013]={ "40913", "小宝箱", "", "第二层", "default", "treasure_dh", "129210"},
	[41413287]={ "40912", "小宝箱", "", "第二层", "default", "treasure_dh", "129210"},
	[24421005]={ "40915", "小宝箱", "", "第三层", "default", "treasure_dh", "129210"},
	[23268157]={ "40916", "小宝箱", "", "第三层", "default", "treasure_dh", "129210"},
	
	[68743628]={ "40301", "愤怒领主勒考斯", "", "", "skull_grey", "rare_dh", "128958"},
	[49543284]={ "40251", "科斯拉佐", "", "", "skull_grey", "rare_dh", "128945"},
}

if (PlayerFaction == "Alliance") then
    nodes["ShadowmoonValleyDR"][29600620]={ "35281", "巴哈麦", "熔火鱿鱼", "", "skull_grey", "rare_smv","111666"}
    nodes["Gorgrond"][60805400]={ "36502", "拜奥兰特", "加经验值的任务物品", "在这个元素从地图去除前，您必须完成任务", "skull_grey", "rare_gg","116159"}
    nodes["Gorgrond"][46004680]={ "35816", "查尔·恐翼", "加经验值的任务物品", "在这个元素从地图去除前，您必须完成任务", "skull_grey", "rare_gg","113457"}
    nodes["Gorgrond"][42805920]={ "35812", "火山领主伊格尼斯", "加经验值的任务物品", "在这个元素从地图去除前，您必须完成任务", "skull_grey", "rare_gg","113449"}
    nodes["Gorgrond"][40505100]={ "35809", "“死水”德斯克斯", "加经验值的任务物品", "在这个元素从地图去除前，您必须完成任务", "skull_grey", "rare_gg","113446"}
    nodes["Gorgrond"][51804160]={ "35808", "暴虐的艾罗萨恩", "加经验值的任务物品", "在这个元素从地图去除前，您必须完成任务", "skull_grey", "rare_gg","113445"}
    nodes["Gorgrond"][58006360]={ "35813", "真菌守卫者", "加经验值的任务物品", "在这个元素从地图去除前，您必须完成任务", "skull_grey", "rare_gg","113453"}
    nodes["ShadowmoonValleyDR"][21603300]={ "33664", "咕噜姆", "i516 敏捷/智力 戒指", "", "skull_grey", "rare_smv","113082"}
    nodes["Gorgrond"][52406580]={ "35820", "吞噬者卡加克斯", "加经验值的任务物品", "在这个元素从地图去除前，您必须完成任务", "skull_grey", "rare_gg","113461"}
    nodes["ShadowmoonValleyDR"][30301990]={ "35530", "坠月鸟蛋", "要塞物资", "在帐篷里", "default", "treasure_smv","824"}
    nodes["Gorgrond"][51206360]={ "35817", "“天空魔王”洛尔丹", "加经验值的任务物品", "会不停地飞来飞去转圈, 坐标只是在他的路线中的一处！在这个元素从地图去除前，您必须完成任务", "skull_grey", "rare_gg","113458"}
    nodes["ShadowmoonValleyDR"][42804100]={ "33038", "风牙狼母", "i516 敏捷/力量 单手剑", "安波里水晶防御事件的一部分", "skull_grey", "rare_smv","113553"}
end

if (PlayerFaction == "Horde") then
    nodes["Gorgrond"][60805400]={ "36503", "拜奥兰特", "加经验值的任务物品", "在这个元素从地图去除前，您必须完成任务", "skull_grey", "rare_gg","116160"}
    nodes["Gorgrond"][46004680]={ "35815", "查尔·恐翼", "加经验值的任务物品", "在这个元素从地图去除前，您必须完成任务", "skull_grey", "rare_gg","113456"}
    nodes["Gorgrond"][42805920]={ "35811", "火山领主伊格尼斯", "加经验值的任务物品", "在这个元素从地图去除前，您必须完成任务", "skull_grey", "rare_gg","113448"}
    nodes["Gorgrond"][40505100]={ "35810", "“死水”德斯克斯", "加经验值的任务物品", "在这个元素从地图去除前，您必须完成任务", "skull_grey", "rare_gg","113447"}
    nodes["Gorgrond"][51804160]={ "35807", "暴虐的艾罗萨恩", "加经验值的任务物品", "在这个元素从地图去除前，您必须完成任务", "skull_grey", "rare_gg","113444"}
    nodes["Gorgrond"][58006360]={ "35814", "真菌守卫者", "加经验值的任务物品", "在这个元素从地图去除前，您必须完成任务", "skull_grey", "rare_gg","113454"}
    nodes["Gorgrond"][52406580]={ "35819", "吞噬者卡加克斯", "加经验值的任务物品", "在这个元素从地图去除前，您必须完成任务", "skull_grey", "rare_gg","113460"}
    nodes["Talador"][61107170]={ "34116", "诺拉纳的宝箱", "i564 敏捷项链", "", "default", "treasure_td","117563"}
    nodes["Gorgrond"][51206360]={ "35818", "“天空魔王”洛尔丹", "加经验值的任务物品", "会不停地飞来飞去转圈, 坐标只是在他的路线中的一处！在这个元素从地图去除前，您必须完成任务", "skull_grey", "rare_gg","113459"}
end

local function GetItem(ID)
    if (ID == "824" or ID == "823") then
        local currency, _, _ = GetCurrencyInfo(ID)

        if (currency ~= nil) then
            return currency
        else
            return "货币 ID 载入错误"
        end
    else
        local _, item, _, _, _, _, _, _, _, _ = GetItemInfo(ID)

        if (item ~= nil) then
            return item
        else
            return "物品 ID 载入错误"
        end
    end
end 

local function GetIcon(ID)
    if (ID == "824" or ID == "823") then
        local _, _, icon = GetCurrencyInfo(ID)

        if (icon ~= nil) then
            return icon
        else
            return "Interface\\Icons\\inv_misc_questionmark"
        end
    else
        local _, _, _, _, _, _, _, _, _, icon = GetItemInfo(ID)

        if (icon ~= nil) then
            return icon
        else
            return "Interface\\Icons\\inv_misc_questionmark"
        end
    end
end

function DraenorTreasures:OnEnter(mapFile, coord)
    if (not nodes[mapFile][coord]) then return end
    
    local tooltip = self:GetParent() == WorldMapButton and WorldMapTooltip or GameTooltip

    if ( self:GetCenter() > UIParent:GetCenter() ) then
        tooltip:SetOwner(self, "ANCHOR_LEFT")
    else
        tooltip:SetOwner(self, "ANCHOR_RIGHT")
    end

    tooltip:SetText(nodes[mapFile][coord][2])
    if (nodes[mapFile][coord][3] ~= nil) and (DraenorTreasures.db.profile.show_loot == true) then
        if ((nodes[mapFile][coord][7] ~= nil) and (nodes[mapFile][coord][7] ~= "")) then
            tooltip:AddLine(("掉落：" .. GetItem(nodes[mapFile][coord][7])), nil, nil, nil, true)

            if ((nodes[mapFile][coord][3] ~= nil) and (nodes[mapFile][coord][3] ~= "")) then
                tooltip:AddLine(("掉落信息：" .. nodes[mapFile][coord][3]), nil, nil, nil, true)
            end
        else
            tooltip:AddLine(("掉落：" .. nodes[mapFile][coord][3]), nil, nil, nil, true)
        end
    end

    if (nodes[mapFile][coord][4] ~= "") and (DraenorTreasures.db.profile.show_notes == true) then
     tooltip:AddLine(("注释：" .. nodes[mapFile][coord][4]), nil, nil, nil, true)
    end

    tooltip:Show()
end

local isMoving = false
local info = {}
local clickedMapFile = nil
local clickedCoord = nil

local function generateMenu(button, level)
    if (not level) then return end

    for k in pairs(info) do info[k] = nil end

    if (level == 1) then
        info.isTitle = 1
        info.text = "DraenorTreasures"
        info.notCheckable = 1
        UIDropDownMenu_AddButton(info, level)
        
        info.disabled = nil
        info.isTitle = nil
        info.notCheckable = nil
        info.text = "从地图上移除此物件"
        info.func = DTDisableTreasure
        info.arg1 = clickedMapFile
        info.arg2 = clickedCoord
        UIDropDownMenu_AddButton(info, level)
        
        if isTomTomloaded == true then
            info.text = "在 TomTom 添加此路径点位置"
            info.func = DTaddtoTomTom
            info.arg1 = clickedMapFile
            info.arg2 = clickedCoord
            UIDropDownMenu_AddButton(info, level)
        end

        if isDBMloaded == true then
            info.text = "在 DBM 中添加此财宝箭头"
            info.func = DTAddDBMArrow
            info.arg1 = clickedMapFile
            info.arg2 = clickedCoord
            UIDropDownMenu_AddButton(info, level)
            
            info.text = "隐藏 DBM 箭头"
            info.func = DTHideDBMArrow
            UIDropDownMenu_AddButton(info, level)
        end

        info.text = CLOSE
        info.func = function() CloseDropDownMenus() end
        info.arg1 = nil
        info.arg2 = nil
        info.notCheckable = 1
        UIDropDownMenu_AddButton(info, level)

        info.text = "恢复已移除物件"
        info.func = DTResetDB
        info.arg1 = nil
        info.arg2 = nil
        info.notCheckable = 1
        UIDropDownMenu_AddButton(info, level)
        
    end
end

local HandyNotes_DraenorTreasuresDropdownMenu = CreateFrame("Frame", "HandyNotes_DraenorTreasuresDropdownMenu")
HandyNotes_DraenorTreasuresDropdownMenu.displayMode = "MENU"
HandyNotes_DraenorTreasuresDropdownMenu.initialize = generateMenu

function DraenorTreasures:OnClick(button, down, mapFile, coord)
    if button == "RightButton" and down then
        clickedMapFile = mapFile
        clickedCoord = coord
        ToggleDropDownMenu(1, nil, HandyNotes_DraenorTreasuresDropdownMenu, self, 0, 0)
    end
end

function DraenorTreasures:OnLeave(mapFile, coord)
    if self:GetParent() == WorldMapButton then
        WorldMapTooltip:Hide()
    else
        GameTooltip:Hide()
    end
end

local options = {
    type = "group",
    name = "德拉诺财宝",
    desc = "德拉诺财宝位置。",
    get = function(info) return DraenorTreasures.db.profile[info.arg] end,
    set = function(info, v) DraenorTreasures.db.profile[info.arg] = v; DraenorTreasures:Refresh() end,
    args = {
        desc = {
            name = "一般设定",
            type = "description",
            order = 0,
        },
        icon_scale_treasures = {
            type = "range",
            name = "财宝图标大小",
            desc = "图标的大小",
            min = 0.25, max = 3, step = 0.01,
            arg = "icon_scale_treasures",
            order = 1,
        },
        icon_scale_rares = {
            type = "range",
            name = "稀有图标大小",
            desc = "图标的大小",
            min = 0.25, max = 3, step = 0.01,
            arg = "icon_scale_rares",
            order = 2,
        },
        icon_alpha = {
            type = "range",
            name = "图标透明度",
            desc = "图标的透明度",
            min = 0, max = 1, step = 0.01,
            arg = "icon_alpha",
            order = 20,
        },
        VisibilityOptions = {
            type = "group",
            name = "可见性设定",
            desc = "可见性设定",
            args = {
                VisibilityGroup = {
                    type = "group",
                    order = 0,
                    name = "选择哪些区域要显示什么：",
                    inline = true,
                    args = {
                        groupSMV = {
                            type = "header",
                            name = "影月谷",
                            desc = "影月谷",
                            order = 0,
                        },
                        treasureSMV = {
                            type = "toggle",
                            arg = "treasure_smv",
                            name = "财宝",
                            desc = "财宝会提供很多物品",
                            order = 1,
                            width = "half",
                        },
                        rareSMV = {
                            type = "toggle",
                            arg = "rare_smv",
                            name = "稀有",
                            desc = "稀有刷新",
                            order = 2,
                            width = "half",
                        },
                        rareHSMV = {
                            type = "toggle",
                            arg = "rare_h_smv",
                            name = "100等级稀有",
                            desc = "玩家等级100出现的稀有",
                            order = 3,
                            width = "normal",
                        },
                        groupFFR = {
                            type = "header",
                            name = "霜火岭",
                            desc = "霜火岭",
                            order = 10,
                        },  
                        treasureFFR = {
                            type = "toggle",
                            arg = "treasure_ffr",
                            name = "财宝",
                            desc = "财宝会提供很多物品",
                            width = "half",
                            order = 11,
                        },
                        rareFFR = {
                            type = "toggle",
                            arg = "rare_ffr",
                            name = "稀有",
                            desc = "稀有刷新",
                            width = "half",
                            order = 12,
                        },
                        rareHFFR = {
                            type = "toggle",
                            arg = "rare_h_ffr",
                            name = "100等级稀有",
                            desc = "玩家等级100出现的稀有",
                            width = "normal",
                            order = 13,
                        },
                        treasureFFRBSF = {
                            type = "toggle",
                            arg = "treasure_ffr_bsf",
                            name = "财宝 - 刀塔堡垒",
                            desc = "在刀塔堡垒内寻找",
                            width = "full",
                            order = 14,
                        },
                        groupGG = {
                            type = "header",
                            name = "戈尔隆德",
                            desc = "戈尔隆德",
                            order = 20,
                        },  
                        treasureGG = {
                            type = "toggle",
                            arg = "treasure_gg",
                            name = "财宝",
                            desc = "财宝会提供很多物品",
                            width = "half",
                            order = 21,
                        },
                        rareGG = {
                            type = "toggle",
                            arg = "rare_gg",
                            name = "稀有",
                            desc = "稀有刷新",
                            width = "half",
                            order = 22,
                        },  
                        rareHGG = {
                            type = "toggle",
                            arg = "rare_h_gg",
                            name = "100等级稀有",
                            desc = "玩家等级100出现的稀有",
                            width = "normal",
                            order = 23,
                        },  
                        treasureGGL = {
                            type = "toggle",
                            arg = "treasure_gg_l",
                            name = "伐木场",
                            desc = "伐木场哨站财宝",
                            order = 24,
                        },  
                        treasureGGB = {
                            type = "toggle",
                            arg = "treasure_gg_b",
                            name = "格斗竞技场",
                            desc = "格斗竞技场哨站财宝",
                            order = 25,
						},
						overrideGG = {
                            type = "toggle",
                            arg = "gorgrond_override",
                            name = "显示伐木场/格斗竞技场",
                            desc = "选择此选项将不依赖任务 ID 而是永远显示伐木场/格斗竞技场财宝。此选项需要重载用户界面生效。",
							width = "full",
                            order = 26,
                        },  
                        groupTD = {
                            type = "header",
                            name = "塔拉多",
                            desc = "塔拉多",
                            order = 30,
                        },  
                        treasureTD = {
                            type = "toggle",
                            arg = "treasure_td",
                            name = "财宝",
                            desc = "财宝会提供很多物品",
                            width = "half",
                            order = 31,
                        },
                        rareTD = {
                            type = "toggle",
                            arg = "rare_td",
                            name = "稀有",
                            desc = "稀有刷新",
                            width = "half",
                            order = 32,
                        },  
                        rareHTD = {
                            type = "toggle",
                            arg = "rare_h_td",
                            name = "100等级稀有",
                            desc = "玩家等级100出现的稀有",
                            width = "normal",
                            order = 33,
                        },  
                        groupSOA = {
                            type = "header",
                            name = "阿兰卡峰林",
                            desc = "阿兰卡峰林",
                            order = 40,
                        },    
                        treasureSOA = {
                            type = "toggle",
                            arg = "treasure_soa",
                            name = "财宝",
                            desc = "财宝会提供很多物品",
                            width = "half",
                            order = 41,
                        },
                        rareSOA = {
                            type = "toggle",
                            arg = "rare_soa",
                            name = "稀有",
                            desc = "稀有刷新",
                            width = "half",
                            order = 42,
                        },  
                        rareHSOA = {
                            type = "toggle",
                            arg = "rare_h_soa",
                            name = "100等级稀有",
                            desc = "玩家等级100出现的稀有",
                            width = "normal",
                            order = 43,
                        },
                        treasureSOAA = {
                            type = "toggle",
                            arg = "treasure_soa_a",
                            name = "财宝 - 考古",
                            desc = "需要考古专业",
                            width = "full",
                            order = 44,
                        },  
                        groupNG = {
                            type = "header",
                            name = "纳格兰",
                            desc = "纳格兰",
                            order = 50,
                        },      
                        treasureNG = {
                            type = "toggle",
                            arg = "treasure_ng",
                            name = "财宝",
                            desc = "财宝会提供很多物品",
                            width = "half",
                            order = 51,
                        },
                        rareNG = {
                            type = "toggle",
                            arg = "rare_ng",
                            name = "稀有",
                            desc = "稀有刷新",
                            width = "half",
                            order = 52,
                        },
                        rareHNG = {
                            type = "toggle",
                            arg = "rare_h_ng",
                            name = "100等级稀有",
                            desc = "玩家等级100出现的稀有",
                            width = "normal",
                            order = 53,
                        },
                        rareSNG = {
                            type = "toggle",
                            arg = "rare_s_ng",
                            name = "稀有 - 热砂保护协会",
                            desc = "出现的稀有掉落声望奖励物品",
                            width = "full",
                            order = 54,
                        },
                        groupTJ = {
                            type = "header",
                            name = "塔纳安丛林",
                            desc = "塔纳安丛林",
                            order = 60,
                        },
                        treasureTJ = {
                            type = "toggle",
                            arg = "treasure_tj",
                            name = "财宝",
                            desc = "财宝会提供很多物品",
                            width = "half",
                            order = 61,
                        },
                        rareHTJ = {
                            type = "toggle",
                            arg = "rare_h_tj",
                            name = "100等级稀有",
                            desc = "玩家等级100出现的稀有",
                            width = "normal",
                            order = 62,
                        },
                        rareATJ = {
                            type = "toggle",
                            arg = "rare_a_tj_new",
                            name = "只显示成就所缺失的项 [丛林捕猎者]",
                            desc = "这里有优先级选项 [总是显示已拾取的稀有]",
                            width = "full",
                            order = 63,
                        },
                        groupMount = {
                            type = "header",
                            name = "稀有坐骑",
                            desc = "稀有坐骑",
                            order = 70,
                        },
                        mountTJ = {
                            type = "toggle",
                            arg = "mount_tj",
                            name = "塔纳安稀有",
                            desc = "有几率掉落的物品内包含3种坐骑中的一种",
                            order = 71,
                        },
                        mountPR = {
                            type = "toggle",
                            arg = "mount_pr",
                            name = "觅径者",
                            desc = "位于影月谷",
                            order = 72,
                        },
                        mountPO = {
                            type = "toggle",
                            arg = "mount_po",
                            name = "重拳",
                            desc = "位于戈尔隆德",
                            order = 73,
                        },
                        mountGO = {
                            type = "toggle",
                            arg = "mount_go",
                            name = "戈罗克",
                            desc = "位于霜火岭",
                            order = 74,
                        },
                        mountSI = {
                            type = "toggle",
                            arg = "mount_si",
                            name = "泥皮",
                            desc = "位于塔拉多",
                            order = 75,
                        },
                        mountLU = {
                            type = "toggle",
                            arg = "mount_lu",
                            name = "鲁克胡克",
                            desc = "位于纳格兰",
                            order = 76,
                        },
                        mountNA = {
                            type = "toggle",
                            arg = "mount_na",
                            name = "雷霆纳克",
                            desc = "位于纳格兰",
                            order = 77,
                        },
                        mountNO = {
                            type = "toggle",
                            arg = "mount_no",
                            name = "诺卡罗什",
                            desc = "位于霜火岭",
                            order = 78,
                        },
                        mountVT = {
                            type = "toggle",
                            arg = "mount_vt",
                            name = "灵爪飞鹰",
                            desc = "传送门位于多个区域",
                            order = 79,
                        },
						groupDH = {
                            type = "header",
                            name = "恶魔猎手",
                            desc = "只在恶魔猎手区域",
                            order = 80,
                        },    
                        treasureDH = {
                            type = "toggle",
                            arg = "treasure_dh",
                            name = "财宝",
                            desc = "财宝会提供很多物品",
                            width = "normal",
                            order = 81,
                        },
                        rareDH = {
                            type = "toggle",
                            arg = "rare_dh",
                            name = "稀有",
                            desc = "稀有刷新",
                            width = "normal",
                            order = 82,
                        },  
                    },
                },
                alwaysshowrares = {
                    type = "toggle",
                    arg = "alwaysshowrares",
                    name = "总是显示已拾取的稀有",
                    desc = "显示每个稀有无论是否已拾取状态",
                    order = 100,
                    width = "full",
                },
                alwaysshowtreasures = {
                    type = "toggle",
                    arg = "alwaysshowtreasures",
                    name = "总是显示已拾取的财宝",
                    desc = "显示每个财宝无论是否已拾取状态",
                    order = 101,
                    width = "full",
                },
                show_loot = {
                    type = "toggle",
                    arg = "show_loot",
                    name = "显示掉落",
                    desc = "显示每个财宝/稀有的掉落",
                    order = 102,
                },
                show_notes = {
                    type = "toggle",
                    arg = "show_notes",
                    name = "显示注释",
                    desc = "当可用时显示每个财宝/稀有的注释",
                    order = 103,
                },
            },
        },
    },
}

function DraenorTreasures:OnInitialize()
    local defaults = {
        profile = {
            icon_scale_treasures = 1.5,
            icon_scale_rares = 2.0,
            icon_alpha = 1.00,
            alwaysshowrares = false,
            alwaysshowtreasures = false,
            save = true,
            treasure_smv = true,
            treasure_ffr = true,
            treasure_ffr_bsf = true,
            treasure_gg = true,
            treasure_gg_b = true,
            treasure_gg_l = true,
            treasure_ng = true,
            treasure_soa = true,
            treasure_soa_a = true,
            treasure_td = true,
            treasure_tj = true,
			treasure_dh = true,
            rare_smv = true,
            rare_ffr = true,
            rare_gg = true,
            rare_td = true,
            rare_soa = true,
            rare_ng = true,
            rare_h_gg = true,
            rare_h_ffr = true,
            rare_s_gg = true,
            rare_h_td = true,
            rare_h_soa = true,
            rare_h_ng = true,
            rare_h_tj = true,
            rare_s_gg = true,
            rare_s_ng = true,
            rare_a_tj_new = false,
			rare_dh = true,
            mount_tj = true,
            mount_pr = true,
            mount_go = true,
            mount_no = true,
            mount_po = true,
            mount_si = true,
            mount_na = true,
            mount_lu = true,
            mount_vt = true,
			gorgrond_override = false,
            world_bosses = true,
            show_loot = true,
            show_notes = true,
        },
    }

    self.db = LibStub("AceDB-3.0"):New("DraenorTreasuresDB", defaults, "Default")
    self:RegisterEvent("PLAYER_ENTERING_WORLD", "WorldEnter")
end

function DraenorTreasures:WorldEnter()
    self:UnregisterEvent("PLAYER_ENTERING_WORLD")
    self:ScheduleTimer("QuestCheck", 5)
    self:ScheduleTimer("RegisterWithHandyNotes", 8)
	self:ScheduleTimer("LoadCheck",6)
	--self:ScheduleTimer("LoginMessage", 10)
end

function DraenorTreasures:QuestCheck()
    do
	if ((IsQuestFlaggedCompleted(36386) == false) or (IsQuestFlaggedCompleted(36390) == false) or (IsQuestFlaggedCompleted(36389) == false) or (IsQuestFlaggedCompleted(36392) == false) or (IsQuestFlaggedCompleted(36388) == false) or (IsQuestFlaggedCompleted(36381) == false)) then
            nodes["SpiresOfArak"][43901500]={ "36395", "暗影视觉药剂 1", "暗影视觉药剂", "药剂可以使用在泰罗卡圣物盒装等585武器6个其中之一 (参见安苏之赐) 一但您拾取所有安苏之赐后物件会立刻被删除", "default", "treasure_soa","115463"}
            nodes["SpiresOfArak"][43802470]={ "36397", "暗影视觉药剂 2", "暗影视觉药剂", "药剂可以使用在泰罗卡圣物盒装等585武器6个其中之一 (参见安苏之赐) 一但您拾取所有安苏之赐后物件会立刻被删除", "default", "treasure_soa","115463"}
            nodes["SpiresOfArak"][69204330]={ "36398", "暗影视觉药剂 3", "暗影视觉药剂", "药剂可以使用在泰罗卡圣物盒装等585武器6个其中之一 (参见安苏之赐) 一但您拾取所有安苏之赐后物件会立刻被删除", "default", "treasure_soa","115463"}
            nodes["SpiresOfArak"][48906250]={ "36399", "暗影视觉药剂 4", "暗影视觉药剂", "药剂可以使用在泰罗卡圣物盒装等585武器6个其中之一 (参见安苏之赐) 一但您拾取所有安苏之赐后物件会立刻被删除", "default", "treasure_soa","115463"}
            nodes["SpiresOfArak"][55602200]={ "36400", "暗影视觉药剂 5", "暗影视觉药剂", "药剂可以使用在泰罗卡圣物盒装等585武器6个其中之一 (参见安苏之赐) 一但您拾取所有安苏之赐后物件会立刻被删除", "default", "treasure_soa","115463"}
            nodes["SpiresOfArak"][53108450]={ "36401", "暗影视觉药剂 6", "暗影视觉药剂", "药剂可以使用在泰罗卡圣物盒装等585武器6个其中之一 (参见安苏之赐) 一但您拾取所有安苏之赐后物件会立刻被删除", "default", "treasure_soa","115463"}
	end
	if (IsQuestFlaggedCompleted(36249) or IsQuestFlaggedCompleted(36250) or DraenorTreasures.db.profile.gorgrond_override == true) then
		--Gorgrond Lumber Mill is active if either of these Quest IDs are true
            nodes["Gorgrond"][49074846]={ "35952", "古老的石质容器", "", "", "default", "treasure_gg_l","824"}
            nodes["Gorgrond"][42345477]={ "36003", "古老的石质容器", "", "", "default", "treasure_gg_l","824"}
            nodes["Gorgrond"][47514363]={ "36717", "古老的石质容器", "", "", "default", "treasure_gg_l","824"}
            nodes["Gorgrond"][53354679]={ "35701", "上古泰坦宝箱", "", "", "default", "treasure_gg_l","824"}
            nodes["Gorgrond"][50155376]={ "35984", "上古泰坦宝箱", "", "", "default", "treasure_gg_l","824"}
            nodes["Gorgrond"][42084607]={ "36720", "上古泰坦宝箱", "", "", "default", "treasure_gg_l","824"}
            nodes["Gorgrond"][41988155]={ "35982", "木精精华之种", "", "", "default", "treasure_gg_l","824"}
            nodes["Gorgrond"][49657883]={ "35968", "被遗忘的食人魔宝箱", "", "", "default", "treasure_gg_l","824"}
            nodes["Gorgrond"][47016905]={ "35971", "被遗忘的嘲颅文物", "", "", "default", "treasure_gg_l","824"}
            nodes["Gorgrond"][45808931]={ "36019", "被遗忘的嘲颅文物", "", "", "default", "treasure_gg_l","824"}
            nodes["Gorgrond"][39335627]={ "36716", "被遗忘的嘲颅文物", "", "", "default", "treasure_gg_l","824"}
            nodes["Gorgrond"][56745727]={ "35965", "神秘的石化豆荚", "", "", "default", "treasure_gg_l","824"}
            nodes["Gorgrond"][41147726]={ "35980", "神秘的石化豆荚", "", "", "default", "treasure_gg_l","824"}
            nodes["Gorgrond"][60507276]={ "36015", "神秘的石化豆荚", "", "", "default", "treasure_gg_l","824"}
            nodes["Gorgrond"][63285719]={ "36430", "神秘的石化豆荚", "", "", "default", "treasure_gg_l","824"}
            nodes["Gorgrond"][47647679]={ "36714", "神秘的石化豆荚", "", "", "default", "treasure_gg_l","824"}
            nodes["Gorgrond"][51756909]={ "36715", "神秘的石化豆荚", "", "", "default", "treasure_gg_l","824"}
            nodes["Gorgrond"][40956732]={ "35979", "黑曜水晶岩", "", "", "default", "treasure_gg_l","824"}
            nodes["Gorgrond"][45969357]={ "35975", "探测工程师托德卡·灰钉的遗骸", "", "", "default", "treasure_gg_l","824"}
            nodes["Gorgrond"][51806148]={ "35966", "格里米尔·灰签的遗骸", "", "", "default", "treasure_gg_l","824"}
            nodes["Gorgrond"][51647226]={ "35967", "未知的石化之蛋", "", "", "default", "treasure_gg_l","824"}
            nodes["Gorgrond"][45318195]={ "35981", "未知的石化之蛋", "", "", "default", "treasure_gg_l","824"}
            nodes["Gorgrond"][42914350]={ "36001", "未知的石化之蛋", "", "", "default", "treasure_gg_l","824"}
            nodes["Gorgrond"][53007906]={ "36713", "未知的石化之蛋", "", "", "default", "treasure_gg_l","824"}
            nodes["Gorgrond"][47245180]={ "36718", "未知的石化之蛋", "", "", "default", "treasure_gg_l","824"}
	end
	if (IsQuestFlaggedCompleted(36251) or IsQuestFlaggedCompleted(36252) or DraenorTreasures.db.profile.gorgrond_override == true) then
		--Gorgrond Sparring Arena is active if either of these Quest IDs are true
            nodes["Gorgrond"][45634931]={ "36722", "古老的石质容器", "", "", "default", "treasure_gg_b","824"}
            nodes["Gorgrond"][43224574]={ "36723", "古老的石质容器", "", "", "default", "treasure_gg_b","824"}
            nodes["Gorgrond"][41764527]={ "36726", "古老的石质容器", "", "", "default", "treasure_gg_b","824"}
            nodes["Gorgrond"][48115516]={ "36730", "古老的石质容器", "", "", "default", "treasure_gg_b","824"}
            nodes["Gorgrond"][51334055]={ "36734", "古老的石质容器", "", "", "default", "treasure_gg_b","824"}
            nodes["Gorgrond"][46056305]={ "36736", "古老的石质容器", "", "", "default", "treasure_gg_b","824"}
            nodes["Gorgrond"][58125146]={ "36739", "古老的石质容器", "", "", "default", "treasure_gg_b","824"}
            nodes["Gorgrond"][59567275]={ "36781", "古老的石质容器", "", "", "default", "treasure_gg_b","824"}
            nodes["Gorgrond"][45748821]={ "36784", "古老的石质容器", "", "", "default", "treasure_gg_b","824"}
            nodes["Gorgrond"][45544298]={ "36733", "上古食人魔文物", "", "", "default", "treasure_gg_b","824"}
            nodes["Gorgrond"][45076993]={ "36737", "上古食人魔文物", "", "", "default", "treasure_gg_b","824"}
            nodes["Gorgrond"][61555855]={ "36740", "上古食人魔文物", "", "", "default", "treasure_gg_b","824"}
            nodes["Gorgrond"][54257313]={ "36782", "上古食人魔文物", "", "", "default", "treasure_gg_b","824"}
            nodes["Gorgrond"][42179308]={ "36787", "上古食人魔文物", "", "", "default", "treasure_gg_b","824"}
            nodes["Gorgrond"][41528652]={ "36789", "上古食人魔文物", "", "", "default", "treasure_gg_b","824"}
            nodes["Gorgrond"][49425084]={ "36710", "上古泰坦宝箱", "", "", "default", "treasure_gg_b","824"}
            nodes["Gorgrond"][42195203]={ "36727", "上古泰坦宝箱", "", "", "default", "treasure_gg_b","824"}
            nodes["Gorgrond"][43365169]={ "36731", "上古泰坦宝箱", "", "", "default", "treasure_gg_b","824"}
            nodes["Gorgrond"][47923998]={ "36735", "上古泰坦宝箱", "", "", "default", "treasure_gg_b","824"}
            nodes["Gorgrond"][50326658]={ "36738", "上古泰坦宝箱", "", "", "default", "treasure_gg_b","824"}
            nodes["Gorgrond"][49128248]={ "36783", "上古泰坦宝箱", "", "", "default", "treasure_gg_b","824"}
            nodes["Gorgrond"][48114638]={ "36721", "黑曜水晶岩", "", "", "default", "treasure_gg_b","824"}
            nodes["Gorgrond"][41855889]={ "36728", "黑曜水晶岩", "", "", "default", "treasure_gg_b","824"}
            nodes["Gorgrond"][42056429]={ "36729", "黑曜水晶岩", "", "", "default", "treasure_gg_b","824"}
            nodes["Gorgrond"][44184665]={ "36732", "黑曜水晶岩", "", "", "default", "treasure_gg_b","824"}
        end
    end
end

function DraenorTreasures:RegisterWithHandyNotes()
    do
        local function iter(t, prestate)
            if not t then return nil end

            local state, value = next(t, prestate)

            while state do
                if (value[1] and self.db.profile[value[6]] and not DraenorTreasures:HasBeenLooted(value)) and (value[6] == "rare_h_tj") then
                    if (self.db.profile.rare_a_tj_new) then
                        if ((value[8] ~= nil) and (value[8] ~= "")) then
                            local _, _, completed, _, _, _, _, _, _, _, _ = GetAchievementCriteriaInfoByID(10070, value[8])

                            if (completed == false) then
                                if ((value[7] ~= nil) and (value[7] ~= "")) then
                                    GetIcon(value[7]) --this should precache the Item, so that the loot is correctly returned
                                end

                                if ((value[5] == "default") or (value[5] == "unknown")) then
                                    if ((value[7] ~= nil) and (value[7] ~= "")) then
                                        return state, nil, GetIcon(value[7]), DraenorTreasures.db.profile.icon_scale_treasures, DraenorTreasures.db.profile.icon_alpha
                                    else
                                        return state, nil, iconDefaults[value[5]], DraenorTreasures.db.profile.icon_scale_treasures, DraenorTreasures.db.profile.icon_alpha
                                    end
                                end

                                return state, nil, iconDefaults[value[5]], DraenorTreasures.db.profile.icon_scale_rares, DraenorTreasures.db.profile.icon_alpha
                            end
                        end
                    else
                        if ((value[7] ~= nil) and (value[7] ~= "")) then
                            GetIcon(value[7]) --this should precache the Item, so that the loot is correctly returned
                        end

                        if ((value[5] == "default") or (value[5] == "unknown")) then
                            if ((value[7] ~= nil) and (value[7] ~= "")) then
                                return state, nil, GetIcon(value[7]), DraenorTreasures.db.profile.icon_scale_treasures, DraenorTreasures.db.profile.icon_alpha
                            else
                                return state, nil, iconDefaults[value[5]], DraenorTreasures.db.profile.icon_scale_treasures, DraenorTreasures.db.profile.icon_alpha
                            end
                        end

                        return state, nil, iconDefaults[value[5]], DraenorTreasures.db.profile.icon_scale_rares, DraenorTreasures.db.profile.icon_alpha 
                    end
                end

                -- QuestID[1], Name[2], Loot[3], Notes[4], Icon[5], Tag[6], ItemID[7]
                if (value[1] and self.db.profile[value[6]] and not DraenorTreasures:HasBeenLooted(value)) and (value[6] ~= "rare_h_tj") then
                    if ((value[7] ~= nil) and (value[7] ~= "")) then
                        GetIcon(value[7]) --this should precache the Item, so that the loot is correctly returned
                    end

                    if ((value[5] == "default") or (value[5] == "unknown")) then
                        if ((value[7] ~= nil) and (value[7] ~= "")) then
                            return state, nil, GetIcon(value[7]), DraenorTreasures.db.profile.icon_scale_treasures, DraenorTreasures.db.profile.icon_alpha
                        else
                            return state, nil, iconDefaults[value[5]], DraenorTreasures.db.profile.icon_scale_treasures, DraenorTreasures.db.profile.icon_alpha
                        end
                    end

                    return state, nil, iconDefaults[value[5]], DraenorTreasures.db.profile.icon_scale_rares, DraenorTreasures.db.profile.icon_alpha
                end

                state, value = next(t, state)
            end
        end

        function DraenorTreasures:GetNodes(mapFile, isMinimapUpdate, dungeonLevel)
            return iter, nodes[mapFile], nil
        end
    end

    HandyNotes:RegisterPluginDB("DraenorTreasures", self, options)
    self:RegisterBucketEvent({ "LOOT_CLOSED" }, 2, "Refresh")
    self:Refresh()
end
 
function DraenorTreasures:Refresh()
    self:SendMessage("HandyNotes_NotifyUpdate", "DraenorTreasures")
end

function DTResetDB()
    table.wipe(DraenorTreasures.db.char)
    DraenorTreasures:Refresh()
end

function DraenorTreasures:HasBeenLooted(value)
    if (self.db.profile.alwaysshowtreasures and (string.find(value[6], "treasure") ~= nil)) then return false end
    if (self.db.profile.alwaysshowrares and (string.find(value[6], "treasure") == nil)) then return false end
    if (DraenorTreasures.db.char[value[1]] and self.db.profile.save) then return true end
    if (IsQuestFlaggedCompleted(value[1])) then
        return true
    end

    return false
end

function DTDisableTreasure(button, mapFile, coord)
    if (nodes[mapFile][coord][1] ~= nil) then
        DraenorTreasures.db.char[nodes[mapFile][coord][1]] = true;
    end

    DraenorTreasures:Refresh()
end

function DraenorTreasures:LoadCheck()
	if (IsAddOnLoaded("TomTom")) then 
		isTomTomloaded = true
	end

	if (IsAddOnLoaded("DBM-Core")) then 
		isDBMloaded = true
	end

	if (IsAddOnLoaded("HandyNotes_LegionRaresTreasures")) then 
		isHN_LRTloaded = true
	end

	if isDBMloaded == true then
		local ArrowDesc = DBMArrow:CreateFontString(nil, "OVERLAY", "GameTooltipText")
		ArrowDesc:SetWidth(400)
		ArrowDesc:SetHeight(100)
		ArrowDesc:SetPoint("CENTER", DBMArrow, "CENTER", 0, -35)
		ArrowDesc:SetTextColor(1, 1, 1, 1)
		ArrowDesc:SetJustifyH("CENTER")
		DBMArrow.Desc = ArrowDesc
	end
end

function DTaddtoTomTom(button, mapFile, coord)
    if isTomTomloaded == true then
        local mapId = HandyNotes:GetMapFiletoMapID(mapFile)
        local x, y = HandyNotes:getXY(coord)
        local desc = nodes[mapFile][coord][2];

        if (nodes[mapFile][coord][3] ~= nil) and (DraenorTreasures.db.profile.show_loot == true) then
            if ((nodes[mapFile][coord][7] ~= nil) and (nodes[mapFile][coord][7] ~= "")) then
                desc = desc.."\n掉落：" .. GetItem(nodes[mapFile][coord][7]);
                desc = desc.."\n掉落信息：" .. nodes[mapFile][coord][3];
            else
                desc = desc.."\n掉落：" .. nodes[mapFile][coord][3];
            end
        end

        if (nodes[mapFile][coord][4] ~= "") and (DraenorTreasures.db.profile.show_notes == true) then
            desc = desc.."\n注释：" .. nodes[mapFile][coord][4]
        end

        TomTom:AddMFWaypoint(mapId, nil, x, y, {
            title = desc,
            persistent = nil,
            minimap = true,
            world = true
        })
    end
end

function DTAddDBMArrow(button, mapFile, coord)
    if isDBMloaded == true then
        local mapId = HandyNotes:GetMapFiletoMapID(mapFile)
        local x, y = HandyNotes:getXY(coord)
        local desc = nodes[mapFile][coord][2];

        if (nodes[mapFile][coord][3] ~= nil) and (DraenorTreasures.db.profile.show_loot == true) then
            if ((nodes[mapFile][coord][7] ~= nil) and (nodes[mapFile][coord][7] ~= "")) then
                desc = desc.."\n掉落：" .. GetItem(nodes[mapFile][coord][7]);
                desc = desc.."\n掉落信息：" .. nodes[mapFile][coord][3];
            else
                desc = desc.."\n掉落：" .. nodes[mapFile][coord][3];
            end
        end

        if (nodes[mapFile][coord][4] ~= "") and (DraenorTreasures.db.profile.show_notes == true) then
            desc = desc.."\n注释：" .. nodes[mapFile][coord][4]
        end
		if not DBMArrow.Desc:IsShown() then
			DBMArrow.Desc:Show()
		end

        x = x*100
        y = y*100
		DBMArrow.Desc:SetText(desc)
		DBM.Arrow:ShowRunTo(x, y, nil, nil, true)
    end
end

function DTHideDBMArrow()
    DBM.Arrow:Hide(true)
end

function DraenorTreasures:LoginMessage()
	if isHN_LRTloaded == false then
	print("|cff00E5EE<|cffFFC125HN:DraenorTreasures|cff00E5EE>|cff00ff00在军团再临前夕发布的财宝和稀有位于 |cffA330C9恶魔猎手|cff00ff00 开始体验已暂时加入到此插件。")
	--print("|cff00ff00These together with all the treasures and rares in the new legion zones can be found in the new addon |cffff0000Handynotes_LegionRares&Treasures |cff00ff00available through Curse.com")
	--print("|cff00ccffhttp://www.curse.com/addons/wow/handynotes_legionrarestreasures")
	end 
end