----------------------------------------------------------------------
-- 	Leatrix Plus Locale
----------------------------------------------------------------------

-- Create locale structure
local GameLocale = GetLocale()
local void, Leatrix_Plus = ...
local function localeFunc(L, key) return key end
local L = setmetatable({}, {__index = localeFunc})
Leatrix_Plus.L = L

-- Locale override (enUS, zhCN, zhTW, ruRU, koKR, deDE, esMX, frFR, itIT, ptBR)
-- GameLocale = "enUS"

-- zhCN: Simplified Chinese
if GameLocale == "zhCN" then
L["A Deal with Death"] = "与死神的交易"
L["A Falling Star"] = "陨落之星"
L["A Found Memento"] = "寻获的记忆碎片"
L["A friend request from"] = "你有一个好友申请，来自"
L["A New Life for Undeath"] = "亡灵的新生"
L["A Taste of Iron"] = "钢铁的滋味"
L["Accept available quests automatically"] = "自动接受任务"
L["Accept resurrection"] = "自动接受战复"
L["Accept summon"] = "自动接受召唤"
L["Account achievements are being shared."] = "帐号成就已经共享。"
L["Account achievements are hidden."] = "账号成就已隐藏。"
L["Addon"] = "插件"
L["Adventure"] = "冒险"
L["Ahn'kahet (Old Kingdom)"] = "安卡赫特：古代王国"
L["All 3 battle pet slots need to be unlocked."] = "所有3个宠物栏位需要预先解锁。"
L["Allied Races"] = "同盟种族"
L["An Unexpected Reunion"] = "意外的团聚"
L["Anchor"] = "锚点"
L["And Justice for Thrall"] = "萨尔的正义"
L["Anduin's Theme"] = "安度因的主题"
L["Antoran Wastes (Argus)"] = "安托兰废土（阿古斯）"
L["Antorus Ending"] = "安托鲁斯终章"
L["Antorus, the Burning Throne"] = "安托鲁斯，燃烧王座"
L["Arathi Highlands"] = "阿拉希高地"
L["Arcway"] = "魔法回廊"
L["Arenas"] = "竞技场"
L["Arrival on Argus"] = "进军阿古斯"
L["Arrival to Zandalar"] = "登陆赞达拉"
L["Ashenvale"] = "灰谷"
L["Ashran"] = "阿什兰"
L["Assault on the Broken Shore"] = "破碎群岛入侵"
L["Astravar Harbor"] = "阿斯塔瓦港"
L["Atal'Dazar"] = "阿塔达萨"
L["ATV"] = "全地形载具"
L["Auchenai Crypts"] = "奥金尼地穴"
L["Auchindoun"] = "奥金顿"
L["AutoFollow"] = "自动跟随"
L["AutoFollow disabled."] = "已关闭自动跟随。"
L["Automate gossip"] = "对话自动交互"
L["Automate quests"] = "任务自动交接"
L["Automation"] = "自动交互"
L["Azjol-Nerub"] = "艾卓-尼鲁布"
L["Azshara"] = "艾萨拉"
L["Azshara's Eternal Palace"] = "艾萨拉的永恒王宫"
L["Azsuna"] = "阿苏纳"
L["Azuremyst Isle"] = "秘蓝岛"
L["Back to Main Menu"] = "返回"
L["Bad ID"] = "损坏的ID"
L["Badlands"] = "荒芜之地"
L["Balls"] = "球类"
L["Ban-Lu"] = "班禄"
L["Baradin Hold"] = "巴拉丁监狱"
L["Barrens"] = "南贫瘠之地"
L["Bastion of Twilight"] = "暮光堡垒"
L["Battle for Azeroth"] = "争霸艾泽拉斯"
L["Battle for Darkshore"] = "黑海岸之战"
L["Battle for Gilneas"] = "吉尔尼斯之战"
L["Battle for Stromgarde"] = "激流堡之战"
L["Battle of Angrathar the Wrathgate"] = "天谴之门之站"
L["Battle of Dazar'alor"] = "达萨罗之战"
L["Battle of Serpent's Heart"] = "蛇心之战"
L["Battlegrounds"] = "战场"
L["Bigger is Better (Alliance)"] = "越大越好（联盟）"
L["Bigger is Better (Horde)"] = "越大越好（部落）"
L["Bikes"] = "机动车"
L["Black Morass"] = "幽暗沼泽"
L["Black Rook Hold"] = "黑鸦堡垒"
L["Black Temple"] = "黑暗神殿"
L["Blackfathom Deeps"] = "黑暗深渊"
L["Blackrock Caverns"] = "黑石岩窟"
L["Blackrock Depths"] = "黑石深渊"
L["Blackrock Foundry"] = "黑石铸造厂"
L["Blackrock Mountain"] = "黑石山"
L["Blackrock Spire"] = "黑石塔"
L["Blackwing Descent"] = "黑翼血环"
L["Blackwing Lair"] = "黑翼之巢"
L["Blade's Edge Mountains"] = "刀锋山"
L["Blasted Lands"] = "诅咒之地"
L["Block duels"] = "屏蔽决斗信息"
L["Block friend requests"] = "屏蔽好友申请"
L["Block party invites"] = "屏蔽队伍邀请"
L["Block pet battle duels"] = "屏蔽宠物对战"
L["Blocks"] = "屏蔽"
L["Bloodmaul Slag Mines"] = "血槌炉渣矿井"
L["Bloodmyst Isle"] = "秘血岛"
L["Borean Tundra"] = "北风苔原"
L["Bottom"] = "底部"
L["Broken Isles"] = "破碎群岛"
L["Broken Shore"] = "破碎海滩"
L["Buffs"] = "Buffs"
L["Burning Steppes"] = "燃烧平原"
L["Buyout Only"] = "仅限一口价"
L["Camera distance"] = "镜头距离"
L["Cape of Stranglethorn"] = "荆棘谷海角"
L["Cataclysm"] = "大地的裂变"
L["Cathedral of Eternal Night"] = "永夜大教堂"
L["Caverns of Time"] = "时光之穴"
L["Chain style"] = "边框样式"
L["Character"] = "角色"
L["Chat"] = "聊天功能"
L["Chat Frame"] = "聊天窗口"
L["Checkbox labels are Ok."] = "复选框信息检查通过"
L["Choose an Enigma pattern"] = "选择一个“神秘莫测”图样"
L["Cinematics"] = "过场动画"
L["Class colored frames"] = "框体职业染色"
L["Class icon portraits"] = "职业图标替换"
L["Class Trials"] = "职业试炼"
L["click here for new selection"] = "点击此处跳转下一曲目"
L["Click to configure the settings for this option."] = "点击进行额外的选项设置"
L["Click to disable Dominos Encounter for all characters on this realm.  This is required for the player power bar position to be saved correctly.  Your UI will be reloaded."] = "点击为本服务器上的所有角色禁用Dominos插件。为了让玩家的能量条位置能正确保存，你的插件会重新载入。"
L["Click to reset the settings on this page."] = "点击重置此页面的设置。"
L["Click to return to the main menu."] = "点击返回到主菜单"
L["Coilfang Reservoir"] = "盘牙水库"
L["Color the backdrops based on faction"] = "根据阵营着色边框"
L["Combat"] = "战斗"
L["Combat log cannot be hidden while undocked."] = "战斗记录窗口被分离时无法隐藏。"
L["Combat plates"] = "自动开关姓名板"
L["Completed."] = "已完成。"
L["Configuration Panel"] = "设置面板"
L["Connections for"] = "连接到"
L["Court of Stars"] = "群星庭院"
L["Credits"] = "Credits"
L["Crucible of Storms"] = "风暴熔炉"
L["Crystalsong Forest"] = "晶歌森林"
L["Culling of Stratholme"] = "净化斯坦索姆"
L["Cursor"] = "指针"
L["Cursor Left"] = "指针左侧"
L["Cursor Right"] = "指针右侧"
L["Dalaran"] = "达拉然"
L["Dark Iron Dwarves"] = "黑铁矮人"
L["Dark Soil scanning activated.  Reload UI to exit."] = "黑色泥土扫描启用，取消需重载插件。"
L["Dark Soil scanning is already activated.  You only need to run this once.  Reload UI to exit."] = "黑色泥土扫描已经启用，你只需要进行一次操作。取消需重载插件。"
L["Darkheart Thicket"] = "黑心林地"
L["Darkmoon Faire"] = "暗月马戏团"
L["Darkness Falls"] = "黑暗殒落"
L["Darkshore"] = "黑海岸"
L["Darnassus"] = "达纳苏斯"
L["Deadmines"] = "死亡矿井"
L["Deepholm"] = "深岩之洲"
L["Deepwind Gorge"] = "深风峡谷"
L["Desolace"] = "凄凉之地"
L["Destiny Unfulfilled"] = "未完成的使命"
L["Dire Maul"] = "厄运之槌"
L["Dire Maul: Capital Gardens"] = "厄运之槌：中心花园"
L["Dire Maul: Gordok Commons"] = "厄运之槌：戈多克议会"
L["Dire Maul: Warpwood Quarter"] = "厄运之槌：扭木广场"
L["Disable bag automation"] = "禁用自动背包"
L["Disable chat fade"] = "禁用聊天窗口淡出"
L["Disable loot warnings"] = "禁用拾取通报"
L["Disable pet automation"] = "禁用自动换宠"
L["Disable screen effects"] = "禁用屏幕特效"
L["Disable screen glow"] = "禁用屏幕泛光"
L["Disable sticky chat"] = "禁用聊天频道粘滞"
L["Disable sticky editbox"] = "禁用粘滞输入框"
L["Dominos Encounter needs to be disabled."] = "Dominos插件需要被禁用。"
L["Don't accept daily quests automatically"] = "忽略日常任务"
L["Don't accept weekly quests automatically"] = "忽略周长任务"
L["Draenor"] = "德拉诺"
L["Drag the frame overlay to position the frame."] = "拖动框体边框来移动。"
L["Drag the frame overlays to position the frames.|n|nTo change the scale of a frame, click it to select it then adjust the scale slider.|n|nThis panel will close automatically if you enter combat."] = "移动面板来定位框体。|n|n如果想要改变框体尺寸，你需选定面板，然后移动滑块来选择。|n|n你一旦进入战斗，这个框体会自动关闭。"
L["Drag to set the buffs frame scale."] = "拖动以调整Buff框体尺寸。"
L["Drag to set the cursor X offset."] = "拖动以调整指针横向偏差值。"
L["Drag to set the cursor Y offset."] = "拖动以调整指针纵向偏差值。"
L["Drag to set the density of weather effects."] = "拖动以调整天气效果的密度。"
L["Drag to set the font size of mail text."] = "拖动以调整邮件字体大小"
L["Drag to set the font size of quest text."] = "拖动以调整任务文本字体大小"
L["Drag to set the minimap scale.|n|nNote that if you are using the default action bars, rescaling the minimap will also rescale the right action bars at startup so you may want to leave this at 100%."] = "拖动以缩放小地图尺寸。|n|n需要注意的是，当你使用游戏内置动作条时，缩放小地图会同时影响到右侧动作条，所以建议保持在100%。"
L["Drag to set the scale of the Leatrix Plus panel."] = "拖动以缩放LeatrixPlus面板尺寸"
L["Drag to set the scale of the selected frame."] = "拖动以缩放所选面板的尺寸"
L["Drag to set the size of the bottom border."] = "拖动以调整底部边框的尺寸"
L["Drag to set the size of the left border."] = "拖动以调整左侧边框的尺寸"
L["Drag to set the size of the right border."] = "拖动以调整右侧边框的尺寸"
L["Drag to set the size of the top border."] = "拖动以调整顶部边框的尺寸"
L["Drag to set the tooltip scale."] = "拖动以缩放鼠标提示框的尺寸"
L["Drag to set the transparency of the borders."] = "拖动以调整边框透明度"
L["Drag to set the transparency of the Leatrix Plus panel."] = "拖动以调整LeatrixPlus面板的透明度"
L["Dragon Soul"] = "巨龙之魂"
L["Dragonblight"] = "龙骨荒野"
L["Drak'Tharon Keep"] = "达克萨隆要塞"
L["Dread Wastes"] = "恐惧废土"
L["Drustvar"] = "德鲁斯瓦"
L["Dun Morogh"] = "丹莫罗"
L["Dungeon"] = "地下城"
L["Dungeons"] = "地下城"
L["Dup ID"] = "复制的ID"
L["durability"] = "耐久度"
L["Durability"] = "耐久度"
L["Durotar"] = "杜隆塔尔"
L["Duskwood"] = "暮色森林"
L["Dustwallow Marsh"] = "尘泥沼泽"
L["Eastern"] = "东部王国"
L["Eastern Kingdoms"] = "东部王国"
L["Eastern Plaguelands"] = "东瘟疫之地"
L["ELITE"] = "精英"
L["Elwynn Forest"] = "艾尔文森林"
L["Embassies"] = "大使馆"
L["Embers of War"] = "战火余烬"
L["Emerald Nightmare"] = "翡翠梦魇"
L["Enable hotkey"] = "启用热键"
L["End Time"] = "时光之末"
L["Enhance dressup"] = "增强换装预览"
L["Enhance minimap"] = "小地图增强"
L["Enhance tooltip"] = "鼠标提示增强"
L["Enhancements"] = "增强功能"
L["Enigma"] = "神秘莫测"
L["Enter the spell IDs for the cooldown icons that you want to see.|n|nIf a cooldown icon normally appears under the pet frame, check the pet checkbox.|n|nCooldown icons are saved to your class and specialisation."] = "输入你想要监视冷却的法术所属的ID。|n|n如果冷却图标显示到了宠物面板下方，请检查设置中的宠物复选框。|n|n冷却监控的相关设置是依据你的职业和专精来保存的。"
L["enter zone or track name"] = "输入区域或者曲目名称"
L["Epilogue (Alliance)"] = "尾声（联盟）"
L["Epilogue (Horde)"] = "尾声（部落）"
L["Error messages will be hidden"] = "错误信息已屏蔽。"
L["Error messages will be shown"] = "错误信息已显示。"
L["Error retrieving quest."] = "接受任务错误。"
L["Establish Your Garrison (Alliance)"] = "建造你的要塞（联盟）"
L["Establish Your Garrison (Horde)"] = "建造你的要塞（部落）"
L["Eternal Palace"] = "永恒王宫"
L["Events"] = "事件"
L["Everbloom"] = "永茂林地"
L["Evermoon Terrace"] = "永月平台"
L["Eversong Woods"] = "永歌森林"
L["Extras"] = "其他"
L["Eye of Azshara"] = "艾萨拉之眼"
L["Eye of Eternity"] = "永恒之眼"
L["Falanaar"] = "法兰纳尔"
L["Fall of Deathwing"] = "死亡之翼的陨落"
L["Fall of the Lich King"] = "巫妖王的殒落"
L["False"] = "错误"
L["Faster auto loot"] = "加速自动拾取"
L["Faster movie skip"] = "快速跳过短片"
L["Fate of the Horde"] = "部落的命运"
L["Features"] = "功能"
L["Felsoul Hold"] = "邪魂堡垒"
L["Felwood"] = "费伍德森林"
L["Feralas"] = "菲拉斯"
L["Find Item"] = "查找物品"
L["Firelands"] = "火焰之地"
L["Fizzle"] = "游戏音效"
L["Forge of Souls"] = "灵魂熔炉"
L["Frames"] = "框体相关"
L["Freehold"] = "自由镇"
L["Frostfire Ridge"] = "霜火岭"
L["Game Options"] = "游戏设置"
L["Gate of the Setting Sun"] = "残阳关"
L["General"] = "通用"
L["Ghost"] = "灵魂状态框体"
L["Ghostlands"] = "幽魂之地"
L["Gnomeregan"] = "诺莫瑞根"
L["Gold Only"] = "仅输入金币"
L["Gorgrond"] = "戈尔隆德"
L["Graphics and Sound"] = "界面和音效"
L["Grim Batol"] = "格瑞姆巴托"
L["Grimrail Depot"] = "恐轨车站"
L["Grizzly Hills"] = "灰熊丘陵"
L["Groups"] = "队伍"
L["Gruul's Lair"] = "格鲁尔的巢穴"
L["Gul'dan Ascendant"] = "古尔丹之治"
L["Gul'dan's Plan"] = "古尔丹的计策"
L["Gundrak"] = "古达克"
L["Halls of Lightning"] = "闪电大厅"
L["Halls of Origination"] = "起源大厅"
L["Halls of Reflection"] = "倒映大厅"
L["Halls of Stone"] = "岩石大厅"
L["Halls of Valor"] = "勇气大厅"
L["Harbingers Gul'dan"] = "预言者古尔丹"
L["Harbingers Illidan"] = "预言者伊利丹"
L["Harbingers Khadgar"] = "预言者卡德加"
L["Havenswood"] = "湾林"
L["Heart of Fear"] = "恐惧之心"
L["Hellfire Citadel"] = "地狱火堡垒"
L["Hellfire Peninsula"] = "地狱火半岛"
L["Hellfire Ramparts"] = "地狱火城墙"
L["Hellscream's Downfall (Alliance)"] = "地狱咆哮的殒落（联盟）"
L["Hellscream's Downfall (Horde)"] = "地狱咆哮的殒落（部落）"
L["Help"] = "帮助"
L["Hide alerts"] = "隐藏信息提示"
L["Hide bodyguard gossip"] = "隐藏保镖对话"
L["Hide boss banner"] = "隐藏BOSS横幅"
L["Hide chat buttons"] = "隐藏聊天窗口按钮"
L["Hide clean-up buttons"] = "隐藏背包整理按钮"
L["Hide cooldown duration numbers (if enabled)"] = "隐藏冷却计时（若启用）"
L["Hide error messages"] = "隐藏错误信息"
L["Hide gryphons"] = "隐藏动作条狮鹫"
L["Hide level-up display"] = "隐藏升级提示"
L["Hide order hall bar"] = "隐藏职业大厅信息"
L["Hide portrait numbers"] = "隐藏头像数字"
L["Hide social button"] = "隐藏社交按钮"
L["Hide stance bar"] = "隐藏姿态条"
L["Hide talking frame"] = "隐藏对话框体"
L["Hide the clock"] = "隐藏时钟"
L["Hide the combat log"] = "隐藏战斗记录窗口"
L["Hide the zone text bar"] = "隐藏区域信息"
L["Hide the zoom buttons"] = "隐藏缩放按钮"
L["Hide tooltips for world units during combat"] = "战斗中隐藏窗口"
L["Hide zone text"] = "隐藏区域文本"
L["High"] = "高"
L["Highmaul"] = "悬槌堡"
L["Highmountain"] = "至高岭"
L["Highmountain Tauren"] = "至高岭牛头人"
L["Hillsbrad Foothills"] = "希尔斯布莱德丘陵"
L["Hinterlands"] = "辛特兰"
L["Home"] = "主页"
L["Hour of Twilight"] = "暮光之刻"
L["Howling Fjord"] = "嚎风峡湾"
L["Hyjal Summit"] = "海加尔山"
L["Icecrown"] = "冰冠冰川"
L["Icecrown Citadel"] = "冰冠堡垒"
L["If checked, a button will be added to the character sheet which will show your equipped item durability when you hover the pointer over it.|n|nIn addition, an overall percentage will be shown in the chat frame when you die."] = "勾选后，一个按钮会显示在角色框体，其鼠标提示信息会显示身上的装备耐久度。|n|n当你死后，你的整体耐久度也会显示在聊天框体。"
L["If checked, a group invite will be sent to anyone who whispers you with a set keyword as long as you are ungrouped, group leader or raid assistant."] = "勾选后，当你未组队或者拥有队伍权限时，可以自动邀请密语中包含预设关键词的玩家。"
L["If checked, a group invite will be sent to anyone who whispers you with the keyword INV.|n|nYou need to be either ungrouped or party leader in your own group for this to work."] = "勾选后，会自动邀请那些密语你“INV”的玩家。|n|n你必须不在队伍中，或者是队伍队长的情况下，才可以生效。"
L["If checked, a master volume slider will be shown on the character sheet.|n|nThe volume slider can be placed in either of two locations on the character sheet.  To toggle between them, hold the shift key down and right-click the slider."] = "勾选后，一个全局音量控制滑块会显示在角色信息框体。|n|n这个音量控制可以在两个位置之间切换，你可以按住SHIFT+鼠标右键进行切换。"
L["If checked, a minimap button will be available.|n|nClick - Toggle options panel.|n|nSHIFT/Left-click - Toggle music.|n|nSHIFT/Right-click - Toggle stopwatch.|n|nCTRL/Left-click - Toggle minimap target tracking.|n|nCTRL/Right-click - Toggle errors (if enabled).|n|nCTRL/SHIFT/Left-click - Toggle Zygor (if installed).|n|nCTRL/SHIFT/Right-click - Toggle windowed mode."] = "勾选后，小地图图标可用。|n|n单击 - 打开控制面板。|n|nSHIFT+左键 - 打开音乐。|n|nSHIFT+右键 - 打开计时器。|n|nCTRL+左键 - 打开小地图追踪。|n|nCTRL+右键 - 开关错误信息（需启用）。|n|nCTRL+SHIFT+左键 - 开关Zygor插件（需安装）.|n|nCTRL+SHIFT+右键 - 开关窗口模式。"
L["If checked, alert frames will not be shown."] = "勾选后，通知提示框体不再显示。"
L["If checked, all grey items in your bags will be sold automatically when you visit a merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "勾选后，当你访问商贩时将自动出售背包中的杂物。|n|n当你访问时按住Shift键，可以暂时忽略该功能。"
L["If checked, available quests will be accepted automatically."] = "勾选后，自动接受可用的任务。"
L["If checked, backdrops will be tinted blue (friendly) or red (hostile)."] = "勾选后，信息窗口的边框会更改为蓝色（右方）或者红色（敌方）。"
L["If checked, Ban-Lu will no longer talk to you."] = "勾选后，坐骑班禄将不再和你说话。"
L["If checked, battle pets which are automatically summoned will be dismissed within a few seconds.|n|nThis includes dragging a pet onto the first team slot in the pet journal and entering a battle pet team save command.|n|nNote that pets which are automatically summoned during combat will be dismissed when combat ends."] = "勾选后，被自动召唤的战斗宠物会在若干秒后被自动召回。|n|n这包括将宠物拖动到对战队伍栏位和进入宠物对战的指令。|n|n需要注意的是，战斗中自动召唤的宠物会在战斗结束后再解散。"
L["If checked, battle shouts heard when casting specific spells will be muted."] = "勾选后，施放特殊技能时的战斗怒吼音效会被禁音。"
L["If checked, BattleTag and Real ID friend requests will be automatically declined.|n|nEnabling this option will automatically decline any pending requests."] = "勾选后，战网好友申请会自动屏蔽。|n|n启用后，当前待处理的申请会自动拒绝。"
L["If checked, chat frame buttons will be hidden.|n|nClicking chat tabs will automatically show the latest messages.|n|nUse the mouse wheel to scroll through the chat history.  Hold down SHIFT for page jump or CTRL to jump to the top or bottom of the chat history."] = "勾选后，聊天窗口的按钮会被隐藏。|n|n点击窗口标签会自动显示最新的消息。|n|n使用鼠标滚轮可以查看历史消息。按住SHIFT进行消息页面跳转，按住CTRL将滚动至消息页首/页尾。"
L["If checked, chat text will not fade out after a time period."] = "勾选后，聊天信息不会在一定时间后淡出。"
L["If checked, class coloring will be used in the player frame, target frame and focus frame."] = "勾选后，会在玩家、目标和焦点面板启用职业颜色。"
L["If checked, class icons will be shown in the portrait frames."] = "勾选后，玩家的头像会替换为职业图标。"
L["If checked, completed quests will be turned-in automatically."] = "勾选后，已完成的任务自动提交。"
L["If checked, confirmations will no longer appear when you choose a loot roll option or attempt to sell or mail a tradable item."] = "勾选后，当你选择Roll点或者想要出售/邮寄一个可交易物品时，不再显示确认信息。"
L["If checked, converting a party group to a raid group will succeed even if there are low level characters in the group.|n|nEveryone in the group needs to have Leatrix Plus installed with this option enabled."] = "勾选后，将队伍转换为团队时，低等级玩家不再受限。|n|n小队里的玩家必须都安装Leatrix Plus插件才可以生效。"
L["If checked, cooldown duration numbers will not be shown over the cooldowns.|n|nIf unchecked, cooldown duration numbers will be shown over the cooldowns if they are enabled in the game options panel ('ActionBars' menu)."] = "勾选后，冷却计时数字不再显示。|n|n如果未勾选，在界面-动作条中启用冷却计时后，在相关的冷却中的法术图标会显示计时数字。"
L["If checked, daily quests will not be accepted automatically."] = "勾选后，日常任务不会自动接受。"
L["If checked, damage and healing numbers in the player and pet portrait frames will be hidden."] = "勾选后，在玩家头像和宠物头像上的伤害及治疗数字不再显示。"
L["If checked, dragging the General chat tab while the chat frame is locked will expand the chat frame upwards.|n|nIf the chat frame is unlocked, dragging the General chat tab will move the chat frame."] = "勾选后，对锁定的聊天窗口进行拖动，会使其竖直拉伸。|n|n对已解锁的聊天窗口进行拖动，会使其移动。"
L["If checked, duel requests will be blocked unless the player requesting the duel is in your friends list or guild."] = "勾选后，对于非好友和非公会成员的决斗信息会被屏蔽。"
L["If checked, emote sounds will be silenced while your character is:|n|n- resting|n- in a pet battle|n- at the Halfhill Market|n- at the Grim Guzzler|n|nEmote sounds will be enabled when none of the above apply."] = "勾选后，当你处于下列情况时将关闭表情音效：|n|n休息时|n处于宠物对战中|n在半山集市|n在黑铁酒吧|n|n当你不处于上述位置时将恢复表情音效。"
L["If checked, enemy nameplates will be shown during combat and hidden when combat ends."] = "勾选后，敌对姓名板会在战斗中自动开启，离开战斗后关闭。"
L["If checked, gear toggle buttons will be added to the dressup frame and model positioning controls will be removed."] = "勾选后，装备切换按钮会天界至试衣间，同时模型移动控制会被移除。"
L["If checked, group invites will only be sent to friends and guild members.|n|nIf unchecked, group invites will be sent to everyone."] = "勾选后，自动邀请仅针对好友或者公会成员。|n|n当未勾选时，邀请是针对所有玩家。"
L["If checked, guild ranks will be shown for players in your guild."] = "勾选后，显示公会会阶。"
L["If checked, most error messages (such as 'Not enough rage') will not be shown.  Some important errors are excluded.|n|nIf you have the minimap button enabled, you can hold down the control key and right-click it to toggle error messages without affecting this setting."] = "勾选后，除了部分特殊提示，大部分的错误信息（例如怒气不足）都不再显示。|n|n如果你启用了小地图按钮，你可以按住CTRL+鼠标右键来单独控制错误信息的开关。"
L["If checked, most of the bike mount sounds will be muted."] = "勾选后，会禁音大部分机动车类型的坐骑音效。"
L["If checked, party invitations from friends or guild members will be automatically accepted unless you are queued in Dungeon Finder."] = "勾选后，如果你不在地下城队列中，你的好友或公会成员发送的组队申请会被自动接受。"
L["If checked, party invitations will be blocked unless the player inviting you is in your friends list or guild."] = "勾选后，对于非好友和非公会成员的组队邀请会被屏蔽。"
L["If checked, party sync requests from friends or guild members will be automatically accepted."] = "勾选后，会自动接受来自好友或者公会成员的小队同步请求。"
L["If checked, pet battle duel requests will be blocked unless the player requesting the duel is in your friends list or guild."] = "勾选后，对于非好友和非公会成员的宠物对战信息会被屏蔽。"
L["If checked, profession filter settings will be saved for the remainder of your login session."] = "勾选后，专业过滤设置会保存你最近一次的操作。"
L["If checked, quests will be selected, accepted and turned-in automatically.|n|nQuests which have a gold, currency or crafting reagent requirement will not be turned-in automatically.|n|nYou can hold the shift key down when you talk to a quest giver to override this setting."] = "勾选后，将对任务进行自动交互。|n|n任务需求金币，货币或者材料的不会自动交接。|n|n当按住SHIFT键打开对话时，可以忽略这项设置。"
L["If checked, raid chat and instance chat will both be colored blue (to match the default party chat color)."] = "勾选后，团队和副本聊天信息会改为蓝色（与小队一致）。"
L["If checked, repair costs will be taken from guild funds for characters that are guilded and have permission to repair."] = "勾选后，当公会修理可用时，将优先使用公会资金。"
L["If checked, requests initiated by your party leader to join the Dungeon Finder queue will be automatically accepted if the party leader is in your friends list or guild.|n|nThis option requires that you have selected a role for your character in the Dungeon Finder window."] = "勾选后，如果你的小队队长是你的好友或公会成员，其申请的地下城请求会被自动接受。|n|n这个选项不会自动将你传送到副本中。|n|n这个选项需要你在地下城页面选择一个职责。"
L["If checked, resurrection requests will be accepted automatically as long as the player resurrecting you is not in combat.|n|nResurrection requests from a Brazier of Awakening or a Failure Detection Pylon will not be accepted automatically."] = "勾选后，会自动接受在战斗外对你发起的战复。|n|n不会自动接受来自觉醒火盆或者工程晶塔的战复。"
L["If checked, spell IDs will be shown in buff icon tooltips located in the buff frame and under the target frame."] = "勾选后，在Buff框体和目标头像下方的相关法术图标的鼠标提示框中，会显示它们的法术ID。"
L["If checked, sticky chat will be disabled.|n|nNote that this does not apply to temporary chat windows."] = "勾选后，会禁用聊天频道的粘滞。|n|n此选项不会影响临时对话窗口。"
L["If checked, summon requests will be accepted automatically unless you are in combat."] = "勾选后，当你不处于战斗状态时会自动接受召唤。"
L["If checked, the addon list (accessible from the game menu) will show character based addons by default."] = "勾选后，插件列表（游戏菜单处）会显示默认的对角色生效的插件。"
L["If checked, the amount of time it takes to auto loot creatures will be significantly reduced."] = "勾选后，自动拾取的耗时将会明显降低。"
L["If checked, the backpack clean-up button and the bank frame clean-up button will not be shown."] = "勾选后，背包及银行的整理按钮不再显示。"
L["If checked, the boss banner will not be shown.|n|nThe boss banner appears when a boss is defeated.  It shows the name of the boss and the loot that was distributed."] = "勾选后，BOSS的横幅信息不再显示。|n|n该信息通常在BOSS被击败后显示。它显示BOSS的名字以及掉落。"
L["If checked, the button to toggle the raid container frame will be shown just above the raid management frame (left side of the screen) instead of in the raid management frame itself.|n|nThis allows you to toggle the raid container frame without needing to open the raid management frame."] = "勾选后，打开团队信息的按钮会显示在左侧团队管理框体的上方，而不是在其内部。|n|n此选项让你无需打开团队管理框体，就可以切换团队框体。"
L["If checked, the clock will be hidden."] = "勾选后，小地图的时钟会被隐藏。"
L["If checked, the combat log will be hidden.|n|nThe combat log must be docked in order for this option to work.|n|nIf the combat log is undocked, you can dock it by dragging the tab (and reloading your UI) or by resetting the chat windows (from the chat menu)."] = "勾选后，战斗记录会被隐藏。|n|n战斗记录窗口必须未被分离时才能生效。|n|n如果战斗记录窗口被分离了，你可以拖动其合并至主窗口（然后重载插件），或者在聊天设置中重置设置。"
L["If checked, the 'Display only character achievements to others' setting in the game options panel ('Social' menu) will be permanently checked and locked."] = "勾选后，“对他人只显示角色成就”的选项（界面-社交）会被永久勾选并锁定。"
L["If checked, the editbox will be moved to the top of the chat frame."] = "勾选后文本框会被移动至聊天窗口上方。"
L["If checked, the editbox will close when it loses focus."] = "勾选后，输入框失去焦点时自动关闭。"
L["If checked, the Foot Ball sounds will be muted."] = "勾选后，球类玩具的声音将被静音。"
L["If checked, the gossip window will not be shown when you talk to an active garrison bodyguard.|n|nYou can hold the shift key down when you talk to a bodyguard to override this setting."] = "勾选后，你的保镖对话时不再出现选项。|n|n对话时按住Shift键，可以暂时忽略该项设置。"
L["If checked, the grey screen of death and the netherworld effect will be disabled."] = "勾选后，将关闭死亡后的灵魂世界特效和渐隐时的特殊光效。"
L["If checked, the interface button sound, the chat frame tab click sound and the game menu toggle sound will be muted."] = "勾选后，将静音插件按钮音效、聊天窗标签点击音效以及游戏菜单音效。"
L["If checked, the level-up display will not be shown.|n|nThe level-up display shows encounter objectives, level-ups, pet battle rewards, etc."] = "勾选后，升级提示不再显示。|n|n升级提示功能包括副本目标、升级、小宠物奖励等等。"
L["If checked, the main bar gryphons will not be shown."] = "勾选后，动作条两边的狮鹫不再显示。"
L["If checked, the mechanical guild vault idle sound will be muted."] = "勾选后，公会仓库的音效将被静音。"
L["If checked, the netherworld effect will be disabled."] = "勾选后，关闭死亡后的特效、"
L["If checked, the order hall command bar will not be shown."] = "勾选后，当你处于职业大厅时，顶部的信息条不再显示。"
L["If checked, the player frame background will be shown in class color."] = "勾选后，玩家框体的背景会显示职业颜色。"
L["If checked, the ready check sound will be muted."] = "勾选后，屏蔽就位确认音效。"
L["If checked, the screen glow will be disabled.|n|nEnabling this option will also disable the drunken haze effect."] = "勾选后，屏幕泛光会被禁用。|n|n启用这个选项的同时，也会关闭醉酒时的泛光效果。"
L["If checked, the social button and quick-join notification will be hidden."] = "勾选后，社交按钮和快速加入通知会被隐藏。"
L["If checked, the spell fizzle sounds will be muted."] = "勾选后，将静音法术音效。"
L["If checked, the stance bar will not be shown."] = "勾选后，姿态条不再显示。"
L["If checked, the talking frame will not be shown.|n|nThe talking frame normally appears in the lower portion of the screen when certain NPCs communicate with you."] = "勾选后，对话面板不再显示。|n|n当NPC与你交流时，该框体通常出现在界面下方。"
L["If checked, the target frame background and focus frame background will be shown in class color."] = "勾选后，目标及焦点框体的背景会显示职业颜色。"
L["If checked, the tooltip will be color coded and you will be able to modify the tooltip layout and scale."] = "勾选后，鼠标信息会被着色，你可以设置他的布局和大小尺寸。"
L["If checked, the worgen sniffing sounds will be muted."] = "勾选后，将静音狼人的喘息声。"
L["If checked, the zone text bar will be hidden.  The tracking button tooltip will show zone information."] = "勾选后，小地图的区域信息会被隐藏。追踪按钮的提示信息里会显示区域信息。"
L["If checked, the zoom buttons will be hidden.  You can use the mousewheel to zoom regardless of this setting."] = "勾选后，缩放按钮会被隐藏。你可以使用鼠标滚来来对小地图进行缩放。"
L["If checked, tooltips for world units will be hidden during combat.|n|nYou can hold the shift key down to override this setting."] = "勾选后，目标的信息窗口在战斗中会被隐藏。|n|n你可以按住SHIFT键暂时忽略这个设置。"
L["If checked, train sounds will be muted."] = "勾选后，火车音效将被静音。"
L["If checked, traveling merchant greetings and farewells will be muted.|n|nThis applies to Traveler's Tundra Mammoth, Grand Expedition Yak and Mighty Caravan Brutosaur."] = "勾选后，将屏蔽旅行商人的问候。|n|n此选项针对旅行者的苔原猛犸象，雄壮远足牦牛以及雄壮商队雷龙。"
L["If checked, unit targets will be shown."] = "勾选后，目标的目标会显示在信息窗口上。"
L["If checked, weekly quests will not be accepted automatically."] = "勾选后，周常任务不会自动接受。"
L["If checked, Wowhead links will be shown in the world map frame and the achievements frame."] = "勾选后，wowhead的链接会显示在地图和成就面板里。"
L["If checked, Xiwyllag ATV will be muted."] = "勾选后，全地形载具的声音将被静音。"
L["If checked, you can hold down the alt key while opening a gossip window to automatically select a single gossip option."] = "勾选后，你可以按住ALT键来自动交互只有一个选项的对话窗口。"
L["If checked, you can hold down the control key and click a chat tab to view recent chat in a copy-friendly window."] = "勾选后，你可以按住CTRL键，点击聊天标签来打开相应的历史记录窗口，以供复制。"
L["If checked, you can open Leatrix Plus by pressing CTRL/Z."] = "勾选后，你可以使用CTRL+Z来打开Leatrix Plus。"
L["If checked, you can press the arrow keys to move the insertion point left and right in the chat frame.|n|nIf unchecked, the arrow keys will use the default keybind setting."] = "勾选后，你可以使用方向键移动文本框中的光标。|n|n如果未被勾选，方向键将保持它所绑定的按键功能。"
L["If checked, you will be able to cancel cinematics without being prompted for confirmation."] = "勾选后，你无需确认即可快速跳过过场短片。"
L["If checked, you will be able to change the font size of quest text.|n|nEnabling this option will also change the text size of other frames which inherit the same font (such as the Dungeon Finder frame)."] = "勾选后，你可以更改任务信息文本的字体大小。|n|n启用这个选项也会影响使用同一文本模版的框体（例如地下城查找器）。"
L["If checked, you will be able to change the font size of standard mail text.|n|nThis does not affect mail created using templates (such as auction house invoices)."] = "勾选后，你可以更改邮件文本的字体大小。|n|n这个选项不会影响系统邮件模版（例如拍卖行的收据信息）。"
L["If checked, you will be able to change the position and scale of the buffs frame."] = "勾选后，你可以调整Buff框体的位置和缩放。"
L["If checked, you will be able to change the position and scale of the player alternative power bar."] = "勾选后，你可以调整玩家额外能量条的位置和缩放。"
L["If checked, you will be able to change the position and scale of the player frame, target frame, ghost frame and timer bar."] = "勾选后，你可以修改玩家、目标、灵魂框体和计时条的位置和缩放。"
L["If checked, you will be able to change the position and scale of the widget frame.|n|nThe widget frame is commonly used for showing PvP scores and tracking objectives."] = "勾选后，你可以修改微件框体的位置和缩放。|n|n微件框体通常用于显示PVP占点分数以及目标追踪等。"
L["If checked, you will be able to customise the minimap."] = "勾选后，你可以开启小地图相关的自定义选项。"
L["If checked, you will be able to drag the chat frame to the edge of the screen."] = "勾选后，你可以把聊天窗口拖动到屏幕边缘。"
L["If checked, you will be able to mute a selection of game sounds."] = "勾选后，将静音游戏内按钮点击等音效。"
L["If checked, you will be able to place up to five beneficial cooldown icons above the target frame."] = "勾选后，你可以在目标框体上方监控至多5个的法术监控。"
L["If checked, you will be able to reposition the tooltip."] = "勾选后，你可以重新给鼠标提示框设置锚点。"
L["If checked, you will be able to save your current battle pet team (including abilities) to a single command.|n|nA button will be added to the Pet Journal.  Clicking the button will toggle showing the assignment command for your current team.  Pressing CTRL/C will copy the command to memory.|n|nYou can then paste the command (with CTRL/V) into the chat window or a macro to instantly assign your team."] = "勾选后，你可以通过一个单独的指令来保存你当前宠物对战的队伍配置信息（包括技能）。|n|n一个保存的按钮会添加到宠物面板。点击该按钮会给你当前的队伍显示相关的工作指令。按下<CTRL+C>会复制并缓存你的指令。|n|n你可以通过<CTRL+V>粘贴你的指令到聊天窗口或者宏页面，以实现快速配置队伍。"
L["If checked, you will be able to set the density of weather effects."] = "勾选后，你可以调整天气效果的显示密度。"
L["If checked, you will be able to show a rare, elite or rare elite chain around the player frame."] = "勾选后，会在玩家框体显示稀有、精英或者稀有精英的边框。"
L["If checked, you will be able to show customisable borders around the edges of the screen.|n|nThe borders are placed on top of the game world but under the UI so you can place UI elements over them."] = "勾选后，你可以在屏幕边缘显示自定义边框。|n|n边框的层级很低，你可以将UI元素放置于其上方。"
L["If checked, you will be able to zoom out to a greater distance."] = "勾选后，你可以加大镜头的缩放距离。"
L["If checked, you will need to hold the shift key down for quests to be automated.|n|nIf unchecked, holding shift will prevent quests from being automated."] = "勾选后，你可以按住Shift键来实现自动任务交互。|n|n如果未勾选，按住Shift键则停止自动任务交互。"
L["If checked, you will release automatically after you die in Ashran, Tol Barad (PvP), Wintergrasp or any battleground.|n|nYou will not release automatically if you have the ability to self-resurrect (soulstone, reincarnation, etc)."] = "勾选后，当你处于战场或者诸如阿什兰、托尔巴拉德或者冬拥湖之类的PVP场所，会在死亡时自动释放尸体。|n|n如果你有复生类的技能，则不会自动释放尸体（灵魂石，萨满复生等等）。"
L["If checked, your bags will not be opened or closed automatically when you interact with a merchant, bank or mailbox."] = "勾选后，当你打开商贩、银行或者邮箱时，背包不会自动开启或者关闭。"
L["If checked, your chat history will increase to 4096 lines.  If unchecked, the default will be used (128 lines).|n|nEnabling this option may prevent some chat text from showing during login."] = "勾选后，你的聊天历史记录会增涨至4096行。如果未被勾选，会保持在默认的128行。|n|n启用这个设置可能会在登录时会隐藏一些聊天信息。"
L["If checked, your gear will be repaired automatically when you visit a suitable merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "勾选后，当你打开一个可供修理的商贩时，会自动修理身上的装备。|n|n当你打开商贩时，按住SHIFT键会让你当下忽略此项功能。"
L["If checked, zone text will not be shown (eg. 'Ironforge')."] = "勾选后，区域文本不再显示。"
L["Increase chat history"] = "增加聊天历史记录"
L["Interface"] = "界面设置"
L["Into the Portal"] = "进入传送门"
L["Invalid battle pet team parameter."] = "无效的宠物对战队伍参数。"
L["Invalid console variable."] = "无效控制台缓存。"
L["Invalid parameter."] = "无效参数"
L["Invalid quest ID."] = "无效的任务ID。"
L["Invalid sound ID"] = "无效的声音ID"
L["Invalid taint level."] = "无效的污染等级。"
L["Invalid target."] = "无效目标。"
L["Invite from whispers"] = "密语邀请"
L["Iron Docks"] = "钢铁码头"
L["Island Expeditions"] = "海岛探险"
L["Isle of Conquest"] = "征服之岛"
L["Isle of Quel'Danas"] = "奎尔丹纳斯岛"
L["Isle of Thunder"] = "雷神岛"
L["Jade Forest"] = "翡翠林"
L["Jade Forest Crash"] = "翡翠林之战"
L["Jaina Joins the Battle"] = "吉安娜加入战斗"
L["Jaina Returns to Kul Tiras"] = "吉安娜重返库尔提拉斯"
L["Jaina's Nightmare"] = "吉安娜的梦魇"
L["Jaina's Siege"] = "吉安娜的围城"
L["Jaina's Theme"] = "吉安娜的主题"
L["Jorundall"] = "约伦达尔"
L["Kalimdor"] = "卡利姆多"
L["Karazhan"] = "卡拉赞"
L["Keyword"] = "关键词"
L["Kezan"] = "科赞岛"
L["Kil'jaeden's Downfall"] = "基尔加丹的殒落"
L["Kings' Rest"] = "诸王之眠"
L["Krasarang Wilds"] = "卡桑琅丛林"
L["Krokuun (Argus)"] = "克罗库恩（阿古斯）"
L["Kul Tiran Humans"] = "库尔提拉斯人"
L["Kul Tiras"] = "库尔提拉斯"
L["Kun-Lai Summit"] = "昆莱山"
L["Last Stand"] = "背水一战"
L["Leatrix Plus will not overwrite LeaPlusDB at next logout."] = "下次登出时不会清空LeatrixPlus的插件缓存。"
L["LEATRIX PLUS: WRONG VERSION INSTALLED!"] = "注意！你使用了错误的LeatrixPlus版本！"
L["Leaving Kezan"] = "逃离科赞岛"
L["Leaving the Wandering Isle"] = "离开梦幻岛"
L["Left"] = "左边"
L["Legion"] = "军团再临"
L["Lifetime honorable kills"] = "荣誉击杀总数"
L["Lightforged Draenei"] = "圣光德莱尼"
L["Lion's Watch"] = "雄狮岗哨"
L["Loch Modan"] = "洛克莫丹"
L["Lockout sharing"] = "成就共享锁定"
L["Lost City of the Tol'vir"] = "托维尔失落之城"
L["Lost Isles"] = "失落群岛"
L["Low"] = "低"
L["Lunastre Estate"] = "月郡庄园"
L["Mac'Aree (Argus)"] = "玛凯雷（阿古斯）"
L["Madness of Deathwing"] = "死亡之翼的疯狂"
L["Maelstrom"] = "大漩涡"
L["Mag'har Orcs"] = "玛格汉兽人"
L["Magisters' Terrace"] = "魔导师平台"
L["Magtheridon's Lair"] = "玛瑟里顿的巢穴"
L["Main Titles"] = "主标题"
L["Manage buffs"] = "Buff框体管理"
L["Manage frames"] = "管理框体面板"
L["Manage power bar"] = "能量条管理"
L["Manage widget"] = "微件管理"
L["Managed by Leatrix Plus"] = "LeatrixPlus托管"
L["Mana-Tombs"] = "法力陵墓"
L["Maraudon"] = "玛拉顿"
L["Maraudon: Earth Song Falls"] = "玛拉顿：毒水瀑布"
L["Maraudon: Foulspore Cavern"] = "玛拉顿：毒菇洞穴"
L["Maraudon: The Wicked Grotto"] = "玛拉顿：邪恶洞穴"
L["Mardum"] = "马顿"
L["Maw of Souls"] = "噬魂之喉"
L["Max camera zoom"] = "最大镜头距离"
L["Mechagon"] = "麦卡贡"
L["Mechanics"] = "特性设置"
L["Media"] = "媒体"
L["Medium"] = "中"
L["Memory Usage"] = "内存占用"
L["message shown."] = "信息显示。"
L["messages shown."] = "信息显示。"
L["Missing console variable."] = "丢失控制台缓存。"
L["Missing mount name."] = "坐骑名字缺失。"
L["Missing movie ID."] = "影片编号不存在。"
L["Missing pet name."] = "宠物名字缺失。"
L["Missing quest ID."] = "缺少任务ID。"
L["Missing sound file parameter."] = "缺失音频文件参数"
L["Missing sound ID."] = "缺少声音ID。"
L["Mists of Pandaria"] = "熊猫人之迷"
L["Mogu'shan Palace"] = "魔古山宫殿"
L["Mogu'shan Vaults"] = "魔古山宝库"
L["Molten Core"] = "熔火之心"
L["Moon Guard Stronghold"] = "护月堡垒"
L["Moonglade"] = "月光林地"
L["Motherlode"] = "主母"
L["Mount Hyjal"] = "海加尔山"
L["Mount not found."] = "无法找到该坐骑。"
L["Mounts"] = "坐骑"
L["Move editbox to top"] = "把文本框移动上方"
L["Movie not playable."] = "无法播放该影片。"
L["Movie number"] = "影片编号"
L["Movies"] = "电影"
L["Mulgore"] = "莫高雷"
L["Music"] = "音乐"
L["Music Rolls"] = "音乐列表"
L["Mute game sounds"] = "静音游戏音效"
L["My Very Own Castle (Alliance)"] = "我的要塞独一无二（联盟）"
L["My Very Own Castle (Horde)"] = "我的要塞独一无二（部落）"
L["Mystical"] = "神秘"
L["Nagrand"] = "纳格兰"
L["Nagrand (Draenor)"] = "纳格兰 (德拉诺)"
L["Narration"] = "旁白"
L["Naxxramas"] = "纳克萨玛斯"
L["Nazjatar"] = "纳沙塔尔"
L["Nazmir"] = "纳兹米尔"
L["Neltharion's Lair"] = "奈萨里奥的巢穴"
L["Netherstorm"] = "虚空风暴"
L["Nexus"] = "时空枢纽"
L["Nightborne"] = "夜之子"
L["Nighthold"] = "暗夜要塞"
L["No bad sound IDs found."] = "没有发现损坏的ID。"
L["No help is available for this page."] = "此页面没有帮助信息。"
L["No items with durability equipped."] = "尚未装备任何带有耐久度的物品。"
L["No media duplicates found."] = "没有发现媒体的副本。"
L["No tooltip showing."] = "目前没有任何提示信息。"
L["None"] = "无"
L["Northern Barrens"] = "北贫瘠之地"
L["Northern Stranglethorn"] = "北荆棘谷"
L["Northrend"] = "诺森德"
L["Not completed."] = "未完成。"
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Plus."] = "注意！|n你必须重新启动游戏客户端才可以正确加载新版本的Leatrix Plus。"
L["Nude"] = "隐藏着装"
L["Ny'alotha"] = "尼奥罗萨"
L["Obsidian Sanctum"] = "黑曜石圣殿"
L["Oculus"] = "魔环"
L["Off"] = "关闭"
L["Okay, disable Dominos Encounter for me"] = "好的，关了它"
L["Okay, disable screen adjust for me"] = "为我禁用屏幕自适应吧"
L["Old Hillsbrad Foothills"] = "旧希尔斯布莱德丘陵"
L["Onyxia's Lair"] = "奥妮克希亚的巢穴"
L["Operation Mechagon"] = "麦卡贡行动"
L["Orgrimmar"] = "奥格瑞玛"
L["Outland"] = "外域"
L["Overall"] = "总计"
L["Overlay"] = "外框"
L["Pandaria"] = "潘达利亚"
L["Particle density"] = "粒子密度"
L["Party from friends"] = "好友组队邀请"
L["Pet"] = "宠物"
L["Pet Battles"] = "宠物对战"
L["Pet not found.  Only owned pets that are currently showing in the journal can be searched."] = "无法找到该宠物。你只能搜索你所拥有的显示在藏品宠物页面中的宠物。"
L["Pit of Saron"] = "萨隆矿坑"
L["Plants vs Zombies"] = "植物大战僵尸"
L["Player"] = "玩家框体"
L["Portal"] = "传送门"
L["Power"] = "能量"
L["Power of the Horde"] = "部落之力"
L["Press CTRL/C to copy."] = "按住CTRL+C复制"
L["Queue from friends"] = "好友队列申请"
L["Ragefire Chasm"] = "怒焰裂谷"
L["Raid"] = "团队副本"
L["Raid frame toggle"] = "切换团队框体"
L["Random"] = "随机"
L["RARE"] = "稀有"
L["RARE ELITE"] = "稀有精英"
L["Razorfen Downs"] = "剃刀高地"
L["Razorfen Kraul"] = "剃刀沼泽"
L["Ready"] = "就位"
L["Realm Of Torment"] = "苦痛之境"
L["Recent chat window"] = "临时聊天窗口"
L["Reckoning"] = "最终审判"
L["Redridge Mountains"] = "赤脊山"
L["Reincarnation of Alleria Windrunner"] = "奥蕾莉亚的再生"
L["Rejection of the Gift"] = "拒绝馈赠"
L["Release in PvP"] = "PvP自动释放尸体"
L["Reload"] = "重载插件"
L["Remove raid restrictions"] = "移除团队等级限制"
L["Repair automatically"] = "自动修理装备"
L["Repair using guild funds if available"] = "优先使用公会修理"
L["Repaired for"] = "修理花费"
L["Reposition the tooltip"] = "重设提示框锚点"
L["Require shift key for quest automation"] = "需要按住Shift键以自动任务交互"
L["Requires UI reload."] = "需要重载插件"
L["Requires you to be interacting with Larana Drome.  She can be found at Scribes' Sacellum, Dalaran, Northrend."] = "需要你与拉兰娜·德罗姆交流。她可以在达拉然（诺森德）的铭文店里找到。"
L["Reset"] = "重置"
L["Resize mail text"] = "重设邮件文本"
L["Resize quest text"] = "重设任务文本"
L["Rested bubbles"] = "休息气泡信息"
L["Restrict to friends and guild members"] = "仅限好友及公会成员"
L["result"] = "结果"
L["results"] = "结果"
L["Return to Karazhan"] = "重返卡拉赞"
L["Return to the Black Temple"] = "重返黑暗神殿"
L["Right"] = "右边"
L["Right-click to close"] = "右键关闭"
L["Right-click to close."] = "右键点击关闭。"
L["right-click to go back"] = "右键点击返回"
L["Rise of Argus"] = "阿古斯的崛起"
L["Rise of Azshara"] = "艾萨拉的崛起"
L["Risking It All"] = "孤注一掷"
L["Ruby Sanctum"] = "红玉圣殿"
L["Ruins of Ahn'Qiraj"] = "安其拉废墟"
L["Ruins of Elune'eth"] = "艾露尼斯废墟"
L["Ruins of Gilneas"] = "吉尔尼斯废墟"
L["Sanctum of Order"] = "秩序大殿"
L["Save profession filters"] = "保存专业过滤"
L["Scale"] = "尺寸"
L["Scarlet Halls"] = "血色大厅"
L["Scarlet Monastery"] = "血色修道院"
L["Scholomance"] = "通灵学院"
L["Search"] = "搜索"
L["Searing Gorge"] = "灼热峡谷"
L["Seat of the Triumvirate"] = "执政团之座"
L["Select the settings that you want to use."] = "选择你想启用的设置。"
L["Selection of music tracks"] = "音乐列表的选择"
L["Self Markers Allowed"] = "允许自我标记"
L["Self Markers Blocked"] = "屏蔽自我标记"
L["Sell junk automatically"] = "自动出售杂物"
L["SELLING JUNK"] = "出售杂物"
L["Serpentshrine Cavern"] = "毒蛇神殿"
L["Set weather density"] = "设置天气效果密度"
L["Sethekk Halls"] = "塞泰克大厅"
L["Settings"] = "设置"
L["Shaders"] = "阴影"
L["Shado-Pan Monastery"] = "影踪修道院"
L["Shadow Labyrinth"] = "暗影迷宫"
L["Shadowfang Keep"] = "影牙城堡"
L["Shadowmoon Burial Grounds"] = "影月墓地"
L["Shadowmoon Valley"] = "影月谷"
L["Shadowmoon Valley (Draenor)"] = "影月谷 (德拉诺)"
L["Shipyard Construction (Alliance)"] = "建造船坞（联盟）"
L["Shipyard Construction (Horde)"] = "建造船坞（部落）"
L["Sholazar Basin"] = "索拉查盆地"
L["Shouts"] = "怒吼"
L["Show borders"] = "显示边框"
L["Show character addons"] = "显示角色插件"
L["Show cooldowns"] = "显示冷却计时"
L["Show durability status"] = "显示耐久度"
L["Show guild ranks for your guild"] = "显示会阶"
L["Show minimap button"] = "显示小地图按钮"
L["Show pet save button"] = "保存宠物按钮"
L["Show player chain"] = "显示玩家边框"
L["Show player frame in class color"] = "玩家框体职业颜色"
L["Show raid button"] = "显示团队按钮"
L["Show target frame and focus frame in class color"] = "目标及焦点框体职业颜色"
L["Show the spell ID in buff icon tooltips"] = "显示法术ID"
L["Show the unit's target"] = "显示目标的目标"
L["Show volume slider"] = "显示音量控制"
L["Show Wowhead links"] = "显示wowhead链接"
L["Shrine of the Storm"] = "风暴神殿"
L["Siege of Boralus"] = "围攻伯拉勒斯"
L["Siege of Dazar'alor"] = "围攻达萨罗"
L["Siege of Niuzao Temple"] = "围攻砮皂寺"
L["Siege of Orgrimmar"] = "决战奥格瑞玛"
L["Silence rested emotes"] = "表情禁音"
L["Silithus"] = "希利苏斯"
L["Silverpine Forest"] = "银松森林"
L["Silvershard Mines"] = "碎银矿脉"
L["Skyreach"] = "通天峰"
L["Slave Pens"] = "奴隶围栏"
L["Sniffing"] = "喘息声"
L["Social"] = "社交信息"
L["Sold junk for"] = "杂物出售总计"
L["Sound system restarted."] = "声音系统已重启。"
L["Southern Barrens"] = "南贫瘠之地"
L["Spell ID"] = "法术ID"
L["Spine of Deathwing"] = "死亡之翼的脊背"
L["Spires of Arak"] = "阿兰卡峰林"
L["Steamvault"] = "蒸汽地窟"
L["Stockade"] = "暴风城监狱"
L["Stonecore"] = "巨石之核"
L["Stonetalon Mountains"] = "石爪山脉"
L["Stop"] = "停止"
L["Storm Peaks"] = "风暴峭壁"
L["Stormheim"] = "风暴峡湾"
L["Stormheim (Alliance)"] = "风暴峡湾（联盟）"
L["Stormheim (Horde)"] = "风暴峡湾（部落）"
L["Stormsong Valley"] = "斯托颂谷地"
L["Stormstout Brewery"] = "风暴酿酒厂"
L["Stormwind"] = "暴风城"
L["Strand of the Ancients"] = "远古海滩"
L["Stratholme"] = "斯坦索姆"
L["Stratholme: Crusader's Square"] = "斯坦索姆：十字军广场"
L["Stratholme: The Gauntlet"] = "斯坦索姆：后门"
L["Sunken Temple"] = "沉没的神庙"
L["Sunwell Plateau"] = "太阳之井高地"
L["Support"] = "帮助支持"
L["Suramar"] = "苏拉玛"
L["Swamp of Sorrows"] = "悲伤沼泽"
L["Sync from friends"] = "好友同步请求"
L["System"] = "系统设置"
L["Tabard"] = "隐藏战袍"
L["Taint level: Basic (1)."] = "污染等级：基本(1)。"
L["Taint level: Disabled (0)."] = "污染等级：禁用(0)。"
L["Taint level: Full (2)."] = "污染等级：全面(2)。"
L["Talador"] = "塔拉多"
L["Tanaan Jungle"] = "塔纳安丛林"
L["Tanaris"] = "塔纳利斯"
L["Target"] = "目标框体"
L["Target Tracking Disabled"] = "禁用目标追踪"
L["Target Tracking Enabled"] = "启用目标追踪"
L["Tea with Jaina"] = "与吉安娜共饮"
L["Tel'anor"] = "泰安诺"
L["Teldrassil"] = "泰达希尔"
L["Tempest Keep"] = "风暴要塞"
L["Temple of Ahn'Qiraj"] = "安其拉神殿"
L["Temple of Atal'Hakkar"] = "阿塔哈卡神庙"
L["Temple of Sethraliss"] = "塞塔里斯神庙"
L["Temple of the Jade Serpent"] = "青龙寺"
L["Ten Years of Warcraft"] = "魔兽十周年"
L["Terokkar Forest"] = "泰罗卡森林"
L["Terrace of Endless Spring"] = "永春台"
L["Terror of Darkshore"] = "黑海岸的恐怖"
L["Text"] = "文本信息"
L["Text size"] = "字体尺寸"
L["Text Size"] = "字体尺寸"
L["The Art of War"] = "战争的艺术"
L["The Battle for Broken Shore"] = "破碎海滩之战"
L["The Battle for Shattrath"] = "沙塔斯之战"
L["The Battle of Thunder Pass"] = "雷电王座之战"
L["The Burning Crusade"] = "燃烧的远征"
L["The Demon's Trail"] = "恶魔的追踪"
L["The Dragon Soul"] = "巨龙之魂"
L["The Eye"] = "风暴要塞"
L["The Fall of Lordaeron"] = "洛丹伦的陨落"
L["The Fate of Val'sharah"] = "瓦尔莎拉的命运"
L["The Fleet in Krasarang (Alliance)"] = "卡桑琅的舰队（联盟）"
L["The Fleet in Krasarang (Horde)"] = "卡桑琅的舰队（部落）"
L["The Frozen Halls"] = "冰封大殿"
L["The Invasion Begins"] = "入侵开始"
L["The King's Command"] = "国王的征召"
L["The Negotiation"] = "谈判"
L["The Nightborne Pact"] = "夜之子的公约"
L["The Nighthold"] = "暗夜要塞"
L["The Return of Hope"] = "希望重燃"
L["The summon from"] = "召唤来自"
L["The Threat Within"] = "内在的威胁"
L["The Waning Crescent"] = "残月酒馆"
L["Themes"] = "主题"
L["This command will assign your current pet team and selected abilities.|n|nPress CTRL/C to copy the command then paste it into a macro or chat window with CTRL/V."] = "这个命令会指派你的当前宠物对战队伍并保存技能选择信息。|n|n按下<CTRL+C>来复制指令，然后通过<CTRL+V>来粘贴指令到聊天窗口或者宏页面中。"
L["This panel will close automatically if you enter combat."] = "此面板在你进入战斗后自动关闭。"
L["Thousand Needles"] = "千针石林"
L["Throne of the Four Winds"] = "风神王座"
L["Throne of the Tides"] = "海潮王座"
L["Throne of Thunder"] = "雷电王座"
L["Thunder Bluff"] = "雷霆崖"
L["Timeless Isle"] = "永恒岛"
L["Timer"] = "计时框体"
L["Tiragarde Sound"] = "提拉加德海峡"
L["Tirisfal Glades"] = "提瑞斯法林地"
L["Titan Panel screen adjust needs to be disabled for frames to be saved correctly."] = "泰坦信息面板的屏幕自适应需要禁用，以方便各框体的保存。"
L["To begin, choose an options page."] = "请选择一项开始使用"
L["To hide the combat log, you need to disable the chat module in ElvUI."] = "若需关闭战斗记录，你需要在ElvUI中禁用聊天模块。"
L["To use the Find Item button, you need to deselect the WoW Token category."] = "你必须取消魔兽货币分类以启用寻找物品的按钮。"
L["Tol Barad"] = "托尔巴拉德"
L["Tol Dagor"] = "托尔达戈"
L["Tomb of Sargeras"] = "萨格拉斯之墓"
L["Tooltip"] = "鼠标信息窗口"
L["Tooltip title color"] = "鼠标提示信息颜色"
L["Top"] = "顶部"
L["Top Center"] = "顶级中心"
L["Townlong Steppes"] = "螳螂高原"
L["Tracing started."] = "追踪开始。"
L["Tracing stopped."] = "追踪停止。"
L["Trains"] = "火车"
L["Transparency"] = "透明度"
L["Travelers"] = "旅行商人"
L["Trial of Style"] = "时尚试炼"
L["Trial of the Champion"] = "冠军的试炼"
L["Trial of the Crusader"] = "十字军的试炼"
L["Trial of Valor"] = "勇气试炼"
L["True"] = "正确"
L["Turn-in completed quests automatically"] = "自动提交任务"
L["Twilight Highlands"] = "暮光高地"
L["Twilight Vineyards"] = "暮光酒庄"
L["Twin Peaks"] = "双子峰"
L["Uldaman"] = "奥达曼"
L["Uldir"] = "奥迪尔"
L["Ulduar"] = "奥杜尔"
L["Uldum"] = "奥丹姆"
L["Unclamp chat frame"] = "不限制窗口位置"
L["Underbog"] = "幽暗沼泽"
L["Undercity"] = "幽暗城"
L["Underrot"] = "地渊孢林"
L["Un'Goro Crater"] = "安戈洛环形山"
L["Universal group color"] = "统一队伍颜色"
L["Use arrow keys in chat"] = "允许使用方向键"
L["Use easy resizing"] = "使用简单拉伸"
L["Use Leatrix Plus to move that frame."] = "使用Leatrix Plues来移动框体"
L["Use Leatrix Plus to reset that frame."] = "使用Leatrix Plues来重置框体"
L["Utgarde Keep"] = "乌特加德城堡"
L["Utgarde Pinnacle"] = "乌特加德之巅"
L["Vale of Eternal Blossoms"] = "锦绣谷"
L["Valley of the Four Winds"] = "四风谷"
L["Val'sharah"] = "瓦尔莎拉"
L["Value must be a number."] = "该参数必须为数字。"
L["Various"] = "其他"
L["Vashj'ir"] = "瓦丝琪尔"
L["Vault of Archavon"] = "阿尔卡冯的宝库"
L["Vault of the Wardens"] = "守望者地窟"
L["Vaults"] = "公会仓库"
L["Vendors"] = "商贩"
L["Version"] = "版本"
L["Victory at The Nighthold"] = "暗夜要塞的胜利"
L["Victory in Draenor!"] = "德拉诺的胜利！"
L["Video"] = "视频"
L["Violet Hold"] = "紫罗兰监狱"
L["Visibility"] = "可见性"
L["Vision of Sailor's Memory"] = "海员记忆的幻象"
L["Visions of N'Zoth"] = "恩佐斯的幻象"
L["Void Elves"] = "虚空精灵"
L["Vol'dun"] = "沃顿"
L["Vol'mar"] = "沃玛尔"
L["Wailing Caverns"] = "哀嚎洞穴"
L["Wandering Isle"] = "迷踪岛"
L["Warbringers Azshara"] = "战争使者艾萨拉"
L["Warbringers Jaina"] = "战争使者吉安娜"
L["Warbringers Sylvanas"] = "战争使者 希尔瓦娜斯"
L["Warfronts"] = "战争前线"
L["Warlords of Draenor"] = "德拉诺之王"
L["Warning"] = "警告"
L["was automatically declined."] = "已经自动拒绝。"
L["Waycrest Manor"] = "维克雷斯庄园"
L["Weather density"] = "天气密度"
L["Welcome to Leatrix Plus."] = "欢迎使用Leatrix Plus"
L["Well of Eternity"] = "永恒之井"
L["Western Plaguelands"] = "西瘟疫之地"
L["Westfall"] = "西部荒野"
L["Wetlands"] = "湿地"
L["Widget"] = "窗口小部件"
L["will be automatically accepted in 10 seconds unless cancelled."] = "将在10秒内自动接受，除非手动拒绝。"
L["Winter"] = "冬日"
L["Wintergrasp"] = "冬拥湖"
L["Winterspring"] = "冬泉谷"
L["World of Warcraft"] = "魔兽世界"
L["Wrath of the Lich King"] = "巫妖王之怒"
L["Wyrmrest Temple"] = "龙眠神殿"
L["X Offset"] = "横向偏斜值"
L["Y Offset"] = "纵向偏斜值"
L["YOU"] = "你"
L["You cannot do that in combat."] = "你无法在战斗中进行该项操作。"
L["You do not own this pet.  Only owned pets can be searched."] = "你还未拥有这只宠物。你只能搜索你拥有的宠物。"
L["You have"] = "你有"
L["You need a battle pet team."] = "你需要一个宠物对战队伍。"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "你需要进行重载插件后才能使部分设置生效。|n|n你无需立即点击重载插件按钮，但是你完成设置并希望其生效时，必须点击它。"
L["Your UI needs to be reloaded."] = "你的插件需要重新载入。"
L["Zandalar"] = "赞达拉"
L["Zandalari Trolls"] = "赞达拉巨魔"
L["Zangarmarsh"] = "赞加沼泽"
L["Zones"] = "区域"
L["Zul'Aman"] = "祖阿曼"
L["Zuldazar"] = "祖达萨"
L["Zul'Drak"] = "祖达克"
L["Zul'Farrak"] = "祖尔法拉克"
L["Zul'Gurub"] = "祖尔格拉布"
L["Zygor addon not found."] = "你尚未安装Zygor插件。"

end

-- zhTW: Traditional Chinese
if GameLocale == "zhTW" then
L["A Deal with Death"] = "死亡的交易"
L["A Falling Star"] = "殞落之星"
L["A Found Memento"] = "尋獲的記憶碎片"
L["A friend request from"] = "你有一個好友申請，來自"
L["A New Life for Undeath"] = "不死族的新生"
L["A Taste of Iron"] = "鋼鐵的滋味"
L["Accept available quests automatically"] = "自動接受可用的任務"
L["Accept resurrection"] = "自動接受復活"
L["Accept summon"] = "自動接受召喚"
L["Account achievements are being shared."] = "帳號成就已經共享。"
L["Account achievements are hidden."] = "帳號成就已隱藏。"
L["Addon"] = "插件"
L["Adventure"] = "探險"
L["Ahn'kahet (Old Kingdom)"] = "安卡罕特：古王國"
L["All 3 battle pet slots need to be unlocked."] = "所有的三個戰寵欄位需要解鎖。"
L["Allied Races"] = "同盟種族"
L["An Unexpected Reunion"] = "一次意想不到的重逢"
L["Anchor"] = "定位點"
L["And Justice for Thrall"] = "索爾的正義"
L["Anduin's Theme"] = "安度因主題"
L["Antoran Wastes (Argus)"] = "安托洛斯荒原（阿古斯）"
L["Antorus Ending"] = "安托洛斯終章"
L["Antorus, the Burning Throne"] = "安托洛斯．燃燒王座"
L["Arathi Highlands"] = "阿拉希高地"
L["Arcway"] = "幽暗地道"
L["Arenas"] = "競技場"
L["Arrival on Argus"] = "抵達阿古斯"
L["Arrival to Zandalar"] = "抵達贊達拉"
L["Ashenvale"] = "梣谷"
L["Ashran"] = "艾斯蘭"
L["Assault on the Broken Shore"] = "破碎群島的襲擊"
L["Astravar Harbor"] = "艾斯特瓦港"
L["Atal'Dazar"] = "阿塔達薩"
L["ATV"] = "全地形載具"
L["Auchenai Crypts"] = "奧奇奈地穴"
L["Auchindoun"] = "奧齊頓"
L["AutoFollow"] = "自動跟隨"
L["AutoFollow disabled."] = "自動跟隨已停用。"
L["Automate gossip"] = "自動對話"
L["Automate quests"] = "任務自動化"
L["Automation"] = "自動化"
L["Azjol-Nerub"] = "阿茲歐-奈幽"
L["Azshara"] = "艾薩拉"
L["Azshara's Eternal Palace"] = "艾薩拉的永恆宮殿"
L["Azsuna"] = "艾蘇納"
L["Azuremyst Isle"] = "藍謎島"
L["Back to Main Menu"] = "返回"
L["Bad ID"] = "損壞的ID"
L["Badlands"] = "荒蕪之地"
L["Balls"] = "足球"
L["Ban-Lu"] = "班盧"
L["Baradin Hold"] = "巴拉丁堡"
L["Barrens"] = "南貧瘠之地"
L["Bastion of Twilight"] = "暮光堡壘"
L["Battle for Azeroth"] = "決戰艾澤拉斯"
L["Battle for Darkshore"] = "黑海岸之戰"
L["Battle for Gilneas"] = "吉爾尼斯之戰"
L["Battle for Stromgarde"] = "斯通加德之戰"
L["Battle of Angrathar the Wrathgate"] = "安格薩憤怒之門的戰役"
L["Battle of Dazar'alor"] = "達薩亞洛之戰"
L["Battle of Serpent's Heart"] = "毒蛇之心的戰鬥"
L["Battlegrounds"] = "戰場"
L["Bigger is Better (Alliance)"] = "越大越好（聯盟）"
L["Bigger is Better (Horde)"] = "越大越好（部落）"
L["Bikes"] = "機械動力"
L["Black Morass"] = "黑色沼澤"
L["Black Rook Hold"] = "玄鴉堡"
L["Black Temple"] = "黑暗神廟"
L["Blackfathom Deeps"] = "黑澗深淵"
L["Blackrock Caverns"] = "黑石洞穴"
L["Blackrock Depths"] = "黑石深淵"
L["Blackrock Foundry"] = "黑石鑄造廠"
L["Blackrock Mountain"] = "黑石山"
L["Blackrock Spire"] = "黑石塔"
L["Blackwing Descent"] = "黑翼陷窟"
L["Blackwing Lair"] = "黑翼之巢"
L["Blade's Edge Mountains"] = "劍刃山脈"
L["Blasted Lands"] = "詛咒之地"
L["Block duels"] = "拒絕決鬥"
L["Block friend requests"] = "封鎖好友邀請"
L["Block party invites"] = "封鎖隊伍邀請"
L["Block pet battle duels"] = "封鎖寵物對戰"
L["Blocks"] = "封鎖"
L["Bloodmaul Slag Mines"] = "血槌熔渣礦場"
L["Bloodmyst Isle"] = "血謎島"
L["Borean Tundra"] = "北風凍原"
L["Bottom"] = "底部"
L["Broken Isles"] = "破碎群島"
L["Broken Shore"] = "破碎海岸"
L["Buffs"] = "增益"
L["Burning Steppes"] = "燃燒平原"
L["Buyout Only"] = "僅限直購價"
L["Camera distance"] = "鏡頭距離"
L["Cape of Stranglethorn"] = "荊棘谷海角"
L["Cataclysm"] = "浩劫與重生"
L["Cathedral of Eternal Night"] = "永夜聖殿"
L["Caverns of Time"] = "時光之穴"
L["Chain style"] = "邊框樣式"
L["Character"] = "角色"
L["Chat"] = "聊天功能"
L["Chat Frame"] = "聊天視窗"
L["Checkbox labels are Ok."] = "複選框標籤是OK的。"
L["Choose an Enigma pattern"] = "選擇謎之模式"
L["Cinematics"] = "動畫"
L["Class colored frames"] = "框架職業染色"
L["Class icon portraits"] = "頭像顯示職業圖示"
L["Class Trials"] = "職業試煉"
L["click here for new selection"] = "點擊這裡跳轉新選擇"
L["Click to configure the settings for this option."] = "點擊進行額外的選項設置"
L["Click to disable Dominos Encounter for all characters on this realm.  This is required for the player power bar position to be saved correctly.  Your UI will be reloaded."] = "點擊來為此伺服器的所有角色禁用Dominos Encounter。要保存玩家能量條的位置這是必要的。您的用戶界面將被重新載入。"
L["Click to reset the settings on this page."] = "點擊重置此頁面的設置。"
L["Click to return to the main menu."] = "點擊返回到主選單"
L["Coilfang Reservoir"] = "盤牙蓄湖"
L["Color the backdrops based on faction"] = "根據陣營著色邊框"
L["Combat"] = "戰鬥"
L["Combat log cannot be hidden while undocked."] = "戰鬥記錄視窗被分離時無法隱藏。"
L["Combat plates"] = "自動開關姓名板"
L["Completed."] = "已完成。"
L["Configuration Panel"] = "設置面板"
L["Connections for"] = "連結在"
L["Court of Stars"] = "眾星之廷"
L["Credits"] = "有功人員"
L["Crucible of Storms"] = "風暴邪淵"
L["Crystalsong Forest"] = "水晶之歌森林"
L["Culling of Stratholme"] = "斯坦索姆的抉擇"
L["Cursor"] = "鼠標"
L["Cursor Left"] = "鼠標左"
L["Cursor Right"] = "鼠標右"
L["Dalaran"] = "達拉然"
L["Dark Iron Dwarves"] = "黑鐵矮人"
L["Dark Soil scanning activated.  Reload UI to exit."] = "深色土壤掃描啟用，取消需重載插件。"
L["Dark Soil scanning is already activated.  You only need to run this once.  Reload UI to exit."] = "深色土壤掃描已經啟用，你只需要進行一次操作。取消需重載插件。"
L["Darkheart Thicket"] = "暗心灌木林"
L["Darkmoon Faire"] = "暗月馬戲團"
L["Darkness Falls"] = "黑暗殞落"
L["Darkshore"] = "黑海岸"
L["Darnassus"] = "達納蘇斯"
L["Deadmines"] = "死亡礦坑"
L["Deepholm"] = "地深之源"
L["Deepwind Gorge"] = "深風峽谷"
L["Desolace"] = "淒涼之地"
L["Destiny Unfulfilled"] = "戰亂命運"
L["Dire Maul"] = "厄運之槌"
L["Dire Maul: Capital Gardens"] = "厄運之槌：中心花園"
L["Dire Maul: Gordok Commons"] = "厄運之槌：戈多克平民區"
L["Dire Maul: Warpwood Quarter"] = "厄運之槌：杻木廣場"
L["Disable bag automation"] = "停用背包自動開啟"
L["Disable chat fade"] = "停用聊天視窗淡出"
L["Disable loot warnings"] = "停用拾取通報"
L["Disable pet automation"] = "停用寵物自動化"
L["Disable screen effects"] = "停用螢幕特效"
L["Disable screen glow"] = "停用螢幕光暈"
L["Disable sticky chat"] = "停用聊天頻道粘附"
L["Disable sticky editbox"] = "停用黏附輸入框"
L["Dominos Encounter needs to be disabled."] = "Dominos Encounter需要被禁用。"
L["Don't accept daily quests automatically"] = "不要自動接受每日任務"
L["Don't accept weekly quests automatically"] = "不要自動接受每週任務"
L["Draenor"] = "德拉諾"
L["Drag the frame overlay to position the frame."] = "拖曳框架的遮罩以定位此框架。"
L["Drag the frame overlays to position the frames.|n|nTo change the scale of a frame, click it to select it then adjust the scale slider.|n|nThis panel will close automatically if you enter combat."] = "移動面板來定位框架。|n|n如果想要改變框架尺寸，你需選定面板，然後移動滑塊來選擇。|n|n你一旦進入戰鬥，這個框架會自動關閉。"
L["Drag to set the buffs frame scale."] = "拖拉來設置增益框架大小。"
L["Drag to set the cursor X offset."] = "拖拉來設置鼠標水平偏移。"
L["Drag to set the cursor Y offset."] = "拖拉來設置鼠標垂直偏移。"
L["Drag to set the density of weather effects."] = "拖拉來設定天氣效果的密度。"
L["Drag to set the font size of mail text."] = "拖動來設置郵件文字的大小。"
L["Drag to set the font size of quest text."] = "拖動來設置任務文字的大小。"
L["Drag to set the minimap scale.|n|nNote that if you are using the default action bars, rescaling the minimap will also rescale the right action bars at startup so you may want to leave this at 100%."] = "拖動來設定小地圖縮放。|n|n請注意如果您使用的是預設動作列，則重新縮放小地圖也會在啟動時重新縮放右側動作列，因此您可能希望將其保留為100%。"
L["Drag to set the scale of the Leatrix Plus panel."] = "拖動來設置Leatrix Plus面板的縮放大小。"
L["Drag to set the scale of the selected frame."] = "拖動來設置所選框架的縮放大小。"
L["Drag to set the size of the bottom border."] = "拖動來設置底部邊框的大小。"
L["Drag to set the size of the left border."] = "拖動來設置左側邊框的大小。"
L["Drag to set the size of the right border."] = "拖動來設置右側邊框的大小。"
L["Drag to set the size of the top border."] = "拖動來設置頂部邊框的大小。"
L["Drag to set the tooltip scale."] = "拖動來設置工具提示的縮放大小。"
L["Drag to set the transparency of the borders."] = "拖動來設置邊框的透明度。"
L["Drag to set the transparency of the Leatrix Plus panel."] = "拖動來設置Leatrix Plus面板的透明度。"
L["Dragon Soul"] = "巨龍之魂"
L["Dragonblight"] = "龍骨荒野"
L["Drak'Tharon Keep"] = "德拉克薩隆要塞"
L["Dread Wastes"] = "悚然荒野"
L["Drustvar"] = "祖斯特瓦"
L["Dun Morogh"] = "丹莫洛"
L["Dungeon"] = "地城"
L["Dungeons"] = "地城"
L["Dup ID"] = "重複的ID"
L["durability"] = "耐久度"
L["Durability"] = "耐久度"
L["Durotar"] = "杜洛塔"
L["Duskwood"] = "暮色森林"
L["Dustwallow Marsh"] = "塵泥沼澤"
L["Eastern"] = "東部王國"
L["Eastern Kingdoms"] = "東部王國"
L["Eastern Plaguelands"] = "東瘟疫之地"
L["ELITE"] = "精英"
L["Elwynn Forest"] = "艾爾文森林"
L["Embassies"] = "特使"
L["Embers of War"] = "戰火餘燼"
L["Emerald Nightmare"] = "翡翠夢魘"
L["Enable hotkey"] = "啟用熱鍵"
L["End Time"] = "終焉之刻"
L["Enhance dressup"] = "增強試衣間"
L["Enhance minimap"] = "增強小地圖"
L["Enhance tooltip"] = "增強工具提示"
L["Enhancements"] = "增強功能"
L["Enigma"] = "謎"
L["Enter the spell IDs for the cooldown icons that you want to see.|n|nIf a cooldown icon normally appears under the pet frame, check the pet checkbox.|n|nCooldown icons are saved to your class and specialisation."] = "輸入你想要看見冷卻圖標的法術ID。|n|n如果冷卻圖標通常出現在寵物框架下，勾選寵物複選框。|n|n冷卻圖標依據你的職業與專精儲存。"
L["enter zone or track name"] = "輸入區域或曲目名稱"
L["Epilogue (Alliance)"] = "結局（聯盟）"
L["Epilogue (Horde)"] = "結局（部落）"
L["Error messages will be hidden"] = "錯誤訊息將會隱藏"
L["Error messages will be shown"] = "錯誤訊息將會顯示"
L["Error retrieving quest."] = "檢索任務時出錯。"
L["Establish Your Garrison (Alliance)"] = "建立你的要塞（聯盟）"
L["Establish Your Garrison (Horde)"] = "建立你的要塞（部落）"
L["Eternal Palace"] = "永恆宮殿"
L["Events"] = "事件"
L["Everbloom"] = "永茂林"
L["Evermoon Terrace"] = "永月露臺"
L["Eversong Woods"] = "永歌森林"
L["Extras"] = "其他"
L["Eye of Azshara"] = "艾薩拉之眼"
L["Eye of Eternity"] = "永恆之眼"
L["Falanaar"] = "法拉納爾"
L["Fall of Deathwing"] = "死亡之翼的殞落"
L["Fall of the Lich King"] = "巫妖王之殞"
L["False"] = "虛假"
L["Faster auto loot"] = "加速自動拾取"
L["Faster movie skip"] = "快速動畫跳過"
L["Fate of the Horde"] = "部落的命運"
L["Features"] = "功能"
L["Felsoul Hold"] = "魔魂堡"
L["Felwood"] = "費伍德森林"
L["Feralas"] = "菲拉斯"
L["Find Item"] = "搜尋物品"
L["Firelands"] = "火源之界"
L["Fizzle"] = "嘶嘶聲"
L["Forge of Souls"] = "眾魂熔爐"
L["Frames"] = "框架相關"
L["Freehold"] = "自由港"
L["Frostfire Ridge"] = "霜火峰"
L["Game Options"] = "游戲設置"
L["Gate of the Setting Sun"] = "落陽關"
L["General"] = "一般"
L["Ghost"] = "靈魂狀態框架"
L["Ghostlands"] = "鬼魂之地"
L["Gnomeregan"] = "諾姆瑞根"
L["Gold Only"] = "僅輸入金幣"
L["Gorgrond"] = "格古隆德"
L["Graphics and Sound"] = "圖形和音效"
L["Grim Batol"] = "格瑞姆巴托"
L["Grimrail Depot"] = "恐軌車站"
L["Grizzly Hills"] = "灰白之丘"
L["Groups"] = "隊伍"
L["Gruul's Lair"] = "戈魯爾之巢"
L["Gul'dan Ascendant"] = "古爾丹支配"
L["Gul'dan's Plan"] = "古爾丹的計謀"
L["Gundrak"] = "剛德拉克"
L["Halls of Lightning"] = "雷光大廳"
L["Halls of Origination"] = "起源大廳"
L["Halls of Reflection"] = "倒影大廳"
L["Halls of Stone"] = "石之大廳"
L["Halls of Valor"] = "英靈殿"
L["Harbingers Gul'dan"] = "先知古爾丹"
L["Harbingers Illidan"] = "先知伊利丹"
L["Harbingers Khadgar"] = "先知卡德加"
L["Havenswood"] = "寧靜森林"
L["Heart of Fear"] = "恐懼之心"
L["Hellfire Citadel"] = "地獄火堡壘"
L["Hellfire Peninsula"] = "地獄火半島"
L["Hellfire Ramparts"] = "地獄火壁壘"
L["Hellscream's Downfall (Alliance)"] = "地獄吼的垮台（聯盟）"
L["Hellscream's Downfall (Horde)"] = "地獄吼的垮台（部落）"
L["Help"] = "幫助"
L["Hide alerts"] = "隱藏訊息提示"
L["Hide bodyguard gossip"] = "隱藏保鏢對話"
L["Hide boss banner"] = "隱藏BOSS橫幅"
L["Hide chat buttons"] = "隱藏聊天視窗按鈕"
L["Hide clean-up buttons"] = "隱藏背包整理按鈕"
L["Hide cooldown duration numbers (if enabled)"] = "隱藏冷卻持續時間數字(如果啟用)"
L["Hide error messages"] = "隱藏錯誤訊息"
L["Hide gryphons"] = "隱藏動作條獅鷲"
L["Hide level-up display"] = "隱藏升級提示"
L["Hide order hall bar"] = "隱藏職業大廳條"
L["Hide portrait numbers"] = "隱藏頭像數字"
L["Hide social button"] = "隱藏社交按鈕"
L["Hide stance bar"] = "隱藏姿態條"
L["Hide talking frame"] = "隱藏對話框架"
L["Hide the clock"] = "隱藏時鐘"
L["Hide the combat log"] = "隱藏戰鬥記錄視窗"
L["Hide the zone text bar"] = "隱藏區域文字列"
L["Hide the zoom buttons"] = "隱藏縮放按紐"
L["Hide tooltips for world units during combat"] = "戰鬥中隱藏視窗"
L["Hide zone text"] = "隱藏區域文字"
L["High"] = "高"
L["Highmaul"] = "天槌"
L["Highmountain"] = "高嶺"
L["Highmountain Tauren"] = "高嶺牛頭人"
L["Hillsbrad Foothills"] = "希爾斯布萊德丘陵"
L["Hinterlands"] = "辛特蘭"
L["Home"] = "首頁"
L["Hour of Twilight"] = "暮光之時"
L["Howling Fjord"] = "凜風峽灣"
L["Hyjal Summit"] = "海加爾山之戰"
L["Icecrown"] = "寒冰皇冠"
L["Icecrown Citadel"] = "冰冠城寨"
L["If checked, a button will be added to the character sheet which will show your equipped item durability when you hover the pointer over it.|n|nIn addition, an overall percentage will be shown in the chat frame when you die."] = "勾選後，一個按鈕會顯示在角色框架，其鼠標提示訊息會顯示身上的裝備耐久度。|n|n當你死後，你的整體耐久度也會顯示在聊天框架。"
L["If checked, a group invite will be sent to anyone who whispers you with a set keyword as long as you are ungrouped, group leader or raid assistant."] = "勾選後，只要你不在隊伍、或是隊伍領隊或是團隊助理，只要密語你設定的關鍵字的任何人，將被發送組隊邀請。"
L["If checked, a group invite will be sent to anyone who whispers you with the keyword INV.|n|nYou need to be either ungrouped or party leader in your own group for this to work."] = "勾選後，將會向所有密語你關鍵字INV的人發送組隊邀請。|n|n你需要尚未組隊或是你是自己隊伍的隊長才有作用。"
L["If checked, a master volume slider will be shown on the character sheet.|n|nThe volume slider can be placed in either of two locations on the character sheet.  To toggle between them, hold the shift key down and right-click the slider."] = "勾選後，一個全局音量控制桿會顯示在角色訊息視窗。|n|n這個音量控制可以在兩個位置之間切換，你可以按住SHIFT+鼠標右鍵進行切換。"
L["If checked, a minimap button will be available.|n|nClick - Toggle options panel.|n|nSHIFT/Left-click - Toggle music.|n|nSHIFT/Right-click - Toggle stopwatch.|n|nCTRL/Left-click - Toggle minimap target tracking.|n|nCTRL/Right-click - Toggle errors (if enabled).|n|nCTRL/SHIFT/Left-click - Toggle Zygor (if installed).|n|nCTRL/SHIFT/Right-click - Toggle windowed mode."] = "勾選後，小地圖按鈕將可使用。|n|n點擊 - 切換選項面板。|n|nSHIFT/左鍵點擊 - 切換音樂。|n|nSHIFT/右鍵點擊 - 切換碼表。|n|nCTRL/左鍵點擊 - 切換小地圖目標追蹤。|n|nCTRL/右鍵點擊 - 切換錯誤顯示(如果已啟用)。|n|nCTRL/SHIFT/左鍵點擊 - 切換Zygor(如果已安裝)。|n|nCTRL/SHIFT/右鍵點擊 - 切換視窗模式。"
L["If checked, alert frames will not be shown."] = "勾選後，警告框架將不會顯示。"
L["If checked, all grey items in your bags will be sold automatically when you visit a merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "勾選後，當你訪問商販時將自動出售背包中的垃圾。|n|n當你訪問時按住Shift鍵，可以暫時忽略該功能。"
L["If checked, available quests will be accepted automatically."] = "勾選後，可用的任務將被自動接受。"
L["If checked, backdrops will be tinted blue (friendly) or red (hostile)."] = "勾選後，訊息視窗的邊框會更改為藍色（友方）或者紅色（敵方）。"
L["If checked, Ban-Lu will no longer talk to you."] = "勾選後，班盧不會再跟你對話。"
L["If checked, battle pets which are automatically summoned will be dismissed within a few seconds.|n|nThis includes dragging a pet onto the first team slot in the pet journal and entering a battle pet team save command.|n|nNote that pets which are automatically summoned during combat will be dismissed when combat ends."] = "勾選後，自動召喚的戰寵將在幾秒內被解散。|n|n這包含了拖曳寵物到寵物日誌第一個隊伍空格以及輸入一個戰寵隊伍儲存指令。|n|n注意在戰鬥中自動召喚的寵物會在戰鬥結束後被解散。"
L["If checked, battle shouts heard when casting specific spells will be muted."] = "勾選後，施放特定法術時聽到的戰鬥怒吼將被靜音。"
L["If checked, BattleTag and Real ID friend requests will be automatically declined.|n|nEnabling this option will automatically decline any pending requests."] = "勾選後，戰網好友邀請會自動拒絕。|n|n啟用後，當前待處理的邀請會自動拒絕。"
L["If checked, chat frame buttons will be hidden.|n|nClicking chat tabs will automatically show the latest messages.|n|nUse the mouse wheel to scroll through the chat history.  Hold down SHIFT for page jump or CTRL to jump to the top or bottom of the chat history."] = "勾選後，聊天視窗的按鈕會被隱藏。|n|n點擊視窗標簽會自動顯示最新的消息。|n|n使用鼠標滾輪可以查看歷史訊息。按住SHIFT進行訊息頁面跳轉，按住CTRL將滾動至訊息頁首/頁尾。"
L["If checked, chat text will not fade out after a time period."] = "勾選後，聊天訊息不會在一定時間後淡出。"
L["If checked, class coloring will be used in the player frame, target frame and focus frame."] = "勾選後，職業著色將使用在玩家框架、目標框架以及焦點目標框架上。"
L["If checked, class icons will be shown in the portrait frames."] = "勾選後，頭像框架將會顯示職業圖示。"
L["If checked, completed quests will be turned-in automatically."] = "勾選後，已經完成的任務將會自動交付。"
L["If checked, confirmations will no longer appear when you choose a loot roll option or attempt to sell or mail a tradable item."] = "勾選後，當你選擇一個擲骰選項或是試圖出售或郵寄可交易物品將不再確認。"
L["If checked, converting a party group to a raid group will succeed even if there are low level characters in the group.|n|nEveryone in the group needs to have Leatrix Plus installed with this option enabled."] = "勾選後，即使有低等級角色在隊伍中也可以成功轉成團隊。|n|n隊伍中的每個人都需要安裝Leatrix Plus並啟用此選項。"
L["If checked, cooldown duration numbers will not be shown over the cooldowns.|n|nIf unchecked, cooldown duration numbers will be shown over the cooldowns if they are enabled in the game options panel ('ActionBars' menu)."] = "勾選後，冷卻持續時間數字將不顯示在冷卻上。|n|n取消勾選後，冷卻持續時間數字將會顯示在冷卻上如果已在遊戲選項面板中啟用('動作條'選單)。"
L["If checked, daily quests will not be accepted automatically."] = "勾選後，每日任務將不會自動接受。"
L["If checked, damage and healing numbers in the player and pet portrait frames will be hidden."] = "勾選後，在玩家頭像和寵物頭像上的傷害及治療數字不再顯示。"
L["If checked, dragging the General chat tab while the chat frame is locked will expand the chat frame upwards.|n|nIf the chat frame is unlocked, dragging the General chat tab will move the chat frame."] = "勾選後，對鎖定的聊天視窗進行拖動，會使其豎直拉伸。|n|n對已解鎖的聊天視窗進行拖動，會使其移動。"
L["If checked, duel requests will be blocked unless the player requesting the duel is in your friends list or guild."] = "勾選後，對於非好友與公會成員的決鬥請求會被封鎖。"
L["If checked, emote sounds will be silenced while your character is:|n|n- resting|n- in a pet battle|n- at the Halfhill Market|n- at the Grim Guzzler|n|nEmote sounds will be enabled when none of the above apply."] = "勾選後，表情音效將被靜音當你的角色處於：|n|n- 休息區|n- 寵物戰鬥中|n- 半丘市集|n- 黑鐵酒吧|n|n當不處於上述區域時表情音效將會啟用。"
L["If checked, enemy nameplates will be shown during combat and hidden when combat ends."] = "勾選後，敵對姓名板會在戰鬥中自動開啟，離開戰鬥後關閉。"
L["If checked, gear toggle buttons will be added to the dressup frame and model positioning controls will be removed."] = "勾選後，裝備切換按鈕將添加到試衣間框架，並且模型定位控件將被刪除。"
L["If checked, group invites will only be sent to friends and guild members.|n|nIf unchecked, group invites will be sent to everyone."] = "勾選後，組隊邀請將只發送到好友以及公會成員。|n|n如未勾選，隊伍邀請將會發送到每個人。"
L["If checked, guild ranks will be shown for players in your guild."] = "勾選後，顯示公會會階。"
L["If checked, most error messages (such as 'Not enough rage') will not be shown.  Some important errors are excluded.|n|nIf you have the minimap button enabled, you can hold down the control key and right-click it to toggle error messages without affecting this setting."] = "勾選後，大部分錯誤訊息將不顯示(像是'沒有足夠的怒氣')。部分重要錯誤將排除在外。|n|n如果你有啟用小地圖按鈕，你可以按下CTRL+右鍵來切換錯誤訊息的顯示而不管此設置。"
L["If checked, most of the bike mount sounds will be muted."] = "勾選後，大多數的機械坐騎音效將被靜音。"
L["If checked, party invitations from friends or guild members will be automatically accepted unless you are queued in Dungeon Finder."] = "勾選後，如果你不在地下城佇列中，你的好友或公會成員發送的組隊邀請會被自動接受。"
L["If checked, party invitations will be blocked unless the player inviting you is in your friends list or guild."] = "勾選後，對於非好友與公會成員的組隊邀請會被封鎖。"
L["If checked, party sync requests from friends or guild members will be automatically accepted."] = "勾選後，來自好友或公會成員的隊伍同步請求將被自動接受。"
L["If checked, pet battle duel requests will be blocked unless the player requesting the duel is in your friends list or guild."] = "勾選後，對於非好友與公會成員的寵物對戰請求會被封鎖。"
L["If checked, profession filter settings will be saved for the remainder of your login session."] = "勾選後，在你登入階段專業技能過濾設置將會保存剩餘的部分。"
L["If checked, quests will be selected, accepted and turned-in automatically.|n|nQuests which have a gold, currency or crafting reagent requirement will not be turned-in automatically.|n|nYou can hold the shift key down when you talk to a quest giver to override this setting."] = "勾選後，任務將會自動選擇、接受、與回覆。|n|n那些需求金錢、貨幣或製造材料的任務不會自動回覆。|n|n您可以在與任務交付者對話時按下Shift鍵以無視此設置。"
L["If checked, raid chat and instance chat will both be colored blue (to match the default party chat color)."] = "勾選後，團隊和副本聊天訊息會改為藍色（與小隊一致）。"
L["If checked, repair costs will be taken from guild funds for characters that are guilded and have permission to repair."] = "勾選後，有加入公會並有權限修理的角色，修理花費會從公會資金支出。"
L["If checked, requests initiated by your party leader to join the Dungeon Finder queue will be automatically accepted if the party leader is in your friends list or guild.|n|nThis option requires that you have selected a role for your character in the Dungeon Finder window."] = "勾選後，如果小隊隊長是你的好友或公會成員，其地城搜尋器的加入請求會被自動接受。|n|n這個選項需要你在地城搜尋器中選擇一個職責。"
L["If checked, resurrection requests will be accepted automatically as long as the player resurrecting you is not in combat.|n|nResurrection requests from a Brazier of Awakening or a Failure Detection Pylon will not be accepted automatically."] = "勾選後，只要復活你的玩家不在戰鬥中，復活請求將被自動接受。|n|n覺醒火盆或滅團偵測塔的復活請求不會自動接受。"
L["If checked, spell IDs will be shown in buff icon tooltips located in the buff frame and under the target frame."] = "勾選後，位於增益框架與目標框架之下的增益圖標提示會顯示法術ID。"
L["If checked, sticky chat will be disabled.|n|nNote that this does not apply to temporary chat windows."] = "勾選後，會停用聊天頻道的粘附。|n|n此選項不會影響臨時視窗的對話。"
L["If checked, summon requests will be accepted automatically unless you are in combat."] = "勾選後，當你不處於戰鬥狀態時會自動接受召喚。"
L["If checked, the addon list (accessible from the game menu) will show character based addons by default."] = "勾選後，插件列表（游戲選單處）會顯示預設的對角色生效的插件。"
L["If checked, the amount of time it takes to auto loot creatures will be significantly reduced."] = "勾選後，自動拾取所需的時間將大幅減少。"
L["If checked, the backpack clean-up button and the bank frame clean-up button will not be shown."] = "勾選後，背包及銀行的整理按鈕不再顯示。"
L["If checked, the boss banner will not be shown.|n|nThe boss banner appears when a boss is defeated.  It shows the name of the boss and the loot that was distributed."] = "勾選後，BOSS的橫幅訊息不再顯示。|n|n該訊息通常在BOSS被擊敗後顯示。它顯示BOSS的名字以及掉落。"
L["If checked, the button to toggle the raid container frame will be shown just above the raid management frame (left side of the screen) instead of in the raid management frame itself.|n|nThis allows you to toggle the raid container frame without needing to open the raid management frame."] = "勾選後，打開團隊訊息的按鈕會顯示在左側團隊管理框架的上方，而不是在其內部。|n|n此選項讓你無需打開團隊管理框架，就可以切換團隊框架。"
L["If checked, the clock will be hidden."] = "勾選後，時鐘將會隱藏。"
L["If checked, the combat log will be hidden.|n|nThe combat log must be docked in order for this option to work.|n|nIf the combat log is undocked, you can dock it by dragging the tab (and reloading your UI) or by resetting the chat windows (from the chat menu)."] = "勾選後，戰鬥記錄會被隱藏。|n|n戰鬥記錄視窗必須未被分離時才能生效。|n|n如果戰鬥記錄視窗被分離了，你可以拖動其合併至主視窗（然後重載插件），或者在聊天設置中重置設置。"
L["If checked, the 'Display only character achievements to others' setting in the game options panel ('Social' menu) will be permanently checked and locked."] = "勾選後，“對他人只顯示角色成就”的選項（介面-社交）會被永久勾選並鎖定。"
L["If checked, the editbox will be moved to the top of the chat frame."] = "勾選後輸入框會被移動至聊天視窗上方。"
L["If checked, the editbox will close when it loses focus."] = "勾選後，失去焦點時，輸入框將關閉。"
L["If checked, the Foot Ball sounds will be muted."] = "勾選後，足球音效將被靜音。"
L["If checked, the gossip window will not be shown when you talk to an active garrison bodyguard.|n|nYou can hold the shift key down when you talk to a bodyguard to override this setting."] = "勾選後，你的保鏢對話時不再出現選項。|n|n對話時按住Shift鍵，可以暫時忽略該項設置。"
L["If checked, the grey screen of death and the netherworld effect will be disabled."] = "勾選後，死亡後的灰色螢幕以及靈魂世界特效將會停用。"
L["If checked, the interface button sound, the chat frame tab click sound and the game menu toggle sound will be muted."] = "勾選後，界面按鈕聲音，聊天框標籤點擊聲音和遊戲選單切換聲音將被靜音。"
L["If checked, the level-up display will not be shown.|n|nThe level-up display shows encounter objectives, level-ups, pet battle rewards, etc."] = "勾選後，升級提示不再顯示。|n|n升級提示功能包括副本目標、升級、小寵物獎勵等等。"
L["If checked, the main bar gryphons will not be shown."] = "勾選後，動作條兩邊的獅鷲不再顯示。"
L["If checked, the mechanical guild vault idle sound will be muted."] = "勾選後，機械公會金庫的閒置聲音將被靜音。"
L["If checked, the netherworld effect will be disabled."] = "勾選後，幽冥世界的效果將被停用。"
L["If checked, the order hall command bar will not be shown."] = "勾選後，職業大廳控制條將不顯示。"
L["If checked, the player frame background will be shown in class color."] = "勾選後，玩家框架的背景會顯示職業顏色。"
L["If checked, the ready check sound will be muted."] = "勾選後，準備確認的音效將被靜音。"
L["If checked, the screen glow will be disabled.|n|nEnabling this option will also disable the drunken haze effect."] = "勾選後，螢幕光暈將停用。|n|n啟用此選項同時也停用醉酒霧霾效果。"
L["If checked, the social button and quick-join notification will be hidden."] = "勾選後，社交按鈕與快速加入提醒將會隱藏。"
L["If checked, the spell fizzle sounds will be muted."] = "勾選後，法術的嘶嘶音效將被靜音。"
L["If checked, the stance bar will not be shown."] = "勾選後，姿態條不再顯示。"
L["If checked, the talking frame will not be shown.|n|nThe talking frame normally appears in the lower portion of the screen when certain NPCs communicate with you."] = "勾選後，對話面板不再顯示。|n|n當NPC與你交流時，該框架通常出現在界面下方。"
L["If checked, the target frame background and focus frame background will be shown in class color."] = "勾選後，目標及焦點框架的背景會顯示職業顏色。"
L["If checked, the tooltip will be color coded and you will be able to modify the tooltip layout and scale."] = "勾選後，提示訊息會被著色，你可以設置他的佈局和大小尺寸。"
L["If checked, the worgen sniffing sounds will be muted."] = "勾選後，狼人嗅聞的音效會被靜音。"
L["If checked, the zone text bar will be hidden.  The tracking button tooltip will show zone information."] = "勾選後，區域文字列將隱藏。追蹤按鈕提示將顯示區域資訊。"
L["If checked, the zoom buttons will be hidden.  You can use the mousewheel to zoom regardless of this setting."] = "勾選後，縮放按鈕將隱藏。無論此設置如何，您都可以使用滑鼠滾輪進行縮放。"
L["If checked, tooltips for world units will be hidden during combat.|n|nYou can hold the shift key down to override this setting."] = "勾選後，目標的訊息視窗在戰鬥中會被隱藏。|n|n你可以按住SHIFT鍵暫時忽略這個設置。"
L["If checked, train sounds will be muted."] = "勾選後，火車音效將被靜音。"
L["If checked, traveling merchant greetings and farewells will be muted.|n|nThis applies to Traveler's Tundra Mammoth, Grand Expedition Yak and Mighty Caravan Brutosaur."] = "勾選後，旅行商的的問候和告別將被靜音。|n|n這適用於旅者的凍原長毛象、大型遠征犛牛以及巨型商隊雷龍。"
L["If checked, unit targets will be shown."] = "勾選後，目標的目標會顯示在訊息視窗上。"
L["If checked, weekly quests will not be accepted automatically."] = "勾選後，每週任務將不會自動接受。"
L["If checked, Wowhead links will be shown in the world map frame and the achievements frame."] = "勾選後，Wowhead連結將會顯示在世界地圖視窗與成就視窗。"
L["If checked, Xiwyllag ATV will be muted."] = "勾選後，賽威拉格全地形載具將會靜音。"
L["If checked, you can hold down the alt key while opening a gossip window to automatically select a single gossip option."] = "勾選後，你可以在開啟對話視窗時按下Alt鍵來自動選擇單個的對話選項。"
L["If checked, you can hold down the control key and click a chat tab to view recent chat in a copy-friendly window."] = "勾選後，你可以在點擊聊天標籤時按下Ctrl鍵，在易於複製的視窗中查看最近的聊天。"
L["If checked, you can open Leatrix Plus by pressing CTRL/Z."] = "勾選後，你可以透過按下CTRL+Z來開啟Leatrix Plus。"
L["If checked, you can press the arrow keys to move the insertion point left and right in the chat frame.|n|nIf unchecked, the arrow keys will use the default keybind setting."] = "勾選後，你可以使用方向鍵移動聊天框中的輸入點。|n|n如果未被勾選，方向鍵將保持它所綁定的按鍵功能。"
L["If checked, you will be able to cancel cinematics without being prompted for confirmation."] = "勾選後，你可以取消動畫而不經確認。"
L["If checked, you will be able to change the font size of quest text.|n|nEnabling this option will also change the text size of other frames which inherit the same font (such as the Dungeon Finder frame)."] = "勾選後，你可以更改任務訊息文字的字體大小。|n|n啟用這個選項也會影響使用同一文字模版的框架（例如地城搜尋器）。"
L["If checked, you will be able to change the font size of standard mail text.|n|nThis does not affect mail created using templates (such as auction house invoices)."] = "勾選後，你可以更改郵件文字的字體大小。|n|n這個選項不會影響使用系統範本的郵件（例如拍賣行的收據訊息）。"
L["If checked, you will be able to change the position and scale of the buffs frame."] = "勾選後，您將可以更動增益框架的位置與大小。"
L["If checked, you will be able to change the position and scale of the player alternative power bar."] = "勾選後，您將可以變更玩家替代能量條的位置與大小。"
L["If checked, you will be able to change the position and scale of the player frame, target frame, ghost frame and timer bar."] = "勾選後，您將可以改變玩家框架、目標框架、靈魂框架以及計時條的位置與大小。"
L["If checked, you will be able to change the position and scale of the widget frame.|n|nThe widget frame is commonly used for showing PvP scores and tracking objectives."] = "勾選後，您將可以改變組件框架的位置與大小。|n|n此組件框架通常用於顯示PvP分數和追蹤任務目標。"
L["If checked, you will be able to customise the minimap."] = "勾選後，您將可以自定義小地圖。"
L["If checked, you will be able to drag the chat frame to the edge of the screen."] = "勾選後，你可以把聊天視窗拖動到屏幕邊緣。"
L["If checked, you will be able to mute a selection of game sounds."] = "勾選後，您將能夠將選擇的遊戲音效靜音。"
L["If checked, you will be able to place up to five beneficial cooldown icons above the target frame."] = "勾選後，你可以在目標框架上放置最多5個有用的冷卻圖標。"
L["If checked, you will be able to reposition the tooltip."] = "勾選後，您可以重新定位工具提示。"
L["If checked, you will be able to save your current battle pet team (including abilities) to a single command.|n|nA button will be added to the Pet Journal.  Clicking the button will toggle showing the assignment command for your current team.  Pressing CTRL/C will copy the command to memory.|n|nYou can then paste the command (with CTRL/V) into the chat window or a macro to instantly assign your team."] = "勾選後，你可以利用一個單獨的指令儲存你當前戰寵的隊伍(包含技能)。|n|n寵物日誌將會加入新的按鈕。點擊該按鈕將切換顯示您當前隊伍的分配指令。按下Ctrl+C就會複製此指令到記憶體中。|n|n你可以貼上此指令(用Ctrl+V)到聊天視窗或巨集中以立即指派你的隊伍。"
L["If checked, you will be able to set the density of weather effects."] = "勾選後，您可以設定天氣效果的密度。"
L["If checked, you will be able to show a rare, elite or rare elite chain around the player frame."] = "勾選後，會在玩家框架顯示稀有、精英或者稀有精英的邊框。"
L["If checked, you will be able to show customisable borders around the edges of the screen.|n|nThe borders are placed on top of the game world but under the UI so you can place UI elements over them."] = "勾選後，您將能夠在螢幕邊緣周圍顯示可自定義的邊框。|n|n邊框位於遊戲世界的頂層，但位於UI之下，因此您可以將UI元素放置在其上方。"
L["If checked, you will be able to zoom out to a greater distance."] = "勾選後，你可以將鏡頭拉遠到更遠的距離。"
L["If checked, you will need to hold the shift key down for quests to be automated.|n|nIf unchecked, holding shift will prevent quests from being automated."] = "勾選後，則需要按住Shift鍵才能自動執行任務。|n|n如果未選中，按住Shift鍵將防止任務自動執行。"
L["If checked, you will release automatically after you die in Ashran, Tol Barad (PvP), Wintergrasp or any battleground.|n|nYou will not release automatically if you have the ability to self-resurrect (soulstone, reincarnation, etc)."] = "勾選後，如果你死在阿斯蘭、托巴拉德、冬握湖或任何戰場，將會自動釋放靈魂。n|n如果你有辦法自我復活(靈魂石、復生等)，則不會自動釋放。"
L["If checked, your bags will not be opened or closed automatically when you interact with a merchant, bank or mailbox."] = "勾選後，當你打開商店、銀行或者郵箱時，背包不會自動開啟或者關閉。"
L["If checked, your chat history will increase to 4096 lines.  If unchecked, the default will be used (128 lines).|n|nEnabling this option may prevent some chat text from showing during login."] = "勾選後，你的聊天歷史記錄會增漲至4096行。如果未被勾選，會保持在預設的128行。|n|n啟用這個設置可能會在登錄時會隱藏一些聊天訊息。"
L["If checked, your gear will be repaired automatically when you visit a suitable merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "勾選後，當你訪問適用的商店時，裝備將自動修理。|n|n當你開啟商店時可以按下Shift鍵以無視此設置。"
L["If checked, zone text will not be shown (eg. 'Ironforge')."] = "勾選後，區域文字不再顯示。"
L["Increase chat history"] = "增加聊天歷史記錄"
L["Interface"] = "界面設置"
L["Into the Portal"] = "進入傳送門"
L["Invalid battle pet team parameter."] = "無效的戰寵隊伍參數。"
L["Invalid console variable."] = "無效控制台變量。"
L["Invalid parameter."] = "無效參數"
L["Invalid quest ID."] = "無效任務ID。"
L["Invalid sound ID"] = "無效聲音ID"
L["Invalid taint level."] = "無效的汙染等級。"
L["Invalid target."] = "無效的目標。"
L["Invite from whispers"] = "密語邀請"
L["Iron Docks"] = "鋼鐵碼頭"
L["Island Expeditions"] = "島嶼探險"
L["Isle of Conquest"] = "征服之島"
L["Isle of Quel'Danas"] = "奎爾達納斯之島"
L["Isle of Thunder"] = "雷王島"
L["Jade Forest"] = "翠玉林"
L["Jade Forest Crash"] = "墜毀翠玉林"
L["Jaina Joins the Battle"] = "珍娜加入戰鬥"
L["Jaina Returns to Kul Tiras"] = "珍娜返回庫爾提拉斯"
L["Jaina's Nightmare"] = "珍娜的夢魘"
L["Jaina's Siege"] = "珍娜的進攻"
L["Jaina's Theme"] = "珍娜主題"
L["Jorundall"] = "尤倫達爾"
L["Kalimdor"] = "卡林多"
L["Karazhan"] = "卡拉贊"
L["Keyword"] = "關鍵字"
L["Kezan"] = "凱贊"
L["Kil'jaeden's Downfall"] = "基爾加丹的垮台"
L["Kings' Rest"] = "諸王之眠"
L["Krasarang Wilds"] = "喀撒朗蠻荒"
L["Krokuun (Argus)"] = "克庫恩（阿古斯）"
L["Kul Tiran Humans"] = "庫爾提拉斯人"
L["Kul Tiras"] = "庫爾提拉斯"
L["Kun-Lai Summit"] = "崑萊峰"
L["Last Stand"] = "背水一戰"
L["Leatrix Plus will not overwrite LeaPlusDB at next logout."] = "Leatrix Plus將會在下次登出時覆寫LeaPlus數據庫。"
L["LEATRIX PLUS: WRONG VERSION INSTALLED!"] = "LEATRIX PLUS: 安裝了錯誤的版本！"
L["Leaving Kezan"] = "離開凱贊"
L["Leaving the Wandering Isle"] = "離開漂流島"
L["Left"] = "左側"
L["Legion"] = "軍臨天下"
L["Lifetime honorable kills"] = "榮譽擊殺總數"
L["Lightforged Draenei"] = "光鑄德萊尼"
L["Lion's Watch"] = "雄獅堡"
L["Loch Modan"] = "洛克莫丹"
L["Lockout sharing"] = "成就共享鎖定"
L["Lost City of the Tol'vir"] = "托維爾的失落之城"
L["Lost Isles"] = "失落群島"
L["Low"] = "低"
L["Lunastre Estate"] = "路納斯特莊園"
L["Mac'Aree (Argus)"] = "麥克艾瑞（阿古斯）"
L["Madness of Deathwing"] = "死亡之翼的狂亂"
L["Maelstrom"] = "大漩渦"
L["Mag'har Orcs"] = "瑪格哈獸人"
L["Magisters' Terrace"] = "博學者殿堂"
L["Magtheridon's Lair"] = "瑪瑟里頓的巢穴"
L["Main Titles"] = "主標題"
L["Manage buffs"] = "管理增益"
L["Manage frames"] = "管理框架面板"
L["Manage power bar"] = "管理能量條"
L["Manage widget"] = "管理組件"
L["Managed by Leatrix Plus"] = "由Leatrix Plus管理"
L["Mana-Tombs"] = "法力墓地"
L["Maraudon"] = "瑪拉頓"
L["Maraudon: Earth Song Falls"] = "瑪拉頓：毒水瀑布"
L["Maraudon: Foulspore Cavern"] = "瑪拉頓：毒菇洞穴"
L["Maraudon: The Wicked Grotto"] = "瑪拉頓：邪惡洞穴"
L["Mardum"] = "馬爾頓"
L["Maw of Souls"] = "靈魂之喉"
L["Max camera zoom"] = "最大鏡頭縮放"
L["Mechagon"] = "機械岡"
L["Mechanics"] = "特性設置"
L["Media"] = "音樂"
L["Medium"] = "中"
L["Memory Usage"] = "記憶體占用"
L["message shown."] = "顯示訊息。"
L["messages shown."] = "顯示訊息。"
L["Missing console variable."] = "缺少控制台變量。"
L["Missing mount name."] = "缺少坐騎名稱。"
L["Missing movie ID."] = "缺少動畫ID。"
L["Missing pet name."] = "缺少寵物名稱。"
L["Missing quest ID."] = "缺少任務ID。"
L["Missing sound file parameter."] = "缺少聲音檔案參數。"
L["Missing sound ID."] = "缺少聲音ID。"
L["Mists of Pandaria"] = "潘達利亞之謎"
L["Mogu'shan Palace"] = "魔古山宮"
L["Mogu'shan Vaults"] = "魔古山寶庫"
L["Molten Core"] = "熔火之心"
L["Moon Guard Stronghold"] = "月之守衛要塞"
L["Moonglade"] = "月光林地"
L["Motherlode"] = "母親大人"
L["Mount Hyjal"] = "海加爾山"
L["Mount not found."] = "坐騎未找到。"
L["Mounts"] = "坐騎"
L["Move editbox to top"] = "輸入框移動至頂部"
L["Movie not playable."] = "動畫不可播放。"
L["Movie number"] = "動畫編號"
L["Movies"] = "動畫"
L["Mulgore"] = "莫高雷"
L["Music"] = "音樂"
L["Music Rolls"] = "音樂曲單"
L["Mute game sounds"] = "靜音遊戲音效"
L["My Very Own Castle (Alliance)"] = "我自己的城堡（聯盟）"
L["My Very Own Castle (Horde)"] = "我自己的城堡（部落）"
L["Mystical"] = "神秘"
L["Nagrand"] = "納葛蘭"
L["Nagrand (Draenor)"] = "納葛蘭 (德拉諾)"
L["Narration"] = "旁白"
L["Naxxramas"] = "納克薩瑪斯"
L["Nazjatar"] = "納沙塔爾"
L["Nazmir"] = "納茲米爾"
L["Neltharion's Lair"] = "奈薩里奧巢穴"
L["Netherstorm"] = "虛空風暴"
L["Nexus"] = "奧核之心"
L["Nightborne"] = "夜裔精靈"
L["Nighthold"] = "暗夜堡"
L["No bad sound IDs found."] = "沒有發現損壞的聲音ID。"
L["No help is available for this page."] = "此頁面沒有幫助訊息。"
L["No items with durability equipped."] = "沒有裝備有耐久度的物品。"
L["No media duplicates found."] = "未找到重複的媒體檔。"
L["No tooltip showing."] = "目前沒有任何提示訊息。"
L["None"] = "無"
L["Northern Barrens"] = "北貧瘠之地"
L["Northern Stranglethorn"] = "北荊棘谷"
L["Northrend"] = "北裂境"
L["Not completed."] = "未完成。"
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Plus."] = "警示！|n您必須完全重新啟動遊戲客戶端才能使用此版本的Leatrix Plus。"
L["Nude"] = "脫光"
L["Ny'alotha"] = "奈奧羅薩"
L["Obsidian Sanctum"] = "黑曜聖所"
L["Oculus"] = "奧核之眼"
L["Off"] = "關閉"
L["Okay, disable Dominos Encounter for me"] = "好的，為我禁用Dominos Encounter。"
L["Okay, disable screen adjust for me"] = "好的，為我停用螢幕調整"
L["Old Hillsbrad Foothills"] = "希爾斯布萊德丘陵舊址"
L["Onyxia's Lair"] = "奧妮克希亞的巢穴"
L["Operation Mechagon"] = "機械岡行動"
L["Orgrimmar"] = "奧格瑪"
L["Outland"] = "外域"
L["Overall"] = "整體"
L["Overlay"] = "覆蓋"
L["Pandaria"] = "潘達利亞"
L["Particle density"] = "粒子密度"
L["Party from friends"] = "好友組隊邀請"
L["Pet"] = "寵物"
L["Pet Battles"] = "寵物戰鬥"
L["Pet not found.  Only owned pets that are currently showing in the journal can be searched."] = "寵物未找到。只有顯示在寵物日誌中已收集的寵物才能搜尋。"
L["Pit of Saron"] = "薩倫之淵"
L["Plants vs Zombies"] = "植物大戰殭屍"
L["Player"] = "玩家框架"
L["Portal"] = "傳送門"
L["Power"] = "能量"
L["Power of the Horde"] = "部落的力量"
L["Press CTRL/C to copy."] = "按下CTRL/C來複製。"
L["Queue from friends"] = "好友佇列申請"
L["Ragefire Chasm"] = "怒焰裂谷"
L["Raid"] = "團隊副本"
L["Raid frame toggle"] = "切換團隊框架"
L["Random"] = "隨機"
L["RARE"] = "稀有"
L["RARE ELITE"] = "稀有精英"
L["Razorfen Downs"] = "剃刀高地"
L["Razorfen Kraul"] = "剃刀沼澤"
L["Ready"] = "準備"
L["Realm Of Torment"] = "折磨的國度"
L["Recent chat window"] = "最近聊天視窗"
L["Reckoning"] = "估算"
L["Redridge Mountains"] = "赤脊山"
L["Reincarnation of Alleria Windrunner"] = "艾蘭里亞‧風行者的再生"
L["Rejection of the Gift"] = "拒絕饋贈"
L["Release in PvP"] = "PvP自動釋放屍體"
L["Reload"] = "重載插件"
L["Remove raid restrictions"] = "移除團隊等級限制"
L["Repair automatically"] = "自動修理裝備"
L["Repair using guild funds if available"] = "修理使用公會資金(如果可用)"
L["Repaired for"] = "修理花費"
L["Reposition the tooltip"] = "重新定位工具提示"
L["Require shift key for quest automation"] = "需要Shift鍵才能完成任務自動化"
L["Requires UI reload."] = "需要重載插件"
L["Requires you to be interacting with Larana Drome.  She can be found at Scribes' Sacellum, Dalaran, Northrend."] = "需要你與拉蕾娜．德羅姆互動，她可以在北裂境的達拉然的雕銘師禮拜堂中找到。"
L["Reset"] = "重置"
L["Resize mail text"] = "重設郵件文字"
L["Resize quest text"] = "重設任務文字"
L["Rested bubbles"] = "休息氣泡訊息"
L["Restrict to friends and guild members"] = "只限於好友與公會成員"
L["result"] = "結果"
L["results"] = "結果"
L["Return to Karazhan"] = "重返卡拉贊"
L["Return to the Black Temple"] = "重返黑暗神廟"
L["Right"] = "右側"
L["Right-click to close"] = "右鍵點擊來關閉"
L["Right-click to close."] = "右鍵點擊來關閉。"
L["right-click to go back"] = "右鍵點擊返回"
L["Rise of Argus"] = "阿古斯的崛起"
L["Rise of Azshara"] = "艾薩拉的崛起"
L["Risking It All"] = "孤注一擲"
L["Ruby Sanctum"] = "晶紅聖所"
L["Ruins of Ahn'Qiraj"] = "安琪拉廢墟"
L["Ruins of Elune'eth"] = "伊露恩斯遺址"
L["Ruins of Gilneas"] = "吉爾尼斯廢墟"
L["Sanctum of Order"] = "秩序聖所"
L["Save profession filters"] = "保存專業技能過濾"
L["Scale"] = "尺寸"
L["Scarlet Halls"] = "血色大廳"
L["Scarlet Monastery"] = "血色修道院"
L["Scholomance"] = "通靈學院"
L["Search"] = "搜尋"
L["Searing Gorge"] = "灼熱峽谷"
L["Seat of the Triumvirate"] = "三傑議會之座"
L["Select the settings that you want to use."] = "選擇你想啟用的設置。"
L["Selection of music tracks"] = "選擇的音樂曲目"
L["Self Markers Allowed"] = "允許自身標記"
L["Self Markers Blocked"] = "阻擋自身標記"
L["Sell junk automatically"] = "自動出售垃圾"
L["SELLING JUNK"] = "出售垃圾"
L["Serpentshrine Cavern"] = "毒蛇神殿洞穴"
L["Set weather density"] = "設定天氣密度"
L["Sethekk Halls"] = "塞司克大廳"
L["Settings"] = "設置"
L["Shaders"] = "陰影"
L["Shado-Pan Monastery"] = "影潘僧院"
L["Shadow Labyrinth"] = "暗影迷宮"
L["Shadowfang Keep"] = "影牙城堡"
L["Shadowmoon Burial Grounds"] = "影月墓地"
L["Shadowmoon Valley"] = "影月谷"
L["Shadowmoon Valley (Draenor)"] = "影月谷 (德拉諾)"
L["Shipyard Construction (Alliance)"] = "船塢建設（聯盟）"
L["Shipyard Construction (Horde)"] = "船塢建設（部落）"
L["Sholazar Basin"] = "休拉薩盆地"
L["Shouts"] = "怒吼"
L["Show borders"] = "顯示邊框"
L["Show character addons"] = "顯示角色插件"
L["Show cooldowns"] = "顯示冷卻"
L["Show durability status"] = "顯示耐久度"
L["Show guild ranks for your guild"] = "顯示會階"
L["Show minimap button"] = "顯示小地圖按鈕"
L["Show pet save button"] = "顯示寵物儲存按鈕"
L["Show player chain"] = "顯示玩家邊框"
L["Show player frame in class color"] = "以職業顏色顯示玩家框架"
L["Show raid button"] = "顯示團隊按鈕"
L["Show target frame and focus frame in class color"] = "以職業顏色顯示目標與焦點框架"
L["Show the spell ID in buff icon tooltips"] = "在增益圖標提示顯示法術ID"
L["Show the unit's target"] = "顯示目標的目標"
L["Show volume slider"] = "顯示音量控制"
L["Show Wowhead links"] = "顯示Wowhead連結"
L["Shrine of the Storm"] = "風暴聖壇"
L["Siege of Boralus"] = "波拉勒斯圍城戰"
L["Siege of Dazar'alor"] = "圍攻達薩亞洛"
L["Siege of Niuzao Temple"] = "圍攻怒兆寺"
L["Siege of Orgrimmar"] = "圍攻奧格瑪"
L["Silence rested emotes"] = "表情靜音"
L["Silithus"] = "希利蘇斯"
L["Silverpine Forest"] = "銀松森林"
L["Silvershard Mines"] = "碎銀礦坑"
L["Skyreach"] = "擎天峰"
L["Slave Pens"] = "奴隸監牢"
L["Sniffing"] = "嗅聞"
L["Social"] = "社交訊息"
L["Sold junk for"] = "賣出垃圾為"
L["Sound system restarted."] = "聲音系統已重啟。"
L["Southern Barrens"] = "南貧瘠之地"
L["Spell ID"] = "法術ID"
L["Spine of Deathwing"] = "死亡之翼的脊背"
L["Spires of Arak"] = "阿拉卡山"
L["Steamvault"] = "蒸氣洞窟"
L["Stockade"] = "暴風城監獄"
L["Stonecore"] = "石岩之心"
L["Stonetalon Mountains"] = "石爪山脈"
L["Stop"] = "停止"
L["Storm Peaks"] = "風暴群山"
L["Stormheim"] = "斯鐸海姆"
L["Stormheim (Alliance)"] = "斯鐸海姆 (聯盟)"
L["Stormheim (Horde)"] = "斯鐸海姆 (部落)"
L["Stormsong Valley"] = "風歌谷地"
L["Stormstout Brewery"] = "風暴烈酒酒坊"
L["Stormwind"] = "暴風城"
L["Strand of the Ancients"] = "遠祖灘頭"
L["Stratholme"] = "斯坦索姆"
L["Stratholme: Crusader's Square"] = "斯坦索姆：十字軍廣場"
L["Stratholme: The Gauntlet"] = "斯坦索姆：The Gauntlet"
L["Sunken Temple"] = "沉沒的神廟"
L["Sunwell Plateau"] = "太陽之井高地"
L["Support"] = "支援"
L["Suramar"] = "蘇拉瑪爾"
L["Swamp of Sorrows"] = "悲傷沼澤"
L["Sync from friends"] = "好友的同步請求"
L["System"] = "系統設置"
L["Tabard"] = "隱藏戰袍"
L["Taint level: Basic (1)."] = "汙染等級：基本(1)"
L["Taint level: Disabled (0)."] = "汙染等級：停用(0)"
L["Taint level: Full (2)."] = "汙染等級：完整(2)"
L["Talador"] = "塔拉多爾"
L["Tanaan Jungle"] = "塔南森林"
L["Tanaris"] = "塔納利斯"
L["Target"] = "目標框架"
L["Target Tracking Disabled"] = "停用目標追蹤"
L["Target Tracking Enabled"] = "啟用目標追蹤"
L["Tea with Jaina"] = "與珍娜喝茶"
L["Tel'anor"] = "泰爾亞諾"
L["Teldrassil"] = "泰達希爾"
L["Tempest Keep"] = "風暴要塞"
L["Temple of Ahn'Qiraj"] = "安琪拉神廟"
L["Temple of Atal'Hakkar"] = "阿塔哈卡神廟"
L["Temple of Sethraliss"] = "瑟沙利斯神廟"
L["Temple of the Jade Serpent"] = "玉蛟寺"
L["Ten Years of Warcraft"] = "魔獸十周年"
L["Terokkar Forest"] = "泰洛卡森林"
L["Terrace of Endless Spring"] = "豐泉台"
L["Terror of Darkshore"] = "黑海岸之懼"
L["Text"] = "文字訊息"
L["Text size"] = "字體尺寸"
L["Text Size"] = "字體尺寸"
L["The Art of War"] = "戰爭的藝術"
L["The Battle for Broken Shore"] = "破碎群島之戰"
L["The Battle for Shattrath"] = "撒塔斯之戰"
L["The Battle of Thunder Pass"] = "雷霆王座之戰"
L["The Burning Crusade"] = "燃燒的遠征"
L["The Demon's Trail"] = "惡魔的蹤跡"
L["The Dragon Soul"] = "巨龍之魂"
L["The Eye"] = "風暴要塞"
L["The Fall of Lordaeron"] = "羅德隆的淪陷"
L["The Fate of Val'sharah"] = "維爾薩拉的命運"
L["The Fleet in Krasarang (Alliance)"] = "喀撒朗的艦隊（聯盟）"
L["The Fleet in Krasarang (Horde)"] = "喀撒朗的艦隊（部落）"
L["The Frozen Halls"] = "冰封大廳"
L["The Invasion Begins"] = "入侵開始"
L["The King's Command"] = "國王的徵招"
L["The Negotiation"] = "談判"
L["The Nightborne Pact"] = "夜裔的協議"
L["The Nighthold"] = "暗夜堡"
L["The Return of Hope"] = "希望回歸"
L["The summon from"] = "召喚來自"
L["The Threat Within"] = "內在的威脅"
L["The Waning Crescent"] = "弦月旅店"
L["Themes"] = "主題"
L["This command will assign your current pet team and selected abilities.|n|nPress CTRL/C to copy the command then paste it into a macro or chat window with CTRL/V."] = "此指令會指派你當前的戰寵隊伍並選擇技能。|n|n按下Ctrl+C來複製，然後用Ctrl+V貼上到聊天視窗或是巨集中。"
L["This panel will close automatically if you enter combat."] = "此面板將在你進入戰鬥後自動關閉。"
L["Thousand Needles"] = "千針石林"
L["Throne of the Four Winds"] = "四風王座"
L["Throne of the Tides"] = "海潮王座"
L["Throne of Thunder"] = "雷霆王座"
L["Thunder Bluff"] = "雷霆崖"
L["Timeless Isle"] = "永恆島"
L["Timer"] = "計時框架"
L["Tiragarde Sound"] = "提拉加德海灣"
L["Tirisfal Glades"] = "提里斯法林地"
L["Titan Panel screen adjust needs to be disabled for frames to be saved correctly."] = "泰坦面板螢幕調整需要停用以讓框架能正確儲存。"
L["To begin, choose an options page."] = "請選擇一個選項開始使用"
L["To hide the combat log, you need to disable the chat module in ElvUI."] = "想隱藏戰鬥紀錄，您需要停用ElvUI的聊天模組。"
L["To use the Find Item button, you need to deselect the WoW Token category."] = "要使用此搜尋物品按鈕，您需要取消選擇WoW的代幣類別"
L["Tol Barad"] = "托巴拉德"
L["Tol Dagor"] = "托達戈爾"
L["Tomb of Sargeras"] = "薩格拉斯之墓"
L["Tooltip"] = "提示訊息"
L["Tooltip title color"] = "鼠標提示訊息顏色。"
L["Top"] = "頂部"
L["Top Center"] = "頂級中心"
L["Townlong Steppes"] = "螳螂荒原"
L["Tracing started."] = "追蹤已開始。"
L["Tracing stopped."] = "追蹤已停止。"
L["Trains"] = "火車"
L["Transparency"] = "透明度"
L["Travelers"] = "旅行商"
L["Trial of Style"] = "造型選拔賽"
L["Trial of the Champion"] = "勇士試煉"
L["Trial of the Crusader"] = "十字軍試煉"
L["Trial of Valor"] = "勇氣試煉"
L["True"] = "真實"
L["Turn-in completed quests automatically"] = "自動交付已完成的任務"
L["Twilight Highlands"] = "暮光高地"
L["Twilight Vineyards"] = "暮光葡萄園"
L["Twin Peaks"] = "雙子峰"
L["Uldaman"] = "奧達曼"
L["Uldir"] = "奧迪爾"
L["Ulduar"] = "奧杜亞"
L["Uldum"] = "奧丹姆"
L["Unclamp chat frame"] = "不限制視窗位置"
L["Underbog"] = "幽暗沼澤"
L["Undercity"] = "幽暗城"
L["Underrot"] = "幽腐深窟"
L["Un'Goro Crater"] = "安戈洛環形山"
L["Universal group color"] = "通用的隊伍著色"
L["Use arrow keys in chat"] = "允許使用方向鍵"
L["Use easy resizing"] = "使用簡單拉伸"
L["Use Leatrix Plus to move that frame."] = "使用Leatrix Plues來移動框架"
L["Use Leatrix Plus to reset that frame."] = "使用Leatrix Plues來重置框架"
L["Utgarde Keep"] = "俄特加德要塞"
L["Utgarde Pinnacle"] = "俄特加德之巔"
L["Vale of Eternal Blossoms"] = "永茂林谷地"
L["Valley of the Four Winds"] = "四風峽"
L["Val'sharah"] = "維爾薩拉"
L["Value must be a number."] = "值必須為數字。"
L["Various"] = "雜項"
L["Vashj'ir"] = "瓦許伊爾"
L["Vault of Archavon"] = "亞夏梵穹殿"
L["Vault of the Wardens"] = "看守者鐵獄"
L["Vaults"] = "金庫"
L["Vendors"] = "商店"
L["Version"] = "版本"
L["Victory at The Nighthold"] = "暗夜堡的勝利"
L["Victory in Draenor!"] = "德拉諾的勝利！"
L["Video"] = "影像"
L["Violet Hold"] = "紫羅蘭堡"
L["Visibility"] = "可見性"
L["Vision of Sailor's Memory"] = "水手回憶的想像"
L["Visions of N'Zoth"] = "恩若司的幻象"
L["Void Elves"] = "虛空精靈"
L["Vol'dun"] = "沃魯敦"
L["Vol'mar"] = "沃爾瑪"
L["Wailing Caverns"] = "哀嚎洞穴"
L["Wandering Isle"] = "漂流島"
L["Warbringers Azshara"] = "戰爭使者艾薩拉"
L["Warbringers Jaina"] = "戰爭使者 珍娜"
L["Warbringers Sylvanas"] = "戰火之源：希瓦娜斯"
L["Warfronts"] = "戰爭前線"
L["Warlords of Draenor"] = "德拉諾之霸"
L["Warning"] = "警告"
L["was automatically declined."] = "已經自動拒絕。"
L["Waycrest Manor"] = "威奎斯特莊園"
L["Weather density"] = "天氣密度"
L["Welcome to Leatrix Plus."] = "歡迎使用Leatrix Plus"
L["Well of Eternity"] = "永恆之井"
L["Western Plaguelands"] = "西瘟疫之地"
L["Westfall"] = "西部荒野"
L["Wetlands"] = "濕地"
L["Widget"] = "窗口小部件"
L["will be automatically accepted in 10 seconds unless cancelled."] = "除非取消，否則將在10秒內自動接受。"
L["Winter"] = "寒冬"
L["Wintergrasp"] = "冬握湖"
L["Winterspring"] = "冬泉谷"
L["World of Warcraft"] = "魔獸世界"
L["Wrath of the Lich King"] = "巫妖王之怒"
L["Wyrmrest Temple"] = "龍眠神殿"
L["X Offset"] = "水平偏移"
L["Y Offset"] = "垂直偏移"
L["YOU"] = "你"
L["You cannot do that in combat."] = "你無法在戰鬥中進行該項操作。"
L["You do not own this pet.  Only owned pets can be searched."] = "你未擁有此寵物。只有已收集的寵物能被搜尋。"
L["You have"] = "你有"
L["You need a battle pet team."] = "你需要一個戰寵隊伍。"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "你需要進行重載插件後才能使部分設置生效。|n|n你無需立即點擊重載插件按鈕，但是你完成設置並希望其生效時，必須點擊它。"
L["Your UI needs to be reloaded."] = "你的插件需要重新載入。"
L["Zandalar"] = "贊達拉"
L["Zandalari Trolls"] = "贊達拉食人妖"
L["Zangarmarsh"] = "贊格沼澤"
L["Zones"] = "區域"
L["Zul'Aman"] = "祖阿曼"
L["Zuldazar"] = "祖達薩"
L["Zul'Drak"] = "祖爾德拉克"
L["Zul'Farrak"] = "祖爾法拉克"
L["Zul'Gurub"] = "祖爾格拉布"
L["Zygor addon not found."] = "你尚未安裝Zygor插件。"

end

-- ruRU: Russian
if GameLocale == "ruRU" then
L["A Deal with Death"] = "Сделка со смертью"
L["A Falling Star"] = "Падающая звезда"
L["A Found Memento"] = "Памятная вещь"
L["A friend request from"] = "Запрос дружбы от"
L["A New Life for Undeath"] = "Новая жизнь нежити"
L["A Taste of Iron"] = "Вкус железа"
L["Accept available quests automatically"] = "Принимать доступные квесты автоматически"
L["Accept resurrection"] = "Принятие воскрешения"
L["Accept summon"] = "Принятие призыва"
L["Account achievements are being shared."] = "Достижения на учетную запись могут быть доступны другим персонажам."
L["Account achievements are hidden."] = "Достижения на учетную запись скрыты."
L["Addon"] = "Модификация"
L["Adventure"] = "Приключение"
L["Ahn'kahet (Old Kingdom)"] = "Ан'кахет (Старое Королевство)"
L["All 3 battle pet slots need to be unlocked."] = "Все 3 слота питомцев должны быть разблокированы."
L["Allied Races"] = "Союзные расы"
L["An Unexpected Reunion"] = "Неожиданное Воссоединение"
L["Anchor"] = "Якорь-трава"
L["And Justice for Thrall"] = "Правосудие для Тралла"
L["Anduin's Theme"] = "Тема Андуина"
L["Antoran Wastes (Argus)"] = "Пустоши Анторуса (Аргуса)"
L["Antorus Ending"] = "Конец Анторуса"
L["Antorus, the Burning Throne"] = "Анторус, Пылающий Трон"
L["Arathi Highlands"] = "Нагорье Арати"
L["Arcway"] = "Катакомбы Сурамара"
L["Arenas"] = "Аренас"
L["Arrival on Argus"] = "Прибытие на Аргус"
L["Arrival to Zandalar"] = "Прибытие в Зандалар"
L["Ashenvale"] = "Ясеневый лес"
L["Ashran"] = "Ашран"
L["Assault on the Broken Shore"] = "Штурм сломанного берега"
L["Astravar Harbor"] = "Гавань Астравар"
L["Atal'Dazar"] = "Атал'Дазар"
L["ATV"] = "Скивиллаг"
L["Auchenai Crypts"] = "Аукенайские гробницы"
L["Auchindoun"] = "Аукиндон"
L["AutoFollow"] = "автосопровождение"
L["AutoFollow disabled."] = "Автозаполнение отключено."
L["Automate gossip"] = "Автоматизация общения"
L["Automate quests"] = "Автоматизация заданий"
L["Automation"] = "Автоматизация"
L["Azjol-Nerub"] = "Азжол-Неруб"
L["Azshara"] = "Азшара"
L["Azshara's Eternal Palace"] = "Вечный дворец Азшары"
L["Azsuna"] = "Азсуна"
L["Azuremyst Isle"] = "Остров Лазурной Дымки"
L["Back to Main Menu"] = "В главное меню"
L["Bad ID"] = "Плохой идентификатор"
L["Badlands"] = "Бесплодные земли"
L["Balls"] = "Мячи"
L["Ban-Lu"] = "Бань Лу"
L["Baradin Hold"] = "Крепость Барадин"
L["Barrens"] = "Южные степи"
L["Bastion of Twilight"] = "Сумеречный бастион"
L["Battle for Azeroth"] = "Battle for Azeroth"
L["Battle for Darkshore"] = "Битва за Темные берега"
L["Battle for Gilneas"] = "Битва за Гилнеас"
L["Battle for Stromgarde"] = "Битва за Стромгард"
L["Battle of Angrathar the Wrathgate"] = "Битва при Ангратаре Гневные врата"
L["Battle of Dazar'alor"] = "Битва за Дазар'алор"
L["Battle of Serpent's Heart"] = "Битва Змеиного Сердца"
L["Battlegrounds"] = "Боевые зоны"
L["Bigger is Better (Alliance)"] = "Лучше больше, да лучше (Альянс)"
L["Bigger is Better (Horde)"] = "Лучше больше, да лучше (Horde)"
L["Bikes"] = "Мотоциклы"
L["Black Morass"] = "Черные топи"
L["Black Rook Hold"] = "Крепость Черной Ладьи"
L["Black Temple"] = "Черный храм"
L["Blackfathom Deeps"] = "Непроглядная Пучина"
L["Blackrock Caverns"] = "Пещеры Черной горы"
L["Blackrock Depths"] = "Глубины Черной горы"
L["Blackrock Foundry"] = "Литейная клана Черной горы"
L["Blackrock Mountain"] = "Черная гора"
L["Blackrock Spire"] = "Пик Черной горы"
L["Blackwing Descent"] = "Твердыня Крыла Тьмы"
L["Blackwing Lair"] = "Логово Крыла Тьмы"
L["Blade's Edge Mountains"] = "Острогорье"
L["Blasted Lands"] = "Выжженные земли"
L["Block duels"] = "Блок дуэлей"
L["Block friend requests"] = "Блок запросов дружбы"
L["Block party invites"] = "Блок приглашений в группу"
L["Block pet battle duels"] = "Блок битв питомцев"
L["Blocks"] = "Блокировки"
L["Bloodmaul Slag Mines"] = "Шлаковые шахты Кровавого Молота"
L["Bloodmyst Isle"] = "Остров Кровавой Дымки"
L["Borean Tundra"] = "Борейская тундра"
L["Bottom"] = "Нижняя"
L["Broken Isles"] = "Расколотые острова"
L["Broken Shore"] = "Расколотый берег"
L["Buffs"] = "Эффекты"
L["Burning Steppes"] = "Пылающие степи"
L["Buyout Only"] = "Только выкуп"
L["Camera distance"] = "Дистанция камеры"
L["Cape of Stranglethorn"] = "Мыс Тернистой долины"
L["Cataclysm"] = "Cataclysm"
L["Cathedral of Eternal Night"] = "Собор Вечной Ночи"
L["Caverns of Time"] = "Пещеры Времени"
L["Chain style"] = "Стиль контура"
L["Character"] = "Персонаж"
L["Chat"] = "Чат"
L["Chat Frame"] = "Окно чата"
L["Checkbox labels are Ok."] = "Сокращать описания."
L["Choose an Enigma pattern"] = "Выберите шаблон Enigma"
L["Cinematics"] = "кинематика"
L["Class colored frames"] = "Фон имени в цвете класса"
L["Class icon portraits"] = "Изображение класса в портрете"
L["Class Trials"] = "Классовые испытания"
L["click here for new selection"] = "Нажмите сюда для создания новой подборки"
L["Click to configure the settings for this option."] = "Нажмите, чтобы перейти к интерфейсу дополнительных параметров этой настройки."
L["Click to disable Dominos Encounter for all characters on this realm.  This is required for the player power bar position to be saved correctly.  Your UI will be reloaded."] = "Нажмите, чтобы отключить Dominos Encounter для всех персонажей на этом сервере. Это необходимо для правильного сохранения позиции панели силы игрока. Ваш пользовательский интерфейс будет перезагружен."
L["Click to reset the settings on this page."] = "Нажмите, чтобы сбросить настройки на этой странице."
L["Click to return to the main menu."] = "Нажмите, чтобы вернуться в главное меню."
L["Coilfang Reservoir"] = "Резервуар Кривого Клыка"
L["Color the backdrops based on faction"] = "Цвет фона на основе цвета фракции"
L["Combat"] = "Бой"
L["Combat log cannot be hidden while undocked."] = "Журнал боя не может быть скрыт, пока отсоединён."
L["Combat plates"] = "Индикаторы"
L["Completed."] = "Завершено."
L["Configuration Panel"] = "Панель настройки"
L["Connections for"] = "Соединения для"
L["Court of Stars"] = "Квартал Звезд"
L["Credits"] = "кредиты"
L["Crucible of Storms"] = "Горнило Штормов"
L["Crystalsong Forest"] = "Лес Хрустальной Песни"
L["Culling of Stratholme"] = "Очищение Стратхольма"
L["Cursor"] = "Курсор"
L["Cursor Left"] = "Курсор слева"
L["Cursor Right"] = "Курсор справа"
L["Dalaran"] = "Даларан"
L["Dark Iron Dwarves"] = "Гномы Черного Железа"
L["Dark Soil scanning activated.  Reload UI to exit."] = "Сканирование темной земли активировано. Перезагрузите UI для выхода."
L["Dark Soil scanning is already activated.  You only need to run this once.  Reload UI to exit."] = "Сканирование темной земли уже активировано. Вы должны запустить его только один раз. Перезагрузите UI для выхода."
L["Darkheart Thicket"] = "Чаща Темного Сердца"
L["Darkmoon Faire"] = "Ярмарка Новолуния"
L["Darkness Falls"] = "Тьма наступает"
L["Darkshore"] = "Темные берега"
L["Darnassus"] = "Дарнас"
L["Deadmines"] = "Пещеры Стенаний"
L["Deepholm"] = "Подземье"
L["Deepwind Gorge"] = "Каньон Суровых Ветров"
L["Desolace"] = "Пустоши"
L["Destiny Unfulfilled"] = "Неисполненная судьба"
L["Dire Maul"] = "Забытый Город"
L["Dire Maul: Capital Gardens"] = "Забытый Город: Центральный сад"
L["Dire Maul: Gordok Commons"] = "Забытый Город: Палаты Гордока"
L["Dire Maul: Warpwood Quarter"] = "Забытый Город: Квартал Криводревов"
L["Disable bag automation"] = "Откл. автоматизац. сумок"
L["Disable chat fade"] = "Откл. затухание сообщений чата"
L["Disable loot warnings"] = "Откл. предупреждения о добыче"
L["Disable pet automation"] = "Откл. автоматизац. питомцев"
L["Disable screen effects"] = "Откл. экранные эффекты"
L["Disable screen glow"] = "Откл. свечение экрана"
L["Disable sticky chat"] = "Отключить липкий чат"
L["Disable sticky editbox"] = "Закрывать поле ввода чата"
L["Dominos Encounter needs to be disabled."] = "Dominos Encounter нужно отключить."
L["Don't accept daily quests automatically"] = "Не принимать ежедневные задания автоматически"
L["Don't accept weekly quests automatically"] = "Не принимать еженедельные задания автоматически"
L["Draenor"] = "Дренор"
L["Drag the frame overlay to position the frame."] = "Переместите рамки для изменения позиции окон."
L["Drag the frame overlays to position the frames.|n|nTo change the scale of a frame, click it to select it then adjust the scale slider.|n|nThis panel will close automatically if you enter combat."] = "Переместите рамки для изменения позиции окон.|n|nЧтобы изменить масштаб окна, щелкните по его рамке, чтобы его выбрать, а затем отрегулируйте масштаб ползунком на странице настроек.|n|nЭта панель закроется автоматически, если Вы входите в бой."
L["Drag to set the buffs frame scale."] = "Переместите ползунок влево или вправо, чтобы установить размер фрейма баффов"
L["Drag to set the cursor X offset."] = "Переместите ползунок влево или вправо, чтобы установить смещение курсора по оси X."
L["Drag to set the cursor Y offset."] = "Переместите ползунок влево или вправо, чтобы установить смещение курсора по оси Y."
L["Drag to set the density of weather effects."] = "Переместите ползунок влево или вправо, чтобы установить плотность погодных эффектов."
L["Drag to set the font size of mail text."] = "Переместите ползунок влево или вправо, чтобы установить размер шрифта для текста почтовых сообщений"
L["Drag to set the font size of quest text."] = "Переместите ползунок влево или вправо, чтобы установить размер шрифта для текста квестов."
L["Drag to set the minimap scale.|n|nNote that if you are using the default action bars, rescaling the minimap will also rescale the right action bars at startup so you may want to leave this at 100%."] = "Переместите ползунок влево или вправо, чтобы изменить масштаб мини-карты.|n|nОбратите внимание, что если вы используете панели действий по умолчанию, то изменения масштаба миникарты также приведут к изменению и их масштаба. Рекомендуем оставить значение на 100%."
L["Drag to set the scale of the Leatrix Plus panel."] = "Переместите ползунок влево или вправо, чтобы установить масштаб панели Leatrix Plus."
L["Drag to set the scale of the selected frame."] = "Переместите ползунок влево или вправо, чтобы установить масштаб выбранного фрейма."
L["Drag to set the size of the bottom border."] = "Перемещайте, чтобы установить размер нижней границы."
L["Drag to set the size of the left border."] = "Перемещайте, чтобы установить размер левой границы."
L["Drag to set the size of the right border."] = "Перемещайте, чтобы установить размер верхней границы."
L["Drag to set the size of the top border."] = "Перетащите, чтобы установить размер верхней границы."
L["Drag to set the tooltip scale."] = "Переместите ползунок влево или вправо, чтобы установить масштаб всплывающей подсказки."
L["Drag to set the transparency of the borders."] = "Переместите ползунок влево или вправо, чтобы установить прозрачность границ."
L["Drag to set the transparency of the Leatrix Plus panel."] = "Переместите ползунок влево или вправо, чтобы установить прозрачность панели Leatrix Plus."
L["Dragon Soul"] = "Душа Дракона"
L["Dragonblight"] = "Драконий Погост"
L["Drak'Tharon Keep"] = "Крепость Драк'Тарон"
L["Dread Wastes"] = "Жуткие пустоши"
L["Drustvar"] = "Друствар"
L["Dun Morogh"] = "Дун Морог"
L["Dungeon"] = "Подземелье"
L["Dungeons"] = "Подземелья"
L["Dup ID"] = "Dup ID"
L["durability"] = "прочности"
L["Durability"] = "Прочность"
L["Durotar"] = "Дуротар"
L["Duskwood"] = "Сумеречный лес"
L["Dustwallow Marsh"] = "Пылевые топи"
L["Eastern"] = "Восточные"
L["Eastern Kingdoms"] = "Восточные королевства"
L["Eastern Plaguelands"] = "Восточные Чумные земли"
L["ELITE"] = "Элитный"
L["Elwynn Forest"] = "Элвиннский лес"
L["Embassies"] = "Посольства"
L["Embers of War"] = "Угли войны"
L["Emerald Nightmare"] = "Изумрудный Кошмар"
L["Enable hotkey"] = "Вкл. горячую клавишу"
L["End Time"] = "Конец Времен"
L["Enhance dressup"] = "Улучшить примерочную"
L["Enhance minimap"] = "Улучшить миникарту"
L["Enhance tooltip"] = "Улучшить подсказки"
L["Enhancements"] = "Улучшения"
L["Enigma"] = "загадка"
L["Enter the spell IDs for the cooldown icons that you want to see.|n|nIf a cooldown icon normally appears under the pet frame, check the pet checkbox.|n|nCooldown icons are saved to your class and specialisation."] = "Введите идентификаторы заклинаний для значков времени восстановления, которые вы хотите видеть.|n|nЕсли значок перезарядки обычно появляется под рамкой питомца, установите флажок питомца.|n|nИконки восстановления сохраняются для вашего класса и специализации."
L["enter zone or track name"] = "введите название зоны или трека"
L["Epilogue (Alliance)"] = "Эпилог (Альянс)"
L["Epilogue (Horde)"] = "Эпилог (Орда)"
L["Error messages will be hidden"] = "Сообщения об ошибках будут скрыты"
L["Error messages will be shown"] = "Сообщения об ошибках будут показаны"
L["Error retrieving quest."] = "Ошибка получения квеста."
L["Establish Your Garrison (Alliance)"] = "Создайте свой гарнизон (Альянс)"
L["Establish Your Garrison (Horde)"] = "Создайте свой гарнизон (Орда)"
L["Eternal Palace"] = "Вечный дворец"
L["Events"] = "События"
L["Everbloom"] = "Вечное Цветение"
L["Evermoon Terrace"] = "Терраса Вечной Луны"
L["Eversong Woods"] = "Леса Вечной Песни"
L["Extras"] = "Дополнения"
L["Eye of Azshara"] = "Око Азшары"
L["Eye of Eternity"] = "Око Вечности"
L["Falanaar"] = "Фаланаар"
L["Fall of Deathwing"] = "Падение Смертокрыла"
L["Fall of the Lich King"] = "Падение Короля-лича"
L["False"] = "Ложь"
L["Faster auto loot"] = "Быстрый сбор добычи"
L["Faster movie skip"] = "Быстро пропускать ролики"
L["Fate of the Horde"] = "Судьба Орды"
L["Features"] = "Особенности"
L["Felsoul Hold"] = "Оплот Оскверненной Души"
L["Felwood"] = "Оскверненный лес"
L["Feralas"] = "Фералас"
L["Find Item"] = "Найти предмет"
L["Firelands"] = "Огненные Просторы"
L["Fizzle"] = "Заклинания"
L["Forge of Souls"] = "Кузня Душ"
L["Frames"] = "Рамки"
L["Freehold"] = "Вольная Гавань"
L["Frostfire Ridge"] = "Хребет Ледяного Огня"
L["Game Options"] = "Настройки игры"
L["Gate of the Setting Sun"] = "Врата Заходящего Солнца"
L["General"] = "Основной"
L["Ghost"] = "Призрак"
L["Ghostlands"] = "Призрачные земли"
L["Gnomeregan"] = "Гномреган"
L["Gold Only"] = "Только золото"
L["Gorgrond"] = "Горгронд"
L["Graphics and Sound"] = "Графика и звук"
L["Grim Batol"] = "Грим Батол"
L["Grimrail Depot"] = "Депо Мрачных Путей"
L["Grizzly Hills"] = "Седые холмы"
L["Groups"] = "Группы"
L["Gruul's Lair"] = "Логово Груула"
L["Gul'dan Ascendant"] = "Гул'дан Асцендент"
L["Gul'dan's Plan"] = "План Гул'дана"
L["Gundrak"] = "Гундрак"
L["Halls of Lightning"] = "Чертоги Молний"
L["Halls of Origination"] = "Чертоги Созидания"
L["Halls of Reflection"] = "Залы Отражений"
L["Halls of Stone"] = "Чертоги Камня"
L["Halls of Valor"] = "Чертоги Доблести"
L["Harbingers Gul'dan"] = "Предвестники Гул'дана"
L["Harbingers Illidan"] = "Предвестники Иллидана"
L["Harbingers Khadgar"] = "Предвестники Кадгара"
L["Havenswood"] = "Спасолесье"
L["Heart of Fear"] = "Сердце Страха"
L["Hellfire Citadel"] = "Цитадель Адского Пламени"
L["Hellfire Peninsula"] = "Полуостров Адского Пламени"
L["Hellfire Ramparts"] = "Бастионы Адского Пламени"
L["Hellscream's Downfall (Alliance)"] = "Падение Адского Крика (Альянс)"
L["Hellscream's Downfall (Horde)"] = "Падение Адского Крика (Орда)"
L["Help"] = "Справка"
L["Hide alerts"] = "Скрыть оповещения"
L["Hide bodyguard gossip"] = "Скрыть разговоры телохранителя"
L["Hide boss banner"] = "Скрыть баннер босса"
L["Hide chat buttons"] = "Скрыть кнопки чата"
L["Hide clean-up buttons"] = "Скрыть кнопку сортировки"
L["Hide cooldown duration numbers (if enabled)"] = "Скрыть длительность перезарядки (если включено)"
L["Hide error messages"] = "Скр. сообщ. об ошибках"
L["Hide gryphons"] = "Скрыть грифонов"
L["Hide level-up display"] = "Скрыть окно увл. уровня"
L["Hide order hall bar"] = "Скрыть панель заказов оплота"
L["Hide portrait numbers"] = "Скрыть числа на портрете"
L["Hide social button"] = "Скрыть социальную кнопку"
L["Hide stance bar"] = "Скрыть окно стоек"
L["Hide talking frame"] = "Скрыть окно разговоров"
L["Hide the clock"] = "Скрыть панель с часами"
L["Hide the combat log"] = "Скрыть журнал боя"
L["Hide the zone text bar"] = "Скрыть текстовую панель с названием зоны"
L["Hide the zoom buttons"] = "Скрыть кнопки масштабирования"
L["Hide tooltips for world units during combat"] = "Скрыть подсказки для мировых объектов во время боя"
L["Hide zone text"] = "Скрыть название зоны"
L["High"] = "Высокая"
L["Highmaul"] = "Земли клана Верховного Молота"
L["Highmountain"] = "Крутогорье"
L["Highmountain Tauren"] = "Таурен Крутогорья"
L["Hillsbrad Foothills"] = "Предгорья Хилсбрада"
L["Hinterlands"] = "Внутренние земли"
L["Home"] = "Главная"
L["Hour of Twilight"] = "Время Сумерек"
L["Howling Fjord"] = "Ревущий фьорд"
L["Hyjal Summit"] = "Вершина Хиджала"
L["Icecrown"] = "Ледяная Корона"
L["Icecrown Citadel"] = "Цитадель Ледяной Короны"
L["If checked, a button will be added to the character sheet which will show your equipped item durability when you hover the pointer over it.|n|nIn addition, an overall percentage will be shown in the chat frame when you die."] = "Если флажок установлен, то в окне отображения информации о персонаже будет добавлена кнопка, при наведении указателя мыши на которую, будет показана прочность всей экипировки персонжа.|n|nКроме того, при смерти вашего персонажа, общий процент прочности будет показан сообщением в окне чата."
L["If checked, a group invite will be sent to anyone who whispers you with a set keyword as long as you are ungrouped, group leader or raid assistant."] = "Если флажок установлен, то приглашение в группу будет автоматически отправлено всем, кто шепнёт вам с заданным ключевым словом, если тот человек еще не входит в вашу группу или рейд. Чтобы всё сработало, у вас обязательно должен быть статус лидера группы или помощника в рейде."
L["If checked, a group invite will be sent to anyone who whispers you with the keyword INV.|n|nYou need to be either ungrouped or party leader in your own group for this to work."] = "Если флажок установлен, то групповое приглашение будет отправлено всем, кто шепчет вам с ключевым словом INV.|n|nЧтобы это сработало, вы должны не состоять в группе, либо быть лидером группы или рейда."
L["If checked, a master volume slider will be shown on the character sheet.|n|nThe volume slider can be placed in either of two locations on the character sheet.  To toggle between them, hold the shift key down and right-click the slider."] = "Если флажок установлен, то в окне отображения информации о персонаже будет отображаться регулятор (ползунок) общей громкости.|n|nРегулятор может быть размещен в одном из двух мест в этом окне. По умолчанию в левом нижнем углу. Для переключения расположения регулятора, удерживая клавишу SHIFT щелкните правой кнопкой мыши по регулятору."
L["If checked, a minimap button will be available.|n|nClick - Toggle options panel.|n|nSHIFT/Left-click - Toggle music.|n|nSHIFT/Right-click - Toggle stopwatch.|n|nCTRL/Left-click - Toggle minimap target tracking.|n|nCTRL/Right-click - Toggle errors (if enabled).|n|nCTRL/SHIFT/Left-click - Toggle Zygor (if installed).|n|nCTRL/SHIFT/Right-click - Toggle windowed mode."] = "Если флажок установлен, то у миникарты будет отображаться кнопка аддона.|n|nКликните по ней, чтобы показать/скрыть окно настроек аддона.|n|nSHIFT+ЛКМ - вкл/выкл музыку.|n|nSHIFT+ПКМ - вкл/выкл секундомер.|n|nCTRL+ЛКМ - вкл/выкл отслеживание на миникарте.|n|nCTRL+ПКМ - вкл/выкл ошибки (если были включены).|n|nCTRL+SHIFT+ЛКМ - вкл/выкл Zygor (если установлен).|n|nCTRL+SHIFT+ПКМ - вкл/выкл оконный режим."
L["If checked, alert frames will not be shown."] = "Если флажок установлен, то фреймы с предупреждениями не будут отображаться."
L["If checked, all grey items in your bags will be sold automatically when you visit a merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "Если флажок установлен, то все предметы серого качества, находящиеся в ваших сумках, будут автоматически проданы при посещении торговца.|n|nВы можете удерживать клавишу SHIFT во время общения с торговцем для временного игнорирования этой опции."
L["If checked, available quests will be accepted automatically."] = "Если установлен этот флажок, доступные для вас квесты будут приниматься автоматически"
L["If checked, backdrops will be tinted blue (friendly) or red (hostile)."] = "Если флажок установлен, то фон подсказки будет синим (дружественная цель) или красным (враждебная цель)."
L["If checked, Ban-Lu will no longer talk to you."] = "Если флажок установлен, то Бань Лу больше не будет разговаривать с вами"
L["If checked, battle pets which are automatically summoned will be dismissed within a few seconds.|n|nThis includes dragging a pet onto the first team slot in the pet journal and entering a battle pet team save command.|n|nNote that pets which are automatically summoned during combat will be dismissed when combat ends."] = "Если флажок установлен, то автоматически вызываемые боевые питомцы будут удалены в течение нескольких секунд.|N|nСюда входит перетаскивание питомца в первый слот команды в журнале питомцев и ввод команды сохранения команды боевого питомца. |N|nУкажите, что питомцы будут автоматически вызваны во время боя и будут отклонены после окончания боя."
L["If checked, battle shouts heard when casting specific spells will be muted."] = "Если флажок установлен, боевые крики, слышимые при произнесении определенных заклинаний, будут отключены."
L["If checked, BattleTag and Real ID friend requests will be automatically declined.|n|nEnabling this option will automatically decline any pending requests."] = "Если флажок установлен, то запросы дружбы по BattleTag и Real ID будут автоматически отклоняться.|n|nВключение этого параметра автоматически отклонит любые ожидающие запросы."
L["If checked, chat frame buttons will be hidden.|n|nClicking chat tabs will automatically show the latest messages.|n|nUse the mouse wheel to scroll through the chat history.  Hold down SHIFT for page jump or CTRL to jump to the top or bottom of the chat history."] = "Если флажок установлен, то кнопки чата будут скрыты.|n|nКлик по вкладке чата автоматически покажет последние сообщения.|n|nИспользуйте колесо мыши для прокрутки истории чата. Удерживайте клавишу SHIFT для перехода на другую страницу чата или CTRL, для перехода к верхней или нижней части истории чата."
L["If checked, chat text will not fade out after a time period."] = "Если флажок установлен, то текст чата не будет исчезать спустя некоторое время."
L["If checked, class coloring will be used in the player frame, target frame and focus frame."] = "Если флажок установлен, то фон имени в рамке персонажа будет отображаться в цвете класса - как для вашего персонажа, так и для вашей цели и цели её цели."
L["If checked, class icons will be shown in the portrait frames."] = "Если флажок установлен, то в фреймах персонажей, вместо портретов, будут отображаться значки классов."
L["If checked, completed quests will be turned-in automatically."] = "Если установлен этот флажок, выполненные квесты будут сдаваться автоматически"
L["If checked, confirmations will no longer appear when you choose a loot roll option or attempt to sell or mail a tradable item."] = "Если флажок установлен, то больше не будет предупреждений когда вы разыгрываете (роллите) предмет или пересылаете по почте предмет, который можно передать."
L["If checked, converting a party group to a raid group will succeed even if there are low level characters in the group.|n|nEveryone in the group needs to have Leatrix Plus installed with this option enabled."] = "Если флажок установлен, преобразование группы участников в группу рейдов будет успешным, даже если в группе есть персонажи низкого уровня.|n|nВажно: Все члены группы должны иметь установленный Leatrix Plus с включенной данной настройкой."
L["If checked, cooldown duration numbers will not be shown over the cooldowns.|n|nIf unchecked, cooldown duration numbers will be shown over the cooldowns if they are enabled in the game options panel ('ActionBars' menu)."] = "Если флажок установлен, то не будут отображаться цифры длительности перезарядки.|n|nЕсли не установлен, то длительность перезарядки будет показываться в перезарядках, если они включены в настройках игры."
L["If checked, daily quests will not be accepted automatically."] = "Если этот флажок установлен, доступные ежедневные задания не будут приниматься автоматически."
L["If checked, damage and healing numbers in the player and pet portrait frames will be hidden."] = "Если флажок установлен, то значения урона и лечения на рамках игрока и питомца будут скрыты."
L["If checked, dragging the General chat tab while the chat frame is locked will expand the chat frame upwards.|n|nIf the chat frame is unlocked, dragging the General chat tab will move the chat frame."] = "Если флажок установлен, то перетаскивание вкладки \"Общий\" чата, когда окно чата заблокировано, развернет окно чата.|n|nЕсли окно чата разблокировано, то перетаскивание вкладки \"Общий\" приведет к перемещению окна чата."
L["If checked, duel requests will be blocked unless the player requesting the duel is in your friends list or guild."] = "Если флажок установлен, то запросы на дуэль будут заблокированы (кроме запросов из вашей гильдии и из списка друзей)."
L["If checked, emote sounds will be silenced while your character is:|n|n- resting|n- in a pet battle|n- at the Halfhill Market|n- at the Grim Guzzler|n|nEmote sounds will be enabled when none of the above apply."] = "Если флажок установлен, то звуки эмоций будут заглушаться, пока ваш персонаж отдыхает или находится на \"Рынке Полугорья\" или в Трактире \"Угрюмый обжора\".|n|nВ любое другое время звуки будут включены."
L["If checked, enemy nameplates will be shown during combat and hidden when combat ends."] = "Если флажок установлен, то индикаторы здоровья будут отображены только во время боя и скрыты после его завершения."
L["If checked, gear toggle buttons will be added to the dressup frame and model positioning controls will be removed."] = "Если флажок установлен, то в окне примерочной будет добавлена кнопка переключения экипировки, а кнопки управления позиционированием модели - будут убраны."
L["If checked, group invites will only be sent to friends and guild members.|n|nIf unchecked, group invites will be sent to everyone."] = "Если флажок установлен, то приглашение в группу будет автоматически отправляться только вашим друзьям или согильдийцам|n|nЕсли флажок снят, автоматическое приглашение будет отправляться любому кто вам шепнёт с ключевым словом."
L["If checked, guild ranks will be shown for players in your guild."] = "Если флажок установлен, то для согильдийцев так же будут показываться их ранги в гильдии."
L["If checked, most error messages (such as 'Not enough rage') will not be shown.  Some important errors are excluded.|n|nIf you have the minimap button enabled, you can hold down the control key and right-click it to toggle error messages without affecting this setting."] = "Если флажок установлен, то большинство сообщений об ошибках (например, «Недостаточно ярости») не будут отображаться. Некоторые важные ошибки останутся.|n|nЕсли у вас включена кнопка на мини-карте, вы сможете удерживать CTRL и нажать ПКМ, чтобы вкл/выкл сообщения ошибка, не трогая данную настройку."
L["If checked, most of the bike mount sounds will be muted."] = "Если флажок установлен, то будут отключены большинство звуков мотоцикла"
L["If checked, party invitations from friends or guild members will be automatically accepted unless you are queued in Dungeon Finder."] = "Если флажок установлен, то приглашения в группу от друзей или согильдийцев будут приниматься автоматически, если вы не находитесь в очереди в поиск подземелья или рейда."
L["If checked, party invitations will be blocked unless the player inviting you is in your friends list or guild."] = "Если флажок установлен, то приглашения в группу будут заблокированы, если приглашающий вас игрок не будет находиться в вашем списке друзей или гильдии."
L["If checked, party sync requests from friends or guild members will be automatically accepted."] = "Если флажок установлен, то запросы синхронизации групп от друзей или членов гильдии будут приниматься автоматически."
L["If checked, pet battle duel requests will be blocked unless the player requesting the duel is in your friends list or guild."] = "Если флажок установлен, то запросы на дуэли питомцев будут заблокированы, если вызывающий ваших питомцев на дуэль игрок не будет находиться в списке ваших друзей или гильдии."
L["If checked, profession filter settings will be saved for the remainder of your login session."] = "Если флажок установлен, то настройки фильтра профессий будут сохраняться до конца сеанса входа в систему."
L["If checked, quests will be selected, accepted and turned-in automatically.|n|nQuests which have a gold, currency or crafting reagent requirement will not be turned-in automatically.|n|nYou can hold the shift key down when you talk to a quest giver to override this setting."] = "Если флажок установлен, то квесты будут приниматься и завершаться автоматически.|n|nКвесты для которых необходимо золото не будут автоматически завершаться.|n|nВы так же можете удерживать клавишу SHIFT, перед тем как поговорить с персонажем дающим квест, чтобы временно игнорировать эту настройку."
L["If checked, raid chat and instance chat will both be colored blue (to match the default party chat color)."] = "Если флажок установлен, то чаты рейдов и подземелий будут окрашены в синий цвет (чтобы соответствовать цвету чата группы по умолчанию)."
L["If checked, repair costs will be taken from guild funds for characters that are guilded and have permission to repair."] = "Если флажок установлен и вы являетесь членом гильдии, то затраты на ваш ремонт будут всегда списываться со счета гильдейского банка, при наличии у вас таких полномочий в гильдии."
L["If checked, requests initiated by your party leader to join the Dungeon Finder queue will be automatically accepted if the party leader is in your friends list or guild.|n|nThis option requires that you have selected a role for your character in the Dungeon Finder window."] = "Если флажок установлен , то запросы, инициированные лидером вашей группы на присоединение к очереди поиска подземелий, будут автоматически приниматься, если лидер группы находится в вашем списке друзей или гильдии.|N|nЭтот параметр требует, чтобы вы выбрали роль своего персонажа в окне поиска подземелий."
L["If checked, resurrection requests will be accepted automatically as long as the player resurrecting you is not in combat.|n|nResurrection requests from a Brazier of Awakening or a Failure Detection Pylon will not be accepted automatically."] = "Если флажок установлен, то подтверждение воскрешения будет происходить автоматически, если игрок который пытается вас воскресить не находится в бою.|n|nПодтверждение воскрешения от \"Жаровня пробуждения\" и \"Пилона для обнаружения проблем\" не будут приняты автоматически."
L["If checked, spell IDs will be shown in buff icon tooltips located in the buff frame and under the target frame."] = "Если флажок установлен, то во всплывающих подсказках на фрейме с бафами, а также на целях персонажа будут отображаться ID заклинаний."
L["If checked, sticky chat will be disabled.|n|nNote that this does not apply to temporary chat windows."] = "Если флажок установлен, то липкий чат будет отключен.|n|nОбратите внимание, что это не относится к временным окнам чата или Battle.net разговорам."
L["If checked, summon requests will be accepted automatically unless you are in combat."] = "Если флажок установлен и вы не находитесь в бою, то запрос на ваш призыв будет принят автоматически."
L["If checked, the addon list (accessible from the game menu) will show character based addons by default."] = "Если флажок установлен, то список модификаций (доступный из меню игры) будет отображать по умолчанию список модификации для этого персонажа."
L["If checked, the amount of time it takes to auto loot creatures will be significantly reduced."] = "Если флажок установлен, то время необходимое для поднятие добычи значительно сократится."
L["If checked, the backpack clean-up button and the bank frame clean-up button will not be shown."] = "Если флажок установлен, то кнопка сортировки вещей в сумках и в банке отображаться не будет."
L["If checked, the boss banner will not be shown.|n|nThe boss banner appears when a boss is defeated.  It shows the name of the boss and the loot that was distributed."] = "Если флажок установлен, то баннер босса отображаться не будет.|n|nЭтот баннер обычно появляется после победы над боссом. Он показывает имя босса и полученную с него добычу."
L["If checked, the button to toggle the raid container frame will be shown just above the raid management frame (left side of the screen) instead of in the raid management frame itself.|n|nThis allows you to toggle the raid container frame without needing to open the raid management frame."] = "Если флажок установлен, то кнопка для переключения контейнера рейда будет отображена над его окном управления (c левой стороны), а не на самом окне управления.|n|nЭто позволит переключать рамку контейнера рейда без необходимости открывать окно его управления."
L["If checked, the clock will be hidden."] = "Если флажок установлен, то часы у миникарты будут скрыты."
L["If checked, the combat log will be hidden.|n|nThe combat log must be docked in order for this option to work.|n|nIf the combat log is undocked, you can dock it by dragging the tab (and reloading your UI) or by resetting the chat windows (from the chat menu)."] = "Если флажок установлен, то закладка \"Журнал боя\" в окне чата будет скрыта.|n|nЧтобы эта настройка сработала, закладка \"Журнал боя\" должна находиться в окне чата.|n|n Если закладка откреплена, Вы можете закрепить её перетащив на вкладку чата (после этого необходимо перезагрузить UI) или сбросить настройки окна чата (из соответствующего меню)."
L["If checked, the 'Display only character achievements to others' setting in the game options panel ('Social' menu) will be permanently checked and locked."] = "Если флажок установлен, то параметр 'Позволить другим просматривать только достижения персонажа' в панели настроек игрового меню ('Общение') будет выбран и заблокирован."
L["If checked, the editbox will be moved to the top of the chat frame."] = "Если флажок установлен, то поле ввода текста будет перемещено в верхнюю часть окна чата. По умолчанию, оно находится в нижней части."
L["If checked, the editbox will close when it loses focus."] = "Если флажок установлен, то поле ввода чата будет автоматически закрываться, когда потеряет фокус."
L["If checked, the Foot Ball sounds will be muted."] = "Если флажок установлен, то будут отключены звуки игрушек \"футбольный мяч\" и \"футбольный мяч ограниченной серии\"."
L["If checked, the gossip window will not be shown when you talk to an active garrison bodyguard.|n|nYou can hold the shift key down when you talk to a bodyguard to override this setting."] = "Если флажок установлен, то окно разговоров не будет отображаться, когда Вы будете говорить с активным гарнизонным телохранителем.|n|nВы можете удерживать клавишу SHIFT во время общения для временного игнорирования данной настройки."
L["If checked, the grey screen of death and the netherworld effect will be disabled."] = "Если флажок установлен, то серый экран смерти и другие эффекты будут отключены."
L["If checked, the interface button sound, the chat frame tab click sound and the game menu toggle sound will be muted."] = "Если флажок установлен, то звуки кнопок интерфейса, щелчка по закладке чата и переключения меню игры - будут отключены."
L["If checked, the level-up display will not be shown.|n|nThe level-up display shows encounter objectives, level-ups, pet battle rewards, etc."] = "Если флажок установлен, то окно увеличения уровня не будет отображено.|n|nЭто окно обычно отображает цели подземелья, повышение уровня, награды за битву питомцев и др."
L["If checked, the main bar gryphons will not be shown."] = "Если флажок установлен, то панель с грифонами не будет отображаться."
L["If checked, the mechanical guild vault idle sound will be muted."] = "Если флажок установлен, то будут приглушены звуки холостого хода механического хранилища гильдии."
L["If checked, the netherworld effect will be disabled."] = "Если флажок установлен, то эффект преисподней будет отключен."
L["If checked, the order hall command bar will not be shown."] = "Если флажок установлен, то панель командного стола классового оплота не будет отображаться."
L["If checked, the player frame background will be shown in class color."] = "Если флажок установлен, фон рамки игрока будет отображаться по цвету класса."
L["If checked, the ready check sound will be muted."] = "Если этот флажок установлен, то звук проверки готовности будет отключен."
L["If checked, the screen glow will be disabled.|n|nEnabling this option will also disable the drunken haze effect."] = "Если флажок установлен, то свечение экрана будет отключено.|n|nВключение этой опции также отключит эффект \"пьяной\" дымки."
L["If checked, the social button and quick-join notification will be hidden."] = "Если флажок установлен, то кнопка чата для доступа к социальной сети игры (общении) и уведомлениям о быстром присоединении к друзьям - будет скрыта."
L["If checked, the spell fizzle sounds will be muted."] = "Если флажок установлен, то шипящие звуки заклинаний будут отключены."
L["If checked, the stance bar will not be shown."] = "Если флажок установлен, то панель стоек не будет отображаться."
L["If checked, the talking frame will not be shown.|n|nThe talking frame normally appears in the lower portion of the screen when certain NPCs communicate with you."] = "Если флажок установлен, то окно разговоров не будет показываться.|n|nОкно разговоров появляется обычно в нижней части экрана, в процессе общения с некоторыми НПС."
L["If checked, the target frame background and focus frame background will be shown in class color."] = "Если флажок установлен, фон рамок цели и фокуса будет отображаться по цвету класса."
L["If checked, the tooltip will be color coded and you will be able to modify the tooltip layout and scale."] = "Если флажок установлен, то всплывающие подсказки будут выделены цветом, и у Вас появится возможность изменять их расположение и масштаб."
L["If checked, the worgen sniffing sounds will be muted."] = "Если флажок установлен, то будут отключены звуки обнюхивания у воргенов."
L["If checked, the zone text bar will be hidden.  The tracking button tooltip will show zone information."] = "Если флажок установлен, то название зоны будет скрыто, но все ещё будет появляться во всплывающей подсказке."
L["If checked, the zoom buttons will be hidden.  You can use the mousewheel to zoom regardless of this setting."] = "Если флажок установлен, то кнопки увеличения и уменьшения масштаба у миникарты будут скрыты. Независимо от этой настройки, вы сможете использовать колесо мыши для изменения масштаба."
L["If checked, tooltips for world units will be hidden during combat.|n|nYou can hold the shift key down to override this setting."] = "Если флажок установлен, то подсказки для мировых объектов будут скрыты во время боя.|n|nВы можете удерживать клавишу SHIFT для временного игнорирования этой настройки."
L["If checked, train sounds will be muted."] = "Если флажок установлен, то все звуки поездов будут отключены."
L["If checked, traveling merchant greetings and farewells will be muted.|n|nThis applies to Traveler's Tundra Mammoth, Grand Expedition Yak and Mighty Caravan Brutosaur."] = "Если установлен этот флажок, то сопровождающие вас путешественники (торговцы, аукционеры, трансмогрификаторы и т.д.) больше не будут произносить голосовых приветствий и прощаний.|n|nЭто относится к Тундровому мамонту путешественника, Большому экспедиционному яку и Могучему вьючному брутозавру."
L["If checked, unit targets will be shown."] = "Если флажок установлен, то будет отображаться цель цели."
L["If checked, weekly quests will not be accepted automatically."] = "Если этот флажок установлен, доступные еженедельные задания не будут приниматься автоматически."
L["If checked, Wowhead links will be shown in the world map frame and the achievements frame."] = "Если флажок установлен, то в окне карты миры и в окне достижений будут отображаться ссылки на Wowhead."
L["If checked, Xiwyllag ATV will be muted."] = "Если флажок установлен, то все звуки везделета \"Скивиллаг\" будут отключены."
L["If checked, you can hold down the alt key while opening a gossip window to automatically select a single gossip option."] = "Если флажок установлен, то вы можете удерживать клавишу Alt при открытии окна диалога, чтобы автоматически выбрать один из вариантов ответа."
L["If checked, you can hold down the control key and click a chat tab to view recent chat in a copy-friendly window."] = "Если флажок установлен, то удерживая нажатой клавишу CTRL и щелкнув по закладке чата, вы сможете просмотреть последние записи чата в отдельном окне, из которого сможете легко скопировать текст."
L["If checked, you can open Leatrix Plus by pressing CTRL/Z."] = "Если флажок установлен, то вы сможете открыть Leatrix Plus, нажав CTRL+Z."
L["If checked, you can press the arrow keys to move the insertion point left and right in the chat frame.|n|nIf unchecked, the arrow keys will use the default keybind setting."] = "Если флажок установлен, то вы сможете нажимать кнопки со стрелками для перемещения курсора влево и вправо в окне чата.|n|nЕсли флажок снят, то клавиши со стрелками будут использовать настройки назначения клавиш по умолчанию."
L["If checked, you will be able to cancel cinematics without being prompted for confirmation."] = "Если флажок установлен, то вы сможете пропускать ролики без подтверждения."
L["If checked, you will be able to change the font size of quest text.|n|nEnabling this option will also change the text size of other frames which inherit the same font (such as the Dungeon Finder frame)."] = "Если флажок установлен, то вы сможете изменить размер шрифта текста задания.|n|nВключение этого параметра будет влиять на размер текста других окон, наследующих один и тот же шрифт (например, окно поиска подземелий)."
L["If checked, you will be able to change the font size of standard mail text.|n|nThis does not affect mail created using templates (such as auction house invoices)."] = "Если флажок установлен, вы сможете изменить размер шрифта текста в почтовых сообщениях (письмах).|n|nЭта настройка не будет иметь силы для писем созданных по шаблону (к примеру писем с аукциона)."
L["If checked, you will be able to change the position and scale of the buffs frame."] = "Если этот флажок установлен, у вас будет возможность изменять расположение и размеры фрейма баффов"
L["If checked, you will be able to change the position and scale of the player alternative power bar."] = "Если флажок установлен, то вы сможете управлять положением и масштабом альтернативной панели каста игрока"
L["If checked, you will be able to change the position and scale of the player frame, target frame, ghost frame and timer bar."] = "Если флажок установлен, то вы сможете управлять положением и масштабом фрейма игрока, фрейма цели и панели таймера."
L["If checked, you will be able to change the position and scale of the widget frame.|n|nThe widget frame is commonly used for showing PvP scores and tracking objectives."] = "Если флажок установлен, то вы сможете управлять положением и масштабом виджетов.|n|nВиджеты обычно используются для отображения результатов PvP и отслеживания целей."
L["If checked, you will be able to customise the minimap."] = "Если флажок установлен, то вы сможете настроить миникарту."
L["If checked, you will be able to drag the chat frame to the edge of the screen."] = "Если флажок установлен, то вы сможете переместить рамку чата к краю экрана."
L["If checked, you will be able to mute a selection of game sounds."] = "Если флажок установлен, то вы можете отключить звук в игре."
L["If checked, you will be able to place up to five beneficial cooldown icons above the target frame."] = "Если флажок установлен, то вы сможете разместить до пяти иконок восстановления над фреймом цели."
L["If checked, you will be able to reposition the tooltip."] = "Если флажок установлен, то вы сможете изменять положение всплывающей подсказки."
L["If checked, you will be able to save your current battle pet team (including abilities) to a single command.|n|nA button will be added to the Pet Journal.  Clicking the button will toggle showing the assignment command for your current team.  Pressing CTRL/C will copy the command to memory.|n|nYou can then paste the command (with CTRL/V) into the chat window or a macro to instantly assign your team."] = "Если флажок установлен, то вы сможете сохранить текущий состав питомцев (включая их выбранные в настоящий момент способности) в одну команду.|n|nКнопка будет добавлена в журнал питомцев. Щелчок по кнопке покажет дополнительные операции для вашей текущей команды. При нажатии CTRL+C команда будет скопирована в память.|n|nВы можете вставить команду (с помощью CTRL+V) в окно чата или макроса для мгновенного выбора команды."
L["If checked, you will be able to set the density of weather effects."] = "Если флажок установлен, вы сможете установить плотность погодных эффектов."
L["If checked, you will be able to show a rare, elite or rare elite chain around the player frame."] = "Если флажок установлен, то вы сможете изменить контур рамки своего персонажа с обычного на редкий, элитный или редко-элитный."
L["If checked, you will be able to show customisable borders around the edges of the screen.|n|nThe borders are placed on top of the game world but under the UI so you can place UI elements over them."] = "Если флажок установлен, вы сможете показывать настраиваемые границы по краям экрана.|n|nГраницы располагаются поверх слоя игрового мира, но под слоем пользовательского интерфейса, поэтому вы сможете размещать над границами элементы пользовательского интерфейса."
L["If checked, you will be able to zoom out to a greater distance."] = "Если флажок установлен, то вы сможете максимально отдалять камеру."
L["If checked, you will need to hold the shift key down for quests to be automated.|n|nIf unchecked, holding shift will prevent quests from being automated."] = "Если этот флажок установлен, вам нужно будет удерживать клавишу shift нажатой, чтобы задания были автоматизированы.|n|nЕсли этот флажок не установлен, удержание shift предотвратит автоматизацию заданий."
L["If checked, you will release automatically after you die in Ashran, Tol Barad (PvP), Wintergrasp or any battleground.|n|nYou will not release automatically if you have the ability to self-resurrect (soulstone, reincarnation, etc)."] = "Если флажок установлен, то вы будете автоматически возрождаться после смерти в Ашране, Тол Бараде (PvP), Озеро Ледяных Оков или на любом другом поле битвы.|N|nОднако, вы не возродитесь автоматически, если у вас есть возможность самовоскрешения (камень души, реинкарнация и т. д.)."
L["If checked, your bags will not be opened or closed automatically when you interact with a merchant, bank or mailbox."] = "Если флажок установлен, то ваши сумки не будут открываться или закрываться автоматически, когда Вы взаимодействуете с торговцами, банком или почтовым ящиком."
L["If checked, your chat history will increase to 4096 lines.  If unchecked, the default will be used (128 lines).|n|nEnabling this option may prevent some chat text from showing during login."] = "Если флажок установлен, история чата увеличится до 4096 строк. Если флажок снят, будут использовать настройки по умолчанию (128 строк).|n|nВключение этой настройки может помешать отображению некоторого текста во время входа в игру."
L["If checked, your gear will be repaired automatically when you visit a suitable merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "Если флажок установлен, то ваше снаряжение будет починено автоматически, когда вы поговорите с подходящим торговцем.|n|nВы можете удерживать клавишу Shift, перед разговором, чтобы временно игнорировать данную настройку."
L["If checked, zone text will not be shown (eg. 'Ironforge')."] = "Если флажок установлен, то текст названия зоны не будет отображаться (напр., 'Стальгорн')."
L["Increase chat history"] = "Увеличить историю чата"
L["Interface"] = "Интерфейс"
L["Into the Portal"] = "В портал"
L["Invalid battle pet team parameter."] = "Недопустимый параметр для команды боевых питомцев."
L["Invalid console variable."] = "Недопустимая консольная переменная."
L["Invalid parameter."] = "Неверный параметр."
L["Invalid quest ID."] = "Недопустимый идентификатор квеста."
L["Invalid sound ID"] = "Недопустимый идентификатор звука"
L["Invalid taint level."] = "Неверный уровень заражения."
L["Invalid target."] = "Неверная цель."
L["Invite from whispers"] = "Приглашать по шепоту"
L["Iron Docks"] = "Железные доки"
L["Island Expeditions"] = "Островные Экспедиции"
L["Isle of Conquest"] = "Остров Завоеваний"
L["Isle of Quel'Danas"] = "Остров Кель'Данас"
L["Isle of Thunder"] = "Остров Грома"
L["Jade Forest"] = "Нефритовый лес"
L["Jade Forest Crash"] = "Крушение Нефритового леса"
L["Jaina Joins the Battle"] = "Джайна присоединяется к битве"
L["Jaina Returns to Kul Tiras"] = "Классный отказ с возвращением Джайны"
L["Jaina's Nightmare"] = "Джайнский кошмар"
L["Jaina's Siege"] = "Осада Джайны"
L["Jaina's Theme"] = "Тема Джайны"
L["Jorundall"] = "Йорундалль"
L["Kalimdor"] = "Калимдор"
L["Karazhan"] = "Каражан"
L["Keyword"] = "Ключевое слово"
L["Kezan"] = "Кезан"
L["Kil'jaeden's Downfall"] = "Падение Кил'джедена"
L["Kings' Rest"] = "Гробница королей"
L["Krasarang Wilds"] = "Красарангские джунгли"
L["Krokuun (Argus)"] = "Крокуун (Аргуса)"
L["Kul Tiran Humans"] = "Кул Тир Люди"
L["Kul Tiras"] = "Кул-Тирас"
L["Kun-Lai Summit"] = "Вершина Кунь-Лай"
L["Last Stand"] = "Последний рубеж"
L["Leatrix Plus will not overwrite LeaPlusDB at next logout."] = "Leatrix Plus не будет перезаписывать LeaPlusDB при следующем выходе из системы."
L["LEATRIX PLUS: WRONG VERSION INSTALLED!"] = "LEATRIX MAPS: УСТАНОВЛЕНА НЕПРАВИЛЬНАЯ ВЕРСИЯ!"
L["Leaving Kezan"] = "Покидая Кезан"
L["Leaving the Wandering Isle"] = "Покидая Блуждающий остров"
L["Left"] = "Левая"
L["Legion"] = "Legion"
L["Lifetime honorable kills"] = "Всего почетных побед"
L["Lightforged Draenei"] = "Озаренный дреней"
L["Lion's Watch"] = "Львиный дозор"
L["Loch Modan"] = "Лок Модан"
L["Lockout sharing"] = "Совмесная блокировка"
L["Lost City of the Tol'vir"] = "Затерянный город Тол'вир"
L["Lost Isles"] = "Затерянные острова"
L["Low"] = "Низко"
L["Lunastre Estate"] = "Поместье Лунархов"
L["Mac'Aree (Argus)"] = "Мак'Ари (Аргуса)"
L["Madness of Deathwing"] = "Безумие Смертокрыла"
L["Maelstrom"] = "Водоворот"
L["Mag'har Orcs"] = "Маг'хар Орки"
L["Magisters' Terrace"] = "Терраса Магистров"
L["Magtheridon's Lair"] = "Логово Магтеридона"
L["Main Titles"] = "Главные названия"
L["Manage buffs"] = "Управление баффами"
L["Manage frames"] = "Управление рамками"
L["Manage power bar"] = "Управление панелью каста"
L["Manage widget"] = "Управление виджетами"
L["Managed by Leatrix Plus"] = "Управляется Leatrix Plus"
L["Mana-Tombs"] = "Гробницы Маны"
L["Maraudon"] = "Мародон"
L["Maraudon: Earth Song Falls"] = "Мародон (Поющие водопады)"
L["Maraudon: Foulspore Cavern"] = "Мародон (Зловонная пещера)"
L["Maraudon: The Wicked Grotto"] = "Мародон (Оскверненный грот)"
L["Mardum"] = "Мардум"
L["Maw of Souls"] = "Утроба душ"
L["Max camera zoom"] = "Max отдаление камеры"
L["Mechagon"] = "Мехагон"
L["Mechanics"] = "Механика"
L["Media"] = "Медиа"
L["Medium"] = "Средняя"
L["Memory Usage"] = "Использовано памяти"
L["message shown."] = "сообщение показано."
L["messages shown."] = "сообщения показаны."
L["Missing console variable."] = "Отсутствует переменная консоли."
L["Missing mount name."] = "Отсутствует имя маунта."
L["Missing movie ID."] = "Отсутствует ID видео-ролика."
L["Missing pet name."] = "Отсутствует имя питомца."
L["Missing quest ID."] = "Отсутствует идентификатор квеста."
L["Missing sound file parameter."] = "Отсутствует параметр звукового файла."
L["Missing sound ID."] = "Отсутствует идентификатор звука."
L["Mists of Pandaria"] = "Mists of Pandaria"
L["Mogu'shan Palace"] = "Дворец Могу'шан"
L["Mogu'shan Vaults"] = "Подземелья Могу'шан"
L["Molten Core"] = "Огненные Недра"
L["Moon Guard Stronghold"] = "Цитадель Лунных стражей"
L["Moonglade"] = "Лунная поляна"
L["Motherlode"] = "Золотая жила"
L["Mount Hyjal"] = "Гора Хиджал"
L["Mount not found."] = "Гора не найдена."
L["Mounts"] = "Ездовые животные"
L["Move editbox to top"] = "Поле ввода над чатом"
L["Movie not playable."] = "Видео-ролик не может быть воспроизведён."
L["Movie number"] = "Номер видео-ролика"
L["Movies"] = "Видео-ролики"
L["Mulgore"] = "Мулгор"
L["Music"] = "Музыка"
L["Music Rolls"] = "Музыкальные роллы"
L["Mute game sounds"] = "Отключить звуки игры"
L["My Very Own Castle (Alliance)"] = "Мой собственный замок (Альянс)"
L["My Very Own Castle (Horde)"] = "Мой собственный замок (Орда)"
L["Mystical"] = "мистический"
L["Nagrand"] = "Награнд"
L["Nagrand (Draenor)"] = "Награнд (Дренор)"
L["Narration"] = "пересказ"
L["Naxxramas"] = "Наксрамас"
L["Nazjatar"] = "Рядом"
L["Nazmir"] = "Назмир"
L["Neltharion's Lair"] = "Логово Нелтариона"
L["Netherstorm"] = "Пустоверть"
L["Nexus"] = "Нексус"
L["Nightborne"] = "Ночнорожденный"
L["Nighthold"] = "Цитадель Ночи"
L["No bad sound IDs found."] = "Не найдено плохих идентификаторов звука."
L["No help is available for this page."] = "Справка недоступна для этой страницы."
L["No items with durability equipped."] = "Нет предметов с долговечностью."
L["No media duplicates found."] = "Дубликаты медиа не найдены."
L["No tooltip showing."] = "Нет всплывающих подсказок для отображения."
L["None"] = "Никто"
L["Northern Barrens"] = "Северные степи"
L["Northern Stranglethorn"] = "Северная Тернистая долина"
L["Northrend"] = "Нордскол"
L["Not completed."] = "Не завершено."
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Plus."] = "ВНИМАНИЕ!|nВы должны полностью перезапустить свой игровой клиент, прежде чем использовать эту версию Leatrix Plus."
L["Nude"] = "Раздеться"
L["Ny'alotha"] = "Ни'алота"
L["Obsidian Sanctum"] = "Обсидиановое святилище"
L["Oculus"] = "Окулус"
L["Off"] = "Выкл."
L["Okay, disable Dominos Encounter for me"] = "Окей, отключите для меня Dominos Encounter"
L["Okay, disable screen adjust for me"] = "Ладно, отключите настройку экрана для меня"
L["Old Hillsbrad Foothills"] = "Старые предгорья Хилсбрада"
L["Onyxia's Lair"] = "Логово Ониксии"
L["Operation Mechagon"] = "Операция Мехагон"
L["Orgrimmar"] = "Оргриммар"
L["Outland"] = "Запределье"
L["Overall"] = "Всего"
L["Overlay"] = "Оверлей"
L["Pandaria"] = "Пандария"
L["Particle density"] = "Плотность частиц"
L["Party from friends"] = "Приглашения от друзей"
L["Pet"] = "Питомец"
L["Pet Battles"] = "Битвы питомцев"
L["Pet not found.  Only owned pets that are currently showing in the journal can be searched."] = "Пэт не найден. Только те домашние животные, которые в данный момент отображаются в журнале, могут быть найдены."
L["Pit of Saron"] = "Яма Сарона"
L["Plants vs Zombies"] = "Растения против Зомби"
L["Player"] = "Персонаж"
L["Portal"] = "Портал"
L["Power"] = "Мощность"
L["Power of the Horde"] = "Сила Орды"
L["Press CTRL/C to copy."] = "Нажмите CTRL/C, чтобы скопировать."
L["Queue from friends"] = "Очереди от друзей"
L["Ragefire Chasm"] = "Огненная Пропасть"
L["Raid"] = "Рейд"
L["Raid frame toggle"] = "Переключатель рейд. рамки"
L["Random"] = "Случайно"
L["RARE"] = "Редкий"
L["RARE ELITE"] = "Редкий элитный"
L["Razorfen Downs"] = "Курганы Иглошкурых"
L["Razorfen Kraul"] = "Лабиринты Иглошкурых"
L["Ready"] = "Готовность"
L["Realm Of Torment"] = "Царство мучений"
L["Recent chat window"] = "Окно недавнего чата"
L["Reckoning"] = "Расплата"
L["Redridge Mountains"] = "Красногорье"
L["Reincarnation of Alleria Windrunner"] = "Реинкарнация Аллерии Виндраннер"
L["Rejection of the Gift"] = "Отказ от подарка"
L["Release in PvP"] = "Покидание тела в PvP"
L["Reload"] = "Перезагрузить"
L["Remove raid restrictions"] = "Снять ограничения рейда"
L["Repair automatically"] = "Ремонт снаряжения"
L["Repair using guild funds if available"] = "Ремонт за счет средств гильдии, если возможно."
L["Repaired for"] = "Стоимость ремонта"
L["Reposition the tooltip"] = "Переместите подсказку"
L["Require shift key for quest automation"] = "Требуется клавиша shift для автоматизации задания"
L["Requires UI reload."] = "Требуется перезагрузка интерфейса (UI)."
L["Requires you to be interacting with Larana Drome.  She can be found at Scribes' Sacellum, Dalaran, Northrend."] = "Требует, чтобы вы взаимодействовали с Larana Drome. Ее можно найти в Sacellum Писцов, Даларан, Нордскол."
L["Reset"] = "Сброс настроек"
L["Resize mail text"] = "Размер текста писем"
L["Resize quest text"] = "Размер текста заданий"
L["Rested bubbles"] = "Бонус отдыха"
L["Restrict to friends and guild members"] = "Только для друзей и членов гильдии"
L["result"] = "результат"
L["results"] = "Результаты"
L["Return to Karazhan"] = "Транспорт: флагманский корабль Легиона"
L["Return to the Black Temple"] = "Возвращение в Черный храм"
L["Right"] = "Правая"
L["Right-click to close"] = "Щелчок ПКМ, чтобы закрыть"
L["Right-click to close."] = "Щелчок ПКМ, чтобы закрыть."
L["right-click to go back"] = "Щелчок ПКМ, чтобы вернуться"
L["Rise of Argus"] = "Восстание Аргуса"
L["Rise of Azshara"] = "Восстание Азшары"
L["Risking It All"] = "Рискнуть всем"
L["Ruby Sanctum"] = "Рубиновое святилище"
L["Ruins of Ahn'Qiraj"] = "Руины Ан'Киража"
L["Ruins of Elune'eth"] = "Руины Элун'ета"
L["Ruins of Gilneas"] = "Руины Гилнеаса"
L["Sanctum of Order"] = "Святилище Порядка"
L["Save profession filters"] = "Сохранить фильтры профессий"
L["Scale"] = "Масштаб"
L["Scarlet Halls"] = "Залы Алого ордена"
L["Scarlet Monastery"] = "Монастырь Алого ордена"
L["Scholomance"] = "Некроситет"
L["Search"] = "Поиск"
L["Searing Gorge"] = "Тлеющее ущелье"
L["Seat of the Triumvirate"] = "Престол Триумвирата"
L["Select the settings that you want to use."] = "Выберите параметры, которые вы хотите использовать."
L["Selection of music tracks"] = "Подборка музыкальных треков"
L["Self Markers Allowed"] = "Разрешены самомаркировки"
L["Self Markers Blocked"] = "Заблокированные маркеры"
L["Sell junk automatically"] = "Продажа хлама из сумок"
L["SELLING JUNK"] = "ПРОДАЮ ХЛАМ"
L["Serpentshrine Cavern"] = "Змеиное святилище"
L["Set weather density"] = "Плотность погодных эффектов"
L["Sethekk Halls"] = "Сетеккские залы"
L["Settings"] = "Параметры"
L["Shaders"] = "Тени"
L["Shado-Pan Monastery"] = "Монастырь Шадо-Пан"
L["Shadow Labyrinth"] = "Темный лабиринт"
L["Shadowfang Keep"] = "Крепость Темного Клыка"
L["Shadowmoon Burial Grounds"] = "Некрополь Призрачной Луны"
L["Shadowmoon Valley"] = "Долина Призрачной Луны"
L["Shadowmoon Valley (Draenor)"] = "Долина Призрачной Луны (Дренор)"
L["Shipyard Construction (Alliance)"] = "Судостроительный завод (Альянс)"
L["Shipyard Construction (Horde)"] = "Строительство верфи (Орда)"
L["Sholazar Basin"] = "Низина Шолазар"
L["Shouts"] = "Боевые крики"
L["Show borders"] = "Показывать границы"
L["Show character addons"] = "Модификации для игрока"
L["Show cooldowns"] = "Показать перезарядки"
L["Show durability status"] = "Прочность экипировки"
L["Show guild ranks for your guild"] = "Отображать ранги для Вашей гильдии"
L["Show minimap button"] = "Кнопка у миникарты"
L["Show pet save button"] = "Состав питомцев"
L["Show player chain"] = "Контур рамки персонажа"
L["Show player frame in class color"] = "Показывать фрейм игрока в цвете класса"
L["Show raid button"] = "Показать кнопку рейда"
L["Show target frame and focus frame in class color"] = "Показывать фреймы цели и фокуса в цвете класса"
L["Show the spell ID in buff icon tooltips"] = "Показать идентификатор заклинания во всплывающих подсказках"
L["Show the unit's target"] = "Отображать цель цели"
L["Show volume slider"] = "Регулятор громкости"
L["Show Wowhead links"] = "Ссылки на Wowhead"
L["Shrine of the Storm"] = "Святилище Штормов"
L["Siege of Boralus"] = "Осада Боралуса"
L["Siege of Dazar'alor"] = "Штурм Дазар'алора"
L["Siege of Niuzao Temple"] = "Осада храма Нюцзао"
L["Siege of Orgrimmar"] = "Осада Оргриммара"
L["Silence rested emotes"] = "Заглушать звуки эмоций"
L["Silithus"] = "Силитус"
L["Silverpine Forest"] = "Серебряный бор"
L["Silvershard Mines"] = "Сверкающие копи"
L["Skyreach"] = "Небесный Путь"
L["Slave Pens"] = "Узилище"
L["Sniffing"] = "Обнюхивание"
L["Social"] = "Общение"
L["Sold junk for"] = "Проданный мусор для"
L["Sound system restarted."] = "Звуковая система перезапустилась."
L["Southern Barrens"] = "Южные степи"
L["Spell ID"] = "ID закл."
L["Spine of Deathwing"] = "Хребет Смертокрыла"
L["Spires of Arak"] = "Пики Арака"
L["Steamvault"] = "Паровое подземелье"
L["Stockade"] = "Тюрьма"
L["Stonecore"] = "Каменные Недра"
L["Stonetalon Mountains"] = "Когтистые горы"
L["Stop"] = "Стоп"
L["Storm Peaks"] = "Грозовая гряда"
L["Stormheim"] = "Штормхейм"
L["Stormheim (Alliance)"] = "Штормхейм (Альянс)"
L["Stormheim (Horde)"] = "Штормхейм (Орда)"
L["Stormsong Valley"] = "Долина Штормов"
L["Stormstout Brewery"] = "Хмелеварня Буйных Портеров"
L["Stormwind"] = "Штормград"
L["Strand of the Ancients"] = "Берег Древних"
L["Stratholme"] = "Стратхольм"
L["Stratholme: Crusader's Square"] = "Стратхольм: площадь крестоносцев"
L["Stratholme: The Gauntlet"] = "Стратхольм: рукавица"
L["Sunken Temple"] = "Затонувший храм"
L["Sunwell Plateau"] = "Плато Солнечного Колодца"
L["Support"] = "Поддержка"
L["Suramar"] = "Сурамар"
L["Swamp of Sorrows"] = "Болото печали"
L["Sync from friends"] = "Синхронизация групп"
L["System"] = "Система"
L["Tabard"] = "Накидка"
L["Taint level: Basic (1)."] = "Уровень запаха: базовый (1)."
L["Taint level: Disabled (0)."] = "Уровень заражения: отключен (0)."
L["Taint level: Full (2)."] = "Уровень заражения: Полный (2)."
L["Talador"] = "Таладор"
L["Tanaan Jungle"] = "Танаанские джунгли"
L["Tanaris"] = "Танарис"
L["Target"] = "Цель"
L["Target Tracking Disabled"] = "Отслеживание цели отключено"
L["Target Tracking Enabled"] = "Отслеживание цели включено"
L["Tea with Jaina"] = "Чай с джайной"
L["Tel'anor"] = "Тел'анор"
L["Teldrassil"] = "Тельдрассил"
L["Tempest Keep"] = "Крепость Бурь"
L["Temple of Ahn'Qiraj"] = "Храм Ан'Кираж"
L["Temple of Atal'Hakkar"] = "Храм Атал'Хаккара"
L["Temple of Sethraliss"] = "Храм Сетралисс"
L["Temple of the Jade Serpent"] = "Храм Зин-Малор"
L["Ten Years of Warcraft"] = "Десять лет варкрафта"
L["Terokkar Forest"] = "Лес Тероккар"
L["Terrace of Endless Spring"] = "Терраса Вечной Весны"
L["Terror of Darkshore"] = "Террор Темного берега"
L["Text"] = "Текст"
L["Text size"] = "Размер текста"
L["Text Size"] = "Размер текста"
L["The Art of War"] = "Искусство войны"
L["The Battle for Broken Shore"] = "Битва за Расколотый берег"
L["The Battle for Shattrath"] = "Битва за Шаттрат"
L["The Battle of Thunder Pass"] = "Хребет Ледяного Огня"
L["The Burning Crusade"] = "The Burning Crusade"
L["The Demon's Trail"] = "По следу демона"
L["The Dragon Soul"] = "Душа Дракона"
L["The Eye"] = "Око"
L["The Fall of Lordaeron"] = "Падение Лордерона"
L["The Fate of Val'sharah"] = "Судьба Валь'шары"
L["The Fleet in Krasarang (Alliance)"] = "Флот в Красаранге (Альянс)"
L["The Fleet in Krasarang (Horde)"] = "Флот в Красаранге (Орда)"
L["The Frozen Halls"] = "Ледяные залы"
L["The Invasion Begins"] = "Атака начинается"
L["The King's Command"] = "Приказ короля"
L["The Negotiation"] = "Переговоры"
L["The Nightborne Pact"] = "Пакт ночнорожденных"
L["The Nighthold"] = "Цитадель Ночи"
L["The Return of Hope"] = "Возвращение надежды"
L["The summon from"] = "Призыв для"
L["The Threat Within"] = "Внутренняя угроза"
L["The Waning Crescent"] = "Лунный полумрак"
L["Themes"] = "Темы"
L["This command will assign your current pet team and selected abilities.|n|nPress CTRL/C to copy the command then paste it into a macro or chat window with CTRL/V."] = "Эта операция назначит текущую команду боевых питомцев и их способности.|n|nНажмите CTRL/C чтобы скопировать команду. После этого Вы сможете ее вставить в окно чата или макроса с помощью CTRL/V."
L["This panel will close automatically if you enter combat."] = "Это окно будет автоматически закрыто, если Вы вступите в бой."
L["Thousand Needles"] = "Тысяча Игл"
L["Throne of the Four Winds"] = "Трон Четырех Ветров"
L["Throne of the Tides"] = "Трон Приливов"
L["Throne of Thunder"] = "Престол Гроз"
L["Thunder Bluff"] = "Громовой Утес"
L["Timeless Isle"] = "Вневременный остров"
L["Timer"] = "Таймер"
L["Tiragarde Sound"] = "Тирагардское поморье"
L["Tirisfal Glades"] = "Тирисфальские леса"
L["Titan Panel screen adjust needs to be disabled for frames to be saved correctly."] = "Titan Panel настройки экрана должны быть отключены для правильного сохранения кадров."
L["To begin, choose an options page."] = "Для начала выберите страницу настроек."
L["To hide the combat log, you need to disable the chat module in ElvUI."] = "Чтобы скрыть журнал боя, вам нужно отключить модуль чата в ElvUI."
L["To use the Find Item button, you need to deselect the WoW Token category."] = "Чтобы использовать кнопку «Найти предмет», вам нужно отменить выбор категории токена."
L["Tol Barad"] = "Тол Барад"
L["Tol Dagor"] = "Тол Дагор"
L["Tomb of Sargeras"] = "Гробница Саргераса"
L["Tooltip"] = "Подсказки"
L["Tooltip title color"] = "Цвет заголовка всплывающей подсказки"
L["Top"] = "Верхняя"
L["Top Center"] = "Верхний центральный"
L["Townlong Steppes"] = "Танлунские степи"
L["Tracing started."] = "Отслеживание началось."
L["Tracing stopped."] = "Трассировка остановилась."
L["Trains"] = "Поезда"
L["Transparency"] = "Прозрачность"
L["Travelers"] = "Путешественники"
L["Trial of Style"] = "Наденьте это немедленно!"
L["Trial of the Champion"] = "Испытание чемпиона"
L["Trial of the Crusader"] = "Испытание крестоносца"
L["Trial of Valor"] = "Испытание доблести"
L["True"] = "Правда"
L["Turn-in completed quests automatically"] = "Сдавать выполненные квесты автоматически"
L["Twilight Highlands"] = "Сумеречное нагорье"
L["Twilight Vineyards"] = "Сумеречные виноградники"
L["Twin Peaks"] = "Два Пика"
L["Uldaman"] = "Ульдаман"
L["Uldir"] = "Ульдир"
L["Ulduar"] = "Ульдуар"
L["Uldum"] = "Ульдум"
L["Unclamp chat frame"] = "Открепить окно чата"
L["Underbog"] = "Нижетопь"
L["Undercity"] = "Подгород"
L["Underrot"] = "Подгнилье"
L["Un'Goro Crater"] = "Кратер Ун'Горо"
L["Universal group color"] = "Единый цвет текста групп"
L["Use arrow keys in chat"] = "Использовать кнопки в чате"
L["Use easy resizing"] = "Лёгкое изменение размера"
L["Use Leatrix Plus to move that frame."] = "Используйте Leatrix Plus, чтобы переместить эту рамку."
L["Use Leatrix Plus to reset that frame."] = "Используйте Leatrix Plus, чтобы сбросить положение этой рамки."
L["Utgarde Keep"] = "Крепость Утгард"
L["Utgarde Pinnacle"] = "Вершина Утгард"
L["Vale of Eternal Blossoms"] = "Вечноцветущий дол"
L["Valley of the Four Winds"] = "Долина Четырех Ветров"
L["Val'sharah"] = "Валь'шара"
L["Value must be a number."] = "Значение должно быть числом."
L["Various"] = "Разное"
L["Vashj'ir"] = "Вайш'ир"
L["Vault of Archavon"] = "Склеп Аркавона"
L["Vault of the Wardens"] = "Казематы Стражей"
L["Vaults"] = "Хранилища"
L["Vendors"] = "Продавцы"
L["Version"] = "Версия"
L["Victory at The Nighthold"] = "Победа в Ночной Гавани"
L["Victory in Draenor!"] = "Победа в Дреноре!"
L["Video"] = "видео"
L["Violet Hold"] = "Аметистовая крепость"
L["Visibility"] = "Видимость"
L["Vision of Sailor's Memory"] = "Видение Памяти Матроса"
L["Visions of N'Zoth"] = "Видения Н'Зота"
L["Void Elves"] = "Пустые эльфы"
L["Vol'dun"] = "Вол'дун"
L["Vol'mar"] = "Вол'мар"
L["Wailing Caverns"] = "Пещеры Стенаний"
L["Wandering Isle"] = "Скитающийся остров"
L["Warbringers Azshara"] = "Воительницы Азшара"
L["Warbringers Jaina"] = "Воительницы Джейна"
L["Warbringers Sylvanas"] = "Воительницы Сильваны"
L["Warfronts"] = "фронтовые"
L["Warlords of Draenor"] = "Warlords of Draenor"
L["Warning"] = "Предупреждение"
L["was automatically declined."] = "был автоматически отклонён."
L["Waycrest Manor"] = "Усадьба Уэйкрестов"
L["Weather density"] = "Плотность погоды"
L["Welcome to Leatrix Plus."] = "Добро пожаловать в Leatrix Plus."
L["Well of Eternity"] = "Источник Вечности"
L["Western Plaguelands"] = "Западные Чумные земли"
L["Westfall"] = "Западный Край"
L["Wetlands"] = "Болотина"
L["Widget"] = "Виджет"
L["will be automatically accepted in 10 seconds unless cancelled."] = "будет автоматически принят в течение 10 секунд, если не будет отменен."
L["Winter"] = "зима"
L["Wintergrasp"] = "Озеро Ледяных Оков"
L["Winterspring"] = "Зимние Ключи"
L["World of Warcraft"] = "World of Warcraft"
L["Wrath of the Lich King"] = "Гнев Короля-лича"
L["Wyrmrest Temple"] = "Храм Драконьего Покоя"
L["X Offset"] = "Х Смещение"
L["Y Offset"] = "Y Смещение"
L["YOU"] = "ВЫ"
L["You cannot do that in combat."] = "Вы не можете сделать это в бою."
L["You do not own this pet.  Only owned pets can be searched."] = "Вы не являетесь владельцем этого питомца. Только принадлежащие домашние животные могут быть найдены."
L["You have"] = "У Вас"
L["You need a battle pet team."] = "Вам нужна команда боевых питомцев."
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "Вам нужно перезагрузить пользовательский интерфейс (UI), чтобы некоторые внесенные вами изменения вступили в силу.|n|nВы можете выполнить перезагрузку не сразу, а когда полностью завершите работу с настройками."
L["Your UI needs to be reloaded."] = "Вам необходимо перезагрузить пользовательский интерфейс."
L["Zandalar"] = "Зандалар"
L["Zandalari Trolls"] = "Тролли зандалари"
L["Zangarmarsh"] = "Зангартопь"
L["Zones"] = "Зоны"
L["Zul'Aman"] = "Зул'Аман"
L["Zuldazar"] = "Зулдазар"
L["Zul'Drak"] = "Зул'Драк"
L["Zul'Farrak"] = "Зул'Фаррак"
L["Zul'Gurub"] = "Зул'Гуруб"
L["Zygor addon not found."] = "Модификация Zygor не найдена."

end

-- koKR: Korean
if GameLocale == "koKR" then
L["A Deal with Death"] = "A Deal with Death"
L["A Falling Star"] = "떨어지는 별"
L["A Found Memento"] = "찾아낸 기억의 조각"
L["A friend request from"] = "친구 신청"
L["A New Life for Undeath"] = "죽지 않는자에게 새 생명을"
L["A Taste of Iron"] = "강철의 맛"
L["Accept available quests automatically"] = "퀘스트 자동 수락"
L["Accept resurrection"] = "부활 수락"
L["Accept summon"] = "소환 수락"
L["Account achievements are being shared."] = "계정 업적을 공유하고 있습니다."
L["Account achievements are hidden."] = "계정 업적을 숨깁니다."
L["Addon"] = "애드온"
L["Adventure"] = "모험"
L["Ahn'kahet (Old Kingdom)"] = "안카헤트(고대왕국)"
L["All 3 battle pet slots need to be unlocked."] = "3개의 애완동물 슬롯을 잠금 해제하여야 합니다."
L["Allied Races"] = "동맹 종족"
L["An Unexpected Reunion"] = "뜻밖의 재회"
L["Anchor"] = "앵커"
L["And Justice for Thrall"] = "스랄의 정의"
L["Anduin's Theme"] = "안두인 테마"
L["Antoran Wastes (Argus)"] = "안토란 황무지(아르거스)"
L["Antorus Ending"] = "안토러스의 결말 "
L["Antorus, the Burning Throne"] = "안토러스-불타는 왕좌"
L["Arathi Highlands"] = "아라시 고원"
L["Arcway"] = "비전로"
L["Arenas"] = "투기장"
L["Arrival on Argus"] = "아르거스의 그림자"
L["Arrival to Zandalar"] = "잔달라에 도착하다"
L["Ashenvale"] = "잿빛 골짜기"
L["Ashran"] = "아쉬란"
L["Assault on the Broken Shore"] = "부서진 해변 공격"
L["Astravar Harbor"] = "아스트라바르 항구"
L["Atal'Dazar"] = "아탈다자르"
L["ATV"] = "만능둥둥이"
L["Auchenai Crypts"] = "아키나이 납골당"
L["Auchindoun"] = "아킨둔"
L["AutoFollow"] = "따라가기 설정됨"
L["AutoFollow disabled."] = "따라가기 해제."
L["Automate gossip"] = "대화 자동 넘김"
L["Automate quests"] = "퀘스트 자동화"
L["Automation"] = "자동화"
L["Azjol-Nerub"] = "아졸네룹"
L["Azshara"] = "아즈샤라"
L["Azshara's Eternal Palace"] = "아즈샤라의 영원한 궁전"
L["Azsuna"] = "아즈스나"
L["Azuremyst Isle"] = "하늘안개 섬"
L["Back to Main Menu"] = "주 메뉴로 돌아가기"
L["Bad ID"] = "잘못된 ID"
L["Badlands"] = "황야의 땅"
L["Balls"] = "축구공"
L["Ban-Lu"] = "반루"
L["Baradin Hold"] = "바라딘 요새"
L["Barrens"] = "남부 불모의 땅"
L["Bastion of Twilight"] = "황혼의 요새"
L["Battle for Azeroth"] = "격전의 아제로스"
L["Battle for Darkshore"] = "어둠해안 전투"
L["Battle for Gilneas"] = "길니아스 전투지"
L["Battle for Stromgarde"] = "스트롬가드 전투"
L["Battle of Angrathar the Wrathgate"] = "앙그라타르.분노의 관문 전투"
L["Battle of Dazar'alor"] = "다자알로 전투"
L["Battle of Serpent's Heart"] = "용의 심장의 전투"
L["Battlegrounds"] = "전장"
L["Bigger is Better (Alliance)"] = "더 크게 더 멋지게(얼라이언스)"
L["Bigger is Better (Horde)"] = "더 크게 더 멋지게(호드)"
L["Bikes"] = "호토바이/붕붕이"
L["Black Morass"] = "검은늪"
L["Black Rook Hold"] = "검은 떼까마귀 요새"
L["Black Temple"] = "검은 사원"
L["Blackfathom Deeps"] = "검은 심연 나락"
L["Blackrock Caverns"] = "검은바위 동굴"
L["Blackrock Depths"] = "검은바위 나락"
L["Blackrock Foundry"] = "검은바위 용광로"
L["Blackrock Mountain"] = "검은바위 산"
L["Blackrock Spire"] = "검은바위 첨탑"
L["Blackwing Descent"] = "검은날개 강림지"
L["Blackwing Lair"] = "검은날개 둥지"
L["Blade's Edge Mountains"] = "칼날 산맥"
L["Blasted Lands"] = "저주받은 땅"
L["Block duels"] = "결투 차단"
L["Block friend requests"] = "친구요청 차단"
L["Block party invites"] = "파티초대 차단"
L["Block pet battle duels"] = "애완동물대전 차단"
L["Blocks"] = "차단"
L["Bloodmaul Slag Mines"] = "피망치 잿가루 광산"
L["Bloodmyst Isle"] = "핏빛안개 섬"
L["Borean Tundra"] = "북풍의 땅"
L["Bottom"] = "하단"
L["Broken Isles"] = "부서진 섬"
L["Broken Shore"] = "부서진 해변"
L["Buffs"] = "버프"
L["Burning Steppes"] = "불타는 평원"
L["Buyout Only"] = "즉시구입가 만!"
L["Camera distance"] = "카메라 거리"
L["Cape of Stranglethorn"] = "가시덤불 곶"
L["Cataclysm"] = "대격변"
L["Cathedral of Eternal Night"] = "영원한 밤의 대성당"
L["Caverns of Time"] = "시간의 동굴"
L["Chain style"] = "테두리 스타일"
L["Character"] = "캐릭터"
L["Chat"] = "채팅"
L["Chat Frame"] = "채팅창"
L["Checkbox labels are Ok."] = "체크박스를 확인합니다."
L["Choose an Enigma pattern"] = "수수께끼 패턴 선택"
L["Cinematics"] = "시네마틱"
L["Class colored frames"] = "유닛프레임 직업색상"
L["Class icon portraits"] = "초상화 직업 아이콘 표시"
L["Class Trials"] = "직업 체험"
L["click here for new selection"] = "목록을 갱신하려면 여기를 클릭하세요."
L["Click to configure the settings for this option."] = "설정을 구성하려면 클릭합니다."
L["Click to disable Dominos Encounter for all characters on this realm.  This is required for the player power bar position to be saved correctly.  Your UI will be reloaded."] = "현 서버 모든 케릭터의  Dominos Encounter 사용을 비활성 합니다. 플레이어 파워바 위치를 바르게 저장 하는데 필요합니다. UI가 리로드 됩니다."
L["Click to reset the settings on this page."] = "이 페이지를 재설정 하려면 클릭합니다."
L["Click to return to the main menu."] = "주 메뉴 돌아가기 클릭"
L["Coilfang Reservoir"] = "갈퀴 송곳니 저수지"
L["Color the backdrops based on faction"] = "진영에 따른 배경색상"
L["Combat"] = "전투"
L["Combat log cannot be hidden while undocked."] = "** 창(일반/전투) 연결이 해제되면 숨길수 없습니다."
L["Combat plates"] = "전투시 이름표 표시"
L["Completed."] = "완료"
L["Configuration Panel"] = "설정창"
L["Connections for"] = "연결된 서버"
L["Court of Stars"] = "별의 궁정"
L["Credits"] = "크레딧"
L["Crucible of Storms"] = "폭풍의 용광로"
L["Crystalsong Forest"] = "수정노래 숲"
L["Culling of Stratholme"] = "옛 스트라솔름"
L["Cursor"] = "커서"
L["Cursor Left"] = "커서 왼쪽"
L["Cursor Right"] = "커서 오른쪽"
L["Dalaran"] = "달라란"
L["Dark Iron Dwarves"] = "검은무쇠 드워프"
L["Dark Soil scanning activated.  Reload UI to exit."] = "어두운 토양 검사 활성화. 리로드-종료."
L["Dark Soil scanning is already activated.  You only need to run this once.  Reload UI to exit."] = "어두운 토양 검사가 이미 활성화됨."
L["Darkheart Thicket"] = "어둠심장 숲"
L["Darkmoon Faire"] = "다크문 축제"
L["Darkness Falls"] = "어둠이 드리운다."
L["Darkshore"] = "어둠해안"
L["Darnassus"] = "다르나서스"
L["Deadmines"] = "죽음의 폐광"
L["Deepholm"] = "심원의 영지"
L["Deepwind Gorge"] = "깊은바람 협곡"
L["Desolace"] = "잊혀진 땅"
L["Destiny Unfulfilled"] = "실현되지 않은 운명"
L["Dire Maul"] = "혈투의 전장"
L["Dire Maul: Capital Gardens"] = "혈투의 전장:수도정원"
L["Dire Maul: Gordok Commons"] = "혈투의 전장:고르독 광장"
L["Dire Maul: Warpwood Quarter"] = "혈투의 전장:굽이나무 지구"
L["Disable bag automation"] = "가방 자동열림 비활성"
L["Disable chat fade"] = "챗 사라짐 비활성"
L["Disable loot warnings"] = "전리품 경고 비활성"
L["Disable pet automation"] = "애완동물 자동 비활성"
L["Disable screen effects"] = "이펙트 비활성"
L["Disable screen glow"] = "빛 효과 비활성"
L["Disable sticky chat"] = "채널고정 사용안함"
L["Disable sticky editbox"] = "입력창 자동 닫힘"
L["Dominos Encounter needs to be disabled."] = "Dominos Encounter 비활성 해야 합니다."
L["Don't accept daily quests automatically"] = "일일퀘스트 자동 수락 제외"
L["Don't accept weekly quests automatically"] = "주간퀘스트 자동 수락 제외"
L["Draenor"] = "드레노어"
L["Drag the frame overlay to position the frame."] = "위치 변경은 프레임 드레그 이동하세요."
L["Drag the frame overlays to position the frames.|n|nTo change the scale of a frame, click it to select it then adjust the scale slider.|n|nThis panel will close automatically if you enter combat."] = "위치는 드레그 이동, 크기는 슬라이더 조정 설정."
L["Drag to set the buffs frame scale."] = "버프 프레임 스케일을 설정하려면 드래그하십시오."
L["Drag to set the cursor X offset."] = "드래그하여 커서 X 오프셋을 설정합니다."
L["Drag to set the cursor Y offset."] = "드래그하여 커서 Y 오프셋을 설정합니다."
L["Drag to set the density of weather effects."] = "날씨 효과의 밀도를 설정하려면 드래그하십시오."
L["Drag to set the font size of mail text."] = "드래그하여 우편 글꼴 크기를 설정하십시오."
L["Drag to set the font size of quest text."] = "드래그하여 퀘스트 글꼴 크기를 설정하십시오."
L["Drag to set the minimap scale.|n|nNote that if you are using the default action bars, rescaling the minimap will also rescale the right action bars at startup so you may want to leave this at 100%."] = "드래그하여 미니맵 크기를 설정하십시오. |n|n블리자드(기본) 액션바를 사용시, 변경후 시작마다 오른쪽 액션바가 다시 조정되므로 100 %로 두는 것이 좋습니다."
L["Drag to set the scale of the Leatrix Plus panel."] = "드래그하여 Leatrix Plus 패널 크기를 설정하십시오."
L["Drag to set the scale of the selected frame."] = "드래그하여 선택된 프레임의 크기를 설정하십시오."
L["Drag to set the size of the bottom border."] = "드래그하여 아래쪽 테두리의 크기를 설정하십시오."
L["Drag to set the size of the left border."] = "드래그하여 왼쪽 테두리의 크기를 설정하십시오."
L["Drag to set the size of the right border."] = "드래그하여 오른쪽 테두리의 크기를 설정하십시오."
L["Drag to set the size of the top border."] = "드래그하여 윗쪽 테두리의 크기를 설정하십시오."
L["Drag to set the tooltip scale."] = "드래그하여 툴팁 크기를 설정하십시오."
L["Drag to set the transparency of the borders."] = "드래그하여  테두리의 투명도를 설정하십시오."
L["Drag to set the transparency of the Leatrix Plus panel."] = "드래그하여 Leatrix Plus 패널의 투명도를 설정하십시요."
L["Dragon Soul"] = "용의 영혼"
L["Dragonblight"] = "용의 안식처"
L["Drak'Tharon Keep"] = "드락타론 성채"
L["Dread Wastes"] = "공포의 황무지"
L["Drustvar"] = "드러스트바"
L["Dun Morogh"] = "던 모로"
L["Dungeon"] = "던전"
L["Dungeons"] = "던전"
L["Dup ID"] = "중복ID"
L["durability"] = "당신의"
L["Durability"] = "내구도"
L["Durotar"] = "듀로타"
L["Duskwood"] = "그늘숲"
L["Dustwallow Marsh"] = "먼지진흙 습지대"
L["Eastern"] = "동부 왕국"
L["Eastern Kingdoms"] = "동부 왕국"
L["Eastern Plaguelands"] = "동부 역병지대"
L["ELITE"] = "정예"
L["Elwynn Forest"] = "엘윈 숲"
L["Embassies"] = "대사관"
L["Embers of War"] = "전쟁의 불씨"
L["Emerald Nightmare"] = "에메랄드의 악몽"
L["Enable hotkey"] = "단축키 사용"
L["End Time"] = "시간의 끝"
L["Enhance dressup"] = "미리보기 설정"
L["Enhance minimap"] = "미니맵 설정"
L["Enhance tooltip"] = "툴팁 설정"
L["Enhancements"] = "기능 향상"
L["Enigma"] = "수수께끼"
L["Enter the spell IDs for the cooldown icons that you want to see.|n|nIf a cooldown icon normally appears under the pet frame, check the pet checkbox.|n|nCooldown icons are saved to your class and specialisation."] = "표시할 주문 ID를 입력하세요.|n|n소환수 프레임 아래 표시하려면 소환수 박스를 체크하세요.|n|n쿨다운아이콘은 직업 및 특성으로 저장됩니다."
L["enter zone or track name"] = "지역 또는 트랙이름을 입력하세요."
L["Epilogue (Alliance)"] = "에필로그(얼라이언스)"
L["Epilogue (Horde)"] = "에필로그(호드)"
L["Error messages will be hidden"] = "오류메시지 숨김"
L["Error messages will be shown"] = "오류메시지 표시"
L["Error retrieving quest."] = "퀘스트를 검색하는 중에 오류가 발생했습니다."
L["Establish Your Garrison (Alliance)"] = "주둔지 건설(얼라이언스)"
L["Establish Your Garrison (Horde)"] = "주둔지 건설(호드)"
L["Eternal Palace"] = "영원한 궁전"
L["Events"] = "이벤트"
L["Everbloom"] = "상록숲"
L["Evermoon Terrace"] = "영원달 정원"
L["Eversong Woods"] = "영원노래 숲"
L["Extras"] = "기타"
L["Eye of Azshara"] = "아즈샤라의 눈"
L["Eye of Eternity"] = "영원의 눈"
L["Falanaar"] = "팔라나아르"
L["Fall of Deathwing"] = "데스윙의 추락"
L["Fall of the Lich King"] = "리치 왕의 몰락"
L["False"] = "거짓"
L["Faster auto loot"] = "빠른 전리품 획득"
L["Faster movie skip"] = "빠른 무비 넘김"
L["Fate of the Horde"] = "호드의 운명"
L["Features"] = "특징"
L["Felsoul Hold"] = "지옥영혼 요새"
L["Felwood"] = "악령숲"
L["Feralas"] = "페랄라스"
L["Find Item"] = "아이템찾기"
L["Firelands"] = "불의 땅"
L["Fizzle"] = "스킬 연타 소리"
L["Forge of Souls"] = "영혼의 제련소"
L["Frames"] = "프레임"
L["Freehold"] = "자유지대"
L["Frostfire Ridge"] = "서리불꽃 마루"
L["Game Options"] = "게임 설정"
L["Gate of the Setting Sun"] = "석양문"
L["General"] = "일반"
L["Ghost"] = "유령"
L["Ghostlands"] = "유령의 땅"
L["Gnomeregan"] = "놈리건"
L["Gold Only"] = "골드 만!"
L["Gorgrond"] = "고르그론드"
L["Graphics and Sound"] = "그래픽,소리"
L["Grim Batol"] = "그림 바톨"
L["Grimrail Depot"] = "파멸철로 정비소"
L["Grizzly Hills"] = "회색 구릉지"
L["Groups"] = "그룹"
L["Gruul's Lair"] = "그룰의 둥지"
L["Gul'dan Ascendant"] = "굴단의 위상"
L["Gul'dan's Plan"] = "굴단의 계획"
L["Gundrak"] = "군드락"
L["Halls of Lightning"] = "번개의 전당"
L["Halls of Origination"] = "시초의 전당"
L["Halls of Reflection"] = "투영의 전당"
L["Halls of Stone"] = "돌의 전당"
L["Halls of Valor"] = "용맹의 전당"
L["Harbingers Gul'dan"] = "굴단의 전조"
L["Harbingers Illidan"] = "일리단의 전조"
L["Harbingers Khadgar"] = "카드가의 전조"
L["Havenswood"] = "안식의 숲"
L["Heart of Fear"] = "공포의 심장"
L["Hellfire Citadel"] = "지옥불 성채"
L["Hellfire Peninsula"] = "지옥불 반도"
L["Hellfire Ramparts"] = "지옥불 성루"
L["Hellscream's Downfall (Alliance)"] = "헬스크림의 몰락(얼라이언스)"
L["Hellscream's Downfall (Horde)"] = "헬스크림의 몰락(호드)"
L["Help"] = "도움말"
L["Hide alerts"] = "경보,알림 숨김"
L["Hide bodyguard gossip"] = "경비병 잡담 숨김"
L["Hide boss banner"] = "보스 배너 숨김"
L["Hide chat buttons"] = "채팅 버튼 숨김"
L["Hide clean-up buttons"] = "가방정리 버튼 숨김"
L["Hide cooldown duration numbers (if enabled)"] = "주문 지속시간 숨김"
L["Hide error messages"] = "에러메시지 숨김"
L["Hide gryphons"] = "그리핀 문양 숨김"
L["Hide level-up display"] = "레벨 업 표시 숨김"
L["Hide order hall bar"] = "전당 바 숨김"
L["Hide portrait numbers"] = "초상화 전투수치 숨김"
L["Hide social button"] = "소셜 버튼 숨김"
L["Hide stance bar"] = "태세바 숨김"
L["Hide talking frame"] = "대화 프레임 숨김"
L["Hide the clock"] = "시계 숨김"
L["Hide the combat log"] = "전투기록 숨김"
L["Hide the zone text bar"] = "지역명 숨김"
L["Hide the zoom buttons"] = "확대축소 버튼 숨김"
L["Hide tooltips for world units during combat"] = "전투중 월드유닛 툴팁 숨김"
L["Hide zone text"] = "지역명 숨김"
L["High"] = "높음"
L["Highmaul"] = "높은 망치"
L["Highmountain"] = "높은산"
L["Highmountain Tauren"] = "높은산 타우렌"
L["Hillsbrad Foothills"] = "언덕마루 구릉지"
L["Hinterlands"] = "동부 내륙지"
L["Home"] = "홈"
L["Hour of Twilight"] = "황혼의 시간"
L["Howling Fjord"] = "울부짖는 협만"
L["Hyjal Summit"] = "하이잘 정상"
L["Icecrown"] = "얼음왕관"
L["Icecrown Citadel"] = "얼음왕관 성채"
L["If checked, a button will be added to the character sheet which will show your equipped item durability when you hover the pointer over it.|n|nIn addition, an overall percentage will be shown in the chat frame when you die."] = "케릭창에 내구도 정보 추가"
L["If checked, a group invite will be sent to anyone who whispers you with a set keyword as long as you are ungrouped, group leader or raid assistant."] = "그룹에 속하지 않거나 파티장 또는 부공장인 경우 설정된 키워드로 귓속말 대상에게 그룹초대가 발송됩니다."
L["If checked, a group invite will be sent to anyone who whispers you with the keyword INV.|n|nYou need to be either ungrouped or party leader in your own group for this to work."] = "선택하면,그룹 초대장이 INV 키워드로 귓속말을 보냅니다.|n|n이 기능을 사용하려면 파티가 아니거나 파티장이여야 합니다."
L["If checked, a master volume slider will be shown on the character sheet.|n|nThe volume slider can be placed in either of two locations on the character sheet.  To toggle between them, hold the shift key down and right-click the slider."] = "케릭창 하단 소리 조절 표시. 마스터 볼륨."
L["If checked, a minimap button will be available.|n|nClick - Toggle options panel.|n|nSHIFT/Left-click - Toggle music.|n|nSHIFT/Right-click - Toggle stopwatch.|n|nCTRL/Left-click - Toggle minimap target tracking.|n|nCTRL/Right-click - Toggle errors (if enabled).|n|nCTRL/SHIFT/Left-click - Toggle Zygor (if installed).|n|nCTRL/SHIFT/Right-click - Toggle windowed mode."] = "\"선택하면 Leatrix_Plus 미니맵버튼을 사용할 수 있습니다.|n|n왼클릭-설정창.|n|nShift/왼클릭-배경음악 켜기/끄기.|n|nShift/오른클릭-초시계.|n|nCtrl/왼클릭-대상 미니맵 표시/해제.|n|nCtrl/오른클릭-오류 표시/해제(설정활성된 경우).|n|nCtrl/Shift/왼클릭-Zygor(설치된 경우).|n|nCtrl/Shift/오른클릭-원도우 모드 전환.\""
L["If checked, alert frames will not be shown."] = "경고,알림 프레임이 표시되지 않습니다."
L["If checked, all grey items in your bags will be sold automatically when you visit a merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "상인과 대화시 가방에 있는 모든 회색템이 자동 판매됩니다. |n|n이 설정을 무시하려면 shift 누르고 대화 합니다."
L["If checked, available quests will be accepted automatically."] = "사용 가능한 퀘스트는 자동으로 수락됩니다."
L["If checked, backdrops will be tinted blue (friendly) or red (hostile)."] = "적대적-붉은색, 우호적-파란색"
L["If checked, Ban-Lu will no longer talk to you."] = "반루는 더이상 이야기 하지 않습니다."
L["If checked, battle pets which are automatically summoned will be dismissed within a few seconds.|n|nThis includes dragging a pet onto the first team slot in the pet journal and entering a battle pet team save command.|n|nNote that pets which are automatically summoned during combat will be dismissed when combat ends."] = "자동으로 소환되는 전투팻은 몇초 이내 해제됩니다.|n|n애완동물도감의 그룹저장 포함?|n|n전투 중 자동 소환되는 애완 동물은 전투가 끝나면 해제됩니다."
L["If checked, battle shouts heard when casting specific spells will be muted."] = "특정 주문을 시전 할 때 들리는 전투 소리가 소거됩니다."
L["If checked, BattleTag and Real ID friend requests will be automatically declined.|n|nEnabling this option will automatically decline any pending requests."] = "BattleTag과 실명ID 친구 요청이 자동으로 거절됩니다."
L["If checked, chat frame buttons will be hidden.|n|nClicking chat tabs will automatically show the latest messages.|n|nUse the mouse wheel to scroll through the chat history.  Hold down SHIFT for page jump or CTRL to jump to the top or bottom of the chat history."] = "채팅창의 버튼을 숨깁니다. 최근메시지 표시-탭 클릭. 마우스휠 사용가능."
L["If checked, chat text will not fade out after a time period."] = "채팅글이 일정시간후 사라짐 비활성."
L["If checked, class coloring will be used in the player frame, target frame and focus frame."] = "플레이어,대상,주시 프레임에서 직업 색상 사용."
L["If checked, class icons will be shown in the portrait frames."] = "직업 아이콘이 유닛프레임 초상화에 표시 됩니다."
L["If checked, completed quests will be turned-in automatically."] = "퀘스트 자동 완료(..."
L["If checked, confirmations will no longer appear when you choose a loot roll option or attempt to sell or mail a tradable item."] = "전리품 판매,우편발송 시 확인경고 표시안함."
L["If checked, converting a party group to a raid group will succeed even if there are low level characters in the group.|n|nEveryone in the group needs to have Leatrix Plus installed with this option enabled."] = "파티 구성원 중 저레벨이 있어도 공격대로 전환 할수 있습니다.|n|n그룹의 모든 사용자는 애드온 설치와 설정이 활성화 되어야 합니다. "
L["If checked, cooldown duration numbers will not be shown over the cooldowns.|n|nIf unchecked, cooldown duration numbers will be shown over the cooldowns if they are enabled in the game options panel ('ActionBars' menu)."] = "주문 지속시간 숨김"
L["If checked, daily quests will not be accepted automatically."] = "일일 퀘스트는 자동으로 수락되지 않습니다."
L["If checked, damage and healing numbers in the player and pet portrait frames will be hidden."] = "유닛프레임 초상화에 표시되는 데미지,힐 수치 표시 숨김."
L["If checked, dragging the General chat tab while the chat frame is locked will expand the chat frame upwards.|n|nIf the chat frame is unlocked, dragging the General chat tab will move the chat frame."] = "채팅창 잠긴 경우 탭(일반/전투)드레그로 위쪽을 길이 조절 할수있습니다."
L["If checked, duel requests will be blocked unless the player requesting the duel is in your friends list or guild."] = "친구목록,길드원 제외"
L["If checked, emote sounds will be silenced while your character is:|n|n- resting|n- in a pet battle|n- at the Halfhill Market|n- at the Grim Guzzler|n|nEmote sounds will be enabled when none of the above apply."] = "케릭터가 다음 경우 감정표현이 음소거:|n|n- 휴식.|n- 애완동물 대전.|n- 언덕골 시장.|n- 주정뱅이 선술집.|n|n감정표현 소리는 위의 상황에 적용되지 않을때 활성화 됩니다."
L["If checked, enemy nameplates will be shown during combat and hidden when combat ends."] = "전투시에만 이름표가 표시되고 비전투시 표시되지 않습니다."
L["If checked, gear toggle buttons will be added to the dressup frame and model positioning controls will be removed."] = "미리보기에 장비 토글 버튼이 추가 되고, 모델 컨트롤 버튼이 제거 됩니다."
L["If checked, group invites will only be sent to friends and guild members.|n|nIf unchecked, group invites will be sent to everyone."] = "그룹 초대가 친구 및 길드원에게만 발송됩니다. 체크하지 않으면 그룹 초대가 모든 사람에게 발송됩니다."
L["If checked, guild ranks will be shown for players in your guild."] = "나의 길드등급 표시"
L["If checked, most error messages (such as 'Not enough rage') will not be shown.  Some important errors are excluded.|n|nIf you have the minimap button enabled, you can hold down the control key and right-click it to toggle error messages without affecting this setting."] = "오류 메시지를 숨깁니다.(예:\"잘못된 대상입니다.\")|n|n몇가지 중요한 오류는 제외됩니다."
L["If checked, most of the bike mount sounds will be muted."] = "바이크 타기 사운드 대부분은 음소거됩니다."
L["If checked, party invitations from friends or guild members will be automatically accepted unless you are queued in Dungeon Finder."] = "던전찾기 대기하지 않을때 친구,길드원 파티초대 자동 허용함."
L["If checked, party invitations will be blocked unless the player inviting you is in your friends list or guild."] = "친구목록,길드원 제외"
L["If checked, party sync requests from friends or guild members will be automatically accepted."] = "친구 또는 길드원의 파티 초대 요청은 자동으로 수락됩니다."
L["If checked, pet battle duel requests will be blocked unless the player requesting the duel is in your friends list or guild."] = "친구목록,길드원 제외"
L["If checked, profession filter settings will be saved for the remainder of your login session."] = "이 옵션을 선택하면 남은 로그인 세션 동안 전문기술 필터 설정이 저장됩니다."
L["If checked, quests will be selected, accepted and turned-in automatically.|n|nQuests which have a gold, currency or crafting reagent requirement will not be turned-in automatically.|n|nYou can hold the shift key down when you talk to a quest giver to override this setting."] = "퀘스트가 자동으로 선택,수락 및 완료 됩니다.|n|n골드,화페,제작 재료의 요구사항이 있는 퀘스트는 자동 완료 되지 않습니다.|n|n대화할때 Shift키 사용으로 이 설정을 무시 할수 있습니다."
L["If checked, raid chat and instance chat will both be colored blue (to match the default party chat color)."] = "파티,공격대 챗색상 모두 같은색(파티)으로"
L["If checked, repair costs will be taken from guild funds for characters that are guilded and have permission to repair."] = "길드 자금을 사용가능한 경우 길드 자금으로 수리합니다."
L["If checked, requests initiated by your party leader to join the Dungeon Finder queue will be automatically accepted if the party leader is in your friends list or guild.|n|nThis option requires that you have selected a role for your character in the Dungeon Finder window."] = "파티장이 친구,길드원인 경우 던전대기열 요청을 자동 허용. |n|n던전은 자동으로 입장 되지 않습니다."
L["If checked, resurrection requests will be accepted automatically as long as the player resurrecting you is not in combat.|n|nResurrection requests from a Brazier of Awakening or a Failure Detection Pylon will not be accepted automatically."] = "부활 플레이어가 전투중 아닌경우 부활요청이 자동 수락됩니다.|n|n고장감지변환기,각성의화로 부활요청은 자동수락 제외 됩니다."
L["If checked, spell IDs will be shown in buff icon tooltips located in the buff frame and under the target frame."] = "버프,디버프 툴팁에 주문id 표시"
L["If checked, sticky chat will be disabled.|n|nNote that this does not apply to temporary chat windows."] = "길드,파티,공격대..대화채널을 고정 되지 않게합니다."
L["If checked, summon requests will be accepted automatically unless you are in combat."] = "비전투시 소환 자동수락"
L["If checked, the addon list (accessible from the game menu) will show character based addons by default."] = "게임옵션의 애드온 열때 해당 케릭터의 목록 표시(기본-전체)"
L["If checked, the amount of time it takes to auto loot creatures will be significantly reduced."] = "자동 전리품 획득 시간이 크게 줄어듭니다."
L["If checked, the backpack clean-up button and the bank frame clean-up button will not be shown."] = "소지품,은행 정리버튼 숨김"
L["If checked, the boss banner will not be shown.|n|nThe boss banner appears when a boss is defeated.  It shows the name of the boss and the loot that was distributed."] = "보스를 물리칠때 표시되는 전리품 이름을 숨깁니다."
L["If checked, the button to toggle the raid container frame will be shown just above the raid management frame (left side of the screen) instead of in the raid management frame itself.|n|nThis allows you to toggle the raid container frame without needing to open the raid management frame."] = "블리자드 공격대 프레임을 토글(숨김/표시)하는 버튼을  공격대 관리 창 (화면의 왼쪽)  위에 표시됩니다."
L["If checked, the clock will be hidden."] = "시계를 숨깁니다."
L["If checked, the combat log will be hidden.|n|nThe combat log must be docked in order for this option to work.|n|nIf the combat log is undocked, you can dock it by dragging the tab (and reloading your UI) or by resetting the chat windows (from the chat menu)."] = "전투 로그 창을 숨깁니다."
L["If checked, the 'Display only character achievements to others' setting in the game options panel ('Social' menu) will be permanently checked and locked."] = "게임설정-소셜의 '해당 케릭터의 업적만 표시' 를 사용하고 설정 잠금."
L["If checked, the editbox will be moved to the top of the chat frame."] = "채팅입력창을 프레임 상단으로 이동 설정됩니다."
L["If checked, the editbox will close when it loses focus."] = "대화 입력창 외 마우스 클릭으로 자동 닫힙니다."
L["If checked, the Foot Ball sounds will be muted."] = "축구공 사운드 음소거 됩니다."
L["If checked, the gossip window will not be shown when you talk to an active garrison bodyguard.|n|nYou can hold the shift key down when you talk to a bodyguard to override this setting."] = "주둔지 경비와 대화 할 때 대화창이 표시되지 않습니다.|n|n이 설정을 무시하려면 shift 누르고 대화 합니다."
L["If checked, the grey screen of death and the netherworld effect will be disabled."] = "죽음시 회색화면과 netherworld 효과가 비활성화됩니다."
L["If checked, the interface button sound, the chat frame tab click sound and the game menu toggle sound will be muted."] = "인터페이스 버튼 소리, 채팅 프레임 탭 클릭 소리 및 게임 메뉴 토글 소리가 음소거됩니다."
L["If checked, the level-up display will not be shown.|n|nThe level-up display shows encounter objectives, level-ups, pet battle rewards, etc."] = "레벨 업,교전의 목표,팻대결 보상 표시 숨김"
L["If checked, the main bar gryphons will not be shown."] = "스킬바의 그리핀 문양 제거"
L["If checked, the mechanical guild vault idle sound will be muted."] = "기계식 길드 금고 유휴 사운드가 음소거됩니다."
L["If checked, the netherworld effect will be disabled."] = "netherworld 효과가 비활성화됩니다."
L["If checked, the order hall command bar will not be shown."] = "직업 전당에서의 상단 전당 바 숨김"
L["If checked, the player frame background will be shown in class color."] = "플레이어 프레임 직업색상 표시"
L["If checked, the ready check sound will be muted."] = "준비완료 사운드 음소거"
L["If checked, the screen glow will be disabled.|n|nEnabling this option will also disable the drunken haze effect."] = "빛 효과가 비활성 됩니다.|n|n사용시 술취한 어지럼 효과가 비활성 됩니다."
L["If checked, the social button and quick-join notification will be hidden."] = "사용시, 소셜 버튼과 빠른참여 알림을 숨깁니다."
L["If checked, the spell fizzle sounds will be muted."] = "스킬 연타 사운드? 제거 합니다."
L["If checked, the stance bar will not be shown."] = "태세바 숨김.(드루이드...)"
L["If checked, the talking frame will not be shown.|n|nThe talking frame normally appears in the lower portion of the screen when certain NPCs communicate with you."] = "화면 하단의 NPC 대화 프레임 숨김"
L["If checked, the target frame background and focus frame background will be shown in class color."] = "주시,대상 프레임 직업색상 표시"
L["If checked, the tooltip will be color coded and you will be able to modify the tooltip layout and scale."] = "툴팁의 크기,위치,배경색 설정"
L["If checked, the worgen sniffing sounds will be muted."] = "늑대인간 킁킁 소리 제거 합니다."
L["If checked, the zone text bar will be hidden.  The tracking button tooltip will show zone information."] = "상단의 지역명을 숨깁니다.추적 버튼 툴팁에 지역정보가 표시됩니다."
L["If checked, the zoom buttons will be hidden.  You can use the mousewheel to zoom regardless of this setting."] = "줌 버튼을 숨깁니다.설정과 상관없이 마우스휠로 확대/축소 할수있습니다."
L["If checked, tooltips for world units will be hidden during combat.|n|nYou can hold the shift key down to override this setting."] = "전투 중 월드 유닛에 대한 툴팁을 숨깁니다.|n|nShift 키를 누르고 있으면 이 설정을 무시할 수 있습니다."
L["If checked, train sounds will be muted."] = "기차 사운드 음소거 됩니다."
L["If checked, traveling merchant greetings and farewells will be muted.|n|nThis applies to Traveler's Tundra Mammoth, Grand Expedition Yak and Mighty Caravan Brutosaur."] = "상인(여행자)의 인사말이 음소거 됩니다.|n|n여행자의 동토 매머드, 덩치 큰 원정용 야크 및 강력한 짐마차 브루토사우루스에 적용됩니다."
L["If checked, unit targets will be shown."] = "대상의 대상 표시"
L["If checked, weekly quests will not be accepted automatically."] = "주간 퀘스트는 자동으로 수락되지 않습니다."
L["If checked, Wowhead links will be shown in the world map frame and the achievements frame."] = "세계지도와 업적 창에 와우헤드 링크가 표시됩니다. "
L["If checked, Xiwyllag ATV will be muted."] = "스윅리갤 만능둥둥이 사운드 음소거 됩니다."
L["If checked, you can hold down the alt key while opening a gossip window to automatically select a single gossip option."] = "Alt 키를 누른 상태에서 대화창을 열면 자동으로 하나의 대화를 선택합니다."
L["If checked, you can hold down the control key and click a chat tab to view recent chat in a copy-friendly window."] = "Ctrl키를 누른 상태에서 채팅창 탭을 클릭하면 복사하기 쉬운 최근의 채팅을 볼수 있습니다."
L["If checked, you can open Leatrix Plus by pressing CTRL/Z."] = "Ctrl/Z 키로 Leatrix Plus를 열수 있습니다."
L["If checked, you can press the arrow keys to move the insertion point left and right in the chat frame.|n|nIf unchecked, the arrow keys will use the default keybind setting."] = "채팅 입력에서 삽입 포인터를 방향키로 이동 할수 있습니다."
L["If checked, you will be able to cancel cinematics without being prompted for confirmation."] = "재생 중지 확인 없이 무비를 취소 할수 있습니다."
L["If checked, you will be able to change the font size of quest text.|n|nEnabling this option will also change the text size of other frames which inherit the same font (such as the Dungeon Finder frame)."] = "퀘스트 글자 크기를 변경 할수 있습니다."
L["If checked, you will be able to change the font size of standard mail text.|n|nThis does not affect mail created using templates (such as auction house invoices)."] = "우편글자 크기를 변경할수 있습니다."
L["If checked, you will be able to change the position and scale of the buffs frame."] = "버프 프레임의 위치와 크기를 변경할 수 있습니다."
L["If checked, you will be able to change the position and scale of the player alternative power bar."] = "플레이어 파워바의 위치와 스케일을 변경할 수 있습니다."
L["If checked, you will be able to change the position and scale of the player frame, target frame, ghost frame and timer bar."] = "플레이어 , 대상 , 유령(죽음) , 타이머 바 프레임의 위치와 크기를 변경할 수 있습니다."
L["If checked, you will be able to change the position and scale of the widget frame.|n|nThe widget frame is commonly used for showing PvP scores and tracking objectives."] = "위젯 프레임의 위치와 크기를 변경할 수 있습니다. |n위젯 프레임은 일반적으로 PvP 점수 및 추적 목표를 표시하는 데 사용됩니다."
L["If checked, you will be able to customise the minimap."] = "미니맵을 사용자 정의 할 수 있습니다."
L["If checked, you will be able to drag the chat frame to the edge of the screen."] = "화면 모서리로 채팅창을 옮길수 있습니다."
L["If checked, you will be able to mute a selection of game sounds."] = "선택한 게임 사운드를 음소거 할 수 있습니다."
L["If checked, you will be able to place up to five beneficial cooldown icons above the target frame."] = "대상창(기본프레임) 위에 최대 5개의 쿨다운(버프류) 아이콘을 배치 할 수 있습니다."
L["If checked, you will be able to reposition the tooltip."] = "툴팁의 위치를 변경할수 있습니다."
L["If checked, you will be able to save your current battle pet team (including abilities) to a single command.|n|nA button will be added to the Pet Journal.  Clicking the button will toggle showing the assignment command for your current team.  Pressing CTRL/C will copy the command to memory.|n|nYou can then paste the command (with CTRL/V) into the chat window or a macro to instantly assign your team."] = "현재의 애완동물 그룹을 저장. 애완동물 도감의 생성된 버튼 클릭으로 코드를 crtl+c , 매크로 만들기 ctrl+v."
L["If checked, you will be able to set the density of weather effects."] = "날씨 효과의 밀도를 설정할 수 있습니다."
L["If checked, you will be able to show a rare, elite or rare elite chain around the player frame."] = "플레이어 프레임에 희귀,정예 문양 표시"
L["If checked, you will be able to show customisable borders around the edges of the screen.|n|nThe borders are placed on top of the game world but under the UI so you can place UI elements over them."] = "화면 가장자리 주위에 사용자 정의 가능한 테두리를 표시 할 수 있습니다. |n|n테두리는 게임 화면 상단에 있지만 UI 아래에 배치되어 UI 요소를 그 위에 배치 할 수 있습니다."
L["If checked, you will be able to zoom out to a greater distance."] = "사용시 게임설정-시점-최대시야거리: Max 고정."
L["If checked, you will need to hold the shift key down for quests to be automated.|n|nIf unchecked, holding shift will prevent quests from being automated."] = "이 설정을 사용시, Shift 키를 누르고 있어야 퀘스트가 자동화 됩니다.|n|n이 설정을 끄면, Shift 키를 누를때 퀘스트가 자동화 안 됩니다!!"
L["If checked, you will release automatically after you die in Ashran, Tol Barad (PvP), Wintergrasp or any battleground.|n|nYou will not release automatically if you have the ability to self-resurrect (soulstone, reincarnation, etc)."] = "아쉬란,톨 바라드,겨울손아귀 또는 전장에서 사망시 자동 해제.|n|n자기부활(영혼석,윤회)능력 경우 자동 해제되지 않습니다."
L["If checked, your bags will not be opened or closed automatically when you interact with a merchant, bank or mailbox."] = "상인,은행 NPC 대화 할때"
L["If checked, your chat history will increase to 4096 lines.  If unchecked, the default will be used (128 lines).|n|nEnabling this option may prevent some chat text from showing during login."] = "기본 128행을 4096행으로 증가"
L["If checked, your gear will be repaired automatically when you visit a suitable merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "상인을 방문 할때 장비가 자동으로 수리됩니다.|n|nShift키 누른채 대화시 자동 무시."
L["If checked, zone text will not be shown (eg. 'Ironforge')."] = "화면 가운데 표시되는 지역명 숨김. (예: 아이언포지)"
L["Increase chat history"] = "채팅 기록 증가"
L["Interface"] = "인터페이스"
L["Into the Portal"] = "차원문"
L["Invalid battle pet team parameter."] = "잘못된 매개변수"
L["Invalid console variable."] = "잘못된 콘솔 변수."
L["Invalid parameter."] = "잘못된 매개변수"
L["Invalid quest ID."] = "잘못된 퀘스트ID"
L["Invalid sound ID"] = "잘못된 사운드 ID"
L["Invalid taint level."] = "잘못된 오염 레벨입니다."
L["Invalid target."] = "잘못된 대상"
L["Invite from whispers"] = "귓속말 초대"
L["Iron Docks"] = "강철 선착장"
L["Island Expeditions"] = "군도 탐험"
L["Isle of Conquest"] = "정복의 섬"
L["Isle of Quel'Danas"] = "쿠엘다나스 섬"
L["Isle of Thunder"] = "천둥의 섬"
L["Jade Forest"] = "비취 숲"
L["Jade Forest Crash"] = "Jade Forest Crash"
L["Jaina Joins the Battle"] = "공성전 제이나 합류"
L["Jaina Returns to Kul Tiras"] = "쿨 티라스에 돌아온 제이나"
L["Jaina's Nightmare"] = "제이나의 악몽"
L["Jaina's Siege"] = "제이나-다자알로 전투 오프닝"
L["Jaina's Theme"] = "제이나 테마"
L["Jorundall"] = "조룬달"
L["Kalimdor"] = "칼림도어"
L["Karazhan"] = "카라잔"
L["Keyword"] = "키워드"
L["Kezan"] = "케잔"
L["Kil'jaeden's Downfall"] = "킬제덴의 몰락"
L["Kings' Rest"] = "왕들의 안식처"
L["Krasarang Wilds"] = "크라사랑 밀림"
L["Krokuun (Argus)"] = "크로쿠운(아르거스)"
L["Kul Tiran Humans"] = "쿨 티란"
L["Kul Tiras"] = "쿨 티라스"
L["Kun-Lai Summit"] = "쿤라이 봉우리"
L["Last Stand"] = "최후의 저항"
L["Leatrix Plus will not overwrite LeaPlusDB at next logout."] = "Leatrix Plus는 다음 로그 아웃시 LeaPlusDB를 덮어 쓰지 않습니다."
L["LEATRIX PLUS: WRONG VERSION INSTALLED!"] = "LEATRIX PLUS : 잘못된 버전이 설치되었습니다!"
L["Leaving Kezan"] = "케잔을 떠나다."
L["Leaving the Wandering Isle"] = "유랑도를 떠나다."
L["Left"] = "왼쪽"
L["Legion"] = "군단"
L["Lifetime honorable kills"] = "전체 명예 승수"
L["Lightforged Draenei"] = "빛벼림 드레나이"
L["Lion's Watch"] = "사자의 감시터"
L["Loch Modan"] = "모단 호수"
L["Lockout sharing"] = "업적공유 잠금"
L["Lost City of the Tol'vir"] = "토비르의 잃어버린 도시"
L["Lost Isles"] = "잃어버린 섬"
L["Low"] = "낮음"
L["Lunastre Estate"] = "루나스트르 장원"
L["Mac'Aree (Argus)"] = "마크아리(아르거스)"
L["Madness of Deathwing"] = "데스윙의 광기"
L["Maelstrom"] = "혼돈의 소용돌이"
L["Mag'har Orcs"] = "마그하르 오크"
L["Magisters' Terrace"] = "마법학자의 정원"
L["Magtheridon's Lair"] = "마그테리돈의 둥지"
L["Main Titles"] = "메인 타이틀"
L["Manage buffs"] = "버프 설정"
L["Manage frames"] = "프레임 설정"
L["Manage power bar"] = "파워바 설정"
L["Manage widget"] = "위젯 설정"
L["Managed by Leatrix Plus"] = "Leatrix Plus 에서 설정"
L["Mana-Tombs"] = "마나 무덤"
L["Maraudon"] = "마라우돈"
L["Maraudon: Earth Song Falls"] = "마라우돈:대지노래 폭포"
L["Maraudon: Foulspore Cavern"] = "마라우돈:썩은포자 동굴"
L["Maraudon: The Wicked Grotto"] = "마라우돈:악의 동굴"
L["Mardum"] = "마르둠"
L["Maw of Souls"] = "지옥어귀 벼랑"
L["Max camera zoom"] = "시야거리 최대 고정"
L["Mechagon"] = "메카곤"
L["Mechanics"] = "기능"
L["Media"] = "미디어"
L["Medium"] = "중간"
L["Memory Usage"] = "메모리 사용"
L["message shown."] = "메시지가 표시됩니다."
L["messages shown."] = "메시지가 표시됩니다."
L["Missing console variable."] = "누락된 콘솔 변수."
L["Missing mount name."] = "누락된 탈거."
L["Missing movie ID."] = "잘못된 무비 ID."
L["Missing pet name."] = "누락된 팻."
L["Missing quest ID."] = "퀘스트ID 없음"
L["Missing sound file parameter."] = "소리 파일 매개변수 에러"
L["Missing sound ID."] = "누락 된 사운드 ID."
L["Mists of Pandaria"] = "판다리아의 안개"
L["Mogu'shan Palace"] = "모구샨 궁전"
L["Mogu'shan Vaults"] = "모구샨 금고"
L["Molten Core"] = "화산 심장부"
L["Moon Guard Stronghold"] = "달빛 수호자 성채"
L["Moonglade"] = "달숲"
L["Motherlode"] = "왕노다지 광산!!"
L["Mount Hyjal"] = "하이잘 산"
L["Mount not found."] = "탈거를 찾을수 없습니다."
L["Mounts"] = "말타기"
L["Move editbox to top"] = "입력창 상단"
L["Movie not playable."] = "무비를 재생할수 없습니다."
L["Movie number"] = "무비 번호"
L["Movies"] = "무비"
L["Mulgore"] = "멀고어"
L["Music"] = "배경음악"
L["Music Rolls"] = "주크박스"
L["Mute game sounds"] = "게임 사운드 음소거"
L["My Very Own Castle (Alliance)"] = "나만의 성(얼라이언스)"
L["My Very Own Castle (Horde)"] = "나만의 성(호드)"
L["Mystical"] = "신비"
L["Nagrand"] = "나그란드"
L["Nagrand (Draenor)"] = "나그란드 (드레노어)"
L["Narration"] = "나레이션"
L["Naxxramas"] = "낙스라마스"
L["Nazjatar"] = "나즈자타"
L["Nazmir"] = "나즈미르"
L["Neltharion's Lair"] = "넬타리온의 둥지"
L["Netherstorm"] = "황천의 폭풍"
L["Nexus"] = "마력의 탑"
L["Nightborne"] = "나이트본"
L["Nighthold"] = "밤의 요새"
L["No bad sound IDs found."] = "잘못된 ID를 찾을수 없습니다."
L["No help is available for this page."] = "도움말을 사용할수 없습니다."
L["No items with durability equipped."] = "내구성 갖춘 아이템이 없습니다."
L["No media duplicates found."] = "중복된 미디어가 없습니다."
L["No tooltip showing."] = "툴팁이 없습니다."
L["None"] = "없음"
L["Northern Barrens"] = "북부 불모의 땅"
L["Northern Stranglethorn"] = "북부 가시덤불"
L["Northrend"] = "노스렌드"
L["Not completed."] = "미완료"
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Plus."] = "주의!|nLeatrix Plus 이 버전을 적용하려면 게임 클라이언트를 다시 시작해야합니다."
L["Nude"] = "옷벗기"
L["Ny'alotha"] = "나이알로사"
L["Obsidian Sanctum"] = "흑요석 성소"
L["Oculus"] = "마력의 눈"
L["Off"] = "끄기"
L["Okay, disable Dominos Encounter for me"] = "Okay, 나를 위해 Dominos Encounter를 비활성화"
L["Okay, disable screen adjust for me"] = "Okay, 나를 위해 화면 조정을 비활성화"
L["Old Hillsbrad Foothills"] = "옛 언덕마루 구릉지"
L["Onyxia's Lair"] = "오닉시아의 둥지"
L["Operation Mechagon"] = "작전명: 메카곤"
L["Orgrimmar"] = "오그리마"
L["Outland"] = "아웃랜드"
L["Overall"] = "전체"
L["Overlay"] = "오버레이"
L["Pandaria"] = "판다리아"
L["Particle density"] = "입자 밀도"
L["Party from friends"] = "친구의 파티"
L["Pet"] = "소환수"
L["Pet Battles"] = "애완동물 대전"
L["Pet not found.  Only owned pets that are currently showing in the journal can be searched."] = "팻을 찾을수 없습니다. 도감의 현재 소유한 팻을 검색할수 있습니다."
L["Pit of Saron"] = "사론의 구덩이"
L["Plants vs Zombies"] = "식물 vs 좀비"
L["Player"] = "플레이어"
L["Portal"] = "차원문"
L["Power"] = "파워"
L["Power of the Horde"] = "파워 오브 더 호드"
L["Press CTRL/C to copy."] = "Ctrl+C 를 눌러 복사."
L["Queue from friends"] = "친구의 대기열"
L["Ragefire Chasm"] = "성난불길 협곡"
L["Raid"] = "공격대"
L["Raid frame toggle"] = "레이드 프레임 토글"
L["Random"] = "무작위 재생"
L["RARE"] = "희귀"
L["RARE ELITE"] = "희귀 정예"
L["Razorfen Downs"] = "가시덩굴 구릉"
L["Razorfen Kraul"] = "가시덩굴 우리"
L["Ready"] = "전투준비"
L["Realm Of Torment"] = "Realm Of Torment"
L["Recent chat window"] = "최근 채팅 창"
L["Reckoning"] = "Reckoning"
L["Redridge Mountains"] = "붉은마루 산맥"
L["Reincarnation of Alleria Windrunner"] = "알레리아 원드러너의 환생"
L["Rejection of the Gift"] = "힘의 선물을 거부하다."
L["Release in PvP"] = "PvP지역 부활 수락 해제"
L["Reload"] = "리로드"
L["Remove raid restrictions"] = "공격대 제한 해제"
L["Repair automatically"] = "자동 수리"
L["Repair using guild funds if available"] = "길드 자금 사용"
L["Repaired for"] = "수리비"
L["Reposition the tooltip"] = "툴팁 위치 설정"
L["Require shift key for quest automation"] = "Shift 키 사용시 퀘스트 자동화"
L["Requires UI reload."] = "UI 리로드 필요."
L["Requires you to be interacting with Larana Drome.  She can be found at Scribes' Sacellum, Dalaran, Northrend."] = "라라나 드롬과 상호 작용해야합니다. 그녀는 노스렌드,달라란,각인사의 성소 에서 찾을 수 있습니다."
L["Reset"] = "재설정"
L["Resize mail text"] = "우편 글자 설정"
L["Resize quest text"] = "퀘스트 글자 설정"
L["Rested bubbles"] = "휴식 버블"
L["Restrict to friends and guild members"] = "친구와 길드원으로 제한"
L["result"] = "결과"
L["results"] = "결과들"
L["Return to Karazhan"] = "다시 찾은 카라잔"
L["Return to the Black Temple"] = "검은 사원으로 돌아가다."
L["Right"] = "오른쪽"
L["Right-click to close"] = "창닫기:우클릭."
L["Right-click to close."] = "창닫기:우클릭. ."
L["right-click to go back"] = "마우스 오른쪽 클릭으로 뒤로 이동."
L["Rise of Argus"] = "일어나라.아르거스."
L["Rise of Azshara"] = "아즈샤라의 현신"
L["Risking It All"] = "위험한 도박"
L["Ruby Sanctum"] = "루비 성소"
L["Ruins of Ahn'Qiraj"] = "안퀴라즈 폐허"
L["Ruins of Elune'eth"] = "엘룬에스의 페허"
L["Ruins of Gilneas"] = "길니아스 폐허"
L["Sanctum of Order"] = "질서의 성소"
L["Save profession filters"] = "전문기술 필터 저장"
L["Scale"] = "크기"
L["Scarlet Halls"] = "붉은십자군 전당"
L["Scarlet Monastery"] = "붉은십자군 수도원"
L["Scholomance"] = "스칼로맨스"
L["Search"] = "검색"
L["Searing Gorge"] = "이글거리는 협곡"
L["Seat of the Triumvirate"] = "삼두정의 권좌"
L["Select the settings that you want to use."] = "사용하려는 설정을 선택합니다."
L["Selection of music tracks"] = "음악 트랙 선택"
L["Self Markers Allowed"] = "전술 징표 허용 "
L["Self Markers Blocked"] = "전술 징표 차단"
L["Sell junk automatically"] = "회색템 자동 판매"
L["SELLING JUNK"] = "자동판매"
L["Serpentshrine Cavern"] = "불뱀 제단"
L["Set weather density"] = "날씨 밀도 설정"
L["Sethekk Halls"] = "세데크 전당"
L["Settings"] = "설정"
L["Shaders"] = "쉐이더"
L["Shado-Pan Monastery"] = "음영파 수도원"
L["Shadow Labyrinth"] = "어둠의 미궁"
L["Shadowfang Keep"] = "그림자송곳니 성채"
L["Shadowmoon Burial Grounds"] = "어둠달 지하묘지"
L["Shadowmoon Valley"] = "어둠달 골짜기"
L["Shadowmoon Valley (Draenor)"] = "어둠달 골짜기 (드레노어)"
L["Shipyard Construction (Alliance)"] = "조선소 건설 (얼라이언스)"
L["Shipyard Construction (Horde)"] = "조선소 건설 (호드)"
L["Sholazar Basin"] = "숄라자르 분지"
L["Shouts"] = "외침"
L["Show borders"] = "테두리 표시"
L["Show character addons"] = "케릭터 애드온 표시"
L["Show cooldowns"] = "쿨다운 아이콘 표시"
L["Show durability status"] = "내구도 표시"
L["Show guild ranks for your guild"] = "나의 길드 등급 표시"
L["Show minimap button"] = "미니맵 버튼 표시"
L["Show pet save button"] = "애완동물 저장 버튼"
L["Show player chain"] = "플레이어 테두리 표시"
L["Show raid button"] = "공격대 버튼 표시"
L["Show the spell ID in buff icon tooltips"] = "툴팁 주문ID 표시"
L["Show the unit's target"] = "대상의대상 표시"
L["Show volume slider"] = "소리 조절 표시"
L["Show Wowhead links"] = "와우헤드 링크 표시"
L["Shrine of the Storm"] = "폭풍의 사원"
L["Siege of Boralus"] = "보랄러스 공성전"
L["Siege of Dazar'alor"] = "다자알로 공성전"
L["Siege of Niuzao Temple"] = "니우짜오 사원 공성전투"
L["Siege of Orgrimmar"] = "오그리마 공성전"
L["Silence rested emotes"] = "감정표현 음소거"
L["Silithus"] = "실리더스"
L["Silverpine Forest"] = "은빛소나무 숲"
L["Silvershard Mines"] = "은빛수정 광산"
L["Skyreach"] = "하늘탑"
L["Slave Pens"] = "강제 노역소"
L["Sniffing"] = "콧소리"
L["Social"] = "소셜"
L["Sold junk for"] = "회색템 판매"
L["Sound system restarted."] = "사운드 시스템 재시작."
L["Southern Barrens"] = "남부 불모의 땅"
L["Spell ID"] = "주문 ID"
L["Spine of Deathwing"] = "데스윙의 등"
L["Spires of Arak"] = "아라크 첨탑"
L["Steamvault"] = "증기 저장고"
L["Stockade"] = "스톰윈드 지하감옥"
L["Stonecore"] = "바위심장부"
L["Stonetalon Mountains"] = "돌발톱 산맥"
L["Stop"] = "중지"
L["Storm Peaks"] = "폭풍우 봉우리"
L["Stormheim"] = "스톰하임"
L["Stormheim (Alliance)"] = "Stormheim (Alliance)"
L["Stormheim (Horde)"] = "Stormheim (Horde)"
L["Stormsong Valley"] = "폭풍노래 계곡"
L["Stormstout Brewery"] = "스톰스타우트 양조장"
L["Stormwind"] = "스톰윈드"
L["Strand of the Ancients"] = "고대의 해안"
L["Stratholme"] = "스트라솔름"
L["Stratholme: Crusader's Square"] = "스트라솔름:십자군 광장"
L["Stratholme: The Gauntlet"] = "스트라솔름:투쟁의 거리"
L["Sunken Temple"] = "가라앉은 사원"
L["Sunwell Plateau"] = "태양샘 고원"
L["Support"] = "지원"
L["Suramar"] = "수라마르"
L["Swamp of Sorrows"] = "슬픔의 늪"
L["Sync from friends"] = "친구 동기화"
L["System"] = "시스템"
L["Tabard"] = "휘장숨김"
L["Taint level: Basic (1)."] = "오염 레벨: Basic (1)"
L["Taint level: Disabled (0)."] = "오염 레벨: 비활성(0)"
L["Taint level: Full (2)."] = "오염 레벨: Full (2)"
L["Talador"] = "탈라도르"
L["Tanaan Jungle"] = "타나안 밀림"
L["Tanaris"] = "타나리스"
L["Target"] = "대상"
L["Target Tracking Disabled"] = "대상 추적 사용안함"
L["Target Tracking Enabled"] = "대상 추적 사용"
L["Tea with Jaina"] = "Tea with Jaina"
L["Tel'anor"] = "텔아노르"
L["Teldrassil"] = "텔드랏실"
L["Tempest Keep"] = "폭풍우 요새"
L["Temple of Ahn'Qiraj"] = "안퀴라즈"
L["Temple of Atal'Hakkar"] = "아탈학카르 신전"
L["Temple of Sethraliss"] = "세스랄리스 사원"
L["Temple of the Jade Serpent"] = "옥룡사"
L["Ten Years of Warcraft"] = "워크래프트 10주년"
L["Terokkar Forest"] = "테로카르 숲"
L["Terrace of Endless Spring"] = "영원한 봄의 정원"
L["Terror of Darkshore"] = "어둠해안의 공포"
L["Text"] = "글자"
L["Text size"] = "글자 크기"
L["Text Size"] = "글자 크기"
L["The Art of War"] = "전쟁의 기술"
L["The Battle for Broken Shore"] = "부서진 해변 전투"
L["The Battle for Shattrath"] = "샤트라스 전투"
L["The Battle of Thunder Pass"] = "천둥 고개 전투"
L["The Burning Crusade"] = "불타는 성전"
L["The Demon's Trail"] = "악마의 발자취"
L["The Dragon Soul"] = "용의 영혼"
L["The Eye"] = "폭풍우 요새"
L["The Fall of Lordaeron"] = "로데론의 몰락"
L["The Fate of Val'sharah"] = "발샤라의 운명"
L["The Fleet in Krasarang (Alliance)"] = "크라사랑 함대(얼라이언스)"
L["The Fleet in Krasarang (Horde)"] = "크라사랑 함대(호드)"
L["The Frozen Halls"] = "얼어붙은 전당"
L["The Invasion Begins"] = "침공의 시작"
L["The King's Command"] = "국왕의 명령"
L["The Negotiation"] = "The Negotiation"
L["The Nightborne Pact"] = "나이트본의 맹세"
L["The Nighthold"] = "The Nighthold"
L["The Return of Hope"] = "The Return of Hope"
L["The summon from"] = "당신을 소환하는 자"
L["The Threat Within"] = "The Threat Within"
L["The Waning Crescent"] = "기우는 초승달"
L["Themes"] = "테마"
L["This command will assign your current pet team and selected abilities.|n|nPress CTRL/C to copy the command then paste it into a macro or chat window with CTRL/V."] = "현재 팻과 선택된 능력을 그룹으로 저장합니다. 생성된 코드를 복사 crtl+c , 매크로에 붙어넣기 ctrl+v 저장"
L["This panel will close automatically if you enter combat."] = "전투시 자동으로 닫힙니다."
L["Thousand Needles"] = "버섯구름 봉우리"
L["Throne of the Four Winds"] = "네 바람의 왕좌"
L["Throne of the Tides"] = "파도의 왕좌"
L["Throne of Thunder"] = "천둥의 왕좌"
L["Thunder Bluff"] = "썬더 블러프"
L["Timeless Isle"] = "영원의 섬"
L["Timer"] = "미러바"
L["Tiragarde Sound"] = "티라가드 해협"
L["Tirisfal Glades"] = "티리스팔 숲"
L["Titan Panel screen adjust needs to be disabled for frames to be saved correctly."] = "프레임을 올바르게 저장하려면 Titan Panel 화면 조정을 비활성화해야합니다."
L["To begin, choose an options page."] = "설정 페이지를 선택합니다."
L["To hide the combat log, you need to disable the chat module in ElvUI."] = "전투 기록을 숨기려면 ElvUI에서 채팅 모듈을 비활성화해야합니다."
L["To use the Find Item button, you need to deselect the WoW Token category."] = "아이템찾기 사용하려면, 'WoW토큰' 카테고리 선택을 취소 해야 합니다. "
L["Tol Barad"] = "톨 바라드"
L["Tol Dagor"] = "톨 다고르"
L["Tomb of Sargeras"] = "살게라스의 무덤"
L["Tooltip"] = "툴팁"
L["Tooltip title color"] = "툴팁 제목 색상"
L["Top"] = "상단"
L["Top Center"] = "탑 센터"
L["Townlong Steppes"] = "탕랑 평원"
L["Tracing started."] = "추적 시작."
L["Tracing stopped."] = "추적 중지."
L["Trains"] = "기차"
L["Transparency"] = "투명도"
L["Travelers"] = "여행자(상인)"
L["Trial of Style"] = "멋의 대제전"
L["Trial of the Champion"] = "용사의 시험장"
L["Trial of the Crusader"] = "십자군의 시험장"
L["Trial of Valor"] = "용맹의 시험"
L["True"] = "참된"
L["Turn-in completed quests automatically"] = "퀘스트 자동 완료"
L["Twilight Highlands"] = "황혼의 고원"
L["Twilight Vineyards"] = "황혼의 포도원"
L["Twin Peaks"] = "쌍둥이 봉우리"
L["Uldaman"] = "울다만"
L["Uldir"] = "울디르"
L["Ulduar"] = "울두아르"
L["Uldum"] = "울둠"
L["Unclamp chat frame"] = "채팅창 고정 해제"
L["Underbog"] = "지하수렁"
L["Undercity"] = "언더시티"
L["Underrot"] = "썩은굴"
L["Un'Goro Crater"] = "운고로 분화구"
L["Universal group color"] = "그룹 색상 통합"
L["Use arrow keys in chat"] = "방향키 사용"
L["Use easy resizing"] = "쉬운 크기조절"
L["Use Leatrix Plus to move that frame."] = "프레임 이동 사용"
L["Use Leatrix Plus to reset that frame."] = "프레임 재설정 사용"
L["Utgarde Keep"] = "우트가드 성채"
L["Utgarde Pinnacle"] = "우트가드 첨탑"
L["Vale of Eternal Blossoms"] = "영원꽃 골짜기"
L["Valley of the Four Winds"] = "네 바람의 계곡"
L["Val'sharah"] = "발샤라"
L["Value must be a number."] = "값은 숫자 이여야 합니다."
L["Various"] = "기타"
L["Vashj'ir"] = "바쉬르"
L["Vault of Archavon"] = "아카본 석실"
L["Vault of the Wardens"] = "감시관의 금고"
L["Vaults"] = "금고"
L["Vendors"] = "상인"
L["Version"] = "버전"
L["Victory at The Nighthold"] = "밤의 요새 승리"
L["Victory in Draenor!"] = "드레노어의 승리"
L["Video"] = "비디오"
L["Violet Hold"] = "보랏빛 요새"
L["Visibility"] = "가시성"
L["Vision of Sailor's Memory"] = "Vision of Sailor's Memory"
L["Visions of N'Zoth"] = "Visions of N'Zoth"
L["Void Elves"] = "공허 엘프"
L["Vol'dun"] = "볼둔"
L["Vol'mar"] = "볼마르"
L["Wailing Caverns"] = "통곡의 동굴"
L["Wandering Isle"] = "유랑도"
L["Warbringers Azshara"] = "Warbringers Azshara"
L["Warbringers Jaina"] = "Warbringers Jaina"
L["Warbringers Sylvanas"] = "전쟁인도자 실바나스"
L["Warfronts"] = "격전지"
L["Warlords of Draenor"] = "드레노어의 전쟁군주"
L["Warning"] = "경고"
L["was automatically declined."] = "자동으로 거절되었습니다."
L["Waycrest Manor"] = "웨이크레스트 저택"
L["Weather density"] = "기상 밀도"
L["Welcome to Leatrix Plus."] = "Leatrix Plus 에 오신 것을 환영합니다."
L["Well of Eternity"] = "영원의 샘"
L["Western Plaguelands"] = "서부 역병지대"
L["Westfall"] = "서부 몰락지대"
L["Wetlands"] = "저습지"
L["Widget"] = "위젯"
L["will be automatically accepted in 10 seconds unless cancelled."] = "취소하지 않으면 10 초 후에 자동으로 수락됩니다."
L["Winter"] = "겨울"
L["Wintergrasp"] = "겨울손아귀 호수"
L["Winterspring"] = "여명의 설원"
L["World of Warcraft"] = "월드 오브 워크래프트"
L["Wrath of the Lich King"] = "리치 왕의 분노"
L["Wyrmrest Temple"] = "고룡쉼터 사원"
L["X Offset"] = "X 오프셋"
L["Y Offset"] = "Y 오프셋"
L["YOU"] = "당신"
L["You cannot do that in combat."] = "전투중으로 할수 없습니다."
L["You do not own this pet.  Only owned pets can be searched."] = "당신은 이 팻을 소유하고 있지 않습니다. 소유한 팻만 검색할수 있습니다."
L["You have"] = "장비 내구도"
L["You need a battle pet team."] = "애완동물대전 팀이 필요합니다."
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "일부 변경사항을 적용하려면 UI를 다시 로드 하여야 합니다. 요구시 리로드 버튼 활성화."
L["Your UI needs to be reloaded."] = "당신의 UI는 다시 로드 해야 합니다."
L["Zandalar"] = "잔달라"
L["Zandalari Trolls"] = "잔달라 트롤"
L["Zangarmarsh"] = "장가르 습지대"
L["Zones"] = "지역"
L["Zul'Aman"] = "줄아만"
L["Zuldazar"] = "줄다자르"
L["Zul'Drak"] = "줄드락"
L["Zul'Farrak"] = "줄파락"
L["Zul'Gurub"] = "줄구룹"
L["Zygor addon not found."] = "Zygor 애드온 찾을수 없음."

end

-- esMX: Latin American Spanish
if GameLocale == "esMX" then
L["A Deal with Death"] = "Un Trato con la Muerte"
L["A Falling Star"] = "Una Estrella Fugaz"
L["A Found Memento"] = "Un Recuerdo Encontrado"
L["A friend request from"] = "Una solicitud de amistad de"
L["A New Life for Undeath"] = "Una nueva vida para los No-muertos"
L["A Taste of Iron"] = "El Sabor del Hierro"
L["Accept resurrection"] = "Aceptar la resurrección"
L["Accept summon"] = "Acepta la invocación"
L["Account achievements are being shared."] = "Los logros de la cuenta se están compartiendo."
L["Account achievements are hidden."] = "Los logros de la cuenta están ocultos."
L["Addon"] = "Addon"
L["Adventure"] = "Aventura"
L["Ahn'kahet (Old Kingdom)"] = "Ahn'kahet: El Antiguo Reino"
L["All 3 battle pet slots need to be unlocked."] = "Las tres ranuras para mascotas de batalla deben ser desbloqueadas."
L["Allied Races"] = "Razas Aliadas"
L["An Unexpected Reunion"] = "Una Reunión Inesperada"
L["Anchor"] = "Anclaje"
L["And Justice for Thrall"] = "Justicia para Thrall"
L["Anduin's Theme"] = "El tema de Anduin"
L["Antoran Wastes (Argus)"] = "Baldío Antoran (Argus)"
L["Antorus Ending"] = "El final de Antorus"
L["Antorus, the Burning Throne"] = "Antorus, el Trono Ardiente"
L["Arathi Highlands"] = "Tierras Altas de Arathi"
L["Arcway"] = "La Arquería"
L["Arenas"] = "Arenas"
L["Arrival on Argus"] = "Llegada a Argus"
L["Arrival to Zandalar"] = "Llegada a Zandalar"
L["Ashenvale"] = "Vallefresno"
L["Ashran"] = "Ashran"
L["Assault on the Broken Shore"] = "Asalto a la Costa Quebrada"
L["Astravar Harbor"] = "Puerto de Astravar"
L["Atal'Dazar"] = "Atal'Dazar"
L["ATV"] = "ATV"
L["Auchenai Crypts"] = "Criptas de Auchenai"
L["Auchindoun"] = "Auchindoun"
L["AutoFollow"] = "Autoseguimiento"
L["AutoFollow disabled."] = "Autoseguimiento deshabilitado"
L["Automate gossip"] = "Automatizar los rumores"
L["Automate quests"] = "Automatizar las misiones"
L["Automation"] = "Automatización"
L["Azjol-Nerub"] = "Azjol-Nerub"
L["Azshara"] = "Azshara"
L["Azshara's Eternal Palace"] = "El Palacio Eterno de Azshara"
L["Azsuna"] = "Azsuna"
L["Azuremyst Isle"] = "Isla Bruma Azur"
L["Back to Main Menu"] = "Volver al menú principal"
L["Bad ID"] = "ID Incorrecta"
L["Badlands"] = "Tierras Inhóspitas"
L["Balls"] = "Bolas"
L["Ban-Lu"] = "Ban-Lu, compañero de los Grandes Maestros"
L["Baradin Hold"] = "Bastion de Baradin"
L["Barrens"] = "Los Baldíos"
L["Bastion of Twilight"] = "El Bastión del Crepúsculo"
L["Battle for Azeroth"] = "Battle for Azeroth"
L["Battle for Darkshore"] = "Batalla por Costaoscura"
L["Battle for Gilneas"] = "Batalla por Gilneas"
L["Battle for Stromgarde"] = "Batalla por Stromgarde"
L["Battle of Angrathar the Wrathgate"] = "La Batalla de Angrathar la Puerta de la Colera"
L["Battle of Dazar'alor"] = "Batalla por Dazar'alor"
L["Battle of Serpent's Heart"] = "Batalla del Corazón de la Serpiente"
L["Battlegrounds"] = "Campos de Batalla"
L["Bigger is Better (Alliance)"] = "Más grande es mejor (Alianza)"
L["Bigger is Better (Horde)"] = "Más grande es mejor (Horda)"
L["Bikes"] = "Bikes"
L["Black Morass"] = "La Ciénaga Negra"
L["Black Rook Hold"] = "Fuerte Torre Oscura"
L["Black Temple"] = "Templo Oscuro"
L["Blackfathom Deeps"] = "Cavernas de Brazanegra"
L["Blackrock Caverns"] = "Cavernas Roca Negra"
L["Blackrock Depths"] = "Profundidades de Roca Negra"
L["Blackrock Foundry"] = "Fundición Roca Negra"
L["Blackrock Mountain"] = "Montaña Roca Negra"
L["Blackrock Spire"] = "Cumbre de Roca Negra"
L["Blackwing Descent"] = "Descenso de Alanegra"
L["Blackwing Lair"] = "Guarida Alanegra"
L["Blade's Edge Mountains"] = "Montañas Filospada"
L["Blasted Lands"] = "Tierras Devastadas"
L["Block duels"] = "Bloquear duelos"
L["Block friend requests"] = "Bloquear solicitudes de amistad"
L["Block party invites"] = "Bloquear invitaciones a grupo"
L["Block pet battle duels"] = "Bloquear duelos de batalla de mascotas"
L["Blocks"] = "Bloques"
L["Bloodmaul Slag Mines"] = "Minas Machacasangre"
L["Bloodmyst Isle"] = "Isla Bruma de Sangre"
L["Borean Tundra"] = "Tundra Boreal"
L["Bottom"] = "Abajo"
L["Broken Isles"] = "Islas Quebradas"
L["Broken Shore"] = "Costa Quebrada"
L["Buffs"] = "Buffs"
L["Burning Steppes"] = "Estepas Ardientes"
L["Buyout Only"] = "Sólo la compra"
L["Camera distance"] = "Distancia de la cámara"
L["Cape of Stranglethorn"] = "El Cabo de Tuercespina"
L["Cataclysm"] = "Cataclysm"
L["Cathedral of Eternal Night"] = "Catedral de la Noche Eterna"
L["Caverns of Time"] = "Cavernas del Tiempo"
L["Chain style"] = "Estilo de cadena"
L["Character"] = "Personaje"
L["Chat"] = "Chat"
L["Chat Frame"] = "Cuadro de Chat"
L["Checkbox labels are Ok."] = "Las etiquetas de las casillas de verificación están bien."
L["Choose an Enigma pattern"] = "Elija un patrón de Enigma"
L["Cinematics"] = "Cinematicas"
L["Class colored frames"] = "Los marcos de color de clase"
L["Class icon portraits"] = "Retratos con iconos de clase"
L["Class Trials"] = "Pruebas de la clase"
L["click here for new selection"] = "haga clic aquí para la nueva selección"
L["Click to configure the settings for this option."] = "Haga clic para configurar los ajustes de esta opción."
L["Click to disable Dominos Encounter for all characters on this realm.  This is required for the player power bar position to be saved correctly.  Your UI will be reloaded."] = "Haz clic para desactivar el Encuentro de Dominos para todos los personajes de este reino.  Esto es necesario para que la posición de la barra de poder del jugador se guarde correctamente.  Tu UI se recargará."
L["Click to reset the settings on this page."] = "Haz clic para restablecer los ajustes de esta página."
L["Click to return to the main menu."] = "Haga clic para volver al menú principal."
L["Coilfang Reservoir"] = "Reserva de Colmillo Torcido"
L["Color the backdrops based on faction"] = "Colorear los tooltip en base a la facción"
L["Combat"] = "Combate"
L["Combat log cannot be hidden while undocked."] = "La bitácora de combate no puede ser escondida mientras se desacoplan."
L["Combat plates"] = "Placas de combate"
L["Completed."] = "Completado"
L["Configuration Panel"] = "Panel de configuración"
L["Connections for"] = "Conexiones para"
L["Court of Stars"] = "Corte de Estrellas"
L["Credits"] = "Creditos"
L["Crucible of Storms"] = "Crisol de Tormentas"
L["Crystalsong Forest"] = "Bosque Canto de Cristal"
L["Culling of Stratholme"] = "La Matanza de Stratholme"
L["Cursor"] = "Cursor"
L["Cursor Left"] = "A la izquerida del Cursor"
L["Cursor Right"] = "A la derecha del Cursor"
L["Dalaran"] = "Dalaran"
L["Dark Iron Dwarves"] = "Enanos Hierro Negro"
L["Dark Soil scanning activated.  Reload UI to exit."] = "Escaneo de Tierra Oscura activado.  Recargue la interfaz de usuario para salir."
L["Dark Soil scanning is already activated.  You only need to run this once.  Reload UI to exit."] = "El escaneo del suelo oscuro ya está activado.  Sólo necesitas ejecutar esto una vez.  Recargue la interfaz de usuario para salir."
L["Darkheart Thicket"] = "Matorral Corazón Oscuro"
L["Darkmoon Faire"] = "Feria de la Luna Negra"
L["Darkness Falls"] = "La oscuridad cae"
L["Darkshore"] = "Costaoscura"
L["Darnassus"] = "Darnassus"
L["Deadmines"] = "Minas de la Muerte"
L["Deepholm"] = "Infralar"
L["Deepwind Gorge"] = "Cañón del Céfiro"
L["Desolace"] = "Desolace"
L["Destiny Unfulfilled"] = "Destino incumplido"
L["Dire Maul"] = "La Masacre"
L["Dire Maul: Capital Gardens"] = "La Masacre: Jardines de la Capital"
L["Dire Maul: Gordok Commons"] = "La Masacre: Ágora de Gordok"
L["Dire Maul: Warpwood Quarter"] = "La Masacre: Barrio Alabeo"
L["Disable bag automation"] = "Desactivar la automatización de la bolsa"
L["Disable chat fade"] = "Desactivar el desvanecimiento del chat"
L["Disable loot warnings"] = "Desactivar las advertencias de botín"
L["Disable pet automation"] = "Desactivar la automatización de las mascotas"
L["Disable screen effects"] = "Desactivar los efectos de la pantalla"
L["Disable screen glow"] = "Desactivar el brillo de la pantalla"
L["Disable sticky chat"] = "Deshabilitar el chat bloqueado"
L["Dominos Encounter needs to be disabled."] = "El Encuentro del Dominó tiene que ser desactivado."
L["Draenor"] = "Draenor"
L["Drag the frame overlay to position the frame."] = "Arrastra la superposición del marco para posicionarlo."
L["Drag the frame overlays to position the frames.|n|nTo change the scale of a frame, click it to select it then adjust the scale slider.|n|nThis panel will close automatically if you enter combat."] = "Arrastre las superposiciones de los marcos para posicionarlos. Para cambiar la escala de un marco, haga clic en él para seleccionarlo y luego ajuste el deslizador de escala.|n|nEste panel se cerrará automáticamente si entra en combate."
L["Drag to set the cursor X offset."] = "Arrastre para establecer el desplazamiento del cursor en X."
L["Drag to set the cursor Y offset."] = "Arrastre para establecer el desplazamiento del cursor en Y."
L["Drag to set the density of weather effects."] = "Arrastre para establecer la densidad de los efectos del clima."
L["Drag to set the font size of mail text."] = "Arrastre para establecer el tamaño de la fuente del texto del correo."
L["Drag to set the font size of quest text."] = "Arrastra para establecer el tamaño de la fuente del texto de la misión."
L["Drag to set the minimap scale.|n|nNote that if you are using the default action bars, rescaling the minimap will also rescale the right action bars at startup so you may want to leave this at 100%."] = "Arrastra para establecer la escala del minimap.|n|nNota que si estás usando las barras de acción por defecto, reajustar el minimap también reajustará las barras de acción correctas al inicio, por lo que puede que quieras dejar esto al 100%."
L["Drag to set the scale of the Leatrix Plus panel."] = "Arrastre para establecer la escala del panel de Leatrix Plus."
L["Drag to set the scale of the selected frame."] = "Arrastre para establecer la escala del cuadro seleccionado."
L["Drag to set the size of the bottom border."] = "Arrastre para establecer el tamaño del borde inferior."
L["Drag to set the size of the left border."] = "Arrastre para establecer el tamaño del borde izquierdo."
L["Drag to set the size of the right border."] = "Arrastre para establecer el tamaño del borde derecho."
L["Drag to set the size of the top border."] = "Arrastre para establecer el tamaño del borde superior."
L["Drag to set the tooltip scale."] = "Arrastre para establecer la escala del Tooltip."
L["Drag to set the transparency of the borders."] = "Arrastre para establecer la transparencia de los bordes."
L["Drag to set the transparency of the Leatrix Plus panel."] = "Arrastre para establecer la transparencia del panel de Leatrix Plus."
L["Dragon Soul"] = "Alma de Dragon"
L["Dragonblight"] = "Cementerio de Dragones"
L["Drak'Tharon Keep"] = "Fortaleza de Drak'Tharon"
L["Dread Wastes"] = "Desierto del Pavor"
L["Drustvar"] = "Drustvar"
L["Dun Morogh"] = "Dun Morogh"
L["Dungeon"] = "Calabozo"
L["Dungeons"] = "Calabozos"
L["Dup ID"] = "Dup ID"
L["durability"] = "durabilidad"
L["Durability"] = "Durabilidad"
L["Durotar"] = "Durotar"
L["Duskwood"] = "Bosque del Ocaso"
L["Dustwallow Marsh"] = "Marjal Revolcafango"
L["Eastern"] = "Este"
L["Eastern Kingdoms"] = "Reinos del Este"
L["Eastern Plaguelands"] = "Tierras de la Peste del Este"
L["ELITE"] = "ELITE"
L["Elwynn Forest"] = "Bosque de Elwynn"
L["Embassies"] = "Embajadas"
L["Embers of War"] = "Las cenizas de la guerra"
L["Emerald Nightmare"] = "Pesadilla Esmeralda"
L["Enable hotkey"] = "Activar Hotkey"
L["End Time"] = "Tiempo final"
L["Enhance dressup"] = "Probador Mejorado"
L["Enhancements"] = "Mejoras"
L["Enigma"] = "Enigma"
L["Enter the spell IDs for the cooldown icons that you want to see.|n|nIf a cooldown icon normally appears under the pet frame, check the pet checkbox.|n|nCooldown icons are saved to your class and specialisation."] = "Ingresa los ID de los hechizos de los iconos de enfriamiento que deseas ver.|n|nSi un icono de enfriamiento aparece normalmente debajo del marco de la mascota, marca la casilla de verificación de la mascota.|n|nLos iconos de enfriamiento se guardan en tu clase y especialización."
L["enter zone or track name"] = "introduzca el nombre de la zona o de la pista"
L["Epilogue (Alliance)"] = "Epílogo (Alianza)"
L["Epilogue (Horde)"] = "Epílogo (Horda)"
L["Error messages will be hidden"] = "Los mensajes de error se ocultarán"
L["Error messages will be shown"] = "Se mostrarán mensajes de error"
L["Establish Your Garrison (Alliance)"] = "Establece tu Cuartel (Alianza)"
L["Establish Your Garrison (Horde)"] = "Establece tu Cuartel (Horda)"
L["Eternal Palace"] = "El Palacio Eterno"
L["Events"] = "Eventos"
L["Everbloom"] = "Sempibrote"
L["Evermoon Terrace"] = "Evermoon Terrace"
L["Eversong Woods"] = "Bosque Cancion Eterna"
L["Extras"] = "Extras"
L["Eye of Azshara"] = "Ojo de Azshara"
L["Eye of Eternity"] = "Ojo de la Eternidad"
L["Falanaar"] = "Falanaar"
L["Fall of Deathwing"] = "la caida de Alamuerte"
L["Fall of the Lich King"] = "la caida del Rey Exanime"
L["False"] = "Falso"
L["Faster auto loot"] = "Saqueo automático más rápido"
L["Faster movie skip"] = "Salto de cinematica más rápido"
L["Fate of the Horde"] = "El Destino de la Horda"
L["Features"] = "Características"
L["Felsoul Hold"] = "Felsoul Hold"
L["Felwood"] = "Frondavil"
L["Feralas"] = "Feralas"
L["Find Item"] = "Encuentra el item"
L["Firelands"] = "Tierras del Fuego"
L["Fizzle"] = "Fizzle"
L["Forge of Souls"] = "Forja de Almas"
L["Frames"] = "Cuadros"
L["Freehold"] = "Puerto Libre"
L["Frostfire Ridge"] = "Cresta Pirofrio"
L["Game Options"] = "Opciones de juego"
L["Gate of the Setting Sun"] = "La puerta del sol poniente"
L["General"] = "General"
L["Ghost"] = "Fantasma"
L["Ghostlands"] = "Tierras Fantasmas"
L["Gnomeregan"] = "Gnomeregan"
L["Gold Only"] = "Solo Oro"
L["Gorgrond"] = "Gorgrond"
L["Graphics and Sound"] = "Gráficos y sonido"
L["Grim Batol"] = "Grim Batol"
L["Grimrail Depot"] = "Depósito Riel Siniestro"
L["Grizzly Hills"] = "Colinas Pardas"
L["Groups"] = "Grupos"
L["Gruul's Lair"] = "Guarida de Gruul"
L["Gul'dan Ascendant"] = "Gul'dan Ascendant"
L["Gul'dan's Plan"] = "El plan de Gul'dan"
L["Gundrak"] = "Gundrak"
L["Halls of Lightning"] = "Cámaras de Relámpagos"
L["Halls of Origination"] = "Cámaras de los Orígenes"
L["Halls of Reflection"] = "Cámaras de Reflexión"
L["Halls of Stone"] = "Cámaras de Piedra"
L["Halls of Valor"] = "Cámaras del Valor"
L["Harbingers Gul'dan"] = "Harbingers Gul'dan"
L["Harbingers Illidan"] = "Harbingers Illidan"
L["Harbingers Khadgar"] = "Harbingers Khadgar"
L["Havenswood"] = "Havenswood"
L["Heart of Fear"] = "Corazon del Miedo"
L["Hellfire Citadel"] = "Ciudadela de Fuego Infernal"
L["Hellfire Peninsula"] = "Peninsula de Fuego infernal"
L["Hellfire Ramparts"] = "Murallas del Fuego Infernal"
L["Hellscream's Downfall (Alliance)"] = "La Caida de Gritoinfermal (Alianza)"
L["Hellscream's Downfall (Horde)"] = "La Caida de Gritoinfermal (Horda)"
L["Help"] = "Ayuda"
L["Hide alerts"] = "Ocultar Alertar"
L["Hide bodyguard gossip"] = "Ocultar dialogos de los guardaespaldas"
L["Hide boss banner"] = "Ocultar la bandera del jefe"
L["Hide chat buttons"] = "Ocultar Botones del Chat"
L["Hide clean-up buttons"] = "Ocultar Botones de Limpieza"
L["Hide cooldown duration numbers (if enabled)"] = "Ocultar numeros de enfriamiento (si esta activado)"
L["Hide error messages"] = "Ocultar mensajes de error"
L["Hide gryphons"] = "Ocultar Grifos de la barra de Habilidades"
L["Hide level-up display"] = "Ocultar  mensaje de Subida de Nivel"
L["Hide order hall bar"] = "Ocultar  Barra de la sala de Clase"
L["Hide portrait numbers"] = "Ocultar  numeros de daño en el retrato"
L["Hide social button"] = "Ocultar  Boton Social"
L["Hide stance bar"] = "Ocultar la barra de posición"
L["Hide talking frame"] = "Ocultar  Cuadro de Dialogo"
L["Hide the clock"] = "Ocultar  el Reloj"
L["Hide the combat log"] = "Ocultar  Registro de Combate"
L["Hide the zone text bar"] = "Ocultar  Barra con nombre de zona"
L["Hide the zoom buttons"] = "Ocultar  botones de zoom"
L["Hide tooltips for world units during combat"] = "Ocultar  Tooltip durante el combate"
L["Hide zone text"] = "Ocultar  Texto de Zona"
L["High"] = "Alto"
L["Highmaul"] = "Gran Magullador"
L["Highmountain"] = "Altamontaña"
L["Highmountain Tauren"] = "Taruren Altamontaña"
L["Hillsbrad Foothills"] = "Laderas de Trabalomas"
L["Hinterlands"] = "Tierras del Interior"
L["Home"] = "Casa"
L["Hour of Twilight"] = "Hora del Crepusculo"
L["Howling Fjord"] = "Fiordo Aquilonal"
L["Hyjal Summit"] = "La Cima Hyjal"
L["Icecrown"] = "Corona de Hielo"
L["Icecrown Citadel"] = "Ciudadela de Corona de Hielo"
L["If checked, a button will be added to the character sheet which will show your equipped item durability when you hover the pointer over it.|n|nIn addition, an overall percentage will be shown in the chat frame when you die."] = "Si está marcado, se añadirá un botón a la hoja de personaje que mostrará la durabilidad de tu objeto equipado cuando pases el puntero sobre él. Además, se mostrará un porcentaje general en el marco del chat cuando mueras."
L["If checked, a group invite will be sent to anyone who whispers you with a set keyword as long as you are ungrouped, group leader or raid assistant."] = "Si está marcada, se enviará una invitación de grupo a cualquiera que te susurre con una palabra clave establecida, siempre y cuando no estés agrupado, seas líder de grupo o ayudante de asalto."
L["If checked, a group invite will be sent to anyone who whispers you with the keyword INV.|n|nYou need to be either ungrouped or party leader in your own group for this to work."] = "Si está marcada, se enviará una invitación de grupo a cualquiera que te susurre con la palabra clave INV.|n|Necesitas ser desgrupado o líder del partido en tu propio grupo para que esto funcione."
L["If checked, a master volume slider will be shown on the character sheet.|n|nThe volume slider can be placed in either of two locations on the character sheet.  To toggle between them, hold the shift key down and right-click the slider."] = "Si se marca, se mostrará un deslizador de volumen maestro en la hoja de personajes.|n|nPara alternar entre ellas, mantenga pulsada la tecla Mayúsculas y haga clic con el botón derecho del ratón en el control deslizante."
L["If checked, a minimap button will be available.|n|nClick - Toggle options panel.|n|nSHIFT/Left-click - Toggle music.|n|nSHIFT/Right-click - Toggle stopwatch.|n|nCTRL/Left-click - Toggle minimap target tracking.|n|nCTRL/Right-click - Toggle errors (if enabled).|n|nCTRL/SHIFT/Left-click - Toggle Zygor (if installed).|n|nCTRL/SHIFT/Right-click - Toggle windowed mode."] = "Si está marcado, un botón de minimapa estará disponible.|n|nClick - Panel de opciones de conmutación.|nSHIFT/Left-click - Cambiar la música.|nSHIFT/Right-click - Cambiar el cronómetro. |n|nCTRL/Left-click - Cambiar seguimiento del minimapa.|n|nCTRL/Right-click - Cambiar errores (si esta activado).|n|nCTRL/SHIFT/Left-click - cambiar Zygor (si esta activado).|n|n|nCTRL/SHIFT/Right-click - cambiar a modo ventana."
L["If checked, alert frames will not be shown."] = "Si se marca, los cuadros de alerta no se mostrarán."
L["If checked, all grey items in your bags will be sold automatically when you visit a merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "Si está marcada, todos los artículos grises de sus bolsas se venderán automáticamente cuando visite a un comerciante.|n|nPuede mantener pulsada la tecla de mayúsculas cuando hable con un comerciante para anular esta configuración."
L["If checked, backdrops will be tinted blue (friendly) or red (hostile)."] = "Si se revisa, los fondos serán teñidos de azul (amistoso) o rojo (hostil)."
L["If checked, Ban-Lu will no longer talk to you."] = "Si se comprueba, Ban-Lu ya no hablará contigo."
L["If checked, battle pets which are automatically summoned will be dismissed within a few seconds.|n|nThis includes dragging a pet onto the first team slot in the pet journal and entering a battle pet team save command.|n|nNote that pets which are automatically summoned during combat will be dismissed when combat ends."] = "Si está marcado, las mascotas de batalla que son convocadas automáticamente serán descartadas en pocos segundos.|n|nEsto incluye arrastrar una mascota a la ranura del primer equipo en el diario de mascotas e ingresar un comando de guardar equipo de mascotas de batalla.|n|nTengan en cuenta que las mascotas que son convocadas automáticamente durante el combate serán despedidas cuando el combate termine."
L["If checked, battle shouts heard when casting specific spells will be muted."] = "Si se comprueba, se silenciarán los gritos de batalla que se escuchen cuando se lancen hechizos específicos."
L["If checked, BattleTag and Real ID friend requests will be automatically declined.|n|nEnabling this option will automatically decline any pending requests."] = "Si está marcada, las solicitudes de amistad de BattleTag y Real ID serán rechazadas automáticamente."
L["If checked, chat frame buttons will be hidden.|n|nClicking chat tabs will automatically show the latest messages.|n|nUse the mouse wheel to scroll through the chat history.  Hold down SHIFT for page jump or CTRL to jump to the top or bottom of the chat history."] = "Si está marcada, los botones del marco del chat estarán ocultos. Al hacer clic en las pestañas del chat se mostrarán automáticamente los últimos mensajes.|n|nUsa la rueda del ratón para desplazarte por el historial del chat.  Mantén pulsada la tecla MAYÚS para saltar a la página o la tecla CTRL para saltar a la parte superior o inferior del historial de chat."
L["If checked, chat text will not fade out after a time period."] = "Si se marca, el texto del chat no se desvanecerá después de un período de tiempo."
L["If checked, class coloring will be used in the player frame, target frame and focus frame."] = "Si está marcada, se utilizará el color de la clase en el marco del jugador, en el marco del objetivo y en el marco de enfoque."
L["If checked, class icons will be shown in the portrait frames."] = "Si se marca, los iconos de clase se mostrarán en los marcos de los retratos."
L["If checked, confirmations will no longer appear when you choose a loot roll option or attempt to sell or mail a tradable item."] = "Si se marca, las confirmaciones ya no aparecerán cuando elija una opción de botín o intente vender o enviar por correo un artículo comercial."
L["If checked, converting a party group to a raid group will succeed even if there are low level characters in the group.|n|nEveryone in the group needs to have Leatrix Plus installed with this option enabled."] = "Si está marcada, la conversión de un grupo a una banda tendrá éxito incluso si hay caracteres de bajo nivel en el grupo.|n|nTodos en el grupo necesitan tener Leatrix Plus instalado con esta opción activada."
L["If checked, cooldown duration numbers will not be shown over the cooldowns.|n|nIf unchecked, cooldown duration numbers will be shown over the cooldowns if they are enabled in the game options panel ('ActionBars' menu)."] = "Si está marcada, los números de enfriamiento no se mostrarán sobre los iconos.|n|n Si no está marcada, los números de duración del enfriamiento se mostrarán sobre los iconos si están activados en el panel de opciones del juego (menú 'Barras de Acción')."
L["If checked, damage and healing numbers in the player and pet portrait frames will be hidden."] = "Si se comprueba, los números de daño y curación en los marcos de los retratos de jugadores y mascotas se ocultarán."
L["If checked, dragging the General chat tab while the chat frame is locked will expand the chat frame upwards.|n|nIf the chat frame is unlocked, dragging the General chat tab will move the chat frame."] = "Si está activada, al arrastrar la pestaña de chat general con el marco de chat bloqueado se expandirá el marco de chat hacia arriba.|n|nSi el marco del chat está desbloqueado, al arrastrar la pestaña de chat general se moverá el marco del chat."
L["If checked, duel requests will be blocked unless the player requesting the duel is in your friends list or guild."] = "Si se marca, las solicitudes de duelo serán bloqueadas a menos que el jugador que solicita el duelo esté en su lista de amigos o en su gremio."
L["If checked, emote sounds will be silenced while your character is:|n|n- resting|n- in a pet battle|n- at the Halfhill Market|n- at the Grim Guzzler|n|nEmote sounds will be enabled when none of the above apply."] = "Si está marcado, los sonidos de emotes serán silenciados si: |n|n- descansando|n- duelo de mascotas|n- en el Halfhill Market|n- en el Grim Guzzler|n|nLos sonidos de emotes se activarán cuando no se aplique nada de lo anterior."
L["If checked, enemy nameplates will be shown during combat and hidden when combat ends."] = "Si está marcada, las placas del enemigo se mostrarán durante el combate y se ocultarán cuando éste termine."
L["If checked, gear toggle buttons will be added to the dressup frame and model positioning controls will be removed."] = "Si se marca, se añadirán botones de cambio de equipo al marco del vestidor y se eliminarán los controles de posicionamiento del modelo."
L["If checked, group invites will only be sent to friends and guild members.|n|nIf unchecked, group invites will be sent to everyone."] = "Si está marcada, las invitaciones de grupo sólo se enviarán a amigos y miembros del gremio.|n|nSi no está marcada, las invitaciones de grupo se enviarán a todos."
L["If checked, guild ranks will be shown for players in your guild."] = "Si se marca, se mostrarán los rangos de los jugadores de tu gremio."
L["If checked, most error messages (such as 'Not enough rage') will not be shown.  Some important errors are excluded.|n|nIf you have the minimap button enabled, you can hold down the control key and right-click it to toggle error messages without affecting this setting."] = "Si se marca, la mayoría de los mensajes de error (como 'No hay suficiente rabia') no se mostrarán.  Se excluyen algunos errores importantes.|n|nSi tienes activado el botón de minimapa, puedes mantener pulsada la tecla de control y hacer clic con el botón derecho del ratón para alternar los mensajes de error sin que ello afecte a esta configuración."
L["If checked, most of the bike mount sounds will be muted."] = "Si se comprueba, la mayoría de los sonidos del monturas motorizadas serán silenciados."
L["If checked, party invitations from friends or guild members will be automatically accepted unless you are queued in Dungeon Finder."] = "Si se marca, las invitaciones de amigos o miembros del gremio serán aceptadas automáticamente a menos que estés en la cola de Buscador de Mazmorras."
L["If checked, party invitations will be blocked unless the player inviting you is in your friends list or guild."] = "Si está marcado, las invitaciones a grupo se bloquearán a menos que el jugador que te invita esté en tu lista de amigos o en tu gremio."
L["If checked, party sync requests from friends or guild members will be automatically accepted."] = "Si está marcada, las solicitudes de sincronización de grupo por amigos o miembros del gremio serán aceptadas automáticamente."
L["If checked, pet battle duel requests will be blocked unless the player requesting the duel is in your friends list or guild."] = "Si está marcada, las solicitudes de duelo de mascotas serán bloqueadas a menos que el jugador que solicita el duelo esté en tu lista de amigos o en tu gremio."
L["If checked, profession filter settings will be saved for the remainder of your login session."] = "Si está marcada, la configuración del filtro de profesión se guardará para el resto de la sesión de juego."
L["If checked, quests will be selected, accepted and turned-in automatically.|n|nQuests which have a gold, currency or crafting reagent requirement will not be turned-in automatically.|n|nYou can hold the shift key down when you talk to a quest giver to override this setting."] = "Si está marcada, las misiones serán seleccionadas, aceptadas y entregadas automáticamente.|n|nLas misiones que tengan un requisito de oro, moneda o material de profesion no se entregarán automáticamente.|n|nPuedes mantener pulsada la tecla de mayúsculas cuando hables con alguien para anular esta configuración."
L["If checked, raid chat and instance chat will both be colored blue (to match the default party chat color)."] = "Si está marcada, tanto el chat de Banda como el de instancia serán de color azul (para que coincida con el color de chat de grupo predeterminado)."
L["If checked, repair costs will be taken from guild funds for characters that are guilded and have permission to repair."] = "Si se comprueba, los gastos de reparación se tomarán de los fondos del gremio para los personajes que son gremiados y tienen permiso para reparar."
L["If checked, requests initiated by your party leader to join the Dungeon Finder queue will be automatically accepted if the party leader is in your friends list or guild.|n|nThis option requires that you have selected a role for your character in the Dungeon Finder window."] = "Si está marcada, las solicitudes iniciadas por el líder de tu partido para unirse a la cola del Buscador de Mazmorras se aceptarán automáticamente si el líder del partido está en tu lista de amigos o en tu gremio.|n|nEsta opción requiere que hayas seleccionado un papel para tu personaje en la ventana del Dungeon Finder."
L["If checked, resurrection requests will be accepted automatically as long as the player resurrecting you is not in combat.|n|nResurrection requests from a Brazier of Awakening or a Failure Detection Pylon will not be accepted automatically."] = "Si está marcada, las solicitudes de resurrección serán aceptadas automáticamente siempre y cuando el jugador que te resucite no esté en combate.|n|nLas solicitudes de resurrección de un Brasero del Despertar o de un Pilón de Detección de Fallas no serán aceptadas automáticamente."
L["If checked, spell IDs will be shown in buff icon tooltips located in the buff frame and under the target frame."] = "Si se marca, las ID de los hechizos se mostrarán en los tooltips de los iconos de la barra de buffos y en los iconos debajo el cuadro de objetivo."
L["If checked, sticky chat will be disabled.|n|nNote that this does not apply to temporary chat windows."] = "Si está marcada, el chat pegajoso será desactivado.|n|nTen en cuenta que esto no se aplica a las ventanas de chat temporales."
L["If checked, summon requests will be accepted automatically unless you are in combat."] = "Si se comprueba, las solicitudes de citación se aceptarán automáticamente a menos que esté en combate."
L["If checked, the addon list (accessible from the game menu) will show character based addons by default."] = "Si está marcada, la lista de complementos (accesible desde el menú del juego) mostrará complementos basados en los personajes de forma predeterminada."
L["If checked, the amount of time it takes to auto loot creatures will be significantly reduced."] = "Si se comprueba, la cantidad de tiempo que toma el auto saqueo de las criaturas se reducirá significativamente."
L["If checked, the backpack clean-up button and the bank frame clean-up button will not be shown."] = "Si se comprueba, el botón de limpieza de la mochila y el botón de limpieza del marco del banco no se mostrarán."
L["If checked, the boss banner will not be shown.|n|nThe boss banner appears when a boss is defeated.  It shows the name of the boss and the loot that was distributed."] = "Si está marcada, el banner del jefe no se mostrará. |n|nEl banner del jefe aparece cuando un jefe es derrotado.  Muestra el nombre del jefe y el botín que fue distribuido."
L["If checked, the button to toggle the raid container frame will be shown just above the raid management frame (left side of the screen) instead of in the raid management frame itself.|n|nThis allows you to toggle the raid container frame without needing to open the raid management frame."] = "Si está seleccionado, el botón para cambiar el marco del contenedor del raid se mostrará justo encima del marco de gestión del banda (lado izquierdo de la pantalla) en lugar de en el propio marco de gestión del banda.|n|nEsto le permite cambiar el marco del contenedor de la redada sin necesidad de abrir el marco de gestión de la banda."
L["If checked, the clock will be hidden."] = "Si se comprueba, el reloj estará oculto."
L["If checked, the combat log will be hidden.|n|nThe combat log must be docked in order for this option to work.|n|nIf the combat log is undocked, you can dock it by dragging the tab (and reloading your UI) or by resetting the chat windows (from the chat menu)."] = "Si está marcada, el registro de combate se ocultará.|n|nEl registro de combate debe estar anclado para que esta opción funcione.|n|nSi el registro de combate está desanclado, puedes anclarlo arrastrando la pestaña (y recargando la interfaz de usuario) o restableciendo las ventanas de chat (desde el menú de chat)."
L["If checked, the 'Display only character achievements to others' setting in the game options panel ('Social' menu) will be permanently checked and locked."] = "Si está marcada, la opción 'Mostrar sólo los logros de los personajes a los demás' en el panel de opciones del juego (menú 'Social') estará permanentemente marcada y bloqueada."
L["If checked, the editbox will be moved to the top of the chat frame."] = "Si está marcada, la caja de edición se moverá a la parte superior del marco del chat."
L["If checked, the Foot Ball sounds will be muted."] = "Si se comprueba, los sonidos de la Footballserán silenciados."
L["If checked, the gossip window will not be shown when you talk to an active garrison bodyguard.|n|nYou can hold the shift key down when you talk to a bodyguard to override this setting."] = "Si está marcada, la ventana de chismes no se mostrará cuando hable con un guardaespaldas de la guarnición activa.|n|nPuede mantener pulsada la tecla shift cuando hable con un guardaespaldas para anular esta configuración."
L["If checked, the grey screen of death and the netherworld effect will be disabled."] = "Si se marca, la pantalla gris de la muerte y el efecto del inframundo se desactivarán."
L["If checked, the interface button sound, the chat frame tab click sound and the game menu toggle sound will be muted."] = "Si está marcada, el sonido del botón de la interfaz, el sonido del clic de la pestaña del marco de chat y el sonido de la conmutación del menú del juego se silenciarán."
L["If checked, the level-up display will not be shown.|n|nThe level-up display shows encounter objectives, level-ups, pet battle rewards, etc."] = "Si está marcada, la pantalla de nivelación no se mostrará.|n|nLa pantalla de nivelación muestra los objetivos de encuentro, los niveles, las recompensas de las batallas con mascotas, etc."
L["If checked, the main bar gryphons will not be shown."] = "Si se marca, no se mostrarán los grifos de la barra principal."
L["If checked, the mechanical guild vault idle sound will be muted."] = "Si se comprueba, el sonido de la bóveda del gremio se silenciará."
L["If checked, the order hall command bar will not be shown."] = "Si está marcada, la barra de comandos de la sala de órdenes no se mostrará."
L["If checked, the player frame background will be shown in class color."] = "Si se marca, el fondo del marco del jugador se mostrará en el color de la clase."
L["If checked, the screen glow will be disabled.|n|nEnabling this option will also disable the drunken haze effect."] = "Si está marcada, el brillo de la pantalla se desactivará.|n|nAl activar esta opción también se desactivará el efecto de neblina de borrachera."
L["If checked, the social button and quick-join notification will be hidden."] = "Si se marca, el botón social y la notificación de unión rápida se ocultarán."
L["If checked, the spell fizzle sounds will be muted."] = "Si se comprueba, los sonidos de la efervescencia del hechizo serán silenciados."
L["If checked, the stance bar will not be shown."] = "Si se marca, la barra de posición no se mostrará."
L["If checked, the talking frame will not be shown.|n|nThe talking frame normally appears in the lower portion of the screen when certain NPCs communicate with you."] = "Si se marca, no se mostrará el marco de conversación.|n|nEl marco de conversación normalmente aparece en la parte inferior de la pantalla cuando ciertos PNJ se comunican con usted."
L["If checked, the target frame background and focus frame background will be shown in class color."] = "Si se marca, el fondo del marco del objetivo y el fondo del marco de enfoque se mostrarán en color de clase."
L["If checked, the tooltip will be color coded and you will be able to modify the tooltip layout and scale."] = "Si está marcada, la punta de la herramienta estará codificada con colores y podrá modificar el diseño y la escala de la punta de la herramienta."
L["If checked, the worgen sniffing sounds will be muted."] = "Si se comprueba, los sonidos de olfateo del Huargen serán silenciados."
L["If checked, the zone text bar will be hidden.  The tracking button tooltip will show zone information."] = "Si se marca, la barra de texto de la zona estará oculta.  El botón de seguimiento mostrará la información de la zona."
L["If checked, the zoom buttons will be hidden.  You can use the mousewheel to zoom regardless of this setting."] = "Si se marca, los botones de zoom estarán ocultos.  Puedes usar la rueda del ratón para hacer zoom independientemente de esta configuración."
L["If checked, tooltips for world units will be hidden during combat.|n|nYou can hold the shift key down to override this setting."] = "Si está marcada, los datos de las unidades del mundo se ocultarán durante el combate.|n|nPuedes mantener presionada la tecla Shift para anular este ajuste."
L["If checked, train sounds will be muted."] = "Si se comprueba, los sonidos del tren serán silenciados."
L["If checked, traveling merchant greetings and farewells will be muted.|n|nThis applies to Traveler's Tundra Mammoth, Grand Expedition Yak and Mighty Caravan Brutosaur."] = "Si se marca, los saludos y despedidas de los comerciantes viajeros serán silenciados. Esto se aplica al Mamut de la Tundra del Viajero, al Yak de la Gran Expedición y al Brutosaurio de la Caravana Poderosa."
L["If checked, unit targets will be shown."] = "Si se marca, se mostrarán los objetivos de la unidad."
L["If checked, Wowhead links will be shown in the world map frame and the achievements frame."] = "Si se marca, los enlaces Wowhead se mostrarán en el marco del mapa mundial y en el marco de logros."
L["If checked, Xiwyllag ATV will be muted."] = "Si se comprueba, el ATV Xiwyllag será silenciado."
L["If checked, you can hold down the alt key while opening a gossip window to automatically select a single gossip option."] = "Si está marcada, puede mantener pulsada la tecla Alt mientras abre una ventana de chismes para seleccionar automáticamente una sola opción de chismes."
L["If checked, you can hold down the control key and click a chat tab to view recent chat in a copy-friendly window."] = "Si está marcada, puede mantener pulsada la tecla de control y hacer clic en una pestaña de chat para ver el chat reciente en una ventana de copia fácil."
L["If checked, you can open Leatrix Plus by pressing CTRL/Z."] = "Si está marcada, puedes abrir la Leatrix Plus pulsando CTRL/Z."
L["If checked, you can press the arrow keys to move the insertion point left and right in the chat frame.|n|nIf unchecked, the arrow keys will use the default keybind setting."] = "Si está marcada, puede pulsar las teclas de flecha para mover el punto de inserción a la izquierda y a la derecha en el marco de chat.|n|nSi no está marcada, las teclas de flecha utilizarán la configuración predeterminada del teclado."
L["If checked, you will be able to cancel cinematics without being prompted for confirmation."] = "Si está marcada, podrá cancelar las películas sin que se le pida confirmación."
L["If checked, you will be able to change the font size of quest text.|n|nEnabling this option will also change the text size of other frames which inherit the same font (such as the Dungeon Finder frame)."] = "Si está marcada, podrás cambiar el tamaño de la fuente del texto de la búsqueda.|n|nHabilitar esta opción también cambiará el tamaño del texto de otros marcos que heredan la misma fuente (como el marco de Buscador de Mazmorras)."
L["If checked, you will be able to change the font size of standard mail text.|n|nThis does not affect mail created using templates (such as auction house invoices)."] = "Si está marcada, podrá cambiar el tamaño de la fuente del texto del correo estándar.|n|nEsto no afecta al correo creado con plantillas (como las facturas de las casas de subastas)."
L["If checked, you will be able to customise the minimap."] = "Si está marcada, podrá personalizar el minimapa."
L["If checked, you will be able to drag the chat frame to the edge of the screen."] = "Si está marcada, podrás arrastrar el marco de chat hasta el borde de la pantalla."
L["If checked, you will be able to mute a selection of game sounds."] = "Si está marcada, podrá silenciar una selección de sonidos del juego."
L["If checked, you will be able to place up to five beneficial cooldown icons above the target frame."] = "Si está marcada, podrá colocar hasta cinco iconos de enfriamiento beneficiosos sobre el marco del objetivo."
L["If checked, you will be able to reposition the tooltip."] = "Si está marcada, podrá reposicionar el tooltip."
L["If checked, you will be able to save your current battle pet team (including abilities) to a single command.|n|nA button will be added to the Pet Journal.  Clicking the button will toggle showing the assignment command for your current team.  Pressing CTRL/C will copy the command to memory.|n|nYou can then paste the command (with CTRL/V) into the chat window or a macro to instantly assign your team."] = "Si está marcada, podrás guardar tu equipo actual de mascotas de batalla (incluyendo las habilidades) en un solo comando.|n|nUn botón se añadirá al diario de mascotas.  Al hacer clic en el botón, se mostrará el comando de asignación para tu equipo actual.  Al pulsar CTRL/C se copiará el comando a la memoria.|n|nPodrás entonces pegar el comando (con CTRL/V) en la ventana de chat o en una macro para asignar instantáneamente tu equipo."
L["If checked, you will be able to set the density of weather effects."] = "Si lo compruebas, podrás establecer la densidad de los efectos del clima."
L["If checked, you will be able to show a rare, elite or rare elite chain around the player frame."] = "Si se marca, podrás mostrar una cadena rara, de élite o de élite rara alrededor del cuadro del jugador."
L["If checked, you will be able to show customisable borders around the edges of the screen.|n|nThe borders are placed on top of the game world but under the UI so you can place UI elements over them."] = "Si está marcada, podrás mostrar bordes personalizables alrededor de los bordes de la pantalla.|n|nLos bordes se colocan en la parte superior del mundo del juego pero debajo de la interfaz de usuario para que puedas colocar elementos de la interfaz sobre ellos."
L["If checked, you will be able to zoom out to a greater distance."] = "Si se marca, podrás alejar el zoom a una distancia mayor."
L["If checked, you will release automatically after you die in Ashran, Tol Barad (PvP), Wintergrasp or any battleground.|n|nYou will not release automatically if you have the ability to self-resurrect (soulstone, reincarnation, etc)."] = "Si está marcado, se liberará automáticamente después de morir en Ashran, Tol Barad (PvP), Wintergrasp o cualquier campo de batalla.|n|nNo te liberarás automáticamente si tienes la habilidad de resucitarte a ti mismo (piedra del alma, reencarnación, etc.)."
L["If checked, your bags will not be opened or closed automatically when you interact with a merchant, bank or mailbox."] = "Si se registran, sus bolsas no se abrirán ni cerrarán automáticamente cuando interactúe con un comerciante, un banco o un buzón."
L["If checked, your chat history will increase to 4096 lines.  If unchecked, the default will be used (128 lines).|n|nEnabling this option may prevent some chat text from showing during login."] = "Si lo compruebas, tu historial de chat aumentará a 4096 líneas.  Si no está marcada, se utilizará el valor predeterminado (128 líneas).|n|nHabilitar esta opción puede evitar que se muestre algún texto de chat durante el inicio de sesión."
L["If checked, your gear will be repaired automatically when you visit a suitable merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "Si se comprueba, su equipo se reparará automáticamente cuando visite a un comerciante adecuado.|n|nPuede mantener pulsada la tecla shift cuando hable con un comerciante para anular este ajuste."
L["If checked, zone text will not be shown (eg. 'Ironforge')."] = "Si se marca, no se mostrará el texto de la zona (por ejemplo, 'Forjaz')"
L["Increase chat history"] = "Aumentar el historial de chat"
L["Interface"] = "Interfaz"
L["Into the Portal"] = "Dentro del Portal"
L["Invalid battle pet team parameter."] = "Parámetro de equipo de mascotas de batalla inválido."
L["Invalid console variable."] = "Variable de consola inválida."
L["Invalid parameter."] = "Parámetro inválido."
L["Invalid quest ID."] = "ID de Misión inválida"
L["Invalid sound ID"] = "ID de Sonido inválida"
L["Invalid taint level."] = "Nivel de contaminación inválido."
L["Invalid target."] = "Objetivo inválido."
L["Invite from whispers"] = "Invitación por susurros"
L["Iron Docks"] = "Muelles de Hierro"
L["Island Expeditions"] = "Expediciones Insulares"
L["Isle of Conquest"] = "Isla de Conquista"
L["Isle of Quel'Danas"] = "Isla de Quel'Danas"
L["Isle of Thunder"] = "Isla del Trueno"
L["Jade Forest"] = "Bosque de jade"
L["Jade Forest Crash"] = "Choque del Bosque de Jade"
L["Jaina Joins the Battle"] = "Jaina se une a la batalla"
L["Jaina Returns to Kul Tiras"] = "Jaina regresa a Kul Tiras"
L["Jaina's Nightmare"] = "La pesadilla de Jaina"
L["Jaina's Siege"] = "El asedio de Jaina"
L["Jaina's Theme"] = "Tema de Jaina"
L["Jorundall"] = "Jorundall"
L["Kalimdor"] = "Kalimdor"
L["Karazhan"] = "Karazhan"
L["Keyword"] = "Palabra clave"
L["Kezan"] = "Kezan"
L["Kil'jaeden's Downfall"] = "La caída de Kil'jaeden"
L["Kings' Rest"] = "Reposo de los Reyes"
L["Krasarang Wilds"] = "Espesura Krasarang"
L["Krokuun (Argus)"] = "Krokuun (Argus)"
L["Kul Tiran Humans"] = "Kultiranos"
L["Kul Tiras"] = "Kul Tiras"
L["Kun-Lai Summit"] = "Cima Kun-Lai"
L["Last Stand"] = "Ultima Etapa"
L["Leatrix Plus will not overwrite LeaPlusDB at next logout."] = "Leatrix Plus no sobrescribirá a LeaPlusDB en el próximo cierre de sesión."
L["LEATRIX PLUS: WRONG VERSION INSTALLED!"] = "LEATRIX PLUS: ¡VERSIÓN INCORRECTA INSTALADA!"
L["Leaving Kezan"] = "Dejando a Kezan"
L["Leaving the Wandering Isle"] = "Dejando la Isla Errante"
L["Left"] = "Salida"
L["Legion"] = "Legion"
L["Lifetime honorable kills"] = "Muertes honorables de por vida"
L["Lightforged Draenei"] = "Draenei Templeluz"
L["Lion's Watch"] = "La Guardia del León"
L["Loch Modan"] = "Loch Modan"
L["Lockout sharing"] = "Compartir el bloqueo"
L["Lost City of the Tol'vir"] = "Ciudad Perdida de los Tol'vir"
L["Lost Isles"] = "Islas Perdidas"
L["Low"] = "Bajo"
L["Lunastre Estate"] = "Finca de Lunastre"
L["Mac'Aree (Argus)"] = "Mac'Aree (Argus)"
L["Madness of Deathwing"] = "La locura de la Alamuerte"
L["Maelstrom"] = "Voragine"
L["Mag'har Orcs"] = "Orcos Mag'har"
L["Magisters' Terrace"] = "Bancal del Magister"
L["Magtheridon's Lair"] = "Guarida de Magtheridon"
L["Main Titles"] = "Títulos principales"
L["Manage frames"] = "Gestionar los marcos"
L["Managed by Leatrix Plus"] = "Gestionado por Leatrix Plus"
L["Mana-Tombs"] = "Tumbas de Mana"
L["Maraudon"] = "Maraudon"
L["Maraudon: Earth Song Falls"] = "Maraudon: Las Cataratas de la Canción de la Tierra"
L["Maraudon: Foulspore Cavern"] = "Maraudon: Foulspore Cavernas"
L["Maraudon: The Wicked Grotto"] = "Maraudon: La Gruta Malvada"
L["Mardum"] = "Mardum"
L["Maw of Souls"] = "Fauce de Almas"
L["Max camera zoom"] = "Zoom maximo de la camara"
L["Mechagon"] = "Mecalopolis"
L["Mechanics"] = "Mecanicas"
L["Media"] = "Medios"
L["Medium"] = "Medio"
L["Memory Usage"] = "Uso de Memoria"
L["message shown."] = "mensaje mostrado."
L["messages shown."] = "mensajes mostrados."
L["Missing console variable."] = "Falta la variable de la consola."
L["Missing mount name."] = "Falta el nombre de la montura."
L["Missing movie ID."] = "Falta ID de la cinematica"
L["Missing pet name."] = "Falta el nombre de la mascota"
L["Missing quest ID."] = "Falta el ID de la mision"
L["Missing sound file parameter."] = "Falta el parámetro del archivo de sonido."
L["Missing sound ID."] = "Falta el ID del sonido"
L["Mists of Pandaria"] = "Mist of Pandaria"
L["Mogu'shan Palace"] = "Palacio Mogu'shan"
L["Mogu'shan Vaults"] = "Camaras Mogu'shan"
L["Molten Core"] = "Núcleo de Magma"
L["Moon Guard Stronghold"] = "Fortaleza de la Guardia de la Luna"
L["Moonglade"] = "Claro de Luna"
L["Motherlode"] = "El Filon"
L["Mount Hyjal"] = "Monte Hyjal"
L["Mount not found."] = "Montura no encontrada"
L["Mounts"] = "Monturas"
L["Move editbox to top"] = "Mover la caja de edición a la parte superior"
L["Movie not playable."] = "La cinematica no se puede reproducir."
L["Movie number"] = "Número de la cinematica"
L["Movies"] = "Cinematicas"
L["Mulgore"] = "Mulgore"
L["Music"] = "Musica"
L["Music Rolls"] = "Rollos de música"
L["Mute game sounds"] = "Silenciar el Juego"
L["My Very Own Castle (Alliance)"] = "Mi propio castillo (Alianza)"
L["My Very Own Castle (Horde)"] = "Mi propio castillo (Horda)"
L["Mystical"] = "Místico"
L["Nagrand"] = "Nangrand"
L["Nagrand (Draenor)"] = "Nagrand (Draenor)"
L["Narration"] = "Narracion"
L["Naxxramas"] = "Naxxramas"
L["Nazjatar"] = "Nazjatar"
L["Nazmir"] = "Nazmir"
L["Neltharion's Lair"] = "Guarida de Neltharion"
L["Netherstorm"] = "Tormenta Abisal"
L["Nexus"] = "Nexo"
L["Nightborne"] = "Natonocturnos"
L["Nighthold"] = "Bastion Nocturno"
L["No bad sound IDs found."] = "No se encontraron ID de sonidos dañados"
L["No help is available for this page."] = "No hay ayuda disponible para esta página."
L["No items with durability equipped."] = "No hay artículos equipados con durabilidad."
L["No media duplicates found."] = "No se han encontrado duplicados de medios."
L["No tooltip showing."] = "No mostrar tooltips"
L["None"] = "No"
L["Northern Barrens"] = "Baldios del Norte"
L["Northern Stranglethorn"] = "Norte de la Vega de Tuercespina"
L["Northrend"] = "Rasganorte"
L["Not completed."] = "No se ha completado."
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Plus."] = "¡Aviso!|nDebes reiniciar completamente tu cliente de juego antes de que puedas usar esta versión de Leatrix Plus."
L["Nude"] = "Desnudo"
L["Ny'alotha"] = "Ny'alotha"
L["Obsidian Sanctum"] = "Santuario Osidiana"
L["Oculus"] = "Oculus"
L["Off"] = "Apagado"
L["Okay, disable Dominos Encounter for me"] = "Bien, deshabilita el Encuentros de Dominos para mí"
L["Okay, disable screen adjust for me"] = "Bien, desactiva el ajuste de la pantalla para mí"
L["Old Hillsbrad Foothills"] = "Antiguas Laderas de Trabalomas"
L["Onyxia's Lair"] = "Guarida de Onyxia"
L["Operation Mechagon"] = "Operacion Mecandria"
L["Orgrimmar"] = "Orgrimmar"
L["Outland"] = "Terrallende"
L["Overall"] = "En general"
L["Overlay"] = "Superposición"
L["Pandaria"] = "Pandaria"
L["Particle density"] = "Densidad de Particulas"
L["Party from friends"] = "Grupo con Amigos"
L["Pet"] = "Mascota"
L["Pet Battles"] = "Batalla de Mascotas"
L["Pet not found.  Only owned pets that are currently showing in the journal can be searched."] = "Mascota no encontrada.  Sólo se pueden buscar las mascotas que aparecen actualmente en el diario."
L["Pit of Saron"] = "Foso de Saron"
L["Plants vs Zombies"] = "Plantas vs Zombies"
L["Player"] = "Jugador"
L["Portal"] = "Portal"
L["Power"] = "Poder"
L["Power of the Horde"] = "Poder de la Horda"
L["Press CTRL/C to copy."] = "Presione CTRL/C para copiar."
L["Queue from friends"] = "Cola con amigos"
L["Ragefire Chasm"] = "Sima Ígnea"
L["Raid"] = "Banda"
L["Raid frame toggle"] = "Cambiar el marco de banda"
L["Random"] = "Aleatorio"
L["RARE"] = "RARE"
L["RARE ELITE"] = "RARE ELITE"
L["Razorfen Downs"] = "Zahúrda Rojacieno"
L["Razorfen Kraul"] = "Horado Rajacieno"
L["Realm Of Torment"] = "El reino del Tormento"
L["Recent chat window"] = "Ventana de chat reciente"
L["Reckoning"] = "Reckoning"
L["Redridge Mountains"] = "Montañas Crestagrana"
L["Reincarnation of Alleria Windrunner"] = "Reencarnación de Alleria Brizaveloz"
L["Rejection of the Gift"] = "Rechazo del regalo"
L["Release in PvP"] = "Liberar en PvP"
L["Reload"] = "Recargar"
L["Remove raid restrictions"] = "Quitar restricciones de Banda"
L["Repair automatically"] = "Reparar automáticamente"
L["Repair using guild funds if available"] = "Reparar con fondos del gremio si están disponibles"
L["Repaired for"] = "Reparado por"
L["Reposition the tooltip"] = "Reposicionar el tooltip"
L["Requires UI reload."] = "Requiere recarga de la UI."
L["Requires you to be interacting with Larana Drome.  She can be found at Scribes' Sacellum, Dalaran, Northrend."] = "Requiere que interactúes con el Larana Drome.  Se puede encontrar en el Scribes' Sacellum, Dalaran, Northrend."
L["Reset"] = "Resetear"
L["Resize mail text"] = "Cambiar el tamaño del texto del correo"
L["Resize quest text"] = "Cambiar el tamaño del texto de la misión"
L["Rested bubbles"] = "Burbujas de descanso"
L["Restrict to friends and guild members"] = "Restringir a los amigos y miembros del gremio"
L["result"] = "resultado"
L["results"] = "resultados"
L["Return to Karazhan"] = "Regreso a Karazhan"
L["Return to the Black Temple"] = "Regreso al Templo Oscuro"
L["Right"] = "Derecha"
L["Right-click to close"] = "Haga clic con el botón derecho del ratón para cerrar"
L["Right-click to close."] = "Haga clic con el botón derecho del ratón para cerrar"
L["right-click to go back"] = "haga clic con el botón derecho del ratón para cerrar"
L["Rise of Argus"] = "Alzamiento de Argus"
L["Rise of Azshara"] = "Alzamiento de Azshara"
L["Risking It All"] = "Arriesgándolo todo"
L["Ruby Sanctum"] = "Santuario Rubi"
L["Ruins of Ahn'Qiraj"] = "Ruinas de Ahn'Qiraj"
L["Ruins of Elune'eth"] = "Ruinas de Elune'eth"
L["Ruins of Gilneas"] = "Ruinas de Gilneas"
L["Sanctum of Order"] = "Santuario de la Orden"
L["Save profession filters"] = "Guardar los filtros de la profesión"
L["Scale"] = "Escala"
L["Scarlet Halls"] = "Scarlet Halls"
L["Scarlet Monastery"] = "Monasterio Escarlata"
L["Scholomance"] = "Scholomance"
L["Search"] = "Busca en"
L["Searing Gorge"] = "La Garganta Fuego"
L["Seat of the Triumvirate"] = "Trono del Triunvirato"
L["Select the settings that you want to use."] = "Seleccione los ajustes que desea utilizar."
L["Selection of music tracks"] = "Selección de pistas de música"
L["Self Markers Allowed"] = "Se permiten los auto-marcadores"
L["Self Markers Blocked"] = "Los auto-marcadores están bloqueados"
L["Sell junk automatically"] = "Vender basura automáticamente"
L["SELLING JUNK"] = "VENTA DE BASURA"
L["Serpentshrine Cavern"] = "Caverna Santuario Serpiente"
L["Set weather density"] = "Establecer la densidad del clima"
L["Sethekk Halls"] = "Salas Sethekk"
L["Settings"] = "Ajustes"
L["Shaders"] = "Shaders"
L["Shado-Pan Monastery"] = "Monasterio Shado-Pan"
L["Shadow Labyrinth"] = "Laberinto de las Sombras"
L["Shadowfang Keep"] = "Castillo de Colmillo Oscuro"
L["Shadowmoon Burial Grounds"] = "Cementerio de Sombraluna"
L["Shadowmoon Valley"] = "Valle Sombraluna"
L["Shadowmoon Valley (Draenor)"] = "Valle Sombraluna (Draenor)"
L["Shipyard Construction (Alliance)"] = "Construcción de astilleros (Alianza)"
L["Shipyard Construction (Horde)"] = "Construcción de astilleros (Horda)"
L["Sholazar Basin"] = "Cuenca de Sholazar"
L["Shouts"] = "Gritos"
L["Show borders"] = "Mostrar los bordes"
L["Show character addons"] = "Mostrar los addons de los personajes"
L["Show cooldowns"] = "Mostrar enfriamientos"
L["Show durability status"] = "Mostrar el estado de durabilidad"
L["Show guild ranks for your guild"] = "Muestra los rangos del gremio para tu gremio"
L["Show minimap button"] = "Mostrar el botón de minimización"
L["Show pet save button"] = "Mostrar el botón de guardar mascota"
L["Show player chain"] = "Mostrar Logo de Elite en el cuadro de parsonaje"
L["Show the spell ID in buff icon tooltips"] = "Mostrar la ID del hechizo en los Tooltip de los iconos de buff"
L["Show the unit's target"] = "Mostrar el objetivo de la unidad"
L["Show volume slider"] = "Mostrar el deslizador de volumen"
L["Show Wowhead links"] = "Mostrar los enlaces de Wowhead"
L["Shrine of the Storm"] = "Altar de las Tormentas"
L["Siege of Boralus"] = "Asedio de Boralus"
L["Siege of Dazar'alor"] = "Asedio de Dazar'alor"
L["Siege of Niuzao Temple"] = "Asedio del Templo de Niuzao"
L["Siege of Orgrimmar"] = "Asedio de Orgrimmar"
L["Silence rested emotes"] = "Desactivar emotes de Descanso"
L["Silithus"] = "Silithus"
L["Silverpine Forest"] = "Bosque Argenteos"
L["Silvershard Mines"] = "Minas Lonjaplata"
L["Skyreach"] = "Trecho Celestial"
L["Slave Pens"] = "Recinto de los Esclavos"
L["Sniffing"] = "Olfateando"
L["Social"] = "Social"
L["Sold junk for"] = "Vendió basura por"
L["Sound system restarted."] = "El sistema de sonido se reinició."
L["Southern Barrens"] = "Baldíos del Sur"
L["Spell ID"] = "ID de Hechizo"
L["Spine of Deathwing"] = "Espinazo de Alamuerte"
L["Spires of Arak"] = "Pináculos ed Arak"
L["Steamvault"] = "La Cámara del Vapor"
L["Stockade"] = "Las Mazmorras"
L["Stonecore"] = "El Núcleo Pétreo"
L["Stonetalon Mountains"] = "Sierra Espolón"
L["Stop"] = "Parar"
L["Storm Peaks"] = "Cumbres Tormentosas"
L["Stormheim"] = "Stormheim"
L["Stormheim (Alliance)"] = "Stormheim (Alianza)"
L["Stormheim (Horde)"] = "Stormheim (Horda)"
L["Stormsong Valley"] = "Valle Cantotormenta"
L["Stormstout Brewery"] = "Cerveceria del Trueno"
L["Stormwind"] = "Ventormenta"
L["Strand of the Ancients"] = "Playa de los Ancestros"
L["Stratholme"] = "Stratholme"
L["Stratholme: Crusader's Square"] = "Stratholme: Plaza de los Cruzados"
L["Stratholme: The Gauntlet"] = "Stratholme: El Guantelete"
L["Sunken Temple"] = "Templo Sumergido"
L["Sunwell Plateau"] = "Meseta de la Fuente del Sol"
L["Support"] = "Soporte técnico"
L["Suramar"] = "Suramar"
L["Swamp of Sorrows"] = "Pantano de las Penas"
L["Sync from friends"] = "Sincronización de los amigos"
L["System"] = "Sistema"
L["Tabard"] = "Tabardo"
L["Taint level: Basic (1)."] = "Nivel de contaminación: Básico (1)."
L["Taint level: Disabled (0)."] = "Nivel de contaminación: Desactivado (0)."
L["Taint level: Full (2)."] = "Nivel de contaminación: Completo (2)."
L["Talador"] = "Talador"
L["Tanaan Jungle"] = "Jungla de Tanaan"
L["Tanaris"] = "Tanaris"
L["Target"] = "Objetivo"
L["Target Tracking Disabled"] = "Seguimiento de objetivos desactivado"
L["Target Tracking Enabled"] = "Seguimiento de objetivos habilitado"
L["Tea with Jaina"] = "Té con Jaina"
L["Tel'anor"] = "Tel'anor"
L["Teldrassil"] = "Teldrassil"
L["Tempest Keep"] = "El Castillo de la Tempestad"
L["Temple of Ahn'Qiraj"] = "Templo de Ahn'Qiraj"
L["Temple of Atal'Hakkar"] = "Templo de Atal'Hakkar"
L["Temple of Sethraliss"] = "Templo de Sethraliss"
L["Temple of the Jade Serpent"] = "Templo del Dragon de Jade"
L["Ten Years of Warcraft"] = "Diez años de Warcraft"
L["Terokkar Forest"] = "Bosque de Terrokar"
L["Terrace of Endless Spring"] = "Veranda de la Primavera Eterna"
L["Terror of Darkshore"] = "Terror en Costaoscura"
L["Text"] = "Texto"
L["Text size"] = "Tamaño del texto"
L["Text Size"] = "Tamaño del texto"
L["The Art of War"] = "El Arte de la Guerra"
L["The Battle for Broken Shore"] = "La Batalla por la Costa Quebrada"
L["The Battle for Shattrath"] = "La Batalla por Shattrath"
L["The Battle of Thunder Pass"] = "La Batalla del Paso del Trueno"
L["The Burning Crusade"] = "The Burning Crusade"
L["The Demon's Trail"] = "El rastro del demonio"
L["The Dragon Soul"] = "ALma de Dragon"
L["The Eye"] = "El Ojo"
L["The Fall of Lordaeron"] = "La Caida de Lordaeron"
L["The Fate of Val'sharah"] = "El Destino de Val'sharah"
L["The Fleet in Krasarang (Alliance)"] = "La flota en Krasarang (Alianza)"
L["The Fleet in Krasarang (Horde)"] = "La flota en Krasarang (Horda)"
L["The Frozen Halls"] = "Los Salones Helados"
L["The Invasion Begins"] = "El Comienzo de la Invasionion"
L["The King's Command"] = "La orden del Rey"
L["The Negotiation"] = "La Negociación"
L["The Nightborne Pact"] = "El Pacto de lo Natonocturnos"
L["The Nighthold"] = "Bastion Nocturno"
L["The Return of Hope"] = "El retorno de la esperanza"
L["The summon from"] = "La invocación de"
L["The Threat Within"] = "La amenaza interior"
L["The Waning Crescent"] = "El Cuarto Menguante"
L["Themes"] = "Temas"
L["This command will assign your current pet team and selected abilities.|n|nPress CTRL/C to copy the command then paste it into a macro or chat window with CTRL/V."] = "Este comando asignará su equipo de mascotas actual y las habilidades seleccionadas.|n|nPresione CTRL/C para copiar el comando y luego péguelo en una macro o ventana de chat con CTRL/V."
L["This panel will close automatically if you enter combat."] = "Este panel se cerrará automáticamente si entras en combate."
L["Thousand Needles"] = "Mil Agujas"
L["Throne of the Four Winds"] = "Trono de los Cuatro Vientos"
L["Throne of the Tides"] = "Trono del las Mareas"
L["Throne of Thunder"] = "Solio del Trueno"
L["Thunder Bluff"] = "Cima del Trueno"
L["Timeless Isle"] = "Isla Intemporal"
L["Timer"] = "Temporizador"
L["Tiragarde Sound"] = "Estrecho de Tiragarde"
L["Tirisfal Glades"] = "Claros de Tirisfal"
L["Titan Panel screen adjust needs to be disabled for frames to be saved correctly."] = "El ajuste de pantalla de Titan Panel debe ser desactivado para que los cuadros se guarden correctamente."
L["To begin, choose an options page."] = "Para comenzar, elija una página de opciones."
L["To use the Find Item button, you need to deselect the WoW Token category."] = "Para usar el botón Encontrar artículo, tienes que deseleccionar la categoría Token del WoW."
L["Tol Barad"] = "Tol Barad"
L["Tol Dagor"] = "Tol Dagor"
L["Tomb of Sargeras"] = "Tumba de Sargeras"
L["Tooltip"] = "Tooltip"
L["Tooltip title color"] = "Color del título del Tooltip"
L["Top"] = "Superior"
L["Top Center"] = "Centro superior"
L["Townlong Steppes"] = "Estepas Towlong"
L["Tracing started."] = "El rastreo comenzó"
L["Tracing stopped."] = "El rastreo terminó"
L["Trains"] = "Trenes"
L["Transparency"] = "Transparencia"
L["Travelers"] = "Viajeros"
L["Trial of Style"] = "Prueba de Estilo"
L["Trial of the Champion"] = "Prueba del Campeón"
L["Trial of the Crusader"] = "Prueba del Crusado"
L["Trial of Valor"] = "Prueba del Valor"
L["True"] = "Verdadero"
L["Twilight Highlands"] = "Tierras Altas Crepusculares"
L["Twilight Vineyards"] = "Viñedos Crepusculares"
L["Twin Peaks"] = "Cumbres Gemelas"
L["Uldaman"] = "Uldaman"
L["Uldir"] = "Uldir"
L["Ulduar"] = "Ulduar"
L["Uldum"] = "Uldum"
L["Unclamp chat frame"] = "Desencadenar el marco del chat"
L["Underbog"] = "La Sotiénaga"
L["Undercity"] = "Entrañas"
L["Underrot"] = "Bardoma"
L["Un'Goro Crater"] = "Cráter de Un'Goro"
L["Universal group color"] = "Color de grupo universal"
L["Use arrow keys in chat"] = "Usar las teclas de flecha en el chat"
L["Use easy resizing"] = "Usar el cambio de tamaño fácil"
L["Use Leatrix Plus to move that frame."] = "Usa Leatrix Plus para mover ese cuadro."
L["Use Leatrix Plus to reset that frame."] = "Usa la Leatrix Plus para reajustar ese cuadro."
L["Utgarde Keep"] = "Fortaleza de Utgarde"
L["Utgarde Pinnacle"] = "Pináculo de Utgarde"
L["Vale of Eternal Blossoms"] = "El Valle de la Flor Eterna"
L["Valley of the Four Winds"] = "Valle de los Cuatro Vientos"
L["Val'sharah"] = "Val'sharah"
L["Value must be a number."] = "El valor debe ser un número."
L["Various"] = "Varios"
L["Vashj'ir"] = "Vashj'ir"
L["Vault of Archavon"] = "Bóveda de Archavon"
L["Vault of the Wardens"] = "Bóveda de las Celadoras"
L["Vaults"] = "Bóvedas"
L["Vendors"] = "Vendedores"
L["Version"] = "Version"
L["Victory at The Nighthold"] = "Victoria en el Bastión Nocturno"
L["Victory in Draenor!"] = "¡Victoria en Draenor!"
L["Video"] = "Video"
L["Violet Hold"] = "Bastión Violeta"
L["Visibility"] = "Visibilidad"
L["Vision of Sailor's Memory"] = "Visión de la memoria del marinero"
L["Visions of N'Zoth"] = "Visiones de N'Zoth"
L["Void Elves"] = "Elfos del Vacio"
L["Vol'dun"] = "Vol'dun"
L["Vol'mar"] = "Vol'mar"
L["Wailing Caverns"] = "Cuevas de los Lamentos"
L["Wandering Isle"] = "La isla Errante"
L["Warbringers Azshara"] = "Warbringers Azshara"
L["Warbringers Jaina"] = "Warbringers Jaina"
L["Warbringers Sylvanas"] = "Warbringers Sylvanas"
L["Warfronts"] = "Frentes de Guerra"
L["Warlords of Draenor"] = "Warlords of Draenor"
L["Warning"] = "Advertencia"
L["was automatically declined."] = "fue rechazada automáticamente."
L["Waycrest Manor"] = "Masion Tarjasenda"
L["Weather density"] = "La densidad del clima"
L["Welcome to Leatrix Plus."] = "Bienvenido a Leatrix Plus."
L["Well of Eternity"] = "Pozo de la Eternidad"
L["Western Plaguelands"] = "Tierras de la Peste del Oeste"
L["Westfall"] = "Páramos de Poniente"
L["Wetlands"] = "Los Humedales"
L["Widget"] = "Widget"
L["will be automatically accepted in 10 seconds unless cancelled."] = "se aceptará automáticamente en 10 segundos a menos que se cancele."
L["Winter"] = "Invierno"
L["Wintergrasp"] = "Conquista del Invierno"
L["Winterspring"] = "Cuna del Invierno"
L["World of Warcraft"] = "World of Warcraft"
L["Wrath of the Lich King"] = "Wrath of the Lich King"
L["Wyrmrest Temple"] = "Templo del Reposo del Dragón"
L["X Offset"] = "X Offset"
L["Y Offset"] = "Y Offset"
L["YOU"] = "TU"
L["You cannot do that in combat."] = "No puedes hacer eso en combate."
L["You do not own this pet.  Only owned pets can be searched."] = "No eres el dueño de esta mascota.  Sólo se pueden buscar las mascotas que se poseen."
L["You have"] = "Tienes..."
L["You need a battle pet team."] = "Necesitas un equipo de mascotas de batalla."
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "Su UI necesita ser recargada para que algunos de los cambios surtan efecto.|n|nNo tiene que hacer clic en el botón de recarga inmediatamente, pero sí tiene que hacerlo cuando termine de hacer los cambios y quiera que éstos surtan efecto"
L["Your UI needs to be reloaded."] = "Su UI necesita ser recargada."
L["Zandalar"] = "Zandalar"
L["Zandalari Trolls"] = "Trolls Zandalari "
L["Zangarmarsh"] = "Zangarmarsh"
L["Zones"] = "Zonas"
L["Zul'Aman"] = "Zul'Aman"
L["Zuldazar"] = "Zuldazar"
L["Zul'Drak"] = "Zul'Drak"
L["Zul'Farrak"] = "Zul'Farrak"
L["Zul'Gurub"] = "Zul'Gurub"
L["Zygor addon not found."] = "No se encuentra el addon Zygor."

end

-- esES: European Spanish
if GameLocale == "esES" then
L["A Deal with Death"] = "Un Trato con la Muerte"
L["A Falling Star"] = "Una Estrella Fugaz"
L["A Found Memento"] = "Un Recuerdo Encontrado"
L["A friend request from"] = "Una solicitud de amistad de"
L["A New Life for Undeath"] = "Una nueva vida para los No-muertos"
L["A Taste of Iron"] = "El Sabor del Hierro"
L["Accept resurrection"] = "Aceptar la resurrección"
L["Accept summon"] = "Acepta la invocación"
L["Account achievements are being shared."] = "Los logros de la cuenta se están compartiendo."
L["Account achievements are hidden."] = "Los logros de la cuenta están ocultos."
L["Addon"] = "Addon"
L["Adventure"] = "Aventura"
L["Ahn'kahet (Old Kingdom)"] = "Ahn'kahet: El Antiguo Reino"
L["All 3 battle pet slots need to be unlocked."] = "Las tres ranuras para mascotas de batalla deben ser desbloqueadas."
L["Allied Races"] = "Razas Aliadas"
L["An Unexpected Reunion"] = "Una Reunión Inesperada"
L["Anchor"] = "Anclaje"
L["And Justice for Thrall"] = "Justicia para Thrall"
L["Anduin's Theme"] = "El tema de Anduin"
L["Antoran Wastes (Argus)"] = "Baldío Antoran (Argus)"
L["Antorus Ending"] = "El final de Antorus"
L["Antorus, the Burning Throne"] = "Antorus, el Trono Ardiente"
L["Arathi Highlands"] = "Tierras Altas de Arathi"
L["Arcway"] = "La Arquería"
L["Arenas"] = "Arenas"
L["Arrival on Argus"] = "Llegada a Argus"
L["Arrival to Zandalar"] = "Llegada a Zandalar"
L["Ashenvale"] = "Vallefresno"
L["Ashran"] = "Ashran"
L["Assault on the Broken Shore"] = "Asalto a la Costa Quebrada"
L["Astravar Harbor"] = "Puerto de Astravar"
L["Atal'Dazar"] = "Atal'Dazar"
L["ATV"] = "ATV"
L["Auchenai Crypts"] = "Criptas de Auchenai"
L["Auchindoun"] = "Auchindoun"
L["AutoFollow"] = "Autoseguimiento"
L["AutoFollow disabled."] = "Autoseguimiento deshabilitado"
L["Automate gossip"] = "Automatizar los rumores"
L["Automate quests"] = "Automatizar las misiones"
L["Automation"] = "Automatización"
L["Azjol-Nerub"] = "Azjol-Nerub"
L["Azshara"] = "Azshara"
L["Azshara's Eternal Palace"] = "El Palacio Eterno de Azshara"
L["Azsuna"] = "Azsuna"
L["Azuremyst Isle"] = "Isla Bruma Azur"
L["Back to Main Menu"] = "Volver al menú principal"
L["Bad ID"] = "ID Incorrecta"
L["Badlands"] = "Tierras Inhóspitas"
L["Balls"] = "Bolas"
L["Ban-Lu"] = "Ban-Lu, compañero de los Grandes Maestros"
L["Baradin Hold"] = "Bastion de Baradin"
L["Barrens"] = "Los Baldíos"
L["Bastion of Twilight"] = "El Bastión del Crepúsculo"
L["Battle for Azeroth"] = "Battle for Azeroth"
L["Battle for Darkshore"] = "Batalla por Costaoscura"
L["Battle for Gilneas"] = "Batalla por Gilneas"
L["Battle for Stromgarde"] = "Batalla por Stromgarde"
L["Battle of Angrathar the Wrathgate"] = "La Batalla de Angrathar la Puerta de la Colera"
L["Battle of Dazar'alor"] = "Batalla por Dazar'alor"
L["Battle of Serpent's Heart"] = "Batalla del Corazón de la Serpiente"
L["Battlegrounds"] = "Campos de Batalla"
L["Bigger is Better (Alliance)"] = "Más grande es mejor (Alianza)"
L["Bigger is Better (Horde)"] = "Más grande es mejor (Horda)"
L["Bikes"] = "Bikes"
L["Black Morass"] = "La Ciénaga Negra"
L["Black Rook Hold"] = "Fuerte Torre Oscura"
L["Black Temple"] = "Templo Oscuro"
L["Blackfathom Deeps"] = "Cavernas de Brazanegra"
L["Blackrock Caverns"] = "Cavernas Roca Negra"
L["Blackrock Depths"] = "Profundidades de Roca Negra"
L["Blackrock Foundry"] = "Fundición Roca Negra"
L["Blackrock Mountain"] = "Montaña Roca Negra"
L["Blackrock Spire"] = "Cumbre de Roca Negra"
L["Blackwing Descent"] = "Descenso de Alanegra"
L["Blackwing Lair"] = "Guarida Alanegra"
L["Blade's Edge Mountains"] = "Montañas Filospada"
L["Blasted Lands"] = "Tierras Devastadas"
L["Block duels"] = "Bloquear duelos"
L["Block friend requests"] = "Bloquear solicitudes de amistad"
L["Block party invites"] = "Bloquear invitaciones a grupo"
L["Block pet battle duels"] = "Bloquear duelos de batalla de mascotas"
L["Blocks"] = "Bloques"
L["Bloodmaul Slag Mines"] = "Minas Machacasangre"
L["Bloodmyst Isle"] = "Isla Bruma de Sangre"
L["Borean Tundra"] = "Tundra Boreal"
L["Bottom"] = "Abajo"
L["Broken Isles"] = "Islas Quebradas"
L["Broken Shore"] = "Costa Quebrada"
L["Buffs"] = "Buffs"
L["Burning Steppes"] = "Estepas Ardientes"
L["Buyout Only"] = "Sólo la compra"
L["Camera distance"] = "Distancia de la cámara"
L["Cape of Stranglethorn"] = "El Cabo de Tuercespina"
L["Cataclysm"] = "Cataclysm"
L["Cathedral of Eternal Night"] = "Catedral de la Noche Eterna"
L["Caverns of Time"] = "Cavernas del Tiempo"
L["Chain style"] = "Estilo de cadena"
L["Character"] = "Personaje"
L["Chat"] = "Chat"
L["Chat Frame"] = "Cuadro de Chat"
L["Checkbox labels are Ok."] = "Las etiquetas de las casillas de verificación están bien."
L["Choose an Enigma pattern"] = "Elija un patrón de Enigma"
L["Cinematics"] = "Cinematicas"
L["Class colored frames"] = "Los marcos de color de clase"
L["Class icon portraits"] = "Retratos con iconos de clase"
L["Class Trials"] = "Pruebas de la clase"
L["click here for new selection"] = "haga clic aquí para la nueva selección"
L["Click to configure the settings for this option."] = "Haga clic para configurar los ajustes de esta opción."
L["Click to disable Dominos Encounter for all characters on this realm.  This is required for the player power bar position to be saved correctly.  Your UI will be reloaded."] = "Haz clic para desactivar el Encuentro de Dominos para todos los personajes de este reino.  Esto es necesario para que la posición de la barra de poder del jugador se guarde correctamente.  Tu UI se recargará."
L["Click to reset the settings on this page."] = "Haz clic para restablecer los ajustes de esta página."
L["Click to return to the main menu."] = "Haga clic para volver al menú principal."
L["Coilfang Reservoir"] = "Reserva de Colmillo Torcido"
L["Color the backdrops based on faction"] = "Colorear los tooltip en base a la facción"
L["Combat"] = "Combate"
L["Combat log cannot be hidden while undocked."] = "La bitácora de combate no puede ser escondida mientras se desacoplan."
L["Combat plates"] = "Placas de combate"
L["Completed."] = "Completado"
L["Configuration Panel"] = "Panel de configuración"
L["Connections for"] = "Conexiones para"
L["Court of Stars"] = "Corte de Estrellas"
L["Credits"] = "Creditos"
L["Crucible of Storms"] = "Crisol de Tormentas"
L["Crystalsong Forest"] = "Bosque Canto de Cristal"
L["Culling of Stratholme"] = "La Matanza de Stratholme"
L["Cursor"] = "Cursor"
L["Cursor Left"] = "A la izquerida del Cursor"
L["Cursor Right"] = "A la derecha del Cursor"
L["Dalaran"] = "Dalaran"
L["Dark Iron Dwarves"] = "Enanos Hierro Negro"
L["Dark Soil scanning activated.  Reload UI to exit."] = "Escaneo de Tierra Oscura activado.  Recargue la interfaz de usuario para salir."
L["Dark Soil scanning is already activated.  You only need to run this once.  Reload UI to exit."] = "El escaneo del suelo oscuro ya está activado.  Sólo necesitas ejecutar esto una vez.  Recargue la interfaz de usuario para salir."
L["Darkheart Thicket"] = "Matorral Corazón Oscuro"
L["Darkmoon Faire"] = "Feria de la Luna Negra"
L["Darkness Falls"] = "La oscuridad cae"
L["Darkshore"] = "Costaoscura"
L["Darnassus"] = "Darnassus"
L["Deadmines"] = "Minas de la Muerte"
L["Deepholm"] = "Infralar"
L["Deepwind Gorge"] = "Cañón del Céfiro"
L["Desolace"] = "Desolace"
L["Destiny Unfulfilled"] = "Destino incumplido"
L["Dire Maul"] = "La Masacre"
L["Dire Maul: Capital Gardens"] = "La Masacre: Jardines de la Capital"
L["Dire Maul: Gordok Commons"] = "La Masacre: Ágora de Gordok"
L["Dire Maul: Warpwood Quarter"] = "La Masacre: Barrio Alabeo"
L["Disable bag automation"] = "Desactivar la automatización de la bolsa"
L["Disable chat fade"] = "Desactivar el desvanecimiento del chat"
L["Disable loot warnings"] = "Desactivar las advertencias de botín"
L["Disable pet automation"] = "Desactivar la automatización de las mascotas"
L["Disable screen effects"] = "Desactivar los efectos de la pantalla"
L["Disable screen glow"] = "Desactivar el brillo de la pantalla"
L["Disable sticky chat"] = "Deshabilitar el chat bloqueado"
L["Dominos Encounter needs to be disabled."] = "El Encuentro del Dominó tiene que ser desactivado."
L["Draenor"] = "Draenor"
L["Drag the frame overlay to position the frame."] = "Arrastra la superposición del marco para posicionarlo."
L["Drag the frame overlays to position the frames.|n|nTo change the scale of a frame, click it to select it then adjust the scale slider.|n|nThis panel will close automatically if you enter combat."] = "Arrastre las superposiciones de los marcos para posicionarlos. Para cambiar la escala de un marco, haga clic en él para seleccionarlo y luego ajuste el deslizador de escala.|n|nEste panel se cerrará automáticamente si entra en combate."
L["Drag to set the cursor X offset."] = "Arrastre para establecer el desplazamiento del cursor en X."
L["Drag to set the cursor Y offset."] = "Arrastre para establecer el desplazamiento del cursor en Y."
L["Drag to set the density of weather effects."] = "Arrastre para establecer la densidad de los efectos del clima."
L["Drag to set the font size of mail text."] = "Arrastre para establecer el tamaño de la fuente del texto del correo."
L["Drag to set the font size of quest text."] = "Arrastra para establecer el tamaño de la fuente del texto de la misión."
L["Drag to set the minimap scale.|n|nNote that if you are using the default action bars, rescaling the minimap will also rescale the right action bars at startup so you may want to leave this at 100%."] = "Arrastra para establecer la escala del minimap.|n|nNota que si estás usando las barras de acción por defecto, reajustar el minimap también reajustará las barras de acción correctas al inicio, por lo que puede que quieras dejar esto al 100%."
L["Drag to set the scale of the Leatrix Plus panel."] = "Arrastre para establecer la escala del panel de Leatrix Plus."
L["Drag to set the scale of the selected frame."] = "Arrastre para establecer la escala del cuadro seleccionado."
L["Drag to set the size of the bottom border."] = "Arrastre para establecer el tamaño del borde inferior."
L["Drag to set the size of the left border."] = "Arrastre para establecer el tamaño del borde izquierdo."
L["Drag to set the size of the right border."] = "Arrastre para establecer el tamaño del borde derecho."
L["Drag to set the size of the top border."] = "Arrastre para establecer el tamaño del borde superior."
L["Drag to set the tooltip scale."] = "Arrastre para establecer la escala del Tooltip."
L["Drag to set the transparency of the borders."] = "Arrastre para establecer la transparencia de los bordes."
L["Drag to set the transparency of the Leatrix Plus panel."] = "Arrastre para establecer la transparencia del panel de Leatrix Plus."
L["Dragon Soul"] = "Alma de Dragon"
L["Dragonblight"] = "Cementerio de Dragones"
L["Drak'Tharon Keep"] = "Fortaleza de Drak'Tharon"
L["Dread Wastes"] = "Desierto del Pavor"
L["Drustvar"] = "Drustvar"
L["Dun Morogh"] = "Dun Morogh"
L["Dungeon"] = "Calabozo"
L["Dungeons"] = "Calabozos"
L["Dup ID"] = "Dup ID"
L["durability"] = "durabilidad"
L["Durability"] = "Durabilidad"
L["Durotar"] = "Durotar"
L["Duskwood"] = "Bosque del Ocaso"
L["Dustwallow Marsh"] = "Marjal Revolcafango"
L["Eastern"] = "Este"
L["Eastern Kingdoms"] = "Reinos del Este"
L["Eastern Plaguelands"] = "Tierras de la Peste del Este"
L["ELITE"] = "ELITE"
L["Elwynn Forest"] = "Bosque de Elwynn"
L["Embassies"] = "Embajadas"
L["Embers of War"] = "Las cenizas de la guerra"
L["Emerald Nightmare"] = "Pesadilla Esmeralda"
L["Enable hotkey"] = "Activar Hotkey"
L["End Time"] = "Tiempo final"
L["Enhance dressup"] = "Probador Mejorado"
L["Enhancements"] = "Mejoras"
L["Enigma"] = "Enigma"
L["Enter the spell IDs for the cooldown icons that you want to see.|n|nIf a cooldown icon normally appears under the pet frame, check the pet checkbox.|n|nCooldown icons are saved to your class and specialisation."] = "Ingresa los ID de los hechizos de los iconos de enfriamiento que deseas ver.|n|nSi un icono de enfriamiento aparece normalmente debajo del marco de la mascota, marca la casilla de verificación de la mascota.|n|nLos iconos de enfriamiento se guardan en tu clase y especialización."
L["enter zone or track name"] = "introduzca el nombre de la zona o de la pista"
L["Epilogue (Alliance)"] = "Epílogo (Alianza)"
L["Epilogue (Horde)"] = "Epílogo (Horda)"
L["Error messages will be hidden"] = "Los mensajes de error se ocultarán"
L["Error messages will be shown"] = "Se mostrarán mensajes de error"
L["Establish Your Garrison (Alliance)"] = "Establece tu Cuartel (Alianza)"
L["Establish Your Garrison (Horde)"] = "Establece tu Cuartel (Horda)"
L["Eternal Palace"] = "El Palacio Eterno"
L["Events"] = "Eventos"
L["Everbloom"] = "Sempibrote"
L["Evermoon Terrace"] = "Evermoon Terrace"
L["Eversong Woods"] = "Bosque Cancion Eterna"
L["Extras"] = "Extras"
L["Eye of Azshara"] = "Ojo de Azshara"
L["Eye of Eternity"] = "Ojo de la Eternidad"
L["Falanaar"] = "Falanaar"
L["Fall of Deathwing"] = "la caida de Alamuerte"
L["Fall of the Lich King"] = "la caida del Rey Exanime"
L["False"] = "Falso"
L["Faster auto loot"] = "Saqueo automático más rápido"
L["Faster movie skip"] = "Salto de cinematica más rápido"
L["Fate of the Horde"] = "El Destino de la Horda"
L["Features"] = "Características"
L["Felsoul Hold"] = "Felsoul Hold"
L["Felwood"] = "Frondavil"
L["Feralas"] = "Feralas"
L["Find Item"] = "Encuentra el item"
L["Firelands"] = "Tierras del Fuego"
L["Fizzle"] = "Fizzle"
L["Forge of Souls"] = "Forja de Almas"
L["Frames"] = "Cuadros"
L["Freehold"] = "Puerto Libre"
L["Frostfire Ridge"] = "Cresta Pirofrio"
L["Game Options"] = "Opciones de juego"
L["Gate of the Setting Sun"] = "La puerta del sol poniente"
L["General"] = "General"
L["Ghost"] = "Fantasma"
L["Ghostlands"] = "Tierras Fantasmas"
L["Gnomeregan"] = "Gnomeregan"
L["Gold Only"] = "Solo Oro"
L["Gorgrond"] = "Gorgrond"
L["Graphics and Sound"] = "Gráficos y sonido"
L["Grim Batol"] = "Grim Batol"
L["Grimrail Depot"] = "Depósito Riel Siniestro"
L["Grizzly Hills"] = "Colinas Pardas"
L["Groups"] = "Grupos"
L["Gruul's Lair"] = "Guarida de Gruul"
L["Gul'dan Ascendant"] = "Gul'dan Ascendant"
L["Gul'dan's Plan"] = "El plan de Gul'dan"
L["Gundrak"] = "Gundrak"
L["Halls of Lightning"] = "Cámaras de Relámpagos"
L["Halls of Origination"] = "Cámaras de los Orígenes"
L["Halls of Reflection"] = "Cámaras de Reflexión"
L["Halls of Stone"] = "Cámaras de Piedra"
L["Halls of Valor"] = "Cámaras del Valor"
L["Harbingers Gul'dan"] = "Harbingers Gul'dan"
L["Harbingers Illidan"] = "Harbingers Illidan"
L["Harbingers Khadgar"] = "Harbingers Khadgar"
L["Havenswood"] = "Havenswood"
L["Heart of Fear"] = "Corazon del Miedo"
L["Hellfire Citadel"] = "Ciudadela de Fuego Infernal"
L["Hellfire Peninsula"] = "Peninsula de Fuego infernal"
L["Hellfire Ramparts"] = "Murallas del Fuego Infernal"
L["Hellscream's Downfall (Alliance)"] = "La Caida de Gritoinfermal (Alianza)"
L["Hellscream's Downfall (Horde)"] = "La Caida de Gritoinfermal (Horda)"
L["Help"] = "Ayuda"
L["Hide alerts"] = "Ocultar Alertar"
L["Hide bodyguard gossip"] = "Ocultar dialogos de los guardaespaldas"
L["Hide boss banner"] = "Ocultar la bandera del jefe"
L["Hide chat buttons"] = "Ocultar Botones del Chat"
L["Hide clean-up buttons"] = "Ocultar Botones de Limpieza"
L["Hide cooldown duration numbers (if enabled)"] = "Ocultar numeros de enfriamiento (si esta activado)"
L["Hide error messages"] = "Ocultar mensajes de error"
L["Hide gryphons"] = "Ocultar Grifos de la barra de Habilidades"
L["Hide level-up display"] = "Ocultar  mensaje de Subida de Nivel"
L["Hide order hall bar"] = "Ocultar  Barra de la sala de Clase"
L["Hide portrait numbers"] = "Ocultar  numeros de daño en el retrato"
L["Hide social button"] = "Ocultar  Boton Social"
L["Hide stance bar"] = "Ocultar la barra de posición"
L["Hide talking frame"] = "Ocultar  Cuadro de Dialogo"
L["Hide the clock"] = "Ocultar  el Reloj"
L["Hide the combat log"] = "Ocultar  Registro de Combate"
L["Hide the zone text bar"] = "Ocultar  Barra con nombre de zona"
L["Hide the zoom buttons"] = "Ocultar  botones de zoom"
L["Hide tooltips for world units during combat"] = "Ocultar  Tooltip durante el combate"
L["Hide zone text"] = "Ocultar  Texto de Zona"
L["High"] = "Alto"
L["Highmaul"] = "Gran Magullador"
L["Highmountain"] = "Altamontaña"
L["Highmountain Tauren"] = "Taruren Altamontaña"
L["Hillsbrad Foothills"] = "Laderas de Trabalomas"
L["Hinterlands"] = "Tierras del Interior"
L["Home"] = "Casa"
L["Hour of Twilight"] = "Hora del Crepusculo"
L["Howling Fjord"] = "Fiordo Aquilonal"
L["Hyjal Summit"] = "La Cima Hyjal"
L["Icecrown"] = "Corona de Hielo"
L["Icecrown Citadel"] = "Ciudadela de Corona de Hielo"
L["If checked, a button will be added to the character sheet which will show your equipped item durability when you hover the pointer over it.|n|nIn addition, an overall percentage will be shown in the chat frame when you die."] = "Si está marcado, se añadirá un botón a la hoja de personaje que mostrará la durabilidad de tu objeto equipado cuando pases el puntero sobre él. Además, se mostrará un porcentaje general en el marco del chat cuando mueras."
L["If checked, a group invite will be sent to anyone who whispers you with a set keyword as long as you are ungrouped, group leader or raid assistant."] = "Si está marcada, se enviará una invitación de grupo a cualquiera que te susurre con una palabra clave establecida, siempre y cuando no estés agrupado, seas líder de grupo o ayudante de asalto."
L["If checked, a group invite will be sent to anyone who whispers you with the keyword INV.|n|nYou need to be either ungrouped or party leader in your own group for this to work."] = "Si está marcada, se enviará una invitación de grupo a cualquiera que te susurre con la palabra clave INV.|n|Necesitas ser desgrupado o líder del partido en tu propio grupo para que esto funcione."
L["If checked, a master volume slider will be shown on the character sheet.|n|nThe volume slider can be placed in either of two locations on the character sheet.  To toggle between them, hold the shift key down and right-click the slider."] = "Si se marca, se mostrará un deslizador de volumen maestro en la hoja de personajes.|n|nPara alternar entre ellas, mantenga pulsada la tecla Mayúsculas y haga clic con el botón derecho del ratón en el control deslizante."
L["If checked, a minimap button will be available.|n|nClick - Toggle options panel.|n|nSHIFT/Left-click - Toggle music.|n|nSHIFT/Right-click - Toggle stopwatch.|n|nCTRL/Left-click - Toggle minimap target tracking.|n|nCTRL/Right-click - Toggle errors (if enabled).|n|nCTRL/SHIFT/Left-click - Toggle Zygor (if installed).|n|nCTRL/SHIFT/Right-click - Toggle windowed mode."] = "Si está marcado, un botón de minimapa estará disponible.|n|nClick - Panel de opciones de conmutación.|nSHIFT/Left-click - Cambiar la música.|nSHIFT/Right-click - Cambiar el cronómetro. |n|nCTRL/Left-click - Cambiar seguimiento del minimapa.|n|nCTRL/Right-click - Cambiar errores (si esta activado).|n|nCTRL/SHIFT/Left-click - cambiar Zygor (si esta activado).|n|n|nCTRL/SHIFT/Right-click - cambiar a modo ventana."
L["If checked, alert frames will not be shown."] = "Si se marca, los cuadros de alerta no se mostrarán."
L["If checked, all grey items in your bags will be sold automatically when you visit a merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "Si está marcada, todos los artículos grises de sus bolsas se venderán automáticamente cuando visite a un comerciante.|n|nPuede mantener pulsada la tecla de mayúsculas cuando hable con un comerciante para anular esta configuración."
L["If checked, backdrops will be tinted blue (friendly) or red (hostile)."] = "Si se revisa, los fondos serán teñidos de azul (amistoso) o rojo (hostil)."
L["If checked, Ban-Lu will no longer talk to you."] = "Si se comprueba, Ban-Lu ya no hablará contigo."
L["If checked, battle pets which are automatically summoned will be dismissed within a few seconds.|n|nThis includes dragging a pet onto the first team slot in the pet journal and entering a battle pet team save command.|n|nNote that pets which are automatically summoned during combat will be dismissed when combat ends."] = "Si está marcado, las mascotas de batalla que son convocadas automáticamente serán descartadas en pocos segundos.|n|nEsto incluye arrastrar una mascota a la ranura del primer equipo en el diario de mascotas e ingresar un comando de guardar equipo de mascotas de batalla.|n|nTengan en cuenta que las mascotas que son convocadas automáticamente durante el combate serán despedidas cuando el combate termine."
L["If checked, battle shouts heard when casting specific spells will be muted."] = "Si se comprueba, se silenciarán los gritos de batalla que se escuchen cuando se lancen hechizos específicos."
L["If checked, BattleTag and Real ID friend requests will be automatically declined.|n|nEnabling this option will automatically decline any pending requests."] = "Si está marcada, las solicitudes de amistad de BattleTag y Real ID serán rechazadas automáticamente."
L["If checked, chat frame buttons will be hidden.|n|nClicking chat tabs will automatically show the latest messages.|n|nUse the mouse wheel to scroll through the chat history.  Hold down SHIFT for page jump or CTRL to jump to the top or bottom of the chat history."] = "Si está marcada, los botones del marco del chat estarán ocultos. Al hacer clic en las pestañas del chat se mostrarán automáticamente los últimos mensajes.|n|nUsa la rueda del ratón para desplazarte por el historial del chat.  Mantén pulsada la tecla MAYÚS para saltar a la página o la tecla CTRL para saltar a la parte superior o inferior del historial de chat."
L["If checked, chat text will not fade out after a time period."] = "Si se marca, el texto del chat no se desvanecerá después de un período de tiempo."
L["If checked, class coloring will be used in the player frame, target frame and focus frame."] = "Si está marcada, se utilizará el color de la clase en el marco del jugador, en el marco del objetivo y en el marco de enfoque."
L["If checked, class icons will be shown in the portrait frames."] = "Si se marca, los iconos de clase se mostrarán en los marcos de los retratos."
L["If checked, confirmations will no longer appear when you choose a loot roll option or attempt to sell or mail a tradable item."] = "Si se marca, las confirmaciones ya no aparecerán cuando elija una opción de botín o intente vender o enviar por correo un artículo comercial."
L["If checked, converting a party group to a raid group will succeed even if there are low level characters in the group.|n|nEveryone in the group needs to have Leatrix Plus installed with this option enabled."] = "Si está marcada, la conversión de un grupo a una banda tendrá éxito incluso si hay caracteres de bajo nivel en el grupo.|n|nTodos en el grupo necesitan tener Leatrix Plus instalado con esta opción activada."
L["If checked, cooldown duration numbers will not be shown over the cooldowns.|n|nIf unchecked, cooldown duration numbers will be shown over the cooldowns if they are enabled in the game options panel ('ActionBars' menu)."] = "Si está marcada, los números de enfriamiento no se mostrarán sobre los iconos.|n|n Si no está marcada, los números de duración del enfriamiento se mostrarán sobre los iconos si están activados en el panel de opciones del juego (menú 'Barras de Acción')."
L["If checked, damage and healing numbers in the player and pet portrait frames will be hidden."] = "Si se comprueba, los números de daño y curación en los marcos de los retratos de jugadores y mascotas se ocultarán."
L["If checked, dragging the General chat tab while the chat frame is locked will expand the chat frame upwards.|n|nIf the chat frame is unlocked, dragging the General chat tab will move the chat frame."] = "Si está activada, al arrastrar la pestaña de chat general con el marco de chat bloqueado se expandirá el marco de chat hacia arriba.|n|nSi el marco del chat está desbloqueado, al arrastrar la pestaña de chat general se moverá el marco del chat."
L["If checked, duel requests will be blocked unless the player requesting the duel is in your friends list or guild."] = "Si se marca, las solicitudes de duelo serán bloqueadas a menos que el jugador que solicita el duelo esté en su lista de amigos o en su gremio."
L["If checked, emote sounds will be silenced while your character is:|n|n- resting|n- in a pet battle|n- at the Halfhill Market|n- at the Grim Guzzler|n|nEmote sounds will be enabled when none of the above apply."] = "Si está marcado, los sonidos de emotes serán silenciados si: |n|n- descansando|n- duelo de mascotas|n- en el Halfhill Market|n- en el Grim Guzzler|n|nLos sonidos de emotes se activarán cuando no se aplique nada de lo anterior."
L["If checked, enemy nameplates will be shown during combat and hidden when combat ends."] = "Si está marcada, las placas del enemigo se mostrarán durante el combate y se ocultarán cuando éste termine."
L["If checked, gear toggle buttons will be added to the dressup frame and model positioning controls will be removed."] = "Si se marca, se añadirán botones de cambio de equipo al marco del vestidor y se eliminarán los controles de posicionamiento del modelo."
L["If checked, group invites will only be sent to friends and guild members.|n|nIf unchecked, group invites will be sent to everyone."] = "Si está marcada, las invitaciones de grupo sólo se enviarán a amigos y miembros del gremio.|n|nSi no está marcada, las invitaciones de grupo se enviarán a todos."
L["If checked, guild ranks will be shown for players in your guild."] = "Si se marca, se mostrarán los rangos de los jugadores de tu gremio."
L["If checked, most error messages (such as 'Not enough rage') will not be shown.  Some important errors are excluded.|n|nIf you have the minimap button enabled, you can hold down the control key and right-click it to toggle error messages without affecting this setting."] = "Si se marca, la mayoría de los mensajes de error (como 'No hay suficiente rabia') no se mostrarán.  Se excluyen algunos errores importantes.|n|nSi tienes activado el botón de minimapa, puedes mantener pulsada la tecla de control y hacer clic con el botón derecho del ratón para alternar los mensajes de error sin que ello afecte a esta configuración."
L["If checked, most of the bike mount sounds will be muted."] = "Si se comprueba, la mayoría de los sonidos del monturas motorizadas serán silenciados."
L["If checked, party invitations from friends or guild members will be automatically accepted unless you are queued in Dungeon Finder."] = "Si se marca, las invitaciones de amigos o miembros del gremio serán aceptadas automáticamente a menos que estés en la cola de Buscador de Mazmorras."
L["If checked, party invitations will be blocked unless the player inviting you is in your friends list or guild."] = "Si está marcado, las invitaciones a grupo se bloquearán a menos que el jugador que te invita esté en tu lista de amigos o en tu gremio."
L["If checked, party sync requests from friends or guild members will be automatically accepted."] = "Si está marcada, las solicitudes de sincronización de grupo por amigos o miembros del gremio serán aceptadas automáticamente."
L["If checked, pet battle duel requests will be blocked unless the player requesting the duel is in your friends list or guild."] = "Si está marcada, las solicitudes de duelo de mascotas serán bloqueadas a menos que el jugador que solicita el duelo esté en tu lista de amigos o en tu gremio."
L["If checked, profession filter settings will be saved for the remainder of your login session."] = "Si está marcada, la configuración del filtro de profesión se guardará para el resto de la sesión de juego."
L["If checked, quests will be selected, accepted and turned-in automatically.|n|nQuests which have a gold, currency or crafting reagent requirement will not be turned-in automatically.|n|nYou can hold the shift key down when you talk to a quest giver to override this setting."] = "Si está marcada, las misiones serán seleccionadas, aceptadas y entregadas automáticamente.|n|nLas misiones que tengan un requisito de oro, moneda o material de profesion no se entregarán automáticamente.|n|nPuedes mantener pulsada la tecla de mayúsculas cuando hables con alguien para anular esta configuración."
L["If checked, raid chat and instance chat will both be colored blue (to match the default party chat color)."] = "Si está marcada, tanto el chat de Banda como el de instancia serán de color azul (para que coincida con el color de chat de grupo predeterminado)."
L["If checked, repair costs will be taken from guild funds for characters that are guilded and have permission to repair."] = "Si se comprueba, los gastos de reparación se tomarán de los fondos del gremio para los personajes que son gremiados y tienen permiso para reparar."
L["If checked, requests initiated by your party leader to join the Dungeon Finder queue will be automatically accepted if the party leader is in your friends list or guild.|n|nThis option requires that you have selected a role for your character in the Dungeon Finder window."] = "Si está marcada, las solicitudes iniciadas por el líder de tu partido para unirse a la cola del Buscador de Mazmorras se aceptarán automáticamente si el líder del partido está en tu lista de amigos o en tu gremio.|n|nEsta opción requiere que hayas seleccionado un papel para tu personaje en la ventana del Dungeon Finder."
L["If checked, resurrection requests will be accepted automatically as long as the player resurrecting you is not in combat.|n|nResurrection requests from a Brazier of Awakening or a Failure Detection Pylon will not be accepted automatically."] = "Si está marcada, las solicitudes de resurrección serán aceptadas automáticamente siempre y cuando el jugador que te resucite no esté en combate.|n|nLas solicitudes de resurrección de un Brasero del Despertar o de un Pilón de Detección de Fallas no serán aceptadas automáticamente."
L["If checked, spell IDs will be shown in buff icon tooltips located in the buff frame and under the target frame."] = "Si se marca, las ID de los hechizos se mostrarán en los tooltips de los iconos de la barra de buffos y en los iconos debajo el cuadro de objetivo."
L["If checked, sticky chat will be disabled.|n|nNote that this does not apply to temporary chat windows."] = "Si está marcada, el chat pegajoso será desactivado.|n|nTen en cuenta que esto no se aplica a las ventanas de chat temporales."
L["If checked, summon requests will be accepted automatically unless you are in combat."] = "Si se comprueba, las solicitudes de citación se aceptarán automáticamente a menos que esté en combate."
L["If checked, the addon list (accessible from the game menu) will show character based addons by default."] = "Si está marcada, la lista de complementos (accesible desde el menú del juego) mostrará complementos basados en los personajes de forma predeterminada."
L["If checked, the amount of time it takes to auto loot creatures will be significantly reduced."] = "Si se comprueba, la cantidad de tiempo que toma el auto saqueo de las criaturas se reducirá significativamente."
L["If checked, the backpack clean-up button and the bank frame clean-up button will not be shown."] = "Si se comprueba, el botón de limpieza de la mochila y el botón de limpieza del marco del banco no se mostrarán."
L["If checked, the boss banner will not be shown.|n|nThe boss banner appears when a boss is defeated.  It shows the name of the boss and the loot that was distributed."] = "Si está marcada, el banner del jefe no se mostrará. |n|nEl banner del jefe aparece cuando un jefe es derrotado.  Muestra el nombre del jefe y el botín que fue distribuido."
L["If checked, the button to toggle the raid container frame will be shown just above the raid management frame (left side of the screen) instead of in the raid management frame itself.|n|nThis allows you to toggle the raid container frame without needing to open the raid management frame."] = "Si está seleccionado, el botón para cambiar el marco del contenedor del raid se mostrará justo encima del marco de gestión del banda (lado izquierdo de la pantalla) en lugar de en el propio marco de gestión del banda.|n|nEsto le permite cambiar el marco del contenedor de la redada sin necesidad de abrir el marco de gestión de la banda."
L["If checked, the clock will be hidden."] = "Si se comprueba, el reloj estará oculto."
L["If checked, the combat log will be hidden.|n|nThe combat log must be docked in order for this option to work.|n|nIf the combat log is undocked, you can dock it by dragging the tab (and reloading your UI) or by resetting the chat windows (from the chat menu)."] = "Si está marcada, el registro de combate se ocultará.|n|nEl registro de combate debe estar anclado para que esta opción funcione.|n|nSi el registro de combate está desanclado, puedes anclarlo arrastrando la pestaña (y recargando la interfaz de usuario) o restableciendo las ventanas de chat (desde el menú de chat)."
L["If checked, the 'Display only character achievements to others' setting in the game options panel ('Social' menu) will be permanently checked and locked."] = "Si está marcada, la opción 'Mostrar sólo los logros de los personajes a los demás' en el panel de opciones del juego (menú 'Social') estará permanentemente marcada y bloqueada."
L["If checked, the editbox will be moved to the top of the chat frame."] = "Si está marcada, la caja de edición se moverá a la parte superior del marco del chat."
L["If checked, the Foot Ball sounds will be muted."] = "Si se comprueba, los sonidos de la Footballserán silenciados."
L["If checked, the gossip window will not be shown when you talk to an active garrison bodyguard.|n|nYou can hold the shift key down when you talk to a bodyguard to override this setting."] = "Si está marcada, la ventana de chismes no se mostrará cuando hable con un guardaespaldas de la guarnición activa.|n|nPuede mantener pulsada la tecla shift cuando hable con un guardaespaldas para anular esta configuración."
L["If checked, the grey screen of death and the netherworld effect will be disabled."] = "Si se marca, la pantalla gris de la muerte y el efecto del inframundo se desactivarán."
L["If checked, the interface button sound, the chat frame tab click sound and the game menu toggle sound will be muted."] = "Si está marcada, el sonido del botón de la interfaz, el sonido del clic de la pestaña del marco de chat y el sonido de la conmutación del menú del juego se silenciarán."
L["If checked, the level-up display will not be shown.|n|nThe level-up display shows encounter objectives, level-ups, pet battle rewards, etc."] = "Si está marcada, la pantalla de nivelación no se mostrará.|n|nLa pantalla de nivelación muestra los objetivos de encuentro, los niveles, las recompensas de las batallas con mascotas, etc."
L["If checked, the main bar gryphons will not be shown."] = "Si se marca, no se mostrarán los grifos de la barra principal."
L["If checked, the mechanical guild vault idle sound will be muted."] = "Si se comprueba, el sonido de la bóveda del gremio se silenciará."
L["If checked, the order hall command bar will not be shown."] = "Si está marcada, la barra de comandos de la sala de órdenes no se mostrará."
L["If checked, the player frame background will be shown in class color."] = "Si se marca, el fondo del marco del jugador se mostrará en el color de la clase."
L["If checked, the screen glow will be disabled.|n|nEnabling this option will also disable the drunken haze effect."] = "Si está marcada, el brillo de la pantalla se desactivará.|n|nAl activar esta opción también se desactivará el efecto de neblina de borrachera."
L["If checked, the social button and quick-join notification will be hidden."] = "Si se marca, el botón social y la notificación de unión rápida se ocultarán."
L["If checked, the spell fizzle sounds will be muted."] = "Si se comprueba, los sonidos de la efervescencia del hechizo serán silenciados."
L["If checked, the stance bar will not be shown."] = "Si se marca, la barra de posición no se mostrará."
L["If checked, the talking frame will not be shown.|n|nThe talking frame normally appears in the lower portion of the screen when certain NPCs communicate with you."] = "Si se marca, no se mostrará el marco de conversación.|n|nEl marco de conversación normalmente aparece en la parte inferior de la pantalla cuando ciertos PNJ se comunican con usted."
L["If checked, the target frame background and focus frame background will be shown in class color."] = "Si se marca, el fondo del marco del objetivo y el fondo del marco de enfoque se mostrarán en color de clase."
L["If checked, the tooltip will be color coded and you will be able to modify the tooltip layout and scale."] = "Si está marcada, la punta de la herramienta estará codificada con colores y podrá modificar el diseño y la escala de la punta de la herramienta."
L["If checked, the worgen sniffing sounds will be muted."] = "Si se comprueba, los sonidos de olfateo del Huargen serán silenciados."
L["If checked, the zone text bar will be hidden.  The tracking button tooltip will show zone information."] = "Si se marca, la barra de texto de la zona estará oculta.  El botón de seguimiento mostrará la información de la zona."
L["If checked, the zoom buttons will be hidden.  You can use the mousewheel to zoom regardless of this setting."] = "Si se marca, los botones de zoom estarán ocultos.  Puedes usar la rueda del ratón para hacer zoom independientemente de esta configuración."
L["If checked, tooltips for world units will be hidden during combat.|n|nYou can hold the shift key down to override this setting."] = "Si está marcada, los datos de las unidades del mundo se ocultarán durante el combate.|n|nPuedes mantener presionada la tecla Shift para anular este ajuste."
L["If checked, train sounds will be muted."] = "Si se comprueba, los sonidos del tren serán silenciados."
L["If checked, traveling merchant greetings and farewells will be muted.|n|nThis applies to Traveler's Tundra Mammoth, Grand Expedition Yak and Mighty Caravan Brutosaur."] = "Si se marca, los saludos y despedidas de los comerciantes viajeros serán silenciados. Esto se aplica al Mamut de la Tundra del Viajero, al Yak de la Gran Expedición y al Brutosaurio de la Caravana Poderosa."
L["If checked, unit targets will be shown."] = "Si se marca, se mostrarán los objetivos de la unidad."
L["If checked, Wowhead links will be shown in the world map frame and the achievements frame."] = "Si se marca, los enlaces Wowhead se mostrarán en el marco del mapa mundial y en el marco de logros."
L["If checked, Xiwyllag ATV will be muted."] = "Si se comprueba, el ATV Xiwyllag será silenciado."
L["If checked, you can hold down the alt key while opening a gossip window to automatically select a single gossip option."] = "Si está marcada, puede mantener pulsada la tecla Alt mientras abre una ventana de chismes para seleccionar automáticamente una sola opción de chismes."
L["If checked, you can hold down the control key and click a chat tab to view recent chat in a copy-friendly window."] = "Si está marcada, puede mantener pulsada la tecla de control y hacer clic en una pestaña de chat para ver el chat reciente en una ventana de copia fácil."
L["If checked, you can open Leatrix Plus by pressing CTRL/Z."] = "Si está marcada, puedes abrir la Leatrix Plus pulsando CTRL/Z."
L["If checked, you can press the arrow keys to move the insertion point left and right in the chat frame.|n|nIf unchecked, the arrow keys will use the default keybind setting."] = "Si está marcada, puede pulsar las teclas de flecha para mover el punto de inserción a la izquierda y a la derecha en el marco de chat.|n|nSi no está marcada, las teclas de flecha utilizarán la configuración predeterminada del teclado."
L["If checked, you will be able to cancel cinematics without being prompted for confirmation."] = "Si está marcada, podrá cancelar las películas sin que se le pida confirmación."
L["If checked, you will be able to change the font size of quest text.|n|nEnabling this option will also change the text size of other frames which inherit the same font (such as the Dungeon Finder frame)."] = "Si está marcada, podrás cambiar el tamaño de la fuente del texto de la búsqueda.|n|nHabilitar esta opción también cambiará el tamaño del texto de otros marcos que heredan la misma fuente (como el marco de Buscador de Mazmorras)."
L["If checked, you will be able to change the font size of standard mail text.|n|nThis does not affect mail created using templates (such as auction house invoices)."] = "Si está marcada, podrá cambiar el tamaño de la fuente del texto del correo estándar.|n|nEsto no afecta al correo creado con plantillas (como las facturas de las casas de subastas)."
L["If checked, you will be able to customise the minimap."] = "Si está marcada, podrá personalizar el minimapa."
L["If checked, you will be able to drag the chat frame to the edge of the screen."] = "Si está marcada, podrás arrastrar el marco de chat hasta el borde de la pantalla."
L["If checked, you will be able to mute a selection of game sounds."] = "Si está marcada, podrá silenciar una selección de sonidos del juego."
L["If checked, you will be able to place up to five beneficial cooldown icons above the target frame."] = "Si está marcada, podrá colocar hasta cinco iconos de enfriamiento beneficiosos sobre el marco del objetivo."
L["If checked, you will be able to reposition the tooltip."] = "Si está marcada, podrá reposicionar el tooltip."
L["If checked, you will be able to save your current battle pet team (including abilities) to a single command.|n|nA button will be added to the Pet Journal.  Clicking the button will toggle showing the assignment command for your current team.  Pressing CTRL/C will copy the command to memory.|n|nYou can then paste the command (with CTRL/V) into the chat window or a macro to instantly assign your team."] = "Si está marcada, podrás guardar tu equipo actual de mascotas de batalla (incluyendo las habilidades) en un solo comando.|n|nUn botón se añadirá al diario de mascotas.  Al hacer clic en el botón, se mostrará el comando de asignación para tu equipo actual.  Al pulsar CTRL/C se copiará el comando a la memoria.|n|nPodrás entonces pegar el comando (con CTRL/V) en la ventana de chat o en una macro para asignar instantáneamente tu equipo."
L["If checked, you will be able to set the density of weather effects."] = "Si lo compruebas, podrás establecer la densidad de los efectos del clima."
L["If checked, you will be able to show a rare, elite or rare elite chain around the player frame."] = "Si se marca, podrás mostrar una cadena rara, de élite o de élite rara alrededor del cuadro del jugador."
L["If checked, you will be able to show customisable borders around the edges of the screen.|n|nThe borders are placed on top of the game world but under the UI so you can place UI elements over them."] = "Si está marcada, podrás mostrar bordes personalizables alrededor de los bordes de la pantalla.|n|nLos bordes se colocan en la parte superior del mundo del juego pero debajo de la interfaz de usuario para que puedas colocar elementos de la interfaz sobre ellos."
L["If checked, you will be able to zoom out to a greater distance."] = "Si se marca, podrás alejar el zoom a una distancia mayor."
L["If checked, you will release automatically after you die in Ashran, Tol Barad (PvP), Wintergrasp or any battleground.|n|nYou will not release automatically if you have the ability to self-resurrect (soulstone, reincarnation, etc)."] = "Si está marcado, se liberará automáticamente después de morir en Ashran, Tol Barad (PvP), Wintergrasp o cualquier campo de batalla.|n|nNo te liberarás automáticamente si tienes la habilidad de resucitarte a ti mismo (piedra del alma, reencarnación, etc.)."
L["If checked, your bags will not be opened or closed automatically when you interact with a merchant, bank or mailbox."] = "Si se registran, sus bolsas no se abrirán ni cerrarán automáticamente cuando interactúe con un comerciante, un banco o un buzón."
L["If checked, your chat history will increase to 4096 lines.  If unchecked, the default will be used (128 lines).|n|nEnabling this option may prevent some chat text from showing during login."] = "Si lo compruebas, tu historial de chat aumentará a 4096 líneas.  Si no está marcada, se utilizará el valor predeterminado (128 líneas).|n|nHabilitar esta opción puede evitar que se muestre algún texto de chat durante el inicio de sesión."
L["If checked, your gear will be repaired automatically when you visit a suitable merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "Si se comprueba, su equipo se reparará automáticamente cuando visite a un comerciante adecuado.|n|nPuede mantener pulsada la tecla shift cuando hable con un comerciante para anular este ajuste."
L["If checked, zone text will not be shown (eg. 'Ironforge')."] = "Si se marca, no se mostrará el texto de la zona (por ejemplo, 'Forjaz')"
L["Increase chat history"] = "Aumentar el historial de chat"
L["Interface"] = "Interfaz"
L["Into the Portal"] = "Dentro del Portal"
L["Invalid battle pet team parameter."] = "Parámetro de equipo de mascotas de batalla inválido."
L["Invalid console variable."] = "Variable de consola inválida."
L["Invalid parameter."] = "Parámetro inválido."
L["Invalid quest ID."] = "ID de Misión inválida"
L["Invalid sound ID"] = "ID de Sonido inválida"
L["Invalid taint level."] = "Nivel de contaminación inválido."
L["Invalid target."] = "Objetivo inválido."
L["Invite from whispers"] = "Invitación por susurros"
L["Iron Docks"] = "Muelles de Hierro"
L["Island Expeditions"] = "Expediciones Insulares"
L["Isle of Conquest"] = "Isla de Conquista"
L["Isle of Quel'Danas"] = "Isla de Quel'Danas"
L["Isle of Thunder"] = "Isla del Trueno"
L["Jade Forest"] = "Bosque de jade"
L["Jade Forest Crash"] = "Choque del Bosque de Jade"
L["Jaina Joins the Battle"] = "Jaina se une a la batalla"
L["Jaina Returns to Kul Tiras"] = "Jaina regresa a Kul Tiras"
L["Jaina's Nightmare"] = "La pesadilla de Jaina"
L["Jaina's Siege"] = "El asedio de Jaina"
L["Jaina's Theme"] = "Tema de Jaina"
L["Jorundall"] = "Jorundall"
L["Kalimdor"] = "Kalimdor"
L["Karazhan"] = "Karazhan"
L["Keyword"] = "Palabra clave"
L["Kezan"] = "Kezan"
L["Kil'jaeden's Downfall"] = "La caída de Kil'jaeden"
L["Kings' Rest"] = "Reposo de los Reyes"
L["Krasarang Wilds"] = "Espesura Krasarang"
L["Krokuun (Argus)"] = "Krokuun (Argus)"
L["Kul Tiran Humans"] = "Kultiranos"
L["Kul Tiras"] = "Kul Tiras"
L["Kun-Lai Summit"] = "Cima Kun-Lai"
L["Last Stand"] = "Ultima Etapa"
L["Leatrix Plus will not overwrite LeaPlusDB at next logout."] = "Leatrix Plus no sobrescribirá a LeaPlusDB en el próximo cierre de sesión."
L["LEATRIX PLUS: WRONG VERSION INSTALLED!"] = "LEATRIX PLUS: ¡VERSIÓN INCORRECTA INSTALADA!"
L["Leaving Kezan"] = "Dejando a Kezan"
L["Leaving the Wandering Isle"] = "Dejando la Isla Errante"
L["Left"] = "Salida"
L["Legion"] = "Legion"
L["Lifetime honorable kills"] = "Muertes honorables de por vida"
L["Lightforged Draenei"] = "Draenei Templeluz"
L["Lion's Watch"] = "La Guardia del León"
L["Loch Modan"] = "Loch Modan"
L["Lockout sharing"] = "Compartir el bloqueo"
L["Lost City of the Tol'vir"] = "Ciudad Perdida de los Tol'vir"
L["Lost Isles"] = "Islas Perdidas"
L["Low"] = "Bajo"
L["Lunastre Estate"] = "Finca de Lunastre"
L["Mac'Aree (Argus)"] = "Mac'Aree (Argus)"
L["Madness of Deathwing"] = "La locura de la Alamuerte"
L["Maelstrom"] = "Voragine"
L["Mag'har Orcs"] = "Orcos Mag'har"
L["Magisters' Terrace"] = "Bancal del Magister"
L["Magtheridon's Lair"] = "Guarida de Magtheridon"
L["Main Titles"] = "Títulos principales"
L["Manage frames"] = "Gestionar los marcos"
L["Managed by Leatrix Plus"] = "Gestionado por Leatrix Plus"
L["Mana-Tombs"] = "Tumbas de Mana"
L["Maraudon"] = "Maraudon"
L["Maraudon: Earth Song Falls"] = "Maraudon: Las Cataratas de la Canción de la Tierra"
L["Maraudon: Foulspore Cavern"] = "Maraudon: Foulspore Cavernas"
L["Maraudon: The Wicked Grotto"] = "Maraudon: La Gruta Malvada"
L["Mardum"] = "Mardum"
L["Maw of Souls"] = "Fauce de Almas"
L["Max camera zoom"] = "Zoom maximo de la camara"
L["Mechagon"] = "Mecalopolis"
L["Mechanics"] = "Mecanicas"
L["Media"] = "Medios"
L["Medium"] = "Medio"
L["Memory Usage"] = "Uso de Memoria"
L["message shown."] = "mensaje mostrado."
L["messages shown."] = "mensajes mostrados."
L["Missing console variable."] = "Falta la variable de la consola."
L["Missing mount name."] = "Falta el nombre de la montura."
L["Missing movie ID."] = "Falta ID de la cinematica"
L["Missing pet name."] = "Falta el nombre de la mascota"
L["Missing quest ID."] = "Falta el ID de la mision"
L["Missing sound file parameter."] = "Falta el parámetro del archivo de sonido."
L["Missing sound ID."] = "Falta el ID del sonido"
L["Mists of Pandaria"] = "Mist of Pandaria"
L["Mogu'shan Palace"] = "Palacio Mogu'shan"
L["Mogu'shan Vaults"] = "Camaras Mogu'shan"
L["Molten Core"] = "Núcleo de Magma"
L["Moon Guard Stronghold"] = "Fortaleza de la Guardia de la Luna"
L["Moonglade"] = "Claro de Luna"
L["Motherlode"] = "El Filon"
L["Mount Hyjal"] = "Monte Hyjal"
L["Mount not found."] = "Montura no encontrada"
L["Mounts"] = "Monturas"
L["Move editbox to top"] = "Mover la caja de edición a la parte superior"
L["Movie not playable."] = "La cinematica no se puede reproducir."
L["Movie number"] = "Número de la cinematica"
L["Movies"] = "Cinematicas"
L["Mulgore"] = "Mulgore"
L["Music"] = "Musica"
L["Music Rolls"] = "Rollos de música"
L["Mute game sounds"] = "Silenciar el Juego"
L["My Very Own Castle (Alliance)"] = "Mi propio castillo (Alianza)"
L["My Very Own Castle (Horde)"] = "Mi propio castillo (Horda)"
L["Mystical"] = "Místico"
L["Nagrand"] = "Nangrand"
L["Nagrand (Draenor)"] = "Nagrand (Draenor)"
L["Narration"] = "Narracion"
L["Naxxramas"] = "Naxxramas"
L["Nazjatar"] = "Nazjatar"
L["Nazmir"] = "Nazmir"
L["Neltharion's Lair"] = "Guarida de Neltharion"
L["Netherstorm"] = "Tormenta Abisal"
L["Nexus"] = "Nexo"
L["Nightborne"] = "Natonocturnos"
L["Nighthold"] = "Bastion Nocturno"
L["No bad sound IDs found."] = "No se encontraron ID de sonidos dañados"
L["No help is available for this page."] = "No hay ayuda disponible para esta página."
L["No items with durability equipped."] = "No hay artículos equipados con durabilidad."
L["No media duplicates found."] = "No se han encontrado duplicados de medios."
L["No tooltip showing."] = "No mostrar tooltips"
L["None"] = "No"
L["Northern Barrens"] = "Baldios del Norte"
L["Northern Stranglethorn"] = "Norte de la Vega de Tuercespina"
L["Northrend"] = "Rasganorte"
L["Not completed."] = "No se ha completado."
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Plus."] = "¡Aviso!|nDebes reiniciar completamente tu cliente de juego antes de que puedas usar esta versión de Leatrix Plus."
L["Nude"] = "Desnudo"
L["Ny'alotha"] = "Ny'alotha"
L["Obsidian Sanctum"] = "Santuario Osidiana"
L["Oculus"] = "Oculus"
L["Off"] = "Apagado"
L["Okay, disable Dominos Encounter for me"] = "Bien, deshabilita el Encuentros de Dominos para mí"
L["Okay, disable screen adjust for me"] = "Bien, desactiva el ajuste de la pantalla para mí"
L["Old Hillsbrad Foothills"] = "Antiguas Laderas de Trabalomas"
L["Onyxia's Lair"] = "Guarida de Onyxia"
L["Operation Mechagon"] = "Operacion Mecandria"
L["Orgrimmar"] = "Orgrimmar"
L["Outland"] = "Terrallende"
L["Overall"] = "En general"
L["Overlay"] = "Superposición"
L["Pandaria"] = "Pandaria"
L["Particle density"] = "Densidad de Particulas"
L["Party from friends"] = "Grupo con Amigos"
L["Pet"] = "Mascota"
L["Pet Battles"] = "Batalla de Mascotas"
L["Pet not found.  Only owned pets that are currently showing in the journal can be searched."] = "Mascota no encontrada.  Sólo se pueden buscar las mascotas que aparecen actualmente en el diario."
L["Pit of Saron"] = "Foso de Saron"
L["Plants vs Zombies"] = "Plantas vs Zombies"
L["Player"] = "Jugador"
L["Portal"] = "Portal"
L["Power"] = "Poder"
L["Power of the Horde"] = "Poder de la Horda"
L["Press CTRL/C to copy."] = "Presione CTRL/C para copiar."
L["Queue from friends"] = "Cola con amigos"
L["Ragefire Chasm"] = "Sima Ígnea"
L["Raid"] = "Banda"
L["Raid frame toggle"] = "Cambiar el marco de banda"
L["Random"] = "Aleatorio"
L["RARE"] = "RARE"
L["RARE ELITE"] = "RARE ELITE"
L["Razorfen Downs"] = "Zahúrda Rojacieno"
L["Razorfen Kraul"] = "Horado Rajacieno"
L["Realm Of Torment"] = "El reino del Tormento"
L["Recent chat window"] = "Ventana de chat reciente"
L["Reckoning"] = "Reckoning"
L["Redridge Mountains"] = "Montañas Crestagrana"
L["Reincarnation of Alleria Windrunner"] = "Reencarnación de Alleria Brizaveloz"
L["Rejection of the Gift"] = "Rechazo del regalo"
L["Release in PvP"] = "Liberar en PvP"
L["Reload"] = "Recargar"
L["Remove raid restrictions"] = "Quitar restricciones de Banda"
L["Repair automatically"] = "Reparar automáticamente"
L["Repair using guild funds if available"] = "Reparar con fondos del gremio si están disponibles"
L["Repaired for"] = "Reparado por"
L["Reposition the tooltip"] = "Reposicionar el tooltip"
L["Requires UI reload."] = "Requiere recarga de la UI."
L["Requires you to be interacting with Larana Drome.  She can be found at Scribes' Sacellum, Dalaran, Northrend."] = "Requiere que interactúes con el Larana Drome.  Se puede encontrar en el Scribes' Sacellum, Dalaran, Northrend."
L["Reset"] = "Resetear"
L["Resize mail text"] = "Cambiar el tamaño del texto del correo"
L["Resize quest text"] = "Cambiar el tamaño del texto de la misión"
L["Rested bubbles"] = "Burbujas de descanso"
L["Restrict to friends and guild members"] = "Restringir a los amigos y miembros del gremio"
L["result"] = "resultado"
L["results"] = "resultados"
L["Return to Karazhan"] = "Regreso a Karazhan"
L["Return to the Black Temple"] = "Regreso al Templo Oscuro"
L["Right"] = "Derecha"
L["Right-click to close"] = "Haga clic con el botón derecho del ratón para cerrar"
L["Right-click to close."] = "Haga clic con el botón derecho del ratón para cerrar"
L["right-click to go back"] = "haga clic con el botón derecho del ratón para cerrar"
L["Rise of Argus"] = "Alzamiento de Argus"
L["Rise of Azshara"] = "Alzamiento de Azshara"
L["Risking It All"] = "Arriesgándolo todo"
L["Ruby Sanctum"] = "Santuario Rubi"
L["Ruins of Ahn'Qiraj"] = "Ruinas de Ahn'Qiraj"
L["Ruins of Elune'eth"] = "Ruinas de Elune'eth"
L["Ruins of Gilneas"] = "Ruinas de Gilneas"
L["Sanctum of Order"] = "Santuario de la Orden"
L["Save profession filters"] = "Guardar los filtros de la profesión"
L["Scale"] = "Escala"
L["Scarlet Halls"] = "Scarlet Halls"
L["Scarlet Monastery"] = "Monasterio Escarlata"
L["Scholomance"] = "Scholomance"
L["Search"] = "Busca en"
L["Searing Gorge"] = "La Garganta Fuego"
L["Seat of the Triumvirate"] = "Trono del Triunvirato"
L["Select the settings that you want to use."] = "Seleccione los ajustes que desea utilizar."
L["Selection of music tracks"] = "Selección de pistas de música"
L["Self Markers Allowed"] = "Se permiten los auto-marcadores"
L["Self Markers Blocked"] = "Los auto-marcadores están bloqueados"
L["Sell junk automatically"] = "Vender basura automáticamente"
L["SELLING JUNK"] = "VENTA DE BASURA"
L["Serpentshrine Cavern"] = "Caverna Santuario Serpiente"
L["Set weather density"] = "Establecer la densidad del clima"
L["Sethekk Halls"] = "Salas Sethekk"
L["Settings"] = "Ajustes"
L["Shaders"] = "Shaders"
L["Shado-Pan Monastery"] = "Monasterio Shado-Pan"
L["Shadow Labyrinth"] = "Laberinto de las Sombras"
L["Shadowfang Keep"] = "Castillo de Colmillo Oscuro"
L["Shadowmoon Burial Grounds"] = "Cementerio de Sombraluna"
L["Shadowmoon Valley"] = "Valle Sombraluna"
L["Shadowmoon Valley (Draenor)"] = "Valle Sombraluna (Draenor)"
L["Shipyard Construction (Alliance)"] = "Construcción de astilleros (Alianza)"
L["Shipyard Construction (Horde)"] = "Construcción de astilleros (Horda)"
L["Sholazar Basin"] = "Cuenca de Sholazar"
L["Shouts"] = "Gritos"
L["Show borders"] = "Mostrar los bordes"
L["Show character addons"] = "Mostrar los addons de los personajes"
L["Show cooldowns"] = "Mostrar enfriamientos"
L["Show durability status"] = "Mostrar el estado de durabilidad"
L["Show guild ranks for your guild"] = "Muestra los rangos del gremio para tu gremio"
L["Show minimap button"] = "Mostrar el botón de minimización"
L["Show pet save button"] = "Mostrar el botón de guardar mascota"
L["Show player chain"] = "Mostrar Logo de Elite en el cuadro de parsonaje"
L["Show the spell ID in buff icon tooltips"] = "Mostrar la ID del hechizo en los Tooltip de los iconos de buff"
L["Show the unit's target"] = "Mostrar el objetivo de la unidad"
L["Show volume slider"] = "Mostrar el deslizador de volumen"
L["Show Wowhead links"] = "Mostrar los enlaces de Wowhead"
L["Shrine of the Storm"] = "Altar de las Tormentas"
L["Siege of Boralus"] = "Asedio de Boralus"
L["Siege of Dazar'alor"] = "Asedio de Dazar'alor"
L["Siege of Niuzao Temple"] = "Asedio del Templo de Niuzao"
L["Siege of Orgrimmar"] = "Asedio de Orgrimmar"
L["Silence rested emotes"] = "Desactivar emotes de Descanso"
L["Silithus"] = "Silithus"
L["Silverpine Forest"] = "Bosque Argenteos"
L["Silvershard Mines"] = "Minas Lonjaplata"
L["Skyreach"] = "Trecho Celestial"
L["Slave Pens"] = "Recinto de los Esclavos"
L["Sniffing"] = "Olfateando"
L["Social"] = "Social"
L["Sold junk for"] = "Vendió basura por"
L["Sound system restarted."] = "El sistema de sonido se reinició."
L["Southern Barrens"] = "Baldíos del Sur"
L["Spell ID"] = "ID de Hechizo"
L["Spine of Deathwing"] = "Espinazo de Alamuerte"
L["Spires of Arak"] = "Pináculos ed Arak"
L["Steamvault"] = "La Cámara del Vapor"
L["Stockade"] = "Las Mazmorras"
L["Stonecore"] = "El Núcleo Pétreo"
L["Stonetalon Mountains"] = "Sierra Espolón"
L["Stop"] = "Parar"
L["Storm Peaks"] = "Cumbres Tormentosas"
L["Stormheim"] = "Stormheim"
L["Stormheim (Alliance)"] = "Stormheim (Alianza)"
L["Stormheim (Horde)"] = "Stormheim (Horda)"
L["Stormsong Valley"] = "Valle Cantotormenta"
L["Stormstout Brewery"] = "Cerveceria del Trueno"
L["Stormwind"] = "Ventormenta"
L["Strand of the Ancients"] = "Playa de los Ancestros"
L["Stratholme"] = "Stratholme"
L["Stratholme: Crusader's Square"] = "Stratholme: Plaza de los Cruzados"
L["Stratholme: The Gauntlet"] = "Stratholme: El Guantelete"
L["Sunken Temple"] = "Templo Sumergido"
L["Sunwell Plateau"] = "Meseta de la Fuente del Sol"
L["Support"] = "Soporte técnico"
L["Suramar"] = "Suramar"
L["Swamp of Sorrows"] = "Pantano de las Penas"
L["Sync from friends"] = "Sincronización de los amigos"
L["System"] = "Sistema"
L["Tabard"] = "Tabardo"
L["Taint level: Basic (1)."] = "Nivel de contaminación: Básico (1)."
L["Taint level: Disabled (0)."] = "Nivel de contaminación: Desactivado (0)."
L["Taint level: Full (2)."] = "Nivel de contaminación: Completo (2)."
L["Talador"] = "Talador"
L["Tanaan Jungle"] = "Jungla de Tanaan"
L["Tanaris"] = "Tanaris"
L["Target"] = "Objetivo"
L["Target Tracking Disabled"] = "Seguimiento de objetivos desactivado"
L["Target Tracking Enabled"] = "Seguimiento de objetivos habilitado"
L["Tea with Jaina"] = "Té con Jaina"
L["Tel'anor"] = "Tel'anor"
L["Teldrassil"] = "Teldrassil"
L["Tempest Keep"] = "El Castillo de la Tempestad"
L["Temple of Ahn'Qiraj"] = "Templo de Ahn'Qiraj"
L["Temple of Atal'Hakkar"] = "Templo de Atal'Hakkar"
L["Temple of Sethraliss"] = "Templo de Sethraliss"
L["Temple of the Jade Serpent"] = "Templo del Dragon de Jade"
L["Ten Years of Warcraft"] = "Diez años de Warcraft"
L["Terokkar Forest"] = "Bosque de Terrokar"
L["Terrace of Endless Spring"] = "Veranda de la Primavera Eterna"
L["Terror of Darkshore"] = "Terror en Costaoscura"
L["Text"] = "Texto"
L["Text size"] = "Tamaño del texto"
L["Text Size"] = "Tamaño del texto"
L["The Art of War"] = "El Arte de la Guerra"
L["The Battle for Broken Shore"] = "La Batalla por la Costa Quebrada"
L["The Battle for Shattrath"] = "La Batalla por Shattrath"
L["The Battle of Thunder Pass"] = "La Batalla del Paso del Trueno"
L["The Burning Crusade"] = "The Burning Crusade"
L["The Demon's Trail"] = "El rastro del demonio"
L["The Dragon Soul"] = "ALma de Dragon"
L["The Eye"] = "El Ojo"
L["The Fall of Lordaeron"] = "La Caida de Lordaeron"
L["The Fate of Val'sharah"] = "El Destino de Val'sharah"
L["The Fleet in Krasarang (Alliance)"] = "La flota en Krasarang (Alianza)"
L["The Fleet in Krasarang (Horde)"] = "La flota en Krasarang (Horda)"
L["The Frozen Halls"] = "Los Salones Helados"
L["The Invasion Begins"] = "El Comienzo de la Invasionion"
L["The King's Command"] = "La orden del Rey"
L["The Negotiation"] = "La Negociación"
L["The Nightborne Pact"] = "El Pacto de lo Natonocturnos"
L["The Nighthold"] = "Bastion Nocturno"
L["The Return of Hope"] = "El retorno de la esperanza"
L["The summon from"] = "La invocación de"
L["The Threat Within"] = "La amenaza interior"
L["The Waning Crescent"] = "El Cuarto Menguante"
L["Themes"] = "Temas"
L["This command will assign your current pet team and selected abilities.|n|nPress CTRL/C to copy the command then paste it into a macro or chat window with CTRL/V."] = "Este comando asignará su equipo de mascotas actual y las habilidades seleccionadas.|n|nPresione CTRL/C para copiar el comando y luego péguelo en una macro o ventana de chat con CTRL/V."
L["This panel will close automatically if you enter combat."] = "Este panel se cerrará automáticamente si entras en combate."
L["Thousand Needles"] = "Mil Agujas"
L["Throne of the Four Winds"] = "Trono de los Cuatro Vientos"
L["Throne of the Tides"] = "Trono del las Mareas"
L["Throne of Thunder"] = "Solio del Trueno"
L["Thunder Bluff"] = "Cima del Trueno"
L["Timeless Isle"] = "Isla Intemporal"
L["Timer"] = "Temporizador"
L["Tiragarde Sound"] = "Estrecho de Tiragarde"
L["Tirisfal Glades"] = "Claros de Tirisfal"
L["Titan Panel screen adjust needs to be disabled for frames to be saved correctly."] = "El ajuste de pantalla de Titan Panel debe ser desactivado para que los cuadros se guarden correctamente."
L["To begin, choose an options page."] = "Para comenzar, elija una página de opciones."
L["To use the Find Item button, you need to deselect the WoW Token category."] = "Para usar el botón Encontrar artículo, tienes que deseleccionar la categoría Token del WoW."
L["Tol Barad"] = "Tol Barad"
L["Tol Dagor"] = "Tol Dagor"
L["Tomb of Sargeras"] = "Tumba de Sargeras"
L["Tooltip"] = "Tooltip"
L["Tooltip title color"] = "Color del título del Tooltip"
L["Top"] = "Superior"
L["Top Center"] = "Centro superior"
L["Townlong Steppes"] = "Estepas Towlong"
L["Tracing started."] = "El rastreo comenzó"
L["Tracing stopped."] = "El rastreo terminó"
L["Trains"] = "Trenes"
L["Transparency"] = "Transparencia"
L["Travelers"] = "Viajeros"
L["Trial of Style"] = "Prueba de Estilo"
L["Trial of the Champion"] = "Prueba del Campeón"
L["Trial of the Crusader"] = "Prueba del Crusado"
L["Trial of Valor"] = "Prueba del Valor"
L["True"] = "Verdadero"
L["Twilight Highlands"] = "Tierras Altas Crepusculares"
L["Twilight Vineyards"] = "Viñedos Crepusculares"
L["Twin Peaks"] = "Cumbres Gemelas"
L["Uldaman"] = "Uldaman"
L["Uldir"] = "Uldir"
L["Ulduar"] = "Ulduar"
L["Uldum"] = "Uldum"
L["Unclamp chat frame"] = "Desencadenar el marco del chat"
L["Underbog"] = "La Sotiénaga"
L["Undercity"] = "Entrañas"
L["Underrot"] = "Bardoma"
L["Un'Goro Crater"] = "Cráter de Un'Goro"
L["Universal group color"] = "Color de grupo universal"
L["Use arrow keys in chat"] = "Usar las teclas de flecha en el chat"
L["Use easy resizing"] = "Usar el cambio de tamaño fácil"
L["Use Leatrix Plus to move that frame."] = "Usa Leatrix Plus para mover ese cuadro."
L["Use Leatrix Plus to reset that frame."] = "Usa la Leatrix Plus para reajustar ese cuadro."
L["Utgarde Keep"] = "Fortaleza de Utgarde"
L["Utgarde Pinnacle"] = "Pináculo de Utgarde"
L["Vale of Eternal Blossoms"] = "El Valle de la Flor Eterna"
L["Valley of the Four Winds"] = "Valle de los Cuatro Vientos"
L["Val'sharah"] = "Val'sharah"
L["Value must be a number."] = "El valor debe ser un número."
L["Various"] = "Varios"
L["Vashj'ir"] = "Vashj'ir"
L["Vault of Archavon"] = "Bóveda de Archavon"
L["Vault of the Wardens"] = "Bóveda de las Celadoras"
L["Vaults"] = "Bóvedas"
L["Vendors"] = "Vendedores"
L["Version"] = "Version"
L["Victory at The Nighthold"] = "Victoria en el Bastión Nocturno"
L["Victory in Draenor!"] = "¡Victoria en Draenor!"
L["Video"] = "Video"
L["Violet Hold"] = "Bastión Violeta"
L["Visibility"] = "Visibilidad"
L["Vision of Sailor's Memory"] = "Visión de la memoria del marinero"
L["Visions of N'Zoth"] = "Visiones de N'Zoth"
L["Void Elves"] = "Elfos del Vacio"
L["Vol'dun"] = "Vol'dun"
L["Vol'mar"] = "Vol'mar"
L["Wailing Caverns"] = "Cuevas de los Lamentos"
L["Wandering Isle"] = "La isla Errante"
L["Warbringers Azshara"] = "Warbringers Azshara"
L["Warbringers Jaina"] = "Warbringers Jaina"
L["Warbringers Sylvanas"] = "Warbringers Sylvanas"
L["Warfronts"] = "Frentes de Guerra"
L["Warlords of Draenor"] = "Warlords of Draenor"
L["Warning"] = "Advertencia"
L["was automatically declined."] = "fue rechazada automáticamente."
L["Waycrest Manor"] = "Masion Tarjasenda"
L["Weather density"] = "La densidad del clima"
L["Welcome to Leatrix Plus."] = "Bienvenido a Leatrix Plus."
L["Well of Eternity"] = "Pozo de la Eternidad"
L["Western Plaguelands"] = "Tierras de la Peste del Oeste"
L["Westfall"] = "Páramos de Poniente"
L["Wetlands"] = "Los Humedales"
L["Widget"] = "Widget"
L["will be automatically accepted in 10 seconds unless cancelled."] = "se aceptará automáticamente en 10 segundos a menos que se cancele."
L["Winter"] = "Invierno"
L["Wintergrasp"] = "Conquista del Invierno"
L["Winterspring"] = "Cuna del Invierno"
L["World of Warcraft"] = "World of Warcraft"
L["Wrath of the Lich King"] = "Wrath of the Lich King"
L["Wyrmrest Temple"] = "Templo del Reposo del Dragón"
L["X Offset"] = "X Offset"
L["Y Offset"] = "Y Offset"
L["YOU"] = "TU"
L["You cannot do that in combat."] = "No puedes hacer eso en combate."
L["You do not own this pet.  Only owned pets can be searched."] = "No eres el dueño de esta mascota.  Sólo se pueden buscar las mascotas que se poseen."
L["You have"] = "Tienes..."
L["You need a battle pet team."] = "Necesitas un equipo de mascotas de batalla."
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "Su UI necesita ser recargada para que algunos de los cambios surtan efecto.|n|nNo tiene que hacer clic en el botón de recarga inmediatamente, pero sí tiene que hacerlo cuando termine de hacer los cambios y quiera que éstos surtan efecto"
L["Your UI needs to be reloaded."] = "Su UI necesita ser recargada."
L["Zandalar"] = "Zandalar"
L["Zandalari Trolls"] = "Trolls Zandalari "
L["Zangarmarsh"] = "Zangarmarsh"
L["Zones"] = "Zonas"
L["Zul'Aman"] = "Zul'Aman"
L["Zuldazar"] = "Zuldazar"
L["Zul'Drak"] = "Zul'Drak"
L["Zul'Farrak"] = "Zul'Farrak"
L["Zul'Gurub"] = "Zul'Gurub"
L["Zygor addon not found."] = "No se encuentra el addon Zygor."

end

-- frFR: French
if GameLocale == "frFR" then

end

-- itIT: Italian
if GameLocale == "itIT" then

end

-- ptBR: Brazilian Portuguese
if GameLocale == "ptBR" then

end
