local MDT = MDT
local L = MDT.L
local dungeonIndex = 21
MDT.dungeonTotalCount[dungeonIndex] = {normal=384,teeming=460,teemingEnabled=true}
MDT.scaleMultiplier[dungeonIndex] = 0.7

MDT.mapPOIs[dungeonIndex] = {
    [1] = {
        [1] = {
            ["y"] = -480.35147832794;
            ["x"] = 434.8042835021;
            ["template"] = "DeathReleasePinTemplate";
            ["graveyardDescription"] = "";
            ["type"] = "graveyard";
        };
        [2] = {
            ["y"] = -165.41051814016;
            ["x"] = 230.88050878771;
            ["template"] = "MapLinkPinTemplate";
            ["type"] = "mlFrackingTotem";
        };
        [3] = {
            ["y"] = -159.0643543431;
            ["x"] = 229.53433707512;
            ["template"] = "MapLinkPinTemplate";
            ["type"] = "mlFrackingTotem";
        };
        [4] = {
            ["y"] = -116.94137664378;
            ["x"] = 286.53431587181;
            ["template"] = "MapLinkPinTemplate";
            ["type"] = "mlMineCart";
        };
        [5] = {
            ["y"] = -262.08125072401;
            ["x"] = 367.76549732401;
            ["template"] = "DeathReleasePinTemplate";
            ["graveyardDescription"] = L["mlGraveyardNote1"];
            ["type"] = "graveyard";
        };
        [6] = {
            ["y"] = -121.09600689235;
            ["x"] = 275.70035521298;
            ["template"] = "DeathReleasePinTemplate";
            ["graveyardDescription"] = L["mlGraveyardNote2"];
            ["type"] = "graveyard";
        };
        [7] = {
            ["y"] = -112.60568055995;
            ["x"] = 479.54906443908;
            ["template"] = "DeathReleasePinTemplate";
            ["graveyardDescription"] = L["mlGraveyardNote3"];
            ["type"] = "graveyard";
        };
        [8] = {
            ["y"] = -273.73565889455;
            ["x"] = 409.95526615971;
            ["template"] = "MapLinkPinTemplate";
            ["text"] = L["mlJockeyNote"];
            ["type"] = "generalNote";
        };
        [9] = {
            ["y"] = -348.49370305917;
            ["x"] = 415.73284153458;
            ["template"] = "MapLinkPinTemplate";
            ["text"] = L["mlJockeyNote"];
            ["type"] = "generalNote";
        };
        [10] = {
            ["npcId"] = 161124;
            ["type"] = "nyalothaSpire";
            ["index"] = 1;
            ["y"] = -405.33085878462;
            ["x"] = 451.71529736273;
            ["tooltipText"] = L["Brutal Spire of Ny'alotha"];
            ["weeks"] = {
                [1] = true;
                [2] = true;
                [3] = true;
                [4] = true;
                [5] = true;
                [6] = true;
                [7] = true;
                [8] = true;
                [9] = true;
                [10] = true;
                [11] = true;
                [12] = true;
            };
            ["template"] = "VignettePinTemplate";
        };
        [11] = {
            ["npcId"] = 161241;
            ["type"] = "nyalothaSpire";
            ["index"] = 2;
            ["y"] = -275.22932156066;
            ["x"] = 296.59599494222;
            ["tooltipText"] = L["Cursed Spire of Ny'alotha"];
            ["weeks"] = {
                [1] = true;
                [2] = true;
                [5] = true;
                [6] = true;
                [9] = true;
                [10] = true;
            };
            ["template"] = "VignettePinTemplate";
        };
        [12] = {
            ["npcId"] = 161244;
            ["type"] = "nyalothaSpire";
            ["index"] = 3;
            ["y"] = -106.30385916865;
            ["x"] = 341.12996466647;
            ["tooltipText"] = L["Defiled Spire of Ny'alotha"];
            ["weeks"] = {
                [1] = true;
                [2] = true;
                [5] = true;
                [6] = true;
                [9] = true;
                [10] = true;
            };
            ["template"] = "VignettePinTemplate";
        };
        [13] = {
            ["npcId"] = 161243;
            ["type"] = "nyalothaSpire";
            ["index"] = 4;
            ["y"] = -118.90339334755;
            ["x"] = 531.00495086141;
            ["tooltipText"] = L["Entropic Spire of Ny'alotha"];
            ["weeks"] = {
                [1] = true;
                [2] = true;
                [3] = true;
                [4] = true;
                [5] = true;
                [6] = true;
                [7] = true;
                [8] = true;
                [9] = true;
                [10] = true;
                [11] = true;
                [12] = true;
            };
            ["template"] = "VignettePinTemplate";
        };
        [14] = {
            ["npcId"] = 161244;
            ["type"] = "nyalothaSpire";
            ["index"] = 5;
            ["y"] = -275.62658557555;
            ["x"] = 295.26874509012;
            ["tooltipText"] = L["Defiled Spire of Ny'alotha"];
            ["weeks"] = {
                [11] = true;
                [7] = true;
                [8] = true;
                [3] = true;
                [12] = true;
                [4] = true;
            };
            ["template"] = "VignettePinTemplate";
        };
        [15] = {
            ["npcId"] = 161241;
            ["type"] = "nyalothaSpire";
            ["index"] = 6;
            ["y"] = -108.08239691446;
            ["x"] = 339.76874564595;
            ["tooltipText"] = L["Cursed Spire of Ny'alotha"];
            ["weeks"] = {
                [11] = true;
                [7] = true;
                [8] = true;
                [3] = true;
                [12] = true;
                [4] = true;
            };
            ["template"] = "VignettePinTemplate";
        };
    };
};

MDT.dungeonEnemies[dungeonIndex] = {
    [1] = {
        ["clones"] = {
            [1] = {
                ["y"] = -478.2259243172;
                ["x"] = 425.40178176878;
                ["infested"] = {
                    [1] = true;
                    [3] = true;
                };
                ["sublevel"] = 1;
            };
            [2] = {
                ["y"] = -478.87108043154;
                ["x"] = 447.58139077397;
                ["sublevel"] = 1;
            };
            [3] = {
                ["y"] = -466.85963499295;
                ["x"] = 453.97559275342;
                ["infested"] = {
                    [1] = true;
                };
                ["sublevel"] = 1;
            };
            [4] = {
                ["y"] = -483.07467635869;
                ["x"] = 473.37653395575;
                ["sublevel"] = 1;
            };
            [5] = {
                ["y"] = -488.23596680439;
                ["x"] = 487.57010690783;
                ["sublevel"] = 1;
            };
            [6] = {
                ["y"] = -485.00011197057;
                ["x"] = 497.82152711282;
                ["sublevel"] = 1;
            };
        };
        ["reaping"] = 148716;
        ["scale"] = 0.7;
        ["spells"] = {
            [277242] = {};
            [270866] = {};
        };
        ["id"] = 137713;
        ["health"] = 153699;
        ["count"] = 1;
        ["displayId"] = 32024;
        ["creatureType"] = L["Beast"];
        ["level"] = 120;
        ["name"] = L["Big Money Crab"];
        ["characteristics"] = {
            ["Taunt"] = true;
            ["Incapacitate"] = true;
            ["Sap"] = true;
            ["Stun"] = true;
            ["Slow"] = true;
            ["Root"] = true;
        };
    };
    [2] = {
        ["clones"] = {
            [1] = {
                ["y"] = -508.91315031584;
                ["x"] = 425.07649815113;
                ["sublevel"] = 1;
            };
            [2] = {
                ["y"] = -496.78592021978;
                ["x"] = 450.94195363675;
                ["sublevel"] = 1;
            };
            [3] = {
                ["y"] = -486.60016709926;
                ["x"] = 412.39914455893;
                ["sublevel"] = 1;
            };
            [4] = {
                ["y"] = -495.96787666363;
                ["x"] = 400.36439703866;
                ["sublevel"] = 1;
            };
            [5] = {
                ["y"] = -508.92875746902;
                ["x"] = 387.11641745026;
                ["sublevel"] = 1;
            };
        };
        ["reaping"] = 148716;
        ["scale"] = 0.7;
        ["health"] = 153699;
        ["count"] = 0;
        ["displayId"] = 32023;
        ["creatureType"] = L["Beast"];
        ["level"] = 120;
        ["id"] = 137716;
        ["name"] = L["Bottom Feeder"];
    };
    [3] = {
        ["clones"] = {
            [1] = {
                ["y"] = -548.02341232211;
                ["x"] = 413.56816392568;
                ["sublevel"] = 1;
                ["upstairs"] = true;
            };
            [2] = {
                ["y"] = -550.58154619885;
                ["x"] = 424.265841902;
                ["sublevel"] = 1;
                ["upstairs"] = true;
            };
            [3] = {
                ["y"] = -523.21446339563;
                ["x"] = 418.27288128767;
                ["sublevel"] = 1;
                ["upstairs"] = true;
            };
            [4] = {
                ["y"] = -526.42877694896;
                ["x"] = 430.77283457852;
                ["sublevel"] = 1;
                ["upstairs"] = true;
            };
            [5] = {
                ["y"] = -507.87807746141;
                ["x"] = 434.71401869778;
                ["sublevel"] = 1;
                ["upstairs"] = true;
            };
            [6] = {
                ["y"] = -459.78643311087;
                ["x"] = 395.76294614373;
                ["sublevel"] = 1;
            };
            [7] = {
                ["y"] = -449.17486333683;
                ["x"] = 405.01147033623;
                ["sublevel"] = 1;
            };
            [8] = {
                ["y"] = -447.74631870413;
                ["x"] = 425.01146303998;
                ["sublevel"] = 1;
            };
            [9] = {
                ["y"] = -464.26906410961;
                ["x"] = 485.6324518163;
                ["sublevel"] = 1;
            };
            [10] = {
                ["y"] = -456.37415670018;
                ["x"] = 473.55560139048;
                ["sublevel"] = 1;
            };
            [11] = {
                ["y"] = -456.47780215629;
                ["x"] = 465.73199190146;
                ["sublevel"] = 1;
            };
            [12] = {
                ["y"] = -455.31502582542;
                ["x"] = 456.19712019695;
                ["sublevel"] = 1;
            };
            [13] = {
                ["y"] = -473.78387314372;
                ["x"] = 460.2539811199;
                ["sublevel"] = 1;
            };
            [14] = {
                ["y"] = -481.28385124899;
                ["x"] = 460.2539811199;
                ["sublevel"] = 1;
            };
        };
        ["reaping"] = 148716;
        ["id"] = 138061;
        ["spells"] = {
            [277564] = {};
        };
        ["neutral"] = true;
        ["health"] = 307398;
        ["count"] = 0;
        ["name"] = L["Venture Co. Longshoreman"];
        ["displayId"] = 81226;
        ["creatureType"] = L["Humanoid"];
        ["level"] = 120;
        ["scale"] = 0.7;
        ["characteristics"] = {
            ["Taunt"] = true;
            ["Slow"] = true;
            ["Root"] = true;
            ["Stun"] = true;
        };
    };
    [4] = {
        ["clones"] = {
            [1] = {
                ["y"] = -502.8636334281;
                ["x"] = 381.53036956989;
                ["sublevel"] = 1;
            };
            [2] = {
                ["y"] = -497.86360409746;
                ["x"] = 385.35392512337;
                ["sublevel"] = 1;
            };
            [3] = {
                ["y"] = -484.36417596637;
                ["x"] = 502.83538303213;
                ["sublevel"] = 1;
            };
            [4] = {
                ["y"] = -485.16753800061;
                ["x"] = 507.21111723987;
                ["sublevel"] = 1;
            };
            [5] = {
                ["y"] = -487.75373467127;
                ["x"] = 505.65938739876;
                ["sublevel"] = 1;
            };
            [6] = {
                ["y"] = -489.99512139741;
                ["x"] = 501.86629302909;
                ["sublevel"] = 1;
            };
            [7] = {
                ["y"] = -490.68478568164;
                ["x"] = 498.07319865943;
                ["sublevel"] = 1;
            };
            [8] = {
                ["y"] = -498.29889889274;
                ["x"] = 506.69713557341;
                ["sublevel"] = 1;
            };
            [9] = {
                ["y"] = -497.86412913943;
                ["x"] = 511.9145218839;
                ["sublevel"] = 1;
            };
        };
        ["reaping"] = 148716;
        ["id"] = 138064;
        ["neutral"] = true;
        ["name"] = L["Posh Vacationer"];
        ["health"] = 153699;
        ["displayId"] = 85704;
        ["creatureType"] = L["Humanoid"];
        ["level"] = 120;
        ["count"] = 0;
        ["scale"] = 0.7;
    };
    [5] = {
        ["clones"] = {
            [1] = {
                ["sublevel"] = 1;
                ["x"] = 449.02471238213;
                ["y"] = -434.14300926226;
                ["g"] = 1;
                ["infested"] = {
                    [1] = true;
                };
            };
            [2] = {
                ["y"] = -439.36455230936;
                ["x"] = 451.50833604267;
                ["g"] = 1;
                ["sublevel"] = 1;
            };
            [3] = {
                ["y"] = -435.46782418764;
                ["x"] = 452.54468439098;
                ["g"] = 1;
                ["sublevel"] = 1;
            };
            [4] = {
                ["y"] = -430.11586660419;
                ["x"] = 481.62542419251;
                ["g"] = 2;
                ["sublevel"] = 1;
            };
            [5] = {
                ["y"] = -420.1786603195;
                ["x"] = 461.59482753369;
                ["g"] = 3;
                ["sublevel"] = 1;
            };
            [6] = {
                ["y"] = -422.99777931989;
                ["x"] = 466.99321155107;
                ["g"] = 3;
                ["sublevel"] = 1;
            };
            [7] = {
                ["y"] = -416.59957778435;
                ["x"] = 435.35094745914;
                ["g"] = 4;
                ["sublevel"] = 1;
            };
            [8] = {
                ["y"] = -400.24809876436;
                ["x"] = 468.06397992127;
                ["g"] = 5;
                ["sublevel"] = 1;
            };
            [9] = {
                ["y"] = -403.18472073708;
                ["x"] = 471.1189878183;
                ["g"] = 5;
                ["sublevel"] = 1;
            };
            [10] = {
                ["y"] = -358.71874866673;
                ["x"] = 458.17260833013;
                ["g"] = 19;
                ["sublevel"] = 1;
            };
            [11] = {
                ["y"] = -359.43396729303;
                ["x"] = 450.59536600093;
                ["g"] = 19;
                ["sublevel"] = 1;
            };
            [12] = {
                ["y"] = -354.86875427136;
                ["x"] = 448.42147991669;
                ["g"] = 19;
                ["sublevel"] = 1;
            };
            [13] = {
                ["y"] = -338.92283836523;
                ["x"] = 461.23382100857;
                ["g"] = 20;
                ["sublevel"] = 1;
            };
            [14] = {
                ["y"] = -342.39221974072;
                ["x"] = 457.56035528456;
                ["g"] = 20;
                ["sublevel"] = 1;
            };
            [15] = {
                ["y"] = -346.88202285883;
                ["x"] = 458.7848088263;
                ["g"] = 20;
                ["sublevel"] = 1;
            };
            [16] = {
                ["y"] = -292.30480466739;
                ["x"] = 463.84961221425;
                ["g"] = 27;
                ["sublevel"] = 1;
            };
            [17] = {
                ["y"] = -289.48127360145;
                ["x"] = 455.26139566038;
                ["g"] = 27;
                ["sublevel"] = 1;
            };
            [18] = {
                ["y"] = -308.86456151826;
                ["x"] = 408.06805201094;
                ["g"] = 31;
                ["sublevel"] = 1;
            };
            [19] = {
                ["y"] = -313.75102527871;
                ["x"] = 407.21969976684;
                ["g"] = 31;
                ["sublevel"] = 1;
            };
            [20] = {
                ["y"] = -326.75066665947;
                ["x"] = 432.56067973406;
                ["g"] = 32;
                ["sublevel"] = 1;
            };
            [21] = {
                ["y"] = -330.92788757017;
                ["x"] = 430.02902279571;
                ["g"] = 32;
                ["sublevel"] = 1;
            };
            [22] = {
                ["y"] = -361.44398874944;
                ["x"] = 430.84077766723;
                ["g"] = 38;
                ["sublevel"] = 1;
            };
            [23] = {
                ["y"] = -364.59780324269;
                ["x"] = 435.93651948351;
                ["g"] = 38;
                ["sublevel"] = 1;
            };
            [24] = {
                ["y"] = -369.50690453121;
                ["x"] = 434.66379096478;
                ["g"] = 38;
                ["sublevel"] = 1;
            };
            [25] = {
                ["sublevel"] = 1;
                ["x"] = 436.1251307314;
                ["y"] = -342.89427712404;
                ["g"] = 39;
                ["infested"] = {};
            };
            [26] = {
                ["y"] = -347.6085695264;
                ["x"] = 442.83941872568;
                ["g"] = 39;
                ["sublevel"] = 1;
            };
            [27] = {
                ["y"] = -351.60856071024;
                ["x"] = 440.41085221187;
                ["g"] = 39;
                ["sublevel"] = 1;
            };
            [28] = {
                ["y"] = -351.46571395421;
                ["x"] = 435.98228397537;
                ["g"] = 39;
                ["sublevel"] = 1;
            };
            [29] = {
                ["y"] = -344.79427963513;
                ["x"] = 440.58932329189;
                ["g"] = 39;
                ["sublevel"] = 1;
            };
            [30] = {
                ["y"] = -416.02358442115;
                ["x"] = 438.77025155148;
                ["teeming"] = true;
                ["g"] = 4;
                ["sublevel"] = 1;
            };
        };
        ["reaping"] = 148716;
        ["scale"] = 0.8;
        ["spells"] = {
            [277564] = {};
            [209859] = {};
            [258674] = {};
            [277242] = {};
        };
        ["id"] = 130436;
        ["health"] = 307398;
        ["count"] = 1;
        ["displayId"] = 81226;
        ["creatureType"] = L["Humanoid"];
        ["level"] = 120;
        ["name"] = L["Off-Duty Laborer"];
        ["characteristics"] = {
            ["Taunt"] = true;
            ["Incapacitate"] = true;
            ["Root"] = true;
            ["Disorient"] = true;
            ["Sap"] = true;
            ["Silence"] = true;
            ["Slow"] = true;
            ["Stun"] = true;
            ["Fear"] = true;
        };
    };
    [6] = {
        ["clones"] = {
            [1] = {
                ["y"] = -435.00018284157;
                ["x"] = 481.67609043668;
                ["g"] = 2;
                ["sublevel"] = 1;
            };
            [2] = {
                ["y"] = -427.55080630878;
                ["x"] = 477.61856226763;
                ["g"] = 2;
                ["sublevel"] = 1;
            };
            [3] = {
                ["sublevel"] = 1;
                ["x"] = 439.3794102781;
                ["g"] = 4;
                ["negativeTeeming"] = true;
                ["y"] = -414.53336685115;
            };
            [4] = {
                ["y"] = -419.88315178515;
                ["x"] = 431.61958075867;
                ["g"] = 4;
                ["sublevel"] = 1;
            };
            [5] = {
                ["sublevel"] = 1;
                ["x"] = 466.61615006596;
                ["infested"] = {
                    [2] = true;
                };
                ["g"] = 5;
                ["y"] = -404.83779067648;
            };
            [6] = {
                ["y"] = -395.21057359874;
                ["x"] = 461.22700421103;
                ["g"] = 6;
                ["sublevel"] = 1;
            };
            [7] = {
                ["y"] = -373.06237900427;
                ["x"] = 467.27869006316;
                ["g"] = 40;
                ["sublevel"] = 1;
            };
            [8] = {
                ["y"] = -333.53532477086;
                ["x"] = 504.04957323132;
                ["g"] = 22;
                ["sublevel"] = 1;
            };
            [9] = {
                ["y"] = -292.65774037067;
                ["x"] = 459.14372878729;
                ["g"] = 27;
                ["sublevel"] = 1;
            };
            [10] = {
                ["sublevel"] = 1;
                ["x"] = 451.09070467911;
                ["infested"] = {
                    [2] = true;
                };
                ["g"] = 28;
                ["y"] = -298.63355783428;
            };
            [11] = {
                ["sublevel"] = 1;
                ["x"] = 429.97962561865;
                ["infested"] = {
                    [2] = true;
                };
                ["g"] = 29;
                ["y"] = -311.75848298904;
            };
            [12] = {
                ["y"] = -286.01466856316;
                ["x"] = 416.12633606115;
                ["g"] = 30;
                ["sublevel"] = 1;
            };
            [13] = {
                ["y"] = -310.94431763882;
                ["x"] = 413.38056968444;
                ["g"] = 31;
                ["sublevel"] = 1;
            };
            [14] = {
                ["y"] = -324.34560451914;
                ["x"] = 428.38346425568;
                ["g"] = 32;
                ["sublevel"] = 1;
            };
            [15] = {
                ["y"] = -330.92605057055;
                ["x"] = 393.86934268811;
                ["g"] = 33;
                ["sublevel"] = 1;
            };
            [16] = {
                ["sublevel"] = 1;
                ["x"] = 410.62456974962;
                ["infested"] = {
                    [2] = true;
                };
                ["g"] = 35;
                ["y"] = -360.00323316245;
            };
            [17] = {
                ["y"] = -427.13404980502;
                ["x"] = 468.60506319127;
                ["teeming"] = true;
                ["g"] = 3;
                ["sublevel"] = 1;
            };
        };
        ["reaping"] = 148893;
        ["scale"] = 1;
        ["spells"] = {
            [280605] = {};
            [268130] = {};
            [277242] = {};
            [280604] = {};
            [209859] = {};
            [224729] = {};
            [268129] = {};
            [277564] = {};
        };
        ["id"] = 136470;
        ["health"] = 768495;
        ["count"] = 4;
        ["displayId"] = 84784;
        ["creatureType"] = L["Humanoid"];
        ["level"] = 120;
        ["name"] = L["Refreshment Vendor"];
        ["characteristics"] = {
            ["Taunt"] = true;
            ["Incapacitate"] = true;
            ["Root"] = true;
            ["Polymorph"] = true;
            ["Disorient"] = true;
            ["Sap"] = true;
            ["Fear"] = true;
            ["Stun"] = true;
            ["Slow"] = true;
            ["Silence"] = true;
            ["Imprison"] = true;
        };
    };
    [7] = {
        ["clones"] = {
            [1] = {
                ["sublevel"] = 1;
                ["x"] = 465.36079572815;
                ["y"] = -419.54535271079;
                ["g"] = 3;
                ["infested"] = {
                    [1] = true;
                };
            };
            [2] = {
                ["sublevel"] = 1;
                ["x"] = 454.04528093853;
                ["infested"] = {
                    [2] = true;
                };
                ["g"] = 19;
                ["y"] = -355.10936763606;
            };
            [3] = {
                ["y"] = -355.71156236957;
                ["x"] = 476.16988417219;
                ["g"] = 21;
                ["sublevel"] = 1;
            };
            [4] = {
                ["y"] = -332.54631028177;
                ["x"] = 509.76385820838;
                ["g"] = 22;
                ["sublevel"] = 1;
            };
            [5] = {
                ["y"] = -327.71114824701;
                ["x"] = 505.47815390753;
                ["g"] = 22;
                ["sublevel"] = 1;
            };
            [6] = {
                ["y"] = -323.82978481744;
                ["x"] = 499.65076427533;
                ["g"] = 23;
                ["sublevel"] = 1;
            };
            [7] = {
                ["y"] = -311.91353221683;
                ["x"] = 468.9249933922;
                ["g"] = 26;
                ["sublevel"] = 1;
            };
            [8] = {
                ["y"] = -307.48171092243;
                ["x"] = 464.72918257925;
                ["g"] = 26;
                ["sublevel"] = 1;
            };
            [9] = {
                ["y"] = -332.25374457137;
                ["x"] = 478.21192841174;
                ["g"] = 25;
                ["sublevel"] = 1;
            };
            [10] = {
                ["y"] = -332.32743212129;
                ["x"] = 470.96799696168;
                ["g"] = 25;
                ["sublevel"] = 1;
            };
            [11] = {
                ["y"] = -304.58596373195;
                ["x"] = 450.00392816461;
                ["g"] = 28;
                ["sublevel"] = 1;
            };
            [12] = {
                ["y"] = -310.32368802792;
                ["x"] = 449.6760549887;
                ["g"] = 28;
                ["sublevel"] = 1;
            };
            [13] = {
                ["y"] = -309.69230383048;
                ["x"] = 440.54154084352;
                ["g"] = 29;
                ["sublevel"] = 1;
            };
            [14] = {
                ["sublevel"] = 1;
                ["x"] = 411.73992804077;
                ["y"] = -315.90996457181;
                ["g"] = 31;
                ["infested"] = {
                    [1] = true;
                };
            };
            [15] = {
                ["sublevel"] = 1;
                ["x"] = 425.97839125071;
                ["y"] = -328.26965213076;
                ["g"] = 32;
                ["infested"] = {
                    [1] = true;
                };
            };
            [16] = {
                ["y"] = -335.13658682306;
                ["x"] = 397.55354496879;
                ["g"] = 33;
                ["sublevel"] = 1;
            };
            [17] = {
                ["sublevel"] = 1;
                ["x"] = 413.27536358374;
                ["infested"] = {
                    [2] = true;
                };
                ["g"] = 34;
                ["y"] = -334.97673527945;
            };
            [18] = {
                ["y"] = -352.41702962473;
                ["x"] = 410.27970801072;
                ["g"] = 35;
                ["sublevel"] = 1;
            };
            [19] = {
                ["sublevel"] = 1;
                ["x"] = 434.22763792554;
                ["y"] = -346.93038103221;
                ["g"] = 39;
                ["infested"] = {
                    [1] = true;
                };
            };
            [20] = {
                ["y"] = -424.95815162701;
                ["x"] = 431.13207048378;
                ["teeming"] = true;
                ["g"] = 4;
                ["sublevel"] = 1;
            };
            [21] = {
                ["y"] = -282.55838428264;
                ["x"] = 403.98926354167;
                ["g"] = 30;
                ["sublevel"] = 1;
            };
            [22] = {
                ["y"] = -356.17397051988;
                ["x"] = 420.83320320086;
                ["g"] = 89;
                ["sublevel"] = 1;
            };
        };
        ["reaping"] = 148716;
        ["scale"] = 1;
        ["spells"] = {
            [209859] = {};
            [281621] = {};
            [277564] = {};
            [262287] = {};
            [262019] = {};
            [267433] = {};
            [224729] = {};
            [277242] = {};
            [280602] = {};
        };
        ["id"] = 130488;
        ["health"] = 768495;
        ["count"] = 4;
        ["displayId"] = 81265;
        ["creatureType"] = L["Humanoid"];
        ["level"] = 120;
        ["name"] = L["Mech Jockey"];
        ["characteristics"] = {
            ["Taunt"] = true;
            ["Incapacitate"] = true;
            ["Root"] = true;
            ["Polymorph"] = true;
            ["Disorient"] = true;
            ["Sap"] = true;
            ["Fear"] = true;
            ["Stun"] = true;
            ["Slow"] = true;
            ["Silence"] = true;
            ["Imprison"] = true;
        };
    };
    [8] = {
        ["clones"] = {
            [1] = {
                ["y"] = -394.4723222671;
                ["x"] = 454.94319863389;
                ["g"] = 6;
                ["sublevel"] = 1;
            };
            [2] = {
                ["y"] = -380.53516379952;
                ["x"] = 445.54271378336;
                ["g"] = 7;
                ["sublevel"] = 1;
            };
            [3] = {
                ["sublevel"] = 1;
                ["x"] = 441.82179359542;
                ["infested"] = {
                    [3] = true;
                };
                ["g"] = 7;
                ["y"] = -385.65146149395;
            };
            [4] = {
                ["y"] = -404.1715499278;
                ["x"] = 431.34753769379;
                ["g"] = 9;
                ["sublevel"] = 1;
            };
            [5] = {
                ["y"] = -352.74503361071;
                ["x"] = 482.67372893737;
                ["g"] = 21;
                ["sublevel"] = 1;
            };
            [6] = {
                ["y"] = -319.44911838114;
                ["x"] = 501.98621577546;
                ["g"] = 23;
                ["sublevel"] = 1;
            };
            [7] = {
                ["sublevel"] = 1;
                ["x"] = 484.59901468162;
                ["infested"] = {
                    [3] = true;
                };
                ["g"] = 24;
                ["y"] = -317.27159278197;
            };
            [8] = {
                ["y"] = -312.21697049844;
                ["x"] = 481.27610806539;
                ["g"] = 24;
                ["sublevel"] = 1;
            };
            [9] = {
                ["y"] = -328.52072837613;
                ["x"] = 454.43938551122;
                ["g"] = 41;
                ["sublevel"] = 1;
            };
            [10] = {
                ["sublevel"] = 1;
                ["x"] = 471.28511852648;
                ["infested"] = {
                    [3] = true;
                };
                ["g"] = 26;
                ["y"] = -305.73344743986;
            };
            [11] = {
                ["y"] = -286.42245038369;
                ["x"] = 460.55550189356;
                ["g"] = 27;
                ["sublevel"] = 1;
            };
            [12] = {
                ["y"] = -304.57441402861;
                ["x"] = 435.52555761529;
                ["g"] = 29;
                ["sublevel"] = 1;
            };
            [13] = {
                ["sublevel"] = 1;
                ["x"] = 406.66929011603;
                ["infested"] = {
                    [3] = true;
                };
                ["g"] = 34;
                ["y"] = -336.04502320821;
            };
            [14] = {
                ["y"] = -355.71634412717;
                ["x"] = 405.65446988511;
                ["g"] = 35;
                ["sublevel"] = 1;
            };
            [15] = {
                ["y"] = -367.53093322539;
                ["x"] = 429.97118218407;
                ["g"] = 38;
                ["sublevel"] = 1;
            };
        };
        ["reaping"] = 148716;
        ["scale"] = 1.2;
        ["spells"] = {
            [263637] = {};
            [277242] = {};
            [263636] = {};
            [209859] = {};
            [277564] = {};
            [224729] = {};
            [262092] = {};
        };
        ["id"] = 130435;
        ["health"] = 999044;
        ["count"] = 5;
        ["displayId"] = 30262;
        ["creatureType"] = L["Humanoid"];
        ["level"] = 120;
        ["name"] = L["Addled Thug"];
        ["characteristics"] = {
            ["Taunt"] = true;
            ["Incapacitate"] = true;
            ["Root"] = true;
            ["Polymorph"] = true;
            ["Disorient"] = true;
            ["Fear"] = true;
            ["Silence"] = true;
            ["Slow"] = true;
            ["Stun"] = true;
            ["Imprison"] = true;
        };
    };
    [9] = {
        ["clones"] = {
            [1] = {
                ["y"] = -373.33634931865;
                ["x"] = 461.11431977744;
                ["g"] = 40;
                ["sublevel"] = 1;
            };
            [2] = {
                ["y"] = -409.36564645266;
                ["x"] = 433.73865216591;
                ["g"] = 9;
                ["sublevel"] = 1;
            };
            [3] = {
                ["y"] = -347.33663173639;
                ["x"] = 463.90011099051;
                ["g"] = 20;
                ["sublevel"] = 1;
            };
            [4] = {
                ["y"] = -326.76391932942;
                ["x"] = 460.40217993942;
                ["g"] = 41;
                ["sublevel"] = 1;
            };
            [5] = {
                ["y"] = -322.50162432503;
                ["x"] = 454.00873743284;
                ["g"] = 41;
                ["sublevel"] = 1;
            };
            [6] = {
                ["y"] = -336.78665619602;
                ["x"] = 474.62271822124;
                ["patrol"] = {
                    [1] = {
                        ["y"] = -336.78665619602;
                        ["x"] = 474.62271822124;
                    };
                    [2] = {
                        ["y"] = -348.65758098167;
                        ["x"] = 468.90094316129;
                    };
                    [3] = {
                        ["y"] = -336.78665619602;
                        ["x"] = 474.62271822124;
                    };
                    [4] = {
                        ["y"] = -324.30975643075;
                        ["x"] = 471.72703052261;
                    };
                };
                ["g"] = 25;
                ["sublevel"] = 1;
            };
            [7] = {
                ["y"] = -294.49634326392;
                ["x"] = 406.74577908281;
                ["g"] = 30;
                ["sublevel"] = 1;
            };
            [8] = {
                ["y"] = -327.57033724503;
                ["x"] = 398.72250499114;
                ["g"] = 33;
                ["sublevel"] = 1;
            };
            [9] = {
                ["y"] = -330.00580243568;
                ["x"] = 408.30809514058;
                ["g"] = 34;
                ["sublevel"] = 1;
            };
        };
        ["reaping"] = 148716;
        ["scale"] = 1;
        ["spells"] = {
            [267354] = {};
            [269302] = {};
            [277564] = {};
            [209859] = {};
            [267357] = {};
            [269298] = {};
        };
        ["id"] = 134232;
        ["health"] = 768495;
        ["count"] = 4;
        ["displayId"] = 83395;
        ["creatureType"] = L["Humanoid"];
        ["level"] = 120;
        ["name"] = L["Hired Assassin"];
        ["characteristics"] = {
            ["Taunt"] = true;
            ["Incapacitate"] = true;
            ["Root"] = true;
            ["Polymorph"] = true;
            ["Disorient"] = true;
            ["Sap"] = true;
            ["Fear"] = true;
            ["Stun"] = true;
            ["Slow"] = true;
            ["Silence"] = true;
            ["Imprison"] = true;
        };
    };
    [10] = {
        ["clones"] = {
            [1] = {
                ["y"] = -403.33506578442;
                ["x"] = 445.81886970914;
                ["g"] = 8;
                ["sublevel"] = 1;
            };
            [2] = {
                ["y"] = -406.28607697551;
                ["x"] = 443.60120081537;
                ["g"] = 8;
                ["sublevel"] = 1;
            };
            [3] = {
                ["y"] = -409.63843308163;
                ["x"] = 444.07643355816;
                ["g"] = 8;
                ["sublevel"] = 1;
            };
            [4] = {
                ["y"] = -394.79444469829;
                ["x"] = 446.30373750595;
                ["g"] = 10;
                ["sublevel"] = 1;
            };
            [5] = {
                ["y"] = -394.93729145432;
                ["x"] = 443.44659393948;
                ["g"] = 10;
                ["sublevel"] = 1;
            };
            [6] = {
                ["y"] = -383.14512786918;
                ["x"] = 452.2980765933;
                ["g"] = 11;
                ["sublevel"] = 1;
            };
            [7] = {
                ["y"] = -386.05422608501;
                ["x"] = 449.38897837747;
                ["g"] = 11;
                ["sublevel"] = 1;
            };
            [8] = {
                ["y"] = -389.14512928445;
                ["x"] = 446.47989576722;
                ["g"] = 11;
                ["sublevel"] = 1;
            };
            [9] = {
                ["y"] = -390.8238566991;
                ["x"] = 434.19345472932;
                ["g"] = 12;
                ["sublevel"] = 1;
            };
            [10] = {
                ["y"] = -394.39300324678;
                ["x"] = 434.16502939967;
                ["g"] = 12;
                ["sublevel"] = 1;
            };
            [11] = {
                ["y"] = -392.94562152816;
                ["x"] = 437.0597815434;
                ["g"] = 12;
                ["sublevel"] = 1;
            };
            [12] = {
                ["y"] = -392.18745932876;
                ["x"] = 467.77829615664;
                ["g"] = 13;
                ["sublevel"] = 1;
            };
            [13] = {
                ["y"] = -391.23001827454;
                ["x"] = 469.90595613289;
                ["g"] = 13;
                ["sublevel"] = 1;
            };
            [14] = {
                ["y"] = -391.54916681443;
                ["x"] = 472.1400004776;
                ["g"] = 13;
                ["sublevel"] = 1;
            };
            [15] = {
                ["y"] = -380.45963040171;
                ["x"] = 464.40197530756;
                ["g"] = 14;
                ["sublevel"] = 1;
            };
            [16] = {
                ["y"] = -380.49718389826;
                ["x"] = 467.44899964032;
                ["g"] = 14;
                ["sublevel"] = 1;
            };
            [17] = {
                ["y"] = -383.65508608764;
                ["x"] = 466.92269954902;
                ["g"] = 14;
                ["sublevel"] = 1;
            };
            [18] = {
                ["y"] = -385.66510752651;
                ["x"] = 466.59374958019;
                ["g"] = 14;
                ["sublevel"] = 1;
            };
            [19] = {
                ["y"] = -384.43223817242;
                ["x"] = 469.33349975444;
                ["g"] = 14;
                ["sublevel"] = 1;
            };
            [20] = {
                ["sublevel"] = 1;
                ["x"] = 475.29797373954;
                ["g"] = 15;
                ["y"] = -384.29121070518;
            };
            [21] = {
                ["y"] = -385.29121156652;
                ["x"] = 477.15514096771;
                ["g"] = 15;
                ["sublevel"] = 1;
            };
            [22] = {
                ["y"] = -381.57692615626;
                ["x"] = 475.29797373954;
                ["g"] = 15;
                ["sublevel"] = 1;
            };
            [23] = {
                ["y"] = -382.57525345282;
                ["x"] = 477.27170614703;
                ["g"] = 15;
                ["sublevel"] = 1;
            };
            [24] = {
                ["y"] = -376.66260870592;
                ["x"] = 485.84235116617;
                ["g"] = 16;
                ["sublevel"] = 1;
            };
            [25] = {
                ["y"] = -377.00744084803;
                ["x"] = 488.60096390789;
                ["g"] = 16;
                ["sublevel"] = 1;
            };
            [26] = {
                ["y"] = -370.73491124572;
                ["x"] = 474.34737378737;
                ["g"] = 17;
                ["sublevel"] = 1;
            };
            [27] = {
                ["y"] = -370.30634645459;
                ["x"] = 477.06163381324;
                ["g"] = 17;
                ["sublevel"] = 1;
            };
            [28] = {
                ["y"] = -363.7349113471;
                ["x"] = 473.20452617001;
                ["g"] = 18;
                ["sublevel"] = 1;
            };
            [29] = {
                ["y"] = -362.30634569463;
                ["x"] = 476.06165747495;
                ["g"] = 18;
                ["sublevel"] = 1;
            };
            [30] = {
                ["y"] = -361.06456389368;
                ["x"] = 400.17209537491;
                ["g"] = 36;
                ["sublevel"] = 1;
            };
            [31] = {
                ["y"] = -363.01578806743;
                ["x"] = 398.58672965892;
                ["g"] = 36;
                ["sublevel"] = 1;
            };
            [32] = {
                ["y"] = -363.01578806743;
                ["x"] = 402.12331954866;
                ["g"] = 36;
                ["sublevel"] = 1;
            };
            [33] = {
                ["y"] = -360.16054336484;
                ["x"] = 393.43874065695;
                ["sublevel"] = 1;
            };
            [34] = {
                ["y"] = -353.49853093076;
                ["x"] = 396.1159134637;
                ["g"] = 37;
                ["sublevel"] = 1;
            };
            [35] = {
                ["y"] = -349.72805976084;
                ["x"] = 395.62408962924;
                ["g"] = 37;
                ["sublevel"] = 1;
            };
            [36] = {
                ["y"] = -351.53133408713;
                ["x"] = 392.34541415258;
                ["g"] = 37;
                ["sublevel"] = 1;
            };
            [37] = {
                ["y"] = -354.97396022235;
                ["x"] = 392.18149163522;
                ["g"] = 37;
                ["sublevel"] = 1;
            };
            [38] = {
                ["y"] = -354.48216452909;
                ["x"] = 398.73887072976;
                ["g"] = 37;
                ["sublevel"] = 1;
            };
            [39] = {
                ["y"] = -351.20346091122;
                ["x"] = 398.73887072976;
                ["g"] = 37;
                ["sublevel"] = 1;
            };
            [40] = {
                ["y"] = -348.41656705721;
                ["x"] = 390.21425257978;
                ["g"] = 37;
                ["sublevel"] = 1;
            };
            [41] = {
                ["y"] = -352.02312978038;
                ["x"] = 388.7388655;
                ["g"] = 37;
                ["sublevel"] = 1;
            };
            [42] = {
                ["y"] = -355.79362909151;
                ["x"] = 389.55850622796;
                ["g"] = 37;
                ["sublevel"] = 1;
            };
        };
        ["reaping"] = 148716;
        ["id"] = 136006;
        ["neutral"] = true;
        ["health"] = 153699;
        ["count"] = 0;
        ["name"] = L["Rowdy Reveler"];
        ["displayId"] = 85710;
        ["creatureType"] = L["Humanoid"];
        ["level"] = 120;
        ["scale"] = 0.7;
        ["characteristics"] = {
            ["Taunt"] = true;
            ["Disorient"] = true;
            ["Root"] = true;
            ["Stun"] = true;
            ["Slow"] = true;
            ["Silence"] = true;
            ["Fear"] = true;
        };
    };
    [11] = {
        ["clones"] = {
            [1] = {
                ["y"] = -287.96403229057;
                ["x"] = 409.75023371705;
                ["g"] = 30;
                ["sublevel"] = 1;
            };
            [2] = {
                ["sublevel"] = 1;
                ["x"] = 421.7520034151;
                ["patrol"] = {
                    [1] = {
                        ["y"] = -351.32147778175;
                        ["x"] = 425.25199455151;
                    };
                    [2] = {
                        ["y"] = -342.13778719702;
                        ["x"] = 417.4969119229;
                    };
                    [3] = {
                        ["y"] = -351.32147778175;
                        ["x"] = 425.25199455151;
                    };
                    [4] = {
                        ["y"] = -355.40308592811;
                        ["x"] = 437.08876415058;
                    };
                };
                ["infested"] = {
                    [3] = true;
                };
                ["g"] = 89;
                ["y"] = -348.12147816083;
            };
        };
        ["reaping"] = 148894;
        ["scale"] = 1.6;
        ["spells"] = {
            [262066] = {};
            [262412] = {};
            [263628] = {};
            [209859] = {};
        };
        ["id"] = 136139;
        ["health"] = 1229592;
        ["count"] = 12;
        ["displayId"] = 82943;
        ["creatureType"] = L["Mechanical"];
        ["level"] = 121;
        ["name"] = L["Mechanized Peacekeeper"];
        ["characteristics"] = {
            ["Taunt"] = true;
        };
    };
    [12] = {
        ["clones"] = {
            [1] = {
                ["y"] = -269.35004719114;
                ["x"] = 383.52127517017;
                ["sublevel"] = 1;
            };
        };
        ["name"] = L["Coin-Operated Crowd Pummeler"];
        ["scale"] = 1;
        ["spells"] = {
            [257337] = {};
            [269493] = {};
            [271903] = {};
            [267551] = {};
            [267547] = {};
            [271867] = {};
            [262347] = {};
        };
        ["isBoss"] = true;
        ["encounterID"] = 2109;
        ["instanceID"] = 1012;
        ["count"] = 0;
        ["health"] = 8914542;
        ["displayId"] = 80443;
        ["creatureType"] = L["Mechanical"];
        ["level"] = 122;
        ["id"] = 129214;
        ["characteristics"] = {
            ["Taunt"] = true;
        };
    };
    [13] = {
        ["clones"] = {
            [1] = {
                ["sublevel"] = 1;
                ["x"] = 341.37885347748;
                ["infested"] = {
                    [2] = true;
                };
                ["g"] = 42;
                ["y"] = -248.79042145848;
            };
            [2] = {
                ["y"] = -248.6592433697;
                ["x"] = 322.18181830407;
                ["g"] = 44;
                ["sublevel"] = 1;
            };
            [3] = {
                ["y"] = -269.28650512174;
                ["x"] = 322.41759577357;
                ["g"] = 45;
                ["sublevel"] = 1;
            };
            [4] = {
                ["y"] = -264.95955281291;
                ["x"] = 317.72880363856;
                ["g"] = 45;
                ["sublevel"] = 1;
            };
            [5] = {
                ["y"] = -257.93801060505;
                ["x"] = 309.44674265138;
                ["patrol"] = {
                    [1] = {
                        ["y"] = -257.93801060505;
                        ["x"] = 309.44674265138;
                    };
                    [2] = {
                        ["y"] = -257.91990659878;
                        ["x"] = 298.15392425402;
                    };
                    [3] = {
                        ["y"] = -257.93801060505;
                        ["x"] = 309.44674265138;
                    };
                    [4] = {
                        ["y"] = -257.49952956103;
                        ["x"] = 326.46704569555;
                    };
                };
                ["infested"] = {
                    [3] = true;
                };
                ["g"] = 46;
                ["sublevel"] = 1;
            };
            [6] = {
                ["y"] = -263.24188694247;
                ["x"] = 291.36338999324;
                ["g"] = 48;
                ["sublevel"] = 1;
            };
            [7] = {
                ["y"] = -256.21370937208;
                ["x"] = 270.56060205143;
                ["g"] = 50;
                ["sublevel"] = 1;
            };
            [8] = {
                ["y"] = -266.97301602119;
                ["x"] = 258.25237870002;
                ["g"] = 51;
                ["sublevel"] = 1;
            };
            [9] = {
                ["y"] = -240.242091997;
                ["x"] = 297.41823237674;
                ["g"] = 53;
                ["sublevel"] = 1;
            };
            [10] = {
                ["y"] = -246.10812635318;
                ["x"] = 303.19694717965;
                ["g"] = 53;
                ["sublevel"] = 1;
            };
            [11] = {
                ["y"] = -236.12596711913;
                ["x"] = 281.29724354476;
                ["g"] = 54;
                ["sublevel"] = 1;
            };
            [12] = {
                ["y"] = -183.26444850217;
                ["x"] = 244.43731355328;
                ["g"] = 78;
                ["sublevel"] = 1;
            };
            [13] = {
                ["y"] = -181.49230059643;
                ["x"] = 252.0322517744;
                ["g"] = 78;
                ["sublevel"] = 1;
            };
            [14] = {
                ["y"] = -177.10228965329;
                ["x"] = 254.87533569424;
                ["teeming"] = true;
                ["g"] = 78;
                ["sublevel"] = 1;
            };
        };
        ["reaping"] = 148893;
        ["scale"] = 1;
        ["spells"] = {
            [277242] = {};
            [268709] = {};
            [263202] = {};
            [209859] = {};
            [268722] = {};
            [277564] = {};
            [271579] = {};
        };
        ["id"] = 130661;
        ["count"] = 4;
        ["name"] = L["Venture Co. Earthshaper"];
        ["displayId"] = 81333;
        ["creatureType"] = L["Humanoid"];
        ["level"] = 120;
        ["health"] = 768495;
        ["characteristics"] = {
            ["Taunt"] = true;
            ["Incapacitate"] = true;
            ["Root"] = true;
            ["Polymorph"] = true;
            ["Disorient"] = true;
            ["Sap"] = true;
            ["Stun"] = true;
            ["Slow"] = true;
            ["Silence"] = true;
            ["Fear"] = true;
        };
    };
    [14] = {
        ["clones"] = {
            [1] = {
                ["sublevel"] = 1;
                ["x"] = 336.64831715532;
                ["y"] = -248.51747410029;
                ["g"] = 42;
                ["infested"] = {};
            };
            [2] = {
                ["sublevel"] = 1;
                ["x"] = 340.54952988674;
                ["infested"] = {
                    [1] = true;
                };
                ["g"] = 42;
                ["y"] = -243.87644139072;
            };
            [3] = {
                ["y"] = -269.6340825539;
                ["x"] = 333.12163283447;
                ["g"] = 43;
                ["sublevel"] = 1;
            };
            [4] = {
                ["y"] = -270.78155789664;
                ["x"] = 338.24100852005;
                ["g"] = 43;
                ["sublevel"] = 1;
            };
            [5] = {
                ["y"] = -243.99712109165;
                ["x"] = 321.36786067196;
                ["g"] = 44;
                ["sublevel"] = 1;
            };
            [6] = {
                ["y"] = -252.02475529748;
                ["x"] = 314.70046805279;
                ["g"] = 44;
                ["sublevel"] = 1;
            };
            [7] = {
                ["sublevel"] = 1;
                ["x"] = 285.73839641588;
                ["y"] = -263.39813899924;
                ["g"] = 48;
                ["infested"] = {
                    [1] = true;
                };
            };
            [8] = {
                ["sublevel"] = 1;
                ["x"] = 270.99530544114;
                ["infested"] = {
                    [1] = true;
                };
                ["g"] = 50;
                ["y"] = -250.34413776449;
            };
            [9] = {
                ["y"] = -252.95285225745;
                ["x"] = 266.86495652465;
                ["g"] = 50;
                ["sublevel"] = 1;
            };
            [10] = {
                ["y"] = -257.29908278369;
                ["x"] = 244.5232831631;
                ["g"] = 88;
                ["sublevel"] = 1;
            };
            [11] = {
                ["sublevel"] = 1;
                ["x"] = 246.44636910375;
                ["infested"] = {
                    [1] = true;
                };
                ["g"] = 51;
                ["y"] = -268.64522215933;
            };
        };
        ["reaping"] = 148716;
        ["scale"] = 0.8;
        ["spells"] = {
            [263209] = {};
            [209859] = {};
            [277242] = {};
            [277564] = {};
        };
        ["id"] = 130437;
        ["count"] = 2;
        ["name"] = L["Mine Rat"];
        ["displayId"] = 65436;
        ["creatureType"] = L["Humanoid"];
        ["level"] = 120;
        ["health"] = 461097;
        ["characteristics"] = {
            ["Taunt"] = true;
            ["Root"] = true;
            ["Polymorph"] = true;
            ["Disorient"] = true;
            ["Sap"] = true;
            ["Silence"] = true;
            ["Slow"] = true;
            ["Stun"] = true;
            ["Fear"] = true;
        };
    };
    [15] = {
        ["clones"] = {
            [1] = {
                ["sublevel"] = 1;
                ["x"] = 336.60257197849;
                ["infested"] = {
                    [3] = true;
                };
                ["g"] = 43;
                ["y"] = -265.59673655247;
            };
            [2] = {
                ["y"] = -252.00063473159;
                ["x"] = 318.92820628973;
                ["g"] = 44;
                ["sublevel"] = 1;
            };
            [3] = {
                ["sublevel"] = 1;
                ["x"] = 321.91482562423;
                ["infested"] = {
                    [2] = true;
                };
                ["g"] = 45;
                ["y"] = -264.63248688424;
            };
            [4] = {
                ["y"] = -255.28176587313;
                ["x"] = 305.38422940856;
                ["g"] = 46;
                ["sublevel"] = 1;
            };
            [5] = {
                ["y"] = -261.21926356403;
                ["x"] = 305.38422940856;
                ["g"] = 46;
                ["sublevel"] = 1;
            };
            [6] = {
                ["y"] = -273.33538547124;
                ["x"] = 275.2823863862;
                ["g"] = 49;
                ["sublevel"] = 1;
            };
            [7] = {
                ["y"] = -271.08418338594;
                ["x"] = 269.70900859751;
                ["g"] = 49;
                ["sublevel"] = 1;
            };
            [8] = {
                ["y"] = -237.55447821519;
                ["x"] = 302.93195254732;
                ["g"] = 53;
                ["sublevel"] = 1;
            };
            [9] = {
                ["y"] = -240.77558834183;
                ["x"] = 307.99481933585;
                ["g"] = 53;
                ["sublevel"] = 1;
            };
            [10] = {
                ["y"] = -245.00103764999;
                ["x"] = 275.38344175447;
                ["g"] = 54;
                ["sublevel"] = 1;
            };
            [11] = {
                ["y"] = -172.75811240719;
                ["x"] = 256.71579212167;
                ["g"] = 78;
                ["sublevel"] = 1;
            };
            [12] = {
                ["y"] = -176.93532788558;
                ["x"] = 235.82972559439;
                ["g"] = 78;
                ["sublevel"] = 1;
            };
            [13] = {
                ["y"] = -180.2668553939;
                ["x"] = 239.30571288417;
                ["teeming"] = true;
                ["g"] = 78;
                ["sublevel"] = 1;
            };
        };
        ["reaping"] = 148716;
        ["scale"] = 1;
        ["spells"] = {
            [268362] = {};
            [277242] = {};
            [269313] = {};
            [209859] = {};
            [268712] = {};
            [277564] = {};
        };
        ["id"] = 130653;
        ["count"] = 4;
        ["name"] = L["Wanton Sapper"];
        ["displayId"] = 81316;
        ["creatureType"] = L["Humanoid"];
        ["level"] = 120;
        ["health"] = 768495;
        ["characteristics"] = {
            ["Taunt"] = true;
            ["Incapacitate"] = true;
            ["Root"] = true;
            ["Polymorph"] = true;
            ["Disorient"] = true;
            ["Sap"] = true;
            ["Stun"] = true;
            ["Slow"] = true;
            ["Silence"] = true;
            ["Fear"] = true;
        };
    };
    [16] = {
        ["clones"] = {
            [1] = {
                ["y"] = -268.45436094448;
                ["x"] = 290.29653993565;
                ["g"] = 48;
                ["sublevel"] = 1;
            };
            [2] = {
                ["y"] = -255.35927933195;
                ["x"] = 250.33429794346;
                ["g"] = 88;
                ["sublevel"] = 1;
            };
            [3] = {
                ["sublevel"] = 1;
                ["x"] = 253.56174912058;
                ["infested"] = {
                    [3] = true;
                };
                ["g"] = 51;
                ["y"] = -271.5298510703;
            };
            [4] = {
                ["sublevel"] = 1;
                ["x"] = 279.24259872388;
                ["infested"] = {
                    [3] = true;
                };
                ["g"] = 54;
                ["y"] = -241.57420081507;
            };
        };
        ["reaping"] = 148894;
        ["scale"] = 1.2;
        ["spells"] = {
            [268417] = {};
            [268415] = {};
            [209859] = {};
            [277564] = {};
        };
        ["id"] = 136643;
        ["count"] = 12;
        ["name"] = L["Azerite Extractor"];
        ["displayId"] = 84881;
        ["creatureType"] = L["Mechanical"];
        ["level"] = 121;
        ["health"] = 1229592;
        ["characteristics"] = {
            ["Taunt"] = true;
        };
    };
    [17] = {
        ["clones"] = {
            [1] = {
                ["y"] = -187.06471973415;
                ["x"] = 297.3989234896;
                ["patrol"] = {};
                ["sublevel"] = 1;
            };
            [2] = {
                ["y"] = -198.35504171889;
                ["x"] = 311.91508142068;
                ["patrol"] = {};
                ["sublevel"] = 1;
            };
            [3] = {
                ["y"] = -192.54859515885;
                ["x"] = 332.56021551615;
                ["patrol"] = {};
                ["sublevel"] = 1;
            };
            [4] = {
                ["y"] = -169.57684578475;
                ["x"] = 305.78424056015;
                ["patrol"] = {};
                ["sublevel"] = 1;
            };
            [5] = {
                ["y"] = -171.24349221168;
                ["x"] = 322.8676100705;
                ["patrol"] = {};
                ["sublevel"] = 1;
            };
            [6] = {
                ["y"] = -183.53519624758;
                ["x"] = 315.99259856438;
                ["patrol"] = {};
                ["sublevel"] = 1;
            };
        };
        ["reaping"] = 148716;
        ["scale"] = 1.2;
        ["spells"] = {
            [257478] = {};
        };
        ["stealthDetect"] = true;
        ["name"] = L["Safety Shark"];
        ["health"] = 3073980;
        ["displayId"] = 12207;
        ["creatureType"] = L["Beast"];
        ["level"] = 120;
        ["id"] = 137940;
        ["count"] = 4;
    };
    [18] = {
        ["clones"] = {
            [1] = {
                ["y"] = -221.74336883029;
                ["x"] = 282.48000067196;
                ["g"] = 55;
                ["sublevel"] = 1;
            };
            [2] = {
                ["y"] = -224.90126537291;
                ["x"] = 278.26948700647;
                ["g"] = 55;
                ["sublevel"] = 1;
            };
            [3] = {
                ["y"] = -224.63811532726;
                ["x"] = 281.55896986543;
                ["g"] = 55;
                ["sublevel"] = 1;
            };
            [4] = {
                ["y"] = -194.44559164829;
                ["x"] = 257.86476856303;
                ["g"] = 57;
                ["sublevel"] = 1;
            };
            [5] = {
                ["sublevel"] = 1;
                ["x"] = 252.63086370807;
                ["y"] = -198.73055061898;
                ["g"] = 57;
                ["infested"] = {
                    [1] = true;
                };
            };
            [6] = {
                ["y"] = -198.63700036022;
                ["x"] = 257.04143871153;
                ["g"] = 57;
                ["sublevel"] = 1;
            };
        };
        ["reaping"] = 148716;
        ["scale"] = 0.7;
        ["spells"] = {
            [277564] = {};
            [209859] = {};
            [263262] = {};
            [277242] = {};
        };
        ["id"] = 134005;
        ["name"] = L["Shalebiter"];
        ["health"] = 153699;
        ["displayId"] = 88196;
        ["creatureType"] = L["Elemental"];
        ["level"] = 120;
        ["count"] = 1;
        ["characteristics"] = {
            ["Taunt"] = true;
            ["Silence"] = true;
            ["Root"] = true;
            ["Slow"] = true;
            ["Stun"] = true;
            ["Fear"] = true;
        };
    };
    [19] = {
        ["clones"] = {
            [1] = {
                ["sublevel"] = 1;
                ["x"] = 273.66423133224;
                ["patrol"] = {
                    [1] = {
                        ["y"] = -216.8749518169;
                        ["x"] = 273.66423133224;
                    };
                    [2] = {
                        ["y"] = -210.95390638714;
                        ["x"] = 268.00634159488;
                    };
                    [3] = {
                        ["y"] = -216.8749518169;
                        ["x"] = 273.66423133224;
                    };
                    [4] = {
                        ["y"] = -222.53284720101;
                        ["x"] = 279.71686307833;
                    };
                };
                ["infested"] = {
                    [2] = true;
                };
                ["y"] = -216.8749518169;
            };
            [2] = {
                ["sublevel"] = 1;
                ["x"] = 260.29190043111;
                ["infested"] = {
                    [3] = true;
                };
                ["g"] = 57;
                ["y"] = -203.14913954218;
            };
            [3] = {
                ["y"] = -192.84441003172;
                ["x"] = 252.68472623618;
                ["g"] = 57;
                ["sublevel"] = 1;
            };
        };
        ["reaping"] = 148893;
        ["scale"] = 1;
        ["spells"] = {
            [277242] = {};
            [268704] = {};
            [209859] = {};
            [268702] = {};
            [263215] = {};
            [277564] = {};
        };
        ["id"] = 130635;
        ["name"] = L["Stonefury"];
        ["health"] = 768495;
        ["displayId"] = 83052;
        ["creatureType"] = L["Elemental"];
        ["level"] = 120;
        ["count"] = 4;
        ["characteristics"] = {
            ["Taunt"] = true;
            ["Incapacitate"] = true;
            ["Root"] = true;
            ["Banish"] = true;
            ["Disorient"] = true;
            ["Stun"] = true;
            ["Slow"] = true;
            ["Silence"] = true;
            ["Fear"] = true;
        };
    };
    [20] = {
        ["clones"] = {
            [1] = {
                ["y"] = -176.25325035966;
                ["x"] = 247.29418483409;
                ["g"] = 78;
                ["sublevel"] = 1;
            };
        };
        ["reaping"] = 148894;
        ["scale"] = 1.4;
        ["spells"] = {
            [263583] = {};
            [263601] = {};
            [209859] = {};
            [263276] = {};
            [263586] = {};
            [263275] = {};
        };
        ["id"] = 134012;
        ["name"] = L["Taskmaster Askari"];
        ["health"] = 1229592;
        ["displayId"] = 83286;
        ["creatureType"] = L["Humanoid"];
        ["level"] = 121;
        ["count"] = 6;
        ["characteristics"] = {
            ["Taunt"] = true;
        };
    };
    [21] = {
        ["clones"] = {
            [1] = {
                ["y"] = -149.53323722569;
                ["x"] = 252.15696974033;
                ["g"] = 58;
                ["sublevel"] = 1;
            };
        };
        ["characteristics"] = {
            ["Taunt"] = true;
        };
        ["scale"] = 1;
        ["spells"] = {
            [271698] = {};
            [275907] = {};
            [258622] = {};
            [257597] = {};
            [257593] = {};
        };
        ["isBoss"] = true;
        ["encounterID"] = 2114;
        ["instanceID"] = 1012;
        ["count"] = 0;
        ["health"] = 4733929;
        ["displayId"] = 83891;
        ["creatureType"] = L["Elemental"];
        ["level"] = 122;
        ["name"] = L["Azerokk"];
        ["id"] = 129227;
    };
    [22] = {
        ["clones"] = {
            [1] = {
                ["y"] = -145.56099820803;
                ["x"] = 261.20676759075;
                ["g"] = 58;
                ["sublevel"] = 1;
            };
            [2] = {
                ["y"] = -158.24756556426;
                ["x"] = 257.62465658313;
                ["g"] = 58;
                ["sublevel"] = 1;
            };
            [3] = {
                ["y"] = -153.02369317734;
                ["x"] = 241.80375810842;
                ["g"] = 58;
                ["sublevel"] = 1;
            };
            [4] = {
                ["y"] = -140.03861443538;
                ["x"] = 246.57988903784;
                ["g"] = 58;
                ["sublevel"] = 1;
            };
        };
        ["scale"] = 1;
        ["spells"] = {
            [257544] = {};
            [271526] = {};
            [257582] = {};
            [258627] = {};
        };
        ["id"] = 129802;
        ["name"] = L["Earthrager"];
        ["health"] = 768495;
        ["displayId"] = 83052;
        ["creatureType"] = L["Elemental"];
        ["level"] = 120;
        ["count"] = 0;
        ["characteristics"] = {
            ["Taunt"] = true;
            ["Incapacitate"] = true;
            ["Root"] = true;
            ["Banish"] = true;
            ["Disorient"] = true;
            ["Silence"] = true;
            ["Slow"] = true;
            ["Stun"] = true;
            ["Fear"] = true;
        };
    };
    [23] = {
        ["clones"] = {
            [1] = {
                ["y"] = -104.75213306346;
                ["x"] = 308.8830745492;
                ["g"] = 59;
                ["sublevel"] = 1;
            };
            [2] = {
                ["y"] = -112.39530952304;
                ["x"] = 324.06870177232;
                ["g"] = 59;
                ["sublevel"] = 1;
            };
            [3] = {
                ["y"] = -105.25247907113;
                ["x"] = 326.92585234537;
                ["g"] = 59;
                ["sublevel"] = 1;
            };
            [4] = {
                ["y"] = -101.32388553799;
                ["x"] = 327.64014765209;
                ["g"] = 59;
                ["sublevel"] = 1;
            };
            [5] = {
                ["y"] = -98.823882618294;
                ["x"] = 328.35441230499;
                ["g"] = 59;
                ["sublevel"] = 1;
            };
            [6] = {
                ["y"] = -96.767636866554;
                ["x"] = 314.83818044678;
                ["g"] = 59;
                ["sublevel"] = 1;
            };
            [7] = {
                ["y"] = -94.267649318578;
                ["x"] = 317.73291000349;
                ["g"] = 59;
                ["sublevel"] = 1;
            };
            [8] = {
                ["y"] = -95.320277734951;
                ["x"] = 321.68027362333;
                ["g"] = 59;
                ["sublevel"] = 1;
            };
            [9] = {
                ["y"] = -97.557109590522;
                ["x"] = 317.60132933391;
                ["g"] = 59;
                ["sublevel"] = 1;
            };
            [10] = {
                ["y"] = -99.793958386356;
                ["x"] = 314.57501910762;
                ["g"] = 59;
                ["sublevel"] = 1;
            };
            [11] = {
                ["y"] = -99.004480015633;
                ["x"] = 320.89080089936;
                ["g"] = 59;
                ["sublevel"] = 1;
            };
            [12] = {
                ["y"] = -101.89922086586;
                ["x"] = 309.70660209423;
                ["g"] = 59;
                ["sublevel"] = 1;
            };
            [13] = {
                ["y"] = -107.42552993363;
                ["x"] = 310.36449414862;
                ["g"] = 59;
                ["sublevel"] = 1;
            };
            [14] = {
                ["y"] = -108.87289471199;
                ["x"] = 312.73292361403;
                ["g"] = 59;
                ["sublevel"] = 1;
            };
            [15] = {
                ["y"] = -100.05711972551;
                ["x"] = 317.46974866433;
                ["g"] = 59;
                ["sublevel"] = 1;
            };
            [16] = {
                ["y"] = -101.76763454952;
                ["x"] = 322.60133831039;
                ["g"] = 59;
                ["sublevel"] = 1;
            };
            [17] = {
                ["y"] = -105.32026745413;
                ["x"] = 321.94343496249;
                ["g"] = 59;
                ["sublevel"] = 1;
            };
        };
        ["reaping"] = 148716;
        ["scale"] = 0.6;
        ["spells"] = {
            [271784] = {};
        };
        ["health"] = 153699;
        ["count"] = 0;
        ["displayId"] = 85829;
        ["creatureType"] = L["Humanoid"];
        ["level"] = 120;
        ["id"] = 138369;
        ["name"] = L["Footbomb Hooligan"];
    };
    [24] = {
        ["clones"] = {
            [1] = {
                ["y"] = -114.87366004873;
                ["x"] = 426.4223142796;
                ["g"] = 66;
                ["sublevel"] = 1;
            };
            [2] = {
                ["y"] = -120.73573247268;
                ["x"] = 425.7326203986;
                ["g"] = 66;
                ["sublevel"] = 1;
            };
            [3] = {
                ["y"] = -148.69317920568;
                ["x"] = 361.86321322224;
                ["patrol"] = {
                    [1] = {
                        ["y"] = -148.69317920568;
                        ["x"] = 361.86321322224;
                    };
                    [2] = {
                        ["y"] = -143.91056264851;
                        ["x"] = 354.03715241535;
                    };
                    [3] = {
                        ["y"] = -148.69317920568;
                        ["x"] = 361.86321322224;
                    };
                    [4] = {
                        ["y"] = -149.87321883214;
                        ["x"] = 373.13469152513;
                    };
                };
                ["sublevel"] = 1;
            };
            [4] = {
                ["sublevel"] = 1;
                ["x"] = 364.22819552767;
                ["patrol"] = {
                    [1] = {
                        ["y"] = -111.94521274864;
                        ["x"] = 364.22819552767;
                    };
                    [2] = {
                        ["y"] = -116.9452196157;
                        ["x"] = 357.50405754684;
                    };
                    [3] = {
                        ["y"] = -111.94521274864;
                        ["x"] = 364.22819552767;
                    };
                    [4] = {
                        ["y"] = -108.32451965164;
                        ["x"] = 372.50404855123;
                    };
                };
                ["infested"] = {
                    [3] = true;
                };
                ["y"] = -111.94521274864;
            };
            [5] = {
                ["y"] = -106.89309868833;
                ["x"] = 387.11718681777;
                ["patrol"] = {
                    [1] = {
                        ["y"] = -106.89309868833;
                        ["x"] = 387.11718681777;
                    };
                    [2] = {
                        ["y"] = -102.34763077539;
                        ["x"] = 376.75353807875;
                    };
                    [3] = {
                        ["y"] = -106.89309868833;
                        ["x"] = 387.11718681777;
                    };
                    [4] = {
                        ["y"] = -116.34764448141;
                        ["x"] = 395.6626452705;
                    };
                };
                ["sublevel"] = 1;
            };
            [6] = {
                ["sublevel"] = 1;
                ["x"] = 391.28214632718;
                ["patrol"] = {
                    [1] = {
                        ["y"] = -127.95643401756;
                        ["x"] = 391.28214632718;
                    };
                    [2] = {
                        ["y"] = -134.6805572;
                        ["x"] = 384.90282569007;
                    };
                    [3] = {
                        ["y"] = -127.95643401756;
                        ["x"] = 391.28214632718;
                    };
                    [4] = {
                        ["y"] = -121.23230343592;
                        ["x"] = 396.28215319424;
                    };
                };
                ["infested"] = {
                    [3] = true;
                };
                ["y"] = -127.95643401756;
            };
            [7] = {
                ["sublevel"] = 1;
                ["x"] = 371.83635399335;
                ["patrol"] = {
                    [1] = {
                        ["y"] = -134.454518109;
                        ["x"] = 367.57290486676;
                    };
                    [2] = {
                        ["y"] = -140.73360211461;
                        ["x"] = 377.57289908;
                    };
                    [3] = {
                        ["y"] = -134.454518109;
                        ["x"] = 367.57290486676;
                    };
                    [4] = {
                        ["y"] = -128.64055661211;
                        ["x"] = 358.03803316225;
                    };
                };
                ["infested"] = {};
                ["y"] = -135.82534968228;
            };
            [8] = {
                ["y"] = -109.67485765522;
                ["x"] = 409.74688664058;
                ["teeming"] = true;
                ["g"] = 65;
                ["sublevel"] = 1;
            };
            [9] = {
                ["y"] = -126.78425288335;
                ["x"] = 370.46648478504;
                ["infested"] = {};
                ["teeming"] = true;
                ["g"] = 75;
                ["sublevel"] = 1;
            };
        };
        ["reaping"] = 148894;
        ["id"] = 133430;
        ["spells"] = {
            [262804] = {};
            [262794] = {};
            [209859] = {};
            [262947] = {};
            [271428] = {};
            [277564] = {};
        };
        ["stealthDetect"] = true;
        ["characteristics"] = {
            ["Taunt"] = true;
        };
        ["health"] = 1229592;
        ["count"] = 8;
        ["displayId"] = 83136;
        ["creatureType"] = L["Humanoid"];
        ["level"] = 121;
        ["name"] = L["Venture Co. Mastermind"];
        ["scale"] = 1.2;
    };
    [25] = {
        ["clones"] = {
            [1] = {
                ["y"] = -96.118657816419;
                ["x"] = 342.49887736161;
                ["g"] = 60;
                ["sublevel"] = 1;
            };
            [2] = {
                ["y"] = -97.670387657532;
                ["x"] = 339.05061513406;
                ["g"] = 60;
                ["sublevel"] = 1;
            };
            [3] = {
                ["y"] = -110.67757559578;
                ["x"] = 352.86760421168;
                ["g"] = 61;
                ["sublevel"] = 1;
            };
            [4] = {
                ["sublevel"] = 1;
                ["x"] = 371.70169599061;
                ["infested"] = {
                    [3] = true;
                };
                ["g"] = 63;
                ["y"] = -88.467782982899;
            };
            [5] = {
                ["y"] = -91.814075922799;
                ["x"] = 382.49051316428;
                ["g"] = 64;
                ["sublevel"] = 1;
            };
            [6] = {
                ["y"] = -109.01160242318;
                ["x"] = 423.83608801216;
                ["g"] = 66;
                ["sublevel"] = 1;
            };
            [7] = {
                ["sublevel"] = 1;
                ["x"] = 408.80034973201;
                ["infested"] = {
                    [2] = true;
                };
                ["g"] = 67;
                ["y"] = -126.9038768246;
            };
            [8] = {
                ["y"] = -156.20269452448;
                ["x"] = 376.06223543989;
                ["g"] = 73;
                ["sublevel"] = 1;
            };
            [9] = {
                ["y"] = -157.08512826728;
                ["x"] = 354.36371909447;
                ["g"] = 74;
                ["sublevel"] = 1;
            };
            [10] = {
                ["y"] = -119.66097180029;
                ["x"] = 364.57607893489;
                ["g"] = 75;
                ["sublevel"] = 1;
            };
            [11] = {
                ["y"] = -118.56508466398;
                ["x"] = 369.7815560597;
                ["g"] = 75;
                ["sublevel"] = 1;
            };
        };
        ["reaping"] = 148716;
        ["scale"] = 0.8;
        ["spells"] = {
            [263105] = {};
            [277564] = {};
            [263074] = {};
            [263103] = {};
            [209859] = {};
            [263066] = {};
            [262263] = {};
            [277242] = {};
        };
        ["id"] = 133345;
        ["health"] = 768495;
        ["count"] = 5;
        ["displayId"] = 82866;
        ["creatureType"] = L["Humanoid"];
        ["level"] = 120;
        ["name"] = L["Feckless Assistant"];
        ["characteristics"] = {
            ["Taunt"] = true;
            ["Root"] = true;
            ["Polymorph"] = true;
            ["Disorient"] = true;
            ["Sap"] = true;
            ["Silence"] = true;
            ["Slow"] = true;
            ["Stun"] = true;
            ["Fear"] = true;
        };
    };
    [26] = {
        ["clones"] = {
            [1] = {
                ["sublevel"] = 1;
                ["x"] = 338.6933916311;
                ["infested"] = {
                    [2] = true;
                };
                ["g"] = 60;
                ["y"] = -92.98872066061;
            };
            [2] = {
                ["sublevel"] = 1;
                ["x"] = 386.05215664521;
                ["g"] = 64;
                ["y"] = -94.416826242829;
            };
            [3] = {
                ["sublevel"] = 1;
                ["x"] = 400.78138413119;
                ["g"] = 65;
                ["y"] = -106.22658062928;
            };
            [4] = {
                ["sublevel"] = 1;
                ["x"] = 403.53999687291;
                ["g"] = 65;
                ["y"] = -111.22658749633;
            };
            [5] = {
                ["sublevel"] = 1;
                ["x"] = 397.47278205007;
                ["g"] = 68;
                ["y"] = -154.86916077277;
            };
            [6] = {
                ["y"] = -168.07602044777;
                ["x"] = 375.50234780232;
                ["g"] = 72;
                ["sublevel"] = 1;
            };
            [7] = {
                ["sublevel"] = 1;
                ["x"] = 349.01942633565;
                ["g"] = 74;
                ["y"] = -157.60974069404;
            };
            [8] = {
                ["sublevel"] = 1;
                ["x"] = 366.63087686854;
                ["g"] = 75;
                ["y"] = -123.08563894226;
            };
        };
        ["reaping"] = 148716;
        ["scale"] = 0.8;
        ["spells"] = {
            [277242] = {};
            [268865] = {};
            [268846] = {};
            [277564] = {};
            [209859] = {};
        };
        ["id"] = 136934;
        ["health"] = 768495;
        ["teemingCount"] = 5;
        ["count"] = 4;
        ["displayId"] = 84962;
        ["creatureType"] = L["Humanoid"];
        ["level"] = 120;
        ["name"] = L["Weapons Tester"];
        ["characteristics"] = {
            ["Taunt"] = true;
            ["Disorient"] = true;
            ["Sap"] = true;
            ["Root"] = true;
            ["Slow"] = true;
            ["Stun"] = true;
            ["Fear"] = true;
        };
    };
    [27] = {
        ["clones"] = {
            [1] = {
                ["y"] = -108.03046315425;
                ["x"] = 356.65256956271;
                ["g"] = 61;
                ["sublevel"] = 1;
            };
            [2] = {
                ["y"] = -92.698542186826;
                ["x"] = 365.67812842666;
                ["g"] = 63;
                ["sublevel"] = 1;
            };
            [3] = {
                ["sublevel"] = 1;
                ["x"] = 382.62750126087;
                ["patrol"] = {
                    [1] = {
                        ["y"] = -95.78667193589;
                        ["x"] = 382.62750126087;
                    };
                    [2] = {
                        ["y"] = -94.416826242829;
                        ["x"] = 369.47680859463;
                    };
                    [3] = {
                        ["y"] = -95.78667193589;
                        ["x"] = 382.62750126087;
                    };
                };
                ["infested"] = {
                    [2] = true;
                };
                ["y"] = -95.78667193589;
            };
            [4] = {
                ["y"] = -105.19209900133;
                ["x"] = 405.95380706931;
                ["g"] = 65;
                ["sublevel"] = 1;
            };
            [5] = {
                ["y"] = -127.90752708398;
                ["x"] = 425.7219165469;
                ["g"] = 66;
                ["sublevel"] = 1;
            };
            [6] = {
                ["y"] = -130.66933052743;
                ["x"] = 407.86632302462;
                ["g"] = 67;
                ["sublevel"] = 1;
            };
            [7] = {
                ["y"] = -132.6143762488;
                ["x"] = 405.67241033308;
                ["g"] = 67;
                ["sublevel"] = 1;
            };
            [8] = {
                ["y"] = -135.36437031115;
                ["x"] = 402.42238808984;
                ["g"] = 67;
                ["sublevel"] = 1;
            };
            [9] = {
                ["y"] = -143.8855500859;
                ["x"] = 400.09572524552;
                ["g"] = 68;
                ["sublevel"] = 1;
            };
            [10] = {
                ["sublevel"] = 1;
                ["x"] = 390.98602676877;
                ["infested"] = {
                    [3] = true;
                };
                ["g"] = 71;
                ["y"] = -171.12315932201;
            };
            [11] = {
                ["y"] = -159.81880987673;
                ["x"] = 385.1164764989;
                ["g"] = 71;
                ["sublevel"] = 1;
            };
            [12] = {
                ["y"] = -164.63852884306;
                ["x"] = 371.59605979418;
                ["g"] = 72;
                ["sublevel"] = 1;
            };
            [13] = {
                ["y"] = -170.26352242043;
                ["x"] = 371.59605979418;
                ["g"] = 72;
                ["sublevel"] = 1;
            };
            [14] = {
                ["y"] = -155.20682004787;
                ["x"] = 372.07401292909;
                ["g"] = 73;
                ["sublevel"] = 1;
            };
            [15] = {
                ["y"] = -151.01280214673;
                ["x"] = 374.92301263338;
                ["g"] = 73;
                ["sublevel"] = 1;
            };
            [16] = {
                ["sublevel"] = 1;
                ["x"] = 350.33091903928;
                ["infested"] = {
                    [2] = true;
                };
                ["g"] = 74;
                ["y"] = -152.36386133844;
            };
            [17] = {
                ["y"] = -123.22261528122;
                ["x"] = 373.34321129826;
                ["g"] = 75;
                ["sublevel"] = 1;
            };
            [18] = {
                ["y"] = -141.97633420248;
                ["x"] = 365.27023237456;
                ["g"] = 77;
                ["sublevel"] = 1;
            };
            [19] = {
                ["y"] = -110.88177015262;
                ["x"] = 398.54000480425;
                ["teeming"] = true;
                ["g"] = 65;
                ["sublevel"] = 1;
            };
            [20] = {
                ["y"] = -122.80716290171;
                ["x"] = 362.11289539306;
                ["teeming"] = true;
                ["g"] = 75;
                ["sublevel"] = 1;
            };
        };
        ["reaping"] = 148716;
        ["scale"] = 1;
        ["spells"] = {
            [277242] = {};
            [277564] = {};
            [209859] = {};
            [262268] = {};
            [262270] = {};
            [268797] = {};
        };
        ["id"] = 133432;
        ["health"] = 768495;
        ["count"] = 5;
        ["displayId"] = 82915;
        ["creatureType"] = L["Humanoid"];
        ["level"] = 120;
        ["name"] = L["Venture Co. Alchemist"];
        ["characteristics"] = {
            ["Taunt"] = true;
            ["Root"] = true;
            ["Disorient"] = true;
            ["Sap"] = true;
            ["Imprison"] = true;
            ["Silence"] = true;
            ["Slow"] = true;
            ["Stun"] = true;
            ["Fear"] = true;
        };
    };
    [28] = {
        ["clones"] = {
            [1] = {
                ["y"] = -107.42976385598;
                ["x"] = 349.88940408128;
                ["g"] = 61;
                ["sublevel"] = 1;
            };
            [2] = {
                ["y"] = -114.07371491933;
                ["x"] = 354.42467417492;
                ["g"] = 61;
                ["sublevel"] = 1;
            };
            [3] = {
                ["sublevel"] = 1;
                ["x"] = 351.94330961943;
                ["infested"] = {
                    [1] = true;
                };
                ["g"] = 61;
                ["y"] = -114.7335668989;
            };
            [4] = {
                ["y"] = -91.845982810497;
                ["x"] = 354.30545462517;
                ["g"] = 62;
                ["sublevel"] = 1;
            };
            [5] = {
                ["y"] = -90.085019455527;
                ["x"] = 356.3571527917;
                ["g"] = 62;
                ["sublevel"] = 1;
            };
            [6] = {
                ["y"] = -89.948031358933;
                ["x"] = 358.95990311173;
                ["g"] = 62;
                ["sublevel"] = 1;
            };
            [7] = {
                ["y"] = -92.002829292588;
                ["x"] = 357.86398658135;
                ["g"] = 62;
                ["sublevel"] = 1;
            };
            [8] = {
                ["y"] = -93.3726985009;
                ["x"] = 356.3571527917;
                ["g"] = 62;
                ["sublevel"] = 1;
            };
            [9] = {
                ["y"] = -93.3726985009;
                ["x"] = 354.02837866486;
                ["g"] = 62;
                ["sublevel"] = 1;
            };
            [10] = {
                ["sublevel"] = 1;
                ["x"] = 403.21050634604;
                ["infested"] = {
                    [1] = true;
                };
                ["g"] = 68;
                ["y"] = -147.32816918582;
            };
            [11] = {
                ["y"] = -146.83636645726;
                ["x"] = 395.66950772378;
                ["g"] = 68;
                ["sublevel"] = 1;
            };
            [12] = {
                ["y"] = -149.78718986392;
                ["x"] = 396.81706383946;
                ["g"] = 68;
                ["sublevel"] = 1;
            };
            [13] = {
                ["y"] = -151.09866146165;
                ["x"] = 400.09572524552;
                ["g"] = 68;
                ["sublevel"] = 1;
            };
            [14] = {
                ["y"] = -147.98392257293;
                ["x"] = 400.42361249203;
                ["g"] = 68;
                ["sublevel"] = 1;
            };
            [15] = {
                ["y"] = -119.36467831552;
                ["x"] = 386.12787103318;
                ["g"] = 69;
                ["sublevel"] = 1;
            };
            [16] = {
                ["y"] = -117.29667688676;
                ["x"] = 388.49345438637;
                ["g"] = 69;
                ["sublevel"] = 1;
            };
            [17] = {
                ["y"] = -117.28400446284;
                ["x"] = 384.20244905826;
                ["g"] = 69;
                ["sublevel"] = 1;
            };
            [18] = {
                ["y"] = -119.46581251914;
                ["x"] = 389.47518372237;
                ["g"] = 69;
                ["sublevel"] = 1;
            };
            [19] = {
                ["y"] = -115.45457574642;
                ["x"] = 385.8618748753;
                ["g"] = 69;
                ["sublevel"] = 1;
            };
            [20] = {
                ["sublevel"] = 1;
                ["x"] = 387.92423900664;
                ["infested"] = {
                    [1] = true;
                };
                ["g"] = 71;
                ["y"] = -162.87146377604;
            };
            [21] = {
                ["y"] = -164.12146011361;
                ["x"] = 384.17424328839;
                ["g"] = 71;
                ["sublevel"] = 1;
            };
            [22] = {
                ["y"] = -166.465200732;
                ["x"] = 384.48674740193;
                ["g"] = 71;
                ["sublevel"] = 1;
            };
            [23] = {
                ["y"] = -168.18395994539;
                ["x"] = 387.76800036091;
                ["g"] = 71;
                ["sublevel"] = 1;
            };
            [24] = {
                ["y"] = -165.37145645119;
                ["x"] = 389.64299822004;
                ["g"] = 71;
                ["sublevel"] = 1;
            };
            [25] = {
                ["y"] = -140.30334173465;
                ["x"] = 368.90539961288;
                ["g"] = 77;
                ["sublevel"] = 1;
            };
            [26] = {
                ["sublevel"] = 1;
                ["x"] = 368.78344679363;
                ["infested"] = {
                    [1] = true;
                };
                ["g"] = 77;
                ["y"] = -143.83992115723;
            };
            [27] = {
                ["y"] = -145.4252921068;
                ["x"] = 366.83223308703;
                ["g"] = 77;
                ["sublevel"] = 1;
            };
            [28] = {
                ["y"] = -141.76675463138;
                ["x"] = 361.3444294907;
                ["g"] = 77;
                ["sublevel"] = 1;
            };
            [29] = {
                ["y"] = -138.47407038016;
                ["x"] = 362.68590003534;
                ["g"] = 77;
                ["sublevel"] = 1;
            };
        };
        ["reaping"] = 148716;
        ["scale"] = 0.5;
        ["spells"] = {
            [268810] = {};
            [277564] = {};
            [209859] = {};
            [268815] = {};
            [277242] = {};
        };
        ["id"] = 133963;
        ["health"] = 153699;
        ["count"] = 1;
        ["displayId"] = 1141;
        ["creatureType"] = L["Humanoid"];
        ["level"] = 120;
        ["name"] = L["Test Subject"];
        ["characteristics"] = {
            ["Taunt"] = true;
            ["Disorient"] = true;
            ["Stun"] = true;
            ["Slow"] = true;
            ["Fear"] = true;
        };
    };
    [29] = {
        ["clones"] = {
            [1] = {
                ["y"] = -112.22534117666;
                ["x"] = 466.80802997306;
                ["sublevel"] = 1;
            };
        };
        ["characteristics"] = {
            ["Taunt"] = true;
        };
        ["scale"] = 1;
        ["spells"] = {
            [259474] = {};
            [259853] = {};
            [260669] = {};
            [259856] = {};
        };
        ["isBoss"] = true;
        ["encounterID"] = 2115;
        ["instanceID"] = 1012;
        ["count"] = 0;
        ["health"] = 5379465;
        ["displayId"] = 81489;
        ["creatureType"] = L["Humanoid"];
        ["level"] = 122;
        ["name"] = L["Rixxa Fluxflame"];
        ["id"] = 129231;
    };
    [30] = {
        ["clones"] = {
            [1] = {
                ["sublevel"] = 1;
                ["x"] = 502.68530584216;
                ["infested"] = {
                    [2] = true;
                };
                ["g"] = 79;
                ["y"] = -107.66784182933;
            };
            [2] = {
                ["y"] = -125.80409887054;
                ["x"] = 495.31446879142;
                ["g"] = 80;
                ["sublevel"] = 1;
            };
            [3] = {
                ["y"] = -113.58970168772;
                ["x"] = 558.3736973268;
                ["g"] = 82;
                ["sublevel"] = 1;
            };
            [4] = {
                ["sublevel"] = 1;
                ["x"] = 602.49991019652;
                ["y"] = -138.97133650933;
                ["g"] = 86;
                ["infested"] = {
                    [3] = true;
                };
            };
            [5] = {
                ["y"] = -160.00768784213;
                ["x"] = 606.66641360611;
                ["g"] = 85;
                ["sublevel"] = 1;
            };
            [6] = {
                ["y"] = -121.57230531622;
                ["x"] = 550.29518805671;
                ["g"] = 90;
                ["sublevel"] = 1;
            };
        };
        ["reaping"] = 148893;
        ["scale"] = 1;
        ["spells"] = {
            [262540] = {};
            [277564] = {};
            [262554] = {};
            [277242] = {};
        };
        ["id"] = 133593;
        ["health"] = 768495;
        ["count"] = 5;
        ["displayId"] = 83034;
        ["creatureType"] = L["Humanoid"];
        ["level"] = 120;
        ["name"] = L["Expert Technician"];
        ["characteristics"] = {
            ["Taunt"] = true;
            ["Incapacitate"] = true;
            ["Disorient"] = true;
            ["Stun"] = true;
            ["Slow"] = true;
            ["Silence"] = true;
            ["Imprison"] = true;
        };
    };
    [31] = {
        ["clones"] = {
            [1] = {
                ["sublevel"] = 1;
                ["x"] = 507.03313398718;
                ["infested"] = {
                    [3] = true;
                };
                ["g"] = 79;
                ["y"] = -104.40698471469;
            };
            [2] = {
                ["y"] = -128.99618133409;
                ["x"] = 501.79495014634;
                ["g"] = 80;
                ["sublevel"] = 1;
            };
            [3] = {
                ["y"] = -116.09386714438;
                ["x"] = 591.63697586743;
                ["patrol"] = {
                    [1] = {
                        ["y"] = -116.09386714438;
                        ["x"] = 591.63697586743;
                    };
                    [2] = {
                        ["y"] = -108.63118498562;
                        ["x"] = 586.26383497711;
                    };
                    [3] = {
                        ["y"] = -116.09386714438;
                        ["x"] = 591.63697586743;
                    };
                    [4] = {
                        ["y"] = -125.49684768927;
                        ["x"] = 598.20413667957;
                    };
                };
                ["sublevel"] = 1;
            };
            [4] = {
                ["sublevel"] = 1;
                ["x"] = 574.2169183565;
                ["patrol"] = {
                    [1] = {
                        ["y"] = -126.52056756911;
                        ["x"] = 576.08848904957;
                    };
                    [2] = {
                        ["y"] = -113.72897735969;
                        ["x"] = 570.14284059589;
                    };
                    [3] = {
                        ["y"] = -126.52056756911;
                        ["x"] = 576.08848904957;
                    };
                    [4] = {
                        ["y"] = -145.2302194779;
                        ["x"] = 584.15297508797;
                    };
                };
                ["y"] = -119.0625439491;
                ["infested"] = {
                    [3] = true;
                };
            };
            [5] = {
                ["y"] = -149.69133509057;
                ["x"] = 564.63620385762;
                ["patrol"] = {
                    [1] = {
                        ["y"] = -149.69133509057;
                        ["x"] = 564.63620385762;
                    };
                    [2] = {
                        ["y"] = -140.28280291519;
                        ["x"] = 557.72836194741;
                    };
                    [3] = {
                        ["y"] = -149.69133509057;
                        ["x"] = 564.63620385762;
                    };
                    [4] = {
                        ["y"] = -157.17932630602;
                        ["x"] = 570.6594044943;
                    };
                };
                ["sublevel"] = 1;
            };
            [6] = {
                ["y"] = -165.32110385425;
                ["x"] = 610.70629446065;
                ["g"] = 85;
                ["sublevel"] = 1;
            };
        };
        ["reaping"] = 148894;
        ["id"] = 133463;
        ["spells"] = {
            [269099] = {};
            [277564] = {};
            [262383] = {};
            [269100] = {};
            [269429] = {};
        };
        ["stealthDetect"] = true;
        ["characteristics"] = {
            ["Taunt"] = true;
        };
        ["scale"] = 1.3;
        ["health"] = 1229592;
        ["displayId"] = 83391;
        ["creatureType"] = L["Mechanical"];
        ["level"] = 121;
        ["name"] = L["Venture Co. War Machine"];
        ["count"] = 12;
    };
    [32] = {
        ["clones"] = {
            [1] = {
                ["sublevel"] = 1;
                ["x"] = 505.66596989434;
                ["infested"] = {
                    [1] = true;
                    [2] = true;
                };
                ["g"] = 80;
                ["y"] = -122.86716363872;
            };
            [2] = {
                ["sublevel"] = 1;
                ["x"] = 519.75965424701;
                ["infested"] = {
                    [2] = true;
                };
                ["g"] = 81;
                ["y"] = -105.79333791783;
            };
            [3] = {
                ["y"] = -112.34037467397;
                ["x"] = 519.68925146648;
                ["g"] = 81;
                ["sublevel"] = 1;
            };
            [4] = {
                ["y"] = -108.8101506555;
                ["x"] = 547.55938846329;
                ["sublevel"] = 1;
            };
            [5] = {
                ["y"] = -118.15494269766;
                ["x"] = 560.76499627596;
                ["g"] = 82;
                ["sublevel"] = 1;
            };
            [6] = {
                ["sublevel"] = 1;
                ["x"] = 586.47345853923;
                ["infested"] = {
                    [2] = true;
                };
                ["g"] = 84;
                ["y"] = -147.43362106064;
            };
        };
        ["reaping"] = 148716;
        ["scale"] = 1;
        ["spells"] = {
            [269090] = {};
            [269092] = {};
            [277242] = {};
            [209859] = {};
            [277564] = {};
        };
        ["id"] = 137029;
        ["health"] = 768495;
        ["count"] = 5;
        ["displayId"] = 85024;
        ["creatureType"] = L["Humanoid"];
        ["level"] = 120;
        ["name"] = L["Ordnance Specialist"];
        ["characteristics"] = {
            ["Taunt"] = true;
            ["Disorient"] = true;
            ["Stun"] = true;
            ["Slow"] = true;
            ["Incapacitate"] = true;
        };
    };
    [33] = {
        ["clones"] = {
            [1] = {
                ["y"] = -114.90501753788;
                ["x"] = 538.77523388938;
                ["sublevel"] = 1;
            };
            [2] = {
                ["y"] = -99.129630339316;
                ["x"] = 538.46753015731;
                ["infested"] = {
                    [2] = true;
                };
                ["sublevel"] = 1;
            };
            [3] = {
                ["y"] = -127.01005945566;
                ["x"] = 554.9281381064;
                ["sublevel"] = 1;
            };
            [4] = {
                ["y"] = -107.02042727081;
                ["x"] = 568.88324042251;
                ["g"] = 83;
                ["sublevel"] = 1;
            };
            [5] = {
                ["y"] = -111.70792191861;
                ["x"] = 566.85199050662;
                ["g"] = 83;
                ["sublevel"] = 1;
            };
            [6] = {
                ["y"] = -153.32402103198;
                ["x"] = 579.89810044849;
                ["g"] = 84;
                ["sublevel"] = 1;
            };
            [7] = {
                ["y"] = -130.64835797805;
                ["x"] = 602.10878780705;
                ["sublevel"] = 1;
                ["infested"] = {
                    [3] = true;
                };
            };
            [8] = {
                ["y"] = -158.96290439736;
                ["x"] = 612.93507584307;
                ["g"] = 85;
                ["sublevel"] = 1;
            };
            [9] = {
                ["y"] = -166.42558655613;
                ["x"] = 603.68135099104;
                ["g"] = 85;
                ["sublevel"] = 1;
            };
        };
        ["reaping"] = 148716;
        ["scale"] = 1;
        ["spells"] = {
            [277242] = {};
            [281621] = {};
            [277564] = {};
            [260372] = {};
            [209859] = {};
            [262513] = {};
            [262515] = {};
            [262287] = {};
        };
        ["characteristics"] = {
            ["Taunt"] = true;
        };
        ["health"] = 768495;
        ["count"] = 5;
        ["displayId"] = 82922;
        ["creatureType"] = L["Humanoid"];
        ["level"] = 120;
        ["name"] = L["Venture Co. Skyscorcher"];
        ["id"] = 133436;
    };
    [34] = {
        ["clones"] = {
            [1] = {
                ["y"] = -210.91697510937;
                ["x"] = 578.23777434257;
                ["sublevel"] = 1;
            };
        };
        ["characteristics"] = {
            ["Taunt"] = true;
        };
        ["scale"] = 1;
        ["spells"] = {
            [260323] = {};
            [260190] = {};
            [260280] = {};
            [260811] = {};
            [260813] = {};
            [271456] = {};
            [260202] = {};
            [260189] = {};
            [260318] = {};
            [276212] = {};
            [270277] = {};
            [270926] = {};
        };
        ["isBoss"] = true;
        ["encounterID"] = 2116;
        ["instanceID"] = 1012;
        ["count"] = 0;
        ["health"] = 5994261;
        ["displayId"] = 81816;
        ["creatureType"] = L["Mechanical"];
        ["level"] = 122;
        ["name"] = L["Mogul Razdunk"];
        ["id"] = 129232;
    };
    [35] = {
        ["clones"] = {
            [1] = {
                ["y"] = -109.86235489806;
                ["x"] = 523.10031706718;
                ["g"] = 81;
                ["sublevel"] = 1;
            };
            [2] = {
                ["y"] = -118.95296105033;
                ["x"] = 525.2051065873;
                ["sublevel"] = 1;
            };
            [3] = {
                ["y"] = -96.483800295248;
                ["x"] = 518.01036176257;
                ["sublevel"] = 1;
            };
            [4] = {
                ["y"] = -106.84243946323;
                ["x"] = 528.91721638771;
                ["sublevel"] = 1;
            };
            [5] = {
                ["y"] = -91.606328234521;
                ["x"] = 529.03708273502;
                ["sublevel"] = 1;
            };
            [6] = {
                ["y"] = -100.5006560559;
                ["x"] = 549.24948717915;
                ["sublevel"] = 1;
            };
            [7] = {
                ["y"] = -127.04978404908;
                ["x"] = 549.62471512875;
                ["sublevel"] = 1;
            };
            [8] = {
                ["y"] = -140.92006428613;
                ["x"] = 556.63460193472;
                ["sublevel"] = 1;
            };
            [9] = {
                ["y"] = -157.62893163199;
                ["x"] = 570.05231417427;
                ["sublevel"] = 1;
            };
            [10] = {
                ["y"] = -106.05627477129;
                ["x"] = 563.56908813178;
                ["g"] = 83;
                ["sublevel"] = 1;
            };
            [11] = {
                ["y"] = -125.16008960038;
                ["x"] = 594.5664396924;
                ["sublevel"] = 1;
            };
            [12] = {
                ["y"] = -135.01951743756;
                ["x"] = 604.86618540451;
                ["g"] = 86;
                ["sublevel"] = 1;
            };
            [13] = {
                ["y"] = -126.05401492818;
                ["x"] = 608.83169584523;
                ["sublevel"] = 1;
            };
            [14] = {
                ["y"] = -151.90464432582;
                ["x"] = 584.22776588243;
                ["g"] = 84;
                ["sublevel"] = 1;
            };
            [15] = {
                ["y"] = -137.84301532828;
                ["x"] = 581.15178658182;
                ["sublevel"] = 1;
            };
            [16] = {
                ["y"] = -146.71115472387;
                ["x"] = 606.88765938666;
                ["sublevel"] = 1;
            };
            [17] = {
                ["y"] = -157.38732508187;
                ["x"] = 591.40619005933;
                ["sublevel"] = 1;
            };
            [18] = {
                ["y"] = -106.29985863928;
                ["x"] = 582.18172379917;
                ["sublevel"] = 1;
            };
            [19] = {
                ["y"] = -109.51050590374;
                ["x"] = 596.53743518509;
                ["sublevel"] = 1;
            };
        };
        ["reaping"] = 148894;
        ["scale"] = 0.7;
        ["spells"] = {
            [277564] = {};
            [262348] = {};
            [277242] = {};
            [262377] = {};
        };
        ["characteristics"] = {
            ["Root"] = true;
            ["Slow"] = true;
        };
        ["health"] = 19707;
        ["count"] = 1;
        ["displayId"] = 49134;
        ["creatureType"] = L["Mechanical"];
        ["level"] = 121;
        ["name"] = L["Crawler Mine"];
        ["id"] = 133482;
    };
    [36] = {
        ["clones"] = {
            [1] = {
                ["y"] = -349.0153562019;
                ["x"] = 452.76276992635;
                ["sublevel"] = 1;
            };
            [2] = {
                ["y"] = -332.18362000556;
                ["x"] = 463.47855634964;
                ["sublevel"] = 1;
            };
            [3] = {
                ["y"] = -342.42002021961;
                ["x"] = 484.79616675868;
                ["sublevel"] = 1;
            };
            [4] = {
                ["y"] = -317.60601667629;
                ["x"] = 489.9598137371;
                ["sublevel"] = 1;
            };
            [5] = {
                ["y"] = -306.7816622197;
                ["x"] = 480.33373232292;
                ["sublevel"] = 1;
            };
            [6] = {
                ["y"] = -300.0470909243;
                ["x"] = 464.44097692694;
                ["sublevel"] = 1;
            };
            [7] = {
                ["y"] = -303.97643978494;
                ["x"] = 456.33809052917;
                ["sublevel"] = 1;
            };
            [8] = {
                ["y"] = -325.33374698576;
                ["x"] = 415.68526370019;
                ["sublevel"] = 1;
            };
            [9] = {
                ["y"] = -338.91935176132;
                ["x"] = 424.26441507197;
                ["sublevel"] = 1;
            };
            [10] = {
                ["y"] = -337.70941677999;
                ["x"] = 440.31990437513;
                ["sublevel"] = 1;
            };
            [11] = {
                ["y"] = -414.06142606187;
                ["x"] = 475.46170266607;
                ["sublevel"] = 1;
            };
            [12] = {
                ["y"] = -337.97276073111;
                ["x"] = 451.21285447553;
                ["sublevel"] = 1;
            };
        };
        ["reaping"] = 148894;
        ["scale"] = 1.2;
        ["spells"] = {
            [262412] = {};
            [277564] = {};
            [267367] = {};
            [209859] = {};
            [262066] = {};
            [263628] = {};
        };
        ["id"] = 130485;
        ["health"] = 1229592;
        ["count"] = 12;
        ["displayId"] = 82943;
        ["creatureType"] = L["Mechanical"];
        ["level"] = 121;
        ["name"] = L["Mechanized Peacekeeper"];
        ["characteristics"] = {
            ["Taunt"] = true;
        };
    };
    [37] = {
        ["clones"] = {
            [1] = {
                ["y"] = -260.93717892805;
                ["x"] = 592.36265829;
                ["g"] = 87;
                ["sublevel"] = 1;
            };
            [2] = {
                ["y"] = -257.0565821558;
                ["x"] = 597.13880202998;
                ["g"] = 87;
                ["sublevel"] = 1;
            };
            [3] = {
                ["y"] = -253.62374605687;
                ["x"] = 602.06415022062;
                ["g"] = 87;
                ["sublevel"] = 1;
            };
            [4] = {
                ["y"] = -261.68344458181;
                ["x"] = 597.73577355924;
                ["g"] = 87;
                ["sublevel"] = 1;
            };
            [5] = {
                ["y"] = -258.39986417575;
                ["x"] = 602.21341872403;
                ["g"] = 87;
                ["sublevel"] = 1;
            };
        };
        ["reaping"] = 148716;
        ["scale"] = 1;
        ["health"] = 153699;
        ["count"] = 0;
        ["displayId"] = 85704;
        ["creatureType"] = L["Humanoid"];
        ["level"] = 120;
        ["id"] = 144286;
        ["name"] = L["Asset Manager"];
    };
    [38] = {
        ["clones"] = {
            [1] = {
                ["y"] = -319.75791518289;
                ["x"] = 495.93072211015;
                ["g"] = 23;
                ["sublevel"] = 1;
            };
        };
        ["reaping"] = 148716;
        ["scale"] = 1;
        ["name"] = L["Off-Duty Laborer"];
        ["health"] = 307398;
        ["displayId"] = 81229;
        ["creatureType"] = L["Humanoid"];
        ["level"] = 120;
        ["id"] = 135975;
        ["count"] = 0;
    };
    [39] = {
        ["clones"] = {
            [1] = {
                ["y"] = -440.46506334809;
                ["x"] = 456.21730727281;
                ["sublevel"] = 1;
                ["g"] = 1;
                ["week"] = {
                    [1] = true;
                    [10] = true;
                    [7] = true;
                    [4] = true;
                };
            };
            [2] = {
                ["y"] = -399.05851592266;
                ["x"] = 457.93196886807;
                ["sublevel"] = 1;
                ["g"] = 6;
                ["week"] = {
                    [1] = true;
                    [10] = true;
                    [4] = true;
                    [7] = true;
                };
            };
            [3] = {
                ["y"] = -363.87891908174;
                ["x"] = 426.15899812353;
                ["sublevel"] = 1;
                ["g"] = 38;
                ["week"] = {
                    [1] = true;
                    [10] = true;
                    [4] = true;
                    [7] = true;
                };
            };
            [4] = {
                ["y"] = -266.95943836528;
                ["x"] = 340.37292437476;
                ["sublevel"] = 1;
                ["g"] = 43;
                ["week"] = {
                    [1] = true;
                    [10] = true;
                    [4] = true;
                    [7] = true;
                };
            };
            [5] = {
                ["y"] = -268.78338423016;
                ["x"] = 285.3946546269;
                ["sublevel"] = 1;
                ["g"] = 48;
                ["week"] = {
                    [1] = true;
                    [10] = true;
                    [4] = true;
                    [7] = true;
                };
            };
            [6] = {
                ["y"] = -114.47948170265;
                ["x"] = 342.87463696164;
                ["sublevel"] = 1;
                ["g"] = 92;
                ["week"] = {
                    [1] = true;
                    [10] = true;
                    [4] = true;
                    [7] = true;
                };
            };
            [7] = {
                ["y"] = -135.16608768845;
                ["x"] = 409.46219370416;
                ["sublevel"] = 1;
                ["g"] = 67;
                ["week"] = {
                    [1] = true;
                    [10] = true;
                    [4] = true;
                    [7] = true;
                };
            };
            [8] = {
                ["y"] = -125.83276061525;
                ["x"] = 544.62713215961;
                ["sublevel"] = 1;
                ["g"] = 90;
                ["week"] = {
                    [1] = true;
                    [10] = true;
                    [4] = true;
                    [7] = true;
                };
            };
            [9] = {
                ["y"] = -162.81799280706;
                ["x"] = 588.89663352901;
                ["sublevel"] = 1;
                ["g"] = 93;
                ["week"] = {
                    [1] = true;
                    [10] = true;
                    [7] = true;
                    [4] = true;
                };
            };
            [10] = {
                ["y"] = -103.0860152079;
                ["x"] = 585.78837576708;
                ["week"] = {
                    [8] = true;
                    [2] = true;
                    [11] = true;
                    [5] = true;
                };
                ["g"] = 94;
                ["sublevel"] = 1;
            };
            [11] = {
                ["y"] = -100.26557329067;
                ["x"] = 359.03215169639;
                ["week"] = {
                    [8] = true;
                    [2] = true;
                    [11] = true;
                    [5] = true;
                };
                ["g"] = 95;
                ["sublevel"] = 1;
            };
            [12] = {
                ["y"] = -349.57359956652;
                ["x"] = 477.31823708605;
                ["week"] = {
                    [8] = true;
                    [2] = true;
                    [11] = true;
                    [5] = true;
                };
                ["g"] = 21;
                ["sublevel"] = 1;
            };
            [13] = {
                ["sublevel"] = 1;
                ["x"] = 464.95951532226;
                ["week"] = {
                    [1] = true;
                    [10] = true;
                    [7] = true;
                    [4] = true;
                };
                ["g"] = 20;
                ["y"] = -341.91596055426;
            };
            [14] = {
                ["sublevel"] = 1;
                ["x"] = 378.8967094098;
                ["week"] = {
                    [1] = true;
                    [10] = true;
                    [4] = true;
                    [7] = true;
                };
                ["g"] = 73;
                ["y"] = -153.39285998377;
            };
            [15] = {
                ["y"] = -254.28940042562;
                ["x"] = 274.49933422896;
                ["week"] = {
                    [5] = true;
                    [2] = true;
                    [11] = true;
                    [8] = true;
                };
                ["g"] = 50;
                ["sublevel"] = 1;
            };
            [16] = {
                ["y"] = -352.43446184518;
                ["x"] = 431.73341636712;
                ["sublevel"] = 1;
                ["g"] = 39;
                ["week"] = {
                    [3] = true;
                    [6] = true;
                    [9] = true;
                    [12] = true;
                };
            };
            [17] = {
                ["y"] = -260.3324319918;
                ["x"] = 337.40221851439;
                ["sublevel"] = 1;
                ["g"] = 43;
                ["week"] = {
                    [3] = true;
                    [6] = true;
                    [9] = true;
                    [12] = true;
                };
            };
            [18] = {
                ["y"] = -162.57133418459;
                ["x"] = 376.37514870388;
                ["week"] = {
                    [3] = true;
                    [6] = true;
                    [9] = true;
                    [12] = true;
                };
                ["g"] = 72;
                ["sublevel"] = 1;
            };
            [19] = {
                ["y"] = -96.844939882672;
                ["x"] = 541.97137453729;
                ["week"] = {
                    [3] = true;
                    [6] = true;
                    [9] = true;
                    [12] = true;
                };
                ["sublevel"] = 1;
            };
        };
        ["characteristics"] = {
            ["Taunt"] = true;
        };
        ["scale"] = 1;
        ["spells"] = {
            [302419] = {};
            [302420] = {};
            [302421] = {};
            [302415] = {};
        };
        ["stealthDetect"] = true;
        ["health"] = 999042;
        ["count"] = 4;
        ["ignoreFortified"] = true;
        ["name"] = L["Void-Touched Emissary"];
        ["displayId"] = 39391;
        ["creatureType"] = L["Humanoid"];
        ["level"] = 122;
        ["id"] = 155433;
        ["iconTexture"] = 132886;
    };
    [40] = {
        ["clones"] = {
            [1] = {
                ["y"] = -419.30592443047;
                ["x"] = 469.14798360903;
                ["sublevel"] = 1;
                ["g"] = 3;
                ["week"] = {
                    [1] = true;
                    [10] = true;
                    [4] = true;
                    [7] = true;
                };
            };
            [2] = {
                ["y"] = -351.07890343192;
                ["x"] = 431.5590084809;
                ["sublevel"] = 1;
                ["g"] = 39;
                ["week"] = {
                    [1] = true;
                    [10] = true;
                    [4] = true;
                    [7] = true;
                };
            };
            [3] = {
                ["y"] = -245.89392958249;
                ["x"] = 298.05149006111;
                ["sublevel"] = 1;
                ["g"] = 53;
                ["week"] = {
                    [1] = true;
                    [10] = true;
                    [4] = true;
                    [7] = true;
                };
            };
            [4] = {
                ["y"] = -121.55414072741;
                ["x"] = 499.69142826978;
                ["sublevel"] = 1;
                ["g"] = 80;
                ["week"] = {
                    [1] = true;
                    [10] = true;
                    [4] = true;
                    [7] = true;
                };
            };
            [5] = {
                ["y"] = -437.56568167695;
                ["x"] = 447.83297820449;
                ["week"] = {
                    [8] = true;
                    [2] = true;
                    [11] = true;
                    [5] = true;
                };
                ["g"] = 1;
                ["sublevel"] = 1;
            };
            [6] = {
                ["y"] = -407.62643133508;
                ["x"] = 469.62866891268;
                ["week"] = {
                    [8] = true;
                    [2] = true;
                    [11] = true;
                    [5] = true;
                };
                ["g"] = 5;
                ["sublevel"] = 1;
            };
            [7] = {
                ["y"] = -359.82352427916;
                ["x"] = 453.9016579131;
                ["week"] = {
                    [8] = true;
                    [2] = true;
                    [11] = true;
                    [5] = true;
                };
                ["g"] = 19;
                ["sublevel"] = 1;
            };
            [8] = {
                ["y"] = -110.81662886629;
                ["x"] = 506.47985181098;
                ["week"] = {
                    [8] = true;
                    [2] = true;
                    [11] = true;
                    [5] = true;
                };
                ["g"] = 79;
                ["sublevel"] = 1;
            };
            [9] = {
                ["y"] = -153.52189320554;
                ["x"] = 607.94207884334;
                ["week"] = {
                    [8] = true;
                    [2] = true;
                    [11] = true;
                    [5] = true;
                };
                ["g"] = 85;
                ["sublevel"] = 1;
            };
            [10] = {
                ["y"] = -127.79127934087;
                ["x"] = 364.42964460697;
                ["week"] = {
                    [8] = true;
                    [2] = true;
                    [11] = true;
                    [5] = true;
                };
                ["teeming"] = true;
                ["g"] = 75;
                ["sublevel"] = 1;
            };
            [11] = {
                ["y"] = -170.95800220248;
                ["x"] = 385.14777414932;
                ["week"] = {
                    [11] = true;
                    [2] = true;
                    [5] = true;
                    [8] = true;
                };
                ["g"] = 71;
                ["sublevel"] = 1;
            };
            [12] = {
                ["y"] = -114.59273809432;
                ["x"] = 597.98123807581;
                ["week"] = {
                    [1] = true;
                    [10] = true;
                    [7] = true;
                    [4] = true;
                };
                ["sublevel"] = 1;
            };
            [13] = {
                ["y"] = -330.82405856665;
                ["x"] = 433.96087064676;
                ["week"] = {
                    [5] = true;
                    [2] = true;
                    [11] = true;
                    [8] = true;
                };
                ["g"] = 32;
                ["sublevel"] = 1;
            };
            [14] = {
                ["y"] = -249.18742899505;
                ["x"] = 332.44024483023;
                ["week"] = {
                    [5] = true;
                    [2] = true;
                    [11] = true;
                    [8] = true;
                };
                ["g"] = 42;
                ["sublevel"] = 1;
            };
            [15] = {
                ["y"] = -273.55010288998;
                ["x"] = 320.10730662658;
                ["week"] = {
                    [5] = true;
                    [2] = true;
                    [11] = true;
                    [8] = true;
                };
                ["g"] = 45;
                ["sublevel"] = 1;
            };
            [16] = {
                ["y"] = -186.24588916952;
                ["x"] = 249.48524098056;
                ["week"] = {
                    [5] = true;
                    [2] = true;
                    [11] = true;
                    [8] = true;
                };
                ["g"] = 78;
                ["sublevel"] = 1;
            };
            [17] = {
                ["y"] = -369.02799891071;
                ["x"] = 463.26480745136;
                ["sublevel"] = 1;
                ["g"] = 40;
                ["week"] = {
                    [3] = true;
                    [6] = true;
                    [9] = true;
                    [12] = true;
                };
            };
            [18] = {
                ["y"] = -308.06065992015;
                ["x"] = 431.91078906381;
                ["sublevel"] = 1;
                ["g"] = 29;
                ["week"] = {
                    [3] = true;
                    [6] = true;
                    [9] = true;
                    [12] = true;
                };
            };
            [19] = {
                ["y"] = -253.30203325208;
                ["x"] = 274.72576208774;
                ["sublevel"] = 1;
                ["g"] = 50;
                ["week"] = {
                    [3] = true;
                    [6] = true;
                    [9] = true;
                    [12] = true;
                };
            };
            [20] = {
                ["y"] = -152.77823995884;
                ["x"] = 354.47799476409;
                ["week"] = {
                    [3] = true;
                    [6] = true;
                    [9] = true;
                    [12] = true;
                };
                ["g"] = 74;
                ["sublevel"] = 1;
            };
            [21] = {
                ["y"] = -138.62871651868;
                ["x"] = 407.97341110856;
                ["week"] = {
                    [3] = true;
                    [6] = true;
                    [9] = true;
                    [12] = true;
                };
                ["g"] = 67;
                ["sublevel"] = 1;
            };
        };
        ["scale"] = 1;
        ["spells"] = {
            [302417] = {};
            [302418] = {};
            [302415] = {};
        };
        ["characteristics"] = {
            ["Taunt"] = true;
        };
        ["health"] = 614795;
        ["count"] = 4;
        ["ignoreFortified"] = true;
        ["name"] = L["Emissary of the Tides"];
        ["displayId"] = 39391;
        ["creatureType"] = L["Humanoid"];
        ["level"] = 120;
        ["id"] = 155434;
        ["iconTexture"] = 132315;
    };
    [41] = {
        ["clones"] = {
            [1] = {
                ["y"] = -404.34503491716;
                ["x"] = 435.73194131414;
                ["sublevel"] = 1;
                ["g"] = 9;
                ["week"] = {
                    [1] = true;
                    [10] = true;
                    [4] = true;
                    [7] = true;
                };
            };
            [2] = {
                ["y"] = -310.7057581121;
                ["x"] = 403.85253384018;
                ["sublevel"] = 1;
                ["g"] = 31;
                ["week"] = {
                    [1] = true;
                    [10] = true;
                    [4] = true;
                    [7] = true;
                };
            };
            [3] = {
                ["y"] = -210.19103640257;
                ["x"] = 264.93665383449;
                ["sublevel"] = 1;
                ["g"] = 91;
                ["week"] = {
                    [1] = true;
                    [10] = true;
                    [4] = true;
                    [7] = true;
                };
            };
            [4] = {
                ["y"] = -93.444632456317;
                ["x"] = 378.27765216552;
                ["sublevel"] = 1;
                ["g"] = 64;
                ["week"] = {
                    [1] = true;
                    [10] = true;
                    [4] = true;
                    [7] = true;
                };
            };
            [5] = {
                ["y"] = -379.80077330232;
                ["x"] = 439.48496071633;
                ["week"] = {
                    [8] = true;
                    [2] = true;
                    [11] = true;
                    [5] = true;
                };
                ["g"] = 7;
                ["sublevel"] = 1;
            };
            [6] = {
                ["y"] = -360.73261878147;
                ["x"] = 434.12891344728;
                ["week"] = {
                    [8] = true;
                    [2] = true;
                    [11] = true;
                    [5] = true;
                };
                ["g"] = 38;
                ["sublevel"] = 1;
            };
            [7] = {
                ["y"] = -106.17705559142;
                ["x"] = 397.02356652965;
                ["week"] = {
                    [8] = true;
                    [2] = true;
                    [11] = true;
                    [5] = true;
                };
                ["teeming"] = true;
                ["g"] = 65;
                ["sublevel"] = 1;
            };
            [8] = {
                ["sublevel"] = 1;
                ["x"] = 463.52692933041;
                ["week"] = {
                    [1] = true;
                    [10] = true;
                    [7] = true;
                    [4] = true;
                };
                ["g"] = 26;
                ["y"] = -312.68355585776;
            };
            [9] = {
                ["y"] = -318.43235726429;
                ["x"] = 478.52602749201;
                ["week"] = {
                    [5] = true;
                    [2] = true;
                    [11] = true;
                    [8] = true;
                };
                ["g"] = 24;
                ["sublevel"] = 1;
            };
            [10] = {
                ["y"] = -279.50658618918;
                ["x"] = 276.06405373428;
                ["week"] = {
                    [5] = true;
                    [2] = true;
                    [11] = true;
                    [8] = true;
                };
                ["g"] = 49;
                ["sublevel"] = 1;
            };
            [11] = {
                ["y"] = -438.0482033974;
                ["x"] = 445.09921578365;
                ["sublevel"] = 1;
                ["g"] = 1;
                ["week"] = {
                    [3] = true;
                    [6] = true;
                    [9] = true;
                    [12] = true;
                };
            };
            [12] = {
                ["y"] = -406.78164734194;
                ["x"] = 471.56644600259;
                ["sublevel"] = 1;
                ["g"] = 5;
                ["week"] = {
                    [3] = true;
                    [6] = true;
                    [9] = true;
                    [12] = true;
                };
            };
            [13] = {
                ["y"] = -349.6539686079;
                ["x"] = 477.47363930839;
                ["sublevel"] = 1;
                ["g"] = 21;
                ["week"] = {
                    [3] = true;
                    [6] = true;
                    [9] = true;
                    [12] = true;
                };
            };
            [14] = {
                ["y"] = -339.69608421782;
                ["x"] = 411.42107596531;
                ["sublevel"] = 1;
                ["g"] = 34;
                ["week"] = {
                    [3] = true;
                    [6] = true;
                    [9] = true;
                    [12] = true;
                };
            };
            [15] = {
                ["y"] = -299.48768494855;
                ["x"] = 410.69221255131;
                ["sublevel"] = 1;
                ["g"] = 30;
                ["week"] = {
                    [3] = true;
                    [6] = true;
                    [9] = true;
                    [12] = true;
                };
            };
            [16] = {
                ["y"] = -246.33302758865;
                ["x"] = 308.84023601405;
                ["sublevel"] = 1;
                ["g"] = 53;
                ["week"] = {
                    [3] = true;
                    [6] = true;
                    [9] = true;
                    [12] = true;
                };
            };
            [17] = {
                ["y"] = -112.10252312857;
                ["x"] = 348.41874873088;
                ["week"] = {
                    [3] = true;
                    [6] = true;
                    [9] = true;
                    [12] = true;
                };
                ["g"] = 61;
                ["sublevel"] = 1;
            };
            [18] = {
                ["y"] = -162.23822292246;
                ["x"] = 392.30650249191;
                ["week"] = {
                    [3] = true;
                    [6] = true;
                    [9] = true;
                    [12] = true;
                };
                ["g"] = 71;
                ["sublevel"] = 1;
            };
            [19] = {
                ["y"] = -121.36477656806;
                ["x"] = 499.7902426258;
                ["week"] = {
                    [3] = true;
                    [6] = true;
                    [9] = true;
                    [12] = true;
                };
                ["g"] = 80;
                ["sublevel"] = 1;
            };
            [20] = {
                ["y"] = -157.63992794576;
                ["x"] = 562.65964352978;
                ["week"] = {
                    [3] = true;
                    [6] = true;
                    [9] = true;
                    [12] = true;
                };
                ["sublevel"] = 1;
            };
        };
        ["scale"] = 1;
        ["spells"] = {
            [303632] = {};
            [302415] = {};
            [290027] = {};
        };
        ["characteristics"] = {
            ["Taunt"] = true;
        };
        ["health"] = 15369884;
        ["count"] = 0;
        ["ignoreFortified"] = true;
        ["name"] = L["Enchanted Emissary"];
        ["displayId"] = 39391;
        ["creatureType"] = L["Humanoid"];
        ["level"] = 121;
        ["id"] = 155432;
        ["iconTexture"] = 135735;
    };
    [42] = {
        ["clones"] = {
            [1] = {
                ["y"] = -107.06310141478;
                ["x"] = 535.23214910256;
                ["week"] = {
                    [1] = true;
                    [2] = true;
                    [3] = true;
                    [4] = true;
                    [5] = true;
                    [6] = true;
                    [7] = true;
                    [8] = true;
                    [9] = true;
                    [10] = true;
                    [11] = true;
                    [12] = true;
                };
                ["sublevel"] = 1;
            };
        };
        ["id"] = 161243;
        ["scale"] = 1.4;
        ["spells"] = {
            [314531] = {};
            [314483] = {};
            [314397] = {};
            [314477] = {};
        };
        ["stealthDetect"] = true;
        ["name"] = L["Samh'rek, Beckoner of Chaos"];
        ["corrupted"] = true;
        ["teemingCount"] = 6;
        ["count"] = 4;
        ["displayId"] = 90742;
        ["creatureType"] = L["Aberration"];
        ["level"] = 122;
        ["health"] = 2151786;
        ["characteristics"] = {
            ["Taunt"] = true;
        };
    };
    [43] = {
        ["clones"] = {
            [1] = {
                ["y"] = -415.51082329646;
                ["x"] = 449.93614630826;
                ["week"] = {
                    [1] = true;
                    [2] = true;
                    [3] = true;
                    [4] = true;
                    [5] = true;
                    [6] = true;
                    [7] = true;
                    [8] = true;
                    [9] = true;
                    [10] = true;
                    [11] = true;
                    [12] = true;
                };
                ["sublevel"] = 1;
            };
        };
        ["name"] = L["Urg'roth, Breaker of Heroes"];
        ["characteristics"] = {
            ["Taunt"] = true;
        };
        ["spells"] = {
            [314308] = {};
            [314387] = {};
            [314397] = {};
            [314309] = {};
        };
        ["stealthDetect"] = true;
        ["health"] = 2151786;
        ["level"] = 122;
        ["teemingCount"] = 6;
        ["count"] = 4;
        ["displayId"] = 89415;
        ["creatureType"] = L["Aberration"];
        ["corrupted"] = true;
        ["scale"] = 1.4;
        ["id"] = 161124;
    };
    [44] = {
        ["clones"] = {
            [1] = {
                ["y"] = -272.74135778189;
                ["x"] = 304.66635013543;
                ["week"] = {
                    [1] = true;
                    [2] = true;
                    [5] = true;
                    [6] = true;
                    [9] = true;
                    [10] = true;
                };
                ["sublevel"] = 1;
            };
            [2] = {
                ["y"] = -116.82429592987;
                ["x"] = 332.56610354198;
                ["week"] = {
                    [11] = true;
                    [7] = true;
                    [8] = true;
                    [3] = true;
                    [12] = true;
                    [4] = true;
                };
                ["sublevel"] = 1;
            };
        };
        ["characteristics"] = {
            ["Taunt"] = true;
        };
        ["scale"] = 1.4;
        ["spells"] = {
            [314463] = {};
            [314397] = {};
            [314411] = {};
            [314406] = {};
            [314467] = {};
        };
        ["stealthDetect"] = true;
        ["id"] = 161241;
        ["level"] = 122;
        ["teemingCount"] = 6;
        ["name"] = L["Voidweaver Mal'thir"];
        ["displayId"] = 91910;
        ["creatureType"] = L["Beast"];
        ["corrupted"] = true;
        ["health"] = 2151786;
        ["count"] = 4;
    };
    [45] = {
        ["clones"] = {
            [1] = {
                ["y"] = -117.72186664014;
                ["x"] = 333.4636831689;
                ["week"] = {
                    [1] = true;
                    [2] = true;
                    [5] = true;
                    [6] = true;
                    [9] = true;
                    [10] = true;
                };
                ["sublevel"] = 1;
            };
            [2] = {
                ["y"] = -274.79831668879;
                ["x"] = 302.64676659448;
                ["week"] = {
                    [11] = true;
                    [7] = true;
                    [8] = true;
                    [3] = true;
                    [12] = true;
                    [4] = true;
                };
                ["sublevel"] = 1;
            };
        };
        ["health"] = 2151786;
        ["characteristics"] = {
            ["Taunt"] = true;
        };
        ["spells"] = {
            [314566] = {};
            [314592] = {};
            [314397] = {};
            [314565] = {};
        };
        ["stealthDetect"] = true;
        ["count"] = 4;
        ["corrupted"] = true;
        ["teemingCount"] = 6;
        ["name"] = L["Blood of the Corruptor"];
        ["displayId"] = 92229;
        ["creatureType"] = L["Aberration"];
        ["level"] = 122;
        ["scale"] = 1.4;
        ["id"] = 161244;
    };
};
