local E, L, C = select(2, ...):unpack()

E.highlightLT = {}

E.spellList = {
	["DEATHKNIGHT"] = {
		{ spellID = 47482,  duration = 30,  type = "interrupt", spec = { 252 } },
		{ spellID = 47528,  duration = 15,  type = "interrupt"               },
		{ spellID = 108194, duration = 45,  type = "cc",        spec = true  },
		{ spellID = 221562, duration = 45,  type = "cc",        spec = { 250 } },
		{ spellID = 207167, duration = 60,  type = "cc",        spec = true  },
		{ spellID = 49576,  duration = { default = 25, [250] = 15 }, type = "cc" },
		{ spellID = 108199, duration = 120, type = "cc",        spec = { 250 } },
		{ spellID = 47481,  duration = 90,  type = "cc",        spec = { 252 } },
		{ spellID = 287250, duration = 45,  type = "cc",        spec = true, parent = 196770 },
		{ spellID = 47476,  duration = 60,  type = "cc",        spec = true  },
		{ spellID = 48707,  duration = 60,  type = "defensive", default = true },
		{ spellID = 51052,  duration = 120, type = "defensive", spec = true, default = true },
		{ spellID = 194844, duration = 60,  type = "defensive", spec = true  },
		{ spellID = 274156, duration = 45,  type = "defensive", spec = true  },
		{ spellID = 49028,  duration = 120, type = "defensive", spec = { 250 } },
		{ spellID = 48743,  duration = 120, type = "defensive", spec = true  },
		{ spellID = 48792,  duration = 180, type = "defensive", default = true },
		{ spellID = 287081, duration = 60,  type = "defensive", spec = true, default = true, parent = 48792 },
		{ spellID = 114556, duration = 240, type = "defensive", spec = true  },
		{ spellID = 219809, duration = 60,  type = "defensive", spec = true  },
		{ spellID = 55233,  duration = 90,  type = "defensive", spec = { 250 } },
		{ spellID = 275699, duration = 90,  type = "offensive", spec = { 252 } },
		{ spellID = 42650,  duration = 480, type = "offensive", spec = { 252 } },
		{ spellID = 288853, duration = 90,  type = "offensive", spec = true, parent = 42650 },
		{ spellID = 152279, duration = 120, type = "offensive", spec = true  },
		{ spellID = 63560,  duration = 60,  type = "offensive", spec = { 252 } },
		{ spellID = 47568,  duration = 120, type = "offensive", spec = { 251 } },
		{ spellID = 279302, duration = 180, type = "offensive", spec = true  },
		{ spellID = 51271,  duration = 45,  type = "offensive", spec = { 251 } },
		{ spellID = 130736, duration = 45,  type = "offensive", spec = true  },
		{ spellID = 49206,  duration = 180, type = "offensive", spec = true  },
		{ spellID = 207289, duration = 75,  type = "offensive", spec = true  },
		{ spellID = 77606,  duration = 20,  type = "others",    spec = true  },
		{ spellID = 48265,  duration = 45,  type = "others"                  },
		{ spellID = 196770, duration = 20,  type = "others",    spec = { 251 } },
		{ spellID = 212552, duration = 60,  type = "others",    spec = true  },
	},
	["DEMONHUNTER"] = {
		{ spellID = 183752, duration = 15,  type = "interrupt" },
		{ spellID = 179057, duration = 60,  type = "cc",        spec = { 577 } },
		{ spellID = 211881, duration = 30,  type = "cc",        spec = true  },
		{ spellID = 205630, duration = 60,  type = "cc",        spec = true  },
		{ spellID = 217832, duration = 45,  type = "cc"                      },
		{ spellID = 205596, duration = 60,  type = "cc",        spec = true, parent = 217832 },
		{ spellID = 202138, duration = 90,  type = "cc",        spec = true  },
		{ spellID = 207684, duration = 90,  type = "cc",        spec = { 581 } },
		{ spellID = 202137, duration = 60,  type = "cc",        spec = { 581 } },
		{ spellID = 196555, duration = 120, type = "immunity",  spec = true, default = true },
		{ spellID = 198589, duration = 60,  type = "defensive", spec = { 577 }, default = true },
		{ spellID = 196718, duration = 180, type = "defensive", spec = { 577 } },
		{ spellID = 227635, duration = 180, type = "defensive", spec = true, parent = 196718, default = true },
		{ spellID = 204021, duration = 60,  type = "defensive", spec = { 581 } },
		{ spellID = 209258, duration = 480, type = "defensive", spec = true  },
		{ spellID = 206803, duration = 60,  type = "defensive", spec = true  },
		{ spellID = 206649, duration = 45,  type = "offensive", spec = true  },
		{ spellID = 258925, duration = 60,  type = "offensive", spec = true  },
		{ spellID = 203704, duration = 60,  type = "offensive", spec = true  },
		{ spellID = 200166, duration = 240, type = "offensive", spec = { 577 } },
		{ spellID = 187827, duration = 180, type = "defensive", spec = { 581 } },
		{ spellID = 206491, duration = 120, type = "offensive", spec = true  },
		{ spellID = 205629, duration = 20,  type = "others",    spec = true, charges = 2 },
		{ spellID = 205604, duration = 60,  type = "others",    spec = true, default = true },
	},
	["DRUID"] = {
		{ spellID = 106839, duration = 15,  type = "interrupt", spec = { 103, 104 } },
		{ spellID = 78675,  duration = 60,  type = "interrupt", spec = { 102 }, default = true },
		{ spellID = 88423,  duration = 8,   type = "interrupt", spec = { 105 } },
		{ spellID = 99,     duration = 30,  type = "cc",        spec = { 104 } },
		{ spellID = 102359, duration = 30,  type = "cc",        spec = true  },
		{ spellID = 5211,   duration = 50,  type = "cc",        spec = true  },
		{ spellID = 202246, duration = 25,  type = "cc",        spec = true  },
		{ spellID = 132469, duration = 30,  type = "cc",        spec = true  },
		{ spellID = 102793, duration = 60,  type = "cc",        spec = { 105, true } },
		{ spellID = 22812,  duration = { default = 60, [104] = 90 }, type = "defensive", spec = { 102, 104, 105 }, default = true },
		{ spellID = 201664, duration = 30,  type = "defensive", spec = true  },
		{ spellID = 209749, duration = 30,  type = "defensive", spec = true  },
		{ spellID = 197491, duration = 30,  type = "defensive", spec = true  },
		{ spellID = 217615, duration = 30,  type = "defensive", spec = true  },
		{ spellID = 22842,  duration = 30,  type = "defensive", spec = { 104 }, charges = 2 },
		{ spellID = 102342, duration = 60,  type = "defensive", spec = { 105 }, default = true },
		{ spellID = 108238, duration = 90,  type = "defensive", spec = true, default = true },
		{ spellID = 61336,  duration = { default = 120, [104] = 240 }, type = "defensive", spec = { 103, 104 }, charges = 2, default = true },
		{ spellID = 305497, duration = 45,  type = "defensive", spec = true  },
		{ spellID = 106951, duration = 180, type = "offensive", spec = { 103 } },
		{ spellID = 194223, duration = 180, type = "offensive", spec = { 102 } },
		{ spellID = 202770, duration = 60,  type = "offensive", spec = true  },
		{ spellID = 102560, duration = 180, type = "offensive", spec = true, parent = 194223 },
		{ spellID = 102558, duration = 180, type = "offensive", spec = true  },
		{ spellID = 102543, duration = 180, type = "offensive", spec = true, parent = 106951 },
		{ spellID = 33891,  duration = 180, type = "offensive", spec = true, default = true },
		{ spellID = 203651, duration = 45,  type = "offensive", spec = true  },
		{ spellID = 5217,   duration = 30,  type = "offensive", spec = { 103 } },
		{ spellID = 740,    duration = 180, type = "offensive", spec = { 105 } },
		{ spellID = 202425, duration = 45,  type = "offensive", spec = true  },
		{ spellID = 1850,   duration = 120, type = "others"                  },
		{ spellID = 252216, duration = 45,  type = "others",    spec = true, parent = 1850 },
		{ spellID = 205636, duration = 60,  type = "others",    spec = true  },
		{ spellID = 29166,  duration = 180, type = "others",    spec = { 102, 105 } },
		{ spellID = 77761,  duration = { default = 120, [104] = 60 }, type = "others", spec = { 103, 104 } },
	},
	["HUNTER"] = {
		{ spellID = 147362, duration = 24,  type = "interrupt", spec = { 253, 254 } },
		{ spellID = 187707, duration = 15,  type = "interrupt", spec = { 255 } },
		{ spellID = 109248, duration = 45,  type = "cc",        spec = true  },
		{ spellID = 186387, duration = 30,  type = "cc",        spec = { 254 } },
		{ spellID = 187650, duration = 30,  type = "cc", default = true },
		{ spellID = 203340, duration = 30,  type = "cc", default = true, spec = true, parent = 187650 },
		{ spellID = 236776, duration = 40,  type = "cc",        spec = true  },
		{ spellID = 19577,  duration = 60,  type = "cc",        spec = { 253, 255 } },
		{ spellID = 213691, duration = 30,  type = "cc",        spec = true  },
		{ spellID = 202914, duration = 45,  type = "cc",        spec = true  },
		{ spellID = 186265, duration = 180, type = "immunity", default = true },
		{ spellID = 109304, duration = 120, type = "defensive", default = true },
		{ spellID = 248518, duration = 45,  type = "defensive", spec = true, parent = 34477 },
		{ spellID = 212640, duration = 25,  type = "defensive", spec = true  },
		{ spellID = 53480,  duration = 60,  type = "defensive", spec = true  },
		{ spellID = 131894, duration = 60,  type = "offensive", spec = true  },
		{ spellID = 186289, duration = 90,  type = "offensive", spec = { 255 } },
		{ spellID = 193530, duration = 120, type = "offensive", spec = { 253 } },
		{ spellID = 19574,  duration = 90,  type = "offensive", spec = { 253 } },
		{ spellID = 266779, duration = 120, type = "offensive", spec = { 255 } },
		{ spellID = 205691, duration = 120, type = "offensive", spec = true  },
		{ spellID = 260402, duration = 60,  type = "offensive", spec = true  },
		{ spellID = 194407, duration = 90,  type = "offensive", spec = true  },
		{ spellID = 288613, duration = 120, type = "offensive", spec = { 254 } },
		{ spellID = 186257, duration = 180, type = "others"                  },
		{ spellID = 199483, duration = 60,  type = "others",    spec = true  },
		{ spellID = 272651, duration = 45,  type = "others"                  },
		{ spellID = 34477,  duration = 30,  type = "others",    spec = {253, 254} },
	},
	["MAGE"] = {
		{ spellID = 2139,   duration = 24,  type = "interrupt"              },
		{ spellID = 31661,  duration = 20,  type = "cc",        spec = { 63 } },
		{ spellID = 113724, duration = 45,  type = "cc",        spec = true },
		{ spellID = 45438,  duration = 240, type = "immunity", default = true },
		{ spellID = 86949,  duration = 300, type = "defensive", spec = { 63 } },
		{ spellID = 235219, duration = 300, type = "defensive", spec = { 64 }, default = true },
		{ spellID = 110960, duration = 120, type = "defensive", spec = { 62 } },
		{ spellID = 198158, duration = 60,  type = "defensive", spec = true },
		{ spellID = 198111, duration = 45,  type = "defensive", spec = true, default = true },
		{ spellID = 153626, duration = 20,  type = "offensive", spec = true },
		{ spellID = 12042,  duration = 90,  type = "offensive", spec = { 62 } },
		{ spellID = 205032, duration = 40,  type = "offensive", spec = true },
		{ spellID = 190319, duration = 120, type = "offensive", spec = { 63 } },
		{ spellID = 153595, duration = 30,  type = "offensive", spec = true },
		{ spellID = 257537, duration = 45,  type = "offensive", spec = true },
		{ spellID = 84714,  duration = 60,  type = "offensive", spec = { 64 } },
		{ spellID = 12472,  duration = 180, type = "offensive", spec = { 64 } },
		{ spellID = 198144, duration = 60,  type = "offensive", spec = true, parent = 12472 },
		{ spellID = 153561, duration = 45,  type = "offensive", spec = true },
		{ spellID = 55342,  duration = 120, type = "offensive", spec = true },
		{ spellID = 205025, duration = 60,  type = "offensive", spec = { 62 } },
		{ spellID = 205021, duration = 75,  type = "offensive", spec = true },
		{ spellID = 116011, duration = 40,  type = "offensive", spec = true, charges = 2 },
		{ spellID = 80353,  duration = 300, type = "offensive", pve = true },
		{ spellID = 1953,   duration = 15,  type = "others"                 },
		{ spellID = 212653, duration = 20,  type = "others",    spec = true, charges = 2, parent = 1953 },
		{ spellID = 33395,  duration = 25,  type = "others",    spec = { 64 } },
		{ spellID = 122,    duration = 30,  type = "others"                 },
		{ spellID = 108839, duration = 20,  type = "others",    spec = true, charges = 3 },
		{ spellID = 198100, duration = 30,  type = "others",    spec = true },
		{ spellID = 205024, duration = 0,   type = "others",    spec = true, parent = 33395, hide = true },
	},
	["MONK"] = {
		{ spellID = 116705, duration = 15,  type = "interrupt", spec = { 268, 269 } },
		{ spellID = 115450, duration = 8,   type = "interrupt", spec = { 270 } },
		{ spellID = 202335, duration = 45,  type = "cc",        spec = true  },
		{ spellID = 119381, duration = 60,  type = "cc"                      },
		{ spellID = 202370, duration = 30,  type = "cc",        spec = true  },
		{ spellID = 115078, duration = 45,  type = "cc"                      },
		{ spellID = 116844, duration = 45,  type = "cc",        spec = true  },
		{ spellID = 198898, duration = 30,  type = "cc",        spec = true  },
		{ spellID = 116849, duration = 120, type = "immunity",  spec = { 270 }, default = true },
		{ spellID = 122470, duration = 90,  type = "immunity",  spec = { 269 }, default = true },
		{ spellID = 202162, duration = 45,  type = "defensive", spec = true  },
		{ spellID = 115399, duration = 120, type = "defensive", spec = true  },
		{ spellID = 122278, duration = 120, type = "defensive", spec = true  },
		{ spellID = 122783, duration = 90,  type = "defensive", spec = true, default = true },
		{ spellID = 115203, duration = 420, type = "defensive", spec = { 268 } },
		{ spellID = 243435, duration = 90,  type = "defensive", spec = { 270 } },
		{ spellID = 201318, duration = 90,  type = "defensive", spec = true  },
		{ spellID = 233759, duration = 45,  type = "defensive", spec = true  },
		{ spellID = 132578, duration = 180, type = "defensive", spec = true  },
		{ spellID = 119996, duration = 45,  type = "defensive"               },
		{ spellID = 115176, duration = 300, type = "defensive", spec = { 268 } },
		{ spellID = 123904, duration = 120, type = "offensive", spec = true  },
		{ spellID = 198664, duration = 180, type = "offensive", spec = true  },
		{ spellID = 115310, duration = 180, type = "offensive", spec = { 270 } },
		{ spellID = 137639, duration = 90,  type = "offensive", spec = { 269 }, charges = 2 },
		{ spellID = 152173, duration = 90,  type = "offensive", spec = true, parent = 137639 },
		{ spellID = 115080, duration = 120, type = "offensive", spec = { 269 } },
		{ spellID = 216113, duration = 60,  type = "offensive", spec = true, default = true },
		{ spellID = 101545, duration = 25,  type = "others",    spec = { 269 } },
		{ spellID = 109132, duration = 20,  type = "others", charges = 2 },
		{ spellID = 115008, duration = 20,  type = "others",    spec = true, charges = 2, parent = 109132 },
		{ spellID = 116841, duration = 30,  type = "others",    spec = true  },
		{ spellID = 209584, duration = 45,  type = "others",    spec = true  },
	},
	["PALADIN"] = {
		{ spellID = 96231,  duration = 15,  type = "interrupt", spec = { 66, 70 } },
		{ spellID = 215652, duration = 45,  type = "interrupt", spec = true },
		{ spellID = 4987,   duration = 8,   type = "interrupt", spec = { 65 } },
		{ spellID = 115750, duration = 90,  type = "cc",        spec = true },
		{ spellID = 853,    duration = 60,  type = "cc"                     },
		{ spellID = 20066,  duration = 15,  type = "cc",         spec = true },
		{ spellID = 642,    duration = 300, type = "immunity", default = true },
		{ spellID = 204150, duration = 180, type = "defensive", spec = true },
		{ spellID = 31850,  duration = 85,  type = "defensive", spec = { 66 } },
		{ spellID = 31821,  duration = 180, type = "defensive", spec = { 65 } },
		{ spellID = 1022,   duration = 300, type = "defensive"              },
		{ spellID = 204018, duration = 180, type = "defensive", spec = true, parent = 1022 },
		{ spellID = 6940,   duration = 120, type = "defensive", spec = { 65, 66 } },
		{ spellID = 199452, duration = 120, type = "immunity",  spec = true, default = true, parent = 6940 },
		{ spellID = 498,    duration = 60,  type = "defensive", spec = { 65 } },
		{ spellID = 205191, duration = 60,  type = "defensive", spec = true },
		{ spellID = 86659,  duration = 300, type = "defensive", spec = { 66 } },
		{ spellID = 228049, duration = 180, type = "immunity",  spec = true, parent = 86659 },
		{ spellID = 184662, duration = 120, type = "defensive", spec = { 70 } },
		{ spellID = 31884,  duration = 120, type = "offensive"              },
		{ spellID = 216331, duration = 120, type = "offensive", spec = true, parent = 31884 },
		{ spellID = 231895, duration = 120, type = "offensive", spec = true, parent = 31884 },
		{ spellID = 105809, duration = 90,  type = "offensive", spec = true },
		{ spellID = 255937, duration = 45,  type = "offensive", spec = true },
		{ spellID = 1044,   duration = 25,  type = "others"                 },
		{ spellID = 210256, duration = 45,  type = "others",    spec = true, default = true },
		{ spellID = 210294, duration = 25,  type = "others",    spec = true },
		{ spellID = 190784, duration = 45,  type = "others"                 },
	},
	["PRIEST"] = {
		{ spellID = 527,    duration = 8,   type = "interrupt", spec = { 256, 257 } },
		{ spellID = 88625,  duration = 60,  type = "cc",        spec = { 257 } },
		{ spellID = 64044,  duration = 45,  type = "cc",        spec = true  },
		{ spellID = 8122,   duration = 60,  type = "cc", default = true },
		{ spellID = 205369, duration = 30,  type = "cc",        spec = true, parent = 8122 },
		{ spellID = 204263, duration = 45,  type = "cc",        spec = true  },
		{ spellID = 15487,  duration = 45,  type = "cc",        spec = { 258 } },
		{ spellID = 213602, duration = 45,  type = "immunity",  spec = true  },
		{ spellID = 197268, duration = 60,  type = "immunity",  spec = true, default = true },
		{ spellID = 47585,  duration = 120, type = "defensive", spec = { 258 }, default = true },
		{ spellID = 47788,  duration = 180, type = "defensive", spec = { 257 }, default = true },
		{ spellID = 33206,  duration = 180, type = "defensive", spec = { 256 }, default = true },
		{ spellID = 62618,  duration = 180, type = "defensive", spec = { 256 } },
		{ spellID = 271466, duration = 180, type = "defensive", spec = true, parent = 62618 },
		{ spellID = 197590, duration = 90,  type = "defensive", spec = true, parent = 62618, parent2 = 271466, default = true },
		{ spellID = 15286,  duration = 120, type = "defensive", spec = { 258 } },
		{ spellID = 108968, duration = 300, type = "defensive", spec = true, default = true },
		{ spellID = 200183, duration = 120, type = "offensive", spec = true  },
		{ spellID = 197862, duration = 60,  type = "offensive", spec = true  },
		{ spellID = 197871, duration = 60,  type = "offensive", spec = true  },
		{ spellID = 280711, duration = 60,  type = "offensive", spec = true  },
		{ spellID = 19236,  duration = 90,  type = "offensive", spec = { 256, 257} },
		{ spellID = 64843,  duration = 180, type = "offensive", spec = { 257 } },
		{ spellID = 265202, duration = 720, type = "offensive", spec = true  },
		{ spellID = 34861,  duration = 60,  type = "offensive", spec = { 257 } },
		{ spellID = 2050,   duration = 60,  type = "offensive", spec = { 257 } },
		{ spellID = 211522, duration = 45,  type = "offensive", spec = true  },
		{ spellID = 47536,  duration = 90,  type = "offensive", spec = { 256 } },
		{ spellID = 215982, duration = 180, type = "offensive", spec = true  },
		{ spellID = 193223, duration = 180, type = "offensive", spec = true  },
		{ spellID = 263165, duration = 45,  type = "offensive", spec = true  },
		{ spellID = 213610, duration = 30,  type = "others",    spec = true  },
		{ spellID = 289657, duration = 44,  type = "others",    spec = true  },
		{ spellID = 73325,  duration = 90,  type = "others"                  },
		{ spellID = 32375,  duration = 45,  type = "others"                  },
		{ spellID = 305498, duration = 12,  type = "others",    spec = true  },
		{ spellID = 64901,  duration = 300, type = "others",    spec = { 257 } },
	},
	["ROGUE"] = {
		{ spellID = 1766,   duration = 15,  type = "interrupt"               },
		{ spellID = 199804, duration = 30,  type = "cc",        spec = { 260 } },
		{ spellID = 2094,   duration = 120, type = "cc"                      },
		{ spellID = 408,    duration = 20,  type = "cc",        spec = { 259, 261 } },
		{ spellID = 207736, duration = 120, type = "cc",        spec = true  },
		{ spellID = 212182, duration = 180, type = "cc",        spec = true  },
		{ spellID = 31230,  duration = 360, type = "defensive", spec = true  },
		{ spellID = 31224,  duration = 120, type = "defensive", default = true },
		{ spellID = 207777, duration = 45,  type = "defensive", spec = true  },
		{ spellID = 5277,   duration = 120, type = "defensive", spec = { 259, 261 }, default = true },
		{ spellID = 199754, duration = 120, type = "defensive", spec = { 260 }, default = true },
		{ spellID = 1856,   duration = 120, type = "defensive"               },
		{ spellID = 13750,  duration = 180, type = "offensive", spec = { 260 } },
		{ spellID = 213981, duration = 60,  type = "offensive", spec = true  },
		{ spellID = 200806, duration = 45,  type = "offensive", spec = true  },
		{ spellID = 51690,  duration = 120, type = "offensive", spec = true  },
		{ spellID = 137619, duration = { default = 30, [260] = 60 }, type = "offensive", spec = true },
		{ spellID = 198529, duration = 120, type = "offensive", spec = true  },
		{ spellID = 121471, duration = 180, type = "offensive", spec = { 261 } },
		{ spellID = 185313, duration = 60,  type = "offensive", spec = { 261 }, charges = 2 },
		{ spellID = 221622, duration = 30,  type = "offensive", spec = true, parent = 57934 },
		{ spellID = 79140,  duration = 120, type = "offensive", spec = { 259 } },
		{ spellID = 195457, duration = 60,  type = "others",    spec = { 260 } },
		{ spellID = 36554,  duration = 30,  type = "others",    spec = { 259, 261 }, charges = { [261] = 2, default = 1 } },
		{ spellID = 114018, duration = 360, type = "others"                  },
		{ spellID = 2983,   duration = 60,  type = "others"                  },
		{ spellID = 57934,  duration = 30,  type = "others"                  },
	},
	["SHAMAN"] = {
		{ spellID = 57994,  duration = 12,  type = "interrupt"               },
		{ spellID = 77130,  duration = 8,   type = "interrupt", spec = { 264 } },
		{ spellID = 192058, duration = 60,  type = "cc"                      },
		{ spellID = 51514,  duration = 30,  type = "cc"                      },
		{ spellID = 305483, duration = 30,  type = "cc",        spec = true  },
		{ spellID = 197214, duration = 40,  type = "cc",        spec = true  },
		{ spellID = 51490,  duration = 45,  type = "cc",        spec = { 262 } },
		{ spellID = 204403, duration = 30,  type = "cc",        spec = true, parent = 51490 },
		{ spellID = 108281, duration = 120, type = "defensive", spec = { 262 } },
		{ spellID = 207399, duration = 300, type = "defensive", spec = true  },
		{ spellID = 108271, duration = 90,  type = "defensive",              default = true },
		{ spellID = 198838, duration = 60,  type = "defensive", spec = true, default = true },
		{ spellID = 210918, duration = 60,  type = "defensive", spec = true, default = true, parent = 108271 },
		{ spellID = 98008,  duration = 180, type = "defensive", spec = { 264 }, default = true },
		{ spellID = 114050, duration = 180, type = "offensive", spec = true  },
		{ spellID = 114051, duration = 180, type = "offensive", spec = true  },
		{ spellID = 114052, duration = 180, type = "offensive", spec = true  },
		{ spellID = 2825,   duration = 300, type = "offensive",              pve = true },
		{ spellID = 193876, duration = 60,  type = "offensive", spec = true, parent = 2825 },
		{ spellID = 51533,  duration = 120, type = "offensive", spec = { 263 } },
		{ spellID = 108280, duration = 180, type = "offensive", spec = { 264 } },
		{ spellID = 210714, duration = 30,  type = "offensive", spec = true  },
		{ spellID = 204330, duration = 40,  type = "offensive", spec = true  },
		{ spellID = 191634, duration = 60,  type = "offensive", spec = true  },
		{ spellID = 204331, duration = 45,  type = "others",    spec = true  },
		{ spellID = 198103, duration = 300, type = "others"                  },
		{ spellID = 2484,   duration = 30,  type = "others"                  },
		{ spellID = 51485,  duration = 30,  type = "others",    spec = true  },
		{ spellID = 198067, duration = 150, type = "others",    spec = { 262 } },
		{ spellID = 196884, duration = 30,  type = "others",    spec = true  },
		{ spellID = 204336, duration = 30,  type = "others",    spec = true, default = true },
		{ spellID = 79206,  duration = 120, type = "others",    spec = { 264 } },
		{ spellID = 58875,  duration = 60,  type = "others",    spec = { 263 } },
		{ spellID = 8143,   duration = 60,  type = "others"                  },
		{ spellID = 192077, duration = 120, type = "others",    spec = true  },
	},
	["WARLOCK"] = {
		{ spellID = 119898, duration = 24,  type = "interrupt"               },
		{ spellID = 212619, duration = 24,  type = "interrupt", spec = true  },
		{ spellID = 111898, duration = 90,  type = "cc",        spec = true  },
		{ spellID = 6789,   duration = 45,  type = "cc",        spec = true  },
		{ spellID = 30283,  duration = 60,  type = "cc"                      },
		{ spellID = 108416, duration = 60,  type = "defensive", spec = true  },
		{ spellID = 268358, duration = 30,  type = "defensive", spec = true, default = true },
		{ spellID = 104773, duration = 180, type = "defensive", default = true },
		{ spellID = 201996, duration = 90,  type = "offensive", spec = true  },
		{ spellID = 212459, duration = 90,  type = "offensive", spec = true  },
		{ spellID = 113860, duration = 120, type = "offensive", spec = true  },
		{ spellID = 113858, duration = 120, type = "offensive", spec = true  },
		{ spellID = 267171, duration = 60,  type = "offensive", spec = true  },
		{ spellID = 267217, duration = 180, type = "offensive", spec = true  },
		{ spellID = 205180, duration = 180, type = "offensive", spec = { 265 } },
		{ spellID = 265187, duration = 90,  type = "offensive", spec = { 266 } },
		{ spellID = 1122,   duration = 180, type = "offensive", spec = { 267 } },
		{ spellID = 264119, duration = 45,  type = "offensive", spec = true  },
		{ spellID = 221703, duration = 60,  type = "others",    spec = true  },
		{ spellID = 199954, duration = 45,  type = "others",    spec = true  },
		{ spellID = 80240,  duration = 30,  type = "others",    spec = { 267 } },
		{ spellID = 200546, duration = 45,  type = "others",    spec = true, parent = 80240 },
		{ spellID = 212295, duration = 45,  type = "others",    spec = true  },
	},
	["WARRIOR"] = {
		{ spellID = 6552,   duration = 15,  type = "interrupt"              },
		{ spellID = 5246,   duration = 90,  type = "cc", default = true },
		{ spellID = 46968,  duration = 40,  type = "cc",        spec = { 73 } },
		{ spellID = 107570, duration = 30,  type = "cc",        spec = true },
		{ spellID = 1160,   duration = 45,  type = "defensive", spec = { 73 } },
		{ spellID = 118038, duration = 180, type = "defensive", spec = { 71 }, default = true },
		{ spellID = 236077, duration = 45,  type = "defensive", spec = true },
		{ spellID = 184364, duration = 120, type = "defensive", spec = { 72 }, default = true },
		{ spellID = 12975,  duration = 120, type = "defensive", spec = { 73 } },
		{ spellID = 97462,  duration = 180, type = "defensive"              },
		{ spellID = 871,    duration = 240, type = "defensive", spec = { 73 } },
		{ spellID = 107574, duration = 90,  type = "offensive", spec = { 73, true } },
		{ spellID = 227847, duration = 90,  type = "offensive", spec = { 71 } },
		{ spellID = 46924,  duration = 60,  type = "offensive", spec = true },
		{ spellID = 152277, duration = 60,  type = "offensive", spec = true, parent = 227847 },
		{ spellID = 228920, duration = 60,  type = "offensive", spec = true },
		{ spellID = 167105, duration = 45,  type = "offensive", spec = { 71 } },
		{ spellID = 262161, duration = 45,  type = "offensive", spec = true, parent = 167105 },
		{ spellID = 118000, duration = 35,  type = "offensive", spec = true },
		{ spellID = 1719,   duration = 90,  type = "offensive", spec = { 72 } },
		{ spellID = 198817, duration = 25,  type = "offensive", spec = true },
		{ spellID = 280772, duration = 30,  type = "offensive", spec = true },
		{ spellID = 18499,  duration = 60,  type = "others"                 },
		{ spellID = 236273, duration = 60,  type = "others",    spec = true },
		{ spellID = 6544,   duration = 45,  type = "others"                 },
		{ spellID = 216890, duration = 25,  type = "others",    spec = true },
		{ spellID = 23920,  duration = 25,  type = "others",    spec = { 73 } },
		{ spellID = 213915, duration = 30,  type = "others",    spec = true, parent = 23920 },
		{ spellID = 236320, duration = 90,  type = "others",    spec = true, default = true },
	},
	["TRINKET"] = {
		{ spellID = 208683, duration = 120, type = "trinket",   spec = true, default = true },
		{ spellID = 214027, duration = 60,  type = "trinket",   spec = true, default = true },
		{ spellID = 196029, duration = 0,   type = "trinket",   spec = true, default = true },
		{ spellID = 195710, duration = 180, type = "trinket",                default = true },
	},
	["RACIAL"] = {
		{ spellID = 59752,  duration = 180, type = "racial",    race =  1 },
		{ spellID = 20572,  duration = 120, type = "racial",    race =  2 },
		{ spellID = 20594,  duration = 120, type = "racial",    race =  3 },
		{ spellID = 58984,  duration = 120, type = "racial",    race =  4 },
		{ spellID = 7744,   duration = 120, type = "racial",    race =  5 },
		{ spellID = 20549,  duration = 90,  type = "racial",    race =  6 },
		{ spellID = 20589,  duration = 60,  type = "racial",    race =  7 },
		{ spellID = 26297,  duration = 180, type = "racial",    race =  8 },
		{ spellID = 69070,  duration = 90,  type = "racial",    race =  9 },
		{ spellID = 129597, duration = 120, type = "racial",    race = 10 },
		{ spellID = 59542,  duration = 180, type = "racial",    race = 11 },
		{ spellID = 68992,  duration = 120, type = "racial",    race = 22 },
		{ spellID = 107079, duration = 120, type = "racial",    race = 25 },
		{ spellID = 260364, duration = 180, type = "racial",    race = 27 },
		{ spellID = 255654, duration = 120, type = "racial",    race = 28 },
		{ spellID = 256948, duration = 180, type = "racial",    race = 29 },
		{ spellID = 255647, duration = 150, type = "racial",    race = 30 },
		{ spellID = 291944, duration = 150, type = "racial",    race = 31 },
		{ spellID = 287712, duration = 150, type = "racial",    race = 32 },
		{ spellID = 265221, duration = 120, type = "racial",    race = 34 },
		{ spellID = 312411, duration = 90,  type = "racial",    race = 35 },
		{ spellID = 274738, duration = 120, type = "racial",    race = 36 },
		{ spellID = 312924, duration = 180, type = "racial",    race = 37 },
	},
	["ALL"] = {
		{ spellID = 305252, duration = 120, type = "all",       item = 172672, item2 = 165806 }, -- Corrupted Gladiator's Maledict
		{ spellID = 286342, duration = 180, type = "all",       item = 172673, item2 = 165807 }, -- Corrupted Gladiator's Safeguard
		{ spellID = 315362, duration = 60,  type = "all",       item = 174472 },    -- Corrupted Gladiator's Spite
		{ spellID = 314517, duration = 120, type = "all",       item = 174276 },    -- Corrupted Gladiator's Breach
		{ spellID = 313148, duration = 120, type = "all",       item = 173944 },    -- Forbidden Obsidian Claw (trinket textureID = 1508487)
		{ spellID = 313113, duration = 80,  type = "all",       item = 173946 },    -- Writhing Segment of Drest'agath
		{ spellID = 314585, duration = 60,  type = "all",       item = 174277 },    -- Lingering Psychic Shell
	},
	["ESSENCES"] = {
		{ spellID = 295373, duration = 30,  type = "essence",   item = 295373 },
		{ spellID = 295186, duration = 60,  type = "essence",   item = 295186 },
		{ spellID = 302731, duration = 60,  type = "essence",   item = 302731 },
		{ spellID = 298357, duration = 120, type = "essence",   item = 298357 },
		{ spellID = 293019, duration = 60,  type = "essence",   item = 293019 },
		{ spellID = 294926, duration = 150, type = "essence",   item = 294926 },
		{ spellID = 298168, duration = 120, type = "essence",   item = 298168 },
		{ spellID = 295746, duration = 180, type = "essence",   item = 295746 },
		{ spellID = 293031, duration = 60,  type = "essence",   item = 293031 },
		{ spellID = 296197, duration = 15,  type = "essence",   item = 296197 },
		{ spellID = 296094, duration = 180, type = "essence",   item = 296094 },
		{ spellID = 293032, duration = 120, type = "essence",   item = 293032 },
		{ spellID = 296072, duration = 30,  type = "essence",   item = 296072 },
		{ spellID = 296230, duration = 60,  type = "essence",   item = 296230 },
		{ spellID = 295258, duration = 90,  type = "essence",   item = 295258 },
		{ spellID = 295840, duration = 180, type = "essence",   item = 295840 },
		{ spellID = 297108, duration = 120, type = "essence",   item = 297108 },
		{ spellID = 295337, duration = 60,  type = "essence",   item = 295337 },
		{ spellID = 298452, duration = 60,  type = "essence",   item = 298452 },
		{ spellID = 293030, duration = 180, type = "essence",   item = 293030 },
		{ spellID = 297375, duration = 60,  type = "essence",   item = 297375 },
		{ spellID = 295046, duration = 600, type = "essence",   item = 295046 },
		{ spellID = 310592, duration = 120, type = "essence",   item = 310592 },
		{ spellID = 310690, duration = 45,  type = "essence",   item = 310690 },
		{ spellID = 311203, duration = 60,  type = "essence",   item = 311203 },
	},
}

local iconFix = {
	[205596] = 217832,
	[200166] = 191427,
	[197491] = 22842,
	[217615] = 22842,
	[203340] = 187650,
	[193876] = 2825,
	[268358] = 48020,
}

local buffFix = {
	[51052]  = 145629,
	[287250] = 196770,
	[49028]  = 81256,
	[198589] = 212800,
	[227635] = 209426,
	[200166] = 162264,
	[33891]  = 117679,
	[116011] = 116014,
	[122470] = 125174,
	[228049] = 228050,
	[197590] = 81782,
	[62618]  = 81782,
	[197268] = 232707,
	[1856]   = 11327,
	[185313] = 185422,
	[265187] = 265273,
	[267217] = 267218,
	[97462]  = 97463,
	[236320] = 236321,
}

for k, v in pairs(E.spellList) do
	local n = #v
	for i = n, 1, -1 do
		local t = v[i]
		if t then
			local id = t.spellID

			if not C_Spell.DoesSpellExist(id) then
				tremove(v, i)
				E.Write("Removing Invalid ID: |cffffd700" .. id)
			else
				local _, icon = GetSpellTexture(iconFix[id] or id)
				local buff = buffFix[id]

				if buff then
					t.buff = buff
				end
				t.class = k
				t.icon = icon

				if E.L_HIGHLIGHTS[t.type] then
					E.highlightLT[t.buff or id] = true
				end
			end
		end
	end
end
