local TCL = select(2, ...).TomCatsLibs
TCL.Data.loadData(
	"Creatures",
	{ "Creature ID", "Vignette ID", "Alliance React", "Horde React", "Level", "Locations", "Alliance Tracking ID", "Horde Tracking ID", "World Quest ID", "Bonus Roll Tracking ID", "Loot", },
		{
			{ 151934, 3570, -1, -1, 120, {{0.5242, 0.4087 }, { 0.5242, 0.4087 }}, 55512, 55512, nil, nil, { items = {168823,168908,} }, }, -- Arachnoid Harvester
			{ 150394, 3586, -1, -1, 120, {{0.5756, 0.4801 }, { 0.5756, 0.4801 }}, 55546, 55546, nil, nil, { items = {170072,167843,168908,} }, }, -- Armored Vaultbot
			{ 151308, 3583, -1, -1, 120, {{0.538, 0.312 }, { 0.538, 0.312 }}, 55539, 55539, nil, nil, { items = {168908,169688,} }, }, -- Boggac Skullbash
			{ 153200, 3633, -1, -1, 120, {{0.513, 0.503 }, { 0.513, 0.503 }}, 55857, 55857, nil, nil, { items = {167042,168908,169691,} }, }, -- Boilburn
			{ 152001, 3581, -1, -1, 120, {{0.6576, 0.2719 }, { 0.6576, 0.2719 }}, 55537, 55537, nil, nil, { items = {169392,167846,168908,} }, }, -- Bonepicker
			{ 154739, 3736, -1, -1, 120, {{0.658, 0.584 }, { 0.658, 0.584 }}, 56368, 56368, nil, nil, { items = {169170,168908,} }, }, -- Caustic Mechaslime
			{ 152570, 3626, -1, -1, 120, {{0.8255, 0.2078 }, { 0.8255, 0.2078 }}, 55812, 55812, nil, nil, { items = {169167,169168,168908,169169,} }, }, -- Crazed Trogg
			{ 151569, 3571, -1, -1, 120, {{0.356, 0.4376 }, { 0.356, 0.4376 }}, 55514, 55514, nil, nil, { items = {167836,168908,168804,} }, }, -- Deepwater Maw
			{ 150342, 3634, -1, -1, 120, {{0.63, 0.256 }, { 0.63, 0.256 }}, 55814, 55814, nil, nil, { items = {167042,168908,169691,} }, }, -- Earthbreaker Gulroc
			{ 154153, 3690, -1, -1, 120, {{0.5249, 0.6292 }, { 0.5249, 0.6292 }}, 56207, 56207, nil, nil, { items = {169174,} }, }, -- Enforcer KX-T57
			{ 151202, 3573, -1, -1, 120, {{0.6564, 0.5164 }, { 0.6564, 0.5164 }}, 55513, 55513, nil, nil, { items = {167871,168908,} }, }, -- Foul Manifestation
			{ 151884, 3572, -1, -1, 120, {{0.4942, 0.3625 }, { 0.4942, 0.3625 }}, 55367, 55367, nil, nil, { items = {169379,168908,} }, }, -- Fungarian Furor
			{ 153228, 3628, -1, -1, 120, {{0.598, 0.527 }, { 0.598, 0.527 }}, 55852, 55852, nil, nil, { items = {167847,168908,} }, }, -- Gear Checker Cogstar
			{ 153205, 3631, -1, -1, 120, {{0.596, 0.673 }, { 0.596, 0.673 }}, 55855, 55855, nil, nil, { items = {168908,169691,} }, }, -- Gemicide
			{ 154701, 3735, -1, -1, 120, {{0.728, 0.539 }, { 0.728, 0.539 }}, 56367, 56367, nil, nil, { items = {167846,168908,} }, }, -- Gorged Gear-Cruncher
			{ 151684, 3553, -1, -1, 120, {{0.7723, 0.4469 }, { 0.7723, 0.4469 }}, 55399, 55399, nil, nil, { items = {168908,} }, }, -- Jawbreaker
			{ 152007, 3574, -1, -1, 120, {{0.4209, 0.4017 }, { 0.4209, 0.4017 }}, 55369, 55369, nil, nil, { items = {167931,168908,} }, }, -- Killsaw
			{ 151933, 3584, -1, -1, 120, {{0.6058, 0.4227 }, { 0.6058, 0.4227 }}, 55544, 55544, nil, nil, { items = {169382,169848,168908,} }, }, -- Malfunctioning Beastbot
			{ 151124, 3546, -1, -1, 120, {{0.57, 0.52 }, { 0.57, 0.52 }}, 55207, 55207, nil, nil, { items = {168490,168908,169688,} }, }, -- Mechagonian Nullifier
			{ 151672, 3552, -1, -1, 120, {{0.8824, 0.2081 }, { 0.8824, 0.2081 }}, 55386, 55386, nil, nil, { items = {169393,168908,168491,} }, }, -- Mecharantula
			{ 151627, 3636, -1, -1, 120, {{0.6093, 0.6012 }, { 0.6093, 0.6012 }}, 55859, 55859, nil, nil, { items = {168248,168908,} }, }, -- Mr. Fixthis
			{ 153206, 3629, -1, -1, 120, {{0.56, 0.367 }, { 0.56, 0.367 }}, 55853, 55853, nil, nil, { items = {167846,168908,169691,} }, }, -- Ol' Big Tusk
			{ 151296, 3575, -1, -1, 120, {{0.5677, 0.3989 }, { 0.5677, 0.3989 }}, 55515, 55515, nil, nil, { }, }, -- OOX-Avenger/MG
			{ 152764, 3632, -1, -1, 120, {{0.5716, 0.6258 }, { 0.5716, 0.6258 }}, 55856, 55856, nil, nil, { items = {168908,} }, }, -- Oxidized Leachbeast
			{ 151702, 3554, -1, -1, 120, {{0.2154, 0.6926 }, { 0.2154, 0.6926 }}, 55405, 55405, nil, nil, { items = {168908,} }, }, -- Paol Pondwader
			{ 150575, 3555, -1, -1, 120, {{0.3832, 0.5336 }, { 0.3832, 0.5336 }}, 55368, 55368, nil, nil, { items = {168908,} }, }, -- Rumblerocks
			{ 152182, 3627, -1, -1, 120, {{0.6567, 0.7832 }, { 0.6567, 0.7832 }}, 55811, 55811, nil, nil, { items = {168370,169173,168908,} }, }, -- Rustfeather
			{ 155583, 3756, -1, -1, 120, {{0.822, 0.7761 }, { 0.822, 0.7761 }}, 56737, 56737, nil, nil, { items = {168908,} }, }, -- Scrapclaw
			{ 150937, 3585, -1, -1, 120, {{0.195, 0.8053 }, { 0.195, 0.8053 }}, 55545, 55545, nil, nil, { items = {168063,168908,169872,169873,169218,} }, }, -- Seaspit
			{ 153000, 3625, -1, -1, 120, {{0.8367, 0.2185 }, { 0.8367, 0.2185 }}, 55810, 55810, nil, nil, { items = {168908,} }, }, -- Sparkqueen P'Emp
			{ 153226, 3630, -1, -1, 120, {{0.2507, 0.7734 }, { 0.2507, 0.7734 }}, 55854, 55854, nil, nil, { items = {168062,168908,169689,169691,169690,169692} }, }, -- Steel Singer Freza
			{ 155060, 155060, -1, -1, 120, {{0.8095, 0.2017 }, { 0.8095, 0.2017 }}, 56419, 56419, nil, nil, { }, }, -- The Doppel Gang
			{ 152113, 3635, -1, -1, 120, {{0.684, 0.482 }, { 0.684, 0.482 }}, 55858, 55858, nil, nil, { items = {169886,168908,169691,} }, }, -- The Kleptoboss
			{ 154225, 3687, -1, -1, 120, {{0.556, 0.602 }, { 0.556, 0.602 }}, 56182, 56182, nil, nil, { items = {169347,} }, }, -- The Rusty Prince
			{ 151623, 3550, -1, -1, 120, {{0.7229, 0.5006 }, { 0.7229, 0.5006 }}, 55364, 55364, nil, nil, { items = {168435,} }, }, -- The Scrap King
			{ 151940, 3582, -1, -1, 120, {{0.59, 0.24 }, { 0.59, 0.24 }}, 55538, 55538, nil, nil, { items = {168908,} }, }, -- Uncle T'Rog
		}
)
local L = TCL.Locales
for creatureID, creature in pairs(TCL.Data["Creatures"].records) do
	local key = creatureID .. "_DESC"
	local description = L[key]
	if description ~= key then
		if L.IsTranslationNeeded(key) then
			description = "(" .. L["Translator_Needed"] .. ")\n" .. description
		end
		creature["Description"] = description
	end
end
