require "Items/SuburbsDistributions";

CANDLES_TEST_MODE = false;

Candles = {}
Candles.version = "1.0";
Candles.author = "Darkprozac";
Candles.modName = "Candles";

-- ----------------------------------------------------------------------------
-- Functons
-- ----------------------------------------------------------------------------

--[[ Candles.init()
Prints out mod name, author, and current version.
]]
function Candles.init()
    print("Mod Loaded: " .. Candles.modName .. " by " .. Candles.author .. " (v" .. Candles.version .. ")");
end

--[[ Candles.loadTextures()
Loads new textures for Candles mod.
]]
function Candles.loadTextures()
    getTexture("Item_AnimalFat.png");
    getTexture("Item_FatSaucepan.png");
    getTexture("Item_HomeCraftsV1.png");
    getTexture("Item_Tallow.png");
    getTexture("Item_TallowSaucepan.png");
    getTexture("Item_Wick.png");
end

--[[ Candles.testMode()
Checks the global variable CANDLES_TEST_MODE and if true, your new character 
will start off with items to test this mod.
]]
function Candles.testMode()
    if CANDLES_TEST_MODE then
        local player = getSpecificPlayer(0);
        local playerData = player:getModData();
        
        playerData.testMode = playerData.testMode or "false";

        if (playerData.testMode == "false") then
            player:getInventory():AddItem("Base.Scissors");
            player:getInventory():AddItem("Base.KitchenKnife");
            player:getInventory():AddItem("Base.Lighter");
            player:getInventory():AddItem("Base.Saucepan");
            player:getInventory():AddItems("Base.DeadBird", 10);
            player:getInventory():AddItems("Base.DeadRabbit", 10);
            player:getInventory():AddItems("Base.DeadSquirrel", 10);
            player:getInventory():AddItems("Candles.Animal Fat", 5);
            player:getInventory():AddItem("Candles.Tallow");
            player:getInventory():AddItems("Base.Twine", 2);
            player:getInventory():AddItems("Base.CottonBalls", 3);
            player:getInventory():AddItems("Candles.Wick", 10);
            player:getInventory():AddItem("Candles.HomeCraftsVol1Mag");
            playerData.testMode = "true";
        end
    end
end


--[[ EmptyAnimalFatSaucepan_OnCreate()
OnCreate function to return saucepan back to player inventory since recipe 
only returns one item (animal fat). See Candles.txt.
]]
function EmptyAnimalFatSaucepan_OnCreate(items, result, player)
    player:getInventory():AddItem("Saucepan");
end

--[[ EmptyTallowSaucepan_OnCreate()
OnCreate function to return saucepan back to player inventory since recipe 
only returns one item (tallow). See Candles.txt
]]
function EmptyTallowSaucepan_OnCreate(items, result, player)
    player:getInventory():AddItem("Saucepan");
end

--[[ CandlesCutAnimal_OnCreate()
New CutAnimal function to use. We override the base recipe and call this 
OnCreate function instead. It will call the original version to
get the small animal meat, and then provide a 10% chance to get animal
fat from the action. Had to do this as it seems OnMakeItem event
doesn't work anymore...
]]
function CandlesCutAnimal_OnCreate(items, result, player)    
    CutAnimal_OnCreate(items, result, player);

    if ( ZombRand(10) == 0 ) then
        getPlayer():getInventory():AddItem("Candles.Animal Fat");
    end
end

-- ----------------------------------------------------------------------------
-- Location Distributions
-- ----------------------------------------------------------------------------
table.insert(SuburbsDistributions["all"]["postbox"].items, "Candles.HomeCraftsVol1Mag");
table.insert(SuburbsDistributions["all"]["postbox"].items, 0.2);
table.insert(SuburbsDistributions["all"]["shelves"].items, "Candles.HomeCraftsVol1Mag");
table.insert(SuburbsDistributions["all"]["shelves"].items, 1);
table.insert(SuburbsDistributions["all"]["shelvesmag"].items, "Candles.HomeCraftsVol1Mag");
table.insert(SuburbsDistributions["all"]["shelvesmag"].items, 1);
table.insert(SuburbsDistributions["all"]["sidetable"].items, "Candles.HomeCraftsVol1Mag");
table.insert(SuburbsDistributions["all"]["sidetable"].items, 0.7);

table.insert(SuburbsDistributions["bookstore"]["all"].items,"Candles.HomeCraftsVol1Mag");
table.insert(SuburbsDistributions["bookstore"]["all"].items, 1);

table.insert(SuburbsDistributions["conveniencestore"]["shelves"].items, "Candles.HomeCraftsVol1Mag");
table.insert(SuburbsDistributions["conveniencestore"]["shelves"].items, 0.2);

table.insert(SuburbsDistributions["fossoil"]["shelvesmag"].items, "Candles.HomeCraftsVol1Mag");
table.insert(SuburbsDistributions["fossoil"]["shelvesmag"].items, 0.2);

table.insert(SuburbsDistributions["grocery"]["shelvesmag"].items,"Candles.HomeCraftsVol1Mag");
table.insert(SuburbsDistributions["grocery"]["shelvesmag"].items, 2);

table.insert(SuburbsDistributions["kitchen"]["shelves"].items, "Candles.HomeCraftsVol1Mag");
table.insert(SuburbsDistributions["kitchen"]["shelves"].items, 0.1);

table.insert(SuburbsDistributions["shed"]["counter"].items, "Candles.HomeCraftsVol1Mag");
table.insert(SuburbsDistributions["shed"]["counter"].items, 0.2);

table.insert(SuburbsDistributions["zippeestore"]["shelvesmag"].items, "Candles.HomeCraftsVol1Mag");
table.insert(SuburbsDistributions["zippeestore"]["shelvesmag"].items, 0.2);

-- ----------------------------------------------------------------------------
-- Hooks
-- ----------------------------------------------------------------------------
Events.OnGameBoot.Add(Candles.init);
Events.OnGameStart.Add(Candles.testMode);
Events.OnPreMapLoad.Add(Candles.loadTextures);
