# --------------------------------------------------------

#
# Ľṹ `glad_ad`
#

CREATE TABLE `glad_ad` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `title` varchar(100) default '0',
  `intro` varchar(255) default NULL,
  `url` varchar(255) default NULL,
  `image` varchar(255) default NULL,
  `height` smallint(6) unsigned default NULL,
  `width` smallint(6) unsigned default NULL,
  `img_type` enum('image','flash') default 'image',
  `ad_type` smallint(6) unsigned default '0',
  `ctime` datetime default NULL,
  `etime` datetime default NULL,
  `btimes` smallint(6) unsigned default '0',
  `display` int(11) unsigned default '0',
  `hits` int(11) unsigned default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=2 ;

#
# Ľṹ `glad_articles`
#

CREATE TABLE `glad_articles` (
  `id` int(11) NOT NULL auto_increment,
  `uid` int(11) NOT NULL default '0',
  `cid` varchar(11) NOT NULL default '',
  `title` varchar(255) NOT NULL default '',
  `intro` text NOT NULL,
  `content` text NOT NULL,
  `author` varchar(100) NOT NULL default '',
  `source` varchar(100) NOT NULL default '',
  `img` varchar(255) NOT NULL default '',
  `thumb` varchar(100) NOT NULL default '',
  `first` enum('yes','no') NOT NULL default 'no',
  `isimg` enum('yes','no') NOT NULL default 'no',
  `ctime` datetime NOT NULL default '0000-00-00 00:00:00',
  `etime` datetime NOT NULL default '0000-00-00 00:00:00',
  `utime` datetime NOT NULL default '0000-00-00 00:00:00',
  `voter` smallint(6) NOT NULL default '0',
  `vote` smallint(6) NOT NULL default '0',
  `hits` smallint(6) NOT NULL default '0',
  `active` enum('yes','no') NOT NULL default 'no',
  `mark` enum('yes','no') NOT NULL default 'yes',
  KEY `id` (`id`)
) TYPE=MyISAM AUTO_INCREMENT=678 ;


#
# Ľṹ `glad_attachment`
#

CREATE TABLE `glad_attachment` (
  `id` int(11) NOT NULL auto_increment,
  `aid` int(11) NOT NULL default '0',
  `title` varchar(100) NOT NULL default '',
  `server` int(11) NOT NULL default '0',
  `url` varchar(255) NOT NULL default '',
  `length` varchar(255) NOT NULL default '0.00',
  `size` decimal(6,2) NOT NULL default '0.00',
  `ctime` datetime NOT NULL default '0000-00-00 00:00:00',
  `hits` smallint(6) NOT NULL default '0',
  `ctype` varchar(10) NOT NULL default '',
  `point` smallint(6) NOT NULL default '0',
  KEY `id` (`id`)
) TYPE=MyISAM AUTO_INCREMENT=4 ;

# --------------------------------------------------------

#
# Ľṹ `glad_attachments`
#

CREATE TABLE `glad_attachments` (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(100) NOT NULL default '',
  `filesize` int(30) NOT NULL default '0',
  `filepath` varchar(255) NOT NULL default '',
  `filename` varchar(255) NOT NULL default '',
  `uid` int(11) NOT NULL default '0',
  `ctime` datetime NOT NULL default '0000-00-00 00:00:00',
  KEY `id` (`id`)
) TYPE=MyISAM AUTO_INCREMENT=6 ;


# --------------------------------------------------------

#
# Ľṹ `glad_bank_log`
#

CREATE TABLE `glad_bank_log` (
  `id` int(11) NOT NULL default '0',
  `uid` int(11) NOT NULL default '0',
  `ctype` varchar(20) NOT NULL default '',
  `price` varchar(20) NOT NULL default '',
  `ctime` datetime NOT NULL default '0000-00-00 00:00:00',
  `o_b` varchar(10) NOT NULL default '',
  UNIQUE KEY `id` (`id`)
) TYPE=MyISAM;

#
# е `glad_bank_log`
#


# --------------------------------------------------------

#
# Ľṹ `glad_break_links`
#

CREATE TABLE `glad_break_links` (
  `id` int(11) NOT NULL auto_increment,
  `aid` int(11) NOT NULL default '0',
  `uid` int(11) NOT NULL default '0',
  `ctime` datetime NOT NULL default '0000-00-00 00:00:00',
  `content` varchar(255) NOT NULL default '',
  `stats` enum('yes','no') NOT NULL default 'no',
  KEY `id` (`id`)
) TYPE=MyISAM AUTO_INCREMENT=3 ;

#
# е `glad_break_links`
#


# --------------------------------------------------------

#
# Ľṹ `glad_cart`
#

CREATE TABLE `glad_cart` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `oid` varchar(20) default NULL,
  `name` varchar(100) default NULL,
  `email` varchar(100) default NULL,
  `telnum` varchar(50) default NULL,
  `rname` varchar(100) default NULL,
  `address` varchar(255) default NULL,
  `rtelnum` varchar(40) default NULL,
  `zip` varchar(20) default NULL,
  `info` varchar(255) default NULL,
  `ctime` datetime NOT NULL default '0000-00-00 00:00:00',
  `ispay` enum('yes','no') default 'no',
  `isover` enum('yes','no') default 'no',
  KEY `id` (`id`)
) TYPE=MyISAM AUTO_INCREMENT=23 ;

# --------------------------------------------------------

#
# Ľṹ `glad_cart_item`
#

CREATE TABLE `glad_cart_item` (
  `oid` int(11) unsigned default NULL,
  `iid` int(11) unsigned default NULL,
  `title` varchar(255) default NULL,
  `price` int(10) default NULL,
  `num` smallint(6) unsigned default '0',
  KEY `oid` (`oid`,`iid`)
) TYPE=MyISAM;


# --------------------------------------------------------

#
# Ľṹ `glad_category`
#

CREATE TABLE `glad_category` (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(255) NOT NULL default '',
  `icon` varchar(255) NOT NULL default '',
  `english_name` varchar(255) NOT NULL default '',
  `pid` int(11) NOT NULL default '0',
  `o_num` smallint(6) NOT NULL default '0',
  `intro` text NOT NULL,
  `ctime` datetime NOT NULL default '0000-00-00 00:00:00',
  `mod` varchar(255) NOT NULL default '',
  `cate_template` varchar(255) NOT NULL default 'default.php',
  `list_template` varchar(255) NOT NULL default '',
  `detail_template` varchar(255) NOT NULL default '',
  `other_1` varchar(20) NOT NULL default '',
  `other_2` varchar(6) NOT NULL default '',
  `other_3` varchar(255) NOT NULL default '',
  `hits` smallint(6) NOT NULL default '0',
  `page_title` varchar(255) NOT NULL default '',
  `page_keyword` varchar(255) NOT NULL default '',
  `page_discription` varchar(255) NOT NULL default '',
  `page_num` int(6) NOT NULL default '1',
  `page_col` int(6) NOT NULL default '1',
  `status` enum('yes','no') NOT NULL default 'no',
  KEY `id` (`id`)
) TYPE=MyISAM AUTO_INCREMENT=55 ;


#
# Ľṹ `glad_configration`
#

CREATE TABLE `glad_configration` (
  `conf_id` int(11) NOT NULL auto_increment,
  `conf_intro` varchar(255) default NULL,
  `conf_title` varchar(40) default NULL,
  `conf_set` blob,
  `type` varchar(100) NOT NULL default 'system',
  PRIMARY KEY  (`conf_id`)
) TYPE=MyISAM AUTO_INCREMENT=28 ;

#
# е `glad_configration`
#

INSERT INTO `glad_configration` VALUES (1, 'վ', 'site_name', 0xc3c5b5c0cdf8, 'system');
INSERT INTO `glad_configration` VALUES (2, 'վģ', 'site_template', 'default', 'template');
INSERT INTO `glad_configration` VALUES (3, 'վEmail', 'site_email', 0x6d75797540636e636d732e6f7267, 'system');
INSERT INTO `glad_configration` VALUES (4, 'ʱ趨', 'expire_time', 0x3135, 'system');
INSERT INTO `glad_configration` VALUES (5, 'ȨϢ', 'site_license', 0x506f7765726279207777772e6d656e746f722e636e, 'system');
INSERT INTO `glad_configration` VALUES (6, 'ͼƬĿ¼', 'image_path', 0x75706c6f61642f696d61676573, 'image');
INSERT INTO `glad_configration` VALUES (7, 'ͼƬͼС', 'image_thumb_size', 0x31303078313030, 'image');
INSERT INTO `glad_configration` VALUES (8, 'ͼƬ', 'accept_image_type', 0x626d707c6a7065677c6a70677c6769667c706e677c737766, 'image');
INSERT INTO `glad_configration` VALUES (9, 'Ŀ¼', 'attach_path', 0x75706c6f61642f66696c65, 'attach');
INSERT INTO `glad_configration` VALUES (10, 'С', 'accept_attach_size', 0x32303430303030, 'attach');
INSERT INTO `glad_configration` VALUES (11, '', 'accept_attach_type', 0x7a69707c7261727c7461727c677a7c646f637c786c737c64627c7478747c677a7c626d707c6a70677c6a7065677c706e677c6769667c, 'attach');
INSERT INTO `glad_configration` VALUES (12, 'ĬĿģ', 'default_category_template', 0x696e6465782e74706c, 'template');
INSERT INTO `glad_configration` VALUES (13, 'Ĭбģ', 'default_list_template', 0x64656661756c742e74706c, 'template');
INSERT INTO `glad_configration` VALUES (14, 'Ĭҳģ', 'default_detail_template', 0x696e6465782e74706c, 'template');
INSERT INTO `glad_configration` VALUES (15, 'ͼʽ', 'thumb_method', 0x4744, 'image');
INSERT INTO `glad_configration` VALUES (16, 'mailʽ', 'mail_method', 0x736d7470, 'system');
INSERT INTO `glad_configration` VALUES (17, 'Ƿ񿪷ע', 'allow_register', 0x796573, 'system');
INSERT INTO `glad_configration` VALUES (18, 'Ƿ񿪷վ', 'is_open', 0x796573, 'system');
INSERT INTO `glad_configration` VALUES (19, 'վرԭ', 'site_close_reason', 0xd5beb5e3c9fdbcb6d6d02cc7ebc9d4baf3b7c3ceca, 'system');
INSERT INTO `glad_configration` VALUES (20, 'SMTPַ', 'smtp_host', 0x6c6f63616c686f7374, 'system');
INSERT INTO `glad_configration` VALUES (21, 'smtp˿', 'smtp_port', 0x3235, 'system');
INSERT INTO `glad_configration` VALUES (22, 'ͼƬС(ֽ)', 'image_file_size', 0x323034303030, 'image');
INSERT INTO `glad_configration` VALUES (23, 'ͼƬߴ(x)', 'image_size', 0x38303078383030, 'image');
INSERT INTO `glad_configration` VALUES (24, 'html', 'outhtml', 0x6e6f, 'system');
INSERT INTO `glad_configration` VALUES (25, '̬ҳλ', 'html_path', 0x7765622f, 'system');
INSERT INTO `glad_configration` VALUES (26, '̬ļ׺', 'html_ext', 0x68746d6c, 'system');

# --------------------------------------------------------

#
# Ľṹ `glad_contents`
#

CREATE TABLE `glad_contents` (
  `id` int(11) NOT NULL auto_increment,
  `aid` int(11) NOT NULL default '0',
  `cid` int(11) NOT NULL default '0',
  `title` varchar(255) NOT NULL default '',
  `content` text NOT NULL,
  `ctime` datetime NOT NULL default '0000-00-00 00:00:00',
  `utime` datetime NOT NULL default '0000-00-00 00:00:00',
  `o_num` smallint(6) NOT NULL default '0',
  `other_1` varchar(6) NOT NULL default '',
  `other_2` varchar(6) NOT NULL default '',
  `active` enum('yes','no') NOT NULL default 'yes',
  `hits` smallint(6) NOT NULL default '0',
  KEY `id` (`id`)
) TYPE=MyISAM AUTO_INCREMENT=953 ;


# --------------------------------------------------------

#
# Ľṹ `glad_fetch_content`
#

CREATE TABLE `glad_fetch_content` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `s_id` int(11) unsigned default '0',
  `s_url` varchar(255) default '0',
  `n_title` varchar(255) default '0',
  `n_date` varchar(100) default '0',
  `n_source` varchar(255) default '0',
  `n_content` text,
  `isnew` tinyint(3) unsigned default '0',
  `ischeck` tinyint(3) unsigned default '0',
  PRIMARY KEY  (`id`),
  KEY `id` (`id`)
) TYPE=MyISAM AUTO_INCREMENT=7 ;


# --------------------------------------------------------

#
# Ľṹ `glad_fetch_site`
#

CREATE TABLE `glad_fetch_site` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `title` varchar(255) default '0',
  `intro` varchar(255) default '0',
  `url` varchar(255) default '0',
  `news_url` varchar(255) NOT NULL default '',
  `update_time` varchar(20) default '0',
  `update_url` varchar(255) default NULL,
  `l_code` varchar(255) default '0',
  `p_t_code` varchar(255) default '0',
  `p_d_code` varchar(255) default '0',
  `p_s_code` varchar(255) default '0',
  `p_c_code` varchar(255) default '0',
  `p_clear_ad_code` varchar(255) default NULL,
  `site_name` varchar(255) default '0',
  `default_cate` int(11) NOT NULL default '0',
  `isactive` tinyint(3) unsigned default '1',
  PRIMARY KEY  (`id`),
  KEY `id` (`id`)
) TYPE=MyISAM AUTO_INCREMENT=2 ;

#
# Ľṹ `glad_forum`
#

CREATE TABLE `glad_forum` (
  `post_id` int(11) NOT NULL auto_increment,
  `post_uid` varchar(100) NOT NULL default '',
  `post_aid` int(11) NOT NULL default '0',
  `post_title` varchar(255) NOT NULL default '',
  `post_content` text NOT NULL,
  `post_date` int(11) NOT NULL default '0',
  `post_type` varchar(50) NOT NULL default '',
  KEY `post_id` (`post_id`)
) TYPE=MyISAM AUTO_INCREMENT=2 ;


# --------------------------------------------------------

#
# Ľṹ `glad_group_right`
#

CREATE TABLE `glad_group_right` (
  `gid` varchar(20) NOT NULL default '',
  `cid` int(11) NOT NULL default '0',
  `gright` varchar(20) NOT NULL default ''
) TYPE=MyISAM;

#
# е `glad_group_right`
#


# --------------------------------------------------------

#
# Ľṹ `glad_images`
#

CREATE TABLE `glad_images` (
  `id` int(11) NOT NULL auto_increment,
  `aid` int(11) NOT NULL default '0',
  `name` varchar(100) NOT NULL default '',
  `image` varchar(255) NOT NULL default '',
  `thumb` varchar(255) NOT NULL default '',
  `size` varchar(20) NOT NULL default '',
  `hits` smallint(6) NOT NULL default '0',
  `ot1` smallint(3) NOT NULL default '0',
  `ot2` smallint(3) NOT NULL default '0',
  KEY `id` (`id`)
) TYPE=MyISAM AUTO_INCREMENT=16 ;


# --------------------------------------------------------

#
# Ľṹ `glad_link`
#

CREATE TABLE `glad_link` (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(100) NOT NULL default '',
  `icon` varchar(255) NOT NULL default '',
  `url` varchar(255) NOT NULL default '',
  `ctime` datetime NOT NULL default '0000-00-00 00:00:00',
  `hits` smallint(6) NOT NULL default '0',
  KEY `id` (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

#
# е `glad_link`
#


# --------------------------------------------------------

#
# Ľṹ `glad_poll`
#

CREATE TABLE `glad_poll` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `title` varchar(100) default '0',
  `intro` text,
  `ctime` datetime default NULL,
  `etime` datetime default NULL,
  `polltype` enum('single','multi') default NULL,
  `pollnum` smallint(6) unsigned default '2',
  `voter` smallint(6) unsigned default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=2 ;


# --------------------------------------------------------

#
# Ľṹ `glad_poll_data`
#

CREATE TABLE `glad_poll_data` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `pid` int(11) unsigned NOT NULL default '0',
  `content` varchar(255) default NULL,
  `vote` smallint(6) unsigned default '0',
  PRIMARY KEY  (`id`,`pid`)
) TYPE=MyISAM AUTO_INCREMENT=5 ;

# --------------------------------------------------------

#
# Ľṹ `glad_server`
#

CREATE TABLE `glad_server` (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(100) NOT NULL default '',
  `host` varchar(100) NOT NULL default '',
  `uname` varchar(100) NOT NULL default '',
  `password` varchar(100) NOT NULL default '',
  `port` smallint(6) NOT NULL default '0',
  `utime` datetime NOT NULL default '0000-00-00 00:00:00',
  `serv_url` varchar(255) NOT NULL default '',
  `ctype` enum('ftp','http') NOT NULL default 'http',
  KEY `id` (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

#
# е `glad_server`
#


# --------------------------------------------------------

#
# Ľṹ `glad_sessions`
#

CREATE TABLE `glad_sessions` (
  `id` varchar(32) NOT NULL default '0',
  `member_name` varchar(64) default NULL,
  `member_id` mediumint(8) NOT NULL default '0',
  `ip_address` varchar(16) default NULL,
  `running_time` int(10) default NULL,
  `login_type` varchar(8) default NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;


# --------------------------------------------------------

#
# Ľṹ `glad_topic_links`
#

CREATE TABLE `glad_topic_links` (
  `id` int(11) NOT NULL auto_increment,
  `tid` int(11) NOT NULL default '0',
  `aid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=12 ;

# --------------------------------------------------------

#
# Ľṹ `glad_topics`
#

CREATE TABLE `glad_topics` (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(100) NOT NULL default '',
  `intro` text NOT NULL,
  `image` varchar(255) NOT NULL default '',
  `hits` int(6) NOT NULL default '0',
  `ctime` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=2 ;

# --------------------------------------------------------

#
# Ľṹ `glad_user_extra`
#

CREATE TABLE `glad_user_extra` (
  `id` int(11) NOT NULL default '0',
  `level` varchar(20) NOT NULL default 'Uactive',
  `stime` datetime NOT NULL default '0000-00-00 00:00:00',
  `etime` datetime NOT NULL default '0000-00-00 00:00:00',
  `question` varchar(255) NOT NULL default '',
  `answer` varchar(255) NOT NULL default '',
  `point` smallint(6) NOT NULL default '0',
  `user_type` varchar(20) NOT NULL default '0',
  `ccc` char(3) NOT NULL default '',
  `ddd` char(3) NOT NULL default '',
  UNIQUE KEY `id` (`id`)
) TYPE=MyISAM;

#
# е `glad_user_extra`
#

INSERT INTO `glad_user_extra` VALUES (1, 'Admin', '0000-00-00 00:00:00', '2004-11-21 00:00:00', 'aaa', 'bbb', 2000, 'Vip', '', '');

# --------------------------------------------------------

#
# Ľṹ `glad_user_log`
#

CREATE TABLE `glad_user_log` (
  `id` int(11) NOT NULL auto_increment,
  `aid` int(11) NOT NULL default '0',
  `atid` int(11) NOT NULL default '0',
  `uid` int(11) NOT NULL default '0',
  `ctime` datetime NOT NULL default '0000-00-00 00:00:00',
  `point` smallint(6) NOT NULL default '0',
  KEY `id` (`id`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

#
# е `glad_user_log`
#


# --------------------------------------------------------

#
# Ľṹ `glad_user_right`
#

CREATE TABLE `glad_user_right` (
  `uid` int(11) NOT NULL default '0',
  `cid` int(11) NOT NULL default '0',
  `uright` varchar(20) NOT NULL default ''
) TYPE=MyISAM;

#
# е `glad_user_right`
#

INSERT INTO `glad_user_right` VALUES (1, 2, '');

# --------------------------------------------------------

#
# Ľṹ `glad_users`
#

CREATE TABLE `glad_users` (
  `uid` int(11) NOT NULL auto_increment,
  `username` varchar(100) NOT NULL default '',
  `password` varchar(100) NOT NULL default '',
  `email` varchar(100) NOT NULL default '',
  KEY `uid` (`uid`)
) TYPE=MyISAM AUTO_INCREMENT=20 ;

#
# е `glad_users`
#

INSERT INTO `glad_users` VALUES (1, 'admin', '21232f297a57a5a743894a0e4a801fc3', 'cngun@163.com');
