$(document).ready(function() {
	//通过题目列跳转到该题
	$(".bank_num").click(function() {
		var conf_num = $(this).attr('conf_num');
		var bank_num = $(this).attr('bank_num');
		var bank_key = $(this).attr('bank_key');
		jump(conf_num,bank_num,bank_key);
	});
	//跳转
	$("#jump_action").click(function() {
		var bank_num = parseInt($("#jump_num").attr('value'));
		var bank_total = parseInt($("#jump_num").attr('bank_total'));
		
		if (bank_num > 0 && bank_total >= bank_num) {
			var conf_num = $(".bank_num_"+bank_num).attr('conf_num');
			var bank_key = $(".bank_num_"+bank_num).attr('bank_key');
			jump(conf_num,bank_num,bank_key);
		} else if (isNaN(bank_num)) {
			alert("请您输入要跳转到的题号");
		} else {
			alert("您输入的题号超出了跳转的范围");
		}
	});
	
	//上一题
	$("#pre_bank").click(function() {
		var conf_num_now = parseInt($("#bank_now").attr('conf_num'));
		var bank_now = parseInt($("#bank_now").attr('bank_num'));
		
		if (bank_now == 1) {
			alert("已在最前一题");
		} else {
			var bank_num = bank_now - 1;
			var conf_num = $(".bank_num_"+bank_num).attr("conf_num");
			var bank_key = $(".bank_num_"+bank_num).attr("bank_key");
			
//			alert(conf_num+','+bank_num+','+bank_key);
			jump(conf_num,bank_num,bank_key);
		}
		
	});
	//下一题
	$("#next_bank").click(function() {
		var bank_total = parseInt($("#bank_now").attr("bank_total"));
		var bank_now = parseInt($("#bank_now").attr("bank_num"));
		
		if (bank_total > bank_now) {
			var bank_num = bank_now + 1;
			var conf_num = $(".bank_num_"+bank_num).attr("conf_num");
			var bank_key = $(".bank_num_"+bank_num).attr("bank_key");
			
//			alert(conf_num+','+bank_num+','+bank_key);
			jump(conf_num,bank_num,bank_key);
			
		} else {
			alert("已到最后一题，如要交卷，请点击交卷按钮");
		}
	});
	
	//显示选择的答案并保存到session
	$(".option").click(function() {
		var bank_num = $("#bank_now").attr("bank_num");
		var choice = '';
		$(".option_"+bank_num).each(function() {
			if ($(this).attr('checked') == true) {
				choice += $(this).attr("value");
			}
		});
		var undone_num = parseInt($("#undone_num").html());
		if (choice) {
			if ($("#show_"+bank_num).html() == '　') {
				$("#undone_num").html(undone_num-1);
			}
			$(".bank_num_color_"+bank_num).css('color','blue');
			$("#show_"+bank_num).html(choice);
			
		} else {
			$(".bank_num_color_"+bank_num).css('color','red');
			$("#show_"+bank_num).html('　');
			$("#undone_num").html(undone_num+1);
		}
		
		//save to session
		choice = (choice == "正确")?1:((choice == "错误")?2:choice);
		
		var conf_num = $("#bank_now").attr("conf_num");
		var conf_sec_num = $(".bank_num_"+bank_num).attr('conf_sec_num');
		var bank_key = $("#bank_now").attr("bank_key");
		
//		alert(conf_num+','+conf_sec_num+','+bank_key+','+choice);
		
		saveAnswer(conf_num,conf_sec_num,bank_key,choice);
	});
	
	$("#overIt").click(function() {
		var bank_now = $("#bank_now").attr("bank_num");
		var conf_num = $("#bank_now").attr("conf_num");
		var conf_sec_num = $(".bank_num_"+bank_now).attr('conf_sec_num');
		var bank_key = $("#bank_now").attr("bank_key");
		
		saveAnswer_(conf_num,bank_key,bank_now)
		
		var undone_num = $("#undone_num").html();
		if (confirm("您有"+undone_num+"道题未做，确认要交卷吗？")) {
			if (confirm("请您再次确认是否交卷！")) {
				if (confirm("请您最后确认是否交卷！")) {
//					$("#cover").css("display","");
					
					finishExam();
				}
			}
		}
	});
	
});

function setTime(restTime,usedTime) {
	var rest_time = parseInt(restTime/3600)+':'+parseInt(restTime%3600/60)+':'+parseInt(restTime%3600%60);
	var used_time = parseInt(usedTime/3600)+':'+parseInt(usedTime%3600/60)+':'+parseInt(usedTime%3600%60);
	$("#used_time").attr('value',used_time);
	$("#rest_time").attr('value',rest_time);
	setTimeout(function() {
		if (restTime == 0) {
			alert("考试结束时间已到，请点击确定提交试卷！");
			finishExam();
		}
		restTime -= 1;
		usedTime += 1;
		setTime(restTime,usedTime);
	}, 1000)
}

function jump(conf_num,bank_num,bank_key) {
	var conf_num_now = $("#bank_now").attr('conf_num');
	var bank_now = $("#bank_now").attr('bank_num');
	var bank_key_now = $("#bank_now").attr('bank_key');
	
	$("#bank_now").attr('conf_num',conf_num);
	$("#bank_now").attr('bank_num',bank_num);
	$("#bank_now").attr('bank_key',bank_key);
	
	$(".conf_"+conf_num_now).css("display","none");
	$(".conf_"+conf_num).css("display","");
	$(".bank_"+bank_now).css("display","none");
	$(".bank_"+bank_num).css("display","");
	
	$(".bank_num_"+bank_now).css("background","");
	$(".bank_num_"+bank_num).css("background","green");
	
	saveAnswer_(conf_num_now,bank_key_now,bank_now);
}

function saveAnswer_(conf_num_now,bank_key_now,bank_now) {
	var conf_sec_num = $(".bank_num_"+bank_now).attr('conf_sec_num');
	var bank_type_en = $(".bank_num_"+bank_now).attr("bank_type_en");
	
	if (bank_type_en != 'single_choice' && bank_type_en != 'choice' && bank_type_en != 'judge') {
		
		var my_answer = $('.my_answer_'+bank_now).html();
		saveAnswer(conf_num_now,conf_sec_num,bank_key_now,my_answer);
		var undone_num = parseInt($("#undone_num").html());
		
		if (my_answer == '' || my_answer == '<br>' || my_answer == '-1') {
			if ($(".bank_num_"+bank_now).attr('dotag') == 'true') {
				$("#undone_num").html(undone_num+1);
				$(".bank_num_"+bank_now).attr('dotag','false');
				$(".bank_num_color_"+bank_now).css('color','red');
			}
		} else {
			if ($(".bank_num_"+bank_now).attr('dotag') == 'true') {
				
			} else {
				$("#undone_num").html(undone_num-1);
				$(".bank_num_"+bank_now).attr('dotag','true');
				$(".bank_num_color_"+bank_now).css('color','blue');
			}
		}
		
	}
}

function count(i,line,amount){
	if (i == 6) {
		i = 0;
		amount = "。";
	} else {
		amount = amount + line;
	}
	i++;
	$("#chart").html(amount);
	setTimeout(function() {count(i,line,amount);},500);
}

function showFlash(annex_name) {
	var obj = '<object id="obj" classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="800" height="600" align="middle">\
	<param name="allowScriptAccess" value="sameDomain" />\
	<param name="movie" value="/examnation/flash/' + annex_name + '" />\
	<param name="quality" value="high" />\
	<param name="wmode" value="opaque" />\
	<embed src="/examnation/flash/' + annex_name + '" width="300" height="480" align="middle" name="flash_wmp" bgcolor="#ece9d8" allowScriptAccess="sameDomain" type="application/x-shockwave-flash" pluginspage="http://www.macromedia.com/go/getflashplayer" />\
	</object>';
	
	$(".flash_bank").html(obj);
	$(".flash_bank").css("display","");
	
}


function examination(answer){
	var rs = answer.split("|");
	
	var bank_num = $("#bank_now").attr("bank_num");
	$('.my_answer_'+bank_num).html(rs[1]);
	//隐藏flash
	$(".flash_bank").css("display","none");
	//跳到下一题
	$("#next_bank[id=next_bank]").click();
	
}