﻿using RimWorld;
using System;
using System.Collections.Generic;   
using Verse;

namespace MedTimes
{
    class Building_AirlockDoor : Building_Door
    {
        private int CompRaareTicks = 0;

        private bool freePassageWhenClearedReachabilityCache;  

        private void ClearReachabilityCache(Map map)
        {
            map.reachability.ClearCache();
            freePassageWhenClearedReachabilityCache = FreePassage;
        }

        public override void Draw()
        {
            if (def.drawerType == DrawerType.RealtimeOnly)
            {
                DrawAt(DrawPos);
            }
            Comps_PostDraw();
        }

        public override ushort PathWalkCostFor(Pawn p)
        {
            return Convert.ToUInt16(this.def.pathCost);
        }

        public override ushort PathFindCostFor(Pawn p)
        {
            return Convert.ToUInt16(this.def.pathCost);
        }

        public override bool FireBulwark => false;
                 
        public override void Tick()
        {
            ++CompRaareTicks;
                        
            if (AllComps != null)
            {
                int i = 0;
                for (int count = AllComps.Count; i < count; i++)
                {
                    if (CompRaareTicks == 250 && AllComps[i] is CompMelter cm) cm.CompTickRare();
                    else { AllComps[i].CompTick(); }
                }
            }

            if (CompRaareTicks == 250)
            {
                CompRaareTicks = 0;
            }

            if (FreePassage != freePassageWhenClearedReachabilityCache)
            {
                ClearReachabilityCache(base.Map);
            }
            if (!Open)
            {
                if (visualTicksOpen > 0)
                {
                    visualTicksOpen--;
                }
            }
            else
            {
                if (!Open)
                {
                    return;
                }
                if (visualTicksOpen < TicksToOpenNow)
                {
                    visualTicksOpen++;
                }
                List<Thing> thingList = base.Position.GetThingList(base.Map);
                for (int i = 0; i < thingList.Count; i++)
                {
                    Pawn pawn = thingList[i] as Pawn;
                    if (pawn != null)
                    {
                        CheckFriendlyTouched(pawn);
                    }
                }

                if (ticksUntilClose > 0)
                {
                    if (base.Map.thingGrid.CellContains(base.Position, ThingCategory.Pawn))
                    {
                        ticksUntilClose = 110;
                    }
                    ticksUntilClose--;
                    if (ticksUntilClose <= 0 && !HoldOpen && !DoorTryClose())
                    {
                        ticksUntilClose = 1;
                    }
                }
                else if(!HoldOpen)
                {
                    ticksUntilClose = 110;
                }
            }
        }

        public override bool PawnCanOpen(Pawn p)
        {
            return true;
        }

        public override bool BlocksPawn(Pawn p)
        {                            
            return p.BodySize > 1.0f;
        }

        public override IEnumerable<Gizmo> GetGizmos()
        {
            foreach (Gizmo gizmo in base.GetGizmos())
            {
                if(gizmo is Command_Toggle command && command.icon == TexCommand.HoldOpen)
                {
                    if(!HoldOpen) command.toggleAction.Invoke();
                    continue;
                }
                yield return gizmo;
            }
        }
    }
}
