﻿using System;
using System.Collections.Generic;
using RimWorld;
using UnityEngine;
using Verse;

namespace MedTimes
{
    class Building_FenceGate : Building_Door
    {
        public override void Draw()
        {
            base.Rotation = PalisadeDoorRotationAt(Position, Map);
            float num = Mathf.Clamp01((float)visualTicksOpen / (float)TicksToOpenNow);
            float d = 0.45f * num;
            for (int i = 0; i < 2; i++)
            {
                Vector3 vector = default(Vector3);
                Mesh mesh;
                if (i == 0)
                {
                    vector = new Vector3(0f, 0f, -1f);
                    mesh = MeshPool.plane10;
                }
                else
                {
                    vector = new Vector3(0f, 0f, 1f);
                    mesh = MeshPool.plane10Flip;
                }
                Rot4 rotation = base.Rotation;
                rotation.Rotate(RotationDirection.Clockwise);
                vector = rotation.AsQuat * vector;
                Vector3 vector2 = DrawPos;
                vector2.y = AltitudeLayer.DoorMoveable.AltitudeFor();
                vector2 += vector * d;
                Graphics.DrawMesh(mesh, vector2, base.Rotation.AsQuat, Graphic.MatAt(base.Rotation), 0);
            }
            Comps_PostDraw();
        }

        public static Rot4 PalisadeDoorRotationAt(IntVec3 position, Map map)
        {
            int num = 0;
            int num2 = 0;
            num += AlignQualityAgainst(position + IntVec3.East, map);
            num += AlignQualityAgainst(position + IntVec3.West, map);
            num2 += AlignQualityAgainst(position + IntVec3.North, map);
            num2 += AlignQualityAgainst(position + IntVec3.South, map);
            if (num >= num2)
            {
                return Rot4.North;
            }
            return Rot4.East;
        }

        private static int AlignQualityAgainst(IntVec3 c, Map map)
        {
            if (!c.InBounds(map))
            {
                return 0;
            }
            if (!c.Walkable(map))
            {
                return 9;
            }
            List<Thing> thingList = c.GetThingList(map);
            for (int i = 0; i < thingList.Count; i++)
            {
                Thing thing = thingList[i];
                if (thing.def.graphicData != null && (int)(thing.def.graphicData.linkFlags & LinkFlags.Custom10) > 0)
                {
                    return 9;
                }
                if (typeof(Building_Door).IsAssignableFrom(thing.def.thingClass))
                {
                    return 1;
                }
                Thing thing2 = thing as Blueprint;
                if (thing2 != null)
                {
                    if (thing.def.graphicData != null && (int)(thing.def.graphicData.linkFlags & LinkFlags.Custom10) > 0)
                    {
                        return 9;
                    }
                    if (thing2.def.entityDefToBuild.passability == Traversability.Impassable)
                    {
                        return 9;
                    }
                    if (typeof(Building_Door).IsAssignableFrom(thing.def.thingClass))
                    {
                        return 1;
                    }
                }
            }
            return 0;
        }
    }
}
