﻿using RimWorld;
using UnityEngine;
using Verse;

namespace MedTimes
{
    class Building_VisibleTrap : Building_TrapDamager
    {                                       
        protected override float SpringChance(Pawn p)
        {
            float num = 1f;   
            
            if (p.Faction != null)
            {
                num = ((p.Faction != base.Faction) ? 0.3f : 0.005f);
            }
            else if (p.RaceProps.Animal)
            {
                num = 0.2f;
                num *= def.building.trapPeacefulWildAnimalsSpringChanceFactor;
            }
            else
            {
                num = 0.3f;
            }

            num *= this.GetStatValue(StatDefOf.TrapSpringChance);// * p.GetStatValue(StatDefOf.PawnTrapSpringChance);
            return Mathf.Clamp01(num);
        }

        public override ushort PathFindCostFor(Pawn p)
        {                      
            return (ushort)(80 * this.def.pathCost);
        }

        public override ushort PathWalkCostFor(Pawn p)
        {
            return (ushort)(80 * this.def.pathCost);
        }

        public override bool IsDangerousFor(Pawn p)
        {
            return true;
        }  
    }
}
