﻿using RimWorld;
using System;
using System.Collections.Generic;
using UnityEngine;
using Verse;
using Verse.AI;

namespace MedTimes
{
    class JobDriver_ReadSkillBook : JobDriver_ReadBook
    {
        protected override SkillDef GetBookSkill()
        {
            return BookSource.def.GetCompProperties<CompProperties_Book>().Skill;
        }

        public override bool TryMakePreToilReservations(bool errorOnFailed)
        {
            return base.TryMakePreToilReservations(errorOnFailed);
        }

        protected override void ReadTick(Pawn pawn, Thing bookSource, SkillDef skill, float extraJoyGainFactor = 1f, JoyTickFullJoyAction fullJoyAction = JoyTickFullJoyAction.EndJob)
        {
            Job curJob = pawn.CurJob;
            if (curJob.def.joyKind == null)
            {
                Log.Warning("This method can only be called for jobs with joyKind.");
                return;
            }
            if (bookSource != null)
            {
                // include passion and joygainfactor(quality) to factor skill income even more     
                extraJoyGainFactor *= bookSource.GetStatValue(ResourceBank.StatDefOf.BookQualityFactor);
            }

            if (skill != null)
            {
                var skillRecord = pawn.skills.GetSkill(skill);

                skillRecord.Learn(2 * extraJoyGainFactor * curJob.def.joyXpPerTick / (skillRecord.levelInt + 1));
            }

            pawn.needs.joy.GainJoy(extraJoyGainFactor * curJob.def.joyGainRate * 0.36f / 2500f, curJob.def.joyKind);
            if (curJob.def.joySkill != null)
            {
                pawn.skills.GetSkill(curJob.def.joySkill).Learn(curJob.def.joyXpPerTick);
            }
            if (!curJob.ignoreJoyTimeAssignment && !pawn.GetTimeAssignment().allowJoy)
            {
                pawn.jobs.curDriver.EndJobWith(JobCondition.InterruptForced);
            }
            if (pawn.needs.joy.CurLevel > 0.9999f)
            {
                switch (fullJoyAction)
                {
                    case JoyTickFullJoyAction.EndJob:
                        pawn.jobs.curDriver.EndJobWith(JobCondition.Succeeded);
                        break;
                    case JoyTickFullJoyAction.GoToNextToil:
                        pawn.jobs.curDriver.ReadyForNextToil();
                        break;
                }
            }
        }
    }
}
