﻿using RimWorld;
using System.Collections.Generic;
using Verse;
using Verse.AI;

namespace MedTimes
{
    public class JobDriver_RearmTrap : JobDriver
    {
        public override bool TryMakePreToilReservations(bool errorOnFailed)
        {
            Pawn pawn = base.pawn;
            LocalTargetInfo targetA = base.job.targetA;
            Job job = base.job;
            bool errorOnFailed2 = errorOnFailed;
            return pawn.Reserve(targetA, job, 1, -1, null, errorOnFailed2);
        }

        protected override IEnumerable<Toil> MakeNewToils()
        {
            this.FailOnDespawnedOrNull(TargetIndex.A);
            this.FailOn(delegate
            {
                Designation designation = Map.designationManager.DesignationOn(TargetThingA, ResourceBank.DesignationDefOf.Designtaion_RearmTrap);
                if (designation != null)
                {
                    return false;
                }
                return true;
            });
            yield return Toils_Goto.GotoThing(TargetIndex.A, PathEndMode.Touch);
            yield return Toils_General.Wait(150, TargetIndex.A)
                .FailOnCannotTouch(TargetIndex.A, PathEndMode.Touch)
                .WithProgressBarToilDelay(TargetIndex.A);
            Toil work = new Toil();
            work.initAction = delegate
            {
                Pawn actor = work.actor;
                Building_TrapRearmable building = actor.CurJob.targetA.Thing as Building_TrapRearmable;
                if (building != null) building.Armed = true;
                Map.designationManager.TryRemoveDesignationOn(building, ResourceBank.DesignationDefOf.Designtaion_RearmTrap);
            };
            work.defaultCompleteMode = ToilCompleteMode.Instant;
            yield return work;
        }
    }
}