﻿using RimWorld;        
using Verse;      

namespace MedTimes
{
    public class JobDriver_ViewIdolTynan : JobDriver_ViewIdol
    {                                                           
        protected override void DoFinishAction()
        {
            base.DoFinishAction();

            var value = Rand.Value;
            if (value < 0.2)
            {
                Hediff_MissingPart missing_part = null;

                foreach(var hediff in pawn.health.hediffSet.hediffs)
                {
                    if(hediff is Hediff_Injury inj)
                    {
                        if(hediff.Severity <= 0.3f)
                        {       
                            hediff.Heal(hediff.Severity);
                        }
                        else
                        {
                            hediff.Heal(0.3f);
                        }
                    }
                    else if (hediff is Hediff_MissingPart && missing_part == null)
                    {
                        missing_part = hediff as Hediff_MissingPart;  
                    }
                }                            

                bool parentIsMissing = false;
                do
                {   
                    parentIsMissing = false;
                    for (int i = 0; i < pawn.health.hediffSet.hediffs.Count; i++)
                    {
                        if (pawn.health.hediffSet.hediffs[i] is Hediff_MissingPart hediff_MissingPart && hediff_MissingPart.Part == missing_part.Part.parent)
                        {
                            missing_part = hediff_MissingPart;
                            parentIsMissing = true;
                        }
                    }
                }
                while (parentIsMissing);          

                pawn.health.hediffSet.hediffs.Remove(missing_part);         

                Hediff_Injury hediff_Injury = (Hediff_Injury)HediffMaker.MakeHediff(HediffDefOf.SurgicalCut, pawn);
                hediff_Injury.Part = missing_part.Part;
                hediff_Injury.source = ArtThing.def;
                hediff_Injury.Severity = missing_part.Part.def.GetMaxHealth(pawn) -1.0f;

                pawn.health.hediffSet.AddDirect(hediff_Injury);
            }       
               
        }
    }
}