﻿using MedTimes;
using RimWorld;
using System;
using System.Collections.Generic;
using UnityEngine;
using Verse;
using Verse.AI;
using Verse.Sound;

namespace MedTimes
{
    class JobDriver_ReadBook : IJobDriver_Read
    {       
        protected override Toil GetReadToil(int duration)
        {
            Toil readToil = new Toil();
            readToil.defaultDuration = duration;
            readToil.defaultCompleteMode = ToilCompleteMode.Delay;
            readToil.handlingFacing = true;
            readToil.initAction = delegate
            {                                                                                                    
                ResourceBank.SoundDefOf.BookPageFlips.PlayOneShot(new TargetInfo(this.pawn.Position, this.pawn.Map));      

                if (pawn.CurJob.GetTarget(ReadSurfaceIndex).IsValid)
                    this.pawn.rotationTracker.FaceCell(pawn.CurJob.GetTarget(ReadSurfaceIndex).Cell);
            };
            readToil.tickAction = delegate
            {
                this.pawn.GainComfortFromCellIfPossible();

                ReadTick(pawn, ReadItem, null, 1f, JoyTickFullJoyAction.GoToNextToil);
            };

            readToil.AddFinishAction(delegate
            {
                JoyUtility.TryGainRecRoomThought(pawn);
            });

            return readToil;
        }     

           
    }
}
