﻿using RimWorld;
using System.Collections.Generic;
using System.Linq;
using UnityEngine;
using Verse;
using Verse.AI;

namespace MedTimes
{
    abstract class IJoyGiver_SkillRead : IJoyGiver_Read
    {                                   
        protected override Thing GetDesiredReadSource(Pawn pawn)
        {                      
            GetInnerContainerSearchSet(pawn, tmpCandidates);

            if (tmpCandidates.Count > 0)
            {
                if (tmpCandidates.TryRandomElementByWeight(thing => BookUtilites.GetReadSourceWeight(thing, pawn), out Thing ret) && ret != null)
                {
                    return ret;
                }
                else
                {
                    return null;
                }
            }

            GetSearchSet(pawn, tmpCandidates);    

            return SelectBookSourceToRead(pawn, tmpCandidates);
        }

        

        protected virtual float ReadSourcePriority(Pawn pawn, Thing readSource)
        {
            float maxPriority = 0;

            if (readSource is Building_ContainerShelf bookshelf)
            {
                foreach (var book in bookshelf.GetDirectlyHeldThings())
                {
                    if (def.thingDefs.Contains(book.def))
                    {
                        maxPriority = Mathf.Max(BookUtilites.GetReadSourceWeight(book, pawn), maxPriority);
                    }
                }
            }
            else  
            if (def.thingDefs.Contains(readSource.def))
            {
                return BookUtilites.GetReadSourceWeight(readSource, pawn);
            }  

            return maxPriority;
        }

        protected override Thing SelectBookSourceToRead(Pawn pawn, List<Thing> candidates)
        {
            IntVec3 position = pawn.Position;
            Map map = pawn.Map;
            List<Thing> searchSet = tmpCandidates;
            PathEndMode peMode = PathEndMode.OnCell;
            TraverseParms traverseParams = TraverseParms.For(pawn);
            Thing result = GenClosest.ClosestThing_Global_Reachable(
                position,
                map,
                searchSet,
                peMode,
                traverseParams,
                9999f,
                thing => thing.Spawned && !thing.IsForbidden(pawn),
                thing => ReadSourcePriority(pawn, thing));   

            return result;
        }
    }
}
