﻿using RimWorld;
using System;
using System.Collections.Generic;
using System.Linq;
using Verse;
using Verse.AI;

namespace MedTimes
{
    class JoyGiver_ReadNote : IJoyGiver_Read
    {
        JobDef jobDef = ResourceBank.JobDefOf.ReadNote;

        protected override Job CreateReadJob(Thing readSource, Pawn pawn)
        {
            if (readSource.IsForbidden(pawn)) return null;
            Job job = null;

            if (readSource is Building_ContainerShelf shelf)
            {
                var innerContainer = shelf.GetDirectlyHeldThings();

                Thing thingToRead = innerContainer.Where(t => def.thingDefs.Contains(t.def)).RandomElement();

                job = new Job(jobDef, readSource, thingToRead)
                {
                    count = Math.Min((jobDef.joyDuration / ResourceBank.Numbers.TicksToDestroyScroll) * 2 + 1, thingToRead.stackCount)
                };
            }
            else
            {
                job = new Job(jobDef, null, readSource)
                {
                    count = Math.Min((jobDef.joyDuration / ResourceBank.Numbers.TicksToDestroyScroll) * 2 + 1, readSource.stackCount)
                };
            }

            return job;     
        }   
    }
}
