﻿using UnityEngine;
using Verse;

namespace MedTimes
{
    public class PlaceWorker_NotOnStone : PlaceWorker
    {
        public override void DrawGhost(ThingDef def, IntVec3 center, Rot4 rot, Color ghostCol)
        {
            base.DrawGhost(def, center, rot, ghostCol);
        }

        public override AcceptanceReport AllowsPlacing(BuildableDef def, IntVec3 center, Rot4 rot, Map map, Thing thingToIgnore = null)
        {
            foreach (var current in GenAdj.OccupiedRect(center, rot, def.Size))
            {                                         
                if (ResourceBank.NaturalRockTerrain.Contains(map.terrainGrid.TerrainAt(current)))
                {
                    return ResourceBank.Strings.CannotPlaceOnStone.Translate();
                }                      
            }
            return true;
        }
    }
}
