﻿using RimWorld;
using System.Collections.Generic;
using System.Linq;
using UnityEngine;
using Verse;

namespace MedTimes
{
    public class PlaceWorker_NotOnThing : PlaceWorker
    {                                                         
        public override void DrawGhost(ThingDef def, IntVec3 center, Rot4 rot, Color ghostCol)
        {
            base.DrawGhost(def, center, rot, ghostCol);
        }

        private static bool IsOccupiedlayer(AltitudeLayer layer)
        {
            return                                     
                layer == AltitudeLayer.Terrain ||
                layer == AltitudeLayer.TerrainScatter ||
                layer == AltitudeLayer.Floor ||
                layer == AltitudeLayer.FloorEmplacement;
        }

        public override AcceptanceReport AllowsPlacing(BuildableDef def, IntVec3 center, Rot4 rot, Map map, Thing thingToIgnore = null)
        {
            foreach (var current in GenAdj.OccupiedRect(center, rot, def.Size))
            {
                if (map.thingGrid.ThingsListAt(current).Any(t => IsOccupiedlayer(t.def.altitudeLayer)))
                {
                    return ResourceBank.Strings.NeedEmptyPlace.Translate();
                }
            }
            return true;
        }
    }
}
