﻿using Verse;

namespace MedTimes
{

    public class PlaceWorker_UnderRoof : PlaceWorker
    {                                                       
        public override AcceptanceReport AllowsPlacing(BuildableDef def, IntVec3 loc, Rot4 rot, Map map, Thing thingToIgnore = null)
        {           
            foreach (IntVec3 current in GenAdj.CellsOccupiedBy(loc, rot, def.Size))
            {
                if (!map.roofGrid.Roofed(current))
                {
                    return new AcceptanceReport(ResourceBank.Strings.RoofRequired.Translate(def.LabelCap));
                }
            }

            return true;
        }
    }
}
