﻿using RimWorld;
using System;
using System.Collections.Generic;
using System.Linq;
using Verse;

namespace MedTimes
{
    public static class ResourceBank
    {
        private static List<TerrainDef> naturalRockTerrain = null;
        private static List<TerrainDef> naturalWaterTerrain = null;

        public static List<TerrainDef> NaturalRockTerrain
        {
            get
            {
                if (naturalRockTerrain == null)
                {
                    naturalRockTerrain = DefDatabase<ThingDef>.AllDefs.Where(def => def.building?.naturalTerrain != null).SelectMany(def => GetRockTerrainVariants(def)).ToList();
                }
                return naturalRockTerrain;
            }
        }

        public static List<TerrainDef> NaturalWaterTerrain
        {
            get
            {
                if (naturalWaterTerrain == null)
                {
                    naturalWaterTerrain = DefDatabase<TerrainDef>.AllDefs.Where(def => def.tags?.Any(tag => tag.IndexOf("water", StringComparison.OrdinalIgnoreCase) > -1) == true).ToList();
                }
                return naturalWaterTerrain;
            }
        }

        static IEnumerable<TerrainDef> GetRockTerrainVariants(ThingDef naturalTerrainThing)
        {
            if (naturalTerrainThing.building.naturalTerrain != null)
            {
                yield return naturalTerrainThing.building.naturalTerrain;

                if (naturalTerrainThing.building.naturalTerrain.smoothedTerrain != null)
                {
                    yield return naturalTerrainThing.building.naturalTerrain.smoothedTerrain;
                }
            }

            if (naturalTerrainThing.building.leaveTerrain != null)
            {
                yield return naturalTerrainThing.building.leaveTerrain;
            }
        }

        [DefOf]
        public static class DesignationDefOf
        {
            public static DesignationDef Designtaion_RearmTrap;
        }

        [DefOf]
        public static class ThingDefOf
        {
            public static ThingDef Milk;
            public static ThingDef MedTimes_MealCheese;
            public static ThingDef MedTimes_CheesePress;
            public static ThingDef MedTimes_StoneQuarry;
            public static ThingDef MedTimes_BookShelf;
        }

        [DefOf]
        public static class JobDefOf
        {
            public static JobDef RearmTrap;
            public static JobDef WorkAtQuarry;
            public static JobDef ReadNote;
            public static JobDef ReadSkillNote;
            public static JobDef ReadBook;
            public static JobDef ReadSkillBook;
            public static JobDef WriteBook;
            public static JobDef FillCheesePress;
            public static JobDef TakeCheeseOutOfCheesePress;
        }

        [DefOf]
        public static class JoyGiverDefOf
        {
            public static JoyGiverDef MedTimes_Use_SkillNoteReading;
            public static JoyGiverDef MedTimes_Use_NoteReading;
            public static JoyGiverDef MedTimes_Use_SkillBookReading;
            public static JoyGiverDef MedTimes_Use_BookReading;
        }

        [DefOf]
        public static class StatDefOf
        {
            public static StatDef ComposingQuality;
            public static StatDef BookQualityFactor;
            public static StatDef BookChairSearchRadius;
        }

        [DefOf]
        public static class SoundDefOf
        {
            public static SoundDef BookPageFlips;
        }

        public static class Numbers
        {
            public static int TicksToDestroyScroll = 1500;
            public static float ChanceToDestroyScroll = 0.5f;
        }

        public static class Strings
        {
            public static string DeepDrillNoResources = "DeepDrillNoResources";
            public static string ResourceBelow = "ResourceBelow";
            public static string ProgressToNextPortion = "ProgressToNextPortion";
            public static string BadTemperature = "BadTemperature";
            public static string MissingMaterials = "MissingMaterials";
            public static string Temperature = "Temperature";
            public static string CommandAutoRearm = "CommandAutoRearm";
            public static string CommandAutoRearmDesc = "CommandAutoRearmDesc";

            public static string ContainsCheese = "ContainsCheese";
            public static string ContainsMilk = "ContainsMilk";
            public static string Coagulated = "Coagulated";
            public static string NoMilk = "NoMilk";
            public static string CoagulationProgress = "CoagulationProgress";
            public static string CheesePressOutOfIdealTemperature = "CheesePressOutOfIdealTemperature";
            public static string IdealCoagulationTemperature = "IdealCoagulationTemperature";
            public static string NeedPlaceOnStone = "NeedPlaceOnStone";
            public static string NeedEmptyPlace = "NeedEmptyPlace";
            public static string CannotPlaceOnStone = "CannotPlaceOnStone";
            public static string NeedPlaceNearWater = "NeedPlaceNearWater";
            public static string TimeToDry = "TimeToDry";

            public static string MustDesignateRearmable = "MessageMustDesignateRearmable";
            public static string CommandRearmTrap = "CommandRearmTrap";
            public static string CommandRearmTrapDesc = "CommandRearmTrapDesc";
            public static string CommandHuntOnSpring = "DesignatorHuntOnSpring";
            public static string CommandHuntOnSpringDesc = "DesignatorHuntOnSpringDesc";

            public static string NeedTerrain = "NeedTerrain";

            public static string BookCaseInventoryLabel = "BookCaseInventory_Label";
            public static string RoofRequired = "RoofRequired";

        }
    }
}