﻿using RimWorld;
using System;
using UnityEngine;
using Verse;
using Verse.AI;

namespace MedTimes
{
    public class Building_TurretGunRotableCell : Building_TurretGun
    {
        protected int TicksSinceCheck = 0;

        protected IntVec3 LastInteractionCell;  

        public override IntVec3 InteractionCell => LastInteractionCell;

        //rotates interaction cell around center
        private IntVec3 GetInteractionCellFromTarget(ThingDef def, LocalTargetInfo currentTarget)
        {
            if (!def.hasInteractionCell) return Position;

            var interactionCellVector = (def.interactionCellOffset.ToVector3().RotatedBy((Position - currentTarget.Cell).AngleFlat + 180));

            var cellVector = Position.ToVector3() + new Vector3((float)Math.Round(interactionCellVector.x, 0), (float)Math.Round(interactionCellVector.y, 0), (float)Math.Round(interactionCellVector.z, 0));

            var NewInteractionCell = cellVector.ToIntVec3();

            return NewInteractionCell;                           
        }

        public override void SpawnSetup(Map map, bool respawningAfterLoad)
        {
            base.SpawnSetup(map, respawningAfterLoad);
            if(!respawningAfterLoad)
            {
                LastInteractionCell = Position + def.interactionCellOffset.RotatedBy(Rotation); 
            }                                                                      
        }

        public override void ExposeData()
        {
            base.ExposeData();
                                                                                     
            Scribe_Values.Look(ref TicksSinceCheck, "TicksSinceCheck", defaultValue: 0);
            Scribe_Values.Look(ref LastInteractionCell, "LastInteractionCell", defaultValue: Position);
        }

        public override void Tick()
        {
            base.Tick();
            if(TicksSinceCheck < 30) ++TicksSinceCheck;
            if (Spawned && mannableComp != null && mannableComp.ManningPawn != null)
            {             
                if (TicksSinceCheck > 20)
                {
                    TicksSinceCheck = 0;
                    UpdateInteractionCell();
                }
            }
        }

        protected virtual void UpdateInteractionCell()
        {
            if (CurrentTarget == LocalTargetInfo.Invalid) return;   

            var NewInteractionCell = GetInteractionCellFromTarget(def, CurrentTarget);

            if (NewInteractionCell != LastInteractionCell)
            {
                LastInteractionCell = NewInteractionCell;

                Job job = new Job(JobDefOf.ManTurret, this);
                job.playerForced = mannableComp.ManningPawn.jobs.curJob.playerForced;
                mannableComp.ManningPawn.jobs.StartJob(job, JobCondition.Ongoing);
            }
        }
    }
}
