﻿using RimWorld;
using UnityEngine;
using Verse;

namespace MedTimes
{
    [StaticConstructorOnStartup]
    class FireOverlayFlickable : ThingComp
    {
        protected CompRefuelable refuelableComp;

        protected CompFlickable flickableComp;

        public static readonly Graphic FireGraphic = GraphicDatabase.Get<Graphic_Flicker>("Things/Special/Fire", ShaderDatabase.TransparentPostLight, Vector2.one, Color.white);

        public CompProperties_FireOverlayFlickable Props => (CompProperties_FireOverlayFlickable)props;

        public override void PostDraw()
        {
            base.PostDraw();
            if (refuelableComp == null || refuelableComp.HasFuel 
                && (flickableComp == null || flickableComp.SwitchIsOn))
            {
                Vector3 drawPos = parent.DrawPos;
                drawPos.y += 0.046875f;
                FireGraphic.Draw(drawPos, Rot4.North, parent);
            }
        }

        public override void PostSpawnSetup(bool respawningAfterLoad)
        {
            base.PostSpawnSetup(respawningAfterLoad);
            refuelableComp = parent.GetComp<CompRefuelable>();
            flickableComp = parent.GetComp<CompFlickable>();
        }
    }
}
