﻿using RimWorld;
using System;
using System.Collections.Generic;
using System.Linq;
using UnityEngine;
using Verse;
using Verse.AI;

namespace MedTimes
{
    public class JobDriver_ViewIdol : JobDriver
    {
        protected const TargetIndex TargetThingIndex = TargetIndex.A;      
        protected Thing ArtThing => job.GetTarget(TargetThingIndex).Thing;

        public override bool TryMakePreToilReservations(bool errorOnFailed)
        {
            return pawn.Reserve(job.GetTarget(TargetIndex.A), job, 1, -1, null, errorOnFailed);
        }

        protected override IEnumerable<Toil> MakeNewToils()
        {
            this.FailOnDestroyedNullOrForbidden(TargetIndex.A);
            yield return Toils_Goto.GotoThing(TargetIndex.A, PathEndMode.Touch);
            Toil toil = Toils_General.Wait(job.def.joyDuration);
            toil.FailOnCannotTouch(TargetIndex.A, PathEndMode.Touch);
            toil.tickAction = delegate
            {
                WaitTickAction();
            };
            toil.AddFinishAction(delegate
            {
                if ((Find.TickManager.TicksGame - job.startTick) > (this.job.def.joyDuration * 0.75)) DoFinishAction();
                JoyUtility.TryGainRecRoomThought(pawn);
            });
            yield return toil;
        }


        protected virtual void WaitTickAction()
        {
            float num = ArtThing.GetStatValue(StatDefOf.Beauty) / ArtThing.def.GetStatValueAbstract(StatDefOf.Beauty);
            float extraJoyGainFactor = (num > 0f) ? num : 0f;
            pawn.GainComfortFromCellIfPossible();
            JoyUtility.JoyTickCheckEnd(pawn);
        }

        protected virtual void DoFinishAction()
        {
            var memories = pawn.needs.mood.thoughts.memories.Memories;

            foreach (var thought in memories)
            {
                if(thought.MoodOffset() < 0 && Rand.Value < 0.3)
                {
                    if((thought.def.DurationTicks - thought.age) < 60000 * 4)
                    {
                        thought.age = thought.def.DurationTicks-1;
                    }
                    else
                    {
                        thought.age += (thought.def.DurationTicks - thought.age) / 2;
                    }
                }
            }
        }
    }
}