﻿using RimWorld;
using System;
using Verse;

namespace MedTimes
{
    public class JobDriver_ViewIdolPangLi : JobDriver_ViewIdol
    {                                                           
        protected override void DoFinishAction()
        {
            base.DoFinishAction();

            foreach(var hediff in pawn.health.hediffSet.hediffs)
            {
                if(hediff is Hediff_Injury inj)
                {
                    if(hediff.Severity > 0.3f)
                    {     
                        hediff.Heal(Math.Max(hediff.Severity / 3, 0.3f));
                    }  
                }
            }   

            if (Rand.Value < 0.2)
            {
                pawn.skills.Learn(SkillDefOf.Melee, 1000f, true);
            }      
           
        }
    }
}