﻿using RimWorld;
using System.Collections.Generic;
using Verse;
using Verse.AI;

namespace MedTimes
{
    public class JobDriver_WorkAtQuarry : JobDriver
    {
        public override bool TryMakePreToilReservations(bool errorOnFailed)
        {
            Pawn pawn = base.pawn;
            LocalTargetInfo targetA = base.job.targetA;
            Job job = base.job;
            bool errorOnFailed2 = errorOnFailed;
            return pawn.Reserve(targetA, job, 1, -1, null, errorOnFailed2);
        }

        protected override IEnumerable<Toil> MakeNewToils()
        {
            this.FailOnDespawnedNullOrForbidden(TargetIndex.A);
            this.FailOnBurningImmobile(TargetIndex.A);
            this.FailOnThingHavingDesignation(TargetIndex.A, DesignationDefOf.Uninstall);
            this.FailOn(delegate
            {
                CompQuarryWorker compQuarry = job.targetA.Thing.TryGetComp<CompQuarryWorker>();
                return !compQuarry.CanMineNow();
            });
            yield return Toils_Goto.GotoThing(TargetIndex.A, PathEndMode.InteractionCell);
            Toil work = new Toil();
            work.tickAction = delegate
            {
                Pawn actor = work.actor;
                Building building = (Building)actor.CurJob.targetA.Thing;
                CompQuarryWorker comp = building.GetComp<CompQuarryWorker>();
                comp.MineWorkDone(actor);
                actor.skills.Learn(SkillDefOf.Mining, 0.065f);
            };
            work.defaultCompleteMode = ToilCompleteMode.Never;    
            work.FailOnCannotTouch(TargetIndex.A, PathEndMode.InteractionCell);
            work.activeSkill = (() => SkillDefOf.Mining);
            yield return work;
        }
    }
}      