﻿using RimWorld;
using System;
using System.Collections.Generic;
using UnityEngine;
using Verse;
using Verse.AI;
using Verse.Sound;

namespace MedTimes
{
    class JobDriver_ReadNote : IJobDriver_Read
    {
        protected int LastExaustTick = -1;
                             
        public override void ExposeData()
        {
            base.ExposeData();                                                                          
            Scribe_Values.Look(ref LastExaustTick, "ExaustTicks", defaultValue: -1);         
        }     

        protected override Toil InitRead()
        {
            Toil toil = new Toil()
            {
                defaultCompleteMode = ToilCompleteMode.Instant,
                initAction = delegate
                {
                    LastExaustTick = Find.TickManager.TicksGame;
                    if (ReadItem.Spawned)
                    {
                        ReadItem.Map.physicalInteractionReservationManager.Reserve(pawn, pawn.CurJob, ReadItem);
                    }
                }  
            };                           
            return toil;
        }

        protected override Toil GetReadToil(int duration)
        {                                        
            Toil readToil = new Toil();

            readToil.defaultDuration = duration;
            readToil.defaultCompleteMode = ToilCompleteMode.Delay;
            readToil.handlingFacing = true;
            readToil.initAction = delegate
            {                                                            
                ResourceBank.SoundDefOf.BookPageFlips.PlayOneShot(new TargetInfo(this.pawn.Position, this.pawn.Map));

                if (pawn.CurJob.GetTarget(ReadSurfaceIndex).IsValid)
                    this.pawn.rotationTracker.FaceCell(pawn.CurJob.GetTarget(ReadSurfaceIndex).Cell);
            };
            readToil.tickAction = delegate
            {                  
                this.pawn.GainComfortFromCellIfPossible();  

                ReadTick(pawn, ReadItem, null, 1f, JoyTickFullJoyAction.GoToNextToil);
            };                 

            readToil.AddFinishAction(delegate
            {
                JoyUtility.TryGainRecRoomThought(pawn);    
            });
            readToil.AddFinishAction(delegate
            {
                if (LastExaustTick + ResourceBank.Numbers.TicksToDestroyScroll < Find.TickManager.TicksGame)

                    LastExaustTick = Find.TickManager.TicksGame;

                if (Rand.Value < ResourceBank.Numbers.ChanceToDestroyScroll)
                {
                    Thing thing = job.GetTarget(TargetIndex.A).Thing;
                    if (thing.stackCount == 1)
                    {
                        thing.Destroy();
                        pawn.jobs.EndCurrentJob(JobCondition.InterruptForced);
                    }
                    else
                    {
                        --thing.stackCount;
                    }
                }
            });                

            return readToil;
        }  
    }
}
