﻿using RimWorld;
using System.Collections.Generic;
using System.Linq;
using Verse;
using Verse.AI;

namespace MedTimes
{
    abstract class IJoyGiver_Read : JoyGiver
    {        
        protected static List<Thing> tmpCandidates = new List<Thing>();

        public override Job TryGiveJobInGatheringArea(Pawn pawn, IntVec3 gatherSpot)
        {
            return null;
        }      

        public override Job TryGiveJob(Pawn pawn)
        {
            tmpCandidates.Clear();
            Thing book = GetDesiredReadSource(pawn);

            if (book != null)
            {
                return CreateReadJob(book, pawn);
            }
            return null;
        }

        protected abstract Job CreateReadJob(Thing book, Pawn pawn);


        protected virtual void GetInnerContainerSearchSet(Pawn pawn, List<Thing> outCandidates)
        {
            outCandidates.Clear();
            if (def.thingDefs == null)
            {
                return;
            }

            if (def.thingDefs.Count == 1)
            {
                outCandidates.AddRange(pawn.inventory.innerContainer
                    .InnerListForReading.Where(thing => thing.def == def.thingDefs[0]));
                return;
            }

            for (int i = 0; i < def.thingDefs.Count; i++)
            {
                outCandidates.AddRange(pawn.inventory.innerContainer
                   .InnerListForReading.Where(thing => def.thingDefs.Contains(thing.def)));
            }
        }

        protected override void GetSearchSet(Pawn pawn, List<Thing> outCandidates)
        {
            base.GetSearchSet(pawn, outCandidates);

            outCandidates.AddRange(pawn.Map.listerThings.AllThings.FindAll(y => y is Building_ContainerShelf).Where(delegate (Thing x)
            {
                Building_ContainerShelf building_bookcase = (Building_ContainerShelf)x;
                return x.Faction == Faction.OfPlayer && !x.IsForbidden(pawn) &&
                (building_bookcase?.GetDirectlyHeldThings()?.Any(t => def.thingDefs.Contains(t.def)) == true) &&
                pawn.CanReserveAndReach(x, PathEndMode.Touch, Danger.None, 1, -1, null, false) && building_bookcase.IsPoliticallyProper(pawn);
            }));
        }
                               
        protected virtual Thing GetDesiredReadSource(Pawn pawn)
        {                      
            GetInnerContainerSearchSet(pawn, tmpCandidates);

            if (tmpCandidates.Count > 0)
            {
                return tmpCandidates[(int)(tmpCandidates.Count()*Rand.Value)];
            }

            GetSearchSet(pawn, tmpCandidates);    

            return SelectBookSourceToRead(pawn, tmpCandidates);
        }

        protected virtual Thing SelectBookSourceToRead(Pawn pawn, List<Thing> candidates)
        {
            IntVec3 position = pawn.Position;
            Map map = pawn.Map;
            List<Thing> searchSet = tmpCandidates;
            PathEndMode peMode = PathEndMode.OnCell;
            TraverseParms traverseParams = TraverseParms.For(pawn);
            Thing result = GenClosest.ClosestThing_Global_Reachable(
                position,
                map,
                searchSet,
                peMode,
                traverseParams,
                9999f,
                thing => thing.Spawned && !thing.IsForbidden(pawn));   

            return result;
        }
    }
}
