﻿using RimWorld;
using System.Collections.Generic;
using System.Linq;
using Verse;
using Verse.AI;

namespace MedTimes
{
    class JoyGiver_ReadBook : IJoyGiver_Read
    {
        JobDef jobDef = ResourceBank.JobDefOf.ReadBook;

        protected override Job CreateReadJob(Thing readSource, Pawn pawn)
        {
            if (readSource.IsForbidden(pawn)) return null;
            Job job = null;

            if (readSource is Building_ContainerShelf shelf)
            {
                var innerContainer = shelf.GetDirectlyHeldThings();

                Thing bookToRead = innerContainer.Where(t => def.thingDefs.Contains(t.def)).RandomElement();

                job = new Job(jobDef, readSource, bookToRead)
                {
                    count = 1
                };
            }
            else
            {
                job = new Job(jobDef, null, readSource)
                {
                    count = 1
                };
            }
                    
            return job;
        }
    }
}
