﻿using RimWorld;
using System.Collections.Generic;
using System.Linq;
using UnityEngine;
using Verse;

namespace MedTimes
{
    public class PlaceWorker_NearbyWater : PlaceWorker
    {

        public override void DrawGhost(ThingDef def, IntVec3 center, Rot4 rot, Color ghostCol, Thing thing = null)
        {
            base.DrawGhost(def, center, rot, ghostCol, thing);
        }

        public override AcceptanceReport AllowsPlacing(BuildableDef def, IntVec3 center, Rot4 rot, Map map, Thing thingToIgnore = null, Thing thing = null)
        {                   
            foreach (var current in GenAdj.OccupiedRect(center, rot, def.Size).AdjacentCellsCardinal)
            {                
                if (current.InBounds(map) && ResourceBank.NaturalWaterTerrain.Contains(map.terrainGrid.TerrainAt(current)))
                {
                    return true;
                }                         
            }
            return ResourceBank.Strings.NeedPlaceNearWater.Translate();
        }
    }
}
