﻿using System.Collections.Generic;
using System.Linq;
using UnityEngine;
using Verse;

namespace MedTimes
{
    public class PlaceWorker_OnNaturalStone : PlaceWorker
    {
        public override void DrawGhost(ThingDef def, IntVec3 center, Rot4 rot, Color ghostCol, Thing thing = null)
        {
            base.DrawGhost(def, center, rot, ghostCol, thing);
        }

        public override AcceptanceReport AllowsPlacing(BuildableDef def, IntVec3 center, Rot4 rot, Map map, Thing thingToIgnore = null, Thing thing = null)
        {   
            foreach(var current in GenAdj.OccupiedRect(center, rot, def.Size)) 
            {                                         
                if (!ResourceBank.NaturalRockTerrain.Contains(map.terrainGrid.TerrainAt(current)))
                {                  
                    return ResourceBank.Strings.NeedPlaceOnStone.Translate();
                }                       
            }
            return true;
        }  
    }
}
