﻿using System.Collections.Generic;
using System.Linq;
using UnityEngine;
using Verse;

namespace MedTimes
{
    public class PlaceWorker_Terraforming : PlaceWorker
    {
        public override void DrawGhost(ThingDef def, IntVec3 center, Rot4 rot, Color ghostCol, Thing thing = null)
        {
            base.DrawGhost(def, center, rot, ghostCol, thing);
        }

        public override AcceptanceReport AllowsPlacing(BuildableDef def, IntVec3 center, Rot4 rot, Map map, Thing thingToIgnore = null, Thing thing = null)
        {                   
            if(def is TerraformDef terraDef)
            {
                TerrainDef terrain = map.terrainGrid.TerrainAt(center);
                                                                            
                if (terrain != null && !terraDef.SourceTerrain.Contains(terrain)) return false;

                if (terraDef.RequiresAdjancentTerrain != null && terraDef.RequiresAdjancentTerrain?.Count > 0)
                {
                    foreach(var cell in GenAdj.CellsAdjacentCardinal(center, rot, def.Size))
                    {
                        terrain = map.terrainGrid.TerrainAt(cell);
                        if(terrain != null && terraDef.RequiresAdjancentTerrain.Contains(terrain)) return true;
                    }    
                    
                    return false;
                }

                return true;  
            }          

            return true;  
        }  
    }
}
