﻿using RimWorld;
using System;
using System.Collections.Generic;
using System.Linq;
using Verse;

namespace MedTimes
{                                  
    public static class BookUtilites
    {
        public static float GetReadSourceWeight(Thing thing, Pawn pawn)
        {
            var skill = thing.def.GetCompProperties<CompProperties_Book>()?.Skill;

            var pawnSkill = pawn.skills.GetSkill(skill);

            if (pawnSkill.TotallyDisabled) return 0;

            float joyGain = thing.GetStatValue(StatDefOf.JoyGainFactor);

            var passion = pawnSkill.passion;
            switch (passion)
            {
                case Passion.Major:
                    joyGain *= 4.5f;
                    break;
                case Passion.Minor:
                    joyGain *= 2.5f;
                    break;
                case Passion.None:
                    joyGain *= 0.5f;
                    break;
            }

            joyGain *= (20 - pawnSkill.Level);

            return joyGain;
        }

    }
}