﻿using RimWorld;
using System;
using System.Collections.Generic;
using System.Linq;
using Verse;

namespace MedTimes
{
    public class ThingStackOwner<T> : ThingOwner<T> where T : Thing
    {
        public ThingStackOwner()
        {
            maxStacks = 20;
        }

        public ThingStackOwner(IThingHolder owner) : base(owner)
        {
            maxStacks = 20;
        }

        public ThingStackOwner(IThingHolder owner, int stackCount = 20, LookMode contentsLookMode = LookMode.Deep) : base(owner, stackCount == 1, contentsLookMode)
        {
            maxStacks = stackCount;
        }

        public void SetMaxStacks(int stack)
        {
            maxStacks = stack;
        }
    }
}