﻿using RimWorld;
using System;
using Verse;
using Verse.AI;

namespace MedTimes
{
    class WorkGiver_FillCheesePress : WorkGiver_Scanner
    {                      
       private static string TemperatureTrans = ResourceBank.Strings.BadTemperature.Translate().ToLower();

        private static string NoCheeseTrans = ResourceBank.Strings.NoMilk.Translate();

        public override ThingRequest PotentialWorkThingRequest => ThingRequest.ForDef(ResourceBank.ThingDefOf.MedTimes_CheesePress);

        public override PathEndMode PathEndMode => PathEndMode.Touch; 

        public override bool HasJobOnThing(Pawn pawn, Thing t, bool forced = false)
        {
            Building_CheesePress building_CheesePress = t as Building_CheesePress;
            if (building_CheesePress == null || building_CheesePress.Coagulated || building_CheesePress.SpaceLeftForMilk <= 0)
            {
                return false;
            }
            float ambientTemperature = building_CheesePress.AmbientTemperature;
            CompProperties_TemperatureRuinable compProperties = building_CheesePress.def.GetCompProperties<CompProperties_TemperatureRuinable>();
            if (ambientTemperature < compProperties.minSafeTemperature + 2f || ambientTemperature > compProperties.maxSafeTemperature - 2f)
            {
                JobFailReason.Is(TemperatureTrans);
                return false;
            }
            if (!t.IsForbidden(pawn))
            {
                LocalTargetInfo target = t;
                bool ignoreOtherReservations = forced;
                if (pawn.CanReserve(target, 1, -1, null, ignoreOtherReservations))
                {
                    if (pawn.Map.designationManager.DesignationOn(t, DesignationDefOf.Deconstruct) != null)
                    {
                        return false;
                    }
                    Thing thing = FindCheese(pawn, building_CheesePress);
                    if (thing == null)
                    {
                        JobFailReason.Is(NoCheeseTrans);
                        return false;
                    }
                    if (t.IsBurning())
                    {
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }

        public override Job JobOnThing(Pawn pawn, Thing t, bool forced = false)
        {
            Building_CheesePress press = (Building_CheesePress)t;
            Thing t2 = FindCheese(pawn, press);
            return new Job(ResourceBank.JobDefOf.FillCheesePress, t, t2);
        }

        private Thing FindCheese(Pawn pawn, Building_CheesePress cheesePress)
        {
            Predicate<Thing> predicate = delegate (Thing x)
            {
                if (x.IsForbidden(pawn) || !pawn.CanReserve(x))
                {
                    return false;
                }
                return true;
            };
            IntVec3 position = pawn.Position;
            Map map = pawn.Map;
            ThingRequest thingReq = ThingRequest.ForDef(ResourceBank.ThingDefOf.Milk);
            PathEndMode peMode = PathEndMode.ClosestTouch;
            TraverseParms traverseParams = TraverseParms.For(pawn);
            Predicate<Thing> validator = predicate;
            return GenClosest.ClosestThingReachable(position, map, thingReq, peMode, traverseParams, 9999f, validator);
        }
    }
}
