﻿using RimWorld;   
using System.Collections.Generic;
using System.Linq;     
using Verse;
using Verse.AI;
   
namespace MedTimes
{
    public class WorkGiver_WorkAtQuarry : WorkGiver_Scanner
    {
        public override ThingRequest PotentialWorkThingRequest => ThingRequest.ForDef(ResourceBank.ThingDefOf.MedTimes_StoneQuarry);

        public override PathEndMode PathEndMode => PathEndMode.InteractionCell;

        public override Danger MaxPathDanger(Pawn pawn)
        {
            return Danger.Deadly;
        }

        public override IEnumerable<Thing> PotentialWorkThingsGlobal(Pawn pawn)
        {
            return pawn.Map.listerBuildings.AllBuildingsColonistOfDef(ResourceBank.ThingDefOf.MedTimes_StoneQuarry).Cast<Thing>();
        }

        public override bool ShouldSkip(Pawn pawn, bool forced = false)
        {
            List<Building> allBuildingsColonist = pawn.Map.listerBuildings.allBuildingsColonist;
            for (int i = 0; i < allBuildingsColonist.Count; i++)
            {
                Building building = allBuildingsColonist[i];
                if (building.def == ResourceBank.ThingDefOf.MedTimes_StoneQuarry)
                {
                    CompQuarryWorker compQuarry = building.TryGetComp<CompQuarryWorker>();
                    if (compQuarry != null && compQuarry.CanMineNow() 
                        && building.Map.designationManager.DesignationOn(building, DesignationDefOf.Uninstall) == null
                        && pawn.CanReserve(building, 1, -1, null, false))
                    {
                        return false;
                    }
                }
            }
            return true;
        }

        public override bool HasJobOnThing(Pawn pawn, Thing t, bool forced = false)
        {
            if (t.Faction != pawn.Faction)
            {
                return false;
            }
            Building building = t as Building;
            if (building == null)
            {
                return false;
            }
            if (building.IsForbidden(pawn))
            {
                return false;
            }
            LocalTargetInfo target = building;
            bool ignoreOtherReservations = forced;
            if (!pawn.CanReserve(target, 1, -1, null, ignoreOtherReservations))
            {
                return false;
            }
            CompQuarryWorker compQuarry = building.TryGetComp<CompQuarryWorker>();
            if (!compQuarry.CanMineNow())
            {
                return false;
            }
            if (building.Map.designationManager.DesignationOn(building, DesignationDefOf.Uninstall) != null)
            {
                return false;
            }
            if (building.IsBurning())
            {
                return false;
            }          
            if((building as IBillGiver)?.BillStack?.AnyShouldDoNow == false)
            {
                return false;
            }

            return true;
        }

        public override Job JobOnThing(Pawn pawn, Thing t, bool forced = false)
        {
            return new Job(ResourceBank.JobDefOf.WorkAtQuarry, t, 1500, checkOverrideOnExpiry: true);
        }

    }
}
