﻿using RimWorld;
using System.Collections.Generic;
using Verse;

namespace MedTimes
{
    class Building_ContainerShelf : Building, IThingHolder, IStoreSettingsParent, IHaulDestination
    {
        protected ThingStackOwner<Thing> innerContainer;
        private StorageSettings storageSettings;   

        public bool StorageTabVisible => true;


        public bool Accepts(Thing thing)
        {
            if (!this.storageSettings.AllowedToAccept(thing))
            {
                return false;
            }

            if (!this.innerContainer.CanAcceptAnyOf(thing))
            {
                return false;
            }
            return true;
        }           

        public Building_ContainerShelf() : base()
        {                                                                                                                  
            this.innerContainer = new ThingStackOwner<Thing>(this, 20, LookMode.Deep);
        }       

        public override void Destroy(DestroyMode mode = DestroyMode.Vanish)
        {
            base.Destroy(mode);

            if(mode != DestroyMode.Vanish)
            {
                innerContainer?.TryDropAll(this.Position, this.Map, ThingPlaceMode.Near);
            }
        }

        public override void PostMake()
        {
            base.PostMake();
            this.storageSettings = new StorageSettings(this);
            if (this.def.building.defaultStorageSettings != null)
            {
                this.storageSettings.CopyFrom(this.def.building.defaultStorageSettings);
            }
        }

        public override void ExposeData()
        {
            base.ExposeData();
            Scribe_Deep.Look(ref this.innerContainer, "innerContainer",  this);    
            Scribe_Deep.Look(ref this.storageSettings, "storageSettings", this);
        }

        public void GetChildHolders(List<IThingHolder> outChildren)
        {
            ThingOwnerUtility.AppendThingHoldersFromThings(outChildren, this.GetDirectlyHeldThings());
        }

        public ThingOwner GetDirectlyHeldThings()
        {
            return this.innerContainer;
        }

        public StorageSettings GetParentStoreSettings()
        {
            return this.def.building.fixedStorageSettings;
        }

        public StorageSettings GetStoreSettings()
        {
            return this.storageSettings;
        }

        public bool TryDrop(Thing item, bool forbid = true)
        {
            if (this.innerContainer.Contains(item))
            {
                Thing outThing;
                this.innerContainer.TryDrop(item, ThingPlaceMode.Near, out outThing);
                if (forbid) outThing.SetForbidden(true);
                return true;
            }
            return false;
        }
    }
}
