﻿using RimWorld;
using System.Collections.Generic;
using System.Linq;
using UnityEngine;
using Verse;

namespace MedTimes
{
    class Building_RefuelHopper : Building_Storage
    {
        private const int CompRefuelTicks = 6;
        private int CompTicks = 0;
        IntVec3 CachedCell;

        public override void SpawnSetup(Map map, bool respawningAfterLoad)
        {
            base.SpawnSetup(map, respawningAfterLoad);

            CachedCell = Position + Rotation.FacingCell;
        }

        public override void ExposeData()
        {
            base.ExposeData();

            Scribe_Values.Look(ref CompTicks, "RefuelTicks", defaultValue: 0);
        }

        public override void TickLong()
        {                     
            ++CompTicks;
            //Messages.Message(CompTicks + " " + CachedCell.ToString() + " " + Position.ToString(), MessageTypeDefOf.NeutralEvent);
            if (CompTicks >= CompRefuelTicks)
            {
                CompTicks %= CompRefuelTicks;
                TryRefuelThing();
            }    
        }

        public override void TickRare()
        {                     
            ++CompTicks;
            //Messages.Message(CompTicks + " " + CachedCell.ToString() + " " + Position.ToString(), MessageTypeDefOf.NeutralEvent);
            if (CompTicks >= CompRefuelTicks)
            {
                CompTicks %= CompRefuelTicks;
                TryRefuelThing();
            }
        }

        public override void Tick()
        {                 
            ++CompTicks;
            //Messages.Message(CompTicks + " " + CachedCell.ToString() + " " + Position.ToString(), MessageTypeDefOf.NeutralEvent);
            if (CompTicks >= CompRefuelTicks)
            {
                CompTicks %= CompRefuelTicks;
                TryRefuelThing();
            }
        }

        private void TryRefuelThing()
        {
            var fuelThings = slotGroup.HeldThings;
            if (fuelThings.Count() == 0) return;
            var refuelThing = fuelThings.First();
                                        
            List<Thing> refueledThings = this.Map.thingGrid.ThingsListAt(CachedCell);

            CompRefuelable refueledComp = null;

            foreach (var thing in refueledThings)
                if(thing is ThingWithComps compThing)
                {
                    refueledComp = compThing.TryGetComp<CompRefuelable>();

                    if (refueledComp != null && refueledComp.Props.fuelFilter.Allows(refuelThing)) break;
                }


            if (refueledComp != null)
            {
                int num = refueledComp.GetFuelCountToFullyRefuel();

                int num2 = Mathf.Min(num, refuelThing.stackCount);
                refueledComp.Refuel(num2);
                refuelThing.SplitOff(num2).Destroy();
                num -= num2;                         
            }
        }
    }
}
