﻿using RimWorld;
using Verse;
using Verse.Sound;

namespace MedTimes
{
    class CompCeilingHanger : ThingComp
    {                                                                                                   
        public override void CompTick()
        {
            base.CompTick();

            Tick();
        }

        public override void CompTickRare()
        {
            base.CompTickRare();
            TickRare();
        }             

        private void Tick()
        {
            if (Find.TickManager.TicksGame % 150 == 0)
            {
                TestDrop();
            }
        }

        private void TickRare()
        {                
            TestDrop();
        }                    

        private void TestDrop()
        {
            foreach (IntVec3 current in parent.OccupiedRect())
            {
                if (!parent.Map.roofGrid.Roofed(current))
                {
                    DropMinify();
                    return;
                }
            }
        }

        public void DropMinify()
        {                                       
            MinifiedThing package = parent.MakeMinified();
            GenPlace.TryPlaceThing(package, parent.Position, parent.Map, ThingPlaceMode.Near);        
            MoteMaker.ThrowDustPuff(parent.Position.ToVector3Shifted() + Gen.RandomHorizontalVector(0.6f), parent.Map, 2f);
            SoundDefOf.Roof_Collapse.PlayOneShot(new TargetInfo(parent.Position, parent.Map));
        }
    }
}
