﻿using RimWorld;
using System;
using System.Collections.Generic;
using System.Linq;
using Verse;
using Verse.Sound;

namespace MedTimes
{
    class CompRefrigerator : ThingComp
    {
        private List<IntVec3> cachedOccupiedCells;

        private Dictionary<IntVec3, float> cachedOccupiedRotInt;

        private CompRefuelable compFuel;

        public CompRefrigerator()
        {
            cachedOccupiedRotInt = new Dictionary<IntVec3, float>();
        }

        public override void PostExposeData()
        {
            base.PostExposeData();   
            Scribe_Collections.Look(ref cachedOccupiedRotInt, "cachedOccupiedRotInt", LookMode.Value, LookMode.Value);
        }

        public override void PostSpawnSetup(bool respawningAfterLoad)
        {
            base.PostSpawnSetup(respawningAfterLoad);

            compFuel = parent.TryGetComp<CompRefuelable>();
        }

        public override void CompTick()
        {
            base.CompTick();  
            
            if(Find.TickManager.TicksGame % 128 == 0 && (compFuel == null || compFuel.HasFuel))
            {
                RefrigeratorTick();
            }
        }

        private void RefrigeratorTick()
        {                  
            foreach(IntVec3 cell in AllSlotCells())
            {
                Thing cellThing = null;
                List<Thing> thingList = parent.Map.thingGrid.ThingsListAt(cell);
                for (int i = 0; i < thingList.Count; i++)
                {
                    if (thingList[i].def.EverStorable(willMinifyIfPossible: false))
                    {
                        cellThing = thingList[i];
                        break;
                    }
                }

                if(cellThing != null && cellThing.TryGetComp<CompRottable>() is CompRottable rotPercent)
                {
                    if (cachedOccupiedRotInt.ContainsKey(cell))
                    {
                        rotPercent.RotProgress = cachedOccupiedRotInt[cell];
                    }
                    else
                    {    
                        cachedOccupiedRotInt.Add(cell, rotPercent.RotProgress);
                    }                                  
                }
                else
                {
                    if (cachedOccupiedRotInt.ContainsKey(cell))
                    {
                        cachedOccupiedRotInt.Remove(cell);
                    }
                }  
            }
        }

        public virtual IEnumerable<IntVec3> AllSlotCells()
        {
            foreach (IntVec3 item in GenAdj.CellsOccupiedBy(parent))
            {
                yield return item;
            }
        }

        public List<IntVec3> AllSlotCellsList()
        {
            if (cachedOccupiedCells == null)
            {
                cachedOccupiedCells = AllSlotCells().ToList();
            }
            return cachedOccupiedCells;
        }
    }
}
