﻿using RimWorld;
using UnityEngine;
using Verse;

namespace MedTimes
{
    public class CompProperties_FireOverlayFlickable : CompProperties_FireOverlay
    {
        public CompProperties_FireOverlayFlickable()
        {
            compClass = typeof(FireOverlayFlickable);
        }

        public override void DrawGhost(IntVec3 center, Rot4 rot, ThingDef thingDef, Color ghostCol, AltitudeLayer drawAltitude, Thing thing = null)
        {  
            Graphic graphic = GhostUtility.GhostGraphicFor(FireOverlayFlickable.FireGraphic, thingDef, ghostCol);
            graphic.DrawFromDef(center.ToVector3ShiftedWithAltitude(drawAltitude), rot, thingDef);
        }     
    }
}
