﻿using System.Collections.Generic;
using System.Linq;
using RimWorld;
using UnityEngine;
using Verse;

namespace MedTimes
{               
    public class Designator_RearmTrap : Designator
    {                                    
        public override int DraggableDimensions => 2;
        public override bool DragDrawMeasurements => false;

        protected override DesignationDef Designation => ResourceBank.DesignationDefOf.Designtaion_RearmTrap;

        public Designator_RearmTrap()
        {
            defaultLabel = ResourceBank.Strings.CommandRearmTrap.Translate();
            defaultDesc = ResourceBank.Strings.CommandRearmTrapDesc.Translate();
            icon = TexCommand.RearmTrap;
            soundDragSustain = SoundDefOf.Designate_DragStandard;
            soundDragChanged = SoundDefOf.Designate_DragStandard_Changed;
            useMouseIcon = true;
            soundSucceeded = SoundDefOf.Designate_Hunt;
        }           

        public override AcceptanceReport CanDesignateCell(IntVec3 c)
        {
            if (!c.InBounds(base.Map))
            {
                return false;
            }
            if (RearmablesInCell(c).Any())
            {
                return true;
            }
            return ResourceBank.Strings.MustDesignateRearmable.Translate();     
        }

        public override AcceptanceReport CanDesignateThing(Thing t)
        {
            if (t is Building_TrapRearmable thing && !thing.Armed && thing.Faction == Faction.OfPlayer && base.Map.designationManager.DesignationOn(thing, Designation) == null)
            {
                return true;
            }
            return false;
        }

        private IEnumerable<Building_TrapRearmable> RearmablesInCell(IntVec3 c)
        {
            if (c.Fogged(base.Map))
            {
                yield break;
            }
            List<Thing> thingList = c.GetThingList(base.Map);
            for (int i = 0; i < thingList.Count; i++)
            {
                if (CanDesignateThing(thingList[i]).Accepted)
                {
                    yield return (Building_TrapRearmable)thingList[i];
                }
            }
        }

        public override void DesignateSingleCell(IntVec3 c)
        {
            foreach (var trap in RearmablesInCell(c))
            {
                DesignateThing(trap);
            }
        }

        public override void DesignateThing(Thing t)
        {
            if (DebugSettings.godMode && t is Building_TrapRearmable trap)
            {
                trap.Armed = true;
            }
            else
            {
                base.Map.designationManager.AddDesignation(new Designation(t, Designation));
            }
        }
    }
}
