﻿using System.Collections.Generic;
using Verse;
using Verse.AI;

namespace MedTimes
{
    class JobDriver_FillCheesePress : JobDriver
    {
        private const TargetIndex BarrelInd = TargetIndex.A;

        private const TargetIndex WortInd = TargetIndex.B;

        private const int Duration = 200;

        protected Building_CheesePress CheesePress => (Building_CheesePress)job.GetTarget(TargetIndex.A).Thing;

        protected Thing Wort => job.GetTarget(TargetIndex.B).Thing;

        public override bool TryMakePreToilReservations(bool errorOnFailed)
        {
            Pawn pawn = base.pawn;
            LocalTargetInfo target = CheesePress;
            Job job = base.job;
            bool errorOnFailed2 = errorOnFailed;
            int result;
            if (pawn.Reserve(target, job, 1, -1, null, errorOnFailed2))
            {
                pawn = base.pawn;
                target = Wort;
                job = base.job;
                errorOnFailed2 = errorOnFailed;
                result = (pawn.Reserve(target, job, 1, -1, null, errorOnFailed2) ? 1 : 0);
            }
            else
            {
                result = 0;
            }
            return (byte)result != 0;
        }

        protected override IEnumerable<Toil> MakeNewToils()
        {
            this.FailOnDespawnedNullOrForbidden(TargetIndex.A);
            this.FailOnBurningImmobile(TargetIndex.A);
            AddEndCondition(() => (CheesePress.SpaceLeftForMilk > 0) ? JobCondition.Ongoing : JobCondition.Succeeded);
            yield return Toils_General.DoAtomic(delegate
            {
                job.count = CheesePress.SpaceLeftForMilk;
            });
            Toil reserveWort = Toils_Reserve.Reserve(TargetIndex.B);
            yield return reserveWort;
            yield return Toils_Goto.GotoThing(TargetIndex.B, PathEndMode.ClosestTouch).FailOnDespawnedNullOrForbidden(TargetIndex.B).FailOnSomeonePhysicallyInteracting(TargetIndex.B);
            yield return Toils_Haul.StartCarryThing(TargetIndex.B, putRemainderInQueue: false, subtractNumTakenFromJobCount: true).FailOnDestroyedNullOrForbidden(TargetIndex.B);
            yield return Toils_Haul.CheckForGetOpportunityDuplicate(reserveWort, TargetIndex.B, TargetIndex.None, takeFromValidStorage: true);
            yield return Toils_Goto.GotoThing(TargetIndex.A, PathEndMode.Touch);
            yield return Toils_General.Wait(200).FailOnDestroyedNullOrForbidden(TargetIndex.B).FailOnDestroyedNullOrForbidden(TargetIndex.A)
                .FailOnCannotTouch(TargetIndex.A, PathEndMode.Touch)
                .WithProgressBarToilDelay(TargetIndex.A);
            yield return new Toil
            {
                initAction = delegate
                {
                    CheesePress.AddMilk(Wort);
                },
                defaultCompleteMode = ToilCompleteMode.Instant
            };
        }
    }
}
