﻿using RimWorld;
using System;
using System.Collections.Generic;
using UnityEngine;
using Verse;
using Verse.AI;
using Verse.Sound;

namespace MedTimes
{
    class JobDriver_ReadSkillBook : IJobDriver_Read
    {                                               
        protected SkillDef GetBookSkill()
        {
            return ReadItem.def.GetCompProperties<CompProperties_Book>().Skill;
        }

        protected override Toil GetReadToil(int duration)
        {
            Toil readToil = new Toil();
            SkillDef skill = GetBookSkill();
            readToil.defaultDuration = duration;
            readToil.defaultCompleteMode = ToilCompleteMode.Delay;
            readToil.handlingFacing = true;
            readToil.initAction = delegate
            {     
                if (pawn.CurJob.GetTarget(ReadSurfaceIndex).IsValid)
                    this.pawn.rotationTracker.FaceCell(pawn.CurJob.GetTarget(ReadSurfaceIndex).Cell);

                ResourceBank.SoundDefOf.BookPageFlips.PlayOneShot(new TargetInfo(this.pawn.Position, this.pawn.Map));
            };
            readToil.tickAction = delegate
            {
                this.pawn.GainComfortFromCellIfPossible();

                ReadTick(pawn, ReadItem, skill, 1f, JoyTickFullJoyAction.GoToNextToil);
            };

            readToil.AddFinishAction(delegate
            {
                JoyUtility.TryGainRecRoomThought(pawn);
            });

            return readToil;
        }   
    }
}
